#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include "../../src/util/gui.h"
#include "../../src/util/memory.h"
#include "../../src/util/error.h"


int main(int argc, char **argv)
{
	error_init(argv[0]);
	
	gui_Type *g = gui_new("gui test", 400, 300);
	
	gui_DisplayDimensions dd;
	gui_getDisplayDimensions(g, &dd);
	printf("Display dimensions: %dx%d pixels, %dx%d mm\n",
		dd.widthPixels, dd.heightPixels,
		dd.widthMillimiters, dd.heightMillimiters);
	printf("Display resolution: %dx%d dpi\n",
		(int)(25.4 * dd.widthPixels / dd.widthMillimiters + 0.5),
		(int)(25.4 * dd.heightPixels / dd.heightMillimiters + 0.5));
	
	int pen = gui_getColorIndexString(g, "red");
	gui_Event e;
	int quit = 0;
	while( ! quit ){
		gui_drawLine(g, 1, 2, 2, 1, pen);
		gui_drawLine(g, 4, 2, 3, 3, pen);
		e.code = 1111;
		if( gui_getEvent(g, &e) ){
			switch(e.code){
				
			case gui_EVENT_KEYDOWN:
				printf("Key: %d\n", e.key);
				break;
				
			case gui_EVENT_LBUTTONDOWN:
				printf("drawing cross at %d,%d\n", e.x, e.y);
				gui_drawLine(g, e.x - 10, e.y, e.x + 10, e.y, pen);
				gui_drawLine(g, e.x, e.y - 10, e.x, e.y + 10, pen);
				break;
				
			case gui_EVENT_WINDOW_FOCUS_IN:
				printf("focus in\n");
				break;
				
			case gui_EVENT_WINDOW_FOCUS_OUT:
				printf("focus out\n");
				break;
				
			case gui_EVENT_WINDOW_CLOSE:
				quit = 1;
				break;
				
			default:
				break;
				
			}
		} else {
			if( gui_isVisible(g) )
				printf("is visible\n");
			else
				printf("is not visible\n");
			sleep(1);
		}
	}
	memory_dispose(g);
	return 0;
}
