    /*
     * Some or all of this work - Copyright (c) 2006 - 2021, Intel Corp.
     * All rights reserved.
     *
     * Redistribution and use in source and binary forms, with or without modification,
     * are permitted provided that the following conditions are met:
     *
     * Redistributions of source code must retain the above copyright notice,
     * this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright notice,
     * this list of conditions and the following disclaimer in the documentation
     * and/or other materials provided with the distribution.
     * Neither the name of Intel Corporation nor the names of its contributors
     * may be used to endorse or promote products derived from this software
     * without specific prior written permission.
     *
     * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
     * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
     * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
     * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
     * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
     * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
     * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
     * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */
    /*
     * Resource Descriptor macros
     *
     * Long Vendor Resource Descriptor
     */
    Name (P410, Package (0x07)
    {
        ResourceTemplate ()
        {
            VendorLong  ()      // Length = 0x11
            {
                /* 0000 */  0x8F, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6,  // ........
                /* 0008 */  0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE,  // ........
                /* 0010 */  0xFF                                             // .
            }
        },

        ResourceTemplate ()
        {
            VendorLong  ()      // Length = 0x15
            {
                /* 0000 */  0x9F, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6,  // ........
                /* 0008 */  0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE,  // ........
                /* 0010 */  0xFF, 0x00, 0x01, 0x02, 0x03                     // .....
            }
        },

        ResourceTemplate ()
        {
            VendorLong  ()      // Length = 0x112
            {
                /* 0000 */  0xAF, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6,  // ........
                /* 0008 */  0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE,  // ........
                /* 0010 */  0xFF, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,  // ........
                /* 0018 */  0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,  // ........
                /* 0020 */  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,  // ........
                /* 0028 */  0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,  // ........
                /* 0030 */  0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,  //  !"#$%&'
                /* 0038 */  0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,  // ()*+,-./
                /* 0040 */  0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,  // 01234567
                /* 0048 */  0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,  // 89:;<=>?
                /* 0050 */  0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,  // @ABCDEFG
                /* 0058 */  0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,  // HIJKLMNO
                /* 0060 */  0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,  // PQRSTUVW
                /* 0068 */  0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,  // XYZ[\]^_
                /* 0070 */  0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,  // `abcdefg
                /* 0078 */  0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,  // hijklmno
                /* 0080 */  0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,  // pqrstuvw
                /* 0088 */  0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,  // xyz{|}~.
                /* 0090 */  0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,  // ........
                /* 0098 */  0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,  // ........
                /* 00A0 */  0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,  // ........
                /* 00A8 */  0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,  // ........
                /* 00B0 */  0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,  // ........
                /* 00B8 */  0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,  // ........
                /* 00C0 */  0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,  // ........
                /* 00C8 */  0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,  // ........
                /* 00D0 */  0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,  // ........
                /* 00D8 */  0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,  // ........
                /* 00E0 */  0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,  // ........
                /* 00E8 */  0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,  // ........
                /* 00F0 */  0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,  // ........
                /* 00F8 */  0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,  // ........
                /* 0100 */  0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,  // ........
                /* 0108 */  0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF,  // ........
                /* 0110 */  0x00, 0x01                                       // ..
            }
        },

        ResourceTemplate ()
        {
            VendorLong  ()      // Length = 0x00
            {
            }
        },

        ResourceTemplate ()
        {
            VendorLong  ()      // Length = 0x01
            {
                 0xBF                                             // .
            }
        },

        ResourceTemplate ()
        {
            VendorLong  ()      // Length = 0x02
            {
                 0xCF, 0xF0                                       // ..
            }
        },

        ResourceTemplate ()
        {
            VendorLong  ()      // Length = 0x10
            {
                /* 0000 */  0xDF, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6,  // ........
                /* 0008 */  0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE   // ........
            }
        }
    })
    /*
     ACPI Specification, Revision 3.0, September 2, 2004
     6.4.3.2   Vendor-Defined Descriptor
     Large Vendor-Defined Descriptor layout:
     Byte 0 (Tag Bits): Value = 10000100B (0X84) (Type = 1, Large item name = 0x4)
     Byte 1 (Length, bits[7:0]): Lower eight bits of data length (UUIID & vendor defined data)
     Byte 2 (Length, bits[15:8]): Upper eight bits of data length (UUID & vendor defined data)
     Byte 3 (UUID specific descriptor sub type): UUID specific descriptor sub type value
     Byte 4-19 (UUID): UUID Value
     Byte 20-(Length+2) (Vendor Defined Data): Vendor defined data bytes
     */
    Name (P411, Package (0x07)
    {
        ResourceTemplate ()
        {
            VendorLong  ()      // Length = 0x11
            {
                /* 0000 */  0x8F, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6,  // ........
                /* 0008 */  0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE,  // ........
                /* 0010 */  0xFF                                             // .
            }
        },

        ResourceTemplate ()
        {
            VendorLong  ()      // Length = 0x15
            {
                /* 0000 */  0x9F, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6,  // ........
                /* 0008 */  0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE,  // ........
                /* 0010 */  0xFF, 0x00, 0x01, 0x02, 0x03                     // .....
            }
        },

        ResourceTemplate ()
        {
            VendorLong  ()      // Length = 0x112
            {
                /* 0000 */  0xAF, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6,  // ........
                /* 0008 */  0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE,  // ........
                /* 0010 */  0xFF, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,  // ........
                /* 0018 */  0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,  // ........
                /* 0020 */  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,  // ........
                /* 0028 */  0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,  // ........
                /* 0030 */  0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,  //  !"#$%&'
                /* 0038 */  0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,  // ()*+,-./
                /* 0040 */  0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,  // 01234567
                /* 0048 */  0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,  // 89:;<=>?
                /* 0050 */  0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,  // @ABCDEFG
                /* 0058 */  0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,  // HIJKLMNO
                /* 0060 */  0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,  // PQRSTUVW
                /* 0068 */  0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,  // XYZ[\]^_
                /* 0070 */  0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,  // `abcdefg
                /* 0078 */  0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,  // hijklmno
                /* 0080 */  0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,  // pqrstuvw
                /* 0088 */  0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,  // xyz{|}~.
                /* 0090 */  0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,  // ........
                /* 0098 */  0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,  // ........
                /* 00A0 */  0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,  // ........
                /* 00A8 */  0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,  // ........
                /* 00B0 */  0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,  // ........
                /* 00B8 */  0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,  // ........
                /* 00C0 */  0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,  // ........
                /* 00C8 */  0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,  // ........
                /* 00D0 */  0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,  // ........
                /* 00D8 */  0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,  // ........
                /* 00E0 */  0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,  // ........
                /* 00E8 */  0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,  // ........
                /* 00F0 */  0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,  // ........
                /* 00F8 */  0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,  // ........
                /* 0100 */  0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,  // ........
                /* 0108 */  0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF,  // ........
                /* 0110 */  0x00, 0x01                                       // ..
            }
        },

        ResourceTemplate ()
        {
            VendorLong  ()      // Length = 0x00
            {
            }
        },

        ResourceTemplate ()
        {
            VendorLong  ()      // Length = 0x01
            {
                 0xBF                                             // .
            }
        },

        ResourceTemplate ()
        {
            VendorLong  ()      // Length = 0x02
            {
                 0xCF, 0xF0                                       // ..
            }
        },

        ResourceTemplate ()
        {
            VendorLong  ()      // Length = 0x10
            {
                /* 0000 */  0xDF, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6,  // ........
                /* 0008 */  0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE   // ........
            }
        }
    })
    Method (RT09, 0, Serialized)
    {
        /* Emit test header, set the filename */

        THDR (__METHOD__, "Long Vendor Resource Descriptor Macro", "vendorlong.asl")
        /* Main test case for packages above */

        M330 (__METHOD__, 0x07, "p410", P410, P411)
        /* VendorLong has DescriptorName */
        /* but has not fields in it. */
        Local0 = ResourceTemplate ()
            {
                VendorLong  ()      // Length = 0x11
                {
                    /* 0000 */  0x8F, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6,  // ........
                    /* 0008 */  0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE,  // ........
                    /* 0010 */  0xFF                                             // .
                }
            }
    }
