#!/usr/bin/perl
# SPDX-License-Identifier: GPL-2.0-or-later

use strict;
use warnings;
use File::Basename;

if (@ARGV != 1) {
	die "Usage: $0 <JEP106 PDF document>\n\n"
	. "Convert the JEDEC document containing manufacturer identification codes\n"
	. "to an array initializer suitable for inclusion into jep106.c. The latest\n"
	. "version of the document can be found here:\n"
	. "http://www.jedec.org/standards-documents/results/jep106\n";
};

my $outfile = dirname($0) . "/jep106.inc";

open(my $out, ">", $outfile) || die "Cannot open $outfile: $!\n";
open(my $pdftotext, "pdftotext -layout $ARGV[0] - |") || die "Cannot fork: $!\n";

print $out "/* Autogenerated with " . basename($0) . "*/\n";

my $bank = -1;

while (<$pdftotext>) {
	if (/^[0-9]+[[:space:]]+(.*?)[[:space:]]+([01][[:space:]]+){8}([0-9A-F]{2})$/) {
		if ($3 eq "01") {
			$bank++
		}
		my $id=sprintf("0x%02x",hex($3)&0x7f);
		print $out "[$bank][$id - 1] = \"$1\",\n";
	}
}

close $pdftotext || die "Error: $! $?\n";

print $out "/* EOF */\n";
