% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round5.R
\name{round5}
\alias{round5}
\title{Rounding of Numbers}
\usage{
round5(x, digits = 0)
}
\arguments{
\item{x}{(\code{numeric})\cr
a numeric vector}

\item{digits}{(\code{integer})\cr
integer indicating the number of decimal places}
}
\value{
a numeric vector
}
\description{
Rounds the values in its first argument to the specified number of
decimal places (default 0). Importantly, \code{round5()} \strong{does not} use Base R's
"round to even" default. Standard rounding methods are implemented, for example,
\code{cards::round5(0.5) = 1}, whereas \code{base::round(0.5) = 0}.
}
\details{
Function inspired by \code{janitor::round_half_up()}.
}
\examples{
x <- 0:4 / 2
round5(x) |> setNames(x)

# compare results to Base R
round(x) |> setNames(x)
}
