% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkVector.R
\name{checkVector}
\alias{checkVector}
\alias{check_vector}
\alias{assertVector}
\alias{assert_vector}
\alias{testVector}
\alias{test_vector}
\title{Check if an argument is a vector}
\usage{
checkVector(
  x,
  strict = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  names = NULL,
  null.ok = FALSE
)

check_vector(
  x,
  strict = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  names = NULL,
  null.ok = FALSE
)

assertVector(
  x,
  strict = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  names = NULL,
  null.ok = FALSE,
  .var.name = vname(x),
  add = NULL
)

assert_vector(
  x,
  strict = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  names = NULL,
  null.ok = FALSE,
  .var.name = vname(x),
  add = NULL
)

testVector(
  x,
  strict = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  names = NULL,
  null.ok = FALSE
)

test_vector(
  x,
  strict = FALSE,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  names = NULL,
  null.ok = FALSE
)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{strict}{[\code{logical(1)}]\cr
May the vector have additional attributes? If \code{TRUE}, mimics the behavior of
\code{\link[base]{is.vector}}.
Default is \code{FALSE} which allows e.g. \code{factor}s or \code{data.frame}s
to be recognized as vectors.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with no non-missing values allowed? Default is \code{TRUE}.
Note that empty vectors do not have non-missing values.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{names}{[\code{character(1)}]\cr
Check for names. See \code{\link{checkNamed}} for possible values.
Default is \dQuote{any} which performs no check at all.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertVector}/\code{assert_vector} return 
 \code{x} invisibly, whereas
 \code{checkVector}/\code{check_vector} and 
 \code{testVector}/\code{test_vector} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertVector}/\code{assert_vector}
 throws an error message, 
 \code{testVector}/\code{test_vector}
 returns \code{FALSE},
 and \code{checkVector}/\code{check_vector} 
 return a string with the error message.
 The function \code{expect_vector} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a vector
}
\examples{
testVector(letters, min.len = 1L, any.missing = FALSE)
}
\seealso{
Other basetypes: 
\code{\link{checkArray}()},
\code{\link{checkAtomic}()},
\code{\link{checkAtomicVector}()},
\code{\link{checkCharacter}()},
\code{\link{checkComplex}()},
\code{\link{checkDataFrame}()},
\code{\link{checkDate}()},
\code{\link{checkDouble}()},
\code{\link{checkEnvironment}()},
\code{\link{checkFactor}()},
\code{\link{checkFormula}()},
\code{\link{checkFunction}()},
\code{\link{checkInteger}()},
\code{\link{checkIntegerish}()},
\code{\link{checkList}()},
\code{\link{checkLogical}()},
\code{\link{checkMatrix}()},
\code{\link{checkNull}()},
\code{\link{checkNumeric}()},
\code{\link{checkPOSIXct}()},
\code{\link{checkRaw}()}

Other atomicvector: 
\code{\link{checkAtomic}()},
\code{\link{checkAtomicVector}()}
}
\concept{atomicvector}
\concept{basetypes}
