% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots.R
\name{dyn-dots}
\alias{dyn-dots}
\alias{tidy-dots}
\alias{doc_dots_dynamic}
\alias{:=}
\title{Dynamic dots features}
\description{
The base \code{...} syntax supports:
\itemize{
\item \strong{Forwarding} arguments from function to function, matching them
along the way to arguments.
\item \strong{Collecting} arguments inside data structures, e.g. with \code{\link[=c]{c()}} or
\code{\link[=list]{list()}}.
}

Dynamic dots offer a few additional features,
\link[=topic-inject]{injection} in particular:
\enumerate{
\item You can \strong{splice} arguments saved in a list with the splice
operator \code{\link[=splice-operator]{!!!}}.
\item You can \strong{inject} names with \link[=glue-operators]{glue syntax} on
the left-hand side of \verb{:=}.
\item Trailing commas are ignored, making it easier to copy and paste
lines of arguments.
}
}
\section{Add dynamic dots support in your functions}{


If your function takes dots, adding support for dynamic features is
as easy as collecting the dots with \code{\link[=list2]{list2()}} instead of \code{\link[=list]{list()}}.
See also \code{\link[=dots_list]{dots_list()}}, which offers more control over the collection.

In general, passing \code{...} to a function that supports dynamic dots
causes your function to inherit the dynamic behaviour.

In packages, document dynamic dots with this standard tag:

\if{html}{\out{<div class="sourceCode">}}\preformatted{ @param ... <[`dynamic-dots`][rlang::dyn-dots]> What these dots do.
}\if{html}{\out{</div>}}
}

\examples{
f <- function(...) {
  out <- list2(...)
  rev(out)
}

# Trailing commas are ignored
f(this = "that", )

# Splice lists of arguments with `!!!`
x <- list(alpha = "first", omega = "last")
f(!!!x)

# Inject a name using glue syntax
if (is_installed("glue")) {
  nm <- "key"
  f("{nm}" := "value")
  f("prefix_{nm}" := "value")
}
}
