# Installation instructions for Frescobaldi


## Using a pre-built package

Each release comes with installers for Windows and macOS.  These are available
from

https://github.com/frescobaldi/frescobaldi/releases/

This is the simplest way of installing Frescobaldi under Windows or macOS.

Under Linux, your distribution probably provides a `frescobaldi` package.  If
so, installing it is the easiest route, even though it might be out of date.
Run `sudo apt install frescobaldi` on Debian/Ubuntu or `sudo dnf install
frescobaldi` on Fedora.

You can also install Frescobaldi from Flathub using Flatpak to get a more
up-to-date application.

https://flathub.org/apps/org.frescobaldi.Frescobaldi

If you previously installed Frescobaldi via your distribution, remember to
remove it before installing it through Flatpak. Otherwise, they will coexist on
your computer; while this is not a problem per se, you could get the old
Frescobaldi version when you launch Frescobaldi graphically.



## Developing Frescobaldi

If you would like to help with the development of Frescobaldi, a Linux platform
is recommended. You will need install it from source in editable
mode. Frescobaldi is closely tied to two companion modules, python-ly and
qpageview; you might want to modify these too, so it is recommended to install
them from source as well.

### Uninstalling other versions

While not required, it is a good idea to save yourself confusion in the future
by uninstalling other versions of Frescobaldi. For example, `sudo apt remove
frescobaldi` if you installed via the system package on Debian/Ubuntu, `sudo dnf
remove frescobaldi` on Fedora, or `flatpak remove org.frescobaldi.Frescobaldi`
if you installed it via Flatpak, or `pip uninstall frescobaldi python-ly
qpageview` if you used pip, or `pipx uninstall frescobaldi` if you used pipx.

### Getting basic requirements

Frescobaldi is written in Python 3, so you will need a Python interpreter.  Most
Linux distributions come with Python 3 preinstalled.  Make sure that `python
--version` works.

You will also need a few packages from your operating system:

* [pipx](https://pypa.github.io/pipx), for the installation process,
* [tox](https://tox.wiki), for orchestrating the build of autogenerated files,
* Git, the version control software used for Frescobaldi's source code,
* PyQt6, the library Frescobaldi uses for its graphical interface,
* GNU Gettext, a suite of tools for working with translations, for generating
  compiled MO catalogs.

On Debian/Ubuntu, these packages can be installed using:

```
sudo apt install pipx tox git python3-pyqt6 python3-pyqt6.qtpdf python3-pyqt6.qtsvg python3-pyqt6.qtwebengine gettext
```

On Fedora:

```
sudo dnf install pipx tox git python3-pyqt6 python3-pyqt6-webengine gettext
```

### Getting the source code

Create a directory where you will store the Frescobaldi sources and
`cd` into it.  For example:

```
mkdir frescobaldi-repositories
cd frescobaldi-repositories
```

Next, clone the repository:

```
git clone https://github.com/frescobaldi/frescobaldi.git
```

### Creating autogenerated files

The following commands generate `.mo` files for translations, and a desktop
file.

```
cd frescobaldi
tox -e mo-generate
tox -e linux-generate
cd ..
```

### Installing Frescobaldi

Install from source with `pipx`:

```
pipx install --system-site-packages --editable ./frescobaldi
```

The `--system-site-packages` option is required. It ensures that Frescobaldi can
use PyQt6 from the system.

The `--editable` option makes sure that your changes to the source code will be
reflected.

After this command, you should be able to run Frescobaldi from source by running
`frescobaldi`.

### Installing the desktop file

The desktop file is what enabled you to run Frescobaldi as a normal application,
by clicking on an icon, instead of running Frescobaldi in a terminal. Install it
using

```
cd frescobaldi
desktop-file-install --dir ~/.local/share/applications/ --set-icon $PWD/frescobaldi/icons/org.frescobaldi.Frescobaldi.svg  linux/org.frescobaldi.Frescobaldi.desktop
update-desktop-database ~/.local/share/
cd ..
```

After waiting a few seconds, you should find a Frescobaldi application on your
system.

### Optional: installing python-ly and qpageview as editable

You now have a copy of Frescobaldi's source code that you can edit and launch
easily. However, Frescobaldi relies on two companion modules, python-ly and
qpageview, which you may want to develop as well. If you want to be able to
develop them, clone their sources:

```
git clone https://github.com/frescobaldi/python-ly.git
git clone https://github.com/frescobaldi/qpageview.git
```

then "inject" them into the already installed application so that they replace
the automatically downloaded copies of python-ly and qpageview:

```
pipx inject --editable frescobaldi ./python-ly ./qpageview
```

### Optional: additional features

Finally, you may want to install some optional modules that are needed
for certain features.

* For MIDI the PortMidi library is used, either via importing 'pypm',
  'pyportmidi._pyportmidi', or, if that is not available, loading the
  pygame.pypm module from pygame; or, as a last resort, embedding the PortMidi
  C-library via ctypes. For example, under Debian/Ubuntu, `sudo apt install
  python3-pygame`, and on Fedora, `sudo dnf install python3-pygame`.

* If you want to print PDFs to a local CUPS server, also install `pycups` using
  `pipx inject frescobaldi pycups`.


## For Linux distribution packagers

See above for the dependencies that need to be installed.

Frescobaldi contains some files by default which are also available in other
packages often used in Linux distributions. It is possible to remove those
files after installing/packaging and make Frescobaldi depend on the package
containing those files. This makes the filesystem less cluttered, and copyright
files simpler.

Icons:
You can remove the frescobaldi/icons/Tango directory, and make Frescobaldi
depend on the tango-icon-theme package instead.

Hyphenation dictionaries:
You can remove the hyph_*.dic files from frescobaldi/hyphdicts, and make
Frescobaldi depend on a package that installs hyphenation dictionaries in
/usr/share/hyphen/ (or another dictionary listed by default in frescobaldi/
hyphendialog.py). Do not remove the hyphdicts directory entirely.
