/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.rm;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.IPropertyValueTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.rm.RMObject;
import org.jkiss.dbeaver.model.rm.RMProjectType;
import org.jkiss.dbeaver.model.rm.RMResourceType;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class RMProject
extends RMObject {
    private static final RMProjectType[] SHARED_PROJECTS = new RMProjectType[]{RMProjectType.GLOBAL, RMProjectType.SHARED};
    private String id;
    private String description;
    private RMProjectType type;
    private Long createTime;
    private String creator;
    private String[] projectPermissions;
    private RMResourceType[] resourceTypes;

    public RMProject() {
    }

    public RMProject(String id, String name, String description, RMProjectType type, Long createTime, String creator, String[] projectPermissions) {
        super(name);
        this.id = id;
        this.description = description;
        this.type = type;
        this.createTime = createTime;
        this.creator = creator;
        this.projectPermissions = projectPermissions;
    }

    public RMProject(String name) {
        super(name);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Property(viewable=true, order=1)
    public String getDisplayName() {
        return switch (this.type) {
            case RMProjectType.GLOBAL -> ModelMessages.project_shared_display_name;
            case RMProjectType.USER -> ModelMessages.project_private_display_name;
            default -> this.getName();
        };
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public boolean isShared() {
        return ArrayUtils.contains((Object[])SHARED_PROJECTS, (Object)((Object)this.getType()));
    }

    public boolean isGlobal() {
        return this.getType() == RMProjectType.GLOBAL;
    }

    @Property(viewable=true, order=2)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Property(viewable=true, order=3)
    public RMProjectType getType() {
        return this.type;
    }

    public void setType(RMProjectType type) {
        this.type = type;
    }

    @Property(viewable=true, valueRenderer=TimeRenderer.class, order=10)
    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @Property(viewable=true, order=11)
    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Override
    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RMProject && CommonUtils.equalObjects((Object)this.id, (Object)((RMProject)obj).id) && CommonUtils.equalObjects((Object)this.getName(), (Object)((RMProject)obj).getName()) && CommonUtils.equalObjects((Object)this.description, (Object)((RMProject)obj).description);
    }

    public String[] getProjectPermissions() {
        return this.projectPermissions;
    }

    public boolean hasProjectPermission(String permission) {
        return ArrayUtils.contains((Object[])this.projectPermissions, (Object)permission);
    }

    public void setProjectPermissions(String[] projectPermissions) {
        this.projectPermissions = projectPermissions;
    }

    public RMResourceType[] getResourceTypes() {
        return this.resourceTypes;
    }

    public void setResourceTypes(RMResourceType[] resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    public static class TimeRenderer
    implements IPropertyValueTransformer<RMProject, Object> {
        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Object transform(@NotNull RMProject object, @Nullable Object value) throws IllegalArgumentException {
            void lv;
            if (!(value instanceof Long)) {
                return value;
            }
            Long l = (Long)value;
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(lv.longValue()));
        }
    }
}

