// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package group

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetGroupsOKCode is the HTTP code returned for type GetGroupsOK
const GetGroupsOKCode int = 200

/*
GetGroupsOK Successful operation

swagger:response getGroupsOK
*/
type GetGroupsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.Groups `json:"body,omitempty"`
}

// NewGetGroupsOK creates GetGroupsOK with default headers values
func NewGetGroupsOK() *GetGroupsOK {

	return &GetGroupsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get groups o k response
func (o *GetGroupsOK) WithConfigurationVersion(configurationVersion string) *GetGroupsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get groups o k response
func (o *GetGroupsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get groups o k response
func (o *GetGroupsOK) WithPayload(payload models.Groups) *GetGroupsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get groups o k response
func (o *GetGroupsOK) SetPayload(payload models.Groups) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetGroupsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Groups{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetGroupsDefault General Error

swagger:response getGroupsDefault
*/
type GetGroupsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetGroupsDefault creates GetGroupsDefault with default headers values
func NewGetGroupsDefault(code int) *GetGroupsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetGroupsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get groups default response
func (o *GetGroupsDefault) WithStatusCode(code int) *GetGroupsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get groups default response
func (o *GetGroupsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get groups default response
func (o *GetGroupsDefault) WithConfigurationVersion(configurationVersion string) *GetGroupsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get groups default response
func (o *GetGroupsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get groups default response
func (o *GetGroupsDefault) WithPayload(payload *models.Error) *GetGroupsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get groups default response
func (o *GetGroupsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetGroupsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
