// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package health

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetHealthOKCode is the HTTP code returned for type GetHealthOK
const GetHealthOKCode int = 200

/*
GetHealthOK Success

swagger:response getHealthOK
*/
type GetHealthOK struct {

	/*
	  In: Body
	*/
	Payload *models.Health `json:"body,omitempty"`
}

// NewGetHealthOK creates GetHealthOK with default headers values
func NewGetHealthOK() *GetHealthOK {

	return &GetHealthOK{}
}

// WithPayload adds the payload to the get health o k response
func (o *GetHealthOK) WithPayload(payload *models.Health) *GetHealthOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get health o k response
func (o *GetHealthOK) SetPayload(payload *models.Health) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHealthOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetHealthDefault General Error

swagger:response getHealthDefault
*/
type GetHealthDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHealthDefault creates GetHealthDefault with default headers values
func NewGetHealthDefault(code int) *GetHealthDefault {
	if code <= 0 {
		code = 500
	}

	return &GetHealthDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get health default response
func (o *GetHealthDefault) WithStatusCode(code int) *GetHealthDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get health default response
func (o *GetHealthDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get health default response
func (o *GetHealthDefault) WithConfigurationVersion(configurationVersion string) *GetHealthDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get health default response
func (o *GetHealthDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get health default response
func (o *GetHealthDefault) WithPayload(payload *models.Error) *GetHealthDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get health default response
func (o *GetHealthDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHealthDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
