// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateLogTargetLogForwardCreatedCode is the HTTP code returned for type CreateLogTargetLogForwardCreated
const CreateLogTargetLogForwardCreatedCode int = 201

/*
CreateLogTargetLogForwardCreated Log Target created

swagger:response createLogTargetLogForwardCreated
*/
type CreateLogTargetLogForwardCreated struct {

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewCreateLogTargetLogForwardCreated creates CreateLogTargetLogForwardCreated with default headers values
func NewCreateLogTargetLogForwardCreated() *CreateLogTargetLogForwardCreated {

	return &CreateLogTargetLogForwardCreated{}
}

// WithPayload adds the payload to the create log target log forward created response
func (o *CreateLogTargetLogForwardCreated) WithPayload(payload *models.LogTarget) *CreateLogTargetLogForwardCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target log forward created response
func (o *CreateLogTargetLogForwardCreated) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetLogForwardCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogTargetLogForwardAcceptedCode is the HTTP code returned for type CreateLogTargetLogForwardAccepted
const CreateLogTargetLogForwardAcceptedCode int = 202

/*
CreateLogTargetLogForwardAccepted Configuration change accepted and reload requested

swagger:response createLogTargetLogForwardAccepted
*/
type CreateLogTargetLogForwardAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewCreateLogTargetLogForwardAccepted creates CreateLogTargetLogForwardAccepted with default headers values
func NewCreateLogTargetLogForwardAccepted() *CreateLogTargetLogForwardAccepted {

	return &CreateLogTargetLogForwardAccepted{}
}

// WithReloadID adds the reloadId to the create log target log forward accepted response
func (o *CreateLogTargetLogForwardAccepted) WithReloadID(reloadID string) *CreateLogTargetLogForwardAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create log target log forward accepted response
func (o *CreateLogTargetLogForwardAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create log target log forward accepted response
func (o *CreateLogTargetLogForwardAccepted) WithPayload(payload *models.LogTarget) *CreateLogTargetLogForwardAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target log forward accepted response
func (o *CreateLogTargetLogForwardAccepted) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetLogForwardAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogTargetLogForwardBadRequestCode is the HTTP code returned for type CreateLogTargetLogForwardBadRequest
const CreateLogTargetLogForwardBadRequestCode int = 400

/*
CreateLogTargetLogForwardBadRequest Bad request

swagger:response createLogTargetLogForwardBadRequest
*/
type CreateLogTargetLogForwardBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogTargetLogForwardBadRequest creates CreateLogTargetLogForwardBadRequest with default headers values
func NewCreateLogTargetLogForwardBadRequest() *CreateLogTargetLogForwardBadRequest {

	return &CreateLogTargetLogForwardBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create log target log forward bad request response
func (o *CreateLogTargetLogForwardBadRequest) WithConfigurationVersion(configurationVersion string) *CreateLogTargetLogForwardBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create log target log forward bad request response
func (o *CreateLogTargetLogForwardBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create log target log forward bad request response
func (o *CreateLogTargetLogForwardBadRequest) WithPayload(payload *models.Error) *CreateLogTargetLogForwardBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target log forward bad request response
func (o *CreateLogTargetLogForwardBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetLogForwardBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogTargetLogForwardConflictCode is the HTTP code returned for type CreateLogTargetLogForwardConflict
const CreateLogTargetLogForwardConflictCode int = 409

/*
CreateLogTargetLogForwardConflict The specified resource already exists

swagger:response createLogTargetLogForwardConflict
*/
type CreateLogTargetLogForwardConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogTargetLogForwardConflict creates CreateLogTargetLogForwardConflict with default headers values
func NewCreateLogTargetLogForwardConflict() *CreateLogTargetLogForwardConflict {

	return &CreateLogTargetLogForwardConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create log target log forward conflict response
func (o *CreateLogTargetLogForwardConflict) WithConfigurationVersion(configurationVersion string) *CreateLogTargetLogForwardConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create log target log forward conflict response
func (o *CreateLogTargetLogForwardConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create log target log forward conflict response
func (o *CreateLogTargetLogForwardConflict) WithPayload(payload *models.Error) *CreateLogTargetLogForwardConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target log forward conflict response
func (o *CreateLogTargetLogForwardConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetLogForwardConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateLogTargetLogForwardDefault General Error

swagger:response createLogTargetLogForwardDefault
*/
type CreateLogTargetLogForwardDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogTargetLogForwardDefault creates CreateLogTargetLogForwardDefault with default headers values
func NewCreateLogTargetLogForwardDefault(code int) *CreateLogTargetLogForwardDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateLogTargetLogForwardDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create log target log forward default response
func (o *CreateLogTargetLogForwardDefault) WithStatusCode(code int) *CreateLogTargetLogForwardDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create log target log forward default response
func (o *CreateLogTargetLogForwardDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create log target log forward default response
func (o *CreateLogTargetLogForwardDefault) WithConfigurationVersion(configurationVersion string) *CreateLogTargetLogForwardDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create log target log forward default response
func (o *CreateLogTargetLogForwardDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create log target log forward default response
func (o *CreateLogTargetLogForwardDefault) WithPayload(payload *models.Error) *CreateLogTargetLogForwardDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target log forward default response
func (o *CreateLogTargetLogForwardDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetLogForwardDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
