// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package process_manager

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetProgramOKCode is the HTTP code returned for type GetProgramOK
const GetProgramOKCode int = 200

/*
GetProgramOK Successful operation

swagger:response getProgramOK
*/
type GetProgramOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Program `json:"body,omitempty"`
}

// NewGetProgramOK creates GetProgramOK with default headers values
func NewGetProgramOK() *GetProgramOK {

	return &GetProgramOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get program o k response
func (o *GetProgramOK) WithConfigurationVersion(configurationVersion string) *GetProgramOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get program o k response
func (o *GetProgramOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get program o k response
func (o *GetProgramOK) WithPayload(payload *models.Program) *GetProgramOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get program o k response
func (o *GetProgramOK) SetPayload(payload *models.Program) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetProgramOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetProgramNotFoundCode is the HTTP code returned for type GetProgramNotFound
const GetProgramNotFoundCode int = 404

/*
GetProgramNotFound The specified resource was not found

swagger:response getProgramNotFound
*/
type GetProgramNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetProgramNotFound creates GetProgramNotFound with default headers values
func NewGetProgramNotFound() *GetProgramNotFound {

	return &GetProgramNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get program not found response
func (o *GetProgramNotFound) WithConfigurationVersion(configurationVersion string) *GetProgramNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get program not found response
func (o *GetProgramNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get program not found response
func (o *GetProgramNotFound) WithPayload(payload *models.Error) *GetProgramNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get program not found response
func (o *GetProgramNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetProgramNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetProgramDefault General Error

swagger:response getProgramDefault
*/
type GetProgramDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetProgramDefault creates GetProgramDefault with default headers values
func NewGetProgramDefault(code int) *GetProgramDefault {
	if code <= 0 {
		code = 500
	}

	return &GetProgramDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get program default response
func (o *GetProgramDefault) WithStatusCode(code int) *GetProgramDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get program default response
func (o *GetProgramDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get program default response
func (o *GetProgramDefault) WithConfigurationVersion(configurationVersion string) *GetProgramDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get program default response
func (o *GetProgramDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get program default response
func (o *GetProgramDefault) WithPayload(payload *models.Error) *GetProgramDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get program default response
func (o *GetProgramDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetProgramDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
