// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package spoe

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteSpoeFileNoContentCode is the HTTP code returned for type DeleteSpoeFileNoContent
const DeleteSpoeFileNoContentCode int = 204

/*
DeleteSpoeFileNoContent SPOE file deleted

swagger:response deleteSpoeFileNoContent
*/
type DeleteSpoeFileNoContent struct {
}

// NewDeleteSpoeFileNoContent creates DeleteSpoeFileNoContent with default headers values
func NewDeleteSpoeFileNoContent() *DeleteSpoeFileNoContent {

	return &DeleteSpoeFileNoContent{}
}

// WriteResponse to the client
func (o *DeleteSpoeFileNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteSpoeFileNotFoundCode is the HTTP code returned for type DeleteSpoeFileNotFound
const DeleteSpoeFileNotFoundCode int = 404

/*
DeleteSpoeFileNotFound The specified resource was not found

swagger:response deleteSpoeFileNotFound
*/
type DeleteSpoeFileNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteSpoeFileNotFound creates DeleteSpoeFileNotFound with default headers values
func NewDeleteSpoeFileNotFound() *DeleteSpoeFileNotFound {

	return &DeleteSpoeFileNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete spoe file not found response
func (o *DeleteSpoeFileNotFound) WithConfigurationVersion(configurationVersion string) *DeleteSpoeFileNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete spoe file not found response
func (o *DeleteSpoeFileNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete spoe file not found response
func (o *DeleteSpoeFileNotFound) WithPayload(payload *models.Error) *DeleteSpoeFileNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete spoe file not found response
func (o *DeleteSpoeFileNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteSpoeFileNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteSpoeFileDefault General Error

swagger:response deleteSpoeFileDefault
*/
type DeleteSpoeFileDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteSpoeFileDefault creates DeleteSpoeFileDefault with default headers values
func NewDeleteSpoeFileDefault(code int) *DeleteSpoeFileDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteSpoeFileDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete spoe file default response
func (o *DeleteSpoeFileDefault) WithStatusCode(code int) *DeleteSpoeFileDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete spoe file default response
func (o *DeleteSpoeFileDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete spoe file default response
func (o *DeleteSpoeFileDefault) WithConfigurationVersion(configurationVersion string) *DeleteSpoeFileDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete spoe file default response
func (o *DeleteSpoeFileDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete spoe file default response
func (o *DeleteSpoeFileDefault) WithPayload(payload *models.Error) *DeleteSpoeFileDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete spoe file default response
func (o *DeleteSpoeFileDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteSpoeFileDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
