/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import jdk.jfr.events.SocketReadEvent;
import jdk.jfr.events.SocketWriteEvent;
import jdk.jfr.internal.instrument.JIInstrumentationMethod;
import jdk.jfr.internal.instrument.JIInstrumentationTarget;

@JIInstrumentationTarget(value="sun.nio.ch.SocketChannelImpl")
final class SocketChannelImplInstrumentor {
    private InetSocketAddress remoteAddress;

    private SocketChannelImplInstrumentor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(ByteBuffer byteBuffer) throws IOException {
        SocketReadEvent socketReadEvent = SocketReadEvent.EVENT.get();
        if (!socketReadEvent.isEnabled()) {
            return this.read(byteBuffer);
        }
        int n = 0;
        try {
            socketReadEvent.begin();
            n = this.read(byteBuffer);
        }
        finally {
            socketReadEvent.end();
            if (socketReadEvent.shouldCommit()) {
                String string = this.remoteAddress.getAddress().toString();
                int n2 = string.lastIndexOf(47);
                socketReadEvent.host = string.substring(0, n2);
                socketReadEvent.address = string.substring(n2 + 1);
                socketReadEvent.port = this.remoteAddress.getPort();
                if (n < 0) {
                    socketReadEvent.endOfStream = true;
                } else {
                    socketReadEvent.bytesRead = n;
                }
                socketReadEvent.timeout = 0L;
                socketReadEvent.commit();
                socketReadEvent.reset();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        SocketReadEvent socketReadEvent = SocketReadEvent.EVENT.get();
        if (!socketReadEvent.isEnabled()) {
            return this.read(byteBufferArray, n, n2);
        }
        long l = 0L;
        try {
            socketReadEvent.begin();
            l = this.read(byteBufferArray, n, n2);
        }
        finally {
            socketReadEvent.end();
            if (socketReadEvent.shouldCommit()) {
                String string = this.remoteAddress.getAddress().toString();
                int n3 = string.lastIndexOf(47);
                socketReadEvent.host = string.substring(0, n3);
                socketReadEvent.address = string.substring(n3 + 1);
                socketReadEvent.port = this.remoteAddress.getPort();
                if (l < 0L) {
                    socketReadEvent.endOfStream = true;
                } else {
                    socketReadEvent.bytesRead = l;
                }
                socketReadEvent.timeout = 0L;
                socketReadEvent.commit();
                socketReadEvent.reset();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int write(ByteBuffer byteBuffer) throws IOException {
        SocketWriteEvent socketWriteEvent = SocketWriteEvent.EVENT.get();
        if (!socketWriteEvent.isEnabled()) {
            return this.write(byteBuffer);
        }
        int n = 0;
        try {
            socketWriteEvent.begin();
            n = this.write(byteBuffer);
        }
        catch (Throwable throwable) {
            socketWriteEvent.end();
            if (socketWriteEvent.shouldCommit()) {
                String string = this.remoteAddress.getAddress().toString();
                int n2 = string.lastIndexOf(47);
                socketWriteEvent.host = string.substring(0, n2);
                socketWriteEvent.address = string.substring(n2 + 1);
                socketWriteEvent.port = this.remoteAddress.getPort();
                socketWriteEvent.bytesWritten = n < 0 ? 0L : (long)n;
                socketWriteEvent.commit();
                socketWriteEvent.reset();
            }
            throw throwable;
        }
        socketWriteEvent.end();
        if (socketWriteEvent.shouldCommit()) {
            String string = this.remoteAddress.getAddress().toString();
            int n3 = string.lastIndexOf(47);
            socketWriteEvent.host = string.substring(0, n3);
            socketWriteEvent.address = string.substring(n3 + 1);
            socketWriteEvent.port = this.remoteAddress.getPort();
            socketWriteEvent.bytesWritten = n < 0 ? 0L : (long)n;
            socketWriteEvent.commit();
            socketWriteEvent.reset();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        SocketWriteEvent socketWriteEvent = SocketWriteEvent.EVENT.get();
        if (!socketWriteEvent.isEnabled()) {
            return this.write(byteBufferArray, n, n2);
        }
        long l = 0L;
        try {
            socketWriteEvent.begin();
            l = this.write(byteBufferArray, n, n2);
        }
        catch (Throwable throwable) {
            socketWriteEvent.end();
            if (socketWriteEvent.shouldCommit()) {
                String string = this.remoteAddress.getAddress().toString();
                int n3 = string.lastIndexOf(47);
                socketWriteEvent.host = string.substring(0, n3);
                socketWriteEvent.address = string.substring(n3 + 1);
                socketWriteEvent.port = this.remoteAddress.getPort();
                socketWriteEvent.bytesWritten = l < 0L ? 0L : l;
                socketWriteEvent.commit();
                socketWriteEvent.reset();
            }
            throw throwable;
        }
        socketWriteEvent.end();
        if (socketWriteEvent.shouldCommit()) {
            String string = this.remoteAddress.getAddress().toString();
            int n4 = string.lastIndexOf(47);
            socketWriteEvent.host = string.substring(0, n4);
            socketWriteEvent.address = string.substring(n4 + 1);
            socketWriteEvent.port = this.remoteAddress.getPort();
            socketWriteEvent.bytesWritten = l < 0L ? 0L : l;
            socketWriteEvent.commit();
            socketWriteEvent.reset();
        }
        return l;
    }
}

