/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LazyInitializationException;
import net.sf.hibernate.engine.Key;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.proxy.SerializableProxy;
import net.sf.hibernate.util.ReflectHelper;
import org.apache.commons.logging.LogFactory;

public abstract class LazyInitializer {
    protected static final Object INVOKE_IMPLEMENTATION = new Object();
    protected Object target = null;
    protected Serializable id;
    protected SessionImplementor session;
    protected Class persistentClass;
    protected Method getIdentifierMethod;
    protected boolean overridesEquals;
    private Object[] snapshot;
    private SerializableProxy replacement;
    static /* synthetic */ Class class$net$sf$hibernate$proxy$LazyInitializer;

    protected LazyInitializer(Class persistentClass, Serializable id, Method getIdentifierMethod, SessionImplementor session) {
        this.id = id;
        this.session = session;
        this.persistentClass = persistentClass;
        this.getIdentifierMethod = getIdentifierMethod;
        this.overridesEquals = ReflectHelper.overridesEquals(persistentClass);
    }

    public void initialize() throws HibernateException {
        if (this.target == null) {
            if (this.session == null) {
                throw new HibernateException("Could not initialize proxy - no Session");
            }
            if (!this.session.isOpen()) {
                throw new HibernateException("Could not initialize proxy - the owning Session was closed");
            }
            this.target = this.session.immediateLoad(this.persistentClass, this.id);
        }
    }

    private void initializeWrapExceptions() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            LogFactory.getLog((Class)(class$net$sf$hibernate$proxy$LazyInitializer == null ? (class$net$sf$hibernate$proxy$LazyInitializer = LazyInitializer.class$("net.sf.hibernate.proxy.LazyInitializer")) : class$net$sf$hibernate$proxy$LazyInitializer)).error((Object)"Exception initializing proxy", (Throwable)e);
            throw new LazyInitializationException(e);
        }
    }

    protected abstract SerializableProxy serializableProxy();

    protected final Object invoke(Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        int params = method.getParameterTypes().length;
        if (params == 0) {
            if ("writeReplace".equals(methodName)) {
                if (this.target == null && this.session != null) {
                    this.target = this.session.getEntity(new Key(this.id, this.session.getFactory().getPersister(this.persistentClass)));
                }
                if (this.target == null) {
                    if (this.replacement == null) {
                        this.replacement = this.serializableProxy();
                    }
                    return this.replacement;
                }
                return this.target;
            }
            if (!this.overridesEquals && this.getIdentifierMethod != null && "hashCode".equals(methodName)) {
                return new Integer(this.id.hashCode());
            }
            if (method.equals(this.getIdentifierMethod)) {
                return this.id;
            }
            if ("finalize".equals(method.getName())) {
                return null;
            }
        } else if (params == 1 && !this.overridesEquals && this.getIdentifierMethod != null && "equals".equals(methodName)) {
            return new Boolean(this.id.equals(this.getIdentifierMethod.invoke(args[0], null)));
        }
        return INVOKE_IMPLEMENTATION;
    }

    public final Serializable getIdentifier() {
        return this.id;
    }

    public final Class getPersistentClass() {
        return this.persistentClass;
    }

    public final boolean isUninitialized() {
        return this.target == null;
    }

    public final SessionImplementor getSession() {
        return this.session;
    }

    public final void setSession(SessionImplementor s) {
        if (s != this.session) {
            if (this.session != null && this.session.isOpen()) {
                throw new LazyInitializationException("Illegally attempted to associate a proxy with two open Sessions");
            }
            this.session = s;
        }
    }

    public final Object getImplementation() throws HibernateException {
        this.initializeWrapExceptions();
        return this.target;
    }

    public final Object getImplementation(SessionImplementor s) throws HibernateException {
        return s.getEntity(new Key(this.getIdentifier(), s.getFactory().getPersister(this.getPersistentClass())));
    }

    public void setSnapshot(Object[] sn) {
        this.snapshot = sn;
    }

    public Object[] getSnapshot() {
        return this.snapshot;
    }

    void setTarget(Object target) {
        this.target = target;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

