/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.UniquenessMultipleAttributeBehavior;
import com.unboundid.ldap.sdk.unboundidds.controls.UniquenessRequestControlProperties;
import com.unboundid.ldap.sdk.unboundidds.controls.UniquenessValidationLevel;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class UniquenessRequestControl
extends Control {
    @NotNull
    public static final String UNIQUENESS_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.52";
    private static final byte TYPE_UNIQUENESS_ID = -128;
    private static final byte TYPE_ATTRIBUTE_TYPES = -95;
    private static final byte TYPE_MULTIPLE_ATTRIBUTE_BEHAVIOR = -126;
    private static final byte TYPE_BASE_DN = -125;
    private static final byte TYPE_FILTER = -92;
    private static final byte TYPE_PREVENT_CONFLICTS_WITH_SOFT_DELETED_ENTRIES = -123;
    private static final byte TYPE_PRE_COMMIT_VALIDATION_LEVEL = -122;
    private static final byte TYPE_POST_COMMIT_VALIDATION_LEVEL = -121;
    private static final byte TYPE_ALERT_ON_POST_VALIDATION_CONFLICT_DETECTION = -120;
    private static final byte TYPE_CREATE_CONFLICT_PREVENTION_DETAILS_ENTRY = -119;
    @NotNull
    private static final String JSON_FIELD_ALERT_ON_POST_COMMIT_CONFLICT_DETECTION = "alert-on-post-commit-conflict-detection";
    @NotNull
    private static final String JSON_FIELD_ATTRIBUTE_TYPES = "attribute-types";
    @NotNull
    private static final String JSON_FIELD_BASE_DN = "base-dn";
    @NotNull
    private static final String JSON_FIELD_CREATE_CONFLICT_PREVENTION_DETAILS_ENTRY = "create-conflict-prevention-details-entry";
    @NotNull
    private static final String JSON_FIELD_FILTER = "filter";
    @NotNull
    private static final String JSON_FIELD_MULTIPLE_ATTRIBUTE_BEHAVIOR = "multiple-attribute-behavior";
    @NotNull
    private static final String JSON_FIELD_PRE_COMMIT_VALIDATION_LEVEL = "pre-commit-validation-level";
    @NotNull
    private static final String JSON_FIELD_POST_COMMIT_VALIDATION_LEVEL = "post-commit-validation-level";
    @NotNull
    private static final String JSON_FIELD_PREVENT_CONFLICTS_WITH_SOFT_DELETED_ENTRIES = "prevent-conflicts-with-soft-deleted-entries";
    @NotNull
    private static final String JSON_FIELD_UNIQUENESS_ID = "uniqueness-id";
    @NotNull
    private static final String JSON_MAB_UNIQUE_WITHIN_EACH_ATTRIBUTE = "unique-within-each-attribute";
    @NotNull
    private static final String JSON_MAB_UNIQUE_ACROSS_ALL_ATTRIBUTES_INCLUDING_SAME_ENTRY = "unique-across-all-attributes-including-in-the-same-entry";
    @NotNull
    private static final String JSON_MAB_UNIQUE_ACROSS_ALL_ATTRIBUTES_EXCEPT_SAME_ENTRY = "unique-across-all-attributes-except-in-the-same-entry";
    @NotNull
    private static final String JSON_MAB_UNIQUE_IN_COMBINATION = "unique-in-combination";
    @NotNull
    private static final String JSON_VALIDATION_LEVEL_NONE = "none";
    @NotNull
    private static final String JSON_VALIDATION_LEVEL_ALL_SUBTREE_VIEWS = "all-subtree-views";
    @NotNull
    private static final String JSON_VALIDATION_LEVEL_ALL_BACKEND_SETS = "all-backend-sets";
    @NotNull
    private static final String JSON_VALIDATION_LEVEL_ALL_AVAILABLE_BACKEND_SERVERS = "all-available-backend-servers";
    private static final long serialVersionUID = 7976218379635922852L;
    private final boolean alertOnPostCommitConflictDetection;
    private final boolean createConflictPreventionDetailsEntry;
    private final boolean preventConflictsWithSoftDeletedEntries;
    @Nullable
    private final Filter filter;
    @NotNull
    private final Set<String> attributeTypes;
    @Nullable
    private final String baseDN;
    @NotNull
    private final String uniquenessID;
    @NotNull
    private final UniquenessMultipleAttributeBehavior multipleAttributeBehavior;
    @NotNull
    private final UniquenessValidationLevel postCommitValidationLevel;
    @NotNull
    private final UniquenessValidationLevel preCommitValidationLevel;

    public UniquenessRequestControl(boolean isCritical, @Nullable String uniquenessID, @NotNull UniquenessRequestControlProperties properties) throws LDAPException {
        this(uniquenessID == null ? CryptoHelper.getRandomUUID().toString() : uniquenessID, properties, isCritical);
    }

    private UniquenessRequestControl(@NotNull String uniquenessID, @NotNull UniquenessRequestControlProperties properties, boolean isCritical) throws LDAPException {
        super(UNIQUENESS_REQUEST_OID, isCritical, UniquenessRequestControl.encodeValue(uniquenessID, properties));
        Validator.ensureNotNull(uniquenessID);
        this.uniquenessID = uniquenessID;
        this.attributeTypes = properties.getAttributeTypes();
        this.multipleAttributeBehavior = properties.getMultipleAttributeBehavior();
        this.baseDN = properties.getBaseDN();
        this.filter = properties.getFilter();
        this.preventConflictsWithSoftDeletedEntries = properties.preventConflictsWithSoftDeletedEntries();
        this.preCommitValidationLevel = properties.getPreCommitValidationLevel();
        this.postCommitValidationLevel = properties.getPostCommitValidationLevel();
        this.alertOnPostCommitConflictDetection = properties.alertOnPostCommitConflictDetection();
        this.createConflictPreventionDetailsEntry = properties.createConflictPreventionDetailsEntry();
        if (this.attributeTypes.isEmpty() && this.filter == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_NO_ATTRS_OR_FILTER.get());
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String uniquenessID, @NotNull UniquenessRequestControlProperties properties) {
        UniquenessValidationLevel postCommitValidationLevel;
        UniquenessValidationLevel preCommitValidationLevel;
        Filter filter;
        String baseDN;
        UniquenessMultipleAttributeBehavior multipleAttributeBehavior;
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(10);
        elements.add(new ASN1OctetString(-128, uniquenessID));
        Set<String> attributeTypes = properties.getAttributeTypes();
        if (!attributeTypes.isEmpty()) {
            ArrayList<ASN1OctetString> attributeTypeElements = new ArrayList<ASN1OctetString>(attributeTypes.size());
            for (String attributeType : attributeTypes) {
                attributeTypeElements.add(new ASN1OctetString(attributeType));
            }
            elements.add(new ASN1Set(-95, attributeTypeElements));
        }
        if ((multipleAttributeBehavior = properties.getMultipleAttributeBehavior()) != UniquenessMultipleAttributeBehavior.UNIQUE_WITHIN_EACH_ATTRIBUTE) {
            elements.add(new ASN1Enumerated(-126, multipleAttributeBehavior.intValue()));
        }
        if ((baseDN = properties.getBaseDN()) != null) {
            elements.add(new ASN1OctetString(-125, baseDN));
        }
        if ((filter = properties.getFilter()) != null) {
            elements.add(new ASN1Element(-92, filter.encode().encode()));
        }
        if (properties.preventConflictsWithSoftDeletedEntries()) {
            elements.add(new ASN1Boolean(-123, true));
        }
        if ((preCommitValidationLevel = properties.getPreCommitValidationLevel()) != UniquenessValidationLevel.ALL_SUBTREE_VIEWS) {
            elements.add(new ASN1Enumerated(-122, preCommitValidationLevel.intValue()));
        }
        if ((postCommitValidationLevel = properties.getPostCommitValidationLevel()) != UniquenessValidationLevel.ALL_SUBTREE_VIEWS) {
            elements.add(new ASN1Enumerated(-121, postCommitValidationLevel.intValue()));
        }
        if (!properties.alertOnPostCommitConflictDetection()) {
            elements.add(new ASN1Boolean(-120, false));
        }
        if (properties.createConflictPreventionDetailsEntry()) {
            elements.add(new ASN1Boolean(-119, true));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public UniquenessRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_DECODE_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements;
            boolean decodedAlertOnPostCommitConflictDetection = true;
            boolean decodedCreateConflictPreventionDetailsEntry = false;
            boolean decodedPreventSoftDeletedConflicts = false;
            Filter decodedFilter = null;
            Set<Object> decodedAttributeTypes = Collections.emptySet();
            String decodedBaseDN = null;
            String decodedUniquenessID = null;
            UniquenessMultipleAttributeBehavior decodedMultipleAttributeBehavior = UniquenessMultipleAttributeBehavior.UNIQUE_WITHIN_EACH_ATTRIBUTE;
            UniquenessValidationLevel decodedPreCommitLevel = UniquenessValidationLevel.ALL_SUBTREE_VIEWS;
            UniquenessValidationLevel decodedPostCommitLevel = UniquenessValidationLevel.ALL_SUBTREE_VIEWS;
            block15: for (ASN1Element e : elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        decodedUniquenessID = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block15;
                    }
                    case -95: {
                        ASN1Element[] atElements = ASN1Set.decodeAsSet(e).elements();
                        LinkedHashSet<String> atNames = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(atElements.length));
                        for (ASN1Element atElement : atElements) {
                            atNames.add(ASN1OctetString.decodeAsOctetString(atElement).stringValue());
                        }
                        decodedAttributeTypes = Collections.unmodifiableSet(atNames);
                        continue block15;
                    }
                    case -126: {
                        int mabIntValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        decodedMultipleAttributeBehavior = UniquenessMultipleAttributeBehavior.valueOf(mabIntValue);
                        if (decodedMultipleAttributeBehavior != null) continue block15;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_DECODE_UNKNOWN_MULTIPLE_ATTR_BEHAVIOR.get(mabIntValue));
                    }
                    case -125: {
                        decodedBaseDN = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block15;
                    }
                    case -92: {
                        decodedFilter = Filter.decode(ASN1Element.decode(e.getValue()));
                        continue block15;
                    }
                    case -123: {
                        decodedPreventSoftDeletedConflicts = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block15;
                    }
                    case -122: {
                        int preCommitIntValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        decodedPreCommitLevel = UniquenessValidationLevel.valueOf(preCommitIntValue);
                        if (decodedPreCommitLevel != null) continue block15;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_DECODE_UNKNOWN_PRE_COMMIT_LEVEL.get(preCommitIntValue));
                    }
                    case -121: {
                        int postCommitIntValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        decodedPostCommitLevel = UniquenessValidationLevel.valueOf(postCommitIntValue);
                        if (decodedPostCommitLevel != null) continue block15;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_DECODE_UNKNOWN_POST_COMMIT_LEVEL.get(postCommitIntValue));
                    }
                    case -120: {
                        decodedAlertOnPostCommitConflictDetection = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block15;
                    }
                    case -119: {
                        decodedCreateConflictPreventionDetailsEntry = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block15;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_DECODE_UNKNOWN_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            if (decodedUniquenessID == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_MISSING_UNIQUENESS_ID.get());
            }
            if (decodedAttributeTypes.isEmpty() && decodedFilter == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_NO_ATTRS_OR_FILTER.get());
            }
            this.uniquenessID = decodedUniquenessID;
            this.attributeTypes = decodedAttributeTypes;
            this.multipleAttributeBehavior = decodedMultipleAttributeBehavior;
            this.baseDN = decodedBaseDN;
            this.filter = decodedFilter;
            this.preventConflictsWithSoftDeletedEntries = decodedPreventSoftDeletedConflicts;
            this.preCommitValidationLevel = decodedPreCommitLevel;
            this.postCommitValidationLevel = decodedPostCommitLevel;
            this.alertOnPostCommitConflictDetection = decodedAlertOnPostCommitConflictDetection;
            this.createConflictPreventionDetailsEntry = decodedCreateConflictPreventionDetailsEntry;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_DECODE_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public String getUniquenessID() {
        return this.uniquenessID;
    }

    @NotNull
    public Set<String> getAttributeTypes() {
        return this.attributeTypes;
    }

    @NotNull
    public UniquenessMultipleAttributeBehavior getMultipleAttributeBehavior() {
        return this.multipleAttributeBehavior;
    }

    @Nullable
    public String getBaseDN() {
        return this.baseDN;
    }

    @Nullable
    public Filter getFilter() {
        return this.filter;
    }

    public boolean preventConflictsWithSoftDeletedEntries() {
        return this.preventConflictsWithSoftDeletedEntries;
    }

    @NotNull
    public UniquenessValidationLevel getPreCommitValidationLevel() {
        return this.preCommitValidationLevel;
    }

    @NotNull
    public UniquenessValidationLevel getPostCommitValidationLevel() {
        return this.postCommitValidationLevel;
    }

    public boolean alertOnPostCommitConflictDetection() {
        return this.alertOnPostCommitConflictDetection;
    }

    public boolean createConflictPreventionDetailsEntry() {
        return this.createConflictPreventionDetailsEntry;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_UNIQUENESS_REQ_CONTROL_NAME.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        valueFields.put(JSON_FIELD_UNIQUENESS_ID, new JSONString(this.uniquenessID));
        if (!this.attributeTypes.isEmpty()) {
            ArrayList<JSONString> attributeTypesValues = new ArrayList<JSONString>(this.attributeTypes.size());
            for (String attributeType : this.attributeTypes) {
                attributeTypesValues.add(new JSONString(attributeType));
            }
            valueFields.put(JSON_FIELD_ATTRIBUTE_TYPES, new JSONArray(attributeTypesValues));
        }
        if (this.attributeTypes.size() > 1 || this.multipleAttributeBehavior != UniquenessMultipleAttributeBehavior.UNIQUE_WITHIN_EACH_ATTRIBUTE) {
            switch (this.multipleAttributeBehavior) {
                case UNIQUE_WITHIN_EACH_ATTRIBUTE: {
                    valueFields.put(JSON_FIELD_MULTIPLE_ATTRIBUTE_BEHAVIOR, new JSONString(JSON_MAB_UNIQUE_WITHIN_EACH_ATTRIBUTE));
                    break;
                }
                case UNIQUE_ACROSS_ALL_ATTRIBUTES_INCLUDING_IN_SAME_ENTRY: {
                    valueFields.put(JSON_FIELD_MULTIPLE_ATTRIBUTE_BEHAVIOR, new JSONString(JSON_MAB_UNIQUE_ACROSS_ALL_ATTRIBUTES_INCLUDING_SAME_ENTRY));
                    break;
                }
                case UNIQUE_ACROSS_ALL_ATTRIBUTES_EXCEPT_IN_SAME_ENTRY: {
                    valueFields.put(JSON_FIELD_MULTIPLE_ATTRIBUTE_BEHAVIOR, new JSONString(JSON_MAB_UNIQUE_ACROSS_ALL_ATTRIBUTES_EXCEPT_SAME_ENTRY));
                    break;
                }
                case UNIQUE_IN_COMBINATION: {
                    valueFields.put(JSON_FIELD_MULTIPLE_ATTRIBUTE_BEHAVIOR, new JSONString(JSON_MAB_UNIQUE_IN_COMBINATION));
                }
            }
        }
        if (this.baseDN != null) {
            valueFields.put(JSON_FIELD_BASE_DN, new JSONString(this.baseDN));
        }
        if (this.filter != null) {
            valueFields.put(JSON_FIELD_FILTER, new JSONString(this.filter.toString()));
        }
        valueFields.put(JSON_FIELD_PREVENT_CONFLICTS_WITH_SOFT_DELETED_ENTRIES, new JSONBoolean(this.preventConflictsWithSoftDeletedEntries));
        UniquenessRequestControl.addJSONValidationLevel(valueFields, JSON_FIELD_PRE_COMMIT_VALIDATION_LEVEL, this.preCommitValidationLevel);
        UniquenessRequestControl.addJSONValidationLevel(valueFields, JSON_FIELD_POST_COMMIT_VALIDATION_LEVEL, this.postCommitValidationLevel);
        valueFields.put(JSON_FIELD_ALERT_ON_POST_COMMIT_CONFLICT_DETECTION, new JSONBoolean(this.alertOnPostCommitConflictDetection));
        valueFields.put(JSON_FIELD_CREATE_CONFLICT_PREVENTION_DETAILS_ENTRY, new JSONBoolean(this.createConflictPreventionDetailsEntry));
        return new JSONObject(new JSONField("oid", UNIQUENESS_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_UNIQUENESS_REQ_CONTROL_NAME.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    private static void addJSONValidationLevel(@NotNull Map<String, JSONValue> valueFields, @NotNull String fieldName, @NotNull UniquenessValidationLevel validationLevel) {
        switch (validationLevel) {
            case NONE: {
                valueFields.put(fieldName, new JSONString(JSON_VALIDATION_LEVEL_NONE));
                break;
            }
            case ALL_SUBTREE_VIEWS: {
                valueFields.put(fieldName, new JSONString(JSON_VALIDATION_LEVEL_ALL_SUBTREE_VIEWS));
                break;
            }
            case ALL_BACKEND_SETS: {
                valueFields.put(fieldName, new JSONString(JSON_VALIDATION_LEVEL_ALL_BACKEND_SETS));
                break;
            }
            case ALL_AVAILABLE_BACKEND_SERVERS: {
                valueFields.put(fieldName, new JSONString(JSON_VALIDATION_LEVEL_ALL_AVAILABLE_BACKEND_SERVERS));
            }
        }
    }

    @NotNull
    public static UniquenessRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        Boolean preventConflictsWithSoftDeletedEntries;
        UniquenessRequestControlProperties properties;
        Filter filter;
        Set<String> attributeTypes;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new UniquenessRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        String uniquenessID = valueObject.getFieldAsString(JSON_FIELD_UNIQUENESS_ID);
        List<JSONValue> attributeTypesValues = valueObject.getFieldAsArray(JSON_FIELD_ATTRIBUTE_TYPES);
        if (attributeTypesValues == null || attributeTypesValues.isEmpty()) {
            attributeTypes = Collections.emptySet();
        } else {
            attributeTypes = new LinkedHashSet();
            for (JSONValue v : attributeTypesValues) {
                if (v instanceof JSONString) {
                    attributeTypes.add(((JSONString)v).stringValue());
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_JSON_ATTR_TYPE_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_ATTRIBUTE_TYPES));
            }
        }
        String filterStr = valueObject.getFieldAsString(JSON_FIELD_FILTER);
        if (filterStr == null) {
            filter = null;
        } else {
            try {
                filter = Filter.create(filterStr);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_JSON_INVALID_FILTER.get(controlObject.toSingleLineString(), JSON_FIELD_FILTER, filterStr));
            }
        }
        if (attributeTypes.isEmpty()) {
            if (filter == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_JSON_NEITHER_ATTR_TYPES_NOR_FILTER.get(controlObject.toSingleLineString(), JSON_FIELD_ATTRIBUTE_TYPES, JSON_FIELD_FILTER));
            }
            properties = new UniquenessRequestControlProperties(filter);
        } else {
            properties = new UniquenessRequestControlProperties(attributeTypes);
            if (filter != null) {
                properties.setFilter(filter);
            }
        }
        String multipleAttributeBehaviorStr = valueObject.getFieldAsString(JSON_FIELD_MULTIPLE_ATTRIBUTE_BEHAVIOR);
        if (multipleAttributeBehaviorStr == null) {
            properties.setMultipleAttributeBehavior(UniquenessMultipleAttributeBehavior.UNIQUE_WITHIN_EACH_ATTRIBUTE);
        } else {
            switch (multipleAttributeBehaviorStr) {
                case "unique-within-each-attribute": {
                    properties.setMultipleAttributeBehavior(UniquenessMultipleAttributeBehavior.UNIQUE_WITHIN_EACH_ATTRIBUTE);
                    break;
                }
                case "unique-across-all-attributes-including-in-the-same-entry": {
                    properties.setMultipleAttributeBehavior(UniquenessMultipleAttributeBehavior.UNIQUE_ACROSS_ALL_ATTRIBUTES_INCLUDING_IN_SAME_ENTRY);
                    break;
                }
                case "unique-across-all-attributes-except-in-the-same-entry": {
                    properties.setMultipleAttributeBehavior(UniquenessMultipleAttributeBehavior.UNIQUE_ACROSS_ALL_ATTRIBUTES_EXCEPT_IN_SAME_ENTRY);
                    break;
                }
                case "unique-in-combination": {
                    properties.setMultipleAttributeBehavior(UniquenessMultipleAttributeBehavior.UNIQUE_IN_COMBINATION);
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_JSON_UNRECOGNIZED_MULTIPLE_ATTR_BEHAVIOR.get(controlObject.toSingleLineString(), JSON_FIELD_MULTIPLE_ATTRIBUTE_BEHAVIOR, multipleAttributeBehaviorStr, JSON_MAB_UNIQUE_WITHIN_EACH_ATTRIBUTE, JSON_MAB_UNIQUE_ACROSS_ALL_ATTRIBUTES_INCLUDING_SAME_ENTRY, JSON_MAB_UNIQUE_ACROSS_ALL_ATTRIBUTES_EXCEPT_SAME_ENTRY, JSON_MAB_UNIQUE_IN_COMBINATION));
                }
            }
        }
        String baseDNStr = valueObject.getFieldAsString(JSON_FIELD_BASE_DN);
        if (baseDNStr != null) {
            properties.setBaseDN(baseDNStr);
        }
        if ((preventConflictsWithSoftDeletedEntries = valueObject.getFieldAsBoolean(JSON_FIELD_PREVENT_CONFLICTS_WITH_SOFT_DELETED_ENTRIES)) == null) {
            properties.setPreventConflictsWithSoftDeletedEntries(false);
        } else {
            properties.setPreventConflictsWithSoftDeletedEntries(preventConflictsWithSoftDeletedEntries);
        }
        properties.setPreCommitValidationLevel(UniquenessRequestControl.getValidationLevelJSON(controlObject, valueObject, JSON_FIELD_PRE_COMMIT_VALIDATION_LEVEL));
        properties.setPostCommitValidationLevel(UniquenessRequestControl.getValidationLevelJSON(controlObject, valueObject, JSON_FIELD_POST_COMMIT_VALIDATION_LEVEL));
        Boolean alertOnPostCommitConflictDetection = valueObject.getFieldAsBoolean(JSON_FIELD_ALERT_ON_POST_COMMIT_CONFLICT_DETECTION);
        if (alertOnPostCommitConflictDetection == null) {
            properties.setAlertOnPostCommitConflictDetection(true);
        } else {
            properties.setAlertOnPostCommitConflictDetection(alertOnPostCommitConflictDetection);
        }
        Boolean createConflictPreventionDetailsEntry = valueObject.getFieldAsBoolean(JSON_FIELD_CREATE_CONFLICT_PREVENTION_DETAILS_ENTRY);
        if (createConflictPreventionDetailsEntry == null) {
            properties.setCreateConflictPreventionDetailsEntry(false);
        } else {
            properties.setCreateConflictPreventionDetailsEntry(createConflictPreventionDetailsEntry);
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_UNIQUENESS_ID, JSON_FIELD_ATTRIBUTE_TYPES, JSON_FIELD_MULTIPLE_ATTRIBUTE_BEHAVIOR, JSON_FIELD_BASE_DN, JSON_FIELD_FILTER, JSON_FIELD_PREVENT_CONFLICTS_WITH_SOFT_DELETED_ENTRIES, JSON_FIELD_PRE_COMMIT_VALIDATION_LEVEL, JSON_FIELD_POST_COMMIT_VALIDATION_LEVEL, JSON_FIELD_ALERT_ON_POST_COMMIT_CONFLICT_DETECTION, JSON_FIELD_CREATE_CONFLICT_PREVENTION_DETAILS_ENTRY)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new UniquenessRequestControl(jsonControl.getCriticality(), uniquenessID, properties);
    }

    @NotNull
    private static UniquenessValidationLevel getValidationLevelJSON(@NotNull JSONObject controlObject, @NotNull JSONObject valueObject, @NotNull String fieldName) throws LDAPException {
        String valueStr = valueObject.getFieldAsString(fieldName);
        if (valueStr == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), fieldName));
        }
        switch (valueStr) {
            case "none": {
                return UniquenessValidationLevel.NONE;
            }
            case "all-subtree-views": {
                return UniquenessValidationLevel.ALL_SUBTREE_VIEWS;
            }
            case "all-backend-sets": {
                return UniquenessValidationLevel.ALL_BACKEND_SETS;
            }
            case "all-available-backend-servers": {
                return UniquenessValidationLevel.ALL_AVAILABLE_BACKEND_SERVERS;
            }
        }
        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_JSON_UNRECOGNIZED_VALIDATION_LEVEL.get(controlObject.toSingleLineString(), fieldName, valueStr, JSON_VALIDATION_LEVEL_NONE, JSON_VALIDATION_LEVEL_ALL_SUBTREE_VIEWS, JSON_VALIDATION_LEVEL_ALL_BACKEND_SETS, JSON_VALIDATION_LEVEL_ALL_AVAILABLE_BACKEND_SERVERS));
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("UniquenessRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", uniquenessID='");
        buffer.append(this.uniquenessID);
        buffer.append("', attributeTypes={");
        Iterator<String> attributeTypesIterator = this.attributeTypes.iterator();
        while (attributeTypesIterator.hasNext()) {
            buffer.append('\'');
            buffer.append(attributeTypesIterator.next());
            buffer.append('\'');
            if (!attributeTypesIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, multipleAttributeBehavior=");
        buffer.append((Object)this.multipleAttributeBehavior);
        if (this.baseDN != null) {
            buffer.append(", baseDN='");
            buffer.append(this.baseDN);
            buffer.append('\'');
        }
        if (this.filter != null) {
            buffer.append(", filter='");
            buffer.append(this.filter);
            buffer.append('\'');
        }
        buffer.append(", preventConflictsWithSoftDeletedEntries=");
        buffer.append(this.preventConflictsWithSoftDeletedEntries);
        buffer.append(", preCommitValidationLevel=");
        buffer.append((Object)this.preCommitValidationLevel);
        buffer.append(", postCommitValidationLevel=");
        buffer.append((Object)this.postCommitValidationLevel);
        buffer.append(", alertOnPostCommitConflictDetection=");
        buffer.append(this.alertOnPostCommitConflictDetection);
        buffer.append(", createConflictPreventionDetailsEntry=");
        buffer.append(this.createConflictPreventionDetailsEntry);
        buffer.append(')');
    }
}

