/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.AggregatePostConnectProcessor;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.EXTERNALBindRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RoundRobinServerSet;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.ldap.sdk.StartTLSPostConnectProcessor;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.PasswordReader;
import com.unboundid.util.SASLUtils;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.ssl.AggregateTrustManager;
import com.unboundid.util.ssl.HostNameSSLSocketVerifier;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.PKCS11KeyManager;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import com.unboundid.util.ssl.WrapperKeyManager;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public abstract class LDAPCommandLineTool
extends CommandLineTool {
    @Nullable
    private BooleanArgument defaultTrust = null;
    @Nullable
    private BooleanArgument helpSASL = null;
    @Nullable
    private BooleanArgument enableSSLDebugging = null;
    @Nullable
    private BooleanArgument promptForBindPassword = null;
    @Nullable
    private BooleanArgument promptForKeyStorePassword = null;
    @Nullable
    private BooleanArgument promptForTrustStorePassword = null;
    @Nullable
    private BooleanArgument trustAll = null;
    @Nullable
    private BooleanArgument useSASLExternal = null;
    @Nullable
    private BooleanArgument useSSL = null;
    @Nullable
    private BooleanArgument useStartTLS = null;
    @Nullable
    private BooleanArgument verifyCertificateHostnames = null;
    @Nullable
    private DNArgument bindDN = null;
    @Nullable
    private FileArgument bindPasswordFile = null;
    @Nullable
    private FileArgument keyStorePasswordFile = null;
    @Nullable
    private FileArgument trustStorePasswordFile = null;
    @Nullable
    private IntegerArgument port = null;
    @Nullable
    private StringArgument bindPassword = null;
    @Nullable
    private StringArgument certificateNickname = null;
    @Nullable
    private StringArgument host = null;
    @Nullable
    private StringArgument keyStoreFormat = null;
    @Nullable
    private StringArgument keyStorePath = null;
    @Nullable
    private StringArgument keyStorePassword = null;
    @Nullable
    private StringArgument saslOption = null;
    @Nullable
    private StringArgument trustStoreFormat = null;
    @Nullable
    private StringArgument trustStorePath = null;
    @Nullable
    private StringArgument trustStorePassword = null;
    @Nullable
    private BindRequest bindRequest = null;
    @Nullable
    private ServerSet serverSet = null;
    @Nullable
    private SSLSocketFactory startTLSSocketFactory = null;
    @NotNull
    private final AtomicReference<AggregateTrustManager> promptTrustManager = new AtomicReference();

    public LDAPCommandLineTool(@Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        super(outStream, errStream);
    }

    @NotNull
    static Set<String> getLongLDAPArgumentIdentifiers(@NotNull LDAPCommandLineTool tool) {
        LinkedHashSet<String> ids = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(21));
        ids.add("hostname");
        ids.add("port");
        if (tool.supportsAuthentication()) {
            ids.add("bindDN");
            ids.add("bindPassword");
            ids.add("bindPasswordFile");
            ids.add("promptForBindPassword");
        }
        ids.add("useSSL");
        ids.add("useStartTLS");
        ids.add("defaultTrust");
        ids.add("trustAll");
        ids.add("keyStorePath");
        ids.add("keyStorePassword");
        ids.add("keyStorePasswordFile");
        ids.add("promptForKeyStorePassword");
        ids.add("keyStoreFormat");
        ids.add("trustStorePath");
        ids.add("trustStorePassword");
        ids.add("trustStorePasswordFile");
        ids.add("promptForTrustStorePassword");
        ids.add("trustStoreFormat");
        ids.add("certNickname");
        ids.add("verifyCertificateHostnames");
        if (tool.supportsAuthentication()) {
            ids.add("saslOption");
            ids.add("useSASLExternal");
            ids.add("helpSASL");
        }
        return Collections.unmodifiableSet(ids);
    }

    @NotNull
    protected Set<Character> getSuppressedShortIdentifiers() {
        return Collections.emptySet();
    }

    @Nullable
    private Character getShortIdentifierIfNotSuppressed(@NotNull Character id) {
        if (this.getSuppressedShortIdentifiers().contains(id)) {
            return null;
        }
        return id;
    }

    @Override
    public final void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        boolean supportsAuthentication = this.supportsAuthentication();
        String argumentGroup = supportsAuthentication ? UtilityMessages.INFO_LDAP_TOOL_ARG_GROUP_CONNECT_AND_AUTH.get() : UtilityMessages.INFO_LDAP_TOOL_ARG_GROUP_CONNECT.get();
        this.host = new StringArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('h')), "hostname", true, this.supportsMultipleServers() ? 0 : 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_HOST.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_HOST.get(), "localhost");
        if (this.includeAlternateLongIdentifiers()) {
            this.host.addLongIdentifier("host", true);
            this.host.addLongIdentifier("address", true);
        }
        this.host.setArgumentGroupName(argumentGroup);
        parser.addArgument(this.host);
        this.port = new IntegerArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('p')), "port", true, this.supportsMultipleServers() ? 0 : 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PORT.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_PORT.get(), 1, 65535, 389);
        this.port.setArgumentGroupName(argumentGroup);
        parser.addArgument(this.port);
        if (supportsAuthentication) {
            this.bindDN = new DNArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('D')), "bindDN", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_DN.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_BIND_DN.get());
            this.bindDN.setArgumentGroupName(argumentGroup);
            if (this.includeAlternateLongIdentifiers()) {
                this.bindDN.addLongIdentifier("bind-dn", true);
            }
            parser.addArgument(this.bindDN);
            this.bindPassword = new StringArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('w')), "bindPassword", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PASSWORD.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_BIND_PW.get());
            this.bindPassword.setSensitive(true);
            this.bindPassword.setArgumentGroupName(argumentGroup);
            if (this.includeAlternateLongIdentifiers()) {
                this.bindPassword.addLongIdentifier("bind-password", true);
            }
            parser.addArgument(this.bindPassword);
            this.bindPasswordFile = new FileArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('j')), "bindPasswordFile", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_BIND_PW_FILE.get(), true, true, true, false);
            this.bindPasswordFile.setArgumentGroupName(argumentGroup);
            if (this.includeAlternateLongIdentifiers()) {
                this.bindPasswordFile.addLongIdentifier("bind-password-file", true);
            }
            parser.addArgument(this.bindPasswordFile);
            this.promptForBindPassword = new BooleanArgument(null, "promptForBindPassword", 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_BIND_PW_PROMPT.get());
            this.promptForBindPassword.setArgumentGroupName(argumentGroup);
            if (this.includeAlternateLongIdentifiers()) {
                this.promptForBindPassword.addLongIdentifier("prompt-for-bind-password", true);
            }
            parser.addArgument(this.promptForBindPassword);
        }
        this.useSSL = new BooleanArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('Z')), "useSSL", 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_USE_SSL.get());
        this.useSSL.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.useSSL.addLongIdentifier("use-ssl", true);
        }
        parser.addArgument(this.useSSL);
        this.useStartTLS = new BooleanArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('q')), "useStartTLS", 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_USE_START_TLS.get());
        this.useStartTLS.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.useStartTLS.addLongIdentifier("use-starttls", true);
            this.useStartTLS.addLongIdentifier("use-start-tls", true);
        }
        parser.addArgument(this.useStartTLS);
        String defaultTrustArgDesc = InternalSDKHelper.getPingIdentityServerRoot() != null ? UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_DEFAULT_TRUST_WITH_PING_DS.get() : UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_DEFAULT_TRUST_WITHOUT_PING_DS.get();
        this.defaultTrust = new BooleanArgument(null, "defaultTrust", 1, defaultTrustArgDesc);
        this.defaultTrust.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.defaultTrust.addLongIdentifier("default-trust", true);
            this.defaultTrust.addLongIdentifier("useDefaultTrust", true);
            this.defaultTrust.addLongIdentifier("use-default-trust", true);
        }
        parser.addArgument(this.defaultTrust);
        this.trustAll = new BooleanArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('X')), "trustAll", 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_ALL.get());
        this.trustAll.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.trustAll.addLongIdentifier("trustAllCertificates", true);
            this.trustAll.addLongIdentifier("trust-all", true);
            this.trustAll.addLongIdentifier("trust-all-certificates", true);
        }
        parser.addArgument(this.trustAll);
        this.keyStorePath = new StringArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('K')), "keyStorePath", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PATH.get());
        this.keyStorePath.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.keyStorePath.addLongIdentifier("key-store-path", true);
        }
        parser.addArgument(this.keyStorePath);
        this.keyStorePassword = new StringArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('W')), "keyStorePassword", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PASSWORD.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PASSWORD.get());
        this.keyStorePassword.setSensitive(true);
        this.keyStorePassword.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.keyStorePassword.addLongIdentifier("keyStorePIN", true);
            this.keyStorePassword.addLongIdentifier("key-store-password", true);
            this.keyStorePassword.addLongIdentifier("key-store-pin", true);
        }
        parser.addArgument(this.keyStorePassword);
        this.keyStorePasswordFile = new FileArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('u')), "keyStorePasswordFile", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PASSWORD_FILE.get());
        this.keyStorePasswordFile.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.keyStorePasswordFile.addLongIdentifier("keyStorePINFile", true);
            this.keyStorePasswordFile.addLongIdentifier("key-store-password-file", true);
            this.keyStorePasswordFile.addLongIdentifier("key-store-pin-file", true);
        }
        parser.addArgument(this.keyStorePasswordFile);
        this.promptForKeyStorePassword = new BooleanArgument(null, "promptForKeyStorePassword", 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PASSWORD_PROMPT.get());
        this.promptForKeyStorePassword.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.promptForKeyStorePassword.addLongIdentifier("promptForKeyStorePIN", true);
            this.promptForKeyStorePassword.addLongIdentifier("prompt-for-key-store-password", true);
            this.promptForKeyStorePassword.addLongIdentifier("prompt-for-key-store-pin", true);
        }
        parser.addArgument(this.promptForKeyStorePassword);
        this.keyStoreFormat = new StringArgument(null, "keyStoreFormat", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_FORMAT.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_FORMAT.get());
        this.keyStoreFormat.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.keyStoreFormat.addLongIdentifier("keyStoreType", true);
            this.keyStoreFormat.addLongIdentifier("key-store-format", true);
            this.keyStoreFormat.addLongIdentifier("key-store-type", true);
        }
        parser.addArgument(this.keyStoreFormat);
        this.trustStorePath = new StringArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('P')), "trustStorePath", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PATH.get());
        this.trustStorePath.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.trustStorePath.addLongIdentifier("trust-store-path", true);
        }
        parser.addArgument(this.trustStorePath);
        this.trustStorePassword = new StringArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('T')), "trustStorePassword", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PASSWORD.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD.get());
        this.trustStorePassword.setSensitive(true);
        this.trustStorePassword.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.trustStorePassword.addLongIdentifier("trustStorePIN", true);
            this.trustStorePassword.addLongIdentifier("trust-store-password", true);
            this.trustStorePassword.addLongIdentifier("trust-store-pin", true);
        }
        parser.addArgument(this.trustStorePassword);
        this.trustStorePasswordFile = new FileArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('U')), "trustStorePasswordFile", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD_FILE.get());
        this.trustStorePasswordFile.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.trustStorePasswordFile.addLongIdentifier("trustStorePINFile", true);
            this.trustStorePasswordFile.addLongIdentifier("trust-store-password-file", true);
            this.trustStorePasswordFile.addLongIdentifier("trust-store-pin-file", true);
        }
        parser.addArgument(this.trustStorePasswordFile);
        this.promptForTrustStorePassword = new BooleanArgument(null, "promptForTrustStorePassword", 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD_PROMPT.get());
        this.promptForTrustStorePassword.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.promptForTrustStorePassword.addLongIdentifier("promptForTrustStorePIN", true);
            this.promptForTrustStorePassword.addLongIdentifier("prompt-for-trust-store-password", true);
            this.promptForTrustStorePassword.addLongIdentifier("prompt-for-trust-store-pin", true);
        }
        parser.addArgument(this.promptForTrustStorePassword);
        this.trustStoreFormat = new StringArgument(null, "trustStoreFormat", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_FORMAT.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_FORMAT.get());
        this.trustStoreFormat.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.trustStoreFormat.addLongIdentifier("trustStoreType", true);
            this.trustStoreFormat.addLongIdentifier("trust-store-format", true);
            this.trustStoreFormat.addLongIdentifier("trust-store-type", true);
        }
        parser.addArgument(this.trustStoreFormat);
        this.verifyCertificateHostnames = new BooleanArgument(null, "verifyCertificateHostnames", 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_VERIFY_CERT_HOSTNAMES.get());
        this.verifyCertificateHostnames.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.verifyCertificateHostnames.addLongIdentifier("verifyCertificateHostname", true);
            this.verifyCertificateHostnames.addLongIdentifier("validateCertificateHostname", true);
            this.verifyCertificateHostnames.addLongIdentifier("validateCertificateHostnames", true);
            this.verifyCertificateHostnames.addLongIdentifier("verify-certificate-hostnames", true);
            this.verifyCertificateHostnames.addLongIdentifier("verify-certificate-hostname", true);
            this.verifyCertificateHostnames.addLongIdentifier("validate-certificate-hostnames", true);
            this.verifyCertificateHostnames.addLongIdentifier("validate-certificate-hostname", true);
        }
        parser.addArgument(this.verifyCertificateHostnames);
        this.certificateNickname = new StringArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('N')), "certNickname", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_CERT_NICKNAME.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_CERT_NICKNAME.get());
        this.certificateNickname.setArgumentGroupName(argumentGroup);
        if (this.includeAlternateLongIdentifiers()) {
            this.certificateNickname.addLongIdentifier("certificateNickname", true);
            this.certificateNickname.addLongIdentifier("cert-nickname", true);
            this.certificateNickname.addLongIdentifier("certificate-nickname", true);
        }
        parser.addArgument(this.certificateNickname);
        if (this.supportsSSLDebugging()) {
            this.enableSSLDebugging = new BooleanArgument(null, "enableSSLDebugging", 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_ENABLE_SSL_DEBUGGING.get());
            this.enableSSLDebugging.setArgumentGroupName(argumentGroup);
            if (this.includeAlternateLongIdentifiers()) {
                this.enableSSLDebugging.addLongIdentifier("enableTLSDebugging", true);
                this.enableSSLDebugging.addLongIdentifier("enableStartTLSDebugging", true);
                this.enableSSLDebugging.addLongIdentifier("enable-ssl-debugging", true);
                this.enableSSLDebugging.addLongIdentifier("enable-tls-debugging", true);
                this.enableSSLDebugging.addLongIdentifier("enable-starttls-debugging", true);
                this.enableSSLDebugging.addLongIdentifier("enable-start-tls-debugging", true);
            }
            parser.addArgument(this.enableSSLDebugging);
            this.addEnableSSLDebuggingArgument(this.enableSSLDebugging);
        }
        if (supportsAuthentication) {
            this.saslOption = new StringArgument(this.getShortIdentifierIfNotSuppressed(Character.valueOf('o')), "saslOption", false, 0, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_SASL_OPTION.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_SASL_OPTION.get());
            this.saslOption.setArgumentGroupName(argumentGroup);
            if (this.includeAlternateLongIdentifiers()) {
                this.saslOption.addLongIdentifier("sasl-option", true);
            }
            parser.addArgument(this.saslOption);
            this.useSASLExternal = new BooleanArgument(null, "useSASLExternal", 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_USE_SASL_EXTERNAL.get());
            this.useSASLExternal.setArgumentGroupName(argumentGroup);
            if (this.includeAlternateLongIdentifiers()) {
                this.useSASLExternal.addLongIdentifier("use-sasl-external", true);
            }
            parser.addArgument(this.useSASLExternal);
            if (this.supportsSASLHelp()) {
                this.helpSASL = new BooleanArgument(null, "helpSASL", UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_HELP_SASL.get());
                this.helpSASL.setArgumentGroupName(argumentGroup);
                if (this.includeAlternateLongIdentifiers()) {
                    this.helpSASL.addLongIdentifier("help-sasl", true);
                }
                this.helpSASL.setUsageArgument(true);
                parser.addArgument(this.helpSASL);
                this.setHelpSASLArgument(this.helpSASL);
            }
        }
        parser.addExclusiveArgumentSet(this.useSSL, this.useStartTLS, new Argument[0]);
        parser.addExclusiveArgumentSet(this.keyStorePassword, this.keyStorePasswordFile, this.promptForKeyStorePassword);
        parser.addExclusiveArgumentSet(this.trustStorePassword, this.trustStorePasswordFile, this.promptForTrustStorePassword);
        parser.addExclusiveArgumentSet(this.defaultTrust, this.trustAll, new Argument[0]);
        parser.addExclusiveArgumentSet(this.trustAll, this.trustStorePath, new Argument[0]);
        parser.addDependentArgumentSet(this.keyStorePassword, this.keyStorePath, new Argument[0]);
        parser.addDependentArgumentSet(this.keyStorePasswordFile, this.keyStorePath, new Argument[0]);
        parser.addDependentArgumentSet(this.promptForKeyStorePassword, this.keyStorePath, new Argument[0]);
        parser.addDependentArgumentSet(this.trustStorePassword, this.trustStorePath, new Argument[0]);
        parser.addDependentArgumentSet(this.trustStorePasswordFile, this.trustStorePath, new Argument[0]);
        parser.addDependentArgumentSet(this.promptForTrustStorePassword, this.trustStorePath, new Argument[0]);
        parser.addDependentArgumentSet(this.keyStorePath, this.useSSL, this.useStartTLS);
        parser.addDependentArgumentSet(this.trustStorePath, this.useSSL, this.useStartTLS);
        parser.addDependentArgumentSet(this.defaultTrust, this.useSSL, this.useStartTLS);
        parser.addDependentArgumentSet(this.trustAll, this.useSSL, this.useStartTLS);
        if (supportsAuthentication) {
            if (!this.defaultToPromptForBindPassword()) {
                parser.addDependentArgumentSet(this.bindDN, this.bindPassword, this.bindPasswordFile, this.promptForBindPassword);
            }
            parser.addExclusiveArgumentSet(this.bindDN, this.saslOption, this.useSASLExternal);
            parser.addExclusiveArgumentSet(this.bindPassword, this.bindPasswordFile, this.promptForBindPassword);
            parser.addDependentArgumentSet(this.bindPassword, this.bindDN, this.saslOption);
            parser.addDependentArgumentSet(this.bindPasswordFile, this.bindDN, this.saslOption);
            parser.addDependentArgumentSet(this.promptForBindPassword, this.bindDN, this.saslOption);
        }
        this.addNonLDAPArguments(parser);
    }

    public abstract void addNonLDAPArguments(@NotNull ArgumentParser var1) throws ArgumentException;

    @Override
    public final void doExtendedArgumentValidation() throws ArgumentException {
        if ((this.host.getValues().size() > 1 || this.port.getValues().size() > 1) && this.host.getValues().size() != this.port.getValues().size()) {
            throw new ArgumentException(UtilityMessages.ERR_LDAP_TOOL_HOST_PORT_COUNT_MISMATCH.get(this.host.getLongIdentifier(), this.port.getLongIdentifier()));
        }
        this.doExtendedNonLDAPArgumentValidation();
    }

    protected boolean supportsAuthentication() {
        return true;
    }

    protected boolean defaultToPromptForBindPassword() {
        return false;
    }

    protected boolean supportsSASLHelp() {
        return true;
    }

    protected boolean includeAlternateLongIdentifiers() {
        return false;
    }

    @Nullable
    protected List<Control> getBindControls() {
        return null;
    }

    protected boolean supportsMultipleServers() {
        return false;
    }

    protected boolean supportsSSLDebugging() {
        return false;
    }

    public void doExtendedNonLDAPArgumentValidation() throws ArgumentException {
    }

    @NotNull
    public LDAPConnectionOptions getConnectionOptions() {
        return new LDAPConnectionOptions();
    }

    @NotNull
    protected final LDAPConnectionOptions getConnectionOptionsWithRequestedSettings() {
        LDAPConnectionOptions options = this.getConnectionOptions().duplicate();
        if (this.verifyCertificateHostnames.isPresent()) {
            options.setSSLSocketVerifier(new HostNameSSLSocketVerifier(true));
        }
        return options;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    @NotNull
    public final LDAPConnection getConnection() throws LDAPException {
        LDAPConnection connection = this.getUnauthenticatedConnection();
        try {
            if (this.bindRequest != null) {
                connection.bind(this.bindRequest);
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            connection.close();
            throw le;
        }
        return connection;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    @NotNull
    public final LDAPConnection getUnauthenticatedConnection() throws LDAPException {
        if (this.serverSet == null) {
            this.serverSet = this.createServerSet();
            this.bindRequest = this.createBindRequest();
        }
        LDAPConnection connection = this.serverSet.getConnection();
        if (this.useStartTLS.isPresent()) {
            try {
                ExtendedResult extendedResult = connection.processExtendedOperation(new StartTLSExtendedRequest(this.startTLSSocketFactory));
                if (!extendedResult.getResultCode().equals(ResultCode.SUCCESS)) {
                    throw new LDAPException(extendedResult.getResultCode(), UtilityMessages.ERR_LDAP_TOOL_START_TLS_FAILED.get(extendedResult.getDiagnosticMessage()));
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                connection.close();
                throw le;
            }
        }
        return connection;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    @NotNull
    public final LDAPConnectionPool getConnectionPool(int initialConnections, int maxConnections) throws LDAPException {
        return this.getConnectionPool(initialConnections, maxConnections, 1, null, null, true, null);
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    @NotNull
    public final LDAPConnectionPool getConnectionPool(int initialConnections, int maxConnections, int initialConnectThreads, @Nullable PostConnectProcessor beforeStartTLSProcessor, @Nullable PostConnectProcessor afterStartTLSProcessor, boolean throwOnConnectFailure, @Nullable LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        PostConnectProcessor postConnectProcessor;
        if (this.serverSet == null) {
            this.serverSet = this.createServerSet();
            this.bindRequest = this.createBindRequest();
        }
        ArrayList<PostConnectProcessor> pcpList = new ArrayList<PostConnectProcessor>(3);
        if (beforeStartTLSProcessor != null) {
            pcpList.add(beforeStartTLSProcessor);
        }
        if (this.useStartTLS.isPresent()) {
            pcpList.add(new StartTLSPostConnectProcessor(this.startTLSSocketFactory));
        }
        if (afterStartTLSProcessor != null) {
            pcpList.add(afterStartTLSProcessor);
        }
        switch (pcpList.size()) {
            case 0: {
                postConnectProcessor = null;
                break;
            }
            case 1: {
                postConnectProcessor = (PostConnectProcessor)pcpList.get(0);
                break;
            }
            default: {
                postConnectProcessor = new AggregatePostConnectProcessor(pcpList);
            }
        }
        return new LDAPConnectionPool(this.serverSet, this.bindRequest, initialConnections, maxConnections, initialConnectThreads, postConnectProcessor, throwOnConnectFailure, healthCheck);
    }

    @NotNull
    public ServerSet createServerSet() throws LDAPException {
        SSLUtil sslUtil = this.createSSLUtil();
        SSLSocketFactory socketFactory = null;
        if (this.useSSL.isPresent()) {
            try {
                socketFactory = sslUtil.createSSLSocketFactory();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_CREATE_SSL_SOCKET_FACTORY.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        if (this.useStartTLS.isPresent()) {
            try {
                this.startTLSSocketFactory = sslUtil.createSSLSocketFactory();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_CREATE_SSL_SOCKET_FACTORY.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        if (this.host.getValues().size() == 1) {
            return new SingleServerSet(this.host.getValue(), this.port.getValue(), socketFactory, this.getConnectionOptionsWithRequestedSettings());
        }
        List<String> hostList = this.host.getValues();
        List<Integer> portList = this.port.getValues();
        String[] hosts = new String[hostList.size()];
        int[] ports = new int[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = hostList.get(i);
            ports[i] = portList.get(i);
        }
        return new RoundRobinServerSet(hosts, ports, socketFactory, this.getConnectionOptionsWithRequestedSettings());
    }

    @Nullable
    public SSLUtil createSSLUtil() throws LDAPException {
        return this.createSSLUtil(false);
    }

    @Nullable
    public SSLUtil createSSLUtil(boolean force) throws LDAPException {
        if (force || this.useSSL.isPresent() || this.useStartTLS.isPresent()) {
            TrustManager tm;
            WrapperKeyManager keyManager = null;
            if (this.keyStorePath.isPresent()) {
                char[] pw = null;
                if (this.keyStorePassword.isPresent()) {
                    pw = this.keyStorePassword.getValue().toCharArray();
                } else if (this.keyStorePasswordFile.isPresent()) {
                    try {
                        pw = this.getPasswordFileReader().readPassword(this.keyStorePasswordFile.getValue());
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_READ_KEY_STORE_PASSWORD.get(StaticUtils.getExceptionMessage(e)), e);
                    }
                } else if (this.promptForKeyStorePassword.isPresent()) {
                    this.getOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_KEY_STORE_PASSWORD.get());
                    pw = StaticUtils.toUTF8String(PasswordReader.readPassword()).toCharArray();
                    this.getOut().println();
                }
                try {
                    keyManager = this.keyStoreFormat.isPresent() && this.keyStoreFormat.getValue().equalsIgnoreCase("PKCS11") ? new PKCS11KeyManager(null, new File(this.keyStorePath.getValue()), null, pw, this.certificateNickname.getValue()) : new KeyStoreKeyManager(this.keyStorePath.getValue(), pw, this.keyStoreFormat.getValue(), this.certificateNickname.getValue(), true);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_CREATE_KEY_MANAGER.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
            if (this.trustAll.isPresent()) {
                tm = new TrustAllTrustManager(false);
            } else if (this.trustStorePath.isPresent()) {
                char[] pw = null;
                if (this.trustStorePassword.isPresent()) {
                    pw = this.trustStorePassword.getValue().toCharArray();
                } else if (this.trustStorePasswordFile.isPresent()) {
                    try {
                        pw = this.getPasswordFileReader().readPassword(this.trustStorePasswordFile.getValue());
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_READ_TRUST_STORE_PASSWORD.get(StaticUtils.getExceptionMessage(e)), e);
                    }
                } else if (this.promptForTrustStorePassword.isPresent()) {
                    this.getOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_TRUST_STORE_PASSWORD.get());
                    pw = StaticUtils.toUTF8String(PasswordReader.readPassword()).toCharArray();
                    this.getOut().println();
                }
                TrustStoreTrustManager trustStoreTrustManager = new TrustStoreTrustManager(this.trustStorePath.getValue(), pw, this.trustStoreFormat.getValue(), true);
                tm = this.defaultTrust.isPresent() ? InternalSDKHelper.getPreferredNonInteractiveTrustManagerChain(trustStoreTrustManager) : trustStoreTrustManager;
            } else if (this.defaultTrust.isPresent()) {
                tm = InternalSDKHelper.getPreferredNonInteractiveTrustManagerChain(new X509TrustManager[0]);
            } else if (this.promptTrustManager.get() != null) {
                tm = this.promptTrustManager.get();
            } else {
                AggregateTrustManager atm;
                ArrayList<String> expectedAddresses = new ArrayList<String>(5);
                if (this.useSSL.isPresent() || this.useStartTLS.isPresent()) {
                    expectedAddresses.addAll(this.host.getValues());
                }
                tm = this.promptTrustManager.compareAndSet(null, atm = InternalSDKHelper.getPreferredPromptTrustManagerChain(expectedAddresses)) ? atm : (TrustManager)this.promptTrustManager.get();
            }
            return new SSLUtil(keyManager, tm);
        }
        return null;
    }

    @Nullable
    public BindRequest createBindRequest() throws LDAPException {
        byte[] pw;
        Control[] bindControls;
        if (!this.supportsAuthentication()) {
            return null;
        }
        List<Control> bindControlList = this.getBindControls();
        if (bindControlList == null || bindControlList.isEmpty()) {
            bindControls = StaticUtils.NO_CONTROLS;
        } else {
            bindControls = new Control[bindControlList.size()];
            bindControlList.toArray(bindControls);
        }
        if (this.bindPassword.isPresent()) {
            pw = StaticUtils.getBytes(this.bindPassword.getValue());
        } else if (this.bindPasswordFile.isPresent()) {
            try {
                char[] pwChars = this.getPasswordFileReader().readPassword(this.bindPasswordFile.getValue());
                pw = StaticUtils.getBytes(new String(pwChars));
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_READ_BIND_PASSWORD.get(StaticUtils.getExceptionMessage(e)), e);
            }
        } else if (this.promptForBindPassword.isPresent()) {
            this.getOriginalOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_BIND_PASSWORD.get());
            pw = PasswordReader.readPassword();
            this.getOriginalOut().println();
        } else {
            pw = null;
        }
        if (this.saslOption.isPresent()) {
            String dnStr = this.bindDN.isPresent() ? this.bindDN.getValue().toString() : null;
            return SASLUtils.createBindRequest(dnStr, pw, this.defaultToPromptForBindPassword(), this, null, this.saslOption.getValues(), bindControls);
        }
        if (this.useSASLExternal.isPresent()) {
            return new EXTERNALBindRequest(bindControls);
        }
        if (this.bindDN.isPresent()) {
            if (pw == null && !this.bindDN.getValue().isNullDN() && this.defaultToPromptForBindPassword()) {
                this.getOriginalOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_BIND_PASSWORD.get());
                pw = PasswordReader.readPassword();
                this.getOriginalOut().println();
            }
            return new SimpleBindRequest(this.bindDN.getValue(), pw, bindControls);
        }
        return null;
    }

    public final boolean anyLDAPArgumentsProvided() {
        return LDAPCommandLineTool.isAnyPresent(this.host, this.port, this.bindDN, this.bindPassword, this.bindPasswordFile, this.promptForBindPassword, this.useSSL, this.useStartTLS, this.trustAll, this.keyStorePath, this.keyStorePassword, this.keyStorePasswordFile, this.promptForKeyStorePassword, this.keyStoreFormat, this.trustStorePath, this.trustStorePassword, this.trustStorePasswordFile, this.trustStoreFormat, this.certificateNickname, this.saslOption, this.useSASLExternal);
    }

    private static boolean isAnyPresent(Argument ... args) {
        for (Argument a : args) {
            if (a == null || a.getNumOccurrences() <= 0) continue;
            return true;
        }
        return false;
    }
}

