# Tencent is pleased to support the open source community by making ncnn available.
#
# Copyright (C) 2024 THL A29 Limited, a Tencent company. All rights reserved.
#
# Licensed under the BSD 3-Clause License (the "License"); you may not use this file except
# in compliance with the License. You may obtain a copy of the License at
#
# https://opensource.org/licenses/BSD-3-Clause
#
# Unless required by applicable law or agreed to in writing, software distributed
# under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
# CONDITIONS OF ANY KIND, either express or implied. See the License for the
# specific language governing permissions and limitations under the License.

import torch
import torch.nn as nn
import torch.nn.functional as F

class Model(nn.Module):
    def __init__(self):
        super(Model, self).__init__()

        self.gn_0 = nn.GroupNorm(num_groups=4, num_channels=12)
        self.gn_0.weight = nn.Parameter(torch.rand(12))
        self.gn_0.bias = nn.Parameter(torch.rand(12))
        self.gn_1 = nn.GroupNorm(num_groups=12, num_channels=12, eps=1e-2, affine=False)
        self.gn_2 = nn.GroupNorm(num_groups=1, num_channels=12, eps=1e-4, affine=True)
        self.gn_2.weight = nn.Parameter(torch.rand(12))
        self.gn_2.bias = nn.Parameter(torch.rand(12))

    def forward(self, x, y, z):
        x = self.gn_0(x)
        x = self.gn_1(x)
        x = self.gn_2(x)

        y = self.gn_0(y)
        y = self.gn_1(y)
        y = self.gn_2(y)

        z = self.gn_0(z)
        z = self.gn_1(z)
        z = self.gn_2(z)
        return x, y, z

def test():
    net = Model()
    net.eval()

    torch.manual_seed(0)
    x = torch.rand(1, 12, 64)
    y = torch.rand(1, 12, 24, 64)
    z = torch.rand(1, 12, 24, 32, 64)

    a0, a1, a2 = net(x, y, z)

    # export onnx
    torch.onnx.export(net, (x, y, z), "test_nn_GroupNorm.onnx")

    # onnx to pnnx
    import os
    os.system("../../src/pnnx test_nn_GroupNorm.onnx inputshape=[1,12,64],[1,12,24,64],[1,12,24,32,64]")

    # pnnx inference
    import test_nn_GroupNorm_pnnx
    b0, b1, b2 = test_nn_GroupNorm_pnnx.test_inference()

    return torch.allclose(a0, b0, 1e-4, 1e-4) and torch.allclose(a1, b1, 1e-4, 1e-4) and torch.allclose(a2, b2, 1e-4, 1e-4)

if __name__ == "__main__":
    if test():
        exit(0)
    else:
        exit(1)
