// Copyright (c) ppy Pty Ltd <contact@ppy.sh>. Licensed under the MIT Licence.
// See the LICENCE file in the repository root for full licence text.

namespace osu.Game.Rulesets.Catch.Skinning
{
    public enum CatchSkinColour
    {
        /// <summary>
        /// The colour to be used for the catcher while in hyper-dashing state.
        /// </summary>
        HyperDash,

        /// <summary>
        /// The colour to be used for fruits that grant the catcher the ability to hyper-dash.
        /// </summary>
        HyperDashFruit,

        /// <summary>
        /// The colour to be used for the "exploding" catcher sprite on beginning of hyper-dashing.
        /// </summary>
        HyperDashAfterImage,
    }
}
