/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.websocket.audio.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.openhab.core.audio.AudioDialogProvider;
import org.openhab.core.audio.AudioSink;
import org.openhab.core.audio.AudioSource;
import org.openhab.core.io.websocket.audio.internal.PCMWebSocketAdapter;
import org.openhab.core.io.websocket.audio.internal.PCMWebSocketAudioSink;
import org.openhab.core.io.websocket.audio.internal.PCMWebSocketAudioSource;
import org.openhab.core.io.websocket.audio.internal.PCMWebSocketStreamIdUtil;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
@NonNullByDefault
public class PCMWebSocketConnection
implements WebSocketListener {
    private final Logger logger = LoggerFactory.getLogger(PCMWebSocketConnection.class);
    protected final Map<String, ServiceRegistration<?>> audioComponentRegistrations = new ConcurrentHashMap();
    private volatile @Nullable Session session;
    private @Nullable RemoteEndpoint remote;
    private final PCMWebSocketAdapter wsAdapter;
    private final ScheduledExecutorService executor;
    private @Nullable ScheduledFuture<?> scheduledDisconnection;
    private boolean initialized = false;
    private @Nullable Runnable dialogTrigger = null;
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private String id = "";
    private @Nullable PCMWebSocketAudioSource audioSource = null;

    public PCMWebSocketConnection(PCMWebSocketAdapter wsAdapter, ScheduledExecutorService executor) {
        this.wsAdapter = wsAdapter;
        this.executor = executor;
    }

    public void sendAudio(byte[] id, byte[] b) {
        try {
            RemoteEndpoint remote = this.getRemote();
            if (remote != null) {
                ByteBuffer buff = ByteBuffer.wrap(new byte[id.length + b.length]);
                buff.put(id);
                buff.put(b);
                remote.sendBytesByFuture(ByteBuffer.wrap(buff.array()));
            }
        }
        catch (IllegalStateException ignored) {
            this.logger.warn("Unable to send audio buffer");
        }
    }

    public void setListening(boolean listening) {
        this.sendClientCommand(new WebSocketCommand(listening ? WebSocketCommand.OutputCommands.START_LISTENING : WebSocketCommand.OutputCommands.STOP_LISTENING));
    }

    public void disconnect() {
        Session session = this.getSession();
        if (session != null) {
            try {
                session.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void onWebSocketConnect(@Nullable Session sess) {
        if (sess == null) {
            return;
        }
        this.session = sess;
        this.remote = sess.getRemote();
        this.logger.debug("New client connected.");
        this.scheduledDisconnection = this.executor.schedule(() -> {
            try {
                sess.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, 5L, TimeUnit.SECONDS);
    }

    private <T extends WebSocketCommand> void sendClientCommand(T msg) {
        RemoteEndpoint remote = this.getRemote();
        if (remote != null) {
            try {
                remote.sendStringByFuture(new ObjectMapper().writeValueAsString(msg));
            }
            catch (JsonProcessingException e) {
                this.logger.warn("JsonProcessingException writing JSON message", (Throwable)e);
            }
        }
    }

    public void onWebSocketBinary(byte @Nullable [] payload, int offset, int len) {
        this.logger.trace("Received binary data of length {}", (Object)len);
        PCMWebSocketAudioSource audioSource = this.audioSource;
        if (payload != null && audioSource != null) {
            PCMWebSocketStreamIdUtil.AudioPacketData streamData;
            try {
                streamData = PCMWebSocketStreamIdUtil.parseAudioPacket(payload);
            }
            catch (IOException e) {
                this.logger.warn("Exception processing binary message: {}", (Object)e.getMessage());
                return;
            }
            audioSource.writeToStreams(streamData.id(), streamData.sampleRate(), streamData.bitDepth(), streamData.channels(), streamData.audioData());
        }
    }

    public void onWebSocketText(@Nullable String message) {
        try {
            JsonNode rootMessageNode = this.jsonMapper.readTree(message);
            if (rootMessageNode.has("cmd")) {
                String cmd = rootMessageNode.get("cmd").asText().trim().toUpperCase();
                try {
                    this.logger.debug("Handling msg '{}'", (Object)cmd);
                    WebSocketCommand.InputCommands messageType = WebSocketCommand.InputCommands.valueOf(cmd);
                    switch (messageType) {
                        case INITIALIZE: {
                            this.wsAdapter.onSpeakerConnected(this);
                            JsonNode argsNode = rootMessageNode.get("args");
                            ConnectionOptions clientOptions = (ConnectionOptions)this.jsonMapper.treeToValue((TreeNode)argsNode, ConnectionOptions.class);
                            ScheduledFuture<?> scheduledDisconnection = this.scheduledDisconnection;
                            if (scheduledDisconnection != null) {
                                scheduledDisconnection.cancel(true);
                            }
                            this.id = clientOptions.id;
                            this.registerSpeakerComponents(this.id, clientOptions);
                            this.sendClientCommand(new WebSocketCommand(WebSocketCommand.OutputCommands.INITIALIZED));
                            break;
                        }
                        case ON_SPOT: {
                            this.onRemoteSpot();
                        }
                    }
                }
                catch (IOException | IllegalStateException e) {
                    this.logger.warn("Error handing command '{}' with message: {}. Disconnecting client", (Object)cmd, (Object)e.getMessage());
                    this.disconnect();
                }
            }
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Exception parsing JSON message.", (Throwable)e);
            this.logger.warn("Disconnecting client.");
            this.disconnect();
        }
    }

    public void onWebSocketError(@Nullable Throwable cause) {
        this.logger.warn("WebSocket Error", cause);
    }

    public void onWebSocketClose(int statusCode, @Nullable String reason) {
        this.session = null;
        this.remote = null;
        this.logger.debug("Session closed with code {}: {}", (Object)statusCode, (Object)reason);
        this.wsAdapter.onClientDisconnected(this);
        this.unregisterSpeakerComponents(this.id);
    }

    public void setSinkVolume(int value) {
        if (this.initialized) {
            this.sendClientCommand(new WebSocketCommand(WebSocketCommand.OutputCommands.SINK_VOLUME, Map.of("value", value)));
        }
    }

    public void setSourceVolume(int value) {
        if (this.initialized) {
            this.sendClientCommand(new WebSocketCommand(WebSocketCommand.OutputCommands.SOURCE_VOLUME, Map.of("value", value)));
        }
    }

    public @Nullable RemoteEndpoint getRemote() {
        return this.remote;
    }

    public @Nullable Session getSession() {
        return this.session;
    }

    public boolean isConnected() {
        Session sess = this.session;
        return sess != null && sess.isOpen();
    }

    private synchronized void registerSpeakerComponents(String id, ConnectionOptions clientOptions) throws IOException {
        if (id.isBlank()) {
            throw new IOException("Unable to register audio components");
        }
        String label = "PCM Audio WebSocket (" + id + ")";
        this.logger.debug("Registering dialog components for '{}'", (Object)id);
        this.initialized = true;
        PCMWebSocketAudioSource audioSource = this.audioSource = new PCMWebSocketAudioSource(this.getSourceId(id), label, this);
        this.logger.debug("Registering audio source {}", (Object)this.audioSource.getId());
        this.audioComponentRegistrations.put(this.audioSource.getId(), this.wsAdapter.bundleContext.registerService(AudioSource.class.getName(), (Object)this.audioSource, new Hashtable()));
        PCMWebSocketAudioSink audioSink = new PCMWebSocketAudioSink(this.getSinkId(id), label, this, clientOptions.forceSampleRate, clientOptions.forceBitDepth, clientOptions.forceChannels);
        this.logger.debug("Registering audio sink {}", (Object)audioSink.getId());
        this.audioComponentRegistrations.put(audioSink.getId(), this.wsAdapter.bundleContext.registerService(AudioSink.class.getName(), (Object)audioSink, new Hashtable()));
        if (clientOptions.startDialog) {
            AudioDialogProvider dialogProvider = this.wsAdapter.audioDialogProvider;
            if (dialogProvider == null) {
                throw new IOException("Voice functionality is not ready");
            }
            this.dialogTrigger = dialogProvider.startDialog((AudioSink)audioSink, (AudioSource)audioSource, !clientOptions.locationItem.isBlank() ? clientOptions.locationItem : null, !clientOptions.listeningItem.isBlank() ? clientOptions.listeningItem : null, () -> this.disconnect());
        } else {
            this.dialogTrigger = null;
        }
    }

    private synchronized void unregisterSpeakerComponents(String id) {
        ServiceRegistration<?> sinkReg;
        AudioSink sink;
        ServiceRegistration<?> sourceReg;
        this.initialized = false;
        this.dialogTrigger = null;
        AudioSource source = this.wsAdapter.audioManager.getSource(this.getSourceId(id));
        if (source instanceof PCMWebSocketAudioSource) {
            PCMWebSocketAudioSource hsAudioSource = (PCMWebSocketAudioSource)source;
            try {
                hsAudioSource.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (source != null && (sourceReg = this.audioComponentRegistrations.remove(source.getId())) != null) {
            this.logger.debug("Unregistering audio source {}", (Object)source.getId());
            sourceReg.unregister();
        }
        if ((sink = this.wsAdapter.audioManager.getSink(this.getSinkId(id))) != null && (sinkReg = this.audioComponentRegistrations.remove(sink.getId())) != null) {
            this.logger.debug("Unregistering audio sink {}", (Object)sink.getId());
            sinkReg.unregister();
        }
    }

    private void onRemoteSpot() {
        Runnable dialogTrigger = this.dialogTrigger;
        if (dialogTrigger != null) {
            dialogTrigger.run();
        }
    }

    private String getSinkId(String id) {
        return "pcm::" + id + "::sink";
    }

    private String getSourceId(String id) {
        return "pcm::" + id + "::source";
    }

    public String getId() {
        return this.id;
    }

    public static class ConnectionOptions {
        public String id = "";
        public @Nullable Integer forceSampleRate;
        public @Nullable Integer forceBitDepth;
        public @Nullable Integer forceChannels;
        public boolean startDialog = false;
        public String listeningItem = "";
        public String locationItem = "";
    }

    private static class WebSocketCommand {
        public String cmd = "";
        public Map<String, Object> args;

        public WebSocketCommand(OutputCommands cmd) {
            this(cmd, new HashMap<String, Object>());
        }

        public WebSocketCommand(OutputCommands cmd, Map<String, Object> args) {
            this.cmd = cmd.name();
            this.args = args;
        }

        public static enum InputCommands {
            INITIALIZE,
            ON_SPOT;

        }

        public static enum OutputCommands {
            INITIALIZED,
            START_LISTENING,
            STOP_LISTENING,
            SINK_VOLUME,
            SOURCE_VOLUME;

        }
    }
}

