# -*- coding: utf-8 -*-

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.

from gallery_dl.extractor import mangafire


__tests__ = (
{
    "#url"     : "https://mangafire.to/read/moto-saikyou-yuusha-no-saishuushoku.qzq9j/en/chapter-4",
    "#class"   : mangafire.MangafireChapterExtractor,
    "#pattern" : r"https://20l\.mfcdn2\.xyz/mf/\w+/h/p\.jpg",
    "#count"   : 37,

    "chapter"       : 4,
    "chapter_id"    : 4276231,
    "chapter_minor" : "",
    "chapter_string": "chapter-4",
    "count"         : 37,
    "page"          : range(1, 37),
    "cover"         : "https://static.mfcdn.cc/1d8c/i/c/f7/3ff94f3785fab893354f9d0ca440b59f.jpg",
    "description"   : "Dan was \"the strongest and bravest\" when he was young. But because of his lazy life, he is now a divorced, unemployed old man! He tries to earn money through quests for a living, but age has taken its toll on his strength and all that! He was approached by a silver-haired elf, a handsome man, and an S-rank adventurer... a young man of today’s generation!",
    "extension"     : "jpg",
    "filename"      : "p",
    "lang"          : "en",
    "manga"         : "Re-Employment of the Former Strongest Hero",
    "manga_id"      : "qzq9j",
    "manga_slug"    : "moto-saikyou-yuusha-no-saishuushoku",
    "published"     : "Mar 31, 2022 to ?",
    "publisher"     : ["Wild Hero's"],
    "score"         : float,
    "status"        : "Releasing",
    "title"         : "The Former Strongest Hero Makes a Choice",
    "type"          : "Manga",
    "author"        : [
        "Nobuto Hagio",
        "Hironori Akutsu",
    ],
    "manga_titles"  : [
        "Moto Saikyou Yuusha no Saishuushoku",
        "Re-Employment of the Former Strongest Hero",
    ],
    "tags"          : [
        "Action",
        "Comedy",
        "Adventure",
        "Fantasy",
        "Seinen",
    ],
},

{
    "#url"     : "https://mangafire.to/read/munou-wa-fuyou-to-iware-tokei-tsukai-no-boku-wa-shokuin-guild-kara-oidasareru-mo-dungeon-no-shinbu-de-shin-no-chikara-ni-kakusei-suru-the-comic.6wmv9/en/chapter-14.1",
    "#class"   : mangafire.MangafireChapterExtractor,
    "#pattern" : r"https://\w+\.mfcdn\d\.xyz/mf/\w+/h/p\.jpg",
    "#count"   : 13,

    "chapter"       : 14,
    "chapter_id"    : 4765506,
    "chapter_minor" : ".1",
    "chapter_string": "chapter-14.1",
    "count"         : 13,
    "page"          : range(1, 13),
    "cover"         : "https://static.mfcdn.cc/58c3/i/4/80/a22d447a5e12f1df889632c9e8300cb3.jpg",
    "description"   : "In a world where skills are supreme, Shikuro is given the incompetent skill of \"clock-user.\" One day, Shikuro, who is looked down upon by others, is accused of rape and sent to the frontier, where he is pushed down a hole that leads to a dungeon's deepest level. In the depths of his desperate situation, he thought to himself, \"If only I could use my clock-user ability to stop my stomach clock as well.\" Then the hunger would stop. This triggered the awakening of his skill \"clock-user.\" Eventually, he makes full use of his abilities and is recognized as an SSS-class adventurer.",
    "extension"     : "jpg",
    "filename"      : "p",
    "lang"          : "en",
    "manga"         : "As a Watchmaker, I Was Kicked Out of the Craftsman's Guild Because My Incompetence Was Deemed Unnecessary, But I Awakened to My True Power in the Depths of the Dungeon",
    "manga_id"      : "6wmv9",
    "manga_slug"    : "munou-wa-fuyou-to-iware-tokei-tsukai-no-boku-wa-shokuin-guild-kara-oidasareru-mo-dungeon-no-shinbu-de-shin-no-chikara-ni-kakusei-suru-the-comic",
    "published"     : "Feb 27, 2023 to ?",
    "publisher"     : ["Comic Ride"],
    "score"         : range(5, 10),
    "status"        : "Releasing",
    "title"         : "Part 1 - Karim's Purpose",
    "type"          : "Manga",
    "author"        : [
        "Kohaku Roumu",
        "Misa Sarasa",
    ],
    "manga_titles"  : [
        "Munou wa Fuyou to Iware \"Tokei Tsukai\" no Boku wa Shokuin Guild kara Oidasareru mo, Dungeon no Shinbu de Shin no Chikara ni Kakusei Suru THE COMIC",
        "As a Watchmaker, I Was Kicked Out of the Craftsman's Guild Because My Incompetence Was Deemed Unnecessary, But I Awakened to My True Power in the Depths of the Dungeon",
    ],
    "tags"          : [
        "Action",
        "Adventure",
        "Fantasy",
    ],
},

{
    "#url"     : "https://mangafire.to/read/munou-wa-fuyou-to-iware-tokei-tsukai-no-boku-wa-shokuin-guild-kara-oidasareru-mo-dungeon-no-shinbu-de-shin-no-chikara-ni-kakusei-suru-the-comic.6wmv9/en/volume-2",
    "#comment" : "volume",
    "#class"   : mangafire.MangafireChapterExtractor,
    "#pattern" : r"https://\w+\.mfcdn\d\.xyz/mf/\w+/h/p\.jpg",
    "#count"   : 154,

    "volume"        : 2,
    "volume_id"     : 301787,
    "chapter"       : 0,
    "chapter_id"    : 301787,
    "chapter_minor" : "",
    "chapter_string": "volume-2",
},

{
    "#url"     : "https://mangafire.to/manga/my-noble-family-is-headed-for-ruin-so-i-may-as-well-study-magic-in-my-free-timee.xjj0w",
    "#class"   : mangafire.MangafireMangaExtractor,
    "#pattern" : mangafire.MangafireChapterExtractor.pattern,
    "#count"   : range(40, 60),

    "chapter"       : range(1, 30),
    "chapter_id"    : int,
    "chapter_minor" : {"", ".1", ".2", ".3", ".5"},
    "chapter_string": str,
    "cover"         : "https://static.mfcdn.cc/88d7/i/6/69/69367cb22f154599d524cd5f57ef7e56.jpg",
    "description"   : "While sipping his evening beverage, a man was unexpectedly transported into the body of Liam, the fifth son of a nobleman from another world. Reveling in his newfound powers, he spent his days effortlessly mastering coveted magic, specializing in attribute-based spells, refining his abilities in summoning spirits, and acquiring impressive familiars. He eventually even conquered the most challenging of spells! Determined to secure his independence from his family's inevitable decline, he embraced the life of an adventurer. As time passed, surprisingly, instead of merely becoming one of the world's most skilled magicians, he effortlessly ascended the aristocratic hierarchy.",
    "lang"          : "en",
    "manga"         : "I Am a Noble About to Be Ruined, But Reached the Summit of Magic Because I Had a Lot of Free Time.",
    "manga_id"      : "xjj0w",
    "manga_slug"    : "my-noble-family-is-headed-for-ruin-so-i-may-as-well-study-magic-in-my-free-timee",
    "published"     : "Feb 02, 2020 to ?",
    "publisher"     : ["Comic Corona"],
    "score"         : float,
    "status"        : "Releasing",
    "title"         : str,
    "type"          : "Manga",
    "author"        : [
        "Nazuna Miki",
        "Rio Akisaki",
    ],
    "manga_titles"  : [
        "My Noble Family Is Headed for Ruin, so I May as Well Study Magic in My Free Time",
        "I Am a Noble About to Be Ruined, But Reached the Summit of Magic Because I Had a Lot of Free Time.",
        "Botsuraku Yotei no Kizoku dakedo, Hima Datta kara Mahou wo Kiwamete mita @COMIC",
        "I'm a Noble on the Brink of Ruin, So I Might as Well Try Mastering Magic",
        "Botsuraku Yotei no Kizoku dakedo, Hima datta kara Mahou wo Kiwamete Mita",
        "没落予定の貴族だけど、暇だったから魔法を極めてみた",
    ],
    "tags"          : [
        "Comedy",
        "Drama",
        "Isekai",
        "Adventure",
        "Fantasy",
        "Slice of Life",
        "Magic",
    ],
},

{
    "#url"     : "https://mangafire.to/manga/regressing-as-the-reincarnated-bastard-of-the-sword-clann.90vp0",
    "#class"   : mangafire.MangafireMangaExtractor,
    "#pattern" : mangafire.MangafireChapterExtractor.pattern,
    "#count"   : range(70, 120),

    "author"        : (),
    "chapter"       : int,
    "chapter_id"    : int,
    "chapter_minor" : "",
    "chapter_string": str,
    "cover"         : "https://static.mfcdn.cc/2c9e/i/f/fd/de53985a6ffa2e06d0032d3abc00e87c.jpg",
    "description"   : "The Great Northern Wall. The Dragon Knights. The Lords of the Winter Mountains. The Descendants of the Primordial Dragon. These are the various titles of the Grand Ducal Clan Ragnar, which boasted a rich, thousand year history. Theo Ragnar resolved himself to aiming for the throne of that very same clan. 'These cursed chains weren't something I could slip out of. They were meant to be broken with strength",
    "lang"          : "en",
    "manga"         : "Regressed life of the Sword Clan’s Ignoble Reincarnator",
    "manga_id"      : "90vp0",
    "manga_slug"    : "regressing-as-the-reincarnated-bastard-of-the-sword-clann",
    "published"     : "2024 to ?",
    "publisher"     : (),
    "score"         : range(8, 10),
    "status"        : "Releasing",
    "title"         : "",
    "type"          : "Manhwa",
    "manga_titles"  : [
        "Regressing as the Reincarnated Bastard of the Sword Clan",
        "Regressed life of the Sword Clan’s Ignoble Reincarnator",
        "How to Survive as the Bastard of the Regression Sword Clan",
        "회귀검가의 서자가 사는 법",
    ],
    "tags"          : [
        "Action",
        "Comedy",
        "Drama",
        "Supernatural",
        "Adventure",
        "Fantasy",
    ],
},

)
