/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar.misplaced;

import org.pantsbuild.jarjar.misplaced.FatalMisplacedClassProcessor;
import org.pantsbuild.jarjar.misplaced.MisplacedClassProcessor;
import org.pantsbuild.jarjar.misplaced.MoveMisplacedClassProcessor;
import org.pantsbuild.jarjar.misplaced.OmitMisplacedClassProcessor;
import org.pantsbuild.jarjar.misplaced.SkipMisplacedClassProcessor;

public class MisplacedClassProcessorFactory {
    private static MisplacedClassProcessorFactory me;

    public static synchronized MisplacedClassProcessorFactory getInstance() {
        if (me == null) {
            me = new MisplacedClassProcessorFactory();
        }
        return me;
    }

    private MisplacedClassProcessorFactory() {
    }

    public MisplacedClassProcessor getDefaultProcessor() {
        return new OmitMisplacedClassProcessor();
    }

    public MisplacedClassProcessor getProcessorForName(String string) {
        if (string == null) {
            return this.getDefaultProcessor();
        }
        switch (Strategy.valueOf(string.toUpperCase())) {
            case FATAL: {
                return new FatalMisplacedClassProcessor();
            }
            case MOVE: {
                return new MoveMisplacedClassProcessor();
            }
            case OMIT: {
                return new OmitMisplacedClassProcessor();
            }
            case SKIP: {
                return new SkipMisplacedClassProcessor();
            }
        }
        throw new IllegalArgumentException("Unrecognized strategy name \"" + string + "\".");
    }

    public static enum Strategy {
        FATAL,
        SKIP,
        OMIT,
        MOVE;

    }
}

