// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package qldb

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCancelJournalKinesisStream = "CancelJournalKinesisStream"

// CancelJournalKinesisStreamRequest generates a "aws/request.Request" representing the
// client's request for the CancelJournalKinesisStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelJournalKinesisStream for more information on using the CancelJournalKinesisStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelJournalKinesisStreamRequest method.
//	req, resp := client.CancelJournalKinesisStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/CancelJournalKinesisStream
func (c *QLDB) CancelJournalKinesisStreamRequest(input *CancelJournalKinesisStreamInput) (req *request.Request, output *CancelJournalKinesisStreamOutput) {
	op := &request.Operation{
		Name:       opCancelJournalKinesisStream,
		HTTPMethod: "DELETE",
		HTTPPath:   "/ledgers/{name}/journal-kinesis-streams/{streamId}",
	}

	if input == nil {
		input = &CancelJournalKinesisStreamInput{}
	}

	output = &CancelJournalKinesisStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelJournalKinesisStream API operation for Amazon QLDB.
//
// Ends a given Amazon QLDB journal stream. Before a stream can be canceled,
// its current status must be ACTIVE.
//
// You can't restart a stream after you cancel it. Canceled QLDB stream resources
// are subject to a 7-day retention period, so they are automatically deleted
// after this limit expires.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation CancelJournalKinesisStream for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in the request aren't valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ResourcePreconditionNotMetException
//     The operation failed because a condition wasn't satisfied in advance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/CancelJournalKinesisStream
func (c *QLDB) CancelJournalKinesisStream(input *CancelJournalKinesisStreamInput) (*CancelJournalKinesisStreamOutput, error) {
	req, out := c.CancelJournalKinesisStreamRequest(input)
	return out, req.Send()
}

// CancelJournalKinesisStreamWithContext is the same as CancelJournalKinesisStream with the addition of
// the ability to pass a context and additional request options.
//
// See CancelJournalKinesisStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) CancelJournalKinesisStreamWithContext(ctx aws.Context, input *CancelJournalKinesisStreamInput, opts ...request.Option) (*CancelJournalKinesisStreamOutput, error) {
	req, out := c.CancelJournalKinesisStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLedger = "CreateLedger"

// CreateLedgerRequest generates a "aws/request.Request" representing the
// client's request for the CreateLedger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLedger for more information on using the CreateLedger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLedgerRequest method.
//	req, resp := client.CreateLedgerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/CreateLedger
func (c *QLDB) CreateLedgerRequest(input *CreateLedgerInput) (req *request.Request, output *CreateLedgerOutput) {
	op := &request.Operation{
		Name:       opCreateLedger,
		HTTPMethod: "POST",
		HTTPPath:   "/ledgers",
	}

	if input == nil {
		input = &CreateLedgerInput{}
	}

	output = &CreateLedgerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLedger API operation for Amazon QLDB.
//
// Creates a new ledger in your Amazon Web Services account in the current Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation CreateLedger for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in the request aren't valid.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - LimitExceededException
//     You have reached the limit on the maximum number of resources allowed.
//
//   - ResourceInUseException
//     The specified resource can't be modified at this time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/CreateLedger
func (c *QLDB) CreateLedger(input *CreateLedgerInput) (*CreateLedgerOutput, error) {
	req, out := c.CreateLedgerRequest(input)
	return out, req.Send()
}

// CreateLedgerWithContext is the same as CreateLedger with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLedger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) CreateLedgerWithContext(ctx aws.Context, input *CreateLedgerInput, opts ...request.Option) (*CreateLedgerOutput, error) {
	req, out := c.CreateLedgerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLedger = "DeleteLedger"

// DeleteLedgerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLedger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLedger for more information on using the DeleteLedger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLedgerRequest method.
//	req, resp := client.DeleteLedgerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DeleteLedger
func (c *QLDB) DeleteLedgerRequest(input *DeleteLedgerInput) (req *request.Request, output *DeleteLedgerOutput) {
	op := &request.Operation{
		Name:       opDeleteLedger,
		HTTPMethod: "DELETE",
		HTTPPath:   "/ledgers/{name}",
	}

	if input == nil {
		input = &DeleteLedgerInput{}
	}

	output = &DeleteLedgerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLedger API operation for Amazon QLDB.
//
// Deletes a ledger and all of its contents. This action is irreversible.
//
// If deletion protection is enabled, you must first disable it before you can
// delete the ledger. You can disable it by calling the UpdateLedger operation
// to set this parameter to false.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation DeleteLedger for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in the request aren't valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ResourceInUseException
//     The specified resource can't be modified at this time.
//
//   - ResourcePreconditionNotMetException
//     The operation failed because a condition wasn't satisfied in advance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DeleteLedger
func (c *QLDB) DeleteLedger(input *DeleteLedgerInput) (*DeleteLedgerOutput, error) {
	req, out := c.DeleteLedgerRequest(input)
	return out, req.Send()
}

// DeleteLedgerWithContext is the same as DeleteLedger with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLedger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) DeleteLedgerWithContext(ctx aws.Context, input *DeleteLedgerInput, opts ...request.Option) (*DeleteLedgerOutput, error) {
	req, out := c.DeleteLedgerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJournalKinesisStream = "DescribeJournalKinesisStream"

// DescribeJournalKinesisStreamRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJournalKinesisStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJournalKinesisStream for more information on using the DescribeJournalKinesisStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeJournalKinesisStreamRequest method.
//	req, resp := client.DescribeJournalKinesisStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DescribeJournalKinesisStream
func (c *QLDB) DescribeJournalKinesisStreamRequest(input *DescribeJournalKinesisStreamInput) (req *request.Request, output *DescribeJournalKinesisStreamOutput) {
	op := &request.Operation{
		Name:       opDescribeJournalKinesisStream,
		HTTPMethod: "GET",
		HTTPPath:   "/ledgers/{name}/journal-kinesis-streams/{streamId}",
	}

	if input == nil {
		input = &DescribeJournalKinesisStreamInput{}
	}

	output = &DescribeJournalKinesisStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJournalKinesisStream API operation for Amazon QLDB.
//
// Returns detailed information about a given Amazon QLDB journal stream. The
// output includes the Amazon Resource Name (ARN), stream name, current status,
// creation time, and the parameters of the original stream creation request.
//
// This action does not return any expired journal streams. For more information,
// see Expiration for terminal streams (https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration)
// in the Amazon QLDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation DescribeJournalKinesisStream for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in the request aren't valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ResourcePreconditionNotMetException
//     The operation failed because a condition wasn't satisfied in advance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DescribeJournalKinesisStream
func (c *QLDB) DescribeJournalKinesisStream(input *DescribeJournalKinesisStreamInput) (*DescribeJournalKinesisStreamOutput, error) {
	req, out := c.DescribeJournalKinesisStreamRequest(input)
	return out, req.Send()
}

// DescribeJournalKinesisStreamWithContext is the same as DescribeJournalKinesisStream with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJournalKinesisStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) DescribeJournalKinesisStreamWithContext(ctx aws.Context, input *DescribeJournalKinesisStreamInput, opts ...request.Option) (*DescribeJournalKinesisStreamOutput, error) {
	req, out := c.DescribeJournalKinesisStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJournalS3Export = "DescribeJournalS3Export"

// DescribeJournalS3ExportRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJournalS3Export operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJournalS3Export for more information on using the DescribeJournalS3Export
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeJournalS3ExportRequest method.
//	req, resp := client.DescribeJournalS3ExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DescribeJournalS3Export
func (c *QLDB) DescribeJournalS3ExportRequest(input *DescribeJournalS3ExportInput) (req *request.Request, output *DescribeJournalS3ExportOutput) {
	op := &request.Operation{
		Name:       opDescribeJournalS3Export,
		HTTPMethod: "GET",
		HTTPPath:   "/ledgers/{name}/journal-s3-exports/{exportId}",
	}

	if input == nil {
		input = &DescribeJournalS3ExportInput{}
	}

	output = &DescribeJournalS3ExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJournalS3Export API operation for Amazon QLDB.
//
// Returns information about a journal export job, including the ledger name,
// export ID, creation time, current status, and the parameters of the original
// export creation request.
//
// This action does not return any expired export jobs. For more information,
// see Export job expiration (https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration)
// in the Amazon QLDB Developer Guide.
//
// If the export job with the given ExportId doesn't exist, then throws ResourceNotFoundException.
//
// If the ledger with the given Name doesn't exist, then throws ResourceNotFoundException.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation DescribeJournalS3Export for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DescribeJournalS3Export
func (c *QLDB) DescribeJournalS3Export(input *DescribeJournalS3ExportInput) (*DescribeJournalS3ExportOutput, error) {
	req, out := c.DescribeJournalS3ExportRequest(input)
	return out, req.Send()
}

// DescribeJournalS3ExportWithContext is the same as DescribeJournalS3Export with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJournalS3Export for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) DescribeJournalS3ExportWithContext(ctx aws.Context, input *DescribeJournalS3ExportInput, opts ...request.Option) (*DescribeJournalS3ExportOutput, error) {
	req, out := c.DescribeJournalS3ExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLedger = "DescribeLedger"

// DescribeLedgerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLedger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLedger for more information on using the DescribeLedger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLedgerRequest method.
//	req, resp := client.DescribeLedgerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DescribeLedger
func (c *QLDB) DescribeLedgerRequest(input *DescribeLedgerInput) (req *request.Request, output *DescribeLedgerOutput) {
	op := &request.Operation{
		Name:       opDescribeLedger,
		HTTPMethod: "GET",
		HTTPPath:   "/ledgers/{name}",
	}

	if input == nil {
		input = &DescribeLedgerInput{}
	}

	output = &DescribeLedgerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLedger API operation for Amazon QLDB.
//
// Returns information about a ledger, including its state, permissions mode,
// encryption at rest settings, and when it was created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation DescribeLedger for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in the request aren't valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/DescribeLedger
func (c *QLDB) DescribeLedger(input *DescribeLedgerInput) (*DescribeLedgerOutput, error) {
	req, out := c.DescribeLedgerRequest(input)
	return out, req.Send()
}

// DescribeLedgerWithContext is the same as DescribeLedger with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLedger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) DescribeLedgerWithContext(ctx aws.Context, input *DescribeLedgerInput, opts ...request.Option) (*DescribeLedgerOutput, error) {
	req, out := c.DescribeLedgerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportJournalToS3 = "ExportJournalToS3"

// ExportJournalToS3Request generates a "aws/request.Request" representing the
// client's request for the ExportJournalToS3 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportJournalToS3 for more information on using the ExportJournalToS3
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExportJournalToS3Request method.
//	req, resp := client.ExportJournalToS3Request(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ExportJournalToS3
func (c *QLDB) ExportJournalToS3Request(input *ExportJournalToS3Input) (req *request.Request, output *ExportJournalToS3Output) {
	op := &request.Operation{
		Name:       opExportJournalToS3,
		HTTPMethod: "POST",
		HTTPPath:   "/ledgers/{name}/journal-s3-exports",
	}

	if input == nil {
		input = &ExportJournalToS3Input{}
	}

	output = &ExportJournalToS3Output{}
	req = c.newRequest(op, input, output)
	return
}

// ExportJournalToS3 API operation for Amazon QLDB.
//
// Exports journal contents within a date and time range from a ledger into
// a specified Amazon Simple Storage Service (Amazon S3) bucket. A journal export
// job can write the data objects in either the text or binary representation
// of Amazon Ion format, or in JSON Lines text format.
//
// If the ledger with the given Name doesn't exist, then throws ResourceNotFoundException.
//
// If the ledger with the given Name is in CREATING status, then throws ResourcePreconditionNotMetException.
//
// You can initiate up to two concurrent journal export requests for each ledger.
// Beyond this limit, journal export requests throw LimitExceededException.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation ExportJournalToS3 for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ResourcePreconditionNotMetException
//     The operation failed because a condition wasn't satisfied in advance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ExportJournalToS3
func (c *QLDB) ExportJournalToS3(input *ExportJournalToS3Input) (*ExportJournalToS3Output, error) {
	req, out := c.ExportJournalToS3Request(input)
	return out, req.Send()
}

// ExportJournalToS3WithContext is the same as ExportJournalToS3 with the addition of
// the ability to pass a context and additional request options.
//
// See ExportJournalToS3 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) ExportJournalToS3WithContext(ctx aws.Context, input *ExportJournalToS3Input, opts ...request.Option) (*ExportJournalToS3Output, error) {
	req, out := c.ExportJournalToS3Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBlock = "GetBlock"

// GetBlockRequest generates a "aws/request.Request" representing the
// client's request for the GetBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBlock for more information on using the GetBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBlockRequest method.
//	req, resp := client.GetBlockRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/GetBlock
func (c *QLDB) GetBlockRequest(input *GetBlockInput) (req *request.Request, output *GetBlockOutput) {
	op := &request.Operation{
		Name:       opGetBlock,
		HTTPMethod: "POST",
		HTTPPath:   "/ledgers/{name}/block",
	}

	if input == nil {
		input = &GetBlockInput{}
	}

	output = &GetBlockOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBlock API operation for Amazon QLDB.
//
// Returns a block object at a specified address in a journal. Also returns
// a proof of the specified block for verification if DigestTipAddress is provided.
//
// For information about the data contents in a block, see Journal contents
// (https://docs.aws.amazon.com/qldb/latest/developerguide/journal-contents.html)
// in the Amazon QLDB Developer Guide.
//
// If the specified ledger doesn't exist or is in DELETING status, then throws
// ResourceNotFoundException.
//
// If the specified ledger is in CREATING status, then throws ResourcePreconditionNotMetException.
//
// If no block exists with the specified address, then throws InvalidParameterException.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation GetBlock for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in the request aren't valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ResourcePreconditionNotMetException
//     The operation failed because a condition wasn't satisfied in advance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/GetBlock
func (c *QLDB) GetBlock(input *GetBlockInput) (*GetBlockOutput, error) {
	req, out := c.GetBlockRequest(input)
	return out, req.Send()
}

// GetBlockWithContext is the same as GetBlock with the addition of
// the ability to pass a context and additional request options.
//
// See GetBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) GetBlockWithContext(ctx aws.Context, input *GetBlockInput, opts ...request.Option) (*GetBlockOutput, error) {
	req, out := c.GetBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDigest = "GetDigest"

// GetDigestRequest generates a "aws/request.Request" representing the
// client's request for the GetDigest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDigest for more information on using the GetDigest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDigestRequest method.
//	req, resp := client.GetDigestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/GetDigest
func (c *QLDB) GetDigestRequest(input *GetDigestInput) (req *request.Request, output *GetDigestOutput) {
	op := &request.Operation{
		Name:       opGetDigest,
		HTTPMethod: "POST",
		HTTPPath:   "/ledgers/{name}/digest",
	}

	if input == nil {
		input = &GetDigestInput{}
	}

	output = &GetDigestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDigest API operation for Amazon QLDB.
//
// Returns the digest of a ledger at the latest committed block in the journal.
// The response includes a 256-bit hash value and a block address.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation GetDigest for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in the request aren't valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ResourcePreconditionNotMetException
//     The operation failed because a condition wasn't satisfied in advance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/GetDigest
func (c *QLDB) GetDigest(input *GetDigestInput) (*GetDigestOutput, error) {
	req, out := c.GetDigestRequest(input)
	return out, req.Send()
}

// GetDigestWithContext is the same as GetDigest with the addition of
// the ability to pass a context and additional request options.
//
// See GetDigest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) GetDigestWithContext(ctx aws.Context, input *GetDigestInput, opts ...request.Option) (*GetDigestOutput, error) {
	req, out := c.GetDigestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRevision = "GetRevision"

// GetRevisionRequest generates a "aws/request.Request" representing the
// client's request for the GetRevision operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRevision for more information on using the GetRevision
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRevisionRequest method.
//	req, resp := client.GetRevisionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/GetRevision
func (c *QLDB) GetRevisionRequest(input *GetRevisionInput) (req *request.Request, output *GetRevisionOutput) {
	op := &request.Operation{
		Name:       opGetRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/ledgers/{name}/revision",
	}

	if input == nil {
		input = &GetRevisionInput{}
	}

	output = &GetRevisionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRevision API operation for Amazon QLDB.
//
// Returns a revision data object for a specified document ID and block address.
// Also returns a proof of the specified revision for verification if DigestTipAddress
// is provided.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation GetRevision for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in the request aren't valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ResourcePreconditionNotMetException
//     The operation failed because a condition wasn't satisfied in advance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/GetRevision
func (c *QLDB) GetRevision(input *GetRevisionInput) (*GetRevisionOutput, error) {
	req, out := c.GetRevisionRequest(input)
	return out, req.Send()
}

// GetRevisionWithContext is the same as GetRevision with the addition of
// the ability to pass a context and additional request options.
//
// See GetRevision for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) GetRevisionWithContext(ctx aws.Context, input *GetRevisionInput, opts ...request.Option) (*GetRevisionOutput, error) {
	req, out := c.GetRevisionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJournalKinesisStreamsForLedger = "ListJournalKinesisStreamsForLedger"

// ListJournalKinesisStreamsForLedgerRequest generates a "aws/request.Request" representing the
// client's request for the ListJournalKinesisStreamsForLedger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJournalKinesisStreamsForLedger for more information on using the ListJournalKinesisStreamsForLedger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListJournalKinesisStreamsForLedgerRequest method.
//	req, resp := client.ListJournalKinesisStreamsForLedgerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalKinesisStreamsForLedger
func (c *QLDB) ListJournalKinesisStreamsForLedgerRequest(input *ListJournalKinesisStreamsForLedgerInput) (req *request.Request, output *ListJournalKinesisStreamsForLedgerOutput) {
	op := &request.Operation{
		Name:       opListJournalKinesisStreamsForLedger,
		HTTPMethod: "GET",
		HTTPPath:   "/ledgers/{name}/journal-kinesis-streams",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJournalKinesisStreamsForLedgerInput{}
	}

	output = &ListJournalKinesisStreamsForLedgerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJournalKinesisStreamsForLedger API operation for Amazon QLDB.
//
// Returns all Amazon QLDB journal streams for a given ledger.
//
// This action does not return any expired journal streams. For more information,
// see Expiration for terminal streams (https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration)
// in the Amazon QLDB Developer Guide.
//
// This action returns a maximum of MaxResults items. It is paginated so that
// you can retrieve all the items by calling ListJournalKinesisStreamsForLedger
// multiple times.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation ListJournalKinesisStreamsForLedger for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in the request aren't valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ResourcePreconditionNotMetException
//     The operation failed because a condition wasn't satisfied in advance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalKinesisStreamsForLedger
func (c *QLDB) ListJournalKinesisStreamsForLedger(input *ListJournalKinesisStreamsForLedgerInput) (*ListJournalKinesisStreamsForLedgerOutput, error) {
	req, out := c.ListJournalKinesisStreamsForLedgerRequest(input)
	return out, req.Send()
}

// ListJournalKinesisStreamsForLedgerWithContext is the same as ListJournalKinesisStreamsForLedger with the addition of
// the ability to pass a context and additional request options.
//
// See ListJournalKinesisStreamsForLedger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) ListJournalKinesisStreamsForLedgerWithContext(ctx aws.Context, input *ListJournalKinesisStreamsForLedgerInput, opts ...request.Option) (*ListJournalKinesisStreamsForLedgerOutput, error) {
	req, out := c.ListJournalKinesisStreamsForLedgerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJournalKinesisStreamsForLedgerPages iterates over the pages of a ListJournalKinesisStreamsForLedger operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJournalKinesisStreamsForLedger method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListJournalKinesisStreamsForLedger operation.
//	pageNum := 0
//	err := client.ListJournalKinesisStreamsForLedgerPages(params,
//	    func(page *qldb.ListJournalKinesisStreamsForLedgerOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QLDB) ListJournalKinesisStreamsForLedgerPages(input *ListJournalKinesisStreamsForLedgerInput, fn func(*ListJournalKinesisStreamsForLedgerOutput, bool) bool) error {
	return c.ListJournalKinesisStreamsForLedgerPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJournalKinesisStreamsForLedgerPagesWithContext same as ListJournalKinesisStreamsForLedgerPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) ListJournalKinesisStreamsForLedgerPagesWithContext(ctx aws.Context, input *ListJournalKinesisStreamsForLedgerInput, fn func(*ListJournalKinesisStreamsForLedgerOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJournalKinesisStreamsForLedgerInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJournalKinesisStreamsForLedgerRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJournalKinesisStreamsForLedgerOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListJournalS3Exports = "ListJournalS3Exports"

// ListJournalS3ExportsRequest generates a "aws/request.Request" representing the
// client's request for the ListJournalS3Exports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJournalS3Exports for more information on using the ListJournalS3Exports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListJournalS3ExportsRequest method.
//	req, resp := client.ListJournalS3ExportsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalS3Exports
func (c *QLDB) ListJournalS3ExportsRequest(input *ListJournalS3ExportsInput) (req *request.Request, output *ListJournalS3ExportsOutput) {
	op := &request.Operation{
		Name:       opListJournalS3Exports,
		HTTPMethod: "GET",
		HTTPPath:   "/journal-s3-exports",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJournalS3ExportsInput{}
	}

	output = &ListJournalS3ExportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJournalS3Exports API operation for Amazon QLDB.
//
// Returns all journal export jobs for all ledgers that are associated with
// the current Amazon Web Services account and Region.
//
// This action returns a maximum of MaxResults items, and is paginated so that
// you can retrieve all the items by calling ListJournalS3Exports multiple times.
//
// This action does not return any expired export jobs. For more information,
// see Export job expiration (https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration)
// in the Amazon QLDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation ListJournalS3Exports for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalS3Exports
func (c *QLDB) ListJournalS3Exports(input *ListJournalS3ExportsInput) (*ListJournalS3ExportsOutput, error) {
	req, out := c.ListJournalS3ExportsRequest(input)
	return out, req.Send()
}

// ListJournalS3ExportsWithContext is the same as ListJournalS3Exports with the addition of
// the ability to pass a context and additional request options.
//
// See ListJournalS3Exports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) ListJournalS3ExportsWithContext(ctx aws.Context, input *ListJournalS3ExportsInput, opts ...request.Option) (*ListJournalS3ExportsOutput, error) {
	req, out := c.ListJournalS3ExportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJournalS3ExportsPages iterates over the pages of a ListJournalS3Exports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJournalS3Exports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListJournalS3Exports operation.
//	pageNum := 0
//	err := client.ListJournalS3ExportsPages(params,
//	    func(page *qldb.ListJournalS3ExportsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QLDB) ListJournalS3ExportsPages(input *ListJournalS3ExportsInput, fn func(*ListJournalS3ExportsOutput, bool) bool) error {
	return c.ListJournalS3ExportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJournalS3ExportsPagesWithContext same as ListJournalS3ExportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) ListJournalS3ExportsPagesWithContext(ctx aws.Context, input *ListJournalS3ExportsInput, fn func(*ListJournalS3ExportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJournalS3ExportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJournalS3ExportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJournalS3ExportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListJournalS3ExportsForLedger = "ListJournalS3ExportsForLedger"

// ListJournalS3ExportsForLedgerRequest generates a "aws/request.Request" representing the
// client's request for the ListJournalS3ExportsForLedger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJournalS3ExportsForLedger for more information on using the ListJournalS3ExportsForLedger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListJournalS3ExportsForLedgerRequest method.
//	req, resp := client.ListJournalS3ExportsForLedgerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalS3ExportsForLedger
func (c *QLDB) ListJournalS3ExportsForLedgerRequest(input *ListJournalS3ExportsForLedgerInput) (req *request.Request, output *ListJournalS3ExportsForLedgerOutput) {
	op := &request.Operation{
		Name:       opListJournalS3ExportsForLedger,
		HTTPMethod: "GET",
		HTTPPath:   "/ledgers/{name}/journal-s3-exports",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJournalS3ExportsForLedgerInput{}
	}

	output = &ListJournalS3ExportsForLedgerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJournalS3ExportsForLedger API operation for Amazon QLDB.
//
// Returns all journal export jobs for a specified ledger.
//
// This action returns a maximum of MaxResults items, and is paginated so that
// you can retrieve all the items by calling ListJournalS3ExportsForLedger multiple
// times.
//
// This action does not return any expired export jobs. For more information,
// see Export job expiration (https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration)
// in the Amazon QLDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation ListJournalS3ExportsForLedger for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListJournalS3ExportsForLedger
func (c *QLDB) ListJournalS3ExportsForLedger(input *ListJournalS3ExportsForLedgerInput) (*ListJournalS3ExportsForLedgerOutput, error) {
	req, out := c.ListJournalS3ExportsForLedgerRequest(input)
	return out, req.Send()
}

// ListJournalS3ExportsForLedgerWithContext is the same as ListJournalS3ExportsForLedger with the addition of
// the ability to pass a context and additional request options.
//
// See ListJournalS3ExportsForLedger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) ListJournalS3ExportsForLedgerWithContext(ctx aws.Context, input *ListJournalS3ExportsForLedgerInput, opts ...request.Option) (*ListJournalS3ExportsForLedgerOutput, error) {
	req, out := c.ListJournalS3ExportsForLedgerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJournalS3ExportsForLedgerPages iterates over the pages of a ListJournalS3ExportsForLedger operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJournalS3ExportsForLedger method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListJournalS3ExportsForLedger operation.
//	pageNum := 0
//	err := client.ListJournalS3ExportsForLedgerPages(params,
//	    func(page *qldb.ListJournalS3ExportsForLedgerOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QLDB) ListJournalS3ExportsForLedgerPages(input *ListJournalS3ExportsForLedgerInput, fn func(*ListJournalS3ExportsForLedgerOutput, bool) bool) error {
	return c.ListJournalS3ExportsForLedgerPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJournalS3ExportsForLedgerPagesWithContext same as ListJournalS3ExportsForLedgerPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) ListJournalS3ExportsForLedgerPagesWithContext(ctx aws.Context, input *ListJournalS3ExportsForLedgerInput, fn func(*ListJournalS3ExportsForLedgerOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJournalS3ExportsForLedgerInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJournalS3ExportsForLedgerRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJournalS3ExportsForLedgerOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLedgers = "ListLedgers"

// ListLedgersRequest generates a "aws/request.Request" representing the
// client's request for the ListLedgers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLedgers for more information on using the ListLedgers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLedgersRequest method.
//	req, resp := client.ListLedgersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListLedgers
func (c *QLDB) ListLedgersRequest(input *ListLedgersInput) (req *request.Request, output *ListLedgersOutput) {
	op := &request.Operation{
		Name:       opListLedgers,
		HTTPMethod: "GET",
		HTTPPath:   "/ledgers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLedgersInput{}
	}

	output = &ListLedgersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLedgers API operation for Amazon QLDB.
//
// Returns all ledgers that are associated with the current Amazon Web Services
// account and Region.
//
// This action returns a maximum of MaxResults items and is paginated so that
// you can retrieve all the items by calling ListLedgers multiple times.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation ListLedgers for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListLedgers
func (c *QLDB) ListLedgers(input *ListLedgersInput) (*ListLedgersOutput, error) {
	req, out := c.ListLedgersRequest(input)
	return out, req.Send()
}

// ListLedgersWithContext is the same as ListLedgers with the addition of
// the ability to pass a context and additional request options.
//
// See ListLedgers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) ListLedgersWithContext(ctx aws.Context, input *ListLedgersInput, opts ...request.Option) (*ListLedgersOutput, error) {
	req, out := c.ListLedgersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLedgersPages iterates over the pages of a ListLedgers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLedgers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLedgers operation.
//	pageNum := 0
//	err := client.ListLedgersPages(params,
//	    func(page *qldb.ListLedgersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QLDB) ListLedgersPages(input *ListLedgersInput, fn func(*ListLedgersOutput, bool) bool) error {
	return c.ListLedgersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLedgersPagesWithContext same as ListLedgersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) ListLedgersPagesWithContext(ctx aws.Context, input *ListLedgersInput, fn func(*ListLedgersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLedgersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLedgersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLedgersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListTagsForResource
func (c *QLDB) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon QLDB.
//
// Returns all tags for a specified Amazon QLDB resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in the request aren't valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/ListTagsForResource
func (c *QLDB) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStreamJournalToKinesis = "StreamJournalToKinesis"

// StreamJournalToKinesisRequest generates a "aws/request.Request" representing the
// client's request for the StreamJournalToKinesis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StreamJournalToKinesis for more information on using the StreamJournalToKinesis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StreamJournalToKinesisRequest method.
//	req, resp := client.StreamJournalToKinesisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/StreamJournalToKinesis
func (c *QLDB) StreamJournalToKinesisRequest(input *StreamJournalToKinesisInput) (req *request.Request, output *StreamJournalToKinesisOutput) {
	op := &request.Operation{
		Name:       opStreamJournalToKinesis,
		HTTPMethod: "POST",
		HTTPPath:   "/ledgers/{name}/journal-kinesis-streams",
	}

	if input == nil {
		input = &StreamJournalToKinesisInput{}
	}

	output = &StreamJournalToKinesisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StreamJournalToKinesis API operation for Amazon QLDB.
//
// Creates a journal stream for a given Amazon QLDB ledger. The stream captures
// every document revision that is committed to the ledger's journal and delivers
// the data to a specified Amazon Kinesis Data Streams resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation StreamJournalToKinesis for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in the request aren't valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ResourcePreconditionNotMetException
//     The operation failed because a condition wasn't satisfied in advance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/StreamJournalToKinesis
func (c *QLDB) StreamJournalToKinesis(input *StreamJournalToKinesisInput) (*StreamJournalToKinesisOutput, error) {
	req, out := c.StreamJournalToKinesisRequest(input)
	return out, req.Send()
}

// StreamJournalToKinesisWithContext is the same as StreamJournalToKinesis with the addition of
// the ability to pass a context and additional request options.
//
// See StreamJournalToKinesis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) StreamJournalToKinesisWithContext(ctx aws.Context, input *StreamJournalToKinesisInput, opts ...request.Option) (*StreamJournalToKinesisOutput, error) {
	req, out := c.StreamJournalToKinesisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/TagResource
func (c *QLDB) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon QLDB.
//
// Adds one or more tags to a specified Amazon QLDB resource.
//
// A resource can have up to 50 tags. If you try to create more than 50 tags
// for a resource, your request fails and returns an error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in the request aren't valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/TagResource
func (c *QLDB) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/UntagResource
func (c *QLDB) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon QLDB.
//
// Removes one or more tags from a specified Amazon QLDB resource. You can specify
// up to 50 tag keys to remove.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in the request aren't valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/UntagResource
func (c *QLDB) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLedger = "UpdateLedger"

// UpdateLedgerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLedger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLedger for more information on using the UpdateLedger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLedgerRequest method.
//	req, resp := client.UpdateLedgerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/UpdateLedger
func (c *QLDB) UpdateLedgerRequest(input *UpdateLedgerInput) (req *request.Request, output *UpdateLedgerOutput) {
	op := &request.Operation{
		Name:       opUpdateLedger,
		HTTPMethod: "PATCH",
		HTTPPath:   "/ledgers/{name}",
	}

	if input == nil {
		input = &UpdateLedgerInput{}
	}

	output = &UpdateLedgerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLedger API operation for Amazon QLDB.
//
// Updates properties on a ledger.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation UpdateLedger for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in the request aren't valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/UpdateLedger
func (c *QLDB) UpdateLedger(input *UpdateLedgerInput) (*UpdateLedgerOutput, error) {
	req, out := c.UpdateLedgerRequest(input)
	return out, req.Send()
}

// UpdateLedgerWithContext is the same as UpdateLedger with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLedger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) UpdateLedgerWithContext(ctx aws.Context, input *UpdateLedgerInput, opts ...request.Option) (*UpdateLedgerOutput, error) {
	req, out := c.UpdateLedgerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLedgerPermissionsMode = "UpdateLedgerPermissionsMode"

// UpdateLedgerPermissionsModeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLedgerPermissionsMode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLedgerPermissionsMode for more information on using the UpdateLedgerPermissionsMode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLedgerPermissionsModeRequest method.
//	req, resp := client.UpdateLedgerPermissionsModeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/UpdateLedgerPermissionsMode
func (c *QLDB) UpdateLedgerPermissionsModeRequest(input *UpdateLedgerPermissionsModeInput) (req *request.Request, output *UpdateLedgerPermissionsModeOutput) {
	op := &request.Operation{
		Name:       opUpdateLedgerPermissionsMode,
		HTTPMethod: "PATCH",
		HTTPPath:   "/ledgers/{name}/permissions-mode",
	}

	if input == nil {
		input = &UpdateLedgerPermissionsModeInput{}
	}

	output = &UpdateLedgerPermissionsModeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLedgerPermissionsMode API operation for Amazon QLDB.
//
// Updates the permissions mode of a ledger.
//
// Before you switch to the STANDARD permissions mode, you must first create
// all required IAM policies and table tags to avoid disruption to your users.
// To learn more, see Migrating to the standard permissions mode (https://docs.aws.amazon.com/qldb/latest/developerguide/ledger-management.basics.html#ledger-mgmt.basics.update-permissions.migrating)
// in the Amazon QLDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QLDB's
// API operation UpdateLedgerPermissionsMode for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in the request aren't valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/UpdateLedgerPermissionsMode
func (c *QLDB) UpdateLedgerPermissionsMode(input *UpdateLedgerPermissionsModeInput) (*UpdateLedgerPermissionsModeOutput, error) {
	req, out := c.UpdateLedgerPermissionsModeRequest(input)
	return out, req.Send()
}

// UpdateLedgerPermissionsModeWithContext is the same as UpdateLedgerPermissionsMode with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLedgerPermissionsMode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QLDB) UpdateLedgerPermissionsModeWithContext(ctx aws.Context, input *UpdateLedgerPermissionsModeInput, opts ...request.Option) (*UpdateLedgerPermissionsModeOutput, error) {
	req, out := c.UpdateLedgerPermissionsModeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CancelJournalKinesisStreamInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the ledger.
	//
	// LedgerName is a required field
	LedgerName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The UUID (represented in Base62-encoded text) of the QLDB journal stream
	// to be canceled.
	//
	// StreamId is a required field
	StreamId *string `location:"uri" locationName:"streamId" min:"22" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJournalKinesisStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJournalKinesisStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelJournalKinesisStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelJournalKinesisStreamInput"}
	if s.LedgerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LedgerName"))
	}
	if s.LedgerName != nil && len(*s.LedgerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LedgerName", 1))
	}
	if s.StreamId == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamId"))
	}
	if s.StreamId != nil && len(*s.StreamId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("StreamId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLedgerName sets the LedgerName field's value.
func (s *CancelJournalKinesisStreamInput) SetLedgerName(v string) *CancelJournalKinesisStreamInput {
	s.LedgerName = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *CancelJournalKinesisStreamInput) SetStreamId(v string) *CancelJournalKinesisStreamInput {
	s.StreamId = &v
	return s
}

type CancelJournalKinesisStreamOutput struct {
	_ struct{} `type:"structure"`

	// The UUID (Base62-encoded text) of the canceled QLDB journal stream.
	StreamId *string `min:"22" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJournalKinesisStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelJournalKinesisStreamOutput) GoString() string {
	return s.String()
}

// SetStreamId sets the StreamId field's value.
func (s *CancelJournalKinesisStreamOutput) SetStreamId(v string) *CancelJournalKinesisStreamOutput {
	s.StreamId = &v
	return s
}

type CreateLedgerInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the ledger is protected from being deleted by any user.
	// If not defined during ledger creation, this feature is enabled (true) by
	// default.
	//
	// If deletion protection is enabled, you must first disable it before you can
	// delete the ledger. You can disable it by calling the UpdateLedger operation
	// to set this parameter to false.
	DeletionProtection *bool `type:"boolean"`

	// The key in Key Management Service (KMS) to use for encryption of data at
	// rest in the ledger. For more information, see Encryption at rest (https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html)
	// in the Amazon QLDB Developer Guide.
	//
	// Use one of the following options to specify this parameter:
	//
	//    * AWS_OWNED_KMS_KEY: Use an KMS key that is owned and managed by Amazon
	//    Web Services on your behalf.
	//
	//    * Undefined: By default, use an Amazon Web Services owned KMS key.
	//
	//    * A valid symmetric customer managed KMS key: Use the specified symmetric
	//    encryption KMS key in your account that you create, own, and manage. Amazon
	//    QLDB does not support asymmetric keys. For more information, see Using
	//    symmetric and asymmetric keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
	//    in the Key Management Service Developer Guide.
	//
	// To specify a customer managed KMS key, you can use its key ID, Amazon Resource
	// Name (ARN), alias name, or alias ARN. When using an alias name, prefix it
	// with "alias/". To specify a key in a different Amazon Web Services account,
	// you must use the key ARN or alias ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// For more information, see Key identifiers (KeyId) (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id)
	// in the Key Management Service Developer Guide.
	KmsKey *string `type:"string"`

	// The name of the ledger that you want to create. The name must be unique among
	// all of the ledgers in your Amazon Web Services account in the current Region.
	//
	// Naming constraints for ledger names are defined in Quotas in Amazon QLDB
	// (https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming)
	// in the Amazon QLDB Developer Guide.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The permissions mode to assign to the ledger that you want to create. This
	// parameter can have one of the following values:
	//
	//    * ALLOW_ALL: A legacy permissions mode that enables access control with
	//    API-level granularity for ledgers. This mode allows users who have the
	//    SendCommand API permission for this ledger to run all PartiQL commands
	//    (hence, ALLOW_ALL) on any tables in the specified ledger. This mode disregards
	//    any table-level or command-level IAM permissions policies that you create
	//    for the ledger.
	//
	//    * STANDARD: (Recommended) A permissions mode that enables access control
	//    with finer granularity for ledgers, tables, and PartiQL commands. By default,
	//    this mode denies all user requests to run any PartiQL commands on any
	//    tables in this ledger. To allow PartiQL commands to run, you must create
	//    IAM permissions policies for specific table resources and PartiQL actions,
	//    in addition to the SendCommand API permission for the ledger. For information,
	//    see Getting started with the standard permissions mode (https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html)
	//    in the Amazon QLDB Developer Guide.
	//
	// We strongly recommend using the STANDARD permissions mode to maximize the
	// security of your ledger data.
	//
	// PermissionsMode is a required field
	PermissionsMode *string `type:"string" required:"true" enum:"PermissionsMode"`

	// The key-value pairs to add as tags to the ledger that you want to create.
	// Tag keys are case sensitive. Tag values are case sensitive and can be null.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLedgerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLedgerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLedgerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLedgerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PermissionsMode == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionsMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *CreateLedgerInput) SetDeletionProtection(v bool) *CreateLedgerInput {
	s.DeletionProtection = &v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *CreateLedgerInput) SetKmsKey(v string) *CreateLedgerInput {
	s.KmsKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateLedgerInput) SetName(v string) *CreateLedgerInput {
	s.Name = &v
	return s
}

// SetPermissionsMode sets the PermissionsMode field's value.
func (s *CreateLedgerInput) SetPermissionsMode(v string) *CreateLedgerInput {
	s.PermissionsMode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLedgerInput) SetTags(v map[string]*string) *CreateLedgerInput {
	s.Tags = v
	return s
}

type CreateLedgerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the ledger.
	Arn *string `min:"20" type:"string"`

	// The date and time, in epoch time format, when the ledger was created. (Epoch
	// time format is the number of seconds elapsed since 12:00:00 AM January 1,
	// 1970 UTC.)
	CreationDateTime *time.Time `type:"timestamp"`

	// Specifies whether the ledger is protected from being deleted by any user.
	// If not defined during ledger creation, this feature is enabled (true) by
	// default.
	//
	// If deletion protection is enabled, you must first disable it before you can
	// delete the ledger. You can disable it by calling the UpdateLedger operation
	// to set this parameter to false.
	DeletionProtection *bool `type:"boolean"`

	// The ARN of the customer managed KMS key that the ledger uses for encryption
	// at rest. If this parameter is undefined, the ledger uses an Amazon Web Services
	// owned KMS key for encryption.
	KmsKeyArn *string `min:"20" type:"string"`

	// The name of the ledger.
	Name *string `min:"1" type:"string"`

	// The permissions mode of the ledger that you created.
	PermissionsMode *string `type:"string" enum:"PermissionsMode"`

	// The current status of the ledger.
	State *string `type:"string" enum:"LedgerState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLedgerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLedgerOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateLedgerOutput) SetArn(v string) *CreateLedgerOutput {
	s.Arn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateLedgerOutput) SetCreationDateTime(v time.Time) *CreateLedgerOutput {
	s.CreationDateTime = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *CreateLedgerOutput) SetDeletionProtection(v bool) *CreateLedgerOutput {
	s.DeletionProtection = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CreateLedgerOutput) SetKmsKeyArn(v string) *CreateLedgerOutput {
	s.KmsKeyArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateLedgerOutput) SetName(v string) *CreateLedgerOutput {
	s.Name = &v
	return s
}

// SetPermissionsMode sets the PermissionsMode field's value.
func (s *CreateLedgerOutput) SetPermissionsMode(v string) *CreateLedgerOutput {
	s.PermissionsMode = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateLedgerOutput) SetState(v string) *CreateLedgerOutput {
	s.State = &v
	return s
}

type DeleteLedgerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the ledger that you want to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLedgerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLedgerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLedgerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLedgerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteLedgerInput) SetName(v string) *DeleteLedgerInput {
	s.Name = &v
	return s
}

type DeleteLedgerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLedgerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLedgerOutput) GoString() string {
	return s.String()
}

type DescribeJournalKinesisStreamInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the ledger.
	//
	// LedgerName is a required field
	LedgerName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The UUID (represented in Base62-encoded text) of the QLDB journal stream
	// to describe.
	//
	// StreamId is a required field
	StreamId *string `location:"uri" locationName:"streamId" min:"22" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJournalKinesisStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJournalKinesisStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJournalKinesisStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJournalKinesisStreamInput"}
	if s.LedgerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LedgerName"))
	}
	if s.LedgerName != nil && len(*s.LedgerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LedgerName", 1))
	}
	if s.StreamId == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamId"))
	}
	if s.StreamId != nil && len(*s.StreamId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("StreamId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLedgerName sets the LedgerName field's value.
func (s *DescribeJournalKinesisStreamInput) SetLedgerName(v string) *DescribeJournalKinesisStreamInput {
	s.LedgerName = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *DescribeJournalKinesisStreamInput) SetStreamId(v string) *DescribeJournalKinesisStreamInput {
	s.StreamId = &v
	return s
}

type DescribeJournalKinesisStreamOutput struct {
	_ struct{} `type:"structure"`

	// Information about the QLDB journal stream returned by a DescribeJournalS3Export
	// request.
	Stream *JournalKinesisStreamDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJournalKinesisStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJournalKinesisStreamOutput) GoString() string {
	return s.String()
}

// SetStream sets the Stream field's value.
func (s *DescribeJournalKinesisStreamOutput) SetStream(v *JournalKinesisStreamDescription) *DescribeJournalKinesisStreamOutput {
	s.Stream = v
	return s
}

type DescribeJournalS3ExportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The UUID (represented in Base62-encoded text) of the journal export job to
	// describe.
	//
	// ExportId is a required field
	ExportId *string `location:"uri" locationName:"exportId" min:"22" type:"string" required:"true"`

	// The name of the ledger.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJournalS3ExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJournalS3ExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJournalS3ExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJournalS3ExportInput"}
	if s.ExportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportId"))
	}
	if s.ExportId != nil && len(*s.ExportId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("ExportId", 22))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportId sets the ExportId field's value.
func (s *DescribeJournalS3ExportInput) SetExportId(v string) *DescribeJournalS3ExportInput {
	s.ExportId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeJournalS3ExportInput) SetName(v string) *DescribeJournalS3ExportInput {
	s.Name = &v
	return s
}

type DescribeJournalS3ExportOutput struct {
	_ struct{} `type:"structure"`

	// Information about the journal export job returned by a DescribeJournalS3Export
	// request.
	//
	// ExportDescription is a required field
	ExportDescription *JournalS3ExportDescription `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJournalS3ExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJournalS3ExportOutput) GoString() string {
	return s.String()
}

// SetExportDescription sets the ExportDescription field's value.
func (s *DescribeJournalS3ExportOutput) SetExportDescription(v *JournalS3ExportDescription) *DescribeJournalS3ExportOutput {
	s.ExportDescription = v
	return s
}

type DescribeLedgerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the ledger that you want to describe.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLedgerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLedgerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLedgerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLedgerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeLedgerInput) SetName(v string) *DescribeLedgerInput {
	s.Name = &v
	return s
}

type DescribeLedgerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the ledger.
	Arn *string `min:"20" type:"string"`

	// The date and time, in epoch time format, when the ledger was created. (Epoch
	// time format is the number of seconds elapsed since 12:00:00 AM January 1,
	// 1970 UTC.)
	CreationDateTime *time.Time `type:"timestamp"`

	// Specifies whether the ledger is protected from being deleted by any user.
	// If not defined during ledger creation, this feature is enabled (true) by
	// default.
	//
	// If deletion protection is enabled, you must first disable it before you can
	// delete the ledger. You can disable it by calling the UpdateLedger operation
	// to set this parameter to false.
	DeletionProtection *bool `type:"boolean"`

	// Information about the encryption of data at rest in the ledger. This includes
	// the current status, the KMS key, and when the key became inaccessible (in
	// the case of an error). If this parameter is undefined, the ledger uses an
	// Amazon Web Services owned KMS key for encryption.
	EncryptionDescription *LedgerEncryptionDescription `type:"structure"`

	// The name of the ledger.
	Name *string `min:"1" type:"string"`

	// The permissions mode of the ledger.
	PermissionsMode *string `type:"string" enum:"PermissionsMode"`

	// The current status of the ledger.
	State *string `type:"string" enum:"LedgerState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLedgerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLedgerOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeLedgerOutput) SetArn(v string) *DescribeLedgerOutput {
	s.Arn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeLedgerOutput) SetCreationDateTime(v time.Time) *DescribeLedgerOutput {
	s.CreationDateTime = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *DescribeLedgerOutput) SetDeletionProtection(v bool) *DescribeLedgerOutput {
	s.DeletionProtection = &v
	return s
}

// SetEncryptionDescription sets the EncryptionDescription field's value.
func (s *DescribeLedgerOutput) SetEncryptionDescription(v *LedgerEncryptionDescription) *DescribeLedgerOutput {
	s.EncryptionDescription = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeLedgerOutput) SetName(v string) *DescribeLedgerOutput {
	s.Name = &v
	return s
}

// SetPermissionsMode sets the PermissionsMode field's value.
func (s *DescribeLedgerOutput) SetPermissionsMode(v string) *DescribeLedgerOutput {
	s.PermissionsMode = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeLedgerOutput) SetState(v string) *DescribeLedgerOutput {
	s.State = &v
	return s
}

type ExportJournalToS3Input struct {
	_ struct{} `type:"structure"`

	// The exclusive end date and time for the range of journal contents to export.
	//
	// The ExclusiveEndTime must be in ISO 8601 date and time format and in Universal
	// Coordinated Time (UTC). For example: 2019-06-13T21:36:34Z.
	//
	// The ExclusiveEndTime must be less than or equal to the current UTC date and
	// time.
	//
	// ExclusiveEndTime is a required field
	ExclusiveEndTime *time.Time `type:"timestamp" required:"true"`

	// The inclusive start date and time for the range of journal contents to export.
	//
	// The InclusiveStartTime must be in ISO 8601 date and time format and in Universal
	// Coordinated Time (UTC). For example: 2019-06-13T21:36:34Z.
	//
	// The InclusiveStartTime must be before ExclusiveEndTime.
	//
	// If you provide an InclusiveStartTime that is before the ledger's CreationDateTime,
	// Amazon QLDB defaults it to the ledger's CreationDateTime.
	//
	// InclusiveStartTime is a required field
	InclusiveStartTime *time.Time `type:"timestamp" required:"true"`

	// The name of the ledger.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The output format of your exported journal data. A journal export job can
	// write the data objects in either the text or binary representation of Amazon
	// Ion (https://docs.aws.amazon.com/qldb/latest/developerguide/ion.html) format,
	// or in JSON Lines (https://jsonlines.org/) text format.
	//
	// Default: ION_TEXT
	//
	// In JSON Lines format, each journal block in an exported data object is a
	// valid JSON object that is delimited by a newline. You can use this format
	// to directly integrate JSON exports with analytics tools such as Amazon Athena
	// and Glue because these services can parse newline-delimited JSON automatically.
	OutputFormat *string `type:"string" enum:"OutputFormat"`

	// The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions
	// for a journal export job to do the following:
	//
	//    * Write objects into your Amazon S3 bucket.
	//
	//    * (Optional) Use your customer managed key in Key Management Service (KMS)
	//    for server-side encryption of your exported data.
	//
	// To pass a role to QLDB when requesting a journal export, you must have permissions
	// to perform the iam:PassRole action on the IAM role resource. This is required
	// for all journal export requests.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The configuration settings of the Amazon S3 bucket destination for your export
	// request.
	//
	// S3ExportConfiguration is a required field
	S3ExportConfiguration *S3ExportConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportJournalToS3Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportJournalToS3Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportJournalToS3Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportJournalToS3Input"}
	if s.ExclusiveEndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("ExclusiveEndTime"))
	}
	if s.InclusiveStartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("InclusiveStartTime"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.S3ExportConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3ExportConfiguration"))
	}
	if s.S3ExportConfiguration != nil {
		if err := s.S3ExportConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3ExportConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveEndTime sets the ExclusiveEndTime field's value.
func (s *ExportJournalToS3Input) SetExclusiveEndTime(v time.Time) *ExportJournalToS3Input {
	s.ExclusiveEndTime = &v
	return s
}

// SetInclusiveStartTime sets the InclusiveStartTime field's value.
func (s *ExportJournalToS3Input) SetInclusiveStartTime(v time.Time) *ExportJournalToS3Input {
	s.InclusiveStartTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ExportJournalToS3Input) SetName(v string) *ExportJournalToS3Input {
	s.Name = &v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *ExportJournalToS3Input) SetOutputFormat(v string) *ExportJournalToS3Input {
	s.OutputFormat = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ExportJournalToS3Input) SetRoleArn(v string) *ExportJournalToS3Input {
	s.RoleArn = &v
	return s
}

// SetS3ExportConfiguration sets the S3ExportConfiguration field's value.
func (s *ExportJournalToS3Input) SetS3ExportConfiguration(v *S3ExportConfiguration) *ExportJournalToS3Input {
	s.S3ExportConfiguration = v
	return s
}

type ExportJournalToS3Output struct {
	_ struct{} `type:"structure"`

	// The UUID (represented in Base62-encoded text) that QLDB assigns to each journal
	// export job.
	//
	// To describe your export request and check the status of the job, you can
	// use ExportId to call DescribeJournalS3Export.
	//
	// ExportId is a required field
	ExportId *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportJournalToS3Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportJournalToS3Output) GoString() string {
	return s.String()
}

// SetExportId sets the ExportId field's value.
func (s *ExportJournalToS3Output) SetExportId(v string) *ExportJournalToS3Output {
	s.ExportId = &v
	return s
}

type GetBlockInput struct {
	_ struct{} `type:"structure"`

	// The location of the block that you want to request. An address is an Amazon
	// Ion structure that has two fields: strandId and sequenceNo.
	//
	// For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}.
	//
	// BlockAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetBlockInput's
	// String and GoString methods.
	//
	// BlockAddress is a required field
	BlockAddress *ValueHolder `type:"structure" required:"true" sensitive:"true"`

	// The latest block location covered by the digest for which to request a proof.
	// An address is an Amazon Ion structure that has two fields: strandId and sequenceNo.
	//
	// For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}.
	//
	// DigestTipAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetBlockInput's
	// String and GoString methods.
	DigestTipAddress *ValueHolder `type:"structure" sensitive:"true"`

	// The name of the ledger.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBlockInput"}
	if s.BlockAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("BlockAddress"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.BlockAddress != nil {
		if err := s.BlockAddress.Validate(); err != nil {
			invalidParams.AddNested("BlockAddress", err.(request.ErrInvalidParams))
		}
	}
	if s.DigestTipAddress != nil {
		if err := s.DigestTipAddress.Validate(); err != nil {
			invalidParams.AddNested("DigestTipAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockAddress sets the BlockAddress field's value.
func (s *GetBlockInput) SetBlockAddress(v *ValueHolder) *GetBlockInput {
	s.BlockAddress = v
	return s
}

// SetDigestTipAddress sets the DigestTipAddress field's value.
func (s *GetBlockInput) SetDigestTipAddress(v *ValueHolder) *GetBlockInput {
	s.DigestTipAddress = v
	return s
}

// SetName sets the Name field's value.
func (s *GetBlockInput) SetName(v string) *GetBlockInput {
	s.Name = &v
	return s
}

type GetBlockOutput struct {
	_ struct{} `type:"structure"`

	// The block data object in Amazon Ion format.
	//
	// Block is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetBlockOutput's
	// String and GoString methods.
	//
	// Block is a required field
	Block *ValueHolder `type:"structure" required:"true" sensitive:"true"`

	// The proof object in Amazon Ion format returned by a GetBlock request. A proof
	// contains the list of hash values required to recalculate the specified digest
	// using a Merkle tree, starting with the specified block.
	//
	// Proof is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetBlockOutput's
	// String and GoString methods.
	Proof *ValueHolder `type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBlockOutput) GoString() string {
	return s.String()
}

// SetBlock sets the Block field's value.
func (s *GetBlockOutput) SetBlock(v *ValueHolder) *GetBlockOutput {
	s.Block = v
	return s
}

// SetProof sets the Proof field's value.
func (s *GetBlockOutput) SetProof(v *ValueHolder) *GetBlockOutput {
	s.Proof = v
	return s
}

type GetDigestInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the ledger.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDigestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDigestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDigestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDigestInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetDigestInput) SetName(v string) *GetDigestInput {
	s.Name = &v
	return s
}

type GetDigestOutput struct {
	_ struct{} `type:"structure"`

	// The 256-bit hash value representing the digest returned by a GetDigest request.
	// Digest is automatically base64 encoded/decoded by the SDK.
	//
	// Digest is a required field
	Digest []byte `min:"32" type:"blob" required:"true"`

	// The latest block location covered by the digest that you requested. An address
	// is an Amazon Ion structure that has two fields: strandId and sequenceNo.
	//
	// DigestTipAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetDigestOutput's
	// String and GoString methods.
	//
	// DigestTipAddress is a required field
	DigestTipAddress *ValueHolder `type:"structure" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDigestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDigestOutput) GoString() string {
	return s.String()
}

// SetDigest sets the Digest field's value.
func (s *GetDigestOutput) SetDigest(v []byte) *GetDigestOutput {
	s.Digest = v
	return s
}

// SetDigestTipAddress sets the DigestTipAddress field's value.
func (s *GetDigestOutput) SetDigestTipAddress(v *ValueHolder) *GetDigestOutput {
	s.DigestTipAddress = v
	return s
}

type GetRevisionInput struct {
	_ struct{} `type:"structure"`

	// The block location of the document revision to be verified. An address is
	// an Amazon Ion structure that has two fields: strandId and sequenceNo.
	//
	// For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}.
	//
	// BlockAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetRevisionInput's
	// String and GoString methods.
	//
	// BlockAddress is a required field
	BlockAddress *ValueHolder `type:"structure" required:"true" sensitive:"true"`

	// The latest block location covered by the digest for which to request a proof.
	// An address is an Amazon Ion structure that has two fields: strandId and sequenceNo.
	//
	// For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}.
	//
	// DigestTipAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetRevisionInput's
	// String and GoString methods.
	DigestTipAddress *ValueHolder `type:"structure" sensitive:"true"`

	// The UUID (represented in Base62-encoded text) of the document to be verified.
	//
	// DocumentId is a required field
	DocumentId *string `min:"22" type:"string" required:"true"`

	// The name of the ledger.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRevisionInput"}
	if s.BlockAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("BlockAddress"))
	}
	if s.DocumentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentId", 22))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.BlockAddress != nil {
		if err := s.BlockAddress.Validate(); err != nil {
			invalidParams.AddNested("BlockAddress", err.(request.ErrInvalidParams))
		}
	}
	if s.DigestTipAddress != nil {
		if err := s.DigestTipAddress.Validate(); err != nil {
			invalidParams.AddNested("DigestTipAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockAddress sets the BlockAddress field's value.
func (s *GetRevisionInput) SetBlockAddress(v *ValueHolder) *GetRevisionInput {
	s.BlockAddress = v
	return s
}

// SetDigestTipAddress sets the DigestTipAddress field's value.
func (s *GetRevisionInput) SetDigestTipAddress(v *ValueHolder) *GetRevisionInput {
	s.DigestTipAddress = v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *GetRevisionInput) SetDocumentId(v string) *GetRevisionInput {
	s.DocumentId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetRevisionInput) SetName(v string) *GetRevisionInput {
	s.Name = &v
	return s
}

type GetRevisionOutput struct {
	_ struct{} `type:"structure"`

	// The proof object in Amazon Ion format returned by a GetRevision request.
	// A proof contains the list of hash values that are required to recalculate
	// the specified digest using a Merkle tree, starting with the specified document
	// revision.
	//
	// Proof is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetRevisionOutput's
	// String and GoString methods.
	Proof *ValueHolder `type:"structure" sensitive:"true"`

	// The document revision data object in Amazon Ion format.
	//
	// Revision is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetRevisionOutput's
	// String and GoString methods.
	//
	// Revision is a required field
	Revision *ValueHolder `type:"structure" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRevisionOutput) GoString() string {
	return s.String()
}

// SetProof sets the Proof field's value.
func (s *GetRevisionOutput) SetProof(v *ValueHolder) *GetRevisionOutput {
	s.Proof = v
	return s
}

// SetRevision sets the Revision field's value.
func (s *GetRevisionOutput) SetRevision(v *ValueHolder) *GetRevisionOutput {
	s.Revision = v
	return s
}

// One or more parameters in the request aren't valid.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The name of the invalid parameter.
	ParameterName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about an Amazon QLDB journal stream, including the Amazon Resource
// Name (ARN), stream name, creation time, current status, and the parameters
// of the original stream creation request.
type JournalKinesisStreamDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the QLDB journal stream.
	Arn *string `min:"20" type:"string"`

	// The date and time, in epoch time format, when the QLDB journal stream was
	// created. (Epoch time format is the number of seconds elapsed since 12:00:00
	// AM January 1, 1970 UTC.)
	CreationTime *time.Time `type:"timestamp"`

	// The error message that describes the reason that a stream has a status of
	// IMPAIRED or FAILED. This is not applicable to streams that have other status
	// values.
	ErrorCause *string `type:"string" enum:"ErrorCause"`

	// The exclusive date and time that specifies when the stream ends. If this
	// parameter is undefined, the stream runs indefinitely until you cancel it.
	ExclusiveEndTime *time.Time `type:"timestamp"`

	// The inclusive start date and time from which to start streaming journal data.
	InclusiveStartTime *time.Time `type:"timestamp"`

	// The configuration settings of the Amazon Kinesis Data Streams destination
	// for a QLDB journal stream.
	//
	// KinesisConfiguration is a required field
	KinesisConfiguration *KinesisConfiguration `type:"structure" required:"true"`

	// The name of the ledger.
	//
	// LedgerName is a required field
	LedgerName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions
	// for a journal stream to write data records to a Kinesis Data Streams resource.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The current state of the QLDB journal stream.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"StreamStatus"`

	// The UUID (represented in Base62-encoded text) of the QLDB journal stream.
	//
	// StreamId is a required field
	StreamId *string `min:"22" type:"string" required:"true"`

	// The user-defined name of the QLDB journal stream.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JournalKinesisStreamDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JournalKinesisStreamDescription) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *JournalKinesisStreamDescription) SetArn(v string) *JournalKinesisStreamDescription {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *JournalKinesisStreamDescription) SetCreationTime(v time.Time) *JournalKinesisStreamDescription {
	s.CreationTime = &v
	return s
}

// SetErrorCause sets the ErrorCause field's value.
func (s *JournalKinesisStreamDescription) SetErrorCause(v string) *JournalKinesisStreamDescription {
	s.ErrorCause = &v
	return s
}

// SetExclusiveEndTime sets the ExclusiveEndTime field's value.
func (s *JournalKinesisStreamDescription) SetExclusiveEndTime(v time.Time) *JournalKinesisStreamDescription {
	s.ExclusiveEndTime = &v
	return s
}

// SetInclusiveStartTime sets the InclusiveStartTime field's value.
func (s *JournalKinesisStreamDescription) SetInclusiveStartTime(v time.Time) *JournalKinesisStreamDescription {
	s.InclusiveStartTime = &v
	return s
}

// SetKinesisConfiguration sets the KinesisConfiguration field's value.
func (s *JournalKinesisStreamDescription) SetKinesisConfiguration(v *KinesisConfiguration) *JournalKinesisStreamDescription {
	s.KinesisConfiguration = v
	return s
}

// SetLedgerName sets the LedgerName field's value.
func (s *JournalKinesisStreamDescription) SetLedgerName(v string) *JournalKinesisStreamDescription {
	s.LedgerName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *JournalKinesisStreamDescription) SetRoleArn(v string) *JournalKinesisStreamDescription {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JournalKinesisStreamDescription) SetStatus(v string) *JournalKinesisStreamDescription {
	s.Status = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *JournalKinesisStreamDescription) SetStreamId(v string) *JournalKinesisStreamDescription {
	s.StreamId = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *JournalKinesisStreamDescription) SetStreamName(v string) *JournalKinesisStreamDescription {
	s.StreamName = &v
	return s
}

// Information about a journal export job, including the ledger name, export
// ID, creation time, current status, and the parameters of the original export
// creation request.
type JournalS3ExportDescription struct {
	_ struct{} `type:"structure"`

	// The exclusive end date and time for the range of journal contents that was
	// specified in the original export request.
	//
	// ExclusiveEndTime is a required field
	ExclusiveEndTime *time.Time `type:"timestamp" required:"true"`

	// The date and time, in epoch time format, when the export job was created.
	// (Epoch time format is the number of seconds elapsed since 12:00:00 AM January
	// 1, 1970 UTC.)
	//
	// ExportCreationTime is a required field
	ExportCreationTime *time.Time `type:"timestamp" required:"true"`

	// The UUID (represented in Base62-encoded text) of the journal export job.
	//
	// ExportId is a required field
	ExportId *string `min:"22" type:"string" required:"true"`

	// The inclusive start date and time for the range of journal contents that
	// was specified in the original export request.
	//
	// InclusiveStartTime is a required field
	InclusiveStartTime *time.Time `type:"timestamp" required:"true"`

	// The name of the ledger.
	//
	// LedgerName is a required field
	LedgerName *string `min:"1" type:"string" required:"true"`

	// The output format of the exported journal data.
	OutputFormat *string `type:"string" enum:"OutputFormat"`

	// The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions
	// for a journal export job to do the following:
	//
	//    * Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
	//
	//    * (Optional) Use your customer managed key in Key Management Service (KMS)
	//    for server-side encryption of your exported data.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The Amazon Simple Storage Service (Amazon S3) bucket location in which a
	// journal export job writes the journal contents.
	//
	// S3ExportConfiguration is a required field
	S3ExportConfiguration *S3ExportConfiguration `type:"structure" required:"true"`

	// The current state of the journal export job.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ExportStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JournalS3ExportDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JournalS3ExportDescription) GoString() string {
	return s.String()
}

// SetExclusiveEndTime sets the ExclusiveEndTime field's value.
func (s *JournalS3ExportDescription) SetExclusiveEndTime(v time.Time) *JournalS3ExportDescription {
	s.ExclusiveEndTime = &v
	return s
}

// SetExportCreationTime sets the ExportCreationTime field's value.
func (s *JournalS3ExportDescription) SetExportCreationTime(v time.Time) *JournalS3ExportDescription {
	s.ExportCreationTime = &v
	return s
}

// SetExportId sets the ExportId field's value.
func (s *JournalS3ExportDescription) SetExportId(v string) *JournalS3ExportDescription {
	s.ExportId = &v
	return s
}

// SetInclusiveStartTime sets the InclusiveStartTime field's value.
func (s *JournalS3ExportDescription) SetInclusiveStartTime(v time.Time) *JournalS3ExportDescription {
	s.InclusiveStartTime = &v
	return s
}

// SetLedgerName sets the LedgerName field's value.
func (s *JournalS3ExportDescription) SetLedgerName(v string) *JournalS3ExportDescription {
	s.LedgerName = &v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *JournalS3ExportDescription) SetOutputFormat(v string) *JournalS3ExportDescription {
	s.OutputFormat = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *JournalS3ExportDescription) SetRoleArn(v string) *JournalS3ExportDescription {
	s.RoleArn = &v
	return s
}

// SetS3ExportConfiguration sets the S3ExportConfiguration field's value.
func (s *JournalS3ExportDescription) SetS3ExportConfiguration(v *S3ExportConfiguration) *JournalS3ExportDescription {
	s.S3ExportConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *JournalS3ExportDescription) SetStatus(v string) *JournalS3ExportDescription {
	s.Status = &v
	return s
}

// The configuration settings of the Amazon Kinesis Data Streams destination
// for an Amazon QLDB journal stream.
type KinesisConfiguration struct {
	_ struct{} `type:"structure"`

	// Enables QLDB to publish multiple data records in a single Kinesis Data Streams
	// record, increasing the number of records sent per API call.
	//
	// Default: True
	//
	// Record aggregation has important implications for processing records and
	// requires de-aggregation in your stream consumer. To learn more, see KPL Key
	// Concepts (https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html)
	// and Consumer De-aggregation (https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html)
	// in the Amazon Kinesis Data Streams Developer Guide.
	AggregationEnabled *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
	//
	// StreamArn is a required field
	StreamArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisConfiguration"}
	if s.StreamArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamArn"))
	}
	if s.StreamArn != nil && len(*s.StreamArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("StreamArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregationEnabled sets the AggregationEnabled field's value.
func (s *KinesisConfiguration) SetAggregationEnabled(v bool) *KinesisConfiguration {
	s.AggregationEnabled = &v
	return s
}

// SetStreamArn sets the StreamArn field's value.
func (s *KinesisConfiguration) SetStreamArn(v string) *KinesisConfiguration {
	s.StreamArn = &v
	return s
}

// Information about the encryption of data at rest in an Amazon QLDB ledger.
// This includes the current status, the key in Key Management Service (KMS),
// and when the key became inaccessible (in the case of an error).
//
// For more information, see Encryption at rest (https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html)
// in the Amazon QLDB Developer Guide.
type LedgerEncryptionDescription struct {
	_ struct{} `type:"structure"`

	// The current state of encryption at rest for the ledger. This can be one of
	// the following values:
	//
	//    * ENABLED: Encryption is fully enabled using the specified key.
	//
	//    * UPDATING: The ledger is actively processing the specified key change.
	//    Key changes in QLDB are asynchronous. The ledger is fully accessible without
	//    any performance impact while the key change is being processed. The amount
	//    of time it takes to update a key varies depending on the ledger size.
	//
	//    * KMS_KEY_INACCESSIBLE: The specified customer managed KMS key is not
	//    accessible, and the ledger is impaired. Either the key was disabled or
	//    deleted, or the grants on the key were revoked. When a ledger is impaired,
	//    it is not accessible and does not accept any read or write requests. An
	//    impaired ledger automatically returns to an active state after you restore
	//    the grants on the key, or re-enable the key that was disabled. However,
	//    deleting a customer managed KMS key is irreversible. After a key is deleted,
	//    you can no longer access the ledgers that are protected with that key,
	//    and the data becomes unrecoverable permanently.
	//
	// EncryptionStatus is a required field
	EncryptionStatus *string `type:"string" required:"true" enum:"EncryptionStatus"`

	// The date and time, in epoch time format, when the KMS key first became inaccessible,
	// in the case of an error. (Epoch time format is the number of seconds that
	// have elapsed since 12:00:00 AM January 1, 1970 UTC.)
	//
	// This parameter is undefined if the KMS key is accessible.
	InaccessibleKmsKeyDateTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the customer managed KMS key that the ledger
	// uses for encryption at rest. If this parameter is undefined, the ledger uses
	// an Amazon Web Services owned KMS key for encryption. It will display AWS_OWNED_KMS_KEY
	// when updating the ledger's encryption configuration to the Amazon Web Services
	// owned KMS key.
	//
	// KmsKeyArn is a required field
	KmsKeyArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LedgerEncryptionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LedgerEncryptionDescription) GoString() string {
	return s.String()
}

// SetEncryptionStatus sets the EncryptionStatus field's value.
func (s *LedgerEncryptionDescription) SetEncryptionStatus(v string) *LedgerEncryptionDescription {
	s.EncryptionStatus = &v
	return s
}

// SetInaccessibleKmsKeyDateTime sets the InaccessibleKmsKeyDateTime field's value.
func (s *LedgerEncryptionDescription) SetInaccessibleKmsKeyDateTime(v time.Time) *LedgerEncryptionDescription {
	s.InaccessibleKmsKeyDateTime = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *LedgerEncryptionDescription) SetKmsKeyArn(v string) *LedgerEncryptionDescription {
	s.KmsKeyArn = &v
	return s
}

// Information about a ledger, including its name, state, and when it was created.
type LedgerSummary struct {
	_ struct{} `type:"structure"`

	// The date and time, in epoch time format, when the ledger was created. (Epoch
	// time format is the number of seconds elapsed since 12:00:00 AM January 1,
	// 1970 UTC.)
	CreationDateTime *time.Time `type:"timestamp"`

	// The name of the ledger.
	Name *string `min:"1" type:"string"`

	// The current status of the ledger.
	State *string `type:"string" enum:"LedgerState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LedgerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LedgerSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *LedgerSummary) SetCreationDateTime(v time.Time) *LedgerSummary {
	s.CreationDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *LedgerSummary) SetName(v string) *LedgerSummary {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *LedgerSummary) SetState(v string) *LedgerSummary {
	s.State = &v
	return s
}

// You have reached the limit on the maximum number of resources allowed.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The type of resource.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListJournalKinesisStreamsForLedgerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the ledger.
	//
	// LedgerName is a required field
	LedgerName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in a single ListJournalKinesisStreamsForLedger
	// request. (The actual number of results returned might be fewer.)
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// A pagination token, indicating that you want to retrieve the next page of
	// results. If you received a value for NextToken in the response from a previous
	// ListJournalKinesisStreamsForLedger call, you should use that value as input
	// here.
	NextToken *string `location:"querystring" locationName:"next_token" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJournalKinesisStreamsForLedgerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJournalKinesisStreamsForLedgerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJournalKinesisStreamsForLedgerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJournalKinesisStreamsForLedgerInput"}
	if s.LedgerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LedgerName"))
	}
	if s.LedgerName != nil && len(*s.LedgerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LedgerName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLedgerName sets the LedgerName field's value.
func (s *ListJournalKinesisStreamsForLedgerInput) SetLedgerName(v string) *ListJournalKinesisStreamsForLedgerInput {
	s.LedgerName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJournalKinesisStreamsForLedgerInput) SetMaxResults(v int64) *ListJournalKinesisStreamsForLedgerInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJournalKinesisStreamsForLedgerInput) SetNextToken(v string) *ListJournalKinesisStreamsForLedgerInput {
	s.NextToken = &v
	return s
}

type ListJournalKinesisStreamsForLedgerOutput struct {
	_ struct{} `type:"structure"`

	//    * If NextToken is empty, the last page of results has been processed and
	//    there are no more results to be retrieved.
	//
	//    * If NextToken is not empty, more results are available. To retrieve the
	//    next page of results, use the value of NextToken in a subsequent ListJournalKinesisStreamsForLedger
	//    call.
	NextToken *string `min:"4" type:"string"`

	// The QLDB journal streams that are currently associated with the given ledger.
	Streams []*JournalKinesisStreamDescription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJournalKinesisStreamsForLedgerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJournalKinesisStreamsForLedgerOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListJournalKinesisStreamsForLedgerOutput) SetNextToken(v string) *ListJournalKinesisStreamsForLedgerOutput {
	s.NextToken = &v
	return s
}

// SetStreams sets the Streams field's value.
func (s *ListJournalKinesisStreamsForLedgerOutput) SetStreams(v []*JournalKinesisStreamDescription) *ListJournalKinesisStreamsForLedgerOutput {
	s.Streams = v
	return s
}

type ListJournalS3ExportsForLedgerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in a single ListJournalS3ExportsForLedger
	// request. (The actual number of results returned might be fewer.)
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// The name of the ledger.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// A pagination token, indicating that you want to retrieve the next page of
	// results. If you received a value for NextToken in the response from a previous
	// ListJournalS3ExportsForLedger call, then you should use that value as input
	// here.
	NextToken *string `location:"querystring" locationName:"next_token" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJournalS3ExportsForLedgerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJournalS3ExportsForLedgerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJournalS3ExportsForLedgerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJournalS3ExportsForLedgerInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJournalS3ExportsForLedgerInput) SetMaxResults(v int64) *ListJournalS3ExportsForLedgerInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListJournalS3ExportsForLedgerInput) SetName(v string) *ListJournalS3ExportsForLedgerInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJournalS3ExportsForLedgerInput) SetNextToken(v string) *ListJournalS3ExportsForLedgerInput {
	s.NextToken = &v
	return s
}

type ListJournalS3ExportsForLedgerOutput struct {
	_ struct{} `type:"structure"`

	// The journal export jobs that are currently associated with the specified
	// ledger.
	JournalS3Exports []*JournalS3ExportDescription `type:"list"`

	//    * If NextToken is empty, then the last page of results has been processed
	//    and there are no more results to be retrieved.
	//
	//    * If NextToken is not empty, then there are more results available. To
	//    retrieve the next page of results, use the value of NextToken in a subsequent
	//    ListJournalS3ExportsForLedger call.
	NextToken *string `min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJournalS3ExportsForLedgerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJournalS3ExportsForLedgerOutput) GoString() string {
	return s.String()
}

// SetJournalS3Exports sets the JournalS3Exports field's value.
func (s *ListJournalS3ExportsForLedgerOutput) SetJournalS3Exports(v []*JournalS3ExportDescription) *ListJournalS3ExportsForLedgerOutput {
	s.JournalS3Exports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJournalS3ExportsForLedgerOutput) SetNextToken(v string) *ListJournalS3ExportsForLedgerOutput {
	s.NextToken = &v
	return s
}

type ListJournalS3ExportsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in a single ListJournalS3Exports
	// request. (The actual number of results returned might be fewer.)
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// A pagination token, indicating that you want to retrieve the next page of
	// results. If you received a value for NextToken in the response from a previous
	// ListJournalS3Exports call, then you should use that value as input here.
	NextToken *string `location:"querystring" locationName:"next_token" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJournalS3ExportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJournalS3ExportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJournalS3ExportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJournalS3ExportsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJournalS3ExportsInput) SetMaxResults(v int64) *ListJournalS3ExportsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJournalS3ExportsInput) SetNextToken(v string) *ListJournalS3ExportsInput {
	s.NextToken = &v
	return s
}

type ListJournalS3ExportsOutput struct {
	_ struct{} `type:"structure"`

	// The journal export jobs for all ledgers that are associated with the current
	// Amazon Web Services account and Region.
	JournalS3Exports []*JournalS3ExportDescription `type:"list"`

	//    * If NextToken is empty, then the last page of results has been processed
	//    and there are no more results to be retrieved.
	//
	//    * If NextToken is not empty, then there are more results available. To
	//    retrieve the next page of results, use the value of NextToken in a subsequent
	//    ListJournalS3Exports call.
	NextToken *string `min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJournalS3ExportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJournalS3ExportsOutput) GoString() string {
	return s.String()
}

// SetJournalS3Exports sets the JournalS3Exports field's value.
func (s *ListJournalS3ExportsOutput) SetJournalS3Exports(v []*JournalS3ExportDescription) *ListJournalS3ExportsOutput {
	s.JournalS3Exports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJournalS3ExportsOutput) SetNextToken(v string) *ListJournalS3ExportsOutput {
	s.NextToken = &v
	return s
}

type ListLedgersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in a single ListLedgers request.
	// (The actual number of results returned might be fewer.)
	MaxResults *int64 `location:"querystring" locationName:"max_results" min:"1" type:"integer"`

	// A pagination token, indicating that you want to retrieve the next page of
	// results. If you received a value for NextToken in the response from a previous
	// ListLedgers call, then you should use that value as input here.
	NextToken *string `location:"querystring" locationName:"next_token" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLedgersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLedgersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLedgersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLedgersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLedgersInput) SetMaxResults(v int64) *ListLedgersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLedgersInput) SetNextToken(v string) *ListLedgersInput {
	s.NextToken = &v
	return s
}

type ListLedgersOutput struct {
	_ struct{} `type:"structure"`

	// The ledgers that are associated with the current Amazon Web Services account
	// and Region.
	Ledgers []*LedgerSummary `type:"list"`

	// A pagination token, indicating whether there are more results available:
	//
	//    * If NextToken is empty, then the last page of results has been processed
	//    and there are no more results to be retrieved.
	//
	//    * If NextToken is not empty, then there are more results available. To
	//    retrieve the next page of results, use the value of NextToken in a subsequent
	//    ListLedgers call.
	NextToken *string `min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLedgersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLedgersOutput) GoString() string {
	return s.String()
}

// SetLedgers sets the Ledgers field's value.
func (s *ListLedgersOutput) SetLedgers(v []*LedgerSummary) *ListLedgersOutput {
	s.Ledgers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLedgersOutput) SetNextToken(v string) *ListLedgersOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) for which to list the tags. For example:
	//
	// arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags that are currently associated with the specified Amazon QLDB resource.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The specified resource already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The name of the resource.
	ResourceName *string `type:"string"`

	// The type of resource.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource can't be modified at this time.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The name of the resource.
	ResourceName *string `type:"string"`

	// The type of resource.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The name of the resource.
	ResourceName *string `type:"string"`

	// The type of resource.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because a condition wasn't satisfied in advance.
type ResourcePreconditionNotMetException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The name of the resource.
	ResourceName *string `type:"string"`

	// The type of resource.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourcePreconditionNotMetException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourcePreconditionNotMetException) GoString() string {
	return s.String()
}

func newErrorResourcePreconditionNotMetException(v protocol.ResponseMetadata) error {
	return &ResourcePreconditionNotMetException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourcePreconditionNotMetException) Code() string {
	return "ResourcePreconditionNotMetException"
}

// Message returns the exception's message.
func (s *ResourcePreconditionNotMetException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourcePreconditionNotMetException) OrigErr() error {
	return nil
}

func (s *ResourcePreconditionNotMetException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourcePreconditionNotMetException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourcePreconditionNotMetException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The encryption settings that are used by a journal export job to write data
// in an Amazon Simple Storage Service (Amazon S3) bucket.
type S3EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a symmetric encryption key in Key Management
	// Service (KMS). Amazon S3 does not support asymmetric KMS keys.
	//
	// You must provide a KmsKeyArn if you specify SSE_KMS as the ObjectEncryptionType.
	//
	// KmsKeyArn is not required if you specify SSE_S3 as the ObjectEncryptionType.
	KmsKeyArn *string `min:"20" type:"string"`

	// The Amazon S3 object encryption type.
	//
	// To learn more about server-side encryption options in Amazon S3, see Protecting
	// Data Using Server-Side Encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html)
	// in the Amazon S3 Developer Guide.
	//
	// ObjectEncryptionType is a required field
	ObjectEncryptionType *string `type:"string" required:"true" enum:"S3ObjectEncryptionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3EncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3EncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3EncryptionConfiguration"}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 20))
	}
	if s.ObjectEncryptionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectEncryptionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *S3EncryptionConfiguration) SetKmsKeyArn(v string) *S3EncryptionConfiguration {
	s.KmsKeyArn = &v
	return s
}

// SetObjectEncryptionType sets the ObjectEncryptionType field's value.
func (s *S3EncryptionConfiguration) SetObjectEncryptionType(v string) *S3EncryptionConfiguration {
	s.ObjectEncryptionType = &v
	return s
}

// The Amazon Simple Storage Service (Amazon S3) bucket location in which a
// journal export job writes the journal contents.
type S3ExportConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket name in which a journal export job writes the journal
	// contents.
	//
	// The bucket name must comply with the Amazon S3 bucket naming conventions.
	// For more information, see Bucket Restrictions and Limitations (https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html)
	// in the Amazon S3 Developer Guide.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The encryption settings that are used by a journal export job to write data
	// in an Amazon S3 bucket.
	//
	// EncryptionConfiguration is a required field
	EncryptionConfiguration *S3EncryptionConfiguration `type:"structure" required:"true"`

	// The prefix for the Amazon S3 bucket in which a journal export job writes
	// the journal contents.
	//
	// The prefix must comply with Amazon S3 key naming rules and restrictions.
	// For more information, see Object Key and Metadata (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html)
	// in the Amazon S3 Developer Guide.
	//
	// The following are examples of valid Prefix values:
	//
	//    * JournalExports-ForMyLedger/Testing/
	//
	//    * JournalExports
	//
	//    * My:Tests/
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ExportConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ExportConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ExportConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ExportConfiguration"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.EncryptionConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionConfiguration"))
	}
	if s.Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("Prefix"))
	}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3ExportConfiguration) SetBucket(v string) *S3ExportConfiguration {
	s.Bucket = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *S3ExportConfiguration) SetEncryptionConfiguration(v *S3EncryptionConfiguration) *S3ExportConfiguration {
	s.EncryptionConfiguration = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3ExportConfiguration) SetPrefix(v string) *S3ExportConfiguration {
	s.Prefix = &v
	return s
}

type StreamJournalToKinesisInput struct {
	_ struct{} `type:"structure"`

	// The exclusive date and time that specifies when the stream ends. If you don't
	// define this parameter, the stream runs indefinitely until you cancel it.
	//
	// The ExclusiveEndTime must be in ISO 8601 date and time format and in Universal
	// Coordinated Time (UTC). For example: 2019-06-13T21:36:34Z.
	ExclusiveEndTime *time.Time `type:"timestamp"`

	// The inclusive start date and time from which to start streaming journal data.
	// This parameter must be in ISO 8601 date and time format and in Universal
	// Coordinated Time (UTC). For example: 2019-06-13T21:36:34Z.
	//
	// The InclusiveStartTime cannot be in the future and must be before ExclusiveEndTime.
	//
	// If you provide an InclusiveStartTime that is before the ledger's CreationDateTime,
	// QLDB effectively defaults it to the ledger's CreationDateTime.
	//
	// InclusiveStartTime is a required field
	InclusiveStartTime *time.Time `type:"timestamp" required:"true"`

	// The configuration settings of the Kinesis Data Streams destination for your
	// stream request.
	//
	// KinesisConfiguration is a required field
	KinesisConfiguration *KinesisConfiguration `type:"structure" required:"true"`

	// The name of the ledger.
	//
	// LedgerName is a required field
	LedgerName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions
	// for a journal stream to write data records to a Kinesis Data Streams resource.
	//
	// To pass a role to QLDB when requesting a journal stream, you must have permissions
	// to perform the iam:PassRole action on the IAM role resource. This is required
	// for all journal stream requests.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The name that you want to assign to the QLDB journal stream. User-defined
	// names can help identify and indicate the purpose of a stream.
	//
	// Your stream name must be unique among other active streams for a given ledger.
	// Stream names have the same naming constraints as ledger names, as defined
	// in Quotas in Amazon QLDB (https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming)
	// in the Amazon QLDB Developer Guide.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`

	// The key-value pairs to add as tags to the stream that you want to create.
	// Tag keys are case sensitive. Tag values are case sensitive and can be null.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamJournalToKinesisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamJournalToKinesisInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamJournalToKinesisInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamJournalToKinesisInput"}
	if s.InclusiveStartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("InclusiveStartTime"))
	}
	if s.KinesisConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("KinesisConfiguration"))
	}
	if s.LedgerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LedgerName"))
	}
	if s.LedgerName != nil && len(*s.LedgerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LedgerName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}
	if s.KinesisConfiguration != nil {
		if err := s.KinesisConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KinesisConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveEndTime sets the ExclusiveEndTime field's value.
func (s *StreamJournalToKinesisInput) SetExclusiveEndTime(v time.Time) *StreamJournalToKinesisInput {
	s.ExclusiveEndTime = &v
	return s
}

// SetInclusiveStartTime sets the InclusiveStartTime field's value.
func (s *StreamJournalToKinesisInput) SetInclusiveStartTime(v time.Time) *StreamJournalToKinesisInput {
	s.InclusiveStartTime = &v
	return s
}

// SetKinesisConfiguration sets the KinesisConfiguration field's value.
func (s *StreamJournalToKinesisInput) SetKinesisConfiguration(v *KinesisConfiguration) *StreamJournalToKinesisInput {
	s.KinesisConfiguration = v
	return s
}

// SetLedgerName sets the LedgerName field's value.
func (s *StreamJournalToKinesisInput) SetLedgerName(v string) *StreamJournalToKinesisInput {
	s.LedgerName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StreamJournalToKinesisInput) SetRoleArn(v string) *StreamJournalToKinesisInput {
	s.RoleArn = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *StreamJournalToKinesisInput) SetStreamName(v string) *StreamJournalToKinesisInput {
	s.StreamName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StreamJournalToKinesisInput) SetTags(v map[string]*string) *StreamJournalToKinesisInput {
	s.Tags = v
	return s
}

type StreamJournalToKinesisOutput struct {
	_ struct{} `type:"structure"`

	// The UUID (represented in Base62-encoded text) that QLDB assigns to each QLDB
	// journal stream.
	StreamId *string `min:"22" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamJournalToKinesisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamJournalToKinesisOutput) GoString() string {
	return s.String()
}

// SetStreamId sets the StreamId field's value.
func (s *StreamJournalToKinesisOutput) SetStreamId(v string) *StreamJournalToKinesisOutput {
	s.StreamId = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) to which you want to add the tags. For example:
	//
	// arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The key-value pairs to add as tags to the specified QLDB resource. Tag keys
	// are case sensitive. If you specify a key that already exists for the resource,
	// your request fails and returns an error. Tag values are case sensitive and
	// can be null.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) from which to remove the tags. For example:
	//
	// arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The list of tag keys to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateLedgerInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the ledger is protected from being deleted by any user.
	// If not defined during ledger creation, this feature is enabled (true) by
	// default.
	//
	// If deletion protection is enabled, you must first disable it before you can
	// delete the ledger. You can disable it by calling the UpdateLedger operation
	// to set this parameter to false.
	DeletionProtection *bool `type:"boolean"`

	// The key in Key Management Service (KMS) to use for encryption of data at
	// rest in the ledger. For more information, see Encryption at rest (https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html)
	// in the Amazon QLDB Developer Guide.
	//
	// Use one of the following options to specify this parameter:
	//
	//    * AWS_OWNED_KMS_KEY: Use an KMS key that is owned and managed by Amazon
	//    Web Services on your behalf.
	//
	//    * Undefined: Make no changes to the KMS key of the ledger.
	//
	//    * A valid symmetric customer managed KMS key: Use the specified symmetric
	//    encryption KMS key in your account that you create, own, and manage. Amazon
	//    QLDB does not support asymmetric keys. For more information, see Using
	//    symmetric and asymmetric keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
	//    in the Key Management Service Developer Guide.
	//
	// To specify a customer managed KMS key, you can use its key ID, Amazon Resource
	// Name (ARN), alias name, or alias ARN. When using an alias name, prefix it
	// with "alias/". To specify a key in a different Amazon Web Services account,
	// you must use the key ARN or alias ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// For more information, see Key identifiers (KeyId) (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id)
	// in the Key Management Service Developer Guide.
	KmsKey *string `type:"string"`

	// The name of the ledger.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLedgerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLedgerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLedgerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLedgerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *UpdateLedgerInput) SetDeletionProtection(v bool) *UpdateLedgerInput {
	s.DeletionProtection = &v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *UpdateLedgerInput) SetKmsKey(v string) *UpdateLedgerInput {
	s.KmsKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateLedgerInput) SetName(v string) *UpdateLedgerInput {
	s.Name = &v
	return s
}

type UpdateLedgerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the ledger.
	Arn *string `min:"20" type:"string"`

	// The date and time, in epoch time format, when the ledger was created. (Epoch
	// time format is the number of seconds elapsed since 12:00:00 AM January 1,
	// 1970 UTC.)
	CreationDateTime *time.Time `type:"timestamp"`

	// Specifies whether the ledger is protected from being deleted by any user.
	// If not defined during ledger creation, this feature is enabled (true) by
	// default.
	//
	// If deletion protection is enabled, you must first disable it before you can
	// delete the ledger. You can disable it by calling the UpdateLedger operation
	// to set this parameter to false.
	DeletionProtection *bool `type:"boolean"`

	// Information about the encryption of data at rest in the ledger. This includes
	// the current status, the KMS key, and when the key became inaccessible (in
	// the case of an error).
	EncryptionDescription *LedgerEncryptionDescription `type:"structure"`

	// The name of the ledger.
	Name *string `min:"1" type:"string"`

	// The current status of the ledger.
	State *string `type:"string" enum:"LedgerState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLedgerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLedgerOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateLedgerOutput) SetArn(v string) *UpdateLedgerOutput {
	s.Arn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *UpdateLedgerOutput) SetCreationDateTime(v time.Time) *UpdateLedgerOutput {
	s.CreationDateTime = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *UpdateLedgerOutput) SetDeletionProtection(v bool) *UpdateLedgerOutput {
	s.DeletionProtection = &v
	return s
}

// SetEncryptionDescription sets the EncryptionDescription field's value.
func (s *UpdateLedgerOutput) SetEncryptionDescription(v *LedgerEncryptionDescription) *UpdateLedgerOutput {
	s.EncryptionDescription = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateLedgerOutput) SetName(v string) *UpdateLedgerOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateLedgerOutput) SetState(v string) *UpdateLedgerOutput {
	s.State = &v
	return s
}

type UpdateLedgerPermissionsModeInput struct {
	_ struct{} `type:"structure"`

	// The name of the ledger.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The permissions mode to assign to the ledger. This parameter can have one
	// of the following values:
	//
	//    * ALLOW_ALL: A legacy permissions mode that enables access control with
	//    API-level granularity for ledgers. This mode allows users who have the
	//    SendCommand API permission for this ledger to run all PartiQL commands
	//    (hence, ALLOW_ALL) on any tables in the specified ledger. This mode disregards
	//    any table-level or command-level IAM permissions policies that you create
	//    for the ledger.
	//
	//    * STANDARD: (Recommended) A permissions mode that enables access control
	//    with finer granularity for ledgers, tables, and PartiQL commands. By default,
	//    this mode denies all user requests to run any PartiQL commands on any
	//    tables in this ledger. To allow PartiQL commands to run, you must create
	//    IAM permissions policies for specific table resources and PartiQL actions,
	//    in addition to the SendCommand API permission for the ledger. For information,
	//    see Getting started with the standard permissions mode (https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html)
	//    in the Amazon QLDB Developer Guide.
	//
	// We strongly recommend using the STANDARD permissions mode to maximize the
	// security of your ledger data.
	//
	// PermissionsMode is a required field
	PermissionsMode *string `type:"string" required:"true" enum:"PermissionsMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLedgerPermissionsModeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLedgerPermissionsModeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLedgerPermissionsModeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLedgerPermissionsModeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PermissionsMode == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionsMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateLedgerPermissionsModeInput) SetName(v string) *UpdateLedgerPermissionsModeInput {
	s.Name = &v
	return s
}

// SetPermissionsMode sets the PermissionsMode field's value.
func (s *UpdateLedgerPermissionsModeInput) SetPermissionsMode(v string) *UpdateLedgerPermissionsModeInput {
	s.PermissionsMode = &v
	return s
}

type UpdateLedgerPermissionsModeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the ledger.
	Arn *string `min:"20" type:"string"`

	// The name of the ledger.
	Name *string `min:"1" type:"string"`

	// The current permissions mode of the ledger.
	PermissionsMode *string `type:"string" enum:"PermissionsMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLedgerPermissionsModeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLedgerPermissionsModeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateLedgerPermissionsModeOutput) SetArn(v string) *UpdateLedgerPermissionsModeOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateLedgerPermissionsModeOutput) SetName(v string) *UpdateLedgerPermissionsModeOutput {
	s.Name = &v
	return s
}

// SetPermissionsMode sets the PermissionsMode field's value.
func (s *UpdateLedgerPermissionsModeOutput) SetPermissionsMode(v string) *UpdateLedgerPermissionsModeOutput {
	s.PermissionsMode = &v
	return s
}

// A structure that can contain a value in multiple encoding formats.
type ValueHolder struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// An Amazon Ion plaintext value contained in a ValueHolder structure.
	//
	// IonText is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ValueHolder's
	// String and GoString methods.
	IonText *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValueHolder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValueHolder) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValueHolder) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValueHolder"}
	if s.IonText != nil && len(*s.IonText) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IonText", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIonText sets the IonText field's value.
func (s *ValueHolder) SetIonText(v string) *ValueHolder {
	s.IonText = &v
	return s
}

const (
	// EncryptionStatusEnabled is a EncryptionStatus enum value
	EncryptionStatusEnabled = "ENABLED"

	// EncryptionStatusUpdating is a EncryptionStatus enum value
	EncryptionStatusUpdating = "UPDATING"

	// EncryptionStatusKmsKeyInaccessible is a EncryptionStatus enum value
	EncryptionStatusKmsKeyInaccessible = "KMS_KEY_INACCESSIBLE"
)

// EncryptionStatus_Values returns all elements of the EncryptionStatus enum
func EncryptionStatus_Values() []string {
	return []string{
		EncryptionStatusEnabled,
		EncryptionStatusUpdating,
		EncryptionStatusKmsKeyInaccessible,
	}
}

const (
	// ErrorCauseKinesisStreamNotFound is a ErrorCause enum value
	ErrorCauseKinesisStreamNotFound = "KINESIS_STREAM_NOT_FOUND"

	// ErrorCauseIamPermissionRevoked is a ErrorCause enum value
	ErrorCauseIamPermissionRevoked = "IAM_PERMISSION_REVOKED"
)

// ErrorCause_Values returns all elements of the ErrorCause enum
func ErrorCause_Values() []string {
	return []string{
		ErrorCauseKinesisStreamNotFound,
		ErrorCauseIamPermissionRevoked,
	}
}

const (
	// ExportStatusInProgress is a ExportStatus enum value
	ExportStatusInProgress = "IN_PROGRESS"

	// ExportStatusCompleted is a ExportStatus enum value
	ExportStatusCompleted = "COMPLETED"

	// ExportStatusCancelled is a ExportStatus enum value
	ExportStatusCancelled = "CANCELLED"
)

// ExportStatus_Values returns all elements of the ExportStatus enum
func ExportStatus_Values() []string {
	return []string{
		ExportStatusInProgress,
		ExportStatusCompleted,
		ExportStatusCancelled,
	}
}

const (
	// LedgerStateCreating is a LedgerState enum value
	LedgerStateCreating = "CREATING"

	// LedgerStateActive is a LedgerState enum value
	LedgerStateActive = "ACTIVE"

	// LedgerStateDeleting is a LedgerState enum value
	LedgerStateDeleting = "DELETING"

	// LedgerStateDeleted is a LedgerState enum value
	LedgerStateDeleted = "DELETED"
)

// LedgerState_Values returns all elements of the LedgerState enum
func LedgerState_Values() []string {
	return []string{
		LedgerStateCreating,
		LedgerStateActive,
		LedgerStateDeleting,
		LedgerStateDeleted,
	}
}

const (
	// OutputFormatIonBinary is a OutputFormat enum value
	OutputFormatIonBinary = "ION_BINARY"

	// OutputFormatIonText is a OutputFormat enum value
	OutputFormatIonText = "ION_TEXT"

	// OutputFormatJson is a OutputFormat enum value
	OutputFormatJson = "JSON"
)

// OutputFormat_Values returns all elements of the OutputFormat enum
func OutputFormat_Values() []string {
	return []string{
		OutputFormatIonBinary,
		OutputFormatIonText,
		OutputFormatJson,
	}
}

const (
	// PermissionsModeAllowAll is a PermissionsMode enum value
	PermissionsModeAllowAll = "ALLOW_ALL"

	// PermissionsModeStandard is a PermissionsMode enum value
	PermissionsModeStandard = "STANDARD"
)

// PermissionsMode_Values returns all elements of the PermissionsMode enum
func PermissionsMode_Values() []string {
	return []string{
		PermissionsModeAllowAll,
		PermissionsModeStandard,
	}
}

const (
	// S3ObjectEncryptionTypeSseKms is a S3ObjectEncryptionType enum value
	S3ObjectEncryptionTypeSseKms = "SSE_KMS"

	// S3ObjectEncryptionTypeSseS3 is a S3ObjectEncryptionType enum value
	S3ObjectEncryptionTypeSseS3 = "SSE_S3"

	// S3ObjectEncryptionTypeNoEncryption is a S3ObjectEncryptionType enum value
	S3ObjectEncryptionTypeNoEncryption = "NO_ENCRYPTION"
)

// S3ObjectEncryptionType_Values returns all elements of the S3ObjectEncryptionType enum
func S3ObjectEncryptionType_Values() []string {
	return []string{
		S3ObjectEncryptionTypeSseKms,
		S3ObjectEncryptionTypeSseS3,
		S3ObjectEncryptionTypeNoEncryption,
	}
}

const (
	// StreamStatusActive is a StreamStatus enum value
	StreamStatusActive = "ACTIVE"

	// StreamStatusCompleted is a StreamStatus enum value
	StreamStatusCompleted = "COMPLETED"

	// StreamStatusCanceled is a StreamStatus enum value
	StreamStatusCanceled = "CANCELED"

	// StreamStatusFailed is a StreamStatus enum value
	StreamStatusFailed = "FAILED"

	// StreamStatusImpaired is a StreamStatus enum value
	StreamStatusImpaired = "IMPAIRED"
)

// StreamStatus_Values returns all elements of the StreamStatus enum
func StreamStatus_Values() []string {
	return []string{
		StreamStatusActive,
		StreamStatusCompleted,
		StreamStatusCanceled,
		StreamStatusFailed,
		StreamStatusImpaired,
	}
}
