// Generated bindings for python v3.11.0b5
#![allow(dead_code)]
#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(clippy::useless_transmute)]
#![allow(clippy::default_trait_access)]
#![allow(clippy::cast_lossless)]
#![allow(clippy::trivially_copy_pass_by_ref)]
#![allow(clippy::upper_case_acronyms)]

/* automatically generated by rust-bindgen */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    storage: Storage,
    align: [Align; 0],
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub unsafe fn as_ptr(&self) -> *const T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut_ptr(&mut self) -> *mut T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
impl<T> ::std::clone::Clone for __IncompleteArrayField<T> {
    #[inline]
    fn clone(&self) -> Self {
        Self::new()
    }
}
pub type wchar_t = ::std::os::raw::c_int;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __ssize_t = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
impl Default for __pthread_internal_list {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
impl Default for __pthread_mutex_s {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __bindgen_anon_1: __pthread_cond_s__bindgen_ty_1,
    pub __bindgen_anon_2: __pthread_cond_s__bindgen_ty_2,
    pub __g_refs: [::std::os::raw::c_uint; 2usize],
    pub __g_size: [::std::os::raw::c_uint; 2usize],
    pub __g1_orig_size: ::std::os::raw::c_uint,
    pub __wrefs: ::std::os::raw::c_uint,
    pub __g_signals: [::std::os::raw::c_uint; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_1 {
    pub __wseq: ::std::os::raw::c_ulonglong,
    pub __wseq32: __pthread_cond_s__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_1__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
impl Default for __pthread_cond_s__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_2 {
    pub __g1_start: ::std::os::raw::c_ulonglong,
    pub __g1_start32: __pthread_cond_s__bindgen_ty_2__bindgen_ty_1,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_2__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
impl Default for __pthread_cond_s__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl Default for __pthread_cond_s {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type pthread_key_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
    _bindgen_union_align: [u64; 5usize],
}
impl Default for pthread_mutex_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
    _bindgen_union_align: [u64; 6usize],
}
impl Default for pthread_cond_t {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type Py_ssize_t = isize;
pub type Py_hash_t = Py_ssize_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyMemberDef {
    _unused: [u8; 0],
}
pub type PyObject = _object;
pub type PyLongObject = _longobject;
pub type PyTypeObject = _typeobject;
pub type PyFrameObject = _frame;
pub type PyThreadState = _ts;
pub type PyInterpreterState = _is;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Py_buffer {
    pub buf: *mut ::std::os::raw::c_void,
    pub obj: *mut PyObject,
    pub len: Py_ssize_t,
    pub itemsize: Py_ssize_t,
    pub readonly: ::std::os::raw::c_int,
    pub ndim: ::std::os::raw::c_int,
    pub format: *mut ::std::os::raw::c_char,
    pub shape: *mut Py_ssize_t,
    pub strides: *mut Py_ssize_t,
    pub suboffsets: *mut Py_ssize_t,
    pub internal: *mut ::std::os::raw::c_void,
}
impl Default for Py_buffer {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _object {
    pub ob_refcnt: Py_ssize_t,
    pub ob_type: *mut PyTypeObject,
}
impl Default for _object {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyVarObject {
    pub ob_base: PyObject,
    pub ob_size: Py_ssize_t,
}
impl Default for PyVarObject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type unaryfunc =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut PyObject) -> *mut PyObject>;
pub type binaryfunc = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut PyObject, arg2: *mut PyObject) -> *mut PyObject,
>;
pub type ternaryfunc = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyObject,
        arg2: *mut PyObject,
        arg3: *mut PyObject,
    ) -> *mut PyObject,
>;
pub type inquiry =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut PyObject) -> ::std::os::raw::c_int>;
pub type lenfunc = ::std::option::Option<unsafe extern "C" fn(arg1: *mut PyObject) -> Py_ssize_t>;
pub type ssizeargfunc = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut PyObject, arg2: Py_ssize_t) -> *mut PyObject,
>;
pub type ssizeobjargproc = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyObject,
        arg2: Py_ssize_t,
        arg3: *mut PyObject,
    ) -> ::std::os::raw::c_int,
>;
pub type objobjargproc = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyObject,
        arg2: *mut PyObject,
        arg3: *mut PyObject,
    ) -> ::std::os::raw::c_int,
>;
pub type objobjproc = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut PyObject, arg2: *mut PyObject) -> ::std::os::raw::c_int,
>;
pub type visitproc = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyObject,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub type traverseproc = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyObject,
        arg2: visitproc,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub type freefunc = ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>;
pub type destructor = ::std::option::Option<unsafe extern "C" fn(arg1: *mut PyObject)>;
pub type getattrfunc = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut PyObject, arg2: *mut ::std::os::raw::c_char) -> *mut PyObject,
>;
pub type getattrofunc = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut PyObject, arg2: *mut PyObject) -> *mut PyObject,
>;
pub type setattrfunc = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyObject,
        arg2: *mut ::std::os::raw::c_char,
        arg3: *mut PyObject,
    ) -> ::std::os::raw::c_int,
>;
pub type setattrofunc = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyObject,
        arg2: *mut PyObject,
        arg3: *mut PyObject,
    ) -> ::std::os::raw::c_int,
>;
pub type reprfunc =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut PyObject) -> *mut PyObject>;
pub type hashfunc = ::std::option::Option<unsafe extern "C" fn(arg1: *mut PyObject) -> Py_hash_t>;
pub type richcmpfunc = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyObject,
        arg2: *mut PyObject,
        arg3: ::std::os::raw::c_int,
    ) -> *mut PyObject,
>;
pub type getiterfunc =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut PyObject) -> *mut PyObject>;
pub type iternextfunc =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut PyObject) -> *mut PyObject>;
pub type descrgetfunc = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyObject,
        arg2: *mut PyObject,
        arg3: *mut PyObject,
    ) -> *mut PyObject,
>;
pub type descrsetfunc = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyObject,
        arg2: *mut PyObject,
        arg3: *mut PyObject,
    ) -> ::std::os::raw::c_int,
>;
pub type initproc = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyObject,
        arg2: *mut PyObject,
        arg3: *mut PyObject,
    ) -> ::std::os::raw::c_int,
>;
pub type newfunc = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyTypeObject,
        arg2: *mut PyObject,
        arg3: *mut PyObject,
    ) -> *mut PyObject,
>;
pub type allocfunc = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut PyTypeObject, arg2: Py_ssize_t) -> *mut PyObject,
>;
pub const PySendResult_PYGEN_RETURN: PySendResult = 0;
pub const PySendResult_PYGEN_ERROR: PySendResult = -1;
pub const PySendResult_PYGEN_NEXT: PySendResult = 1;
pub type PySendResult = i32;
pub type getbufferproc = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyObject,
        arg2: *mut Py_buffer,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type releasebufferproc =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut PyObject, arg2: *mut Py_buffer)>;
pub type vectorcallfunc = ::std::option::Option<
    unsafe extern "C" fn(
        callable: *mut PyObject,
        args: *const *mut PyObject,
        nargsf: usize,
        kwnames: *mut PyObject,
    ) -> *mut PyObject,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyNumberMethods {
    pub nb_add: binaryfunc,
    pub nb_subtract: binaryfunc,
    pub nb_multiply: binaryfunc,
    pub nb_remainder: binaryfunc,
    pub nb_divmod: binaryfunc,
    pub nb_power: ternaryfunc,
    pub nb_negative: unaryfunc,
    pub nb_positive: unaryfunc,
    pub nb_absolute: unaryfunc,
    pub nb_bool: inquiry,
    pub nb_invert: unaryfunc,
    pub nb_lshift: binaryfunc,
    pub nb_rshift: binaryfunc,
    pub nb_and: binaryfunc,
    pub nb_xor: binaryfunc,
    pub nb_or: binaryfunc,
    pub nb_int: unaryfunc,
    pub nb_reserved: *mut ::std::os::raw::c_void,
    pub nb_float: unaryfunc,
    pub nb_inplace_add: binaryfunc,
    pub nb_inplace_subtract: binaryfunc,
    pub nb_inplace_multiply: binaryfunc,
    pub nb_inplace_remainder: binaryfunc,
    pub nb_inplace_power: ternaryfunc,
    pub nb_inplace_lshift: binaryfunc,
    pub nb_inplace_rshift: binaryfunc,
    pub nb_inplace_and: binaryfunc,
    pub nb_inplace_xor: binaryfunc,
    pub nb_inplace_or: binaryfunc,
    pub nb_floor_divide: binaryfunc,
    pub nb_true_divide: binaryfunc,
    pub nb_inplace_floor_divide: binaryfunc,
    pub nb_inplace_true_divide: binaryfunc,
    pub nb_index: unaryfunc,
    pub nb_matrix_multiply: binaryfunc,
    pub nb_inplace_matrix_multiply: binaryfunc,
}
impl Default for PyNumberMethods {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PySequenceMethods {
    pub sq_length: lenfunc,
    pub sq_concat: binaryfunc,
    pub sq_repeat: ssizeargfunc,
    pub sq_item: ssizeargfunc,
    pub was_sq_slice: *mut ::std::os::raw::c_void,
    pub sq_ass_item: ssizeobjargproc,
    pub was_sq_ass_slice: *mut ::std::os::raw::c_void,
    pub sq_contains: objobjproc,
    pub sq_inplace_concat: binaryfunc,
    pub sq_inplace_repeat: ssizeargfunc,
}
impl Default for PySequenceMethods {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyMappingMethods {
    pub mp_length: lenfunc,
    pub mp_subscript: binaryfunc,
    pub mp_ass_subscript: objobjargproc,
}
impl Default for PyMappingMethods {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type sendfunc = ::std::option::Option<
    unsafe extern "C" fn(
        iter: *mut PyObject,
        value: *mut PyObject,
        result: *mut *mut PyObject,
    ) -> PySendResult,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyAsyncMethods {
    pub am_await: unaryfunc,
    pub am_aiter: unaryfunc,
    pub am_anext: unaryfunc,
    pub am_send: sendfunc,
}
impl Default for PyAsyncMethods {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyBufferProcs {
    pub bf_getbuffer: getbufferproc,
    pub bf_releasebuffer: releasebufferproc,
}
impl Default for PyBufferProcs {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _typeobject {
    pub ob_base: PyVarObject,
    pub tp_name: *const ::std::os::raw::c_char,
    pub tp_basicsize: Py_ssize_t,
    pub tp_itemsize: Py_ssize_t,
    pub tp_dealloc: destructor,
    pub tp_vectorcall_offset: Py_ssize_t,
    pub tp_getattr: getattrfunc,
    pub tp_setattr: setattrfunc,
    pub tp_as_async: *mut PyAsyncMethods,
    pub tp_repr: reprfunc,
    pub tp_as_number: *mut PyNumberMethods,
    pub tp_as_sequence: *mut PySequenceMethods,
    pub tp_as_mapping: *mut PyMappingMethods,
    pub tp_hash: hashfunc,
    pub tp_call: ternaryfunc,
    pub tp_str: reprfunc,
    pub tp_getattro: getattrofunc,
    pub tp_setattro: setattrofunc,
    pub tp_as_buffer: *mut PyBufferProcs,
    pub tp_flags: ::std::os::raw::c_ulong,
    pub tp_doc: *const ::std::os::raw::c_char,
    pub tp_traverse: traverseproc,
    pub tp_clear: inquiry,
    pub tp_richcompare: richcmpfunc,
    pub tp_weaklistoffset: Py_ssize_t,
    pub tp_iter: getiterfunc,
    pub tp_iternext: iternextfunc,
    pub tp_methods: *mut PyMethodDef,
    pub tp_members: *mut PyMemberDef,
    pub tp_getset: *mut PyGetSetDef,
    pub tp_base: *mut PyTypeObject,
    pub tp_dict: *mut PyObject,
    pub tp_descr_get: descrgetfunc,
    pub tp_descr_set: descrsetfunc,
    pub tp_dictoffset: Py_ssize_t,
    pub tp_init: initproc,
    pub tp_alloc: allocfunc,
    pub tp_new: newfunc,
    pub tp_free: freefunc,
    pub tp_is_gc: inquiry,
    pub tp_bases: *mut PyObject,
    pub tp_mro: *mut PyObject,
    pub tp_cache: *mut PyObject,
    pub tp_subclasses: *mut PyObject,
    pub tp_weaklist: *mut PyObject,
    pub tp_del: destructor,
    pub tp_version_tag: ::std::os::raw::c_uint,
    pub tp_finalize: destructor,
    pub tp_vectorcall: vectorcallfunc,
}
impl Default for _typeobject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _specialization_cache {
    pub getitem: *mut PyObject,
}
impl Default for _specialization_cache {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _heaptypeobject {
    pub ht_type: PyTypeObject,
    pub as_async: PyAsyncMethods,
    pub as_number: PyNumberMethods,
    pub as_mapping: PyMappingMethods,
    pub as_sequence: PySequenceMethods,
    pub as_buffer: PyBufferProcs,
    pub ht_name: *mut PyObject,
    pub ht_slots: *mut PyObject,
    pub ht_qualname: *mut PyObject,
    pub ht_cached_keys: *mut _dictkeysobject,
    pub ht_module: *mut PyObject,
    pub _ht_tpname: *mut ::std::os::raw::c_char,
    pub _spec_cache: _specialization_cache,
}
impl Default for _heaptypeobject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type PyHeapTypeObject = _heaptypeobject;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyBytesObject {
    pub ob_base: PyVarObject,
    pub ob_shash: Py_hash_t,
    pub ob_sval: [::std::os::raw::c_char; 1usize],
}
impl Default for PyBytesObject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type Py_UCS4 = u32;
pub type Py_UCS2 = u16;
pub type Py_UCS1 = u8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyASCIIObject {
    pub ob_base: PyObject,
    pub length: Py_ssize_t,
    pub hash: Py_hash_t,
    pub state: PyASCIIObject__bindgen_ty_1,
    pub wstr: *mut wchar_t,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct PyASCIIObject__bindgen_ty_1 {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u8>,
}
impl PyASCIIObject__bindgen_ty_1 {
    #[inline]
    pub fn interned(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_interned(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn kind(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_kind(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn compact(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_compact(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ascii(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ascii(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ready(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ready(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        interned: ::std::os::raw::c_uint,
        kind: ::std::os::raw::c_uint,
        compact: ::std::os::raw::c_uint,
        ascii: ::std::os::raw::c_uint,
        ready: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let interned: u32 = unsafe { ::std::mem::transmute(interned) };
            interned as u64
        });
        __bindgen_bitfield_unit.set(2usize, 3u8, {
            let kind: u32 = unsafe { ::std::mem::transmute(kind) };
            kind as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let compact: u32 = unsafe { ::std::mem::transmute(compact) };
            compact as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let ascii: u32 = unsafe { ::std::mem::transmute(ascii) };
            ascii as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let ready: u32 = unsafe { ::std::mem::transmute(ready) };
            ready as u64
        });
        __bindgen_bitfield_unit
    }
}
impl Default for PyASCIIObject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyCompactUnicodeObject {
    pub _base: PyASCIIObject,
    pub utf8_length: Py_ssize_t,
    pub utf8: *mut ::std::os::raw::c_char,
    pub wstr_length: Py_ssize_t,
}
impl Default for PyCompactUnicodeObject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct PyUnicodeObject {
    pub _base: PyCompactUnicodeObject,
    pub data: PyUnicodeObject__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PyUnicodeObject__bindgen_ty_1 {
    pub any: *mut ::std::os::raw::c_void,
    pub latin1: *mut Py_UCS1,
    pub ucs2: *mut Py_UCS2,
    pub ucs4: *mut Py_UCS4,
    _bindgen_union_align: u64,
}
impl Default for PyUnicodeObject__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl Default for PyUnicodeObject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type digit = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _longobject {
    pub ob_base: PyVarObject,
    pub ob_digit: [digit; 1usize],
}
impl Default for _longobject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyFloatObject {
    pub ob_base: PyObject,
    pub ob_fval: f64,
}
impl Default for PyFloatObject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyTupleObject {
    pub ob_base: PyVarObject,
    pub ob_item: [*mut PyObject; 1usize],
}
impl Default for PyTupleObject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyListObject {
    pub ob_base: PyVarObject,
    pub ob_item: *mut *mut PyObject,
    pub allocated: Py_ssize_t,
}
impl Default for PyListObject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type PyDictKeysObject = _dictkeysobject;
pub type PyDictValues = _dictvalues;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyDictObject {
    pub ob_base: PyObject,
    pub ma_used: Py_ssize_t,
    pub ma_version_tag: u64,
    pub ma_keys: *mut PyDictKeysObject,
    pub ma_values: *mut PyDictValues,
}
impl Default for PyDictObject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type PyCFunction = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut PyObject, arg2: *mut PyObject) -> *mut PyObject,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyMethodDef {
    pub ml_name: *const ::std::os::raw::c_char,
    pub ml_meth: PyCFunction,
    pub ml_flags: ::std::os::raw::c_int,
    pub ml_doc: *const ::std::os::raw::c_char,
}
impl Default for PyMethodDef {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyFunctionObject {
    pub ob_base: PyObject,
    pub func_globals: *mut PyObject,
    pub func_builtins: *mut PyObject,
    pub func_name: *mut PyObject,
    pub func_qualname: *mut PyObject,
    pub func_code: *mut PyObject,
    pub func_defaults: *mut PyObject,
    pub func_kwdefaults: *mut PyObject,
    pub func_closure: *mut PyObject,
    pub func_doc: *mut PyObject,
    pub func_dict: *mut PyObject,
    pub func_weakreflist: *mut PyObject,
    pub func_module: *mut PyObject,
    pub func_annotations: *mut PyObject,
    pub vectorcall: vectorcallfunc,
    pub func_version: u32,
}
impl Default for PyFunctionObject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type Py_OpenCodeHookFunction = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut PyObject, arg2: *mut ::std::os::raw::c_void) -> *mut PyObject,
>;
pub type _Py_CODEUNIT = u16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyCodeObject {
    pub ob_base: PyVarObject,
    pub co_consts: *mut PyObject,
    pub co_names: *mut PyObject,
    pub co_exceptiontable: *mut PyObject,
    pub co_flags: ::std::os::raw::c_int,
    pub co_warmup: ::std::os::raw::c_short,
    pub _co_linearray_entry_size: ::std::os::raw::c_short,
    pub co_argcount: ::std::os::raw::c_int,
    pub co_posonlyargcount: ::std::os::raw::c_int,
    pub co_kwonlyargcount: ::std::os::raw::c_int,
    pub co_stacksize: ::std::os::raw::c_int,
    pub co_firstlineno: ::std::os::raw::c_int,
    pub co_nlocalsplus: ::std::os::raw::c_int,
    pub co_nlocals: ::std::os::raw::c_int,
    pub co_nplaincellvars: ::std::os::raw::c_int,
    pub co_ncellvars: ::std::os::raw::c_int,
    pub co_nfreevars: ::std::os::raw::c_int,
    pub co_localsplusnames: *mut PyObject,
    pub co_localspluskinds: *mut PyObject,
    pub co_filename: *mut PyObject,
    pub co_name: *mut PyObject,
    pub co_qualname: *mut PyObject,
    pub co_linetable: *mut PyObject,
    pub co_weakreflist: *mut PyObject,
    pub _co_code: *mut PyObject,
    pub _co_linearray: *mut ::std::os::raw::c_char,
    pub _co_firsttraceable: ::std::os::raw::c_int,
    pub co_extra: *mut ::std::os::raw::c_void,
    pub co_code_adaptive: [::std::os::raw::c_char; 1usize],
}
impl Default for PyCodeObject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque {
    pub computed_line: ::std::os::raw::c_int,
    pub lo_next: *const u8,
    pub limit: *const u8,
}
impl Default for _opaque {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _line_offsets {
    pub ar_start: ::std::os::raw::c_int,
    pub ar_end: ::std::os::raw::c_int,
    pub ar_line: ::std::os::raw::c_int,
    pub opaque: _opaque,
}
impl Default for _line_offsets {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type PyCodeAddressRange = _line_offsets;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PySliceObject {
    pub ob_base: PyObject,
    pub start: *mut PyObject,
    pub stop: *mut PyObject,
    pub step: *mut PyObject,
}
impl Default for PySliceObject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyWideStringList {
    pub length: Py_ssize_t,
    pub items: *mut *mut wchar_t,
}
impl Default for PyWideStringList {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PyPreConfig {
    pub _config_init: ::std::os::raw::c_int,
    pub parse_argv: ::std::os::raw::c_int,
    pub isolated: ::std::os::raw::c_int,
    pub use_environment: ::std::os::raw::c_int,
    pub configure_locale: ::std::os::raw::c_int,
    pub coerce_c_locale: ::std::os::raw::c_int,
    pub coerce_c_locale_warn: ::std::os::raw::c_int,
    pub utf8_mode: ::std::os::raw::c_int,
    pub dev_mode: ::std::os::raw::c_int,
    pub allocator: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyConfig {
    pub _config_init: ::std::os::raw::c_int,
    pub isolated: ::std::os::raw::c_int,
    pub use_environment: ::std::os::raw::c_int,
    pub dev_mode: ::std::os::raw::c_int,
    pub install_signal_handlers: ::std::os::raw::c_int,
    pub use_hash_seed: ::std::os::raw::c_int,
    pub hash_seed: ::std::os::raw::c_ulong,
    pub faulthandler: ::std::os::raw::c_int,
    pub tracemalloc: ::std::os::raw::c_int,
    pub import_time: ::std::os::raw::c_int,
    pub code_debug_ranges: ::std::os::raw::c_int,
    pub show_ref_count: ::std::os::raw::c_int,
    pub dump_refs: ::std::os::raw::c_int,
    pub dump_refs_file: *mut wchar_t,
    pub malloc_stats: ::std::os::raw::c_int,
    pub filesystem_encoding: *mut wchar_t,
    pub filesystem_errors: *mut wchar_t,
    pub pycache_prefix: *mut wchar_t,
    pub parse_argv: ::std::os::raw::c_int,
    pub orig_argv: PyWideStringList,
    pub argv: PyWideStringList,
    pub xoptions: PyWideStringList,
    pub warnoptions: PyWideStringList,
    pub site_import: ::std::os::raw::c_int,
    pub bytes_warning: ::std::os::raw::c_int,
    pub warn_default_encoding: ::std::os::raw::c_int,
    pub inspect: ::std::os::raw::c_int,
    pub interactive: ::std::os::raw::c_int,
    pub optimization_level: ::std::os::raw::c_int,
    pub parser_debug: ::std::os::raw::c_int,
    pub write_bytecode: ::std::os::raw::c_int,
    pub verbose: ::std::os::raw::c_int,
    pub quiet: ::std::os::raw::c_int,
    pub user_site_directory: ::std::os::raw::c_int,
    pub configure_c_stdio: ::std::os::raw::c_int,
    pub buffered_stdio: ::std::os::raw::c_int,
    pub stdio_encoding: *mut wchar_t,
    pub stdio_errors: *mut wchar_t,
    pub check_hash_pycs_mode: *mut wchar_t,
    pub use_frozen_modules: ::std::os::raw::c_int,
    pub safe_path: ::std::os::raw::c_int,
    pub pathconfig_warnings: ::std::os::raw::c_int,
    pub program_name: *mut wchar_t,
    pub pythonpath_env: *mut wchar_t,
    pub home: *mut wchar_t,
    pub platlibdir: *mut wchar_t,
    pub module_search_paths_set: ::std::os::raw::c_int,
    pub module_search_paths: PyWideStringList,
    pub stdlib_dir: *mut wchar_t,
    pub executable: *mut wchar_t,
    pub base_executable: *mut wchar_t,
    pub prefix: *mut wchar_t,
    pub base_prefix: *mut wchar_t,
    pub exec_prefix: *mut wchar_t,
    pub base_exec_prefix: *mut wchar_t,
    pub skip_source_first_line: ::std::os::raw::c_int,
    pub run_command: *mut wchar_t,
    pub run_module: *mut wchar_t,
    pub run_filename: *mut wchar_t,
    pub _install_importlib: ::std::os::raw::c_int,
    pub _init_main: ::std::os::raw::c_int,
    pub _isolated_interpreter: ::std::os::raw::c_int,
    pub _is_python_build: ::std::os::raw::c_int,
}
impl Default for PyConfig {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type Py_tracefunc = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyObject,
        arg2: *mut PyFrameObject,
        arg3: ::std::os::raw::c_int,
        arg4: *mut PyObject,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyTraceInfo {
    pub code: *mut PyCodeObject,
    pub bounds: PyCodeAddressRange,
}
impl Default for PyTraceInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _PyCFrame {
    pub use_tracing: u8,
    pub current_frame: *mut _PyInterpreterFrame,
    pub previous: *mut _PyCFrame,
}
impl Default for _PyCFrame {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _err_stackitem {
    pub exc_value: *mut PyObject,
    pub previous_item: *mut _err_stackitem,
}
impl Default for _err_stackitem {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type _PyErr_StackItem = _err_stackitem;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _stack_chunk {
    pub previous: *mut _stack_chunk,
    pub size: usize,
    pub top: usize,
    pub data: [*mut PyObject; 1usize],
}
impl Default for _stack_chunk {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type _PyStackChunk = _stack_chunk;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ts {
    pub prev: *mut PyThreadState,
    pub next: *mut PyThreadState,
    pub interp: *mut PyInterpreterState,
    pub _initialized: ::std::os::raw::c_int,
    pub _static: ::std::os::raw::c_int,
    pub recursion_remaining: ::std::os::raw::c_int,
    pub recursion_limit: ::std::os::raw::c_int,
    pub recursion_headroom: ::std::os::raw::c_int,
    pub tracing: ::std::os::raw::c_int,
    pub tracing_what: ::std::os::raw::c_int,
    pub cframe: *mut _PyCFrame,
    pub c_profilefunc: Py_tracefunc,
    pub c_tracefunc: Py_tracefunc,
    pub c_profileobj: *mut PyObject,
    pub c_traceobj: *mut PyObject,
    pub curexc_type: *mut PyObject,
    pub curexc_value: *mut PyObject,
    pub curexc_traceback: *mut PyObject,
    pub exc_info: *mut _PyErr_StackItem,
    pub dict: *mut PyObject,
    pub gilstate_counter: ::std::os::raw::c_int,
    pub async_exc: *mut PyObject,
    pub thread_id: ::std::os::raw::c_ulong,
    pub native_thread_id: ::std::os::raw::c_ulong,
    pub trash_delete_nesting: ::std::os::raw::c_int,
    pub trash_delete_later: *mut PyObject,
    pub on_delete: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub on_delete_data: *mut ::std::os::raw::c_void,
    pub coroutine_origin_tracking_depth: ::std::os::raw::c_int,
    pub async_gen_firstiter: *mut PyObject,
    pub async_gen_finalizer: *mut PyObject,
    pub context: *mut PyObject,
    pub context_ver: u64,
    pub id: u64,
    pub trace_info: PyTraceInfo,
    pub datastack_chunk: *mut _PyStackChunk,
    pub datastack_top: *mut *mut PyObject,
    pub datastack_limit: *mut *mut PyObject,
    pub exc_state: _PyErr_StackItem,
    pub root_cframe: _PyCFrame,
}
impl Default for _ts {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type _PyFrameEvalFunction = ::std::option::Option<
    unsafe extern "C" fn(
        tstate: *mut PyThreadState,
        arg1: *mut _PyInterpreterFrame,
        arg2: ::std::os::raw::c_int,
    ) -> *mut PyObject,
>;
pub type _PyCrossInterpreterData = _xid;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _xid {
    pub data: *mut ::std::os::raw::c_void,
    pub obj: *mut PyObject,
    pub interp: i64,
    pub new_object: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut _PyCrossInterpreterData) -> *mut PyObject,
    >,
    pub free: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
}
impl Default for _xid {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type crossinterpdatafunc = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyObject,
        arg2: *mut _PyCrossInterpreterData,
    ) -> ::std::os::raw::c_int,
>;
pub type getter = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut PyObject, arg2: *mut ::std::os::raw::c_void) -> *mut PyObject,
>;
pub type setter = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut PyObject,
        arg2: *mut PyObject,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyGetSetDef {
    pub name: *const ::std::os::raw::c_char,
    pub get: getter,
    pub set: setter,
    pub doc: *const ::std::os::raw::c_char,
    pub closure: *mut ::std::os::raw::c_void,
}
impl Default for PyGetSetDef {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyBaseExceptionObject {
    pub ob_base: PyObject,
    pub dict: *mut PyObject,
    pub args: *mut PyObject,
    pub notes: *mut PyObject,
    pub traceback: *mut PyObject,
    pub context: *mut PyObject,
    pub cause: *mut PyObject,
    pub suppress_context: ::std::os::raw::c_char,
}
impl Default for PyBaseExceptionObject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type PyThread_type_lock = *mut ::std::os::raw::c_void;
pub type Py_tss_t = _Py_tss_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _Py_tss_t {
    pub _is_initialized: ::std::os::raw::c_int,
    pub _key: pthread_key_t,
}
pub type PyContext = _pycontextobject;
pub type Py_AuditHookFunction = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut PyObject,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub type atomic_int = u32;
pub type atomic_uintptr_t = usize;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _Py_atomic_address {
    pub _value: atomic_uintptr_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _Py_atomic_int {
    pub _value: atomic_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _gil_runtime_state {
    pub interval: ::std::os::raw::c_ulong,
    pub last_holder: _Py_atomic_address,
    pub locked: _Py_atomic_int,
    pub switch_number: ::std::os::raw::c_ulong,
    pub cond: pthread_cond_t,
    pub mutex: pthread_mutex_t,
    pub switch_cond: pthread_cond_t,
    pub switch_mutex: pthread_mutex_t,
}
impl Default for _gil_runtime_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PyGC_Head {
    pub _gc_next: usize,
    pub _gc_prev: usize,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct gc_generation {
    pub head: PyGC_Head,
    pub threshold: ::std::os::raw::c_int,
    pub count: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct gc_generation_stats {
    pub collections: Py_ssize_t,
    pub collected: Py_ssize_t,
    pub uncollectable: Py_ssize_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gc_runtime_state {
    pub trash_delete_later: *mut PyObject,
    pub trash_delete_nesting: ::std::os::raw::c_int,
    pub enabled: ::std::os::raw::c_int,
    pub debug: ::std::os::raw::c_int,
    pub generations: [gc_generation; 3usize],
    pub generation0: *mut PyGC_Head,
    pub permanent_generation: gc_generation,
    pub generation_stats: [gc_generation_stats; 3usize],
    pub collecting: ::std::os::raw::c_int,
    pub garbage: *mut PyObject,
    pub callbacks: *mut PyObject,
    pub long_lived_total: Py_ssize_t,
    pub long_lived_pending: Py_ssize_t,
}
impl Default for _gc_runtime_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _Py_global_strings {
    pub literals: _Py_global_strings__bindgen_ty_1,
    pub identifiers: _Py_global_strings__bindgen_ty_2,
    pub ascii: [_Py_global_strings__bindgen_ty_3; 128usize],
    pub latin1: [_Py_global_strings__bindgen_ty_4; 128usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1 {
    pub _anon_dictcomp: _Py_global_strings__bindgen_ty_1__bindgen_ty_1,
    pub _anon_genexpr: _Py_global_strings__bindgen_ty_1__bindgen_ty_2,
    pub _anon_lambda: _Py_global_strings__bindgen_ty_1__bindgen_ty_3,
    pub _anon_listcomp: _Py_global_strings__bindgen_ty_1__bindgen_ty_4,
    pub _anon_module: _Py_global_strings__bindgen_ty_1__bindgen_ty_5,
    pub _anon_setcomp: _Py_global_strings__bindgen_ty_1__bindgen_ty_6,
    pub _anon_string: _Py_global_strings__bindgen_ty_1__bindgen_ty_7,
    pub _anon_unknown: _Py_global_strings__bindgen_ty_1__bindgen_ty_8,
    pub _close_br: _Py_global_strings__bindgen_ty_1__bindgen_ty_9,
    pub _comma_sep: _Py_global_strings__bindgen_ty_1__bindgen_ty_10,
    pub _dbl_close_br: _Py_global_strings__bindgen_ty_1__bindgen_ty_11,
    pub _dbl_open_br: _Py_global_strings__bindgen_ty_1__bindgen_ty_12,
    pub _dbl_percent: _Py_global_strings__bindgen_ty_1__bindgen_ty_13,
    pub _dot: _Py_global_strings__bindgen_ty_1__bindgen_ty_14,
    pub _dot_locals: _Py_global_strings__bindgen_ty_1__bindgen_ty_15,
    pub _empty: _Py_global_strings__bindgen_ty_1__bindgen_ty_16,
    pub _list_err: _Py_global_strings__bindgen_ty_1__bindgen_ty_17,
    pub _newline: _Py_global_strings__bindgen_ty_1__bindgen_ty_18,
    pub _open_br: _Py_global_strings__bindgen_ty_1__bindgen_ty_19,
    pub _percent: _Py_global_strings__bindgen_ty_1__bindgen_ty_20,
    pub _utf_8: _Py_global_strings__bindgen_ty_1__bindgen_ty_21,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_1 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_2 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_3 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_4 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_4 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_5 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_5 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_6 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_6 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_7 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_7 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_8 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_8 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_9 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 2usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_9 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_10 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 3usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_10 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_11 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 3usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_11 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_12 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 3usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_12 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_13 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 3usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_13 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_14 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 2usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_14 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_15 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_15 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_16 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 1usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_16 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_17 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 24usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_17 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_18 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 2usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_18 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_19 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 2usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_19 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_20 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 2usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_20 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_1__bindgen_ty_21 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 6usize],
}
impl Default for _Py_global_strings__bindgen_ty_1__bindgen_ty_21 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl Default for _Py_global_strings__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2 {
    pub _False: _Py_global_strings__bindgen_ty_2__bindgen_ty_1,
    pub _Py_Repr: _Py_global_strings__bindgen_ty_2__bindgen_ty_2,
    pub _TextIOWrapper: _Py_global_strings__bindgen_ty_2__bindgen_ty_3,
    pub _True: _Py_global_strings__bindgen_ty_2__bindgen_ty_4,
    pub _WarningMessage: _Py_global_strings__bindgen_ty_2__bindgen_ty_5,
    pub __: _Py_global_strings__bindgen_ty_2__bindgen_ty_6,
    pub ___IOBase_closed: _Py_global_strings__bindgen_ty_2__bindgen_ty_7,
    pub ___abc_tpflags__: _Py_global_strings__bindgen_ty_2__bindgen_ty_8,
    pub ___abs__: _Py_global_strings__bindgen_ty_2__bindgen_ty_9,
    pub ___abstractmethods__: _Py_global_strings__bindgen_ty_2__bindgen_ty_10,
    pub ___add__: _Py_global_strings__bindgen_ty_2__bindgen_ty_11,
    pub ___aenter__: _Py_global_strings__bindgen_ty_2__bindgen_ty_12,
    pub ___aexit__: _Py_global_strings__bindgen_ty_2__bindgen_ty_13,
    pub ___aiter__: _Py_global_strings__bindgen_ty_2__bindgen_ty_14,
    pub ___all__: _Py_global_strings__bindgen_ty_2__bindgen_ty_15,
    pub ___and__: _Py_global_strings__bindgen_ty_2__bindgen_ty_16,
    pub ___anext__: _Py_global_strings__bindgen_ty_2__bindgen_ty_17,
    pub ___annotations__: _Py_global_strings__bindgen_ty_2__bindgen_ty_18,
    pub ___args__: _Py_global_strings__bindgen_ty_2__bindgen_ty_19,
    pub ___await__: _Py_global_strings__bindgen_ty_2__bindgen_ty_20,
    pub ___bases__: _Py_global_strings__bindgen_ty_2__bindgen_ty_21,
    pub ___bool__: _Py_global_strings__bindgen_ty_2__bindgen_ty_22,
    pub ___build_class__: _Py_global_strings__bindgen_ty_2__bindgen_ty_23,
    pub ___builtins__: _Py_global_strings__bindgen_ty_2__bindgen_ty_24,
    pub ___bytes__: _Py_global_strings__bindgen_ty_2__bindgen_ty_25,
    pub ___call__: _Py_global_strings__bindgen_ty_2__bindgen_ty_26,
    pub ___cantrace__: _Py_global_strings__bindgen_ty_2__bindgen_ty_27,
    pub ___class__: _Py_global_strings__bindgen_ty_2__bindgen_ty_28,
    pub ___class_getitem__: _Py_global_strings__bindgen_ty_2__bindgen_ty_29,
    pub ___classcell__: _Py_global_strings__bindgen_ty_2__bindgen_ty_30,
    pub ___complex__: _Py_global_strings__bindgen_ty_2__bindgen_ty_31,
    pub ___contains__: _Py_global_strings__bindgen_ty_2__bindgen_ty_32,
    pub ___copy__: _Py_global_strings__bindgen_ty_2__bindgen_ty_33,
    pub ___del__: _Py_global_strings__bindgen_ty_2__bindgen_ty_34,
    pub ___delattr__: _Py_global_strings__bindgen_ty_2__bindgen_ty_35,
    pub ___delete__: _Py_global_strings__bindgen_ty_2__bindgen_ty_36,
    pub ___delitem__: _Py_global_strings__bindgen_ty_2__bindgen_ty_37,
    pub ___dict__: _Py_global_strings__bindgen_ty_2__bindgen_ty_38,
    pub ___dir__: _Py_global_strings__bindgen_ty_2__bindgen_ty_39,
    pub ___divmod__: _Py_global_strings__bindgen_ty_2__bindgen_ty_40,
    pub ___doc__: _Py_global_strings__bindgen_ty_2__bindgen_ty_41,
    pub ___enter__: _Py_global_strings__bindgen_ty_2__bindgen_ty_42,
    pub ___eq__: _Py_global_strings__bindgen_ty_2__bindgen_ty_43,
    pub ___exit__: _Py_global_strings__bindgen_ty_2__bindgen_ty_44,
    pub ___file__: _Py_global_strings__bindgen_ty_2__bindgen_ty_45,
    pub ___float__: _Py_global_strings__bindgen_ty_2__bindgen_ty_46,
    pub ___floordiv__: _Py_global_strings__bindgen_ty_2__bindgen_ty_47,
    pub ___format__: _Py_global_strings__bindgen_ty_2__bindgen_ty_48,
    pub ___fspath__: _Py_global_strings__bindgen_ty_2__bindgen_ty_49,
    pub ___ge__: _Py_global_strings__bindgen_ty_2__bindgen_ty_50,
    pub ___get__: _Py_global_strings__bindgen_ty_2__bindgen_ty_51,
    pub ___getattr__: _Py_global_strings__bindgen_ty_2__bindgen_ty_52,
    pub ___getattribute__: _Py_global_strings__bindgen_ty_2__bindgen_ty_53,
    pub ___getinitargs__: _Py_global_strings__bindgen_ty_2__bindgen_ty_54,
    pub ___getitem__: _Py_global_strings__bindgen_ty_2__bindgen_ty_55,
    pub ___getnewargs__: _Py_global_strings__bindgen_ty_2__bindgen_ty_56,
    pub ___getnewargs_ex__: _Py_global_strings__bindgen_ty_2__bindgen_ty_57,
    pub ___getstate__: _Py_global_strings__bindgen_ty_2__bindgen_ty_58,
    pub ___gt__: _Py_global_strings__bindgen_ty_2__bindgen_ty_59,
    pub ___hash__: _Py_global_strings__bindgen_ty_2__bindgen_ty_60,
    pub ___iadd__: _Py_global_strings__bindgen_ty_2__bindgen_ty_61,
    pub ___iand__: _Py_global_strings__bindgen_ty_2__bindgen_ty_62,
    pub ___ifloordiv__: _Py_global_strings__bindgen_ty_2__bindgen_ty_63,
    pub ___ilshift__: _Py_global_strings__bindgen_ty_2__bindgen_ty_64,
    pub ___imatmul__: _Py_global_strings__bindgen_ty_2__bindgen_ty_65,
    pub ___imod__: _Py_global_strings__bindgen_ty_2__bindgen_ty_66,
    pub ___import__: _Py_global_strings__bindgen_ty_2__bindgen_ty_67,
    pub ___imul__: _Py_global_strings__bindgen_ty_2__bindgen_ty_68,
    pub ___index__: _Py_global_strings__bindgen_ty_2__bindgen_ty_69,
    pub ___init__: _Py_global_strings__bindgen_ty_2__bindgen_ty_70,
    pub ___init_subclass__: _Py_global_strings__bindgen_ty_2__bindgen_ty_71,
    pub ___instancecheck__: _Py_global_strings__bindgen_ty_2__bindgen_ty_72,
    pub ___int__: _Py_global_strings__bindgen_ty_2__bindgen_ty_73,
    pub ___invert__: _Py_global_strings__bindgen_ty_2__bindgen_ty_74,
    pub ___ior__: _Py_global_strings__bindgen_ty_2__bindgen_ty_75,
    pub ___ipow__: _Py_global_strings__bindgen_ty_2__bindgen_ty_76,
    pub ___irshift__: _Py_global_strings__bindgen_ty_2__bindgen_ty_77,
    pub ___isabstractmethod__: _Py_global_strings__bindgen_ty_2__bindgen_ty_78,
    pub ___isub__: _Py_global_strings__bindgen_ty_2__bindgen_ty_79,
    pub ___iter__: _Py_global_strings__bindgen_ty_2__bindgen_ty_80,
    pub ___itruediv__: _Py_global_strings__bindgen_ty_2__bindgen_ty_81,
    pub ___ixor__: _Py_global_strings__bindgen_ty_2__bindgen_ty_82,
    pub ___le__: _Py_global_strings__bindgen_ty_2__bindgen_ty_83,
    pub ___len__: _Py_global_strings__bindgen_ty_2__bindgen_ty_84,
    pub ___length_hint__: _Py_global_strings__bindgen_ty_2__bindgen_ty_85,
    pub ___lltrace__: _Py_global_strings__bindgen_ty_2__bindgen_ty_86,
    pub ___loader__: _Py_global_strings__bindgen_ty_2__bindgen_ty_87,
    pub ___lshift__: _Py_global_strings__bindgen_ty_2__bindgen_ty_88,
    pub ___lt__: _Py_global_strings__bindgen_ty_2__bindgen_ty_89,
    pub ___main__: _Py_global_strings__bindgen_ty_2__bindgen_ty_90,
    pub ___matmul__: _Py_global_strings__bindgen_ty_2__bindgen_ty_91,
    pub ___missing__: _Py_global_strings__bindgen_ty_2__bindgen_ty_92,
    pub ___mod__: _Py_global_strings__bindgen_ty_2__bindgen_ty_93,
    pub ___module__: _Py_global_strings__bindgen_ty_2__bindgen_ty_94,
    pub ___mro_entries__: _Py_global_strings__bindgen_ty_2__bindgen_ty_95,
    pub ___mul__: _Py_global_strings__bindgen_ty_2__bindgen_ty_96,
    pub ___name__: _Py_global_strings__bindgen_ty_2__bindgen_ty_97,
    pub ___ne__: _Py_global_strings__bindgen_ty_2__bindgen_ty_98,
    pub ___neg__: _Py_global_strings__bindgen_ty_2__bindgen_ty_99,
    pub ___new__: _Py_global_strings__bindgen_ty_2__bindgen_ty_100,
    pub ___newobj__: _Py_global_strings__bindgen_ty_2__bindgen_ty_101,
    pub ___newobj_ex__: _Py_global_strings__bindgen_ty_2__bindgen_ty_102,
    pub ___next__: _Py_global_strings__bindgen_ty_2__bindgen_ty_103,
    pub ___notes__: _Py_global_strings__bindgen_ty_2__bindgen_ty_104,
    pub ___or__: _Py_global_strings__bindgen_ty_2__bindgen_ty_105,
    pub ___orig_class__: _Py_global_strings__bindgen_ty_2__bindgen_ty_106,
    pub ___origin__: _Py_global_strings__bindgen_ty_2__bindgen_ty_107,
    pub ___package__: _Py_global_strings__bindgen_ty_2__bindgen_ty_108,
    pub ___parameters__: _Py_global_strings__bindgen_ty_2__bindgen_ty_109,
    pub ___path__: _Py_global_strings__bindgen_ty_2__bindgen_ty_110,
    pub ___pos__: _Py_global_strings__bindgen_ty_2__bindgen_ty_111,
    pub ___pow__: _Py_global_strings__bindgen_ty_2__bindgen_ty_112,
    pub ___prepare__: _Py_global_strings__bindgen_ty_2__bindgen_ty_113,
    pub ___qualname__: _Py_global_strings__bindgen_ty_2__bindgen_ty_114,
    pub ___radd__: _Py_global_strings__bindgen_ty_2__bindgen_ty_115,
    pub ___rand__: _Py_global_strings__bindgen_ty_2__bindgen_ty_116,
    pub ___rdivmod__: _Py_global_strings__bindgen_ty_2__bindgen_ty_117,
    pub ___reduce__: _Py_global_strings__bindgen_ty_2__bindgen_ty_118,
    pub ___reduce_ex__: _Py_global_strings__bindgen_ty_2__bindgen_ty_119,
    pub ___repr__: _Py_global_strings__bindgen_ty_2__bindgen_ty_120,
    pub ___reversed__: _Py_global_strings__bindgen_ty_2__bindgen_ty_121,
    pub ___rfloordiv__: _Py_global_strings__bindgen_ty_2__bindgen_ty_122,
    pub ___rlshift__: _Py_global_strings__bindgen_ty_2__bindgen_ty_123,
    pub ___rmatmul__: _Py_global_strings__bindgen_ty_2__bindgen_ty_124,
    pub ___rmod__: _Py_global_strings__bindgen_ty_2__bindgen_ty_125,
    pub ___rmul__: _Py_global_strings__bindgen_ty_2__bindgen_ty_126,
    pub ___ror__: _Py_global_strings__bindgen_ty_2__bindgen_ty_127,
    pub ___round__: _Py_global_strings__bindgen_ty_2__bindgen_ty_128,
    pub ___rpow__: _Py_global_strings__bindgen_ty_2__bindgen_ty_129,
    pub ___rrshift__: _Py_global_strings__bindgen_ty_2__bindgen_ty_130,
    pub ___rshift__: _Py_global_strings__bindgen_ty_2__bindgen_ty_131,
    pub ___rsub__: _Py_global_strings__bindgen_ty_2__bindgen_ty_132,
    pub ___rtruediv__: _Py_global_strings__bindgen_ty_2__bindgen_ty_133,
    pub ___rxor__: _Py_global_strings__bindgen_ty_2__bindgen_ty_134,
    pub ___set__: _Py_global_strings__bindgen_ty_2__bindgen_ty_135,
    pub ___set_name__: _Py_global_strings__bindgen_ty_2__bindgen_ty_136,
    pub ___setattr__: _Py_global_strings__bindgen_ty_2__bindgen_ty_137,
    pub ___setitem__: _Py_global_strings__bindgen_ty_2__bindgen_ty_138,
    pub ___setstate__: _Py_global_strings__bindgen_ty_2__bindgen_ty_139,
    pub ___sizeof__: _Py_global_strings__bindgen_ty_2__bindgen_ty_140,
    pub ___slotnames__: _Py_global_strings__bindgen_ty_2__bindgen_ty_141,
    pub ___slots__: _Py_global_strings__bindgen_ty_2__bindgen_ty_142,
    pub ___spec__: _Py_global_strings__bindgen_ty_2__bindgen_ty_143,
    pub ___str__: _Py_global_strings__bindgen_ty_2__bindgen_ty_144,
    pub ___sub__: _Py_global_strings__bindgen_ty_2__bindgen_ty_145,
    pub ___subclasscheck__: _Py_global_strings__bindgen_ty_2__bindgen_ty_146,
    pub ___subclasshook__: _Py_global_strings__bindgen_ty_2__bindgen_ty_147,
    pub ___truediv__: _Py_global_strings__bindgen_ty_2__bindgen_ty_148,
    pub ___trunc__: _Py_global_strings__bindgen_ty_2__bindgen_ty_149,
    pub ___typing_is_unpacked_typevartuple__: _Py_global_strings__bindgen_ty_2__bindgen_ty_150,
    pub ___typing_prepare_subst__: _Py_global_strings__bindgen_ty_2__bindgen_ty_151,
    pub ___typing_subst__: _Py_global_strings__bindgen_ty_2__bindgen_ty_152,
    pub ___typing_unpacked_tuple_args__: _Py_global_strings__bindgen_ty_2__bindgen_ty_153,
    pub ___warningregistry__: _Py_global_strings__bindgen_ty_2__bindgen_ty_154,
    pub ___weakref__: _Py_global_strings__bindgen_ty_2__bindgen_ty_155,
    pub ___xor__: _Py_global_strings__bindgen_ty_2__bindgen_ty_156,
    pub __abc_impl: _Py_global_strings__bindgen_ty_2__bindgen_ty_157,
    pub __annotation: _Py_global_strings__bindgen_ty_2__bindgen_ty_158,
    pub __blksize: _Py_global_strings__bindgen_ty_2__bindgen_ty_159,
    pub __bootstrap: _Py_global_strings__bindgen_ty_2__bindgen_ty_160,
    pub __dealloc_warn: _Py_global_strings__bindgen_ty_2__bindgen_ty_161,
    pub __finalizing: _Py_global_strings__bindgen_ty_2__bindgen_ty_162,
    pub __find_and_load: _Py_global_strings__bindgen_ty_2__bindgen_ty_163,
    pub __fix_up_module: _Py_global_strings__bindgen_ty_2__bindgen_ty_164,
    pub __get_sourcefile: _Py_global_strings__bindgen_ty_2__bindgen_ty_165,
    pub __handle_fromlist: _Py_global_strings__bindgen_ty_2__bindgen_ty_166,
    pub __initializing: _Py_global_strings__bindgen_ty_2__bindgen_ty_167,
    pub __is_text_encoding: _Py_global_strings__bindgen_ty_2__bindgen_ty_168,
    pub __lock_unlock_module: _Py_global_strings__bindgen_ty_2__bindgen_ty_169,
    pub __showwarnmsg: _Py_global_strings__bindgen_ty_2__bindgen_ty_170,
    pub __shutdown: _Py_global_strings__bindgen_ty_2__bindgen_ty_171,
    pub __slotnames: _Py_global_strings__bindgen_ty_2__bindgen_ty_172,
    pub __strptime_time: _Py_global_strings__bindgen_ty_2__bindgen_ty_173,
    pub __uninitialized_submodules: _Py_global_strings__bindgen_ty_2__bindgen_ty_174,
    pub __warn_unawaited_coroutine: _Py_global_strings__bindgen_ty_2__bindgen_ty_175,
    pub __xoptions: _Py_global_strings__bindgen_ty_2__bindgen_ty_176,
    pub _add: _Py_global_strings__bindgen_ty_2__bindgen_ty_177,
    pub _append: _Py_global_strings__bindgen_ty_2__bindgen_ty_178,
    pub _big: _Py_global_strings__bindgen_ty_2__bindgen_ty_179,
    pub _buffer: _Py_global_strings__bindgen_ty_2__bindgen_ty_180,
    pub _builtins: _Py_global_strings__bindgen_ty_2__bindgen_ty_181,
    pub _c_call: _Py_global_strings__bindgen_ty_2__bindgen_ty_182,
    pub _c_exception: _Py_global_strings__bindgen_ty_2__bindgen_ty_183,
    pub _c_return: _Py_global_strings__bindgen_ty_2__bindgen_ty_184,
    pub _call: _Py_global_strings__bindgen_ty_2__bindgen_ty_185,
    pub _clear: _Py_global_strings__bindgen_ty_2__bindgen_ty_186,
    pub _close: _Py_global_strings__bindgen_ty_2__bindgen_ty_187,
    pub _closed: _Py_global_strings__bindgen_ty_2__bindgen_ty_188,
    pub _code: _Py_global_strings__bindgen_ty_2__bindgen_ty_189,
    pub _copy: _Py_global_strings__bindgen_ty_2__bindgen_ty_190,
    pub _copyreg: _Py_global_strings__bindgen_ty_2__bindgen_ty_191,
    pub _decode: _Py_global_strings__bindgen_ty_2__bindgen_ty_192,
    pub _default: _Py_global_strings__bindgen_ty_2__bindgen_ty_193,
    pub _defaultaction: _Py_global_strings__bindgen_ty_2__bindgen_ty_194,
    pub _dictcomp: _Py_global_strings__bindgen_ty_2__bindgen_ty_195,
    pub _difference_update: _Py_global_strings__bindgen_ty_2__bindgen_ty_196,
    pub _dispatch_table: _Py_global_strings__bindgen_ty_2__bindgen_ty_197,
    pub _displayhook: _Py_global_strings__bindgen_ty_2__bindgen_ty_198,
    pub _enable: _Py_global_strings__bindgen_ty_2__bindgen_ty_199,
    pub _encode: _Py_global_strings__bindgen_ty_2__bindgen_ty_200,
    pub _encoding: _Py_global_strings__bindgen_ty_2__bindgen_ty_201,
    pub _end_lineno: _Py_global_strings__bindgen_ty_2__bindgen_ty_202,
    pub _end_offset: _Py_global_strings__bindgen_ty_2__bindgen_ty_203,
    pub _errors: _Py_global_strings__bindgen_ty_2__bindgen_ty_204,
    pub _excepthook: _Py_global_strings__bindgen_ty_2__bindgen_ty_205,
    pub _exception: _Py_global_strings__bindgen_ty_2__bindgen_ty_206,
    pub _extend: _Py_global_strings__bindgen_ty_2__bindgen_ty_207,
    pub _filename: _Py_global_strings__bindgen_ty_2__bindgen_ty_208,
    pub _fileno: _Py_global_strings__bindgen_ty_2__bindgen_ty_209,
    pub _fillvalue: _Py_global_strings__bindgen_ty_2__bindgen_ty_210,
    pub _filters: _Py_global_strings__bindgen_ty_2__bindgen_ty_211,
    pub _find_class: _Py_global_strings__bindgen_ty_2__bindgen_ty_212,
    pub _flush: _Py_global_strings__bindgen_ty_2__bindgen_ty_213,
    pub _genexpr: _Py_global_strings__bindgen_ty_2__bindgen_ty_214,
    pub _get: _Py_global_strings__bindgen_ty_2__bindgen_ty_215,
    pub _get_source: _Py_global_strings__bindgen_ty_2__bindgen_ty_216,
    pub _getattr: _Py_global_strings__bindgen_ty_2__bindgen_ty_217,
    pub _getstate: _Py_global_strings__bindgen_ty_2__bindgen_ty_218,
    pub _ignore: _Py_global_strings__bindgen_ty_2__bindgen_ty_219,
    pub _importlib: _Py_global_strings__bindgen_ty_2__bindgen_ty_220,
    pub _inf: _Py_global_strings__bindgen_ty_2__bindgen_ty_221,
    pub _intersection: _Py_global_strings__bindgen_ty_2__bindgen_ty_222,
    pub _isatty: _Py_global_strings__bindgen_ty_2__bindgen_ty_223,
    pub _isinstance: _Py_global_strings__bindgen_ty_2__bindgen_ty_224,
    pub _items: _Py_global_strings__bindgen_ty_2__bindgen_ty_225,
    pub _iter: _Py_global_strings__bindgen_ty_2__bindgen_ty_226,
    pub _join: _Py_global_strings__bindgen_ty_2__bindgen_ty_227,
    pub _keys: _Py_global_strings__bindgen_ty_2__bindgen_ty_228,
    pub _lambda: _Py_global_strings__bindgen_ty_2__bindgen_ty_229,
    pub _last_traceback: _Py_global_strings__bindgen_ty_2__bindgen_ty_230,
    pub _last_type: _Py_global_strings__bindgen_ty_2__bindgen_ty_231,
    pub _last_value: _Py_global_strings__bindgen_ty_2__bindgen_ty_232,
    pub _latin1: _Py_global_strings__bindgen_ty_2__bindgen_ty_233,
    pub _len: _Py_global_strings__bindgen_ty_2__bindgen_ty_234,
    pub _line: _Py_global_strings__bindgen_ty_2__bindgen_ty_235,
    pub _lineno: _Py_global_strings__bindgen_ty_2__bindgen_ty_236,
    pub _listcomp: _Py_global_strings__bindgen_ty_2__bindgen_ty_237,
    pub _little: _Py_global_strings__bindgen_ty_2__bindgen_ty_238,
    pub _locale: _Py_global_strings__bindgen_ty_2__bindgen_ty_239,
    pub _match: _Py_global_strings__bindgen_ty_2__bindgen_ty_240,
    pub _metaclass: _Py_global_strings__bindgen_ty_2__bindgen_ty_241,
    pub _mode: _Py_global_strings__bindgen_ty_2__bindgen_ty_242,
    pub _modules: _Py_global_strings__bindgen_ty_2__bindgen_ty_243,
    pub _mro: _Py_global_strings__bindgen_ty_2__bindgen_ty_244,
    pub _msg: _Py_global_strings__bindgen_ty_2__bindgen_ty_245,
    pub _n_fields: _Py_global_strings__bindgen_ty_2__bindgen_ty_246,
    pub _n_sequence_fields: _Py_global_strings__bindgen_ty_2__bindgen_ty_247,
    pub _n_unnamed_fields: _Py_global_strings__bindgen_ty_2__bindgen_ty_248,
    pub _name: _Py_global_strings__bindgen_ty_2__bindgen_ty_249,
    pub _newlines: _Py_global_strings__bindgen_ty_2__bindgen_ty_250,
    pub _next: _Py_global_strings__bindgen_ty_2__bindgen_ty_251,
    pub _obj: _Py_global_strings__bindgen_ty_2__bindgen_ty_252,
    pub _offset: _Py_global_strings__bindgen_ty_2__bindgen_ty_253,
    pub _onceregistry: _Py_global_strings__bindgen_ty_2__bindgen_ty_254,
    pub _opcode: _Py_global_strings__bindgen_ty_2__bindgen_ty_255,
    pub _open: _Py_global_strings__bindgen_ty_2__bindgen_ty_256,
    pub _parent: _Py_global_strings__bindgen_ty_2__bindgen_ty_257,
    pub _partial: _Py_global_strings__bindgen_ty_2__bindgen_ty_258,
    pub _path: _Py_global_strings__bindgen_ty_2__bindgen_ty_259,
    pub _peek: _Py_global_strings__bindgen_ty_2__bindgen_ty_260,
    pub _persistent_id: _Py_global_strings__bindgen_ty_2__bindgen_ty_261,
    pub _persistent_load: _Py_global_strings__bindgen_ty_2__bindgen_ty_262,
    pub _print_file_and_line: _Py_global_strings__bindgen_ty_2__bindgen_ty_263,
    pub _ps1: _Py_global_strings__bindgen_ty_2__bindgen_ty_264,
    pub _ps2: _Py_global_strings__bindgen_ty_2__bindgen_ty_265,
    pub _raw: _Py_global_strings__bindgen_ty_2__bindgen_ty_266,
    pub _read: _Py_global_strings__bindgen_ty_2__bindgen_ty_267,
    pub _read1: _Py_global_strings__bindgen_ty_2__bindgen_ty_268,
    pub _readable: _Py_global_strings__bindgen_ty_2__bindgen_ty_269,
    pub _readall: _Py_global_strings__bindgen_ty_2__bindgen_ty_270,
    pub _readinto: _Py_global_strings__bindgen_ty_2__bindgen_ty_271,
    pub _readinto1: _Py_global_strings__bindgen_ty_2__bindgen_ty_272,
    pub _readline: _Py_global_strings__bindgen_ty_2__bindgen_ty_273,
    pub _reducer_override: _Py_global_strings__bindgen_ty_2__bindgen_ty_274,
    pub _reload: _Py_global_strings__bindgen_ty_2__bindgen_ty_275,
    pub _replace: _Py_global_strings__bindgen_ty_2__bindgen_ty_276,
    pub _reset: _Py_global_strings__bindgen_ty_2__bindgen_ty_277,
    pub _return: _Py_global_strings__bindgen_ty_2__bindgen_ty_278,
    pub _reversed: _Py_global_strings__bindgen_ty_2__bindgen_ty_279,
    pub _seek: _Py_global_strings__bindgen_ty_2__bindgen_ty_280,
    pub _seekable: _Py_global_strings__bindgen_ty_2__bindgen_ty_281,
    pub _send: _Py_global_strings__bindgen_ty_2__bindgen_ty_282,
    pub _setcomp: _Py_global_strings__bindgen_ty_2__bindgen_ty_283,
    pub _setstate: _Py_global_strings__bindgen_ty_2__bindgen_ty_284,
    pub _sort: _Py_global_strings__bindgen_ty_2__bindgen_ty_285,
    pub _stderr: _Py_global_strings__bindgen_ty_2__bindgen_ty_286,
    pub _stdin: _Py_global_strings__bindgen_ty_2__bindgen_ty_287,
    pub _stdout: _Py_global_strings__bindgen_ty_2__bindgen_ty_288,
    pub _strict: _Py_global_strings__bindgen_ty_2__bindgen_ty_289,
    pub _symmetric_difference_update: _Py_global_strings__bindgen_ty_2__bindgen_ty_290,
    pub _tell: _Py_global_strings__bindgen_ty_2__bindgen_ty_291,
    pub _text: _Py_global_strings__bindgen_ty_2__bindgen_ty_292,
    pub _threading: _Py_global_strings__bindgen_ty_2__bindgen_ty_293,
    pub _throw: _Py_global_strings__bindgen_ty_2__bindgen_ty_294,
    pub _top: _Py_global_strings__bindgen_ty_2__bindgen_ty_295,
    pub _truncate: _Py_global_strings__bindgen_ty_2__bindgen_ty_296,
    pub _unraisablehook: _Py_global_strings__bindgen_ty_2__bindgen_ty_297,
    pub _values: _Py_global_strings__bindgen_ty_2__bindgen_ty_298,
    pub _version: _Py_global_strings__bindgen_ty_2__bindgen_ty_299,
    pub _warnings: _Py_global_strings__bindgen_ty_2__bindgen_ty_300,
    pub _warnoptions: _Py_global_strings__bindgen_ty_2__bindgen_ty_301,
    pub _writable: _Py_global_strings__bindgen_ty_2__bindgen_ty_302,
    pub _write: _Py_global_strings__bindgen_ty_2__bindgen_ty_303,
    pub _zipimporter: _Py_global_strings__bindgen_ty_2__bindgen_ty_304,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_1 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 6usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_2 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_3 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 14usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_4 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_4 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_5 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 15usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_5 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_6 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 2usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_6 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_7 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 16usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_7 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_8 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 16usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_8 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_9 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_9 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_10 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 20usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_10 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_11 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_11 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_12 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_12 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_13 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_13 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_14 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_14 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_15 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_15 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_16 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_16 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_17 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_17 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_18 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 16usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_18 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_19 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_19 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_20 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_20 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_21 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_21 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_22 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_22 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_23 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 16usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_23 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_24 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 13usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_24 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_25 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_25 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_26 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_26 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_27 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 13usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_27 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_28 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_28 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_29 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 18usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_29 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_30 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 14usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_30 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_31 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_31 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_32 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 13usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_32 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_33 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_33 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_34 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_34 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_35 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_35 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_36 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_36 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_37 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_37 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_38 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_38 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_39 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_39 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_40 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_40 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_41 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_41 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_42 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_42 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_43 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_43 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_44 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_44 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_45 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_45 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_46 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_46 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_47 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 13usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_47 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_48 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_48 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_49 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_49 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_50 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_50 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_51 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_51 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_52 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_52 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_53 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 17usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_53 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_54 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 16usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_54 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_55 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_55 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_56 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 15usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_56 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_57 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 18usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_57 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_58 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 13usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_58 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_59 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_59 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_60 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_60 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_61 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_61 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_62 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_62 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_63 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 14usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_63 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_64 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_64 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_65 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_65 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_66 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_66 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_67 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_67 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_68 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_68 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_69 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_69 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_70 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_70 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_71 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 18usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_71 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_72 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 18usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_72 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_73 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_73 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_74 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_74 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_75 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_75 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_76 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_76 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_77 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_77 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_78 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 21usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_78 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_79 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_79 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_80 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_80 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_81 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 13usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_81 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_82 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_82 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_83 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_83 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_84 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_84 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_85 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 16usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_85 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_86 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_86 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_87 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_87 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_88 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_88 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_89 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_89 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_90 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_90 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_91 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_91 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_92 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_92 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_93 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_93 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_94 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_94 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_95 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 16usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_95 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_96 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_96 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_97 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_97 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_98 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_98 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_99 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_99 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_100 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_100 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_101 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_101 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_102 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 14usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_102 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_103 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_103 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_104 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_104 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_105 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_105 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_106 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 15usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_106 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_107 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_107 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_108 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_108 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_109 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 15usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_109 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_110 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_110 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_111 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_111 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_112 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_112 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_113 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_113 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_114 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 13usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_114 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_115 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_115 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_116 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_116 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_117 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_117 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_118 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_118 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_119 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 14usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_119 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_120 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_120 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_121 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 13usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_121 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_122 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 14usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_122 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_123 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_123 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_124 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_124 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_125 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_125 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_126 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_126 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_127 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_127 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_128 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_128 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_129 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_129 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_130 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_130 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_131 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_131 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_132 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_132 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_133 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 13usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_133 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_134 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_134 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_135 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_135 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_136 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 13usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_136 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_137 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_137 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_138 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_138 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_139 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 13usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_139 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_140 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_140 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_141 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 14usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_141 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_142 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_142 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_143 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_143 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_144 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_144 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_145 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_145 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_146 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 18usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_146 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_147 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 17usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_147 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_148 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_148 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_149 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_149 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_150 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 36usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_150 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_151 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 25usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_151 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_152 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 17usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_152 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_153 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 31usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_153 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_154 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 20usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_154 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_155 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_155 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_156 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_156 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_157 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_157 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_158 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_158 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_159 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_159 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_160 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_160 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_161 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 14usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_161 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_162 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_162 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_163 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 15usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_163 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_164 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 15usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_164 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_165 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 16usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_165 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_166 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 17usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_166 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_167 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 14usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_167 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_168 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 18usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_168 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_169 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 20usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_169 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_170 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 13usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_170 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_171 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_171 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_172 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_172 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_173 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 15usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_173 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_174 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 26usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_174 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_175 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 26usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_175 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_176 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_176 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_177 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 4usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_177 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_178 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_178 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_179 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 4usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_179 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_180 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_180 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_181 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_181 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_182 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_182 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_183 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_183 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_184 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_184 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_185 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_185 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_186 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 6usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_186 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_187 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 6usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_187 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_188 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_188 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_189 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_189 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_190 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_190 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_191 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_191 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_192 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_192 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_193 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_193 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_194 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 14usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_194 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_195 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_195 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_196 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 18usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_196 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_197 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 15usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_197 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_198 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_198 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_199 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_199 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_200 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_200 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_201 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_201 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_202 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_202 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_203 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_203 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_204 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_204 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_205 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_205 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_206 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_206 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_207 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_207 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_208 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_208 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_209 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_209 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_210 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_210 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_211 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_211 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_212 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_212 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_213 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 6usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_213 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_214 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_214 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_215 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 4usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_215 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_216 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_216 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_217 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_217 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_218 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_218 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_219 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_219 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_220 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_220 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_221 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 4usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_221 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_222 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 13usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_222 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_223 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_223 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_224 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_224 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_225 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 6usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_225 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_226 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_226 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_227 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_227 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_228 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_228 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_229 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_229 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_230 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 15usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_230 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_231 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_231 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_232 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 11usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_232 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_233 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_233 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_234 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 4usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_234 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_235 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_235 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_236 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_236 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_237 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_237 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_238 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_238 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_239 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_239 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_240 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 6usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_240 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_241 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_241 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_242 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_242 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_243 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_243 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_244 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 4usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_244 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_245 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 4usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_245 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_246 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_246 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_247 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 18usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_247 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_248 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 17usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_248 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_249 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_249 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_250 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_250 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_251 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_251 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_252 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 4usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_252 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_253 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_253 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_254 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 13usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_254 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_255 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_255 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_256 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_256 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_257 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_257 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_258 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_258 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_259 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_259 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_260 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_260 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_261 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 14usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_261 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_262 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 16usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_262 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_263 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 20usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_263 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_264 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 4usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_264 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_265 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 4usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_265 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_266 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 4usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_266 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_267 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_267 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_268 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 6usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_268 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_269 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_269 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_270 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_270 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_271 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_271 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_272 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_272 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_273 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_273 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_274 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 17usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_274 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_275 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_275 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_276 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_276 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_277 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 6usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_277 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_278 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_278 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_279 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_279 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_280 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_280 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_281 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_281 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_282 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_282 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_283 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_283 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_284 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_284 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_285 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_285 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_286 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_286 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_287 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 6usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_287 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_288 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_288 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_289 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_289 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_290 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 28usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_290 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_291 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_291 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_292 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 5usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_292 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_293 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 10usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_293 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_294 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 6usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_294 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_295 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 4usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_295 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_296 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_296 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_297 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 15usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_297 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_298 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 7usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_298 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_299 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 8usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_299 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_300 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_300 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_301 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_301 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_302 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 9usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_302 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_303 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 6usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_303 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_2__bindgen_ty_304 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 12usize],
}
impl Default for _Py_global_strings__bindgen_ty_2__bindgen_ty_304 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl Default for _Py_global_strings__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_3 {
    pub _ascii: PyASCIIObject,
    pub _data: [u8; 2usize],
}
impl Default for _Py_global_strings__bindgen_ty_3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_strings__bindgen_ty_4 {
    pub _latin1: PyCompactUnicodeObject,
    pub _data: [u8; 2usize],
}
impl Default for _Py_global_strings__bindgen_ty_4 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl Default for _Py_global_strings {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _Py_global_objects {
    pub singletons: _Py_global_objects__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _Py_global_objects__bindgen_ty_1 {
    pub small_ints: [PyLongObject; 262usize],
    pub bytes_empty: PyBytesObject,
    pub bytes_characters: [_Py_global_objects__bindgen_ty_1__bindgen_ty_1; 256usize],
    pub strings: _Py_global_strings,
    pub _tuple_empty_gc_not_used: PyGC_Head,
    pub tuple_empty: PyTupleObject,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_global_objects__bindgen_ty_1__bindgen_ty_1 {
    pub ob: PyBytesObject,
    pub eos: ::std::os::raw::c_char,
}
impl Default for _Py_global_objects__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl Default for _Py_global_objects__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl Default for _Py_global_objects {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ast_state {
    pub initialized: ::std::os::raw::c_int,
    pub AST_type: *mut PyObject,
    pub Add_singleton: *mut PyObject,
    pub Add_type: *mut PyObject,
    pub And_singleton: *mut PyObject,
    pub And_type: *mut PyObject,
    pub AnnAssign_type: *mut PyObject,
    pub Assert_type: *mut PyObject,
    pub Assign_type: *mut PyObject,
    pub AsyncFor_type: *mut PyObject,
    pub AsyncFunctionDef_type: *mut PyObject,
    pub AsyncWith_type: *mut PyObject,
    pub Attribute_type: *mut PyObject,
    pub AugAssign_type: *mut PyObject,
    pub Await_type: *mut PyObject,
    pub BinOp_type: *mut PyObject,
    pub BitAnd_singleton: *mut PyObject,
    pub BitAnd_type: *mut PyObject,
    pub BitOr_singleton: *mut PyObject,
    pub BitOr_type: *mut PyObject,
    pub BitXor_singleton: *mut PyObject,
    pub BitXor_type: *mut PyObject,
    pub BoolOp_type: *mut PyObject,
    pub Break_type: *mut PyObject,
    pub Call_type: *mut PyObject,
    pub ClassDef_type: *mut PyObject,
    pub Compare_type: *mut PyObject,
    pub Constant_type: *mut PyObject,
    pub Continue_type: *mut PyObject,
    pub Del_singleton: *mut PyObject,
    pub Del_type: *mut PyObject,
    pub Delete_type: *mut PyObject,
    pub DictComp_type: *mut PyObject,
    pub Dict_type: *mut PyObject,
    pub Div_singleton: *mut PyObject,
    pub Div_type: *mut PyObject,
    pub Eq_singleton: *mut PyObject,
    pub Eq_type: *mut PyObject,
    pub ExceptHandler_type: *mut PyObject,
    pub Expr_type: *mut PyObject,
    pub Expression_type: *mut PyObject,
    pub FloorDiv_singleton: *mut PyObject,
    pub FloorDiv_type: *mut PyObject,
    pub For_type: *mut PyObject,
    pub FormattedValue_type: *mut PyObject,
    pub FunctionDef_type: *mut PyObject,
    pub FunctionType_type: *mut PyObject,
    pub GeneratorExp_type: *mut PyObject,
    pub Global_type: *mut PyObject,
    pub GtE_singleton: *mut PyObject,
    pub GtE_type: *mut PyObject,
    pub Gt_singleton: *mut PyObject,
    pub Gt_type: *mut PyObject,
    pub IfExp_type: *mut PyObject,
    pub If_type: *mut PyObject,
    pub ImportFrom_type: *mut PyObject,
    pub Import_type: *mut PyObject,
    pub In_singleton: *mut PyObject,
    pub In_type: *mut PyObject,
    pub Interactive_type: *mut PyObject,
    pub Invert_singleton: *mut PyObject,
    pub Invert_type: *mut PyObject,
    pub IsNot_singleton: *mut PyObject,
    pub IsNot_type: *mut PyObject,
    pub Is_singleton: *mut PyObject,
    pub Is_type: *mut PyObject,
    pub JoinedStr_type: *mut PyObject,
    pub LShift_singleton: *mut PyObject,
    pub LShift_type: *mut PyObject,
    pub Lambda_type: *mut PyObject,
    pub ListComp_type: *mut PyObject,
    pub List_type: *mut PyObject,
    pub Load_singleton: *mut PyObject,
    pub Load_type: *mut PyObject,
    pub LtE_singleton: *mut PyObject,
    pub LtE_type: *mut PyObject,
    pub Lt_singleton: *mut PyObject,
    pub Lt_type: *mut PyObject,
    pub MatMult_singleton: *mut PyObject,
    pub MatMult_type: *mut PyObject,
    pub MatchAs_type: *mut PyObject,
    pub MatchClass_type: *mut PyObject,
    pub MatchMapping_type: *mut PyObject,
    pub MatchOr_type: *mut PyObject,
    pub MatchSequence_type: *mut PyObject,
    pub MatchSingleton_type: *mut PyObject,
    pub MatchStar_type: *mut PyObject,
    pub MatchValue_type: *mut PyObject,
    pub Match_type: *mut PyObject,
    pub Mod_singleton: *mut PyObject,
    pub Mod_type: *mut PyObject,
    pub Module_type: *mut PyObject,
    pub Mult_singleton: *mut PyObject,
    pub Mult_type: *mut PyObject,
    pub Name_type: *mut PyObject,
    pub NamedExpr_type: *mut PyObject,
    pub Nonlocal_type: *mut PyObject,
    pub NotEq_singleton: *mut PyObject,
    pub NotEq_type: *mut PyObject,
    pub NotIn_singleton: *mut PyObject,
    pub NotIn_type: *mut PyObject,
    pub Not_singleton: *mut PyObject,
    pub Not_type: *mut PyObject,
    pub Or_singleton: *mut PyObject,
    pub Or_type: *mut PyObject,
    pub Pass_type: *mut PyObject,
    pub Pow_singleton: *mut PyObject,
    pub Pow_type: *mut PyObject,
    pub RShift_singleton: *mut PyObject,
    pub RShift_type: *mut PyObject,
    pub Raise_type: *mut PyObject,
    pub Return_type: *mut PyObject,
    pub SetComp_type: *mut PyObject,
    pub Set_type: *mut PyObject,
    pub Slice_type: *mut PyObject,
    pub Starred_type: *mut PyObject,
    pub Store_singleton: *mut PyObject,
    pub Store_type: *mut PyObject,
    pub Sub_singleton: *mut PyObject,
    pub Sub_type: *mut PyObject,
    pub Subscript_type: *mut PyObject,
    pub TryStar_type: *mut PyObject,
    pub Try_type: *mut PyObject,
    pub Tuple_type: *mut PyObject,
    pub TypeIgnore_type: *mut PyObject,
    pub UAdd_singleton: *mut PyObject,
    pub UAdd_type: *mut PyObject,
    pub USub_singleton: *mut PyObject,
    pub USub_type: *mut PyObject,
    pub UnaryOp_type: *mut PyObject,
    pub While_type: *mut PyObject,
    pub With_type: *mut PyObject,
    pub YieldFrom_type: *mut PyObject,
    pub Yield_type: *mut PyObject,
    pub __dict__: *mut PyObject,
    pub __doc__: *mut PyObject,
    pub __match_args__: *mut PyObject,
    pub __module__: *mut PyObject,
    pub _attributes: *mut PyObject,
    pub _fields: *mut PyObject,
    pub alias_type: *mut PyObject,
    pub annotation: *mut PyObject,
    pub arg: *mut PyObject,
    pub arg_type: *mut PyObject,
    pub args: *mut PyObject,
    pub argtypes: *mut PyObject,
    pub arguments_type: *mut PyObject,
    pub asname: *mut PyObject,
    pub ast: *mut PyObject,
    pub attr: *mut PyObject,
    pub bases: *mut PyObject,
    pub body: *mut PyObject,
    pub boolop_type: *mut PyObject,
    pub cases: *mut PyObject,
    pub cause: *mut PyObject,
    pub cls: *mut PyObject,
    pub cmpop_type: *mut PyObject,
    pub col_offset: *mut PyObject,
    pub comparators: *mut PyObject,
    pub comprehension_type: *mut PyObject,
    pub context_expr: *mut PyObject,
    pub conversion: *mut PyObject,
    pub ctx: *mut PyObject,
    pub decorator_list: *mut PyObject,
    pub defaults: *mut PyObject,
    pub elt: *mut PyObject,
    pub elts: *mut PyObject,
    pub end_col_offset: *mut PyObject,
    pub end_lineno: *mut PyObject,
    pub exc: *mut PyObject,
    pub excepthandler_type: *mut PyObject,
    pub expr_context_type: *mut PyObject,
    pub expr_type: *mut PyObject,
    pub finalbody: *mut PyObject,
    pub format_spec: *mut PyObject,
    pub func: *mut PyObject,
    pub generators: *mut PyObject,
    pub guard: *mut PyObject,
    pub handlers: *mut PyObject,
    pub id: *mut PyObject,
    pub ifs: *mut PyObject,
    pub is_async: *mut PyObject,
    pub items: *mut PyObject,
    pub iter: *mut PyObject,
    pub key: *mut PyObject,
    pub keys: *mut PyObject,
    pub keyword_type: *mut PyObject,
    pub keywords: *mut PyObject,
    pub kind: *mut PyObject,
    pub kw_defaults: *mut PyObject,
    pub kwarg: *mut PyObject,
    pub kwd_attrs: *mut PyObject,
    pub kwd_patterns: *mut PyObject,
    pub kwonlyargs: *mut PyObject,
    pub left: *mut PyObject,
    pub level: *mut PyObject,
    pub lineno: *mut PyObject,
    pub lower: *mut PyObject,
    pub match_case_type: *mut PyObject,
    pub mod_type: *mut PyObject,
    pub module: *mut PyObject,
    pub msg: *mut PyObject,
    pub name: *mut PyObject,
    pub names: *mut PyObject,
    pub op: *mut PyObject,
    pub operand: *mut PyObject,
    pub operator_type: *mut PyObject,
    pub ops: *mut PyObject,
    pub optional_vars: *mut PyObject,
    pub orelse: *mut PyObject,
    pub pattern: *mut PyObject,
    pub pattern_type: *mut PyObject,
    pub patterns: *mut PyObject,
    pub posonlyargs: *mut PyObject,
    pub rest: *mut PyObject,
    pub returns: *mut PyObject,
    pub right: *mut PyObject,
    pub simple: *mut PyObject,
    pub slice: *mut PyObject,
    pub step: *mut PyObject,
    pub stmt_type: *mut PyObject,
    pub subject: *mut PyObject,
    pub tag: *mut PyObject,
    pub target: *mut PyObject,
    pub targets: *mut PyObject,
    pub test: *mut PyObject,
    pub type_: *mut PyObject,
    pub type_comment: *mut PyObject,
    pub type_ignore_type: *mut PyObject,
    pub type_ignores: *mut PyObject,
    pub unaryop_type: *mut PyObject,
    pub upper: *mut PyObject,
    pub value: *mut PyObject,
    pub values: *mut PyObject,
    pub vararg: *mut PyObject,
    pub withitem_type: *mut PyObject,
}
impl Default for ast_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct callable_cache {
    pub isinstance: *mut PyObject,
    pub len: *mut PyObject,
    pub list_append: *mut PyObject,
}
impl Default for callable_cache {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyHamtNode {
    pub ob_base: PyObject,
}
impl Default for PyHamtNode {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyHamtObject {
    pub ob_base: PyObject,
    pub h_root: *mut PyHamtNode,
    pub h_weakreflist: *mut PyObject,
    pub h_count: Py_ssize_t,
}
impl Default for PyHamtObject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_context_state {
    pub freelist: *mut PyContext,
    pub numfree: ::std::os::raw::c_int,
}
impl Default for _Py_context_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _pycontextobject {
    pub ob_base: PyObject,
    pub ctx_prev: *mut PyContext,
    pub ctx_vars: *mut PyHamtObject,
    pub ctx_weakreflist: *mut PyObject,
    pub ctx_entered: ::std::os::raw::c_int,
}
impl Default for _pycontextobject {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _Py_dict_state {
    pub free_list: [*mut PyDictObject; 80usize],
    pub numfree: ::std::os::raw::c_int,
    pub keys_free_list: [*mut PyDictKeysObject; 80usize],
    pub keys_numfree: ::std::os::raw::c_int,
}
impl Default for _Py_dict_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyDictKeyEntry {
    pub me_hash: Py_hash_t,
    pub me_key: *mut PyObject,
    pub me_value: *mut PyObject,
}
impl Default for PyDictKeyEntry {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PyDictUnicodeEntry {
    pub me_key: *mut PyObject,
    pub me_value: *mut PyObject,
}
impl Default for PyDictUnicodeEntry {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct _dictkeysobject {
    pub dk_refcnt: Py_ssize_t,
    pub dk_log2_size: u8,
    pub dk_log2_index_bytes: u8,
    pub dk_kind: u8,
    pub dk_version: u32,
    pub dk_usable: Py_ssize_t,
    pub dk_nentries: Py_ssize_t,
    pub dk_indices: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _dictvalues {
    pub values: [*mut PyObject; 1usize],
}
impl Default for _dictvalues {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_exc_state {
    pub errnomap: *mut PyObject,
    pub memerrors_freelist: *mut PyBaseExceptionObject,
    pub memerrors_numfree: ::std::os::raw::c_int,
    pub PyExc_ExceptionGroup: *mut PyObject,
}
impl Default for _Py_exc_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_float_state {
    pub numfree: ::std::os::raw::c_int,
    pub free_list: *mut PyFloatObject,
}
impl Default for _Py_float_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _Py_async_gen_state {
    pub value_freelist: [*mut _PyAsyncGenWrappedValue; 80usize],
    pub value_numfree: ::std::os::raw::c_int,
    pub asend_freelist: [*mut PyAsyncGenASend; 80usize],
    pub asend_numfree: ::std::os::raw::c_int,
}
impl Default for _Py_async_gen_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _Py_list_state {
    pub free_list: [*mut PyListObject; 80usize],
    pub numfree: ::std::os::raw::c_int,
}
impl Default for _Py_list_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_tuple_state {
    pub free_list: [*mut PyTupleObject; 20usize],
    pub numfree: [::std::os::raw::c_int; 20usize],
}
impl Default for _Py_tuple_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct type_cache_entry {
    pub version: ::std::os::raw::c_uint,
    pub name: *mut PyObject,
    pub value: *mut PyObject,
}
impl Default for type_cache_entry {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct type_cache {
    pub hashtable: [type_cache_entry; 4096usize],
}
impl Default for type_cache {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub const _Py_error_handler__Py_ERROR_UNKNOWN: _Py_error_handler = 0;
pub const _Py_error_handler__Py_ERROR_STRICT: _Py_error_handler = 1;
pub const _Py_error_handler__Py_ERROR_SURROGATEESCAPE: _Py_error_handler = 2;
pub const _Py_error_handler__Py_ERROR_REPLACE: _Py_error_handler = 3;
pub const _Py_error_handler__Py_ERROR_IGNORE: _Py_error_handler = 4;
pub const _Py_error_handler__Py_ERROR_BACKSLASHREPLACE: _Py_error_handler = 5;
pub const _Py_error_handler__Py_ERROR_SURROGATEPASS: _Py_error_handler = 6;
pub const _Py_error_handler__Py_ERROR_XMLCHARREFREPLACE: _Py_error_handler = 7;
pub const _Py_error_handler__Py_ERROR_OTHER: _Py_error_handler = 8;
pub type _Py_error_handler = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_unicode_runtime_ids {
    pub lock: PyThread_type_lock,
    pub next_index: Py_ssize_t,
}
impl Default for _Py_unicode_runtime_ids {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_unicode_fs_codec {
    pub encoding: *mut ::std::os::raw::c_char,
    pub utf8: ::std::os::raw::c_int,
    pub errors: *mut ::std::os::raw::c_char,
    pub error_handler: _Py_error_handler,
}
impl Default for _Py_unicode_fs_codec {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_unicode_ids {
    pub size: Py_ssize_t,
    pub array: *mut *mut PyObject,
}
impl Default for _Py_unicode_ids {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_unicode_state {
    pub fs_codec: _Py_unicode_fs_codec,
    pub ids: _Py_unicode_ids,
}
impl Default for _Py_unicode_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _warnings_runtime_state {
    pub filters: *mut PyObject,
    pub once_registry: *mut PyObject,
    pub default_action: *mut PyObject,
    pub filters_version: ::std::os::raw::c_long,
}
impl Default for _warnings_runtime_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _pending_calls {
    pub lock: PyThread_type_lock,
    pub calls_to_do: _Py_atomic_int,
    pub async_exc: ::std::os::raw::c_int,
    pub calls: [_pending_calls__bindgen_ty_1; 32usize],
    pub first: ::std::os::raw::c_int,
    pub last: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _pending_calls__bindgen_ty_1 {
    pub func: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub arg: *mut ::std::os::raw::c_void,
}
impl Default for _pending_calls__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl Default for _pending_calls {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ceval_state {
    pub recursion_limit: ::std::os::raw::c_int,
    pub eval_breaker: _Py_atomic_int,
    pub gil_drop_request: _Py_atomic_int,
    pub pending: _pending_calls,
}
impl Default for _ceval_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atexit_callback {
    pub func: *mut PyObject,
    pub args: *mut PyObject,
    pub kwargs: *mut PyObject,
}
impl Default for atexit_callback {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atexit_state {
    pub callbacks: *mut *mut atexit_callback,
    pub ncallbacks: ::std::os::raw::c_int,
    pub callback_len: ::std::os::raw::c_int,
}
impl Default for atexit_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _is {
    pub next: *mut PyInterpreterState,
    pub threads: _is_pythreads,
    pub runtime: *mut pyruntimestate,
    pub id: i64,
    pub id_refcount: i64,
    pub requires_idref: ::std::os::raw::c_int,
    pub id_mutex: PyThread_type_lock,
    pub _initialized: ::std::os::raw::c_int,
    pub finalizing: ::std::os::raw::c_int,
    pub _static: bool,
    pub ceval: _ceval_state,
    pub gc: _gc_runtime_state,
    pub modules: *mut PyObject,
    pub modules_by_index: *mut PyObject,
    pub sysdict: *mut PyObject,
    pub builtins: *mut PyObject,
    pub importlib: *mut PyObject,
    pub override_frozen_modules: ::std::os::raw::c_int,
    pub codec_search_path: *mut PyObject,
    pub codec_search_cache: *mut PyObject,
    pub codec_error_registry: *mut PyObject,
    pub codecs_initialized: ::std::os::raw::c_int,
    pub config: PyConfig,
    pub dlopenflags: ::std::os::raw::c_int,
    pub dict: *mut PyObject,
    pub builtins_copy: *mut PyObject,
    pub import_func: *mut PyObject,
    pub eval_frame: _PyFrameEvalFunction,
    pub co_extra_user_count: Py_ssize_t,
    pub co_extra_freefuncs: [freefunc; 255usize],
    pub before_forkers: *mut PyObject,
    pub after_forkers_parent: *mut PyObject,
    pub after_forkers_child: *mut PyObject,
    pub warnings: _warnings_runtime_state,
    pub atexit: atexit_state,
    pub audit_hooks: *mut PyObject,
    pub unicode: _Py_unicode_state,
    pub float_state: _Py_float_state,
    pub slice_cache: *mut PySliceObject,
    pub tuple: _Py_tuple_state,
    pub list: _Py_list_state,
    pub dict_state: _Py_dict_state,
    pub async_gen: _Py_async_gen_state,
    pub context: _Py_context_state,
    pub exc_state: _Py_exc_state,
    pub ast: ast_state,
    pub type_cache: type_cache,
    pub callable_cache: callable_cache,
    pub _initial_thread: PyThreadState,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _is_pythreads {
    pub next_unique_id: u64,
    pub head: *mut PyThreadState,
    pub count: ::std::os::raw::c_long,
    pub stacksize: usize,
}
impl Default for _is_pythreads {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl Default for _is {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _xidregitem {
    pub cls: *mut PyTypeObject,
    pub getdata: crossinterpdatafunc,
    pub next: *mut _xidregitem,
}
impl Default for _xidregitem {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _ceval_runtime_state {
    pub signals_pending: _Py_atomic_int,
    pub gil: _gil_runtime_state,
}
impl Default for _ceval_runtime_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gilstate_runtime_state {
    pub check_enabled: ::std::os::raw::c_int,
    pub tstate_current: _Py_atomic_address,
    pub autoInterpreterState: *mut PyInterpreterState,
    pub autoTSSkey: Py_tss_t,
}
impl Default for _gilstate_runtime_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Py_AuditHookEntry {
    pub next: *mut _Py_AuditHookEntry,
    pub hookCFunction: Py_AuditHookFunction,
    pub userData: *mut ::std::os::raw::c_void,
}
impl Default for _Py_AuditHookEntry {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pyruntimestate {
    pub _initialized: ::std::os::raw::c_int,
    pub preinitializing: ::std::os::raw::c_int,
    pub preinitialized: ::std::os::raw::c_int,
    pub core_initialized: ::std::os::raw::c_int,
    pub initialized: ::std::os::raw::c_int,
    pub _finalizing: _Py_atomic_address,
    pub interpreters: pyruntimestate_pyinterpreters,
    pub xidregistry: pyruntimestate__xidregistry,
    pub main_thread: ::std::os::raw::c_ulong,
    pub exitfuncs: [::std::option::Option<unsafe extern "C" fn()>; 32usize],
    pub nexitfuncs: ::std::os::raw::c_int,
    pub ceval: _ceval_runtime_state,
    pub gilstate: _gilstate_runtime_state,
    pub preconfig: PyPreConfig,
    pub open_code_hook: Py_OpenCodeHookFunction,
    pub open_code_userdata: *mut ::std::os::raw::c_void,
    pub audit_hook_head: *mut _Py_AuditHookEntry,
    pub unicode_ids: _Py_unicode_runtime_ids,
    pub global_objects: _Py_global_objects,
    pub _main_interpreter: PyInterpreterState,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pyruntimestate_pyinterpreters {
    pub mutex: PyThread_type_lock,
    pub head: *mut PyInterpreterState,
    pub main: *mut PyInterpreterState,
    pub next_id: i64,
}
impl Default for pyruntimestate_pyinterpreters {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pyruntimestate__xidregistry {
    pub mutex: PyThread_type_lock,
    pub head: *mut _xidregitem,
}
impl Default for pyruntimestate__xidregistry {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl Default for pyruntimestate {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _frame {
    pub ob_base: PyObject,
    pub f_back: *mut PyFrameObject,
    pub f_frame: *mut _PyInterpreterFrame,
    pub f_trace: *mut PyObject,
    pub f_lineno: ::std::os::raw::c_int,
    pub f_trace_lines: ::std::os::raw::c_char,
    pub f_trace_opcodes: ::std::os::raw::c_char,
    pub f_fast_as_locals: ::std::os::raw::c_char,
    pub _f_frame_data: [*mut PyObject; 1usize],
}
impl Default for _frame {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _PyInterpreterFrame {
    pub f_func: *mut PyFunctionObject,
    pub f_globals: *mut PyObject,
    pub f_builtins: *mut PyObject,
    pub f_locals: *mut PyObject,
    pub f_code: *mut PyCodeObject,
    pub frame_obj: *mut PyFrameObject,
    pub previous: *mut _PyInterpreterFrame,
    pub prev_instr: *mut _Py_CODEUNIT,
    pub stacktop: ::std::os::raw::c_int,
    pub is_entry: bool,
    pub owner: ::std::os::raw::c_char,
    pub localsplus: [*mut PyObject; 1usize],
}
impl Default for _PyInterpreterFrame {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _PyAsyncGenWrappedValue {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PyAsyncGenASend {
    pub _address: u8,
}
