/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.console.internal.extension;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.io.console.Console;
import org.openhab.core.io.console.ConsoleCommandCompleter;
import org.openhab.core.io.console.extensions.AbstractConsoleCommandExtension;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;
import org.openhab.core.io.console.internal.extension.ItemConsoleCommandCompleter;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemNotUniqueException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.types.Command;
import org.openhab.core.types.TypeParser;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConsoleCommandExtension.class})
@NonNullByDefault
public class SendConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private final ItemRegistry itemRegistry;
    private final EventPublisher eventPublisher;

    @Activate
    public SendConsoleCommandExtension(@Reference ItemRegistry itemRegistry, @Reference EventPublisher eventPublisher) {
        super("send", "Send a command to an item.");
        this.itemRegistry = itemRegistry;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public List<String> getUsages() {
        return List.of(this.buildCommandUsage("<item> <command>", "sends a command for an item"));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(String[] args, Console console) {
        block12: {
            if (args.length > 0) {
                itemName = args[0];
                try {
                    item = this.itemRegistry.getItemByPattern(itemName);
                    if (args.length > 1) {
                        commandName = args[1];
                        command = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)commandName);
                        if (command != null) {
                            this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)itemName, (Command)command));
                            console.println("Command has been sent successfully.");
                        } else {
                            console.println("Error: Command '" + commandName + "' is not valid for item '" + itemName + "'");
                            console.println("Valid command types are:");
                            for (Class acceptedType : item.getAcceptedCommandTypes()) {
                                console.print("  " + acceptedType.getSimpleName());
                                if (acceptedType.isEnum()) {
                                    console.print(": ");
                                    var12_16 = Objects.requireNonNull((Command[])acceptedType.getEnumConstants());
                                    var11_15 = var12_16.length;
                                    var10_14 = 0;
                                    while (var10_14 < var11_15) {
                                        e = var12_16[var10_14];
                                        console.print(String.valueOf(e) + " ");
                                        ++var10_14;
                                    }
                                }
                                console.println("");
                            }
                        }
                    } else {
                        this.printUsage(console);
                    }
                    break block12;
                }
                catch (ItemNotFoundException e) {
                    console.println("Error: Item '" + itemName + "' does not exist.");
                    break block12;
                }
                catch (ItemNotUniqueException e) {
                    console.print("Error: Multiple items match this pattern: ");
                    ** for (item : e.getMatchingItems())
                }
lbl-1000:
                // 1 sources

                {
                    console.print(item.getName() + " ");
                    continue;
lbl39:
                    // 1 sources

                    break block12;
                }
            }
            this.printUsage(console);
        }
    }

    @Override
    public @Nullable ConsoleCommandCompleter getCompleter() {
        return new ItemConsoleCommandCompleter(this.itemRegistry, i -> (Class[])i.getAcceptedCommandTypes().toArray(Class[]::new));
    }
}

