searchData={"items":[{"type":"behaviour","title":"application","doc":"Generic OTP application functions\n\nIn OTP, _application_ denotes a component implementing some specific\nfunctionality, that can be started and stopped as a unit, and that can be reused\nin other systems. This module interacts with _application controller_, a process\nstarted at every Erlang runtime system. This module contains functions for\ncontrolling applications (for example, starting and stopping applications), and\nfunctions to access information about applications (for example, configuration\nparameters).\n\nAn application is defined by an _application specification_. The specification\nis normally located in an _application resource file_ named `Application.app`,\nwhere `Application` is the application name. For details about the application\nspecification, see [`app`](app.md).\n\nThis module can also be viewed as a behaviour for an application implemented\naccording to the OTP design principles as a supervision tree. The definition of\nhow to start and stop the tree is to be located in an _application callback\nmodule_, exporting a predefined set of functions.\n\nFor details about applications and behaviours, see\n[OTP Design Principles](`e:system:design_principles.md`).","ref":"application.html"},{"type":"behaviour","title":"See Also - application","doc":"[OTP Design Principles](`e:system:design_principles.md`),\n[kernel](kernel_app.md), [app](app.md)","ref":"application.html#module-see-also"},{"type":"type","title":"application.application_opt/0","doc":"The built-in options available to an application.\n\nSee [app](app.md) for descriptions of the options.","ref":"application.html#t:application_opt/0"},{"type":"type","title":"application.application_spec/0","doc":"An application specification.","ref":"application.html#t:application_spec/0"},{"type":"callback","title":"application.config_change/3","doc":"This function is called by an application after a code replacement, if the\nconfiguration parameters have changed.\n\n`Changed` is a list of parameter-value tuples including all configuration\nparameters with changed values.\n\n`New` is a list of parameter-value tuples including all added configuration\nparameters.\n\n`Removed` is a list of all removed parameters.","ref":"application.html#c:config_change/3"},{"type":"function","title":"application.ensure_all_started/1","doc":"Equivalent to  ensure_all_started(Applications, temporary, serial) .","ref":"application.html#ensure_all_started/1"},{"type":"function","title":"application.ensure_all_started/2","doc":"Equivalent to  ensure_all_started(Applications, Type, serial) .","ref":"application.html#ensure_all_started/2"},{"type":"function","title":"application.ensure_all_started/3","doc":"`Applications` is either an an `t:atom/0` or a list of `t:atom/0` representing\nmultiple applications.\n\nThis function is equivalent to calling [`start/1,2`](`start/1`) repeatedly on\nall dependencies that are not yet started of each application. Optional\ndependencies will also be loaded and started if they are available.\n\nThe `Mode` argument controls if the applications should be started in `serial`\nmode (one at a time) or `concurrent` mode. In concurrent mode, a dependency\ngraph is built and the leaves of the graph are started concurrently and\nrecursively. In both modes, no assertion can be made about the order the\napplications are started. If not supplied, it defaults to `serial`.\n\nReturns `{ok, AppNames}` for a successful start or for an already started\napplication (which is, however, omitted from the `AppNames` list).\n\nThe function reports `{error, {AppName,Reason}}` for errors, where `Reason` is\nany possible reason returned by [`start/1,2`](`start/1`) when starting a\nspecific dependency.\n\nIf an error occurs, the applications started by the function are stopped to\nbring the set of running applications back to its initial state.","ref":"application.html#ensure_all_started/3"},{"type":"function","title":"application.ensure_started/1","doc":"Equivalent to [`start(Application)`](`start/1`) except it returns `ok` for\nalready started applications.","ref":"application.html#ensure_started/1"},{"type":"function","title":"application.ensure_started/2","doc":"Equivalent to [`start(Application, Type)`](`start/2`) except it returns `ok` for\nalready started applications.","ref":"application.html#ensure_started/2"},{"type":"function","title":"application.get_all_env/0","doc":"Equivalent to  get_all_env(application:get_application()) .","ref":"application.html#get_all_env/0"},{"type":"function","title":"application.get_all_env/1","doc":"Returns the configuration parameters and their values for `Application`.\n\nIf the specified application is not loaded, or if the process executing the call\ndoes not belong to any application, the function returns `[]`.","ref":"application.html#get_all_env/1"},{"type":"function","title":"application.get_all_key/0","doc":"Equivalent to  get_all_key(application:get_application()) .","ref":"application.html#get_all_key/0"},{"type":"function","title":"application.get_all_key/1","doc":"Returns the application specification keys and their values for `Application`.\nIf the argument is omitted, it defaults to the application of the calling\nprocess.\n\nIf the specified application is not loaded, the function returns `undefined`. If\nthe process executing the call does not belong to any application, the function\nreturns `[]`.","ref":"application.html#get_all_key/1"},{"type":"function","title":"application.get_application/0","doc":"Equivalent to  get_application(self()) .","ref":"application.html#get_application/0"},{"type":"function","title":"application.get_application/1","doc":"Returns the name of the application to which the process `Pid` or the module\n`Module` belongs.\n\nIf the specified process does not belong to any application, or if the specified\nprocess or module does not exist, the function returns `undefined`.","ref":"application.html#get_application/1"},{"type":"function","title":"application.get_env/1","doc":"Equivalent to  get_env(application:get_application(), Par) .","ref":"application.html#get_env/1"},{"type":"function","title":"application.get_env/2","doc":"Returns the value of configuration parameter `Par` for `Application`.\n\nReturns `undefined` if any of the following applies:\n\n- The specified application is not loaded.\n- The configuration parameter does not exist.\n- The process executing the call does not belong to any application.","ref":"application.html#get_env/2"},{"type":"function","title":"application.get_env/3","doc":"Works like `get_env/2` but returns value `Def` when configuration parameter\n`Par` does not exist.","ref":"application.html#get_env/3"},{"type":"function","title":"application.get_key/1","doc":"Equivalent to  get_key(application:get_application(), Key) .","ref":"application.html#get_key/1"},{"type":"function","title":"application.get_key/2","doc":"Returns the value of the application specification key `Key` for `Application`.\n\nReturns `undefined` if any of the following applies:\n\n- The specified application is not loaded.\n- The specification key does not exist.\n- The process executing the call does not belong to any application.","ref":"application.html#get_key/2"},{"type":"function","title":"application.get_supervisor/1","doc":"Returns the `Pid` of the supervisor running at the root of `Application`.\n\nIf the specified application does not exist or does not define a callback\nmodule, the function returns `undefined`.","ref":"application.html#get_supervisor/1"},{"type":"function","title":"application.load/1","doc":"Equivalent to  load(AppDescr, []) .","ref":"application.html#load/1"},{"type":"function","title":"application.load/2","doc":"Loads the application specification for an application into the application\ncontroller. It also loads the application specifications for any included\napplications. Notice that the function does not load the Erlang object code.\n\nThe application can be specified by its name `Application`. In this case, the\napplication controller searches the code path for the application resource file\n`Application.app` and loads the specification it contains.\n\nThe application specification can also be specified directly as a tuple\n`AppSpec`, having the format and contents as described in [`app`](app.md).\n\nIf `Distributed == {Application,[Time,]Nodes}`, the application becomes\ndistributed. The argument overrides the value for the application in the Kernel\nconfiguration parameter `distributed`. `Application` must be the application\nname (same as in the first argument). If a node crashes and `Time` is specified,\nthe application controller waits for `Time` milliseconds before attempting to\nrestart the application on another node. If `Time` is not specified, it defaults\nto `0` and the application is restarted immediately.\n\n`Nodes` is a list of node names where the application can run, in priority from\nleft to right. Node names can be grouped using tuples to indicate that they have\nthe same priority.\n\n_Example:_\n\n```erlang\nNodes = [cp1@cave, {cp2@cave, cp3@cave}]\n```\n\nThis means that the application is preferably to be started at `cp1@cave`. If\n`cp1@cave` is down, the application is to be started at `cp2@cave` or\n`cp3@cave`.\n\nIf `Distributed == default`, the value for the application in the Kernel\nconfiguration parameter `distributed` is used.","ref":"application.html#load/2"},{"type":"function","title":"application.loaded_applications/0","doc":"Returns a list with information about the applications, and included\napplications, which are loaded using `load/1,2`. `Application` is the\napplication name. `Description` and `Vsn` are the values of their `description`\nand `vsn` application specification keys, respectively.","ref":"application.html#loaded_applications/0"},{"type":"function","title":"application.permit/2","doc":"Changes the permission for `Application` to run at the current node. The\napplication must be loaded using `load/1,2` for the function to have effect.\n\nIf the permission of a loaded, but not started, application is set to `false`,\n`start` returns `ok` but the application is not started until the permission is\nset to `true`.\n\nIf the permission of a running application is set to `false`, the application is\nstopped. If the permission later is set to `true`, it is restarted.\n\nIf the application is distributed, setting the permission to `false` means that\nthe application will be started at, or moved to, another node according to how\nits distribution is configured (see `load/2`).\n\nThe function does not return until the application is started, stopped, or\nsuccessfully moved to another node. However, in some cases where permission is\nset to `true`, the function returns `ok` even though the application is not\nstarted. This is true when an application cannot start because of dependencies\nto other applications that are not yet started. When they are started,\n`Application` is started as well.\n\nBy default, all applications are loaded with permission `true` on all nodes. The\npermission can be configured using the Kernel configuration parameter\n`permissions`.","ref":"application.html#permit/2"},{"type":"callback","title":"application.prep_stop/1","doc":"This function is called when an application is about to be stopped, before\nshutting down the processes of the application.\n\n`State` is the state returned from [`Module:start/2`](`c:start/2`), or `[]` if\nno state was returned. `NewState` is any term and is passed to\n[`Module:stop/1`](`c:stop/1`).\n\nThe function is optional. If it is not defined, the processes are terminated and\nthen [`Module:stop(State)`](`c:stop/1`) is called.","ref":"application.html#c:prep_stop/1"},{"type":"type","title":"application.restart_type/0","doc":"The type of restart behaviour an application should have.","ref":"application.html#t:restart_type/0"},{"type":"function","title":"application.set_env/1","doc":"Equivalent to  set_env(Config, []) .","ref":"application.html#set_env/1"},{"type":"function","title":"application.set_env/2","doc":"Sets the configuration `Config` for multiple applications.\n\nIt is equivalent to calling [`set_env/4`](`set_env/4`) on each application\nindividually, except it is more efficient. The given `Config` is validated before\nthe configuration is set.\n\n[`set_env/2`](`set_env/2`) uses the standard `gen_server` time-out value (5000\nms). Option `timeout` can be specified if another time-out value is useful, for\nexample, in situations where the application controller is heavily loaded.\n\nOption `persistent` can be set to `true` to guarantee that parameters set with\n[`set_env/2`](`set_env/2`) are not overridden by those defined in the\napplication resource file on load. This means that persistent values will stick\nafter the application is loaded and also on application reload.\n\nIf an application is given more than once or if an application has the same key\ngiven more than once, the behaviour is undefined and a warning message will be\nlogged. In future releases, an error will be raised.\n\n> #### Warning {: .warning }\n>\n> Use this function only if you know what you are doing, that is, on your own\n> applications. It is very application-dependent and configuration\n> parameter-dependent when and how often the value is read by the application.\n> Careless use of this function can put the application in a weird,\n> inconsistent, and malfunctioning state.","ref":"application.html#set_env/2"},{"type":"function","title":"application.set_env/3","doc":"Equivalent to  set_env(Application, Par, Val, []) .","ref":"application.html#set_env/3"},{"type":"function","title":"application.set_env/4","doc":"Sets the value of configuration parameter `Par` for `Application`.\n\n[`set_env/4`](`set_env/4`) uses the standard `gen_server` time-out value (5000\nms). Option `timeout` can be specified if another time-out value is useful, for\nexample, in situations where the application controller is heavily loaded.\n\nIf [`set_env/4`](`set_env/4`) is called before the application is loaded, the\napplication environment values specified in file `Application.app` override the\nones previously set. This is also true for application reloads.\n\nOption `persistent` can be set to `true` to guarantee that parameters set with\n[`set_env/4`](`set_env/4`) are not overridden by those defined in the\napplication resource file on load. This means that persistent values will stick\nafter the application is loaded and also on application reload.\n\n> #### Warning {: .warning }\n>\n> Use this function only if you know what you are doing, that is, on your own\n> applications. It is very application-dependent and configuration\n> parameter-dependent when and how often the value is read by the application.\n> Careless use of this function can put the application in a weird,\n> inconsistent, and malfunctioning state.","ref":"application.html#set_env/4"},{"type":"function","title":"application.start/1","doc":"Equivalent to  start(Application, temporary) .","ref":"application.html#start/1"},{"type":"callback","title":"application.start/2","doc":"This function is called whenever an application is started using `start/1,2`,\nand is to start the processes of the application. If the application is\nstructured according to the OTP design principles as a supervision tree, this\nmeans starting the top supervisor of the tree.\n\n`StartType`{: #start_type } defines the type of start:\n\n- `normal` if it is a normal startup.\n- `normal` also if the application is distributed and started at the current\n  node because of a failover from another node, and the application\n  specification key `start_phases == undefined`.\n- `{takeover,Node}` if the application is distributed and started at the current\n  node because of a takeover from `Node`, either because\n  [`takeover/2`](`takeover/2`) has been called or because the current node has\n  higher priority than `Node`.\n- `{failover,Node}` if the application is distributed and started at the current\n  node because of a failover from `Node`, and the application specification key\n  `start_phases /= undefined`.\n\n`StartArgs` is the `StartArgs` argument defined by the application specification\nkey `mod`.\n\nThe function is to return `{ok,Pid}` or `{ok,Pid,State}`, where `Pid` is the pid\nof the top supervisor and `State` is any term. If omitted, `State` defaults to\n`[]`. If the application is stopped later, `State` is passed to\n[`Module:prep_stop/1`](`c:prep_stop/1`).","ref":"application.html#c:start/2"},{"type":"function","title":"application.start/2","doc":"Starts `Application`. If it is not loaded, the application controller first\nloads it using [`load/1`](`load/1`). It ensures that any included applications\nare loaded, but does not start them. That is assumed to be taken care of in the\ncode for `Application`.\n\nThe application controller checks the value of the application specification key\n`applications`, to ensure that all applications needed to be started before this\napplication are running. If an application is missing and the application is not\nmarked as optional, `{error,{not_started,App}}` is returned, where `App` is the\nname of the missing application. Note this function makes no attempt to start\nany of the applications listed in `applications`, not even optional ones. See\n[`ensure_all_started/1,2`](`ensure_all_started/1`) for recursively starting the\ncurrent application and its dependencies.\n\nOnce validated, the application controller then creates an _application master_\nfor the application. The application master becomes the group leader of all the\nprocesses in the application. I/O is forwarded to the previous group leader,\nthough, this is just a way to identify processes that belong to the application.\nUsed for example to find itself from any process, or, reciprocally, to kill them\nall when it terminates.\n\nThe application master starts the application by calling the application\ncallback function [`Module:start/2`](`c:start/2`) as defined by the application\nspecification key `mod`.\n\nArgument `Type` specifies the type of the application. If omitted, it defaults\nto `temporary`.\n\n- If a permanent application terminates, all other applications and the entire\n  Erlang node are also terminated.\n- If a transient application terminates:\n  - with `Reason == normal`, this is reported but no other applications are\n    terminated.\n  - abnormally, all other applications and the entire Erlang node are also\n    terminated.\n- If a temporary application terminates, this is reported but no other\n  applications are terminated.\n\nNotice that an application can always be stopped explicitly by calling\n[`stop/1`](`stop/1`). Regardless of the type of the application, no other\napplications are affected.\n\nNotice also that the transient type is of little practical use, because when a\nsupervision tree terminates, the reason is set to `shutdown`, not `normal`.","ref":"application.html#start/2"},{"type":"callback","title":"application.start_phase/3","doc":"Starts an application with included applications, when synchronization is needed\nbetween processes in the different applications during startup.\n\nThe start phases are defined by the application specification key\n`start_phases == [{Phase,PhaseArgs}]`. For included applications, the set of\nphases must be a subset of the set of phases defined for the including\napplication.\n\nThe function is called for each start phase (as defined for the primary\napplication) for the primary application and all included applications, for\nwhich the start phase is defined.\n\nFor a description of `StartType`, see [`Module:start/2`](`c:start/2`).","ref":"application.html#c:start_phase/3"},{"type":"type","title":"application.start_type/0","doc":"The reason for the application to be started on the current node.","ref":"application.html#t:start_type/0"},{"type":"function","title":"application.start_type/0","doc":"This function is intended to be called by a process belonging to an application,\nwhen the application is started, to determine the start type, which is\n`StartType` or `local`.\n\nFor a description of `StartType`, see\n[`Module:start/2`](`m:application#start_type`).\n\n`local` is returned if only parts of the application are restarted (by a\nsupervisor), or if the function is called outside a startup.\n\nIf the process executing the call does not belong to any application, the\nfunction returns `undefined`.","ref":"application.html#start_type/0"},{"type":"callback","title":"application.stop/1","doc":"This function is called whenever an application has stopped. It is intended to\nbe the opposite of [`Module:start/2`](`c:start/2`) and is to do any necessary\ncleaning up. The return value is ignored.\n\n`State` is the return value of [`Module:prep_stop/1`](`c:prep_stop/1`), if such\na function exists. Otherwise `State` is taken from the return value of\n[`Module:start/2`](`c:start/2`).","ref":"application.html#c:stop/1"},{"type":"function","title":"application.stop/1","doc":"Stops `Application`. The application master calls\n[`Module:prep_stop/1`](`c:prep_stop/1`), if such a function is defined, and then\ntells the top supervisor of the application to shut down (see `m:supervisor`).\n\nThis means that the entire supervision tree, including included applications, is\nterminated in reversed start order. After the shutdown, the application master\ncalls [`Module:stop/1`](`c:stop/1`). `Module` is the callback module as defined\nby the application specification key `mod`.\n\nLast, the application master terminates. Notice that all processes with the\napplication master as group leader, that is, processes spawned from a process\nbelonging to the application, are also terminated.\n\nWhen stopped, the application is still loaded.\n\nTo stop a distributed application, [`stop/1`](`stop/1`) must be called on all\nnodes where it can execute (that is, on all nodes where it has been started).\nThe call to [`stop/1`](`stop/1`) on the node where the application currently\nexecutes stops its execution. The application is not moved between nodes, as\n[`stop/1`](`stop/1`) is called on the node where the application currently\nexecutes before [`stop/1`](`stop/1`) is called on the other nodes.","ref":"application.html#stop/1"},{"type":"function","title":"application.takeover/2","doc":"Takes over the distributed application `Application`, which executes at another\nnode `Node`.\n\nAt the current node, the application is restarted by calling\n[`Module:start({takeover,Node},StartArgs)`](`c:start/2`). `Module` and\n`StartArgs` are retrieved from the loaded application specification. The\napplication at the other node is not stopped until the startup is completed,\nthat is, when [`Module:start/2`](`c:start/2`) and any calls to\n[`Module:start_phase/3`](`c:start_phase/3`) have returned.\n\nThus, two instances of the application run simultaneously during the takeover,\nso that data can be transferred from the old to the new instance. If this is not\nan acceptable behavior, parts of the old instance can be shut down when the new\ninstance is started. However, the application cannot be stopped entirely, at\nleast the top supervisor must remain alive.\n\nFor a description of `Type`, see [`start/1,2`](`start/1`).","ref":"application.html#takeover/2"},{"type":"type","title":"application.tuple_of/1","doc":"A tuple where the elements are of type `T`.","ref":"application.html#t:tuple_of/1"},{"type":"function","title":"application.unload/1","doc":"Unloads the application specification for `Application` from the application\ncontroller. It also unloads the application specifications for any included\napplications. Notice that the function does not purge the Erlang object code.","ref":"application.html#unload/1"},{"type":"function","title":"application.unset_env/2","doc":"Equivalent to  unset_env(Application, Par, []) .","ref":"application.html#unset_env/2"},{"type":"function","title":"application.unset_env/3","doc":"Removes the configuration parameter `Par` and its value for `Application`.\n\n[`unset_env/3`](`unset_env/3`) uses the standard `gen_server` time-out value\n(5000 ms). Option `timeout` can be specified if another time-out value is\nuseful, for example, in situations where the application controller is heavily\nloaded.\n\n[`unset_env/3`](`unset_env/3`) also allows the persistent option to be passed\n(see `set_env/4`).\n\n> #### Warning {: .warning }\n>\n> Use this function only if you know what you are doing, that is, on your own\n> applications. It is very application-dependent and configuration\n> parameter-dependent when and how often the value is read by the application.\n> Careless use of this function can put the application in a weird,\n> inconsistent, and malfunctioning state.","ref":"application.html#unset_env/3"},{"type":"function","title":"application.which_applications/0","doc":"Equivalent to  which_applications(5000) .","ref":"application.html#which_applications/0"},{"type":"function","title":"application.which_applications/1","doc":"Returns a list with information about the applications that are currently\nrunning.\n\n`Application` is the application name. `Description` and `Vsn` are the\nvalues of their `description` and `vsn` application specification keys,\nrespectively.\n\nA `Timeout` argument can be specified in situations where the application\ncontroller is heavily loaded.","ref":"application.html#which_applications/1"},{"type":"module","title":"code","doc":"Interface to the Erlang code server process.\n\nThis module contains the interface to the Erlang _code server_, which deals with\nthe loading of compiled code into a running Erlang runtime system.\n\nThe runtime system can be started in _interactive_ or _embedded_ mode. Which one\nis decided by the command-line flag `-mode`:\n\n```bash\n% erl -mode embedded\n```\n\nThe modes are as follows:\n\n- In _interactive_ mode, which is default, only the modules needed by\n  the runtime system are loaded during system startup. Other code is\n  dynamically loaded when first referenced. When a call to a function\n  in a certain module is made, and that module is not loaded, the code\n  server searches for and tries to load that module.\n\n- In _embedded_ mode, modules are not auto-loaded. Trying to use a\n  module that has not been loaded results in an error. This mode is\n  recommended when the boot script loads all modules, as it is\n  typically done in OTP releases. (Code can still be loaded later by\n  explicitly ordering the code server to do so).\n\nTo prevent accidentally reloading of modules affecting the Erlang runtime\nsystem, directories `kernel`, `stdlib`, and `compiler` are considered _sticky_.\nThis means that the system issues a warning and rejects the request if a user\ntries to reload a module residing in any of them. The feature can be disabled by\nusing command-line flag `-nostick`.","ref":"code.html"},{"type":"module","title":"Code Path - code","doc":"In interactive mode, the code server maintains a _code path_,\nconsisting of a list of directories, which it searches sequentially\nwhen trying to load a module.\n\nInitially, the code path consists of the current working directory and all\nErlang object code directories under library directory `$OTPROOT/lib`, where\n`$OTPROOT` is the installation directory of Erlang/OTP, `code:root_dir()`.\nDirectories can be named `Name[-Vsn]` and the code server, by default, chooses\nthe directory with the highest version number among those having the same\n`Name`. Suffix `-Vsn` is optional. If an `ebin` directory exists under\n`Name[-Vsn]`, this directory is added to the code path.\n\nEnvironment variable `ERL_LIBS` (defined in the operating system) can be used to\ndefine more library directories to be handled in the same way as the standard\nOTP library directory described above, except that directories without an `ebin`\ndirectory are ignored.\n\nAll application directories found in the additional directories appear before\nthe standard OTP applications, except for the Kernel and STDLIB applications,\nwhich are placed before any additional applications. In other words, modules\nfound in any of the additional library directories override modules with the\nsame name in OTP, except for modules in Kernel and STDLIB.\n\nEnvironment variable `ERL_LIBS` (if defined) is to contain a colon-separated\n(for Unix-like systems) or semicolon-separated (for Windows) list of additional\nlibraries.\n\n_Example:_\n\nOn a Unix-like system, `ERL_LIBS` can be set to the following:\n\n```text\n/usr/local/jungerl:/home/some_user/my_erlang_lib\n```\n\nThe code paths specified by `$OTPROOT`, `ERL_LIBS`, and boot scripts have their\nlistings cached by default (except for `\".\"`) The code server will\nlookup the contents in their directories once and avoid future file system\ntraversals. Therefore, modules added to such directories after the Erlang VM\nboots will not be picked up. This behaviour can be disabled by setting\n`-cache_boot_paths false` or by calling `code:set_path(code:get_path())`.\n\n> #### Change {: .info }\n>\n> The support for caching directories in the code path was added\n> in Erlang/OTP 26.\n\nDirectories given by the command line options `-pa` and `-pz` are not\ncached by default. Many of the functions that manipulate the code path\naccept the `cache` atom as an optional argument to enable caching\nselectively.","ref":"code.html#module-code-path"},{"type":"module","title":"Loading of Code From Archive Files - code","doc":"> #### Change {: .info }\n>\n> The existing experimental support for archive files will be changed\n> in a future release. As of Erlang/OTP 27, the function `code:lib_dir/2`,\n> the `-code_path_choice` flag, and using `m:erl_prim_loader` for\n> reading files from an archive are deprecated.\n>\n> `escript` scripts that use archive files should use\n> `escript:extract/2` to read data files from its archive instead of using\n> `code:lib_dir/2` and `m:erl_prim_loader`.\n\nThe Erlang archives are `ZIP` files with extension `.ez`. Erlang archives can\nalso be [enclosed in `escript`](`m:escript`) files whose file extension is arbitrary.\n\nErlang archive files can contain entire Erlang applications or parts of\napplications. The structure in an archive file is the same as the directory\nstructure for an application. If you, for example, create an archive of\n`mnesia-4.4.7`, the archive file must be named `mnesia-4.4.7.ez` and it must\ncontain a top directory named `mnesia-4.4.7`. If the version part of the name is\nomitted, it must also be omitted in the archive. That is, a `mnesia.ez` archive\nmust contain a `mnesia` top directory.\n\nAn archive file for an application can, for example, be created like this:\n\n```erlang\nzip:create(\"mnesia-4.4.7.ez\",\n\t[\"mnesia-4.4.7\"],\n\t[{cwd, code:lib_dir()},\n\t {compress, all},\n\t {uncompress,[\".beam\",\".app\"]}]).\n```\n\nAny file in the archive can be compressed, but to speed up the access of\nfrequently read files, it can be a good idea to store `beam` and `app` files\nuncompressed in the archive.\n\nNormally the top directory of an application is located in library directory\n`$OTPROOT/lib` or in a directory referred to by environment variable `ERL_LIBS`.\nAt startup, when the initial code path is computed, the code server also looks\nfor archive files in these directories and possibly adds `ebin` directories in\narchives to the code path. The code path then contains paths to directories that\nlook like `$OTPROOT/lib/mnesia.ez/mnesia/ebin` or\n`$OTPROOT/lib/mnesia-4.4.7.ez/mnesia-4.4.7/ebin`.\n\nThe code server uses module `erl_prim_loader` in ERTS (possibly through\n`erl_boot_server`) to read code files from archives. However, the functions in\n`erl_prim_loader` can also be used by other applications to read files from\narchives. For example, the call\n`erl_prim_loader:list_dir( \"/otp/root/lib/mnesia-4.4.7.ez/mnesia-4.4.7/examples/bench)\"`\nwould list the contents of a directory inside an archive. See\n`m:erl_prim_loader`.\n\nAn application archive file and a regular application directory can coexist.\nThis can be useful when it is needed to have parts of the application as regular\nfiles. A typical case is the `priv` directory, which must reside as a regular\ndirectory to link in drivers dynamically and start port programs. For other\napplications that do not need this, directory `priv` can reside in the archive\nand the files under the directory `priv` can be read through `erl_prim_loader`.\n\nWhen a directory is added to the code path and when the entire code path is\n(re)set, the code server decides which subdirectories in an application that are\nto be read from the archive and which that are to be read as regular files. If\ndirectories are added or removed afterwards, the file access can fail if the\ncode path is not updated (possibly to the same path as before, to trigger the\ndirectory resolution update).\n\nFor each directory on the second level in the application archive (`ebin`,\n`priv`, `src`, and so on), the code server first chooses the regular directory\nif it exists and second from the archive. Function `code:lib_dir/2` returns the\npath to the subdirectory. For example, `code:lib_dir(megaco, ebin)` can return\n`/otp/root/lib/megaco-3.9.1.1.ez/megaco-3.9.1.1/ebin` while\n`code:lib_dir(megaco, priv)` can return `/otp/root/lib/megaco-3.9.1.1/priv`.\n\nWhen an `escript` file contains an archive, there are no restrictions on the\nname of the `escript` and no restrictions on how many applications that can be\nstored in the embedded archive. Single Beam files can also reside on the top\nlevel in the archive. At startup, the top directory in the embedded archive and\nall (second level) `ebin` directories in the embedded archive are added to the\ncode path. See [`escript`](`e:erts:escript_cmd.md`).\n\nA future-proof way for `escript` scripts to read data files from the archive is\nto use the `escript:extract/2` function.\n\nWhen the choice of directories in the code path is `strict` (which is\nthe default as of Erlang/OTP 27), the directory that ends up in the\ncode path is exactly the stated one. This means that if, for example,\nthe directory `$OTPROOT/lib/mnesia-4.4.7/ebin` is explicitly added to\nthe code path, the code server does not load files from\n`$OTPROOT/lib/mnesia-4.4.7.ez/mnesia-4.4.7/ebin`.\n\nThis behavior can be controlled through command-line flag\n`-code_path_choice Choice`. If the flag is set to `relaxed`, the code server\ninstead chooses a suitable directory depending on the actual file structure. If\na regular application `ebin` directory exists, it is chosen. Otherwise, the\ndirectory `ebin` in the archive is chosen if it exists. If neither of them\nexists, the original directory is chosen.\n\nCommand-line flag `-code_path_choice Choice` also affects how module `init`\ninterprets the `boot script`. The interpretation of the explicit code paths in\nthe `boot script` can be `strict` or `relaxed`. It is particularly useful to set\nthe flag to `relaxed` when elaborating with code loading from archives without\nediting the `boot script`. The default has changed to `strict` in OTP 27 and the\noption is scheduled for removal in OTP 28. See module `m:init` in the\nErts application.","ref":"code.html#module-loading-of-code-from-archive-files"},{"type":"module","title":"Current and Old Code - code","doc":"The code for a module can exist in two variants in a system: _current code_ and\n_old code_. When a module is loaded into the system for the first time, the\nmodule code becomes *current* and the global _export table_ is updated with\nreferences to all functions exported from the module.\n\nWhen a new instance of the module is loaded, the code of the previous\ninstance becomes *old*, and all export entries referring to the\nprevious instance are removed. After that, the new instance is loaded\nas for the first time, and becomes current.\n\nBoth old and current code for a module are valid, and can even be executed\nconcurrently. The difference is that exported functions in old code are\nunavailable. Hence, a global call cannot be made to an exported function in old\ncode, but old code can still be executed because of processes lingering in it.\n\nIf a third instance of the module is loaded, the code server removes (purges)\nthe old code and any processes lingering in it are terminated. Then the third\ninstance becomes current and the previously current code becomes old.\n\nFor more information about old and current code, and how to make a process\nswitch from old to current code, see section Compilation and Code Loading in the\n[Erlang Reference Manual](`e:system:code_loading.md`).","ref":"code.html#module-current-and-old-code"},{"type":"module","title":"Native Coverage Support - code","doc":"In runtime systems that use the JIT, native coverage is a light-weight\nway to find out which functions or lines that have been executed, or\nhow many times each function or line has been executed.\n\n> #### Change {: .info }\n>\n> The support for native coverage was added in Erlang/OTP 27.\n\nNative coverage works by instrumenting code at load-time. When a\nmodule has been instrumented for native coverage collection it is not\npossible to later disable the coverage collection, except by reloading\nthe module. However, the overhead for keeping coverage collection\nrunning is often neligible, especially for [coverage\nmode](`t:coverage_mode/0`) `function` that only keeps track of which\nfunctions that have been executed.\n\nThe `m:cover` tool in the Tools application will automatically use the\nnative coverage support if the runtime system supports it.\n\nIt is only necessary to use the functionality described next if\n`m:cover` is not sufficient, for example:\n\n* If one wants to collect coverage information for the code that runs\n  when the runtime system is starting (module `m:init` and so on).\n  `m:cover` can only be used when the Erlang system has started, and\n  it will reload every module that is to be analyzed.\n\n* If it is necessary to collect coverage information with the absolute\n  minimum disturbance of the test system. `m:cover` always counts how\n  many times each line is executed (coverage mode `line_counters`),\n  but by using native coverage one can use a less expensive coverage\n  mode such as `function`, which has almost negligible overhead.","ref":"code.html#module-native-coverage-support"},{"type":"module","title":"Short summary of using native coverage - code","doc":"If the `line` or `line_counters` coverage mode is to be used,\nthe code to be tested must be compiled with option\n[`line_coverage`](`e:compiler:compile#line_coverage`).\n\nUse [set_coverage_mode(Mode)](`set_coverage_mode/1`) to set a\n[coverage mode](`t:coverage_mode/0`) for all code subsequently\nloaded, or set it with option [\\+JPcover](`e:erts:erl_cmd.md#%2BJPcover`)\nfor `erl`.\n\nOptionally reset coverage information for all\nmodules that are to be tested by calling\n[reset_coverage(Module)](`reset_coverage/1`).\n\nRun the code whose coverage information is to be collected.\n\nRead out the counters for all interesting modules by calling\n[get_coverage(Level, Module)](`get_coverage/2`), where `Level`\nis either `function` or `line`.","ref":"code.html#module-short-summary-of-using-native-coverage"},{"type":"module","title":"The other native coverage BIFs - code","doc":"The following BIFs are sometimes useful, for example to fail gracefully\nif the runtime system does not support native coverage:\n\n* [coverage_support()](`coverage_support/0`) - check whether\n  the runtime system supports native coverage\n\n* [get_coverage_mode()](`get_coverage_mode/0`) - get the current\n  coverage mode\n\n* [get_coverage_mode(Module)](`get_coverage_mode/1`) - get the coverage\n  mode for module `Module`","ref":"code.html#module-the-other-native-coverage-bifs"},{"type":"module","title":"Argument Types and Invalid Arguments - code","doc":"Module and application names are atoms, while file and directory names are\nstrings. For backward compatibility reasons, some functions accept both strings\nand atoms, but a future release will probably only allow the arguments that are\ndocumented.\n\nFunctions in this module generally fail with an exception if they are passed an\nincorrect type (for example, an integer or a tuple where an atom is expected).\nAn error tuple is returned if the argument type is correct, but there are some\nother errors (for example, a non-existing directory is specified to\n[`set_path/1`](`set_path/1`)).\n\n[](){: #error_reasons }","ref":"code.html#module-argument-types-and-invalid-arguments"},{"type":"module","title":"Error Reasons for Code-Loading Functions - code","doc":"Functions that load code (such as [`load_file/1`](`load_file/1`)) will return\n`{error,Reason}` if the load operation fails. Here follows a description of the\ncommon reasons.\n\n- **`badfile`** - The object code has an incorrect format or the module name in\n  the object code is not the expected module name.\n\n- **`nofile`** - No file with object code was found.\n\n- **`not_purged`** - The object code could not be loaded because an old version\n  of the code already existed.\n\n- **`on_load_failure`** - The module has an\n  [\\-on_load function](`e:system:code_loading.md#on_load`) that failed when it\n  was called.\n\n- **`sticky_directory`** - The object code resides in a sticky directory.","ref":"code.html#module-error-reasons-for-code-loading-functions"},{"type":"function","title":"code.add_path/1","doc":"Equivalent to  add_pathz(Dir, nocache) .","ref":"code.html#add_path/1"},{"type":"function","title":"code.add_path/2","doc":"Equivalent to  add_pathz(Dir, Cache) .","ref":"code.html#add_path/2"},{"type":"type","title":"code.add_path_ret/0","doc":"","ref":"code.html#t:add_path_ret/0"},{"type":"function","title":"code.add_patha/1","doc":"Equivalent to  add_patha(Dir, nocache) .","ref":"code.html#add_patha/1"},{"type":"function","title":"code.add_patha/2","doc":"Adds `Dir` to the beginning of the code path.\n\nIf `Dir` exists, it is removed from the old position in the code path.\n\nArgument `Cache` controls whether the content of the directory\nshould be cached on first traversal. If `Cache` is `cache` the directory\ncontents will be cached; if `Cache` is `nocache` it will not be cached.\n\nReturns `true` if successful, or `{error, bad_directory}` if `Dir` is\nnot the name of a directory.","ref":"code.html#add_patha/2"},{"type":"function","title":"code.add_paths/1","doc":"Equivalent to  add_pathsz(Dirs, nocache) .","ref":"code.html#add_paths/1"},{"type":"function","title":"code.add_paths/2","doc":"Equivalent to  add_pathsz(Dirs, Cache) .","ref":"code.html#add_paths/2"},{"type":"function","title":"code.add_pathsa/1","doc":"Equivalent to  add_pathsa(Dirs, nocache) .","ref":"code.html#add_pathsa/1"},{"type":"function","title":"code.add_pathsa/2","doc":"Traverses `Dirs` and adds each `Dir` to the beginning of the code path.\n\nThis means that the order of `Dirs` is reversed in the resulting code\npath. For example, if `Dirs` is `[Dir1,Dir2]`, the resulting path will\nbe `[Dir2,Dir1|OldCodePath]`.\n\nIf a `Dir` already exists in the code path, it is removed from the old position.\n\nArgument `Cache` controls whether the content of the directory\nshould be cached on first traversal. If `Cache` is `cache` the directory\ncontents will be cached; if `Cache` is `nocache` it will not be cached.\n\nAlways returns `ok`, regardless of the validity of each individual `Dir`.","ref":"code.html#add_pathsa/2"},{"type":"function","title":"code.add_pathsz/1","doc":"Equivalent to  add_pathsz(Dirs, nocache) .","ref":"code.html#add_pathsz/1"},{"type":"function","title":"code.add_pathsz/2","doc":"Adds the directories in `Dirs` to the end of the code path.\n\nDirectories that are already present in the path will not be added.\n\nArgument `Cache` controls whether the content of the directory\nshould be cached on first traversal. If `Cache` is `cache` the directory\ncontents will be cached; if `Cache` is `nocache` it will not be cached.\n\nAlways returns `ok`, regardless of the validity of each individual `Dir`.","ref":"code.html#add_pathsz/2"},{"type":"function","title":"code.add_pathz/1","doc":"Equivalent to  add_pathz(Dir, nocache) .","ref":"code.html#add_pathz/1"},{"type":"function","title":"code.add_pathz/2","doc":"Adds `Dir` as the directory last in the code path.\n\nIf `Dir` already exists in the path, it is not added.\n\nArgument `Cache` controls whether the content of the directory\nshould be cached on first traversal. If `Cache` is `cache` the directory\ncontents will be cached; if `Cache` is `nocache` it will not be cached.\n\nReturns `true` if successful, or `{error, bad_directory}` if `Dir` is\nnot the name of a directory.","ref":"code.html#add_pathz/2"},{"type":"function","title":"code.all_available/0","doc":"Returns a list of tuples `{Module, Filename, Loaded}` for all available modules.\n\nA module is considered to be available if it either is loaded or would be loaded\nif called. `Filename` is normally the absolute filename, as described for\n`is_loaded/1`.","ref":"code.html#all_available/0"},{"type":"function","title":"code.all_loaded/0","doc":"Returns a list of tuples `{Module, Loaded}` for all loaded modules.\n\n`Loaded` is normally the absolute filename, as described for `is_loaded/1`.","ref":"code.html#all_loaded/0"},{"type":"function","title":"code.atomic_load/1","doc":"Tries to load all of the modules in the list `Modules` atomically.\n\nThat means that either all modules are loaded at the same time, or\nnone of the modules are loaded if there is a problem with any of the\nmodules.\n\nLoading can fail for one the following reasons:\n\n- **`badfile`** - The object code has an incorrect format or the module name in\n  the object code is not the expected module name.\n\n- **`nofile`** - No file with object code exists.\n\n- **`on_load_not_allowed`** - A module contains an\n  [\\-on_load function](`e:system:code_loading.md#on_load`).\n\n- **`duplicated`** - A module is included more than once in `Modules`.\n\n- **`not_purged`** - The object code cannot be loaded because an old version of\n  the code already exists.\n\n- **`sticky_directory`** - The object code resides in a sticky directory.\n\n- **`pending_on_load`** - A previously loaded module contains an `-on_load`\n  function that never finished.\n\nIf it is important to minimize the time that an application is inactive while\nchanging code, use `prepare_loading/1` and `finish_loading/1` instead of\n[`atomic_load/1`](`atomic_load/1`). Here is an example:\n\n```erlang\n{ok,Prepared} = code:prepare_loading(Modules),\n%% Put the application into an inactive state or do any\n%% other preparation needed before changing the code.\nok = code:finish_loading(Prepared),\n%% Resume the application.\n```","ref":"code.html#atomic_load/1"},{"type":"type","title":"code.cache/0","doc":"","ref":"code.html#t:cache/0"},{"type":"function","title":"code.clash/0","doc":"Searches all directories in the code path for module names with identical names\nand writes a report to `stdout`.","ref":"code.html#clash/0"},{"type":"function","title":"code.clear_cache/0","doc":"Clears the code path cache.\n\nIf a directory is cached, its cache is cleared once and then it will\nbe recalculated and cached once more in a future traversal.\n\nTo clear the cache for a single path, either re-add it to the code\npath (with [`add_path/2`](`add_path/2`)) or replace it (with\n[`replace_path/3`](`replace_path/3`)). To disable all caching, reset\nthe code path with `code:set_path(code:get_path())`.\n\nAlways returns `ok`.","ref":"code.html#clear_cache/0"},{"type":"function","title":"code.compiler_dir/0","doc":"Returns the compiler library directory.\n\nEquivalent to [`code:lib_dir(compiler)`](`code:lib_dir/1`).","ref":"code.html#compiler_dir/0"},{"type":"type","title":"code.coverage_mode/0","doc":"","ref":"code.html#t:coverage_mode/0"},{"type":"function","title":"code.coverage_support/0","doc":"Returns `true` if the system supports coverage and `false` otherwise.\n\n_See also:_ [Native Coverage Support](#module-native-coverage-support)","ref":"code.html#coverage_support/0"},{"type":"nominal","title":"code.debug_frame/0","doc":"","ref":"code.html#t:debug_frame/0"},{"type":"nominal","title":"code.debug_info/0","doc":"","ref":"code.html#t:debug_info/0"},{"type":"nominal","title":"code.debug_line/0","doc":"","ref":"code.html#t:debug_line/0"},{"type":"nominal","title":"code.debug_name/0","doc":"","ref":"code.html#t:debug_name/0"},{"type":"nominal","title":"code.debug_source/0","doc":"","ref":"code.html#t:debug_source/0"},{"type":"nominal","title":"code.debug_value/0","doc":"","ref":"code.html#t:debug_value/0"},{"type":"function","title":"code.del_path/1","doc":"Deletes a directory from the code path.\n\nThe argument can be an atom `Name`, in which case the directory with\nthe name `.../Name[-Vsn][/ebin]` is deleted from the code path. Also,\nthe complete directory name `Dir` can be specified as argument.\n\nReturns:\n\n- **`true`** - If successful\n\n- **`false`** - If the directory is not found\n\n- **`{error, bad_name}`** - If the argument is invalid","ref":"code.html#del_path/1"},{"type":"function","title":"code.del_paths/1","doc":"Deletes directories from the code path.\n\nThe argument is a list of either atoms or complete directory names. If\n`Name` is an atom, the directory with the name `.../Name[-Vsn][/ebin]` is\ndeleted from the code path.\n\nAlways returns `ok`, regardless of the validity of each individual\n`NamesOrDirs`.","ref":"code.html#del_paths/1"},{"type":"function","title":"code.delete/1","doc":"Removes the current code for `Module`, that is, the current code for `Module` is\nmade old.\n\nThis means that processes can continue to execute the code in the\nmodule, but no external function calls can be made to it.\n\nReturns `true` if successful, or `false` if there is old code for `Module` that\nmust be purged first, or if `Module` is not a (loaded) module.","ref":"code.html#delete/1"},{"type":"function","title":"code.ensure_loaded/1","doc":"Tries to load a module in the same way as `load_file/1`, unless the module is\nalready loaded.\n\nIf called concurrently, this function ensures that only one process\nattempts to load said module at a given time.\n\nIn embedded mode, it does not load a module that is not already loaded, but\nreturns `{error, embedded}` instead. See\n[Error Reasons for Code-Loading Functions](`m:code#error_reasons`) for a\ndescription of other possible error reasons.","ref":"code.html#ensure_loaded/1"},{"type":"function","title":"code.ensure_modules_loaded/1","doc":"Tries to load any modules not already loaded in the list `Modules` in the same\nway as `load_file/1`.\n\nUnlike `ensure_loaded/1`, modules are loaded even in `embedded` mode.\n\nReturns `ok` if successful, or `{error,[{Module,Reason}]}` if loading of some\nmodules fails. See\n[Error Reasons for Code-Loading Functions](`m:code#error_reasons`) for a\ndescription of other possible error reasons.","ref":"code.html#ensure_modules_loaded/1"},{"type":"function","title":"code.finish_loading/1","doc":"Tries to load code for all modules that have been previously prepared by\n`prepare_loading/1`.\n\nThe loading occurs atomically, meaning that either all modules are\nloaded at the same time, or none of the modules are loaded.\n\nThis function can fail with one of the following error reasons:\n\n- **`not_purged`** - The object code cannot be loaded because an old version of\n  the code already exists.\n\n- **`sticky_directory`** - The object code resides in a sticky directory.\n\n- **`pending_on_load`** - A previously loaded module contains an `-on_load`\n  function that never finished.","ref":"code.html#finish_loading/1"},{"type":"function","title":"code.get_coverage/2","doc":"Return either `function` or `line` coverage data for module `Module`.\n\nIf Level is `function`, returns function coverage for the given module\naccording to its [coverage mode](`t:coverage_mode/0`):\n\n- **`function`** - For each function in module Module, a boolean indicating\n  whether that function has been executed at least once is returned.\n\n- **`function_counters`** - For each function in module Module, an integer\n  giving the number of times that line has been executed is returned.\n\n- **`line`** - For each function in module Module, a boolean indicating whether\n  that function has been executed at least once is returned.\n\n- **`line_counters`** - For each function in module Module, a boolean indicating\n  whether that function has been executed at least once is returned (note that\n  in this mode, counters for the number of times each function has been executed\n  **cannot** be retrieved).\n\nIf Level is `line`, returns line coverage for the given module according to its\ncoverage mode:\n\n- **`line`** - For each executable line in the module, a boolean indicating\n  whether that line has been executed at least once is returned.\n\n- **`line_counters`** - For each executable line in the module, an integer\n  giving the number of times that line was executed is returned.\n\nLevel `cover_id_line` is used by the `m:cover` tool.\n\nFailures:\n\n- **`badarg`** - If `Level` is not `function` or `line`.\n\n- **`badarg`** - If `Module` is not an atom.\n\n- **`badarg`** - If `Module` does not refer to a loaded module.\n\n- **`badarg`** - If `Module` was not loaded in another coverage mode than\n  `none`.\n\n- **`badarg`** - If Level is `line` and `Module` has not been loaded with either\n  `line` or `line_counters` enabled.\n\n- **`badarg`** - If the runtime system does not support coverage.\n\n_See also:_ [Native Coverage Support](#module-native-coverage-support)","ref":"code.html#get_coverage/2"},{"type":"function","title":"code.get_coverage_mode/0","doc":"Returns the coverage mode as set by option\n[\\+JPcover](`e:erts:erl_cmd.md#%2BJPcover`) for `erl` or `set_coverage_mode/1`.\n\nFailure:\n\n- **`badarg`** - If the runtime system does not support coverage.\n\n_See also:_ [Native Coverage Support](#module-native-coverage-support)","ref":"code.html#get_coverage_mode/0"},{"type":"function","title":"code.get_coverage_mode/1","doc":"Get coverage mode for the given module.\n\nFailures:\n\n- **`badarg`** - If `Module` is not an atom.\n\n- **`badarg`** - If `Module` does not refer to a loaded module.\n\n- **`badarg`** - If the runtime system does not support coverage.\n\n_See also:_ [Native Coverage Support](#module-native-coverage-support)","ref":"code.html#get_coverage_mode/1"},{"type":"function","title":"code.get_debug_info/1","doc":"","ref":"code.html#get_debug_info/1"},{"type":"function","title":"code.get_doc/1","doc":"Returns [EEP 48](https://www.erlang.org/eeps/eep-0048.html) style\ndocumentation for `Module` if available.\n\nIf `Module` is not found in the code path, this function returns\n`{error,non_existing}`.\n\nIf no documentation can be found this function attempts to generate\ndocumentation from the debug information in the module. If no debug\ninformation is available, this function returns `{error,missing}`.\n\nFor more information about the documentation chunk see\n[Documentation Storage and Format](eep48_chapter.md) in\nKernel's User's Guide.","ref":"code.html#get_doc/1"},{"type":"function","title":"code.get_mode/0","doc":"Returns an atom describing the mode of the code server: `interactive` or\n`embedded`.\n\nThis information is useful when an external entity (for example, an IDE)\nprovides additional code for a running node. If the code server is in\ninteractive mode, it only has to add the path to the code. If the code server is\nin embedded mode, the code must be loaded with `load_binary/3`.","ref":"code.html#get_mode/0"},{"type":"function","title":"code.get_object_code/1","doc":"Returns the object code for module `Module` if found in the code path.\n\nReturns `{Module, Binary, Filename}` if successful, otherwise\n`error`. `Binary` is a binary data object, which contains the object\ncode for the module. This is useful if code is to be loaded on a\nremote node in a distributed system. For example, loading module\n`Module` on a node `Node` is done as follows:\n\n```erlang\n...\n{_Module, Binary, Filename} = code:get_object_code(Module),\nerpc:call(Node, code, load_binary, [Module, Filename, Binary]),\n...\n```","ref":"code.html#get_object_code/1"},{"type":"function","title":"code.get_path/0","doc":"Returns the code path.","ref":"code.html#get_path/0"},{"type":"function","title":"code.is_loaded/1","doc":"Checks whether `Module` is loaded.\n\nIf it is, `{file, Loaded}` is returned, otherwise `false`.\n\nNormally, `Loaded` is the absolute filename `Filename` from which the code is\nobtained. If the module is preloaded (see [`script(4)`](`e:sasl:script.md`)),\n`Loaded =:= preloaded`. If the module is Cover-compiled (see `m:cover`),\n`Loaded =:= cover_compiled`.","ref":"code.html#is_loaded/1"},{"type":"function","title":"code.is_sticky/1","doc":"Returns `true` if `Module` is the name of a module that has been loaded from a\nsticky directory (in other words: an attempt to reload the module will fail), or\n`false` if `Module` is not a loaded module or is not sticky.","ref":"code.html#is_sticky/1"},{"type":"function","title":"code.lib_dir/0","doc":"Returns the library directory, `$OTPROOT/lib`, where `$OTPROOT` is the root\ndirectory of Erlang/OTP.\n\n_Example:_\n\n```erlang\n1> code:lib_dir().\n\"/usr/local/otp/lib\"\n```","ref":"code.html#lib_dir/0"},{"type":"function","title":"code.lib_dir/1","doc":"Returns the path for the *library directory*, the top directory, for an\napplication `Name` located under `$OTPROOT/lib` or in a directory referred to\nwith environment variable `ERL_LIBS`.\n\nIf a regular directory called `Name` or `Name-Vsn` exists in the code path with\nan `ebin` subdirectory, the path to this directory is returned (not the `ebin`\ndirectory).\n\nIf the directory refers to a directory in an archive, the archive name is\nstripped away before the path is returned. For example, if directory\n`/usr/local/otp/lib/mnesia-4.2.2.ez/mnesia-4.2.2/ebin` is in the path,\n`/usr/local/otp/lib/mnesia-4.2.2/ebin` is returned. This means that the library\ndirectory for an application is the same, regardless if the application resides\nin an archive or not.\n\n> #### Warning {: .info }\n>\n> Archives are experimental. In a future release, they can be removed or\n> their behavior can change.\n\n_Example:_\n\n```erlang\n> code:lib_dir(mnesia).\n\"/usr/local/otp/lib/mnesia-4.23\"\n```\n\nReturns `{error, bad_name}` if `Name` is not the name of an application under\n`$OTPROOT/lib` or on a directory referred to through environment variable\n`ERL_LIBS`. Fails with an exception if `Name` has the wrong type.\n\n> #### Warning {: .warning }\n>\n> For backward compatibility, `Name` is also allowed to be a string. That will\n> probably change in a future release.","ref":"code.html#lib_dir/1"},{"type":"function","title":"code.lib_dir/2","doc":"Returns the path to a subdirectory directly under the top directory of an\napplication.\n\n> #### Change {: .info }\n>\n> This function is part of the archive support, which is an experimental\n> feature that will be changed or removed in a future release.\n\nNormally the subdirectories reside under the top directory for the\napplication, but when applications at least partly reside in an archive, the\nsituation is different. Some of the subdirectories can reside as regular\ndirectories while others reside in an archive file. It is not checked whether\nthis directory exists.\n\nInstead of using this function, use [`code:lib_dir/1`](`code:lib_dir/1`)\nand `filename:join/2`.\n\n_Example:_\n\n```erlang\n1> filename:join(code:lib_dir(megaco), \"priv\").\n\"/usr/local/otp/lib/megaco-3.9.1.1/priv\"\n```\n\nFails with an exception if `Name` or `SubDir` has the wrong type.","ref":"code.html#lib_dir/2"},{"type":"function","title":"code.load_abs/1","doc":"Equivalent to [`load_file(Module)`](`load_file/1`), except that `Filename` is\nan absolute or relative filename.\n\nThe code path is not searched. It returns a value in the same way as\n`load_file/1`. Notice that `Filename` must not contain the extension\n(for example, `.beam`) because [`load_abs/1`](`load_abs/1`) adds the\ncorrect extension.","ref":"code.html#load_abs/1"},{"type":"function","title":"code.load_binary/3","doc":"Loads object code from a binary.\n\nThis function can be used to load object code on remote Erlang nodes. Argument\n`Binary` must contain object code for `Module`. `Filename` is only used by the\ncode server to keep a record of from which file the object code for `Module`\noriginates. Thus, `Filename` is not opened and read by the code server.\n\nReturns `{module, Module}` if successful, or `{error, Reason}` if loading fails.\nSee [Error Reasons for Code-Loading Functions](`m:code#error_reasons`) for a\ndescription of the possible error reasons.","ref":"code.html#load_binary/3"},{"type":"type","title":"code.load_error_rsn/0","doc":"","ref":"code.html#t:load_error_rsn/0"},{"type":"function","title":"code.load_file/1","doc":"Tries to load the Erlang module `Module` using the code path.\n\nIt looks for the object code file with an extension corresponding to\nthe Erlang machine used, for example, `Module.beam`. The loading fails\nif the module name found in the object code differs from the name\n`Module`. Use `load_binary/3` to load object code with a module name\nthat is different from the file name.\n\nReturns `{module, Module}` if successful, or `{error, Reason}` if loading fails.\nSee [Error Reasons for Code-Loading Functions](`m:code#error_reasons`) for a\ndescription of the possible error reasons.","ref":"code.html#load_file/1"},{"type":"type","title":"code.load_ret/0","doc":"","ref":"code.html#t:load_ret/0"},{"type":"type","title":"code.loaded_filename/0","doc":"","ref":"code.html#t:loaded_filename/0"},{"type":"type","title":"code.loaded_ret_atoms/0","doc":"","ref":"code.html#t:loaded_ret_atoms/0"},{"type":"function","title":"code.modified_modules/0","doc":"Returns the list of all currently loaded modules for which `module_status/1`\nreturns `modified`.\n\nSee also `all_loaded/0`.","ref":"code.html#modified_modules/0"},{"type":"type","title":"code.module_status/0","doc":"","ref":"code.html#t:module_status/0"},{"type":"function","title":"code.module_status/0","doc":"See `module_status/1` and `all_loaded/0` for details.","ref":"code.html#module_status/0"},{"type":"function","title":"code.module_status/1","doc":"Returns the status of `Module` in relation to object file on disk.\n\nThe status of a module can be one of:\n\n- **`not_loaded`** - If `Module` is not currently loaded.\n\n- **`loaded`** - If `Module` is loaded, and the object file exists and contains\n  the same code.\n\n- **`removed`** - If `Module` is loaded, but no corresponding object file can be\n  found in the code path.\n\n- **`modified`** - If `Module` is loaded, but the object file contains code with\n  a different MD5 checksum.\n\nPreloaded modules are always reported as `loaded`, without inspecting the\ncontents on disk. Cover-compiled modules will always be reported as `modified`\nif an object file exists, or as `removed` otherwise. Modules whose load path is\nan empty string (which is the convention for auto-generated code) will only be\nreported as `loaded` or `not_loaded`.\n\nSee also `modified_modules/0`.","ref":"code.html#module_status/1"},{"type":"function","title":"code.objfile_extension/0","doc":"Returns the object code file extension corresponding to the Erlang machine used.\n\nFor the official Erlang/OTP release, the return value is always `.beam`.","ref":"code.html#objfile_extension/0"},{"type":"function","title":"code.prepare_loading/1","doc":"Prepares to load the modules in the list `Modules`.\n\nFinish the loading by calling\n[finish_loading(Prepared)](`finish_loading/1`).\n\nThis function can fail with one of the following error reasons:\n\n- **`badfile`** - The object code has an incorrect format or the module name in\n  the object code is not the expected module name.\n\n- **`nofile`** - No file with object code exists.\n\n- **`on_load_not_allowed`** - A module contains an\n  [\\-on_load function](`e:system:code_loading.md#on_load`).\n\n- **`duplicated`** - A module is included more than once in `Modules`.","ref":"code.html#prepare_loading/1"},{"type":"opaque","title":"code.prepared_code/0","doc":"An opaque term holding prepared code.","ref":"code.html#t:prepared_code/0"},{"type":"function","title":"code.priv_dir/1","doc":"Returns the path to the `priv` directory in an application.\n\n> #### Warning {: .warning }\n>\n> For backward compatibility, `Name` is also allowed to be a string. That will\n> probably change in a future release.","ref":"code.html#priv_dir/1"},{"type":"function","title":"code.purge/1","doc":"Purges the code for `Module`, that is, removes code marked as old.\n\nIf some processes still linger in the old code, these processes are\nkilled before the code is removed.\n\n> #### Change {: .info }\n>\n> As of Erlang/OTP 20.0, a process is only considered to be lingering in the\n> code if it has direct references to the code. For more information see\n> documentation of `erlang:check_process_code/3`, which is used in order to\n> determine whether a process is lingering.\n\nReturns `true` if successful and any process is needed to be killed, otherwise\n`false`.","ref":"code.html#purge/1"},{"type":"function","title":"code.replace_path/2","doc":"Equivalent to  replace_path(Name, Dir, nocache) .","ref":"code.html#replace_path/2"},{"type":"function","title":"code.replace_path/3","doc":"Replaces an old occurrence of a directory named `.../Name[-Vsn][/ebin]` in the\ncode path, with `Dir`.\n\nIf `Name` does not exist, it adds the new directory `Dir` last in the\ncode path. The new directory must also be named\n`.../Name[-Vsn][/ebin]`. This function is to be used if a new version\nof the directory (library) is added to a running system.\n\nArgument `Cache` controls whether the content of the directory\nshould be cached on first traversal. If `Cache` is `cache` the directory\ncontents will be cached; if `Cache` is `nocache` it will not be cached.\n\nReturns:\n\n- **`true`** - If successful\n\n- **`{error, bad_name}`** - If `Name` is not found\n\n- **`{error, bad_directory}`** - If `Dir` does not exist\n\n- **`{error, {badarg, [Name, Dir]}}`** - If `Name` or `Dir` is invalid","ref":"code.html#replace_path/3"},{"type":"type","title":"code.replace_path_ret/0","doc":"","ref":"code.html#t:replace_path_ret/0"},{"type":"function","title":"code.reset_coverage/1","doc":"Resets coverage information for module `Module`.\n\nIf the [coverage mode](`t:coverage_mode/0`) is either `function` or\n`line`, all booleans for `Module` keeping track of executed functions\nor lines are set to `false`.\n\nIf the coverage mode is either `function_counters` or\n`line_counters`, all counters for `Module` are reset to zero.\n\nFailures:\n\n- **`badarg`** - If `Module` is not an atom.\n\n- **`badarg`** - If `Module` does not refer to a loaded module.\n\n- **`badarg`** - If `Module` was not loaded with coverage enabled.\n\n- **`badarg`** - If the runtime system does not support coverage.\n\n_See also:_ [Native Coverage Support](#module-native-coverage-support)","ref":"code.html#reset_coverage/1"},{"type":"function","title":"code.root_dir/0","doc":"Returns the root directory of Erlang/OTP, which is the directory where it is\ninstalled.\n\n_Example:_\n\n```erlang\n1> code:root_dir().\n\"/usr/local/otp\"\n```","ref":"code.html#root_dir/0"},{"type":"function","title":"code.set_coverage_mode/1","doc":"Sets the coverage mode for modules that are subsequently loaded, similar to\noption [\\+JPcover](`e:erts:erl_cmd.md#%2BJPcover`) for `erl`.\n\nThe coverage mode will have the following effect on code that is\nloaded following this call:\n\n- **`function`** - All modules that are loaded will be instrumented to keep\n  track of which functions are executed. Information about which functions that\n  have been executed can be retrieved by calling\n  [`get_coverage(function, Module)`](`get_coverage/2`).\n\n- **`function_counters`** - All modules that are loaded will be instrumented to\n  count how many times each function is executed. Information about how many\n  times each function has been executed can be retrieved by calling\n  [`get_coverage(function, Module)`](`get_coverage/2`).\n\n- **`line`** - When modules that have been compiled with the\n  [`line_coverage`](`m:compile#line_coverage`) option are loaded, they will be\n  instrumented to keep track of which lines have been executed. Information\n  about which lines have been executed can be retrieved by calling\n  [`get_coverage(line, Module)`](`get_coverage/2`), and information about which\n  functions that have been executed can be retrieved by calling\n  [`get_coverage(function, Module)`](`get_coverage/2`).\n\n- **`line_counters`** - When modules that have been compiled with the\n  [`line_coverage`](`m:compile#line_coverage`) option are loaded, they will be\n  instrumented to count the number of times each line is executed. Information\n  about how many times each line has been executed can be retrieved by calling\n  [`get_coverage(line, Module)`](`get_coverage/2`), and information about which\n  functions that have been executed can be retrieved by calling\n  [`get_coverage(function, Module)`](`get_coverage/2`) (note that in this mode,\n  counters for the number of times each function has been executed **cannot** be\n  retrieved).\n\n- **`none`** - Modules will be loaded without coverage instrumentation.\n\nReturns the previous coverage mode.\n\nFailures:\n\n- **`badarg`** - If `Mode` is not a valid coverage mode.\n\n- **`badarg`** - If the runtime system does not support coverage.\n\n_See also:_ [Native Coverage Support](#module-native-coverage-support)","ref":"code.html#set_coverage_mode/1"},{"type":"function","title":"code.set_path/1","doc":"Equivalent to  set_path(PathList, nocache) .","ref":"code.html#set_path/1"},{"type":"function","title":"code.set_path/2","doc":"Sets the code path to the list of directories `Path`.\n\nArgument `Cache` controls whether the content of the directory\nshould be cached on first traversal. If `Cache` is `cache` the directory\ncontents will be cached; if `Cache` is `nocache` it will not be cached.\n\nReturns:\n\n- **`true`** - If successful\n\n- **`{error, bad_directory}`** - If any `Dir` is not a directory name","ref":"code.html#set_path/2"},{"type":"type","title":"code.set_path_ret/0","doc":"","ref":"code.html#t:set_path_ret/0"},{"type":"function","title":"code.soft_purge/1","doc":"Purges the code for `Module`, that is, removes code marked as old, but only if\nno processes linger in it.\n\n> #### Change {: .info }\n>\n> As of Erlang/OTP 20.0, a process is only considered to be lingering in the\n> code if it has direct references to the code. For more information see\n> documentation of `erlang:check_process_code/3`, which is used in order to\n> determine whether a process is lingering.\n\nReturns `false` if the module cannot be purged because of processes lingering in\nold code, otherwise `true`.","ref":"code.html#soft_purge/1"},{"type":"function","title":"code.stick_dir/1","doc":"Marks `Dir` as sticky.\n\nReturns `ok` if successful, otherwise `error`.","ref":"code.html#stick_dir/1"},{"type":"function","title":"code.unstick_dir/1","doc":"Unsticks a directory that is marked as sticky.\n\nReturns `ok` if successful, otherwise `error`.","ref":"code.html#unstick_dir/1"},{"type":"function","title":"code.where_is_file/1","doc":"Searches the code path for `Filename`, which is a file of arbitrary type.\n\nIf found, the full name is returned. `non_existing` is returned if the\nfile cannot be found.  The function can be useful, for example, to\nlocate application resource files.","ref":"code.html#where_is_file/1"},{"type":"function","title":"code.which/1","doc":"If the module is not loaded, this function searches the code path for the first\nfile containing object code for `Module` and returns the absolute filename.\n\n- If the module is loaded, it returns the name of the file containing the loaded\n  object code.\n\n- If the module is preloaded, `preloaded` is returned.\n\n- If the module is Cover-compiled, `cover_compiled` is returned.\n\n- If the module cannot be found, `non_existing` is returned.","ref":"code.html#which/1"},{"type":"module","title":"erl_ddll","doc":"Dynamic driver loader and linker.\n\nThis module provides an interface for loading and unloading _Erlang linked-in\ndrivers_ in runtime.\n\n> #### Note {: .info }\n>\n> This is a large reference document. For casual use of this module, and for\n> most real world applications, the descriptions of functions `load/2` and\n> `unload/1` are enough to getting started.\n\nThe driver is to be provided as a dynamically linked library in an object code\nformat specific for the platform in use, that is, `.so` files on most Unix\nsystems and `.ddl` files on Windows. An Erlang linked-in driver must provide\nspecific interfaces to the emulator, so this module is not designed for loading\narbitrary dynamic libraries. For more information about Erlang drivers, see\n[`erl_driver`](`e:erts:erl_driver.md`) .\n\n[](){: #users }\n\nWhen describing a set of functions (that is, a module, a part of a module, or an\napplication), executing in a process and wanting to use a ddll-driver, we use\nthe term _user_. A process can have many users (different modules needing the\nsame driver) and many processes running the same code, making up many _users_ of\na driver.\n\nIn the basic scenario, each user loads the driver before starting to use it and\nunloads the driver when done. The reference counting keeps track of processes\nand the number of loads by each process. This way the driver is only unloaded\nwhen no one wants it (it has no user). The driver also keeps track of ports that\nare opened to it. This enables delay of unloading until all ports are closed, or\nkilling of all ports that use the driver when it is unloaded.\n\n[](){: #scenarios }\n\nThe interface supports two basic scenarios of loading and unloading. Each\nscenario can also have the option of either killing ports when the driver is\nunloading, or waiting for the ports to close themselves. The scenarios are as\nfollows:\n\n- **_Load and Unload on a \"When Needed Basis\"_** - This (most common) scenario\n  simply supports that each [user](`m:erl_ddll#users`) of the driver loads it\n  when needed and unloads it when no longer needed. The driver is always\n  reference counted and as long as a process keeping the driver loaded is still\n  alive, the driver is present in the system.\n\n  Each [user](`m:erl_ddll#users`) of the driver use _literally_ the same\n  pathname for the driver when demanding load, but the\n  [users](`m:erl_ddll#users`) are not concerned with if the driver is already\n  loaded from the file system or if the object code must be loaded from file\n  system.\n\n  The following two pairs of functions support this scenario:\n\n  - **_load/2 and unload/1_** - When using the `load/unload` interfaces, the\n    driver is not unloaded until the _last port_ using the driver is closed.\n    Function [`unload/1`](`unload/1`) can return immediately, as the\n    [users](`m:erl_ddll#users`) have no interest in when the unloading occurs.\n    The driver is unloaded when no one needs it any longer.\n\n    If a process having the driver loaded dies, it has the same effect as if\n    unloading is done.\n\n    When loading, function [`load/2`](`load/2`) returns `ok` when any instance\n    of the driver is present. Thus, if a driver is waiting to get unloaded\n    (because of open ports), it simply changes state to no longer need\n    unloading.\n\n  - **_load_driver/2 and unload_driver/1_** - These interfaces are intended to\n    be used when it is considered an error that ports are open to a driver that\n    no [user](`m:erl_ddll#users`) has loaded. The ports that are still open when\n    the last [user](`m:erl_ddll#users`) calls\n    [`unload_driver/1`](`unload_driver/1`) or when the last process having the\n    driver loaded dies, are killed with reason `driver_unloaded`.\n\n    The function names `load_driver` and `unload_driver` are kept for backward\n    compatibility.\n\n- **_Loading and Reloading for Code Replacement_** - This scenario can occur if\n  the driver code needs replacement during operation of the Erlang emulator.\n  Implementing driver code replacement is a little more tedious than Beam code\n  replacement, as one driver cannot be loaded as both \"old\" and \"new\" code. All\n  [users](`m:erl_ddll#users`) of a driver must have it closed (no open ports)\n  before the old code can be unloaded and the new code can be loaded.\n\n  The unloading/loading is done as one atomic operation, blocking all processes\n  in the system from using the driver in question while in progress.\n\n  The preferred way to do driver code replacement is to let _one single process_\n  keep track of the driver. When the process starts, the driver is loaded. When\n  replacement is required, the driver is reloaded. Unload is probably never\n  done, or done when the process exits. If more than one\n  [user](`m:erl_ddll#users`) has a driver loaded when code replacement is\n  demanded, the replacement cannot occur until the last \"other\"\n  [user](`m:erl_ddll#users`) has unloaded the driver.\n\n  Demanding reload when a reload is already in progress is always an error.\n  Using the high-level functions, it is also an error to demand reloading when\n  more than one [user](`m:erl_ddll#users`) has the driver loaded.\n\n  To simplify driver replacement, avoid designing your system so that more than\n  one [user](`m:erl_ddll#users`) has the driver loaded.\n\n  The two functions for reloading drivers are to be used together with\n  corresponding load functions to support the two different behaviors concerning\n  open ports:\n\n  - **_load/2 and reload/2_** - This pair of functions is used when reloading is\n    to be done after the last open port to the driver is closed.\n\n    As [`reload/2`](`reload/2`) waits for the reloading to occur, a misbehaving\n    process keeping open ports to the driver (or keeping the driver loaded) can\n    cause infinite waiting for reload. Time-outs must be provided outside of the\n    process demanding the reload or by using the low-level interface\n    `try_load/3` in combination with driver monitors.\n\n  - **_load_driver/2 and reload_driver/2_** - This pair of functions are used\n    when open ports to the driver are to be killed with reason `driver_unloaded`\n    to allow for new driver code to get loaded.\n\n    However, if another process has the driver loaded, calling `reload_driver`\n    returns error code `pending_process`. As stated earlier, the recommended\n    design is to not allow other [users](`m:erl_ddll#users`) than the \"driver\n    reloader\" to demand loading of the driver in question.","ref":"erl_ddll.html"},{"type":"module","title":"See Also - erl_ddll","doc":"[`erl_driver(4)`](`e:erts:erl_driver.md`), [`driver_entry(4)`](`e:erts:driver_entry.md`)","ref":"erl_ddll.html#module-see-also"},{"type":"function","title":"erl_ddll.demonitor/1","doc":"Removes a driver monitor in much the same way as `erlang:demonitor/1` in ERTS\ndoes with process monitors.\n\nFor details about how to create driver monitors, see `monitor/2`,\n`try_load/3`, and `try_unload/2`.\n\nThe function throws a `badarg` exception if the parameter is not a\n`t:reference/0`.","ref":"erl_ddll.html#demonitor/1"},{"type":"type","title":"erl_ddll.driver/0","doc":"","ref":"erl_ddll.html#t:driver/0"},{"type":"function","title":"erl_ddll.format_error/1","doc":"Takes an `ErrorDesc` returned by load, unload, or reload functions and returns a\nstring that describes the error or warning.\n\n> #### Note {: .info }\n>\n> Because of peculiarities in the dynamic loading interfaces on different\n> platforms, the returned string is only guaranteed to describe the correct\n> error _if format_error/1 is called in the same instance of the Erlang virtual\n> machine as the error appeared in_ (meaning the same operating system process).","ref":"erl_ddll.html#format_error/1"},{"type":"function","title":"erl_ddll.info/0","doc":"Returns a list of tuples `{DriverName, InfoList}`, where `InfoList` is the\nresult of calling `info/1` for that `DriverName`. Only dynamically linked-in\ndrivers are included in the list.","ref":"erl_ddll.html#info/0"},{"type":"function","title":"erl_ddll.info/1","doc":"Returns a list of tuples `{Tag, Value}`, where `Tag` is the information item and\n`Value` is the result of calling `info/2` with this driver name and this tag.\nThe result is a tuple list containing all information available about a driver.\n\nThe following tags appears in the list:\n\n- `processes`\n- `driver_options`\n- `port_count`\n- `linked_in_driver`\n- `permanent`\n- `awaiting_load`\n- `awaiting_unload`\n\nFor a detailed description of each value, see `info/2`.\n\nThe function throws a `badarg` exception if the driver is not present in the\nsystem.","ref":"erl_ddll.html#info/1"},{"type":"function","title":"erl_ddll.info/2","doc":"Returns specific information about one aspect of a driver. Parameter `Tag`\nspecifies which aspect to get information about. The return `Value` differs\nbetween different tags:\n\n- **`processes`** - Returns all processes containing [users](`m:erl_ddll#users`)\n  of the specific drivers as a list of tuples `{pid(),integer() >= 0}`, where\n  `t:integer/0` denotes the number of users in process `t:pid/0`.\n\n- **`driver_options`** - Returns a list of the driver options provided when\n  loading, and any options set by the driver during initialization. The only\n  valid option is `kill_ports`.\n\n- **`port_count`** - Returns the number of ports (an `integer() >= 0`) using the\n  driver.\n\n- **`linked_in_driver`** - Returns a `t:boolean/0`, which is `true` if the\n  driver is a statically linked-in one, otherwise `false`.\n\n- **`permanent`** - Returns a `t:boolean/0`, which is `true` if the driver has\n  made itself permanent (and is _not_ a statically linked-in driver), otherwise\n  `false`.\n\n- **`awaiting_load`** - Returns a list of all processes having monitors for\n  `loading` active. Each process is returned as `{pid(),integer() >= 0}`, where\n  `t:integer/0` is the number of monitors held by process `t:pid/0`.\n\n- **`awaiting_unload`** - Returns a list of all processes having monitors for\n  `unloading` active. Each process is returned as `{pid(),integer() >= 0}`,\n  where `t:integer/0` is the number of monitors held by process `t:pid/0`.\n\nIf option `linked_in_driver` or `permanent` returns `true`, all other options\nreturn `linked_in_driver` or `permanent`, respectively.\n\nThe function throws a `badarg` exception if the driver is not present in the\nsystem or if the tag is not supported.","ref":"erl_ddll.html#info/2"},{"type":"function","title":"erl_ddll.load/2","doc":"Loads and links the dynamic driver `Name`. `Path` is a file path to the\ndirectory containing the driver. `Name` must be a shareable object/dynamic\nlibrary. Two drivers with different `Path` parameters cannot be loaded under the\nsame name. `Name` is a string or atom containing at least one character.\n\nThe `Name` specified is to correspond to the filename of the dynamically\nloadable object file residing in the directory specified as `Path`, but\n_without_ the extension (that is, `.so`). The driver name provided in the driver\ninitialization routine must correspond with the filename, in much the same way\nas Erlang module names correspond to the names of the `.beam` files.\n\nIf the driver was previously unloaded, but is still present because of open\nports to it, a call to [`load/2`](`load/2`) stops the unloading and keeps the\ndriver (as long as `Path` is the same), and `ok` is returned. If you really want\nthe object code to be reloaded, use `reload/2` or the low-level interface\n`try_load/3` instead. See also the description of\n[`different scenarios`](`m:erl_ddll#scenarios`) for loading/unloading in the\nintroduction.\n\nIf more than one process tries to load an already loaded driver with the same\n`Path`, or if the same process tries to load it many times, the function returns\n`ok`. The emulator keeps track of the [`load/2`](`load/2`) calls, so that a\ncorresponding number of `unload/2` calls must be done from the same process\nbefore the driver gets unloaded. It is therefore safe for an application to load\na driver that is shared between processes or applications when needed. It can\nsafely be unloaded without causing trouble for other parts of the system.\n\nIt is not allowed to load multiple drivers with the same name but with different\n`Path` parameters.\n\n> #### Note {: .info }\n>\n> `Path` is interpreted literally, so that all loaders of the same driver must\n> specify the same _literal_ `Path` string, although different paths can point\n> out the same directory in the file system (because of use of relative paths\n> and links).\n\nOn success, the function returns `ok`. On failure, the return value is\n`{error,ErrorDesc}`, where `ErrorDesc` is an opaque term to be translated into\nhuman readable form by function `format_error/1`.\n\nFor more control over the error handling, use the `try_load/3` interface\ninstead.\n\nThe function throws a `badarg` exception if the parameters are not specified as\ndescribed here.","ref":"erl_ddll.html#load/2"},{"type":"function","title":"erl_ddll.load_driver/2","doc":"Works essentially as [`load/2`](`load/2`), but loads the driver with other\noptions. All ports using the driver are killed with reason `driver_unloaded`\nwhen the driver is to be unloaded.\n\nThe number of loads and unloads by different [users](`m:erl_ddll#users`)\ninfluences the loading and unloading of a driver file. The port killing\ntherefore only occurs when the _last_ [user](`m:erl_ddll#users`) unloads the\ndriver, or when the last process having loaded the driver exits.\n\nThis interface (or at least the name of the functions) is kept for backward\ncompatibility. Using `try_load/3` with `{driver_options,[kill_ports]}` in the\noption list gives the same effect regarding the port killing.\n\nThe function throws a `badarg` exception if the parameters are not specified as\ndescribed here.","ref":"erl_ddll.html#load_driver/2"},{"type":"function","title":"erl_ddll.loaded_drivers/0","doc":"Returns a list of all the available drivers, both (statically) linked-in and\ndynamically loaded ones.\n\nThe driver names are returned as a list of strings rather than a list of atoms\nfor historical reasons.\n\nFor more information about drivers, see [`info`](`info/0`).","ref":"erl_ddll.html#loaded_drivers/0"},{"type":"function","title":"erl_ddll.monitor/2","doc":"Creates a driver monitor and works in many ways as `erlang:monitor/2` in ERTS,\ndoes for processes. When a driver changes state, the monitor results in a\nmonitor message that is sent to the calling process. `MonitorRef` returned by\nthis function is included in the message sent.\n\nAs with process monitors, each driver monitor set only generates _one single\nmessage_. The monitor is \"destroyed\" after the message is sent, so it is then\nnot needed to call `demonitor/1`.\n\n`MonitorRef` can also be used in subsequent calls to `demonitor/1` to remove a\nmonitor.\n\nThe function accepts the following parameters:\n\n- **`Tag`** - The monitor tag is always `driver`, as this function can only be\n  used to create driver monitors. In the future, driver monitors will be\n  integrated with process monitors, why this parameter has to be specified for\n  consistence.\n\n- **`Item`** - Parameter `Item` specifies which driver to monitor (the driver\n  name) and which state change to monitor. The parameter is a tuple of arity two\n  whose first element is the driver name and second element is one of the\n  following:\n\n  - **`loaded`** - Notifies when the driver is reloaded (or loaded if loading is\n    underway). It only makes sense to monitor drivers that are in the process of\n    being loaded or reloaded. A future driver name for loading cannot be\n    monitored. That only results in a `DOWN` message sent immediately.\n    Monitoring for loading is therefore most useful when triggered by function\n    `try_load/3`, where the monitor is created _because_ the driver is in such a\n    pending state.\n\n    Setting a driver monitor for `loading` eventually leads to one of the\n    following messages being sent:\n\n    - **`{'UP', reference(), driver, Name, loaded}`** - This message is sent\n      either immediately if the driver is already loaded and no reloading is\n      pending, or when reloading is executed if reloading is pending.\n\n      The [user](`m:erl_ddll#users`) is expected to know if reloading is\n      demanded before creating a monitor for loading.\n\n    - **`{'UP', reference(), driver, Name, permanent}`** - This message is sent\n      if reloading was expected, but the (old) driver made itself permanent\n      before reloading. It is also sent if the driver was permanent or\n      statically linked-in when trying to create the monitor.\n\n    - **`{'DOWN', reference(), driver, Name, load_cancelled}`** - This message\n      arrives if reloading was underway, but the requesting\n      [user](`m:erl_ddll#users`) cancelled it by dying or calling `try_unload/2`\n      (or [`unload/1`](`unload/1`)/[`unload_driver/1`](`unload_driver/1`)) again\n      before it was reloaded.\n\n    - **`{'DOWN', reference(), driver, Name, {load_failure, Failure}}`** - This\n      message arrives if reloading was underway but the loading for some reason\n      failed. The `Failure` term is one of the errors that can be returned from\n      `try_load/3`. The error term can be passed to `format_error/1` for\n      translation into human readable form. Notice that the translation must be\n      done in the same running Erlang virtual machine as the error was detected\n      in.\n\n  - **`unloaded`** - Monitors when a driver gets unloaded. If one monitors a\n    driver that is not present in the system, one immediately gets notified that\n    the driver got unloaded. There is no guarantee that the driver was ever\n    loaded.\n\n    A driver monitor for unload eventually results in one of the following\n    messages being sent:\n\n    - **`{'DOWN', reference(), driver, Name, unloaded}`** - The monitored driver\n      instance is now unloaded. As the unload can be a result of a\n      [`reload/2`](`reload/2`) request, the driver can once again have been\n      loaded when this message arrives.\n\n    - **`{'UP', reference(), driver, Name, unload_cancelled}`** - This message\n      is sent if unloading was expected, but while the driver was waiting for\n      all ports to get closed, a new [user](`m:erl_ddll#users`) of the driver\n      appeared, and the unloading was cancelled.\n\n      This message appears if `{ok, pending_driver}` was returned from\n      `try_unload/2` for the last [user](`m:erl_ddll#users`) of the driver, and\n      then `{ok, already_loaded}` is returned from a call to `try_load/3`.\n\n      If one _really_ wants to monitor when the driver gets unloaded, this\n      message distorts the picture, because no unloading was done. Option\n      `unloaded_only` creates a monitor similar to an `unloaded` monitor, but\n      never results in this message.\n\n    - **`{'UP', reference(), driver, Name, permanent}`** - This message is sent\n      if unloading was expected, but the driver made itself permanent before\n      unloading. It is also sent if trying to monitor a permanent or statically\n      linked-in driver.\n\n  - **`unloaded_only`** - A monitor created as `unloaded_only` behaves exactly\n    as one created as `unloaded` except that the\n    `{'UP', reference(), driver, Name, unload_cancelled}` message is never sent,\n    but the monitor instead persists until the driver _really_ gets unloaded.\n\nThe function throws a `badarg` exception if the parameters are not specified as\ndescribed here.","ref":"erl_ddll.html#monitor/2"},{"type":"type","title":"erl_ddll.path/0","doc":"","ref":"erl_ddll.html#t:path/0"},{"type":"function","title":"erl_ddll.reload/2","doc":"Reloads the driver named `Name` from a possibly different `Path` than previously\nused. This function is used in the code change\n[`scenario`](`m:erl_ddll#scenarios`) described in the introduction.\n\nIf there are other [users](`m:erl_ddll#users`) of this driver, the function\nreturns `{error, pending_process}`, but if there are no other users, the\nfunction call hangs until all open ports are closed.\n\n> #### Note {: .info }\n>\n> Avoid mixing multiple [users](`m:erl_ddll#users`) with driver reload requests.\n\nTo avoid hanging on open ports, use function `try_load/3` instead.\n\nThe `Name` and `Path` parameters have exactly the same meaning as when calling\nthe plain function `load/2`.\n\nOn success, the function returns `ok`. On failure, the function returns an\nopaque error, except the `pending_process` error described earlier. The opaque\nerrors are to be translated into human readable form by function\n`format_error/1`.\n\nFor more control over the error handling, use the `try_load/3` interface\ninstead.\n\nThe function throws a `badarg` exception if the parameters are not specified as\ndescribed here.","ref":"erl_ddll.html#reload/2"},{"type":"function","title":"erl_ddll.reload_driver/2","doc":"Works exactly as `reload/2`, but for drivers loaded with the `load_driver/2`\ninterface.\n\nAs this interface implies that ports are killed when the last user disappears,\nthe function does not hang waiting for ports to get closed.\n\nFor more details, see [`scenarios`](`m:erl_ddll#scenarios`) in this module\ndescription and the function description for `reload/2`.\n\nThe function throws a `badarg` exception if the parameters are not specified as\ndescribed here.","ref":"erl_ddll.html#reload_driver/2"},{"type":"function","title":"erl_ddll.try_load/3","doc":"Provides more control than the [`load/2`](`load/2`)/[`reload/2`](`reload/2`) and\n[`load_driver/2`](`load_driver/2`)/[`reload_driver/2`](`reload_driver/2`)\ninterfaces. It never waits for completion of other operations related to the\ndriver, but immediately returns the status of the driver as one of the\nfollowing:\n\n- **`{ok, loaded}`** - The driver was loaded and is immediately usable.\n\n- **`{ok, already_loaded}`** - The driver was already loaded by another process\n  or is in use by a living port, or both. The load by you is registered and a\n  corresponding `try_unload` is expected sometime in the future.\n\n- **`{ok, pending_driver}`or `{ok, pending_driver, reference()}`** - The load\n  request is registered, but the loading is delayed because an earlier instance\n  of the driver is still waiting to get unloaded (open ports use it). Still,\n  unload is expected when you are done with the driver. This return value\n  _mostly_ occurs when options `{reload,pending_driver}` or `{reload,pending}`\n  are used, but _can_ occur when another [user](`m:erl_ddll#users`) is unloading\n  a driver in parallel and driver option `kill_ports` is set. In other words,\n  this return value always needs to be handled.\n\n- **`{ok, pending_process}`or `{ok, pending_process, reference()}`** - The load\n  request is registered, but the loading is delayed because an earlier instance\n  of the driver is still waiting to get unloaded by another\n  [user](`m:erl_ddll#users`) (not only by a port, in which case\n  `{ok,pending_driver}` would have been returned). Still, unload is expected\n  when you are done with the driver. This return value _only_ occurs when option\n  `{reload,pending}` is used.\n\nWhen the function returns `{ok, pending_driver}` or `{ok, pending_process}`, one\ncan get information about when the driver is _actually_ loaded by using option\n`{monitor, MonitorOption}`.\n\nWhen monitoring is requested, and a corresponding `{ok, pending_driver}` or\n`{ok, pending_process}` would be returned, the function instead returns a tuple\n`{ok, PendingStatus, reference()}` and the process then gets a monitor message\nlater, when the driver gets loaded. The monitor message to expect is described\nin the function description of `monitor/2`.\n\n> #### Note {: .info }\n>\n> In case of loading, monitoring can _not_ only get triggered by using option\n> `{reload, ReloadOption}`, but also in special cases where the load error is\n> transient. Thus, `{monitor, pending_driver}` is to be used under basically\n> _all_ real world circumstances.\n\nThe function accepts the following parameters:\n\n- **`Path`** - The file system path to the directory where the driver object\n  file is located. The filename of the object file (minus extension) must\n  correspond to the driver name (used in parameter `Name`) and the driver must\n  identify itself with the same name. `Path` can be provided as an _iolist()_,\n  meaning it can be a list of other `t:iolist/0`s, characters (8-bit integers),\n  or binaries, all to be flattened into a sequence of characters.\n\n  The (possibly flattened) `Path` parameter must be consistent throughout the\n  system. A driver is to, by all [users](`m:erl_ddll#users`), be loaded using\n  the same _literal_ `Path`. The exception is when _reloading_ is requested, in\n  which case `Path` can be specified differently. Notice that all\n  [users](`m:erl_ddll#users`) trying to load the driver later need to use the\n  _new_ `Path` if `Path` is changed using a `reload` option. This is yet another\n  reason to have _only one loader_ of a driver one wants to upgrade in a running\n  system.\n\n- **`Name`** - This parameter is the name of the driver to be used in subsequent\n  calls to function [`erlang:open_port`](`erlang:open_port/2`) in ERTS. The name\n  can be specified as an `t:iolist/0` or an `t:atom/0`. The name specified when\n  loading is used to find the object file (with the help of `Path` and the\n  system-implied extension suffix, that is, `.so`). The name by which the driver\n  identifies itself must also be consistent with this `Name` parameter, much as\n  the module name of a Beam file much corresponds to its filename.\n\n- **`OptionList`** - Some options can be specified to control the loading\n  operation. The options are specified as a list of two-tuples. The tuples have\n  the following values and meanings:\n\n  - **`{driver_options, DriverOptionList}`** - This is to provide options that\n    changes its general behavior and \"sticks\" to the driver throughout its\n    lifespan.\n\n    The driver options for a specified driver name need always to be consistent,\n    _even when the driver is reloaded_, meaning that they are as much a part of\n    the driver as the name.\n\n    The only allowed driver option is `kill_ports`, which means that all ports\n    opened to the driver are killed with exit reason `driver_unloaded` when no\n    process any longer has the driver loaded. This situation arises either when\n    the last [user](`m:erl_ddll#users`) calls `try_unload/2`, or when the last\n    process having loaded the driver exits.\n\n  - **`{monitor, MonitorOption}`** - A `MonitorOption` tells\n    [`try_load/3`](`try_load/3`) to trigger a driver monitor under certain\n    conditions. When the monitor is triggered, the function returns a\n    three-tuple `{ok, PendingStatus, reference()}`, where `t:reference/0` is the\n    monitor reference for the driver monitor.\n\n    Only one `MonitorOption` can be specified. It is one of the following:\n\n    - The atom `pending`, which means that a monitor is to be created whenever a\n      load operation is delayed,\n    - The atom `pending_driver`, in which a monitor is created whenever the\n      operation is delayed because of open ports to an otherwise unused driver.\n\n    Option `pending_driver` is of little use, but is present for completeness,\n    as it is well defined which reload options that can give rise to which\n    delays. However, it can be a good idea to use the same `MonitorOption` as\n    the `ReloadOption`, if present.\n\n    If reloading is not requested, it can still be useful to specify option\n    `monitor`, as forced unloads (driver option `kill_ports` or option\n    `kill_ports` to `try_unload/2`) trigger a transient state where driver\n    loading cannot be performed until all closing ports are closed. Thus, as\n    `try_unload` can, in almost all situations, return `{ok, pending_driver}`,\n    always specify at least `{monitor, pending_driver}` in production code (see\n    the monitor discussion earlier).\n\n  - **`{reload, ReloadOption}`** - This option is used to _reload_ a driver from\n    disk, most often in a code upgrade scenario. Having a `reload` option also\n    implies that parameter `Path` does _not_ need to be consistent with earlier\n    loads of the driver.\n\n    To reload a driver, the process must have loaded the driver before, that is,\n    there must be an active [user](`m:erl_ddll#users`) of the driver in the\n    process.\n\n    The `reload` option can be either of the following:\n\n    - **`pending`** - With the atom `pending`, reloading is requested for any\n      driver and is effectuated when _all_ ports opened to the driver are\n      closed. The driver replacement in this case takes place regardless if\n      there are still pending [users](`m:erl_ddll#users`) having the driver\n      loaded.\n\n      The option also triggers port-killing (if driver option `kill_ports` is\n      used) although there are pending users, making it usable for forced driver\n      replacement, but laying much responsibility on the driver\n      [users](`m:erl_ddll#users`). The pending option is seldom used as one does\n      not want other [users](`m:erl_ddll#users`) to have loaded the driver when\n      code change is underway.\n\n    - **`pending_driver`** - This option is more useful. Here, reloading is\n      queued if the driver is _not_ loaded by any other\n      [users](`m:erl_ddll#users`), but the driver has opened ports, in which\n      case `{ok, pending_driver}` is returned (a `monitor` option is\n      recommended).\n\n    If the driver is unloaded (not present in the system), error code\n    `not_loaded` is returned. Option `reload` is intended for when the user has\n    already loaded the driver in advance.\n\nThe function can return numerous errors, some can only be returned given a\ncertain combination of options.\n\nSome errors are opaque and can only be interpreted by passing them to function\n`format_error/1`, but some can be interpreted directly:\n\n- **`{error,linked_in_driver}`** - The driver with the specified name is an\n  Erlang statically linked-in driver, which cannot be manipulated with this API.\n\n- **`{error,inconsistent}`** - The driver is already loaded with other\n  `DriverOptionList` or a different _literal_ `Path` argument.\n\n  This can occur even if a `reload` option is specified, if `DriverOptionList`\n  differs from the current.\n\n- **`{error, permanent}`** - The driver has requested itself to be permanent,\n  making it behave like an Erlang linked-in driver and can no longer be\n  manipulated with this API.\n\n- **`{error, pending_process}`** - The driver is loaded by other\n  [users](`m:erl_ddll#users`) when option `{reload, pending_driver}` was\n  specified.\n\n- **`{error, pending_reload}`** - Driver reload is already requested by another\n  [user](`m:erl_ddll#users`) when option `{reload, ReloadOption}` was specified.\n\n- **`{error, not_loaded_by_this_process}`** - Appears when option `reload` is\n  specified. The driver `Name` is present in the system, but there is no\n  [user](`m:erl_ddll#users`) of it in this process.\n\n- **`{error, not_loaded}`** - Appears when option `reload` is specified. The\n  driver `Name` is not in the system. Only drivers loaded by this process can be\n  reloaded.\n\nAll other error codes are to be translated by function `format_error/1`. Notice\nthat calls to `format_error` are to be performed from the same running instance\nof the Erlang virtual machine as the error is detected in, because of\nsystem-dependent behavior concerning error values.\n\nIf the arguments or options are malformed, the function throws a `badarg`\nexception.","ref":"erl_ddll.html#try_load/3"},{"type":"function","title":"erl_ddll.try_unload/2","doc":"This is the low-level function to unload (or decrement reference counts of) a\ndriver. It can be used to force port killing, in much the same way as the driver\noption `kill_ports` implicitly does. Also, it can trigger a monitor either\nbecause other [users](`m:erl_ddll#users`) still have the driver loaded or\nbecause open ports use the driver.\n\nUnloading can be described as the process of telling the emulator that this\nparticular part of the code in this particular process (that is, this\n[user](`m:erl_ddll#users`)) no longer needs the driver. That can, if there are\nno other users, trigger unloading of the driver, in which case the driver name\ndisappears from the system and (if possible) the memory occupied by the driver\nexecutable code is reclaimed.\n\nIf the driver has option `kill_ports` set, or if `kill_ports` is specified as an\noption to this function, all pending ports using this driver are killed when\nunloading is done by the last [user](`m:erl_ddll#users`). If no port-killing is\ninvolved and there are open ports, the unloading is delayed until no more open\nports use the driver. If, in this case, another [user](`m:erl_ddll#users`) (or\neven this user) loads the driver again before the driver is unloaded, the\nunloading never takes place.\n\nTo allow the [user](`m:erl_ddll#users`) to _request unloading_ to wait for\n_actual unloading_, `monitor` triggers can be specified in much the same way as\nwhen loading. However, as [users](`m:erl_ddll#users`) of this function seldom\nare interested in more than decrementing the reference counts, monitoring is\nseldom needed.\n\n> #### Note {: .info }\n>\n> If option `kill_ports` is used, monitor trigging is crucial, as the ports are\n> not guaranteed to be killed until the driver is unloaded. Thus, a monitor must\n> be triggered for at least the `pending_driver` case.\n\nThe possible monitor messages to expect are the same as when using option\n`unloaded` to function `monitor/2`.\n\nThe function returns one of the following statuses upon success:\n\n- **`{ok, unloaded}`** - The driver was immediately unloaded, meaning that the\n  driver name is now free to use by other drivers and, if the underlying OS\n  permits it, the memory occupied by the driver object code is now reclaimed.\n\n  The driver can only be unloaded when there are no open ports using it and no\n  more [users](`m:erl_ddll#users`) require it to be loaded.\n\n- **`{ok, pending_driver}`or `{ok, pending_driver, reference()}`** - Indicates\n  that this call removed the last [user](`m:erl_ddll#users`) from the driver,\n  but there are still open ports using it. When all ports are closed and no new\n  [users](`m:erl_ddll#users`) have arrived, the driver is reloaded and the name\n  and memory reclaimed.\n\n  This return value is valid even if option `kill_ports` was used, as killing\n  ports can be a process that does not complete immediately. However, the\n  condition is in that case transient. Monitors are always useful to detect when\n  the driver is really unloaded.\n\n- **`{ok, pending_process}`or `{ok, pending_process, reference()}`** - The\n  unload request is registered, but other [users](`m:erl_ddll#users`) still hold\n  the driver. Notice that the term `pending_process` can refer to the running\n  process; there can be more than one [user](`m:erl_ddll#users`) in the same\n  process.\n\n  This is a normal, healthy, return value if the call was just placed to inform\n  the emulator that you have no further use of the driver. It is the most common\n  return value in the most common [`scenario`](`m:erl_ddll#scenarios`) described\n  in the introduction.\n\nThe function accepts the following parameters:\n\n- **`Name`** - `Name` is the name of the driver to be unloaded. The name can be\n  specified as an `t:iolist/0` or as an `t:atom/0`.\n\n- **`OptionList`** - Argument `OptionList` can be used to specify certain\n  behavior regarding ports and triggering monitors under certain conditions:\n\n  - **`kill_ports`** - Forces killing of all ports opened using this driver,\n    with exit reason `driver_unloaded`, if you are the _last_\n    [user](`m:erl_ddll#users`) of the driver.\n\n    If other [users](`m:erl_ddll#users`) have the driver loaded, this option has\n    no effect.\n\n    To get the consistent behavior of killing ports when the last\n    [user](`m:erl_ddll#users`) unloads, use driver option `kill_ports` when\n    loading the driver instead.\n\n  - **`{monitor, MonitorOption}`** - Creates a driver monitor if the condition\n    specified in `MonitorOption` is true. The valid options are:\n\n    - **`pending_driver`** - Creates a driver monitor if the return value is to\n      be `{ok, pending_driver}`.\n\n    - **`pending`** - Creates a monitor if the return value is\n      `{ok, pending_driver}` or `{ok, pending_process}`.\n\n    The `pending_driver` `MonitorOption` is by far the most useful. It must be\n    used to ensure that the driver really is unloaded and the ports closed\n    whenever option `kill_ports` is used, or the driver can have been loaded\n    with driver option `kill_ports`.\n\n    Using the monitor triggers in the call to `try_unload` ensures that the\n    monitor is added before the unloading is executed, meaning that the monitor\n    is always properly triggered, which is not the case if\n    [`monitor/2`](`monitor/2`) is called separately.\n\nThe function can return the following error conditions, all well specified (no\nopaque values):\n\n- **`{error, linked_in_driver}`** - You were trying to unload an Erlang\n  statically linked-in driver, which cannot be manipulated with this interface\n  (and cannot be unloaded at all).\n\n- **`{error, not_loaded}`** - The driver `Name` is not present in the system.\n\n- **`{error, not_loaded_by_this_process}`** - The driver `Name` is present in\n  the system, but there is no [user](`m:erl_ddll#users`) of it in this process.\n\n  As a special case, drivers can be unloaded from processes that have done no\n  corresponding call to [`try_load/3`](`try_load/3`) if, and only if, there are\n  _no users of the driver at all_, which can occur if the process containing the\n  last user dies.\n\n- **`{error, permanent}`** - The driver has made itself permanent, in which case\n  it can no longer be manipulated by this interface (much like a statically\n  linked-in driver).\n\nThe function throws a `badarg` exception if the parameters are not specified as\ndescribed here.","ref":"erl_ddll.html#try_unload/2"},{"type":"function","title":"erl_ddll.unload/1","doc":"Unloads, or at least dereferences the driver named `Name`. If the caller is the\nlast [user](`m:erl_ddll#users`) of the driver, and no more open ports use the\ndriver, the driver gets unloaded. Otherwise, unloading is delayed until all\nports are closed and no [users](`m:erl_ddll#users`) remain.\n\nIf there are other [users](`m:erl_ddll#users`) of the driver, the reference\ncounts of the driver is merely decreased, so that the caller is no longer\nconsidered a [user](`m:erl_ddll#users`) of the driver. For use scenarios, see\nthe [`description`](`m:erl_ddll#scenarios`) in the beginning of this module.\n\nThe `ErrorDesc` returned is an opaque value to be passed further on to function\n`format_error/1`. For more control over the operation, use the `try_unload/2`\ninterface.\n\nThe function throws a `badarg` exception if the parameters are not specified as\ndescribed here.","ref":"erl_ddll.html#unload/1"},{"type":"function","title":"erl_ddll.unload_driver/1","doc":"Unloads, or at least dereferences the driver named `Name`. If the caller is the\nlast [user](`m:erl_ddll#users`) of the driver, all remaining open ports using\nthe driver are killed with reason `driver_unloaded` and the driver eventually\ngets unloaded.\n\nIf there are other [users](`m:erl_ddll#users`) of the driver, the reference\ncounts of the driver is merely decreased, so that the caller is no longer\nconsidered a [user](`m:erl_ddll#users`). For use scenarios, see the\n[`description`](`m:erl_ddll#scenarios`) in the beginning of this module.\n\nThe `ErrorDesc` returned is an opaque value to be passed further on to function\n`format_error/1`. For more control over the operation, use the `try_unload/2`\ninterface.\n\nThe function throws a `badarg` exception if the parameters are not specified as\ndescribed here.","ref":"erl_ddll.html#unload_driver/1"},{"type":"module","title":"erl_debugger","doc":"Erlang debugger support (EXPERIMENTAL).\n\nThis module exposes low-level functionality for the implementation\nof a debugger for Erlang.\n\nAny local process can register itself as the debugger for a node, but\nthere can be at most one such process registered at any given time.\nUsing the BIFs in this module, a debugger can:\n\n  - set breakpoints;\n  - inspect internal process state, such registers, stack-frames;\n  - get notified on debugger events such as a process hitting a breakpoint;\n  - resume processes paused on breakpoints\n\nAt the moment, the API is highly experimental; so don't depend on it,\nor otherwise expect frequent incompatible changes.","ref":"erl_debugger.html"},{"type":"function","title":"erl_debugger.breakpoint/3","doc":"Sets or clear a breakpoint on the given Module/Line.\n\nWhen a process hits a breakpoint, it will pause and a `breakpoint`\nmessage is sent to the registered debugger.\n\nReturns `ok` on success. It can fail with the following reasons:\n  - `{badkey, Module}`: The given module is not loaded.\n  - `{unsupported, Module}`: The module was loaded without support\n    for line breakpoints.\n  - `{badkey, Line}`: The line is not relevant; it could refer to a comment,\n     not existing in the module source, and so on.\n  - `{unsupported, Line}`: It is not possible to set a breakpoint in\n    in the given line; for example, if it refers to a function head.","ref":"erl_debugger.html#breakpoint/3"},{"type":"function","title":"erl_debugger.breakpoints/1","doc":"Returns information on available breakpoints for a module.\n\nFor each function in the module, returns a map `#{Line => boolean()}`,\nwhere the keys are lines where breakpoints can be set, and the value\nrepresents whether be breakpoint is enabled (`true`) or not (`false`).","ref":"erl_debugger.html#breakpoints/1"},{"type":"function","title":"erl_debugger.breakpoints/3","doc":"Returns information on available breakpoints for a given function. .\n\nThe function need not be exported.\n\nReturns a map `#{Line => boolean()}`, where the keys are lines where\nbreakpoints can be set, and the value represents whether be breakpoint\nis enabled (`true`) or not (`false`).","ref":"erl_debugger.html#breakpoints/3"},{"type":"type","title":"erl_debugger.event/0","doc":"Debugger events.\n\nHere are the possible events:\n\n  * `{breakpoint, Pid, {M,F,A}, Line, Resume}`: process Pid hit a breakpoint\n    on module `M`, at the given `Line`. The debugger can resume the process\n    by executing `Resume()`.","ref":"erl_debugger.html#t:event/0"},{"type":"type","title":"erl_debugger.event_message/0","doc":"The debugger process will receive debugger-event messages, wrapped in\nan envelope of this type.","ref":"erl_debugger.html#t:event_message/0"},{"type":"type","title":"erl_debugger.instrumentation/0","doc":"Debugging instrumentations that can be applied on module loading.\n\n  - `line_breakpoint`: Allows setting breakpoints at the beginning\n     of executable lines","ref":"erl_debugger.html#t:instrumentation/0"},{"type":"function","title":"erl_debugger.instrumentations/0","doc":"Returns the instrumentations that will be applied on module loading.\n\nModules that are already loaded may have had a different set of\ninstrumentations applied.","ref":"erl_debugger.html#instrumentations/0"},{"type":"function","title":"erl_debugger.peek_stack_frame_slot/4","doc":"Gets the value of a slot in a suspended process stack-frame.\n\nReturns `running` if the process is not suspended, and `undefined`\nif the frame or the slot does not exist for that process.\nOtherwise, returns the slot, that can be a term, if its size is less\nthan `MaxTermSize`, or an exeption handler.","ref":"erl_debugger.html#peek_stack_frame_slot/4"},{"type":"function","title":"erl_debugger.peek_xreg/3","doc":"Get the value of an X register for a suspended process.","ref":"erl_debugger.html#peek_xreg/3"},{"type":"type","title":"erl_debugger.reg_val/0","doc":"The value of an X or a Y register, provided it fits within the requested\nsize.\n\nIf it is too large, then size of the term.","ref":"erl_debugger.html#t:reg_val/0"},{"type":"function","title":"erl_debugger.register/1","doc":"Register the given process as the debugger.\n\nIf the registration succeeds, it returns `{ok, Session}`, where `Session`\nis a token that will be included in every message sent to the process.\n\nReturns `{error, already_exists}` if some process is currently\nregistered as debugger.","ref":"erl_debugger.html#register/1"},{"type":"opaque","title":"erl_debugger.session/0","doc":"Debugger session identifier.\n\nIt is attached to all debugger events.","ref":"erl_debugger.html#t:session/0"},{"type":"type","title":"erl_debugger.stack_frame/0","doc":"A stack-frame, including the value of each slot.","ref":"erl_debugger.html#t:stack_frame/0"},{"type":"type","title":"erl_debugger.stack_frame_fun/0","doc":"What is running in each stack frame, including special VM frames.","ref":"erl_debugger.html#t:stack_frame_fun/0"},{"type":"type","title":"erl_debugger.stack_frame_info/0","doc":"Extra information about a stack-frame.\n\n  - `slots`: Y-registers (in order `[Y0,...Yk])`, followed by exception-handlers.\n  - `code`: Memory address of the next instruction to execute in this frame.","ref":"erl_debugger.html#t:stack_frame_info/0"},{"type":"type","title":"erl_debugger.stack_frame_slot/0","doc":"The contents of a stack frame slot can be a Y register\nor an exception handler.","ref":"erl_debugger.html#t:stack_frame_slot/0"},{"type":"function","title":"erl_debugger.stack_frames/2","doc":"Get the all the stack-frames for a suspended process.\n\nIf the given process is not in a suspended state, returns `running`.\nOtherwise, a list of [stack frames](`t:stack_frame/0`) including the\ncontent of each slot is returned. For slots containing terms,\n`MaxTermSize` controls the maximum size of values that are allowed to\nbe returned (to avoid accidentally blowing the heap of the caller).","ref":"erl_debugger.html#stack_frames/2"},{"type":"function","title":"erl_debugger.supported/0","doc":"Returns `true` if the emulator supports debugging.\n\nThe debugger can only be used if the `+D` argument was passed\nto the emulator on start-up.","ref":"erl_debugger.html#supported/0"},{"type":"function","title":"erl_debugger.toggle_instrumentations/1","doc":"Updates the instrumentations that will be applied on module loading.\n\nModules that are already loaded will keep the instrumentation they\nhad at their time of loading.","ref":"erl_debugger.html#toggle_instrumentations/1"},{"type":"function","title":"erl_debugger.unregister/2","doc":"Unregisters the given process.\n\nThe session given on registration needs to be provided.","ref":"erl_debugger.html#unregister/2"},{"type":"function","title":"erl_debugger.whereis/0","doc":"Returns the pid of the registered debugger.","ref":"erl_debugger.html#whereis/0"},{"type":"function","title":"erl_debugger.xregs_count/1","doc":"Get the number of X registers currently in use by a suspended process.","ref":"erl_debugger.html#xregs_count/1"},{"type":"module","title":"error_handler","doc":"Default system error handler.\n\nThis module defines what happens when certain types of errors occur.\n\nYou can change the error handler of a process by calling\n[`erlang:process_flag(error_handler, NewErrorHandler)`](`erlang#process_flag_error_handler`).","ref":"error_handler.html"},{"type":"module","title":"Notes - error_handler","doc":"The code in `error_handler` is complex. Do not change it without fully\nunderstanding the interaction between the error handler, the `init` process of\nthe code server, and the I/O mechanism of the code.\n\nCode changes that seem small can cause a deadlock, as unforeseen consequences\ncan occur. The use of `input` is dangerous in this type of code.","ref":"error_handler.html#module-notes"},{"type":"function","title":"error_handler.raise_undef_exception/3","doc":"Raises an `undef` exception with a stacktrace, indicating that\n`Module:Function/N` is undefined.","ref":"error_handler.html#raise_undef_exception/3"},{"type":"function","title":"error_handler.undefined_function/3","doc":"This function is called by the runtime system if a call is made to\n`Module:Function(Arg1,.., ArgN)` and `Module:Function/N` is undefined. Notice\nthat this function is evaluated inside the process making the original call.\n\nThis function first attempts to autoload `Module`. If that is not possible, an\n`undef` exception is raised.\n\nIf it is possible to load `Module` and function `Function/N` is exported, it is\ncalled.\n\nOtherwise, if function `'$handle_undefined_function'/2` is exported, it is\ncalled as `'$handle_undefined_function'(`Function, Args).\n\n> #### Warning {: .warning }\n>\n> Defining `'$handle_undefined_function'/2` in ordinary application code is\n> highly discouraged. It is very easy to make subtle errors that can take a long\n> time to debug. Furthermore, none of the tools for static code analysis (such\n> as Dialyzer and Xref) supports the use of `'$handle_undefined_function'/2` and\n> no such support will be added. Only use this function after having carefully\n> considered other, less dangerous, solutions. One example of potential\n> legitimate use is creating stubs for other sub-systems during testing and\n> debugging.\n\nOtherwise an `undef` exception is raised.","ref":"error_handler.html#undefined_function/3"},{"type":"function","title":"error_handler.undefined_lambda/3","doc":"This function is evaluated if a call is made to `Fun(Arg1,.., ArgN)` when the\nmodule defining the fun is not loaded. The function is evaluated inside the\nprocess making the original call.\n\nIf `Module` is interpreted, the interpreter is invoked and the return value of\nthe interpreted `Fun(Arg1,.., ArgN)` call is returned.\n\nOtherwise, it returns, if possible, the value of [`apply(Fun, Args)`](`apply/2`)\nafter an attempt is made to autoload `Module`. If this is not possible, the call\nfails with exit reason `undef`.","ref":"error_handler.html#undefined_lambda/3"},{"type":"module","title":"heart","doc":"Heartbeat monitoring of an Erlang runtime system.\n\nThis modules contains the interface to the `heart` process. `heart` sends\nperiodic heartbeats to an external port program, which is also named `heart`.\nThe purpose of the `heart` port program is to check that the Erlang runtime\nsystem it is supervising is still running. If the port program has not received\nany heartbeats within `HEART_BEAT_TIMEOUT` seconds (defaults to 60 seconds), the\nsystem can be rebooted.\n\nAn Erlang runtime system to be monitored by a heart program is to be started\nwith command-line flag `-heart` (see also [`erl(1)`](`e:erts:erl_cmd.md`)). The\n`heart` process is then started automatically:\n\n```text\n% erl -heart ...\n```\n\nIf the system is to be rebooted because of missing heartbeats, or a terminated\nErlang runtime system, environment variable `HEART_COMMAND` must be set before\nthe system is started. If this variable is not set, a warning text is printed\nbut the system does not reboot.\n\nTo reboot on Windows, `HEART_COMMAND` can be set to `heart -shutdown` (included\nin the Erlang delivery) or to any other suitable program that can activate a\nreboot.\n\nThe environment variable `HEART_BEAT_TIMEOUT` can be used to configure the heart\ntime-outs; it can be set in the operating system shell before Erlang is started\nor be specified at the command line:\n\n```text\n% erl -heart -env HEART_BEAT_TIMEOUT 30 ...\n```\n\nThe value (in seconds) must be in the range `10 < X <= 65535`.\n\nWhen running on OSs lacking support for monotonic time, `heart` is susceptible\nto system clock adjustments of more than `HEART_BEAT_TIMEOUT` seconds. When this\nhappens, `heart` times out and tries to reboot the system. This can occur, for\nexample, if the system clock is adjusted automatically by use of the Network\nTime Protocol (NTP).\n\nIf a crash occurs, an `erl_crash.dump` is _not_ written unless environment\nvariable `ERL_CRASH_DUMP_SECONDS` is set:\n\n```text\n% erl -heart -env ERL_CRASH_DUMP_SECONDS 10 ...\n```\n\nIf a regular core dump is wanted, let `heart` know by setting the kill signal to\nabort using environment variable `HEART_KILL_SIGNAL=SIGABRT`. If unset, or not\nset to `SIGABRT`, the default behavior is a kill signal using `SIGKILL`:\n\n```text\n% erl -heart -env HEART_KILL_SIGNAL SIGABRT ...\n```\n\nIf heart should _not_ kill the Erlang runtime system, this can be indicated\nusing the environment variable `HEART_NO_KILL=TRUE`. This can be useful if the\ncommand executed by heart takes care of this, for example as part of a specific\ncleanup sequence. If unset, or not set to `TRUE`, the default behaviour will be\nto kill as described above.\n\n```text\n% erl -heart -env HEART_NO_KILL 1 ...\n```\n\nFurthermore, `ERL_CRASH_DUMP_SECONDS` has the following behavior on `heart`:\n\n- **`ERL_CRASH_DUMP_SECONDS=0`** - Suppresses the writing of a crash dump file\n  entirely, thus rebooting the runtime system immediately. This is the same as\n  not setting the environment variable.\n\n- **`ERL_CRASH_DUMP_SECONDS=-1`** - Setting the environment variable to a\n  negative value does not reboot the runtime system until the crash dump file is\n  completely written.\n\n- **`ERL_CRASH_DUMP_SECONDS=S`** - `heart` waits for `S` seconds to let the\n  crash dump file be written. After `S` seconds, `heart` reboots the runtime\n  system, whether the crash dump file is written or not.\n\nIn the following descriptions, all functions fail with reason `badarg` if\n`heart` is not started.","ref":"heart.html"},{"type":"function","title":"heart.clear_callback/0","doc":"Removes the validation callback call before heartbeats.","ref":"heart.html#clear_callback/0"},{"type":"function","title":"heart.clear_cmd/0","doc":"Clears the temporary boot command. If the system terminates, the normal\n`HEART_COMMAND` is used to reboot.","ref":"heart.html#clear_cmd/0"},{"type":"function","title":"heart.get_callback/0","doc":"Get the validation callback. If the callback is cleared, `none` will be\nreturned.","ref":"heart.html#get_callback/0"},{"type":"function","title":"heart.get_cmd/0","doc":"Gets the temporary reboot command. If the command is cleared, the empty string\nis returned.","ref":"heart.html#get_cmd/0"},{"type":"function","title":"heart.get_options/0","doc":"Returns `{ok, Options}` where `Options` is a list of current options enabled for\nheart. If the callback is cleared, `none` will be returned.","ref":"heart.html#get_options/0"},{"type":"type","title":"heart.heart_option/0","doc":"","ref":"heart.html#t:heart_option/0"},{"type":"function","title":"heart.set_callback/2","doc":"This validation callback will be executed before any heartbeat is sent to the\nport program. For the validation to succeed it needs to return with the value\n`ok`.\n\nAn exception within the callback will be treated as a validation failure.\n\nThe callback will be removed if the system reboots.","ref":"heart.html#set_callback/2"},{"type":"function","title":"heart.set_cmd/1","doc":"Sets a temporary reboot command. This command is used if a `HEART_COMMAND` other\nthan the one specified with the environment variable is to be used to reboot the\nsystem. The new Erlang runtime system uses (if it misbehaves) environment\nvariable `HEART_COMMAND` to reboot.\n\nLimitations: Command string `Cmd` is sent to the `heart` program as an ISO\nLatin-1 or UTF-8 encoded binary, depending on the filename encoding mode of the\nemulator (see `file:native_name_encoding/0`). The size of the encoded binary\nmust be less than 2047 bytes.","ref":"heart.html#set_cmd/1"},{"type":"function","title":"heart.set_options/1","doc":"Valid options `set_options` are:\n\n- **`check_schedulers`** - If enabled, a signal will be sent to each scheduler\n  to check its responsiveness. The system check occurs before any heartbeat sent\n  to the port program. If any scheduler is not responsive enough the heart\n  program will not receive its heartbeat and thus eventually terminate the node.\n\nReturns with the value `ok` if the options are valid.","ref":"heart.html#set_options/1"},{"type":"module","title":"os","doc":"Operating system-specific functions.\n\nThe functions in this module are operating system-specific. Careless use of\nthese functions results in programs that will only run on a specific platform.\nOn the other hand, with careful use, these functions can be of help in enabling\na program to run on most platforms.\n\n> #### Note {: .info }\n>\n> The functions in this module will raise a `badarg` exception if their\n> arguments contain invalid characters according to the description in the \"Data\n> Types\" section.","ref":"os.html"},{"type":"function","title":"os.cmd/1","doc":"Equivalent to  cmd(Command, #{}) .","ref":"os.html#cmd/1"},{"type":"function","title":"os.cmd/2","doc":"Executes `Command` in a command shell of the target OS, captures the standard\noutput and standard error of the command, and returns this result as a string.\n\n_Examples:_\n\n```erlang\nLsOut = os:cmd(\"ls\"), % on unix platform\nDirOut = os:cmd(\"dir\"), % on Win32 platform\n```\n\nNotice that in some cases, standard output of a command when called from another\nprogram can differ, compared with the standard output of the command when called\ndirectly from an OS command shell.\n\nThe possible options are:\n\n- **`max_size`** - The maximum size of the data returned by the `os:cmd/2` call.\n  This option is a safety feature that should be used when the command executed\n  can return a very large, possibly infinite, result.\n\n  _Example_:\n\n  ```erlang\n  > os:cmd(\"cat /dev/zero\", #{ max_size => 20 }).\n  [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]\n  ```\n\n- **`exception_on_failure`** - If set to true, `os:cmd/2` will throw an error\n  exception if the command exits with a non-zero exit code. The exception reason\n  looks like this: `{command_failed, ResultBeforeFailure, ExitCode}` where\n  `ResultBeforeFailure` is the result written to stdout by the command before\n  the error happened and `ExitCode` is the exit code from the command.\n\n  _Example_:\n\n  ```erlang\n  > catch os:cmd(\"echo hello && exit 123\", #{ exception_on_failure => true }).\n  {'EXIT',{{command_failed,\"hello\\n\",123},\n           [{os,cmd,2,[{file,\"os.erl\"},{line,579}]},\n  ...\n  ```\n\nThe command shell can be set using the\n[kernel configuration parameter](kernel_app.md#os_cmd_shell), by default the\nshell is detected upon system startup.","ref":"os.html#cmd/2"},{"type":"function","title":"os.env/0","doc":"Returns a list of all environment variables. Each environment variable is\nexpressed as a tuple `{VarName,Value}`, where `VarName` is the name of the\nvariable and `Value` its value.\n\nIf Unicode filename encoding is in effect (see the\n[`erl` manual page](`e:erts:erl_cmd.md#file_name_encoding`)), the strings can\ncontain characters with codepoints > 255.","ref":"os.html#env/0"},{"type":"type","title":"os.env_var_name/0","doc":"A string containing valid characters on the specific OS for environment variable\nnames using [`file:native_name_encoding()`](`file:native_name_encoding/0`)\nencoding.\n\nNull characters (integer value zero) are not allowed. On Unix, `=`\ncharacters are not allowed. On Windows, a `=` character is only allowed as the\nvery first character in the string.","ref":"os.html#t:env_var_name/0"},{"type":"type","title":"os.env_var_name_value/0","doc":"Assuming that environment variables has been correctly set, a strings containing\nvalid characters on the specific OS for environment variable names and values\nusing [`file:native_name_encoding()`](`file:native_name_encoding/0`) encoding.\n\nThe first `=` characters appearing in the string separates environment variable\nname (on the left) from environment variable value (on the right).","ref":"os.html#t:env_var_name_value/0"},{"type":"type","title":"os.env_var_value/0","doc":"A string containing valid characters on the specific OS for environment variable\nvalues using [`file:native_name_encoding()`](`file:native_name_encoding/0`)\nencoding.\n\nNull characters (integer value zero) are not allowed.","ref":"os.html#t:env_var_value/0"},{"type":"function","title":"os.find_executable/1","doc":"Equivalent to [`find_executable(Name, Path)`](`find_executable/2`) where\n`Path` is the current execution path (that is, the environment variable `PATH`\non Unix and Windows).","ref":"os.html#find_executable/1"},{"type":"function","title":"os.find_executable/2","doc":"Look up an executable program, with the specified name and a search path, in the\nsame way as the underlying OS.\n\n`Path` is to conform to the syntax of execution paths on the OS.\nReturns the absolute filename of the executable program `Name`, or `false` if\nthe program is not found.","ref":"os.html#find_executable/2"},{"type":"function","title":"os.getenv/0","doc":"Returns a list of all environment variables. Each environment variable is\nexpressed as a single string on the format `\"VarName=Value\"`, where `VarName` is\nthe name of the variable and `Value` its value.\n\nIf Unicode filename encoding is in effect (see the\n[`erl` manual page](`e:erts:erl_cmd.md#file_name_encoding`)), the strings can\ncontain characters with codepoints > 255.\n\nConsider using `env/0` for a nicer 2-tuple format.","ref":"os.html#getenv/0"},{"type":"function","title":"os.getenv/1","doc":"Returns the `Value` of the environment variable `VarName`, or `false` if the\nenvironment variable is undefined.\n\nIf Unicode filename encoding is in effect (see the\n[`erl` manual page](`e:erts:erl_cmd.md#file_name_encoding`)), the strings\n`VarName` and `Value` can contain characters with codepoints > 255.","ref":"os.html#getenv/1"},{"type":"function","title":"os.getenv/2","doc":"Returns the `Value` of the environment variable `VarName`, or `DefaultValue` if\nthe environment variable is undefined.\n\nIf Unicode filename encoding is in effect (see the\n[`erl` manual page](`e:erts:erl_cmd.md#file_name_encoding`)), the strings\n`VarName` and `Value` can contain characters with codepoints > 255.","ref":"os.html#getenv/2"},{"type":"function","title":"os.getpid/0","doc":"Returns the process identifier of the current Erlang emulator in the format most\ncommonly used by the OS environment.\n\nReturns `Value` as a string containing the (usually) numerical identifier for a process.\n\n- On Unix, this is typically the return value of the `getpid/0` system call.\n- On Windows, the process id as returned by the `GetCurrentProcessId()` system call\n  is used.","ref":"os.html#getpid/0"},{"type":"type","title":"os.os_command/0","doc":"All characters needs to be valid characters on the specific OS using\n[`file:native_name_encoding()`](`file:native_name_encoding/0`) encoding. Null\ncharacters (integer value zero) are not allowed.","ref":"os.html#t:os_command/0"},{"type":"type","title":"os.os_command_opts/0","doc":"Options for [`os:cmd/2`](`cmd/2`).\n\n- **`max_size`** - The maximum size of the data returned by the `os:cmd/2` call.\n  See the [`os:cmd/2`](`cmd/2`) documentation for more details.\n- **`exception_on_failure`** - If set to true, `cmd/2` will throw an error exception if\n  the command exits with a non-zero exit code.","ref":"os.html#t:os_command_opts/0"},{"type":"function","title":"os.perf_counter/0","doc":"Returns the current performance counter value in `perf_counter`\n[time unit](`t:erlang:time_unit/0`). This is a highly optimized call that\nmight not be traceable.","ref":"os.html#perf_counter/0"},{"type":"function","title":"os.perf_counter/1","doc":"Returns a performance counter that can be used as a very fast and high\nresolution timestamp.\n\nThis counter is read directly from the hardware or operating system with the\nsame guarantees. This means that two consecutive calls to the function are not\nguaranteed to be monotonic, though it most likely will be. The performance\ncounter will be converted to the resolution passed as an argument.\n\n```erlang\n1> T1 = os:perf_counter(1000),receive after 10000 -> ok end,T2 = os:perf_counter(1000).\n176525861\n2> T2 - T1.\n10004\n```","ref":"os.html#perf_counter/1"},{"type":"function","title":"os.putenv/2","doc":"Sets a new `Value` for environment variable `VarName`.\n\nIf Unicode filename encoding is in effect (see the\n[`erl` manual page](`e:erts:erl_cmd.md#file_name_encoding`)), the strings\n`VarName` and `Value` can contain characters with codepoints > 255.\n\nOn Unix platforms, the environment is set using UTF-8 encoding if Unicode\nfilename translation is in effect. On Windows, the environment is set using wide\ncharacter interfaces.","ref":"os.html#putenv/2"},{"type":"function","title":"os.set_signal/2","doc":"Enables or disables OS signals.\n\nEach signal my be set to one of the following options:\n\n- **`ignore`** - This signal will be ignored.\n\n- **`default`** - This signal will use the default signal handler for the\n  operating system.\n\n- **`handle`** - This signal will notify\n  [`erl_signal_server`](kernel_app.md#erl_signal_server) when it is received by\n  the Erlang runtime system.","ref":"os.html#set_signal/2"},{"type":"function","title":"os.system_time/0","doc":"Returns the current [OS system time](`e:erts:time_correction.md#os-system-time`)\nin `native` [time unit](`t:erlang:time_unit/0`).\n\n> #### Note {: .info }\n>\n> This time is _not_ a monotonically increasing time.","ref":"os.html#system_time/0"},{"type":"function","title":"os.system_time/1","doc":"Returns the current [OS system time](`e:erts:time_correction.md#os-system-time`)\nconverted into the `Unit` passed as argument.\n\nCalling `os:system_time(Unit)` is equivalent to\n[`erlang:convert_time_unit`](`erlang:convert_time_unit/3`)([`os:system_time()`](`system_time/0`)`, native, Unit)`.\n\n> #### Note {: .info }\n>\n> This time is _not_ a monotonically increasing time.","ref":"os.html#system_time/1"},{"type":"function","title":"os.timestamp/0","doc":"Returns the current [OS system time](`e:erts:time_correction.md#os-system-time`)\nin the same format as `erlang:timestamp/0`.\n\nThe tuple can be used together with function `calendar:now_to_universal_time/1`\nor `calendar:now_to_local_time/1` to get calendar time. Using the calendar time,\ntogether with the `MicroSecs` part of the return tuple from this function,\nallows you to log time stamps in high resolution and consistent with the time in\n the rest of the OS.\n\nExample of code formatting a string in format \"DD Mon YYYY HH:MM:SS.mmmmmm\",\nwhere DD is the day of month, Mon is the textual month name, YYYY is the year,\nHH:MM:SS is the time, and mmmmmm is the microseconds in six positions:\n\n```erlang\n-module(print_time).\n-export([format_utc_timestamp/0]).\nformat_utc_timestamp() ->\n    TS = {_,_,Micro} = os:timestamp(),\n    {{Year,Month,Day},{Hour,Minute,Second}} =\ncalendar:now_to_universal_time(TS),\n    Mstr = element(Month,{\"Jan\",\"Feb\",\"Mar\",\"Apr\",\"May\",\"Jun\",\"Jul\",\n    \"Aug\",\"Sep\",\"Oct\",\"Nov\",\"Dec\"}),\n    io_lib:format(\"~2w ~s ~4w ~2w:~2..0w:~2..0w.~6..0w\",\n    [Day,Mstr,Year,Hour,Minute,Second,Micro]).\n```\n\nThis module can be used as follows:\n\n```erlang\n1> io:format(\"~s~n\",[print_time:format_utc_timestamp()]).\n29 Apr 2009  9:55:30.051711\n```\n\nOS system time can also be retrieved by `system_time/0` and `system_time/1`.","ref":"os.html#timestamp/0"},{"type":"function","title":"os.type/0","doc":"Returns the `Osfamily` and, in some cases, the `Osname` of the current OS.\n\nOn Unix, `Osname` has the same value as `uname -s` returns, but in lower case.\nFor example, on Solaris 1 and 2, it is `sunos`.\n\nOn Windows, `Osname` is `nt`.\n\n> #### Note {: .info }\n>\n> Think twice before using this function. Use module `m:filename` if you want to\n> inspect or build filenames in a portable way. Avoid matching on atom `Osname`.","ref":"os.html#type/0"},{"type":"function","title":"os.unsetenv/1","doc":"Deletes the environment variable `VarName`.\n\nIf Unicode filename encoding is in effect (see the\n[`erl` manual page](`e:erts:erl_cmd.md#file_name_encoding`)), the string\n`VarName` can contain characters with codepoints > 255.","ref":"os.html#unsetenv/1"},{"type":"function","title":"os.version/0","doc":"Returns the OS version. On most systems, this function returns a tuple, but a\nstring is returned instead if the system has versions that cannot be expressed\nas three numbers.\n\n> #### Note {: .info }\n>\n> Think twice before using this function. If you still need to use it, always\n> `call os:type()` first.","ref":"os.html#version/0"},{"type":"module","title":"auth","doc":"Erlang network authentication server.\n\nFor a description of the Magic Cookie system, refer\nto [Distributed Erlang](`e:system:distributed.md`) in the Erlang Reference\nManual.","ref":"auth.html"},{"type":"type","title":"auth.cookie/0","doc":"","ref":"auth.html#t:cookie/0"},{"type":"function","title":"auth.cookie/0","doc":"Use [`erlang:get_cookie()`](`erlang:get_cookie/0`) in ERTS instead.","ref":"auth.html#cookie/0"},{"type":"function","title":"auth.cookie/1","doc":"Use [`erlang:set_cookie(node(), Cookie)` in ERTS](`erlang:set_cookie/2`)\ninstead.","ref":"auth.html#cookie/1"},{"type":"function","title":"auth.is_auth/1","doc":"Returns `yes` if communication with `Node` is authorized.\n\nUse [`net_adm:ping(Node)`](`net_adm:ping/1`) instead.\n\nNotice that a connection to `Node` is established in this case. Returns `no` if\n`Node` does not exist or communication is not authorized (it has another cookie\nthan `auth` thinks it has).","ref":"auth.html#is_auth/1"},{"type":"function","title":"auth.node_cookie/1","doc":"Equivalent to [`node_cookie(Node, Cookie)`](`node_cookie/2`).","ref":"auth.html#node_cookie/1"},{"type":"function","title":"auth.node_cookie/2","doc":"Sets the magic cookie of `Node` to `Cookie` and verifies the status of the\nauthorization.\n\nEquivalent to calling [`erlang:set_cookie(Node, Cookie)`](`erlang:set_cookie/2`),\nfollowed by [`auth:is_auth(Node)`](`is_auth/1`).","ref":"auth.html#node_cookie/2"},{"type":"module","title":"erl_boot_server","doc":"Boot server for other Erlang machines.\n\nThis server is used to assist diskless Erlang nodes that fetch all Erlang code\nfrom another machine.\n\nThis server is used to fetch all code, including the start script, if an Erlang\nruntime system is started with command-line flag `-loader inet`. All hosts\nspecified with command-line flag `-hosts Host` must have one instance of this\nserver running.\n\nThis server can be started with the Kernel configuration parameter\n`start_boot_server`.\n\nThe `erl_boot_server` can read regular files and files in archives. See `m:code`\nand `m:erl_prim_loader` in ERTS.\n\n> #### Warning {: .warning }\n>\n> The support for loading code from archive files is experimental. It is\n> released before it is ready to obtain early feedback. The file format,\n> semantics, interfaces, and so on, can be changed in a future release.","ref":"erl_boot_server.html"},{"type":"module","title":"SEE ALSO - erl_boot_server","doc":"[`erts:init`](`m:init`), [`erts:erl_prim_loader`](`m:erl_prim_loader`)","ref":"erl_boot_server.html#module-see-also"},{"type":"function","title":"erl_boot_server.add_slave/1","doc":"Adds a `Slave` node to the list of allowed slave hosts.","ref":"erl_boot_server.html#add_slave/1"},{"type":"function","title":"erl_boot_server.delete_slave/1","doc":"Deletes a `Slave` node from the list of allowed slave hosts.","ref":"erl_boot_server.html#delete_slave/1"},{"type":"function","title":"erl_boot_server.start/1","doc":"Starts the boot server. `Slaves` is a list of IP addresses for hosts, which are\nallowed to use this server as a boot server.","ref":"erl_boot_server.html#start/1"},{"type":"function","title":"erl_boot_server.start_link/1","doc":"Starts the boot server and links to the caller. This function is used to start\nthe server if it is included in a supervision tree.","ref":"erl_boot_server.html#start_link/1"},{"type":"function","title":"erl_boot_server.which_slaves/0","doc":"Returns the current list of allowed slave hosts.","ref":"erl_boot_server.html#which_slaves/0"},{"type":"module","title":"erl_epmd","doc":"Erlang interface towards epmd\n\nThis module communicates with the EPMD daemon, see [epmd](`e:erts:epmd_cmd.md`).\nTo implement your own epmd module please see\n[ERTS User's Guide: How to Implement an Alternative Node Discovery for Erlang Distribution](`e:erts:alt_disco.md`)","ref":"erl_epmd.html"},{"type":"function","title":"erl_epmd.address_please/3","doc":"Called by the distribution module to resolves the `Host` to an IP address of a\nremote node.\n\nAs an optimization this function may also return the port and version of the\nremote node. If port and version are returned `port_please/3` will not be\ncalled.","ref":"erl_epmd.html#address_please/3"},{"type":"function","title":"erl_epmd.listen_port_please/2","doc":"Called by the distribution module to get which port the local node should listen\nto when accepting new distribution requests.","ref":"erl_epmd.html#listen_port_please/2"},{"type":"function","title":"erl_epmd.names/1","doc":"Called by [`net_adm:names/0`](`m:net_adm`). `Host` defaults to the localhost.\nReturns the names and associated port numbers of the Erlang nodes that `epmd`\nregistered at the specified host. Returns `{error, address}` if `epmd` is not\noperational.\n\n_Example:_\n\n```erlang\n(arne@dunn)1> erl_epmd:names(localhost).\n{ok,[{\"arne\",40262}]}\n```","ref":"erl_epmd.html#names/1"},{"type":"function","title":"erl_epmd.port_please/2","doc":"Equivalent to  port_please(Name, Host, infinity) .","ref":"erl_epmd.html#port_please/2"},{"type":"function","title":"erl_epmd.port_please/3","doc":"Requests the distribution port for the given node of an EPMD instance. Together\nwith the port it returns a distribution protocol version which has been 5 since\nErlang/OTP R6.","ref":"erl_epmd.html#port_please/3"},{"type":"function","title":"erl_epmd.register_node/2","doc":"Equivalent to  register_node(Name, Port, inet) .","ref":"erl_epmd.html#register_node/2"},{"type":"function","title":"erl_epmd.register_node/3","doc":"Registers the node with `epmd` and tells epmd what port will be used for the\ncurrent node. It returns a creation number. This number is incremented on each\nregister to help differentiate a new node instance connecting to epmd with the\nsame name.\n\nAfter the node has successfully registered with epmd it will automatically\nattempt reconnect to the daemon if the connection is broken.","ref":"erl_epmd.html#register_node/3"},{"type":"function","title":"erl_epmd.start_link/0","doc":"This function is invoked as this module is added as a child of the\n`erl_distribution` supervisor.","ref":"erl_epmd.html#start_link/0"},{"type":"module","title":"erpc","doc":"Enhanced Remote Procedure Call\n\nThis module provide services similar to Remote Procedure Calls. A remote\nprocedure call is a method to call a function on a remote node and collect the\nanswer. It is used for collecting information on a remote node, or for running a\nfunction with some specific side effects on the remote node.\n\nThis is an enhanced subset of the operations provided by the `m:rpc` module.\nEnhanced in the sense that it makes it possible to distinguish between returned\nvalue, raised exceptions, and other errors. `erpc` also has better performance\nand scalability than the original `rpc` implementation. However, current `rpc`\nmodule will utilize `erpc` in order to also provide these properties when\npossible.\n\nIn order for an `erpc` operation to succeed, the remote node also needs to\nsupport `erpc`. Typically only ordinary Erlang nodes as of OTP 23 have `erpc`\nsupport.\n\nNote that it is up to the user to ensure that correct code to execute via `erpc`\nis available on the involved nodes.\n\n> #### Note {: .info }\n>\n> For some important information about distributed signals, see the\n> [Blocking Signaling Over Distribution](`e:system:ref_man_processes.md#blocking-signaling-over-distribution`)\n> section in the _Processes_ chapter of the _Erlang Reference Manual_. Blocking\n> signaling can, for example, cause timeouts in `erpc` to be significantly\n> delayed.","ref":"erpc.html"},{"type":"function","title":"erpc.call/2","doc":"Equivalent to  call(Node, Fun, #{timeout => infinity}) .","ref":"erpc.html#call/2"},{"type":"function","title":"erpc.call/3","doc":"Equivalent to\n[`erpc:call(Node, erlang, apply, [Fun,[]], #{timeout => Timeout})`](`call/5`).\n\nMay raise all the same exceptions as [`call/5`](`call/5`) plus an `{erpc, badarg}`\n`error` exception if `Fun` is not a fun of zero arity.","ref":"erpc.html#call/3"},{"type":"function","title":"erpc.call/4","doc":"Equivalent to  call(Node, Module, Function, Args, #{timeout => infinity}) .","ref":"erpc.html#call/4"},{"type":"function","title":"erpc.call/5","doc":"Evaluates [`apply(Module, Function, Args)`](`apply/3`) on node `Node` and\nreturns the corresponding value `Result`.\n\n`TimeoutOrOptions` can be either a [`timeout time`](`t:timeout_time/0`) or a\n[`call options`](`t:call_options/0`) map (since OTP 28.0).\n\nThe `call()` function only returns if the applied function successfully returned\nwithout raising any uncaught exceptions, the operation did not time out, and no\nfailures occurred. In all other cases an exception is raised. The following\nexceptions, listed by exception class, can currently be raised by `call()`:\n\n- **`throw`** - The applied function called [`throw(Value)`](`throw/1`) and did\n  not catch this exception. The exception reason `Value` equals the argument\n  passed to [`throw/1`](`throw/1`).\n\n- **`exit`** - Exception reason:\n\n  - **`{exception, ExitReason}`** - The applied function called\n    [`exit(ExitReason)`](`exit/1`) and did not catch this exception. The exit\n    reason `ExitReason` equals the argument passed to [`exit/1`](`exit/1`).\n\n  - **`{signal, ExitReason}`** - The process that applied the function received\n    an exit signal and terminated due to this signal. The process terminated\n    with exit reason `ExitReason`.\n\n- **`error`** - Exception reason:\n\n  - **`{exception, ErrorReason, StackTrace}`** - A runtime error occurred which\n    raised an error exception while applying the function, and the applied\n    function did not catch the exception. The error reason `ErrorReason`\n    indicates the type of error that occurred. `StackTrace` is formatted as when\n    caught in a `try/catch` construct. The `StackTrace` is limited to the\n    applied function and functions called by it.\n\n  - **`{erpc, ERpcErrorReason}`** - The `erpc` operation failed. The following\n    `ERpcErrorReason`s are the most common ones:\n\n    - **`badarg`** - If any one of these are true:\n\n      - `Node` is not an atom.\n      - `Module` is not an atom.\n      - `Function` is not an atom.\n      - `Args` is not a list. Note that the list is not verified to be a proper\n        list at the client side.\n      - `Timeout` is invalid.\n\n    - **`noconnection`** - The connection to `Node` was lost or could not be\n      established. The function may or may not be applied.\n\n    - **`system_limit`** - The `erpc` operation failed due to some system limit\n      being reached. This typically due to failure to create a process on the\n      remote node `Node`, but can be other things as well.\n\n    - **`timeout`** - The `erpc` operation timed out. The function may or may\n      not be applied.\n\n    - **`notsup`** - The remote node `Node` does not support this `erpc`\n      operation.\n\nIf the `erpc` operation fails, but it is unknown if the function is/will be\napplied (that is, a timeout or a connection loss), the caller will not receive\nany further information about the result if/when the applied function completes.\nIf the applied function explicitly communicates with the calling process, such\ncommunication may, of course, reach the calling process.\n\n> #### Note {: .info }\n>\n> If the `always_spawn` option is `false` (which is the default), you cannot make\n> _any_ assumptions about the process that will perform the `apply()`. It may be\n> the calling process itself, or a freshly spawned process.","ref":"erpc.html#call/5"},{"type":"type","title":"erpc.call_options/0","doc":"Options to be used in [`call/3,5`](`call/5`) and\n[`multicall/3,5`](`multicall/5`) functions.\n\n- **`timeout`** - Upper time limit for call operations to complete, see\n  `t:timeout_time/0`. Default: `infinity`.\n\n- **`always_spawn`** - If `true`, the `apply()` will _always_ be performed\n  in a freshly spawned process. If `false`, the calling process _may_ be\n  used instead, if possible. Default: `false`.","ref":"erpc.html#t:call_options/0"},{"type":"function","title":"erpc.cast/2","doc":"Equivalent to [`erpc:cast(Node,erlang,apply,[Fun,[]])`](`cast/4`).\n\n[`cast/2`](`cast/2`) fails with an `{erpc, badarg}` `error` exception if:\n\n- `Node` is not an atom.\n- `Fun` is not a a fun of zero arity.","ref":"erpc.html#cast/2"},{"type":"function","title":"erpc.cast/4","doc":"Evaluates [`apply(Module, Function, Args)`](`apply/3`) on node `Node`. No\nresponse is delivered to the calling process. `cast()` returns immediately after\nthe cast request has been sent. Any failures beside bad arguments are silently\nignored.\n\n[`cast/4`](`cast/4`) fails with an `{erpc, badarg}` `error` exception if:\n\n- `Node` is not an atom.\n- `Module` is not an atom.\n- `Function` is not an atom.\n- `Args` is not a list. Note that the list is not verified to be a proper list\n  at the client side.","ref":"erpc.html#cast/4"},{"type":"type","title":"erpc.caught_call_exception/0","doc":"","ref":"erpc.html#t:caught_call_exception/0"},{"type":"function","title":"erpc.check_response/2","doc":"Check if a message is a response to a `call` request previously made by the\ncalling process using `send_request/4`.\n\n`RequestId` should be the value returned from the previously made\n[`send_request/4`](`send_request/4`) call, and the\ncorresponding response should not already have been received and handled to\ncompletion by [`check_response/2`](`check_response/2`), `receive_response/2`, or\n`wait_response/2`. `Message` is the message to check.\n\nIf `Message` does not correspond to the response, the atom `no_response` is\nreturned. If `Message` corresponds to the response, the `call` operation is\ncompleted and either the result is returned as `{response, Result}` where\n`Result` corresponds to the value returned from the applied function or an\nexception is raised. The exceptions that can be raised corresponds to the same\nexceptions as can be raised by `call/4`. That is, no `{erpc, timeout}` `error`\nexception can be raised. `check_response()` will fail with an `{erpc, badarg}`\nexception if/when an invalid `RequestId` is detected.\n\nIf the `erpc` operation fails, but it is unknown if the function is/will be\napplied (that is, a connection loss), the caller will not receive any further\ninformation about the result if/when the applied function completes. If the\napplied function explicitly communicates with the calling process, such\ncommunication may, of course, reach the calling process.","ref":"erpc.html#check_response/2"},{"type":"function","title":"erpc.check_response/3","doc":"Check if a message is a response to a `call` request corresponding to a request\nidentifier saved in `RequestIdCollection`. All request identifiers of\n`RequestIdCollection` must correspond to requests that have been made using\n`send_request/4` or `send_request/6`, and all requests must have been made by\nthe process calling this function.\n\n`Label` is the label associated with the request identifier of the request that\nthe response corresponds to. A request identifier is associated with a label\nwhen [adding a request identifier](`reqids_add/3`) in a\n[request identifier collection](`t:request_id_collection/0`), or when sending\nthe request using `send_request/6`.\n\nCompared to `check_response/2`, the returned result associated with a specific\nrequest identifier or an exception associated with a specific request identifier\nwill be wrapped in a 3-tuple. The first element of this tuple equals the value\nthat would have been produced by [`check_response/2`](`check_response/2`), the\nsecond element equals the `Label` associated with the specific request\nidentifier, and the third element `NewRequestIdCollection` is a possibly\nmodified request identifier collection. The `error` exception `{erpc, badarg}`\nis not associated with any specific request identifier, and will hence not be\nwrapped.\n\nIf `RequestIdCollection` is empty, the atom `no_request` will be returned. If\n`Message` does not correspond to any of the request identifiers in\n`RequestIdCollection`, the atom `no_response` is returned.\n\nIf `Delete` equals `true`, the association with `Label` will have been deleted\nfrom `RequestIdCollection` in the resulting `NewRequestIdCollection`. If\n`Delete` equals `false`, `NewRequestIdCollection` will equal\n`RequestIdCollection`. Note that deleting an association is not for free and\nthat a collection containing already handled requests can still be used by\nsubsequent calls to [`check_response/3`](`check_response/3`),\n`receive_response/3`, and `wait_response/3`. However, without deleting handled\nassociations, the above calls will not be able to detect when there are no more\noutstanding requests to handle, so you will have to keep track of this some\nother way than relying on a `no_request` return. Note that if you pass a\ncollection only containing associations of already handled or abandoned requests\nto [`check_response/3`](`check_response/3`), it will always return\n`no_response`.\n\nNote that a response might have been consumed uppon an `{erpc, badarg}`\nexception and if so, will be lost for ever.","ref":"erpc.html#check_response/3"},{"type":"function","title":"erpc.multicall/2","doc":"Equivalent to  multicall(Nodes, Fun, #{timeout => infinity}) .","ref":"erpc.html#multicall/2"},{"type":"function","title":"erpc.multicall/3","doc":"Equivalent to\n[`erpc:multicall(Nodes, erlang, apply, [Fun,[]], #{timeout => Timeout})`](`multicall/5`).\n\nMay raise all the same exceptions as [`multicall/5`](`multicall/5`) plus an\n`{erpc, badarg}` `error` exception if `Fun` is not a fun of zero arity.","ref":"erpc.html#multicall/3"},{"type":"function","title":"erpc.multicall/4","doc":"Equivalent to  multicall(Nodes, Module, Function, Args, #{timeout => infinity}) .","ref":"erpc.html#multicall/4"},{"type":"function","title":"erpc.multicall/5","doc":"Performs multiple `call` operations in parallel on multiple nodes.\n\nThat is, evaluates [`apply(Module, Function, Args)`](`apply/3`) on the nodes `Nodes` in\nparallel.\n\n`TimeoutOrOptions` can be either a [`timeout time`](`t:timeout_time/0`) or a\n[`call options`](`t:call_options/0`) map (since OTP 28.0).\n\nThe result is returned as a list where the result from each node is\nplaced at the same position as the node name is placed in `Nodes`. Each item in\nthe resulting list is formatted as either:\n\n- **`{ok, Result}`** - The `call` operation for this specific node returned\n  `Result`.\n\n- **`{Class, ExceptionReason}`** - The `call` operation for this specific node\n  raised an exception of class `Class` with exception reason `ExceptionReason`.\n  These correspond to the exceptions that `call/5` can raise.\n\n[`multicall/5`](`multicall/5`) fails with an `{erpc, badarg}` `error` exception\nif:\n\n- `Nodes` is not a proper list of atoms. Note that some requests may already\n  have been sent when the failure occurs. That is, the function may or may not\n  be applied on some nodes.\n- `Module` is not an atom.\n- `Function` is not an atom.\n- `Args` is not a list. Note that the list is not verified to be a proper list\n  at the client side.\n\nThe call `erpc:multicall(Nodes, Module, Function, Args)` is equivalent to the\ncall `erpc:multicall(Nodes, Module, Function, Args, infinity)`. These calls are\nalso equivalent to calling `my_multicall(Nodes, Module, Function, Args)` below\nif one disregard performance and failure behavior. `multicall()` can utilize a\nselective receive optimization which removes the need to scan the message queue\nfrom the beginning in order to find a matching message. The\n`send_request()/receive_response()` combination can, however, not utilize this\noptimization.\n\n```erlang\nmy_multicall(Nodes, Module, Function, Args) ->\n  ReqIds = lists:map(fun (Node) ->\n                       erpc:send_request(Node, Module, Function, Args)\n                     end,\n                     Nodes),\n  lists:map(fun (ReqId) ->\n              try\n                {ok, erpc:receive_response(ReqId, infinity)}\n              catch\n                Class:Reason ->\n                  {Class, Reason}\n              end\n            end,\n            ReqIds).\n```\n\nIf an `erpc` operation fails, but it is unknown if the function is/will be\napplied (that is, a timeout, connection loss, or an improper `Nodes` list), the\ncaller will not receive any further information about the result if/when the\napplied function completes. If the applied function communicates with the\ncalling process, such communication may, of course, reach the calling process.\n\n> #### Note {: .info }\n>\n> If the `always_spawn` option is `false` (which is the default), you cannot make\n> _any_ assumptions about the processes that will perform the `apply()`s. It may be\n> the calling process itself, or freshly spawned processes, or a mix of both.","ref":"erpc.html#multicall/5"},{"type":"function","title":"erpc.multicast/2","doc":"Equivalent to\n[`erpc:multicast(Nodes,erlang,apply,[Fun,[]])`](`multicast/4`).\n\n[`multicast/2`](`multicast/2`) fails with an `{erpc, badarg}` `error` exception\nif:\n\n- `Nodes` is not a proper list of atoms.\n- `Fun` is not a a fun of zero arity.","ref":"erpc.html#multicast/2"},{"type":"function","title":"erpc.multicast/4","doc":"Evaluates [`apply(Module, Function, Args)`](`apply/3`) on the nodes `Nodes`. No\nresponse is delivered to the calling process. `multicast()` returns immediately\nafter the cast requests have been sent. Any failures beside bad arguments are\nsilently ignored.\n\n[`multicast/4`](`multicast/4`) fails with an `{erpc, badarg}` `error` exception\nif:\n\n- `Nodes` is not a proper list of atoms. Note that some requests may already\n  have been sent when the failure occurs. That is, the function may or may not\n  be applied on some nodes.\n- `Module` is not an atom.\n- `Function` is not an atom.\n- `Args` is not a list. Note that the list is not verified to be a proper list\n  at the client side.","ref":"erpc.html#multicast/4"},{"type":"function","title":"erpc.receive_response/1","doc":"Equivalent to  receive_response(RequestId, infinity) .","ref":"erpc.html#receive_response/1"},{"type":"function","title":"erpc.receive_response/2","doc":"Receive a response to a `call` request previously made by the calling process\nusing `send_request/4`.\n\n`RequestId` should be the value returned from the\npreviously made [`send_request/4`](`send_request/4`) call, and the corresponding\nresponse should not already have been received and handled to completion by\n`receive_response()`, [`check_response/4`](`check_response/2`), or\n[`wait_response/4`](`wait_response/2`).\n\n`Timeout` sets an upper time limit on how long to wait for a response. If the\noperation times out, the request identified by `RequestId` will be abandoned,\nthen an `{erpc, timeout}` `error` exception will be raised. That is, no response\ncorresponding to the request will ever be received after a timeout. If a\nresponse is received, the `call` operation is completed and either the result is\nreturned or an exception is raised. The exceptions that can be raised\ncorresponds to the same exceptions as can be raised by `call/5`.\n[`receive_response/2`](`receive_response/2`) will fail with an `{erpc, badarg}`\nexception if/when an invalid `RequestId` is detected or if an invalid `Timeout`\nis passed.\n\nA call to the function `my_call(Node, Module, Function, Args, Timeout)` below is\nequivalent to the call\n[`erpc:call(Node, Module, Function, Args, Timeout)`](`call/5`) if one disregards\nperformance. `call()` can utilize a selective receive optimization which removes\nthe need to scan the message queue from the beginning in order to find a\nmatching message. The `send_request()/receive_response()` combination can,\nhowever, not utilize this optimization.\n\n```erlang\nmy_call(Node, Module, Function, Args, Timeout) ->\n  RequestId = erpc:send_request(Node, Module, Function, Args),\n  erpc:receive_response(RequestId, Timeout).\n```\n\nIf the `erpc` operation fails, but it is unknown if the function is/will be\napplied (that is, a timeout, or a connection loss), the caller will not receive\nany further information about the result if/when the applied function completes.\nIf the applied function explicitly communicates with the calling process, such\ncommunication may, of course, reach the calling process.","ref":"erpc.html#receive_response/2"},{"type":"function","title":"erpc.receive_response/3","doc":"Receive a response to a `call` request corresponding to a request identifier\nsaved in `RequestIdCollection`. All request identifiers of `RequestIdCollection`\nmust correspond to requests that have been made using `send_request/4` or\n`send_request/6`, and all requests must have been made by the process calling\nthis function.\n\n`Label` is the label associated with the request identifier of the request that\nthe response corresponds to. A request identifier is associated with a label\nwhen [adding a request identifier](`reqids_add/3`) in a\n[request identifier collection](`t:request_id_collection/0`), or when sending\nthe request using `send_request/6`.\n\nCompared to `receive_response/2`, the returned result associated with a specific\nrequest identifier or an exception associated with a specific request identifier\nwill be wrapped in a 3-tuple. The first element of this tuple equals the value\nthat would have been produced by [`receive_response/2`](`receive_response/2`),\nthe second element equals the `Label` associated with the specific request\nidentifier, and the third element `NewRequestIdCollection` is a possibly\nmodified request identifier collection. The `error` exceptions `{erpc, badarg}`\nand `{erpc, timeout}` are not associated with any specific request identifiers,\nand will hence not be wrapped.\n\nIf `RequestIdCollection` is empty, the atom `no_request` will be returned.\n\nIf the operation times out, all requests identified by `RequestIdCollection`\nwill be abandoned, then an `{erpc, timeout}` `error` exception will be raised.\nThat is, no responses corresponding to any of the request identifiers in\n`RequestIdCollection` will ever be received after a timeout. The difference\nbetween [`receive_response/3`](`receive_response/3`) and `wait_response/3` is\nthat [`receive_response/3`](`receive_response/3`) abandons the requests at\ntimeout so that any potential future responses are ignored, while\n[`wait_response/3`](`wait_response/3`) does not.\n\nIf `Delete` equals `true`, the association with `Label` will have been deleted\nfrom `RequestIdCollection` in the resulting `NewRequestIdCollection`. If\n`Delete` equals `false`, `NewRequestIdCollection` will equal\n`RequestIdCollection`. Note that deleting an association is not for free and\nthat a collection containing already handled requests can still be used by\nsubsequent calls to [`receive_response/3`](`receive_response/3`),\n`check_response/3`, and `wait_response/3`. However, without deleting handled\nassociations, the above calls will not be able to detect when there are no more\noutstanding requests to handle, so you will have to keep track of this some\nother way than relying on a `no_request` return. Note that if you pass a\ncollection only containing associations of already handled or abandoned requests\nto [`receive_response/3`](`receive_response/3`), it will always block until a\ntimeout determined by `Timeout` is triggered.\n\nNote that a response might have been consumed uppon an `{erpc, badarg}`\nexception and if so, will be lost for ever.","ref":"erpc.html#receive_response/3"},{"type":"function","title":"erpc.reqids_add/3","doc":"Saves `RequestId` and associates a `Label` with the request identifier by adding\nthis information to `RequestIdCollection` and returning the resulting request\nidentifier collection.","ref":"erpc.html#reqids_add/3"},{"type":"function","title":"erpc.reqids_new/0","doc":"Returns a new empty request identifier collection. A request identifier\ncollection can be utilized in order the handle multiple outstanding requests.\n\nRequest identifiers of requests made by `send_request/4` can be saved in a\nrequest identifier collection using `reqids_add/3`. Such a collection of request\nidentifiers can later be used in order to get one response corresponding to a\nrequest in the collection by passing the collection as argument to\n`check_response/3`, `receive_response/3`, and `wait_response/3`.\n\n`reqids_size/1` can be used to determine the amount of request identifiers in a\nrequest identifier collection.","ref":"erpc.html#reqids_new/0"},{"type":"function","title":"erpc.reqids_size/1","doc":"Returns the amount of request identifiers saved in `RequestIdCollection`.","ref":"erpc.html#reqids_size/1"},{"type":"function","title":"erpc.reqids_to_list/1","doc":"Returns a list of `{RequestId, Label}` tuples which corresponds to all request\nidentifiers with their associated labels present in the `RequestIdCollection`\ncollection.","ref":"erpc.html#reqids_to_list/1"},{"type":"opaque","title":"erpc.request_id/0","doc":"An opaque request identifier. For more information see `send_request/4`.","ref":"erpc.html#t:request_id/0"},{"type":"opaque","title":"erpc.request_id_collection/0","doc":"An opaque collection of request identifiers (`t:request_id/0`) where each\nrequest identifier can be associated with a label chosen by the user. For more\ninformation see `reqids_new/0`.","ref":"erpc.html#t:request_id_collection/0"},{"type":"function","title":"erpc.send_request/2","doc":"Equivalent to\n[`erpc:send_request(Node, erlang, apply, [Fun, []])`](`send_request/4`).\n\nFails with an `{erpc, badarg}` `error` exception if:\n\n- `Node` is not an atom.\n- `Fun` is not a fun of zero arity.","ref":"erpc.html#send_request/2"},{"type":"function","title":"erpc.send_request/4","doc":"Send an asynchronous `call` request to the node `Node`.\n\n[`send_request/4`](`send_request/4`) returns a request identifier that later is\nto be passed to either `receive_response/2`, `wait_response/2`, or,\n`check_response/2` in order to get the response of the call request. Besides\npassing the request identifier directly to these functions, it can also be added\nin a request identifier collection using `reqids_add/3`. Such a collection of\nrequest identifiers can later be used in order to get one response corresponding\nto a request in the collection by passing the collection as argument to\n`receive_response/3`, `wait_response/3`, or, `check_response/3`. If you are\nabout to save the request identifier in a request identifier collection, you may\nwant to consider using `send_request/6` instead.\n\nA call to the function `my_call(Node, Module, Function, Args, Timeout)` below is\nequivalent to the call\n[`erpc:call(Node, Module, Function, Args, Timeout)`](`call/5`) if one disregards\nperformance. `call()` can utilize a selective receive optimization which removes\nthe need to scan the message queue from the beginning in order to find a\nmatching message. The `send_request()/receive_response()` combination can,\nhowever, not utilize this optimization.\n\n```erlang\nmy_call(Node, Module, Function, Args, Timeout) ->\n  RequestId = erpc:send_request(Node, Module, Function, Args),\n  erpc:receive_response(RequestId, Timeout).\n```\n\nFails with an `{erpc, badarg}` `error` exception if:\n\n- `Node` is not an atom.\n- `Module` is not an atom.\n- `Function` is not an atom.\n- `Args` is not a list. Note that the list is not verified to be a proper list\n  at the client side.\n\nEquivalent to\n[`erpc:send_request(Node, erlang, apply, [Fun,[]]), Label, RequestIdCollection)`](`send_request/6`).\n\nFails with an `{erpc, badarg}` `error` exception if:\n\n- `Node` is not an atom.\n- `Fun` is not a fun of zero arity.\n- `RequestIdCollection` is detected not to be request identifier collection.","ref":"erpc.html#send_request/4"},{"type":"function","title":"erpc.send_request/6","doc":"Send an asynchronous `call` request to the node `Node`. The `Label` will be\nassociated with the request identifier of the operation and added to the\nreturned request identifier collection `NewRequestIdCollection`. The collection\ncan later be used in order to get one response corresponding to a request in the\ncollection by passing the collection as argument to `receive_response/3`,\n`wait_response/3`, or, `check_response/3`.\n\nEquivalent to\n[`erpc:reqids_add`](`reqids_add/3`)([`erpc:send_request`](`send_request/4`)`(Node, Module, Function, Args), Label, RequestIdCollection)`,\nbut calling [`send_request/6`](`send_request/6`) is slightly more efficient.\n\nFails with an `{erpc, badarg}` `error` exception if:\n\n- `Node` is not an atom.\n- `Module` is not an atom.\n- `Function` is not an atom.\n- `Args` is not a list. Note that the list is not verified to be a proper list\n  at the client side.\n- `RequestIdCollection` is detected not to be request identifier collection.","ref":"erpc.html#send_request/6"},{"type":"type","title":"erpc.stack_item/0","doc":"","ref":"erpc.html#t:stack_item/0"},{"type":"type","title":"erpc.timeout_time/0","doc":"The timeout time used by erpc functions.\n\nThe value can be:\n\n- **`0..4294967295`** - Timeout relative to current time in milliseconds.\n\n- **`infinity`** - Infinite timeout. That is, the operation will never time out.\n\n- **`{abs, Timeout}`** - An absolute\n  [Erlang monotonic time](`erlang:monotonic_time/1`) timeout in milliseconds.\n  That is, the operation will time out when\n  [`erlang:monotonic_time(millisecond)`](`erlang:monotonic_time/1`) returns a\n  value larger than or equal to `Timeout`. `Timeout` is not allowed to identify\n  a time further into the future than `4294967295` milliseconds. Identifying the\n  timeout using an absolute timeout value is especially handy when you have a\n  deadline for responses corresponding to a complete collection of requests\n  (`t:request_id_collection/0`), since you do not have to recalculate the\n  relative time until the deadline over and over again.","ref":"erpc.html#t:timeout_time/0"},{"type":"function","title":"erpc.wait_response/1","doc":"Equivalent to [`erpc:wait_response(RequestId, 0)`](`wait_response/2`).\nThat is, poll for a response message to a `call` request previously made by the\ncalling process.","ref":"erpc.html#wait_response/1"},{"type":"function","title":"erpc.wait_response/2","doc":"Wait or poll for a response message to a `call` request previously made by the\ncalling process using `send_request/4`.\n\n`RequestId` should be the value returned from the previously made `send_request()`\ncall, and the corresponding response should not already have been received and\nhandled to completion by `check_response/2`, `receive_response/2`, or `wait_response()`.\n\n`WaitTime` sets an upper time limit on how long to wait for a response. If no\nresponse is received before the `WaitTime` timeout has triggered, the atom\n`no_response` is returned. It is valid to continue waiting for a response as\nmany times as needed up until a response has been received and completed by\n`check_response()`, `receive_response()`, or `wait_response()`. If a response is\nreceived, the `call` operation is completed and either the result is returned as\n`{response, Result}` where `Result` corresponds to the value returned from the\napplied function or an exception is raised. The exceptions that can be raised\ncorresponds to the same exceptions as can be raised by `call/4`. That is, no\n`{erpc, timeout}` `error` exception can be raised.\n[`wait_response/2`](`wait_response/2`) will fail with an `{erpc, badarg}`\nexception if/when an invalid `RequestId` is detected or if an invalid `WaitTime`\nis passed.\n\nIf the `erpc` operation fails, but it is unknown if the function is/will be\napplied (that is, a too large wait time value, or a connection loss), the caller\nwill not receive any further information about the result if/when the applied\nfunction completes. If the applied function explicitly communicates with the\ncalling process, such communication may, of course, reach the calling process.","ref":"erpc.html#wait_response/2"},{"type":"function","title":"erpc.wait_response/3","doc":"Wait or poll for a response to a `call` request corresponding to a request\nidentifier saved in `RequestIdCollection`. All request identifiers of\n`RequestIdCollection` must correspond to requests that have been made using\n`send_request/4` or `send_request/6`, and all requests must have been made by\nthe process calling this function.\n\n`Label` is the label associated with the request identifier of the request that\nthe response corresponds to. A request identifier is associated with a label\nwhen [adding a request identifier](`reqids_add/3`) in a\n[request identifier collection](`t:request_id_collection/0`), or when sending\nthe request using `send_request/6`.\n\nCompared to `wait_response/2`, the returned result associated with a specific\nrequest identifier or an exception associated with a specific request identifier\nwill be wrapped in a 3-tuple. The first element of this tuple equals the value\nthat would have been produced by [`wait_response/2`](`wait_response/2`), the\nsecond element equals the `Label` associated with the specific request\nidentifier, and the third element `NewRequestIdCollection` is a possibly\nmodified request identifier collection. The `error` exception `{erpc, badarg}`\nis not associated with any specific request identifier, and will hence not be\nwrapped.\n\nIf `RequestIdCollection` is empty, `no_request` will be returned. If no response\nis received before the `WaitTime` timeout has triggered, the atom `no_response`\nis returned. It is valid to continue waiting for a response as many times as\nneeded up until a response has been received and completed by\n`check_response()`, `receive_response()`, or `wait_response()`. The difference\nbetween `receive_response/3` and [`wait_response/3`](`wait_response/3`) is that\n[`receive_response/3`](`receive_response/3`) abandons requests at timeout so\nthat any potential future responses are ignored, while\n[`wait_response/3`](`wait_response/3`) does not.\n\nIf `Delete` equals `true`, the association with `Label` will have been deleted\nfrom `RequestIdCollection` in the resulting `NewRequestIdCollection`. If\n`Delete` equals `false`, `NewRequestIdCollection` will equal\n`RequestIdCollection`. Note that deleting an association is not for free and\nthat a collection containing already handled requests can still be used by\nsubsequent calls to [`wait_response/3`](`wait_response/3`), `check_response/3`,\nand `receive_response/3`. However, without deleting handled associations, the\nabove calls will not be able to detect when there are no more outstanding\nrequests to handle, so you will have to keep track of this some other way than\nrelying on a `no_request` return. Note that if you pass a collection only\ncontaining associations of already handled or abandoned requests to\n[`wait_response/3`](`wait_response/3`), it will always block until a timeout\ndetermined by `WaitTime` is triggered and then return `no_response`.\n\nNote that a response might have been consumed uppon an `{erpc, badarg}`\nexception and if so, will be lost for ever.","ref":"erpc.html#wait_response/3"},{"type":"module","title":"global","doc":"A global name registration facility.\n\nThis module consists of the following services:\n\n- Registration of global names\n- Global locks\n- Maintenance of the fully connected network\n\n[](){: #prevent_overlapping_partitions }\n\nAs of OTP 25, `global` will by default prevent overlapping partitions due to\nnetwork issues by actively disconnecting from nodes that reports that they have\nlost connections to other nodes. This will cause fully connected partitions to\nform instead of leaving the network in a state with overlapping partitions.\n\n> #### Warning {: .warning }\n>\n> Prevention of overlapping partitions can be disabled using the\n> [`prevent_overlapping_partitions`](kernel_app.md#prevent_overlapping_partitions)\n> Kernel parameter, making `global` behave like it used to do. This is,\n> however, problematic for all applications expecting a fully connected network\n> to be provided, such as for example `mnesia`, but also for `global` itself. A\n> network of overlapping partitions might cause the internal state of `global`\n> to become inconsistent. Such an inconsistency can remain even after such\n> partitions have been brought together to form a fully connected network again.\n> The effect on other applications that expects that a fully connected network\n> is maintained may vary, but they might misbehave in very subtle hard to detect\n> ways during such a partitioning. Since you might get hard to detect issues\n> without this fix, you are _strongly_ advised _not_ to disable this fix. Also\n> note that this fix _has_ to be enabled on _all_ nodes in the network in order\n> to work properly.\n\n> #### Note {: .info }\n>\n> None of the above services will be reliably delivered unless both of the\n> kernel parameters [`connect_all`](kernel_app.md#connect_all) and\n> [`prevent_overlapping_partitions`](kernel_app.md#prevent_overlapping_partitions)\n> are enabled. Calls to the `global` API will, however, _not_ fail even though\n> one or both of them are disabled. You will just get unreliable results.\n\nThese services are controlled through the process `global_name_server` that\nexists on every node. The global name server starts automatically when a node is\nstarted. With the term _global_ is meant over a system consisting of many Erlang\nnodes.\n\nThe ability to globally register names is a central concept in the programming\nof distributed Erlang systems. In this module, the equivalent of the\n[`register/2`](`register/2`) and [`whereis/1`](`whereis/1`) BIFs (for local name\nregistration) are provided, but for a network of Erlang nodes. A registered name\nis an alias for a process identifier (pid). The global name server monitors\nglobally registered pids. If a process terminates, the name is also globally\nunregistered.\n\nThe registered names are stored in replica global name tables on every node.\nThere is no central storage point. Thus, the translation of a name to a pid is\nfast, as it is always done locally. For any action resulting in a change to the\nglobal name table, all tables on other nodes are automatically updated.\n\nGlobal locks have lock identities and are set on a specific resource. For\nexample, the specified resource can be a pid. When a global lock is set, access\nto the locked resource is denied for all resources other than the lock\nrequester.\n\nBoth the registration and lock services are atomic. All nodes involved in these\nactions have the same view of the information.\n\nThe global name server also performs the critical task of continuously\nmonitoring changes in node configuration. If a node that runs a globally\nregistered process goes down, the name is globally unregistered. To this end,\nthe global name server subscribes to `nodeup` and `nodedown` messages sent from\nmodule `net_kernel`. Relevant Kernel application variables in this context are\n[`net_setuptime`](kernel_app.md#net_setuptime), [`net_ticktime`](kernel_app.md#net_ticktime),\nand [`dist_auto_connect`](kernel_app.md#dist_auto_connect).\n\nThe name server also maintains a fully connected network. For example, if node\n`N1` connects to node `N2` (which is already connected to `N3`), the global name\nservers on the nodes `N1` and `N3` ensure that also `N1` and `N3` are connected.\nIn this case, the name registration service cannot be used, but the lock\nmechanism still works.\n\nIf the global name server fails to connect nodes (`N1` and `N3` in the example),\na warning event is sent to the error logger. The presence of such an event does\nnot exclude the nodes to connect later (you can, for example, try command\n`rpc:call(N1, net_adm, ping, [N2])` in the Erlang shell), but it indicates a\nnetwork problem.\n\n> #### Note {: .info }\n>\n> If the fully connected network is not set up properly, try first to increase\n> the value of `net_setuptime`.","ref":"global.html"},{"type":"module","title":"See Also - global","doc":"`m:global_group`, `m:net_kernel`","ref":"global.html#module-see-also"},{"type":"function","title":"global.del_lock/1","doc":"Equivalent to  del_lock(Id, [node() | nodes()]) .","ref":"global.html#del_lock/1"},{"type":"function","title":"global.del_lock/2","doc":"Deletes the lock `Id` synchronously.","ref":"global.html#del_lock/2"},{"type":"function","title":"global.disconnect/0","doc":"Disconnect from all other nodes known to `global`.\n\nA list of node names (in an unspecified order) is returned which corresponds to\nthe nodes that were disconnected. All disconnect operations performed have completed when\n`global:disconnect/0` returns.\n\nThe disconnects will be made in such a way that only the current node will be\nremoved from the cluster of `global` nodes. If\n[`prevent_overlapping_partitions`] is\nenabled and you disconnect, from other nodes in the cluster of `global` nodes,\nby other means, `global` on the other nodes may partition the remaining nodes in\norder to ensure that no overlapping partitions appear. Even if\n[`prevent_overlapping_partitions`] is disabled, you should preferably use\n`global:disconnect/0` in order to remove current node from a cluster of `global`\nnodes, since you otherwise likely _will_ create overlapping partitions which\nmight [cause problems](`m:global#prevent_overlapping_partitions`).\n\nNote that if the node is going to be halted, there is _no_ need to remove it\nfrom a cluster of `global` nodes explicitly by calling `global:disconnect/0`\nbefore halting it. The removal from the cluster is taken care of automatically\nwhen the node halts regardless of whether [`prevent_overlapping_partitions`] is\nenabled or not.\n\nIf current node has been configured to be part of a\n[_global group_](`m:global_group`), only connected and/or synchronized nodes in\nthat group are known to `global`, so `global:disconnect/0` will _only_\ndisconnect from those nodes. If current node is _not_ part of a _global group_,\nall [connected visible nodes](`erlang:nodes/0`) will be known to `global`, so\n`global:disconnect/0` will disconnect from all those nodes.\n\nNote that information about connected nodes does not instantaneously reach\n`global`, so the caller might see a node part of the result returned by\n[`nodes()`](`erlang:nodes/0`) while it still is not known to `global`. The\ndisconnect operation will, however, still not cause any overlapping partitions\nwhen [`prevent_overlapping_partitions`] is enabled. If\n[`prevent_overlapping_partitions`] is disabled, overlapping partitions might form\nin this case.\n\nNote that when [`prevent_overlapping_partitions`] is enabled, you may see warning\nreports on other nodes when they detect that current node has disconnected.\nThese are in this case completely harmless and can be ignored.\n\n[`prevent_overlapping_partitions`]: kernel_app.md#prevent_overlapping_partitions","ref":"global.html#disconnect/0"},{"type":"type","title":"global.id/0","doc":"A lock id used to set or delete lock `ResourceId` on behalf of `LockRequesterId`.","ref":"global.html#t:id/0"},{"type":"type","title":"global.method/0","doc":"","ref":"global.html#t:method/0"},{"type":"function","title":"global.notify_all_name/3","doc":"The function unregisters both pids and sends the message\n`{global_name_conflict, Name, OtherPid}` to both processes.\n\nCan be used as a name resolving function for `register_name/3` and\n`re_register_name/3`.","ref":"global.html#notify_all_name/3"},{"type":"function","title":"global.random_exit_name/3","doc":"The function randomly selects one of the pids for registration and kills the\nother one.\n\nCan be used as a name resolving function for `register_name/3` and\n`re_register_name/3`.","ref":"global.html#random_exit_name/3"},{"type":"function","title":"global.random_notify_name/3","doc":"The function randomly selects one of the pids for registration, and sends the\nmessage `{global_name_conflict, Name}` to the other pid.\n\nCan be used as a name resolving function for `register_name/3` and\n`re_register_name/3`.","ref":"global.html#random_notify_name/3"},{"type":"function","title":"global.re_register_name/2","doc":"Equivalent to  re_register_name(Name, Pid, fun random_exit_name/3) .","ref":"global.html#re_register_name/2"},{"type":"function","title":"global.re_register_name/3","doc":"Atomically changes the registered name `Name` on all nodes to refer to `Pid`.\n\nFunction `Resolve` has the same behavior as in\n[`register_name/2,3`](`register_name/2`).","ref":"global.html#re_register_name/3"},{"type":"function","title":"global.register_name/2","doc":"Equivalent to  register_name(Name, Pid, fun random_exit_name/3) .","ref":"global.html#register_name/2"},{"type":"function","title":"global.register_name/3","doc":"Globally associates name `Name` with a pid, that is, globally notifies all nodes\nof a new global name in a network of Erlang nodes.\n\nWhen new nodes are added to the network, they are informed of the globally\nregistered names that already exist. The network is also informed of any global\nnames in newly connected nodes. If any name clashes are discovered, function\n`Resolve` is called. Its purpose is to decide which pid is correct. If the\nfunction crashes, or returns anything other than one of the pids, the name is\nunregistered. This function is called once for each name clash.\n\n> #### Warning {: .warning }\n>\n> If you plan to change code without restarting your system, you must use an\n> external fun (`fun Module:Function/Arity`) as function `Resolve`. If you use a\n> local fun, you can never replace the code for the module that the fun belongs\n> to.\n\nThree predefined resolve functions exist:\n[`random_exit_name/3`](`random_exit_name/3`),\n[`random_notify_name/3`](`random_notify_name/3`), and\n[`notify_all_name/3`](`notify_all_name/3`).\n\nThis function is completely synchronous, that is, when this function returns,\nthe name is either registered on all nodes or none.\n\nThe function returns `yes` if successful, `no` if it fails. For example, `no` is\nreturned if an attempt is made to register an already registered process or to\nregister a process with a name that is already in use.\n\n> #### Note {: .info }\n>\n> Releases up to and including Erlang/OTP R10 did not check if the process was\n> already registered. The global name table could therefore become inconsistent.\n> The old (buggy) behavior can be chosen by giving the Kernel application\n> variable `global_multi_name_action` the value `allow`.\n\nIf a process with a registered name dies, or the node goes down, the name is\nunregistered on all nodes.","ref":"global.html#register_name/3"},{"type":"function","title":"global.registered_names/0","doc":"Returns a list of all globally registered names.","ref":"global.html#registered_names/0"},{"type":"type","title":"global.retries/0","doc":"","ref":"global.html#t:retries/0"},{"type":"function","title":"global.send/2","doc":"Sends message `Msg` to the pid globally registered as `Name`.\n\nIf `Name` is not a globally registered name, the calling function exits with\nreason `{badarg, {Name, Msg}}`.","ref":"global.html#send/2"},{"type":"function","title":"global.set_lock/1","doc":"Equivalent to  set_lock(Id, [node() | nodes()], infinity) .","ref":"global.html#set_lock/1"},{"type":"function","title":"global.set_lock/2","doc":"Equivalent to  set_lock(Id, Nodes, infinity) .","ref":"global.html#set_lock/2"},{"type":"function","title":"global.set_lock/3","doc":"Sets a lock on the specified nodes on using `t:id/0`.\n\nIf a lock already exists on `ResourceId` for another requester than `LockRequesterId`,\nand `Retries` is not equal to `0`, the process sleeps for a while and tries to\nexecute the action later. When `Retries` attempts have been made, `false` is\nreturned, otherwise `true`. If `Retries` is `infinity`, `true` is eventually\nreturned (unless the lock is never released).\n\nThis function is completely synchronous.\n\nIf a process that holds a lock dies, or the node goes down, the locks held by\nthe process are deleted.\n\nThe global name server keeps track of all processes sharing the same lock, that\nis, if two processes set the same lock, both processes must delete the lock.\n\nThis function does not address the problem of a deadlock. A deadlock can never\noccur as long as processes only lock one resource at a time. A deadlock can\noccur if some processes try to lock two or more resources. It is up to the\napplication to detect and rectify a deadlock.\n\n> #### Note {: .info }\n>\n> Avoid the following values of `ResourceId`, otherwise Erlang/OTP does not work\n> properly:\n>\n> - `dist_ac`\n> - `global`\n> - `mnesia_adjust_log_writes`\n> - `mnesia_table_lock`","ref":"global.html#set_lock/3"},{"type":"function","title":"global.sync/0","doc":"Synchronizes the global name server with all nodes known to this node.\n\nThese are the nodes that are returned from [`nodes()`](`erlang:nodes/0`). When\nthis function returns, the global name server receives global information from\nall nodes. This function can be called when new nodes are added to the network.\n\nThe only possible error reason `Reason` is\n`{\"global_groups definition error\", Error}`.","ref":"global.html#sync/0"},{"type":"function","title":"global.trans/2","doc":"Equivalent to  trans(Id, Fun, [node() | nodes()], infinity) .","ref":"global.html#trans/2"},{"type":"function","title":"global.trans/3","doc":"Equivalent to  trans(Id, Fun, Nodes, infinity) .","ref":"global.html#trans/3"},{"type":"function","title":"global.trans/4","doc":"Sets a lock on `Id` (using `set_lock/3`).\n\nIf this succeeds, `Fun()` is evaluated and the result `Res` is returned.\nReturns `aborted` if the lock attempt fails. If `Retries` is set to `infinity`,\nthe transaction does not abort.\n\n`infinity` is the default setting and is used if no value is specified for\n`Retries`.","ref":"global.html#trans/4"},{"type":"type","title":"global.trans_fun/0","doc":"","ref":"global.html#t:trans_fun/0"},{"type":"function","title":"global.unregister_name/1","doc":"Removes the globally registered name `Name` from the network of Erlang nodes.","ref":"global.html#unregister_name/1"},{"type":"function","title":"global.whereis_name/1","doc":"Returns the pid with the globally registered name `Name`. Returns `undefined` if\nthe name is not globally registered.","ref":"global.html#whereis_name/1"},{"type":"module","title":"global_group","doc":"Grouping nodes to global name registration groups.\n\nThis module makes it possible to partition the nodes of a system into _global\ngroups_. Each global group has its own global namespace, see `m:global`.\n\nThe main advantage of dividing systems into global groups is that the background\nload decreases while the number of nodes to be updated is reduced when\nmanipulating globally registered names.\n\nThe Kernel configuration parameter [`global_groups`](kernel_app.md#global_groups)\ndefines the global groups:\n\n```erlang\n{global_groups, [GroupTuple :: group_tuple()]}\n```\n\nFor the processes and nodes to run smoothly using the global group\nfunctionality, the following criteria must be met:\n\n- An instance of the global group server, `global_group`, must be running on\n  each node. The processes are automatically started and synchronized when a\n  node is started.\n- All involved nodes must agree on the global group definition, otherwise the\n  behavior of the system is undefined.\n- _All_ nodes in the system must belong to exactly one global group.\n\nIn the following descriptions, a _group node_ is a node belonging to the same\nglobal group as the local node.","ref":"global_group.html"},{"type":"module","title":"Notes - global_group","doc":"- In the situation where a node has lost its connections to other nodes in its\n  global group, but has connections to nodes in other global groups, a request\n  from another global group can produce an incorrect or misleading result. For\n  example, the isolated node can have inaccurate information about registered\n  names in its global group.\n- Function [`send/2,3`](`send/2`) is not secure.\n- Distribution of applications is highly dependent of the global group\n  definitions. It is not recommended that an application is distributed over\n  many global groups, as the registered names can be moved to another global\n  group at failover/takeover. Nothing prevents this to be done, but the\n  application code must then handle the situation.","ref":"global_group.html#module-notes"},{"type":"module","title":"See Also - global_group","doc":"`m:global`, [`erl`](`e:erts:erl_cmd.md`)","ref":"global_group.html#module-see-also"},{"type":"function","title":"global_group.global_groups/0","doc":"Returns a tuple containing the name of the global group that the local node\nbelongs to, and the list of all other known group names.\n\nReturns `undefined` if no global groups are defined.","ref":"global_group.html#global_groups/0"},{"type":"type","title":"global_group.group_name/0","doc":"","ref":"global_group.html#t:group_name/0"},{"type":"type","title":"global_group.group_tuple/0","doc":"A `GroupTuple` without `PublishType` is the same as a `GroupTuple` with\n`PublishType` equal to `normal`.","ref":"global_group.html#t:group_tuple/0"},{"type":"function","title":"global_group.info/0","doc":"Returns a list containing information about the global groups. Each list element\nis a tuple. The order of the tuples is undefined.\n\n- **`{state, State}`** - If the local node is part of a global group, `State` is\n  equal to `synced`. If no global groups are defined, `State` is equal to\n  `no_conf`.\n\n- **`{own_group_name, GroupName}`** - The name (atom) of the group that the\n  local node belongs to.\n\n- **`{own_group_nodes, Nodes}`** - A list of node names (atoms), the group\n  nodes.\n\n- **`{synced_nodes, Nodes}`** - A list of node names, the group nodes currently\n  synchronized with the local node.\n\n- **`{sync_error, Nodes}`** - A list of node names, the group nodes with which\n  the local node has failed to synchronize.\n\n- **`{no_contact, Nodes}`** - A list of node names, the group nodes to which\n  there are currently no connections.\n\n- **`{other_groups, Groups}`** - `Groups` is a list of tuples\n  `{GroupName, Nodes}`, specifying the name and nodes of the other global\n  groups.\n\n- **`{monitoring, Pids}`** - A list of pids, specifying the processes that have\n  subscribed to `nodeup` and `nodedown` messages.","ref":"global_group.html#info/0"},{"type":"type","title":"global_group.info_item/0","doc":"","ref":"global_group.html#t:info_item/0"},{"type":"function","title":"global_group.monitor_nodes/1","doc":"Alter the calling process' subscription of node status change messages.\n\nIf `Flag` is equal to `true` the calling process starts subscribing to\nnode status change messages. If equal to `false` it stops subscribing.\n\nA process that has subscribed receives the messages `{nodeup, Node}` and\n`{nodedown, Node}` when a group node connects or disconnects, respectively.","ref":"global_group.html#monitor_nodes/1"},{"type":"type","title":"global_group.name/0","doc":"A registered name.","ref":"global_group.html#t:name/0"},{"type":"function","title":"global_group.own_nodes/0","doc":"Returns the names of all group nodes, regardless of their current status.","ref":"global_group.html#own_nodes/0"},{"type":"type","title":"global_group.publish_type/0","doc":"A node started with command-line flag `-hidden` (see\n[`erl`](`e:erts:erl_cmd.md`)) is said to be a _hidden_ node. A hidden node\nestablishes hidden connections to nodes not part of the same global group, but\nnormal (visible) connections to nodes part of the same global group.\n\nA global group defined with `PublishType` equal to `hidden` is said to be a\nhidden global group. All nodes in a hidden global group are hidden nodes,\nwhether they are started with command-line flag `-hidden` or not.","ref":"global_group.html#t:publish_type/0"},{"type":"function","title":"global_group.registered_names/1","doc":"Returns a list of all names that are globally registered on the specified node\nor in the specified global group.","ref":"global_group.html#registered_names/1"},{"type":"function","title":"global_group.send/2","doc":"Sends `Msg` to the pid represented by the globally registered name `Name`.\n\n`send/2` searches for `Name` any any global group. The global groups are searched\nin the order that they appear in the value of configuration parameter\n[`global_groups`](kernel_app.md#global_groups).\n\nIf `Name` is found, message `Msg` is sent to the corresponding pid. The pid is\nalso the return value of the function. If the name is not found, the function\nreturns `{badarg, {Name, Msg}}`.","ref":"global_group.html#send/2"},{"type":"function","title":"global_group.send/3","doc":"Equivalent to [`send(Name, Msg)`](`send/2`) except that he search is limited\nto the node or global group specified by `Where`.","ref":"global_group.html#send/3"},{"type":"function","title":"global_group.sync/0","doc":"Synchronizes the group nodes, that is, the global name servers on the group\nnodes. Also checks the names globally registered in the current global group and\nunregisters them on any known node not part of the group.\n\nIf synchronization is not possible, an error report is sent to the error logger\n(see also `m:error_logger`.\n\nReturns `{error, {'invalid global_groups definition', Bad}}` if configuration\nparameter `global_groups` has an invalid value `Bad`.","ref":"global_group.html#sync/0"},{"type":"type","title":"global_group.sync_state/0","doc":"","ref":"global_group.html#t:sync_state/0"},{"type":"type","title":"global_group.where/0","doc":"","ref":"global_group.html#t:where/0"},{"type":"function","title":"global_group.whereis_name/1","doc":"Searched for `Name` in any global group.\n\nThe global groups are searched in the order that they appear in the value\nof configuration parameter `global_groups`.\n\nIf `Name` is found, the corresponding pid is returned. If the name is not found,\nthe function returns `undefined`.","ref":"global_group.html#whereis_name/1"},{"type":"function","title":"global_group.whereis_name/2","doc":"Equivalent to [`whereis_name(Name)`](`whereis_name/1`) except that he search is limited\nto the node or global group specified by `Where`.","ref":"global_group.html#whereis_name/2"},{"type":"module","title":"net_adm","doc":"Various Erlang net administration routines.\n\nThis module contains various network utility functions.","ref":"net_adm.html"},{"type":"module","title":"Files - net_adm","doc":"File `.hosts.erlang` consists of a number of host names written as Erlang terms.\nIt is looked for in the current work directory, the user's home directory, and\n`$OTPROOT` (the root directory of Erlang/OTP), in that order.\n\nThe format of file `.hosts.erlang` must be one host name per line. The host\nnames must be within quotes.\n\n_Example:_\n\n```text\n'super.eua.ericsson.se'.\n'renat.eua.ericsson.se'.\n'grouse.eua.ericsson.se'.\n'gauffin1.eua.ericsson.se'.\n^ (new line)\n```","ref":"net_adm.html#module-files"},{"type":"function","title":"net_adm.dns_hostname/1","doc":"Returns the official name of `Host`, or `{error, Host}` if no such name is\nfound. See also `m:inet`.","ref":"net_adm.html#dns_hostname/1"},{"type":"function","title":"net_adm.host_file/0","doc":"Reads file `.hosts.erlang`, see section [Files](`m:net_adm#module-files`). Returns the\nhosts in this file as a list. Returns `{error, Reason}` if the file cannot be\nread or the Erlang terms on the file cannot be interpreted.","ref":"net_adm.html#host_file/0"},{"type":"function","title":"net_adm.localhost/0","doc":"Returns the name of the local host. If Erlang was started with command-line flag\n`-name`, `Name` is the fully qualified name.","ref":"net_adm.html#localhost/0"},{"type":"function","title":"net_adm.names/0","doc":"Equivalent to  names(net_adm:localhost()) .","ref":"net_adm.html#names/0"},{"type":"function","title":"net_adm.names/1","doc":"Returns the names and associated port numbers of the Erlang nodes that `epmd`\nregistered at the specified host.\n\nSimilar to `epmd -names`, see [`erts:epmd`](`e:erts:epmd_cmd.md`).\n\nReturns `{error, address}` if `epmd` is not operational.\n\n_Example:_\n\n```erlang\n(arne@dunn)1> net_adm:names().\n{ok,[{\"arne\",40262}]}\n```","ref":"net_adm.html#names/1"},{"type":"function","title":"net_adm.ping/1","doc":"Sets up a connection to `Node`. Returns `pong` if it is successful, otherwise\n`pang`.","ref":"net_adm.html#ping/1"},{"type":"type","title":"net_adm.verbosity/0","doc":"","ref":"net_adm.html#t:verbosity/0"},{"type":"function","title":"net_adm.world/0","doc":"Equivalent to  world(silent) .","ref":"net_adm.html#world/0"},{"type":"function","title":"net_adm.world/1","doc":"Calls [`names(Host)`](`names/1`) for all hosts that are specified in the Erlang\nhost file `.hosts.erlang`, collects the replies, and then evaluates\n[`ping(Node)`](`ping/1`) on all those nodes. Returns the list of all nodes that\nare successfully pinged.\n\nIf `Arg == verbose`, the function writes information about which nodes it is\npinging to `stdout`.\n\nThis function can be useful when a node is started, and the names of the other\nnetwork nodes are not initially known.\n\nReturns `{error, Reason}` if `host_file/0` returns `{error, Reason}`.","ref":"net_adm.html#world/1"},{"type":"function","title":"net_adm.world_list/1","doc":"Equivalent to  world_list(Hosts, silent) .","ref":"net_adm.html#world_list/1"},{"type":"function","title":"net_adm.world_list/2","doc":"Same as [`world/0,1`](`world/1`), but the hosts are specified as argument\ninstead of being read from `.hosts.erlang`.","ref":"net_adm.html#world_list/2"},{"type":"module","title":"net_kernel","doc":"Erlang networking kernel.\n\nThe net kernel is a system process, registered as `net_kernel`, which must be\noperational for distributed Erlang to work. The purpose of this process is to\nimplement parts of the BIFs [`spawn/4`](`spawn/4`) and\n[`spawn_link/4`](`spawn_link/4`), and to provide monitoring of the network.\n\nAn Erlang node is started using command-line flag `-name` or `-sname`:\n\n```text\n$ erl -sname foobar\n```\n\nIt is also possible to call [`net_kernel:start(foobar, #{})`](`start/2`)\ndirectly from the normal Erlang shell prompt:\n\n```erlang\n1> net_kernel:start(foobar, #{name_domain => shortnames}).\n{ok,<0.64.0>}\n(foobar@gringotts)2>\n```\n\nIf the node is started with command-line flag `-sname`, the node name is\n`foobar@Host`, where `Host` is the short name of the host (not the fully\nqualified domain name). If started with flag `-name`, the node name is\n`foobar@Host`, where `Host` is the fully qualified domain name. For more\ninformation, see [`erl`](`e:erts:erl_cmd.md`).\n\nNormally, connections are established automatically when another node is\nreferenced. This functionality can be disabled by setting Kernel configuration\nparameter `dist_auto_connect` to `never`, see [`kernel(6)`](kernel_app.md). In\nthis case, connections must be established explicitly by calling\n`connect_node/1`.\n\nWhich nodes that are allowed to communicate with each other is handled by the\nmagic cookie system, see section [Distributed Erlang](`e:system:distributed.md`)\nin the Erlang Reference Manual.\n\n> #### Warning {: .warning }\n>\n> Starting a distributed node without also specifying\n> [`-proto_dist inet_tls`](`e:erts:erl_cmd.md#proto_dist`) will expose the node\n> to attacks that may give the attacker complete access to the node and in\n> extension the cluster. When using un-secure distributed nodes, make sure that\n> the network is configured to keep potential attackers out. See the\n> [Using SSL for Erlang Distribution](`e:ssl:ssl_distribution.md`) User's Guide\n> for details on how to setup a secure distributed node.","ref":"net_kernel.html"},{"type":"function","title":"net_kernel.allow/1","doc":"Permits access to the specified set of nodes.\n\nBefore the first call to [`allow/1`](`allow/1`), any node with the correct\ncookie can be connected. When [`allow/1`](`allow/1`) is called, a list of\nallowed nodes is established. Any access attempts made from (or to) nodes not in\nthat list will be rejected.\n\nSubsequent calls to [`allow/1`](`allow/1`) will add the specified nodes to the\nlist of allowed nodes. It is not possible to remove nodes from the list.\n\nDisallowing an already connected node will not cause it to be disconnected. It\nwill, however, prevent any future reconnection attempts.\n\nPassing `Nodes` as an empty list has never any affect at all.\n\nReturns `error` if any element in `Nodes` is not an atom, and `ignored` if the\nlocal node is not alive.","ref":"net_kernel.html#allow/1"},{"type":"function","title":"net_kernel.allowed/0","doc":"Returns a list of nodes that are explicitly allowed to connect to the node by calling\n[`allow/1`](`allow/1`). If empty list is returned, it means that any node using the\nsame cookie will be able to connect.","ref":"net_kernel.html#allowed/0"},{"type":"function","title":"net_kernel.connect_node/1","doc":"Establishes a connection to `Node`.\n\nReturns `true` if a connection was established or was already established or if\n`Node` is the local node itself. Returns `false` if the connection attempt failed,\nand `ignored` if the local node is not alive.","ref":"net_kernel.html#connect_node/1"},{"type":"type","title":"net_kernel.connection_state/0","doc":"","ref":"net_kernel.html#t:connection_state/0"},{"type":"type","title":"net_kernel.connection_type/0","doc":"","ref":"net_kernel.html#t:connection_type/0"},{"type":"function","title":"net_kernel.get_net_ticktime/0","doc":"Returns currently used net tick time in seconds.\n\nFor more information see the [`net_ticktime`](kernel_app.md#net_ticktime)\n`Kernel` parameter.\n\nDefined return values (`Res`):\n\n- **`NetTicktime`** - `net_ticktime` is `NetTicktime` seconds.\n\n- **`{ongoing_change_to, NetTicktime}`** - `net_kernel` is currently changing\n  `net_ticktime` to `NetTicktime` seconds.\n\n- **`ignored`** - The local node is not alive.","ref":"net_kernel.html#get_net_ticktime/0"},{"type":"function","title":"net_kernel.get_state/0","doc":"Get the current state of the distribution for the local node.\n\nReturns a map with (at least) the following key-value pairs:\n\n- **`started => Started`** - Valid values for `Started`:\n\n  - **`no`** - The distribution is not started. In this state none of the other\n    keys below are present in the map.\n\n  - **`static`** - The distribution was started with command line arguments\n    [`-name`](`e:erts:erl_cmd.md#name`) or\n    [`-sname`](`e:erts:erl_cmd.md#sname`).\n\n  - **`dynamic`** - The distribution was started with\n    [`net_kernel:start/1`](`start/1`) and can be stopped with\n    [`net_kernel:stop/0`](`start/1`).\n\n- **`name => Name`** - The name of the node. Same as returned by `erlang:node/0`\n  except when `name_type` is `dynamic` in which case `Name` may be `undefined`\n  (instead of `nonode@nohost`).\n\n- **`name_type => NameType`** - Valid values for `NameType`:\n\n  - **`static`** - The node has a static node name set by the node itself.\n\n  - **`dynamic`** - The distribution was started in\n    [dynamic node name](`e:system:distributed.md#dyn_node_name`) mode, and will\n    get its node name assigned from the first node it connects to. If key `name`\n    has value `undefined` that has not happened yet.\n\n- **`name_domain => NameDomain`** - Valid values for `NameDomain`:\n\n  - **`shortnames`** - The distribution was started to use node names with a\n    short host portion (not fully qualified).\n\n  - **`longnames`** - The distribution was started to use node names with a long\n    fully qualified host portion.","ref":"net_kernel.html#get_state/0"},{"type":"function","title":"net_kernel.getopts/2","doc":"Get one or more options for the distribution socket connected to `Node`.\n\nIf `Node` is a connected node the return value is the same as from\n[`inet:getopts(Sock, Options)`](`inet:getopts/2`) where `Sock` is the\ndistribution socket for `Node`.\n\nReturns `ignored` if the local node is not alive or `{error, noconnection}` if\n`Node` is not connected.","ref":"net_kernel.html#getopts/2"},{"type":"function","title":"net_kernel.monitor_nodes/1","doc":"Equivalent to  monitor_nodes(Flag, []) .","ref":"net_kernel.html#monitor_nodes/1"},{"type":"function","title":"net_kernel.monitor_nodes/2","doc":"The calling process subscribes or unsubscribes to node status change messages. A\n`nodeup` message is delivered to all subscribing processes when a new node is\nconnected, and a `nodedown` message is delivered when a node is disconnected.\n\nIf `Flag` is `true`, a new subscription is started. If `Flag` is `false`, all\nprevious subscriptions started with the same `Options` are stopped. Two option\nlists are considered the same if they contain the same set of options.\n\nDelivery guarantees of `nodeup`/`nodedown` messages:\n\n- `nodeup` messages are delivered before delivery of any signals from the remote\n  node through the newly established connection.\n- `nodedown` messages are delivered after all the signals from the remote node\n  over the connection have been delivered.\n- `nodeup` messages are delivered after the corresponding node appears in\n  results from `erlang:nodes()`.\n- `nodedown` messages are delivered after the corresponding node has disappeared\n  in results from `erlang:nodes()`.\n- As of OTP 23.0, a `nodedown` message for a connection being taken down will be\n  delivered before a `nodeup` message due to a new connection to the same node.\n  Prior to OTP 23.0, this was not guaranteed to be the case.\n\nThe format of the node status change messages depends on `Options`. If `Options`\nis the empty list or if `net_kernel:monitor_nodes/1` is called, the format is as\nfollows:\n\n```erlang\n{nodeup, Node} | {nodedown, Node}\n  Node = node()\n```\n\nWhen `Options` is the empty map or empty list, the caller will only subscribe\nfor status change messages for visible nodes. That is, only nodes that appear in\nthe result of `erlang:nodes/0`.\n\nIf `Options` equals anything other than the empty list, the format of the status\nchange messages is as follows:\n\n```erlang\n{nodeup, Node, Info} | {nodedown, Node, Info}\n  Node = node()\n  Info = #{Tag => Val} | [{Tag, Val}]\n```\n\n`Info` is either a map or a list of 2-tuples. Its content depends on `Options`.\nIf `Options` is a map, `Info` will also be a map. If `Options` is a list, `Info`\nwill also be a list.\n\nWhen `Options` is a map, currently the following associations are allowed:\n\n- **`connection_id => boolean()`** - If the value of the association equals\n  `true`, a `connection_id => ConnectionId` association will be included in the\n  `Info` map where `ConnectionId` is the connection identifier of the connection\n  coming up or going down. For more info about this connection identifier see\n  the documentation of [erlang:nodes/2](`m:erlang#connection_id`).\n\n- **`node_type => NodeType`** - Valid values for `NodeType`:\n\n  - **`visible`** - Subscribe to node status change messages for visible nodes\n    only. The association `node_type => visible` will be included in the `Info`\n    map.\n\n  - **`hidden`** - Subscribe to node status change messages for hidden nodes\n    only. The association `node_type => hidden` will be included in the `Info`\n    map.\n\n  - **`all`** - Subscribe to node status change messages for both visible and\n    hidden nodes. The association `node_type => visible | hidden` will be\n    included in the `Info` map.\n\n  If no `node_type => NodeType` association is included in the `Options` map,\n  the caller will subscribe for status change messages for visible nodes only,\n  but _no_ `node_type => visible` association will be included in the `Info`\n  map.\n\n- **`nodedown_reason => boolean()`** - If the value of the association equals\n  `true`, a `nodedown_reason => Reason` association will be included in the\n  `Info` map for `nodedown` messages.\n\n  [](){: #nodedown_reasons } `Reason` can, depending on which distribution\n  module or process that is used, be any term, but for the standard TCP\n  distribution module it is one of the following:\n\n  - **`connection_setup_failed`** - The connection setup failed (after `nodeup`\n    messages were sent).\n\n  - **`no_network`** - No network is available.\n\n  - **`net_kernel_terminated`** - The `net_kernel` process terminated.\n\n  - **`shutdown`** - Unspecified connection shutdown.\n\n  - **`connection_closed`** - The connection was closed.\n\n  - **`disconnect`** - The connection was disconnected (forced from the current\n    node).\n\n  - **`net_tick_timeout`** - Net tick time-out.\n\n  - **`send_net_tick_failed`** - Failed to send net tick over the connection.\n\n  - **`get_status_failed`** - Status information retrieval from the `Port`\n    holding the connection failed.\n\nWhen `Options` is a list, currently `ListOption` can be one of the following:\n\n- **`connection_id`** - A `{connection_id, ConnectionId}` tuple will be included\n  in `Info` where `ConnectionId` is the connection identifier of the connection\n  coming up or going down. For more info about this connection identifier see\n  the documentation of [erlang:nodes/2](`m:erlang#connection_id`).\n\n- **`{node_type, NodeType}`** - Valid values for `NodeType`:\n\n  - **`visible`** - Subscribe to node status change messages for visible nodes\n    only. The tuple `{node_type, visible}` will be included in the `Info` list.\n\n  - **`hidden`** - Subscribe to node status change messages for hidden nodes\n    only. The tuple `{node_type, hidden}` will be included in the `Info` list.\n\n  - **`all`** - Subscribe to node status change messages for both visible and\n    hidden nodes. The tuple `{node_type, visible | hidden}` will be included in\n    the `Info` list.\n\n  If no `{node_type, NodeType}` option has been given. The caller will subscribe\n  for status change messages for visible nodes only, but _no_\n  `{node_type, visible}` tuple will be included in the `Info` list.\n\n- **`nodedown_reason`** - The tuple `{nodedown_reason, Reason}` will be included\n  in the `Info` list for `nodedown` messages.\n\n  See the documentation of the\n  [`nodedown_reason => boolean()`](`m:net_kernel#nodedown_reasons`) association\n  above for information about possible `Reason` values.\n\nExample:\n\n```erlang\n(a@localhost)1> net_kernel:monitor_nodes(true, #{connection_id=>true, node_type=>all, nodedown_reason=>true}).\nok\n(a@localhost)2> flush().\nShell got {nodeup,b@localhost,\n                  #{connection_id => 3067552,node_type => visible}}\nShell got {nodeup,c@localhost,\n                  #{connection_id => 13892107,node_type => hidden}}\nShell got {nodedown,b@localhost,\n                    #{connection_id => 3067552,node_type => visible,\n                      nodedown_reason => connection_closed}}\nShell got {nodedown,c@localhost,\n                    #{connection_id => 13892107,node_type => hidden,\n                      nodedown_reason => net_tick_timeout}}\nShell got {nodeup,b@localhost,\n                  #{connection_id => 3067553,node_type => visible}}\nok\n(a@localhost)3>\n```","ref":"net_kernel.html#monitor_nodes/2"},{"type":"function","title":"net_kernel.set_net_ticktime/1","doc":"Equivalent to  set_net_ticktime(NetTicktime, 60) .","ref":"net_kernel.html#set_net_ticktime/1"},{"type":"function","title":"net_kernel.set_net_ticktime/2","doc":"Sets `net_ticktime` (see [`kernel(6)`](kernel_app.md)) to `NetTicktime` seconds.\n`TransitionPeriod` defaults to `60`.\n\nSome definitions:\n\n- **Minimum transition traffic interval (`MTTI`)** -\n  `minimum(NetTicktime, PreviousNetTicktime)*1000 div 4` milliseconds.\n\n- **Transition period** - The time of the least number of consecutive `MTTI`s to\n  cover `TransitionPeriod` seconds following the call to\n  [`set_net_ticktime/2`](`set_net_ticktime/2`) (that is,\n  ((`TransitionPeriod*1000 - 1) div MTTI + 1)*MTTI` milliseconds).\n\nIf `NetTicktime   #### Note {: .info }\n>\n> The `net_ticktime` changes must be initiated on all nodes in the network (with\n> the same `NetTicktime`) before the end of any transition period on any node;\n> otherwise connections can erroneously be disconnected.\n\nReturns one of the following:\n\n- **`unchanged`** - `net_ticktime` already has the value of `NetTicktime` and is\n  left unchanged.\n\n- **`change_initiated`** - `net_kernel` initiated the change of `net_ticktime`\n  to `NetTicktime` seconds.\n\n- **`{ongoing_change_to, NewNetTicktime}`** - The request is _ignored_ because\n  `net_kernel` is busy changing `net_ticktime` to `NewNetTicktime` seconds.","ref":"net_kernel.html#set_net_ticktime/2"},{"type":"function","title":"net_kernel.setopts/2","doc":"Set one or more options for distribution sockets. Argument `Node` can be either\none node name or the atom `new` to affect the distribution sockets of all future\nconnected nodes.\n\nThe return value is the same as from `inet:setopts/2` or `{error, noconnection}`\nif `Node` is not a connected node or `new`.\n\nIf `Node` is `new` the `Options` will then also be added to kernel configuration\nparameters [inet_dist_listen_options](kernel_app.md#inet_dist_listen_options)\nand [inet_dist_connect_options](kernel_app.md#inet_dist_connect_options).\n\nReturns `ignored` if the local node is not alive.","ref":"net_kernel.html#setopts/2"},{"type":"function","title":"net_kernel.start/1","doc":"Turns a non-distributed node into a distributed node by starting `net_kernel`\nand other necessary processes.\n\n`Options` list can only be exactly one of the following lists (order is\nimporant):\n\n- **`[Name]`** - The same as `net_kernel:start([Name, longnames, 15000])`.\n\n- **`[Name, NameDomain]`** - The same as\n  `net_kernel:start([Name, NameDomain, 15000])`.\n\n- **`[Name, NameDomain, TickTime]`** - The same as\n  [`net_kernel:start(Name, #{name_domain => NameDomain, net_ticktime => ((TickTime*4-1) div 1000) + 1, net_tickintensity => 4})`](`start/2`).\n  Note that `TickTime` is _not_ the same as net tick time expressed in\n  milliseconds. `TickTime` is the time between ticks when net tick intensity\n  equals `4`.","ref":"net_kernel.html#start/1"},{"type":"function","title":"net_kernel.start/2","doc":"Turns a non-distributed node into a distributed node by starting `net_kernel`\nand other necessary processes.\n\nIf `Name` is set to _`undefined`_ the distribution will be started to request a\ndynamic node name from the first node it connects to. See\n[Dynamic Node Name](`e:system:distributed.md#dyn_node_name`). Setting `Name` to\n`undefined` implies options `dist_listen => false` and `hidden => true`.\n\nCurrently supported options:\n\n- **`name_domain => NameDomain`** - Determines the host name part of the node\n  name. If `NameDomain` equals `longnames`, fully qualified domain names will be\n  used which also is the default. If `NameDomain` equals `shortnames`, only the\n  short name of the host will be used.\n\n- **`net_ticktime => NetTickTime`** - _Net tick time_ to use in seconds.\n  Defaults to the value of the [`net_ticktime`](kernel_app.md#net_ticktime)\n  `kernel(6)` parameter. For more information about _net tick time_, see the\n  `kernel` parameter. However, note that if the value of the `kernel` parameter\n  is invalid, it will silently be replaced by a valid value, but if an invalid\n  `NetTickTime` value is passed as option value to this function, the call will\n  fail.\n\n- **`net_tickintensity => NetTickIntensity`** - _Net tick intensity_ to use.\n  Defaults to the value of the\n  [`net_tickintensity`](kernel_app.md#net_tickintensity) `kernel(6)` parameter.\n  For more information about _net tick intensity_, see the `kernel` parameter.\n  However, note that if the value of the `kernel` parameter is invalid, it will\n  silently be replaced by a valid value, but if an invalid `NetTickIntensity`\n  value is passed as option value to this function, the call will fail.\n\n- **`dist_listen => boolean()`** - Enable or disable listening for incoming\n  connections. Defaults to the value of the\n  [`-dist_listen`](`e:erts:erl_cmd.md#dist_listen`) `erl` command line argument.\n  Note that `dist_listen => false` implies `hidden => true`.\n\n  If `undefined` has been passed as `Name`, the `dist_listen` option will be\n  overridden with `dist_listen => false`.\n\n- **`hidden => boolean()`** - Enable or disable hidden node. Defaults to `true`\n  if the [`-hidden`](`e:erts:erl_cmd.md#hidden`) `erl` command line argument has\n  been passed; otherwise `false`.\n\n  If `undefined` has been passed as `Name`, or the option `dist_listen` equals\n  `false`, the `hidden` option will be overridden with `hidden => true`.","ref":"net_kernel.html#start/2"},{"type":"function","title":"net_kernel.stop/0","doc":"Turns a distributed node into a non-distributed node.\n\nFor other nodes in the network, this is the same as the node going down.\nOnly possible when the net kernel was started using `start/2`, otherwise\n`{error, not_allowed}` is returned. Returns `{error, not_found}` if the local\nnode is not alive.","ref":"net_kernel.html#stop/0"},{"type":"module","title":"pg","doc":"Distributed named process groups.\n\nThis module implements process groups. A message can be sent to one, some, or\nall group members.\n\nUp until OTP 17 there used to exist an experimental `pg` module in `stdlib`.\nThis `pg` module is not the same module as that experimental `pg` module, and\nonly share the same module name.\n\nA group of processes can be accessed by a common name. For example, if there is\na group named `foobar`, there can be a set of processes (which can be located on\ndifferent nodes) that are all members of the group `foobar`. There are no\nspecial functions for sending a message to the group. Instead, client functions\nare to be written with the functions `get_members/1` and `get_local_members/1`\nto determine which processes are members of the group. Then the message can be\nsent to one or more group members.\n\nIf a member terminates, it is automatically removed from the group.\n\nA process may join multiple groups. It may join the same group multiple times.\nIt is only allowed to join processes running on local node.\n\nProcess Groups implement strong eventual consistency. Process Groups membership\nview may temporarily diverge. For example, when processes on `node1` and `node2`\njoin concurrently, `node3` and `node4` may receive updates in a different order.\n\nMembership view is not transitive. If `node1` is not directly connected to\n`node2`, they will not see each other groups. But if both are connected to\n`node3`, `node3` will have the full view.\n\nGroups are automatically created when any process joins, and are removed when\nall processes leave the group. Non-existing group is considered empty\n(containing no processes).\n\nProcess groups can be organised into multiple scopes. Scopes are completely\nindependent of each other. A process may join any number of groups in any number\nof scopes. Scopes are designed to decouple single mesh into a set of overlay\nnetworks, reducing amount of traffic required to propagate group membership\ninformation. Default scope `pg` is started automatically when\n[Kernel](kernel_app.md#start_pg) is configured to do so.\n\n> #### Note {: .info }\n>\n> Scope name is used to register process locally, and to name an ETS table. If\n> there is another process registered under this name, or another ETS table\n> exists, scope fails to start.\n>\n> Local membership is not preserved if scope process exits and restarts.\n>\n> A scope can be kept local-only by using a scope name that is unique\n> cluster-wide, e.g. the node name: `pg:start_link(node()).`","ref":"pg.html"},{"type":"module","title":"See Also - pg","doc":"[Kernel](kernel_app.md)","ref":"pg.html#module-see-also"},{"type":"function","title":"pg.demonitor/1","doc":"Equivalent to  demonitor(pg, Ref) .","ref":"pg.html#demonitor/1"},{"type":"function","title":"pg.demonitor/2","doc":"Unsubscribes the caller from updates (scope or group). Flushes all outstanding\nupdates that were already in the message queue of the calling process.","ref":"pg.html#demonitor/2"},{"type":"function","title":"pg.get_local_members/1","doc":"Equivalent to  get_local_members(pg, Group) .","ref":"pg.html#get_local_members/1"},{"type":"function","title":"pg.get_local_members/2","doc":"Returns all processes running on the local node in the group `Group`. Processes\nare returned in no specific order. This function is optimised for speed.","ref":"pg.html#get_local_members/2"},{"type":"function","title":"pg.get_members/1","doc":"Equivalent to  get_members(pg, Group) .","ref":"pg.html#get_members/1"},{"type":"function","title":"pg.get_members/2","doc":"Returns all processes in the group `Group`. Processes are returned in no\nspecific order. This function is optimised for speed.","ref":"pg.html#get_members/2"},{"type":"type","title":"pg.group/0","doc":"The identifier of a process group.","ref":"pg.html#t:group/0"},{"type":"function","title":"pg.join/2","doc":"Equivalent to  join(pg, Group, PidOrPids) .","ref":"pg.html#join/2"},{"type":"function","title":"pg.join/3","doc":"Joins single process or multiple processes to the group `Group`. A process can\njoin a group many times and must then leave the group the same number of times.\n\n`PidOrPids` may contain the same process multiple times.","ref":"pg.html#join/3"},{"type":"function","title":"pg.leave/2","doc":"Equivalent to  leave(pg, Group, PidOrPids) .","ref":"pg.html#leave/2"},{"type":"function","title":"pg.leave/3","doc":"Makes the process `PidOrPids` leave the group `Group`. If the process is not a\nmember of the group, `not_joined` is returned.\n\nWhen list of processes is passed as `PidOrPids`, function returns `not_joined`\nonly when all processes of the list are not joined.","ref":"pg.html#leave/3"},{"type":"function","title":"pg.monitor/1","doc":"Equivalent to  monitor(pg, Group) .","ref":"pg.html#monitor/1"},{"type":"function","title":"pg.monitor/2","doc":"Subscribes the caller to updates for the specified group.\n\nReturns list of processes currently in the group, and a reference to match the\nupcoming notifications.\n\nSee `monitor_scope/0` for the update message structure.","ref":"pg.html#monitor/2"},{"type":"function","title":"pg.monitor_scope/0","doc":"Equivalent to  monitor_scope(pg) .","ref":"pg.html#monitor_scope/0"},{"type":"function","title":"pg.monitor_scope/1","doc":"Subscribes the caller to updates from the specified scope.\n\nReturns content of the entire scope and a reference to match the upcoming\nnotifications.\n\nWhenever any group membership changes, an update message is sent to the\nsubscriber:\n\n```erlang\n{Ref, join, Group, [JoinPid1, JoinPid2]}\n```\n\n```erlang\n{Ref, leave, Group, [LeavePid1]}\n```","ref":"pg.html#monitor_scope/1"},{"type":"function","title":"pg.start/1","doc":"Starts additional scope.","ref":"pg.html#start/1"},{"type":"function","title":"pg.start_link/0","doc":"Starts the default `pg` scope within supervision tree.\n\nKernel may be configured to do it automatically by setting\nthe Kernel configuration parameter [`start_pg`](kernel_app.md#start_pg).","ref":"pg.html#start_link/0"},{"type":"function","title":"pg.start_link/1","doc":"Equivalent to [`start(Scope)`](`start/1`), except that it also creates\na `link/1` with the calling process.","ref":"pg.html#start_link/1"},{"type":"function","title":"pg.which_groups/0","doc":"Equivalent to  which_groups(pg) .","ref":"pg.html#which_groups/0"},{"type":"function","title":"pg.which_groups/1","doc":"Returns a list of all known groups.","ref":"pg.html#which_groups/1"},{"type":"module","title":"rpc","doc":"Remote Procedure Call services.\n\nThis module contains services similar to Remote Procedure Calls. It also\ncontains broadcast facilities and parallel evaluators. A remote procedure call\nis a method to call a function on a remote node and collect the answer. It is\nused for collecting information on a remote node, or for running a function with\nsome specific side effects on the remote node.\n\n> #### Note {: .info }\n>\n> `rpc:call/4` and friends makes it quite hard to distinguish between successful\n> results, raised exceptions, and other errors. This cannot be changed due to\n> compatibility reasons. As of OTP 23, a new module `m:erpc` was introduced in\n> order to provide an API that makes it possible to distinguish between the\n> different results. The `erpc` module provides a subset (however, the central\n> subset) of the functionality available in the `rpc` module. The `erpc`\n> implementation also provides a more scalable implementation with better\n> performance than the original `rpc` implementation. However, since the\n> introduction of `erpc`, the `rpc` module implements large parts of its central\n> functionality using `erpc`, so the `rpc` module won't not suffer scalability\n> wise and performance wise compared to `erpc`.\n\n> #### Note {: .info }\n>\n> For some important information about distributed signals, see the\n> [Blocking Signaling Over Distribution](`e:system:ref_man_processes.md#blocking-signaling-over-distribution`)\n> section in the _Processes_ chapter of the _Erlang Reference Manual_. Blocking\n> signaling can, for example, cause timeouts in `rpc` to be significantly\n> delayed.","ref":"rpc.html"},{"type":"function","title":"rpc.abcast/2","doc":"Equivalent to [`abcast([node()|nodes()], Name, Msg)`](`abcast/3`).","ref":"rpc.html#abcast/2"},{"type":"function","title":"rpc.abcast/3","doc":"Broadcasts the message `Msg` asynchronously to the registered process `Name` on\nthe specified nodes.","ref":"rpc.html#abcast/3"},{"type":"function","title":"rpc.async_call/4","doc":"Implements _call streams with promises_, a type of RPC that does not suspend the\ncaller until the result is finished. Instead, a key is returned, which can be\nused later to collect the value. The key can be viewed as a promise to deliver\nthe answer.\n\nIn this case, the key `Key` is returned, which can be used in a subsequent call\nto `yield/1` or [`nb_yield/1,2`](`nb_yield/1`) to retrieve the value of\nevaluating [`apply(Module, Function, Args)`](`apply/3`) on node `Node`.\n\n> #### Note {: .info }\n>\n> If you want the ability to distinguish between results, you may want to\n> consider using the [`erpc:send_request()`](`erpc:send_request/4`) function\n> from the `erpc` module instead. This also gives you the ability retrieve the\n> results in other useful ways.\n\n> #### Note {: .info }\n>\n> `yield/1` and [`nb_yield/1,2`](`nb_yield/1`) must be called by the same\n> process from which this function was made otherwise they will never yield\n> correctly.\n\n> #### Note {: .info }\n>\n> You cannot make _any_ assumptions about the process that will perform the\n> `apply()`. It may be an `rpc` server, another server, or a freshly spawned\n> process.","ref":"rpc.html#async_call/4"},{"type":"function","title":"rpc.block_call/4","doc":"The same as calling\n[`rpc:block_call(Node, Module, Function, Args, infinity)`](`block_call/5`).","ref":"rpc.html#block_call/4"},{"type":"function","title":"rpc.block_call/5","doc":"The same as calling\n[`rpc:call(Node, Module, Function, Args, Timeout)`](`call/5`) with the exception\nthat it also blocks other `rpc:block_call/5` operations from executing\nconcurrently on the node `Node`.\n\n> #### Warning {: .warning }\n>\n> Note that it also blocks other operations than just `rpc:block_call/5`\n> operations, so use it with care.","ref":"rpc.html#block_call/5"},{"type":"function","title":"rpc.call/4","doc":"Evaluates [`apply(Module, Function, Args)`](`apply/3`) on node `Node` and\nreturns the corresponding value `Res`, or `{badrpc, Reason}` if the call fails.\nThe same as calling\n[`rpc:call(Node, Module, Function, Args, infinity)`](`call/5`).","ref":"rpc.html#call/4"},{"type":"function","title":"rpc.call/5","doc":"Evaluates [`apply(Module, Function, Args)`](`apply/3`) on node `Node` and\nreturns the corresponding value `Res`, or `{badrpc, Reason}` if the call fails.\n`Timeout` is a time-out value in milliseconds. If the call times out, `Reason`\nis `timeout`.\n\nIf the reply arrives after the call times out, no message contaminates the\ncaller's message queue.\n\n> #### Note {: .info }\n>\n> If you want the ability to distinguish between results, you may want to\n> consider using the [`erpc:call()`](`erpc:call/4`) function from the `erpc`\n> module instead.\n\n> #### Note {: .info }\n>\n> Here follows the details of what exactly is returned.\n>\n> `{badrpc, Reason}` will be returned in the following circumstances:\n>\n> - The called function fails with an `exit` exception.\n> - The called function fails with an `error` exception.\n> - The called function returns a term that matches `{'EXIT', _}`.\n> - The called function `throws` a term that matches `{'EXIT', _}`.\n>\n> `Res` is returned in the following circumstances:\n>\n> - The called function returns normally with a term that does **not** match\n>   `{'EXIT',_}`.\n> - The called function `throw`s a term that does **not** match `{'EXIT',_}`.\n\n> #### Note {: .info }\n>\n> You cannot make _any_ assumptions about the process that will perform the\n> `apply()`. It may be the calling process itself, an `rpc` server, another\n> server, or a freshly spawned process.","ref":"rpc.html#call/5"},{"type":"function","title":"rpc.cast/4","doc":"Evaluates [`apply(Module, Function, Args)`](`apply/3`) on node `Node`. No\nresponse is delivered and the calling process is not suspended until the\nevaluation is complete, as is the case with [`call/4,5`](`call/4`).\n\n> #### Note {: .info }\n>\n> You cannot make _any_ assumptions about the process that will perform the\n> `apply()`. It may be an `rpc` server, another server, or a freshly spawned\n> process.","ref":"rpc.html#cast/4"},{"type":"function","title":"rpc.eval_everywhere/3","doc":"Equivalent to\n[`eval_everywhere([node()|nodes()], Module, Function, Args)`](`eval_everywhere/4`).","ref":"rpc.html#eval_everywhere/3"},{"type":"function","title":"rpc.eval_everywhere/4","doc":"Evaluates [`apply(Module, Function, Args)`](`apply/3`) on the specified nodes.\nNo answers are collected.","ref":"rpc.html#eval_everywhere/4"},{"type":"opaque","title":"rpc.key/0","doc":"Opaque value returned by `async_call/4`.","ref":"rpc.html#t:key/0"},{"type":"function","title":"rpc.multi_server_call/2","doc":"Equivalent to\n[`multi_server_call([node()|nodes()], Name, Msg)`](`multi_server_call/3`).","ref":"rpc.html#multi_server_call/2"},{"type":"function","title":"rpc.multi_server_call/3","doc":"Can be used when interacting with servers called `Name` on the specified nodes.\nIt is assumed that the servers receive messages in the format `{From, Msg}` and\nreply using `From ! {Name, Node, Reply}`, where `Node` is the name of the node\nwhere the server is located. The function returns `{Replies, BadNodes}`, where\n`Replies` is a list of all `Reply` values, and `BadNodes` is one of the\nfollowing:\n\n- A list of the nodes that do not exist\n- A list of the nodes where the server does not exist\n- A list of the nodes where the server terminated before sending any reply.","ref":"rpc.html#multi_server_call/3"},{"type":"function","title":"rpc.multicall/3","doc":"Equivalent to\n[`multicall([node()|nodes()], Module, Function, Args, infinity)`](`multicall/5`).","ref":"rpc.html#multicall/3"},{"type":"function","title":"rpc.multicall/4","doc":"Equivalent to\n[`multicall(Nodes, Module, Function, Args, infinity)`](`multicall/5`).\n\nEquivalent to\n[`multicall([node()|nodes()], Module, Function, Args, Timeout)`](`multicall/5`).","ref":"rpc.html#multicall/4"},{"type":"function","title":"rpc.multicall/5","doc":"In contrast to an RPC, a multicall is an RPC that is sent concurrently from one\nclient to multiple servers. This is useful for collecting information from a set\nof nodes, or for calling a function on a set of nodes to achieve some side\neffects. It is semantically the same as iteratively making a series of RPCs on\nall the nodes, but the multicall is faster, as all the requests are sent at the\nsame time and are collected one by one as they come back.\n\nThe function evaluates [`apply(Module, Function, Args)`](`apply/3`) on the\nspecified nodes and collects the answers. It returns `{ResL, BadNodes}`, where\n`BadNodes` is a list of the nodes that do not exist, and `ResL` is a list of the\nreturn values, or `{badrpc, Reason}` for failing calls. `Timeout` is a time\n(integer) in milliseconds, or `infinity`.\n\nThe following example is useful when new object code is to be loaded on all\nnodes in the network, and indicates some side effects that RPCs can produce:\n\n```erlang\n%% Find object code for module Mod\n{Mod, Bin, File} = code:get_object_code(Mod),\n\n%% and load it on all nodes including this one\n{ResL, _} = rpc:multicall(code, load_binary, [Mod, File, Bin]),\n\n%% and then maybe check the ResL list.\n```\n\n> #### Note {: .info }\n>\n> If you want the ability to distinguish between results, you may want to\n> consider using the [`erpc:multicall()`](`erpc:multicall/4`) function from the\n> `erpc` module instead.\n\n> #### Note {: .info }\n>\n> You cannot make _any_ assumptions about the process that will perform the\n> `apply()`. It may be the calling process itself, an `rpc` server, another\n> server, or a freshly spawned process.","ref":"rpc.html#multicall/5"},{"type":"function","title":"rpc.nb_yield/1","doc":"Equivalent to [`nb_yield(Key, 0)`](`nb_yield/2`).","ref":"rpc.html#nb_yield/1"},{"type":"function","title":"rpc.nb_yield/2","doc":"Non-blocking version of `yield/1`. It returns the tuple `{value, Val}` when the\ncomputation is finished, or `timeout` when `Timeout` milliseconds has elapsed.\n\nSee the note in `call/4` for more details of Val.\n\n> #### Note {: .info }\n>\n> This function must be called by the same process from which `async_call/4` was\n> made otherwise it will only return `timeout`.","ref":"rpc.html#nb_yield/2"},{"type":"function","title":"rpc.parallel_eval/1","doc":"Evaluates, for every tuple in `FuncCalls`,\n[`apply(Module, Function, Args)`](`apply/3`) on some node in the network.\nReturns the list of return values, in the same order as in `FuncCalls`.","ref":"rpc.html#parallel_eval/1"},{"type":"function","title":"rpc.pinfo/1","doc":"Location transparent version of the BIF `erlang:process_info/1` in ERTS.","ref":"rpc.html#pinfo/1"},{"type":"function","title":"rpc.pinfo/2","doc":"Location transparent version of the BIF `erlang:process_info/2` in ERTS.","ref":"rpc.html#pinfo/2"},{"type":"function","title":"rpc.pmap/3","doc":"Evaluates [`apply(Module, Function, [Elem|ExtraArgs])`](`apply/3`) for every\nelement `Elem` in `List1`, in parallel. Returns the list of return values, in\nthe same order as in `List1`.","ref":"rpc.html#pmap/3"},{"type":"function","title":"rpc.sbcast/2","doc":"Equivalent to [`sbcast([node()|nodes()], Name, Msg)`](`sbcast/3`).","ref":"rpc.html#sbcast/2"},{"type":"function","title":"rpc.sbcast/3","doc":"Broadcasts the message `Msg` synchronously to the registered process `Name` on\nthe specified nodes.\n\nReturns `{GoodNodes, BadNodes}`, where `GoodNodes` is the list of nodes that\nhave `Name` as a registered process.\n\nThe function is synchronous in the sense that it is known that all servers have\nreceived the message when the call returns. It is not possible to know that the\nservers have processed the message.\n\nAny further messages sent to the servers, after this function has returned, are\nreceived by all servers after this message.","ref":"rpc.html#sbcast/3"},{"type":"function","title":"rpc.server_call/4","doc":"Can be used when interacting with a server called `Name` on node `Node`. It is\nassumed that the server receives messages in the format `{From, Msg}` and\nreplies using `From ! {ReplyWrapper, Node, Reply}`. This function makes such a\nserver call and ensures that the entire call is packed into an atomic\ntransaction, which either succeeds or fails. It never hangs, unless the server\nitself hangs.\n\nThe function returns the answer `Reply` as produced by the server `Name`, or\n`{error, Reason}`.","ref":"rpc.html#server_call/4"},{"type":"function","title":"rpc.yield/1","doc":"Returns the promised answer from a previous `async_call/4`. If the answer is\navailable, it is returned immediately. Otherwise, the calling process is\nsuspended until the answer arrives from `Node`.\n\n> #### Note {: .info }\n>\n> This function must be called by the same process from which `async_call/4` was\n> made otherwise it will never return.\n\nSee the note in `call/4` for more details of the return value.","ref":"rpc.html#yield/1"},{"type":"module","title":"file","doc":"File interface module.\n\nThis module provides an interface to the file system.\n\n> #### Warning {: .warning }\n>\n> File operations are only guaranteed to appear atomic when going through the\n> same file server. A NIF or other OS process may observe intermediate steps on\n> certain operations on some operating systems, eg. renaming an existing file on\n> Windows, or [`write_file_info/2`](`write_file_info/2`) on any OS at the time\n> of writing.\n\nRegarding filename encoding, the Erlang VM can operate in two modes. The current\nmode can be queried using function `native_name_encoding/0`. It returns `latin1`\nor `utf8`.\n\nIn `latin1` mode, the Erlang VM does not change the encoding of filenames. In\n`utf8` mode, filenames can contain Unicode characters greater than 255 and the\nVM converts filenames back and forth to the native filename encoding (usually\nUTF-8, but UTF-16 on Windows).\n\nThe default mode depends on the operating system. Windows, MacOS X and Android\nenforce consistent filename encoding and therefore the VM uses `utf8` mode.\n\nOn operating systems with transparent naming (for example, all Unix systems\nexcept MacOS X), default is `utf8` if the terminal supports UTF-8, otherwise\n`latin1`. The default can be overridden using `+fnl` (to force `latin1` mode) or\n`+fnu` (to force `utf8` mode) when starting [`erl`](`e:erts:erl_cmd.md`).\n\nOn operating systems with transparent naming, files can be inconsistently named,\nfor example, some files are encoded in UTF-8 while others are encoded in ISO\nLatin-1. The concept of _raw filenames_ is introduced to handle file systems\nwith inconsistent naming when running in `utf8` mode.\n\nA _raw filename_ is a filename specified as a binary. The Erlang VM does not\ntranslate a filename specified as a binary on systems with transparent naming.\n\nWhen running in `utf8` mode, functions `list_dir/1` and `read_link/1` never\nreturn raw filenames. To return all filenames including raw filenames, use\nfunctions `list_dir_all/1` and `read_link_all/1`.\n\nSee also section\n[Notes About Raw Filenames](`e:stdlib:unicode_usage.md#notes-about-raw-filenames`)\nin the STDLIB User's Guide.\n\n> #### Note {: .info }\n>\n> File operations used to accept filenames containing null characters (integer\n> value zero). This caused the name to be truncated and in some cases arguments\n> to primitive operations to be mixed up. Filenames containing null characters\n> inside the filename are now _rejected_ and will cause primitive file\n> operations fail.","ref":"file.html"},{"type":"module","title":"POSIX Error Codes - file","doc":"- `eacces` \\- Permission denied\n- `eagain` \\- Resource temporarily unavailable\n- `ebadf` \\- Bad file number\n- `ebusy` \\- File busy\n- `edquot` \\- Disk quota exceeded\n- `eexist` \\- File already exists\n- `efault` \\- Bad address in system call argument\n- `efbig` \\- File too large\n- `eintr` \\- Interrupted system call\n- `einval` \\- Invalid argument\n- `eio` \\- I/O error\n- `eisdir` \\- Illegal operation on a directory\n- `eloop` \\- Too many levels of symbolic links\n- `emfile` \\- Too many open files\n- `emlink` \\- Too many links\n- `enametoolong` \\- Filename too long\n- `enfile` \\- File table overflow\n- `enodev` \\- No such device\n- `enoent` \\- No such file or directory\n- `enomem` \\- Not enough memory\n- `enospc` \\- No space left on device\n- `enotblk` \\- Block device required\n- `enotdir` \\- Not a directory\n- `enotsup` \\- Operation not supported\n- `enxio` \\- No such device or address\n- `eperm` \\- Not owner\n- `epipe` \\- Broken pipe\n- `erofs` \\- Read-only file system\n- `espipe` \\- Invalid seek\n- `esrch` \\- No such process\n- `estale` \\- Stale remote file handle\n- `exdev` \\- Cross-device link","ref":"file.html#module-posix-error-codes"},{"type":"module","title":"Performance - file","doc":"For increased performance, raw files are recommended.\n\nA normal file is really a process so it can be used as an I/O device (see\n`m:io`). Therefore, when data is written to a normal file, the sending of the\ndata to the file process, copies all data that are not binaries. Opening the\nfile in binary mode and writing binaries is therefore recommended. If the file\nis opened on another node, or if the file server runs as slave to the file\nserver of another node, also binaries are copied.\n\n> #### Note {: .info }\n>\n> Raw files use the file system of the host machine of the node. For normal\n> files (non-raw), the file server is used to find the files, and if the node is\n> running its file server as slave to the file server of another node, and the\n> other node runs on some other host machine, they can have different file\n> systems. However, this is seldom a problem.\n\n`open/2` can be given the options `delayed_write` and `read_ahead` to turn on\ncaching, which will reduce the number of operating system calls and greatly\nimprove performance for small reads and writes. However, the overhead won't\ndisappear completely and it's best to keep the number of file operations to a\nminimum. As a contrived example, the following function writes 4MB in 2.5\nseconds when tested:\n\n```erlang\ncreate_file_slow(Name) ->\n    {ok, Fd} = file:open(Name, [raw, write, delayed_write, binary]),\n    create_file_slow_1(Fd, 4 bsl 20),\n    file:close(Fd).\n\ncreate_file_slow_1(_Fd, 0) ->\n    ok;\ncreate_file_slow_1(Fd, M) ->\n    ok = file:write(Fd, <<0>>),\n    create_file_slow_1(Fd, M - 1).\n```\n\nThe following functionally equivalent code writes 128 bytes per call to\n`write/2` and so does the same work in 0.08 seconds, which is roughly 30 times\nfaster:\n\n```erlang\ncreate_file(Name) ->\n    {ok, Fd} = file:open(Name, [raw, write, delayed_write, binary]),\n    create_file_1(Fd, 4 bsl 20),\n    file:close(Fd),\n    ok.\n\ncreate_file_1(_Fd, 0) ->\n    ok;\ncreate_file_1(Fd, M) when M >= 128 ->\n    ok = file:write(Fd, <<0:(128)/unit:8>>),\n    create_file_1(Fd, M - 128);\ncreate_file_1(Fd, M) ->\n    ok = file:write(Fd, <<0:(M)/unit:8>>),\n    create_file_1(Fd, M - 1).\n```\n\nWhen writing data it's generally more efficient to write a list of binaries\nrather than a list of integers. It is not needed to flatten a deep list before\nwriting. On Unix hosts, scatter output, which writes a set of buffers in one\noperation, is used when possible. In this way\n[`write(FD, [Bin1, Bin2 | Bin3])`](`write/2`) writes the contents of the\nbinaries without copying the data at all, except for perhaps deep down in the\noperating system kernel.\n\n> #### Warning {: .warning }\n>\n> If an error occurs when accessing an open file with module `m:io`, the process\n> handling the file exits. The dead file process can hang if a process tries to\n> access it later. This will be fixed in a future release.","ref":"file.html#module-performance"},{"type":"module","title":"See Also - file","doc":"`m:filename`","ref":"file.html#module-see-also"},{"type":"function","title":"file.advise/4","doc":"[`advise/4`](`advise/4`) can be used to announce an intention to access file\ndata in a specific pattern in the future, thus allowing the operating system to\nperform appropriate optimizations.\n\nOn some platforms, this function might have no effect.","ref":"file.html#advise/4"},{"type":"function","title":"file.allocate/3","doc":"[`allocate/3`](`allocate/3`) can be used to preallocate space for a file.\n\nThis function only succeeds in platforms that provide this feature.","ref":"file.html#allocate/3"},{"type":"function","title":"file.change_group/2","doc":"Changes group of a file. See `write_file_info/2`.","ref":"file.html#change_group/2"},{"type":"function","title":"file.change_mode/2","doc":"Changes permissions of a file. See `write_file_info/2`.","ref":"file.html#change_mode/2"},{"type":"function","title":"file.change_owner/2","doc":"Changes owner of a file. See `write_file_info/2`.","ref":"file.html#change_owner/2"},{"type":"function","title":"file.change_owner/3","doc":"Changes owner and group of a file. See `write_file_info/2`.","ref":"file.html#change_owner/3"},{"type":"function","title":"file.change_time/2","doc":"Changes the modification and access times of a file. See `write_file_info/2`.","ref":"file.html#change_time/2"},{"type":"function","title":"file.change_time/3","doc":"Changes the modification and last access times of a file. See\n`write_file_info/2`.","ref":"file.html#change_time/3"},{"type":"function","title":"file.close/1","doc":"Closes the file referenced by `IoDevice`. It mostly returns `ok`, except for\nsome severe errors such as out of memory.\n\nNotice that if option `delayed_write` was used when opening the file,\n[`close/1`](`close/1`) can return an old write error and not even try to close\nthe file. See `open/2`.","ref":"file.html#close/1"},{"type":"function","title":"file.consult/1","doc":"Reads Erlang terms, separated by `.`, from `Filename`. Returns one of the\nfollowing:\n\n- **`{ok, Terms}`** - The file was successfully read.\n\n- **`{error, atom()}`** - An error occurred when opening the file or reading it.\n  For a list of typical error codes, see `open/2`.\n\n- **`{error, {Line, Mod, Term}}`** - An error occurred when interpreting the\n  Erlang terms in the file. To convert the three-element tuple to an English\n  description of the error, use `format_error/1`.\n\n_Example:_\n\n```text\nf.txt:  {person, \"kalle\", 25}.\n        {person, \"pelle\", 30}.\n```\n\n```erlang\n1> file:consult(\"f.txt\").\n{ok,[{person,\"kalle\",25},{person,\"pelle\",30}]}\n```\n\nThe encoding of `Filename` can be set by a comment, as described in\n[`epp`](`m:epp#encoding`).","ref":"file.html#consult/1"},{"type":"function","title":"file.copy/2","doc":"Equivalent to  copy(Source, Destination, infinity) .","ref":"file.html#copy/2"},{"type":"function","title":"file.copy/3","doc":"Copies `ByteCount` bytes from `Source` to `Destination`. `Source` and\n`Destination` refer to either filenames or IO devices from, for example,\n[`open/2`](`open/2`).\n\nArgument `Modes` is a list of possible modes, see `open/2`, and defaults to\n`[]`.\n\nIf both `Source` and `Destination` refer to filenames, the files are opened with\n`[read, binary]` and `[write, binary]` prepended to their mode lists,\nrespectively, to optimize the copy.\n\nIf `Source` refers to a filename, it is opened with `read` mode prepended to the\nmode list before the copy, and closed when done.\n\nIf `Destination` refers to a filename, it is opened with `write` mode prepended\nto the mode list before the copy, and closed when done.\n\nReturns `{ok, BytesCopied}`, where `BytesCopied` is the number of bytes that was\ncopied, which can be less than `ByteCount` if end of file was encountered on the\nsource. If the operation fails, `{error, Reason}` is returned.\n\nTypical error reasons: as for `open/2` if a file had to be opened, and as for\n`read/2` and `write/2`.","ref":"file.html#copy/3"},{"type":"function","title":"file.datasync/1","doc":"Ensures that any buffers kept by the operating system (not by the Erlang runtime\nsystem) are written to disk. In many ways it resembles `fsync` but it does not\nupdate some of the metadata of the file, such as the access time. On some\nplatforms this function has no effect.\n\nApplications that access databases or log files often write a tiny data fragment\n(for example, one line in a log file) and then call `fsync()` immediately to\nensure that the written data is physically stored on the hard disk.\nUnfortunately, `fsync()` always initiates two write operations: one for the\nnewly written data and another one to update the modification time stored in the\n`inode`. If the modification time is not a part of the transaction concept,\n`fdatasync()` can be used to avoid unnecessary `inode` disk write operations.\n\nAvailable only in some POSIX systems, this call results in a call to `fsync()`,\nor has no effect in systems not providing the `fdatasync()` syscall.","ref":"file.html#datasync/1"},{"type":"type","title":"file.date_time/0","doc":"Must denote a valid date and time.","ref":"file.html#t:date_time/0"},{"type":"type","title":"file.deep_list/0","doc":"","ref":"file.html#t:deep_list/0"},{"type":"function","title":"file.del_dir/1","doc":"Tries to delete directory `Dir`. The directory must be empty before it can be\ndeleted. Returns `ok` if successful.\n\nTypical error reasons:\n\n- **`eacces`** - Missing search or write permissions for the parent directories\n  of `Dir`.\n\n- **`eexist`** - The directory is not empty.\n\n- **`enoent`** - The directory does not exist.\n\n- **`enotdir`** - A component of `Dir` is not a directory. On some platforms,\n  `enoent` is returned instead.\n\n- **`einval`** - Attempt to delete the current directory. On some platforms,\n  `eacces` is returned instead.","ref":"file.html#del_dir/1"},{"type":"function","title":"file.del_dir_r/1","doc":"Deletes file or directory `File`. If `File` is a directory, its contents is\nfirst recursively deleted. Returns:\n\n- **`ok`** - The operation completed without errors.\n\n- **`{error, posix()}`** - An error occurred when accessing or deleting `File`.\n  If some file or directory under `File` could not be deleted, `File` cannot be\n  deleted as it is non-empty, and `{error, eexist}` is returned.","ref":"file.html#del_dir_r/1"},{"type":"function","title":"file.delete/1","doc":"Equivalent to  delete(Filename, []) .","ref":"file.html#delete/1"},{"type":"function","title":"file.delete/2","doc":"Tries to delete file `Filename`. Returns `ok` if successful.\n\nIf the option `raw` is set, the file server is not called. This can be useful in\nparticular during the early boot stage when the file server is not yet\nregistered, to still be able to delete local files.\n\nTypical error reasons:\n\n- **`enoent`** - The file does not exist.\n\n- **`eacces`** - Missing permission for the file or one of its parents.\n\n- **`eperm`** - The file is a directory and the user is not superuser.\n\n- **`enotdir`** - A component of the filename is not a directory. On some\n  platforms, `enoent` is returned instead.\n\n- **`einval`** - `Filename` has an improper type, such as tuple.\n\n> #### Warning {: .warning }\n>\n> In a future release, a bad type for argument `Filename` will probably generate\n> an exception.","ref":"file.html#delete/2"},{"type":"type","title":"file.delete_option/0","doc":"","ref":"file.html#t:delete_option/0"},{"type":"function","title":"file.eval/1","doc":"Reads and evaluates Erlang expressions, separated by `.` (or `,`, a sequence of\nexpressions is also an expression) from `Filename`. The result of the evaluation\nis not returned; any expression sequence in the file must be there for its side\neffect.\n\nReturns one of the following:\n\n- **`ok`** - The file was read and evaluated.\n\n- **`{error, atom()}`** - An error occurred when opening the file or reading it.\n  For a list of typical error codes, see `open/2`.\n\n- **`{error, {Line, Mod, Term}}`** - An error occurred when interpreting the\n  Erlang expressions in the file. To convert the three-element tuple to an\n  English description of the error, use `format_error/1`.\n\nThe encoding of `Filename` can be set by a comment, as described in\n[`epp`](`m:epp#encoding`).","ref":"file.html#eval/1"},{"type":"function","title":"file.eval/2","doc":"The same as [`eval/1`](`eval/1`), but the variable bindings `Bindings` are used\nin the evaluation. For information about the variable bindings, see\n`m:erl_eval`.","ref":"file.html#eval/2"},{"type":"type","title":"file.fd/0","doc":"A file descriptor representing a file opened in [`raw`](`m:file#raw`) mode.","ref":"file.html#t:fd/0"},{"type":"type","title":"file.file_info/0","doc":"","ref":"file.html#t:file_info/0"},{"type":"type","title":"file.file_info_option/0","doc":"","ref":"file.html#t:file_info_option/0"},{"type":"type","title":"file.filename/0","doc":"A file name as returned from `m:file` API functions.\n\nSee the documentation of the `t:name_all/0` type.","ref":"file.html#t:filename/0"},{"type":"type","title":"file.filename_all/0","doc":"A file name as returned from `m:file` API functions.\n\nSee the documentation of the `t:name_all/0` type.","ref":"file.html#t:filename_all/0"},{"type":"function","title":"file.format_error/1","doc":"Given the error reason returned by any function in this module, returns a\ndescriptive string of the error in English.","ref":"file.html#format_error/1"},{"type":"function","title":"file.get_cwd/0","doc":"Returns `{ok, Dir}`, where `Dir` is the current working directory of the file\nserver.\n\n> #### Note {: .info }\n>\n> In rare circumstances, this function can fail on Unix. It can occur if read\n> permission does not exist for the parent directories of the current directory.\n\nA typical error reason:\n\n- **`eacces`** - Missing read permission for one of the parents of the current\n  directory.","ref":"file.html#get_cwd/0"},{"type":"function","title":"file.get_cwd/1","doc":"Returns `{ok, Dir}` or `{error, Reason}`, where `Dir` is the current working\ndirectory of the specified drive.\n\n`Drive` is to be of the form `Letter:`, for example, `c:`.\n\nReturns `{error, enotsup}` on platforms that have no concept of current drive\n(Unix, for example).\n\nTypical error reasons:\n\n- **`enotsup`** - The operating system has no concept of drives.\n\n- **`eacces`** - The drive does not exist.\n\n- **`einval`** - The format of `Drive` is invalid.","ref":"file.html#get_cwd/1"},{"type":"type","title":"file.io_device/0","doc":"An IO device as returned by `open/2`.\n\n`t:io_server/0` is returned by default and `t:fd/0` is returned if the `raw` option is given.","ref":"file.html#t:io_device/0"},{"type":"type","title":"file.io_server/0","doc":"A process handling the I/O protocol.","ref":"file.html#t:io_server/0"},{"type":"function","title":"file.list_dir/1","doc":"Lists all files in a directory, _except_ files with raw filenames. Returns\n`{ok, Filenames}` if successful, otherwise `{error, Reason}`. `Filenames` is a\nlist of the names of all the files in the directory. The names are not sorted.\n\nTypical error reasons:\n\n- **`eacces`** - Missing search or write permissions for `Dir` or one of its\n  parent directories.\n\n- **`enoent`** - The directory does not exist.\n\n- **`{no_translation, Filename}`** - `Filename` is a `t:binary/0` with\n  characters coded in ISO Latin-1 and the VM was started with parameter `+fnue`.","ref":"file.html#list_dir/1"},{"type":"function","title":"file.list_dir_all/1","doc":"Lists all the files in a directory, including files with\nraw filenames. Returns `{ok, Filenames}` if successful, otherwise\n`{error, Reason}`. `Filenames` is a list of the names of all the files in the\ndirectory. The names are not sorted.\n\nTypical error reasons:\n\n- **`eacces`** - Missing search or write permissions for `Dir` or one of its\n  parent directories.\n\n- **`enoent`** - The directory does not exist.","ref":"file.html#list_dir_all/1"},{"type":"type","title":"file.location/0","doc":"","ref":"file.html#t:location/0"},{"type":"function","title":"file.make_dir/1","doc":"Tries to create directory `Dir`. Missing parent directories are _not_ created.\nReturns `ok` if successful.\n\nTypical error reasons:\n\n- **`eacces`** - Missing search or write permissions for the parent directories\n  of `Dir`.\n\n- **`eexist`** - A file or directory named `Dir` exists already.\n\n- **`enoent`** - A component of `Dir` does not exist.\n\n- **`enospc`** - No space is left on the device.\n\n- **`enotdir`** - A component of `Dir` is not a directory. On some platforms,\n  `enoent` is returned instead.","ref":"file.html#make_dir/1"},{"type":"function","title":"file.make_link/2","doc":"Makes a hard link from `Existing` to `New` on platforms supporting links (Unix\nand Windows). This function returns `ok` if the link was successfully created,\notherwise `{error, Reason}`. On platforms not supporting links,\n`{error,enotsup}` is returned.\n\nTypical error reasons:\n\n- **`eacces`** - Missing read or write permissions for the parent directories of\n  `Existing` or `New`.\n\n- **`eexist`** - `New` already exists.\n\n- **`enotsup`** - Hard links are not supported on this platform.","ref":"file.html#make_link/2"},{"type":"function","title":"file.make_symlink/2","doc":"Creates a symbolic link `New` to the file or directory `Existing` on platforms\nsupporting symbolic links (most Unix systems and Windows, beginning with Vista).\n`Existing` does not need to exist. Returns `ok` if the link is successfully\ncreated, otherwise `{error, Reason}`. On platforms not supporting symbolic\nlinks, `{error, enotsup}` is returned.\n\nTypical error reasons:\n\n- **`eacces`** - Missing read or write permissions for the parent directories of\n  `Existing` or `New`.\n\n- **`eexist`** - `New` already exists.\n\n- **`enotsup`** - Symbolic links are not supported on this platform.\n\n- **`eperm`** - User does not have privileges to create symbolic links\n  (`SeCreateSymbolicLinkPrivilege` on Windows).","ref":"file.html#make_symlink/2"},{"type":"type","title":"file.mode/0","doc":"","ref":"file.html#t:mode/0"},{"type":"type","title":"file.name/0","doc":"A restricted file name used as input into `m:file` API functions.\n\nIf VM is in Unicode filename mode, `t:string/0` and `t:char/0` are allowed to\nbe > 255. See also the documentation of the `t:name_all/0` type.","ref":"file.html#t:name/0"},{"type":"type","title":"file.name_all/0","doc":"A file name used as input into `m:file` API functions.\n\nIf VM is in Unicode filename mode, characters are allowed to be > 255.\n`RawFilename` is a filename not subject to Unicode translation, meaning that it\ncan contain characters not conforming to the Unicode encoding expected from the\nfile system (that is, non-UTF-8 characters although the VM is started in Unicode\nfilename mode). Null characters (integer value zero) are _not_ allowed in\nfilenames (not even at the end).","ref":"file.html#t:name_all/0"},{"type":"function","title":"file.native_name_encoding/0","doc":"Returns the filename encoding mode. If it is `latin1`, the system translates no\nfilenames. If it is `utf8`, filenames are converted back and forth to the native\nfilename encoding (usually UTF-8, but UTF-16 on Windows).","ref":"file.html#native_name_encoding/0"},{"type":"function","title":"file.open/2","doc":"Opens file `File` in the mode determined by `Modes`, which can contain one or\nmore of the following options:\n\n- **`read`** - The file, which must exist, is opened for reading.\n\n- **`write`** - The file is opened for writing. It is created if it does not\n  exist. If the file exists and `write` is not combined with `read`, the file is\n  truncated.\n\n- **`append`** - The file is opened for writing. It is created if it does not\n  exist. Every write operation to a file opened with `append` takes place at the\n  end of the file.\n\n- **`exclusive`** - The file is opened for writing. It is created if it does not\n  exist. If the file exists, `{error, eexist}` is returned.\n\n  > #### Warning {: .warning }\n  >\n  > This option does not guarantee exclusiveness on file systems not supporting\n  > `O_EXCL` properly, such as NFS. Do not depend on this option unless you know\n  > that the file system supports it (in general, local file systems are safe).\n\n- **`raw`** - [](){: #raw } Allows faster access to a file, as no Erlang process\n  is needed to handle the file. However, a file opened in this way has the\n  following limitations:\n\n  - The functions in the `io` module cannot be used, as they can only talk to an\n    Erlang process. Instead, use functions `read/2`, `read_line/1`, and\n    `write/2`.\n  - Especially if [`read_line/1`](`read_line/1`) is to be used on a `raw` file,\n    it is recommended to combine this option with option `{read_ahead, Size}` as\n    line-oriented I/O is inefficient without buffering.\n  - Only the Erlang process that opened the file can use it.\n  - A remote Erlang file server cannot be used. The computer on which the Erlang\n    node is running must have access to the file system (directly or through\n    NFS).\n\n- **`binary`** - Read operations on the file return binaries rather than lists.\n\n- **`{delayed_write, Size, Delay}`** - Data in subsequent [`write/2`](`write/2`)\n  calls is buffered until at least `Size` bytes are buffered, or until the\n  oldest buffered data is `Delay` milliseconds old. Then all buffered data is\n  written in one operating system call. The buffered data is also flushed before\n  some other file operation than [`write/2`](`write/2`) is executed.\n\n  The purpose of this option is to increase performance by reducing the number\n  of operating system calls. Thus, the [`write/2`](`write/2`) calls must be for\n  sizes significantly less than `Size`, and not interspersed by too many other\n  file operations.\n\n  When this option is used, the result of [`write/2`](`write/2`) calls can\n  prematurely be reported as successful, and if a write error occurs, the error\n  is reported as the result of the next file operation, which is not executed.\n\n  For example, when `delayed_write` is used, after a number of\n  [`write/2`](`write/2`) calls, [`close/1`](`close/1`) can return\n  `{error, enospc}`, as there is not enough space on the disc for previously\n  written data. [`close/1`](`close/1`) must probably be called again, as the\n  file is still open.\n\n- **`delayed_write`** - The same as `{delayed_write, Size, Delay}` with\n  reasonable default values for `Size` and `Delay` (roughly some 64 KB, 2\n  seconds).\n\n- **`{read_ahead, Size}`** - Activates read data buffering. If\n  [`read/2`](`read/2`) calls are for significantly less than `Size` bytes, read\n  operations to the operating system are still performed for blocks of `Size`\n  bytes. The extra data is buffered and returned in subsequent\n  [`read/2`](`read/2`) calls, giving a performance gain as the number of\n  operating system calls is reduced.\n\n  The `read_ahead` buffer is also highly used by function\n  [`read_line/1`](`read_line/1`) in `raw` mode, therefore this option is\n  recommended (for performance reasons) when accessing raw files using that\n  function.\n\n  If [`read/2`](`read/2`) calls are for sizes not significantly less than, or\n  even greater than `Size` bytes, no performance gain can be expected.\n\n- **`read_ahead`** - The same as `{read_ahead, Size}` with a reasonable default\n  value for `Size` (roughly some 64 KB).\n\n- **`compressed`** - Makes it possible to read or write gzip compressed files.\n  Option `compressed` must be combined with `read` or `write`, but not both.\n  Notice that the file size obtained with `read_file_info/1` does probably not\n  match the number of bytes that can be read from a compressed file.\n\n- **`compressed_one`** - Read one member of a gzip compressed file. Option\n  `compressed_one` can only be combined with `read`.\n\n- **`{encoding, Encoding}`** - Makes the file perform automatic translation of\n  characters to and from a specific (Unicode) encoding. Notice that the data\n  supplied to `write/2` or returned by `read/2` still is byte-oriented; this\n  option denotes only how data is stored in the disk file.\n\n  Depending on the encoding, different methods of reading and writing data is\n  preferred. The default encoding of `latin1` implies using this module (`file`)\n  for reading and writing data as the interfaces provided here work with\n  byte-oriented data. Using other (Unicode) encodings makes the `m:io` functions\n  `get_chars`, `get_line`, and `put_chars` more suitable, as they can work with\n  the full Unicode range.\n\n  If data is sent to an `t:io_device/0` in a format that cannot be converted to\n  the specified encoding, or if data is read by a function that returns data in\n  a format that cannot cope with the character range of the data, an error\n  occurs and the file is closed.\n\n  Allowed values for `Encoding`:\n\n  - **`latin1`** - The default encoding. Bytes supplied to the file, that is,\n    `write/2` are written \"as is\" on the file. Likewise, bytes read from the\n    file, that is, `read/2` are returned \"as is\". If module `m:io` is used for\n    writing, the file can only cope with Unicode characters up to code point 255\n    (the ISO Latin-1 range).\n\n  - **`unicode or utf8`** - Characters are translated to and from UTF-8 encoding\n    before they are written to or read from the file. A file opened in this way\n    can be readable using function `read/2`, as long as no data stored on the\n    file lies beyond the ISO Latin-1 range (0..255), but failure occurs if the\n    data contains Unicode code points beyond that range. The file is best read\n    with the functions in the Unicode aware module `m:io`.\n\n    Bytes written to the file by any means are translated to UTF-8 encoding\n    before being stored on the disk file.\n\n  - **`utf16 or {utf16,big}`** - Works like `unicode`, but translation is done\n    to and from big endian UTF-16 instead of UTF-8.\n\n  - **`{utf16,little}`** - Works like `unicode`, but translation is done to and\n    from little endian UTF-16 instead of UTF-8.\n\n  - **`utf32 or {utf32,big}`** - Works like `unicode`, but translation is done\n    to and from big endian UTF-32 instead of UTF-8.\n\n  - **`{utf32,little}`** - Works like `unicode`, but translation is done to and\n    from little endian UTF-32 instead of UTF-8.\n\n  The Encoding can be changed for a file \"on the fly\" by using function\n  `io:setopts/2`. So a file can be analyzed in latin1 encoding for, for example,\n  a BOM, positioned beyond the BOM and then be set for the right encoding before\n  further reading. For functions identifying BOMs, see module `m:unicode`.\n\n  This option is not allowed on `raw` files.\n\n- **`ram`** - `File` must be `t:iodata/0`. Returns an `t:fd/0`, which lets\n  module `file` operate on the data in-memory as if it is a file.\n\n- **`sync`** - On platforms supporting it, enables the POSIX `O_SYNC`\n  synchronous I/O flag or its platform-dependent equivalent (for example,\n  `FILE_FLAG_WRITE_THROUGH` on Windows) so that writes to the file block until\n  the data is physically written to disk. However, be aware that the exact\n  semantics of this flag differ from platform to platform. For example, none of\n  Linux or Windows guarantees that all file metadata are also written before the\n  call returns. For precise semantics, check the details of your platform\n  documentation. On platforms with no support for POSIX `O_SYNC` or equivalent,\n  use of the `sync` flag causes `open` to return `{error, enotsup}`.\n\n- **`directory`** - Allows `open` to work on directories.\n\nReturns:\n\n- **`{ok, IoDevice}`** - The file is opened in the requested mode. `IoDevice` is\n  a reference to the file.\n\n- **`{error, Reason}`** - The file cannot be opened.\n\n`IoDevice` is really the pid of the process that handles the file. This process\nmonitors the process that originally opened the file (the owner process). If the\nowner process terminates, the file is closed and the process itself terminates\ntoo. An `IoDevice` returned from this call can be used as an argument to the I/O\nfunctions (see `m:io`).\n\n> #### Warning {: .warning }\n>\n> While this function can be used to open any file, we recommend against using\n> it for NFS-mounted files, FIFOs, devices, or similar since they can cause IO\n> threads to hang forever.\n>\n> If your application needs to interact with these kinds of files we recommend\n> breaking out those parts to a port program instead.\n\n> #### Note {: .info }\n>\n> In previous versions of `file`, modes were specified as one of the atoms\n> `read`, `write`, or `read_write` instead of a list. This is still allowed for\n> reasons of backwards compatibility, but is not to be used for new code. Also\n> note that `read_write` is not allowed in a mode list.\n\nTypical error reasons:\n\n- **`enoent`** - The file does not exist.\n\n- **`eacces`** - Missing permission for reading the file or searching one of the\n  parent directories.\n\n- **`eisdir`** - The named file is a directory.\n\n- **`enotdir`** - A component of the filename is not a directory, or the\n  filename itself is not a directory if `directory` mode was specified. On some\n  platforms, `enoent` is returned instead.\n\n- **`enospc`** - There is no space left on the device (if `write` access was\n  specified).","ref":"file.html#open/2"},{"type":"function","title":"file.path_consult/2","doc":"Searches the path `Path` (a list of directory names) until the file `Filename`\nis found. If `Filename` is an absolute filename, `Path` is ignored. Then reads\nErlang terms, separated by `.`, from the file.\n\nReturns one of the following:\n\n- **`{ok, Terms, FullName}`** - The file is successfully read. `FullName` is the\n  full name of the file.\n\n- **`{error, enoent}`** - The file cannot be found in any of the directories in\n  `Path`.\n\n- **`{error, atom()}`** - An error occurred when opening the file or reading it.\n  For a list of typical error codes, see `open/2`.\n\n- **`{error, {Line, Mod, Term}}`** - An error occurred when interpreting the\n  Erlang terms in the file. Use `format_error/1` to convert the three-element\n  tuple to an English description of the error.\n\nThe encoding of `Filename` can be set by a comment as described in\n[`epp`](`m:epp#encoding`).","ref":"file.html#path_consult/2"},{"type":"function","title":"file.path_eval/2","doc":"Searches the path `Path` (a list of directory names) until the file `Filename`\nis found. If `Filename` is an absolute filename, `Path` is ignored. Then reads\nand evaluates Erlang expressions, separated by `.` (or `,`, a sequence of\nexpressions is also an expression), from the file. The result of evaluation is\nnot returned; any expression sequence in the file must be there for its side\neffect.\n\nReturns one of the following:\n\n- **`{ok, FullName}`** - The file is read and evaluated. `FullName` is the full\n  name of the file.\n\n- **`{error, enoent}`** - The file cannot be found in any of the directories in\n  `Path`.\n\n- **`{error, atom()}`** - An error occurred when opening the file or reading it.\n  For a list of typical error codes, see `open/2`.\n\n- **`{error, {Line, Mod, Term}}`** - An error occurred when interpreting the\n  Erlang expressions in the file. Use `format_error/1` to convert the\n  three-element tuple to an English description of the error.\n\nThe encoding of `Filename` can be set by a comment as described in\n[`epp`](`m:epp#encoding`).","ref":"file.html#path_eval/2"},{"type":"function","title":"file.path_open/3","doc":"Searches the path `Path` (a list of directory names) until the file `Filename`\nis found. If `Filename` is an absolute filename, `Path` is ignored. Then opens\nthe file in the mode determined by `Modes`.\n\nReturns one of the following:\n\n- **`{ok, IoDevice, FullName}`** - The file is opened in the requested mode.\n  `IoDevice` is a reference to the file and `FullName` is the full name of the\n  file.\n\n- **`{error, enoent}`** - The file cannot be found in any of the directories in\n  `Path`.\n\n- **`{error, atom()}`** - The file cannot be opened.","ref":"file.html#path_open/3"},{"type":"function","title":"file.path_script/2","doc":"Searches the path `Path` (a list of directory names) until the file `Filename`\nis found. If `Filename` is an absolute filename, `Path` is ignored. Then reads\nand evaluates Erlang expressions, separated by `.` (or `,`, a sequence of\nexpressions is also an expression), from the file.\n\nReturns one of the following:\n\n- **`{ok, Value, FullName}`** - The file is read and evaluated. `FullName` is\n  the full name of the file and `Value` the value of the last expression.\n\n- **`{error, enoent}`** - The file cannot be found in any of the directories in\n  `Path`.\n\n- **`{error, atom()}`** - An error occurred when opening the file or reading it.\n  For a list of typical error codes, see `open/2`.\n\n- **`{error, {Line, Mod, Term}}`** - An error occurred when interpreting the\n  Erlang expressions in the file. Use `format_error/1` to convert the\n  three-element tuple to an English description of the error.\n\nThe encoding of `Filename` can be set by a comment as described in\n[`epp`](`m:epp#encoding`).","ref":"file.html#path_script/2"},{"type":"function","title":"file.path_script/3","doc":"The same as [`path_script/2`](`path_script/2`) but the variable bindings\n`Bindings` are used in the evaluation. See `m:erl_eval` about variable bindings.","ref":"file.html#path_script/3"},{"type":"function","title":"file.position/2","doc":"Sets the position of the file referenced by `IoDevice` to `Location`. Returns\n`{ok, NewPosition}` (as absolute offset) if successful, otherwise\n`{error, Reason}`. `Location` is one of the following:\n\n- **`Offset`** - The same as `{bof, Offset}`.\n\n- **`{bof, Offset}`** - Absolute offset.\n\n- **`{cur, Offset}`** - Offset from the current position.\n\n- **`{eof, Offset}`** - Offset from the end of file.\n\n- **`bof | cur | eof`** - The same as above with `Offset` 0.\n\nNotice that offsets are counted in bytes, not in characters. If the file is\nopened using some other `encoding` than `latin1`, one byte does not correspond\nto one character. Positioning in such a file can only be done to known character\nboundaries. That is, to a position earlier retrieved by getting a current\nposition, to the beginning/end of the file or to some other position _known_ to\nbe on a correct character boundary by some other means (typically beyond a byte\norder mark in the file, which has a known byte-size).\n\nA typical error reason is:\n\n- **`einval`** - Either `Location` is illegal, or it is evaluated to a negative\n  offset in the file. Notice that if the resulting position is a negative value,\n  the result is an error, and after the call the file position is undefined.","ref":"file.html#position/2"},{"type":"type","title":"file.posix/0","doc":"An atom that is named from the POSIX error codes used in Unix, and in the\nruntime libraries of most C compilers.","ref":"file.html#t:posix/0"},{"type":"type","title":"file.posix_file_advise/0","doc":"","ref":"file.html#t:posix_file_advise/0"},{"type":"function","title":"file.pread/2","doc":"Performs a sequence of [`pread/3`](`pread/3`) in one operation, which is more\nefficient than calling them one at a time. Returns `{ok, [Data, ...]}` or\n`{error, Reason}`, where each `Data`, the result of the corresponding `pread`,\nis either a list or a binary depending on the mode of the file, or `eof` if the\nrequested position is beyond end of file.\n\nAs the position is specified as a byte-offset, take special caution when working\nwith files where `encoding` is set to something else than `latin1`, as not every\nbyte position is a valid character boundary on such a file.","ref":"file.html#pread/2"},{"type":"function","title":"file.pread/3","doc":"Combines [`position/2`](`position/2`) and [`read/2`](`read/2`) in one operation,\nwhich is more efficient than calling them one at a time.\n\n`Location` is only allowed to be an integer for `raw` and `ram` modes.\n\nThe current position of the file after the operation is undefined for `raw` mode\nand unchanged for `ram` mode.\n\nAs the position is specified as a byte-offset, take special caution when working\nwith files where `encoding` is set to something else than `latin1`, as not every\nbyte position is a valid character boundary on such a file.","ref":"file.html#pread/3"},{"type":"function","title":"file.pwrite/2","doc":"Performs a sequence of [`pwrite/3`](`pwrite/3`) in one operation, which is more\nefficient than calling them one at a time. Returns `ok` or\n`{error, {N, Reason}}`, where `N` is the number of successful writes done before\nthe failure.\n\nWhen positioning in a file with other `encoding` than `latin1`, caution must be\ntaken to set the position on a correct character boundary. For details, see\n`position/2`.","ref":"file.html#pwrite/2"},{"type":"function","title":"file.pwrite/3","doc":"Combines [`position/2`](`position/2`) and [`write/2`](`write/2`) in one\noperation, which is more efficient than calling them one at a time.\n\n`Location` is only allowed to be an integer for `raw` and `ram` modes.\n\nThe current position of the file after the operation is undefined for `raw` mode\nand unchanged for `ram` mode.\n\nWhen positioning in a file with other `encoding` than `latin1`, caution must be\ntaken to set the position on a correct character boundary. For details, see\n`position/2`.","ref":"file.html#pwrite/3"},{"type":"function","title":"file.read/2","doc":"Reads `Number` bytes/characters from the file referenced by `IoDevice`.\n\nThe functions `read/2`, `pread/3`, and `read_line/1` are the only ways to read from\na file opened in `raw` mode (although they work for normally opened files, too).\n\nFor files where `encoding` is set to something else than `latin1`, one character\ncan be represented by more than one byte on the file. The parameter `Number`\nalways denotes the number of _characters_ read from the file, while the position\nin the file can be moved much more than this number when reading a Unicode file.\n\nAlso, if `encoding` is set to something else than `latin1`, the\n[`read/2`](`read/2`) call fails if the data contains characters larger than 255,\nwhich is why `io:get_chars/3` is to be preferred when reading such a file.\n\nThe function returns:\n\n- **`{ok, Data}`** - If the file was opened in binary mode, the read bytes are\n  returned in a binary, otherwise in a list. The list or binary is shorter than\n  the number of bytes requested if end of file was reached.\n\n- **`eof`** - Returned if `Number>0` and end of file was reached before anything\n  at all could be read.\n\n- **`{error, Reason}`** - An error occurred.\n\nTypical error reasons:\n\n- **`ebadf`** - The file is not opened for reading.\n\n- **`{no_translation, unicode, latin1}`** - The file is opened with another\n  `encoding` than `latin1` and the data in the file cannot be translated to the\n  byte-oriented data that this function returns.","ref":"file.html#read/2"},{"type":"function","title":"file.read_file/1","doc":"Equivalent to  read_file(Filename, []) .","ref":"file.html#read_file/1"},{"type":"function","title":"file.read_file/2","doc":"Returns `{ok, Binary}`, where `Binary` is a binary data object that contains the\ncontents of `Filename`, or `{error, Reason}` if an error occurs.\n\nIf the option `raw` is set, the file server is not called.\n\nTypical error reasons:\n\n- **`enoent`** - The file does not exist.\n\n- **`eacces`** - Missing permission for reading the file, or for searching one\n  of the parent directories.\n\n- **`eisdir`** - The named file is a directory.\n\n- **`enotdir`** - A component of the filename is not a directory. On some\n  platforms, `enoent` is returned instead.\n\n- **`enomem`** - There is not enough memory for the contents of the file.","ref":"file.html#read_file/2"},{"type":"function","title":"file.read_file_info/1","doc":"Equivalent to  read_file_info(File, []) .","ref":"file.html#read_file_info/1"},{"type":"function","title":"file.read_file_info/2","doc":"Retrieves information about a file. Returns `{ok, FileInfo}` if successful,\notherwise `{error, Reason}`.\n\n`FileInfo` is a record `file_info`, defined in the Kernel include file `file.hrl`.\nInclude the following directive in the module from which the function is called:\n\n```erlang\n-include_lib(\"kernel/include/file.hrl\").\n```\n\nThe time type returned in `atime`, `mtime`, and `ctime` is dependent on the time\ntype set in `Opts :: {time, Type}` as follows:\n\n- **`local`** - Returns local time.\n\n- **`universal`** - Returns universal time.\n\n- **`posix`** - Returns seconds since or before Unix time epoch, which is\n  1970-01-01 00:00 UTC.\n\nDefault is `{time, local}`.\n\nIf the option `raw` is set, the file server is not called and only information\nabout local files is returned. Note that this will break this module's atomicity\nguarantees as it can race with a concurrent call to\n[`write_file_info/1,2` ](`write_file_info/2`).\n\nThis option has no effect when the function is given an I/O device instead of a\nfile name. Use `open/2` with the `raw` mode to obtain a file descriptor first.\n\n> #### Note {: .info }\n>\n> As file times are stored in POSIX time on most OS, it is faster to query file\n> information with option `posix`.\n\nThe record `file_info` contains the following fields:\n\n- **`size = ` `t:non_neg_integer/0`** - Size of file in bytes.\n\n- **`type = device | directory | other | regular`** - The type of the file. Can\n  also contain `symlink` when returned from\n  [read_link_info/1,2](`read_link_info/1`).\n\n- **`access = read | write | read_write | none`** - The current system access to\n  the file.\n\n- **`atime = ` `t:date_time/0` ` | ` `t:non_neg_integer/0`** - The last time the file was\n  read.\n\n- **`mtime = ` `t:date_time/0` ` | ` `t:non_neg_integer/0`** - The last time the file was\n  written.\n\n- **`ctime = ` `t:date_time/0` ` | ` `t:non_neg_integer/0`** - The interpretation of this\n  time field depends on the operating system. On Unix, it is the last time the\n  file or the `inode` was changed. In Windows, it is the create time.\n\n- **`mode = ` `t:non_neg_integer/0`** - The file permissions as the sum of the following\n  bit values:\n\n  - **`8#00400`** - read permission: owner\n\n  - **`8#00200`** - write permission: owner\n\n  - **`8#00100`** - execute permission: owner\n\n  - **`8#00040`** - read permission: group\n\n  - **`8#00020`** - write permission: group\n\n  - **`8#00010`** - execute permission: group\n\n  - **`8#00004`** - read permission: other\n\n  - **`8#00002`** - write permission: other\n\n  - **`8#00001`** - execute permission: other\n\n  - **`16#800`** - set user id on execution\n\n  - **`16#400`** - set group id on execution\n\n  On Unix platforms, other bits than those listed above may be set.\n\n- **`links = ` `t:non_neg_integer/0`** - Number of links to the file (this is always 1\n  for file systems that have no concept of links).\n\n- **`major_device = ` `t:non_neg_integer/0`** - Identifies the file system where the\n  file is located. In Windows, the number indicates a drive as follows: 0 means\n  A:, 1 means B:, and so on.\n\n- **`minor_device = ` `t:non_neg_integer/0`** - Only valid for character devices on\n  Unix. In all other cases, this field is zero.\n\n- **`inode = ` `t:non_neg_integer/0`** - Gives the `inode` number. On non-Unix file\n  systems, this field is zero.\n\n- **`uid = ` `t:non_neg_integer/0`** - Indicates the owner of the file. On non-Unix file\n  systems, this field is zero.\n\n- **`gid = ` `t:non_neg_integer/0`** - Gives the group that the owner of the file\n  belongs to. On non-Unix file systems, this field is zero.\n\nTypical error reasons:\n\n- **`eacces`** - Missing search permission for one of the parent directories of\n  the file.\n\n- **`enoent`** - The file does not exist.\n\n- **`enotdir`** - A component of the filename is not a directory. On some\n  platforms, `enoent` is returned instead.","ref":"file.html#read_file_info/2"},{"type":"type","title":"file.read_file_option/0","doc":"","ref":"file.html#t:read_file_option/0"},{"type":"function","title":"file.read_line/1","doc":"Reads a line of bytes/characters from the file referenced by `IoDevice`.\n\nLines are defined to be delimited by the linefeed (LF, `\\n`) character, but any\ncarriage return (CR, `\\r`) followed by a newline is also treated as a single LF\ncharacter (the carriage return is silently ignored). The line is returned\n_including_ the LF, but excluding any CR immediately followed by an LF. This\nbehaviour is consistent with the behaviour of `io:get_line/2`. If end of file is\nreached without any LF ending the last line, a line with no trailing LF is\nreturned.\n\nThe function can be used on files opened in `raw` mode. However, it is\ninefficient to use it on `raw` files if the file is not opened with option\n`{read_ahead, Size}` specified. Thus, combining `raw` and `{read_ahead, Size}`\nis highly recommended when opening a text file for raw line-oriented reading.\n\nIf `encoding` is set to something else than `latin1`, the\n[`read_line/1`](`read_line/1`) call fails if the data contains characters larger\nthan 255, why `io:get_line/2` is to be preferred when reading such a file.\n\nThe function returns:\n\n- **`{ok, Data}`** - One line from the file is returned, including the trailing\n  LF, but with CRLF sequences replaced by a single LF (see above).\n\n  If the file is opened in binary mode, the read bytes are returned in a binary,\n  otherwise in a list.\n\n- **`eof`** - Returned if end of file was reached before anything at all could\n  be read.\n\n- **`{error, Reason}`** - An error occurred.\n\nTypical error reasons:\n\n- **`ebadf`** - The file is not opened for reading.\n\n- **`{no_translation, unicode, latin1}`** - The file is opened with another\n  `encoding` than `latin1` and the data on the file cannot be translated to the\n  byte-oriented data that this function returns.","ref":"file.html#read_line/1"},{"type":"function","title":"file.read_link/1","doc":"Returns `{ok, Filename}` if `Name` refers to a symbolic\nlink that is not a raw filename, or `{error, Reason}` otherwise. On platforms\nthat do not support symbolic links, the return value is `{error,enotsup}`.\n\nTypical error reasons:\n\n- **`einval`** - `Name` does not refer to a symbolic link or the name of the\n  file that it refers to does not conform to the expected encoding.\n\n- **`enoent`** - The file does not exist.\n\n- **`enotsup`** - Symbolic links are not supported on this platform.","ref":"file.html#read_link/1"},{"type":"function","title":"file.read_link_all/1","doc":"Returns `{ok, Filename}` if `Name` refers to a symbolic link or\n`{error, Reason}` otherwise. On platforms that do not support symbolic links,\nthe return value is `{error,enotsup}`.\n\nNotice that `Filename` can be either a list or a binary.\n\nTypical error reasons:\n\n- **`einval`** - `Name` does not refer to a symbolic link.\n\n- **`enoent`** - The file does not exist.\n\n- **`enotsup`** - Symbolic links are not supported on this platform.","ref":"file.html#read_link_all/1"},{"type":"function","title":"file.read_link_info/1","doc":"Equivalent to  read_link_info(Name, []) .","ref":"file.html#read_link_info/1"},{"type":"function","title":"file.read_link_info/2","doc":"Works like [`read_file_info/1,2`](`read_file_info/2`) except that if `Name` is a\nsymbolic link, information about the link is returned in the `file_info` record\nand the `type` field of the record is set to `symlink`.\n\nIf the option `raw` is set, the file server is not called and only information\nabout local files is returned. Note that this will break this module's atomicity\nguarantees as it can race with a concurrent call to\n[`write_file_info/1,2`](`write_file_info/2`)\n\nIf `Name` is not a symbolic link, this function returns the same result as\n[`read_file_info/1`](`read_file_info/1`). On platforms that do not support\nsymbolic links, this function is always equivalent to\n[`read_file_info/1`](`read_file_info/1`).","ref":"file.html#read_link_info/2"},{"type":"function","title":"file.rename/2","doc":"Tries to rename the file `Source` to `Destination`. It can be used to move files\n(and directories) between directories, but it is not sufficient to specify the\ndestination only. The destination filename must also be specified. For example,\nif `bar` is a normal file and `foo` and `baz` are directories,\n[`rename(\"foo/bar\", \"baz\")`](`rename/2`) returns an error, but\n[`rename(\"foo/bar\", \"baz/bar\")`](`rename/2`) succeeds. Returns `ok` if it is\nsuccessful.\n\n> #### Note {: .info }\n>\n> Renaming of open files is not allowed on most platforms (see `eacces` below).\n\nTypical error reasons:\n\n- **`eacces`** - Missing read or write permissions for the parent directories of\n  `Source` or `Destination`. On some platforms, this error is given if either\n  `Source` or `Destination` is open.\n\n- **`eexist`** - `Destination` is not an empty directory. On some platforms,\n  also given when `Source` and `Destination` are not of the same type.\n\n- **`einval`** - `Source` is a root directory, or `Destination` is a\n  subdirectory of `Source`.\n\n- **`eisdir`** - `Destination` is a directory, but `Source` is not.\n\n- **`enoent`** - `Source` does not exist.\n\n- **`enotdir`** - `Source` is a directory, but `Destination` is not.\n\n- **`exdev`** - `Source` and `Destination` are on different file systems.","ref":"file.html#rename/2"},{"type":"function","title":"file.script/1","doc":"Reads and evaluates Erlang expressions, separated by `.` (or `,`, a sequence of\nexpressions is also an expression), from the file.\n\nReturns one of the following:\n\n- **`{ok, Value}`** - The file is read and evaluated. `Value` is the value of\n  the last expression.\n\n- **`{error, atom()}`** - An error occurred when opening the file or reading it.\n  For a list of typical error codes, see `open/2`.\n\n- **`{error, {Line, Mod, Term}}`** - An error occurred when interpreting the\n  Erlang expressions in the file. Use `format_error/1` to convert the\n  three-element tuple to an English description of the error.\n\nThe encoding of `Filename` can be set by a comment as described in\n[`epp`](`m:epp#encoding`).","ref":"file.html#script/1"},{"type":"function","title":"file.script/2","doc":"The same as [`script/1`](`script/1`) but the variable bindings `Bindings` are\nused in the evaluation. See `m:erl_eval` about variable bindings.","ref":"file.html#script/2"},{"type":"function","title":"file.sendfile/2","doc":"Sends the file `Filename` to `Socket`. Returns `{ok, BytesSent}` if successful,\notherwise `{error, Reason}`.","ref":"file.html#sendfile/2"},{"type":"function","title":"file.sendfile/5","doc":"Sends `Bytes` from the file referenced by `RawFile` beginning at `Offset` to\n`Socket`. Returns `{ok, BytesSent}` if successful, otherwise `{error, Reason}`.\nIf `Bytes` is set to `0` all data after the specified `Offset` is sent.\n\nThe file used must be opened using the `raw` flag, and the process calling\n`sendfile` must be the controlling process of the socket. See\n`gen_tcp:controlling_process/2` or module [`socket`'s](`socket:setopt/3`)\n[level `otp` socket option ](`t:socket:otp_socket_option/0`)`controlling_process`.\n\nIf the OS used does not support non-blocking `sendfile`, an Erlang fallback\nusing `read/2` and `gen_tcp:send/2` is used.\n\nThe option list can contain the following options:\n\n- **`chunk_size`** - The chunk size used by the Erlang fallback to send data. If\n  using the fallback, set this to a value that comfortably fits in the systems\n  memory. Default is 20 MB.","ref":"file.html#sendfile/5"},{"type":"type","title":"file.sendfile_option/0","doc":"","ref":"file.html#t:sendfile_option/0"},{"type":"function","title":"file.set_cwd/1","doc":"Sets the current working directory of the file server to `Dir`. Returns `ok` if\nsuccessful.\n\nThe functions in the module `file` usually treat binaries as raw filenames, that\nis, they are passed \"as is\" even when the encoding of the binary does not agree\nwith [`native_name_encoding()`](`native_name_encoding/0`). However, this\nfunction expects binaries to be encoded according to the value returned by\n`native_name_encoding/0`.\n\nTypical error reasons are:\n\n- **`enoent`** - The directory does not exist.\n\n- **`enotdir`** - A component of `Dir` is not a directory. On some platforms,\n  `enoent` is returned.\n\n- **`eacces`** - Missing permission for the directory or one of its parents.\n\n- **`badarg`** - `Dir` has an improper type, such as tuple.\n\n- **`no_translation`** - `Dir` is a `t:binary/0` with characters coded in\n  ISO-latin-1 and the VM is operating with unicode filename encoding.\n\n> #### Warning {: .warning }\n>\n> In a future release, a bad type for argument `Dir` will probably generate an\n> exception.","ref":"file.html#set_cwd/1"},{"type":"function","title":"file.sync/1","doc":"Ensures that any buffers kept by the operating system (not by the Erlang runtime\nsystem) are written to disk. On some platforms, this function might have no\neffect.\n\nA typical error reason is:\n\n- **`enospc`** - Not enough space left to write the file.","ref":"file.html#sync/1"},{"type":"function","title":"file.truncate/1","doc":"Truncates the file referenced by `IoDevice` at the current position. Returns\n`ok` if successful, otherwise `{error, Reason}`.","ref":"file.html#truncate/1"},{"type":"function","title":"file.write/2","doc":"Writes `Bytes` to the file referenced by `IoDevice`. This function is the only\nway to write to a file opened in `raw` mode (although it works for normally\nopened files too). Returns `ok` if successful, and `{error, Reason}` otherwise.\n\nIf the file is opened with `encoding` set to something else than `latin1`, each\nbyte written can result in many bytes being written to the file, as the byte\nrange 0..255 can represent anything between one and four bytes depending on\nvalue and UTF encoding type. If you want to write `t:unicode:chardata/0` to the\n`IoDevice` you should use `io:put_chars/2` instead.\n\nTypical error reasons:\n\n- **`ebadf`** - The file is not opened for writing.\n\n- **`enospc`** - No space is left on the device.","ref":"file.html#write/2"},{"type":"function","title":"file.write_file/2","doc":"Writes the contents of the `iodata` term `Bytes` to file `Filename`. The file is\ncreated if it does not exist. If it exists, the previous contents are\noverwritten. Returns `ok` if successful, otherwise `{error, Reason}`.\n\nTypical error reasons:\n\n- **`enoent`** - A component of the filename does not exist.\n\n- **`enotdir`** - A component of the filename is not a directory. On some\n  platforms, `enoent` is returned instead.\n\n- **`enospc`** - No space is left on the device.\n\n- **`eacces`** - Missing permission for writing the file or searching one of the\n  parent directories.\n\n- **`eisdir`** - The named file is a directory.","ref":"file.html#write_file/2"},{"type":"function","title":"file.write_file/3","doc":"Same as [`write_file/2`](`write_file/2`), but takes a third argument `Modes`, a\nlist of possible modes, see `open/2`. The mode flags `binary` and `write` are\nimplicit, so they are not to be used.","ref":"file.html#write_file/3"},{"type":"function","title":"file.write_file_info/2","doc":"Equivalent to  write_file_info(Filename, FileInfo, []) .","ref":"file.html#write_file_info/2"},{"type":"function","title":"file.write_file_info/3","doc":"Changes file information. Returns `ok` if successful, otherwise\n`{error, Reason}`.\n\n`FileInfo` is a record `file_info`, defined in the Kernel\ninclude file `file.hrl`. Include the following directive in the module from\nwhich the function is called:\n\n```erlang\n-include_lib(\"kernel/include/file.hrl\").\n```\n\nThe time type set in `atime`, `mtime`, and `ctime` depends on the time type set\nin `Opts :: {time, Type}` as follows:\n\n- **`local`** - Interprets the time set as local.\n\n- **`universal`** - Interprets it as universal time.\n\n- **`posix`** - Must be seconds since or before Unix time epoch, which is\n  1970-01-01 00:00 UTC.\n\nDefault is `{time, local}`.\n\nIf the option `raw` is set, the file server is not called and only information\nabout local files is returned.\n\nThe following fields are used from the record, if they are specified:\n\n- **`atime = ` `t:date_time/0` ` | ` `t:non_neg_integer/0`** - The last time the file was\n  read.\n\n- **`mtime = ` `t:date_time/0` ` | ` `t:non_neg_integer/0`** - The last time the file was\n  written.\n\n- **`ctime = ` `t:date_time/0` ` | ` `t:non_neg_integer/0`** - On Unix, any value\n  specified for this field is ignored (the \"ctime\" for the file is set to the\n  current time). On Windows, this field is the new creation time to set for the\n  file.\n\n- **`mode = ` `t:non_neg_integer/0`** - The file permissions as the sum of the following\n  bit values:\n\n  - **`8#00400`** - Read permission: owner\n\n  - **`8#00200`** - Write permission: owner\n\n  - **`8#00100`** - Execute permission: owner\n\n  - **`8#00040`** - Read permission: group\n\n  - **`8#00020`** - Write permission: group\n\n  - **`8#00010`** - Execute permission: group\n\n  - **`8#00004`** - Read permission: other\n\n  - **`8#00002`** - Write permission: other\n\n  - **`8#00001`** - Execute permission: other\n\n  - **`16#800`** - Set user id on execution\n\n  - **`16#400`** - Set group id on execution\n\n  On Unix platforms, other bits than those listed above may be set.\n\n- **`uid = ` `t:non_neg_integer/0`** - Indicates the file owner. Ignored for non-Unix\n  file systems.\n\n- **`gid = ` `t:non_neg_integer/0`** - Gives the group that the file owner belongs to.\n  Ignored for non-Unix file systems.\n\nTypical error reasons:\n\n- **`eacces`** - Missing search permission for one of the parent directories of\n  the file.\n\n- **`enoent`** - The file does not exist.\n\n- **`enotdir`** - A component of the filename is not a directory. On some\n  platforms, `enoent` is returned instead.","ref":"file.html#write_file_info/3"},{"type":"module","title":"gen_sctp","doc":"Interface to SCTP sockets.\n\nThis module provides functions for communicating over SCTP sockets.\nThe implementation assumes that the OS kernel supports SCTP\n[(RFC 2960)](http://www.rfc-archive.org/getrfc.php?rfc=2960)\nthrough the user-level\n[Sockets API Extensions](http://tools.ietf.org/html/draft-ietf-tsvwg-sctpsocket-13).\n\nDuring development, this implementation was tested on:\n\n- Linux Fedora Core 5.0 (kernel 2.6.15-2054 or later is needed)\n- Solaris 10, 11\n\nDuring OTP adaptation it was tested on:\n\n- SUSE Linux Enterprise Server 10 (x86_64) kernel 2.6.16.27-0.6-smp, with\n  lksctp-tools-1.0.6\n- Briefly on Solaris 10\n- SUSE Linux Enterprise Server 10 Service Pack 1 (x86_64) kernel\n  2.6.16.54-0.2.3-smp with lksctp-tools-1.0.7\n- FreeBSD 8.2\n\nThis module was written for one-to-many style sockets (type `seqpacket`).\nWith the addition of `peeloff/2`, one-to-one style sockets (type `stream`)\nwere introduced.\n\nRecord definitions for this module can be found using:\n\n```erlang\n-include_lib(\"kernel/include/inet_sctp.hrl\").\n```\n\nThese record definitions use the \"new\" spelling 'adaptation',\nnot the deprecated 'adaption', regardless of which spelling\nthe underlying C API uses.\n\n[](){: #options } SCTP Socket Options\n-------------------------------------\n\nThe set of admissible SCTP socket options is by construction orthogonal\nto the sets of TCP, UDP, and generic `inet` options. Here are only\noptions listed that are allowed for SCTP sockets.\n\nOptions can be set on the socket when calling [`open/1,2`](`open/1`),\nand changed when calling [`connect/4,5`](`connect/4`) or\nby calling `inet:setopts/2`.  They can be retrieved using `inet:getopts/2`.\n\n- **`{mode, list|binary} | list | binary`** [](){: #option-binary } [](){: #option-list } -\n  Determines the type of data returned from [`recv/1,2`](`recv/1`)\n  or in _active mode_ data messages.\n\n- **`{active, false|true|once|N}`** [](){: #option-active }\n\n  - If `false` (_passive mode_, the default), the caller must do an explicit\n    [`recv`](`recv/1`) call to retrieve the available data from the socket.\n\n  - If `true|once|N` (_active modes_) received data or events are sent\n    to the owning process. See [`open/0..2`](`open/0`) for the message format.\n\n  - If `true` (fully _active mode_) there is no flow control.\n\n    > #### Note {: .info }\n    >\n    > Note that this can cause the message queue to overflow\n    > causing for example the virtual machine to run out of memory and crash.\n\n  - If `once`, only one message is automatically placed in the message queue,\n    and the mode resets to passive. This provides flow control\n    and the possibility for the receiver to listen for incoming\n    SCTP data interleaved with other inter-process messages.\n\n  - If `active` is specified as an integer `N` in the range -32768 to 32767\n    (inclusive), that number is added to the socket's data messages counter.\n    If the result of the addition is negative, the counter is set to `0`.\n    Once the counter reaches `0`, either through the delivery of messages\n    or by being explicitly set with `inet:setopts/2`, the socket mode\n    resets to passive (`{active, false}`). When a socket in `{active, N}`\n    mode transitions to passive mode, the message `{sctp_passive, Socket}`\n    is sent to the controlling process to notify that if it wants to receive\n    more data messages from the socket, it must call `inet:setopts/2`\n    to set the socket back into an active mode.\n\n- **`{tos, integer()}`** - Sets the Type-Of-Service field on the IP datagrams\n  that are sent, to the specified value. This effectively determines a\n  prioritization policy for the outbound packets. The acceptable values are\n  system-dependent.\n\n- **`{priority, integer()}`** - A protocol-independent equivalent of `tos`\n  above. Setting priority implies setting `tos` as well.\n\n- **`{dontroute, true|false}`** - Defaults to `false`.\n  If `true`, the kernel does not send packets through any gateway,\n  but only sends them to directly connected hosts.\n\n- **`{reuseaddr, true|false}`** - Defaults to `false`.\n  If `true`, the local binding address `{IP,Port}` of the socket can be\n  reused immediately. No waiting in state `CLOSE_WAIT` is performed\n  (can be required for some types of servers).\n\n- **`{sndbuf, integer()}`** - The size, in bytes, of the OS kernel send buffer\n  for this socket. Sending errors would occur for datagrams larger than\n  `val(sndbuf)`. Setting this option also adjusts the size of\n  the driver buffer (see `buffer` above).\n\n- **`{recbuf, integer()}`** - The size, in bytes, of the OS kernel receive\n  buffer for this socket. Sending errors would occur for datagrams\n  larger than `val(recbuf)`. Setting this option also adjusts the size\n  of the driver buffer (see `buffer` above).\n\n### [](){: #option_non_block_send }\n\n- **`{non_block_send, boolean()}`** - A send call that would otherwise block (hang),\n  will instead immediately return with e.g. `{error, eagain}`\n  *if* this option has been set to `true`.\n  Defaults to `false`.\n\n- **`{sctp_module, module()}`** - Overrides which callback module is used.\nDefaults to `inet_sctp` for IPv4 and `inet6_sctp` for IPv6.\n\n- **`{sctp_rtoinfo, #sctp_rtoinfo{}}`**\n\n  ```erlang\n  #sctp_rtoinfo{\n        assoc_id = assoc_id(),\n        initial  = integer(),\n        max      = integer(),\n        min      = integer()\n  }\n  ```\n\n  Determines retransmission time-out parameters, in milliseconds, for the\n  association(s) specified by `assoc_id`.\n\n  `assoc_id = 0` (default) indicates the whole endpoint. See\n  [RFC 2960](http://www.rfc-archive.org/getrfc.php?rfc=2960) and\n  [Sockets API Extensions for SCTP](http://tools.ietf.org/html/draft-ietf-tsvwg-sctpsocket-13)\n  for the exact semantics of the field values.\n\n- **`{sctp_associnfo, #sctp_assocparams{}}`**\n\n  ```erlang\n  #sctp_assocparams{\n        assoc_id                 = assoc_id(),\n        asocmaxrxt               = integer(),\n        number_peer_destinations = integer(),\n        peer_rwnd                = integer(),\n        local_rwnd               = integer(),\n        cookie_life              = integer()\n  }\n  ```\n\n  Determines association parameters for the association(s) specified by\n  `assoc_id`.\n\n  `assoc_id = 0` (default) indicates the whole endpoint. See\n  [Sockets API Extensions for SCTP](http://tools.ietf.org/html/draft-ietf-tsvwg-sctpsocket-13)\n  for the discussion of their semantics. Rarely used.\n\n- **`{sctp_initmsg, #sctp_initmsg{}}`**\n\n  ```erlang\n  #sctp_initmsg{\n       num_ostreams   = integer(),\n       max_instreams  = integer(),\n       max_attempts   = integer(),\n       max_init_timeo = integer()\n  }\n  ```\n\n  Determines the default parameters that this socket tries to negotiate\n  with its peer while establishing an association with it. Is to be set after\n  [`open/*`](`open/1`) but before the first [`connect/*`](`connect/4`).\n  `#sctp_initmsg{}` can also be used as ancillary data with the first call of\n  [`send/*`](`send/3`) to a new peer (when a new association is created).\n\n  - **`num_ostreams`** - Number of outbound streams\n\n  - **`max_instreams`** - Maximum number of inbound streams\n\n  - **`max_attempts`** - Maximum retransmissions while establishing an\n    association\n\n  - **`max_init_timeo`** - Time-out, in milliseconds, for establishing an\n    association\n\n- **`{sctp_autoclose, integer() >= 0}`** - Determines the time, in seconds,\n  after which an idle association is automatically closed. `0` means that the\n  association is never automatically closed.\n\n- **`{sctp_nodelay, true|false}`** - Turns off (`true`) / on (`false`) the Nagle\n  algorithm for merging small packets into larger ones. This improves throughput\n  at the expense of latency.\n\n- **`{sctp_disable_fragments, true|false}`** - If `true`, induces an error on an\n  attempt to send a message larger than the current PMTU size (which would\n  require fragmentation/reassembling). Notice that message fragmentation does\n  not affect the logical atomicity of its delivery; this option is provided for\n  performance reasons only.\n\n- **`{sctp_i_want_mapped_v4_addr, true|false}`** - Turns on|off automatic\n  mapping of IPv4 addresses into IPv6 ones (if the socket address family is\n  `AF_INET6`).\n\n- **`{sctp_maxseg, integer()}`** - Determines the maximum chunk size if message\n  fragmentation is used. If `0`, the chunk size is limited by the Path MTU only.\n\n- **`{sctp_primary_addr, #sctp_prim{}}`**\n\n  ```erlang\n  #sctp_prim{\n        assoc_id = assoc_id(),\n        addr     = {IP, Port}\n  }\n   IP = ip_address()\n   Port = port_number()\n  ```\n\n  For the association specified by `assoc_id`, `{IP,Port}` must be one of the\n  peer addresses. This option determines that the specified address is treated\n  by the local SCTP stack as the primary address of the peer.\n\n- **`{sctp_set_peer_primary_addr, #sctp_setpeerprim{}}`**\n\n  ```erlang\n  #sctp_setpeerprim{\n        assoc_id = assoc_id(),\n        addr     = {IP, Port}\n  }\n   IP = ip_address()\n   Port = port_number()\n  ```\n\n  When set, informs the peer to use `{IP, Port}` as the primary address of the\n  local endpoint for the association specified by `assoc_id`.\n\n\n- **`{sctp_adaptation_layer, #sctp_setadaptation{}}`** [](){: #option-sctp_adaptation_layer }\n\n  ```erlang\n  #sctp_setadaptation{\n        adaptation_ind = integer()\n  }\n  ```\n\n  When set, requests that the local endpoint uses the value specified by\n  `adaptation_ind` as the Adaptation Indication parameter for establishing\n  new associations. For details, see\n  [RFC 2960](http://www.rfc-archive.org/getrfc.php?rfc=2960) and\n  [Sockets API Extensions for SCTP](http://tools.ietf.org/html/draft-ietf-tsvwg-sctpsocket-13).\n\n- **`{sctp_peer_addr_params, #sctp_paddrparams{}}`**\n\n  ```erlang\n  #sctp_paddrparams{\n        assoc_id   = assoc_id(),\n        address    = {IP, Port},\n        hbinterval = integer(),\n        pathmaxrxt = integer(),\n        pathmtu    = integer(),\n        sackdelay  = integer(),\n        flags      = list()\n  }\n  IP = ip_address()\n  Port = port_number()\n  ```\n\n  Determines various per-address parameters for the association specified by\n  `assoc_id` and the peer address `address` (the SCTP protocol supports\n  multi-homing, so more than one address can correspond to a specified\n  association).\n\n  - **`hbinterval`** - Heartbeat interval, in milliseconds\n\n  - **`pathmaxrxt`** - Maximum number of retransmissions before this address is\n    considered unreachable (and an alternative address is selected)\n\n  - **`pathmtu`** - Fixed Path MTU, if automatic discovery is disabled (see\n    `flags` below)\n\n  - **`sackdelay`** - Delay, in milliseconds, for SAC messages (if the delay is\n    enabled, see `flags` below)\n\n  - **`flags`** - The following flags are available:\n\n    - **`hb_enable`** - Enables heartbeat\n\n    - **`hb_disable`** - Disables heartbeat\n\n    - **`hb_demand`** - Initiates heartbeat immediately\n\n    - **`pmtud_enable`** - Enables automatic Path MTU discovery\n\n    - **`pmtud_disable`** - Disables automatic Path MTU discovery\n\n    - **`sackdelay_enable`** - Enables SAC delay\n\n    - **`sackdelay_disable`** - Disables SAC delay\n\n- **`{sctp_default_send_param, #sctp_sndrcvinfo{}}`**\n\n  [](){: #record-sctp_sndrcvinfo }\n  ```erlang\n  #sctp_sndrcvinfo{\n        stream     = integer(),\n        ssn        = integer(),\n        flags      = list(),\n        ppid       = integer(),\n        context    = integer(),\n        timetolive = integer(),\n        tsn        = integer(),\n        cumtsn     = integer(),\n        assoc_id   = assoc_id()\n  }\n  ```\n\n  `#sctp_sndrcvinfo{}` is used both in this socket option, and as\n  ancillary data while sending or receiving SCTP messages. When set\n  as an option, it provides default values for subsequent\n  [`send`](`send/3`) calls on the association specified by `assoc_id`.\n\n  `assoc_id = 0` (default) indicates the whole endpoint.\n\n  The following fields typically must be specified by the sender:\n\n  - **`sinfo_stream`** - Stream number (0-base) within the association to send\n    the messages through;\n\n  - **`sinfo_flags`** - The following flags are recognised:\n\n    - **`unordered`** - The message is to be sent unordered\n\n    - **`addr_over`** - The address specified in [`send`](`send/3`) overwrites\n      the primary peer address\n\n    - **`abort`** - Aborts the current association without flushing any unsent\n      data\n\n    - **`eof`** - Gracefully shuts down the current association, with flushing\n      of unsent data\n\n    Other fields are rarely used. For complete information, see\n    [RFC 2960](http://www.rfc-archive.org/getrfc.php?rfc=2960) and\n    [Sockets API Extensions for SCTP](http://tools.ietf.org/html/draft-ietf-tsvwg-sctpsocket-13).\n\n- **`{sctp_events, #sctp_event_subscribe{}}`** [](){: #option-sctp_events }\n\n  ```erlang\n  #sctp_event_subscribe{\n          data_io_event          = true | false,\n          association_event      = true | false,\n          address_event          = true | false,\n          send_failure_event     = true | false,\n          peer_error_event       = true | false,\n          shutdown_event         = true | false,\n          partial_delivery_event = true | false,\n          adaptation_layer_event = true | false\n  }\n  ```\n\n  This option determines which [SCTP Events](#sctp-events) that are to be\n  received (through [`recv/*`](`recv/1`)) along with the data. The only\n  exception is `data_io_event`, which enables or disables receiving of\n  [`#sctp_sndrcvinfo{}`](#record-sctp_sndrcvinfo) ancillary data,\n  not events. By default, all flags except `adaptation_layer_event` are enabled,\n  although `sctp_data_io_event` and `association_event` are used by the driver\n  itself and not exported to the user level.\n\n- **`{sctp_delayed_ack_time, #sctp_assoc_value{}}`**\n\n  ```erlang\n  #sctp_assoc_value{\n        assoc_id    = assoc_id(),\n        assoc_value = integer()\n  }\n  ```\n\n  Rarely used. Determines the ACK time (specified by `assoc_value`, in\n  milliseconds) for the specified association or the whole endpoint if\n  `assoc_value = 0` (default).\n\n- **`{sctp_status, #sctp_status{}}`**\n\n  ```erlang\n  #sctp_status{\n        assoc_id            = assoc_id(),\n        state               = atom(),\n        rwnd                = integer(),\n        unackdata           = integer(),\n        penddata            = integer(),\n        instrms             = integer(),\n        outstrms            = integer(),\n        fragmentation_point = integer(),\n        primary             = #sctp_paddrinfo{}\n  }\n  ```\n\n  This option is read-only. It determines the status of the SCTP association\n  specified by `assoc_id`. The following are the possible values of `state`\n  (the state designations are mostly self-explanatory):\n\n  - **`sctp_state_empty`** - Default. Means that no other state is active.\n\n  - **`sctp_state_closed`**\n\n  - **`sctp_state_cookie_wait`**\n\n  - **`sctp_state_cookie_echoed`**\n\n  - **`sctp_state_established`**\n\n  - **`sctp_state_shutdown_pending`**\n\n  - **`sctp_state_shutdown_sent`**\n\n  - **`sctp_state_shutdown_received`**\n\n  - **`sctp_state_shutdown_ack_sent`**\n\n  Semantics of the other fields:\n\n  - **`sstat_rwnd`** - Current receiver window size of the association\n\n  - **`sstat_unackdata`** - Number of unacked data chunks\n\n  - **`sstat_penddata`** - Number of data chunks pending receipt\n\n  - **`sstat_instrms`** - Number of inbound streams\n\n  - **`sstat_outstrms`** - Number of outbound streams\n\n  - **`sstat_fragmentation_point`** - Message size at which SCTP fragmentation\n    occurs\n\n  - **`sstat_primary`** - Information on the current primary peer address (see\n    below for the format of `#sctp_paddrinfo{}`)\n\n\n- **`{sctp_get_peer_addr_info, #sctp_paddrinfo{}}`** [](){: #option-sctp_get_peer_addr_info }\n\n  ```erlang\n  #sctp_paddrinfo{\n        assoc_id  = assoc_id(),\n        address   = {IP, Port},\n        state     = inactive | active | unconfirmed,\n        cwnd      = integer(),\n        srtt      = integer(),\n        rto       = integer(),\n        mtu       = integer()\n  }\n  IP = ip_address()\n  Port = port_number()\n  ```\n\n  This option is read-only. It determines the parameters specific to\n  the peer address specified by `address` within the association specified\n  by `assoc_id`.  Field `address` fmust be set by the caller; all other fields\n  are filled in on return. If `assoc_id = 0` (default), the `address`\n  is automatically translated into the corresponding association ID.\n  This option is rarely used. For the semantics of all fields, see\n  [RFC 2960](http://www.rfc-archive.org/getrfc.php?rfc=2960) and\n  [Sockets API Extensions for SCTP](http://tools.ietf.org/html/draft-ietf-tsvwg-sctpsocket-13).\n\n[](){: #examples } SCTP Examples\n--------------------------------\n\nExample of an Erlang SCTP server that receives SCTP messages\nand prints them on the standard output:\n\n```erlang\n-module(sctp_server).\n\n-export([server/0,server/1,server/2]).\n-include_lib(\"kernel/include/inet.hrl\").\n-include_lib(\"kernel/include/inet_sctp.hrl\").\n\nserver() ->\n    server(any, 2006).\n\nserver([Host,Port]) when is_list(Host), is_list(Port) ->\n    {ok, #hostent{h_addr_list = [IP|_]}} = inet:gethostbyname(Host),\n    io:format(\"~w -> ~w~n\", [Host, IP]),\n    server([IP, list_to_integer(Port)]).\n\nserver(IP, Port) when is_tuple(IP) orelse IP == any orelse IP == loopback,\n                      is_integer(Port) ->\n    {ok,S} = gen_sctp:open(Port, [{recbuf,65536}, {ip,IP}]),\n    io:format(\"Listening on ~w:~w. ~w~n\", [IP,Port,S]),\n    ok     = gen_sctp:listen(S, true),\n    server_loop(S).\n\nserver_loop(S) ->\n    case gen_sctp:recv(S) of\n    {error, Error} ->\n        io:format(\"SCTP RECV ERROR: ~p~n\", [Error]);\n    Data ->\n        io:format(\"Received: ~p~n\", [Data])\n    end,\n    server_loop(S).\n```\n\nExample of an Erlang SCTP client interacting with the above server.\nNote that in this example the client creates an association with\nthe server with 5 outbound streams. Therefore, sending of `\"Test 0\"`\nover stream 0 succeeds, but sending of `\"Test 5\"` over stream 5 fails.\nThe client then `abort`s the association, which results in that\nthe corresponding event is received on the server side.\n\n```erlang\n-module(sctp_client).\n\n-export([client/0, client/1, client/2]).\n-include_lib(\"kernel/include/inet.hrl\").\n-include_lib(\"kernel/include/inet_sctp.hrl\").\n\nclient() ->\n    client([localhost]).\n\nclient([Host]) ->\n    client(Host, 2006);\n\nclient([Host, Port]) when is_list(Host), is_list(Port) ->\n    client(Host,list_to_integer(Port)),\n    init:stop().\n\nclient(Host, Port) when is_integer(Port) ->\n    {ok,S}     = gen_sctp:open(),\n    {ok,Assoc} = gen_sctp:connect\n        (S, Host, Port, [{sctp_initmsg,#sctp_initmsg{num_ostreams=5}}]),\n    io:format(\"Connection Successful, Assoc=~p~n\", [Assoc]),\n\n    io:write(gen_sctp:send(S, Assoc, 0, <<\"Test 0\">>)),\n    io:nl(),\n    timer:sleep(10000),\n    io:write(gen_sctp:send(S, Assoc, 5, <<\"Test 5\">>)),\n    io:nl(),\n    timer:sleep(10000),\n    io:write(gen_sctp:abort(S, Assoc)),\n    io:nl(),\n\n    timer:sleep(1000),\n    gen_sctp:close(S).\n```\n\nA simple Erlang SCTP client that uses the `connect_init` API:\n\n```erlang\n-module(ex3).\n\n-export([client/4]).\n-include_lib(\"kernel/include/inet.hrl\").\n-include_lib(\"kernel/include/inet_sctp.hrl\").\n\nclient(Peer1, Port1, Peer2, Port2)\n  when is_tuple(Peer1), is_integer(Port1), is_tuple(Peer2), is_integer(Port2) ->\n    {ok,S}     = gen_sctp:open(),\n    SctpInitMsgOpt = {sctp_initmsg,#sctp_initmsg{num_ostreams=5}},\n    ActiveOpt = {active, true},\n    Opts = [SctpInitMsgOpt, ActiveOpt],\n    ok = gen_sctp:connect(S, Peer1, Port1, Opts),\n    ok = gen_sctp:connect(S, Peer2, Port2, Opts),\n    io:format(\"Connections initiated~n\", []),\n    client_loop(S, Peer1, Port1, undefined, Peer2, Port2, undefined).\n\nclient_loop(S, Peer1, Port1, AssocId1, Peer2, Port2, AssocId2) ->\n    receive\n        {sctp, S, Peer1, Port1, {_Anc, SAC}}\n          when is_record(SAC, sctp_assoc_change), AssocId1 == undefined ->\n            io:format(\"Association 1 connect result: ~p. AssocId: ~p~n\",\n                      [SAC#sctp_assoc_change.state,\n                       SAC#sctp_assoc_change.assoc_id]),\n            client_loop(S, Peer1, Port1, SAC#sctp_assoc_change.assoc_id,\n                        Peer2, Port2, AssocId2);\n\n        {sctp, S, Peer2, Port2, {_Anc, SAC}}\n          when is_record(SAC, sctp_assoc_change), AssocId2 == undefined ->\n            io:format(\"Association 2 connect result: ~p. AssocId: ~p~n\",\n                      [SAC#sctp_assoc_change.state, SAC#sctp_assoc_change.assoc_id]),\n            client_loop(S, Peer1, Port1, AssocId1, Peer2, Port2,\n                       SAC#sctp_assoc_change.assoc_id);\n\n        {sctp, S, Peer1, Port1, Data} ->\n            io:format(\"Association 1: received ~p~n\", [Data]),\n            client_loop(S, Peer1, Port1, AssocId1,\n                        Peer2, Port2, AssocId2);\n\n        {sctp, S, Peer2, Port2, Data} ->\n            io:format(\"Association 2: received ~p~n\", [Data]),\n            client_loop(S, Peer1, Port1, AssocId1,\n                        Peer2, Port2, AssocId2);\n\n        Other ->\n            io:format(\"Other ~p~n\", [Other]),\n            client_loop(S, Peer1, Port1, AssocId1,\n                        Peer2, Port2, AssocId2)\n\n    after 5000 ->\n            ok\n    end.\n```\n\n[](){: #seealso } See Also\n--------------------------\n\n`m:gen_tcp`, `m:gen_udp`, `m:inet`,\n[RFC 2960](http://www.rfc-archive.org/getrfc.php?rfc=2960) (Stream Control\nTransmission Protocol),\n[Sockets API Extensions for SCTP](http://tools.ietf.org/html/draft-ietf-tsvwg-sctpsocket-13)","ref":"gen_sctp.html"},{"type":"function","title":"gen_sctp.abort/2","doc":"Abort an association.\n\nAbnormally terminates the association specified by `Assoc`,\nwithout flushing unsent data.  The socket itself remains open.\nOther associations opened on this socket are still valid,\nand the socket can be used in new associations.","ref":"gen_sctp.html#abort/2"},{"type":"type","title":"gen_sctp.assoc_id/0","doc":"Association ID.\n\nAn opaque term returned in, for example, `#sctp_paddr_change{}`, which\nidentifies an association for an SCTP socket. The term is opaque except for the\nspecial value `0`, which has a meaning such as \"the whole endpoint\" or \"all\nfuture associations\".","ref":"gen_sctp.html#t:assoc_id/0"},{"type":"function","title":"gen_sctp.close/1","doc":"Close an SCTP socket.\n\nCloses the socket and all associations on it. The unsent data is flushed\nas for `eof/2`. The [`close/1`](`close/1`) call is blocking\ndepending of the value of the [`linger`](`m:inet#option-linger`)\nsocket [option]. If it is `false` or the linger time-out expires,\nthe call returns and unsent data is flushed in the background.","ref":"gen_sctp.html#close/1"},{"type":"function","title":"gen_sctp.connect/3","doc":"Equivalent to  connect(Socket, SockAddr, Opts, infinity) .","ref":"gen_sctp.html#connect/3"},{"type":"function","title":"gen_sctp.connect/4","doc":"Establish an association with a peer.\n\nWith arguments `Addr` and `Port`, equivalent to\n[`connect(Socket, Addr, Port, Opts, infinity)`](`connect/5`).\n\nWith arguments `SockAddr` and `Opts` _(since OTP 24.3)_, equivalent to\n[`connect(Socket, Addr, Port, Opts, Timeout)`](`connect/5`)\nwhere `Addr` and `Port` are extracted from `SockAddr`.","ref":"gen_sctp.html#connect/4"},{"type":"function","title":"gen_sctp.connect/5","doc":"Establish an association with a peer.\n\nEstablishes a new association for socket `Socket`, with the peer\n(SCTP server socket) specified by `Addr` and `Port`.\n`Timeout`, is expressed in milliseconds.\nA socket can be associated with multiple peers.\nThe socket has to be of type `seqpacket`.\n\n> #### Warning {: .warning }\n>\n> Using a value of `Timeout` less than the maximum time taken by the OS to\n> establish an association (around 4.5 minutes if the default values from\n> [RFC 4960](https://tools.ietf.org/html/rfc4960) are used), can result in\n> inconsistent or incorrect return values. This is especially relevant for\n> associations sharing the same `Socket` (that is, source address and port), as\n> the controlling process blocks until `connect/*` returns.\n> [`connect_init/*`](`connect_init/4`) provides an alternative without this\n> limitation.\n\n### [](){: #record-sctp_assoc_change } `#sctp_assoc_change{}`\n\nThe result of `connect/*` is an `#sctp_assoc_change{}` event that contains,\nin particular, the new [Association ID](`t:assoc_id/0`):\nl\n```erlang\n#sctp_assoc_change{\n      state             = atom(),\n      error             = integer(),\n      outbound_streams  = integer(),\n      inbound_streams   = integer(),\n      assoc_id          = assoc_id()\n}\n```\n\nThe number of outbound and inbound streams for the association\ncan be set by giving an `sctp_initmsg` option to `connect` as in:\n\n```erlang\nconnect(Socket, Ip, Port>,\n      [{sctp_initmsg,#sctp_initmsg{num_ostreams=OutStreams,\n                                   max_instreams=MaxInStreams}}])\n```\n\nAll options `Opt` are set on the socket before the association is attempted.\nIf an option record has undefined field values, the options record\nis first read from the socket for those values. In effect,\n`Opt` option records only need to define field values to change\nbefore connecting.\n\nThe returned `outbound_streams` and `inbound_streams` are the number of\nstream on the socket. These can be different from the requested values\n(`OutStreams` and `MaxInStreams`, respectively), if the peer\nrequires lower values.\n\n`state` can have the following values:\n\n- **`comm_up`** - Association is successfully established. This indicates\n  a successful completion of `connect`.\n\n- **`cant_assoc`** - The association cannot be established\n  (`connect/*` failure).\n\nOther states do not normally occur in the output from `connect/*`.\nRather, they can occur in `#sctp_assoc_change{}` events received\ninstead of data from [`recv/*`](`recv/1`) calls or socket messages.\nAll of them indicate losing the association because of various\nerror conditions, and are listed here for the sake of completeness:\n\n- **`comm_lost`**\n\n- **`restart`**\n\n- **`shutdown_comp`**\n\nThe field `error` can provide more detailed diagnostics.  Its value\ncan be converted into a string using `error_string/1`.","ref":"gen_sctp.html#connect/5"},{"type":"function","title":"gen_sctp.connect_init/3","doc":"Equivalent to  connect_init(Socket, SockAddr, Opts, infinity) .","ref":"gen_sctp.html#connect_init/3"},{"type":"function","title":"gen_sctp.connect_init/4","doc":"Start establishing an association with a peer.\n\nWith arguments `Addr` and `Port`, equivalent to\n[`connect_init(Socket, Addr, Port, Opts, infinity)`](`connect/5`).\n\nWith arguments `SockAddr` and `Opts` _(since OTP 24.3)_, equivalent to\n[`connect_init(Socket, Addr, Port, Opts, Timeout)`](`connect/5`)\nwhere `Addr` and `Port` are extracted from `SockAddr`.","ref":"gen_sctp.html#connect_init/4"},{"type":"function","title":"gen_sctp.connect_init/5","doc":"Start establishing an association with a peer.\n\nInitiates a new association for socket `Socket`, with the peer\n(SCTP server socket) specified by `Addr` and `Port`.\n\nThe fundamental difference between this API and `connect/*` is that\nthe return value is that of the underlying OS `connect(2)` system call.\nIf `ok` is returned, the operation has been succesfully initiated,\nand the final result result of the association establishment\nis sent to the socket owner (controlling process) as an\n[`#sctp_assoc_change{}`](#record-sctp_assoc_change) event.\nThe socket owner must be prepared to receive this, the\n[`recv/*`](`recv/1`) call has to be polled, depending on the value\nof the [active option](#option-active).\n\nThe parameters are as described for [`connect/*`](`connect/5`),\nexcept the `Timeout` value since for this function, the time-out only\napplies to the name resolving of `Addr` when it is a `t:inet:hostname/0`.","ref":"gen_sctp.html#connect_init/5"},{"type":"function","title":"gen_sctp.connectx_init/3","doc":"Start establishing an association with a peer (multiple addresses).\n\nSimilar to `connectx_init/5` except using socket addresses, and not having a\n`Timeout`. Since the addresses do not need lookup and the connect is\nnon-blocking this call returns immediately.\n\nThe value of each socket address `port` must be the same or zero.\nAt least one socket address must have a non-zero `port`","ref":"gen_sctp.html#connectx_init/3"},{"type":"function","title":"gen_sctp.connectx_init/4","doc":"Equivalent to  connectx_init(Socket, Addrs, Port, Opts, infinity) .","ref":"gen_sctp.html#connectx_init/4"},{"type":"function","title":"gen_sctp.connectx_init/5","doc":"Start establishing an association with a peer (multiple addresses).\n\nInitiates a new association for socket `Socket`, with the peer\n(SCTP server socket) specified by `Addrs` and `Port`.\n\nThis API is similar to `connect_init/*` except the underlying OS\n`sctp_connectx(3)` system call is used, that accepts multiple\ndestination addresses.\n\nIf successful, the association ID is returned which will be received in a\nsubsequent [`#sctp_assoc_change{}`](#record-sctp_assoc_change)\nevent.\n\nThe parameters are as described in `connect_init/5`\n\n> #### Note {: .info }\n> This API allows the OS to use all Addrs when establishing an association,\n> but does not guarantee it will. Therefore, if the connection fails,\n> the user may want to rotate the order of addresses for a subsequent call.","ref":"gen_sctp.html#connectx_init/5"},{"type":"function","title":"gen_sctp.controlling_process/2","doc":"Change the controlling process (owner) of a socket.\n\nAssigns a new controlling process `Pid` to `Socket`.\nSee `gen_udp:controlling_process/2`.","ref":"gen_sctp.html#controlling_process/2"},{"type":"type","title":"gen_sctp.elementary_option/0","doc":"","ref":"gen_sctp.html#t:elementary_option/0"},{"type":"type","title":"gen_sctp.elementary_option_name/0","doc":"","ref":"gen_sctp.html#t:elementary_option_name/0"},{"type":"function","title":"gen_sctp.eof/2","doc":"Terminate an association gracefully.\n\nGracefully terminates the association specified by `Assoc`, flushing\nall unsent data. The socket itself remains open.  Other associations\nopened on this socket are still valid.  The socket can be used\nin new associations.","ref":"gen_sctp.html#eof/2"},{"type":"function","title":"gen_sctp.error_string/1","doc":"Translate an error number into a string or atom.\n\nTranslates an SCTP error number from, for example, `#sctp_remote_error{}`\nor `#sctp_send_failed{}` into an explanatory string, or into\none of the atoms `ok` for no error, or `unknown_error`\nfor an unrecognized integer.","ref":"gen_sctp.html#error_string/1"},{"type":"function","title":"gen_sctp.listen/2","doc":"Make an SCTP socket listen to incoming associations.\n\nThe socket will listen on the IP address(es) and port number it is bound to.\n\nFor type `seqpacket`, sockets (the default), the argument`IsServer`\nmust be a `t:boolean/0`.  In contrast to `stream` sockets, there is\nno listening queue length.  If `IsServer` is `true`, the socket accepts\nnew associations, that is, it becomes an SCTP server socket.\n\nFor type `stream` sockets, the argument `Backlog` sets\nthe backlog queue length just like for TCP.","ref":"gen_sctp.html#listen/2"},{"type":"function","title":"gen_sctp.open/0","doc":"Equivalent to  open([]) .","ref":"gen_sctp.html#open/0"},{"type":"function","title":"gen_sctp.open/1","doc":"Create an SCTP socket.\n\nWith argument [`Port`](`t:inet:port_number/0`),\nequivalent to`open([{port, Port}]`.\n\nCreates an SCTP socket and binds it to the local addresses specified by all\n`{ip,IP}` (or synonymously `{ifaddr,IP}`) options (this feature is called\nSCTP multi-homing). The default `IP` and `Port` are `any` and `0`,\nmeaning bind to all local addresses on any free port.\n\nIt is also possible to use `{ifaddr, SockAddr}`, in which case it takes\nprecedence over the `ip` and `port` options. These options can however\nbe used to update the address and port of ifaddr (if they occur\nafter ifaddr in the options list), although this is not recommended.\n\nOther options:\n\n- **`inet6`** - Sets up the socket for IPv6.\n\n- **`inet`** - Sets up the socket for IPv4. This is the default.\n\nA default set of socket [options](#options) is used.\nIn particular, the socket is opened in [binary](#option-binary)\nand [passive](#option-active) mode, with SockType `seqpacket`,\nand with reasonably large [kernel](`m:inet#option-sndbuf`) and driver\n[buffers](`m:inet#option-buffer`).\n\nWhen the socket is in [passive](#option-active) mode,\ndata can be received through the [`recv/1,2`](`recv/1`) calls.\n\nWhen the socket is in [active](#option-active) mode,\ndata received data is delivered to the controlling process as messages:\n\n```erlang\n{sctp, Socket, FromIP, FromPort, {AncData, Data}}\n```\n\nSee [`recv/1,2`](`recv/1`) for a description of the message fields.\n\n> #### Note {: .info }\n>\n> This message format unfortunately differs slightly from the\n> [`gen_udp`](`gen_udp:open/1`) message format with ancillary data,\n> and from the [`recv/1,2`](`recv/1`) return tuple format.","ref":"gen_sctp.html#open/1"},{"type":"function","title":"gen_sctp.open/2","doc":"Equivalent to  open([{port, Port} | Opts]) .","ref":"gen_sctp.html#open/2"},{"type":"type","title":"gen_sctp.option/0","doc":"[SCTP Socket Option](#options) name and value, to set.","ref":"gen_sctp.html#t:option/0"},{"type":"type","title":"gen_sctp.option_name/0","doc":"[SCTP Socket Option](#options) name, to get.","ref":"gen_sctp.html#t:option_name/0"},{"type":"type","title":"gen_sctp.option_value/0","doc":"[SCTP Socket Option](#options) name and value, what you get.","ref":"gen_sctp.html#t:option_value/0"},{"type":"function","title":"gen_sctp.peeloff/2","doc":"Branch off an association into a new socket of type `stream`.\n\nThe existing association `Assoc` in the socket `Socket` (that has to\nbe of type `seqpacket`; one-to-many style) is branched off into\na new socket `NewSocket` of type `stream` (one-to-one style).\n\nThe existing association argument `Assoc` can be a\n[`#sctp_assoc_change{}`](#record-sctp_assoc_change) record as\nreturned from, for example, [`recv/*`](`recv/2`), [`connect/*`](`connect/5`),\nor from a listening socket in active mode.\nIt can also be just the field `assoc_id` `t:integer/0` from such a record.","ref":"gen_sctp.html#peeloff/2"},{"type":"type","title":"gen_sctp.record_option/0","doc":"","ref":"gen_sctp.html#t:record_option/0"},{"type":"function","title":"gen_sctp.recv/1","doc":"Equivalent to  recv(Socket, infinity) .","ref":"gen_sctp.html#recv/1"},{"type":"function","title":"gen_sctp.recv/2","doc":"Receive a `Data` message.\n\nReceives the `Data` message from any association of the socket.\nIf the receive times out, `{error,timeout}` is returned. The default\ntime-out is `infinity`. `FromIP` and `FromPort` indicate the address\nof the sender.\n\n`AncData` is a list of ancillary data items received with the main `Data`.\nThis list can be empty, or contain a single\n[`#sctp_sndrcvinfo{}`](#record-sctp_sndrcvinfo) record,\nif receiving ancillary data is enabled\n(see option [`sctp_events`](#option-sctp_events)).\nPer default, it is enabled, as such ancillary data provides an easy way\nto determine the association and stream over which the message was received.\n(An alternative way is to get the association ID from `FromIP` and `FromPort`\nusing socket option\n[`sctp_get_peer_addr_info`](#option-sctp_get_peer_addr_info),\nbut this does still not give the stream number).\n\n`AncData` may also contain [ancillary data](`t:inet:ancillary_data/0`)\nfrom the socket [options](#options)\n[`recvtos`](`m:inet#option-recvtos`),\n[`recvtclass`](`m:inet#option-recvtclass`) or\n[`recvttl`](`m:inet#option-recvttl`), if that is supported for the socket\nby the platform.\n\nThe `Data` received can, depending on the socket [mode](#option-binary)\nbe a `t:binary/0` or a `t:list/0` of bytes (integers in the range\n`0` through `255`), or it can be an SCTP event.\n\n### [](){: #sctp-events } Possible SCTP events\n\n- [`#sctp_sndrcvinfo{}`](#record-sctp_sndrcvinfo)\n- [`#sctp_assoc_change{}`](#record-sctp_assoc_change)\n- ```erlang\n  #sctp_paddr_change{\n        addr      = {ip_address(),port()},\n        state     = atom(),\n        error     = integer(),\n        assoc_id  = assoc_id()\n  }\n  ```\n\n  Indicates change of the status of the IP address of the peer specified by\n  `addr` within association `assoc_id`. Possible values of `state` (mostly\n  self-explanatory) include:\n\n  - **`addr_unreachable`**\n\n  - **`addr_available`**\n\n  - **`addr_removed`**\n\n  - **`addr_added`**\n\n  - **`addr_made_prim`**\n\n  - **`addr_confirmed`**\n\n  In case of an error (for example, `addr_unreachable`), the field `error`\n  provides more diagnostics. In such cases, event `#sctp_paddr_change{}`\n  is automatically converted into an `error` term returned by\n  [`recv`](`recv/1`). The `error` field value can be converted\n  into a string using `error_string/1`.\n\n- ```erlang\n  #sctp_send_failed{\n        flags     = true | false,\n        error     = integer(),\n        info      = #sctp_sndrcvinfo{},\n        assoc_id  = assoc_id()\n        data      = binary()\n  }\n  ```\n\n  The sender can receive this event if a send operation fails.\n\n  - **`flags`** - A Boolean specifying if the data has been transmitted\n    over the wire.\n\n  - **`error`** - Provides extended diagnostics, use\n    [`error_string/1`.](`error_string/1`)\n\n  - **`info`** - The original\n    [`#sctp_sndrcvinfo{}`](#record-sctp_sndrcvinfo) record\n    used in the failed [`send/*`.](`send/3`)\n\n  - **`data`** - The whole original data chunk attempted to be sent.\n\n  In the current implementation of the Erlang/SCTP binding, this event is\n  internally converted into an `error` term returned by [`recv/*`](`recv/1`).\n\n- ```erlang\n  #sctp_adaptation_event{\n        adaptation_ind = integer(),\n        assoc_id       = assoc_id()\n  }\n  ```\n\n  Delivered when a peer sends an adaptation layer indication parameter\n  (configured through option\n  [`sctp_adaptation_layer`](#option-sctp_adaptation_layer)).\n  Notie that with the current implementation of the Erlang/SCTP binding,\n  this event is disabled by default.\n\n- ```erlang\n  #sctp_pdapi_event{\n        indication = sctp_partial_delivery_aborted,\n        assoc_id   = assoc_id()\n  }\n  ```\n\n  A partial delivery failure. In the current implementation\n  of the Erlang/SCTP binding, this event is internally converted\n  into an `error` term returned by [`recv/*`](`recv/1`).","ref":"gen_sctp.html#recv/2"},{"type":"type","title":"gen_sctp.ro_option/0","doc":"","ref":"gen_sctp.html#t:ro_option/0"},{"type":"type","title":"gen_sctp.sctp_socket/0","doc":"Socket identifier returned from [`open/*`](`open/0`).","ref":"gen_sctp.html#t:sctp_socket/0"},{"type":"function","title":"gen_sctp.send/3","doc":"Send a `Data` message, full-featured.\n\nSends the `Data` message with all sending parameters from a\n[`#sctp_sndrcvinfo{}`](#record-sctp_sndrcvinfo) record.\nThis way, the user can specify the PPID (passed to the remote end)\nand context (passed to the local SCTP layer), which can be used,\nfor example, for error identification.  However, such a fine grained\nuser control is rarely required. The function [`send/4`](`send/4`)\nis sufficient for most applications.\n\n> #### Note {: .info }\n>\n> Send is normally blocking, but if the socket option\n> [`non_block_send`](#option_non_block_send) is set to true,\n> the function will return with e.g. {error, eagain}\n> in the case when the function would otherwise block.\n> It is then up to the user to try again later.","ref":"gen_sctp.html#send/3"},{"type":"function","title":"gen_sctp.send/4","doc":"Send a data message.\n\nSends a `Data` message on the association `Assoc` and `Stream`.\n\n`Assoc` can be specified with a\n[`#sctp_assoc_change{}`](#record-sctp_assoc_change) record\nfrom an association establishment, or as the `t:assoc_id/0`\n`t:integer/0` field value.\n\n> #### Note {: .info }\n>\n> Send is normally blocking, but if the socket option\n> [`non_block_send`](#option_non_block_send) is set to true,\n> the function will return with e.g. {error, eagain}\n> in the case when the function would otherwise block.\n> It is then up to the user to try again later.","ref":"gen_sctp.html#send/4"},{"type":"module","title":"gen_tcp","doc":"Interface to TCP/IP sockets.\n\nThis module provides functions for communicating over TCP/IP\nprotocol sockets.\n\nThe following code fragment is a simple example of a client connecting to a\nserver at port 5678, transferring a binary, and closing the connection:\n\n```erlang\nclient() ->\n    SomeHostInNet = \"localhost\", % to make it runnable on one machine\n    {ok, Sock} = gen_tcp:connect(SomeHostInNet, 5678,\n                                 [binary, {packet, 0}]),\n    ok = gen_tcp:send(Sock, \"Some Data\"),\n    ok = gen_tcp:close(Sock).\n```\n\nAt the other end, a server is listening on port 5678, accepts the connection,\nand receives the binary:\n\n```erlang\nserver() ->\n    {ok, LSock} = gen_tcp:listen(5678, [binary, {packet, 0},\n                                        {active, false}]),\n    {ok, Sock} = gen_tcp:accept(LSock),\n    {ok, Bin} = do_recv(Sock, []),\n    ok = gen_tcp:close(Sock),\n    ok = gen_tcp:close(LSock),\n    Bin.\n\ndo_recv(Sock, Bs) ->\n    case gen_tcp:recv(Sock, 0) of\n        {ok, B} ->\n            do_recv(Sock, [Bs, B]);\n        {error, closed} ->\n            {ok, list_to_binary(Bs)}\n    end.\n```\n\nFor more examples, see section [Examples](#module-examples).\n\n> #### Note {: .info }\n>\n> Functions that create sockets can take an optional option;\n> `{inet_backend, Backend}` that, if specified, has to be the first option. This\n> selects the implementation backend towards the platform's socket API.\n>\n> This is a _temporary_ option that will be ignored in a future release.\n>\n> The default is `Backend = inet` that selects the traditional `inet_drv.c`\n> driver. The other choice is `Backend = socket` that selects the new `m:socket`\n> module and its NIF implementation.\n>\n> The system default can be changed when the node is started with the\n> application `kernel`'s configuration variable `inet_backend`.\n>\n> For `gen_tcp` with `inet_backend = socket` we have tried to be as \"compatible\"\n> as possible which has sometimes been impossible. Here is a list of cases when\n> the behaviour of inet-backend `inet` (default) and `socket` are different:\n>\n> - [Non-blocking send](#non_blocking_send)\n>\n>   If a user calling [`gen_tcp:send/2`](`send/2`) with `inet_backend = inet`,\n>   tries to send more data than there is room for in the OS buffers, the \"rest\n>   data\" is buffered by the inet driver (and later sent in the background). The\n>   effect for the user is that the call is non-blocking.\n>\n>   This is _not_ the effect when `inet_backend = socket`, since there is no\n>   buffering. Instead the user hangs either until all data has been sent or the\n>   `send_timeout` timeout has been reached.\n>\n> - `shutdown/2` may hide errors\n>\n>   The call does not involve the receive process state, and is done\n>   right on the underlying socket.  On for example Linux, it is a known\n>   misbehaviour that it skips some checks so doing shutdown on a\n>   listen socket returns `ok` while the logical result should have been\n>   `{error, enotconn}`.  The `inet_drv.c` driver did an extra check\n>   and simulated the correct error, but with `Backend = socket`\n>   it would introduce overhead to involve the receive process.\n>\n> - The option [nodelay](`m:inet#option-nodelay`) is a TCP specific option that\n>   is _not_ compatible with `domain = local`.\n>\n>   When using `inet_backend = socket`, trying to create a socket (via listen or\n>   connect) with `domain = local` (for example with option \\{ifaddr,\n>   \\{local,\"/tmp/test\"\\}\\}) _will fail_ with `{error, enotsup}`.\n>\n>   This does not actually work for `inet_backend = inet` either, but in that\n>   case the error is simply _ignored_, which is a _bad_ idea. We have chosen to\n>   _not_ ignore this error for `inet_backend = socket`.\n>\n> - [Async shutdown write](#async_shutdown_write)\n>\n>   Calling [gen_tcp:shutdown(Socket, write | read_write)](`shutdown/2`) on a\n>   socket created with `inet_backend = socket` will take _immediate_ effect,\n>   unlike for a socket created with `inet_backend = inet`.\n>\n>   See [async shutdown write](#async_shutdown_write) for more info.\n>\n> - Windows require sockets (domain = `inet | inet6`) to be bound.\n>\n>   _Currently_ all sockets created on Windows with `inet_backend = socket` will\n>   be bound. If the user does not provide an address, gen_tcp will try to\n>   'figure out' an address itself.","ref":"gen_tcp.html"},{"type":"module","title":"Examples - gen_tcp","doc":"The following example illustrates use of option `{active,once}` and multiple\naccepts by implementing a server as a number of worker processes doing accept on\na single listening socket. Function `start/2` takes the number of worker\nprocesses and the port number on which to listen for incoming connections. If\n`LPort` is specified as `0`, an ephemeral port number is used, which is why the\nstart function returns the actual port number allocated:\n\n```erlang\nstart(Num,LPort) ->\n    case gen_tcp:listen(LPort,[{active, false},{packet,2}]) of\n        {ok, ListenSock} ->\n            start_servers(Num,ListenSock),\n            {ok, Port} = inet:port(ListenSock),\n            Port;\n        {error,Reason} ->\n            {error,Reason}\n    end.\n\nstart_servers(0,_) ->\n    ok;\nstart_servers(Num,LS) ->\n    spawn(?MODULE,server,[LS]),\n    start_servers(Num-1,LS).\n\nserver(LS) ->\n    case gen_tcp:accept(LS) of\n        {ok,S} ->\n            loop(S),\n            server(LS);\n        Other ->\n            io:format(\"accept returned ~w - goodbye!~n\",[Other]),\n            ok\n    end.\n\nloop(S) ->\n    inet:setopts(S,[{active,once}]),\n    receive\n        {tcp,S,Data} ->\n            Answer = process(Data), % Not implemented in this example\n            gen_tcp:send(S,Answer),\n            loop(S);\n        {tcp_closed,S} ->\n            io:format(\"Socket ~w closed [~w]~n\",[S,self()]),\n            ok\n    end.\n```\n\nExample of a simple client:\n\n```erlang\nclient(PortNo,Message) ->\n    {ok,Sock} = gen_tcp:connect(\"localhost\",PortNo,[{active,false},\n                                                    {packet,2}]),\n    gen_tcp:send(Sock,Message),\n    A = gen_tcp:recv(Sock,0),\n    gen_tcp:close(Sock),\n    A.\n```\n\nThe `send` call does not accept a time-out option because time-outs on send is\nhandled through socket option `send_timeout`. The behavior of a send operation\nwith no receiver is mainly defined by the underlying TCP stack and the network\ninfrastructure. To write code that handles a hanging receiver that can\neventually cause the sender to hang on a `send` do like the following.\n\nConsider a process that receives data from a client process to be forwarded to a\nserver on the network. The process is connected to the server through TCP/IP and\ndoes not get any acknowledge for each message it sends, but has to rely on the\nsend time-out option to detect that the other end is unresponsive. Option\n`send_timeout` can be used when connecting:\n\n```erlang\n...\n{ok,Sock} = gen_tcp:connect(HostAddress, Port,\n                            [{active,false},\n                             {send_timeout, 5000},\n                             {packet,2}]),\n                loop(Sock), % See below\n...\n```\n\nIn the loop where requests are handled, send time-outs can now be detected:\n\n```erlang\nloop(Sock) ->\n    receive\n        {Client, send_data, Binary} ->\n            case gen_tcp:send(Sock,[Binary]) of\n                {error, timeout} ->\n                    io:format(\"Send timeout, closing!~n\",\n                              []),\n                    handle_send_timeout(), % Not implemented here\n                    Client ! {self(),{error_sending, timeout}},\n                    %% Usually, it's a good idea to give up in case of a\n                    %% send timeout, as you never know how much actually\n                    %% reached the server, maybe only a packet header?!\n                    gen_tcp:close(Sock);\n                {error, OtherSendError} ->\n                    io:format(\"Some other error on socket (~p), closing\",\n                              [OtherSendError]),\n                    Client ! {self(),{error_sending, OtherSendError}},\n                    gen_tcp:close(Sock);\n                ok ->\n                    Client ! {self(), data_sent},\n                    loop(Sock)\n            end\n    end.\n```\n\nUsually it suffices to detect time-outs on receive, as most protocols include\nsome sort of acknowledgment from the server, but if the protocol is strictly one\nway, option `send_timeout` comes in handy.","ref":"gen_tcp.html#module-examples"},{"type":"function","title":"gen_tcp.accept/1","doc":"Equivalent to  accept(ListenSocket, infinity) .","ref":"gen_tcp.html#accept/1"},{"type":"function","title":"gen_tcp.accept/2","doc":"Accept an incoming connection request on a listen socket.\n\n`Socket` must be a socket returned from `listen/2`. `Timeout` specifies\na time-out value in milliseconds. Defaults to `infinity`.\n\nReturns:\n\n- `{ok, Socket}` if a connection is established\n- `{error, closed}` if `ListenSocket` is closed\n- `{error, timeout}` if no connection is established within `Timeout`\n- `{error, system_limit}` if all available ports in the Erlang emulator\n  are in  use\n- A POSIX error value if something else goes wrong, see `m:inet`\n  about possible values\n\nTo send packets (outbound) on the returned `Socket`, use `send/2`.\nPackets sent from the peer (inbound) are delivered as messages\nto the socket owner; the process that created the socket.\nUnless `{active, false}` is specified in the option list when creating\nthe [listening socket](`listen/2`).\n\nSee `connect/4` about _active mode_ socket messages and _passive mode_.\n\n> #### Note {: .info }\n>\n> The `accept` call _doesn't have to be_ issued from the socket owner process.\n> Using version 5.5.3 and higher of the emulator, multiple simultaneous accept\n> calls can be issued from different processes, which allows for a pool of\n> acceptor processes handling incoming connections.","ref":"gen_tcp.html#accept/2"},{"type":"function","title":"gen_tcp.close/1","doc":"Close a TCP socket.\n\nNote that in most implementations of TCP, doing a `close` does not guarantee\nthat the data sent is delivered to the recipient.  It is guaranteed that\nthe recepient will see all sent data before getting the close, but the\nsender gets no indication of that.\n\nIf the sender needs to know that the recepient has received all data\nthere are two common ways to achieve this:\n\n1. Use [`gen_tcp:shutdown(Sock, write)`](`shutdown/2`) to signal that no more\n   data is to be sent and wait for the other side to acknowledge seeing\n   its read side being closed, by closing its write side, which shows\n   as a socket close on this side.\n2. Implement an acknowledgement in the protocol on top of TCP\n   that both connection ends adhere to, indicating that all data\n   has been seen.  The socket option [`{packet, N}`](`m:inet#option-packet`)\n   may be useful.","ref":"gen_tcp.html#close/1"},{"type":"function","title":"gen_tcp.connect/2","doc":"Equivalent to [`connect(SockAddr, Opts, infinity)`](`connect/3`).","ref":"gen_tcp.html#connect/2"},{"type":"function","title":"gen_tcp.connect/3","doc":"Create a socket connected to the specified address.","ref":"gen_tcp.html#connect/3"},{"type":"function","title":"With arguments Address and Port - gen_tcp.connect/3","doc":"Equivalent to [`connect(Address, Port, Opts, infinity)`](`connect/4`).","ref":"gen_tcp.html#connect/3-with-arguments-address-and-port"},{"type":"function","title":"With argument SockAddr (since OTP 24.3) - gen_tcp.connect/3","doc":"Connects to a remote listen socket specified by `SockAddr`\nwhere `t:socket:sockaddr_in6/0` for example allows specifying\nthe `scope_id` for link local IPv6 addresses.\n\n[IPv4 addresses](`t:socket:sockaddr_in/0`) on the same\n`t:map/0` format is also allowed.\n\nEquivalent to `connect/4`, besides the format of the destination address.","ref":"gen_tcp.html#connect/3-with-argument-sockaddr-since-otp-24-3"},{"type":"function","title":"gen_tcp.connect/4","doc":"Create a socket connected to the specified address.\n\nCreates a socket and connects it to a server on TCP port `Port`\non the host with IP address `Address`, that may also be a hostname.\n\n### `Opts` (connect options)\n\n- **`{ip, Address}`** - If the local host has many IP addresses,\n  this option specifies which one to use.\n\n- **`{ifaddr, Address}`** - Same as `{ip, Address}`.\n\n  However, if `Address` instead is a `t:socket:sockaddr_in/0` or\n  `t:socket:sockaddr_in6/0` this takes precedence over any value\n  previously set with the `ip` and `port` options. If these options\n  (`ip` or/and `port`) however comes _after_ this option,\n  they may be used to _update_ the corresponding fields of this option\n  (for `ip`, the `addr` field, and for `port`, the `port` field).\n\n- **`{fd, integer() >= 0}`** - If a socket has somehow been connected without\n  using `gen_tcp`, use this option to pass the file descriptor for it.\n  If `{ip, Address}` and/or `{port, port_number()}` is combined\n  with this option, the `fd` is bound to the specified interface\n  and port before connecting. If these options are not specified,\n  it is assumed that the `fd` is already bound appropriately.\n\n- **`inet`** - Sets up the socket for IPv4.\n\n- **`inet6`** - Sets up the socket for IPv6.\n\n- **`local`** - Sets up a Unix Domain Socket. See `t:inet:local_address/0`\n\n- **`{port, Port}`** - Specifies which local port number to use.\n\n- **`{tcp_module, module()}`** - Overrides which callback module is used.\n  Defaults to `inet_tcp` for IPv4 and `inet6_tcp` for IPv6.\n\n- **`t:option/0`** - See `inet:setopts/2`.","ref":"gen_tcp.html#connect/4"},{"type":"function","title":"Socket Data - gen_tcp.connect/4","doc":"Packets can be sent to the peer (outbound) with\n[`send(Socket, Packet)`](`send/2`).  Packets sent from the peer\n(inbound) are delivered as messages to the socket owner;\nthe process that created the socket, unless `{active, false}`\nis specified in the `Options` list.\n\n#### Active mode socket messages\n\n- **`{tcp, Socket, Data}`** - Inbound data from the socket.\n\n- **`{tcp_passive, Socket}`** -\n  The socket was in `{active, N}` mode (see `inet:setopts/2` for details)\n  and its message counter reached `0`, indicating that\n  the socket has transitioned to passive (`{active, false}`) mode.\n\n\n- **`{tcp_closed, Socket}`** - The socket was closed.\n\n- **`{tcp_error, Socket, Reason}`** A socket error occurred.\n\n#### Passive mode\n\nIf `{active, false}` is specified in the option list for the socket,\npackets and errors are retrieved by calling [`recv/2,3`](`recv/3`)\n(`send/2` may also return errors).\n\n#### Timeout\n\nThe optional `Timeout` parameter specifies a connect time-out in milliseconds.\nDefaults to `infinity`.\n\n> #### Note {: .info }\n>\n> Keep in mind that if the underlying OS `connect()` call returns a timeout,\n> `gen_tcp:connect` will also return a timeout (i.e. `{error, etimedout}`),\n> even if a larger `Timeout` was specified (for example `infinity`).\n\n> #### Note {: .info }\n>\n> The default values for options specified to `connect` can be affected by the\n> Kernel configuration parameter `inet_default_connect_options`.\n> For details, see `m:inet`.","ref":"gen_tcp.html#connect/4-socket-data"},{"type":"type","title":"gen_tcp.connect_option/0","doc":"","ref":"gen_tcp.html#t:connect_option/0"},{"type":"function","title":"gen_tcp.controlling_process/2","doc":"Change the controlling process (owner) of a socket.\n\nAssigns a new controlling process `Pid` to `Socket`. The controlling process\nis the process that the socket sends messages to.  If this function\nis called from any other process than the current controlling process,\n`{error, not_owner}` is returned.\n\nIf the process identified by `Pid` is not an existing local `t:pid/0`,\n`{error, badarg}` is returned. `{error, badarg}` may also be returned\nin some cases when `Socket` is closed during the execution of this function.\n\nIf the socket is in _active mode_, this function will transfer any messages\nfrom the socket in the mailbox of the caller to the new controlling process.\n\nIf any other process is interacting with the socket during the transfer,\nit may not work correctly and messages may remain in the caller's mailbox.\nFor instance, changing the sockets active mode during the transfer\ncould cause this.","ref":"gen_tcp.html#controlling_process/2"},{"type":"function","title":"gen_tcp.listen/2","doc":"Create a listen socket.\n\nCreates a socket and sets it to listen on port `Port` on the local host.\n\nIf `Port == 0`, the underlying OS assigns an available (ephemeral)\nport number, use `inet:port/1` to retrieve it.\n\nThe following options are available:\n\n- **`list`** - Received `Packet`s are delivered as lists of bytes,\n  `[`[`byte/0`](`t:byte/0`)`]`.\n\n- **`binary`** - Received `Packet`s are delivered as `t:binary/0`s.\n\n- **`{backlog, B}`** - `B ::` `t:non_neg_integer/0`. The backlog value\n  defines the maximum length that the queue of pending connections\n  can grow to. Defaults to `5`.\n\n- **`inet6`** - Sets up the socket for IPv6.\n\n- **`inet`** - Sets up the socket for IPv4.\n\n- **`{fd, Fd}`** - If a socket has somehow been created without using\n  `gen_tcp`, use this option to pass the file descriptor for it.\n\n- **`{ip, Address}`** - If the host has many IP addresses, this option\n  specifies which one to listen on.\n\n- **`{port, Port}`** - Specifies which local port number to use.\n\n- **`{ifaddr, Address}`** - Same as `{ip, Address}`.\n\n  However, if this instead is an `t:socket:sockaddr_in/0` or\n  `t:socket:sockaddr_in6/0` this takes precedence over any value\n  previously set with the `ip` and `port` options. If these options\n  (`ip` or/and `port`) however comes _after_ this option,\n  they may be used to _update_ their corresponding fields of this option\n  (for `ip`, the `addr` field, and for `port`, the `port` field).\n\n- **`{tcp_module, module()}`** - Overrides which callback module is used.\n  Defaults to `inet_tcp` for IPv4 and `inet6_tcp` for IPv6.\n\n- **`t:option/0`** - See `inet:setopts/2`.\n\nThe returned socket `ListenSocket` should be used when calling\n[`accept/1,2`](`accept/1`) to accept an incoming connection request.\n\n> #### Note {: .info }\n>\n> The default values for options specified to `listen` can be affected by the\n> Kernel configuration parameter `inet_default_listen_options`. For details, see\n> `m:inet`.","ref":"gen_tcp.html#listen/2"},{"type":"type","title":"gen_tcp.listen_option/0","doc":"","ref":"gen_tcp.html#t:listen_option/0"},{"type":"type","title":"gen_tcp.option/0","doc":"","ref":"gen_tcp.html#t:option/0"},{"type":"type","title":"gen_tcp.option_name/0","doc":"","ref":"gen_tcp.html#t:option_name/0"},{"type":"type","title":"gen_tcp.pktoptions_value/0","doc":"Value from socket option [`pktoptions`](`t:option_name/0`).\n\nIf the platform implements the IPv4 option `IP_PKTOPTIONS`,\nor the IPv6 option `IPV6_PKTOPTIONS` or `IPV6_2292PKTOPTIONS` for the socket;\nthis value is returned from `inet:getopts/2` when called with the option name\n[`pktoptions`](`t:option_name/0`).\n\n> #### Note {: .info }\n>\n> This option appears to be VERY Linux specific, and its existence in future\n> Linux kernel versions is also worrying since the option is part of RFC 2292\n> which is since long (2003) obsoleted by RFC 3542 that _explicitly_ removes\n> this possibility to get packet information from a stream socket. For\n> comparison: it has existed in FreeBSD but is now removed, at least since\n> FreeBSD 10.","ref":"gen_tcp.html#t:pktoptions_value/0"},{"type":"function","title":"gen_tcp.recv/2","doc":"Equivalent to  recv(Socket, Length, infinity) .","ref":"gen_tcp.html#recv/2"},{"type":"function","title":"gen_tcp.recv/3","doc":"Receive a packet, from a socket in _passive mode_.\n\nA closed socket is indicated by the return value `{error, closed}`.\nIf the socket is not in passive mode, the return value is `{error, einval}`.\n\nArgument `Length` is only meaningful when the socket is in `raw` mode and\ndenotes the number of bytes to read.  If `Length` is `0`, all available\nbytes are returned. If `Length > 0`, exactly `Length` bytes are returned,\nor an error; except if the socket is closed from the other side,\nthen the last read before the one returning `{error, closed}`\nmay return less than `Length` bytes of data.\n\nThe optional `Timeout` parameter specifies a time-out in milliseconds.\nDefaults to `infinity`.\n\nAny process can receive data from a passive socket, even if that process is not\nthe controlling process of the socket. However, only one process can call this\nfunction on a socket at any given time. Using simultaneous calls to `recv` is\nnot recommended as the behavior depends on the socket implementation,\nand could return errors such as `{error, ealready}`.","ref":"gen_tcp.html#recv/3"},{"type":"function","title":"gen_tcp.send/2","doc":"Send a packet on a socket.\n\nThere is no `send/2` call with a time-out option; use socket option\n`send_timeout` if time-outs are desired.  See section\n[Examples](#module-examples).\n\nThe return value `{error, {timeout, RestData}}` can only be returned when\n`inet_backend = socket`.\n\n[](){: #non_blocking_send }\n\n> #### Note {: .info }\n>\n> #### Non-blocking send.\n>\n> If the user tries to send more data than there is room for in the OS send\n> buffers, the 'rest data' is stored in (inet driver) internal buffers and later\n> sent in the background. The function immediately returns ok (_not_ informing\n> the caller that some date isn'nt sent yet). Any issue while\n> sending the 'rest data' may be returned later.\n>\n> When using `inet_backend = socket`, the behaviour is different. There is\n> _no_ buffering, instead the caller will \"hang\" until all of the data\n> has been sent or the send timeout (as specified by the `send_timeout`\n> option) expires (the function can \"hang\" even when using the `inet`\n> backend if the internal buffers are full).\n>\n> If this happens when using `packet =/= raw`, a partial packet has been\n> written. A new packet therefore _mustn't_ be written at this point,\n> as there is no way for the peer to distinguish this from data in\n> the current packet. Instead, set the `packet` option to `raw`, send the\n> rest data (as raw data) and then set `packet` back to the correct type.","ref":"gen_tcp.html#send/2"},{"type":"function","title":"gen_tcp.shutdown/2","doc":"Close the socket in one or both directions.\n\n`How == write` means closing the socket for writing, reading from it is still\npossible.\n\nIf `How == read` or there is no outgoing data buffered in the `Socket` port, the\nshutdown is performed immediately and any error encountered is returned in\n`Reason`.\n\nIf there is data buffered in the socket port, shutdown isn't performed\non the socket until that buffered data has been written to the OS\nprotocol stack.  If any errors are encountered, the socket is closed\nand `{error, closed}` is returned by the next `recv/2` or `send/2` call.\n\nOption `{exit_on_close, false}` is useful if the peer performs a shutdown\nof its write side.  Then the socket stays open for writing after\nreceive has indicated that the socket was closed.\n\n[](){: #async_shutdown_write }\n\n> #### Note {: .info }\n>\n> Async shutdown write (`How :: write | read_write`).\n>\n> If the shutdown attempt is made while the inet driver is sending\n> buffered data in the background, the shutdown is postponed until\n> all buffered data has been sent.  This function immediately returns `ok`,\n> and the caller _isn't_ informed (that the shutdown has been postponed).\n>\n> When using `inet_backend = socket`, the behaviour is different. A shutdown\n> with `How :: write | read_write` will always be performed _immediately_.","ref":"gen_tcp.html#shutdown/2"},{"type":"type","title":"gen_tcp.socket/0","doc":"As returned by [`accept/1,2`](`accept/1`) and [`connect/3,4`](`connect/3`).","ref":"gen_tcp.html#t:socket/0"},{"type":"module","title":"gen_udp","doc":"Interface to UDP sockets.\n\nThis module provides functions for communicating over UDP\nprotocol sockets.\n\n> #### Note {: .info }\n>\n> Functions that create sockets can take an optional option;\n> `{inet_backend, Backend}` that, if specified, has to be the first option. This\n> selects the implementation backend towards the platform's socket API.\n>\n> This is a _temporary_ option that will be ignored in a future release.\n>\n> The default is `Backend = inet` that selects the traditional `inet_drv.c`\n> driver. The other choice is `Backend = socket` that selects the new `m:socket`\n> module and its NIF implementation.\n>\n> The system default can be changed when the node is started with the\n> application `kernel`'s configuration variable `inet_backend`.\n>\n> For `gen_udp` with `inet_backend = socket` we have tried to be as \"compatible\"\n> as possible which has sometimes been impossible. Here is a list of cases when\n> the behaviour of inet-backend `inet` (default) and `socket` are different:\n>\n> - The option [read_packets](`m:inet#option-read_packets`) is currently\n>   _ignored_.\n> - Windows require sockets (domain = `inet | inet6`) to be bound.\n>\n>   _Currently_ all sockets created on Windows with `inet_backend = socket` will\n>   be bound. If the user does not provide an address, gen_udp will try to\n>   'figure out' an address itself.","ref":"gen_udp.html"},{"type":"function","title":"gen_udp.close/1","doc":"Closes a UDP socket.","ref":"gen_udp.html#close/1"},{"type":"function","title":"gen_udp.connect/2","doc":"Connect a UDP socket.\n\nConnecting a UDP socket only means storing the specified (destination) socket\naddress, as specified by `SockAddr`, so that the system knows where to send\ndata.\n\nWhen the socket is \"connected\" it is not necessary to specify\nthe destination address when sending a datagram.\nThat is; `send/2` may be used.\n\nIt also means that the socket will only receive data from\nthe connected address.  Other messages are discarded on arrival\nby the OS protocol stack.","ref":"gen_udp.html#connect/2"},{"type":"function","title":"gen_udp.connect/3","doc":"Connect a UDP socket.\n\nSee `connect/2`.\n\nWith this function the destination is specified\nwith separate `Address` and `Port` arguments where `Address` may be\nan [IP address](`t:inet:socket_address/0`)\nor a [host name](`t:inet:hostname/0`).","ref":"gen_udp.html#connect/3"},{"type":"function","title":"gen_udp.controlling_process/2","doc":"Change the controlling process (owner) of a socket.\n\nAssigns a new controlling process `Pid` to `Socket`. The controlling process\nis the process that the socket sends messages to.  If this function\nis called from any other process than the current controlling process,\n`{error, not_owner}` is returned.\n\nIf the process identified by `Pid` is not an existing local `t:pid/0`,\n`{error, badarg}` is returned. `{error, badarg}` may also be returned\nin some cases when `Socket` is closed during the execution of this function.\n\nIf the socket is in _active mode_, this function will transfer any messages\nfrom the socket in the mailbox of the caller to the new controlling process.\n\nIf any other process is interacting with the socket during the transfer,\nit may not work correctly and messages may remain in the caller's mailbox.\nFor instance, changing the sockets active mode during the transfer\ncould cause this.","ref":"gen_udp.html#controlling_process/2"},{"type":"type","title":"gen_udp.ip6_membership/0","doc":"","ref":"gen_udp.html#t:ip6_membership/0"},{"type":"type","title":"gen_udp.ip6_multicast_if/0","doc":"IPv6 this multicast interface index (an integer).","ref":"gen_udp.html#t:ip6_multicast_if/0"},{"type":"type","title":"gen_udp.ip_membership/0","doc":"IP multicast membership.\n\nThe 3-tuple form _isn't_ supported on all platforms.\n'ifindex' defaults to zero (0) on platforms that supports the 3-tuple variant.","ref":"gen_udp.html#t:ip_membership/0"},{"type":"type","title":"gen_udp.ip_multicast_if/0","doc":"","ref":"gen_udp.html#t:ip_multicast_if/0"},{"type":"type","title":"gen_udp.membership/0","doc":"","ref":"gen_udp.html#t:membership/0"},{"type":"type","title":"gen_udp.multicast_if/0","doc":"","ref":"gen_udp.html#t:multicast_if/0"},{"type":"function","title":"gen_udp.open/1","doc":"Equivalent to  open(Port, []) .","ref":"gen_udp.html#open/1"},{"type":"function","title":"gen_udp.open/2","doc":"Open a UDP socket.\n\nThe created socket is bound to the UDP port number `Port`.\nIf `Port == 0`, the underlying OS assigns a free (ephemeral) UDP port;\nuse `inet:port/1` to retrieve it.\n\nThe process that calls this function becomes the `Socket`'s\ncontrolling process (socket owner).","ref":"gen_udp.html#open/2"},{"type":"function","title":"UDP socket options - gen_udp.open/2","doc":"- **`list`** - Received `Packet` is delivered as a list.\n\n- **`binary`** - Received `Packet` is delivered as a binary.\n\n- **`{ip, Address}`** - If the local host has many IP addresses,\n  this option specifies which one to use.\n\n- **`{ifaddr, Address}`** - Same as `{ip, Address}`.\n\n  However, if this instead is a `t:socket:sockaddr_in/0` or\n  `t:socket:sockaddr_in6/0` this takes precedence over any value\n  previously set with the `ip` options. If the `ip` option comes\n  _after_ the `ifaddr` option, it may be used to _update_ its corresponding\n  field of the `ifaddr` option (the `addr` field).\n\n- **`{fd, integer() >= 0}`** - If a socket has somehow been opened without\n  using `gen_udp`, use this option to pass the file descriptor for it.\n  If `Port` is not set to `0` and/or `{ip, ip_address()}` is combined\n  with this option, the `fd` is bound to the specified interface\n  and port after it is being opened.  If these options are not specified,\n  it is assumed that the `fd` is already bound appropriately.\n\n- **`inet6`** - Sets up the socket for IPv6.\n\n- **`inet`** - Sets up the socket for IPv4.\n\n- **`local`** - Sets up a Unix Domain Socket. See `t:inet:local_address/0`\n\n- **`{udp_module, module()}`** - Overrides which callback module is used.\n  Defaults to `inet_udp` for IPv4 and `inet6_udp` for IPv6.\n\n- **`{multicast_if, Address}`** - Sets the local device for a multicast socket.\n\n- **`{multicast_loop, true | false}`** - When `true`, sent multicast packets\n  are looped back to the local sockets.\n\n- **`{multicast_ttl, Integer}`** - Option `multicast_ttl` changes the\n  time-to-live (TTL) for outgoing multicast datagrams to control the scope of\n  the multicasts.\n\n  Datagrams with a TTL of 1 are not forwarded beyond the local network.\n  Defaults to `1`.\n\n- **`{add_membership, {MultiAddress, InterfaceAddress}}`** -\n  Joins a multicast group.\n\n- **`{drop_membership, {MultiAddress, InterfaceAddress}}`** -\n  Leaves a multicast group.\n\n- **`t:option/0`** - See `inet:setopts/2`.\n\nUDP packets are sent with this socket using [`send(Socket, ...)`](`send/3`).\nWhen UDP packets arrive to the `Socket`'s UDP port, and the socket is in\nan _active mode_, the packets are delivered as messages to the\ncontrolling process (socket owner):\n\n```erlang\n{udp, Socket, PeerIP, PeerPort, Packet} % Without ancillary data\n{udp, Socket, PeerIP, PeerPort, AncData, Packet} % With ancillary data\n```\n\n`PeerIP` and `PeerPort` are the address from which `Packet` was sent.\n`Packet` is a list of bytes (`[`[`byte/0`](`t:byte/0`)`]` if option `list`\nis active and a `t:binary/0` if option `binary`is active\n(they are mutually exclusive).\n\nThe message contains an `AncData` field only if any of the socket\n[options](`t:option/0`) [`recvtos`](`m:inet#option-recvtos`),\n[`recvtclass`](`m:inet#option-recvtclass`) or\n[`recvttl`](`m:inet#option-recvttl`) are active.\n\nWhen a socket in `{active, N}` mode (see `inet:setopts/2` for details),\ntransitions to passive (`{active, false}`) mode (`N` counts down to `0`),\nthe controlling process is notified by a message on this form:\n\n```erlang\n{udp_passive, Socket}\n```\n\nIf the OS protocol stack reports an error for the socket, the following\nmessage is sent to the controlling process:\n\n```erlang\n{udp_error, Socket, Reason}\n```\n`Reason` is mostly a [POSIX Error Code](`m:inet#posix-error-codes`).\n\nIf the socket is in _passive mode_ (not in an _active mode_), received data\ncan be retrieved with the`recv/2,3`](`recv/2`) calls. Note that incoming\nUDP packets that are longer than the receive buffer option specifies\ncan be truncated without warning.\n\nThe default value for the receive buffer option is `{recbuf, 9216}`.","ref":"gen_udp.html#open/2-udp-socket-options"},{"type":"type","title":"gen_udp.open_option/0","doc":"","ref":"gen_udp.html#t:open_option/0"},{"type":"type","title":"gen_udp.option/0","doc":"","ref":"gen_udp.html#t:option/0"},{"type":"type","title":"gen_udp.option_name/0","doc":"","ref":"gen_udp.html#t:option_name/0"},{"type":"function","title":"gen_udp.recv/2","doc":"Equivalent to  recv(Socket, Length, infinity) .","ref":"gen_udp.html#recv/2"},{"type":"function","title":"gen_udp.recv/3","doc":"Receive a packet from a socket in _passive mode_.\n\n`Timeout` specifies a time-out in milliseconds.\n\nIf any of the socket [options](`t:option/0`)\n[`recvtos`](`m:inet#option-recvtos`),\n[`recvtclass`](`m:inet#option-recvtclass`)\nor [`recvttl`](`m:inet#option-recvttl`) are active,\nthe `RecvData` tuple contains an `AncData` field,\notherwise it doesn't.","ref":"gen_udp.html#recv/3"},{"type":"function","title":"gen_udp.send/2","doc":"Send a packet on a connected UDP socket.\n\nTo connect a UDP socket, use `connect/2` or `connect/3`.","ref":"gen_udp.html#send/2"},{"type":"function","title":"gen_udp.send/3","doc":"Equivalent to [`send(Socket, Destination, [], Packet)`](#send-4-AncData).","ref":"gen_udp.html#send/3"},{"type":"function","title":"gen_udp.send/4","doc":"Send a UDP packet to the specified destination.","ref":"gen_udp.html#send/4"},{"type":"function","title":"With arguments Host and Port - gen_udp.send/4","doc":"Argument `Host` can be a hostname or a socket address, and `Port`\ncan be a port number or a service name atom. These are resolved to\na `Destination` and then this function is equivalent to\n[`send(Socket, Destination, [], Packet)`](#send-4-AncData)\njust below.\n\n### [](){: #send-4-AncData } With arguments `Destination` and `AncData` _(since OTP 22.1)_\n\nSends a packet to the specified `Destination` with ancillary data `AncData`.\n\n> #### Note {: .info }\n>\n> The ancillary data `AncData` contains options that for this single message\n> override the default options for the socket, an operation that may not be\n> supported on all platforms, and if so return `{error, einval}`. Using more\n> than one of an ancillary data item type may also not be supported.\n> `AncData =:= []` is always supported.","ref":"gen_udp.html#send/4-with-arguments-host-and-port"},{"type":"function","title":"With arguments Destination and PortZero (since OTP 22.1) - gen_udp.send/4","doc":"Sends a packet to the specified `Destination`.  Since `Destination`\nis a complete address, `PortZero` is redundant and has to be `0`.\n\nThis is a legacy clause mostly for `Destination = {local, Binary}`\nwhere `PortZero` is superfluous. Equivalent to\n[`send(Socket, Destination, [], Packet)`](#send-4-AncData), right above here.","ref":"gen_udp.html#send/4-with-arguments-destination-and-portzero-since-otp-22-1"},{"type":"function","title":"gen_udp.send/5","doc":"Send a packet to the specified destination, with ancillary data.\n\nEquvalent to [`send(Socket, Host, Port, Packet)`](`send/4`)\nregarding `Host` and `Port` and also equivalent to\n[`send(Socket, Destination, AncData, Packet)`](#send-4-AncData)\nregarding the ancillary data: `AncData`.","ref":"gen_udp.html#send/5"},{"type":"type","title":"gen_udp.socket/0","doc":"A socket as returned by [`open/1,2`](`open/1`).","ref":"gen_udp.html#t:socket/0"},{"type":"module","title":"inet","doc":"Access to Network protocols.\n\nThis module, together with `m:gen_tcp`, `m:gen_udp` and `m:gen_sctp`\nprovides access to the Network protocols TCP, SCTP and UDP over IP,\nas well as stream and datagram protocols over the local (unix)\naddress domain / protocol domain.\n\nSee also [ERTS User's Guide: Inet Configuration](`e:erts:inet_cfg.md`)\nor more information about how to configure an Erlang runtime system\nfor IP communication.\n\nThe following four Kernel configuration parameters affect the behavior of all\n`m:gen_tcp`, `m:gen_udp` and `m:gen_sctp` sockets opened on an Erlang node:\n\n- `inet_default_connect_options` can contain a list of\n  default options used for all sockets created by\n  a `gen_tcp:connect/2,3,4`](`gen_tcp:connect/2`) call.\n- `inet_default_listen_options` can contain a list of default options\n  used for sockets created by a `gen_tcp:listen/2` call.\n- `inet_default_udp_options` can contain a list of\n  default options used for all sockets created by\n  a `gen_udp:open/1,2`](`gen_udp:open/2`) call.\n- `inet_default_sctp_options` can contain a list of\n  default options used for all sockets created by\n  a `gen_sctp:open/0,1`](`gen_sctp:open/1`) call.\n\nFor the [`gen_tcp:accept/1,2`](`gen_tcp:accept/1`) call,\nthe values of the listening socket options are inherited.\nTherefore there is no corresponding application variable for `accept`.\n\nUsing the Kernel configuration parameters above, one can set default options\nfor all TCP sockets on a node, but use this with care. Options such as\n`{delay_send,true}` can be specified in this way. The following is an example\nof starting an Erlang node with all sockets using delayed send:\n\n```text\n$ erl -sname test -kernel \\\ninet_default_connect_options '[{delay_send,true}]' \\\ninet_default_listen_options '[{delay_send,true}]'\n```\n\n**Please note** that the default option `{active, true}` cannot be changed,\nfor internal implementation reasons.\n\nAddresses as inputs to functions can be either a string or a tuple.\nFor example, the IP address 150.236.20.73 can be passed to\n`gethostbyaddr/1`, either as a string `\"150.236.20.73\"`\nor as a tuple `{150, 236, 20, 73}`.\n\n_IPv4 address examples:_\n\n```text\nAddress          ip_address()\n-------          ------------\n127.0.0.1        {127,0,0,1}\n192.168.42.2     {192,168,42,2}\n```\n\n_IPv6 address examples:_\n\n```erlang\nAddress          ip_address()\n-------          ------------\n::1             {0,0,0,0,0,0,0,1}\n::192.168.42.2  {0,0,0,0,0,0,(192 bsl 8) bor 168,(42 bsl 8) bor 2}\n::FFFF:192.168.42.2\n                {0,0,0,0,0,16#FFFF,(192 bsl 8) bor 168,(42 bsl 8) bor 2}\n3ffe:b80:1f8d:2:204:acff:fe17:bf38\n                {16#3ffe,16#b80,16#1f8d,16#2,16#204,16#acff,16#fe17,16#bf38}\nfe80::204:acff:fe17:bf38\n                {16#fe80,0,0,0,16#204,16#acff,16#fe17,16#bf38}\n```\n\nFunction `parse_address/1` can be useful:\n\n```erlang\n1> inet:parse_address(\"192.168.42.2\").\n{ok,{192,168,42,2}}\n2> inet:parse_address(\"::FFFF:192.168.42.2\").\n{ok,{0,0,0,0,0,65535,49320,10754}}\n```\n\n[](){: #posix-error-codes } POSIX Error Codes\n---------------------------------------------\n\n- `e2big` - Too long argument list\n- `eacces` - Permission denied\n- `eaddrinuse` - Address already in use\n- `eaddrnotavail` - Cannot assign requested address\n- `eadv` - Advertise error\n- `eafnosupport` - Address family not supported by protocol family\n- `eagain` - Resource temporarily unavailable\n- `ealign` - EALIGN\n- `ealready` - Operation already in progress\n- `ebade` - Bad exchange descriptor\n- `ebadf` - Bad file number\n- `ebadfd` - File descriptor in bad state\n- `ebadmsg` - Not a data message\n- `ebadr` - Bad request descriptor\n- `ebadrpc` - Bad RPC structure\n- `ebadrqc` - Bad request code\n- `ebadslt` - Invalid slot\n- `ebfont` - Bad font file format\n- `ebusy` - File busy\n- `echild` - No children\n- `echrng` - Channel number out of range\n- `ecomm` - Communication error on send\n- `econnaborted` - Software caused connection abort\n- `econnrefused` - Connection refused\n- `econnreset` - Connection reset by peer\n- `edeadlk` - Resource deadlock avoided\n- `edeadlock` - Resource deadlock avoided\n- `edestaddrreq` - Destination address required\n- `edirty` - Mounting a dirty fs without force\n- `edom` - Math argument out of range\n- `edotdot` - Cross mount point\n- `edquot` - Disk quota exceeded\n- `eduppkg` - Duplicate package name\n- `eexist` - File already exists\n- `efault` - Bad address in system call argument\n- `efbig` - File too large\n- `ehostdown` - Host is down\n- `ehostunreach` - Host is unreachable\n- `eidrm` - Identifier removed\n- `einit` - Initialization error\n- `einprogress` - Operation now in progress\n- `eintr` - Interrupted system call\n- `einval` - Invalid argument\n- `eio` - I/O error\n- `eisconn` - Socket is already connected\n- `eisdir` - Illegal operation on a directory\n- `eisnam` - Is a named file\n- `el2hlt` - Level 2 halted\n- `el2nsync` - Level 2 not synchronized\n- `el3hlt` - Level 3 halted\n- `el3rst` - Level 3 reset\n- `elbin` - ELBIN\n- `elibacc` - Cannot access a needed shared library\n- `elibbad` - Accessing a corrupted shared library\n- `elibexec` - Cannot exec a shared library directly\n- `elibmax` - Attempting to link in more shared libraries than system limit\n- `elibscn` - `.lib` section in `a.out` corrupted\n- `elnrng` - Link number out of range\n- `eloop` - Too many levels of symbolic links\n- `emfile` - Too many open files\n- `emlink` - Too many links\n- `emsgsize` - Message too long\n- `emultihop` - Multihop attempted\n- `enametoolong` - Filename too long\n- `enavail` - Unavailable\n- `enet` - ENET\n- `enetdown` - Network is down\n- `enetreset` - Network dropped connection on reset\n- `enetunreach` - Network is unreachable\n- `enfile` - File table overflow\n- `enoano` - Anode table overflow\n- `enobufs` - No buffer space available\n- `enocsi` - No CSI structure available\n- `enodata` - No data available\n- `enodev` - No such device\n- `enoent` - No such file or directory\n- `enoexec` - Exec format error\n- `enolck` - No locks available\n- `enolink` - Link has been severed\n- `enomem` - Not enough memory\n- `enomsg` - No message of desired type\n- `enonet` - Machine is not on the network\n- `enopkg` - Package not installed\n- `enoprotoopt` - Bad protocol option\n- `enospc` - No space left on device\n- `enosr` - Out of stream resources or not a stream device\n- `enosym` - Unresolved symbol name\n- `enosys` - Function not implemented\n- `enotblk` - Block device required\n- `enotconn` - Socket is not connected\n- `enotdir` - Not a directory\n- `enotempty` - Directory not empty\n- `enotnam` - Not a named file\n- `enotsock` - Socket operation on non-socket\n- `enotsup` - Operation not supported\n- `enotty` - Inappropriate device for `ioctl`\n- `enotuniq` - Name not unique on network\n- `enxio` - No such device or address\n- `eopnotsupp` - Operation not supported on socket\n- `eperm` - Not owner\n- `epfnosupport` - Protocol family not supported\n- `epipe` - Broken pipe\n- `eproclim` - Too many processes\n- `eprocunavail` - Bad procedure for program\n- `eprogmismatch` - Wrong program version\n- `eprogunavail` - RPC program unavailable\n- `eproto` - Protocol error\n- `eprotonosupport` - Protocol not supported\n- `eprototype` - Wrong protocol type for socket\n- `erange` - Math result unrepresentable\n- `erefused` - EREFUSED\n- `eremchg` - Remote address changed\n- `eremdev` - Remote device\n- `eremote` - Pathname hit remote filesystem\n- `eremoteio` - Remote I/O error\n- `eremoterelease` - EREMOTERELEASE\n- `erofs` - Read-only filesystem\n- `erpcmismatch` - Wrong RPC version\n- `erremote` - Object is remote\n- `eshutdown` - Cannot send after socket shutdown\n- `esocktnosupport` - Socket type not supported\n- `espipe` - Invalid seek\n- `esrch` - No such process\n- `esrmnt` - Srmount error\n- `estale` - Stale remote file handle\n- `esuccess` - Error 0\n- `etime` - Timer expired\n- `etimedout` - Connection timed out\n- `etoomanyrefs` - Too many references\n- `etxtbsy` - Text file or pseudo-device busy\n- `euclean` - Structure needs cleaning\n- `eunatch` - Protocol driver not attached\n- `eusers` - Too many users\n- `eversion` - Version mismatch\n- `ewouldblock` - Operation would block\n- `exdev` - Cross-device link\n- `exfull` - Message tables full\n- `nxdomain` - Hostname or domain name cannot be found","ref":"inet.html"},{"type":"type","title":"inet.address_family/0","doc":"","ref":"inet.html#t:address_family/0"},{"type":"type","title":"inet.ancillary_data/0","doc":"Ancillary data / control messages.\n\nAncillary data received with a data packet, read with the socket option\n[`pktoptions`](`t:gen_tcp:pktoptions_value/0`) from a TCP socket,\nor to set in a call to [`gen_udp:send/4`](`m:gen_udp#send-4-AncData`)\nor `gen_udp:send/5`.\n\nThe value(s) correspond to the currently active socket\n[options](`t:socket_setopt/0`) [`recvtos`](#option-recvtos),\n[`recvtclass`](#option-recvtclass) and [`recvttl`](#option-recvttl),\nor for a single send operation the option(s) to override\nthe currently active socket option(s).","ref":"inet.html#t:ancillary_data/0"},{"type":"function","title":"inet.cancel_monitor/1","doc":"Cancel a socket monitor.\n\nIf `MRef` is a reference that the calling process obtained by calling\n`monitor/1`, this monitor is removed. If the monitoring is already removed,\nnothing happens.\n\nThe returned value is one of the following:\n\n- **`true`** - The monitor was found and removed. In this case, no `'DOWN'`\n  message corresponding to this monitor has been delivered and will not be\n  delivered.\n\n- **`false`** - The monitor was not found and couldn't be removed.\n  Probably because the monitor has already triggered and there is\n  a corresponding `'DOWN'` message in the caller message queue.","ref":"inet.html#cancel_monitor/1"},{"type":"function","title":"inet.close/1","doc":"Close a socket of any type.","ref":"inet.html#close/1"},{"type":"type","title":"inet.ether_address/0","doc":"","ref":"inet.html#t:ether_address/0"},{"type":"type","title":"inet.family_address/0","doc":"A general network address.\n\nA general network address format of the form `{Family, Destination}`\nwhere `Family` is an atom such as `local` and the format of `Destination`\ndepends on `Family`.  `Destination` is a complete address (for example\nan IP address with port number).","ref":"inet.html#t:family_address/0"},{"type":"function","title":"inet.format_error/1","doc":"Format an error code into a `t:string/0`.\n\nReturns a diagnostic error string. For possible POSIX values\nand corresponding strings, see section\n[POSIX Error Codes](#posix-error-codes).","ref":"inet.html#format_error/1"},{"type":"function","title":"inet.get_rc/0","doc":"Get the `inet` configuration.\n\nReturns the state of the `inet` configuration database in form of\na list of recorded configuration parameters. For more information, see\n[ERTS User's Guide: Inet Configuration](`e:erts:inet_cfg.md`).\n\nOnly actual parameters with other than default values are returned,\nfor example not directives that specify other sources for configuration\nparameters nor directives that clear parameters.","ref":"inet.html#get_rc/0"},{"type":"function","title":"inet.getaddr/2","doc":"Resolve a host to an address, in a specific addresss family.\n\nReturns the [IP address](`t:ip_address/0`) for `Host` as a tuple of integers.\n`Host` can be an [IP address](`t:ip_address/0`), a single `t:hostname/0`,\nor a fully qualified `t:hostname/0`.","ref":"inet.html#getaddr/2"},{"type":"function","title":"inet.getaddrs/2","doc":"Resolve a host to a list of addresses, in a specific address family.\n\nReturns a list of all IP addresses for `Host`.\n`Host` can be an [IP address](`t:ip_address/0`),\na single `t:hostname/0`, or a fully qualified `t:hostname/0`.","ref":"inet.html#getaddrs/2"},{"type":"function","title":"inet.gethostbyaddr/1","doc":"Resolve (reverse) an address to a [`#hostent{}`](`t:hostent/0`) record.\n\nReturns a [`#hostent{}`](`t:hostent/0`) record for the host\nwith the specified address.","ref":"inet.html#gethostbyaddr/1"},{"type":"function","title":"inet.gethostbyname/1","doc":"Resolve a hostname to a [`#hostent{}`](`t:hostent/0`) record.\n\nReturns a [`#hostent{}`](`t:hostent/0`) record for the host\nwith the specified `Hostname`.\n\nThis function uses the resolver, which is often the native (OS) resolver.\n\nIf resolver option `inet6` is `true`, an IPv6 address is looked up.\n\nSee [ERTS User's Guide: Inet Configuration](`e:erts:inet_cfg.md`) for\ninformation about the resolver configuration.\n\nA quirk of many resolvers is that an integer string is interpreted\nas an IP address. For instance, the integer string \"3232235521\"\nand the string \"192.168.0.1\" are both translated\nto the IP address `{192,168,0,1}`.","ref":"inet.html#gethostbyname/1"},{"type":"function","title":"inet.gethostbyname/2","doc":"Resolve a hostname to a [`#hostent{}`](`t:hostent/0`) record,\nin a specific address family.\n\nReturns a [`#hostent{}`](`t:hostent/0`) record for the host\nwith the specified `Hostname`, restricted to the specified address `Family`.\n\nSee also `gethostbyname/1`.","ref":"inet.html#gethostbyname/2"},{"type":"function","title":"inet.gethostname/0","doc":"Get the local hostname.\n\nReturns the local hostname. Never fails.","ref":"inet.html#gethostname/0"},{"type":"function","title":"inet.getifaddrs/0","doc":"Get interface names and addresses.\n\nReturns a list of 2-tuples containing interface names and the interfaces'\naddresses. `Ifname` is a Unicode string and `Ifopts` is a list of interface\naddress description tuples.\n\nThe interface address description tuples are documented under\nthe type of the [`Ifopts`](`t:getifaddrs_ifopts/0`) value.","ref":"inet.html#getifaddrs/0"},{"type":"function","title":"inet.getifaddrs/1","doc":"Get interface names and addresses, in a specific namespace.\n\nEquivalent to `getifaddrs/0`, but accepts an `Option`\n`{netns, Namespace}` that, on platforms that support the feature (Linux),\nsets a network namespace for the OS call.\nAlso,\nIf the option 'inet_backend' is *first* in the options list,\nthe specified backend will be used (for 'inet', inet and\nfor 'socket' the equivalent net functions will be used).\n                                         \n\nSee the socket option [`{netns, Namespace}`](#option-netns)\nunder `setopts/2`.","ref":"inet.html#getifaddrs/1"},{"type":"type","title":"inet.getifaddrs_ifopts/0","doc":"Interface address description list.\n\nA list returned from [`getifaddrs/0,1`](`getifaddrs/0`)\nfor a named interface, translated from the\nreturned data of the POSIX API function `getaddrinfo()`.\n\n`Hwaddr` is hardware dependent, for example, on Ethernet interfaces it is the\n6-byte Ethernet address (MAC address (EUI-48 address)).\n\nThe tuples `{addr,Addr}`, `{netmask,Netmask}`, and possibly\n`{broadaddr,Broadaddr}` or `{dstaddr,Dstaddr}` are repeated in the list\nif the interface has got multiple addresses.  An interface may have multiple\n`{flag,_}` tuples for example if it has different flags for different\naddress families.\n\nMultiple `{hwaddr,Hwaddr}` tuples is hard to say anything definite about,\nthough. The tuple `{flag,Flags}` is mandatory, all others are optional.\n\nDo not rely too much on the order of `Flags` atoms or the `Ifopt` tuples.\nThere are however some rules:\n\n- A `{flag,_}` tuple applies to all other tuples that follow.\n- Immediately after `{addr,_}` follows `{netmask,_}`.\n- Immediately thereafter may `{broadaddr,_}` follow if `broadcast`\n  is member of `Flags`, or `{dstaddr,_}` if `pointtopoint`\n  is member of `Flags`. Both `{dstaddr,_}` and `{broadaddr,_}` doesn't\n  occur for the same `{addr,_}`.\n- Any `{netmask,_}`, `{broadaddr,_}`, or `{dstaddr,_}` tuples that follow an\n  `{addr,Addr}` tuple concerns the address `Addr`.\n\nThe tuple `{hwaddr,_}` is not returned on Solaris, as the hardware address\nhistorically belongs to the link layer and it is not returned\nby the Solaris API function `getaddrinfo()`.\n\n> #### Warning {: .warning }\n>\n> On Windows, the data is fetched from different OS API functions, so the\n> `Netmask` and `Broadaddr` values may be calculated, just as some `Flags`\n> values.","ref":"inet.html#t:getifaddrs_ifopts/0"},{"type":"function","title":"inet.getopts/2","doc":"Get one or more options for a socket.\n\nGets all options in the list `Options` from `Socket`.\nSee `setopts/2` for a list of available options. See also\nthe descriptions of protocol specific types referenced by\n[`socket_optval()` ](`t:socket_optval/0`).\n\nThe number of elements in the returned `OptionValues` list does not necessarily\ncorrespond to the number of options asked for. If the operating system fails to\nsupport an option, it is left out in the returned list. An error tuple is\nreturned only when getting options for the socket is impossible (that is, the\nsocket is closed or the buffer size in a raw request is too large). This\nbehavior is kept for backward compatibility reasons.\n\nA raw option request `RawOptReq = {raw, Protocol, OptionNum, ValueSpec}` can be\nused to get information about socket options not (explicitly) supported by the\nemulator. The use of raw socket options makes the code non-portable, but allows\nthe Erlang programmer to take advantage of unusual features present on a\nparticular platform.\n\n`RawOptReq` consists of tag `raw` followed by the protocol level, the option\nnumber, and either a binary or the size, in bytes, of the buffer in which the\noption value is to be stored. A binary is to be used when the underlying\n`getsockopt` requires _input_ in the argument field. In this case, the binary\nsize shall correspond to the required buffer size of the return value. The\nsupplied values in a `RawOptReq` correspond to the second, third, and\nfourth/fifth parameters to the `getsockopt` call in the C socket API. The value\nstored in the buffer is returned as a binary `ValueBin`, where all values are\ncoded in native endianness.\n\nAsking for and inspecting raw socket options require low-level information about\nthe current operating system and TCP stack.\n\n_Example:_\n\nConsider a Linux machine where option `TCP_INFO` can be used to collect TCP\nstatistics for a socket. Assume you are interested in field `tcpi_sacked` of\n`struct tcp_info` filled in when asking for `TCP_INFO`. To be able to access\nthis information, you need to know the following:\n\n- The numeric value of protocol level `IPPROTO_TCP`\n- The numeric value of option `TCP_INFO`\n- The size of `struct tcp_info`\n- The size and offset of the specific field\n\nBy inspecting the headers or writing a small C program, it is found that\n`IPPROTO_TCP` is 6, `TCP_INFO` is 11, the structure size is 92 (bytes), the\noffset of `tcpi_sacked` is 28 bytes, and the value is a 32-bit integer. The\nfollowing code can be used to retrieve the value:\n\n```erlang\nget_tcpi_sacked(Sock) ->\n    {ok,[{raw,_,_,Info}]} = inet:getopts(Sock,[{raw,6,11,92}]),\n    <<_:28/binary,TcpiSacked:32/native,_/binary>> = Info,\n    TcpiSacked.\n```\n\nPreferably, you would check the machine type, the operating system, and the\nKernel version before executing anything similar to this code.","ref":"inet.html#getopts/2"},{"type":"function","title":"inet.getstat/1","doc":"Equivalent to  getstat/2 .","ref":"inet.html#getstat/1"},{"type":"function","title":"inet.getstat/2","doc":"Get one or more statistics options for a socket.\n\n[`getstat(Socket)`](`getstat/1`) is equivalent to\n[`getstat(Socket, [recv_avg, recv_cnt, recv_dvi, recv_max, recv_oct, send_avg, send_cnt, send_pend, send_max, send_oct])`](`getstat/2`).\n\nThe following options are available:\n\n- **`recv_avg`** - Average size of packets, in bytes, received by the socket.\n\n- **`recv_cnt`** - Number of packets received by the socket.\n\n- **`recv_dvi`** - Average packet size deviation, in bytes, received by the\n  socket.\n\n- **`recv_max`** - Size of the largest packet, in bytes, received by the socket.\n\n- **`recv_oct`** - Number of bytes received by the socket.\n\n- **`send_avg`** - Average size of packets, in bytes, sent from the socket.\n\n- **`send_cnt`** - Number of packets sent from the socket.\n\n- **`send_pend`** - Number of bytes waiting to be sent by the socket.\n\n- **`send_max`** - Size of the largest packet, in bytes, sent from the socket.\n\n- **`send_oct`** - Number of bytes sent from the socket.","ref":"inet.html#getstat/2"},{"type":"type","title":"inet.hostent/0","doc":"A record describing a host; name and address.\n\nCorresponds to the `C`: `struct hostent` as returned by for example\n`gethostbyname(3)`.\n\nThe record is defined in the Kernel include file `\"inet.hrl\"`.\n\nAdd the following directive to the module:\n\n```erlang\n-include_lib(\"kernel/include/inet.hrl\").\n```","ref":"inet.html#t:hostent/0"},{"type":"type","title":"inet.hostname/0","doc":"","ref":"inet.html#t:hostname/0"},{"type":"function","title":"inet.i/0","doc":"Equivalent to `i/1` for the protocols `tcp`, `udp`, and `sctp`","ref":"inet.html#i/0"},{"type":"function","title":"inet.i/1","doc":"List network sockets.\n\nWith argument `Proto` equivalent to [`i(Proto, Options)`](`i/2`)\nwhere `Options` is a list of all `t:atom/0`s in `t:i_option/0`.\n\nWith argument `Options`, equivalent to [`i(Proto, Options)](`i/2`)\nfor `Proto`: `tcp`, `udp`, and `sctp`.\n\nWith argument `show_ports` **(since OTP 27.0)** equivalent to\n[`i(Proto, Options)](`i/2`) where `Option` is a list of all\noptions in `t:i_option/0` with `ShowPorts = true`.","ref":"inet.html#i/1"},{"type":"function","title":"inet.i/2","doc":"List network sockets.\n\nLists all TCP, UDP and SCTP sockets on the terminal, those created by\nthe Erlang runtime system as well as by the application.\n\nThe following options are available:\n\n- **`port`** - An internal index of the port.\n\n- **`module`** - The callback module of the socket.\n\n- **`recv`** - Number of bytes received by the socket.\n\n- **`sent`** - Number of bytes sent from the socket.\n\n- **`owner`** - The socket owner process.\n\n- **`local_address`** - The local address of the socket.\n\n- **`foreign_address`** - The address and port of the other end of the\n  connection.\n\n- **`state`** - The connection state.\n\n- **`type`** - STREAM or DGRAM or SEQPACKET.\n\nThe `Options` argument may also be **(since OTP 27.0)**:\n\n- **`show_ports`** - Do *not* translate the port numbers\n  (of 'local_address' and 'foreign_address') to service name(s).","ref":"inet.html#i/2"},{"type":"type","title":"inet.i_option/0","doc":"Options for selecting statistics items.\n\nRegarding `ShowPorts`, see `show_ports` as described in the `i/2` function,\ndefaults to `false`.","ref":"inet.html#t:i_option/0"},{"type":"type","title":"inet.inet6_address/0","doc":"A network address for the `inet6` family (`AF_INET6`, IPv6)\n> #### Warning {: .warning }\n>\n> This address format is currently experimental and for completeness\n> to make all address families have a `{Family, Destination}` representation.","ref":"inet.html#t:inet6_address/0"},{"type":"type","title":"inet.inet_address/0","doc":"A network address for the `inet` family (`AF_INET`, IPv4)\n> #### Warning {: .warning }\n>\n> This address format is currently experimental and for completeness\n> to make all address families have a `{Family, Destination}` representation.","ref":"inet.html#t:inet_address/0"},{"type":"type","title":"inet.inet_backend/0","doc":"Implementation backend selector for `t:socket/0`.\n\nSelects the implementation backend for [sockets](`t:socket/0`).\nThe current default is `inet` which uses `inet_drv.c` to call\nthe platform's socket API. The value `socket` instead uses\nthe `m:socket` module and its NIF implementation.\n\nThis is a _temporary_ option that will be ignored in a future release.","ref":"inet.html#t:inet_backend/0"},{"type":"function","title":"inet.info/1","doc":"Get information about a socket.\n\nReturns a term containing miscellaneous information about a socket.","ref":"inet.html#info/1"},{"type":"type","title":"inet.ip4_address/0","doc":"","ref":"inet.html#t:ip4_address/0"},{"type":"type","title":"inet.ip6_address/0","doc":"","ref":"inet.html#t:ip6_address/0"},{"type":"type","title":"inet.ip_address/0","doc":"","ref":"inet.html#t:ip_address/0"},{"type":"function","title":"inet.ipv4_mapped_ipv6_address/1","doc":"Convert between an IPv4 address and an IPv4-mapped IPv6 address.\n\nConvert an IPv4 address to an IPv4-mapped IPv6 address or the reverse.\nWhen converting from an IPv6 address all but the 2 low words are ignored\nso this function also works on some other types of IPv6 addresses\nthan IPv4-mapped.","ref":"inet.html#ipv4_mapped_ipv6_address/1"},{"type":"function","title":"inet.is_ip_address/1","doc":"Test for an IP address.\n\nTests if the argument `IPAddress` is an `t:ip_address/0`\nand if so returns `true`, otherwise `false`.","ref":"inet.html#is_ip_address/1"},{"type":"function","title":"inet.is_ipv4_address/1","doc":"Test for an IPv4 address.\n\nTests if the argument `IPv4Address` is an `t:ip4_address/0`\nand if so returns `true`, otherwise `false`.","ref":"inet.html#is_ipv4_address/1"},{"type":"function","title":"inet.is_ipv6_address/1","doc":"Test for an IPv6 address.\n\nTests if the argument `IPv6Address` is an `t:ip6_address/0`\nand if so returns `true`, otherwise `false`.","ref":"inet.html#is_ipv6_address/1"},{"type":"type","title":"inet.local_address/0","doc":"A network address for the `local` family (`AF_LOCAL | AF_UNIX`)\n\nThis address family, also known as \"Unix domain sockets\" only works\non Unix-like systems.\n\n`File` is normally a file pathname in a local filesystem. It is limited in\nlength by the operating system, traditionally to 108 bytes.\n\nA `t:binary/0` is passed as is to the operating system,\nbut a `t:string/0` is encoded according to the\n[system filename encoding mode.](`file:native_name_encoding/0`)\n\nOther addresses are possible, for example Linux implements\n\"Abstract Addresses\".  See the documentation for Unix Domain Sockets\non your system, normally `unix` in manual section 7.\n\nIn most API functions where you can use this address family\nthe port number must be `0`.","ref":"inet.html#t:local_address/0"},{"type":"type","title":"inet.module_socket/0","doc":"","ref":"inet.html#t:module_socket/0"},{"type":"function","title":"inet.monitor/1","doc":"Start a socket monitor.\n\nIf the `Socket` to monitor doesn't exist or when the monitor is triggered,\na `'DOWN'` message is sent that has the following pattern:\n\n```erlang\n\t    {'DOWN', MonitorRef, Type, Object, Info}\n```\n\n- **`MonitorRef`** - The return value from this function.\n\n- **`Type`** - The type of socket, can be one of the following\n  `t:atom/0`s: `port` or `socket`.\n\n- **`Object`** - The monitored entity, the socket, which triggered the event.\n\n- **`Info`** - Either the termination reason of the socket or `nosock`\n  (the `Socket` did not exist when this function was called).\n\nMaking several calls to `inet:monitor/1` for the same `Socket`\nis not an error; one monitor is created per call.\n\nThe monitor is triggered when the socket is closed in any way such as\nan API call, remote end close, closed by signal when owner exits, ...","ref":"inet.html#monitor/1"},{"type":"function","title":"inet.ntoa/1","doc":"Parse an `t:ip_address/0` to an IPv4 or IPv6 address string.","ref":"inet.html#ntoa/1"},{"type":"function","title":"inet.parse_address/1","doc":"Parse an IP address string to an `t:ip_address/0`.\n\nReturns an `t:ip4_address/0` or an `t:ip6_address/0` depending\non which parsing that succeeds.\n\nAccepts a short form IPv4 address string like `parse_ipv4_address/1`.","ref":"inet.html#parse_address/1"},{"type":"function","title":"inet.parse_ipv4_address/1","doc":"Parse (relaxed) an IPv4 address string to an `t:ip4_address/0`.\n\nAccepts a short form IPv4 address string (less than 4 fields)\nsuch as `\"127.1\"` or `\"0x7f000001\"`.","ref":"inet.html#parse_ipv4_address/1"},{"type":"function","title":"inet.parse_ipv4strict_address/1","doc":"Parse an IPv4 address string to an `t:ip4_address/0`.\n\nRequires an IPv4 address string containing four fields,\nthat is; _not_ a short form address string.","ref":"inet.html#parse_ipv4strict_address/1"},{"type":"function","title":"inet.parse_ipv6_address/1","doc":"Parse (relaxed) an IPv6 address string to an `t:ip6_address/0`.\n\nAlso accepts a (relaxed) IPv4 address string like `parse_ipv4_address/1`\nand returns an IPv4-mapped IPv6 address.","ref":"inet.html#parse_ipv6_address/1"},{"type":"function","title":"inet.parse_ipv6strict_address/1","doc":"Parse an IPv6 address string to an `t:ip6_address/0`.\n\n_Doesn't_ accept an IPv4 address string.  An IPv6 address string, though,\nallows an IPv4 tail like this: `\"::127.0.0.1\"`\n(which is the same as `\"::7f00:0001\"`).","ref":"inet.html#parse_ipv6strict_address/1"},{"type":"function","title":"inet.parse_strict_address/1","doc":"Parse an IP address string to an `t:ip_address/0`.\n\nLike `parse_address/1` but _doesn't_ accept a short form IPv4 address string.","ref":"inet.html#parse_strict_address/1"},{"type":"function","title":"inet.peername/1","doc":"Return the address of the socket's remote end.\n\nReturns the address and port for the other end of a connection.\n\nNotice that for SCTP sockets, this function returns only one of\nthe peer addresses of the socket. Function [`peernames/1,2`](`peernames/1`)\nreturns all.","ref":"inet.html#peername/1"},{"type":"function","title":"inet.peernames/1","doc":"Equivalent to [`peernames(Socket, 0)`](`peernames/2`).\n\nNotice that the behavior of this function for an SCTP one-to-many style socket\nis not defined by the\n[SCTP Sockets API Extensions](http://tools.ietf.org/html/draft-ietf-tsvwg-sctpsocket-13).","ref":"inet.html#peernames/1"},{"type":"function","title":"inet.peernames/2","doc":"Return the addresses of all remote ends of a socket.\n\nReturns a list of all address/port number pairs for the remote end of an\nassociation `Assoc` of a socket.\n\nThis function can return multiple addresses for multihomed sockets,\nsuch as SCTP sockets. For other sockets it returns a one-element list.\n\nNotice that parameter `Assoc` is by the\n[SCTP Sockets API Extensions](http://tools.ietf.org/html/draft-ietf-tsvwg-sctpsocket-13)\ndefined to be ignored for one-to-one style sockets.\nWhat the special value `0` means, is unfortunately undefined,\nand hence the behavior for one-to-many style sockets.","ref":"inet.html#peernames/2"},{"type":"function","title":"inet.port/1","doc":"Return the local port number for a socket.","ref":"inet.html#port/1"},{"type":"type","title":"inet.port_number/0","doc":"","ref":"inet.html#t:port_number/0"},{"type":"type","title":"inet.posix/0","doc":"POSIX Error Code `t:atom/0`.\n\nAn atom that is named from the POSIX error codes used in Unix,\nand in the runtime libraries of most C compilers.\nSee section [POSIX Error Codes](#posix-error-codes).","ref":"inet.html#t:posix/0"},{"type":"type","title":"inet.returned_non_ip_address/0","doc":"a non-IP network address.\n\nAddresses besides `t:ip_address/0` ones that are returned from\nsocket API functions. See in particular `t:local_address/0`.\nThe `unspec` family corresponds to `AF_UNSPEC` and can occur\nif the other side has no socket address. The `undefined`\nfamily can only occur in the unlikely event of an address family\nthat the VM doesn't recognize.","ref":"inet.html#t:returned_non_ip_address/0"},{"type":"function","title":"inet.setopts/2","doc":"Set one or more options for a socket.\n\nSets the list of `Options` on `Socket`.\n\nThe following options are available:\n\n- **`{active, true | false | once | N}`** [](){: #option-active } -\n  If the value is `true`, which is the default, everything received\n  from the socket is sent as messages to the receiving process.\n\n  If the value is `false` (passive mode), the process must explicitly receive\n  incoming data by calling [`gen_tcp:recv/2,3`](`gen_tcp:recv/2`),\n  [`gen_udp:recv/2,3`](`gen_udp:recv/2`), or\n  [`gen_sctp:recv/1,2`](`gen_sctp:recv/1`) (depending on the type of socket).\n\n  If the value is `once` (`{active, once}`), _one_ data message from the socket\n  is sent to the process. To receive one more message,\n  [`setopts/2`](`setopts/2`) must be called again with option `{active, once}`.\n\n  If the value is an integer `N` in the range -32768 to 32767 (inclusive), the\n  value is added to the socket's count of data messages sent to the controlling\n  process. A socket's default message count is `0`. If a negative value is\n  specified, and its magnitude is equal to or greater than the socket's current\n  message count, the socket's message count is set to `0`. Once the socket's\n  message count reaches `0`, either because of sending received data messages to\n  the process or by being explicitly set, the process is then notified by a\n  special message, specific to the type of socket, that the socket has entered\n  passive mode. Once the socket enters passive mode, to receive more messages\n  [`setopts/2`](`setopts/2`) must be called again to set the socket back into an\n  active mode.\n\n  When using `{active, once}` or `{active, N}`, the socket changes behavior\n  automatically when data is received. This can be confusing in combination with\n  connection-oriented sockets (that is, `gen_tcp`), as a socket with\n  `{active, false}` behavior reports closing differently than a socket with\n  `{active, true}` behavior. To simplify programming, a socket where the peer\n  closed, and this is detected while in `{active, false}` mode, still generates\n  message `{tcp_closed, Socket}` when set to `{active, once}`, `{active, true}`,\n  or `{active, N}` mode. It is therefore safe to assume that message\n  `{tcp_closed, Socket}`, possibly followed by socket port termination (depending\n  on option `exit_on_close`) eventually appears when a socket changes back and\n  forth between `{active, true}` and `{active, false}` mode. However, _when_\n  peer closing is detected it is all up to the underlying TCP/IP stack and\n  protocol.\n\n  Notice that `{active, true}` mode provides no flow control; a fast sender can\n  easily overflow the receiver with incoming messages. The same is true for\n  `{active, N}` mode, while the message count is greater than zero.\n\n  Use active mode only if your high-level protocol provides its own flow control\n  (for example, acknowledging received messages) or the amount of data exchanged\n  is small. Using `{active, false}` mode, `{active, once}` mode, or\n  `{active, N}` mode with values of `N` appropriate for the application to\n  provide flow control, ensures the other side cannot send faster than the\n  receiver can read.\n\n- **`{broadcast, Boolean}` (UDP sockets)** [](){: #option-broadcast } -\n  Enables/disables permission to send broadcasts.\n\n- **`{buffer, Size}`** [](){: #option-buffer } -\n  The size of the user-level buffer used by the driver.  Not to be confused\n  with options `sndbuf` and `recbuf`, which correspond to the\n  Kernel socket buffers. For TCP it is recommended to have\n  `val(buffer) >= val(recbuf)` to avoid performance issues because of\n  unnecessary copying. For UDP the same recommendation applies, but the max\n  should not be larger than the MTU of the network path. `val(buffer)` is\n  automatically set to the above maximum when `recbuf` is set. However, as the\n  size set for `recbuf` usually become larger, you are encouraged to use\n  `getopts/2` to analyze the behavior of your operating system.\n\n  Note that this is also the maximum amount of data that can be received from a\n  single recv call. If you are using higher than normal MTU consider setting\n  buffer higher.\n\n- **`{delay_send, Boolean}`** - Normally, when an Erlang process sends to a\n  socket, the driver tries to send the data immediately. If that fails, the\n  driver uses any means available to queue up the message to be sent whenever\n  the operating system says it can handle it. Setting `{delay_send, true}` makes\n  _all_ messages queue up. The messages sent to the network are then larger but\n  fewer. The option affects the scheduling of send requests versus Erlang\n  processes instead of changing any real property of the socket. The option is\n  implementation-specific. Defaults to `false`.\n\n- **`{deliver, port | term}`** - When `{active, true}`, data is delivered on the\n  form `port` : `{S, {data, [H1,..Hsz | Data]}}`\n  or `term` : `{tcp, S, [H1..Hsz | Data]}`.\n\n- **`{dontroute, Boolean}`** - Enables/disables routing bypass for outgoing\n  messages.\n\n- **`{exit_on_close, Boolean}`** - This option is set to `true` by default.\n\n  The only reason to set it to `false` is if you want to continue sending data\n  to the socket after a close is detected, for example, if the peer uses\n  `gen_tcp:shutdown/2` to shut down the write side.\n\n- **`{exclusiveaddruse, Boolean}`** [](){: #option-exclusiveaddruse } -\n  Enables/disables exclusive address/port usage on Windows. That is, by enabling\n  this option you can prevent other sockets from binding to the same\n  address/port.  By default this option is disabled. That is, other sockets\n  may use the same address/port by setting\n  [`{reuseaddr, true}`](#option-reuseaddr) in combination with\n  [`{reuseport, true}`](#option-reuseport) unless\n  `{exclusiveaddruse, true}` has been set on `Socket`. On non-Windows systems\n  this option is silently ignored.\n\n  > #### Note {: .info }\n  >\n  > This option is _currently_ not supported for socket created with\n  > `inet_backend = socket`\n\n- **`{header, Size}`** - This option is only meaningful if option `binary` was\n  specified when the socket was created. If option `header` is specified, the\n  first `Size` number bytes of data received from the socket are elements of a\n  list, and the remaining data is a binary specified as the tail of the same\n  list. For example, if `Size == 2`, the data received matches\n  `[Byte1, Byte2 | Binary]`.\n\n- **`{high_msgq_watermark, Size}`** - The socket message queue is set to a busy\n  state when the amount of data on the message queue reaches this limit. Notice\n  that this limit only concerns data that has not yet reached the ERTS internal\n  socket implementation. Defaults to 8 kB.\n\n  Senders of data to the socket are suspended if either the socket message queue\n  is busy or the socket itself is busy.\n\n  For more information, see options `low_msgq_watermark`, `high_watermark`, and\n  `low_watermark`.\n\n  Notice that distribution sockets disable the use of `high_msgq_watermark` and\n  `low_msgq_watermark`. Instead use the\n  [distribution buffer busy limit](`m:erlang#system_info_dist_buf_busy_limit`),\n  which is a similar feature.\n\n- **`{high_watermark, Size}` (TCP/IP sockets)** - The socket is set to a busy\n  state when the amount of data queued internally by the ERTS socket\n  implementation reaches this limit. Defaults to 8 kB.\n\n  Senders of data to the socket are suspended if either the socket message queue\n  is busy or the socket itself is busy.\n\n  For more information, see options `low_watermark`, `high_msgq_watermark`, and\n  `low_msqg_watermark`.\n\n- **`{ipv6_v6only, Boolean}`** - Restricts the socket to use only IPv6,\n  prohibiting any IPv4 connections. This is only applicable for IPv6 sockets\n  (option `inet6`).\n\n  On most platforms this option must be set on the socket before associating it\n  to an address. It is therefore only reasonable to specify it when creating the\n  socket and not to use it when calling function (`setopts/2`) containing this\n  description.\n\n  The behavior of a socket with this option set to `true` is the only portable\n  one. The original idea when IPv6 was new of using IPv6 for all traffic is now\n  not recommended by FreeBSD (you can use `{ipv6_v6only,false}` to override the\n  recommended system default value), forbidden by OpenBSD (the supported GENERIC\n  kernel), and impossible on Windows (which has separate IPv4 and IPv6 protocol\n  stacks). Most Linux distros still have a system default value of `false`. This\n  policy shift among operating systems to separate IPv6 from IPv4 traffic has\n  evolved, as it gradually proved hard and complicated to get a dual stack\n  implementation correct and secure.\n\n  On some platforms, the only allowed value for this option is `true`, for\n  example, OpenBSD and Windows. Trying to set this option to `false`, when\n  creating the socket, fails in this case.\n\n  Setting this option on platforms where it does not exist is ignored. Getting\n  this option with `getopts/2` returns no value, that is, the returned list does\n  not contain an `{ipv6_v6only,_}` tuple. On Windows, the option does not exist,\n  but it is emulated as a read-only option with value `true`.\n\n  Therefore, setting this option to `true` when creating a socket never fails,\n  except possibly on a platform where you have customized the kernel to only\n  allow `false`, which can be doable (but awkward) on, for example, OpenBSD.\n\n  If you read back the option value using `getopts/2` and get no value, the\n  option does not exist in the host operating system. The behavior of both an\n  IPv6 and an IPv4 socket listening on the same port, and for an IPv6 socket\n  getting IPv4 traffic is then no longer predictable.\n\n- **`{keepalive, Boolean}` (TCP/IP sockets)** - Enables/disables periodic\n  transmission on a connected socket when no other data is exchanged. If the\n  other end does not respond, the connection is considered broken and an error\n  message is sent to the controlling process. Defaults to `false`.\n\n- **`{linger, {true|false, Seconds}}`** [](){: #option-linger } -\n  Determines the time-out, in seconds, for flushing unsent data\n  in the [`close/1`](`close/1`) socket call.\n\n  The first component is if linger is enabled, the second component is the\n  flushing time-out, in seconds. There are 3 alternatives:\n\n  - **`{false, _}`** - close/1 or shutdown/2 returns immediately, not waiting\n    for data to be flushed, with closing happening in the background.\n\n  - **`{true, 0}`** - Aborts the connection when it is closed. Discards any data\n    still remaining in the send buffers and sends RST to the peer.\n\n    This avoids TCP's TIME_WAIT state, but leaves open the possibility that\n    another \"incarnation\" of this connection being created.\n\n  - **`{true, Time} when Time > 0`** - close/1 or shutdown/2 will not return\n    until all queued messages for the socket have been successfully sent or the\n    linger timeout (Time) has been reached.\n\n- **`{low_msgq_watermark, Size}`** - If the socket message queue is in a busy\n  state, the socket message queue is set in a not busy state when the amount of\n  data queued in the message queue falls below this limit. Notice that this\n  limit only concerns data that has not yet reached the ERTS internal socket\n  implementation. Defaults to 4 kB.\n\n  Senders that are suspended because of either a busy message queue or a busy\n  socket are resumed when the socket message queue and the socket are not busy.\n\n  For more information, see options `high_msgq_watermark`, `high_watermark`, and\n  `low_watermark`.\n\n  Notice that distribution sockets disable the use of `high_msgq_watermark` and\n  `low_msgq_watermark`. Instead they use the\n  [distribution buffer busy limit](`m:erlang#system_info_dist_buf_busy_limit`),\n  which is a similar feature.\n\n- **`{low_watermark, Size}` (TCP/IP sockets)** - If the socket is in a busy\n  state, the socket is set in a not busy state when the amount of data queued\n  internally by the ERTS socket implementation falls below this limit. Defaults\n  to 4 kB.\n\n  Senders that are suspended because of a busy message queue or a busy socket\n  are resumed when the socket message queue and the socket are not busy.\n\n  For more information, see options `high_watermark`, `high_msgq_watermark`, and\n  `low_msgq_watermark`.\n\n- **`{mode, Mode :: binary | list}`** - Received `Packet` is delivered as\n  defined by `Mode`.\n\n- **`{netns, Namespace :: file:filename_all()}`{: #option-netns }** - Sets a\n  network namespace for the socket. Parameter `Namespace` is a filename defining\n  the namespace, for example, `\"/var/run/netns/example\"`, typically created by\n  command `ip netns add example`. This option must be used in a function call\n  that creates a socket, that is, [`gen_tcp:connect/3,4`](`gen_tcp:connect/3`),\n  `gen_tcp:listen/2`, [`gen_udp:open/1,2`](`gen_udp:open/1`) or\n  [`gen_sctp:open/0,1,2`](`gen_sctp:open/0`), and also `getifaddrs/1`.\n\n  This option uses the Linux-specific syscall `setns()`, such as in Linux kernel\n  3.0 or later, and therefore only exists when the runtime system is compiled\n  for such an operating system.\n\n  The virtual machine also needs elevated privileges, either running as\n  superuser or (for Linux) having capability `CAP_SYS_ADMIN` according to the\n  documentation for `setns(2)`. However, during testing also `CAP_SYS_PTRACE`\n  and `CAP_DAC_READ_SEARCH` have proven to be necessary.\n\n  _Example:_\n\n  ```text\n  setcap cap_sys_admin,cap_sys_ptrace,cap_dac_read_search+epi beam.smp\n  ```\n\n  Notice that the filesystem containing the virtual machine executable\n  (`beam.smp` in the example) must be local, mounted without flag `nosetuid`,\n  support extended attributes, and the kernel must support file capabilities.\n  All this runs out of the box on at least Ubuntu 12.04 LTS, except that SCTP\n  sockets appear to not support network namespaces.\n\n  `Namespace` is a filename and is encoded and decoded as discussed in module\n  `m:file`, with the following exceptions:\n\n  - Emulator flag `+fnu` is ignored.\n  - `getopts/2` for this option returns a binary for the filename if the stored\n    filename cannot be decoded. This is only to occur if you set the option\n    using a binary that cannot be decoded with the emulator's filename encoding:\n    `file:native_name_encoding/0`.\n\n- **`{bind_to_device, Ifname :: binary()}`** - Binds a socket to a specific\n  network interface. This option must be used in a function call that creates a\n  socket, that is, [`gen_tcp:connect/3,4`](`gen_tcp:connect/3`),\n  `gen_tcp:listen/2`, [`gen_udp:open/1,2`](`gen_udp:open/1`), or\n  [`gen_sctp:open/0,1,2`](`gen_sctp:open/0`).\n\n  Unlike `getifaddrs/0`, Ifname is encoded a binary. In the unlikely case that a\n  system is using non-7-bit-ASCII characters in network device names, special\n  care has to be taken when encoding this argument.\n\n  This option uses the Linux-specific socket option `SO_BINDTODEVICE`, such as\n  in Linux kernel 2.0.30 or later, and therefore only exists when the runtime\n  system is compiled for such an operating system.\n\n  Before Linux 3.8, this socket option could be set, but could not retrieved\n  with `getopts/2`. Since Linux 3.8, it is readable.\n\n  The virtual machine also needs elevated privileges, either running as\n  superuser or (for Linux) having capability `CAP_NET_RAW`.\n\n  The primary use case for this option is to bind sockets into\n  [Linux VRF instances](http://www.kernel.org/doc/Documentation/networking/vrf.txt).\n\n- **`list`** - Received `Packet` is delivered as a list.\n\n- **`binary`** - Received `Packet` is delivered as a binary.\n\n- **`{nodelay, Boolean}` (TCP/IP sockets)** [](){: #option-nodelay } -\n  If `Boolean == true`, option `TCP_NODELAY` is turned on for the socket,\n  which means that also small amounts of data are sent immediately.\n\n  This option is _not_ supported for `domain = local`, but if\n  `inet_backend =/= socket` this error will be _ignored_.\n\n- **`{nopush, Boolean}` (TCP/IP sockets)** - This translates to `TCP_NOPUSH` on\n  BSD and to `TCP_CORK` on Linux.\n\n  If `Boolean == true`, the corresponding option is turned on for the socket,\n  which means that small amounts of data are accumulated until a full MSS-worth\n  of data is available or this option is turned off.\n\n  Note that while `TCP_NOPUSH` socket option is available on OSX, its semantics\n  is very different (e.g., unsetting it does not cause immediate send of\n  accumulated data). Hence, `nopush` option is intentionally ignored on OSX.\n\n- **`{packet, PacketType}` (TCP/IP sockets)** [](){: #option-packet } -\n  Defines the type of packets to use for a socket. Possible values:\n\n  - **`raw | 0`** - No packaging is done.\n\n  - **`1 | 2 | 4`** - Packets consist of a header specifying the number of bytes\n    in the packet, followed by that number of bytes. The header length can be\n    one, two, or four bytes, and containing an unsigned integer in big-endian\n    byte order. Each send operation generates the header, and the header is\n    stripped off on each receive operation.\n\n    The 4-byte header is limited to 2Gb.\n\n  - **`asn1 | cdr | sunrm | fcgi | tpkt | line`** - These packet types only have\n    effect on receiving. When sending a packet, it is the responsibility of the\n    application to supply a correct header. On receiving, however, one message\n    is sent to the controlling process for each complete packet received, and,\n    similarly, each call to `gen_tcp:recv/2,3` returns one complete packet. The\n    header is _not_ stripped off.\n\n    The meanings of the packet types are as follows:\n\n    - `asn1` - ASN.1 BER\n    - `sunrm` - Sun's RPC encoding\n    - `cdr` - CORBA (GIOP 1.1)\n    - `fcgi` - Fast CGI\n    - `tpkt` - TPKT format \\[RFC1006]\n    - `line` - Line mode, a packet is a line-terminated with newline, lines\n      longer than the receive buffer are truncated\n\n  - **`http | http_bin`** - The Hypertext Transfer Protocol. The packets are\n    returned with the format according to `HttpPacket` described in\n    `erlang:decode_packet/3` in ERTS. A socket in passive mode returns\n    `{ok, HttpPacket}` from `gen_tcp:recv` while an active socket sends messages\n    like `{http, Socket, HttpPacket}`.\n\n  - **`httph | httph_bin`** - These two types are often not needed, as the\n    socket automatically switches from `http`/`http_bin` to `httph`/`httph_bin`\n    internally after the first line is read. However, there can be occasions\n    when they are useful, such as parsing trailers from chunked encoding.\n\n- **`{packet_size, Integer}`(TCP/IP sockets)** - Sets the maximum allowed length\n  of the packet body. If the packet header indicates that the length of the\n  packet is longer than the maximum allowed length, the packet is considered\n  invalid. The same occurs if the packet header is too large for the socket\n  receive buffer.\n\n  For line-oriented protocols (`line`, `http*`), option `packet_size` also\n  guarantees that lines up to the indicated length are accepted and not\n  considered invalid because of internal buffer limitations.\n\n- **`{line_delimiter, Char}` (TCP/IP sockets)**\n  [](){: #option-line_delimiter } -\n  Sets the line delimiting character for line-oriented protocols (`line`).\n  Defaults to `$\\n`.\n\n- **`{raw, Protocol, OptionNum, ValueBin}`** - See below.\n\n- **`{read_ahead, Boolean}`** [](){: #option-read_ahead } -\n  If set to `false` avoids reading ahead from the OS socket layer.\n  The default for this option is `true` which speeds up packet header parsing.\n  Setting `false` has a performance penalty because the packet header\n  has to be read first, to know exactly how many bytes to read for the body,\n  which roughly doubles the number of read operations.\n\n  The use of this option is essential for example before switching to kTLS\n  which activates OS socket layer encryption and decryption by setting\n  special (raw) socket options.  So if the Erlang socket layer has read ahead,\n  it has read bytes that was for the OS socket layer to decrypt,\n  which makes packet decryption derail for the connection.\n\n  > #### Warning {: .warning }\n  >\n  > For packet modes that doesn't have the packet length at a fixed location\n  > in a packet header, such as `line` or `asn1`, not reading ahead\n  > can become very inefficient since sometimes the only way to accomplish\n  > this is to read one byte at the time until the length\n  > or packet end is found.\n\n- **`{read_packets, Integer}` (UDP sockets)** [](){: #option-read_packets } -\n  Sets the maximum number of UDP packets to read without intervention\n  from the socket when data is available.  When this many packets\n  have been read and delivered to the destination process,\n  new packets are not read until a new notification of available data\n  has arrived. Defaults to `5`. If this parameter is set too high, the system\n  can become unresponsive because of UDP packet flooding.\n\n- **`{recbuf, Size}`** [](){: #option-recbuf } -\n  The minimum size of the receive buffer to use for the socket.\n  You are encouraged to use `getopts/2` to retrieve the size\n  set by your operating system.\n\n- **`{recvtclass, Boolean}`** [](){: #option-recvtclass } -\n  If set to `true` activates returning the received `TCLASS` value\n  on platforms that implements the protocol `IPPROTO_IPV6` option\n  `IPV6_RECVTCLASS` or `IPV6_2292RECVTCLASS` for the socket.\n  The value is returned as a `{tclass,TCLASS}` tuple regardless of if\n  the platform returns an `IPV6_TCLASS` or an `IPV6_RECVTCLASS` CMSG value.\n\n  For packet oriented sockets that supports receiving ancillary data with the\n  payload data (`gen_udp` and `gen_sctp`), the `TCLASS` value is returned in an\n  extended return tuple contained in an\n  [ancillary data](`t:ancillary_data/0`) list. For stream oriented sockets\n  (`gen_tcp`) the only way to get the `TCLASS` value is if the platform supports\n  the [`pktoptions`](`t:gen_tcp:pktoptions_value/0`) option.\n\n- **`{recvtos, Boolean}`** [](){: #option-recvtos } -\n  If set to `true` activates returning the received `TOS` value\n  on platforms that implements the protocol `IPPROTO_IP` option\n  `IP_RECVTOS` for the socket. The value is returned as a `{tos,TOS}` tuple\n  regardless of if the platform returns an `IP_TOS` or an `IP_RECVTOS` CMSG\n  value.\n\n  For packet oriented sockets that supports receiving ancillary data with the\n  payload data (`gen_udp` and `gen_sctp`), the `TOS` value is returned in an\n  extended return tuple contained in an\n  [ancillary data](`t:ancillary_data/0`) list. For stream oriented sockets\n  (`gen_tcp`) the only way to get the `TOS` value is if the platform supports\n  the [`pktoptions`](`t:gen_tcp:pktoptions_value/0`) option.\n\n- **`{recvttl, Boolean}`** [](){: #option-recvttl } -\n  If set to `true` activates returning the received `TTL` value\n  on platforms that implements the protocol `IPPROTO_IP` option `IP_RECVTTL`\n  for the socket. The value is returned as a `{ttl,TTL}` tuple\n  regardless of if the platform returns an `IP_TTL` or an `IP_RECVTTL` CMSG\n  value.\n\n  For packet oriented sockets that supports receiving ancillary data with the\n  payload data (`gen_udp` and `gen_sctp`), the `TTL` value is returned in an\n  extended return tuple contained in an\n  [ancillary data](`t:ancillary_data/0`) list. For stream oriented sockets\n  (`gen_tcp`) the only way to get the `TTL` value is if the platform supports\n  the [`pktoptions`](`t:gen_tcp:pktoptions_value/0`) option.\n\n- **`{reuseaddr, Boolean}`[](){: #option-reuseaddr }** -\n   Allows or disallows reuse of local address. By default, reuse is disallowed.\n\n  > #### Note {: .info }\n  >\n  > On windows `{reuseaddr, true}` will have no effect unless also\n  > [`{reuseport, true}`](#option-reuseport) is set. If both are set,\n  > the `SO_REUSEADDR` Windows socket option will be enabled. This since setting\n  > `SO_REUSEADDR` on Windows more or less has the same behavior as setting both\n  > `SO_REUSEADDR` and `SO_REUSEPORT` on BSD. This behavior was introduced as of\n  > OTP 26.0.\n  >\n  > > #### Change {: .info }\n  > >\n  > > Previous behavior on Windows:\n  > >\n  > > - Prior to OTP 25.0, the `{reuseaddr, true}` option was silently ignored.\n  > > - Between OTP 25.0 and up to the predecessor of OTP 25.2, the underlying\n  > >   `SO_REUSEADDR` socket option was set if `{reuseaddr, true}` was set.\n  > > - Between OTP 25.2 and up to the predecessor of OTP 26.0, the underlying\n  > >   `SO_REUSEADDR` socket option was only set on UDP sockets if\n  > >   `{reuseaddr, true}` was set, and silently ignored on other sockets.\n  >\n  > See also the [`exclusiveaddruse`](#option-exclusiveaddruse) option.\n\n- **`{reuseport, Boolean}`[](){: #option-reuseport }** -\n   Allows or disallows reuse of local port which _may or may not_\n  have load balancing depending on the underlying OS. By default,\n  reuse is disallowed. See also [`reuseport_lb`](#option-reuseport_lb).\n\n  > #### Note {: .info }\n  >\n  > On windows `{reuseport, true}` will have no effect unless also\n  > [`{reuseaddr, true}`](#option-reuseaddr) is set. If both are set,\n  > the `SO_REUSEADDR` Windows socket option will be enabled. This since setting\n  > `SO_REUSEADDR` on Windows more or less has the same behavior as setting both\n  > `SO_REUSEADDR` and `SO_REUSEPORT` on BSD. The `reuseport` option was\n  > introduced as of OTP 26.0.\n  >\n  > See also the [`exclusiveaddruse`](#option-exclusiveaddruse) option.\n\n  > #### Note {: .info }\n  >\n  > `reuseport` _may or may not_ be the same underlying option as\n  > [`reuseport_lb`](#option-reuseport_lb) depending on the underlying\n  > OS. They, for example, are on Linux. When they are the same underlying\n  > option, operating on both may cause them to interact in surprising ways. For\n  > example, by enabling `reuseport` and then disabling `reuseport_lb` both will\n  > end up being disabled.\n\n  > #### Note {: .info }\n  >\n  > This option is _currently_ not supported for socket created with\n  > `inet_backend = socket`\n\n- **`{reuseport_lb, Boolean}`[](){: #option-reuseport_lb }** -\n  Allows or disallows reuse of local port _with_ load balancing.\n  By default, reuse is disallowed.  See also [`reuseport`](#option-reuseport).\n\n  > #### Note {: .info }\n  >\n  > `reuseport_lb` _may or may not_ be the same underlying option as\n  > [`reuseport`](#option-reuseport) depending on the underlying OS.\n  > On Linux, for example, they are.  And when they are the same\n  >  underlying option, operating on both may cause them to interact\n  > in surprising ways. For example, by enabling `reuseport_lb`,\n  > and then disabling `reuseport`, both will end up being disabled.\n\n  > #### Note {: .info }\n  >\n  > This option is _currently_ not supported for socket created with\n  > `inet_backend = socket`\n\n- **`{send_timeout, Integer}`** - Only allowed for connection-oriented sockets.\n\n  Specifies a longest time to wait for a send operation to be accepted by the\n  underlying TCP stack. When the limit is exceeded, the send operation returns\n  `{error, timeout}`. How much of a packet that got sent is unknown; the socket\n  is therefore to be closed whenever a time-out has occurred (see\n  `send_timeout_close` below). Defaults to `infinity`.\n\n- **`{send_timeout_close, Boolean}`** - Only allowed for connection-oriented\n  sockets.\n\n  Used together with `send_timeout` to specify whether the socket is to be\n  automatically closed when the send operation returns `{error, timeout}`. The\n  recommended setting is `true`, which automatically closes the socket. Defaults\n  to `false` because of backward compatibility.\n\n- **`{show_econnreset, Boolean}` (TCP/IP sockets)**\n  [](){: #option-show_econnreset } -\n  When this option is set to `false`, which is default, an RST\n  received from the TCP peer is treated as a normal close\n  (as though an FIN was sent). A caller to `gen_tcp:recv/2` gets\n  `{error, closed}`. In active mode, the controlling process receives a\n  `{tcp_closed, Socket}` message, indicating that the peer has closed the\n  connection.\n\n  Setting this option to `true` allows you to distinguish between a connection\n  that was closed normally, and one that was aborted (intentionally or\n  unintentionally) by the TCP peer. A call to `gen_tcp:recv/2` returns\n  `{error, econnreset}`. In active mode, the controlling process receives a\n  `{tcp_error, Socket, econnreset}` message before the usual\n  `{tcp_closed, Socket}`, as is the case for any other socket error. Calls to\n  `gen_tcp:send/2` also returns `{error, econnreset}` when it is detected that a\n  TCP peer has sent an RST.\n\n  A connected socket returned from `gen_tcp:accept/1` inherits the\n  `show_econnreset` setting from the listening socket.\n\n- **`{sndbuf, Size}`** [](){: #option-sndbuf } -\n  The minimum size of the send buffer to use for the socket.\n  You are encouraged to use `getopts/2`, to retrieve the size\n  set by your operating system.\n\n- **`{priority, Integer}`** - Sets the `SO_PRIORITY` socket level option on\n  platforms where this is implemented. The behavior and allowed range varies\n  between different systems. The option is ignored on platforms where it is not\n  implemented. Use with caution.\n\n- **`{tos, Integer}`** - Sets `IP_TOS IP` level options on platforms where this\n  is implemented. The behavior and allowed range varies between different\n  systems. The option is ignored on platforms where it is not implemented. Use\n  with caution.\n\n- **`{tclass, Integer}`** - Sets `IPV6_TCLASS IP` level options on platforms\n  where this is implemented. The behavior and allowed range varies between\n  different systems. The option is ignored on platforms where it is not\n  implemented. Use with caution.\n\nIn addition to these options, _raw_ option specifications can be used. The raw\noptions are specified as a tuple of arity four, beginning with tag `raw`,\nfollowed by the protocol level, the option number, and the option value\nspecified as a binary. This corresponds to the second, third, and fourth\narguments to the `setsockopt` call in the C socket API. The option value must be\ncoded in the native endianness of the platform and, if a structure is required,\nmust follow the structure alignment conventions on the specific platform.\n\nUsing raw socket options requires detailed knowledge about the current operating\nsystem and TCP stack.\n\n_Example:_\n\nThis example concerns the use of raw options. Consider a Linux system where you\nwant to set option `TCP_LINGER2` on protocol level `IPPROTO_TCP` in the stack.\nYou know that on this particular system it defaults to 60 (seconds), but you\nwant to lower it to 30 for a particular socket. Option `TCP_LINGER2` is not\nexplicitly supported by `inet`, but you know that the protocol level translates\nto number 6, the option number to number 8, and the value is to be specified as\na 32-bit integer. You can use this code line to set the option for the socket\nnamed `Sock`:\n\n```text\ninet:setopts(Sock, [{raw,6,8,<<30:32/native>>}]),\n```\n\nAs many options are silently discarded by the stack if they are specified out of\nrange; it can be a good idea to check that a raw option is accepted. The\nfollowing code places the value in variable `TcpLinger2:`\n\n```text\n{ok,[{raw,6,8,< >}]}=inet:getopts(Sock,[{raw,6,8,4}]),\n```\n\nCode such as these examples is inherently non-portable, even different versions\nof the same OS on the same platform can respond differently to this kind of\noption manipulation. Use with care.\n\nNotice that the default options for TCP/IP sockets can be changed with the\nKernel configuration parameters mentioned in the beginning of this manual page.","ref":"inet.html#setopts/2"},{"type":"type","title":"inet.socket/0","doc":"A socket recognized by this module and its siblings.\n\nSee `t:gen_tcp:socket/0` and `t:gen_udp:socket/0`.","ref":"inet.html#t:socket/0"},{"type":"type","title":"inet.socket_address/0","doc":"","ref":"inet.html#t:socket_address/0"},{"type":"type","title":"inet.socket_getopt/0","doc":"","ref":"inet.html#t:socket_getopt/0"},{"type":"type","title":"inet.socket_optval/0","doc":"","ref":"inet.html#t:socket_optval/0"},{"type":"type","title":"inet.socket_protocol/0","doc":"","ref":"inet.html#t:socket_protocol/0"},{"type":"type","title":"inet.socket_setopt/0","doc":"","ref":"inet.html#t:socket_setopt/0"},{"type":"function","title":"inet.sockname/1","doc":"Return the local address and port number for a socket.\n\nNotice that for SCTP sockets this function returns only one of the socket\naddresses. Function [`socknames/1,2`](`socknames/1`) returns all.","ref":"inet.html#sockname/1"},{"type":"function","title":"inet.socknames/1","doc":"Equivalent to [`socknames(Socket, 0)`](`socknames/2`).","ref":"inet.html#socknames/1"},{"type":"function","title":"inet.socknames/2","doc":"Return all localaddresses for a socket.\n\nReturns a list of all local address/port number pairs for a socket,\nfor the specified association `Assoc`.\n\nThis function can return multiple addresses for multihomed sockets,\nsuch as SCTP sockets. For other sockets it returns a one-element list.\n\nNotice that parameter `Assoc` is by the\n[SCTP Sockets API Extensions](http://tools.ietf.org/html/draft-ietf-tsvwg-sctpsocket-13)\ndefined to be ignored for one-to-one style sockets.  For one-to-many style\nsockets, the special value `0` is defined to mean that the returned addresses\nmust be without any particular association. How different SCTP implementations\ninterpret this varies somewhat.","ref":"inet.html#socknames/2"},{"type":"type","title":"inet.stat_option/0","doc":"","ref":"inet.html#t:stat_option/0"},{"type":"module","title":"inet_res","doc":"A rudimentary DNS client.\n\nThis module performs DNS name resolving towards recursive name servers.\n\nSee also [ERTS User's Guide: Inet Configuration](`e:erts:inet_cfg.md`)\nor more information about how to configure an Erlang runtime system for IP\ncommunication, and how to enable this DNS client by defining `'dns'`\nas a lookup method. The DNS client then acts as a backend for\nthe resolving functions in `m:inet`.\n\nThis DNS client can resolve DNS records even if it is not used\nfor normal name resolving in the node.\n\nThis is not a full-fledged resolver, only a DNS client that relies on asking\ntrusted recursive name servers.","ref":"inet_res.html"},{"type":"module","title":"Name Resolving - inet_res","doc":"UDP queries are used unless resolver option `usevc` is `true`,\nwhich forces TCP queries.  If the query is too large for UDP,\nTCP is used instead. For regular DNS queries, 512 bytes is the size limit.\n\nWhen EDNS is enabled (resolver option `edns` is set to the EDNS version\n(that is; `0` instead of `false`), resolver option `udp_payload_size`\nsets the payload size limit.  If a name server replies with the TC bit set\n(truncation), indicating that the answer is incomplete, the query is retried\ntowards the same name server using TCP.  Resolver option `udp_payload_size`\nalso sets the advertised size for the maximum allowed reply size,\nif EDNS is enabled, otherwise the name server uses the limit 512 bytes.\nIf the reply is larger, it gets truncated, forcing a TCP requery.\n\nFor UDP queries, resolver options `timeout` and `retry` control\nretransmission.  Each name server in the `nameservers` list is tried\nwith a time-out of `timeout`/`retry`. Then all name servers are tried again,\ndoubling the time-out, for a total of `retry` times.\n\n[](){: #servfail_retry_timeout }\n\nBut before all name servers are tried again, there is a (user configurable)\ntime-out, `servfail_retry_timeout`. The point of this is to prevent\nthe new query to be handled by a server's servfail cache (a client\nthat is too eager will actually only get what is in the servfail cache).\nIf there is too little time left of the resolver call's time-out\nto do a retry, the resolver call may return before the call's time-out\nhas expired.\n\nFor queries not using the `search` list, if the query to all `nameservers`\nresults in `{error,nxdomain}` or an empty answer, the same query is tried for\n`alt_nameservers`.","ref":"inet_res.html#module-name-resolving"},{"type":"module","title":"Resolver Types - inet_res","doc":"The following data types concern the resolver:","ref":"inet_res.html#module-resolver-types"},{"type":"module","title":"DNS Types - inet_res","doc":"The following data types concern the DNS client:","ref":"inet_res.html#module-dns-types"},{"type":"module","title":"Example - inet_res","doc":"This access functions example shows how `lookup/3` can be implemented using\n`resolve/3` from outside the module:\n\n```erlang\nexample_lookup(Name, Class, Type) ->\n    case inet_res:resolve(Name, Class, Type) of\n        {ok,Msg} ->\n            [inet_dns:rr(RR, data)\n             || RR <- inet_dns:msg(Msg, anlist),\n                 inet_dns:rr(RR, type) =:= Type,\n                 inet_dns:rr(RR, class) =:= Class];\n        {error,_} ->\n            []\n     end.\n```","ref":"inet_res.html#module-example"},{"type":"type","title":"inet_res.dns_class/0","doc":"","ref":"inet_res.html#t:dns_class/0"},{"type":"type","title":"inet_res.dns_data/0","doc":"DNS record data (content)\n\nThe basic type of each data element is specified in this type.\n\n`Regexp` is a UTF-8 `t:string/0`.  The other `t:string/0`s\nare actually Latin-1 strings.","ref":"inet_res.html#t:dns_data/0"},{"type":"type","title":"inet_res.dns_msg/0","doc":"A DNS message.\n\nThis is the start of a hierarchy of opaque data structures that can be\nexamined with access functions in `inet_dns`, which return lists of\n`{Field,Value}` tuples. The arity 2 functions return the value\nfor a specified field.\n\n```erlang\ndns_msg() = DnsMsg\n    inet_dns:msg(DnsMsg) ->\n        [ {header, dns_header()}\n        | {qdlist, dns_query()}\n        | {anlist, dns_rr()}\n        | {nslist, dns_rr()}\n        | {arlist, dns_rr()} ]\n    inet_dns:msg(DnsMsg, header) -> dns_header() % for example\n    inet_dns:msg(DnsMsg, Field) -> Value\n\ndns_header() = DnsHeader\n    inet_dns:header(DnsHeader) ->\n        [ {id, integer()}\n        | {qr, boolean()}\n        | {opcode, query | iquery | status | integer()}\n        | {aa, boolean()}\n        | {tc, boolean()}\n        | {rd, boolean()}\n        | {ra, boolean()}\n        | {pr, boolean()}\n        | {rcode, integer(0..16)} ]\n    inet_dns:header(DnsHeader, Field) -> Value\n\nquery_type() = axfr | mailb | maila | any | dns_rr_type()\n\ndns_query() = DnsQuery\n    inet_dns:dns_query(DnsQuery) ->\n        [ {domain, dns_name()}\n        | {type, query_type()}\n        | {class, dns_class()} ]\n    inet_dns:dns_query(DnsQuery, Field) -> Value\n\ndns_rr() = DnsRr\n    inet_dns:rr(DnsRr) -> DnsRrFields | DnsRrOptFields\n    DnsRrFields = [ {domain, dns_name()}\n                  | {type, dns_rr_type()}\n                  | {class, dns_class()}\n                  | {ttl, integer()}\n                  | {data, dns_data()} ]\n    DnsRrOptFields = [ {domain, dns_name()}\n                     | {type, opt}\n                     | {udp_payload_size, integer()}\n                     | {ext_rcode, integer()}\n                     | {version, integer()}\n                     | {z, integer()}\n                     | {data, dns_data()} ]\n    inet_dns:rr(DnsRr, Field) -> Value\n```\n\nThere is an information function for the types above:\n\n```erlang\ninet_dns:record_type(dns_msg()) -> msg;\ninet_dns:record_type(dns_header()) -> header;\ninet_dns:record_type(dns_query()) -> dns_query;\ninet_dns:record_type(dns_rr()) -> rr;\ninet_dns:record_type(_) -> undefined.\n```\n\nSo, `inet_dns:(inet_dns:record_type(X))(X)` converts any of these data\nstructures into a `{Field,Value}` list.","ref":"inet_res.html#t:dns_msg/0"},{"type":"type","title":"inet_res.dns_name/0","doc":"A string with no adjacent dots.","ref":"inet_res.html#t:dns_name/0"},{"type":"type","title":"inet_res.dns_rr_type/0","doc":"","ref":"inet_res.html#t:dns_rr_type/0"},{"type":"function","title":"inet_res.getbyname/2","doc":"Equivalent to  getbyname(Name, Type, infinity) .","ref":"inet_res.html#getbyname/2"},{"type":"function","title":"inet_res.getbyname/3","doc":"Resolve a DNS query.\n\nResolves a DNS query of the specified `Type` for the specified host,\nof class`in`.  Returns, on success, when resolving a `Type = a|aaaa`\nDNS record, a `#hostent{}` record with `#hostent.h_addrtype = inet|inet6`,\nrespectively; see `t:inet:hostent/0`.\n\nWhen resolving other `Type = dns_rr_type()`:s (of class `in`), also returns\na `#hostent{}` record but with `t:dns_rr_type/0` in `#hostent.h_addrtype`,\nand the resolved `t:dns_data/0` in `#hostent.h_addr_list`; see `t:hostent/0`.\n\nThis function uses resolver option `search` that is a list of domain names.\nIf the name to resolve contains no dots, it is prepended to each domain\nname in the search list, and they are tried in order.  If the name\ncontains dots, it is first tried as an absolute name and if that fails,\nthe search list is used. If the name has a trailing dot, it is supposed\nto be an absolute name and the search list is not used.","ref":"inet_res.html#getbyname/3"},{"type":"function","title":"inet_res.gethostbyaddr/1","doc":"Equivalent to  gethostbyaddr(Address, infinity) .","ref":"inet_res.html#gethostbyaddr/1"},{"type":"function","title":"inet_res.gethostbyaddr/2","doc":"Backend function used by `inet:gethostbyaddr/1`.","ref":"inet_res.html#gethostbyaddr/2"},{"type":"function","title":"inet_res.gethostbyname/1","doc":"Backend functions used by [`inet:gethostbyname/1,2`](`inet:gethostbyname/1`).\n\nIf resolver option `inet6` is `true`, equivalent to\n[`gethostbyname(Name, inet6, infinity)`](`gethostbyname/3`),\notherwise [`gethostbyname(Name, inet, infinity)`](`gethostbyname/3`).","ref":"inet_res.html#gethostbyname/1"},{"type":"function","title":"inet_res.gethostbyname/2","doc":"Equivalent to  gethostbyname(Name, Family, infinity) .","ref":"inet_res.html#gethostbyname/2"},{"type":"function","title":"inet_res.gethostbyname/3","doc":"Backend functions used by [`inet:gethostbyname/1,2`](`inet:gethostbyname/1`).\n\nThis function uses resolver option `search` just like\n[`getbyname/2,3`](`getbyname/2`).","ref":"inet_res.html#gethostbyname/3"},{"type":"type","title":"inet_res.hostent/0","doc":"Extended variant of `t:inet:hostent/0`.\n\nAllows `t:dns_rr_type/0` for the\n[`#hostent{}.h_addrtype`](`t:inet:hostent/0`) field, and\n`[`[`dns_data/0`](`t:dns_data/0`)`]` for the\n[`#hostent{}.h_addr_list`](`t:inet:hostent/0`) field.","ref":"inet_res.html#t:hostent/0"},{"type":"function","title":"inet_res.lookup/3","doc":"Equivalent to  lookup(Name, Class, Type, [], infinity) .","ref":"inet_res.html#lookup/3"},{"type":"function","title":"inet_res.lookup/4","doc":"Equivalent to  lookup(Name, Class, Type, Opts, infinity) .","ref":"inet_res.html#lookup/4"},{"type":"function","title":"inet_res.lookup/5","doc":"Look up DNS data.\n\nResolves the DNS data for the record `Name` of the specified\n`Type` and `Class`. On success, filters out the answer records\nwith the correct `Class` and `Type`, and returns a list of their data fields.\nSo, a lookup for type `any` gives an empty answer, as the answer records\nhave specific types that are not `any`. An empty answer or a failed lookup\nreturns an empty list.\n\nCalls [`resolve/*`](`resolve/3`) with the same arguments and filters the result,\nso `Opts` is described for those functions.","ref":"inet_res.html#lookup/5"},{"type":"type","title":"inet_res.nameserver/0","doc":"","ref":"inet_res.html#t:nameserver/0"},{"type":"function","title":"inet_res.nnslookup/4","doc":"Equivalent to  nnslookup(Name, Class, Type, NSs, infinity) .","ref":"inet_res.html#nnslookup/4"},{"type":"function","title":"inet_res.nnslookup/5","doc":"Resolve a DNS query.\n\nLike `nslookup/4` but calls `resolve/5` with both the arguments\n`Opts = [{nameservers, Nameservers}]` and `Timeout`.","ref":"inet_res.html#nnslookup/5"},{"type":"function","title":"inet_res.nslookup/3","doc":"Equivalent to  nslookup(Name, Class, Type, infinity) .","ref":"inet_res.html#nslookup/3"},{"type":"function","title":"inet_res.nslookup/4","doc":"Resolve a DNS query.\n\nThis function is a legacy wrapper to `resolve/5` that simplifies\nerrors matching `{error, {Reason, _}}` into `{error, Reason}`\nor `{error, einval}`.\n\nWith argument `Timeout` calls `resolve/5` with `Opts = []`.\n\nWith argument `Nameservers` calls `resolve/5` with\n`Opts = [{nameservers, Nameservers}]` and `Timeout = infinity`.","ref":"inet_res.html#nslookup/4"},{"type":"type","title":"inet_res.res_error/0","doc":"","ref":"inet_res.html#t:res_error/0"},{"type":"type","title":"inet_res.res_option/0","doc":"","ref":"inet_res.html#t:res_option/0"},{"type":"function","title":"inet_res.resolve/3","doc":"Equivalent to  resolve(Name, Class, Type, [], infinity) .","ref":"inet_res.html#resolve/3"},{"type":"function","title":"inet_res.resolve/4","doc":"Equivalent to  resolve(Name, Class, Type, Opts, infinity) .","ref":"inet_res.html#resolve/4"},{"type":"function","title":"inet_res.resolve/5","doc":"Resolve a DNS query.\n\nResolves a DNS query for the specified `Type`, `Class`, and  `Name`,\ninto a DNS message possibly containing Resource Records.\nThe returned `t:dns_msg/0` can be examined using access functions\nin `inet_db`, as described in section in [DNS Types](#module-dns-types).\n\nIf `Name` is an `ip_address()`, the domain name to query about is generated\nas the standard reverse `\".IN-ADDR.ARPA.\"` name for an IPv4 address, or the\n`\".IP6.ARPA.\"` name for an IPv6 address.  In this case, you most probably\nwant to use `Class = in` and `Type = ptr`, but it is not done automatically.\n\n`Opts` overrides the corresponding resolver options. If option `nameservers`\nis specified, it is assumed that it is the complete list of name serves,\nso resolver option `alt_nameserves` is ignored. However, if option\n`alt_nameserves` is also specified to this function, it is used.\n\nOption `verbose` (or rather `{verbose,true}`) causes diagnostics printout\nthrough [`io:format/2`](`io:format/3`) of queries, replies, retransmissions,\nand so on, similar to utilities such as `dig` and `nslookup`.\n\nOption `nxdomain_reply` (or rather `{nxdomain_reply, true}`) causes NXDOMAIN\nerrors from DNS servers to be returned as `{error, {nxdomain, dns_msg()}}`.\n`t:dns_msg/0` contains the additional sections that where included by the\nanswering server. This is mainly useful to inspect the SOA record\nto get the TTL for negative caching.\n\nIf `Opt` is any atom, it is interpreted as `{Opt,true}` unless\nthe atom string starts with `\"no\"`, making the interpretation `{Opt,false}`.\nFor example, `usevc` is an alias for `{usevc, true}` and `nousevc`\nis an alias for `{usevc, false}`.\n\nOption `inet6` has no effect on this function. You probably want to use\n`Type = a | aaaa` instead.","ref":"inet_res.html#resolve/5"},{"type":"module","title":"net","doc":"Network interface.\n\nThis module provides an API for the network interface.","ref":"net.html"},{"type":"type","title":"net.address_info/0","doc":"","ref":"net.html#t:address_info/0"},{"type":"function","title":"net.getaddrinfo/1","doc":"Equivalent to  getaddrinfo(Host, undefined) .","ref":"net.html#getaddrinfo/1"},{"type":"function","title":"net.getaddrinfo/2","doc":"Network address and service translation.\n\nThis function is the inverse of [`getnameinfo`](`getnameinfo/1`). It converts\nhost and service to a corresponding socket address.\n\nOne of the `Host` and `Service` may be `undefined` but _not_ both.","ref":"net.html#getaddrinfo/2"},{"type":"function","title":"net.gethostname/0","doc":"Return the name of the current host.","ref":"net.html#gethostname/0"},{"type":"function","title":"net.getifaddrs/0","doc":"Equivalent to  getifaddrs(default) .","ref":"net.html#getifaddrs/0"},{"type":"function","title":"net.getifaddrs/1","doc":"Get interface addresses.\n\nWith argument 'Filter: get the machines interface addresses,\nfiltered according to `Filter`.\n\nWith argument `Namespace`: equivalent to\n[`getifaddrs(default, Namespace)`](`getifaddrs/2`).","ref":"net.html#getifaddrs/1"},{"type":"function","title":"net.getifaddrs/2","doc":"Get interface addresses in a namespace.\n\nThe same as [`getifaddrs(Filter)`](`getifaddrs/1`) but\nin the specified `Namespace`.","ref":"net.html#getifaddrs/2"},{"type":"function","title":"net.getnameinfo/1","doc":"Equivalent to  getnameinfo(SockAddr, undefined) .","ref":"net.html#getnameinfo/1"},{"type":"function","title":"net.getnameinfo/2","doc":"Address-to-name translation in a protocol-independant manner.\n\nThis function is the inverse of [`getaddrinfo`](`getaddrinfo/1`). It converts a\nsocket address to a corresponding host and service.","ref":"net.html#getnameinfo/2"},{"type":"function","title":"net.getservbyname/1","doc":"Equivalent to  getservbyname(Name, any) .","ref":"net.html#getservbyname/1"},{"type":"function","title":"net.getservbyname/2","doc":"Get service by name.\n\nThis function is used to get the port number of the specified protocol\nfor the named service.","ref":"net.html#getservbyname/2"},{"type":"function","title":"net.getservbyport/1","doc":"Equivalent to  getservbyport(PortNumber, any) .","ref":"net.html#getservbyport/1"},{"type":"function","title":"net.getservbyport/2","doc":"Get service by name.\n\nThis function is used to get the service name of the specified protocol\nfor the given port number.","ref":"net.html#getservbyport/2"},{"type":"function","title":"net.if_index2name/1","doc":"Mappings between network interface index and names.","ref":"net.html#if_index2name/1"},{"type":"function","title":"net.if_name2index/1","doc":"Mappings between network interface names and indexes.","ref":"net.html#if_name2index/1"},{"type":"function","title":"net.if_names/0","doc":"Get network interface names and indexes.","ref":"net.html#if_names/0"},{"type":"type","title":"net.ifaddrs/0","doc":"Interface addresses and flags.\n\nThis type defines addresses and flags for an interface.\n\n> #### Note {: .info }\n>\n> Not all fields of this map has to be present. The flags field can be used to\n> test for some of the fields. For example `broadaddr` will only be present if\n> the `broadcast` flag is present in flags.","ref":"net.html#t:ifaddrs/0"},{"type":"type","title":"net.ifaddrs_filter/0","doc":"Interface address filtering selector.\n\n- **all** - All interfaces\n\n- **default** - Interfaces with address family `inet` _or_ `inet6`\n\n- **inet | inet6 | packet | link** - Interfaces with _only_ the specified\n address family\n- **hwaddr** - Interfaces with address family `packet` _or_ `link`","ref":"net.html#t:ifaddrs_filter/0"},{"type":"type","title":"net.ifaddrs_filter_fun/0","doc":"Interface address filtering selector `t:function/0`.\n\nFor each `ifaddrs` entry, return either `true` to keep the entry\nor `false` to discard the entry.\n\nFor example, to get an interface list which only contains\nnon-`loopback` `inet` interfaces:\n\n```erlang\nnet:getifaddrs(\n    fun (#{ addr  := #{family := inet},\n            flags := Flags}) ->\n          not lists:member(loopback, Flags);\n        (_) ->\n          false\n    end).\n```","ref":"net.html#t:ifaddrs_filter_fun/0"},{"type":"type","title":"net.ifaddrs_filter_map/0","doc":"Interface address filtering selector map.\n\nThe `family` field can only have the (above) specified values\n(and not all the values of socket:domain()).\nIt can also be a list of values, to cover the situation when\nany of the specified families are accepted.\nFor example, family can be set to `[inet,inet6]` if either `inet` or `inet6`\nis accepted.\n\nThe use of the `flags` field is that any flag provided must exist for the\ninterface.\n\nFor example, if `family` is set to `inet` and `flags` to\n`[broadcast, multicast]` only interfaces with address family `inet`\nand the flags `broadcast` and `multicast` will be listed.","ref":"net.html#t:ifaddrs_filter_map/0"},{"type":"type","title":"net.ifaddrs_flag/0","doc":"","ref":"net.html#t:ifaddrs_flag/0"},{"type":"type","title":"net.ifaddrs_flags/0","doc":"","ref":"net.html#t:ifaddrs_flags/0"},{"type":"type","title":"net.name_info/0","doc":"","ref":"net.html#t:name_info/0"},{"type":"type","title":"net.name_info_flag/0","doc":"","ref":"net.html#t:name_info_flag/0"},{"type":"type","title":"net.name_info_flag_ext/0","doc":"","ref":"net.html#t:name_info_flag_ext/0"},{"type":"type","title":"net.name_info_flags/0","doc":"","ref":"net.html#t:name_info_flags/0"},{"type":"type","title":"net.network_interface_index/0","doc":"","ref":"net.html#t:network_interface_index/0"},{"type":"type","title":"net.network_interface_name/0","doc":"","ref":"net.html#t:network_interface_name/0"},{"type":"module","title":"socket","doc":"Socket interface.\n\nThis module provides an API for network sockets. Functions are provided to\ncreate, delete and manipulate the sockets as well as sending and receiving data\non them.\n\nThe intent is that it shall be as \"close as possible\" to the OS level socket\ninterface. The only significant additions are that some of the functions, e.g.\n`recv/3`, have a time-out argument, and that [`recv/*`](`recv/1`) for a\n[`stream`](`t:type/0`) socket iterates until the requested amount of data\nhas been received.\n\n[](){: #asynchronous-calls }\n\n> #### Note {: .info }\n>\n> #### Asynchronous Calls\n>\n> Some functions feature _asynchronous calls_.  This is achieved by setting\n> the `Timeout` argument to `nowait` or to a `Handle ::` `t:reference/0`.\n> See the respective function's type specification.\n>\n> This module has two different implementations of asynchronous calls.\n> One on the _Unix_ family of operating systems:\n> `select` - based on the standard socket interface's\n> `select(3)`/`poll(3)` calls, and one on _Windows_: `completion` -\n> based on asynchronous I/O Completion Ports.\n> The difference shows in the return values and message formats\n> because they have slightly different semantics.\n>\n> #### The `completion` and `select` Return Values\n>\n> For instance, the call [`recv(Socket, 0, nowait)`](#recv-nowait),\n> when there is no data available for reading, will,\n> depending on the operating system, return one of:\n>\n> - `{completion, `[`CompletionInfo`](`t:completion_info/0`)`}`\n> - `{select, `[`SelectInfo`](`t:select_info/0`)`}`\n>\n> Where `CompletionInfo` is\n> `{completion_info, _, `[`CompletionHandle`](`t:completion_handle/0`)`}`\n> and `SelectInfo` is\n> `{select_info, _, `[`SelectHandle`](`t:select_handle/0`)`}`.\n> Both the `CompletionHandle` and the `SelectHandle`\n> are of type `t:reference/0`.\n>\n> When the operation can continue, a `completion` message containing\n> the `CompletionHandle` or a `select` message containing\n> the `SelectHandle` is sent to the calling process.\n>\n> On `select` systems, [`recv/2,3,4`](`recv/2`) may also return:\n>\n> - `{select, {`[`SelectInfo`](`t:select_info/0`)`, Data}`\n>\n> This may happen for sockets of type [`stream`](`t:type/0`)\n> when `Length > 1` since the OS may split a data stream at any point\n> and deliver just the first part of the requested data.\n> For the next [`recv/2,3,4`](`recv/2`) call; the `Length` to receive\n> will probably have to be adjusted due to the already delivered data\n> in this return value.\n>\n> On `select` systems, when the `{otp, select_read}` option is `true`,\n> the asynchronous [`recv/3,4`](#recv-nowait),\n> [`recvfrom/3,4`](#recvfrom-nowait), and\n> [`recvmsg/3,4,5`](#recvmsg-nowait) functions may also return:\n>\n> - `{select_read, {`[`SelectInfo`](`t:select_info/0`)`, Data}`\n>\n> This indicates that the receive operation was completed;\n> all requested data has been delivered,  and that the calling process\n> will get a `select` message when there is data available\n> for the next receive operation.\n>\n> #### The `completion` and `select` Messages [](){: #async-messages }\n>\n> The `completion` message has the format:\n>\n> - `{'$socket', `[`Socket`](`t:socket/0`)`, completion,\n>   {`[`CompletionHandle`](`t:completion_handle/0`)`, CompletionStatus}}`\n>\n> The `select` message has the format:\n>\n> - `{'$socket', `[`Socket`](`t:socket/0`)`, select,\n>   `[`SelectHandle`](`t:select_handle/0`)`}`\n>\n> When a `completion` message is received (which contains the _result_\n> of the operation), it means that the operation has been _completed_ and\n> `CompletionStatus` is the return value for the operation,\n> which is what the function that initiated the operation\n> could have returned, with the `nowait` argument,\n> except for the `completion` and `select` return values.\n>\n> When a `select` message is received, it only means that the operation\n> _may now continue_, by retrying the operation (which may return\n> a new `{select, _}` value).  Some operations are retried by repeating\n> the same function call, and some have a dedicated function variant\n> to be used for the retry.  See the respective function's documentation.\n>\n> #### Operation Queuing on `select` Systems\n>\n> On `select` systems, all other processes are _locked out_ until the\n> current process has completed the operation as in a continuation\n> call has returned a value indicating success or failure\n> (not a `select` or `select_read` return).  Other processes are queued\n> and get a `select` return which makes them wait for their turn.\n>\n> Note that receiving data from parallel processes is only suitable\n> for some protocols.  For a [`stream`](`t:type/0`) socket\n> it is in general a recipe for disaster.\n>\n> #### Cancelling an operation\n>\n> An operation that is in progress (not completed) may be canceled\n> using `cancel/2` both on `completion` and `select` systems.\n>\n> Cancelling an operation ensures that there is no `completion`,\n> `select`, nor `abort` message in the inbox after the `cancel/2` call.\n>\n> #### Using a `Handle`\n>\n> If creating a `t:reference/0` with [`make_ref()`](`erlang:make_ref/0`)\n> and using that as the `Timeout | Handle` argument, the same `Handle`\n> will then be the [`SelectHandle`](`t:select_handle/0`) in the returned\n> `t:select_info/0` and the received `select` message, or be\n> the [`CompletionHandle`](`t:completion_handle/0`) in the returned\n> `t:completion_info/0` and the received `completion` message.\n>\n> The compiler may then optimize a following `receive` statement\n> to only scan the messages that arrive after the `t:reference/0`\n> is created.  If the message queue is large this is a big optimization.\n>\n> It is not possible to have more than one operation in progress\n> with the same `t:reference/0`.\n>\n> #### Repeating an Operation on a `select` Systems\n>\n> On`select` systems, if a call would be repeated _before_ the `select`\n> message has been received it replaces the operation in progress:\n>\n> ```erlang\n>     {select, {select_info, Handle}} = socket:accept(LSock, nowait),\n>     {ok, Socket} = socket:accept(LSock, 1000),\n>     :\n> ```\n> Above, `Handle` is _no longer_ valid once the second `accept/2`, call\n> has been made (the first call is automatically canceled).\n> After the second `accept/2` call returns, the accept operation\n> has completed.\n>\n> Note that there is a race here; there is no way to know if the call\n> is repeated _before_ the `select` message is sent since it _may_\n> have been sent just before the repeated call.  So now there\n> might be a `select` message containing `Handle` in the inbox.\n>\n> #### The `abort` Message\n>\n> Another message the user must be prepared for\n> (when using `nowait | Handle`) is the `abort` message:\n>\n> - `{'$socket', `[`Socket`](`t:socket/0`)`, abort, Info}`\n>\n> This message indicates that the operation in progress has been aborted.\n> For instance, if the socket has been closed by another process;\n> `Info` will be `{Handle, closed}`.\n\n> #### Note {: .info }\n>\n> Support for IPv6 has been implemented but not _fully_ tested.\n>\n> SCTP has only been partly implemented (and not tested).\n\nThis module was introduced in OTP 22.0, as experimental code.\n* In OTP 22.1, the `nowait` argument was added for many functions,\n  and the `cancel/2` and `info/1` functions were also added.\n* In OTP 22.3, the `number_of/0` function was added.\n* In OTP 23.0, the functions [`is_supported/1,2`](`is_supported/1`)\n  and the [`open/1,2`](`open/1`) functions with an `FD` argument were added.\n* In OTP 23.1, the `use_registry/1` function was added.\n* In OTP 24.0, the `t:select_handle/0` argument was added for many functions,\n  the `cancel/1`, `cancel_monitor/1`, `getopt/3` with tuple options,\n  `getopt_native/3`, `info/0`, `monitor/1`, `open/3` with an option list,\n  many variants of the [`recv/*`](`recv/2`),\n  [`recvfrom/*`](`recvfrom/1`), [`recvmsg/*`](`recvmsg/1`),\n  [`send/*`](`send/2`), [`sendmsg/*`](`sendmsg/2`),\n  the [`sendto/*`](`sendto/3`) functions,\n  the [`sendfile/*`](`sendfile/5`) functions,\n  and the `setopt/3`, `setopt_native/3` functions, were added.\n* In OTP 24.1, the [`i/*`](`i/0`) functions were added.\n* In OTP 24.2, the [`ioctl/*`](`ioctl/2`) functions were added.\n* In OTP 26.0, the `t:completion_handle/0` argument was added for\n  many functions, and the `cancel/2` function with `t:completion_info/0`\n  argument was added.  That is: support for Windows asynchronous\n  I/O Completion Ports was added.  The Unix-ish flavored\n  ([select handle](`t:select_handle/0`)) API features could be considered\n  no longer experimental.\n* In OTP 27.0, the Windows flavored\n  ([completion handle](`t:completion_handle/0`))\n  API features could be considered no longer experimental.","ref":"socket.html"},{"type":"module","title":"Examples - socket","doc":"```erlang\nclient(SAddr, SPort) ->\n   {ok, Sock} = socket:open(inet, stream, tcp),\n   ok = socket:connect(Sock, #{family => inet,\n                               addr   => SAddr,\n                               port   => SPort}),\n   Msg = <<\"hello\">>,\n   ok = socket:send(Sock, Msg),\n   ok = socket:shutdown(Sock, write),\n   {ok, Msg} = socket:recv(Sock),\n   ok = socket:close(Sock).\n\nserver(Addr, Port) ->\n   {ok, LSock} = socket:open(inet, stream, tcp),\n   ok = socket:bind(LSock, #{family => inet,\n                             port   => Port,\n                             addr   => Addr}),\n   ok = socket:listen(LSock),\n   {ok, Sock} = socket:accept(LSock),\n   {ok, Msg} = socket:recv(Sock),\n   ok = socket:send(Sock, Msg),\n   ok = socket:close(Sock),\n   ok = socket:close(LSock).\n```","ref":"socket.html#module-examples"},{"type":"function","title":"socket.accept/1","doc":"Equivalent to [`accept(ListenSocket, infinity)`](`accept/2`).","ref":"socket.html#accept/1"},{"type":"function","title":"socket.accept/2","doc":"Accept a connection on a listening socket.\n\n`ListenSocket` has to be of a connection oriented type\n(types `stream` or `seqpacket`, see `open/1`), and set to listen\n(see `listen/1`).\n\n[](){: #accept-infinity }\n\nIf the `Timeout` argument is `infinity`; accepts the first pending\nincoming connection for the listen socket or wait for one to arrive,\nand return the new connection socket.\n\n[](){: #accept-timeout }\n\nIf the `Timeout` argument is a time-out value (`t:non_neg_integer/0`);\nreturns `{error, timeout}` if no connection has arrived\nafter `Timeout` milliseconds.\n\n[](){: #accept-nowait }\n\nIf the `Handle` argument `nowait` *(since OTP 22.1)*,\nstarts an [asynchronous call](#asynchronous-calls) if the operation\ncouldn't be completed immediately.\n\nIf the `Handle` argument is a `t:select_handle/0`,\n*(since OTP 24.0)*, or on _Windows_, the equivalent\n`t:completion_handle/0` *(since OTP 26.0)*, starts\nan [asynchronous call](#asynchronous-calls) like for `nowait`.\n\nSee the note [Asynchronous Calls](#asynchronous-calls)\nat the start of this module reference manual page.","ref":"socket.html#accept/2"},{"type":"function","title":"socket.bind/2","doc":"Bind a name to a socket.\n\nWhen a socket is created (with [`open`](`open/2`)), it has no address assigned\nto it. `bind` assigns the address specified by the `Addr` argument.\n\nThe rules used for name binding vary between domains.\n\nIf you bind a socket to an address in for example the `inet` or `inet6`\naddress families, with an ephemeral port number (`0`), and want to know\nwhich port that was chosen, you can find out using something like:\n`{ok, #{port := Port}} =`[`socket:sockname(Socket)`](`sockname/1`)","ref":"socket.html#bind/2"},{"type":"function","title":"socket.cancel/2","doc":"Cancel an asynchronous call in progress.\n\nCall this function to cancel an [asynchronous call](#asynchronous-calls)\nin progress, that is; it returned a value containing\na `t:completion_info/0` or `t:select_info/0`.\n\nSee the note [Asynchronous Calls](#asynchronous-calls)\nat the start of this module reference manual page.\n\nIf another process tries an operation of the same basic type\n(`accept/1` | `send/2` | `recv/2`) it will be enqueued and notified\nthrough a [`select` or `completion` message](#async-messages)\nwhen the current operation and all enqueued before it has been completed.\nIf the current operation is canceled by this function it is treated\nas a completed operation; the process first in queue is notified.\n\nIf [`SelectInfo`](`t:select_info/0`) `|`\n[`CompletionInfo`](`t:completion_info/0`) does not match\nan operation in progress for the calling process, this function returns\n`{error, {invalid, SelectInfo | CompletionInfo}}`.","ref":"socket.html#cancel/2"},{"type":"function","title":"socket.cancel_monitor/1","doc":"Cancel a socket monitor.\n\nIf `MRef` is a reference that the calling process obtained by calling\n`monitor/1`, this monitor is removed. If there is no such monitor\nfor the calling process (or MRef doesn't correspond to a monitor),\nnothing happens.\n\nThe returned value is one of the following:\n\n- **`true`** - The monitor was found and removed. In this case, no `'DOWN'`\n  message corresponding to this monitor has been delivered and will not be\n  delivered.\n\n- **`false`** - The monitor was not found so it couldn't be removed. This\n  might be because the monitor has already triggered and there is\n  a `'DOWN'` message from this monitor in the caller message queue.","ref":"socket.html#cancel_monitor/1"},{"type":"function","title":"socket.close/1","doc":"Close a socket.\n\n> #### Note {: .info }\n>\n> Note that for `Protocol = tcp` (see `open/3`), although\n> TCP guarantees that when the other side sees the stream close\n> all data that we sent before closing has been delivered,\n> there is no way for us to know that the other side got all data\n> and the stream close.  All kinds of network and OS issues\n> may obliterate that.\n>\n> To get such a guarantee we need to implement an in-band acknowledge\n> protocol on the connection, or we can use the [`shutdown`](`shutdown/2`)\n> function to signal that no more data will be sent and then wait\n> for the other end to close the socket.  Then we will see our read side\n> getting a socket close.  In this way we implement a small\n> acknowledge protocol using `shutdown/2`.  The other side cannot\n> know that we ever saw the socket close, but in a client/server\n> scenario that is often not relevant.","ref":"socket.html#close/1"},{"type":"type","title":"socket.cmsg/0","doc":"Control messages (ancillary messages).","ref":"socket.html#t:cmsg/0"},{"type":"type","title":"socket.cmsg_recv/0","doc":"Control messages (ancillary messages) returned by\n[`recvmsg/1,2,3,5`](`recvmsg/1`).\n\nA control message has got a `data` field with a native (`binary`) value for the\nmessage data, and may also have a decoded `value` field if this socket library\nsuccessfully decoded the data.","ref":"socket.html#t:cmsg_recv/0"},{"type":"type","title":"socket.cmsg_send/0","doc":"Control messages (ancillary messages) accepted by\n[`sendmsg/2,3,4`](`sendmsg/2`).\n\nA control message may for some message types have a `value` field with a\nsymbolic value, or a `data` field with a native value, that has to be binary\ncompatible what is defined in the platform's header files.","ref":"socket.html#t:cmsg_send/0"},{"type":"type","title":"socket.completion_handle/0","doc":"[Completion operation](#asynchronous-calls) handle.\n\nA `t:reference/0` that uniquely identifies the (completion) operation,\ncontained in the returned `t:completion_info/0`.","ref":"socket.html#t:completion_handle/0"},{"type":"type","title":"socket.completion_info/0","doc":"[Completion operation](#asynchronous-calls) info.\n\nReturned by an operation that requires the caller to wait for a\n[`completion` message](#async-messages) containing the\n[`CompletionHandle`](`t:completion_handle/0`) _and_ the result of the operation;\nthe `CompletionStatus`.","ref":"socket.html#t:completion_info/0"},{"type":"type","title":"socket.completion_tag/0","doc":"[Completion operation](#asynchronous-calls) tag.\n\n\nA tag that describes the ongoing (completion) operation (= function name),\ncontained in the returned `t:completion_info/0`.","ref":"socket.html#t:completion_tag/0"},{"type":"function","title":"socket.connect/1","doc":"Finalize a [`connect/3`](#connect-nowait) operation.\n\nSee the note [Asynchronous Calls](#asynchronous-calls)\nat the start of this module reference manual page.\n\nOn `select` systems this function finalizes a connection setup\non a socket, after receiving a [`select` message](#async-messages)\n`{'$socket',` [`Socket`](`t:socket/0`)`, select,\n`[`SelectHandle`](`t:select_handle/0`)`}`,\nand returns whether the connection setup was successful or not.\n\nInstead of calling this function, for backwards compatibility,\nit is allowed to call [`connect/2,3`](`connect/2`) again,\nbut that incurs more overhead since the connect address and\ntime-out argument are processed in vain.\n\nThe call that completes the connect operation, the second call,\ncannot return a `select` return value.","ref":"socket.html#connect/1"},{"type":"function","title":"socket.connect/2","doc":"Equivalent to\n[`connect(Socket, SockAddr, infinity)`](#connect-infinity).","ref":"socket.html#connect/2"},{"type":"function","title":"socket.connect/3","doc":"Connect the socket to the given address.\n\nThis function connects the socket to the address specified\nby the `SockAddr` argument.\n\nIf a connection attempt is already in progress (by another process),\n`{error, already}` is returned.\n\n> #### Note {: .info }\n>\n> On _Windows_ the socket has to be [_bound_](`bind/2`).\n\n[](){: #connect-infinity }\n\nIf the time-out argument (argument 3) is `infinity` it is\nup to the OS implementation to decide when the connection\nattempt failed and then what to return; probably `{error, etimedout}`.\nThe OS time-out may be very long.\n\n[](){: #connect-timeout }\n\nIf the time-out argument (argument 3) is a time-out value\n(`t:non_neg_integer/0`); return `{error, timeout}`\nif the connection hasn't been established within `Timeout` milliseconds.\n\n> #### Note {: .info }\n>\n> Note that when this call has returned `{error, timeout}`\n> the connection state of the socket is uncertain since the platform's\n> network stack may complete the connection at any time,\n> up to some platform specific time-out.\n>\n> Repeating a connection attempt towards the same address would be ok, but\n> towards a different address could end up with a connection to either address.\n>\n> The safe play is to close the socket and start over.\n>\n> Also note that this applies to cancelling a `nowait` connect call\n> described below.\n\n[](){: #connect-nowait }\n\nIf the time-out argument (argument 2) is `nowait` *(since OTP 22.1)*,\nstart an [asynchronous call](#asynchronous-calls) if the operation\ncouldn't be completed immediately.\n\nIf the time-out argument (argument 2) is a `Handle ::` `t:select_handle/0`,\n*(since OTP 24.0)*, or on _Windows_, the equivalent\n`Handle ::` `t:completion_handle/0` *(since OTP 26.0)*,\nstart an [asynchronous call](#asynchronous-calls) like for `nowait`.\n\nSee the note [Asynchronous Calls](#asynchronous-calls)\nat the start of this module reference manual page.\n\nAfter receiving a [`select` message](#async-messages); call `connect/1`\nto complete the operation.\n\nIf cancelling the operation with `cancel/2` see the note above\nabout [connection time-out](#connect-timeout).","ref":"socket.html#connect/3"},{"type":"type","title":"socket.domain/0","doc":"Protocol _domain_ a.k.a address _family_.\n\nA lowercase `t:atom/0` representing a protocol _domain_\non the platform named `AF_*` (or `PF_*`).  For example\n`inet` corresponds to `AF_INET`.\n\n[`is_supported(ipv6)` ](`is_supported/1`) tells if the IPv6 protocol,\nprotocol domain `inet6`, is supported.\n\n[`is_supported(local)` ](`is_supported/1`) tells if the\nprotocol domain `local` is supported.\n\n`supports/0` reports both values, but also many more, with a single call.","ref":"socket.html#t:domain/0"},{"type":"type","title":"socket.ee_origin/0","doc":"","ref":"socket.html#t:ee_origin/0"},{"type":"type","title":"socket.eei/0","doc":"Extended Error Information.\n\nA term containing additional (error) information\n_if_ the socket NIF has been configured to produce it.","ref":"socket.html#t:eei/0"},{"type":"type","title":"socket.extended_err/0","doc":"","ref":"socket.html#t:extended_err/0"},{"type":"function","title":"socket.getopt/2","doc":"Get the value of a socket option.\n\nGets the value of an OS protocol level socket option, or from\nthe `otp` pseudo protocol level, which is this module's\nimplementation level above the OS protocol levels.\n\nSee the type [otp_socket_option() ](`t:otp_socket_option/0`)\nfor a description of the `otp` protocol level.\n\nSee the type `t:socket_option/0` for which OS protocol level options\nthat this implementation knows about, how they are related to OS option names,\nand if there are known peculiarities with any of them.\n\nWhat options that are valid depends on the OS, and on the kind of socket\n(`t:domain/0`,`t:type/0` and `t:protocol/0`).  See the type\n`t:socket_option()` and the\n[socket options ](socket_usage.md#socket_options) chapter\nin the User's Guide for more info.\n\n> #### Note {: .info }\n>\n> Not all options are valid, nor possible to get, on all platforms. That is,\n> even if this `socket` implementation  support an option; it doesn't mean\n> that the underlying OS does.","ref":"socket.html#getopt/2"},{"type":"function","title":"socket.getopt/3","doc":"Get a socket option _(backwards compatibility function)_.\n\nEquivalent to [`getopt(Socket, {Level, Opt})`](`getopt/2`),\nor as a special case if\n`Opt = {NativeOpt :: `[`integer/0`](`t:integer/0`)`, ValueSpec}`\nequivalent to\n[`getopt_native(Socket, {Level, NativeOpt}, ValueSpec)`](`getopt_native/3`).\n\nUse `getopt/2` or `getopt_native/3` instead to handle\nthe option level and name as a single term, and to make the\ndifference between known options and native options clear.","ref":"socket.html#getopt/3"},{"type":"function","title":"socket.getopt_native/3","doc":"Get a \"native\" socket option.\n\nGets a socket option that may be unknown to our implementation, or that has a\ntype not compatible with our implementation, that is; in \"native mode\".\n\nThe socket option may be specified with an ordinary\n[`socket_option()` ](`t:socket_option/0`) tuple, with a known\n[`Level = level()` ](`t:level/0`) and an integer `NativeOpt`,\nor with both an integer `NativeLevel` and `NativeOpt`.\n\nHow to decode the option value has to be specified either with `ValueType`,\nby specifying the `ValueSize` for a `t:binary/0` that will contain the fetched\noption value, or by specifying a `t:binary/0` `ValueSpec` that will be copied\nto a buffer for the `getsockopt()` call to write the value in which will be\nreturned as a new `t:binary/0`.\n\nIf `ValueType` is `integer` a `C` type `(int)` will be fetched, if it is\n`boolean` a `C` type `(int)` will be fetched and converted into a `t:boolean/0`\naccording to the `C` implementation's notion about true and false.\n\nIf an option is valid depends both on the platform and on\nwhat kind of socket it is (`t:domain/0`, `t:type/0` and `t:protocol/0`).\n\nThe integer values for `NativeLevel` and `NativeOpt` as well as the `Value`\nencoding has to be deduced from the header files for the running system.","ref":"socket.html#getopt_native/3"},{"type":"type","title":"socket.hatype/0","doc":"","ref":"socket.html#t:hatype/0"},{"type":"function","title":"socket.i/0","doc":"Print information to the erlang shell in table format\nfor all sockets.\n\nThe information printed for each socket is specified by the default set\nof `t:info_keys/0` (all keys).\n\nThe sockets that are printed are all sockets created by this\n`socket` module's implementation.","ref":"socket.html#i/0"},{"type":"function","title":"socket.i/1","doc":"Print information to the erlang shell in table format\nfor all sockets.\n\nIf the argument is a list of `t:info_keys/0`, print the specified\ninformation for all sockets.  See `i/0`.\n\nOtherwise the same as `i/2` with the same first argument\nand the default information (see `i/0`).","ref":"socket.html#i/1"},{"type":"function","title":"socket.i/2","doc":"Print information to the erlang shell in table format\nfor a selection of sockets.\n\nThe argument [`InfoKeys`](`t:info_keys/0`) specifies which information\nis printed for each socket.\n\nIf the first argument is `Domain` print information for\nall sockets of that specific `t:domain/0`.\n\nIf the first argument is `Proto` print information for\nall sockets of that specific `t:protocol/0`.\n\nIf the first argument is `Type` print information for\nall sockets of that specific `t:type/0`.","ref":"socket.html#i/2"},{"type":"type","title":"socket.icmp_dest_unreach/0","doc":"","ref":"socket.html#t:icmp_dest_unreach/0"},{"type":"type","title":"socket.icmpv6_dest_unreach/0","doc":"","ref":"socket.html#t:icmpv6_dest_unreach/0"},{"type":"type","title":"socket.in6_addr/0","doc":"","ref":"socket.html#t:in6_addr/0"},{"type":"type","title":"socket.in6_flow_info/0","doc":"","ref":"socket.html#t:in6_flow_info/0"},{"type":"type","title":"socket.in6_scope_id/0","doc":"","ref":"socket.html#t:in6_scope_id/0"},{"type":"type","title":"socket.in_addr/0","doc":"","ref":"socket.html#t:in_addr/0"},{"type":"type","title":"socket.info/0","doc":"Platform dependent information items.\n\nThe value of `iov_max` is the value of the `IOV_MAX` constant\nin the system headers, which is the largest allowed I/O vector.\nSee also `sendmsg/4` regarding the `iov` key of `t:msg_send/0`.\nThe smallest allowed `IOV_MAX` value according to POSIX is `16`,\nbut check your platform documentation to be sure.\n\nAbout the `use_registry` key, see `use_registry/1`\nand the `t:otp_socket_option/0` with the same name.","ref":"socket.html#t:info/0"},{"type":"function","title":"socket.info/0","doc":"Get miscellaneous information about this `socket` library.\n\nThe function returns a map with each information item as a key-value pair.\n\n> #### Note {: .info }\n>\n> In order to ensure data integrity, mutexes are taken when needed.\n> So, don't call this function often.","ref":"socket.html#info/0"},{"type":"function","title":"socket.info/1","doc":"Get miscellaneous info about a socket.\n\nThe function returns a map with each information item as a key-value pair\nreflecting the \"current\" state of the socket.\n\n> #### Note {: .info }\n>\n> In order to ensure data integrity, mutexes are taken when needed.\n> So, don't call this function often.","ref":"socket.html#info/1"},{"type":"type","title":"socket.info_keys/0","doc":"Information element designators for the  `i/1` and `i/2` functions.","ref":"socket.html#t:info_keys/0"},{"type":"type","title":"socket.interface_type/0","doc":"The interface type (of the datalink). We only translate a few values to atoms,\nthe rest are left as (unsigned) integer values.","ref":"socket.html#t:interface_type/0"},{"type":"type","title":"socket.invalid/0","doc":"","ref":"socket.html#t:invalid/0"},{"type":"function","title":"socket.ioctl/2","doc":"Set socket (device) parameters.\n\nThis function retrieves a specific parameter, according to\nthe `GetRequest` argument.\n\n- **`gifconf`** - Get a list of interface (transport layer) addresses.\n\n  Result; a list of `t:map/0`s, one for each interface,\n  with its name and address.\n\n- **`nread`** - Get the number of bytes immediately available for reading\n  *(since OTP 26.1)*.\n\n  Result; the number of bytes, `t:integer/0`.\n\n- **`nwrite`** - Get the number of bytes in the send queue\n  *(since OTP 26.1)*.\n\n  Result; the number of bytes, `t:integer/0`.\n\n- **`nspace`** - Get the free space in the send queue\n  *(since OTP 26.1)*.\n\n  Result; the number of bytes, `t:integer/0`.\n\n- **`atmark`** - Test if there is OOB (out-of-bound) data waiting to be read\n  *(since OTP 26.1)*.\n\n  Result; a `t:boolean/0`.\n\n- **`tcp_info`** - Get miscellaneous TCP related information for a\n  _connected_ socket *(since OTP 26.1)*.\n\n  Result; a `t:map/0` with information items as key-value pairs.\n\n> #### Note {: .info }\n>\n> Not all requests are supported by all platforms.\n> To see if a ioctl request is supported on the current platform:\n>\n> ```erlang\n> \t    Request = nread,\n> \t    true = socket:is_supported(ioctl_requests, Request),\n> \t    :\n> ```","ref":"socket.html#ioctl/2"},{"type":"function","title":"socket.ioctl/3","doc":"Get or set socket (device) parameters.\n\n[](){: #ioctl-get }\n\nThis function retrieves a specific parameter, according to\none of the following `GetRequest` arguments. The third argument is\nthe (lookup) \"key\", identifying the interface, for most requests\nthe name of the interface as a `t:string/0`.\nAlso, see the note above.\n\n- **`gifname`** - Get the name of the interface with the specified index\n  (`t:integer/0`).\n\n  Result; the name of the interface, `t:string/0`.\n\n- **`gifindex`** - Get the index of the interface with the specified name.\n\n  Result; the interface index, `t:integer/0`.\n\n- **`gifaddr`** - Get the address of the interface with the specified name.\n\n  Result; the address of the interface, `t:sockaddr/0`.\n\n- **`gifdstaddr`** - Get the destination address of the point-to-point\n  interface with the specified name.\n\n  Result; the destination address of the interface, `t:sockaddr/0`.\n\n- **`gifbrdaddr`** - Get the broadcast address of the interface with the\n  specified name.\n\n  Result; broadcast address of the interface, `t:sockaddr/0`.\n\n- **`gifnetmask`** - Get the network mask of the interface with\n  the specified name.\n\n  Result; the network mask of the interface, `t:sockaddr/0`.\n\n- **`gifhwaddr` | `genaddr`** - Get the hardware address for the interface with the\n  specified name.\n\n  Result; the hardware address of the interface, `t:sockaddr/0` | `t:binary/0`.\n  The family field contains the 'ARPHRD' device type (or an integer).\n\n- **`gifmtu`** - Get the MTU (Maximum Transfer Unit) for the interface with the\n  specified name.\n\n  Result; MTU of the interface, `t:integer/0`.\n\n- **`giftxqlen`** - Get the transmit queue length of the interface with the\n  specified name.\n\n  Result; transmit queue length of the interface, `t:integer/0`.\n\n- **`gifflags`** - Get the active flag word of the interface\n  with the specified name.\n\n  Result; the active flag word of the interface, is a list of\n  `t:ioctl_device_flag/0` `|` `t:integer( )`.\n\n[](){: #ioctl-set }\n\nWith the following `SetRequest` argument this function sets\nthe `Value` for the request parameter *(since OTP 26.1)*.\n\n- **`rcvall`** - Enables (or disables) a socket to receive all IPv4 or IPv6\n  packages passing through a network interface.\n\n  The `Socket` has to be one of:\n\n  - **An IPv4 socket** - Created with the address\n    [domain `inet`](`t:domain/0`), socket [type `raw`](`t:type/0`)\n    and [protocol `ip`](`t:protocol/0`).\n\n  - **An IPv6 socket** - Created with the address\n    [domain `inet6`](`t:domain/0`), socket [type `raw`](`t:type/0`)\n    and [protocol `ipv6`](`t:protocol/0`).\n\n  The socket must also be bound to an (explicit) local IPv4 or IPv6 interface\n  (`any` isn't allowed).\n\n  Setting this IOCTL requires elevated privileges.\n\nWith the following `SetRequest` arguments this function sets\nthe `Value` for the request parameter *(since OTP 26.1)*.\n\n- **`rcvall_igmpmcall`** - Enables (or disables) a socket to receive IGMP\n  multicast IP traffic, _without_ receiving any other IP traffic.\n\n  The socket has to be created with the address\n  [domain `inet`](`t:domain/0`), socket [type `raw`](`t:type/0`)\n  and [protocol `igmp`](`t:protocol/0`).\n\n  The socket must also be bound to an (explicit) local interface\n  (`any` isn't allowed).\n\n  The receive buffer must be sufficiently large.\n\n  Setting this IOCTL requires elevated privileges.\n\n- **`rcvall_mcall`** - Enables (or disables) a socket to receive all multicast\n  IP traffic (as in; all IP packets destined for IP addresses in the range\n  224.0.0.0 to 239.255.255.255).\n\n  The socket has to be created with the address\n  [domain `inet`](`t:domain/0`), socket [type `raw`](`t:type/0`)\n  and [protocol `udp`](`t:protocol/0`).\n\n  The socket must also be bound to an (explicit) local interface\n  (`any` isn't allowed), And bound to port `0`.\n\n  The receive buffer must be sufficiently large.\n\n  Setting this IOCTL requires elevated privileges.","ref":"socket.html#ioctl/3"},{"type":"function","title":"socket.ioctl/4","doc":"Set socket (device) parameters.\n\nThis function sets a specific parameter, according to the `SetRequest`\nargument. The `Name` argument is the name of the interface,\nand the `Value` argument is the value to set.\n\nThese operations require elevated privileges.\n\n- **`sifflags`** - Set the the active flag word, `#{Flag => boolean()}`, of the\n  interface with the specified name.\n\n  Each flag to be changed should be added to the value `t:map/0`,\n  with the value `true` if the `Flag` should be set and `false`\n  if the flag should be cleared.\n\n- **`sifaddr`** - Set the address, `t:sockaddr/0`, of the interface with the\n  specified name.\n\n- **`sifdstaddr`** - Set the destination address, `t:sockaddr/0`, of a\n  point-to-point interface with the specified name.\n\n- **`sifbrdaddr`** - Set the broadcast address, `t:sockaddr/0`,\nof the interface with the specified name.\n\n- **`sifnetmask`** - Set the network mask, `t:sockaddr/0`, of the interface\n  with the specified name.\n\n- **`sifhwaddr`** - Set the hardware address, `t:sockaddr/0`,\nof the interface with the specified name.\n\n- **`sifmtu`** - Set the MTU (Maximum Transfer Unit), `t:integer/0`,\n  for the interface with the specified name.\n\n- **`siftxqlen`** - Set the transmit queue length, `t:integer/0`,\n  of the interface with the specified name.","ref":"socket.html#ioctl/4"},{"type":"type","title":"socket.ioctl_device_flag/0","doc":"","ref":"socket.html#t:ioctl_device_flag/0"},{"type":"type","title":"socket.ioctl_device_map/0","doc":"","ref":"socket.html#t:ioctl_device_map/0"},{"type":"type","title":"socket.ip_mreq/0","doc":"C: `struct ip_mreq`\n\nCorresponds to the C `struct ip_mreq` for managing multicast groups.","ref":"socket.html#t:ip_mreq/0"},{"type":"type","title":"socket.ip_mreq_source/0","doc":"C: `struct ip_mreq_source`\n\nCorresponds to the C `struct ip_mreq_source` for managing multicast groups.","ref":"socket.html#t:ip_mreq_source/0"},{"type":"type","title":"socket.ip_msfilter/0","doc":"C: `struct ip_msfilter`\n\nCorresponds to the C `struct ip_msfilter` for managing\nmulticast source filtering (RFC 3376).","ref":"socket.html#t:ip_msfilter/0"},{"type":"type","title":"socket.ip_pktinfo/0","doc":"C: `struct ip_pktinfo`","ref":"socket.html#t:ip_pktinfo/0"},{"type":"type","title":"socket.ip_pmtudisc/0","doc":"C: `IP_PMTUDISC_*` values.\n\nLowercase `t:atom/0` values corresponding to the C library constants\n`IP_PMTUDISC_*`. Some constant(s) may be unsupported by the platform.","ref":"socket.html#t:ip_pmtudisc/0"},{"type":"type","title":"socket.ip_tos/0","doc":"C: `IPTOS_*` values.\n\nLowercase `t:atom/0` values corresponding to the C library constants `IPTOS_*`.\nSome constant(s) may be unsupported by the platform.","ref":"socket.html#t:ip_tos/0"},{"type":"type","title":"socket.ipv6_hops/0","doc":"IPv6 hop limit value.\n\nThe value `default` is only valid to _set_ and is translated to the C value\n`-1`, meaning the route default.","ref":"socket.html#t:ipv6_hops/0"},{"type":"type","title":"socket.ipv6_mreq/0","doc":"C: `struct ipv6_mreq`\n\nCorresponds to the C `struct ipv6_mreq` for managing multicast groups. See also\nRFC 2553.","ref":"socket.html#t:ipv6_mreq/0"},{"type":"type","title":"socket.ipv6_pktinfo/0","doc":"C: `struct in6_pktinfo`","ref":"socket.html#t:ipv6_pktinfo/0"},{"type":"type","title":"socket.ipv6_pmtudisc/0","doc":"C: `IPV6_PMTUDISC_*` values\n\nLowercase `t:atom/0` values corresponding to the C library constants\n`IPV6_PMTUDISC_*`. Some constant(s) may be unsupported by the platform.","ref":"socket.html#t:ipv6_pmtudisc/0"},{"type":"function","title":"socket.is_supported/1","doc":"Check if a socket feature is supported.\n\nReturns `true` if `supports/0` has a `{Key1, true}` tuple\nor a `{Key1, list()}` tuple in its returned list,\notherwise `false` (also for unknown keys).\n\nExample:\n``` erlang\ntrue = socket:is_supported(local),\n```","ref":"socket.html#is_supported/1"},{"type":"function","title":"socket.is_supported/2","doc":"Check if a socket feature is supported.\n\nReturns `true` if [`supports(Key1)`](`supports/1`) has a `{Key2, true}` tuple\nin its returned list, otherwise `false` (also for unknown keys).\n\nExample:\n``` erlang\ntrue = socket:is_supported(msg_flags, errqueue),\n```","ref":"socket.html#is_supported/2"},{"type":"type","title":"socket.level/0","doc":"Protocol level.\n\nA lowercase `t:atom/0` OS protocol level, that is:\n`socket` or a `t:protocol/0` name.\n\n`socket` is the `SOL_SOCKET` protocol level in the OS header files,\nwith options named `SO_`\\* .","ref":"socket.html#t:level/0"},{"type":"type","title":"socket.linger/0","doc":"C: `struct linger`\n\nCorresponds to the C `struct linger` for managing the\n[socket option](`t:socket_option/0`) `{socket, linger}`.","ref":"socket.html#t:linger/0"},{"type":"function","title":"socket.listen/1","doc":"Make a socket listen for connections.\n\nEquivalent to [`listen(Socket, Backlog)`](`listen/2`) with a default\nvalue for `Backlog` (currently `5`).","ref":"socket.html#listen/1"},{"type":"function","title":"socket.listen/2","doc":"Make a socket listen for connections.\n\nThe `Backlog` argument states the length of the queue for\nincoming not yet accepted connections.\nExactly how that number is interpreted is up to the OS'\nprotocol stack, but the resulting effective queue length\nwill most probably be perceived as at least that long.\n\n> #### Note {: .info }\n>\n> On _Windows_ the socket has to be _bound_.","ref":"socket.html#listen/2"},{"type":"function","title":"socket.monitor/1","doc":"Start a socket monitor.\n\nIf the `Socket` doesn't exist or when later the monitor is triggered,\na `'DOWN'` message is sent to the process that called `monitor/1`\nwith the following pattern:\n\n``` erlang\n\t    {'DOWN', MonitorRef, socket, Socket, Info}\n```\n`Info` is the termination reason of the socket or `nosock` if\n`Socket` did not exist when the monitor was started.\n\nMaking several calls to `socket:monitor/1` for the same `Socket` is not an\nerror; each call creates an independent monitor instance.","ref":"socket.html#monitor/1"},{"type":"type","title":"socket.msg/0","doc":"C: `struct msghdr`","ref":"socket.html#t:msg/0"},{"type":"type","title":"socket.msg_flag/0","doc":"Platform dependent message flags.\n\nTranslates to/from message flag constants on the platform.\nThese flags are lowercase while the constants are uppercase\nwith prefix `MSG_`; for example `oob` translates to `MSG_OOB`.\n\nSome flags are only used for sending, some only for receiving, some in received\ncontrol messages, and some for several of these. Not all flags are supported on\nall platforms. See the platform's documentation,\n[`supports(msg_flags)`](`supports/1`), and\n[`is_supported(msg_flags, MsgFlag)`](`is_supported/2`).","ref":"socket.html#t:msg_flag/0"},{"type":"type","title":"socket.msg_recv/0","doc":"Message returned by [`recvmsg/1,2,3,5`](`recvmsg/1`).\n\nCorresponds to a C `struct msghdr`, see your platform documentation for\n[`recvmsg(2)`](`recvmsg/1`).\n\n- **`addr`** - Optional peer address, used on unconnected sockets. Corresponds\n  to `msg_name` and `msg_namelen` fields of a `struct msghdr`. If `NULL` the map\n  key is not present.\n\n- **`iov`** - Data as a list of binaries. The `msg_iov` and `msg_iovlen` fields\n  of a `struct msghdr`.\n\n- **`ctrl`** - A possibly empty list of control messages (CMSG). Corresponds to\n  the `msg_control` and `msg_controllen` fields of a `struct msghdr`.\n\n- **`flags`** - Message flags. Corresponds to the `msg_flags` field of a\n  `struct msghdr`. Unknown flags, if any, are returned in one `t:integer/0`,\n  last in the containing list.","ref":"socket.html#t:msg_recv/0"},{"type":"type","title":"socket.msg_send/0","doc":"Message sent by [`sendmsg/2,3,4`](`sendmsg/2`).\n\nCorresponds to a C `struct msghdr`, see your platform documentation for\n`sendmsg(2)`.\n\n- **`addr`** - Optional peer address, used on unconnected sockets. Corresponds\n  to `msg_name` and `msg_namelen` fields of a `struct msghdr`. If not used they\n  are set to `NULL`, `0`.\n\n- **`iov`** - Mandatory data as a list of binaries. The `msg_iov` and\n  `msg_iovlen` fields of a `struct msghdr`.\n\n- **`ctrl`** - Optional list of control messages (CMSG). Corresponds to the\n  `msg_control` and `msg_controllen` fields of a `struct msghdr`. If not used\n  they are set to `NULL`, `0`.\n\nThe `msg_flags` field of the `struct msghdr` is set to `0`.","ref":"socket.html#t:msg_send/0"},{"type":"type","title":"socket.native_value/0","doc":"","ref":"socket.html#t:native_value/0"},{"type":"function","title":"socket.number_of/0","doc":"Return the number of active sockets.","ref":"socket.html#number_of/0"},{"type":"function","title":"socket.open/1","doc":"Equivalent to [`open(FD, #{})`](`open/2`).","ref":"socket.html#open/1"},{"type":"function","title":"socket.open/2","doc":"Create a socket.\n\n#### With arguments `Domain` and `Type`\n\nEquivalent to [`open(Domain, Type, default, #{})`](`open/4`).\n\n#### With arguments `FD` and `Opts` *(since OTP 23.0)*\n\nCreates an endpoint for communication (socket) based on\nan already existing file descriptor that must be a socket.\nThis function attempts to retrieve the file descriptor's\n`domain`, `type` and `protocol` from the system.\nThis is however not possible on all platforms;\nin that case they should be specified in `Opts`.\n\nThe `Opts` argument can provide extra information:\n\n- **`domain`** - The file descriptor's communication domain. See also\n\n  [`open/2,3,4`](`open/3`).\n\n- **`type`** - The file descriptor's socket type.\n\n  See also [`open/2,3,4`](`open/3`).\n\n- **`protocol`** - The file descriptor's protocol. The atom `default` is\n  equivalent to the integer protocol number `0` which means the default\n  protocol for a given domain and type.\n\n  If the protocol can not be retrieved from the platform for the socket, and\n  `protocol` is not specified, the default protocol is used, which may\n  or may not be correct.\n\n  See also [`open/2,3,4`](`open/3`).\n\n- **`dup`** - If `false` don't duplicate the provided file descriptor.\n\n  Defaults to `true`; do duplicate the file descriptor.\n\n- **`debug`** - If `true` enable socket debug logging.\n\n  Defaults to `false`; don't enable socket debug logging.\n\n- **`use_registry`** - Enable or disable use of the socket registry\n  for this socket. This overrides the global setting.\n\n  Defaults to the global setting, see `use_registry/1`.\n\n> #### Note {: .info }\n>\n> This function should be used with care\\!\n>\n> On some platforms it is _necessary_ to provide `domain`, `type` and `protocol`\n> since they cannot be retrieved from the platform.\n>\n> On some platforms it is not easy to get hold of a file descriptor\n> to use in this function.","ref":"socket.html#open/2"},{"type":"function","title":"socket.open/3","doc":"Create a socket.\n\n#### With arguments `Domain`, `Type` and `Protocol`\n\nEquivalent to [`open(Domain, Type, Protocol, #{})`](`open/4`).\n\n#### With arguments `Domain`, `Type` and `Opts` *(since OTP 24.0)*\n\nEquivalent to [`open(Domain, Type, default, #{})`](`open/4`).","ref":"socket.html#open/3"},{"type":"function","title":"socket.open/4","doc":"Create a socket.\n\nCreates an endpoint for communication (socket).\n\n`Domain` and `Type` may be `t:integer/0`s, as defined in the platform's\nheader files. The same goes for `Protocol` as defined in the platform's\n`services(5)` database. See also the OS man page for the library call\n`socket(2)`.\n\n> #### Note {: .info }\n>\n> For some combinations of `Domain` and `Type` the platform has got\n> a default protocol that can be selected with `Protocol = default`,\n> and the platform may allow or require selecting the default protocol,\n> or a specific protocol.\n>\n> Examples:\n>\n> - **`socket:open(inet, stream, tcp)`** - It is common that for\n>   protocol domain and type `inet,stream` it is allowed to select\n>   the `tcp` protocol although that mostly is the default.\n> - **`socket:open(local, dgram)`** - It is common that for\n>   the protocol domain `local` it is mandatory to not select a protocol,\n>   that is; to select the default protocol.\n\nThe `Opts` argument is intended for \"other\" options.\nThe supported option(s) are described below:\n\n- **`netns: string()`** - Used to set the network namespace during the open\n  call. Only supported on Linux.\n\n- **`debug: boolean()`** - Enable or disable debug logging.\n\n  Defaults to `false`.\n\n- **`use_registry: boolean()`** - Enable or disable use of the socket registry\n  for this socket. This overrides the global value.\n\n  Defaults to the global value, see `use_registry/1`.","ref":"socket.html#open/4"},{"type":"type","title":"socket.otp_socket_option/0","doc":"Protocol level `otp` socket option.\n\nSocket options for the `otp` pseudo protocol level,\nthat is: `{otp, Name}` options.\n\nThis protocol level is the Erlang/OTP's socket implementation layer,\nhence above all OS protocol levels.\n\n- **`debug`** - `t:boolean/0` \\- Activate debug logging.\n\n- **`iow`** - `t:boolean/0` \\- Inform On Wrap of statistics counters.\n\n- **`controlling_process`** - `t:pid/0` \\- The socket \"owner\". Only the current\n  controlling process can set this option.\n\n- **`rcvbuf`** -\n  `BufSize :: (default | integer()>0) | {N :: integer()>0, BufSize :: (default | integer()>0)} `\\-\n  Receive buffer size.\n\n  The value `default` is only valid to _set_.\n\n  `N` specifies the number of read attempts to do in a tight loop before\n  assuming no more data is pending.\n\n  This is the allocation size for the receive buffer used when calling the OS\n  protocol stack's receive API, when no specific size (size 0) is requested.\n  When the receive function returns the receive buffer is reallocated to the\n  actually received size. If the data is copied or shrunk in place is up to\n  the allocator, and can to some extent be configured in the Erlang VM.\n\n  The similar socket option; `{socket,rcvbuf}` is a related option for the OS'\n  protocol stack that on Unix corresponds to `SOL_SOCKET,SO_RCVBUF`.\n\n- **`rcvctrlbuf`** - `BufSize :: (default | integer()>0) `\\- Allocation size for\n  the ancillary data buffer used when calling the OS protocol stack's receive\n  API.\n\n  The value `default` is only valid to _set_.\n\n- **`sndctrlbuf`** - `BufSize :: (default | integer()>0) `\\- Allocation size for\n  the ancillary data buffer used when calling the OS protocol stack's\n  [sendmsg](`sendmsg/2`) API.\n\n  The value `default` is only valid to _set_.\n\n  It is the user's responsibility to set a buffer size that has room for the\n  encoded ancillary data in the message to send.\n\n  See [sendmsg](`sendmsg/2`) and also the `ctrl` field of the `t:msg_send/0`\n  type.\n\n- **`select_read`** - `t:boolean/0` \\-\n  On `select` implementations, see [Asynchronous Calls](#asynchronous-calls),\n  automatically activate select after a completed read.\n\n  Instead of `{ok, Data}` the receive operation returns\n  [`{select_read, {SelectInfo, Data}}`](`t:select_info/0`),\n  and the calling process can wait for a [`select` message](#async-messages)\n  containing `SelectInfo` when there is data available again.\n\n  Setting this option locks out other processes from receiving any data\n  since the current process continues its operation, so it effectively\n  disables receive operation queuing.\n\n- **`fd`** - `t:integer/0` \\- Only valid to _get_. The OS protocol levels'\n  socket descriptor. Functions [`open/1,2`](`open/1`) can be used to create a\n  socket according to this module from an existing OS socket descriptor.\n\n- **`use_registry`** - `t:boolean/0` \\- Only valid to _get_. The value is set\n  when the socket is created with `open/2` or `open/4`.\n\nOptions not described here are intentionally undocumented and for Erlang/OTP\ninternal use only.","ref":"socket.html#t:otp_socket_option/0"},{"type":"type","title":"socket.packet_type/0","doc":"","ref":"socket.html#t:packet_type/0"},{"type":"function","title":"socket.peername/1","doc":"Return the remote address of a socket.\n\nReturns the address of the connected peer, that is,\nthe remote end of the socket.","ref":"socket.html#peername/1"},{"type":"type","title":"socket.port_number/0","doc":"","ref":"socket.html#t:port_number/0"},{"type":"type","title":"socket.posix/0","doc":"Posix error codes.\n\nLocal alias for `t:inet:posix/0`, a set of `t:atom/0`s.","ref":"socket.html#t:posix/0"},{"type":"type","title":"socket.protocol/0","doc":"Protocol name.\n\nA lowercase `t:atom/0` representing an OS protocol name.\nTo be used for example in `t:socket_option/0`\nin [control messages](`t:cmsg/0`).\n\nThey have the following names in the OS header files:\n\n- **`ip`** - `IPPROTO_IP` a.k.a `SOL_IP` with options named `IP_`\\*.\n\n- **`ipv6`** - `IPPROTO_IPV6` a.k.a `SOL_IPV6` with options named `IPV6_`\\*.\n\n- **`tcp`** - `IPPROTO_TCP` with options named `TCP_`\\*.\n\n- **`udp`** - `IPPROTO_UDP` with options named `UDP_`\\*.\n\n- **`sctp`** - `IPPROTO_SCTP` with options named `SCTP_`\\*.\n\nThere are many other possible protocols, but the ones above are those for which\nthis socket library implements socket options and/or control messages.\n\nAll protocols known to the OS are enumerated when the Erlang VM is started,\nthrough the `C` library call `getprotoent()`. See the OS man page for\nprotocols(5). Those in the list above are valid if supported by the platform,\neven if they aren't enumerated.\n\nThe calls [`is_supported(ipv6)` ](`is_supported/1`)\nand [`is_supported(sctp)` ](`is_supported/1`) can be used to find out\nif the protocols `ipv6` and `sctp` are supported on the platform\nas in appropriate header file and library exists.\n\nThe call [`is_supported(protocols, Protocol)` ](`is_supported/2`)\ncan only be used to find out if the platform knows the protocol number\nfor a named `Protocol`.\n\nSee [`open/2,3,4`](`open/3`)","ref":"socket.html#t:protocol/0"},{"type":"function","title":"socket.recv/1","doc":"Equivalent to [`recv(Socket, 0, [], infinity)`](`recv/4`).","ref":"socket.html#recv/1"},{"type":"function","title":"socket.recv/2","doc":"Receive data on a connected socket.\n\nWith argument `Length`; equivalent to\n[`recv(Socket, Length, [], infinity)`](`recv/4`).\n\nWith argument `Flags`; equivalent to\n[`recv(Socket, 0, Flags, infinity)`](`recv/4`) *(since OTP 24.0)*.","ref":"socket.html#recv/2"},{"type":"function","title":"socket.recv/3","doc":"Receive data on a connected socket.\n\nWith arguments `Length` and `Flags`; equivalent to\n[`recv(Socket, Length, Flags, infinity)`](`recv/4`).\n\nWith arguments `Length` and `TimeoutOrHandle`; equivalent to\n[`recv(Socket, Length, [], TimeoutOrHandle)`](`recv/4`).\n`TimeoutOrHandle :: nowait` has been allowed *since OTP 22.1*.\n`TimeoutOrHandle :: Handle` has been allowed *since OTP 24.0*.\n\nWith arguments `Flags` and `TimeoutOrHandle`; equivalent to\n[`recv(Socket, 0, Flags, TimeoutOrHandle)`](`recv/4`)\n*(since OTP 24.0)*.","ref":"socket.html#recv/3"},{"type":"function","title":"socket.recv/4","doc":"Receive data on a connected socket.\n\nThe argument `Length` specifies the size of the receive buffer.\nPacket oriented sockets truncate the packet if the size is too small.\n\nIf `Length == 0`; a default buffer size is used, which can be set by\n[`socket:setopt(Socket, {otp,recvbuf}, BufSz)`](`setopt/3`).\n\nFor a socket of [type `stream`](`t:type/0`), when a `Timeout` argument\nis used, the operation iterates until `Length` bytes has been received,\nor the operation times out.  If `Length == 0` all readily available\ndata is returned.\n\nOn a `select` system, when the default receive buffer size option\n[`{otp,recvbuf}`](`t:otp_socket_option/0`) special value `{N,BufSize}`\nis used, `N` limits how many `BufSize` buffers that may be received\nin a tight loop before the receive operation returns.  The option value\n`{1,BufSize}` is equivalent to just specifying a size value `BufSize`.\n\nThe message `Flags` may be symbolic `t:msg_flag/0`s and/or\n`t:integer/0`s as in the platform's appropriate header files.\nThe values of all symbolic flags and integers are or:ed together.\n\nWhen there is a socket error this function returns `{error, Reason}`,\nor if some data arrived before the error; `{error, {Reason, Data}}`\n(can only happen for a socket of [type `stream`](`t:type/0`)).\n\n[](){: #recv-infinity }\n\nIf the `Timeout` argument is `infinity`; waits for the data to arrive.\nFor a socket of [type `stream`](`t:type/0`) this call\nwon't return until _all_ requested data can be delivered,\nor if \"all available\" was requested when the first data chunk arrives,\nor if the OS reports an error for the operation.\n\n[](){: #recv-timeout }\n\nIf the `Timeout` argument is a time-out value\n(`t:non_neg_integer/0`); return `{error, timeout}`\nif no data has arrived after `Timeout` milliseconds,\nor `{error, {timeout, Data}}` if some but not enough data\nhas been received on a socket of [type `stream`](`t:type/0`) with Length > 0.\nIt *can* also return directly with `{ok, Data}` ([type `dgram`](`t:type/0`)).\n\n`Timeout = 0` only polls the OS receive call and doesn't\nengage the Asynchronous Calls mechanisms.  If no data\nis immediately available `{error, timeout} is returned.\n`On a socket of type [`stream`](`t:type/0`), `{error, {timeout, Data}}`\nis returned if there is an insufficient amount of data immediately available.\n\n[](){: #recv-nowait }\n\nIf the `Handle` argument is `nowait` *(since OTP 22.1)*,\nstarts an [asynchronous call](#asynchronous-calls) if the operation\ncouldn't be completed immediately.\n\nIf the `Handle` argument is a `t:select_handle/0`,\n*(since OTP 24.0)*, or on _Windows_, the equivalent\n`t:completion_handle/0` *(since OTP 26.0)*, starts\nan [asynchronous call](#asynchronous-calls) like for `nowait`.\n\nSee the note [Asynchronous Calls](#asynchronous-calls)\nat the start of this module reference manual page.\n\nOn `select` systems, for a socket of type [`stream`](`t:type/0`),\nif `Length > 0` and there is some but not enough data available,\nthis function will return [`{select, {SelectInfo, Data}}`](`t:select_info/0`)\nwith partial `Data`.  A repeated call to complete the operation\nmay need an updated `Length` argument.\n\nOn `select` systems, if the option\n[`{otp, select_read}`](`t:otp_socket_option/0`) is set,\n[`{select_read, {SelectInfo, Data}}`](`t:select_info/0`)\nis returned instead of `{ok, Data}` and a new asynchronous\nreceive operation has been initiated, which can be seen\nas an automatic [nowait](#recv-nowait) call whenever\na receive operation is completed.","ref":"socket.html#recv/4"},{"type":"function","title":"socket.recvfrom/1","doc":"Equivalent to [`recvfrom(Socket, 0, [], infinity)`](`recvfrom/4`).","ref":"socket.html#recvfrom/1"},{"type":"function","title":"socket.recvfrom/2","doc":"Receive a message on a socket.\n\nWith argument `BufSz`; equivalent to\n[`recvfrom(Socket, BufSz, [], infinity)`](`recvfrom/4`).\n\nWith argument `Flags`; equivalent to\n[`recvfrom(Socket, 0, Flags, infinity)`](`recvfrom/4`) *(since OTP 24.0)*.","ref":"socket.html#recvfrom/2"},{"type":"function","title":"socket.recvfrom/3","doc":"Receive a message on a socket.\n\nWith arguments `BufSz` and `Flags`; equivalent to\n[`recvfrom(Socket, BufSz, Flags, infinity)`](`recvfrom/4`).\n\nWith arguments `BufSz` and `TimeoutOrHandle`; equivalent to\n[`recvfrom(Socket, BufSz, [], TimeoutOrHandle)`](`recvfrom/4`).\n\nWith arguments `Flags` and `TimeoutOrHandle`; equivalent to\n[`recvfrom(Socket, 0, Flags, TimeoutOrHandle)`](`recvfrom/4`)\n\n`TimeoutOrHandle :: 'nowait'` has been allowed *since OTP 22.1*.\n\n`TimeoutOrHandle :: Handle` has been allowed *since OTP 24.0*.","ref":"socket.html#recvfrom/3"},{"type":"function","title":"socket.recvfrom/4","doc":"Receive a message on a socket.\n\nThis function is intended primarily for sockets that are not connection\noriented such as type [`dgram`](`t:type/0`) or [`seqpacket`](`t:type/0`)\nwhere messages may arrive from different source addresses.\n\nArgument `BufSz` specifies the number of bytes for the receive buffer.\nIf the buffer size is too small, the message will be truncated.\n\nIf `BufSz` is `0`, a default buffer size is used, which can be set by\n[`socket:setopt(Socket, {otp,recvbuf}, BufSz)`](`setopt/3`).\n\nIf there is no known appropriate buffer size, it may be possible\nto use the receive [message flag](`t:msg_flag/0`) `peek`.\nWhen this flag is used, the message is _not_ \"consumed\" from\nthe underlying buffers, so another `recvfrom/1,2,3,4` call\nis needed, possibly with an adjusted buffer size.\n\nThe message `Flags` may be symbolic `t:msg_flag/0`s and/or\n`t:integer/0`s, as in the platform's appropriate header files.\nThe values of all symbolic flags and integers are or:ed together.\n\n[](){: #recvfrom-infinity }\n\nIf the `Timeout` argument is `infinity`; waits for a message\nto arrive, or for a socket error.\n\n[](){: #recvfrom-timeout }\n\nIf the `Timeout` argument is a time-out value\n(`t:non_neg_integer/0`); returns `{error, timeout}`\nif no message has arrived after `Timeout` milliseconds.\n\n`Timeout = 0` only polls the OS receive call and doesn't\nengage the Asynchronous Calls mechanisms.  If no message\nis immediately available `{error, timeout}` is returned.\n\n[](){: #recvfrom-nowait }\n\nIf the `Handle` argument is `nowait` *(since OTP 22.1)*,\nstarts an [asynchronous call](#asynchronous-calls) if the operation\ncouldn't be completed immediately.\n\nIf the 'Handle' argument is a `t:select_handle/0`,\n*(since OTP 24.0)*, or on _Windows_, the equivalent\n`t:completion_handle/0` *(since OTP 26.0)*,\nstarts an [asynchronous call](#asynchronous-calls) like for `nowait`.\n\nSee the note [Asynchronous Calls](#asynchronous-calls)\nat the start of this module reference manual page.","ref":"socket.html#recvfrom/4"},{"type":"function","title":"socket.recvmsg/1","doc":"Equivalent to [`recvmsg(Socket, 0, 0, [], infinity)`](`recvmsg/5`).","ref":"socket.html#recvmsg/1"},{"type":"function","title":"socket.recvmsg/2","doc":"Receive a message on a socket.\n\nWith argument `Flags`; equivalent to\n[`recvmsg(Socket, 0, 0, Flags, infinity)`](`recvmsg/5`).\n\nWith argument `TimeoutOrHandle`; equivalent to\n[`recvmsg(Socket, 0, 0, [], TimeoutOrHandle)`](`recvmsg/5`).\n\n`TimeoutOrHandle :: nowait` has been allowed *since OTP 22.1*.\n\n`TimeoutOrHandle :: Handle` has been allowed *since OTP 24.0*.","ref":"socket.html#recvmsg/2"},{"type":"function","title":"socket.recvmsg/3","doc":"Receive a message on a socket.\n\nWith arguments  `Flags`; equivalent to\n[`recvmsg(Socket, 0, 0, Flags, infinity)`](`recvmsg/5`).\n\nWith argument `TimeoutOrHandle`; equivalent to\n[`recvmsg(Socket, 0, 0, [], TimeoutOrHandle)`](`recvmsg/5`).\n\n`TimeoutOrHandle :: nowait` has been allowed *since OTP 22.1*.\n\n`TimeoutOrHandle :: Handle` has been allowed *since OTP 24.0*.","ref":"socket.html#recvmsg/3"},{"type":"function","title":"socket.recvmsg/4","doc":"Equivalent to\n[`recvmsg(Socket, BufSz, CtrlSz, [], TimeoutOrHandle)`](`recvmsg/5`).","ref":"socket.html#recvmsg/4"},{"type":"function","title":"socket.recvmsg/5","doc":"Receive a message on a socket.\n\nThis function receives a data message with control messages\nas well as its source address.\n\nArguments `BufSz` and `CtrlSz` specifies the number of bytes for the\nreceive buffer and the control message buffer. If the buffer size(s)\nis(are) too small, the message and/or control message list will be truncated.\n\nIf `BufSz` is `0`, a default buffer size is used, which can be set by\n[`socket:setopt(Socket, {otp,recvbuf}, BufSz)`](`setopt/3`).\nThe same applies to `CtrlSz` and\n[`socket:setopt(Socket, {otp,recvctrlbuf}, CtrlSz)`](`setopt/3`).\n\nIf there is no known appropriate buffer size, it may be possible\nto use the receive [message flag](`t:msg_flag/0`) `peek`.\nWhen this flag is used, the message is _not_ \"consumed\" from\nthe underlying buffers, so another `recvfrom/1,2,3,4` call\nis needed, possibly with an adjusted buffer size.\n\nThe message `Flags` may be symbolic `t:msg_flag/0`s and/or\n`t:integer/0`s, as in the platform's appropriate header files.\nThe values of all symbolic flags and integers are or:ed together.\n\n[](){: #recvmsg-infinity }\n\nIf the `Timeout` argument is `infinity`; waits for the message\nto arrive, or for a socket error.\n\n[](){: #recvmsg-timeout }\n\nIf the `Timeout` argument is a time-out value\n(`t:non_neg_integer/0`); return `{error, timeout}`\nif no message has arrived after `Timeout` milliseconds.\n\n`Timeout = 0` only polls the OS receive call and doesn't\nengage the Asynchronous Calls mechanisms.  If no message\nis immediately available `{error, timeout}` is returned.\n\n[](){: #recvmsg-nowait }\n\nIf the `Handle` argument is `nowait` *(since OTP 22.1)*,\nstarts an [asynchronous call](#asynchronous-calls) if the operation\ncouldn't be completed immediately.\n\nIf the 'Handle' argument is a `t:select_handle/0`,\n*(since OTP 24.0)*, or on _Windows_, the equivalent\n`t:completion_handle/0` *(since OTP 26.0)*,\nstarts an [asynchronous call](#asynchronous-calls) like for `nowait`.\n\nSee the note [Asynchronous Calls](#asynchronous-calls)\nat the start of this module reference manual page.","ref":"socket.html#recvmsg/5"},{"type":"type","title":"socket.sctp_assocparams/0","doc":"C: `struct sctp_assocparams`","ref":"socket.html#t:sctp_assocparams/0"},{"type":"type","title":"socket.sctp_event_subscribe/0","doc":"C: `struct sctp_event_subscribe`.\n\nNot all fields are implemented on all platforms; unimplemented fields are\nignored, but implemented fields are mandatory. Note that the '\\_event' suffixes\nhave been stripped from the C struct field names, for convenience.","ref":"socket.html#t:sctp_event_subscribe/0"},{"type":"type","title":"socket.sctp_initmsg/0","doc":"C: `struct sctp_initmsg`.","ref":"socket.html#t:sctp_initmsg/0"},{"type":"type","title":"socket.sctp_rtoinfo/0","doc":"C: `struct sctp_rtoinfo`.","ref":"socket.html#t:sctp_rtoinfo/0"},{"type":"type","title":"socket.select_handle/0","doc":"[Select operation](#asynchronous-calls) handle.\n\nA `t:reference/0` that uniquely identifies the (select) operation,\ncontained in the returned `t:select_info/0`.","ref":"socket.html#t:select_handle/0"},{"type":"type","title":"socket.select_info/0","doc":"[Select operation](#asynchronous-calls) info.\n\nReturned by an operation that requires the caller to wait for a\n[`select` message](#async-messages) containing the\n[`SelectHandle`](`t:select_handle/0`).\n\nOn `select` systems, if the option\n[`{otp, select_read}`](`t:otp_socket_option/0`) is set,\n[`{select_read, {select_info(), _}}`](`t:select_info/0`)\nis returned instead of `{ok, _}` to indicate that a new\nasynchronous receive operation has been initiated\nand the caller should wait for a\n[`select` message](#async-messages) containing the\n[`SelectHandle`](`t:select_handle/0`).","ref":"socket.html#t:select_info/0"},{"type":"type","title":"socket.select_tag/0","doc":"[Select operation](#asynchronous-calls) tag.\n\nA tag that describes the (select) operation (= function name),\ncontained in the returned `t:select_info/0`.","ref":"socket.html#t:select_tag/0"},{"type":"function","title":"socket.send/2","doc":"Equivalent to [`send(Socket, Data, [], infinity)`](`send/4`).","ref":"socket.html#send/2"},{"type":"function","title":"socket.send/3","doc":"Send data on a connected socket.\n\nWith argument `Timeout`; equivalent to\n[`send(Socket, Data, [], Timeout)`](`send/4`).\n\nWith argument `Flags`; equivalent to\n[`send(Socket, Data, Flags, infinity)`](`send/4`).\n\nWith argument `Cont`; equivalent to\n[`send(Socket, Data, Cont, infinity)`](`send/4`) *(since OTP 24.0)*.","ref":"socket.html#send/3"},{"type":"function","title":"socket.send/4","doc":"Send data on a connected socket.\n\nThe message `Flags` may be symbolic `t:msg_flag/0`s and/or\n`t:integer/0`s as in the platform's appropriate header files.\nThe values of all symbolic flags and integers are or:ed together.\n\nThe `Data`, if it is not a `t:binary/0`, is copied into one before\ncalling the platform network API, because a single buffer is required.\nA returned `RestData` is a sub binary of it.\n\nThe return value indicates the result from the platform's network layer:\n\n- **`ok`** - All data was accepted by the OS for delivery\n\n- **`{ok, RestData}`** - Some but not all data was accepted,\n  but no error was reported (partially successful send).  `RestData`\n  is the tail of `Data` that wasn't accepted.\n\n  This cannot happen for a socket of [type `stream`](`t:type/0`) where\n  such a partially successful send is retried until the data is either\n  accepted for delivery or there is an error.\n\n  For a socket of [type `dgram`](`t:type/0`) this should probably\n  also not happen since a message that cannot be passed atomically\n  should render an error.\n\n  It is nevertheless possible for the platform's network layer\n  to return this,  surely more possible for a socket of\n  [type `seqpacket`](`t:type/0`).\n\n- **`{error, Reason}`** - An error has been reported and no data\n  was accepted for delivery.  [`Reason :: posix/0`](`t:posix/0`)\n  is what the platform's network layer reported.  `closed` means\n  that this socket library was informed that the socket was closed,\n  and `t:invalid/0` means that this socket library found\n  an argument to be invalid.\n\n- **`{error, {Reason, RestData}}`** - An error was reported but before that\n  some data was accepted for delivery. `RestData` is the tail of `Data`\n  that wasn't accepted. See `{error, Reason}` above.\n\n  This can only happen for a socket of [type `stream`](`t:type/0`)\n  when a partially successful send is retried until there is an error.\n\n[](){: #send-infinity }\n\nIf the `Timeout` argument is `infinity`; wait for the OS to\ncomplete the send operation (take responsibility for the data),\nor return an error.\n\n[](){: #send-timeout }\n\nIf the `Timeout` argument is a time-out value\n(`t:non_neg_integer/0`); return `{error, timeout}`\nif no data has been sent within `Timeout` millisecond,\nor `{error, {timeout, RestData}}` if some data was sent\n(accepted by the OS for delivery).  `RestData` is the tail of the data\nthat hasn't been sent.\n\n[](){: #send-nowait }\n\nIf the `Handle` argument is `nowait` *(since OTP 22.1)*,\nstarts an [asynchronous call](#asynchronous-calls) if the operation\ncouldn't be completed immediately.\n\nIf the `Handle` argument is a `t:select_handle/0`,\n*(since OTP 24.0)*, or on _Windows_, the equivalent\n`t:completion_handle/0` *(since OTP 26.0)*, starts\nan [asynchronous call](#asynchronous-calls) like for `nowait`.\n\nSee the note [Asynchronous Calls](#asynchronous-calls)\nat the start of this module reference manual page.\n\n[](){: #send-cont }\n\nIf the function is called with a `Cont` argument, that is;\nthe [`SelectInfo`](`t:select_info/0`) from the previous\n[`send/3,4`](`send/3`) call; the send is continued with\npreprocessed send parameters in the `SelectInfo`.\nUsing this argument variant avoids for example having to validate\nand encode message flags in every call but the first.","ref":"socket.html#send/4"},{"type":"function","title":"socket.sendfile/2","doc":"Send a file on a socket.\n\nEquivalent to\n[`sendfile(Socket, FileHandle_or_Continuation, 0, 0, infinity)`](`sendfile/5`).","ref":"socket.html#sendfile/2"},{"type":"function","title":"socket.sendfile/3","doc":"Send a file on a socket.\n\nEquivalent to\n[`sendfile(Socket, FileHandle_or_Continuation, 0, 0, Timeout_or_Handle)`](`sendfile/5`).","ref":"socket.html#sendfile/3"},{"type":"function","title":"socket.sendfile/4","doc":"Send a file on a socket.\n\nEquivalent to\n[`sendfile(Socket, FileHandle_or_Continuation, Offset, Count, infinity)`](`sendfile/5`).","ref":"socket.html#sendfile/4"},{"type":"function","title":"socket.sendfile/5","doc":"Send a file on a socket.\n\n> #### Note {: .info }\n> This function unsupported on Windows.\n\nThe `FileHandle` argument must refer to an open raw file\nas described in `file:open/2`.\n\nThe `Offset` argument is the file offset to start reading from.\nThe default offset is `0`.\n\nThe `Count` argument is the number of bytes to transfer\nfrom `FileHandle` to `Socket`. If `Count = 0` (the default)\nthe transfer stops at the end of file.\n\nThe return value indicates the result from the platform's network layer:\n\n- **`{ok, BytesSent}`** - The transfer completed successfully after `BytesSent`\n  bytes of data.\n\n- **`{error, Reason}`** - An error has been reported and no data\n  was transferred. [`Reason :: posix/0`](`t:posix/0`)\n  is what the platform's network layer reported.  `closed` means\n  that this socket library was informed that the socket was closed,\n  and `t:invalid/0` means that this socket library found\n  an argument to be invalid.\n\n- **`{error, {Reason, BytesSent}}`** - An error has been reported\n  but before that some data was transferred. See `{error, Reason}`\n  and `{ok, BytesSent}` above.\n\n[](){: #sendfile-infinity }\n\nIf the `Timeout` argument is `infinity`; wait for the OS to\ncomplete the send operation (take responsibility for the data),\nor return an error.\n\n[](){: #sendfile-timeout }\n\nIf the `Timeout` argument is a time-out value\n(`t:non_neg_integer/0`); return `{error, timeout}`\nif no data has been sent within `Timeout` millisecond,\nor `{error, {timeout, BytesSent}}` if some but not all data was sent\n(accepted by the OS for delivery).\n\n[](){: #sendfile-nowait }\n\nIf the `Handle` argument is `nowait`,\nstarts an [asynchronous call](#asynchronous-calls) if the operation\ncouldn't be completed immediately.\n\nIf the `Handle` argument is a `t:select_handle/0`, starts\nan [asynchronous call](#asynchronous-calls) like for `nowait`.\n\nSee the note [Asynchronous Calls](#asynchronous-calls)\nat the start of this module reference manual page.\n\nAfter receiving a [`select` message](#async-messages);\ncall [`sendfile/2,3,4,5`](`sendfile/2`)\nwith `SelectInfo` as the `Continuation` argument,\nto complete the operation.\n\n[](){: #sendfile-cont }\n\nIf the function is called with a `Continuation` argument, that is;\nthe [`SelectInfo`](`t:select_info/0`) from the previous\n`sendfile/5` call; the transfer is continued with\npreprocessed parameters in the `SelectInfo`.\n\nThe `Offset` and maybe `Count` arguments will probably\nneed to be updated between continuation calls.","ref":"socket.html#sendfile/5"},{"type":"function","title":"socket.sendmsg/2","doc":"Equivalent to [`sendmsg(Socket, Msg, [], infinity)`](`sendmsg/4`).","ref":"socket.html#sendmsg/2"},{"type":"function","title":"socket.sendmsg/3","doc":"Send data and control messages on a socket.\n\nWith arguments `Msg` and `Timeout`; equivalent to\n[`sendmsg(Socket, Msg, [], Timeout)`](`sendmsg/4`).\n\nWith arguments `Msg` and `Flags`; equivalent to\n[`sendmsg(Socket, Msg, Flags, infinity)`](`sendmsg/4`).\n\nWith arguments `Data` and `Cont`; equivalent to\n[`sendmsg(Socket, Data, Cont, infinity)`](`sendmsg/4`) *since OTP 24.0*.","ref":"socket.html#sendmsg/3"},{"type":"function","title":"socket.sendmsg/4","doc":"Send data and control messages on a socket.\n\nThe argument `Msg` is a map that contains the data to be sent\nunder the key `iov` as an`t:erlang:iovec/0` (list of `t:binary/0`).\nIt may also contain the destination address under the key `addr`,\nwhich is mandatory if the socket isn't connected.  If the socket\n_is_ connected it is best to not have an `addr` key since\nthe platform may regard that as an error (or ignore it).\nUnder the key `ctrl` there may be a list of protocol and platform dependent\ncontrol messages (a.k.a ancillary data, a.k.a control information)\nto send.\n\n[](){: #sendmsg-iov }\n\nThe message data is given to the platform's network layer as an\nI/O vector without copying the content. If the number of elements\nin the I/O vector is larger than allowed on the platform (reported\nin the [`iov_max`](`t:info/0`) field from `info/0`), on a socket of\n[type `stream`](`t:type/0`) the send is iterated over all elements,\nbut for other socket types the call fails.\n\nSee `send/4` for a description of the `Flags` argument\nand the return values.\n\n> #### Note {: .info }\n>\n> On Windows, this function can only be used with datagram and raw sockets.\n\n[](){: #sendmsg-infinity }\n\nIf the `Timeout` argument is `infinity`; wait for the OS to\ncomplete the send operation (take responsibility for the data),\nor return an error.\n\n[](){: #sendmsg-timeout }\n\nIf the `Timeout` argument is a time-out value\n(`t:non_neg_integer/0`); return `{error, timeout}`\nif no data has been sent within `Timeout` millisecond,\nor `{error, {timeout, RestData}}` if some data was sent\n(accepted by the OS for delivery).  `RestData` is the tail of the data\nthat hasn't been sent.\n\n[](){: #sendmsg-nowait }\n\nIf the `Handle` argument is `nowait` *(since OTP 22.1)*,\nstarts an [asynchronous call](#asynchronous-calls) if the operation\ncouldn't be completed immediately.\n\nIf the `Handle` argument is a `t:select_handle/0`,\n*(since OTP 24.0)*, or on _Windows_, the equivalent\n`t:completion_handle/0` *(since OTP 26.0)*, starts\nan [asynchronous call](#asynchronous-calls) like for `nowait`.\n\nSee the note [Asynchronous Calls](#asynchronous-calls)\nat the start of this module reference manual page.\n\nAfter receiving a [`select` message](#async-messages);\ncall [`sendmsg/3,4`](`sendmsg/3`) with `SelectInfo` as the `Cont` argument,\nto complete the operation.\n\n[](){: #sendmsg-cont }\n\nWith the arguments `Data` and [`Cont`](`t:select_info/0`),\ncontinues the send operation.  `Cont` should be\nthe [`SelectInfo`](`t:select_info/0`) returned from the previous\n[`sendmsg/2,3,4`](`sendmsg/2`) call.\n\n`Data` can be a [`Msg`](`t:msg_send/0`) `t:map/0`\nwhere only the key `iov` is used, or an `t:erlang:iovec/0`.","ref":"socket.html#sendmsg/4"},{"type":"function","title":"socket.sendto/3","doc":"Send data on a socket.\n\nWith argument `Dest`; equivalent to\n[`sendto(Socket, Data, Dest, [], infinity)`](`sendto/5`).\n\nWith argument `Cont`; equivalent to\n[`sendto(Socket, Data, Cont, infinity)`](`sendto/4`) *since OTP 24.0*.","ref":"socket.html#sendto/3"},{"type":"function","title":"socket.sendto/4","doc":"Send data on a socket.\n\nWith arguments `Dest` and `TimeoutOrHandle`; equivalent to\n[`sendto(Socket, Data, Dest, [], TimeoutOrHandle)`](`sendto/5`).\n\nWith arguments `Dest` and `Flags`; equivalent to\n[`sendto(Socket, Data, Dest, Flags, infinity)`](`sendto/5`).\n\nWith arguments `Cont` and `TimeoutOrHandle`; `Cont` must be\nthe [`SelectInfo`](`t:select_info/0`) from the previous\n[`sendto/3,4,5`](`sendto/3`) call and the send is continued with\npreprocessed send parameters in the `SelectInfo`.\nUsing this argument variant avoids for example having o validate\nand encode message flags in every call but the first.\n*(Since OTP 24.0)*\n\nSee the last argument (argument 5) of `sendto/5` for\nan explanation of `TimeoutOrHandle`.","ref":"socket.html#sendto/4"},{"type":"function","title":"socket.sendto/5","doc":"Send data on a socket.\n\nThe `To` argument is the destination address where to send the data.\nFor a connected socket this argument is still passed to the OS call\nthat may ignore the address or return an error.\n\nSee `send/4` for a description of the `Flags` and `Data` arguments,\nand the return values.\n\n[](){: #sendto-infinity }\n\nIf the `Timeout` argument is `infinity`; wait for the OS to\ncomplete the send operation (take responsibility for the data),\nor return an error.\n\n[](){: #sendto-timeout }\n\nIf the `Timeout` argument is a time-out value\n(`t:non_neg_integer/0`); return `{error, timeout}`\nif no data has been sent within `Timeout` millisecond,\nor `{error, {timeout, RestData}}` if some data was sent\n(accepted by the OS for delivery).  `RestData` is the tail of the data\nthat hasn't been sent.\n\n[](){: #sendto-nowait }\n\nIf the `Handle` argument is `nowait` *(since OTP 22.1)*,\nstarts an [asynchronous call](#asynchronous-calls) if the operation\ncouldn't be completed immediately.\n\nIf the `Handle` argument is a `t:select_handle/0`,\n*(since OTP 24.0)*, or on _Windows_, the equivalent\n`t:completion_handle/0` *(since OTP 26.0)*, starts\nan [asynchronous call](#asynchronous-calls) like for `nowait`.\n\nSee the note [Asynchronous Calls](#asynchronous-calls)\nat the start of this module reference manual page.\n\nAfter receiving a [`select` message](#async-messages);\ncall [`sendto/3,4`](`sendto/3`) with `SelectInfo` as the `Cont` argument,\nto complete the operation.","ref":"socket.html#sendto/5"},{"type":"function","title":"socket.sendv/2","doc":"Equivalent to  sendv(Socket, IOV, infinity) .","ref":"socket.html#sendv/2"},{"type":"function","title":"socket.sendv/3","doc":"Send `t:erlang:iovec/0` data on a connected socket.\n\nSee [`sendmsg/4`](#sendmsg-iov) about how the [`IOV`](`t:erlang:iovec/0`)\ndata is handled towards the platform's network layer.\n\nThe return value indicates the result from the platform's network layer:\n\n- **`ok`** - All data has been accepted by the OS for delivery.\n\n- **`{ok, RestIOV}`** - Some but not all data was accepted,\n  but no error was reported (partially successful send).  `RestIOV`\n  is the tail of `IOV` that wasn't accepted.\n\n- **`{error, Reason}`** - An error has been reported and no data\n  was accepted for delivery.  [`Reason :: posix/0`](`t:posix/0`)\n  is what the platform's network layer reported.  `closed` means\n  that this socket library was informed that the socket was closed,\n  and `t:invalid/0` means that this socket library found\n  an argument to be invalid.\n\n- **`{error, {Reason, RestIOV}}`** -  - An error was reported but before that\n  some data was accepted for delivery. `RestIOV` is the tail of `IOV`\n  that wasn't accepted. See `{error, Reason}` above.\n\n[](){: #sendv-infinity }\n\nIf the `Timeout` argument is `infinity`; wait for the OS to\ncomplete the send operation (take responsibility for the data),\nor return an error.\n\n[](){: #sendv-timeout }\n\nIf the `Timeout` argument is a time-out value\n(`t:non_neg_integer/0`); return `{error, timeout}`\nif no data has been sent within `Timeout` millisecond,\nor `{error, {timeout, RestIOV}}` if some data was sent\n(accepted by the OS for delivery).  `RestIOV` is the tail of the data\nthat hasn't been sent.\n\n[](){: #sendv-nowait }\n\nIf the `Handle` argument is `nowait`,\nstarts an [asynchronous call](#asynchronous-calls) if the operation\ncouldn't be completed immediately.\n\nIf the `Handle` argument is a `t:select_handle/0`,\nor on _Windows_, the equivalent `t:completion_handle/0`, starts\nan [asynchronous call](#asynchronous-calls) like for `nowait`.\n\nSee the note [Asynchronous Calls](#asynchronous-calls)\nat the start of this module reference manual page.\n\n[](){: #sendv-cont }\n\nWith the argument [`Cont`](`t:select_info/0`), equivalent to\n[`sendv(Socket, IOV, Cont, infinity)`](`sendv/4`).","ref":"socket.html#sendv/3"},{"type":"function","title":"socket.sendv/4","doc":"Send data on a connected socket, continuation.\n\nContinues sending data on a connected socket.\n`Cont` is the [`SelectInfo`](`t:select_info/0`) returned from\nthe previous [`sendv/2,3`](`sendv/2`) call.\n`IOV` should be the rest data that wasn't sent.\n\nSee [asynchronous calls](#asynchronous-calls) about continuing\nunfinished calls.\n\nSee `sendv/3` about the return values.","ref":"socket.html#sendv/4"},{"type":"function","title":"socket.setopt/3","doc":"Set a socket option.\n\nSet an OS protocol level option, or an `otp` pseudo protocol level option.\nThe latter level is this module's implementation level above\nthe OS protocol levels.\n\nSee the type [otp_socket_option() ](`t:otp_socket_option/0`)\nfor a description of the `otp` protocol level.\n\nSee the type `t:socket_option/0` for which OS protocol level options\nthat this implementation knows about, how they are related to OS option names,\nand if there are known peculiarities with any of them.\n\nWhat options that are valid depends on the OS, and on the kind of socket\n(`t:domain/0`,`t:type/0` and `t:protocol/0`).  See the type\n`t:socket_option()` and the\n[socket options ](socket_usage.md#socket_options) chapter\nin the User's Guide for more info.\n\n> #### Note {: .info }\n>\n> Not all options are valid, nor possible to set, on all platforms. That is,\n> even if this `socket` implementation  support an option; it doesn't mean\n> that the underlying OS does.","ref":"socket.html#setopt/3"},{"type":"function","title":"socket.setopt/4","doc":"Set a socket option _(backwards compatibility function)_.\n\nEquivalent to [`setopt(Socket, {Level, Opt}, Value)`](`setopt/3`),\nor as a special case if `Opt = NativeOpt ::` `t:integer/0`\nand `Value =` `t:binary/0` equivalent to\n[`setopt_native(Socket, {Level, NativeOpt}, ValueSpec)`](`setopt_native/3`).\n\nUse `setopt/3` or `setopt_native/3` instead to handle\nthe option level and name as a single term, and to make the\ndifference between known options and native options clear.","ref":"socket.html#setopt/4"},{"type":"function","title":"socket.setopt_native/3","doc":"Set a \"native\" socket option.\n\nSets a socket option that may be unknown to our implementation, or that has a\ntype not compatible with our implementation, that is; in \"native mode\".\n\nIf `Value` is an `t:integer/0` it will be used as a `C` type `(int)`,\nif it is a `t:boolean/0` it will be used as a `C` type `(int)`\nwith the `C` implementations values for `false` or `true`,\nand if it is a `t:binary/0` its content and size will be used\nas the option value.\n\nThe socket option may be specified with an ordinary\n`t:socket_option/0` tuple, with a symbolic `Level` as\n`{`[`Level :: level/0`](`t:level/0`)`, `[`NativeOpt :: integer/0`](`t:integer/0`)`}`,\nor with integers for both `NativeLevel` and `NativeOpt` as\n`{`[`NativeLevel :: integer/0`](`t:integer/0`)`, `[`NativeOpt :: integer/0`](`t:integer/0`)`}`.\n\nIf an option is valid depends both on the platform and on\nwhat kind of socket it is (`t:domain/0`, `t:type/0` and `t:protocol/0`).\n\nThe integer values for `NativeLevel` and `NativeOpt` as well as the `Value`\nencoding has to be deduced from the header files for the running system.","ref":"socket.html#setopt_native/3"},{"type":"function","title":"socket.shutdown/2","doc":"Shut down all or part of a full-duplex connection.","ref":"socket.html#shutdown/2"},{"type":"type","title":"socket.sockaddr/0","doc":"","ref":"socket.html#t:sockaddr/0"},{"type":"type","title":"socket.sockaddr_dl/0","doc":"C: `struct sockaddr_dl`\n\nLink level address (PF_LINK) on BSD:s.","ref":"socket.html#t:sockaddr_dl/0"},{"type":"type","title":"socket.sockaddr_in6/0","doc":"C: `struct sockaddr_in6`\n\n[Domain `inet6`](`t:domain/0`) (IPv6) address.","ref":"socket.html#t:sockaddr_in6/0"},{"type":"type","title":"socket.sockaddr_in/0","doc":"C: `struct sockaddr_in`\n\n[Domain `inet`](`t:domain/0`) (IPv4) address.","ref":"socket.html#t:sockaddr_in/0"},{"type":"type","title":"socket.sockaddr_ll/0","doc":"C: `struct sockaddr_ll`\n\n[Domain `packet`](`t:domain/0`), [type `raw`](`t:type/0`)\n(link level) address.","ref":"socket.html#t:sockaddr_ll/0"},{"type":"type","title":"socket.sockaddr_native/0","doc":"C: `struct sockaddr`\n\nIn C, a `struct sockaddr` with the integer value of `sa_family`\nin the `t:map/0` key `family`,\nand the content of `sa_data` in the `t:map/0` key `addr`.","ref":"socket.html#t:sockaddr_native/0"},{"type":"type","title":"socket.sockaddr_recv/0","doc":"","ref":"socket.html#t:sockaddr_recv/0"},{"type":"type","title":"socket.sockaddr_un/0","doc":"C: `struct sockaddr_un`.\n\nA Unix Domain socket address, a.k.a local address (`AF_LOCAL`).\n\nThe `path` element will always be a `binary` when returned from this module.\nWhen supplied to an API function in this module it may be a `t:string/0`, which\nwill be encoded into a binary according to the\n[native file name encoding ](`file:native_name_encoding/0`)on the platform.\n\nA terminating zero character will be appended before the address path is given\nto the OS, and the terminating zero will be stripped before giving the address\npath to the caller.\n\nLinux's non-portable abstract socket address extension is handled by not doing\nany terminating zero processing in either direction, if the first byte of the\naddress is zero.","ref":"socket.html#t:sockaddr_un/0"},{"type":"type","title":"socket.sockaddr_unspec/0","doc":"C: `struct sockaddr` of `AF_UNSPEC`\n\nIn C, a `struct sockaddr` with `sa_family = AF_UNSPEC`\nand the content of `sa_data` in the `t:map/0` key `addr`.","ref":"socket.html#t:sockaddr_unspec/0"},{"type":"type","title":"socket.socket/0","doc":"A socket, according to this module.\n\nCreated and returned by [`open/1,2,3,4`](`open/1`)\nand [`accept/1,2`](`accept/1`).","ref":"socket.html#t:socket/0"},{"type":"type","title":"socket.socket_counters/0","doc":"A `t:map/0` of `Name := Counter` associations.","ref":"socket.html#t:socket_counters/0"},{"type":"opaque","title":"socket.socket_handle/0","doc":"Opaque socket handle unique for the socket.","ref":"socket.html#t:socket_handle/0"},{"type":"type","title":"socket.socket_info/0","doc":"","ref":"socket.html#t:socket_info/0"},{"type":"type","title":"socket.socket_option/0","doc":"Socket option.\n\nSocket options of the form `{Level, Opt}` where the OS protocol `Level` =\n`t:level/0` and `Opt` is a socket option on that protocol level.\n\nThe OS name for an options is, except where otherwise noted, the `Opt` atom, in\ncapitals, with prefix according to `t:level/0`.\n\n> #### Note {: .info }\n>\n> The `IPv6` option `pktoptions` is a special (barf) case. It is intended for\n> backward compatibility usage only.\n>\n> Do _not_ use this option.\n\n> #### Note {: .info }\n>\n> See the OS documentation for every socket option.\n\nAn option below that has the value type `t:boolean/0` will translate the value\n`false` to a C `int` with value `0`, and the value `true` to `!!0` (not (not\nfalse)).\n\nAn option with value type `t:integer/0` will be translated to a C `int` that may\nhave a restricted range, for example byte: `0..255`. See the OS documentation.\n\nThe calls [`supports(options)`](`supports/1`),\n[`supports(options, Level)`](`supports/1`) and\n[`is_supported(options, {Level, Opt})` ](`is_supported/2`)can be used to find\nout which socket options that are supported by the platform.\n\n_Options for protocol level_ [_`socket`_:](`t:level/0`)\n\n- **`{socket, acceptconn}`** - `Value = boolean()`\n\n- **`{socket, bindtodevice}`** - `Value = string()`\n\n- **`{socket, broadcast}`** - `Value = boolean()`\n\n- **`{socket, debug}`** - `Value = integer()`\n\n- **`{socket, domain}`** - `Value =` `t:domain/0`\n\n  Only valid to _get_.\n\n  The socket's protocol domain. Does _not_ work on for instance FreeBSD.\n\n- **`{socket, dontroute}`** - `Value = boolean()`\n\n- **`{socket, keepalive}`** - `Value = boolean()`\n\n- **`{socket, linger}`** - `Value = abort |` `t:linger/0`\n\n  The value `abort` is shorthand for `#{onoff => true, linger => 0}`, and only\n  valid to _set_.\n\n- **`{socket, oobinline}`** - `Value = boolean()`\n\n- **`{socket, passcred}`** - `Value = boolean()`\n\n- **`{socket, peek_off}`** - `Value = integer()`\n\n  Currently disabled due to a possible infinite loop when calling\n  [`recv/1-4`](`recv/1`) with [`peek`](`t:msg_flag/0`) in `Flags`.\n\n- **`{socket, priority}`** - `Value = integer()`\n\n- **`{socket, protocol}`** - `Value =` `t:protocol/0`\n\n  Only valid to _get_.\n\n  The socket's protocol. Does _not_ work on for instance Darwin.\n\n- **`{socket, rcvbuf}`** - `Value = integer()`\n\n- **`{socket, rcvlowat}`** - `Value = integer()`\n\n- **`{socket, rcvtimeo}`** - `Value =` `t:timeval/0`\n\n  This option is unsupported per default; OTP has to be explicitly built with\n  the `--enable-esock-rcvsndtimeo` configure option for this to be available.\n\n  Since our implementation uses non-blocking sockets, it is unknown if and how\n  this option works, or even if it may cause malfunction. Therefore, we do not\n  recommend setting this option.\n\n  Instead, use the `Timeout` argument to, for instance, the `recv/3` function.\n\n- **`{socket, reuseaddr}`** - `Value = boolean()`\n\n- **`{socket, reuseport}`** - `Value = boolean()`\n\n- **`{socket, sndbuf}`** - `Value = integer()`\n\n- **`{socket, sndlowat}`** - `Value = integer()`\n\n- **`{socket, sndtimeo}`** - `Value =` `t:timeval/0`\n\n  This option is unsupported per default; OTP has to be explicitly built with\n  the `--enable-esock-rcvsndtimeo` configure option for this to be available.\n\n  Since our implementation uses non-blocking sockets, it is unknown if and how\n  this option works, or even if it may cause malfunction. Therefore, we do not\n  recommend setting this option.\n\n  Instead, use the `Timeout` argument to, for instance, the `send/3` function.\n\n- **`{socket, timestamp}`** - `Value = boolean()`\n\n- **`{socket, type}`** - `Value =` `t:type/0`\n\n  Only valid to _get_.\n\n  The socket's type.\n\n_Options for protocol level_ [_`ip`_:](`t:level/0`)\n\n- **`{ip, add_membership}`** - `Value =` `t:ip_mreq/0`\n\n  Only valid to _set_.\n\n- **`{ip, add_source_membership}`** - `Value =` `t:ip_mreq_source/0`\n\n  Only valid to _set_.\n\n- **`{ip, block_source}`** - `Value =` `t:ip_mreq_source/0`\n\n  Only valid to _set_.\n\n- **`{ip, drop_membership}`** - `Value =` `t:ip_mreq/0`\n\n  Only valid to _set_.\n\n- **`{ip, drop_source_membership}`** - `Value =` `t:ip_mreq_source/0`\n\n  Only valid to _set_.\n\n- **`{ip, freebind}`** - `Value = boolean()`\n\n- **`{ip, hdrincl}`** - `Value = boolean()`\n\n- **`{ip, minttl}`** - `Value = integer()`\n\n- **`{ip, msfilter}`** - `Value =` `null |` `t:ip_msfilter/0`\n\n  Only valid to _set_.\n\n  The value `null` passes a `NULL` pointer and size `0` to the C library call.\n\n- **`{ip, mtu}`** - `Value = integer()`\n\n  Only valid to _get_.\n\n- **`{ip, mtu_discover}`** - `Value =`\n  [`ip_pmtudisc()` ](`t:ip_pmtudisc/0`)`| integer()`\n\n  An `t:integer/0` value according to the platform's header files.\n\n- **`{ip, multicast_all}`** - `Value = boolean()`\n\n- **`{ip, multicast_if}`** - `Value =` `any |` `t:in_addr/0`\n\n- **`{ip, multicast_loop}`** - `Value = boolean()`\n\n- **`{ip, multicast_ttl}`** - `Value = integer()`\n\n- **`{ip, nodefrag}`** - `Value = boolean()`\n\n- **`{ip, pktinfo}`** - `Value = boolean()`\n\n- **`{ip, recvdstaddr}`** - `Value = boolean()`\n\n- **`{ip, recverr}`** - `Value = boolean()`\n\n  Enable extended reliable error message passing.\n\n  _Warning\\!_ When this option is enabled, error messages may arrive on the\n  socket's error queue, which should be read using the message flag\n  [`errqueue`](`t:msg_flag/0`), and using [`recvmsg/1,2,3,4,5`](`recvmsg/1`) to\n  get all error information in the [message's](`t:msg_recv/0`) `ctrl` field as a\n  [control message](`t:cmsg_recv/0`) `#{level := ip, type := recverr}`.\n\n  A working strategy should be to first poll the error queue using\n  [`recvmsg/2,3,4` ](#recvmsg-timeout)with `Timeout =:= 0` and `Flags`\n  containing `errqueue` (ignore the return value `{error, timeout}`) before\n  reading the actual data to ensure that the error queue gets cleared. And read\n  the data using one of the `nowait |`\n  [`select_handle()` ](`t:select_handle/0`)recv functions:\n  [`recv/3,4`](#recv-nowait),\n  [`recvfrom/3,4`](#recvfrom-nowait) or\n  [`recvmsg/3,4,5`](#recvmsg-nowait). Otherwise you might accidentally\n  cause a busy loop in and out of 'select' for the socket.\n\n- **`{ip, recvif}`** - `Value = boolean()`\n\n- **`{ip, recvopts}`** - `Value = boolean()`\n\n- **`{ip, recvorigdstaddr}`** - `Value = boolean()`\n\n- **`{ip, recvtos}`** - `Value = boolean()`\n\n- **`{ip, recvttl}`** - `Value = boolean()`\n\n- **`{ip, retopts}`** - `Value = boolean()`\n\n- **`{ip, router_alert}`** - `Value = integer()`\n\n- **`{ip, sendsrcaddr}`** - `Value = boolean()`\n\n- **`{ip, tos}`** - `Value =` [`ip_tos()` ](`t:ip_tos/0`)`| integer()`\n\n  An `t:integer/0` value is according to the platform's header files.\n\n- **`{ip, transparent}`** - `Value = boolean()`\n\n- **`{ip, ttl}`** - `Value = integer()`\n\n- **`{ip, unblock_source}`** - `Value =` `t:ip_mreq_source/0`\n\n  Only valid to _set_.\n\n_Options for protocol level_ [_`ipv6`_:](`t:level/0`)\n\n- **`{ipv6, addrform}`** - `Value =` `t:domain/0`\n\n  As far as we know the only valid value is `inet` and it is only allowed for an\n  IPv6 socket that is connected and bound to an IPv4-mapped IPv6 address.\n\n- **`{ipv6, add_membership}`** - `Value =` `t:ipv6_mreq/0`\n\n  Only valid to _set_.\n\n- **`{ipv6, authhdr}`** - `Value = boolean()`\n\n- **`{ipv6, drop_membership}`** - `Value =` `t:ipv6_mreq/0`\n\n  Only valid to _set_.\n\n- **`{ipv6, dstopts}`** - `Value = boolean()`\n\n- **`{ipv6, flowinfo}`** - `Value = boolean()`\n\n- **`{ipv6, hoplimit}`** - `Value = boolean()`\n\n- **`{ipv6, hopopts}`** - `Value = boolean()`\n\n- **`{ipv6, mtu}`** - `Value = integer()`\n\n- **`{ipv6, mtu_discover}`** - `Value =`\n  [`ipv6_pmtudisc()` ](`t:ipv6_pmtudisc/0`)`| integer()`\n\n  An `t:integer/0` value is according to the platform's header files.\n\n- **`{ipv6, multicast_hops}`** - `Value =` `t:ipv6_hops/0`\n\n- **`{ipv6, multicast_if}`** - `Value = integer()`\n\n- **`{ipv6, multicast_loop}`** - `Value = boolean()`\n\n- **`{ipv6, recverr}`** - `Value = boolean()`\n\n  _Warning\\!_ See the socket option `{ip, recverr}` regarding the socket's error\n  queue. The same warning applies for this option.\n\n- **`{ipv6, recvhoplimit}`** - `Value = boolean()`\n\n- **`{ipv6, recvpktinfo}`** - `Value = boolean()`\n\n- **`{ipv6, recvtclass}`** - `Value = boolean()`\n\n- **`{ipv6, router_alert}`** - `Value = integer()`\n\n- **`{ipv6, rthdr}`** - `Value = boolean()`\n\n- **`{ipv6, tclass}`** - `Value = boolean()`\n\n- **`{ipv6, unicast_hops}`** - `Value =` `t:ipv6_hops/0`\n\n- **`{ipv6, v6only}`** - `Value = boolean()`\n\n_Options for protocol level_ [_`sctp`_](`t:level/0`). See also RFC 6458.\n\n- **`{sctp, associnfo}`** - `Value =` `t:sctp_assocparams/0`\n\n- **`{sctp, autoclose}`** - `Value = integer()`\n\n- **`{sctp, disable_fragments}`** - `Value = boolean()`\n\n- **`{sctp, events}`** - `Value =` `t:sctp_event_subscribe/0`\n\n  Only valid to _set_.\n\n- **`{sctp, initmsg}`** - `Value =` `t:sctp_initmsg/0`\n\n- **`{sctp, maxseg}`** - `Value = integer()`\n\n- **`{sctp, nodelay}`** - `Value = boolean()`\n\n- **`{sctp, rtoinfo}`** - `Value =` `t:sctp_rtoinfo/0`\n\n_Options for protocol level_ [_`tcp`:_](`t:level/0`)\n\n- **`{tcp, congestion}`** - `Value = string()`\n\n- **`{tcp, cork}`** - `Value = boolean()`\n\n- **`{tcp, maxseg}`** - `Value = integer()`\n\n- **`{tcp, nodelay}`** - `Value = boolean()`\n\n_Options for protocol level_ [_`udp`:_](`t:level/0`)\n\n- **`{udp, cork}`** - `Value = boolean()`","ref":"socket.html#t:socket_option/0"},{"type":"function","title":"socket.sockname/1","doc":"Get the socket's address.\n\nReturns the address to which the socket is currently bound.\nIf the bind address had the wildcard port `0`,\nthe address returned by this function contains the ephemeral port\nselected by the OS.","ref":"socket.html#sockname/1"},{"type":"function","title":"socket.supports/0","doc":"Retrieve information about what socket features\nthe module and the platform supports.\n\nReturns a list of, in no particular order,\n`{Key1, `[`supports(Key1)`](`supports/1`)`}` tuples\nfor every `Key1` described in `supports/1`,\nand `{Key, boolean()}` tuples for each of the following keys:\n\n- **`sctp`** - SCTP support\n\n- **`ipv6`** - IPv6 support\n\n- **`local`** - Unix Domain sockets support (`AF_UNIX | AF_LOCAL`)\n\n- **`netns`** - Network Namespaces support (Linux, `setns(2)`)\n\n- **`sendfile`** - Sendfile support (`sendfile(2)`)","ref":"socket.html#supports/0"},{"type":"function","title":"socket.supports/1","doc":"Retrieve information about what socket features\nthe module and the platform supports.\n\nIf `Key1 = msg_flags` returns a list of `{Flag, boolean()}`\ntuples for every `Flag` in `t:msg_flag/0` with the `t:boolean/0`\nindicating if the flag is supported on this platform.\n\nIf `Key1 = protocols` returns a list of `{Name, boolean()}`\ntuples for every `Name` in`t:protocol/0` with the `t:boolean/0`\nindicating if the protocol is supported on this platform.\n\nIf `Key1 = options` returns a list of `{SocketOption, boolean()}`\ntuples for every `SocketOption` in `t:socket_option/0` with the `t:boolean/0`\nindicating if the socket option is supported on this platform.\n\nThere is no particular order of any of the returned lists.\n\nFor other values of `Key1` returns `[]`.\nNote that in future versions of this module or on different platforms,\nthere might be more supported keys.","ref":"socket.html#supports/1"},{"type":"function","title":"socket.supports/2","doc":"Retrieve information about what socket features\nthe module and the platform supports.\n\nIf `Key1 = options`, for a `Key2` in `t:level/0` returns\na list of `{Opt, boolean()}` tuples for all known socket options\n[`Opt` on that `Level = Key2`](`t:socket_option/0`) with the `t:boolean/0`\nindicating if the socket option is supported on this platform.\nSee `setopt/3` and `getopt/2`.\n\nThere is no particular order of any of the returned lists.\n\nFor other values of `Key1` or `Key2` returns `[]`.\nNote that in future versions of this module or on different platforms,\nthere might be more supported keys.","ref":"socket.html#supports/2"},{"type":"type","title":"socket.timeval/0","doc":"C: `struct timeval`\n\nCorresponds to the C `struct timeval`. The field `sec` holds seconds, and `usec`\nmicroseconds.","ref":"socket.html#t:timeval/0"},{"type":"type","title":"socket.type/0","doc":"Protocol type.\n\nA lowercase `t:atom/0` representing a protocol _type_\non the platform named `SOCK_*`.  For example\n`stream` corresponds to `SOCK_STREAM`.","ref":"socket.html#t:type/0"},{"type":"function","title":"socket.use_registry/1","doc":"Set the global [`use_registry`](`t:otp_socket_option/0`)\noption default value.\n\nGlobally change if the socket registry is to be used or not.\nNote that its still possible to override this explicitly\nwhen creating an individual sockets, see [`open/2,3,4`](`open/2`)\nfor more info (the [`Opts :: map/0`](`t:map/0`)).","ref":"socket.html#use_registry/1"},{"type":"function","title":"socket.which_sockets/0","doc":"Return a list of all known sockets.\n\nEquivalent to [`which_sockets(fun (_) -> true end)`](`which_sockets/1`).","ref":"socket.html#which_sockets/0"},{"type":"function","title":"socket.which_sockets/1","doc":"Return a filtered list of known sockets.\n\nThere are several predefined `FilterRule`s and one general:\n\n- **`inet | inet6`** - Only the sockets with matching `t:domain/0`\n  are returned.\n\n- **`stream | dgram | seqpacket`** - Only the sockets with\n  matching `t:type/0` are returned.\n\n- **`sctp | tcp | udp`** - Only the sockets with\n  matching `t:protocol/0` are returned.\n\n- **`t:pid/0`** - Only the sockets with matching Controlling Process\n  are returned. See the OTP socket option\n  [`controlling_process`](`t:otp_socket_option/0`).\n\n- **`fun((socket_info()) -> boolean())`** - The general filter rule.\n  A fun that takes the socket info and returns a `t:boolean/0`\n  indicating if the socket should be returned or not.","ref":"socket.html#which_sockets/1"},{"type":"module","title":"disk_log","doc":"`disk_log` is a disk-based term logger that enables efficient logging of items\non files.\n\nThree types of logs are supported:\n\n- **halt logs** - Appends items to a single file, which size can be limited by\n  the `disk_log` module.\n\n- **wrap logs** - Uses a sequence of wrap log files of limited size. As a wrap\n  log file is filled up, further items are logged on to the next file in the\n  sequence, starting all over with the first file when the last file is filled\n  up.\n\n- **rotate logs** - Uses a sequence of rotate log files of limited size. As a\n  log file is filled up, it is rotated and then compressed. There is one active\n  log file and upto the configured number of compressed log files. Only\n  externally formatted logs are supported. It follows the same naming convention\n  as the handler logger_std_h for Logger. For more details about the naming\n  convention check the file parameter for `open/1`.\n\n  It follows the same naming convention as that for the compressed files for\n  Linux's logrotate and BSD's newsyslog.\n\nFor efficiency reasons, items are always written to files as binaries.\n\nTwo formats of the log files are supported:\n\n- **internal format** - Supports automatic repair of log files that are not\n  properly closed and enables efficient reading of logged items in _chunks_\n  using a set of functions defined in this module. This is the only way to read\n  internally formatted logs. An item logged to an internally formatted log must\n  not occupy more than 4 GB of disk space (the size must fit in 4 bytes).\n\n- **external format** - Leaves it up to the user to read and interpret the\n  logged data. The `disk_log` module cannot repair externally formatted logs.\n\nFor each open disk log, one process handles requests made to the disk log. This\nprocess is created when `open/1` is called, provided there exists no process\nhandling the disk log. A process that opens a disk log can be an _owner_ or an\nanonymous _user_ of the disk log. Each owner is linked to the disk log process,\nand an owner can close the disk log either explicitly (by calling\n[`close/1`](`close/1`)) or by terminating.\n\nOwners can subscribe to _notifications_, messages of the form\n`{disk_log, Node, Log, Info}`, which are sent from the disk log process when\ncertain events occur, see the functions and in particular the\n[`open/1`](`open/1`) option [`notify`](`m:disk_log#notify`). A log can have many\nowners, but a process cannot own a log more than once. However, the same process\ncan open the log as a user more than once.\n\nFor a disk log process to close its file properly and terminate, it must be\nclosed by its owners and once by some non-owner process for each time the log\nwas used anonymously. The users are counted and there must not be any users left\nwhen the disk log process terminates.\n\nItems can be logged _synchronously_ by using functions `log/2`, `blog/2`,\n`log_terms/2`, and `blog_terms/2`. For each of these functions, the caller is\nput on hold until the items are logged (but not necessarily written, use\n[`sync/1`](`sync/1`) to ensure that). By adding an `a` to each of the mentioned\nfunction names, we get functions that log items _asynchronously_. Asynchronous\nfunctions do not wait for the disk log process to write the items to the file,\nbut return the control to the caller more or less immediately.\n\nWhen using the internal format for logs, use functions `log/2`, `log_terms/2`,\n`alog/2`, and `alog_terms/2`. These functions log one or more Erlang terms. By\nprefixing each of the functions with a `b` (for \"binary\"), we get the\ncorresponding `blog()` functions for the external format. These functions log\none or more chunks of bytes. For example, to log the string `\"hello\"` in ASCII\nformat, you can use [`disk_log:blog(Log, \"hello\")`](`blog/2`), or\n[`disk_log:blog(Log, list_to_binary(\"hello\"))`](`blog/2`). The two alternatives\nare equally efficient.\n\nThe `blog()` functions can also be used for internally formatted logs, but in\nthis case they must be called with binaries constructed with calls to\n[`term_to_binary/1`](`erlang:term_to_binary/1`). There is no check to ensure\nthis, it is entirely the responsibility of the caller. If these functions are\ncalled with binaries that do not correspond to Erlang terms, the\n[`chunk/2,3`](`chunk/3`) and automatic repair functions fail. The corresponding\nterms (not the binaries) are returned when [`chunk/2,3`](`chunk/3`) is called.\n\nAn open disk log is only accessible from the node where the disk log process\nruns. All processes on the node where the disk log process runs can log items or\notherwise change, inspect, or close the log.\n\nErrors are reported differently for asynchronous log attempts and other uses of\nthe `m:disk_log` module. When used synchronously, this module replies with an\nerror message, but when called asynchronously, this module does not know where\nto send the error message. Instead, owners subscribing to notifications receive\nan `error_status` message.\n\nThe `m:disk_log` module does not report errors to the `m:error_logger` module. It\nis up to the caller to decide whether to employ the error logger. Function\n`format_error/1` can be used to produce readable messages from error replies.\nHowever, information events are sent to the error logger in two situations,\nnamely when a log is repaired, or when a file is missing while reading chunks.\n\nError message `no_such_log` means that the specified disk log is not open.\nNothing is said about whether the disk log files exist or not.\n\n> #### Note {: .info }\n>\n> If an attempt to reopen or truncate a log fails (see\n> [`reopen/2,3`](`reopen/3`) and [`truncate/1,2`](`truncate/2`)) the disk log\n> process terminates immediately. Before the process terminates, links to owners\n> and blocking processes (see [`block/1,2`](`block/2`)) are removed. The effect\n> is that the links work in one direction only. Any process using a disk log\n> must check for error message `no_such_log` if some other process truncates or\n> reopens the log simultaneously.","ref":"disk_log.html"},{"type":"module","title":"See Also - disk_log","doc":"`m:file`, `m:wrap_log_reader`","ref":"disk_log.html#module-see-also"},{"type":"function","title":"disk_log.all/0","doc":"Returns the names of the disk logs accessible on the current node.","ref":"disk_log.html#all/0"},{"type":"function","title":"disk_log.alog/2","doc":"Asynchronously version of `log/2`.\n\nOwners subscribing to notifications receive message `read_only`, `blocked_log`,\nor `format_external` if the item cannot be written on the log, and possibly one\nof the messages `wrap`, `full`, or `error_status` if an item is written on the\nlog. Message `error_status` is sent if something is wrong with the header\nfunction or if a file error occurs.","ref":"disk_log.html#alog/2"},{"type":"function","title":"disk_log.alog_terms/2","doc":"Asynchronously version of `log_terms/2`.\n\nOwners subscribing to notifications receive message `read_only`, `blocked_log`,\nor `format_external` if the items cannot be written on the log, and possibly one\nor more of the messages `wrap`, `full`, and `error_status` if items are written\non the log. Message `error_status` is sent if something is wrong with the header\nfunction or if a file error occurs.","ref":"disk_log.html#alog_terms/2"},{"type":"function","title":"disk_log.balog/2","doc":"Asynchronously version of `blog/2`.\n\nOwners subscribing to notifications receive message `read_only`, `blocked_log`,\nor `format_external` if the item cannot be written on the log, and possibly one\nof the messages `wrap`, `full`, or `error_status` if an item is written on the\nlog. Message `error_status` is sent if something is wrong with the header\nfunction or if a file error occurs.","ref":"disk_log.html#balog/2"},{"type":"function","title":"disk_log.balog_terms/2","doc":"Asynchronously version of `blog_terms/2`.\n\nOwners subscribing to notifications receive message `read_only`, `blocked_log`,\nor `format_external` if the items cannot be written on the log, and possibly one\nor more of the messages `wrap`, `full`, and `error_status` if items are written\non the log. Message `error_status` is sent if something is wrong with the header\nfunction or if a file error occurs.","ref":"disk_log.html#balog_terms/2"},{"type":"function","title":"disk_log.bchunk/2","doc":"Equivalent to  bchunk(Log, Cont, infinity) .","ref":"disk_log.html#bchunk/2"},{"type":"function","title":"disk_log.bchunk/3","doc":"Equivalent to [`chunk(Log, Continuation, N)`](`chunk/3`) except that\nit returns the binaries read from the file, that is it does not call\n`binary_to_term/1`.","ref":"disk_log.html#bchunk/3"},{"type":"type","title":"disk_log.bchunk_ret/0","doc":"","ref":"disk_log.html#t:bchunk_ret/0"},{"type":"function","title":"disk_log.block/1","doc":"Equivalent to  block(Log, true) .","ref":"disk_log.html#block/1"},{"type":"function","title":"disk_log.block/2","doc":"With a call to `block/2` a process can block a log.\n\nIf the blocking process is not an owner of the log, a temporary link is created\nbetween the disk log process and the blocking process. The link ensures that the disk log is\nunblocked if the blocking process terminates without first closing or unblocking\nthe log.\n\nAny process can probe a blocked log with [`info/1`](`info/1`) or close it with\n[`close/1`](`close/1`). The blocking process can also use functions [`chunk/2,3`](`chunk/3`),\n[`bchunk/2,3`](`chunk/3`), [`chunk_step/3`](`chunk_step/3`), and [`unblock/1`](`unblock/1`)\nwithout being affected by the block. Any other attempt than those mentioned so\nfar to update or read a blocked log suspends the calling process until the log\nis unblocked or returns error message `{blocked_log, Log}`, depending on whether\nthe value of `QueueLogRecords` is `true` or `false`.","ref":"disk_log.html#block/2"},{"type":"type","title":"disk_log.block_error_rsn/0","doc":"","ref":"disk_log.html#t:block_error_rsn/0"},{"type":"function","title":"disk_log.blog/2","doc":"Equivalent to `log/2` except that it is used for externally formatted logs.\n\n`blog/2` can also be used for internally formatted logs\nif the binaries are constructed with calls to `term_to_binary/1`.","ref":"disk_log.html#blog/2"},{"type":"function","title":"disk_log.blog_terms/2","doc":"Equivalent to `log_terms/2` except that it is used for externally formatted logs.\n\n`blog_terms/2` can also be used for internally formatted logs\nif the binaries are constructed with calls to `term_to_binary/1`.","ref":"disk_log.html#blog_terms/2"},{"type":"function","title":"disk_log.breopen/3","doc":"Equivalent to `reopen` except that it is used for externally formatted logs.","ref":"disk_log.html#breopen/3"},{"type":"function","title":"disk_log.btruncate/2","doc":"Equivalent to `truncate/2` for externally formatted logs.","ref":"disk_log.html#btruncate/2"},{"type":"function","title":"disk_log.change_header/2","doc":"Changes the value of option `head` or `head_func` for an owner of a disk log.","ref":"disk_log.html#change_header/2"},{"type":"function","title":"disk_log.change_notify/3","doc":"Changes the value of option `notify` for an owner of a disk log.","ref":"disk_log.html#change_notify/3"},{"type":"function","title":"disk_log.change_size/2","doc":"Changes the size of an open log. For a halt log, the size can always be\nincreased, but it cannot be decreased to something less than the current file\nsize.\n\nFor a wrap or rotate log, both the size and the number of files can always be\nincreased, as long as the number of files does not exceed 65000. For wrap logs,\nif the maximum number of files is decreased, the change is not valid until the\ncurrent file is full and the log wraps to the next file. The redundant files are\nremoved the next time the log wraps around, that is, starts to log to file\nnumber 1.\n\nAs an example, assume that the old maximum number of files is 10 and that the\nnew maximum number of files is 6. If the current file number is not greater than\nthe new maximum number of files, files 7-10 are removed when file 6 is full and\nthe log starts to write to file number 1 again. Otherwise, the files greater\nthan the current file are removed when the current file is full (for example, if\nthe current file is 8, files 9 and 10 are removed). The files between the new\nmaximum number of files and the current file (that is, files 7 and 8) are\nremoved the next time file 6 is full.\n\nFor rotate logs, if the maximum number of files is decreased, the redundant\nfiles are deleted instantly.\n\nIf the size of the files is decreased, the change immediately affects the\ncurrent log. It does not change the size of log files already full until the\nnext time they are used.\n\nIf the log size is decreased, for example, to save space, function\n`next_file/1`, can be used to force the log to wrap.","ref":"disk_log.html#change_size/2"},{"type":"function","title":"disk_log.chunk/2","doc":"Equivalent to  chunk(Log, Continuation, infinity) .","ref":"disk_log.html#chunk/2"},{"type":"function","title":"disk_log.chunk/3","doc":"Efficiently reads the terms that are appended to an internally formatted log.\n\nIt minimizes disk I/O by reading 64 kilobyte chunks from the file.\n\nThe first time `chunk()` is called, an initial continuation, the\natom `start`, must be provided.\n\nWhen [`chunk/3`](`chunk/3`) is called, `N` controls the maximum number of terms\nthat are read from the log in each chunk. `infinity` means\nthat all the terms contained in the 64 kilobyte chunk are read. If less than `N`\nterms are returned, this does not necessarily mean that the end of the file is\nreached.\n\n`chunk/3` returns a tuple `{Continuation2, Terms}`, where `Terms` is a list of\nterms found in the log. `Continuation2` is yet another continuation, which must\nbe passed on to any subsequent calls to `chunk()`. With a series of calls to\n`chunk()`, all terms from a log can be extracted.\n\n`chunk/3` returns a tuple `{Continuation2, Terms, Badbytes}` if the log is\nopened in read-only mode and the read chunk is corrupt. `Badbytes` is the number\nof bytes in the file found not to be Erlang terms in the chunk. Notice that the\nlog is not repaired. When trying to read chunks from a log opened in read-write\nmode, tuple `{corrupt_log_file, FileName}` is returned if the read chunk is\ncorrupt.\n\n`chunk/3` returns `eof` when the end of the log is reached, or `{error, Reason}`\nif an error occurs. If a wrap log file is missing, a message is output on the\nerror log.\n\nWhen [`chunk/2,3`](`chunk/3`) is used with wrap logs, the returned continuation might not be\nvalid in the next call to `chunk/3`. This is because the log can wrap and delete\nthe file into which the continuation points. To prevent this, the log can be\nblocked during the search.","ref":"disk_log.html#chunk/3"},{"type":"type","title":"disk_log.chunk_error_rsn/0","doc":"","ref":"disk_log.html#t:chunk_error_rsn/0"},{"type":"function","title":"disk_log.chunk_info/1","doc":"Returns the pair `{node, Node}`, describing the chunk continuation returned by\n`chunk/2,3`, [`bchunk/2,3`](`bchunk/3`), or [`chunk_step/3`](`chunk_step/3`).\n\nTerms are read from the disk log running on `Node`.","ref":"disk_log.html#chunk_info/1"},{"type":"type","title":"disk_log.chunk_ret/0","doc":"","ref":"disk_log.html#t:chunk_ret/0"},{"type":"function","title":"disk_log.chunk_step/3","doc":"Can be used with [`chunk/2,3`](`chunk/3`) and [`bchunk/2,3`](`chunk/3`) to\nsearch through an internally formatted wrap log.\n\nIt takes as argument a continuation as returned by [`chunk/2,3`](`chunk/3`),\n[`bchunk/2,3`](`bchunk/3`), or [`chunk_step/3`](`chunk_step/3`), and steps\nforward (or backward) `Step` files in the wrap log. The continuation returned,\npoints to the first log item in the new current file.\n\nIf atom `start` is specified as continuation, the first file of the wrap log is\nchosen as the new current file.\n\nIf the wrap log is not full because all files are not yet used,\n`{error, end_of_log}` is returned if trying to step outside the log.","ref":"disk_log.html#chunk_step/3"},{"type":"function","title":"disk_log.close/1","doc":"Closes a disk log properly.\n\nAn internally formatted log must be closed before the Erlang system is stopped.\nOtherwise, the log is regarded as unclosed and the automatic repair procedure is\nactivated next time the log is opened.\n\nThe disk log process is not terminated as long as there are owners or users of\nthe log. All owners must close the log, possibly by terminating. Also, any other\nprocess, not only the processes that have opened the log anonymously, can\ndecrement the `users` counter by closing the log. Attempts to close a log by a\nprocess that is not an owner are ignored if there are no users.\n\nIf the log is blocked by the closing process, the log is also unblocked.","ref":"disk_log.html#close/1"},{"type":"type","title":"disk_log.close_error_rsn/0","doc":"","ref":"disk_log.html#t:close_error_rsn/0"},{"type":"opaque","title":"disk_log.continuation/0","doc":"Chunk continuation returned by [`chunk/2,3`](`chunk/3`),\n[`bchunk/2,3`](`bchunk/3`), or [`chunk_step/3`](`chunk_step/3`).","ref":"disk_log.html#t:continuation/0"},{"type":"type","title":"disk_log.dlog_format/0","doc":"","ref":"disk_log.html#t:dlog_format/0"},{"type":"type","title":"disk_log.dlog_head_opt/0","doc":"","ref":"disk_log.html#t:dlog_head_opt/0"},{"type":"type","title":"disk_log.dlog_info/0","doc":"","ref":"disk_log.html#t:dlog_info/0"},{"type":"type","title":"disk_log.dlog_mode/0","doc":"","ref":"disk_log.html#t:dlog_mode/0"},{"type":"type","title":"disk_log.dlog_optattr/0","doc":"","ref":"disk_log.html#t:dlog_optattr/0"},{"type":"type","title":"disk_log.dlog_option/0","doc":"","ref":"disk_log.html#t:dlog_option/0"},{"type":"type","title":"disk_log.dlog_options/0","doc":"","ref":"disk_log.html#t:dlog_options/0"},{"type":"type","title":"disk_log.dlog_size/0","doc":"","ref":"disk_log.html#t:dlog_size/0"},{"type":"type","title":"disk_log.dlog_type/0","doc":"","ref":"disk_log.html#t:dlog_type/0"},{"type":"type","title":"disk_log.file_error/0","doc":"","ref":"disk_log.html#t:file_error/0"},{"type":"function","title":"disk_log.format_error/1","doc":"Given the error returned by any function in this module, this function returns a\ndescriptive string of the error in English.\n\nFor file errors, function [`format_error/1`](`format_error/1`) in module\n[`file`](`file:format_error/1`) is called.","ref":"disk_log.html#format_error/1"},{"type":"type","title":"disk_log.inc_wrap_error_rsn/0","doc":"","ref":"disk_log.html#t:inc_wrap_error_rsn/0"},{"type":"function","title":"disk_log.inc_wrap_file/1","doc":"Forces the internally formatted disk log to start logging to the next log file.\nIt can be used, for example, with [`change_size/2`](`change_size/2`) to reduce\nthe amount of disk space allocated by the disk log.\n\nOwners subscribing to notifications normally receive a `wrap` message, but if an\nerror occurs with a reason tag of `invalid_header` or `file_error`, an\n`error_status` message is sent.","ref":"disk_log.html#inc_wrap_file/1"},{"type":"function","title":"disk_log.info/1","doc":"Returns a list of `{Tag, Value}` pairs describing a log running on the node.\n\nThe following pairs are returned for all logs:\n\n- **`{name, Log}`** - `Log` is the log name as specified by the\n  [`open/1`](`open/1`) option `name`.\n\n- **`{file, File}`** - For halt logs `File` is the filename, and for wrap logs\n  `File` is the base name.\n\n- **`{type, Type}`** - `Type` is the log type as specified by the\n  [`open/1`](`open/1`) option `type`.\n\n- **`{format, Format}`** - `Format` is the log format as specified by the\n  [`open/1`](`open/1`) option `format`.\n\n- **`{size, Size}`** - `Size` is the log size as specified by the\n  [`open/1`](`open/1`) option `size`, or the size set by\n  [`change_size/2`](`change_size/2`). The value set by\n  [`change_size/2`](`change_size/2`) is reflected immediately.\n\n- **`{mode, Mode}`** - `Mode` is the log mode as specified by the\n  [`open/1`](`open/1`) option `mode`.\n\n- **`{owners, [{pid(), Notify}]}`** - `Notify` is the value set by the\n  [`open/1`](`open/1`) option `notify` or function\n  [`change_notify/3`](`change_notify/3`) for the owners of the log.\n\n- **`{users, Users}`** - `Users` is the number of anonymous users of the log,\n  see the [`open/1`](`open/1`) option [`linkto`](`m:disk_log#linkto`).\n\n- **`{status, Status}`** - `Status` is `ok` or `{blocked, QueueLogRecords}` as\n  set by functions `block/1,2` and [`unblock/1`](`unblock/1`).\n\n- **`{node, Node}`** - The information returned by the current invocation of\n  function [`info/1`](`info/1`) is gathered from the disk log process running on\n  `Node`.\n\nThe following pairs are returned for all logs opened in `read_write` mode:\n\n- **`{head, Head}`** - Depending on the value of the [`open/1`](`open/1`)\n  options `head` and `head_func`, or set by function\n  [`change_header/2`](`change_header/2`), the value of `Head` is `none`\n  (default), `{head, H}` (`head` option), or `{M,F,A}` (`head_func` option).\n\n- **`{no_written_items, NoWrittenItems}`** - `NoWrittenItems` is the number of\n  items written to the log since the disk log process was created.\n\nThe following pair is returned for halt logs opened in `read_write` mode:\n\n- **`{full, Full}`** - `Full` is `true` or `false` depending on whether the halt\n  log is full or not.\n\nThe following pairs are returned for wrap logs opened in `read_write` mode:\n\n- **`{no_current_bytes, integer() >= 0}`** - The number of bytes written to the\n  current wrap log file.\n\n- **`{no_current_items, integer() >= 0}`** - The number of items written to the\n  current wrap log file, header inclusive.\n\n- **`{no_items, integer() >= 0}`** - The total number of items in all wrap log\n  files.\n\n- **`{current_file, integer()}`** - The ordinal for the current wrap log file in\n  the range `1..MaxNoFiles`, where `MaxNoFiles` is specified by the\n  [`open/1`](`open/1`) option `size` or set by\n  [`change_size/2`](`change_size/2`).\n\n- **`{no_overflows, {SinceLogWasOpened, SinceLastInfo}}`** - `SinceLogWasOpened`\n  (`SinceLastInfo`) is the number of times a wrap log file has been filled up\n  and a new one is opened or [`inc_wrap_file/1`](`inc_wrap_file/1`) has been\n  called since the disk log was last opened ([`info/1`](`info/1`) was last\n  called). The first time `info/2` is called after a log was (re)opened or\n  truncated, the two values are equal.\n\nNotice that functions [`chunk/2,3`](`chunk/3`), [`bchunk/2,3`](`bchunk/3`), and\n[`chunk_step/3`](`chunk_step/3`) do not affect any value returned by\n[`info/1`](`info/1`).","ref":"disk_log.html#info/1"},{"type":"type","title":"disk_log.invalid_header/0","doc":"","ref":"disk_log.html#t:invalid_header/0"},{"type":"type","title":"disk_log.log/0","doc":"","ref":"disk_log.html#t:log/0"},{"type":"function","title":"disk_log.log/2","doc":"Synchronously appends a term to a internally formatted disk log. Returns `ok`\nor `{error, Reason}` when the term is written to disk.\n\nTerms are written by the ordinary `write()` function of the operating system.\nHence, it is not guaranteed that the term is written to disk, it can linger in\nthe operating system kernel for a while. To ensure that the item is written to disk,\nfunction `sync/1` must be called.\n\nOwners subscribing to notifications are notified of an error with an\n`error_status` message if the error reason tag is `invalid_header` or\n`file_error`.","ref":"disk_log.html#log/2"},{"type":"type","title":"disk_log.log_error_rsn/0","doc":"","ref":"disk_log.html#t:log_error_rsn/0"},{"type":"function","title":"disk_log.log_terms/2","doc":"Synchronously appends a list of items to an internally formatted log.\n\nIt is more efficient to use this functions instead of [`log/2`](`log/2`). The specified\nlist is split into as large sublists as possible (limited by the size of wrap log files),\nand each sublist is logged as one single item, which reduces the overhead.\n\nOwners subscribing to notifications are notified of an error with an\n`error_status` message if the error reason tag is `invalid_header` or\n`file_error`.","ref":"disk_log.html#log_terms/2"},{"type":"function","title":"disk_log.next_file/1","doc":"For wrap logs, it forces the disk log to start logging to the next log file. It\ncan be used, for example, with [`change_size/2`](`change_size/2`) to reduce the\namount of disk space allocated by the disk log.\n\nOwners subscribing to notifications normally receive a `wrap` message, but if an\nerror occurs with a reason tag of `invalid_header` or `file_error`, an\n`error_status` message is sent.\n\nFor rotate logs, it forces rotation of the currently active log file, compresses\nit and opens a new active file for logging.","ref":"disk_log.html#next_file/1"},{"type":"type","title":"disk_log.next_file_error_rsn/0","doc":"","ref":"disk_log.html#t:next_file_error_rsn/0"},{"type":"type","title":"disk_log.notify_ret/0","doc":"","ref":"disk_log.html#t:notify_ret/0"},{"type":"function","title":"disk_log.open/1","doc":"Open a new disk_log file for reading or writing.\n\nParameter `ArgL` is a list of the following options:\n\n- **`{name, Log}`** - Specifies the log name. This name must be passed on as a\n  parameter in all subsequent logging operations. A name must always be\n  supplied.\n\n- **`{file, FileName}`** - Specifies the name of the file to be used for logged\n  terms. If this value is omitted and the log name is an atom or a string, the\n  filename defaults to `lists:concat([Log, \".LOG\"])` for halt logs.\n\n  For wrap logs, this is the base name of the files. Each file in a wrap log is\n  called ` .N`, where `N` is an integer. Each wrap log also has two\n  files called ` .idx` and ` .siz`.\n\n  For rotate logs, this is the name of the active log file. The compressed files\n  are named as ` .N.gz`, where `N` is an integer and ` .0.gz`\n  is the latest compressed log file. All the compressed files are renamed at\n  each rotation so that the latest files have the smallest index. The maximum\n  value for N is the value of `MaxNoFiles` minus 1.\n\n- **`{linkto, LinkTo}`[](){: #linkto } **  \n   If `LinkTo` is a pid, it becomes an owner of the log. If `LinkTo` is `none`, the\n  log records that it is used anonymously by some process by incrementing the `users`\n  counter. By default, the process that calls [`open/1`](`open/1`) owns the log.\n\n- **`{repair, Repair}`** - If `Repair` is `true`, the current log file is\n  repaired, if needed. As the restoration is initiated, a message is output on\n  the error log. If `false` is specified, no automatic repair is attempted.\n  Instead, the tuple `{error, {need_repair, Log}}` is returned if an attempt is\n  made to open a corrupt log file. If `truncate` is specified, the log file\n  becomes truncated, creating an empty log, regardless of previous content.\n  Defaults to `true`, which has no effect on logs opened in read-only mode.\n\n- **`{type, Type}`** - The log type. Defaults to `halt`.\n\n- **`{format, Format}`** - Disk log format. Defaults to `internal`.\n\n- **`{size, Size}`** - Log size.\n\n  When a halt log has reached its maximum size, all attempts to log more items\n  are rejected. Defaults to `infinity`, which for halt implies that there is no\n  maximum size.\n\n  For wrap and rotate logs, parameter `Size` can be a pair\n  `{MaxNoBytes, MaxNoFiles}`. For wrap logs it can also be `infinity`. In the\n  latter case, if the files of an existing wrap log with the same name can be\n  found, the size is read from the existing wrap log, otherwise an error is\n  returned.\n\n  Wrap logs write at most `MaxNoBytes` bytes on each file and use `MaxNoFiles`\n  files before starting all over with the first wrap log file. Regardless of\n  `MaxNoBytes`, at least the header (if there is one) and one item are written\n  on each wrap log file before wrapping to the next file.\n\n  The first time an existing wrap log is opened, that is, when the disk log\n  process is created, the value of the option `size` is allowed to differ from\n  the current log size, and the size of the disk log is changed as per\n  `change_size/2`.\n\n  When opening an existing wrap log, it is not necessary to supply a value for\n  option `size`, but if the log is already open, that is, the disk log process\n  exists, the supplied value must equal the current log size, otherwise the\n  tuple `{error, {size_mismatch, CurrentSize, NewSize}}` is returned.\n\n  > #### Note {: .info }\n  >\n  > Before Erlang/OTP 24.0, the supplied value of option `size` was to be equal\n  > to the current log size when opening an existing wrap log for the first\n  > time, that is, when creating the disk log process.\n\n  Rotate logs write at most `MaxNoBytes` bytes on the active log file and keep\n  the latest `MaxNoFiles` compressed files. Regardless of `MaxNoBytes`, at least\n  the header (if there is one) and one item are written on each rotate log file\n  before rotation.\n\n  When opening an already open halt log, option `size` is ignored.\n\n- **`{notify, boolean()}`**{: #notify } - If `true`, the log owners are notified\n  when certain log events occur. Defaults to `false`. The owners are sent one of the\n  following messages when an event occurs:\n\n  - **`{disk_log, Node, Log, {wrap, NoLostItems}}`** - Sent when a wrap log has\n    filled up one of its files and a new file is opened. `NoLostItems` is the\n    number of previously logged items that were lost when truncating existing\n    files.\n\n  - **`{disk_log, Node, Log, {truncated, NoLostItems}}`** - Sent when a log is\n    truncated or reopened. For halt logs `NoLostItems` is the number of items\n    written on the log since the disk log process was created. For wrap logs\n    `NoLostItems` is the number of items on all wrap log files.\n\n  - **`{disk_log, Node, Log, {read_only, Items}}`** - Sent when an asynchronous\n    log attempt is made to a log file opened in read-only mode. `Items` is the\n    items from the log attempt.\n\n  - **`{disk_log, Node, Log, {blocked_log, Items}}`** - Sent when an\n    asynchronous log attempt is made to a blocked log that does not queue log\n    attempts. `Items` is the items from the log attempt.\n\n  - **`{disk_log, Node, Log, {format_external, Items}}`** - Sent when function\n    [`alog/2`](`alog/2`) or [`alog_terms/2`](`alog_terms/2`) is used for\n    internally formatted logs. `Items` is the items from the log attempt.\n\n  - **`{disk_log, Node, Log, full}`** - Sent when an attempt to log items to a\n    wrap log would write more bytes than the limit set by option `size`.\n\n  - **`{disk_log, Node, Log, {error_status, Status}}`** - Sent when the error\n    status changes. The error status is defined by the outcome of the last\n    attempt to log items to the log, or to truncate the log, or the last use of\n    function [`sync/1`](`sync/1`), [`inc_wrap_file/1`](`inc_wrap_file/1`), or\n    [`change_size/2`](`change_size/2`). `Status` is either `ok` or\n    `{error, Error}`, the former is the initial value.\n\n- **`{head, Head}`** - Specifies a header to be written first on the log file.\n  If the log is a wrap or rotate log, the item `Head` is written first in each\n  new file. `Head` is to be a term if the format is `internal`, otherwise an\n  `t:iodata/0`. Defaults to `none`, which means that no header is written first\n  on the file.\n\n- **`{head_func, {M,F,A}}`** - Specifies a function to be called each time a new\n  log file is opened. The call `M:F(A)` is assumed to return `{ok, Head}`. The\n  item `Head` is written first in each file. `Head` is to be a term if the\n  format is `internal`, otherwise an `t:iodata/0`.\n\n- **`{mode, Mode}`** - Specifies if the log is to be opened in read-only or\n  read-write mode. Defaults to `read_write`.\n\n- **`{quiet, Boolean}`** - Specifies if messages will be sent to `error_logger`\n  on recoverable errors with the log files. Defaults to `false`.\n\n[`open/1`](`open/1`) returns `{ok, Log}` if the log file is successfully opened.\nIf the file is successfully repaired, the tuple\n`{repaired, Log, {recovered, Rec}, {badbytes, Bad}}` is returned, where `Rec` is\nthe number of whole Erlang terms found in the file and `Bad` is the number of\nbytes in the file that are non-Erlang terms.\n\nWhen a disk log is opened in read-write mode, any existing log file is checked\nfor. If there is none, a new empty log is created, otherwise the existing file\nis opened at the position after the last logged item, and the logging of items\nstarts from there. If the format is `internal` and the existing file is not\nrecognized as an internally formatted log, a tuple\n`{error, {not_a_log_file, FileName}}` is returned.\n\n[`open/1`](`open/1`) cannot be used for changing the values of options of an\nopen log. When there are prior owners or users of a log, all option values\nexcept `name`, `linkto`, and `notify` are only checked against the values\nsupplied before as option values to function [`open/1`](`open/1`),\n[`change_header/2`](`change_header/2`), [`change_notify/3`](`change_notify/3`),\nor [`change_size/2`](`change_size/2`). Thus, none of the options except `name`\nis mandatory. If some specified value differs from the current value, a tuple\n`{error, {arg_mismatch, OptionName, CurrentValue, Value}}` is returned.\n\n> #### Note {: .info }\n>\n> If an owner attempts to open a log as owner once again, it is acknowledged\n> with the return value `{ok, Log}`, but the state of the disk log is not\n> affected.\n\nA log file can be opened more than once by giving different values to option\n`name` or by using the same file when opening a log on different nodes. It is up\nto the user of module `disk_log` to ensure that not more than one disk log\nprocess has write access to any file, otherwise the file can be corrupted.\n\nIf an attempt to open a log file for the first time fails, the disk log process\nterminates with the EXIT message `{{failed,Reason},[{disk_log,open,1}]}`. The\nfunction returns `{error, Reason}` for all other errors.","ref":"disk_log.html#open/1"},{"type":"type","title":"disk_log.open_error_rsn/0","doc":"","ref":"disk_log.html#t:open_error_rsn/0"},{"type":"type","title":"disk_log.open_ret/0","doc":"","ref":"disk_log.html#t:open_ret/0"},{"type":"function","title":"disk_log.pid2name/1","doc":"Returns the log name given the pid of a disk log process on the current node, or\n`undefined` if the specified pid is not a disk log process.\n\nThis function is meant to be used for debugging only.","ref":"disk_log.html#pid2name/1"},{"type":"function","title":"disk_log.reopen/2","doc":"Equivalent to [`reopen(Log, File, Head)`](`reopen/3`) where `Head` is\nthe `Head` specified in `open/1`.","ref":"disk_log.html#reopen/2"},{"type":"function","title":"disk_log.reopen/3","doc":"Renames an internally formatted log file to `File` and then recreates a new log file. If a\nwrap/rotate log exists, `File` is used as the base name of the renamed files.\n\nWrites the value of `Head` first in the newly opened log file. The header argument\nis used only once. Next time a wrap/rotate log file is opened, the header given to\n[`open/1`](`open/1`) is used.\n\nOwners subscribing to notifications receive a `truncate` message.\n\nUpon failure to reopen the log, the disk log process terminates with the EXIT\nmessage `{{failed,Error},[{disk_log,Fun,Arity}]}`. Other processes having\nrequests queued receive the message\n`{disk_log, Node, {error, disk_log_stopped}}`.","ref":"disk_log.html#reopen/3"},{"type":"type","title":"disk_log.reopen_error_rsn/0","doc":"","ref":"disk_log.html#t:reopen_error_rsn/0"},{"type":"function","title":"disk_log.sync/1","doc":"Ensures that the contents of the log are written to the disk. This is usually a\nrather expensive operation.","ref":"disk_log.html#sync/1"},{"type":"type","title":"disk_log.sync_error_rsn/0","doc":"","ref":"disk_log.html#t:sync_error_rsn/0"},{"type":"type","title":"disk_log.trunc_error_rsn/0","doc":"","ref":"disk_log.html#t:trunc_error_rsn/0"},{"type":"function","title":"disk_log.truncate/1","doc":"Equivalent to [`truncate(Log, Head)`](`truncate/2`) where `Head` is\nthe `Head` specified in `open/1`.\n\nThis function can be used for both internally and externally\nformatted logs.","ref":"disk_log.html#truncate/1"},{"type":"function","title":"disk_log.truncate/2","doc":"Removes all items from an internally formatted disk log. The argument `Head` or\nis written first in the newly truncated log.\n\nThe header argument is used only once. Next time a wrap/rotate log file is opened,\nthe header given to [`open/1`](`open/1`) is used.\n\nOwners subscribing to notifications receive a `truncate` message.\n\nIf the attempt to truncate the log fails, the disk log process terminates with\nthe EXIT message `{{failed,Reason},[{disk_log,Fun,Arity}]}`. Other processes\nhaving requests queued receive the message\n`{disk_log, Node, {error, disk_log_stopped}}`.","ref":"disk_log.html#truncate/2"},{"type":"function","title":"disk_log.unblock/1","doc":"Unblocks a log. A log can only be unblocked by the blocking process.","ref":"disk_log.html#unblock/1"},{"type":"type","title":"disk_log.unblock_error_rsn/0","doc":"","ref":"disk_log.html#t:unblock_error_rsn/0"},{"type":"module","title":"error_logger","doc":"Erlang error logger.\n\n> #### Note {: .info }\n>\n> In Erlang/OTP 21.0, a new API for logging was added. The old `m:error_logger`\n> module can still be used by legacy code, but log events are redirected to the\n> new Logger API. New code should use the Logger API directly.\n>\n> `m:error_logger` is no longer started by default, but is automatically started\n> when an event handler is added with [`error_logger:add_report_handler/1,2`](`error_logger:add_report_handler/2`). The\n> `m:error_logger` module is then also added as a handler to the new logger.\n>\n> See `m:logger` and the [Logging](logger_chapter.md) chapter in the User's\n> Guide for more information.\n\nThe Erlang _error logger_ is an event manager (see\n[OTP Design Principles](`e:system:design_principles.md`) and `m:gen_event`),\nregistered as `m:error_logger`.\n\nError logger is no longer started by default, but is automatically started when\nan event handler is added with\n[`add_report_handler/1,2`](`add_report_handler/1`). The `m:error_logger` module is\nthen also added as a handler to the new logger, causing log events to be\nforwarded from logger to error logger, and consequently to all installed error\nlogger event handlers.\n\nUser-defined event handlers can be added to handle application-specific events.\n\nExisting event handlers provided by STDLIB and SASL are still available, but are\nno longer used by OTP.\n\nWarning events were introduced in Erlang/OTP R9C and are enabled by default as\nfrom Erlang/OTP 18.0. To retain backwards compatibility with existing\nuser-defined event handlers, the warning events can be tagged as `errors` or\n`info` using command-line flag `+W  `, thus showing up as\n`ERROR REPORT` or `INFO REPORT` in the logs.\n\n[](){: #events }","ref":"error_logger.html"},{"type":"module","title":"Events - error_logger","doc":"All event handlers added to the error logger must handle the following events.\n`Gleader` is the group leader pid of the process that sent the event, and `Pid`\nis the process that sent the event.\n\n- **`{error, Gleader, {Pid, Format, Data}}`** -\n  Generated when [`error_msg/1,2`](`error_msg/2`) or `format/2` is called.\n\n- **`{error_report, Gleader, {Pid, std_error, Report}}`** -\n  Generated when [`error_report/1`](`error_report/1`) is called.\n\n- **`{error_report, Gleader, {Pid, Type, Report}}`** -\n  Generated when [`error_report/2`](`error_report/2`) is called.\n\n- **`{warning_msg, Gleader, {Pid, Format, Data}}`** -\n  Generated when [`warning_msg/1,2`](`warning_msg/2`) is called if warnings are set to\n  be tagged as warnings.\n\n- **`{warning_report, Gleader, {Pid, std_warning, Report}}`** -\n  Generated when [`warning_report/1`](`warning_report/1`) is called if warnings are\n  set to be tagged as warnings.\n\n- **`{warning_report, Gleader, {Pid, Type, Report}}`** - Generated when\n  [`warning_report/2`](`warning_report/2`) is called if warnings are set to be\n  tagged as warnings.\n\n- **`{info_msg, Gleader, {Pid, Format, Data}}`** -\n  Generated when [`info_msg/1,2`](`info_msg/2`) is called.\n\n- **`{info_report, Gleader, {Pid, std_info, Report}}`** -\n  Generated when [`info_report/1`](`info_report/1`) is called.\n\n- **`{info_report, Gleader, {Pid, Type, Report}}`** -\n  Generated when [`info_report/2`](`info_report/2`) is called.\n\nNotice that some system-internal events can also be received. Therefore a\ncatch-all clause last in the definition of the event handler callback function\n`c:gen_event:handle_event/2` is necessary. This also applies for\n`c:gen_event:handle_info/2`, as the event handler must also take care of some\nsystem-internal messages.","ref":"error_logger.html#module-events"},{"type":"module","title":"See Also - error_logger","doc":"`m:gen_event`, `m:logger`, `m:log_mf_h`, [`kernel`](kernel_app.md),\n[`sasl`](`e:sasl:sasl_app.md`)","ref":"error_logger.html#module-see-also"},{"type":"function","title":"error_logger.add_report_handler/1","doc":"Equivalent to  add_report_handler(Handler, []) .","ref":"error_logger.html#add_report_handler/1"},{"type":"function","title":"error_logger.add_report_handler/2","doc":"Adds a new event handler to the error logger. The event handler must be\nimplemented as a `m:gen_event` callback module.\n\n`Handler` is typically the name of the callback module and `Args` is an optional\nterm (defaults to []) passed to the initialization callback function\n`c:gen_event:init/1`. The function returns `ok` if successful.\n\nThe event handler must be able to handle the events in this module, see section\n[Events](`m:error_logger#module-events`).\n\nThe first time this function is called, `m:error_logger` is added as a Logger\nhandler, and the `m:error_logger` process is started.","ref":"error_logger.html#add_report_handler/2"},{"type":"function","title":"error_logger.delete_report_handler/1","doc":"Deletes an event handler from the error logger by calling\n[`gen_event:delete_handler(error_logger, Handler, [])`](`gen_event:delete_handler/3`).\n\nIf no more event handlers exist after the deletion, `m:error_logger` is removed as\na Logger handler, and the `m:error_logger` process is stopped.","ref":"error_logger.html#delete_report_handler/1"},{"type":"function","title":"error_logger.error_msg/1","doc":"Equivalent to  error_msg(Format, []) .","ref":"error_logger.html#error_msg/1"},{"type":"function","title":"error_logger.error_msg/2","doc":"Log a standard error event. The `Format` and `Data` arguments are the same as\nthe arguments of `io:format/2` in STDLIB.\n\nError logger forwards the event to Logger, including metadata that allows\nbackwards compatibility with legacy error logger event handlers.\n\nThe event is handled by the default Logger handler.\n\nThis function is kept for backwards compatibility and must not be used by new\ncode. Use the [`?LOG_ERROR`](`m:logger#module-macros`) macro or\n[`logger:error/1,2,3`](`logger:error/1`) instead.\n\n_Example:_\n\n```text\n1> error_logger:error_msg(\"An error occurred in ~p\", [a_module]).\n=ERROR REPORT==== 22-May-2018::11:18:43.376917 ===\nAn error occurred in a_module\nok\n```\n\n> #### Warning {: .warning }\n>\n> If the Unicode translation modifier (`t`) is used in the format string, all\n> event handlers must ensure that the formatted output is correctly encoded for\n> the I/O device.","ref":"error_logger.html#error_msg/2"},{"type":"function","title":"error_logger.error_report/1","doc":"Log a standard error event. Error logger forwards the event to Logger, including\nmetadata that allows backwards compatibility with legacy error logger event\nhandlers.\n\nThe event is handled by the default Logger handler.\n\nThis functions is kept for backwards compatibility and must not be used by new\ncode. Use the [`?LOG_ERROR`](`m:logger#module-macros`) macro or\n[`logger:error/1,2,3`](`logger:error/1`) instead.\n\n_Example:_\n\n```text\n2> error_logger:error_report([{tag1,data1},a_term,{tag2,data}]).\n=ERROR REPORT==== 22-May-2018::11:24:23.699306 ===\n    tag1: data1\n    a_term\n    tag2: data\nok\n3> error_logger:error_report(\"Serious error in my module\").\n=ERROR REPORT==== 22-May-2018::11:24:45.972445 ===\nSerious error in my module\nok\n```","ref":"error_logger.html#error_report/1"},{"type":"function","title":"error_logger.error_report/2","doc":"Log a user-defined error event. Error logger forwards the event to Logger,\nincluding metadata that allows backwards compatibility with legacy error logger\nevent handlers.\n\nError logger also adds a `domain` field with value `[Type]` to this event's\nmetadata, causing the filters of the default Logger handler to discard the\nevent. A different Logger handler, or an error logger event handler, must be\nadded to handle this event.\n\nIt is recommended that `Report` follows the same structure as for\n`error_report/1`.\n\nThis functions is kept for backwards compatibility and must not be used by new\ncode. Use the [`?LOG_ERROR`](`m:logger#module-macros`) macro or\n[`logger:error/1,2,3`](`logger:error/1`) instead.","ref":"error_logger.html#error_report/2"},{"type":"function","title":"error_logger.format/2","doc":"Equivalent to  error_msg(Format, Data) .","ref":"error_logger.html#format/2"},{"type":"function","title":"error_logger.get_format_depth/0","doc":"Returns [`max(10, Depth)`](`max/2`), where `Depth` is the value of\n[`error_logger_format_depth`](kernel_app.md#error_logger_format_depth) in the\nKernel application, if Depth is an integer. Otherwise, `unlimited` is returned.\n\n> #### Note {: .info }\n>\n> The [`error_logger_format_depth`](kernel_app.md#error_logger_format_depth) variable is\n> [deprecated](kernel_app.md#deprecated-configuration-parameters) since the\n> [Logger API](`m:logger`) was introduced in Erlang/OTP 21.0. The variable, and\n> this function, are kept for backwards compatibility since they still might be\n> used by legacy report handlers.","ref":"error_logger.html#get_format_depth/0"},{"type":"function","title":"error_logger.info_msg/1","doc":"Equivalent to  info_msg(Format, []) .","ref":"error_logger.html#info_msg/1"},{"type":"function","title":"error_logger.info_msg/2","doc":"Log a standard information event. The `Format` and `Data` arguments are the same\nas the arguments of `io:format/2` in STDLIB.\n\nError logger forwards the event to Logger, including metadata that allows\nbackwards compatibility with legacy error logger event handlers.\n\nThe event is handled by the default Logger handler.\n\nThese functions are kept for backwards compatibility and must not be used by new\ncode. Use the [`?LOG_INFO`](`m:logger#module-macros`) macro or\n[`logger:info/1,2,3`](`logger:info/1`) instead.\n\n_Example:_\n\n```text\n1> error_logger:info_msg(\"Something happened in ~p\", [a_module]).\n=INFO REPORT==== 22-May-2018::12:03:32.612462 ===\nSomething happened in a_module\nok\n```\n\n> #### Warning {: .warning }\n>\n> If the Unicode translation modifier (`t`) is used in the format string, all\n> event handlers must ensure that the formatted output is correctly encoded for\n> the I/O device.","ref":"error_logger.html#info_msg/2"},{"type":"function","title":"error_logger.info_report/1","doc":"Log a standard information event. Error logger forwards the event to Logger,\nincluding metadata that allows backwards compatibility with legacy error logger\nevent handlers.\n\nThe event is handled by the default Logger handler.\n\nThis functions is kept for backwards compatibility and must not be used by new\ncode. Use the [`?LOG_INFO`](`m:logger#module-macros`) macro or\n[`logger:info/1,2,3`](`logger:info/1`) instead.\n\n_Example:_\n\n```text\n2> error_logger:info_report([{tag1,data1},a_term,{tag2,data}]).\n=INFO REPORT==== 22-May-2018::12:06:35.994440 ===\n    tag1: data1\n    a_term\n    tag2: data\nok\n3> error_logger:info_report(\"Something strange happened\").\n=INFO REPORT==== 22-May-2018::12:06:49.066872 ===\nSomething strange happened\nok\n```","ref":"error_logger.html#info_report/1"},{"type":"function","title":"error_logger.info_report/2","doc":"Log a user-defined information event. Error logger forwards the event to Logger,\nincluding metadata that allows backwards compatibility with legacy error logger\nevent handlers.\n\nError logger also adds a `domain` field with value `[Type]` to this event's\nmetadata, causing the filters of the default Logger handler to discard the\nevent. A different Logger handler, or an error logger event handler, must be\nadded to handle this event.\n\nIt is recommended that `Report` follows the same structure as for\n`info_report/1`.\n\nThis functions is kept for backwards compatibility and must not be used by new\ncode. Use the [`?LOG_INFO`](`m:logger#module-macros`) macro or\n[`logger:info/1,2,3`](`logger:info/1`) instead.","ref":"error_logger.html#info_report/2"},{"type":"function","title":"error_logger.logfile/1","doc":"Enables or disables printout of standard events to a file.\n\nThis is done by adding or deleting the `error_logger_file_h` event handler, and\nthus indirectly adding `m:error_logger` as a Logger handler.\n\nNotice that this function does not manipulate the Logger configuration directly,\nmeaning that if the default Logger handler is already logging to a file, this\nfunction can potentially cause logging to a second file.\n\nThis function is useful as a shortcut during development and testing, but must\nnot be used in a production system. See section [Logging](logger_chapter.md) in\nthe Kernel User's Guide, and the `m:logger` manual page for information about\nhow to configure Logger for live systems.\n\n`Request` is one of the following:\n\n- **`{open, Filename}`** - Opens log file `Filename`. Returns `ok` if\n  successful, or `{error, allready_have_logfile}` if logging to file is already\n  enabled, or an error tuple if another error occurred (for example, if\n  `Filename` cannot be opened). The file is opened with encoding UTF-8.\n\n- **`close`** - Closes the current log file. Returns `ok`, or\n  `{error, module_not_found}`.\n\n- **`filename`** - Returns the name of the log file `Filename`, or\n  `{error, no_log_file}` if logging to file is not enabled.","ref":"error_logger.html#logfile/1"},{"type":"type","title":"error_logger.open_error/0","doc":"","ref":"error_logger.html#t:open_error/0"},{"type":"type","title":"error_logger.report/0","doc":"","ref":"error_logger.html#t:report/0"},{"type":"function","title":"error_logger.tty/1","doc":"Enables (`Flag == true`) or disables (`Flag == false`) printout of standard\nevents to the terminal.\n\nThis is done by manipulating the Logger configuration. The function is useful as\na shortcut during development and testing, but must not be used in a production\nsystem. See section [Logging](logger_chapter.md) in the Kernel User's Guide, and\nthe `m:logger` manual page for information about how to configure Logger for\nlive systems.","ref":"error_logger.html#tty/1"},{"type":"function","title":"error_logger.warning_map/0","doc":"Returns the current mapping for warning events.\n\nEvents sent using [`warning_msg/1,2`](`warning_msg/2`) or\n[`warning_report/1,2`](`warning_report/2`) are tagged as errors, warnings\n(default), or info, depending on the value of command-line flag `+W`.\n\n_Example:_\n\n```text\nos$ erl\nErlang (BEAM) emulator version 5.4.8 [hipe] [threads:0] [kernel-poll]\n\nEshell V5.4.8  (abort with ^G)\n1> error_logger:warning_map().\nwarning\n2> error_logger:warning_msg(\"Warnings tagged as: ~p~n\", [warning]).\n\n=WARNING REPORT==== 11-Aug-2005::15:31:55 ===\nWarnings tagged as: warning\nok\n3>\nUser switch command\n --> q\nos$ erl +W e\nErlang (BEAM) emulator version 5.4.8 [hipe] [threads:0] [kernel-poll]\n\nEshell V5.4.8  (abort with ^G)\n1> error_logger:warning_map().\nerror\n2> error_logger:warning_msg(\"Warnings tagged as: ~p~n\", [error]).\n\n=ERROR REPORT==== 11-Aug-2005::15:31:23 ===\nWarnings tagged as: error\nok\n```","ref":"error_logger.html#warning_map/0"},{"type":"function","title":"error_logger.warning_msg/1","doc":"Equivalent to  warning_msg(Format, []) .","ref":"error_logger.html#warning_msg/1"},{"type":"function","title":"error_logger.warning_msg/2","doc":"Log a standard warning event. The `Format` and `Data` arguments are the same as\nthe arguments of `io:format/2` in STDLIB.\n\nError logger forwards the event to Logger, including metadata that allows\nbackwards compatibility with legacy error logger event handlers.\n\nThe event is handled by the default Logger handler. The log level can be changed\nto error or info, see `warning_map/0`.\n\nThese functions are kept for backwards compatibility and must not be used by new\ncode. Use the [`?LOG_WARNING`](`m:logger#module-macros`) macro or\n[`logger:warning/1,2,3`](`logger:warning/1`) instead.\n\n> #### Warning {: .warning }\n>\n> If the Unicode translation modifier (`t`) is used in the format string, all\n> event handlers must ensure that the formatted output is correctly encoded for\n> the I/O device.","ref":"error_logger.html#warning_msg/2"},{"type":"function","title":"error_logger.warning_report/1","doc":"Log a standard warning event. Error logger forwards the event to Logger,\nincluding metadata that allows backwards compatibility with legacy error logger\nevent handlers.\n\nThe event is handled by the default Logger handler. The log level can be changed\nto error or info, see `warning_map/0`.\n\nThis functions is kept for backwards compatibility and must not be used by new\ncode. Use the [`?LOG_WARNING`](`m:logger#module-macros`) macro or\n[`logger:warning/1,2,3`](`logger:warning/1`) instead.","ref":"error_logger.html#warning_report/1"},{"type":"function","title":"error_logger.warning_report/2","doc":"Log a user-defined warning event. Error logger forwards the event to Logger,\nincluding metadata that allows backwards compatibility with legacy error logger\nevent handlers.\n\nError logger also adds a `domain` field with value `[Type]` to this event's\nmetadata, causing the filters of the default Logger handler to discard the\nevent. A different Logger handler, or an error logger event handler, must be\nadded to handle this event.\n\nThe log level can be changed to error or info, see `warning_map/0`.\n\nIt is recommended that `Report` follows the same structure as for\n`warning_report/1`.\n\nThis functions is kept for backwards compatibility and must not be used by new\ncode. Use the [`?LOG_WARNING`](`m:logger#module-macros`) macro or\n[`logger:warning/1,2,3`](`logger:warning/1`) instead.","ref":"error_logger.html#warning_report/2"},{"type":"module","title":"logger","doc":"API module for Logger, the standard logging facility in Erlang/OTP.\n\nThis module implements the main API for logging in Erlang/OTP. To create a log\nevent, use the [API functions](#logging-api-functions) or the log\n[macros](#module-macros), for example:\n\n```erlang\n?LOG_ERROR(\"error happened because: ~p\", [Reason]).   % With macro\nlogger:error(\"error happened because: ~p\", [Reason]). % Without macro\n```\n\nTo configure the Logger backend, use\n[Kernel configuration parameters](kernel_app.md#logger) or\n[configuration functions](#configuration-api-functions) in the Logger API.\n\nBy default, the Kernel application installs one log handler at system start.\nThis handler is named `default`. It receives and processes standard log events\nproduced by the Erlang runtime system, standard behaviours and different\nErlang/OTP applications. The log events are by default printed to the terminal.\n\nIf you want your systems logs to be printed to a file instead, you must\nconfigure the default handler to do so. The simplest way is to include the\nfollowing in your [`sys.config`](config.md):\n\n```erlang\n[{kernel,\n  [{logger,\n    [{handler, default, logger_std_h,\n      #{config => #{file => \"path/to/file.log\"}}}]}]}].\n```\n\nFor more information about:\n\n- the Logger facility in general, see the [User's Guide](logger_chapter.md).\n- how to configure Logger, see the\n  [Configuration](logger_chapter.md#configuration) section in the User's Guide.\n- the built-in handlers, see `m:logger_std_h` and `m:logger_disk_log_h`.\n- the built-in formatter, see `m:logger_formatter`.\n- built-in filters, see `m:logger_filters`.","ref":"logger.html"},{"type":"module","title":"Macros - logger","doc":"The following macros are defined in `logger.hrl`, which is included in a module\nwith the directive\n\n```erlang\n    -include_lib(\"kernel/include/logger.hrl\").\n```\n\n- `?LOG_EMERGENCY(StringOrReport[,Metadata])`\n- `?LOG_EMERGENCY(FunOrFormat,Args[,Metadata])`\n- `?LOG_ALERT(StringOrReport[,Metadata])`\n- `?LOG_ALERT(FunOrFormat,Args[,Metadata])`\n- `?LOG_CRITICAL(StringOrReport[,Metadata])`\n- `?LOG_CRITICAL(FunOrFormat,Args[,Metadata])`\n- `?LOG_ERROR(StringOrReport[,Metadata])`\n- `?LOG_ERROR(FunOrFormat,Args[,Metadata])`\n- `?LOG_WARNING(StringOrReport[,Metadata])`\n- `?LOG_WARNING(FunOrFormat,Args[,Metadata])`\n- `?LOG_NOTICE(StringOrReport[,Metadata])`\n- `?LOG_NOTICE(FunOrFormat,Args[,Metadata])`\n- `?LOG_INFO(StringOrReport[,Metadata])`\n- `?LOG_INFO(FunOrFormat,Args[,Metadata])`\n- `?LOG_DEBUG(StringOrReport[,Metadata])`\n- `?LOG_DEBUG(FunOrFormat,Args[,Metadata])`\n- `?LOG(Level,StringOrReport[,Metadata])`\n- `?LOG(Level,FunOrFormat,Args[,Metadata])`\n\nAll macros expand to a call to Logger, where `Level` is taken from the macro\nname, or from the first argument in the case of the `?LOG` macro. Location data\nis added to the metadata as described under the `t:metadata/0` type definition.\n\nThe call is wrapped in a case statement and will be evaluated only if `Level` is\nequal to or below the configured log level.","ref":"logger.html#module-macros"},{"type":"module","title":"See Also - logger","doc":"[`config`](config.md), `m:erlang`, `m:io`, `m:logger_disk_log_h`,\n`m:logger_filters`, `m:logger_handler`, `m:logger_formatter`, `m:logger_std_h`,\n`m:unicode`","ref":"logger.html#module-see-also"},{"type":"function","title":"logger.add_handler/3","doc":"Add a handler with the given configuration.\n\n`HandlerId` is a unique identifier which must be used in all subsequent calls\nreferring to this handler.","ref":"logger.html#add_handler/3"},{"type":"function","title":"logger.add_handler_filter/3","doc":"Add a filter to the specified handler.\n\nThe filter fun is called with the log event as the first parameter, and the\nspecified `filter_args()` as the second parameter.\n\nThe return value of the fun specifies if a log event is to be discarded or\nforwarded to the handler callback:\n\n- **`t:log_event/0`** - The filter _passed_. The next handler filter, if any, is\n  applied. If no more filters exist for this handler, the log event is forwarded\n  to the handler callback.\n\n- **`stop`** - The filter _did not pass_, and the log event is immediately\n  discarded.\n\n- **`ignore`** - The filter has no knowledge of the log event. The next handler\n  filter, if any, is applied. If no more filters exist for this handler, the\n  value of the `filter_default` configuration parameter for the handler\n  specifies if the log event shall be discarded or forwarded to the handler\n  callback.\n\nSee section [Filters](logger_chapter.md#filters) in the User's Guide for more\ninformation about filters.\n\nSome built-in filters exist. These are defined in `m:logger_filters`.","ref":"logger.html#add_handler_filter/3"},{"type":"function","title":"logger.add_handlers/1","doc":"Reads the application configuration parameter `logger` and calls\n[`add_handlers/1`](`add_handlers/1`) with its contents.\n\nThis function should be used by custom Logger handlers to make configuration\nconsistent no matter which handler the system uses. Normal usage is to add a\ncall to `logger:add_handlers/1` just after the processes that the handler needs\nare started, and pass the application's `logger` configuration as the argument.\nFor example:\n\n```erlang\n-behaviour(application).\nstart(_, []) ->\n    case supervisor:start_link({local, my_sup}, my_sup, []) of\n        {ok, Pid} ->\n            ok = logger:add_handlers(my_app),\n            {ok, Pid, []};\n        Error -> Error\n     end.\n```\n\nThis reads the `logger` configuration parameter from the `my_app` application\nand starts the configured handlers. The contents of the configuration use the\nsame rules as the\n[logger handler configuration](logger_chapter.md#handler-configuration).\n\nIf the handler is meant to replace the default handler, the Kernel's default\nhandler have to be disabled before the new handler is added. A `sys.config` file\nthat disables the Kernel handler and adds a custom handler could look like this:\n\n```erlang\n[{kernel,\n  [{logger,\n    %% Disable the default Kernel handler\n    [{handler, default, undefined}]}]},\n {my_app,\n  [{logger,\n    %% Enable this handler as the default\n    [{handler, default, my_handler, #{}}]}]}].\n```","ref":"logger.html#add_handlers/1"},{"type":"function","title":"logger.add_primary_filter/2","doc":"Add a primary filter to Logger.\n\nThe filter fun is called with the log event as the first parameter, and the\nspecified `filter_args()` as the second parameter.\n\nThe return value of the fun specifies if a log event is to be discarded or\nforwarded to the handlers:\n\n- **`t:log_event/0`** - The filter _passed_. The next primary filter, if any, is\n  applied. If no more primary filters exist, the log event is forwarded to the\n  handler part of Logger, where handler filters are applied.\n\n- **`stop`** - The filter _did not pass_, and the log event is immediately\n  discarded.\n\n- **`ignore`** - The filter has no knowledge of the log event. The next primary\n  filter, if any, is applied. If no more primary filters exist, the value of the\n  primary `filter_default` configuration parameter specifies if the log event\n  shall be discarded or forwarded to the handler part.\n\nSee section [Filters](logger_chapter.md#filters) in the User's Guide for more\ninformation about filters.\n\nSome built-in filters exist. These are defined in `m:logger_filters`.","ref":"logger.html#add_primary_filter/2"},{"type":"function","title":"logger.alert/1","doc":"Equivalent to  alert(StringOrReport, #{}) .","ref":"logger.html#alert/1"},{"type":"function","title":"logger.alert/2","doc":"Create a alert log event.\n\nEquivalent to [`log(alert, StringOrReport, Metadata)`](`log/3`) if called\nas [`alert(StringOrReport, Metadata)`](`alert/2`).\n\nEquivalent to [`alert(FormatOrFun, Args, #{})`](`alert/3`) if called as\n[`alert(FormatOrFun, Args)`](`alert/2`).","ref":"logger.html#alert/2"},{"type":"function","title":"logger.alert/3","doc":"Equivalent to  log(alert, FormatOrFun, Args, Metadata) .","ref":"logger.html#alert/3"},{"type":"function","title":"logger.compare_levels/2","doc":"Compare the severity of two log levels. Returns `gt` if `Level1` is more severe\nthan `Level2`, `lt` if `Level1` is less severe, and `eq` if the levels are\nequal.","ref":"logger.html#compare_levels/2"},{"type":"type","title":"logger.config_handler/0","doc":"Configuration used when adding or updating a handler.","ref":"logger.html#t:config_handler/0"},{"type":"function","title":"logger.critical/1","doc":"Equivalent to  critical(StringOrReport, #{}) .","ref":"logger.html#critical/1"},{"type":"function","title":"logger.critical/2","doc":"Create a critical log event.\n\nEquivalent to [`log(critical, StringOrReport, Metadata)`](`log/3`) if called\nas [`critical(StringOrReport, Metadata)`](`critical/2`).\n\nEquivalent to [`critical(FormatOrFun, Args, #{})`](`critical/3`) if called as\n[`critical(FormatOrFun, Args)`](`critical/2`).","ref":"logger.html#critical/2"},{"type":"function","title":"logger.critical/3","doc":"Equivalent to  log(critical, FormatOrFun, Args, Metadata) .","ref":"logger.html#critical/3"},{"type":"function","title":"logger.debug/1","doc":"Equivalent to  debug(StringOrReport, #{}) .","ref":"logger.html#debug/1"},{"type":"function","title":"logger.debug/2","doc":"Create a debug log event.\n\nEquivalent to [`log(debug, StringOrReport, Metadata)`](`log/3`) if called\nas [`debug(StringOrReport, Metadata)`](`debug/2`).\n\nEquivalent to [`debug(FormatOrFun, Args, #{})`](`debug/3`) if called as\n[`debug(FormatOrFun, Args)`](`debug/2`).","ref":"logger.html#debug/2"},{"type":"function","title":"logger.debug/3","doc":"Equivalent to  log(debug, FormatOrFun, Args, Metadata) .","ref":"logger.html#debug/3"},{"type":"function","title":"logger.emergency/1","doc":"Equivalent to  emergency(StringOrReport, #{}) .","ref":"logger.html#emergency/1"},{"type":"function","title":"logger.emergency/2","doc":"Create a emergency log event.\n\nEquivalent to [`log(emergency, StringOrReport, Metadata)`](`log/3`) if called\nas [`emergency(StringOrReport, Metadata)`](`emergency/2`).\n\nEquivalent to [`emergency(FormatOrFun, Args, #{})`](`emergency/3`) if called as\n[`emergency(FormatOrFun, Args)`](`emergency/2`).","ref":"logger.html#emergency/2"},{"type":"function","title":"logger.emergency/3","doc":"Equivalent to  log(emergency, FormatOrFun, Args, Metadata) .","ref":"logger.html#emergency/3"},{"type":"function","title":"logger.error/1","doc":"Equivalent to  error(StringOrReport, #{}) .","ref":"logger.html#error/1"},{"type":"function","title":"logger.error/2","doc":"Create a error log event.\n\nEquivalent to [`log(error, StringOrReport, Metadata)`](`log/3`) if called\nas [`error(StringOrReport, Metadata)`](`error/2`).\n\nEquivalent to [`error(FormatOrFun, Args, #{})`](`error/3`) if called as\n[`error(FormatOrFun, Args)`](`error/2`).","ref":"logger.html#error/2"},{"type":"function","title":"logger.error/3","doc":"Equivalent to  log(error, FormatOrFun, Args, Metadata) .","ref":"logger.html#error/3"},{"type":"type","title":"logger.filter/0","doc":"A filter which can be installed as a handler filter, or as a primary filter in\nLogger.","ref":"logger.html#t:filter/0"},{"type":"type","title":"logger.filter_arg/0","doc":"The second argument to the filter fun.","ref":"logger.html#t:filter_arg/0"},{"type":"type","title":"logger.filter_id/0","doc":"A unique identifier for a filter.","ref":"logger.html#t:filter_id/0"},{"type":"type","title":"logger.filter_return/0","doc":"The return value from the filter fun.","ref":"logger.html#t:filter_return/0"},{"type":"function","title":"logger.format_report/1","doc":"Convert a log message on report form to `{Format, Args}`. This is the default\nreport callback used by `m:logger_formatter` when no custom report callback is\nfound. See section [Log Message](logger_chapter.md#log-message) in the Kernel\nUser's Guide for information about report callbacks and valid forms of log\nmessages.\n\nThe function produces lines of `Key: Value` from key-value lists. Strings are\nprinted with `~ts` and other terms with `~tp`.\n\nIf `Report` is a map, it is converted to a key-value list before formatting as\nsuch.","ref":"logger.html#format_report/1"},{"type":"type","title":"logger.formatter_config/0","doc":"Configuration data for the formatter. See `m:logger_formatter` for an example of\na formatter implementation.","ref":"logger.html#t:formatter_config/0"},{"type":"function","title":"logger.get_config/0","doc":"Look up all current Logger configuration, including primary, handler, and proxy\nconfiguration, and module level settings.","ref":"logger.html#get_config/0"},{"type":"function","title":"logger.get_handler_config/0","doc":"Look up the current configuration for all handlers.","ref":"logger.html#get_handler_config/0"},{"type":"function","title":"logger.get_handler_config/1","doc":"Look up the current configuration for the given handler.","ref":"logger.html#get_handler_config/1"},{"type":"function","title":"logger.get_handler_ids/0","doc":"Look up the identities for all installed handlers.","ref":"logger.html#get_handler_ids/0"},{"type":"function","title":"logger.get_module_level/0","doc":"Look up all current module levels. Returns a list containing one\n`{Module,Level}` element for each module for which the module level was\npreviously set with `set_module_level/2`.","ref":"logger.html#get_module_level/0"},{"type":"function","title":"logger.get_module_level/1","doc":"Look up the current level for the given modules. Returns a list containing one\n`{Module,Level}` element for each of the given modules for which the module\nlevel was previously set with `set_module_level/2`.","ref":"logger.html#get_module_level/1"},{"type":"function","title":"logger.get_primary_config/0","doc":"Look up the current primary configuration for Logger.","ref":"logger.html#get_primary_config/0"},{"type":"function","title":"logger.get_process_metadata/0","doc":"Retrieve data set with `set_process_metadata/1` or `update_process_metadata/1`.","ref":"logger.html#get_process_metadata/0"},{"type":"function","title":"logger.get_proxy_config/0","doc":"Look up the current configuration for the Logger proxy.\n\nFor more information about the proxy, see section\n[Logger Proxy](logger_chapter.md#logger-proxy) in the Kernel User's Guide.","ref":"logger.html#get_proxy_config/0"},{"type":"type","title":"logger.handler_config/0","doc":"Handler configuration data for Logger.\n\n> #### Note {: .info }\n>\n> DEPRECATED: Use `t:logger_handler:config/0` instead.","ref":"logger.html#t:handler_config/0"},{"type":"type","title":"logger.handler_id/0","doc":"A unique identifier for a handler instance.\n\n> #### Note {: .info }\n>\n> DEPRECATED: Use `t:logger_handler:id/0` instead.","ref":"logger.html#t:handler_id/0"},{"type":"function","title":"logger.i/0","doc":"Pretty print all Logger configuration.","ref":"logger.html#i/0"},{"type":"function","title":"logger.i/1","doc":"Pretty print the Logger configuration.","ref":"logger.html#i/1"},{"type":"function","title":"logger.info/1","doc":"Equivalent to  info(StringOrReport, #{}) .","ref":"logger.html#info/1"},{"type":"function","title":"logger.info/2","doc":"Create a info log event.\n\nEquivalent to [`log(info, StringOrReport, Metadata)`](`log/3`) if called\nas [`info(StringOrReport, Metadata)`](`info/2`).\n\nEquivalent to [`info(FormatOrFun, Args, #{})`](`info/3`) if called as\n[`info(FormatOrFun, Args)`](`info/2`).","ref":"logger.html#info/2"},{"type":"function","title":"logger.info/3","doc":"Equivalent to  log(info, FormatOrFun, Args, Metadata) .","ref":"logger.html#info/3"},{"type":"type","title":"logger.level/0","doc":"The severity level for the message to be logged.","ref":"logger.html#t:level/0"},{"type":"function","title":"logger.log/2","doc":"Equivalent to  log(Level, StringOrReport, #{}) .","ref":"logger.html#log/2"},{"type":"function","title":"logger.log/3","doc":"Create a log event at the given [log level](logger_chapter.md#log-level), with\nthe given [message](logger_chapter.md#log-message) to be logged and\n[_metadata_](logger_chapter.md#metadata).\n\n*Example*:\n\n```erlang\n%% A plain string\n1> logger:log(info, \"Hello World\").\n%% A plain string with metadata\n2> logger:log(debug, \"Hello World\", #{ meta => data }).\n%% A format string with arguments\n3> logger:log(warning, \"The roof is on ~ts\",[Cause]).\n%% A report\n4> logger:log(warning, #{ what => roof, cause => Cause }).\n```\n\nEquivalent to [`log(Level, FormatOrFun, Args, #{})`](`log/4`) if called as\n`log(Level, FormatOrFun, Args)`.","ref":"logger.html#log/3"},{"type":"function","title":"logger.log/4","doc":"Create a log event at the given [log level](logger_chapter.md#log-level), with\nthe given [message](logger_chapter.md#log-message) to be logged and\n[_metadata_](logger_chapter.md#metadata).\n\nThe message and metadata can either be given directly in the arguments, or\nreturned from a fun. Passing a fun instead of the message/metadata directly is\nuseful in scenarios when the message/metadata is very expensive to compute. This\nis because the fun is only evaluated when the message/metadata is actually\nneeded, which may be not at all if the log event is not to be logged. Examples:\n\n```erlang\n%% A plain string with expensive metadata\n1> logger:info(fun([]) -> {\"Hello World\", #{ meta => expensive() }} end,[]).\n%% An expensive report\n2> logger:debug(fun(What) -> #{ what => What, cause => expensive() } end,roof).\n%% A plain string with expensive metadata and normal metadata\n3> logger:debug(fun([]) -> {\"Hello World\", #{ meta => expensive() }} end,[],\n               #{ meta => data }).\n```\n\nWhen metadata is given both as an argument and returned from the fun they are\nmerged. If equal keys exists the values are taken from the metadata returned by\nthe fun.","ref":"logger.html#log/4"},{"type":"type","title":"logger.log_event/0","doc":"A log event passed to filters and handlers","ref":"logger.html#t:log_event/0"},{"type":"type","title":"logger.metadata/0","doc":"Metadata for the log event.\n\nLogger adds the following metadata to each log event:\n\n- `pid => self()`\n- `gl => group_leader()`\n- `time => logger:timestamp()`\n\nWhen a log macro is used, Logger also inserts location information:\n\n- `mfa => {?MODULE, ?FUNCTION_NAME, ?FUNCTION_ARITY}`\n- `file => ?FILE`\n- `line => ?LINE`\n\nYou can add custom metadata, either by:\n\n- specifying a map as the last parameter to any of the log macros or the logger\n  API functions.\n- setting process metadata with `set_process_metadata/1` or\n  `update_process_metadata/1`.\n- setting primary metadata with `set_primary_config/1` or through the kernel\n  configuration parameter [logger_metadata](kernel_app.md#logger_metadata)\n\n> #### Note {: .info }\n>\n> When adding custom metadata, make sure not to use any of the keys mentioned\n> above as that may cause a lot of confusion about the log events.\n\nLogger merges all the metadata maps before forwarding the log event to the\nhandlers. If the same keys occur, values from the log call overwrite process\nmetadata, which overwrites the primary metadata, which in turn overwrite values\nset by Logger.\n\nThe following custom metadata keys have special meaning:\n\n- **`domain`** - The value associated with this key is used by filters for\n  grouping log events originating from, for example, specific functional areas.\n  See `logger_filters:domain/2` for a description of how this field can be used.\n\n- **`report_cb`** - If the log message is specified as a `t:report/0`, the\n  `report_cb` key can be associated with a fun (report callback) that converts\n  the report to a format string and arguments, or directly to a string. See the\n  type definition of `t:report_cb/0`, and section\n  [Log Message](logger_chapter.md#log-message) in the User's Guide for more\n  information about report callbacks.","ref":"logger.html#t:metadata/0"},{"type":"type","title":"logger.msg_fun/0","doc":"","ref":"logger.html#t:msg_fun/0"},{"type":"type","title":"logger.msg_fun_return/0","doc":"","ref":"logger.html#t:msg_fun_return/0"},{"type":"function","title":"logger.notice/1","doc":"Equivalent to  notice(StringOrReport, #{}) .","ref":"logger.html#notice/1"},{"type":"function","title":"logger.notice/2","doc":"Create a notice log event.\n\nEquivalent to [`log(notice, StringOrReport, Metadata)`](`log/3`) if called\nas [`notice(StringOrReport, Metadata)`](`notice/2`).\n\nEquivalent to [`notice(FormatOrFun, Args, #{})`](`notice/3`) if called as\n[`notice(FormatOrFun, Args)`](`notice/2`).","ref":"logger.html#notice/2"},{"type":"function","title":"logger.notice/3","doc":"Equivalent to  log(notice, FormatOrFun, Args, Metadata) .","ref":"logger.html#notice/3"},{"type":"type","title":"logger.olp_config/0","doc":"Overload protection configuration.\n\n> #### Note {: .info }\n>\n> DEPRECATED: Use `t:logger_handler:olp_config/0` instead.","ref":"logger.html#t:olp_config/0"},{"type":"type","title":"logger.primary_config/0","doc":"Primary configuration data for Logger. The following default values apply:\n\n- `level => info`\n- `filter_default => log`\n- `filters => []`","ref":"logger.html#t:primary_config/0"},{"type":"function","title":"logger.reconfigure/0","doc":"Reconfigure Logger using updated `kernel` configuration that was set after\n`kernel` application was loaded.\n\nBeware, that this is meant to be run only by the build tools, not manually\nduring application lifetime, as this may cause missing log entries.\n\nBefore reconfiguration, `simple` logger handler is added to capture log events\nbefore the logging infrastructure is started and prints them to standard\noutput. After the `default` handler is added again, all log events captured by\nthe `simple` handler are replayed to the `default` handler, and the `simple`\nhandler is removed. Notice that if you don't add the `default` handler,\n`simple` handler will persist.","ref":"logger.html#reconfigure/0"},{"type":"function","title":"logger.remove_handler/1","doc":"Remove the handler identified by `HandlerId`.","ref":"logger.html#remove_handler/1"},{"type":"function","title":"logger.remove_handler_filter/2","doc":"Remove the filter identified by `FilterId` from the handler identified by\n`HandlerId`.","ref":"logger.html#remove_handler_filter/2"},{"type":"function","title":"logger.remove_primary_filter/1","doc":"Remove the primary filter identified by `FilterId` from Logger.","ref":"logger.html#remove_primary_filter/1"},{"type":"type","title":"logger.report/0","doc":"A log report.","ref":"logger.html#t:report/0"},{"type":"type","title":"logger.report_cb/0","doc":"A fun which converts a [`report()`](`t:report/0`) to a format string and\narguments, or directly to a string.\n\nSee section [Log Message](logger_chapter.md#log-message) in the User's Guide\nfor more information.","ref":"logger.html#t:report_cb/0"},{"type":"type","title":"logger.report_cb_config/0","doc":"","ref":"logger.html#t:report_cb_config/0"},{"type":"function","title":"logger.set_application_level/2","doc":"Set the log level for all the modules of the specified application.\n\nThis function is a convenience function that calls\n[logger:set_module_level/2](`set_module_level/2`) for each module associated\nwith an application.","ref":"logger.html#set_application_level/2"},{"type":"function","title":"logger.set_handler_config/2","doc":"Set configuration data for the specified handler. This overwrites the current\nhandler configuration.\n\nTo modify the existing configuration, use `update_handler_config/2`, or, if a\nmore complex merge is needed, read the current configuration with\n[`get_handler_config/1` ](`get_handler_config/1`), then do the merge before\nwriting the new configuration back with this function.\n\nIf a key is removed compared to the current configuration, and the key is known\nby Logger, the default value is used. If it is a custom key, then it is up to\nthe handler implementation if the value is removed or a default value is\ninserted.","ref":"logger.html#set_handler_config/2"},{"type":"function","title":"logger.set_handler_config/3","doc":"Add or update configuration data for the specified handler. If the given `Key`\nalready exists, its associated value will be changed to the given value. If it\ndoes not exist, it will be added.\n\nIf the value is incomplete, which for example can be the case for the `config`\nkey, it is up to the handler implementation how the unspecified parts are set.\nFor all handlers in the Kernel application, unspecified data for the `config`\nkey is set to default values. To update only specified data, and keep the\nexisting configuration for the rest, use `update_handler_config/3`.\n\nSee the definition of the `t:logger_handler:config/0` type for more information\nabout the different parameters.","ref":"logger.html#set_handler_config/3"},{"type":"function","title":"logger.set_module_level/2","doc":"Set the log level for the specified modules.\n\nThe log level for a module overrides the primary log level of Logger for log\nevents originating from the module in question. Notice, however, that it does\nnot override the level configuration for any handler.\n\nFor example: Assume that the primary log level for Logger is `info`, and there\nis one handler, `h1`, with level `info` and one handler, `h2`, with level\n`debug`.\n\nWith this configuration, no debug messages will be logged, since they are all\nstopped by the primary log level.\n\nIf the level for `mymodule` is now set to `debug`, then debug events from this\nmodule will be logged by the handler `h2`, but not by handler `h1`.\n\nDebug events from other modules are still not logged.\n\nTo change the primary log level for Logger, use\n[`set_primary_config(level, Level)`](`set_primary_config/2`).\n\nTo change the log level for a handler, use\n[`set_handler_config(HandlerId, level, Level)` ](`set_handler_config/3`).\n\n> #### Note {: .info }\n>\n> The originating module for a log event is only detected if the key `mfa`\n> exists in the metadata, and is associated with `{Module, Function, Arity}`.\n> When log macros are used, this association is automatically added to all log\n> events. If an API function is called directly, without using a macro, the\n> logging client must explicitly add this information if module levels shall\n> have any effect.","ref":"logger.html#set_module_level/2"},{"type":"function","title":"logger.set_primary_config/1","doc":"Set primary configuration data for Logger. This overwrites the current\nconfiguration.\n\nTo modify the existing configuration, use `update_primary_config/1`, or, if a\nmore complex merge is needed, read the current configuration with\n[`get_primary_config/0` ](`get_primary_config/0`), then do the merge before\nwriting the new configuration back with this function.\n\nIf a key is removed compared to the current configuration, the default value is\nused.","ref":"logger.html#set_primary_config/1"},{"type":"function","title":"logger.set_primary_config/2","doc":"Add or update primary configuration data for Logger. If the given `Key` already\nexists, its associated value will be changed to the given value. If it does not\nexist, it will be added.\n\nThe `metadata` key was added in OTP 24.0.","ref":"logger.html#set_primary_config/2"},{"type":"function","title":"logger.set_process_metadata/1","doc":"Set metadata which Logger shall automatically insert in all log events produced\non the current process.\n\nLocation data produced by the log macros, and/or metadata given as argument to\nthe log call (API function or macro), are merged with the process metadata. If\nthe same keys occur, values from the metadata argument to the log call overwrite\nvalues from the process metadata, which in turn overwrite values from the\nlocation data.\n\nSubsequent calls to this function overwrites previous data set. To update\nexisting data instead of overwriting it, see `update_process_metadata/1`.","ref":"logger.html#set_process_metadata/1"},{"type":"function","title":"logger.set_proxy_config/1","doc":"Set configuration data for the Logger proxy. This overwrites the current proxy\nconfiguration. Keys that are not specified in the `Config` map gets default\nvalues.\n\nTo modify the existing configuration, use `update_proxy_config/1`, or, if a more\ncomplex merge is needed, read the current configuration with\n[`get_proxy_config/0` ](`get_proxy_config/0`), then do the merge before writing\nthe new configuration back with this function.\n\nFor more information about the proxy, see section\n[Logger Proxy](logger_chapter.md#logger-proxy) in the Kernel User's Guide.","ref":"logger.html#set_proxy_config/1"},{"type":"type","title":"logger.timestamp/0","doc":"A timestamp produced with [`logger:timestamp()`](`timestamp/0`).","ref":"logger.html#t:timestamp/0"},{"type":"function","title":"logger.timestamp/0","doc":"Return a timestamp that can be inserted as the `time` field in the meta data for\na log event. It is produced with\n[`os:system_time(microsecond)`](`os:system_time/1`).\n\nNotice that Logger automatically inserts a timestamp in the meta data unless it\nalready exists. This function is exported for the rare case when the timestamp\nmust be taken at a different point in time than when the log event is issued.","ref":"logger.html#timestamp/0"},{"type":"function","title":"logger.unset_application_level/1","doc":"Unset the log level for all the modules of the specified application.\n\nThis function is a utility function that calls\n[logger:unset_module_level/2](`unset_module_level/1`) for each module associated\nwith an application.","ref":"logger.html#unset_application_level/1"},{"type":"function","title":"logger.unset_module_level/0","doc":"Remove module specific log settings. After this, the primary log level is used\nfor all modules.","ref":"logger.html#unset_module_level/0"},{"type":"function","title":"logger.unset_module_level/1","doc":"Remove module specific log settings. After this, the primary log level is used\nfor the specified modules.","ref":"logger.html#unset_module_level/1"},{"type":"function","title":"logger.unset_process_metadata/0","doc":"Delete data set with `set_process_metadata/1` or `update_process_metadata/1`.","ref":"logger.html#unset_process_metadata/0"},{"type":"function","title":"logger.update_formatter_config/2","doc":"Update the formatter configuration for the specified handler.\n\nThe new configuration is merged with the existing formatter configuration.\n\nTo overwrite the existing configuration without any merge, use\n\n```erlang\nset_handler_config(HandlerId, formatter,\n\t      {FormatterModule, FormatterConfig}).\n```","ref":"logger.html#update_formatter_config/2"},{"type":"function","title":"logger.update_formatter_config/3","doc":"Equivalent to  update_formatter_config(HandlerId, #{Key => Value}) .","ref":"logger.html#update_formatter_config/3"},{"type":"function","title":"logger.update_handler_config/2","doc":"Update configuration data for the specified handler. This function behaves as if\nit was implemented as follows:\n\n```erlang\n{ok, {_, Old}} = logger:get_handler_config(HandlerId),\nlogger:set_handler_config(HandlerId, maps:merge(Old, Config)).\n```\n\nTo overwrite the existing configuration without any merge, use\n[`set_handler_config/2` ](`set_handler_config/2`).","ref":"logger.html#update_handler_config/2"},{"type":"function","title":"logger.update_handler_config/3","doc":"Add or update configuration data for the specified handler. If the given `Key`\nalready exists, its associated value will be changed to the given value. If it\ndoes not exist, it will be added.\n\nIf the value is incomplete, which for example can be the case for the `config`\nkey, it is up to the handler implementation how the unspecified parts are set.\nFor all handlers in the Kernel application, unspecified data for the `config`\nkey is not changed. To reset unspecified data to default values, use\n`set_handler_config/3`.\n\nSee the definition of the `t:logger_handler:config/0` type for more information\nabout the different parameters.","ref":"logger.html#update_handler_config/3"},{"type":"function","title":"logger.update_primary_config/1","doc":"Update primary configuration data for Logger. This function behaves as if it was\nimplemented as follows:\n\n```erlang\nOld = logger:get_primary_config(),\nlogger:set_primary_config(maps:merge(Old, Config)).\n```\n\nTo overwrite the existing configuration without any merge, use\n[`set_primary_config/1` ](`set_primary_config/1`).","ref":"logger.html#update_primary_config/1"},{"type":"function","title":"logger.update_process_metadata/1","doc":"Set or update metadata to use when logging from current process\n\nIf process metadata exists for the current process, this function behaves as if\nit was implemented as follows:\n\n```erlang\nlogger:set_process_metadata(maps:merge(logger:get_process_metadata(), Meta)).\n```\n\nIf no process metadata exists, the function behaves as\n[`set_process_metadata/1` ](`set_process_metadata/1`).","ref":"logger.html#update_process_metadata/1"},{"type":"function","title":"logger.update_proxy_config/1","doc":"Update configuration data for the Logger proxy. This function behaves as if it\nwas implemented as follows:\n\n```erlang\nOld = logger:get_proxy_config(),\nlogger:set_proxy_config(maps:merge(Old, Config)).\n```\n\nTo overwrite the existing configuration without any merge, use\n[`set_proxy_config/1` ](`set_proxy_config/1`).\n\nFor more information about the proxy, see section\n[Logger Proxy](logger_chapter.md#logger-proxy) in the Kernel User's Guide.","ref":"logger.html#update_proxy_config/1"},{"type":"function","title":"logger.warning/1","doc":"Equivalent to  warning(StringOrReport, #{}) .","ref":"logger.html#warning/1"},{"type":"function","title":"logger.warning/2","doc":"Create a warning log event.\n\nEquivalent to [`log(warning, StringOrReport, Metadata)`](`log/3`) if called\nas [`warning(StringOrReport, Metadata)`](`warning/2`).\n\nEquivalent to [`warning(FormatOrFun, Args, #{})`](`warning/3`) if called as\n[`warning(FormatOrFun, Args)`](`warning/2`).","ref":"logger.html#warning/2"},{"type":"function","title":"logger.warning/3","doc":"Equivalent to  log(warning, FormatOrFun, Args, Metadata) .","ref":"logger.html#warning/3"},{"type":"module","title":"logger_disk_log_h","doc":"A disk_log based handler for Logger\n\nThis is a handler for Logger that offers circular (wrapped) logs by using\n`m:disk_log`. Multiple instances of this handler can be added to Logger, and\neach instance prints to its own disk log file, created with the name and\nsettings specified in the handler configuration.\n\nThe default standard handler, `m:logger_std_h`, can be replaced by a disk_log\nhandler at startup of the Kernel application. See an example of this below.\n\nThe handler has an overload protection mechanism that keeps the handler process\nand the Kernel application alive during high loads of log events. How overload\nprotection works, and how to configure it, is described in the\n[`User's Guide`](logger_chapter.md#overload_protection).\n\nTo add a new instance of the disk_log handler, use\n[`logger:add_handler/3`](`logger:add_handler/3`). The handler configuration\nargument is a map which can contain general configuration parameters, as\ndocumented in the [`User's Guide`](logger_chapter.md#handler-configuration),\nand handler specific parameters. The specific data is stored in a sub map with\nthe key `config`, and can contain the following parameters:\n\n- **`file`** - This is the full name of the disk log file. The option\n  corresponds to the `name` property in the [`dlog_option()`](`disk_log:open/1`)\n  datatype.\n\n  The value is set when the handler is added, and it cannot be changed in\n  runtime.\n\n  Defaults to the same name as the handler identity, in the current directory.\n\n- **`type`** - This is the disk log type, `wrap` or `halt`. The option\n  corresponds to the `type` property in the [`dlog_option()`](`disk_log:open/1`)\n  datatype.\n\n  The value is set when the handler is added, and it cannot be changed in\n  runtime.\n\n  Defaults to `wrap`.\n\n- **`max_no_files`** - This is the maximum number of files that disk_log uses\n  for its circular logging. The option corresponds to the `MaxNoFiles` element\n  in the `size` property in the [`dlog_option()`](`disk_log:open/1`) datatype.\n\n  The value is set when the handler is added, and it cannot be changed in\n  runtime.\n\n  Defaults to `10`.\n\n  The setting has no effect on a halt log.\n\n- **`max_no_bytes`** - This is the maximum number of bytes that is written to a\n  log file before disk_log proceeds with the next file in order, or generates an\n  error in case of a full halt log. The option corresponds to the `MaxNoBytes`\n  element in the `size` property in the [`dlog_option()`](`disk_log:open/1`)\n  datatype.\n\n  The value is set when the handler is added, and it cannot be changed in\n  runtime.\n\n  Defaults to `1048576` bytes for a wrap log, and `infinity` for a halt log.\n\n- **`filesync_repeat_interval`** - This value, in milliseconds, specifies how\n  often the handler does a disk_log sync operation to write buffered data to\n  disk. The handler attempts the operation repeatedly, but only performs a new\n  sync if something has actually been logged.\n\n  Defaults to `5000` milliseconds.\n\n  If `no_repeat` is set as value, the repeated sync operation is disabled. The\n  user can also call the [`filesync/1`](`filesync/1`) function to perform a\n  disk_log sync.\n\nOther configuration parameters exist, to be used for customizing the overload\nprotection behaviour. The same parameters are used both in the standard handler\nand the disk_log handler, and are documented in the\n[`User's Guide`](logger_chapter.md#overload_protection).\n\nNotice that when changing the configuration of the handler in runtime, the\ndisk_log options (`file`, `type`, `max_no_files`, `max_no_bytes`) must not be\nmodified.\n\nExample of adding a disk_log handler:\n\n```erlang\nlogger:add_handler(my_disk_log_h, logger_disk_log_h,\n                   #{config => #{file => \"./my_disk_log\",\n                                 type => wrap,\n                                 max_no_files => 4,\n                                 max_no_bytes => 10000,\n                                 filesync_repeat_interval => 1000}}).\n```\n\nTo use the disk_log handler instead of the default standard handler when\nstarting an Erlang node, change the Kernel default logger to use\n`logger_disk_log_h`. Example:\n\n```text\nerl -kernel logger '[{handler,default,logger_disk_log_h,\n                      #{config => #{file => \"./system_disk_log\"}}}]'\n```","ref":"logger_disk_log_h.html"},{"type":"module","title":"See Also - logger_disk_log_h","doc":"`m:logger`, `m:logger_std_h`, `m:disk_log`","ref":"logger_disk_log_h.html#module-see-also"},{"type":"function","title":"logger_disk_log_h.filesync/1","doc":"Write buffered data to disk.","ref":"logger_disk_log_h.html#filesync/1"},{"type":"module","title":"logger_filters","doc":"Filters to use with Logger.\n\nAll functions exported from this module can be used as primary or handler\nfilters. See `logger:add_primary_filter/2` and `logger:add_handler_filter/3` for\nmore information about how filters are added.\n\nFilters are removed with `logger:remove_primary_filter/1` and\n`logger:remove_handler_filter/2`.","ref":"logger_filters.html"},{"type":"module","title":"See Also - logger_filters","doc":"`m:logger`","ref":"logger_filters.html#module-see-also"},{"type":"function","title":"logger_filters.domain/2","doc":"This filter provides a way of filtering log events based on a `domain` field in\n`Metadata`. This field is optional, and the purpose of using it is to group log\nevents from, for example, a specific functional area. This allows filtering or\nother specialized treatment in a Logger handler.\n\nA domain field must be a list of atoms, creating smaller and more specialized\ndomains as the list grows longer. The greatest domain is `[]`, which comprises\nall possible domains.\n\nFor example, consider the following domains:\n\n```erlang\nD1 = [otp]\nD2 = [otp, sasl]\n```\n\n`D1` is the greatest of the two, and is said to be a super-domain of `D2`. `D2`\nis a sub-domain `D1`. Both `D1` and `D2` are sub-domains of `[]`.\n\nThe above domains are used for logs originating from Erlang/OTP. D1 specifies\nthat the log event comes from Erlang/OTP in general, and D2 indicates that the\nlog event is a so called [SASL report](logger_chapter.md#sasl_reports).\n\nThe `Extra` parameter to the [`domain/2`](`domain/2`) function is specified when\nadding the filter via `logger:add_primary_filter/2` or\n`logger:add_handler_filter/3`.\n\nThe filter compares the value of the `domain` field in the log event's metadata\n(`Domain`) against `MatchDomain`. The filter matches if the value of `Compare`\nis:\n\n- **`sub`** - and `Domain` is equal to or a sub-domain of `MatchDomain`, that\n  is, if `MatchDomain` is a prefix of `Domain`.\n\n- **`super`** - and `Domain` is equal to or a super-domain of `MatchDomain`,\n  that is, if `Domain` is a prefix of `MatchDomain`.\n\n- **`equal`** - and `Domain` is equal to `MatchDomain`.\n\n- **`not_equal`** - and `Domain` differs from `MatchDomain`, or if there is no\n  domain field in metadata.\n\n- **`undefined`** - and there is no domain field in metadata. In this case\n  `MatchDomain` must be set to `[]`.\n\nIf the filter matches and `Action` is `log`, the log event is allowed. If the\nfilter matches and `Action` is `stop`, the log event is stopped.\n\nIf the filter does not match, it returns `ignore`, meaning that other filters,\nor the value of the configuration parameter `filter_default`, decide if the\nevent is allowed or not.\n\nLog events that do not contain any domain field, match only when `Compare` is\nequal to `undefined` or `not_equal`.\n\nExample: stop all events with domain `[otp, sasl | _]`\n\n```erlang\n1> logger:set_handler_config(h1, filter_default, log). % this is the default\nok\n2> Filter = {fun logger_filters:domain/2, {stop, sub, [otp, sasl]}}.\n...\n3> logger:add_handler_filter(h1, no_sasl, Filter).\nok\n```","ref":"logger_filters.html#domain/2"},{"type":"function","title":"logger_filters.level/2","doc":"This filter provides a way of filtering log events based on the log level. It\nmatches log events by comparing the log level with a specified `MatchLevel`\n\nThe `Extra` parameter is specified when adding the filter via\n`logger:add_primary_filter/2` or `logger:add_handler_filter/3`.\n\nThe filter compares the value of the event's log level (`Level`) to `MatchLevel`\nby calling\n[`logger:compare_levels(Level, MatchLevel)`](`logger:compare_levels/2`). The\nfilter matches if the value of `Operator` is:\n\n- **`neq`** - and the compare function returns `lt` or `gt`.\n\n- **`eq`** - and the compare function returns `eq`.\n\n- **`lt`** - and the compare function returns `lt`.\n\n- **`gt`** - and the compare function returns `gt`.\n\n- **`lteq`** - and the compare function returns `lt` or `eq`.\n\n- **`gteq`** - and the compare function returns `gt` or `eq`.\n\nIf the filter matches and `Action` is `log`, the log event is allowed. If the\nfilter matches and `Action` is `stop`, the log event is stopped.\n\nIf the filter does not match, it returns `ignore`, meaning that other filters,\nor the value of the configuration parameter `filter_default`, will decide if the\nevent is allowed or not.\n\nExample: only allow debug level log events\n\n```erlang\nlogger:set_handler_config(h1, filter_default, stop).\nFilter = {fun logger_filters:level/2, {log, eq, debug}}.\nlogger:add_handler_filter(h1, debug_only, Filter).\nok\n```","ref":"logger_filters.html#level/2"},{"type":"function","title":"logger_filters.progress/2","doc":"This filter matches all progress reports from `m:supervisor` and\n[`application_controller`](`m:application`).\n\nIf `Extra` is `log`, the progress reports are allowed. If `Extra` is `stop`, the\nprogress reports are stopped.\n\nThe filter returns `ignore` for all other log events.","ref":"logger_filters.html#progress/2"},{"type":"function","title":"logger_filters.remote_gl/2","doc":"This filter matches all events originating from a process that has its group\nleader on a remote node.\n\nIf `Extra` is `log`, the matching events are allowed. If `Extra` is `stop`, the\nmatching events are stopped.\n\nThe filter returns `ignore` for all other log events.","ref":"logger_filters.html#remote_gl/2"},{"type":"behaviour","title":"logger_formatter","doc":"Default formatter for Logger.\n\nEach Logger handler has a configured formatter specified as a module and a\nconfiguration term. The purpose of the formatter is to translate the log events\nto a final printable string ([`unicode:chardata()`](`t:unicode:chardata/0`))\nwhich can be written to the output device of the handler. See sections\n[Handlers](logger_chapter.md#handlers) and\n[Formatters](logger_chapter.md#formatters) in the Kernel User's Guide for more\ninformation.\n\n`m:logger_formatter` is the default formatter used by Logger.","ref":"logger_formatter.html"},{"type":"behaviour","title":"See Also - logger_formatter","doc":"`m:calendar`, `m:error_logger`, `m:io`, `m:io_lib`, `m:logger`, `m:maps`,\n[`sasl(6)`](`e:sasl:sasl_app.md`), `m:unicode`","ref":"logger_formatter.html#module-see-also"},{"type":"callback","title":"logger_formatter.check_config/1","doc":"The function is called by a Logger when formatter configuration is set or\nmodified. The formatter must validate the given configuration and return `ok` if\nit is correct, and `{error,Reason}` if it is faulty.\n\nThe following Logger API functions can trigger this callback:\n\n- `logger:add_handler/3`\n- [`logger:set_handler_config/2,3`](`logger:set_handler_config/2`)\n- [`logger:update_handler_config/2,3`](`logger:update_handler_config/2`)\n- `logger:update_formatter_config/2`\n\nSee `m:logger_formatter` for an example implementation. `m:logger_formatter` is\nthe default formatter used by Logger.","ref":"logger_formatter.html#c:check_config/1"},{"type":"function","title":"logger_formatter.check_config/1","doc":"The function is called by Logger when the formatter configuration for a handler\nis set or modified. It returns `ok` if the configuration is valid, and\n`{error,term()}` if it is faulty.\n\nThe following Logger API functions can trigger this callback:\n\n- `logger:add_handler/3`\n- [`logger:set_handler_config/2,3`](`logger:set_handler_config/2`)\n- `logger:update_handler_config/2`\n- `logger:update_formatter_config/2`","ref":"logger_formatter.html#check_config/1"},{"type":"type","title":"logger_formatter.config/0","doc":"The configuration term for `logger_formatter` is a [map](`m:maps`), and the\nfollowing keys can be set as configuration parameters:\n\n- **`chars_limit = integer() > 0 | unlimited`{: #chars_limit }** - A positive\n  integer representing the value of the option with the same name to be used\n  when calling `io_lib:format/3`. This value limits the total number of\n  characters printed for each log event. Notice that this is a soft limit. For a\n  hard truncation limit, see option `max_size`.\n\n  Defaults to `unlimited`.\n\n- **`depth = integer() > 0 | unlimited`{: #depth }** - A positive integer\n  representing the maximum depth to which terms shall be printed by this\n  formatter. Format strings passed to this formatter are rewritten. The format\n  controls ~p and ~w are replaced with ~P and ~W, respectively, and the value is\n  used as the depth parameter. For details, see [`io:format/2,3`](`io:format/2`)\n  in STDLIB.\n\n  Defaults to `unlimited`.\n\n- **`legacy_header = boolean()`** - If set to `true` a header field is added to\n  logger_formatter's part of `Metadata`. The value of this field is a string\n  similar to the header created by the old `m:error_logger` event handlers. It\n  can be included in the log event by adding the list\n  `[logger_formatter,header]` to the template. See the description of the\n  `t:template/0` type for more information.\n\n  Defaults to `false`.\n\n- **`max_size = integer() > 0 | unlimited`{: #max_size }** - A positive integer\n  representing the absolute maximum size a string returned from this formatter\n  can have. If the formatted string is longer, after possibly being limited by\n  `chars_limit` or `depth`, it is truncated.\n\n  Defaults to `unlimited`.\n\n- **`report_cb = ` `t:logger:report_cb/0`** - A report callback is used by the\n  formatter to transform log messages on report form to a format string and\n  arguments. The report callback can be specified in the metadata for the log\n  event. If no report callback exists in metadata, `logger_formatter` will use\n  `logger:format_report/1` as default callback.\n\n  If this configuration parameter is set, it replaces both the default report\n  callback, and any report callback found in metadata. That is, all reports are\n  converted by this configured function.\n\n- **`single_line = boolean()`** - If set to `true`, each log event is printed as\n  a single line. To achieve this, `logger_formatter` sets the field width to `0`\n  for all `~p` and `~P` control sequences in the format a string (see\n  `io:format/2`), and replaces all newlines in the message with `\", \"`. White\n  spaces following directly after newlines are removed. Notice that newlines\n  added by the `template` parameter are not replaced.\n\n  Defaults to `true`.\n\n- **`template = `{: #template }`t:template/0`** - The template describes how the\n  formatted string is composed by combining different data values from the log\n  event. See the description of the `t:template/0` type for more information\n  about this.\n\n- **`time_designator = byte()`** - Timestamps are formatted according to\n  RFC3339, and the time designator is the character used as date and time\n  separator.\n\n  Defaults to `$T`.\n\n  The value of this parameter is used as the `time_designator` option to\n  `calendar:system_time_to_rfc3339/2`.\n\n- **`time_offset = integer() | [byte()]`** - The time offset, either a string or\n  an integer, to be used when formatting the timestamp.\n\n  An empty string is interpreted as local time. The values `\"Z\"`, `\"z\"` or `0`\n  are interpreted as Universal Coordinated Time (UTC).\n\n  Strings, other than `\"Z\"`, `\"z\"`, or `\"\"`, must be of the form `±[hh]:[mm]`,\n  for example `\"-02:00\"` or `\"+00:00\"`.\n\n  Integers must be in microseconds, meaning that the offset `7200000000` is\n  equivalent to `\"+02:00\"`.\n\n  Defaults to an empty string, meaning that timestamps are displayed in local\n  time. However, for backwards compatibility, if the SASL configuration\n  parameter [`utc_log`](`e:sasl:sasl_app.md#utc_log`)`=true`, the default is\n  changed to `\"Z\"`, meaning that timestamps are displayed in UTC.\n\n  The value of this parameter is used as the `offset` option to\n  `calendar:system_time_to_rfc3339/2`.","ref":"logger_formatter.html#t:config/0"},{"type":"callback","title":"logger_formatter.format/2","doc":"The function can be called by a log handler to convert a log event term to a\nprintable string. The returned value can, for example, be printed as a log entry\nto the console or a file using [`io:put_chars/1,2`](`io:put_chars/1`).\n\nSee `m:logger_formatter` for an example implementation. `m:logger_formatter` is\nthe default formatter used by Logger.","ref":"logger_formatter.html#c:format/2"},{"type":"function","title":"logger_formatter.format/2","doc":"This the formatter callback function to be called from handlers.\n\nThe log event is processed as follows:\n\n- If the message is on report form, it is converted to `{Format,Args}` by\n  calling the report callback. See section\n  [Log Message](logger_chapter.md#log-message) in the Kernel User's Guide for\n  more information about report callbacks and valid forms of log messages.\n- The message size is limited according to the values of configuration\n  parameters [`chars_limit`](`m:logger_formatter#chars_limit`) and\n  [`depth`](`m:logger_formatter#depth`).\n- The full log entry is composed according to the\n  [`template`](`m:logger_formatter#template`).\n- If the final string is too long, it is truncated according to the value of\n  configuration parameter [`max_size`](`m:logger_formatter#max_size`).","ref":"logger_formatter.html#format/2"},{"type":"type","title":"logger_formatter.metakey/0","doc":"","ref":"logger_formatter.html#t:metakey/0"},{"type":"type","title":"logger_formatter.template/0","doc":"The template to be used by a logger formatter.\n\nThe template is a list of atoms, atom lists, tuples and strings. The atoms\n`level` or `msg`, are treated as placeholders for the severity level and the log\nmessage, respectively. Other atoms or atom lists are interpreted as placeholders\nfor metadata, where atoms are expected to match top level keys, and atom lists\nrepresent paths to sub keys when the metadata is a nested map. For example the\nlist `[key1,key2]` is replaced by the value of the `key2` field in the nested\nmap below. The atom `key1` on its own is replaced by the complete value of the\n`key1` field. The values are converted to strings.\n\n```text\n#{key1 => #{key2 => my_value,\n            ...}\n  ...}\n```\n\nTuples in the template express if-exist tests for metadata keys. For example,\nthe following tuple says that if `key1` exists in the metadata map, print\n`\"key1=Value\"`, where `Value` is the value that `key1` is associated with in the\nmetadata map. If `key1` does not exist, print nothing.\n\n```text\n{key1, [\"key1=\",key1], []}\n```\n\nStrings in the template are printed literally.\n\nThe default value for the `template` configuration parameter depends on the\nvalue of the `single_line` and `legacy_header` configuration parameters as\nfollows.\n\nThe log event used in the examples is:\n\n```text\n?LOG_ERROR(\"name: ~p~nexit_reason: ~p\", [my_name, \"It crashed\"])\n```\n\n- **`legacy_header = true, single_line = false`** - Default template:\n  `[[logger_formatter,header],\"\\n\",msg,\"\\n\"]`\n\n  Example log entry:\n\n  ```text\n  =ERROR REPORT==== 17-May-2018::18:30:19.453447 ===\n  name: my_name\n  exit_reason: \"It crashed\"\n  ```\n\n  Notice that all eight levels can occur in the heading, not only `ERROR`,\n  `WARNING` or `INFO` as `m:error_logger` produces. And microseconds are added\n  at the end of the timestamp.\n\n- **`legacy_header = true, single_line = true`** - Default template:\n  `[[logger_formatter,header],\"\\n\",msg,\"\\n\"]`\n\n  Notice that the template is here the same as for `single_line=false`, but the\n  resulting log entry differs in that there is only one line after the heading:\n\n  ```text\n  =ERROR REPORT==== 17-May-2018::18:31:06.952665 ===\n  name: my_name, exit_reason: \"It crashed\"\n  ```\n\n- **`legacy_header = false, single_line = true`** - Default template:\n  `[time,\" \",level,\": \",msg,\"\\n\"]`\n\n  Example log entry:\n\n  ```text\n  2018-05-17T18:31:31.152864+02:00 error: name: my_name, exit_reason: \"It crashed\"\n  ```\n\n- **`legacy_header = false, single_line = false`** - Default template:\n  `[time,\" \",level,\":\\n\",msg,\"\\n\"]`\n\n  Example log entry:\n\n  ```text\n  2018-05-17T18:32:20.105422+02:00 error:\n  name: my_name\n  exit_reason: \"It crashed\"\n  ```","ref":"logger_formatter.html#t:template/0"},{"type":"behaviour","title":"logger_handler","doc":"logger_handler behavior module.\n\nThe behaviour module for logger handlers. A logger handler is a callback module\nthat is called when a log event has passed all filters and is ready to be logged\nsomewhere. For more information see [Handlers](logger_chapter.md#handlers) in\nthe Users Guide.","ref":"logger_handler.html"},{"type":"behaviour","title":"See Also - logger_handler","doc":"`m:logger_filters`, `m:logger_formatter`, `m:logger`","ref":"logger_handler.html#module-see-also"},{"type":"callback","title":"logger_handler.adding_handler/1","doc":"The function is called on a temporary process when a new handler is about to be\nadded. The purpose is to verify the configuration and initiate all resources\nneeded by the handler.\n\nThe handler identity is associated with the `id` key in `Config1`.\n\nIf everything succeeds, the callback function can add possible default values or\ninternal state values to the configuration, and return the adjusted map in\n`{ok,Config2}`.\n\nIf the configuration is faulty, or if the initiation fails, the callback\nfunction must return `{error,Reason}`.","ref":"logger_handler.html#c:adding_handler/1"},{"type":"callback","title":"logger_handler.changing_config/3","doc":"The function is called on a temporary process when the configuration for a\nhandler is about to change. The purpose is to verify and act on the new\nconfiguration.\n\n`OldConfig` is the existing configuration and `NewConfig` is the new\nconfiguration.\n\nThe handler identity is associated with the `id` key in `OldConfig`.\n\n`SetOrUpdate` has the value `set` if the configuration change originates from a\ncall to [`logger:set_handler_config/2,3`](`logger:set_handler_config/2`), and\n`update` if it originates from\n[`logger:update_handler_config/2,3`](`logger:update_handler_config/2`). The\nhandler can use this parameter to decide how to update the value of the `config`\nfield, that is, the handler specific configuration data. Typically, if\n`SetOrUpdate` equals `set`, values that are not specified must be given their\ndefault values. If `SetOrUpdate` equals `update`, the values found in\n`OldConfig` must be used instead.\n\nIf everything succeeds, the callback function must return a possibly adjusted\nconfiguration in `{ok,Config}`.\n\nIf the configuration is faulty, the callback function must return\n`{error,Reason}`.","ref":"logger_handler.html#c:changing_config/3"},{"type":"type","title":"logger_handler.config/0","doc":"Handler configuration data for Logger. The following default values apply:\n\n- `level => all`\n- `filter_default => log`\n- `filters => []`\n- `formatter => {logger_formatter, DefaultFormatterConfig`\\}\n\nIn addition to these, the following fields are automatically inserted by Logger,\nvalues taken from the two first parameters to `logger:add_handler/3`:\n\n- `id => HandlerId`\n- `module => Module`\n\nThese are read-only and cannot be changed in runtime.\n\nHandler specific configuration data is inserted by the handler callback itself,\nin a sub structure associated with the field named `config`. See the\n`m:logger_std_h` and `m:logger_disk_log_h` manual pages for information about\nthe specific configuration for these handlers.\n\nSee the [`logger_formatter`](`t:logger_formatter:config/0`) manual page for\ninformation about the default configuration for this formatter.","ref":"logger_handler.html#t:config/0"},{"type":"callback","title":"logger_handler.filter_config/1","doc":"The function is called when one of the Logger API functions for fetching the\nhandler configuration is called, for example `logger:get_handler_config/1`.\n\nIt allows the handler to remove internal data fields from its configuration data\nbefore it is returned to the caller.","ref":"logger_handler.html#c:filter_config/1"},{"type":"type","title":"logger_handler.id/0","doc":"A unique identifier for a handler instance.","ref":"logger_handler.html#t:id/0"},{"type":"callback","title":"logger_handler.log/2","doc":"The function is called when all primary filters and all handler filters for the\nhandler in question have passed for the given log event. It is called on the\nclient process, that is, the process that issued the log event.\n\nThe handler identity is associated with the `id` key in `Config`.\n\nThe handler must log the event.\n\nThe return value from this function is ignored by Logger.","ref":"logger_handler.html#c:log/2"},{"type":"type","title":"logger_handler.olp_config/0","doc":"Overload protection configuration.\n\nSee [Protecting the Handler from Overload](logger_chapter.md#protecting-the-handler-from-overload)\nfor more details.","ref":"logger_handler.html#t:olp_config/0"},{"type":"callback","title":"logger_handler.removing_handler/1","doc":"The function is called on a temporary process when a handler is about to be\nremoved. The purpose is to release all resources used by the handler.\n\nThe handler identity is associated with the `id` key in `Config`.\n\nThe return value is ignored by Logger.","ref":"logger_handler.html#c:removing_handler/1"},{"type":"module","title":"logger_std_h","doc":"Standard handler for Logger.\n\nThis is the standard handler for Logger. Multiple instances of this handler can\nbe added to Logger, and each instance prints logs to\n[`standard_io`](`t:io:standard_io/0`),\n[`standard_error`](`t:io:standard_error/0`), or to file.\n\nThe handler has an overload protection mechanism that keeps the handler process\nand the Kernel application alive during high loads of log events. How overload\nprotection works, and how to configure it, is described in the\n[`User's Guide`](logger_chapter.md#overload_protection).\n\nTo add a new instance of the standard handler, use\n[`logger:add_handler/3`](`logger:add_handler/3`). The handler configuration\nargument is a map which can contain general configuration parameters, as\ndocumented in the [`User's Guide`](logger_chapter.md#handler-configuration),\nand handler specific parameters. The specific data is stored in a sub map with\nthe key `config`, and can contain the following parameters:\n\n- **`type = ` `t:io:standard_io/0` ` | ` `t:io:standard_error/0` ` | file | {device, ` `t:io:device/0` `}`**{: #type } -\n  Specifies the log destination.\n\n  The value is set when the handler is added, and it cannot be changed in\n  runtime.\n\n  Defaults to [`standard_io`](`t:io:standard_io/0`), unless parameter\n  [`file`](`m:logger_std_h#file`) is given, in which case it defaults to `file`.\n\n- **`file = ` `t:file:filename/0`**{: #file } - This specifies the name of the\n  log file when the handler is of type `file`.\n\n  The value is set when the handler is added, and it cannot be changed in\n  runtime.\n\n  Defaults to the same name as the handler identity, in the current directory.\n\n- **`modes = [` `t:file:mode/0` `]`**{: #modes } - This specifies the file modes\n  to use when opening the log file, see `file:open/2`. If `modes` are not\n  specified, the default list used is `[raw,append,delayed_write]`. If `modes`\n  are specified, the list replaces the default modes list with the following\n  adjustments:\n\n  - If `raw` is not found in the list, it is added.\n  - If none of `write`, `append` or `exclusive` is found in the list, `append`\n    is added.\n  - If none of `delayed_write` or `{delayed_write,Size,Delay}` is found in the\n    list, `delayed_write` is added.\n\n  Log files are always UTF-8 encoded. The encoding cannot be changed by setting\n  the mode `{encoding,Encoding}`.\n\n  The value is set when the handler is added, and it cannot be changed in\n  runtime.\n\n  Defaults to `[raw,append,delayed_write]`.\n\n- **`max_no_bytes = ` `t:pos_integer/0` ` | infinity`{: #max_no_bytes }** - This\n  parameter specifies if the log file should be rotated or not. The value\n  `infinity` means the log file will grow indefinitely, while an integer value\n  specifies at which file size (bytes) the file is rotated.\n\n  Defaults to `infinity`.\n\n- **`max_no_files = ` `t:non_neg_integer/0`**{: #max_no_files } - This parameter\n  specifies the number of rotated log file archives to keep. This has meaning\n  only if [`max_no_bytes`](`m:logger_std_h#max_no_bytes`) is set to an integer\n  value.\n\n  The log archives are named `FileName.0`, `FileName.1`, ... `FileName.N`, where\n  `FileName` is the name of the current log file. `FileName.0` is the newest of\n  the archives. The maximum value for `N` is the value of `max_no_files`\n  minus 1.\n\n  Notice that setting this value to `0` does not turn off rotation. It only\n  specifies that no archives are kept.\n\n  Defaults to `0`.\n\n- **`compress_on_rotate = ` `t:boolean/0`**{: #compress_on_rotate } - This parameter\n  specifies if the rotated log file archives shall be compressed or not. If set\n  to `true`, all archives are compressed with `gzip`, and renamed to\n  `FileName.N.gz`\n\n  `compress_on_rotate` has no meaning if\n  [`max_no_bytes`](`m:logger_std_h#max_no_bytes`) has the value `infinity`.\n\n  Defaults to `false`.\n\n- **`file_check = ` `t:non_neg_integer/0`**{: #file_check } - When `logger_std_h`\n  logs to a file, it reads the file information of the log file prior to each\n  write operation. This is to make sure the file still exists and has the same\n  inode as when it was opened. This implies some performance loss, but ensures\n  that no log events are lost in the case when the file has been removed or\n  renamed by an external actor.\n\n  In order to allow minimizing the performance loss, the `file_check` parameter\n  can be set to a positive integer value, `N`. The handler will then skip\n  reading the file information prior to writing, as long as no more than `N`\n  milliseconds have passed since it was last read.\n\n  Notice that the risk of losing log events grows when the `file_check` value\n  grows.\n\n  Defaults to 0.\n\n- **`filesync_repeat_interval = ` `t:pos_integer/0` ` | no_repeat`** - This value, in\n  milliseconds, specifies how often the handler does a file sync operation to\n  write buffered data to disk. The handler attempts the operation repeatedly,\n  but only performs a new sync if something has actually been logged.\n\n  If `no_repeat` is set as value, the repeated file sync operation is disabled,\n  and it is the operating system settings that determine how quickly or slowly\n  data is written to disk. The user can also call the `filesync/1` function to\n  perform a file sync.\n\n  Defaults to `5000` milliseconds.\n\nOther configuration parameters exist, to be used for customizing the overload\nprotection behaviour. The same parameters are used both in the standard handler\nand the disk_log handler, and are documented in the\n[`User's Guide`](logger_chapter.md#overload_protection).\n\nNotice that if changing the configuration of the handler in runtime, the `type`,\n`file`, or `modes` parameters must not be modified.\n\nExample of adding a standard handler:\n\n```erlang\nlogger:add_handler(my_standard_h, logger_std_h,\n                   #{config => #{file => \"./system_info.log\",\n                                 filesync_repeat_interval => 1000}}).\n```\n\nTo set the default handler, that starts initially with the Kernel application,\nto log to file instead of [`standard_io`](`t:io:standard_io/0`), change the\nKernel default logger configuration. Example:\n\n```text\nerl -kernel logger '[{handler,default,logger_std_h,\n                      #{config => #{file => \"./log.log\"}}}]'\n```\n\nAn example of how to replace the standard handler with a disk_log handler at\nstartup is found in the `m:logger_disk_log_h` manual.","ref":"logger_std_h.html"},{"type":"module","title":"See Also - logger_std_h","doc":"`m:logger`, `m:logger_disk_log_h`","ref":"logger_std_h.html#module-see-also"},{"type":"function","title":"logger_std_h.filesync/1","doc":"Write buffered data to disk.","ref":"logger_std_h.html#filesync/1"},{"type":"module","title":"wrap_log_reader","doc":"A service to read internally formatted wrap disk logs.\n\nThis module makes it possible to read internally formatted wrap disk logs, see\n`m:disk_log`. `m:wrap_log_reader` does not interfere with `m:disk_log` activities;\nthere is however a bug in this version of the `m:wrap_log_reader`, see section\n[Known Limitations](`m:wrap_log_reader#module-known-limitations`).\n\nA wrap disk log file consists of many files, called index files. A log file can\nbe opened and closed. Also, a single index file can be opened separately. If a\nnon-existent or non-internally formatted file is opened, an error message is\nreturned. If the file is corrupt, no attempt is made to repair it, but an error\nmessage is returned.\n\nIf a log is configured to be distributed, it is possible that all items are not\nlogged on all nodes. `m:wrap_log_reader` only reads the log on the called node; it\nis up to the user to be sure that all items are read.","ref":"wrap_log_reader.html"},{"type":"module","title":"Known Limitations - wrap_log_reader","doc":"This version of `m:wrap_log_reader` does not detect if `m:disk_log` wraps to a new\nindex file between a call to `wrap_log_reader:open/1` and the first call to\n`wrap_log_reader:chunk/1`. If this occurs, the call to `chunk/1` reads the last\nlogged items in the log file, as the opened index file was truncated by\n`m:disk_log`.","ref":"wrap_log_reader.html#module-known-limitations"},{"type":"function","title":"wrap_log_reader.chunk/1","doc":"Equivalent to  chunk(Continuation, infinity) .","ref":"wrap_log_reader.html#chunk/1"},{"type":"function","title":"wrap_log_reader.chunk/2","doc":"Enables to efficiently read the terms that are appended to a log. Minimises disk\nI/O by reading 64 kilobyte chunks from the file.\n\nThe first time `chunk/2` is called, an initial continuation returned from\n[`open/1`](`open/1`) or [`open/2`](`open/2`) must be provided.\n\nWhen `chunk/2` is called, `N` controls the maximum number of terms that are read\nfrom the log in each chunk. `infinity` means that all the\nterms contained in the 8K chunk are read. If less than `N` terms are returned,\nthis does not necessarily mean that end of file is reached.\n\nReturns a tuple `{Continuation2, Terms}`, where `Terms` is a list of terms found\nin the log. `Continuation2` is yet another continuation that must be passed on\nto any subsequent calls to `chunk()`. With a series of calls to `chunk()`, it is\nthen possible to extract all terms from a log.\n\nReturns a tuple `{Continuation2, Terms, Badbytes}` if the log is opened in read\nonly mode and the read chunk is corrupt. `Badbytes` indicates the number of\nnon-Erlang terms found in the chunk. Notice that the log is not repaired.\n\nReturns `{Continuation2, eof}` when the end of the log is reached, and\n`{error, Reason}` if an error occurs.\n\nThe returned continuation either is or is not valid in the next call to this\nfunction. This is because the log can wrap and delete the file into which the\ncontinuation points. To ensure this does not occur, the log can be blocked\nduring the search.","ref":"wrap_log_reader.html#chunk/2"},{"type":"type","title":"wrap_log_reader.chunk_ret/0","doc":"","ref":"wrap_log_reader.html#t:chunk_ret/0"},{"type":"function","title":"wrap_log_reader.close/1","doc":"Closes a log file properly.","ref":"wrap_log_reader.html#close/1"},{"type":"opaque","title":"wrap_log_reader.continuation/0","doc":"Continuation returned by `open/1,2` or `chunk/1,2`.","ref":"wrap_log_reader.html#t:continuation/0"},{"type":"function","title":"wrap_log_reader.open/1","doc":"Equivalent to [`open(Filename, ...)`](`open/2`) except that the whole\nwrap log file is read.","ref":"wrap_log_reader.html#open/1"},{"type":"function","title":"wrap_log_reader.open/2","doc":"`Filename` specifies the name of the file to be read.\n\n`N` specifies the index of the file to be read. Use `open/1` to read the entire\nwrap log.\n\nReturns `{ok, Continuation}` if the log/index file is opened successfully.\n`Continuation` is to be used when chunking or closing the file.\n\nReturns `{error, Reason}` for all errors.","ref":"wrap_log_reader.html#open/2"},{"type":"type","title":"wrap_log_reader.open_ret/0","doc":"","ref":"wrap_log_reader.html#t:open_ret/0"},{"type":"module","title":"seq_trace","doc":"Sequential tracing of information transfers.\n\nSequential tracing makes it possible to trace information flows between\nprocesses resulting from one initial transfer of information. Sequential tracing\nis independent of the ordinary tracing in Erlang, which is controlled by the\n`erlang:trace/3` BIF. For more information about what sequential tracing is and\nhow it can be used, see section [Sequential Tracing](`m:seq_trace#whatis`).\n\n`seq_trace` provides functions that control all aspects of sequential tracing.\nThere are functions for activation, deactivation, inspection, and for collection\nof the trace output.","ref":"seq_trace.html"},{"type":"module","title":"Trace Messages Sent to the System Tracer - seq_trace","doc":"The format of the messages is one of the following, depending on if flag\n`timestamp` of the trace token is set to `true` or `false`:\n\n```text\n{seq_trace, Label, SeqTraceInfo, TimeStamp}\n```\n\nor\n\n```text\n{seq_trace, Label, SeqTraceInfo}\n```\n\nWhere:\n\n```erlang\nLabel = int()\nTimeStamp = {Seconds, Milliseconds, Microseconds}\n  Seconds = Milliseconds = Microseconds = int()\n```\n\n`SeqTraceInfo` can have the following formats:\n\n- **`{send, Serial, From, To, Message}`** - Used when a process `From` with its\n  trace token flag `send` set to `true` has sent information. `To` may be a\n  process identifier, a registered name on a node represented as\n  `{NameAtom, NodeAtom}`, or a node name represented as an atom. `From` may be a\n  process identifier or a node name represented as an atom. `Message` contains\n  the information passed along in this information transfer. If the transfer is\n  done via message passing, it is the actual message.\n\n- **`{'receive', Serial, From, To, Message}`** - Used when a process `To`\n  receives information with a trace token that has flag `'receive'` set to\n  `true`. `To` may be a process identifier, or a node name represented as an\n  atom. `From` may be a process identifier or a node name represented as an\n  atom. `Message` contains the information passed along in this information\n  transfer. If the transfer is done via message passing, it is the actual\n  message.\n\n- **`{print, Serial, From, _, Info}`** - Used when a process `From` has called\n  `seq_trace:print(Label, TraceInfo)` and has a trace token with flag `print`\n  set to `true`, and `label` set to `Label`.\n\n`Serial` is a tuple `{PreviousSerial, ThisSerial}`, where:\n\n- Integer `PreviousSerial` denotes the serial counter passed in the last\n  received information that carried a trace token. If the process is the first\n  in a new sequential trace, `PreviousSerial` is set to the value of the process\n  internal \"trace clock\".\n- Integer `ThisSerial` is the serial counter that a process sets on outgoing\n  messages. It is based on the process internal \"trace clock\", which is\n  incremented by one before it is attached to the trace token in the message.\n\n[](){: #whatis }","ref":"seq_trace.html#module-trace-messages-sent-to-the-system-tracer"},{"type":"module","title":"Sequential Tracing - seq_trace","doc":"Sequential tracing is a way to trace a sequence of information transfers between\ndifferent local or remote processes, where the sequence is initiated by a single\ntransfer. The typical information transfer is an ordinary Erlang message passed\nbetween two processes, but information is transferred also in other ways. In\nshort, it works as follows:\n\nEach process has a _trace token_, which can be empty or not empty. When not\nempty, the trace token can be seen as the tuple `{Label, Flags, Serial, From}`.\nThe trace token is passed invisibly when information is passed between\nprocesses. In most cases the information is passed in ordinary messages between\nprocesses, but information is also passed between processes by other means. For\nexample, by spawning a new process. An information transfer between two\nprocesses is represented by a send event and a receive event regardless of how\nit is passed.\n\nTo start a sequential trace, the user must explicitly set the trace token in the\nprocess that will send the first information in a sequence.\n\nThe trace token of a process is set each time the process receives information.\nThis is typically when the process matches a message in a receive statement,\naccording to the trace token carried by the received message, empty or not.\n\nOn each Erlang node, a process can be set as the _system tracer_. This process\nwill receive trace messages each time information with a trace token is sent or\nreceived (if the trace token flag `send` or `'receive'` is set). The system\ntracer can then print each trace event, write it to a file, or whatever\nsuitable.\n\n> #### Note {: .info }\n>\n> The system tracer only receives those trace events that occur locally within\n> the Erlang node. To get the whole picture of a sequential trace, involving\n> processes on many Erlang nodes, the output from the system tracer on each\n> involved node must be merged (offline).\n\nThe following sections describe sequential tracing and its most fundamental\nconcepts.","ref":"seq_trace.html#module-sequential-tracing"},{"type":"module","title":"Different Information Transfers - seq_trace","doc":"Information flows between processes in a lot of different ways. Not all flows of\ninformation will be covered by sequential tracing. One example is information\npassed via ETS tables. Below is a list of information paths that are covered by\nsequential tracing:\n\n- **Message Passing** - All ordinary messages passed between Erlang processes.\n\n- **Exit signals** - An exit signal is represented as an `{'EXIT', Pid, Reason}`\n  tuple.\n\n- **Process Spawn** - A process spawn is represented as multiple information\n  transfers. At least one spawn request and one spawn reply. The actual amount\n  of information transfers depends on what type of spawn it is and may also\n  change in future implementations. Note that this is more or less an internal\n  protocol that you are peeking at. The spawn request will be represented as a\n  tuple with the first element containing the atom `spawn_request`, but this is\n  more or less all that you can depend on.\n\n> #### Note {: .info }\n>\n> If you do ordinary `send` or `receive` trace on the system, you will only see\n> ordinary message passing, not the other information transfers listed above.\n\n> #### Note {: .info }\n>\n> When a send event and corresponding receive event do not both correspond to\n> ordinary Erlang messages, the `Message` part of the trace messages may not be\n> identical. This since all information not necessarily are available when\n> generating the trace messages.","ref":"seq_trace.html#module-different-information-transfers"},{"type":"module","title":"Trace Token - seq_trace","doc":"Each process has a current trace token which is \"invisibly\" passed from the\nparent process on creation of the process.\n\nThe current token of a process is set in one of the following two ways:\n\n- Explicitly by the process itself, through a call to `seq_trace:set_token/1,2`\n- When information is received. This is typically when a received message is\n  matched out in a receive expression, but also when information is received in\n  other ways.\n\nIn both cases, the current token is set. In particular, if the token of a\nreceived message is empty, the current token of the process is set to empty.\n\nA trace token contains a label and a set of flags. Both the label and the flags\nare set in both alternatives above.","ref":"seq_trace.html#module-trace-token"},{"type":"module","title":"Serial - seq_trace","doc":"The trace token contains a component called `serial`. It consists of two\nintegers, `Previous` and `Current`. The purpose is to uniquely identify each\ntraced event within a trace sequence, as well as to order the messages\nchronologically and in the different branches, if any.\n\nThe algorithm for updating `Serial` can be described as follows:\n\nLet each process have two counters, `prev_cnt` and `curr_cnt`, both are set to\n`0` when a process is created outside of a trace sequence. The counters are\nupdated at the following occasions:\n\n- _When the process is about to pass along information to another process and\n  the trace token is not empty._ This typically occurs when sending a message,\n  but also, for example, when spawning another process.\n\n  Let the serial of the trace token be `tprev` and `tcurr`.\n\n  ```text\n  curr_cnt := curr_cnt + 1\n  tprev := prev_cnt\n  tcurr := curr_cnt\n  ```\n\n  The trace token with `tprev` and `tcurr` is then passed along with the\n  information passed to the other process.\n\n- _When the process calls_ `seq_trace:print(Label, Info)`, `Label` _matches the\n  label part of the trace token and the trace token print flag is `true`._\n\n  The algorithm is the same as for send above.\n\n- _When information is received that also contains a non-empty trace token. For\n  example, when a message is matched out in a receive expression, or when a new\n  process is spawned._\n\n  The process trace token is set to the trace token from the message.\n\n  Let the serial of the trace token be `tprev` and `tcurr`.\n\n  ```text\n  if (curr_cnt < tcurr )\n     curr_cnt := tcurr\n  prev_cnt := tcurr\n  ```\n\n`curr_cnt` of a process is incremented each time the process is involved in a\nsequential trace. The counter can reach its limit (27 bits) if a process is very\nlong-lived and is involved in much sequential tracing. If the counter overflows,\nthe serial for ordering of the trace events cannot be used. To prevent the\ncounter from overflowing in the middle of a sequential trace, function\n`seq_trace:reset_trace/0` can be called to reset `prev_cnt` and `curr_cnt` of\nall processes in the Erlang node. This function also sets all trace tokens in\nprocesses and their message queues to empty, and thus stops all ongoing\nsequential tracing.","ref":"seq_trace.html#module-serial"},{"type":"module","title":"Performance Considerations - seq_trace","doc":"The performance degradation for a system that is enabled for sequential tracing\nis negligible as long as no tracing is activated. When tracing is activated,\nthere is an extra cost for each traced message, but all other messages are\nunaffected.","ref":"seq_trace.html#module-performance-considerations"},{"type":"module","title":"Ports - seq_trace","doc":"Sequential tracing is not performed across ports.\n\nIf the user for some reason wants to pass the trace token to a port, this must\nbe done manually in the code of the port controlling process. The port\ncontrolling processes have to check the appropriate sequential trace settings\n(as obtained from `seq_trace:get_token/1`) and include trace information in the\nmessage data sent to their respective ports.\n\nSimilarly, for messages received from a port, a port controller has to retrieve\ntrace-specific information, and set appropriate sequential trace flags through\ncalls to `seq_trace:set_token/2`.","ref":"seq_trace.html#module-ports"},{"type":"module","title":"Distribution - seq_trace","doc":"Sequential tracing between nodes is performed transparently. This applies to\nC-nodes built with `Erl_Interface` too. A C-node built with `Erl_Interface` only\nmaintains one trace token, which means that the C-node appears as one process\nfrom the sequential tracing point of view.","ref":"seq_trace.html#module-distribution"},{"type":"module","title":"Example of Use - seq_trace","doc":"This example gives a rough idea of how the new primitives can be used and what\nkind of output it produces.\n\nAssume that you have an initiating process with `Pid == <0.30.0>` like this:\n\n```erlang\n-module(seqex).\n-compile(export_all).\n\nloop(Port) ->\n    receive\n        {Port,Message} ->\n            seq_trace:set_token(label,17),\n            seq_trace:set_token('receive',true),\n            seq_trace:set_token(print,true),\n            seq_trace:print(17,\"**** Trace Started ****\"),\n            call_server ! {self(),the_message};\n        {ack,Ack} ->\n            ok\n    end,\n    loop(Port).\n```\n\nAnd a registered process `call_server` with `Pid == <0.31.0>` like this:\n\n```erlang\nloop() ->\n    receive\n        {PortController,Message} ->\n            Ack = {received, Message},\n            seq_trace:print(17,\"We are here now\"),\n            PortController ! {ack,Ack}\n    end,\n    loop().\n```\n\nA possible output from the system's `sequential_tracer` can be like this:\n\n```erlang\n17:<0.30.0> Info {0,1} WITH\n\"**** Trace Started ****\"\n17:<0.31.0> Received {0,2} FROM <0.30.0> WITH\n{<0.30.0>,the_message}\n17:<0.31.0> Info {2,3} WITH\n\"We are here now\"\n17:<0.30.0> Received {2,4} FROM <0.31.0> WITH\n{ack,{received,the_message}}\n```\n\nThe implementation of a system tracer process that produces this printout can\nlook like this:\n\n```erlang\ntracer() ->\n    receive\n        {seq_trace,Label,TraceInfo} ->\n           print_trace(Label,TraceInfo,false);\n        {seq_trace,Label,TraceInfo,Ts} ->\n           print_trace(Label,TraceInfo,Ts);\n        _Other -> ignore\n    end,\n    tracer().\n\nprint_trace(Label,TraceInfo,false) ->\n    io:format(\"~p:\",[Label]),\n    print_trace(TraceInfo);\nprint_trace(Label,TraceInfo,Ts) ->\n    io:format(\"~p ~p:\",[Label,Ts]),\n    print_trace(TraceInfo).\n\nprint_trace({print,Serial,From,_,Info}) ->\n    io:format(\"~p Info ~p WITH~n~p~n\", [From,Serial,Info]);\nprint_trace({'receive',Serial,From,To,Message}) ->\n    io:format(\"~p Received ~p FROM ~p WITH~n~p~n\",\n              [To,Serial,From,Message]);\nprint_trace({send,Serial,From,To,Message}) ->\n    io:format(\"~p Sent ~p TO ~p WITH~n~p~n\",\n              [From,Serial,To,Message]).\n```\n\nThe code that creates a process that runs this tracer function and sets that\nprocess as the system tracer can look like this:\n\n```erlang\nstart() ->\n    Pid = spawn(?MODULE,tracer,[]),\n    seq_trace:set_system_tracer(Pid), % set Pid as the system tracer\n    ok.\n```\n\nWith a function like `test/0`, the whole example can be started:\n\n```erlang\ntest() ->\n    P = spawn(?MODULE, loop, [port]),\n    register(call_server, spawn(?MODULE, loop, [])),\n    start(),\n    P ! {port,message}.\n```","ref":"seq_trace.html#module-example-of-use"},{"type":"type","title":"seq_trace.component/0","doc":"","ref":"seq_trace.html#t:component/0"},{"type":"type","title":"seq_trace.flag/0","doc":"","ref":"seq_trace.html#t:flag/0"},{"type":"function","title":"seq_trace.get_system_tracer/0","doc":"Returns the pid, port identifier or tracer module of the current system tracer\nor `false` if no system tracer is activated.","ref":"seq_trace.html#get_system_tracer/0"},{"type":"function","title":"seq_trace.get_token/0","doc":"Returns the value of the trace token for the calling process. If `[]` is\nreturned, it means that tracing is not active. Any other value returned is the\nvalue of an active trace token. The value returned can be used as input to the\n[`set_token/1`](`set_token/1`) function.","ref":"seq_trace.html#get_token/0"},{"type":"function","title":"seq_trace.get_token/1","doc":"Returns the value of the trace token component `Component`. See `set_token/2`\nfor possible values of `Component` and `Val`.","ref":"seq_trace.html#get_token/1"},{"type":"function","title":"seq_trace.print/1","doc":"Puts the Erlang term `TraceInfo` into the sequential trace output if the calling\nprocess currently is executing within a sequential trace and the `print` flag of\nthe trace token is set.","ref":"seq_trace.html#print/1"},{"type":"function","title":"seq_trace.print/2","doc":"Same as [`print/1`](`print/1`) with the additional condition that `TraceInfo` is\noutput only if `Label` is equal to the label component of the trace token.","ref":"seq_trace.html#print/2"},{"type":"function","title":"seq_trace.reset_trace/0","doc":"Sets the trace token to empty for all processes on the local node. The process\ninternal counters used to create the serial of the trace token is set to 0. The\ntrace token is set to empty for all messages in message queues. Together this\nwill effectively stop all ongoing sequential tracing in the local node.","ref":"seq_trace.html#reset_trace/0"},{"type":"function","title":"seq_trace.set_system_tracer/1","doc":"Sets the system tracer. The system tracer can be either a process, port or\n[tracer module](`m:erl_tracer`) denoted by `Tracer`. Returns the previous value\n(which can be `false` if no system tracer is active).\n\nFailure: `{badarg, Info}}` if `Pid` is not an existing local pid.","ref":"seq_trace.html#set_system_tracer/1"},{"type":"function","title":"seq_trace.set_token/1","doc":"Sets the trace token for the calling process to `Token`. If `Token == []` then\ntracing is disabled, otherwise `Token` should be an Erlang term returned from\n`get_token/0` or [`set_token/1`](`set_token/1`). [`set_token/1`](`set_token/1`)\ncan be used to temporarily exclude message passing from the trace by setting the\ntrace token to empty like this:\n\n```erlang\nOldToken = seq_trace:set_token([]), % set to empty and save\n                                    % old value\n% do something that should not be part of the trace\nio:format(\"Exclude the signalling caused by this~n\"),\nseq_trace:set_token(OldToken), % activate the trace token again\n...\n```\n\nReturns the previous value of the trace token.","ref":"seq_trace.html#set_token/1"},{"type":"function","title":"seq_trace.set_token/2","doc":"Sets the individual `Component` of the trace token to `Val`. Returns the\nprevious value of the component.\n\n- **[`set_token(label, Label)`](`set_token/2`)** - The `label` component is a\n  term which identifies all events belonging to the same sequential trace. If\n  several sequential traces can be active simultaneously, `label` is used to\n  identify the separate traces. Default is 0.\n\n  > #### Warning {: .warning }\n  >\n  > Labels were restricted to small signed integers (28 bits) prior to OTP 21.\n  > The trace token will be silently dropped if it crosses over to a node that\n  > does not support the label.\n\n- **[`set_token(serial, SerialValue)`](`set_token/2`)** -\n  `SerialValue = {Previous, Current}`. The `serial` component contains counters\n  which enables the traced messages to be sorted, should never be set explicitly\n  by the user as these counters are updated automatically. Default is `{0, 0}`.\n\n- **[`set_token(send, Bool)`](`set_token/2`)** - A trace token flag\n  (`true | false`) which enables/disables tracing on information sending.\n  Default is `false`.\n\n- **[`set_token('receive', Bool)`](`set_token/2`)** - A trace token flag\n  (`true | false`) which enables/disables tracing on information reception.\n  Default is `false`.\n\n- **[`set_token(print, Bool)`](`set_token/2`)** - A trace token flag\n  (`true | false`) which enables/disables tracing on explicit calls to\n  `seq_trace:print/1`. Default is `false`.\n\n- **[`set_token(timestamp, Bool)`](`set_token/2`)** - A trace token flag\n  (`true | false`) which enables/disables a timestamp to be generated for each\n  traced event. Default is `false`.\n\n- **[`set_token(strict_monotonic_timestamp, Bool)`](`set_token/2`)** - A trace\n  token flag (`true | false`) which enables/disables a strict monotonic\n  timestamp to be generated for each traced event. Default is `false`.\n  Timestamps will consist of\n  [Erlang monotonic time](`e:erts:time_correction.md#erlang-monotonic-time`) and\n  a monotonically increasing integer. The time-stamp has the same format and\n  value as produced by\n  `{erlang:monotonic_time(nanosecond), erlang:unique_integer([monotonic])}`.\n\n- **[`set_token(monotonic_timestamp, Bool)`](`set_token/2`)** - A trace token\n  flag (`true | false`) which enables/disables a strict monotonic timestamp to\n  be generated for each traced event. Default is `false`. Timestamps will use\n  [Erlang monotonic time](`e:erts:time_correction.md#erlang-monotonic-time`).\n  The time-stamp has the same format and value as produced by\n  `erlang:monotonic_time(nanosecond)`.\n\nIf multiple timestamp flags are passed, `timestamp` has precedence over\n`strict_monotonic_timestamp` which in turn has precedence over\n`monotonic_timestamp`. All timestamp flags are remembered, so if two are passed\nand the one with highest precedence later is disabled the other one will become\nactive.","ref":"seq_trace.html#set_token/2"},{"type":"type","title":"seq_trace.token/0","doc":"An opaque term (a tuple) representing a trace token.","ref":"seq_trace.html#t:token/0"},{"type":"type","title":"seq_trace.tracer/0","doc":"","ref":"seq_trace.html#t:tracer/0"},{"type":"type","title":"seq_trace.value/0","doc":"","ref":"seq_trace.html#t:value/0"},{"type":"module","title":"trace","doc":"The Erlang trace interface.\n\nThe Erlang run-time system exposes several trace points that allow users\nto be notified when they are triggered. Trace points are things such as\nfunction calls, message sending and receiving, garbage collection, and\nprocess scheduling.\n\nThe functions in this module can be used directly, but can also be\nused as building blocks to build more sophisticated debugging or\nprofiling tools. For debugging Erlang code it is recommended to use\n`m:dbg` and for profiling to use `m:tprof`.","ref":"trace.html"},{"type":"module","title":"Trace Sessions - trace","doc":"All tracing is done within a trace session. Trace sessions can be\n[created](`session_create/3`) and [destroyed](`session_destroy/1`)\ndynamically. Each session has its own tracer that will receive all trace\nmessages. Several sessions can exist at the same time without interfering with\neach other. When a trace session is destroyed, all its trace settings are\nautomatically cleaned up.\n\n*Example*:\n\n```erlang\n%% Create a tracer process that will receive the trace events\n1> Tracer = spawn(fun F() -> receive M -> io:format(\"~p~n\",[M]), F() end end).\n<0.91.0>\n%% Create a session using the Tracer\n2> Session = trace:session_create(my_session, Tracer, []).\n{#Ref<0.1543805153.1548353537.92331>,{my_session, 0}}\n%% Setup call tracing on self()\n3> trace:process(Session, self(), true, [call]).\n1\n%% Setup call tracing on lists:seq/2\n4> trace:function(Session, {lists,seq,2}, [], []).\n1\n%% Call the traced function\n5> lists:seq(1, 10).\n{trace,<0.89.0>,call,{lists,seq,[1,10]}} % The trace message\n[1,2,3,4,5,6,7,8,9,10] % The return value\n%% Cleanup the trace session\n6> trace:session_destroy(Session).\nok\n```","ref":"trace.html#module-trace-sessions"},{"type":"module","title":"Node Local Tracing Only - trace","doc":"The functions in this module only operates on the local node. That is, both the\ntraced processes/ports as well as the tracer process/port/module must all reside\non the same local node as the call is made. To trace remote nodes use `m:dbg` or\n`m:ttb`.\n\n> #### Change {: .info }\n>\n> This `trace` module was introduced in OTP 27.0. The interface and semantics are\n> similar to the older functions `erlang:trace/3`, `erlang:trace_pattern/3`,\n> and `erlang:trace_info/2`.\n>\n> The main difference is the old functions operate on a single static\n> trace session per node. That could impose the problem that different\n> users and tools would interfere with each other's trace settings. The new trace\n> functions in this module all operate on dynamically created trace sesssions\n> isolated from each other. Also, this makes it easier to safely disable all trace\n> settings when done by a single call to `session_destroy/1`.\n>\n> To change an existing tool to use the interface the following table can be\n> useful:\n>\n> | Old function call                            | corresponds to                                                     |\n> | -------------------------------------------  | ------------------------------------------------------------------ |\n> | [`erlang:trace(Pid, ...)`][1]                | [`process(S, Pid, ...)`][p]                                        |\n> | [`erlang:trace(processes, ...)`][1]          | [`process(S, all, ...)`][p]                                        |\n> | [`erlang:trace(existing_processes, ...)`][1] | [`process(S, existing, ...)`][p]                                   |\n> | [`erlang:trace(new_processes, ...)`][1]      | [`process(S, new, ...)`][p]                                        |\n> | [`erlang:trace(Port, ...)`][1]               | [`port(S, Port, ...)`][o]                                          |\n> | [`erlang:trace(ports, ...)`][1]              | [`port(S, all, ...)`][o]                                           |\n> | [`erlang:trace(existing_ports, ...)`][1]     | [`port(S, existing, ...)`][o]                                      |\n> | [`erlang:trace(new_ports, ...)`][1]          | [`port(S, new, ...)`][o]                                           |\n> | [`erlang:trace(all, ...)`][1]                | [`process(S, all, ...)`][p] and [`port(S, all, ...)`][o]           |\n> | [`erlang:trace(existing, ...)`][1]           | [`process(S, existing, ...)`][p] and [`port(S, existing, ...)`][o] |\n> | [`erlang:trace(new, ...)`][1]                | [`process(S, new, ...)`][p] and [`port(S, new, ...)`][o]           |\n> | [`erlang:trace_pattern(MFA, ...)`][2]        | [`function(S, MFA, ...)`][f]                                       |\n> | [`erlang:trace_pattern(send, ...)`][2]       | [`send(S, ...)`][s]                                                |\n> | [`erlang:trace_pattern('receive', ...)`][2]  | [`recv(S, ...)`][r]                                                |\n> | [`erlang:trace_info(...)`][3]                | [`info(S, ...)`][i]                                                |\n>\n> Argument `S` is the trace session that must first be created with\n> `session_create/3`. The other arguments (implied by `...`) are mostly the\n> same. The only other difference is that the tracer is always the tracer\n> specified when the session was created. Options `{tracer,T}`, `{tracer,M,S}`,\n> `{meta,T}`, and `{meta,M,S}` are therefore not allowed, and the default tracer is\n> never the calling process.\n\n[1]: `erlang:trace/3`\n[2]: `erlang:trace_pattern/3`\n[3]: `erlang:trace_info/2`\n[p]: `process/4`\n[o]: `port/4`\n[f]: `function/4`\n[s]: `send/3`\n[r]: `recv/3`\n[i]: `info/3`","ref":"trace.html#module-node-local-tracing-only"},{"type":"function","title":"trace.delivered/2","doc":"Equivalent to [`erlang:trace_delivered(Tracee)`](`erlang:trace_delivered/1`)\nexcept that it is run within the given `t:session/0`.","ref":"trace.html#delivered/2"},{"type":"function","title":"trace.function/4","doc":"Enable or disable _call tracing_ for one or more functions.\n\nMust be combined with `process/4` to set the `call` trace flag for one or more\nprocesses.\n\nConceptually, call tracing works as follows. In each trace session, a\nset of processes and a set of functions have been marked for\ntracing. If a traced process calls a traced function, the trace action\nis taken. Otherwise, nothing happens.\n\nTo add or remove one or more processes to the set of traced processes, use\n`process/4`.\n\nUse this function to add or remove functions to the set of traced functions\nin a trace session.\n\nArgument `Session` is the trace session to operate on as returned by\n`session_create/3`.\n\nArgument **`MFA`** is to be a tuple, such as `{Module, Function, Arity}`, or the\natom `on_load` (described below). The `MFA` tuple specifies the module,\nfunction, and arity for the functions to be traced. The atom `'_'` can be used\nas a wildcard in any of the following ways:\n\n- **`{Module,Function,'_'}`** - All functions of any arity named `Function` in\n  module `Module`.\n\n- **`{Module,'_','_'}`** - All functions in module `Module`.\n\n- **`{'_','_','_'}`** - All functions in all loaded modules.\n\nOther combinations, such as `{Module,'_',Arity}`, are not allowed.\n\nIf argument `MFA` is the atom `on_load`, the match specification and flag list\nare used on all functions in all modules that are newly loaded.\n\nArgument **`MatchSpec`** can take the following forms:\n\n- **`true`** - Enable tracing for the matching functions. Any match\n  specification is removed.\n\n- **`false`** - Disable tracing for the matching functions. Any match\n  specification is removed.\n\n- **`MatchExpression`** - A match specification. An empty list is equivalent to\n  `true`. For a description of match specifications, see section\n  [Match Specifications in Erlang](`e:erts:match_spec.md`) in the User's Guide\n  for the ERTS application.\n\n- **`restart`** - For the `FlagList` options `call_count`, `call_time` and\n  `call_memory`: restarts the existing counters. The behavior is undefined for\n  other `FlagList` options.\n\n- **`pause`** - For the `FlagList` options `call_count`, `call_time` and\n  `call_memory`: pauses the existing counters. The behavior is undefined for\n  other `FlagList` options.\n\nArgument **`FlagList`** is a list of options. The following are the valid options:\n\n- **`global`** - Turn on or off call tracing for global function calls (that\n  is, calls specifying the module explicitly). Only exported functions match and\n  only global calls generate trace messages. **This is the default if `FlagList`\n  is empty**.\n\n- **`local`** - Turn on or off call tracing for all types of function calls.\n  Trace messages are sent whenever any of the specified functions are called,\n  regardless of how they are called. If flag `return_to` is set for the process,\n  a `return_to` message is also sent when this function returns to its caller.\n\n- **`meta`** - Turn on or off meta-tracing for all types of function\n  calls. Trace messages are sent to the tracer whenever any of the specified\n  functions are called.\n\n  Meta-tracing traces all processes and does not care about the process trace\n  flags set by `process/4`, the trace flags are instead fixed to\n  `[call, timestamp]`.\n\n  The match specification function `{return_trace}` works with meta-trace.\n\n- **`call_count`**{: #call_count } - Start (`MatchSpec == true`) or stop\n  (`MatchSpec == false`) call count tracing for all types of function calls. For\n  every function, a counter is incremented when the function is called, in any\n  process. No process trace flags need to be activated.\n\n  If call count tracing is started while already running, the count is restarted\n  from zero. To pause running counters, use `MatchSpec == pause`. Paused and\n  running counters can be restarted from zero with `MatchSpec == restart`.\n\n  To read the counter value for a function, call\n  [`trace:info(_, MFA, call_count)`](`info/3`).\n\n- **`call_time`**{: #call_time } - Start (`MatchSpec` is `true`) or stops (`MatchSpec` is `false`)\n  call time tracing for all types of function calls. For every function, a\n  counter is incremented when the function is called and the time spent in the\n  function is measured and accumulated in another counter. The counters are\n  stored for each call traced process.\n\n  If call time tracing is started while already running, the count and time\n  restart from zero. To pause running counters, use `MatchSpec == pause`. Paused\n  and running counters can be restarted from zero with `MatchSpec == restart`.\n\n  To read the counter values, use `info/3`.\n\n- **`call_memory`**{: #call_memory } - Start (`MatchSpec == true`) or stop\n  (`MatchSpec == false`) call memory tracing for all types of function calls.\n  For every function, a counter is incremented when the function is called and\n  the memory consumed by the function is measured and accumulated in another\n  counter. Separate counters are stored for each call traced process.\n\n  If call memory tracing is started while already running, counters and\n  allocations restart from zero. To pause running counters, use\n  `MatchSpec == pause`. Paused and running counters can be restarted from zero\n  with `MatchSpec == restart`.\n\n  To read the counter value, use `info/3`.\n\nOption `global` cannot be combined with any of the other options, which all\nperform some kind of local tracing. If global tracing is specified for\na set of functions, then `local`, `meta`, `call_count`, `call_time`,\nand `call_memory` tracing for the matching set of functions are\ndisabled, and vice versa.\n\nWhen disabling trace, the option must match the type of trace set on the\nfunction. That is, local tracing must be disabled with option `local` and global\ntracing with option `global` (or no option), and so on.\n\nPart of a match specification cannot be changed directly. If a function has\na match specification, it can be replaced with a new one. Function `info/3` can\nbe used to retrieve the existing match specification.\n\nReturns the number of functions matching argument `MFA`. Zero is returned if\nnone matched or if `on_load` was specified.\n\nFails by raising an error exception with an error reason of:\n\n- **`badarg`** - If an argument is invalid.\n\n- **`system_limit`** - If a match specification passed as argument has excessive\n  nesting which causes scheduler stack exhaustion for the scheduler that the\n  calling process is executing on.\n  [Scheduler stack size](`e:erts:erl_cmd.md#sched_thread_stack_size`) can be configured\n  when starting the runtime system.","ref":"trace.html#function/4"},{"type":"function","title":"trace.info/3","doc":"Return trace information about a port, process, function, or event.\n\nArgument `Session` is the trace session to inspect as returned by\n`session_create/3` or `session_info/1`.\n\n**To get information about a port or process**, `PidPortFuncEvent` is to be a\nprocess identifier (pid), port identifier, or one of the atoms `new`,\n`new_processes`, or `new_ports`. The atom `new` or `new_processes` means that\nthe default trace state for processes to be created is returned. The atom\n`new_ports` means that the default trace state for ports to be created is\nreturned.\n\nValid `Item` values for ports and processes:\n\n- **`flags`** - Returns a list of atoms indicating what kind of traces is\n  enabled for the process. The list is empty if no traces are enabled, and one\n  or more of [`trace_info_flag()`](`t:trace_info_flag/0`) if traces are enabled.\n  The order is arbitrary.\n\n- **`tracer`** - Returns the identifier for process, port, or a tuple containing\n  the tracer module and tracer state tracing this process. If this process is\n  not traced, the return value is `[]`.\n\n**To get information about a function**, `PidPortFuncEvent` is to be the\nthree-element tuple `{Module, Function, Arity}` or the atom `on_load`. No\nwildcards are allowed. Returns `undefined` if the function does not exist or\n`false` if the function is not traced. If `PidPortFuncEvent` is `on_load`, the\ninformation returned refers to the default value for code that will be loaded.\n\nValid `Item` values for functions:\n\n- **`traced`** - Returns `global` if this function is traced on global function\n  calls, `local` if this function is traced on local function calls (that is,\n  local and global function calls), and `false` if local or global function\n  calls are not traced.\n\n- **`match_spec`** - Returns the match specification for this function, if it\n  has one. If the function is locally or globally traced but has no match\n  specification defined, the returned value is `[]`.\n\n- **`meta`** - Returns the meta-trace tracer process, port, or trace module for\n  this function, if it has one. If the function is not meta-traced, the returned\n  value is `false`. If the function is meta-traced but has once detected that\n  the tracer process is invalid, the returned value is `[]`.\n\n- **`meta_match_spec`** - Returns the meta-trace match specification for this\n  function, if it has one. If the function is meta-traced but has no match\n  specification defined, the returned value is `[]`.\n\n- **`call_count`** - Returns the call count value for this function or `true`\n  for the pseudo function `on_load` if call count tracing is active. Otherwise\n  `false` is returned.\n\n  See also `function/4`.\n\n- **`call_time`** - Returns the call time values for this function or `true` for\n  the pseudo function `on_load` if call time tracing is active. Otherwise\n  `false` is returned. The call time values returned, `[{Pid, Count, S, Us}]`,\n  is a list of each process that executed the function and its specific\n  counters. `Count` is the call count. `S` and `Us` are the accumulated call\n  time expressed in seconds and microseconds.\n\n  See also `function/4`.\n\n- **`call_memory`** - Returns the accumulated number of words allocated by this\n  function. Accumulation stops at the next memory traced function: if there are\n  `outer`, `middle` and `inner` functions each allocating 3 words, but only\n  `outer` is traced, it will report 9 allocated words. If `outer` and `inner`\n  are traced, 6 words are reported for `outer` and 3 for `inner`. When function\n  is not traced, `false` is returned. Returned tuple is `[{Pid, Count, Words}]`,\n  for each process that executed the function.\n\n  See also `function/4`.\n\n- **`all`** - Returns a list containing the `{Item, Value}` tuples for all other\n  items, or returns `false` if no tracing is active for this function.\n\n**To get information about an event**, `PidPortFuncEvent` is to be one of the\natoms `send` or `'receive'`.\n\nOne valid `Item` for events exists:\n\n- **`match_spec`** - Returns the match specification for this event, if it has\n  one, or `true` if no match specification has been set.\n\n**To get information about monitored system events**, `PidPortFuncEvent` is to\n  be the atom `system`.\n\nOnly valid `Item` for `system` is\n\n- **`all`** - Returns a list of all monitored system events enabled by\n    `system/3`.\n\nThe return value is `{Item, Value}`, where `Value` is the requested information\nas described earlier. If a pid for a dead process was specified, or the name of\na non-existing function, `Value` is `undefined`.","ref":"trace.html#info/3"},{"type":"type","title":"trace.match_variable/0","doc":"","ref":"trace.html#t:match_variable/0"},{"type":"function","title":"trace.port/4","doc":"Turn on or off trace flags for one or more ports.\n\nArgument `Session` is the trace session to operate on as returned by\n`session_create/3`.\n\n`Ports` is either a port identifier for a local port or one of the following atoms:\n\n- **`all`** - All currently existing ports and all that will be\n  created in the future.\n\n- **`existing`** - All currently existing ports.\n\n- **`new`** - All ports that will be created in the future.\n\n`FlagList` can contain any number of the following flags (the \"message tags\"\nrefers to the list of [`trace messages`](#port_trace_messages)):\n\n- **`all`** - Sets all trace flags except `cpu_timestamp`, which are in its\n    nature different than the others.\n\n- **`send`** - Traces sending of messages.\n\n  Message tags: [`send`](#port_trace_messages_send) and\n  [`send_to_non_existing_process`](#port_trace_messages_send_to_non_existing_process).\n\n- **`'receive'`** - Traces receiving of messages.\n\n  Message tags: [`'receive'`](#port_trace_messages_receive).\n\n- **`ports`** - Traces port-related events.\n\n  Message tags: [`open`](#port_trace_messages_open),\n  [`closed`](#port_trace_messages_closed),\n  [`register`](#port_trace_messages_register),\n  [`unregister`](#port_trace_messages_unregister),\n  [`getting_linked`](#port_trace_messages_getting_linked), and\n  [`getting_unlinked`](#port_trace_messages_getting_unlinked).\n\n- **`running_ports`** - Traces scheduling of ports.\n\n  Message tags: [`in`](#port_trace_messages_in_port) and\n  [`out`](#port_trace_messages_out_port).\n\n- **`timestamp`**, **`cpu_timestamp`**, **`monotonic_timestamp`**,\n  **`strict_monotonic_timestamp`** - Same as for timestamps in\n  [`process/4`](#timestamp).\n\nThe tracing process receives the _trace messages_ described in the following\nlist. `Port` is the port identifier of the traced port in which the traced\nevent has occurred. The third tuple element is the message tag.\n\nIf flag `timestamp`, `strict_monotonic_timestamp`, or `monotonic_timestamp` is\nspecified, the first tuple element is `trace_ts` instead, and the time stamp is\nadded as an extra element last in the message tuple. If multiple time stamp\nflags are passed, `timestamp` has precedence over `strict_monotonic_timestamp`,\nwhich in turn has precedence over `monotonic_timestamp`. All time stamp flags\nare remembered, so if two are passed and the one with highest precedence later\nis disabled, the other one becomes active.\n\nIf a match specification (applicable only for `send` and `'receive'`\ntracing) contains a `{message}` action function with a non-boolean value, that\nvalue is added as an extra element to the message tuple either in the last\nposition or before the timestamp (if it is present).\n\nTrace messages:\n\n[](){: #port_trace_messages }\n\n- **`{trace, Port, send, Msg, To}`{: #port_trace_messages_send }** - When\n  `Port` sends message `Msg` to process `To`.\n\n- **`{trace, Port, send_to_non_existing_process, Msg, To}`{:\n  #port_trace_messages_send_to_non_existing_process }** - When `Port`\n  sends message `Msg` to the non-existing process `To`.\n\n- **`{trace, Port, 'receive', Msg}`{: #port_trace_messages_receive }** -\n  When `Port` receives message `Msg`. If `Msg` is set to time-out, a receive\n  statement can have timed out, or the process received a message with the\n  payload `timeout`.\n\n- **`{trace, Port, register, RegName}`{: #port_trace_messages_register\n  }** - When `Port` gets the name `RegName` registered.\n\n- **`{trace, Port, unregister, RegName}`{: #port_trace_messages_unregister\n  }** - When `Port` gets the name `RegName` unregistered. This is done\n  automatically when a registered process or port exits.\n\n- **`{trace, Port, getting_linked, Pid2}`{:\n  #port_trace_messages_getting_linked }** - When `Port` gets linked to a\n  process `Pid2`.\n\n- **`{trace, Port, getting_unlinked, Pid2}`{:\n  #port_trace_messages_getting_unlinked }** - When `Port` gets unlinked\n  from a process `Pid2`.\n\n- **`{trace, Port, open, Pid, Driver}`{: #port_trace_messages_open }** - When\n  `Pid` opens a new port `Port` with the running `Driver`.\n\n  `Driver` is the name of the driver as an atom.\n\n- **`{trace, Port, closed, Reason}`{: #port_trace_messages_closed }** - When\n  `Port` closes with `Reason`.\n\n- **`{trace, Port, in, Command | 0}`{: #port_trace_messages_in_port }** -\n  When `Port` is scheduled to run. `Command` is the first thing the port will\n  execute, it can however run several commands before being scheduled out. On\n  some rare occasions, the current function cannot be determined, then the last\n  element is `0`.\n\n  The possible commands are `call`, `close`, `command`, `connect`, `control`,\n  `flush`, `info`, `link`, `open`, and `unlink`.\n\n- **`{trace, Port, out, Command | 0}`{: #port_trace_messages_out_port }** -\n  When `Port` is scheduled out. The last command run was `Command`. On some rare\n  occasions, the current function cannot be determined, then the last element is\n  `0`. `Command` can contain the same commands as `in`\n\nIf the tracing process/port dies or the tracer module returns `remove`, the\nflags are silently removed.\n\nReturns a number indicating the number of ports that matched `Ports`.\nIf `Ports` is a port identifier, the return value is `1`. If\n`Ports` is `all` or `existing`, the return value is the number of\nexisting ports. If `Ports` is `new`, the return value is `0`.\n\nFailure: `badarg` if the specified arguments are not supported. For example,\n`cpu_timestamp` is not supported on all platforms.","ref":"trace.html#port/4"},{"type":"function","title":"trace.process/4","doc":"Turn on or off trace flags for one or more processes.\n\nArgument `Session` is the trace session to operate on as returned by\n`session_create/3`.\n\nArgument `Procs` is either a process identifier (pid) for a local process or\none of the following atoms:\n\n- **`all`** - All currently existing processes and all that will be\n  created in the future.\n\n- **`existing`** - All currently existing processes.\n\n- **`new`** - All processes that will be created in the future.\n\nArgument `How` is either `true` to turn on trace flags or `false` to turn them off.\n\nArgument `FlagList` can contain any number of the following flags (the \"message\ntags\" refers to the list of [`trace messages`](#process_trace_messages)):\n\n- **`all`** - Sets all trace flags except `cpu_timestamp`, which\n  is in its nature different than the others.\n\n- **`send`** - Traces sending of messages. Limit which sent messages to trace by\n    calling `send/3`.\n\n  Message tags: [`send`](#process_trace_messages_send) and\n  [`send_to_non_existing_process`](#process_trace_messages_send_to_non_existing_process).\n\n- **`'receive'`** - Traces receiving of messages. Limit which received messages\n    to trace by calling `recv/3`.\n\n  Message tags: [`'receive'`](#process_trace_messages_receive).\n\n- **`call`** - Traces certain function calls. Specify which function calls to\n  trace by calling `function/4`.\n\n  Message tags: [`call`](#process_trace_messages_call) and\n  [`return_from`](#process_trace_messages_return_from).\n\n- **`silent`** - Used with the `call` trace flag. The `call`, `return_from`, and\n  `return_to` trace messages are inhibited if this flag is set, but they are\n  executed as normal if there are match specifications.\n\n  Silent mode is inhibited by executing `trace:process(_, _, false, [silent|_])`, or\n  by a match specification executing the function `{silent, false}`.\n\n  The `silent` trace flag facilitates setting up a trace on many or even all\n  processes in the system. The trace can then be activated and deactivated using\n  the match specification function `{silent,Bool}`, giving a high degree of\n  control of which functions with which arguments that trigger the trace.\n\n  Message tags: [`call`](#process_trace_messages_call),\n  [`return_from`](#process_trace_messages_return_from), and\n  [`return_to`](#process_trace_messages_return_to). Or rather, the\n  absence of.\n\n- **`return_to`** - Used with the `call` trace flag. Traces the exit from\n  call traced functions back to where the execution resumes. Only works for\n  functions traced with option `local` to `function/4`.\n\n  The semantics is that a `return_to` trace message is sent when a call traced\n  function returns or throws and exception that is caught. For tail calls, only\n  one trace message is sent per chain of tail calls, so the properties of tail\n  recursiveness for function calls are kept while tracing with this\n  flag. Similar for exceptions, only one `return_to` trace message is sent, even\n  if the exception passed more than one call traced function before it was\n  caught.\n\n  Using `call` and `return_to` trace together makes it possible to know exactly\n  in which function a process executes at any time.\n\n  To get trace messages containing return values from functions, use the\n  `{return_trace}` match specification action instead.\n\n  Message tags: [`return_to`](#process_trace_messages_return_to).\n\n- **`procs`** - Traces process-related events.\n\n  Message tags: [`spawn`](#process_trace_messages_spawn),\n  [`spawned`](#process_trace_messages_spawned),\n  [`exit`](#process_trace_messages_exit),\n  [`register`](#process_trace_messages_register),\n  [`unregister`](#process_trace_messages_unregister),\n  [`link`](#process_trace_messages_link),\n  [`unlink`](#process_trace_messages_unlink),\n  [`getting_linked`](#process_trace_messages_getting_linked), and\n  [`getting_unlinked`](#process_trace_messages_getting_unlinked).\n\n- **`running`** - Traces scheduling of processes.\n\n  Message tags: [`in`](#process_trace_messages_in_proc) and\n  [`out`](#process_trace_messages_out_proc).\n\n- **`exiting`** - Traces scheduling of exiting processes.\n\n  Message tags:\n  [`in_exiting`](#process_trace_messages_in_exiting_proc),\n  [`out_exiting`](#process_trace_messages_out_exiting_proc), and\n  [`out_exited`](#process_trace_messages_out_exited_proc).\n\n- **`running_procs`** - Traces scheduling of processes just like `running`.\n  However, this option also includes schedule events when the process executes\n  within the context of a port without being scheduled out itself.\n\n  Message tags: [`in`](#process_trace_messages_in_proc) and\n  [`out`](#process_trace_messages_out_proc).\n\n- **`garbage_collection`** - Traces garbage collections of processes.\n\n  Message tags:\n  [`gc_minor_start`](#process_trace_messages_gc_minor_start),\n  [`gc_max_heap_size`](#process_trace_messages_gc_max_heap_size), and\n  [`gc_minor_end`](#process_trace_messages_gc_minor_end).\n\n- **`timestamp`{: #timestamp }** - Includes a time stamp in all trace\n  messages. The time stamp (Ts) has the same form as returned by\n  `erlang:now/0`.\n\n- **`cpu_timestamp`** - A global trace flag for the Erlang node that makes all\n  trace time stamps using flag `timestamp` to be in CPU time, not wall clock\n  time. That is, `cpu_timestamp` is not be used if `monotonic_timestamp` or\n  `strict_monotonic_timestamp` is enabled. Only allowed with `Procs==all`.\n  If the host machine OS does not support high-resolution CPU time measurements,\n  `process/4` exits with `badarg`. Notice that most OS do not\n  synchronize this value across cores, so be prepared that time can seem to go\n  backwards when using this option.\n\n- **`monotonic_timestamp`** - Includes an\n  [Erlang monotonic time](`e:erts:time_correction.md#erlang-monotonic-time`) time stamp\n  in all trace messages. The time stamp (Ts) has the same format and value as\n  produced by [`erlang:monotonic_time(nanosecond)`](`erlang:monotonic_time/1`). This\n  flag overrides flag `cpu_timestamp`.\n\n- **`strict_monotonic_timestamp`** - Includes an time stamp consisting of\n  [Erlang monotonic time](`e:erts:time_correction.md#erlang-monotonic-time`) and a\n  monotonically increasing integer in all trace messages. The time stamp (Ts)\n  has the same format and value as produced by `{`\n  [`erlang:monotonic_time(nanosecond)`](`erlang:monotonic_time/1`)`,`\n  [`erlang:unique_integer([monotonic])`](`erlang:unique_integer/1`)`}`. This flag\n  overrides flag `cpu_timestamp`.\n\n  If multiple time stamp flags are passed, `timestamp` has precedence over\n  `strict_monotonic_timestamp`, which in turn has precedence over\n  `monotonic_timestamp`. All time stamp flags are remembered, so if two are\n  passed and the one with highest precedence later is disabled, the other one\n  becomes active.\n\n- **`arity`** - Used with the `call` trace flag. `{M, F, Arity}` is specified\n  instead of `{M, F, Args}` in call trace messages.\n\n- **`set_on_spawn`** - Makes any process created by a traced process inherit all\n  its trace flags, including flag `set_on_spawn` itself.\n\n- **`set_on_first_spawn`** - Makes the first process created by a traced process\n  inherit all its trace flags, excluding flag `set_on_first_spawn` itself. That\n  is, after the first spawn is done, `set_on_first_spawn` will be cleared in\n  both the spawned process and the spawning process.\n\n  If both are set, `set_on_first_spawn` will supersede `set_on_spawn`.\n\n- **`set_on_link`** - Makes any process linked by a traced process inherit all\n  its trace flags, including flag `set_on_link` itself.\n\n- **`set_on_first_link`** - Makes the first process linked to by a traced\n  process inherit all its trace flags, excluding flag `set_on_first_link`\n  itself. That is, after the first link is done, `set_on_first_link` will be\n  cleared in both the linked process and the linking process.\n\n  If both are set, `set_on_first_link` will supersede `set_on_link`.\n\nThe tracing process receives the _trace messages_ described in the following\nlist. `Pid` is the process identifier of the traced process in which the traced\nevent has occurred. The third tuple element is the message tag.\n\nIf flag `timestamp`, `strict_monotonic_timestamp`, or `monotonic_timestamp` is\nspecified, the first tuple element is `trace_ts` instead, and the time stamp is\nadded as an extra element last in the message tuple.\n\nIf a match specification (applicable only for `call`, `send`, and `'receive'`\ntracing) contains a `{message}` action function with a non-boolean value, that\nvalue is added as an extra element to the message tuple either in the last\nposition or before the timestamp (if it is present).\n\nTrace messages:\n\n[](){: #process_trace_messages }\n\n- **`{trace, Pid, send, Msg, To}`{: #process_trace_messages_send }** - When\n  process `Pid` sends message `Msg` to process `To`.\n\n- **`{trace, Pid, send_to_non_existing_process, Msg, To}`{:\n  #process_trace_messages_send_to_non_existing_process }** - When process `Pid`\n  sends message `Msg` to the non-existing process `To`.\n\n- **`{trace, Pid, 'receive', Msg}`{: #process_trace_messages_receive }** -\n  When process `Pid` receives message `Msg`. If `Msg` is set to time-out, a receive\n  statement can have timed out, or the process received a message with the\n  payload `timeout`.\n\n- **`{trace, Pid, call, {M, F, Args}}`{: #process_trace_messages_call }** - When\n  process `Pid` calls a traced function. The return values of calls are never\n  supplied, only the call and its arguments.\n\n  Trace flag `arity` can be used to change the contents of this message, so that\n  `Arity` is specified instead of `Args`.\n\n- **`{trace, Pid, return_to, {M, F, Arity}}`{: #process_trace_messages_return_to\n  }** - When process `Pid` returns _to_ the specified function. This trace\n  message is sent if both the flags `call` and `return_to` are set, and the\n  function is set to be traced on _local_ function calls. The message is only\n  sent when returning from a chain of tail recursive function calls, where at\n  least one call generated a `call` trace message (that is, the functions match\n  specification matched, and `{message, false}` was not an action).\n\n- **`{trace, Pid, return_from, {M, F, Arity}, ReturnValue}`{:\n  #process_trace_messages_return_from }** - When `Pid` returns _from_ the\n  specified function. This trace message is sent if flag `call` is set, and the\n  function has a match specification with a `return_trace` or `exception_trace`\n  action.\n\n- **`{trace, Pid, exception_from, {M, F, Arity}, {Class, Value}}`{:\n  #process_trace_messages_exception_from }** - When `Pid` exits _from_ the\n  specified function because of an exception. This trace message is sent if flag\n  `call` is set, and the function has a match specification with an\n  `exception_trace` action.\n\n- **`{trace, Pid, spawn, Pid2, {M, F, Args}}`{: #process_trace_messages_spawn\n  }** - When `Pid` spawns a new process `Pid2` with the specified function call\n  as entry point.\n\n  `Args` is supposed to be the argument list, but can be any term if the spawn\n  is erroneous.\n\n- **`{trace, Pid, spawned, Pid2, {M, F, Args}}`{:\n  #process_trace_messages_spawned }** - When `Pid` is spawned by process `Pid2`\n  with the specified function call as entry point.\n\n  `Args` is supposed to be the argument list, but can be any term if the spawn\n  is erroneous.\n\n- **`{trace, Pid, exit, Reason}`{: #process_trace_messages_exit }** - When `Pid`\n  exits with reason `Reason`.\n\n- **`{trace, Pid, register, RegName}`{: #process_trace_messages_register\n  }** - When process `Pid` gets the name `RegName` registered.\n\n- **`{trace, Pid, unregister, RegName}`{: #process_trace_messages_unregister\n  }** - When process `Pid` gets the name `RegName` unregistered. This is done\n  automatically when a registered process or port exits.\n\n- **`{trace, Pid, link, Pid2}`{: #process_trace_messages_link }** - When `Pid`\n  links to a process `Pid2`.\n\n- **`{trace, Pid, unlink, Pid2}`{: #process_trace_messages_unlink }** - When\n  `Pid` removes the link from a process `Pid2`.\n\n- **`{trace, Pid, getting_linked, Pid2}`{:\n  #process_trace_messages_getting_linked }** - When `Pid` gets linked to a\n  process `Pid2`.\n\n- **`{trace, Pid, getting_unlinked, Pid2}`{:\n  #process_trace_messages_getting_unlinked }** - When `Pid` gets unlinked\n  from a process `Pid2`.\n\n- **`{trace, Port, open, Pid, Driver}`{: #process_trace_messages_open }** - When\n  `Pid` opens a new port `Port` with the running `Driver`.\n\n  `Driver` is the name of the driver as an atom.\n\n- **[](){: #process_trace_messages_in_proc }\n  `{trace, Pid, in | in_exiting, {M, F, Arity} | 0}`{:\n  #process_trace_messages_in_exiting_proc }**\n  When `Pid` is scheduled to run. The process runs in function `{M, F, Arity}`.\n  On some rare occasions, the current function cannot be determined, then the\n  last element is `0`.\n\n- **[](){: #process_trace_messages_out_proc } [](){:\n  #process_trace_messages_out_exiting_proc }\n  `{trace, Pid, out | out_exiting | out_exited, {M, F, Arity} | 0}`{:\n  #process_trace_messages_out_exited_proc }**\n  When `Pid` is scheduled out. The process was running in function `{M, F,\n  Arity}`. On some rare occasions, the current function cannot be determined,\n  then the last element is `0`.\n\n- **`{trace, Pid, gc_minor_start, Info}`{:\n  #process_trace_messages_gc_minor_start }** - [](){: #gc_minor_start } Sent\n  when a garbage collection of the young generation is about to be started.\n  `Info` is a list of two-element tuples, where the first element is a key,\n  and the second is the value. Do not depend on any order of the tuples.\n  The following keys are defined:\n\n  - **`heap_size`** - The size of the used part of the heap.\n\n  - **`heap_block_size`** - The size of the memory block used for storing the\n    heap and the stack.\n\n  - **`old_heap_size`** - The size of the used part of the old heap.\n\n  - **`old_heap_block_size`** - The size of the memory block used for storing\n    the old heap.\n\n  - **`stack_size`** - The size of the stack.\n\n  - **`recent_size`** - The size of the data that survived the previous garbage\n    collection.\n\n  - **`mbuf_size`** - The combined size of message buffers associated with the\n    process.\n\n  - **`bin_vheap_size`** - The total size of unique off-heap binaries referenced\n    from the process heap.\n\n  - **`bin_vheap_block_size`** - The total size of binaries allowed in the\n    virtual heap in the process before doing a garbage collection.\n\n  - **`bin_old_vheap_size`** - The total size of unique off-heap binaries\n    referenced from the process old heap.\n\n  - **`bin_old_vheap_block_size`** - The total size of binaries allowed in the\n    virtual old heap in the process before doing a garbage collection.\n\n  - **`wordsize`** - For the `gc_minor_start` event it is the size of the need\n    that triggered the GC. For the corresponding `gc_minor_end` event it is the\n    size of reclaimed memory = start `heap_size` - end `heap_size`.\n\n  All sizes are in words.\n\n- **`{trace, Pid, gc_max_heap_size, Info}`{:\n  #process_trace_messages_gc_max_heap_size }** - Sent when the\n  [`max_heap_size`](`e:erts:erlang#process_flag_max_heap_size`) is reached during\n  garbage collection. `Info` contains the same kind of list as in message\n  `gc_start`, but the sizes reflect the sizes that triggered `max_heap_size` to\n  be reached.\n\n- **`{trace, Pid, gc_minor_end, Info}`{: #process_trace_messages_gc_minor_end\n  }** - Sent when young garbage collection is finished. `Info` contains the same\n  kind of list as in message `gc_minor_start`, but the sizes reflect the new\n  sizes after garbage collection.\n\n- **`{trace, Pid, gc_major_start, Info}`{:\n  #process_trace_messages_gc_major_start }** - Sent when fullsweep garbage\n  collection is about to be started. `Info` contains the same kind of list as in\n  message `gc_minor_start`.\n\n- **`{trace, Pid, gc_major_end, Info}`{: #process_trace_messages_gc_major_end\n  }** - Sent when fullsweep garbage collection is finished. `Info` contains the\n  same kind of list as in message `gc_minor_start`, but the sizes reflect the\n  new sizes after a fullsweep garbage collection.\n\nIf the tracing process dies or the tracer module returns `remove`, the\nflags are silently removed.\n\nReturns a number indicating the number of processes that matched `Procs`.\nIf `Procs` is a process identifier, the return value is `1`. If\n`Procs` is `all` or `existing`, the return value is the number of\nprocesses running. If `Procs` is `new`, the return value is `0`.\n\nFailure: `badarg` if the specified arguments are not supported. For example,\n`cpu_timestamp` is not supported on all platforms.","ref":"trace.html#process/4"},{"type":"function","title":"trace.recv/3","doc":"Set trace pattern for _message receiving_.\n\nMust be combined with `process/4` or `port/4` to set the `'receive'` trace flag\nfor one or more processes or ports.\n\nArgument `Session` is the trace session to operate on as returned by\n`session_create/3`.\n\nThe default value for the `receive` trace pattern in each session is\n`true`. That is, all messages received by processes having `'receive'`\ntrace enabled will be traced. Use this function to limit traced\n`'receive'` events based on the message content, the sender, and/or the\nreceiver.\n\nArgument `MatchSpec` can take the following forms:\n\n- **`MatchExpression`** - A match specification. The matching is done on\n  the list `[Node, Sender, Msg]`. `Node` is the node name of the sender.\n  `Sender` is the process or port identity of the sender, or the atom\n  `undefined` if the sender is not known (which can be the case for remote\n  senders). `Msg` is the message term. The pid of the receiving process can be\n  accessed with the guard function `self/0`. An empty list is the same as\n  `true`. For more information, see section\n  [Match Specifications in Erlang](`e:erts:match_spec.md`) in the User's Guide\n  for the ERTS application.\n\n- **`true`** - Enable tracing for all received messages (to `'receive'` traced\n  processes). Any match specification is removed. _This is the default_.\n\n- **`false`** - Disable tracing for all received messages. Any match\n  specification is removed.\n\nArgument `FlagList` must be `[]` for receive tracing.\n\nThe return value is always `1`.\n\n*Examples:*\n\nOnly trace messages from a specific process `Pid`:\n\n```erlang\n> trace:recv(Session, [{['_',Pid, '_'],[],[]}], []).\n1\n```\n\nOnly trace messages matching `{reply, _}`:\n\n```erlang\n> trace:recv(Session, [{['_','_', {reply,'_'}],[],[]}], []).\n1\n```\n\nOnly trace messages from other nodes:\n\n```erlang\n> trace:recv(Session, [{['$1', '_', '_'],[{'=/=','$1',{node}}],[]}], []).\n1\n```\n\n> #### Note {: .info }\n>\n> A match specification for `'receive'` trace can use all guard and body\n> functions except `caller`, `is_seq_trace`, `get_seq_token`, `set_seq_token`,\n> `enable_trace`, `disable_trace`, `trace`, `silent`, and `process_dump`.\n\nFails by raising an error exception with an error reason of:\n\n- **`badarg`** - If an argument is invalid.\n\n- **`system_limit`** - If a match specification passed as argument has excessive\n  nesting which causes scheduler stack exhaustion for the scheduler that the\n  calling process is executing on.\n  [Scheduler stack size](`e:erts:erl_cmd.md#sched_thread_stack_size`) can be configured\n  when starting the runtime system.","ref":"trace.html#recv/3"},{"type":"function","title":"trace.send/3","doc":"Set trace pattern for _message sending_.\n\nMust be combined with `process/4` or `port/4` to set the `send` trace flag for\none or more processes or ports.\n\nArgument `Session` is the trace session to operate on as returned by\n`session_create/3`.\n\nThe default value for the `send` trace pattern in each session is\n`true`. That is, all messages sent from processes having `send` trace\nenabled will be traced. Use this function to limit traced `send`\nevents based on the message content, the sender, and/or the receiver.\n\nArgument `MatchSpec` can take the following forms:\n\n- **`MatchExpression`** - A match specification. The matching is done on\n  the list `[Receiver, Msg]`. `Receiver` is the process or port identity of the\n  receiver and `Msg` is the message term. The pid of the sending process can be\n  accessed with the guard function `self/0`. An empty list is the same as\n  `true`. For more information, see section\n  [Match Specifications in Erlang](`e:erts:match_spec.md`) in the User's Guide\n  for the ERTS application.\n\n- **`true`** - Enable tracing for all sent messages (from `send` traced\n  processes). Any match specification is removed.\n\n- **`false`** - Disable tracing for all sent messages. Any match specification\n  is removed.\n\nArgument `FlagList` must be `[]`.\n\nThe return value is always `1`.\n\n*Examples:*\n\nOnly trace messages to a specific process `Pid`:\n\n```erlang\n> trace:send(Session, [{[Pid, '_'],[],[]}], []).\n1\n```\n\nOnly trace messages matching `{reply, _}`:\n\n```erlang\n> trace:send(Session, [{['_', {reply,'_'}],[],[]}], []).\n1\n```\n\nOnly trace messages sent to the sender itself:\n\n```erlang\n> trace:send(Session, [{['$1', '_'],[{'=:=','$1',{self}}],[]}], []).\n1\n```\n\nOnly trace messages sent to other nodes:\n\n```erlang\n> trace:send(Session, [{['$1', '_'],[{'=/=',{node,'$1'},{node}}],[]}], []).\n1\n```\n\n> #### Note {: .info }\n>\n> A match specification for `send` trace can use all guard and body functions\n> except `caller`.\n\nFails by raising an error exception with an error reason of:\n\n- **`badarg`** - If an argument is invalid.\n\n- **`system_limit`** - If a match specification passed as argument has excessive\n  nesting which causes scheduler stack exhaustion for the scheduler that the\n  calling process is executing on.\n  [Scheduler stack size](`e:erts:erl_cmd.md#sched_thread_stack_size`) can be configured\n  when starting the runtime system.","ref":"trace.html#send/3"},{"type":"type","title":"trace.session/0","doc":"A handle to an isolated trace session.","ref":"trace.html#t:session/0"},{"type":"function","title":"trace.session_create/3","doc":"Create a new trace session.\n\nArgument `Name` is an atom name for the session. It will be returned when\ninspecting with `session_info/1`.\n\nArgument `Tracer` specifies the consumer of all trace events for the session. It\ncan be an identifier of a local process or port to receive all trace\nmessages.\n\n`Tracer` can also be a tuple `{TracerModule, TracerState}` for a tracer module\nto be called instead of sending a trace message. The tracer module can then\nignore or change the trace message. For more details on how to write a tracer\nmodule, see module `m:erl_tracer`.\n\nArgument `Opts` must be `[]`.\n\nReturns an opaque handle to the trace session. The handle will keep the session\nalive. If the handle is dropped and garbage collected, the session will be\ndestroyed and cleaned up as if `session_destroy/1` was called.","ref":"trace.html#session_create/3"},{"type":"function","title":"trace.session_destroy/1","doc":"Destroy a trace session and cleanup all its settings on processes, ports, and\nfunctions.\n\nThe only things not cleaned up are trace messages that have already been sent.\n\nReturns `true` if the session was active. Returns `false` if the session had\nalready been destroyed by either an earler call to this function or the garbage\ncollector.","ref":"trace.html#session_destroy/1"},{"type":"function","title":"trace.session_info/1","doc":"Return which trace sessions that affect a port, process, function, or event.\n\nArgument `all` returns all active trace sessions that exists on the node.\n\nReturns a list of [weak session handles](`t:session_weak_ref/0`) or `undefined` if the\nprocess/port/function does not exists.","ref":"trace.html#session_info/1"},{"type":"opaque","title":"trace.session_strong_ref/0","doc":"","ref":"trace.html#t:session_strong_ref/0"},{"type":"opaque","title":"trace.session_weak_ref/0","doc":"A weak session handle as returned by `session_info/1`. A weak session handle can\nbe used like a full session handle, but it will not prevent the session from\nbeing destroyed when the last strong handle is garbage collected.","ref":"trace.html#t:session_weak_ref/0"},{"type":"function","title":"trace.system/3","doc":"Enable/disable monitoring of system events.\n\nArgument `Session` is the trace session to operate on as returned by\n`session_create/3`.\n\nArgument `Event` is an atom describing the kind of system event to\nmonitor. To enable monitoring argument `Value` is, depending on event, either a\nlimit of that event or the atom `true`. To disable monitoring pass `Value` as the\natom `false`.\n\nWhen a monitored system event happens, a message is sent to the session\ntracer. The session tracer must be a process otherwise the function call will\nfail.\n\nThe following `Event`s with `Value`s can be monitored:\n\n- **`long_gc, Time`** - If a garbage collection in the system takes at least\n  `Time` wall clock milliseconds, a message `{monitor, GcPid, long_gc, Info}` is\n  sent. `GcPid` is the pid that was garbage collected. `Info` is a list of\n  two-element tuples describing the result of the garbage collection.\n\n  One of the tuples is `{timeout, GcTime}`, where `GcTime` is the time for the\n  garbage collection in milliseconds. The other tuples are tagged with\n  `heap_size`, `heap_block_size`, `stack_size`, `mbuf_size`, `old_heap_size`,\n  and `old_heap_block_size`. These tuples are explained in the description of\n  trace message [`gc_minor_start`](`m:trace#gc_minor_start`) (see\n  `trace:process/4`). New tuples can be added, and the order of the tuples in\n  the `Info` list can be changed at any time without prior notice.\n\n- **`long_message_queue, {Disable, Enable}`** - If the number of messages in the\n  message queue of a process reach `Enable`, a message `{monitor, Pid,\n  long_message_queue, Long}` is sent. `Pid` is the process identifier of the\n  process that got a long message queue and `Long` will equal `true` indicating\n  that it is in a _long message queue_ state. No more `long_message_queue`\n  monitor messages will be sent due to the process identified by `Pid` until its\n  message queue length falls down to a length of `Disable` length. When this\n  happens, a `long_message_queue` monitor message with `Long` equal to `false`\n  will be sent indicating that the process is no longer in a _long message\n  queue_ state. As of this, if the message queue length should again reach\n  `Enable` length, a new `long_message_queue` monitor message with `Long` set to\n  `true` will again be sent. That is, a `long_message_queue` monitor message is\n  sent when a process enters or leaves a _long message queue_ state where these\n  state changes are defined by the `Enable` and `Disable` parameters.\n\n  `Enable` must be an integer larger than zero. `Disable` must be an integer\n  larger than or equal to zero and smaller than `Enable`. If the above is not\n  satisfied the operation will fail with a `badarg` error exception. You are\n  recommended to use a much smaller value for `Disable` length than `Enable`\n  length in order not to be flooded with `long_message_queue` monitor messages.\n\n- **`long_schedule, Time`** - If a process or port in the system runs\n  uninterrupted for at least `Time` wall clock milliseconds, a message\n  `{monitor, PidOrPort, long_schedule, Info}` is sent.\n  `PidOrPort` is the process or port that was running. `Info` is a list of\n  two-element tuples describing the event.\n\n  If a `t:pid/0`, the tuples `{timeout, Millis}`, `{in, Location}`, and\n  `{out, Location}` are present, where `Location` is either an MFA\n  (`{Module, Function, Arity}`) describing the function where the process was\n  scheduled in/out, or the atom `undefined`.\n\n  If a `t:port/0`, the tuples `{timeout, Millis}` and `{port_op,Op}` are\n  present. `Op` is one of `proc_sig`, `timeout`, `input`, `output`, `event`, or\n  `dist_cmd`, depending on which driver callback was executing.\n\n  `proc_sig` is an internal operation and is never to appear, while the others\n  represent the corresponding driver callbacks `timeout`, `ready_input`,\n  `ready_output`, `event`, and `outputv` (when the port is used by\n  distribution). Value `Millis` in tuple `timeout` informs about the\n  uninterrupted execution time of the process or port, which always is equal to\n  or higher than the `Time` value supplied when starting the trace. New tuples\n  can be added to the `Info` list in a future release. The order of the tuples\n  in the list can be changed at any time without prior notice.\n\n  This can be used to detect problems with NIFs or drivers that take too long to\n  execute. 1 ms is considered a good maximum time for a driver callback or a\n  NIF. However, a time-sharing system is usually to consider everything < 100 ms\n  as \"possible\" and fairly \"normal\". However, longer schedule times can indicate\n  swapping or a misbehaving NIF/driver. Misbehaving NIFs and drivers can cause\n  bad resource utilization and bad overall system performance.\n\n- **`large_heap, Size`** - If a garbage collection in the system results in\n  the allocated size of a heap being at least `Size` words, a message\n  `{monitor, GcPid, large_heap, Info}` is sent. `GcPid` and `Info` are the same\n  as for `long_gc` described above, except that the tuple tagged with `timeout`\n  is not present.\n\n  The monitor message is sent if the sum of the sizes of all memory blocks\n  allocated for all heap generations after a garbage collection is equal to or\n  higher than `Size`.\n\n  When a process is killed by\n  [`max_heap_size`](`e:erts:erlang#process_flag_max_heap_size`), it is killed before\n  the garbage collection is complete and thus no large heap message is sent.\n\n- **`busy_port, true`** - If a process in the system gets suspended because it sends\n  to a busy port, a message `{monitor, SusPid, busy_port, Port}` is\n  sent. `SusPid` is the pid that got suspended when sending to `Port`.\n\n- **`busy_dist_port, true`[](){: #busy_dist_port } **\n  If a process in the system gets suspended because it sends to a process on a remote\n  node whose inter-node communication was handled by a busy port, a message\n  `{monitor, SusPid, busy_dist_port, Port}` is sent. `SusPid` is the pid that\n  got suspended when sending through the inter-node communication port `Port`.\n\nTo disable system monitoring of a event pass the value as `false`. There are no\nother special values (like zero) to disable monitoring of an event. Some of the\nevents have an unspecified minimum value. Lower values will be adjusted to the\nminimum value. For example, it is currently not possible to monitor all garbage\ncollections with `{long_gc, 0}`.\n\n> #### Note {: .info }\n>\n> If the session tracer process gets so large that it itself starts to cause\n> system monitor messages when garbage collecting, the messages enlarge the\n> process message queue and probably make the problem worse.\n>\n> Keep the tracer process neat and do not set the system monitor limits too\n> tight.\n\nFailures:\n\n- **`badarg`** - If the session tracer is not a local process.","ref":"trace.html#system/3"},{"type":"type","title":"trace.system_event/0","doc":"","ref":"trace.html#t:system_event/0"},{"type":"type","title":"trace.system_value/0","doc":"","ref":"trace.html#t:system_value/0"},{"type":"type","title":"trace.trace_flag/0","doc":"","ref":"trace.html#t:trace_flag/0"},{"type":"type","title":"trace.trace_info_flag/0","doc":"","ref":"trace.html#t:trace_info_flag/0"},{"type":"type","title":"trace.trace_info_item_result/0","doc":"","ref":"trace.html#t:trace_info_item_result/0"},{"type":"type","title":"trace.trace_info_return/0","doc":"","ref":"trace.html#t:trace_info_return/0"},{"type":"type","title":"trace.trace_info_system_item/0","doc":"","ref":"trace.html#t:trace_info_system_item/0"},{"type":"type","title":"trace.trace_match_spec/0","doc":"","ref":"trace.html#t:trace_match_spec/0"},{"type":"type","title":"trace.trace_pattern_flag/0","doc":"","ref":"trace.html#t:trace_pattern_flag/0"},{"type":"type","title":"trace.trace_pattern_mfa/0","doc":"","ref":"trace.html#t:trace_pattern_mfa/0"},{"type":"extras","title":"Kernel Application","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Kernel Application","ref":"kernel_app.html"},{"type":"extras","title":"Description - Kernel Application","doc":"The Kernel application has all the code necessary to run the Erlang runtime\nsystem: file servers, code servers, and so on.\n\nThe Kernel application is the first application started. It is mandatory in the\nsense that the minimal system based on Erlang/OTP consists of Kernel and STDLIB.\nKernel contains the following functional areas:\n\n- Start, stop, supervision, configuration, and distribution of applications\n- Code loading\n- Logging\n- Global name service\n- Supervision of Erlang/OTP\n- Communication with sockets\n- Operating system interface","ref":"kernel_app.html#description"},{"type":"extras","title":"Logger Handlers - Kernel Application","doc":"Two standard logger handlers are defined in the Kernel application. These are\ndescribed in the [Kernel User's Guide](logger_chapter.md), and in the\n`m:logger_std_h` and [`logger_disk_log_h` ](`m:logger_disk_log_h`)manual pages.\n\n[](){: #erl_signal_server }","ref":"kernel_app.html#logger-handlers"},{"type":"extras","title":"OS Signal Event Handler - Kernel Application","doc":"Asynchronous OS signals may be subscribed to via the Kernel applications event\nmanager (see [OTP Design Principles](`e:system:design_principles.md`) and\n`m:gen_event`) registered as `erl_signal_server`. A default signal handler is\ninstalled which handles the following signals:\n\n- **`sigusr1`** - The default handler will halt Erlang and produce a crashdump\n  with slogan \"Received SIGUSR1\". This is equivalent to calling\n  `erlang:halt(\"Received SIGUSR1\")`.\n\n- **`sigquit`** - The default handler will halt Erlang immediately. This is\n  equivalent to calling `erlang:halt()`.\n\n- **`sigterm`** - The default handler will terminate Erlang normally. This is\n  equivalent to calling `init:stop()`.","ref":"kernel_app.html#os-signal-event-handler"},{"type":"extras","title":"Events - Kernel Application","doc":"Any event handler added to `erl_signal_server` must handle the following events.\n\n- **`sighup`** - Hangup detected on controlling terminal or death of controlling\n  process\n\n- **`sigquit`** - Quit from keyboard\n\n- **`sigabrt`** - Abort signal from abort\n\n- **`sigalrm`** - Timer signal from alarm\n\n- **`sigterm`** - Termination signal\n\n- **`sigusr1`** - User-defined signal 1\n\n- **`sigusr2`** - User-defined signal 2\n\n- **`sigchld`** - Child process stopped or terminated\n\n- **`sigstop`** - Stop process\n\n- **`sigtstp`** - Stop typed at terminal\n\n- **`sigcont`** - Continue after stop\n\n- **`sigwinch`** - Window size change\n\n- **`siginfo`** - Status request from keyboard. Note several operating systems\n  (Linux in particular) do not support this signal. `os:set_signal/2` will thow\n  a `badarg` exception if support is missing.\n\nSetting OS signals are described in `os:set_signal/2`.","ref":"kernel_app.html#events"},{"type":"extras","title":"Configuration - Kernel Application","doc":"The following configuration parameters are defined for the Kernel application.\nFor more information about configuration parameters, see file\n[`app`](app.md).\n\n- **`connect_all = true | false`{: #connect_all }** - If enabled (`true`), which\n  also is the default, `m:global` will actively connect to all nodes that\n  becomes known to it. Note that you also want to enable\n  [`prevent_overlapping_partitions`](kernel_app.md#prevent_overlapping_partitions)\n  in order for `global` to ensure that a fully connected network is maintained.\n  `prevent_overlapping_partitions` will also prevent inconsistencies in\n  `global`'s name registration and locking.\n\n  The now deprecated command line argument\n  [`-connect_all  `](`e:erts:erl_cmd.md#connect_all`) has the same\n  effect as the `connect_all` configuration parameter. If this configuration\n  parameter is defined, it will override the command line argument.\n\n- **`distributed = [Distrib]`{: #distributed }** - Specifies which applications\n  that are distributed and on which nodes they are allowed to execute. In this\n  parameter:\n\n  - `Distrib = {App,Nodes} | {App,Time,Nodes}`\n  - `App = atom()`\n  - `Time = integer()>0`\n  - `Nodes = [node() | {node(),...,node()}]`\n\n  The parameter is described in `application:load/2`.\n\n- **`dist_auto_connect = Value`{: #dist_auto_connect }** - Specifies when nodes\n  are automatically connected. If this parameter is not specified, a node is\n  always automatically connected, for example, when a message is to be sent to\n  that node. `Value` is one of:\n\n  - **`never`** - Connections are never automatically established, they must be\n    explicitly connected. See `m:net_kernel`.\n\n  - **`once`** - Connections are established automatically, but only once per\n    node. If a node goes down, it must thereafter be explicitly connected. See\n    `m:net_kernel`.\n\n- **`epmd_module = module()`{: #epmd_module }** - Configures the module\n  responsible for communication with [epmd](`e:erts:epmd_cmd.md`). If this parameter\n  is undefined, it defaults to `erl_epmd`.\n\n  The now deprecated command line argument\n  [`-epmd_module  `](`e:erts:erl_cmd.md#epmd_module`) has the same\n  effect as the `epmd_module` configuration parameter. If this configuration\n  parameter is defined, it will override the command line argument.\n\n- **`erl_epmd_node_listen_port = integer()`{: #erl_epmd_node_listen_port }** - Configures the port used by `m:erl_epmd`\n  to listen for connection and connect to other nodes. If this flag is set, the\n  Erlang VM will boot in distributed mode even if EPMD is not available. If not\n  set, a port is chosen automatically (equivalent to port `0`). See `m:erl_epmd`\n  for more details.\n\n  The now deprecated command line argument\n  [`erl_epmd_port  `](`e:erts:erl_cmd.md#erl_epmd_port`) has the same\n  effect as the `erl_epmd_node_listen_port` configuration parameter. If this\n  configuration parameter is defined, it will override the command line argument.\n\n- **`permissions = [Perm]`{: #permissions }** - Specifies the default permission\n  for applications when they are started. In this parameter:\n\n  - `Perm = {ApplName,Bool}`\n  - `ApplName = atom()`\n  - `Bool = boolean()`\n\n  Permissions are described in `application:permit/2`.\n\n- **`logger = [Config]`{: #logger }** - Specifies the configuration for\n  [Logger](`m:logger`), except the primary log level, which is specified with\n  [`logger_level`](kernel_app.md#logger_level), and the compatibility with\n  [SASL Error Logging](`e:sasl:error_logging.md`), which is specified with\n  [`logger_sasl_compatible`](kernel_app.md#logger_sasl_compatible).\n\n  The `logger `parameter is described in section\n  [Logging](logger_chapter.md#logger_parameter) in the Kernel User's Guide.\n\n- **`logger_level = Level`{: #logger_level }** - Specifies the primary log level\n  for Logger. Log events with the same, or a more severe level, pass through the\n  primary log level check. See section [Logging](logger_chapter.md) in the\n  Kernel User's Guide for more information about Logger and log levels.\n\n  `Level = emergency | alert | critical | error | warning | notice | info | debug | all | none`\n\n  To change the primary log level at runtime, use\n  [`logger:set_primary_config(level, Level)`](`logger:set_primary_config/2`).\n\n  Defaults to `notice`.\n\n- **`logger_metadata = Metadata`{: #logger_metadata }** - Specifies primary\n  metadata for log events.\n\n  `Metadata = map()`\n\n  Defaults to `#{}`.\n\n- **`logger_sasl_compatible = true | false`{: #logger_sasl_compatible }** -\n  Specifies if Logger behaves backwards compatible with the SASL error logging\n  functionality from releases prior to Erlang/OTP 21.0.\n\n  If this parameter is set to `true`, the default Logger handler does not log\n  any progress-, crash-, or supervisor reports. If the SASL application is then\n  started, it adds a Logger handler named `sasl`, which logs these events\n  according to values of the SASL configuration parameter `sasl_error_logger`\n  and `sasl_errlog_type`.\n\n  See section\n  [Deprecated Error Logger Event Handlers and Configuration](`e:sasl:sasl_app.md#deprecated_error_logger_config`)\n  in the sasl(6) manual page for information about the SASL configuration\n  parameters.\n\n  See section [SASL Error Logging](`e:sasl:error_logging.md`) in the SASL User's\n  Guide, and section\n  [Backwards Compatibility with error_logger](logger_chapter.md#backwards-compatibility-with-error_logger)\n  in the Kernel User's Guide for information about the SASL error logging\n  functionality, and how Logger can be backwards compatible with this.\n\n  Defaults to `false`.\n\n  > #### Note {: .info }\n  >\n  > If this parameter is set to `true`, `sasl_errlog_type` indicates that\n  > progress reports shall be logged, and the configured primary log level is\n  > `notice` or more severe, then SASL automatically sets the primary log level\n  > to `info`. That is, this setting can potentially overwrite the value of the\n  > Kernel configuration parameter `logger_level`. This is to allow progress\n  > reports, which have log level `info`, to be forwarded to the handlers.\n\n- **`global_groups = [GroupTuple]`{: #global_groups }** - Defines global groups,\n  see `m:global_group`. In this parameter:\n\n  - `GroupTuple = {GroupName, [Node]} | {GroupName, PublishType, [Node]}`\n  - `GroupName = atom()`\n  - `PublishType = normal | hidden`\n  - `Node = node()`\n\n- **`inet_default_connect_options = [{Opt, Val}]`{: #inet_default_connect_options }** - Specifies default options for `connect`\n  sockets, see `m:inet`.\n\n- **`inet_default_listen_options = [{Opt, Val}]`{: #inet_default_listen_options\n  }** - Specifies default options for `listen` (and `accept`) sockets, see\n  `m:inet`.\n\n- **`inet_dist_use_interface = ip_address()`{: #inet_dist_use_interface }** - If\n  the host of an Erlang node has many network interfaces, this parameter\n  specifies which one to listen on. For the type definition of `ip_address()`,\n  see `m:inet`.\n\n- **`inet_dist_listen_min = First`{: #inet_dist_listen }  \n  `inet_dist_listen_max = Last`**  \n  Defines the `First..Last` port range for the listener socket of a distributed\n  Erlang node.\n\n- **`inet_dist_listen_options = Opts`{: #inet_dist_listen_options }** - Defines\n  a list of extra socket options to be used when opening the listening socket\n  for a distributed Erlang node. See `gen_tcp:listen/2`.\n\n- **`inet_dist_connect_options = Opts`{: #inet_dist_connect_options }** -\n  Defines a list of extra socket options to be used when connecting to other\n  distributed Erlang nodes. See `gen_tcp:connect/4`.\n\n- **`inet_parse_error_log = silent`{: #inet_parse_error_log }** - If set, no log\n  events are issued when erroneous lines are found and skipped in the various\n  Inet configuration files.\n\n- **`inetrc = Filename`{: #inetrc }** - The name (string) of an Inet user\n  configuration file. For details, see section\n  [`Inet Configuration`](`e:erts:inet_cfg.md`) in the ERTS User's Guide.\n\n- **`net_setuptime = SetupTime`{: #net_setuptime }** -\n  `SetupTime` must be a positive integer or floating point number, and is\n  interpreted as the maximum allowed time for each network operation during\n  connection setup to another Erlang node. The maximum allowed value is `120`.\n  If higher values are specified, `120` is used. Default is 7 seconds if the\n  variable is not specified, or if the value is incorrect (for example, not a\n  number).\n\n  Notice that this value does not limit the total connection setup time, but\n  rather each individual network operation during the connection setup and\n  handshake.\n\n- **`net_ticker_spawn_options = Opts`{: #net_ticker_spawn_options }** - Defines\n  a list of extra spawn options for net ticker processes. There exist one such\n  process for each connection to another node. A net ticker process is\n  responsible for supervising the connection it is associated with. These\n  processes also execute the distribution handshake protocol when setting up\n  connections. When there is a large number of distribution connections, setting\n  up garbage collection options can be helpful to reduce memory usage. Default\n  is `[link, {priority, max}]`, and these two options cannot be changed. The\n  `monitor` and `{monitor, MonitorOpts}` options are not allowed and will be\n  dropped if present. See the documentation of the `erlang:spawn_opt/4` BIF for\n  information about valid options. If the `Opts` list is not a proper list, or\n  containing invalid options the setup of connections will fail.\n\n  Note that the behavior described above is only true if the distribution\n  carrier protocol used is implemented as described in\n  [ERTS User's Guide ➜ How to implement an Alternative Carrier for the Erlang Distribution ➜ Distribution Module](`e:erts:alt_dist.md#distribution-module`)\n  without further alterations. The implementer of the distribution carrier\n  protocol used, may have chosen to ignore the `net_ticker_spawn_options`\n  parameter or altered its behavior. Currently all distribution modules shipped\n  with OTP do, however, behave as described above.\n\n- **`net_tickintensity = NetTickIntensity`{: #net_tickintensity }** - _Net tick\n  intensity_ specifies how many ticks to send during a\n  [net tick time](kernel_app.md#net_ticktime) period when no other data is sent\n  over a connection to another node. This also determines how often to check for\n  data from the other node. The higher net tick intensity, the closer to the\n  chosen net tick time period the node will detect an unresponsive node. The net\n  tick intensity defaults to `4`. The value of `NetTickIntensity` should be an\n  integer in the range `4..1000`. If the `NetTickIntensity` is not an integer or\n  an integer less than `4`, `4` will silently be used. If `NetTickIntensity` is\n  an integer larger than `1000`, `1000` will silently be used.\n\n  > #### Note {: .info }\n  >\n  > Note that all communicating nodes are expected to use the same _net tick\n  > intensity_ as well as the same _net tick time_.\n\n  > #### Warning {: .warning }\n  >\n  > Be careful not to set a too high net tick intensity, since you can overwhelm\n  > the node with work if it is set too high.\n\n- **`net_ticktime = NetTickTime`{: #net_ticktime }** - Specifies the _net tick\n  time_ in seconds. This is the approximate time a connected node may be\n  unresponsive until it is considered down and thereby disconnected.\n\n  Net tick time together with\n  [net tick intensity](kernel_app.md#net_tickintensity) determines an interval\n  `TickInterval = NetTickTime/NetTickIntensity`. Once every `TickInterval`\n  seconds, each connected node is ticked if nothing has been sent to it during\n  that last `TickInterval` seconds. A tick is a small package sent on the\n  connection. A connected node is considered to be down if no ticks or payload\n  packages have been received during the last `NetTickIntensity` number of\n  `TickInterval` seconds intervals. This ensures that nodes that are not\n  responding, for reasons such as hardware errors, are considered to be down.\n\n  As the availability is only checked every `TickInterval` seconds, the actual\n  time `T` a node have been unresponsive when detected may vary between `MinT`\n  and `MaxT`, where:\n\n  ```c\n  MinT = NetTickTime - NetTickTime / NetTickIntensity\n  MaxT = NetTickTime + NetTickTime / NetTickIntensity\n  ```\n\n  `NetTickTime` defaults to `60` seconds and `NetTickIntensity` defaults to `4`.\n  Thus, `45   #### Note {: .info }\n  >\n  > Notice that _all_ communicating nodes are to have the _same_ `NetTickTime`\n  > and `NetTickIntensity` values specified, as it determines both the frequency\n  > of outgoing ticks and the expected frequency of incominging ticks.\n\n  `NetTickTime` needs to be a multiple of `NetTickIntensity`. If the configured\n  values are not, `NetTickTime` will internally be rounded up to the nearest\n  millisecond.\n  [`net_kernel:get_net_ticktime()`](`net_kernel:get_net_ticktime/0`) will,\n  however, report net tick time truncated to the nearest second.\n\n  Normally, a terminating node is detected immediately by the transport protocol\n  (like TCP/IP).\n\n- **`prevent_overlapping_partitions = true | false`{:\n  #prevent_overlapping_partitions }** - If enabled (`true`), `global` will\n  actively prevent overlapping partitions from forming when connections are lost\n  between nodes. This fix is enabled by default. If you are about to disable\n  this fix, make sure to read the\n  [`global`](`m:global#prevent_overlapping_partitions`) documentation about this\n  fix for more important information about this.\n\n- **`shutdown_timeout = integer() | infinity`{: #shutdown_timeout }** -\n  Specifies the time `application_controller` waits for an application to\n  terminate during node shutdown. If the timer expires, `application_controller`\n  brutally kills `application_master` of the hanging application. If this\n  parameter is undefined, it defaults to `infinity`.\n\n- **`sync_nodes_mandatory = [NodeName]`{: #sync_nodes_mandatory }** - Specifies\n  which other nodes that _must_ be alive for this node to start properly. If\n  some node in the list does not start within the specified time, this node does\n  not start either. If this parameter is undefined, it defaults to `[]`.\n\n- **`sync_nodes_optional = [NodeName]`{: #sync_nodes_optional }** - Specifies\n  which other nodes that _can_ be alive for this node to start properly. If some\n  node in this list does not start within the specified time, this node starts\n  anyway. If this parameter is undefined, it defaults to the empty list.\n\n- **`sync_nodes_timeout = integer() | infinity`{: #sync_nodes_timeout }** -\n  Specifies the time (in milliseconds) that this node waits for the mandatory\n  and optional nodes to start. If this parameter is undefined, no node\n  synchronization is performed. This option ensures that `global` is\n  synchronized.\n\n- **`start_distribution = true | false`{: #start_distribution }** - Starts all\n  distribution services, such as `rpc`, `global`, and `net_kernel` if the\n  parameter is `true`. This parameter is to be set to `false` for systems who\n  want to disable all distribution functionality.\n\n  Defaults to `true`.\n\n- **`start_dist_ac = true | false`{: #start_dist_ac }** - Starts the `dist_ac`\n  server if the parameter is `true`. This parameter is to be set to `true` for\n  systems using distributed applications.\n\n  Defaults to `false`. If this parameter is undefined, the server is started if\n  parameter `distributed` is set.\n\n- **`start_boot_server = true | false`{: #start_boot_server }** - Starts the\n  `boot_server` if the parameter is `true` (see `m:erl_boot_server`). This\n  parameter is to be set to `true` in an embedded system using this service.\n\n  Defaults to `false`.\n\n- **`boot_server_slaves = [SlaveIP]`{: #boot_server_slaves }** - If\n  configuration parameter `start_boot_server` is `true`, this parameter can be\n  used to initialize `boot_server` with a list of slave IP addresses:\n\n  `SlaveIP = string() | atom | {integer(),integer(),integer(),integer()}`,\n\n  where `0 <= integer() <=255`.\n\n  Examples of `SlaveIP` in atom, string, and tuple form:\n\n  `'150.236.16.70', \"150,236,16,70\", {150,236,16,70}`.\n\n  Defaults to `[]`.\n\n- **`start_disk_log = true | false`{: #start_disk_log }** - Starts the\n  `disk_log_server` if the parameter is `true` (see `m:disk_log`). This\n  parameter is to be set to `true` in an embedded system using this service.\n\n  Defaults to `false`.\n\n- **`start_pg = true | false`{: #start_pg }** - Starts the\n  default `pg` scope server (see `m:pg`) if the parameter is `true`. This\n  parameter is to be set to `true` in an embedded system that uses this service.\n\n  Defaults to `false`.\n\n- **`start_timer = true | false`{: #start_timer }** - Starts the `timer_server`\n  if the parameter is `true` (see `m:timer`). This parameter is to be set to\n  `true` in an embedded system using this service.\n\n  Defaults to `false`.\n\n- **`shell_docs_ansi = boolean()`{: #shell_docs_ansi }** - Specifies whether\n  the documentation rendered in the shell should use ANSI escape codes.\n\n  See also `t:shell_docs:config/0`.\n\n- **`shell_history = enabled | disabled | module()`{: #shell_history }** -\n  Specifies whether shell history should be logged to disk between usages of\n  `erl` (`enabled`), not logged at all (`disabled`), or a user-specified module\n  will be used to log shell history. This module should export\n  `load() -> [string()]` returning a list of strings to load in the shell when\n  it starts, and `add(iodata()) -> ok.` called every time new line is entered in\n  the shell. By default logging is disabled.\n\n- **`shell_history_drop = [string()]`{: #shell_history_drop }** - Specific log\n  lines that should not be persisted. For example `[\"q().\", \"init:stop().\"]`\n  will allow to ignore commands that shut the node down. Defaults to `[]`.\n\n- **`shell_history_file_bytes = integer()`{: #shell_history_file_bytes }** - How\n  many bytes the shell should remember. By default, the value is set to 512kb,\n  and the minimal value is 50kb.\n\n- **`shell_history_path = string()`{: #shell_history_path }** - Specifies where\n  the shell history files will be stored. defaults to the user's cache directory\n  as returned by `filename:basedir(user_cache, \"erlang-history\")`.\n\n- **`shutdown_func = {Mod :: atom(), Func :: atom()}`{: #shutdown_func }** -\n  Sets a function that `application_controller` calls when it starts to\n  terminate. The function is called as `Mod:Func(Reason)`, where `Reason` is the\n  terminate reason for `application_controller`, and it must return as soon as\n  possible for `application_controller` to terminate properly.\n\n- **`source_search_rules = [DirRule] | [SuffixRule]`{: #source_search_rules }**\n\n  Where:\n\n  - `DirRule = {ObjDirSuffix,SrcDirSuffix}`\n  - `SuffixRule = {ObjSuffix,SrcSuffix,[DirRule]}`\n  - `ObjDirSuffix = string()`\n  - `SrcDirSuffix = string()`\n  - `ObjSuffix = string()`\n  - `SrcSuffix = string()`\n\n  Specifies a list of rules for use by `filelib:find_file/2`\n  `filelib:find_source/2` If this is set to some other value than the empty\n  list, it replaces the default rules. Rules can be simple pairs of directory\n  suffixes, such as `{\"ebin\", \"src\"}`, which are used by `filelib:find_file/2`,\n  or triples specifying separate directory suffix rules depending on file name\n  extensions, for example `[{\".beam\", \".erl\", [{\"ebin\", \"src\"}]}`, which are\n  used by `filelib:find_source/2`. Both kinds of rules can be mixed in the list.\n\n  The interpretation of `ObjDirSuffix` and `SrcDirSuffix` is as follows: if the\n  end of the directory name where an object is located matches `ObjDirSuffix`,\n  then the name created by replacing `ObjDirSuffix` with `SrcDirSuffix` is\n  expanded by calling `filelib:wildcard/1`, and the first regular file found\n  among the matches is the source file.\n\n- **`standard_io_encoding = Encoding`{: #standard_io_encoding }** - Set whether\n  bytes sent or received via standard_io should be interpreted as unicode or\n  latin1. By default input and output is interpreted as Unicode if it is\n  supported on the host. With this flag you may configure the encoding on\n  startup.\n\n  This works similarly to\n  [`io:setopts(standard_io, {encoding, Encoding})`](`io:setopts/2`) but is\n  applied before any bytes on standard_io may have been read.\n\n  Encoding is one of:\n\n  - **`unicode`** - Configure standard_io to use unicode mode.\n\n  - **`latin1`** - Configure standard_io to use latin1 mode.\n\n  - **`_`** - Anything other than unicode or latin1 will be ignored and the\n    system will configure the encoding by itself, typically unicode on modern\n    systems.\n\n  See\n  [Escripts and non-interactive I/O in Unicode Usage in Erlang](`e:stdlib:unicode_usage.md#escripts-and-non-interactive-i-o`)\n  for more details.\n\n- **`os_cmd_shell = string()`{: #os_cmd_shell }** - Specifies which shell to\n  use when invoking system commands via `os:cmd/2`. By default the shell is detected\n  automatically.","ref":"kernel_app.html#configuration"},{"type":"extras","title":"Deprecated Configuration Parameters - Kernel Application","doc":"In Erlang/OTP 21.0, a new API for logging was added. The old `error_logger`\nevent manager, and event handlers running on this manager, still work, but they\nare no longer used by default.\n\nThe following application configuration parameters can still be set, but they\nare only used if the corresponding configuration parameters for Logger are not\nset.\n\n- **`error_logger`** - Replaced by setting the [`type`](`m:logger_std_h#type`),\n  and possibly [`file`](`m:logger_std_h#file`) and\n  [`modes`](`m:logger_std_h#modes`) parameters of the default `logger_std_h`\n  handler. Example:\n\n  ```text\n  erl -kernel logger '[{handler,default,logger_std_h,#{config=>#{file=>\"/tmp/erlang.log\"}}}]'\n  ```\n\n- **`error_logger_format_depth`**{: #error_logger_format_depth } - Replaced by setting the\n  [`depth`](`m:logger_formatter#depth`) parameter of the default handlers\n  formatter. Example:\n\n  ```text\n  erl -kernel logger '[{handler,default,logger_std_h,#{formatter=>{logger_formatter,#{legacy_header=>true,template=>[{logger_formatter,header},\"\\n\",msg,\"\\n\"],depth=>10}}}]'\n  ```\n\nSee [Backwards compatibility with error_logger](logger_chapter.md#backwards-compatibility-with-error_logger)\nfor more information.","ref":"kernel_app.html#deprecated-configuration-parameters"},{"type":"extras","title":"Kernel Release Notes","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Kernel Release Notes\n\nThis document describes the changes made to the Kernel application.","ref":"notes.html"},{"type":"extras","title":"Kernel 10.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-10-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fixed an issue where output to the shell would not print the prompt on a new line.\n\n  Own Id: OTP-19228 Aux Id: [PR-8820]\n\n- When in `m:shell` is in `-noshell` mode, and in `latin1` encoding mode, io requests in latin1 encoding will not be translated to unicode and back to latin1.\n\n  Own Id: OTP-19296 Aux Id: [PR-9013]\n\n- Fixed a bug where a composing unicode character would bind to a character not available to the user and deleting that character would cause a crash.\n\n  Own Id: OTP-19297 Aux Id: [PR-9005]\n\n- The [`-noshell`](`e:erts:erl_cmd.md#noshell`) mode has been updated to read data lazily from standard input. Before this fix any data would be read greedily which meant that Erlang could consume data not meant for it. It also meant that in order for `shell:start_interactive/0` to work on Windows an API that did not support reading of Unicode characters had to be used.\n\n  Own Id: OTP-19313 Aux Id: [PR-8962], [GH-8113]\n\n- The Erlang shell no longer crashes when a shell prompt ends with an escape sequence.\n\n  Own Id: OTP-19414 Aux Id: [PR-9272]\n\n- `code:get_doc/1` now works for cover-compiled modules.\n\n  Own Id: OTP-19513 Aux Id: [PR-9433]\n\n- An infinite loop in CNAME loop detection that can cause Out Of Memory has been fixed.  This affected CNAME lookup with the internal DNS resolver.\n\n  Own Id: OTP-19544 Aux Id: [PR-9587], OTP-19545\n\n- The internal resolver framework has been fixed to wait with the first resolver lookup until the ERL_INETRC environment variable has been applied.\n  \n  Previously, on some platform(s) (Linux) a first lookup when figuring out the domain name was always placed on the `native` resolver even if ERL_INETRC was used to disable it.\n\n  Own Id: OTP-19555 Aux Id: [PR-9543]\n\n- Fix [`logger:add_handler(default, ...)`](`logger:add_handler/3`) to correctly replay events generated during startup when the default logger is set to `undefined` in [logger's configuration parameters](logger_chapter.md#kernel-configuration-parameters).\n\n  Own Id: OTP-19588 Aux Id: [PR-9595], [GH-9436]\n\n- Enhance specs of timeout for improving documentation and dialyzer analysis.\n\n  Own Id: OTP-19604 Aux Id: [PR-9574]\n\n- Removed the default values for SCTP send (sndbuf) and receive (recbuf) buffers.\n\n  Own Id: OTP-19627 Aux Id: OTP-19576, [GH-9722]\n\n[PR-8820]: https://github.com/erlang/otp/pull/8820\n[PR-9013]: https://github.com/erlang/otp/pull/9013\n[PR-9005]: https://github.com/erlang/otp/pull/9005\n[PR-8962]: https://github.com/erlang/otp/pull/8962\n[GH-8113]: https://github.com/erlang/otp/issues/8113\n[PR-9272]: https://github.com/erlang/otp/pull/9272\n[PR-9433]: https://github.com/erlang/otp/pull/9433\n[PR-9587]: https://github.com/erlang/otp/pull/9587\n[PR-9543]: https://github.com/erlang/otp/pull/9543\n[PR-9595]: https://github.com/erlang/otp/pull/9595\n[GH-9436]: https://github.com/erlang/otp/issues/9436\n[PR-9574]: https://github.com/erlang/otp/pull/9574\n[GH-9722]: https://github.com/erlang/otp/issues/9722","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- `application:load/1` slows down as the number of directories in the code path increases because the call to `code:where_is_file/1` for the '.app' file must scan each directory for the app. \n  \n  `code_server` maintains a cache of the contents of directories in the path. Re-using that cache when searching for '.app' files in `application:load/1` may improve its runtime, especially when loading multiple applications.\n\n  Own Id: OTP-19194 Aux Id: [PR-8078]\n\n- The [`Erlang SSH daemon`](`e:ssh:using_ssh.md#running-an-erlang-ssh-daemon`) now uses the same backend to handle multiline functionality as the Erlang shell.\n\n  Own Id: OTP-19226 Aux Id: [PR-8805]\n\n- Added support for `SIGWINCH`, `SIGCONT`, and `SIGINFO` signals to `os:set_signal/2` where available.\n\n  Own Id: OTP-19278 Aux Id: [PR-8887], [PR-8938]\n\n- Add `net_kernel:allowed/0`, it returns a list of nodes that are explicitly allowed to connect to the node by calling\n  `net_kernel:allow/1`\n\n  Own Id: OTP-19287 Aux Id: [PR-8207]\n\n- Documentation chunks (EEP-48) has been updated to include the following reserved metadata fields: `behaviours`, `group`, `source_path`, and `source_annos`. The compiler has also been updated to emit this metadata. See the [EEP-48 documentation](eep48_chapter.md) for more details.\n\n  Own Id: OTP-19306 Aux Id: [PR-8945], [PR-8975]\n\n- The `erpc:call/3`, `erpc:call/5`, `erpc:multicall/3`, and `erpc:multicall/5` functions now also accept an option map as last argument containing the `timeout` and `always_spawn` options. The `always_spawn` option can be used in order to ensure that the call operation will use a newly spawned process when executing the remote call.\n\n  Own Id: OTP-19343 Aux Id: [PR-8642]\n\n- [EEP-69: Nominal Types](https://www.erlang.org/eeps/eep-0069) has been implemented. As a side effect, nominal types can encode opaque types. We changed all opaque-handling logic and improved opaque warnings in Dialyzer.\n  \n  All existing Erlang type systems are structural: two types are seen as equivalent if their structures are the same. Type comparisons are based on the structures of the types, not on how the user explicitly defines them. For example, in the following example, `meter()` and `foot()` are equivalent. The two types can be used interchangeably. Neither of them differ from the basic type `integer()`.\n  \n  ````\n  -type meter() :: integer().\n  -type foot() :: integer().\n  ````\n  \n  Nominal typing is an alternative type system, where two types are equivalent if and only if they are declared with the same type name. The EEP proposes one new syntax -nominal for declaring nominal types. Under nominal typing, `meter()` and `foot()` are no longer compatible. Whenever a function expects type `meter()`, passing in type `foot()` would result in a Dialyzer error.\n  \n  ````\n  -nominal meter() :: integer().\n  -nominal foot() :: integer().\n  ````\n  \n  More nominal type-checking rules can be found in the EEP. It is worth noting that most work for adding nominal types and type-checking is in `erl_types.erl`. The rest are changes that removed the previous opaque type-checking, and added an improved version of it using nominal type-checking with reworked warnings.\n  \n  Backwards compatibility for opaque type-checking is not preserved by this PR. Previous opaque warnings can appear with slightly different wordings. A new kind of opaque warning `opaque_union` is added, together with a Dialyzer option `no_opaque_union` to turn this kind of warnings off.\n\n  Own Id: OTP-19364 Aux Id: [PR-9079]\n\n- Improved open debug for gen_tcp_socket (connect and listen) and gen_udp_socket (open).\n\n  Own Id: OTP-19386\n\n- `t:io:standard_error/0` has been updated to write via a NIF API instead of a port. This allows it to access the dirty-scheduler pool and make sure that writes have been written to the OSs `stderr` when `io:format/3` and equivalent return.\n\n  Own Id: OTP-19401 Aux Id: [PR-9116]\n\n- Added the option `exception_on_failure` to `os:cmd/2` to make `os:cmd/2` raise an exception if the command fails to execute.\n\n  Own Id: OTP-19404 Aux Id: [PR-9082]\n\n- A `socket` option `{otp,select_read}` has been added that enables keeping a socket in the VM select/poll set between calls to recv functions.\n  \n  This increases throughput by reducing the number of calls to said functions.\n\n  Own Id: OTP-19451 Aux Id: [PR-9344]\n\n- Add a configure chapter to the socket usage guide\n\n  Own Id: OTP-19522 Aux Id: [PR-9508]\n\n- The license and copyright header has changed format to include an `SPDX-License-Identifier`. At the same time, most files have been updated to follow a uniform standard for license headers.\n\n  Own Id: OTP-19575 Aux Id: [PR-9670]\n\n- Increase the default inet-driver buffer size(s). Also introduce kernel parameters for UDP and SCTP to change the sizes when creating (those) sockets.\n\n  Own Id: OTP-19576\n\n- An  **experimental** API for a native debugger has been added. The main components are the following:\n  \n  * A new compiler option `beam_debug_info` for the Erlang compiler. When given, most optimizations are disabled and debug information suitable for the native debugger are added to generated BEAM files.\n  \n  * A new `+D` emulator flag. When given, the VM becomes \"debuggable\", which means that when modules that been compiled with the `beam_debug_info` option are loaded, the code is instrumented so that one can enable and disable breakpoints on executable lines.\n  \n  * An experimental `erl_debugger` module with a new debugging API. Essentially, it allows a single, local, process to be registered as the \"debugger\" process for the node. This process is the one that will receive messages notifying that a process hit a breakpoint. This way, the front-end implementation of a debugger (such as [edb from WhatApp](https://github.com/WhatsApp/edb)) can be decoupled from OTP.\n  \n  * The `erl_debugger` module also exposes new BIFs to inspect `X` and `Y` registers of a suspended process. Together with new code-information BIFs, this let's a debugger show the values of variables in scope for a suspended process.\n\n  Own Id: OTP-19609 Aux Id: [PR-8670], [PR-9334], [PR-9604]\n\n[PR-8078]: https://github.com/erlang/otp/pull/8078\n[PR-8805]: https://github.com/erlang/otp/pull/8805\n[PR-8887]: https://github.com/erlang/otp/pull/8887\n[PR-8938]: https://github.com/erlang/otp/pull/8938\n[PR-8207]: https://github.com/erlang/otp/pull/8207\n[PR-8945]: https://github.com/erlang/otp/pull/8945\n[PR-8975]: https://github.com/erlang/otp/pull/8975\n[PR-8642]: https://github.com/erlang/otp/pull/8642\n[PR-9079]: https://github.com/erlang/otp/pull/9079\n[PR-9116]: https://github.com/erlang/otp/pull/9116\n[PR-9082]: https://github.com/erlang/otp/pull/9082\n[PR-9344]: https://github.com/erlang/otp/pull/9344\n[PR-9508]: https://github.com/erlang/otp/pull/9508\n[PR-9670]: https://github.com/erlang/otp/pull/9670\n[PR-8670]: https://github.com/erlang/otp/pull/8670\n[PR-9334]: https://github.com/erlang/otp/pull/9334\n[PR-9604]: https://github.com/erlang/otp/pull/9604","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Kernel 10.2.7 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-10-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- With this change, disk_log will not crash when using chunk_step/3 after log size was decreased.\n\n  Own Id: OTP-19605 Aux Id: [GH-9720], [PR-9765]\n\n- With this change, disk_log will not run into infinite loop when using chunk/2,3 after log size was decreased.\n\n  Own Id: OTP-19608 Aux Id: [GH-9707], [PR-9767]\n\n[GH-9720]: https://github.com/erlang/otp/issues/9720\n[PR-9765]: https://github.com/erlang/otp/pull/9765\n[GH-9707]: https://github.com/erlang/otp/issues/9707\n[PR-9767]: https://github.com/erlang/otp/pull/9767","ref":"notes.html#fixed-bugs-and-malfunctions-1"},{"type":"extras","title":"Kernel 10.2.6 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-10-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fixed bug in `call_memory` tracing that could cause wildly incorrect reported memory values. Bug exists since OTP 27.1.\n  \n  Also fixed return type spec of `trace:info/3`.\n\n  Own Id: OTP-19581 Aux Id: ERIERL-1219, [PR-9706]\n\n[PR-9706]: https://github.com/erlang/otp/pull/9706","ref":"notes.html#fixed-bugs-and-malfunctions-2"},{"type":"extras","title":"Kernel 10.2.5 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-10-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- On Windows, using socket:sendv, a large IOV (size > MAX), the tail was not sent.\n\n  Own Id: OTP-19482\n\n- gen_tcp connect with a sockaddr with loopback address failed.\n\n  Own Id: OTP-19560 Aux Id: [GH-9541]\n\n- Remove debug printouts from gen_tcp_socket\n\n  Own Id: OTP-19564\n\n[GH-9541]: https://github.com/erlang/otp/issues/9541","ref":"notes.html#fixed-bugs-and-malfunctions-3"},{"type":"extras","title":"Kernel 10.2.4 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-10-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Behavior for socket:recv/3 has been improved. The behavior has also been clarified in the documentation.\n\n  Own Id: OTP-19469 Aux Id: [#9172]\n\n- An infinite loop in CNAME loop detection that can cause Out Of Memory has been fixed. This affected CNAME lookup with the internal DNS resolver.\n\n  Own Id: OTP-19545 Aux Id: [PR-9587], OTP-19544\n\n[#9172]: https://github.com/erlang/otp/issues/9172\n[PR-9587]: https://github.com/erlang/otp/pull/9587","ref":"notes.html#fixed-bugs-and-malfunctions-4"},{"type":"extras","title":"Kernel 10.2.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-10-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Clarify inet:setopts documentation\n\n  Own Id: OTP-19416 Aux Id: [PR-9248]\n\n- Fix bug where log printouts would go missing when `application_controller` is stopping while log messages are being sent.\n  \n  This bug was introduced by OTP-19078 in Erlang/OTP 26.2.5.\n\n  Own Id: OTP-19418 Aux Id: [GH-9163], [PR-9274]\n\n- Fixes a bug in the socket type spec, which caused Dialyzer to reject some valid programs.\n\n  Own Id: OTP-19429 Aux Id: [PR-9295], [PR-9379]\n\n[PR-9248]: https://github.com/erlang/otp/pull/9248\n[GH-9163]: https://github.com/erlang/otp/issues/9163\n[PR-9274]: https://github.com/erlang/otp/pull/9274\n[PR-9295]: https://github.com/erlang/otp/pull/9295\n[PR-9379]: https://github.com/erlang/otp/pull/9379","ref":"notes.html#fixed-bugs-and-malfunctions-5"},{"type":"extras","title":"Kernel 10.2.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-10-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fixed a couple of bugs that could make `global`'s internal state inconsistent when a connection was reconnected.\n\n  Own Id: OTP-19381 Aux Id: [PR-9377], [GH-9112], [GH-9117]\n\n[PR-9377]: https://github.com/erlang/otp/pull/9377\n[GH-9112]: https://github.com/erlang/otp/issues/9112\n[GH-9117]: https://github.com/erlang/otp/issues/9117","ref":"notes.html#fixed-bugs-and-malfunctions-6"},{"type":"extras","title":"Kernel 10.2.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-10-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix the default group_leader to reply `{error,request}` on invalid I/O requests instead of crashing.\n  \n  This bug was introduced in Erlang/OTP 27.2.\n\n  Own Id: OTP-19444 Aux Id: [GH-9237], [PR-9318]\n\n[GH-9237]: https://github.com/erlang/otp/issues/9237\n[PR-9318]: https://github.com/erlang/otp/pull/9318","ref":"notes.html#fixed-bugs-and-malfunctions-7"},{"type":"extras","title":"Kernel 10.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-10-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- `gen_sctp:peeloff/2` has been fixed to inherit socket options to the peeled off socket more like `gen_tcp:accept/1`, for example the options `tos` or `tclass`.\n  \n  When setting SCTP options that are unsupported on the platform, some should be silently ignored, but a bug caused the option parsing to derail so the options after could bail out and cause an error instead.  This has been fixed.\n\n  Own Id: OTP-19225 Aux Id: [PR-8789]\n\n- Made it possible to expand help text displayed by pressing ^[h by pressing ^[h again.\n\n  Own Id: OTP-19260 Aux Id: [PR-8884]\n\n- [`inet:getifaddrs/0,1`](`inet:getifaddrs/1`) is improved when using\n  inet_backend = socket.\n\n  Own Id: OTP-19264\n\n- Fixed `t:logger:report/0` to mandate at least one element in the report. This fixes an issue with overlapping `spec` domains in all `m:logger` functions that use `t:logger:report/0`.\n\n  Own Id: OTP-19302 Aux Id: [PR-8959]\n\n- Fixed deadlock on `code_server`. Multiple calls loading the same module with an `on_load` function loading call would create a deadlock.\n\n  Own Id: OTP-19305 Aux Id: [PR-8744], [GH-7466], [GH-8510]\n\n[PR-8789]: https://github.com/erlang/otp/pull/8789\n[PR-8884]: https://github.com/erlang/otp/pull/8884\n[PR-8959]: https://github.com/erlang/otp/pull/8959\n[PR-8744]: https://github.com/erlang/otp/pull/8744\n[GH-7466]: https://github.com/erlang/otp/issues/7466\n[GH-8510]: https://github.com/erlang/otp/issues/8510","ref":"notes.html#fixed-bugs-and-malfunctions-8"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- The Kernel application now recognizes the `epmd_module` and `erl_epmd_listen_port` parameters, similar to `-kernel:connect_all`.\n\n  Own Id: OTP-19253 Aux Id: [PR-8671]\n\n- The `inetrc` kernel argument will now tolerate atoms again to improve compatibility with old configurations that relied on atoms working by accident.\n  \n  The expected type always was, and still remains, a string.\n\n  Own Id: OTP-19280 Aux Id: [GH-8899], [PR-8902]\n\n- The `t:file:io_device/0` type has been updated to clearly show the difference between a `raw` and `cooked` IoDevice.\n\n  Own Id: OTP-19301 Aux Id: [PR-8956]\n\n- Erlang/OTP type specifications has been updated to eliminate overlapping domains.\n\n  Own Id: OTP-19310 Aux Id: [GH-8810], [GH-8821], [PR-8986]\n\n- Added the kernel parameter [`os_cmd_shell`](kernel_app.md#os_cmd_shell) that controls which shell should be used by `os:cmd/1`.\n\n  Own Id: OTP-19342 Aux Id: [PR-8972]\n\n- Added logging support to `t:io:user/0`, `t:io:standard_io/0` and `t:io:standard_error/0`. See `io:setopts/2` for more details.\n\n  Own Id: OTP-19372 Aux Id: [PR-8947]\n\n[PR-8671]: https://github.com/erlang/otp/pull/8671\n[GH-8899]: https://github.com/erlang/otp/issues/8899\n[PR-8902]: https://github.com/erlang/otp/pull/8902\n[PR-8956]: https://github.com/erlang/otp/pull/8956\n[GH-8810]: https://github.com/erlang/otp/issues/8810\n[GH-8821]: https://github.com/erlang/otp/issues/8821\n[PR-8986]: https://github.com/erlang/otp/pull/8986\n[PR-8972]: https://github.com/erlang/otp/pull/8972\n[PR-8947]: https://github.com/erlang/otp/pull/8947","ref":"notes.html#improvements-and-new-features-1"},{"type":"extras","title":"Kernel 10.1.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-10-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- On windows the socket:recv could return with success ({ok, Data}) even though not all data had been read.\n\n  Own Id: OTP-19328\n\n- gen_udp:send on domain local can leak inet_reply messages.\n\n  Own Id: OTP-19332 Aux Id: [#8989]\n\n- Failure to create an UDP IPv6 socket when inet_backend = socket with certain IPv6 socket options.\n\n  Own Id: OTP-19357\n\n- net:getifaddrs does not properly report the running flag on windows.\n\n  Own Id: OTP-19366 Aux Id: OTP-19061, ERIERL-1134\n\n[#8989]: https://github.com/erlang/otp/issues/8989","ref":"notes.html#fixed-bugs-and-malfunctions-9"},{"type":"extras","title":"Kernel 10.1.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-10-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- A bug has been fixed where receiving an SCTP message with `gen_sctp` could waste the first fragments of a message and only deliver the last fragment.\n  \n  This happened with low probability when the OS signaled that the socket was ready for reading in combination with an internal time-out retry.\n  \n  A bug has been fixed with a lingering time-out from after an SCTP connect that could stop the flow of incoming messages on an active `gen_tcp` socket.\n\n  Own Id: OTP-19235 Aux Id: ERIERL-1133, [PR-8837]\n\n- An boolean option `non_block_send` for SCTP, has ben added to be able to achieve the old behaviour to avoid blocking send operations by passing the OS network stack error message (`{error,eagain}` through.\n\n  Own Id: OTP-19258 Aux Id: OTP-19061, ERIERL-1134\n\n[PR-8837]: https://github.com/erlang/otp/pull/8837","ref":"notes.html#fixed-bugs-and-malfunctions-10"},{"type":"extras","title":"Kernel 10.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-10-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- A faulty assertion was corrected in the `prim_tty` module. This assertion could trigger when invalid UTF-8 was read from stdin just as the mode was changed from unicode to latin1.\n\n  Own Id: OTP-19097 Aux Id: [PR-8503]\n\n- Opening a `disk_log` file and combining `head_func` with `rotate` options did not work.\n\n  Own Id: OTP-19104 Aux Id: ERIERL-870\n\n- Fixed an error info printout for `erlang:is_process_alive/1` on non-local pids.\n\n  Own Id: OTP-19134 Aux Id: [PR-8560]\n\n- A race in the kTLS flavour of SSL distribution has been fixed so that `inet_drv.c` doesn't read ahead too much data, which could cause the kTLS encryption to be activated too late when some encrypted data had already been read into the `inet_drv.c` buffer as unencrypted.\n\n  Own Id: OTP-19175 Aux Id: [GH-8561], [PR-8690]\n\n- Fixed a deadlock when an application crashes during startup and log messages were sent to standard out. Logger would fail to print the messages to standard out and instead print them to standard error.\n\n  Own Id: OTP-19205\n\n- The `-proto_dist` init parameter will no longer be ignored when specified multiple times. It will now log a warning and use the first specified value.\n\n  Own Id: OTP-19208 Aux Id: [PR-8672]\n\n- Corrected socket:ioctl for genaddr (SIOCGENADDR).\n\n  Own Id: OTP-19216\n\n[PR-8503]: https://github.com/erlang/otp/pull/8503\n[PR-8560]: https://github.com/erlang/otp/pull/8560\n[GH-8561]: https://github.com/erlang/otp/issues/8561\n[PR-8690]: https://github.com/erlang/otp/pull/8690\n[PR-8672]: https://github.com/erlang/otp/pull/8672","ref":"notes.html#fixed-bugs-and-malfunctions-11"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Added functions `getservbyname` and `getservbyport` to the `net` module.\n\n  Own Id: OTP-19101 Aux Id: OTP-18835\n\n- Introduced enet | esock variants of `m:inet` functions, either when called with sockets,\n  with explicit inet_backend config or with the e inet_backend kernel config option.\n\n  Own Id: OTP-19132 Aux Id: OTP-19101\n\n- The function `socket:i/0` now uses the `m:net` module (instead of the `m:inet` module) for service translation.\n\n  Own Id: OTP-19138 Aux Id: OTP-19101\n\n- A boolean option `read_ahead` has been implemented for `gen_tcp`, default `true`, to facilitate not reading past (caching data) the end of a packet.  In particular, for kTLS, caching data could read in data that was supposed to be decrypted by the platform's network stack, before crypto parameters could be activated.\n\n  Own Id: OTP-19199 Aux Id: OTP-19175, [GH-8561], [GH-8690], [GH-8785]\n\n[GH-8561]: https://github.com/erlang/otp/issues/8561\n[GH-8690]: https://github.com/erlang/otp/issues/8690\n[GH-8785]: https://github.com/erlang/otp/issues/8785","ref":"notes.html#improvements-and-new-features-2"},{"type":"extras","title":"Kernel 10.0.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-10-0-1"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Polish the `m:logger` documentation.\n\n  Own Id: OTP-19118 Aux Id: [PR-8534]\n\n[PR-8534]: https://github.com/erlang/otp/pull/8534","ref":"notes.html#improvements-and-new-features-3"},{"type":"extras","title":"Kernel 10.0 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-10-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fixed a crash when calling `file:delete/2` with an empty option list.\n\n  Own Id: OTP-18590 Aux Id: [PR-7220]\n\n- New functions have been added to the undocumented module `m:inet_dns` that take a flag to specify if encode/decode is for mDNS.  This affects how CLASS values in the private range, with the top bit set, are handled.\n\n  Own Id: OTP-18878 Aux Id: [GH-7718], OTP-17734\n\n- The error information for `erlang:phash/2` has been corrected.\n\n  Own Id: OTP-18904 Aux Id: [PR-7960]\n\n- `get_until` requests using the I/O protocol now correctly return a binary or list when `eof` is the last item returned by the callback.\n\n  Own Id: OTP-18930 Aux Id: [PR-7993], [GH-4992]\n\n- Calling `logger:add_handlers/1` with config option now works.\n\n  Own Id: OTP-18954 Aux Id: [GH-8061], [PR-8076]\n\n- The `code:del_path/1` function now also works on paths added through `-pa`, `-pz` , `-path` and the boot script.\n\n  Own Id: OTP-18959 Aux Id: [GH-6692], [PR-7697]\n\n- A  call to `socket:[recv|recvfrom|recvmsg]/*` with Timeout = 0 on Windows could cause a (case clause) crash if data is immediately available.\n\n  Own Id: OTP-19063 Aux Id: OTP-18835\n\n- Improve heuristic for when a characters is wide in the shell for systems with old libc versions.\n\n  Own Id: OTP-19087 Aux Id: [PR-8382]\n\n- Fix reading a line when reading from `t:io:user/0` to not consider `\\r` without `\\n` to be a new line when `erl` is started with `-noshell`.\n\n  Own Id: OTP-19088 Aux Id: [PR-8396], [GH-8360]\n\n[PR-7220]: https://github.com/erlang/otp/pull/7220\n[GH-7718]: https://github.com/erlang/otp/issues/7718\n[PR-7960]: https://github.com/erlang/otp/pull/7960\n[PR-7993]: https://github.com/erlang/otp/pull/7993\n[GH-4992]: https://github.com/erlang/otp/issues/4992\n[GH-8061]: https://github.com/erlang/otp/issues/8061\n[PR-8076]: https://github.com/erlang/otp/pull/8076\n[GH-6692]: https://github.com/erlang/otp/issues/6692\n[PR-7697]: https://github.com/erlang/otp/pull/7697\n[PR-8382]: https://github.com/erlang/otp/pull/8382\n[PR-8396]: https://github.com/erlang/otp/pull/8396\n[GH-8360]: https://github.com/erlang/otp/issues/8360","ref":"notes.html#fixed-bugs-and-malfunctions-12"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Added `file:read_file/2` with a `raw` option for reading files without going through the file server.\n\n  Own Id: OTP-18589 Aux Id: [PR-7220]\n\n- The undocumented Erlang DNS resolver library (`inet_dns` and `inet_res`) has been augmented to handle IXFR, NOTIFY, UPDATE and TSIG records.  With this some bug fixes and code cleanup has been done, and the resolver used in the test suite has been changed to Knot DNS.  See the source code. \n  \n  Kudos to Alexander Clouter that did almost all the work!\n\n  Own Id: OTP-18713 Aux Id: [PR-6985], [GH-6985]\n\n- The `ebin` directories for escripts are now cached.\n\n  Own Id: OTP-18778 Aux Id: [PR-7556]\n\n- `-callback` attributes haven been added to `m:application`, `m:logger_handler`, and `m:logger_formatter`.\n\n  Own Id: OTP-18795 Aux Id: [PR-7703]\n\n- Progress reports from before logger is started are now logged when log level is set to debug.\n\n  Own Id: OTP-18807 Aux Id: [PR-7732] ERIERL-985\n\n- The `code:where_is_file/2` and\n  `code:which/1` functions now check for existence of the file directly instead of listing the content of each directory in the code path.\n\n  Own Id: OTP-18816 Aux Id: [PR-7711]\n\n- Type specs has been added to the [`logger:Level/1,2,3`](`m:logger`) functions.\n\n  Own Id: OTP-18820 Aux Id: [PR-7779]\n\n- For `inet_backend = socket`, setting the `active` socket option alone, to `once`, `true` or `N` has been optimized, as well as the corresponding data delivery.\n\n  Own Id: OTP-18835\n\n- New functions `socket:sendv/*` for sending I/O vectors have been added.\n\n  Own Id: OTP-18845\n\n- The shell now pages long output from the documentation help command ([`h(Module)`](`c:h/1`)), auto completions and the search command.\n\n  Own Id: OTP-18846 Aux Id: [PR-7845]\n\n- Native coverage support has been implemented in the JIT. It will  automatically be used by the `m:cover` tool to reduce the execution overhead when running cover-compiled code.\n  \n  There are also new APIs to support native coverage without using the `cover` tool.\n  \n  To instrument code for native coverage it must be compiled with the [`line_coverage`](`m:compile#line_coverage`) option.\n  \n  To enable native coverage in the runtime system, start it like so:\n  \n  ```text\n  $ erl +JPcover true\n  ```\n  \n  There are also the following new functions for supporting native coverage:\n  \n  * `code:coverage_support/0`\n  * `code:get_coverage/2`\n  * `code:reset_coverage/1`\n  * `code:get_coverage_mode/0`\n  * `code:get_coverage_mode/1`\n  * `code:set_coverage_mode/1`\n\n  Own Id: OTP-18856 Aux Id: [PR-7856]\n\n- Optimized code loading by moving certain operations from the code server to the caller.\n\n  Own Id: OTP-18941 Aux Id: [PR-7981]\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n- Application startup has been optimized by removing an intermediary process.\n\n  Own Id: OTP-18963 Aux Id: [PR-8042]\n\n- The existing experimental support for archive files will be changed in a future release. The support for having an archive in an escript will remain, but the support for using archives in a release will either become more limited or completely removed.\n  \n  As of Erlang/OTP 27, the function `code:lib_dir/2`, the `-code_path_choice` flag, and using `m:erl_prim_loader` for reading members of an archive are deprecated.\n  \n  To remain compatible with future version of Erlang/OTP `escript` scripts that need to retrieve data files from its archive should use `escript:extract/2` instead of `erl_prim_loader` and `code:lib_dir/2`.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-18966 Aux Id: [PR-8091]\n\n- The undocumented and deprecated `file:pid2name` function has been removed.\n\n  Own Id: OTP-18967 Aux Id: [PR-8092]\n\n- There is a new module `m:trace` in Kernel providing the same trace functionality as `erlang:trace/3` and `erlang:trace_pattern/3`, but with the addition of **dynamic isolated trace sessions**.\n\n  Own Id: OTP-18980\n\n- Error logging has been improved when the `t:io:standard_io/0` reader and/or writer terminates with an error.\n\n  Own Id: OTP-18989 Aux Id: [PR-8103]\n\n- `inet_backend = socket` has been optimized and reworked to be more compatible with the original `inet_backend = inet`.\n\n  Own Id: OTP-19004 Aux Id: OTP-18835\n\n- Add an simple example (echo server) )to the socket users guide.\n\n  Own Id: OTP-19042\n\n- `inet:i/0,1,2` has been improved to allow port numbers to be shown explicitly.\n\n  Own Id: OTP-19053 Aux Id: [#6724]\n\n- The `socket` documentation has been reworked, and due to\n  that a few details were fixed:\n  * `socket:is_supported/1` now returns `true` for example for `protocols`\n    that is a \"category\", not an item.\n  * `socket:cancel_monitor/1` no longer badargs for a monitor that was set by\n    another process, instead it returns `false` as for other unknown\n    `reference()`s.\n\n  Own Id: OTP-19054\n\n- Add `stdin`, `stdout` and `stderr` keys to `io:getopts/1` on `t:io:standard_io/0` to indicate if the respective I/O device is backed by a terminal.\n\n  Own Id: OTP-19089 Aux Id: [PR-8396]\n\n[PR-7220]: https://github.com/erlang/otp/pull/7220\n[PR-6985]: https://github.com/erlang/otp/pull/6985\n[GH-6985]: https://github.com/erlang/otp/issues/6985\n[PR-7556]: https://github.com/erlang/otp/pull/7556\n[PR-7703]: https://github.com/erlang/otp/pull/7703\n[PR-7732]: https://github.com/erlang/otp/pull/7732\n[PR-7711]: https://github.com/erlang/otp/pull/7711\n[PR-7779]: https://github.com/erlang/otp/pull/7779\n[PR-7845]: https://github.com/erlang/otp/pull/7845\n[PR-7856]: https://github.com/erlang/otp/pull/7856\n[PR-7981]: https://github.com/erlang/otp/pull/7981\n[PR-8026]: https://github.com/erlang/otp/pull/8026\n[PR-8042]: https://github.com/erlang/otp/pull/8042\n[PR-8091]: https://github.com/erlang/otp/pull/8091\n[PR-8092]: https://github.com/erlang/otp/pull/8092\n[PR-8103]: https://github.com/erlang/otp/pull/8103\n[#6724]: https://github.com/erlang/otp/issues/6724\n[PR-8396]: https://github.com/erlang/otp/pull/8396","ref":"notes.html#improvements-and-new-features-4"},{"type":"extras","title":"Kernel 9.2.4.8 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-2-4-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* With this change, disk_log will not crash when using chunk_step/3 after log size was decreased.\n\n  Own Id: OTP-19605 Aux Id: GH-9720, PR-9765\n* With this change, disk_log will not run into infinite loop when using chunk/2,3 after log size was decreased.\n\n  Own Id: OTP-19608 Aux Id: GH-9707, PR-9767","ref":"notes.html#fixed-bugs-and-malfunctions-13"},{"type":"extras","title":"Kernel 9.2.4.7 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-2-4-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* Behavior for socket:recv/3 has been improved. The behavior has also been clarified in the documentation.\n\n  Own Id: OTP-19469 Aux Id: #9172\n* An infinite loop in CNAME loop detection that can cause Out Of Memory has been fixed. This affected CNAME lookup with the internal DNS resolver.\n\n  Own Id: OTP-19545 Aux Id: PR-9587, OTP-19544","ref":"notes.html#fixed-bugs-and-malfunctions-14"},{"type":"extras","title":"Kernel 9.2.4.6 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-2-4-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* Fixed a couple of bugs that could make `global`'s internal state inconsistent when a connection was reconnected.\n\n  Own Id: OTP-19381 Aux Id: PR-9377, GH-9112, GH-9117","ref":"notes.html#fixed-bugs-and-malfunctions-15"},{"type":"extras","title":"Kernel 9.2.4.5 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-2-4-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* Fix bug where log printouts would go missing when `application_controller` is stopping while log messages are being sent.\n\n  This bug was introduced by OTP-19078 in Erlang/OTP 26.2.5.\n\n  Own Id: OTP-19418 Aux Id: GH-9163 PR-9274","ref":"notes.html#fixed-bugs-and-malfunctions-16"},{"type":"extras","title":"Kernel 9.2.4.4 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-2-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* gen_udp:send on domain local can leak inet_reply messages.\n\n  Own Id: OTP-19332 Aux Id: #8989\n* Failure to create an UDP IPv6 socket when inet_backend = socket with certain IPv6 socket options.\n\n  Own Id: OTP-19357\n* net:getifaddrs does not properly report the running flag on windows.\n\n  Own Id: OTP-19366 Aux Id: OTP-19061, ERIERL-1134","ref":"notes.html#fixed-bugs-and-malfunctions-17"},{"type":"extras","title":"Kernel 9.2.4.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-2-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* A bug has been fixed where receiving an SCTP message with \\`gen_sctp\\` could waste the first fragments of a message and only deliver the last fragment.\n\n  This happened with low probability when the OS signaled that the socket was ready for reading in combination with an internal time-out retry.\n\n  A bug has been fixed with a lingering time-out from after an SCTP connect that could stop the flow of incoming messages on an active \\`gen_tcp\\` socket.\n\n  Own Id: OTP-19235 Aux Id: ERIERL-1133, PR-8837\n* An boolean option \\`non_block_send\\` for SCTP, has ben added to be able to achieve the old behaviour to avoid blocking send operations by passing the OS network stack error message (\\`\\{error,eagain\\}\\` through.\n\n  Own Id: OTP-19258 Aux Id: OTP-19061, ERIERL-1134","ref":"notes.html#fixed-bugs-and-malfunctions-18"},{"type":"extras","title":"Kernel 9.2.4.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-2-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* A race in the kTLS flavour of SSL distribution has been fixed so inet_drv.c doesn't read ahead too much data which could cause the kTLS encryption to be activated too late when some encrypted data had already been read into the inet_drv.c buffer as unencrypted.\n\n  Own Id: OTP-19175 Aux Id: GH-8561, PR-8690\n* Fix a deadlock when an application crashes during startup and log messages were sent to standard out. Logger would fail to print the messages to standard out and instead print them to standard error.\n\n  Own Id: OTP-19205\n* Add the stdlib application parameters `shell_redraw_prompt_on_output` which when set to `false` disables redrawing of the shell prompt if any other output is done.\n\n  Own Id: OTP-19213 Aux Id: PR-8763 ERIERL-1108","ref":"notes.html#fixed-bugs-and-malfunctions-19"},{"type":"extras","title":"Kernel 9.2.4.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-2-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* A call to socket:\\[recv|recvfrom|recvmsg]/* with Timeout = 0 on Windows could cause a (case clause) crash if data is immediately available.\n\n  Own Id: OTP-19063 Aux Id: OTP-18835\n* Open a `disk_log` file and combining `head_func` with `rotate` options did not work.\n\n  Own Id: OTP-19104 Aux Id: ERIERL-870","ref":"notes.html#fixed-bugs-and-malfunctions-20"},{"type":"extras","title":"Kernel 9.2.4 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* Fix the shell Job Control Mode to not crash when typing `TAB` or `CTRL+R`.\n\n  Own Id: OTP-19072 Aux Id: PR-8391\n* Fix calls to blocking `m:application` APIs to throw an exception with reason `terminating` if called when the system is terminating.\n\n  This is done in order to avoid deadlocks during shutdown or restart.\n\n  Own Id: OTP-19078 Aux Id: PR-8422","ref":"notes.html#fixed-bugs-and-malfunctions-21"},{"type":"extras","title":"Kernel 9.2.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* When using IPv6, classic gen_udp failed to add (group) membership (drop was used instead).\n\n  Own Id: OTP-19049 Aux Id: #8176\n* The check in inet_res of the RD bit has been relaxed slightly.\n\n  Own Id: OTP-19056 Aux Id: PR-8312, OTP-17323","ref":"notes.html#fixed-bugs-and-malfunctions-22"},{"type":"extras","title":"Kernel 9.2.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* Fix performance bug when using `io:fread` to read from `standard_io`. This regression was introduced in OTP 26.0.\n\n  Own Id: OTP-18910 Aux Id: PR-7933 GH-7924\n* A bug in the code server could cause it to crash in some concurrent scenarios. This bug was introduced in 26.1.\n\n  Own Id: OTP-18948 Aux Id: PR-8046\n* Fixed gen_udp:open/2 type spec to include already supported module socket address types.\n\n  Own Id: OTP-18990 Aux Id: GH-8158\n* Fix reading of password for ssh client when in `user_interactive` mode.\n\n  Own Id: OTP-19007 Aux Id: ERIERL-1049","ref":"notes.html#fixed-bugs-and-malfunctions-23"},{"type":"extras","title":"Kernel 9.2.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* Fix `group` (that is the shell) to properly handle when an `get_until` callback function returned `{done, eof, []}` when an `eof` was detected.\n\n  Own Id: OTP-18901","ref":"notes.html#fixed-bugs-and-malfunctions-24"},{"type":"extras","title":"Kernel 9.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- For `inet_backend = socket`, an unexpected receive error such as `etimedout`\n  caused the receiving state machine server to crash. This bug has now been\n  fixed.\n\n  Own Id: OTP-18749 Aux Id: GH-7608\n\n- Fix bug where reading using `file` from a unicode enabled `standard_io`,\n  `standard_error` or any other `group` backed device would result in incorrect\n  values being returned or a crash.\n\n  Now instead a no_translation error is returned to the caller when unicode data\n  is read using `file`. See\n  [Using Unicode](`e:stdlib:unicode_usage.md#escripts-and-non-interactive-i-o`)\n  in the STDLIB User's Guide for more details on how to correctly read from\n  `standard_io`.\n\n  Own Id: OTP-18800 Aux Id: PR-7714 GH-7591\n\n- The native resolver interface module has gotten a rewrite of its ETS table\n  handling to minimize term copying, and also to move the handling of client\n  time-outs to the clients, which helps the native resolver name server from\n  digging itself into a tar pit when heavily loaded.\n\n  Own Id: OTP-18812 Aux Id: ERIERL-997\n\n- Replaced unintentional Erlang Public License 1.1 headers in some files with\n  the intended Apache License 2.0 header.\n\n  Own Id: OTP-18815 Aux Id: PR-7780\n\n- Fix bug in `pg` if a client process both monitored a group/scope and joined a\n  group. The termination of such process resulted in crash of the `pg` server\n  process.\n\n  Own Id: OTP-18833 Aux Id: GH-7625, PR-7659\n\n- Fix crash when using `file:consult` and the underlying file read returns an\n  error while reading.\n\n  Own Id: OTP-18873 Aux Id: PR-7831\n\n- Corrected gen_tcp_socket listen option handling.\n\n  Own Id: OTP-18883 Aux Id: #7764","ref":"notes.html#fixed-bugs-and-malfunctions-25"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Add Windows support for DGRAM socket connect.\n\n  Own Id: OTP-18762\n\n- Document the, previously opaque, types select_tag() and completion_tag().\n\n  Own Id: OTP-18818 Aux Id: #7337","ref":"notes.html#improvements-and-new-features-5"},{"type":"extras","title":"Kernel 9.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fixed an issue with truncated crash slogans on failed emulator start.\n\n  Own Id: OTP-18623 Aux Id: GH-7344\n\n- Fix shell:start_interactive function specification.\n\n  Own Id: OTP-18628 Aux Id: GH-7280\n\n- Fix code:get_doc/1 to return missing, when it can't find erts instead of\n  crashing.\n\n  Own Id: OTP-18654 Aux Id: PR-7404\n\n- Function socket:close/1 could cause a VM crash on Windows.\n\n  Own Id: OTP-18669 Aux Id: OTP-18029\n\n- Fix deadlock when `erl.exe` is used as part of a pipe on Windows and trying to\n  set the encoding of the `standard_io` device.\n\n  Own Id: OTP-18675 Aux Id: PR-7473 GH-7459\n\n- Expanded the documentation about how to use the `standard_io`,\n  `standard_error` and `user` I/O devices.\n\n  Added the types [`io:standard_io/0`](`t:io:standard_io/0`),\n  `io:standard:error/0` and [`io:user/0`](`t:io:user/0`).\n\n  Own Id: OTP-18676 Aux Id: PR-7473 GH-7459\n\n- Fix logger's overload protection mechanism to only fetch memory used by\n  messages when needed.\n\n  Own Id: OTP-18677 Aux Id: PR-7418 GH-7417\n\n- Fixed a number of socket-related issues causing incompatibilities with gen_tcp\n  and gen_udp respectively.\n\n  Own Id: OTP-18685\n\n- gen_tcp:connect with socket address and socket (inet-) backend fails because\n  of missing callback function.\n\n  Own Id: OTP-18707 Aux Id: #7530\n\n- The DNS RR cache used by \\`inet_res\\` has been fixed to preserve insert order,\n  which is beneficial when the DNS server returns RRs in some specific order for\n  e.g load balancing purposes.\n\n  Own Id: OTP-18731 Aux Id: GH-7577, PR-7578\n\n- The options \\`reuseport\\`, \\`reuseport_lb\\` and \\`exclusiveaddruse\\` were\n  accidentally not allowed for e.g \\`gen_udp:open/1,2\\`, which has now been\n  corrected.\n\n  Own Id: OTP-18734 Aux Id: OTP-18344, PR-6522, GH-6461, GH-7569\n\n- `gen_udp:recv/*` for Unix Domain Socket in binary mode and passive mode has\n  been fixed to not crash.\n\n  Own Id: OTP-18747 Aux Id: GH-7605\n\n- Fixed issue where cursor would not be placed at the end of the expression when\n  navigating shell history.\n\n  Own Id: OTP-18757 Aux Id: PR-7631","ref":"notes.html#fixed-bugs-and-malfunctions-26"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Update gen_tcp_socket and gen_udp_socket to handle 'completion' (socket on\n  Windows).\n\n  Own Id: OTP-18586 Aux Id: OTP-18029\n\n- Add support for Unix Domain Sockets (only for STREAM sockets) on Windows for\n  'socket'.\n\n  Own Id: OTP-18611 Aux Id: OTP-18029, #5024\n\n- Add basic support for socket ioctl on Windows.\n\n  Own Id: OTP-18660\n\n- The [`file:location/0`](`t:file:location/0`) type is now exported.\n\n  Own Id: OTP-18681\n\n- Add support for (Windows) socket option exclusiveaddruse.\n\n  Own Id: OTP-18686\n\n- \\[socket] Add support for the 'nopush' option.\n\n  Own Id: OTP-18687\n\n- Add support for socket option 'BSP STATE'.\n\n  Own Id: OTP-18693\n\n- Add tcp socket options 'keepcnt', 'keepidle' and 'keepintvl'.\n\n  Own Id: OTP-18698\n\n- Add support for misc (Windows) socket options ('max_msg_size' and 'maxdg').\n\n  Own Id: OTP-18710\n\n- The keyboard shortcuts for the shell are now configurable.\n\n  Own Id: OTP-18754 Aux Id: PR-7604 PR-7647\n\n- Optimized code_server to reduce repeated work when loading the same module\n  concurrently.\n\n  Own Id: OTP-18755 Aux Id: PR-7503","ref":"notes.html#improvements-and-new-features-6"},{"type":"extras","title":"Kernel 9.0.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix bug where when you entered Alt+Enter in the terminal, the cursor would\n  move to the last line, instead of moving to the next line.\n\n  Own Id: OTP-18580 Aux Id: PR-7242\n\n- Fix so that the shell does not crash on startup when termcap is not available.\n\n  Own Id: OTP-18624 Aux Id: GH-7296\n\n- Multiple socket:accept calls issue. When making multiple accept calls, only\n  the last call is active.\n\n  Own Id: OTP-18635 Aux Id: #7328\n\n- Fix the shell to ignore terminal delay when the terminal capabilities report\n  that they should be used.\n\n  Own Id: OTP-18636 Aux Id: PR-7352 GH-7308\n\n- Fix \"oldshell\" to echo characters while typing on Windows.\n\n  Own Id: OTP-18637 Aux Id: PR-7359 GH-7324\n\n- Fix eof handling when reading from stdin when erlang is started using\n  `-noshell`.\n\n  Own Id: OTP-18640 Aux Id: PR-7384 GH-7368 GH-7286 GH-6881\n\n- On Windows, a call to the function socket:close, when there are waiting active\n  calls to read, write or accept functions, could hang.\n\n  Own Id: OTP-18646\n\n- Fix issues when reading or configuring `standard_io` on Windows when erl.exe\n  is started using `-noshell` flag.\n\n  Own Id: OTP-18649 Aux Id: GH-7261 PR-7400\n\n- gen_udp:connect with inet_backend = socket fails when the Address is a\n  hostname (string or atom).\n\n  Own Id: OTP-18650\n\n- Fixed problem which would cause shell to crash if particular escape sequence\n  was written to stdout.\n\n  Own Id: OTP-18651 Aux Id: PR-7242\n\n- Fixed problem where output would disappear if it was received after a prompt\n  was written in the shell.\n\n  Own Id: OTP-18652 Aux Id: PR-7242\n\n- Fix a crash where the location of erts could not be found in rebar3 dev\n  builds.\n\n  Own Id: OTP-18656 Aux Id: PR-7404 GH-7390\n\n- Introduce the KERNEL application parameter `standard_io_encoding` that can be\n  used to set the default encoding for standard_io. This option needs to be set\n  to `latin1` if the application wants to treat all input data as bytes rather\n  than utf-8 encoded characters.\n\n  Own Id: OTP-18657 Aux Id: GH-7230 PR-7384","ref":"notes.html#fixed-bugs-and-malfunctions-27"},{"type":"extras","title":"Kernel 9.0.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The POSIX error `exdev` was sometimes incorrectly described as \"cross domain\n  link\" in some error messages.\n\n  Own Id: OTP-18578 Aux Id: GH-7213\n\n- Corrected the socket send function description (send with Timeout = nowait).\n  The send function(s) could not return \\{ok, \\{RestData, SelectInfo\\}\\}\n\n  Own Id: OTP-18584 Aux Id: #7238","ref":"notes.html#fixed-bugs-and-malfunctions-28"},{"type":"extras","title":"Kernel 9.0 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-9-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fixed a bug where duplicate keys were allowed in the .app file of an\n  application. Duplicate keys are now rejected and the application will not\n  start if they exist.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18210 Aux Id: GH-5877 PR-5878\n\n- Fix inconsistent handling in logger_formatter of the branched values in\n  conditional branches. For example using `msg` in a conditional branch would\n  not be formatted as it should before this fix.\n\n  Own Id: OTP-18225 Aux Id: PR-6036\n\n- Fix the logger_std_h handler to log to standard_error if logging to\n  standard_io fails for any reason.\n\n  Own Id: OTP-18226 Aux Id: PR-6253\n\n- Fix the TLS distribution to work when starting Erlang in embedded mode and a\n  connection is done before kernel is fully started.\n\n  Own Id: OTP-18248 Aux Id: PR-6227 GH-6085\n\n- erl `-remsh` has been improved to provide better error reasons and work when\n  using a shell without terminal support (that is an \"oldshell\").\n\n  Own Id: OTP-18271 Aux Id: PR-6279\n\n- Fix logging of log events generated before kernel is started to not fail if\n  the code for formatting those log messaged have not yet been loaded.\n\n  Own Id: OTP-18286 Aux Id: PR-5955\n\n- `proc_lib:start*/*` has become synchronous when the started process fails.\n  This requires that a failing process use a new function\n  `proc_lib:init_fail/2,3`, or exits, to indicate failure. All OTP behaviours\n  have been fixed to do this.\n\n  All these start functions now consume the `'EXIT'` message from a process link\n  for all error returns. Previously it was only the `start_link/*` functions\n  that did this, and only when the started function exited, not when it used\n  `init_ack/1,2` or `init_fail/2,3` to create the return value.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18471 Aux Id: GH-6339, PR-6843\n\n- Fixed a bug where `file:read(standard_io, ...)` unexpectedly returned `eof` in\n  binary mode.\n\n  Own Id: OTP-18486 Aux Id: PR-6881\n\n- Return type for `seq_trace:get_token/1` fixed.\n\n  Own Id: OTP-18528 Aux Id: PR-7009\n\n- Looking up, connecting to and sending to a host with an empty name is now\n  handled by trying to look up the address of the root domain, which fails.\n  Previously some of these operations caused an internal exception, which\n  contradicted type specifications.\n\n  Own Id: OTP-18543 Aux Id: GH-6353\n\n- Replaced a regex with a special case handling of ANSI Select Graphic Rendition\n  escape characters, to speed up io output that make use of these escape\n  sequences.\n\n  Own Id: OTP-18547 Aux Id: PR-7092","ref":"notes.html#fixed-bugs-and-malfunctions-29"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- The Erlang shell has been improved to support the following features:\n\n  - Auto-complete variables, record names, record field names, map keys,\n    function parameter types and filenames.\n  - Open external editor in the shell (with C-o) to edit the current expression\n    in an editor.\n  - Support defining records (with types), functions and function typespecs, and\n    custom types in the shell.\n  - Do not save pager commands, and input to io:getline in history.\n\n  Own Id: OTP-14835 Aux Id: PR-5924\n\n- The TTY/terminal subsystem has been rewritten by moving more code to Erlang\n  from the old linked-in driver and implementing all the I/O primitives needed\n  in a NIF instead.\n\n  On Unix platforms the user should not notice a lot of difference, besides\n  better handling of unicode characters and fixing of some long standing bugs.\n\n  Windows users will notice that erl.exe has the same functionality as a normal\n  Unix shell and that werl.exe has been removed and replaced with a symlink to\n  erl.exe. This makes the Windows Erlang terminal experience identical to that\n  of Unix.\n\n  The re-write brings with it a number of bug fixes and feature additions:\n\n  - The TTY is now reset when Erlang exits, fixing zsh to not break when\n    terminating an Erlang session.\n  - `standard_error` now uses the same unicode mode as `standard_io`.\n  - Hitting backspace when searching the shell history with an empty search\n    string no longer breaks the shell.\n  - Tab expansion now works on remote nodes started using the JCL interface.\n  - It is now possible to configure the shell slogan and the session slogans\n    (that is the texts that appear when you start an Erlang shell). See the\n    kernel documentation for more details.\n  - Added shell:start_interactive for starting the interactive shell from a\n    non-interactive Erlang session (for example an escript).\n  - On Windows, when starting in detached mode the standard handler are now set\n    to `nul` devices instead of being unset.\n  - Standard I/O now always defaults to `unicode` mode if supported. Previously\n    the default was `latin1` if the runtime system had been started with\n    `-oldshell` or `-noshell` (for example in an `escript`). To send raw bytes\n    over standard out, one now explicitly has to specify\n    `io:setopts(standard_io, [{encoding, latin1}]).`\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17932 Aux Id: PR-6144 GH-3150 GH-3390 GH-4343 GH-4225\n\n- Add support for socket on Windows.\n\n  - Pre release status.\n  - Error codes not finalized.\n  - No explicit support for Windows specific options (socket options, flags for\n    read and write).\n  - New async api for Windows (completion). See the `Asynchronous calls` chapter\n    in the (Socket Usage) Users Guide.\n  - To ensure platform independence, gen_tcp and gen_udp is _intended_ to be\n    used (not yet updated).\n\n  Own Id: OTP-18029\n\n- As announced since the release of OTP 24, support for:\n\n  - version 4 node container types in the external term format are now\n    mandatory. That is, references supporting up to 5 32-bit integer\n    identifiers, and process and port identifiers with support for 64-bit data\n    storage. The distribution flag\n    [`DFLAG_V4_NC`](`e:erts:erl_dist_protocol.md#DFLAG_V4_NC`) is therefor now\n    also mandatory. OTP has since OTP 24 supported this. Also note that the\n    external format produced by `term_to_binary()` and `term_to_iovec()` will\n    unconditionally produce pids, ports, and references supporting this larger\n    format.\n  - the [new link protocol](`e:erts:erl_dist_protocol.md#new_link_protocol`)\n    introduced in OTP 23.3 is now mandatory. The distribution flag\n    [`DFLAG_UNLINK_ID`](`e:erts:erl_dist_protocol.md#DFLAG_UNLINK_ID`) is\n    therefor now also mandatory.\n\n  Due to the above, OTP 26 nodes will refuse to connect to OTP nodes from\n  releases prior to OTP 24.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18140 Aux Id: PR-6072\n\n- Support for Kernel TLS (kTLS), has been added to the SSL application, for TLS\n  distribution (`-proto_dist inet_tls`), the SSL option `{ktls, true}`. Using\n  this for general SSL sockets is uncomfortable, undocumented and not\n  recommended since it requires very platform dependent raw options.\n\n  This, for now, only works for some not too old Linux distributions. Roughly, a\n  kernel 5.2.0 or later with support for UserLand Protocols and the kernel\n  module `tls` is required.\n\n  Own Id: OTP-18235 Aux Id: PR-6104, PR-5840\n\n- Add code:get_doc/2 which adds support to fetch documentation skeletons of\n  functions using debug_info chunks instead of eep48 doc chunks.\n\n  Own Id: OTP-18261 Aux Id: PR-5924\n\n- The Erlang shell's auto-completion when typing `tab` has been changed to\n  happen after the editing current line instead of before it.\n\n  This behaviour can be configured using a the `shell_expand_location` STDLIB\n  configuration parameter.\n\n  Own Id: OTP-18278 Aux Id: PR-6260\n\n- Typing `Ctrl+L` in a shell now clears the screen and redraws the current line\n  instead of only redrawing the current line. To only redraw the current line,\n  you must now type `Alt+L`. This brings the behaviour of `Ctrl+L` closer to how\n  bash and other shells work.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18285 Aux Id: PR-6262\n\n- gen_server optimized by caching callback functions\n\n  Own Id: OTP-18305 Aux Id: PR-5831\n\n- Prepare the `pg` communication protocol for upgrade. The plan is for OTP-28\n  nodes to be able to use an upgraded `pg` protocol while still being able to\n  talk with OTP 26 nodes.\n\n  Own Id: OTP-18327 Aux Id: PR-6433\n\n- New `disk_log` log type `rotate`, where the log files are compressed upon\n  rotation.\n\n  Own Id: OTP-18331 Aux Id: ERIERL-870\n\n- The following `inet:setopts/2` options have been introduced:\n\n  - **[`reuseport`](`m:inet#option-reuseport`)** - Reuse of local port. Load\n    balancing may or may not be provided depending on underlying OS.\n\n  - **[`reuseport_lb`](`m:inet#option-reuseport_lb`)** - Reuse of local port.\n    Load balancing provided.\n\n  - **[`exclusiveaddruse`](`m:inet#option-exclusiveaddruse`)** - Exclusive\n    address/port usage on Windows. This socket option is Windows specific and\n    will silently be ignored on other systems.\n\n  The behavior of setting [`reuseaddr`](`m:inet#option-reuseaddr`) on Windows\n  have changed in a _backwards incompatible_ way. The underlying `SO_REUSEADDR`\n  socket option is now only set if both the `reusaddr` and the `reuseport`\n  `inet` options have been set. This since the underlying `SO_REUSEADDR` socket\n  option on Windows behaves similar to how BSD behaves if both the underlying\n  socket options `SO_REUSEADDR` and `SO_REUSEPORT` have been set. See the\n  documentation of the `reuseaddr` option for more information.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18344 Aux Id: PR-6522, PR-6944, OTP-18324, PR-6481, GH-6461\n\n- Replace size/1 with either tuple_size/1 or byte_size/1\n\n  The [`size/1`](`size/1`) BIF is not optimized by the JIT, and its use can\n  result in worse types for Dialyzer.\n\n  When one knows that the value being tested must be a tuple,\n  [`tuple_size/1`](`tuple_size/1`) should always be preferred.\n\n  When one knows that the value being tested must be a binary,\n  [`byte_size/1`](`byte_size/1`) should be preferred. However,\n  [`byte_size/1`](`byte_size/1`) also accepts a bitstring (rounding up size to a\n  whole number of bytes), so one must make sure that the call to `byte_size/` is\n  preceded by a call to [`is_binary/1`](`is_binary/1`) to ensure that bitstrings\n  are rejected. Note that the compiler removes redundant calls to\n  [`is_binary/1`](`is_binary/1`), so if one is not sure whether previous code\n  had made sure that the argument is a binary, it does not harm to add an\n  [`is_binary/1`](`is_binary/1`) test immediately before the call to\n  [`byte_size/1`](`byte_size/1`).\n\n  Own Id: OTP-18405 Aux Id:\n  GH-6672,PR-6702,PR-6768,PR-6700,PR-6769,PR-6812,PR-6814\n\n- The function `file:pid2name/1` is deprecated and will be removed in\n  Erlang/OTP 27.\n\n  Own Id: OTP-18419\n\n- The modules Erlang DNS resolver `inet_res` and helper modules have been\n  updated for RFC6891; to handle OPT RR with DNSSEC OK (DO) bit.\n\n  Own Id: OTP-18442 Aux Id: PR-6786, GH-6606\n\n- Introduced `application:get_supervisor/1`.\n\n  Own Id: OTP-18444 Aux Id: PR-6035\n\n- Handling of `on_load` modules during boot has been improved by adding an extra\n  step in the boot order for embedded mode that runs all `on_load` handlers,\n  instead of relying on explicit invocation of them, later, when the kernel\n  supervision tree starts.\n\n  This is mostly a code improvement and OTP internal simplification to avoid\n  future bugs and to simplify code maintenance.\n\n  Own Id: OTP-18447\n\n- Reduce contention on the code_server by doing the code preparation on the\n  client.\n\n  Own Id: OTP-18448 Aux Id: PR-6736\n\n- Added a mode to ensure_all_loaded, to start children application and their\n  dependencies concurrently.\n\n  Own Id: OTP-18451 Aux Id: PR-6737\n\n- Cache OTP boot code paths, to limit how many folders that are being accessed\n  during a module lookup. Can be disabled with -cache_boot_path false. OTP boot\n  code paths consists of ERL_LIB environment variables. The various otp/\\*/ebin\n  folders. And the \\{path, ...\\} clauses in the init script.\n\n  Own Id: OTP-18452 Aux Id: PR-6729\n\n- Erlang distribution code in Kernel and SSL has been refactored a bit to\n  facilitate debugging and re-usability, which shouldn't have any noticeable\n  effects on behaviour or performance.\n\n  Own Id: OTP-18456\n\n- Add cache attribute to code path apis.\n\n  Added an optional cache/nocache argument to all code:add_path*,\n  code:set_path*, and code:replace_path\\* functions. These functions will then\n  avoid doing file-accesses if they are cached. Cache can be cleared with\n  code:clear_cache/0. Added code:del_paths/1 to make it easier to clear multiple\n  paths.\n\n  Own Id: OTP-18466 Aux Id: PR-6832\n\n- Deprecates `dbg:stop_clear/0` because it is simply a function alias to\n  `dbg:stop/0`\n\n  Own Id: OTP-18478 Aux Id: GH-6903\n\n- Improvements to code:ensure_modules_loaded/1: Previously it would prepare\n  modules and then abandon references to said modules if they had on_load\n  callbacks. This pull request makes it so they keep the references around and\n  then serially load them without having to fetch the object code and prepare\n  them again.\n\n  Own Id: OTP-18484 Aux Id: PR-6844\n\n- The internal DNS resolver has been updated to handle DNS LOC RR:s (RFC 1876).\n  This is an undocumented module, although still used by power users. See the\n  source code.\n\n  Own Id: OTP-18510 Aux Id: GH-6098, PR-6982\n\n- Reduced memory consumption in `global` when informing other nodes about lost\n  connections.\n\n  Own Id: OTP-18521 Aux Id: PR-7025\n\n- The `net_kernel`, `global`, and `global_group` servers now have\n  [_fully asynchronous distributed signaling_](`m:erlang#process_flag_async_dist`)\n  enabled all the time which prevents them from ever getting blocked on send of\n  distributed signals.\n\n  Documentation about blocking distributed signals has also been improved.\n\n  Own Id: OTP-18533 Aux Id: PR-7061\n\n- Allow IPv6 addresses as host in `http` packets decoded by\n  `erlang:decode_packet/3` and `gen_tcp` packet option. The IPv6 address should\n  be enclosed within `[]` according to RFC2732.\n\n  Own Id: OTP-18540 Aux Id: PR-6900\n\n- Remove deprecated functions in OTP-26\n\n  Own Id: OTP-18542\n\n- Removed `code:is_module_native/1` since HiPE has been removed. It has since\n  OTP 24 been deprecated and scheduled for removal in OTP 26.\n\n  Removed `code:rehash/0` since the code path feature no longer is present. It\n  has since OTP 19 been deprecated and has since OTP 24 been scheduled for\n  removal in OTP 26.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18551 Aux Id: PR-7106\n\n- Added support for multiple line expressions and navigation in the shell. Added\n  new keybindings:\n\n  - navigate up (ctrl+up)/(alt+up)\n  - navigate down (ctrl+down)/(alt+down)\n  - insert newline in middle of line (alt+enter)\n  - navigate top (alt+<)/(alt+shift+up)\n  - navigate bottom (alt+>)/(alt+shift+down)\n  - clear current expression (alt+c)\n  - cancel search (alt+c)\n  - opening editor on mac (option+o)/(alt+o)\n\n  Modifies the prompt for new lines to make it clearer that the prompt has\n  entered multi-line mode. Supports terminal with small window size, recommend\n  not go lower than 7 rows and 40 columns. Modifies the search prompt to support\n  multi-line statements. Redraw the prompt after continuing from JCL menu.\n\n  Own Id: OTP-18575 Aux Id: PR-7169","ref":"notes.html#improvements-and-new-features-7"},{"type":"extras","title":"Kernel 8.5.4.6 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-5-4-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* With this change, disk_log will not crash when using chunk_step/3 after log size was decreased.\n\n  Own Id: OTP-19605 Aux Id: GH-9720, PR-9765\n* With this change, disk_log will not run into infinite loop when using chunk/2,3 after log size was decreased.\n\n  Own Id: OTP-19608 Aux Id: GH-9707, PR-9767","ref":"notes.html#fixed-bugs-and-malfunctions-30"},{"type":"extras","title":"Kernel 8.5.4.5 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-5-4-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* An infinite loop in CNAME loop detection that can cause Out Of Memory has been fixed. This affected CNAME lookup with the internal DNS resolver.\n\n  Own Id: OTP-19545 Aux Id: PR-9587, OTP-19544","ref":"notes.html#fixed-bugs-and-malfunctions-31"},{"type":"extras","title":"Kernel 8.5.4.4 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-5-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* Fixed a couple of bugs that could make `global`'s internal state inconsistent when a connection was reconnected.\n\n  Own Id: OTP-19381 Aux Id: PR-9377, GH-9112, GH-9117","ref":"notes.html#fixed-bugs-and-malfunctions-32"},{"type":"extras","title":"Kernel 8.5.4.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-5-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"* Fixed gen_udp:open/2 type spec to include already supported module socket address types.\n\n  Own Id: OTP-19050 Aux Id: OTP-18990","ref":"notes.html#fixed-bugs-and-malfunctions-33"},{"type":"extras","title":"Kernel 8.5.4.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-5-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- gen_tcp:connect with socket address and socket (inet-) backend fails because\n  of missing callback function.\n\n  Own Id: OTP-18707 Aux Id: #7530","ref":"notes.html#fixed-bugs-and-malfunctions-34"},{"type":"extras","title":"Kernel 8.5.4.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-5-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Multiple socket:accept calls issue. When making multiple accept calls, only\n  the last call is active.\n\n  Own Id: OTP-18635 Aux Id: #7328\n\n- gen_udp:connect with inet_backend = socket fails when the Address is a\n  hostname (string or atom).\n\n  Own Id: OTP-18650","ref":"notes.html#fixed-bugs-and-malfunctions-35"},{"type":"extras","title":"Kernel 8.5.4 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-5-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fixed a bug on Windows where `file:read_file_info/1` would fail for files with\n  corrupt metadata.\n\n  Own Id: OTP-18348 Aux Id: GH-6356\n\n- Accept connection setup from OTP 23 and 24 nodes that are not using epmd.\n\n  Own Id: OTP-18404 Aux Id: GH-6595, PR-6625","ref":"notes.html#fixed-bugs-and-malfunctions-36"},{"type":"extras","title":"Kernel 8.5.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The tcp connect option 'bind_to_device' could not be used with inet_backend =\n  'socket'. 'inet' requires value type binarry() and 'socket' requires value\n  type 'string()'.\n\n  Own Id: OTP-18357 Aux Id: #6509\n\n- Minor issue processing options when calling gen_tcp:connect with a sockaddr()\n  and inet_backend = socket.\n\n  Own Id: OTP-18358 Aux Id: #6528","ref":"notes.html#fixed-bugs-and-malfunctions-37"},{"type":"extras","title":"Kernel 8.5.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fixed shutdown crash in gen_tcp socket backend, when the other end closed the\n  socket.\n\n  Own Id: OTP-18270 Aux Id: #6331\n\n- `erl_tar` can now read gzip-compressed tar files that are padded. There is a\n  new option `compressed_one` for `file:open/2` that will read a single member\n  from a gzip file,\n\n  Own Id: OTP-18289 Aux Id: PR-6343\n\n- Fix `os:cmd` to not translate all exceptions thrown to `badarg`. For example\n  `emfile` from `erlang:open_port` was translated to `badarg`.\n\n  This bug has existed since Erlang/OTP 24.\n\n  Own Id: OTP-18291 Aux Id: PR-6382\n\n- Spec for function net:if_names/0 incorrect\n\n  Own Id: OTP-18296 Aux Id: OTP-16464\n\n- Missing ctrl option name transation for TOS and TTL (on FreeBSD) when using\n  gen_udp with the 'socket' inet_backend.\n\n  Own Id: OTP-18315\n\n- gen_udp:open/2 with option(s) add_membership or drop_membership would drop\n  earlier options.\n\n  Own Id: OTP-18323 Aux Id: #6476\n\n- The `inet:setopts/2` `{reuseaddr, true}` option will now be ignored on Windows\n  unless the socket is an UDP socket. For more information see the documentation\n  of the `reuseaddr` option part of the documentation of `inet:setopts/2`.\n\n  Prior to OTP 25 the `{reuseaddr, true}` option was ignored for all sockets on\n  Windows, but as of OTP 25.0 this was changed so that it was not ignored for\n  any sockets.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18324 Aux Id: GH-6461, PR-6481","ref":"notes.html#fixed-bugs-and-malfunctions-38"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- The distribution socket option handling in `inet_tcp_dist` has been cleaned up\n  to clarify which were mandatory and which just had default values.\n\n  Own Id: OTP-18293\n\n- Improve warning message format for gen_tcp_socket.\n\n  Own Id: OTP-18317","ref":"notes.html#improvements-and-new-features-8"},{"type":"extras","title":"Kernel 8.5.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Listen sockets created with the socket module, leaked (erlang-) monitors.\n\n  Own Id: OTP-18240 Aux Id: #6285\n\n- `m:peer` nodes failed to halt when the process supervising the control\n  connection crashed. When an alternative control connection was used, this\n  supervision process also quite frequently crashed when the `peer` node was\n  stopped by the node that started it which caused the `peer` node to linger\n  without ever halting.\n\n  Own Id: OTP-18249 Aux Id: PR-6301","ref":"notes.html#fixed-bugs-and-malfunctions-39"},{"type":"extras","title":"Kernel 8.5 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fixed inconsistency bugs in `m:global` due to `nodeup`/`nodedown` messages not\n  being delivered before/after traffic over connections. Also fixed various\n  other inconsistency bugs and deadlocks in both `m:global_group` and `global`.\n\n  As building blocks for these fixes, a new BIF `erlang:nodes/2` has been\n  introduced and `net_kernel:monitor_nodes/2` has been extended.\n\n  The [`-hidden`](`e:erts:erl_cmd.md#hidden`) and\n  [`-connect_all`](`e:erts:erl_cmd.md#connect_all`) command line arguments did\n  not work if multiple instances were present on the command line which has been\n  fixed. The new kernel parameter [`connect_all`](kernel_app.md#connect_all) has\n  also been introduced in order to replace the `-connect_all` command line\n  argument.\n\n  Own Id: OTP-17934 Aux Id: PR-6007\n\n- Fixed IPv6 multicast_if and membership socket options.\n\n  Own Id: OTP-18091 Aux Id: #5789\n\n- Fixed issue with inet:getifaddrs hanging on pure IPv6 Windows\n\n  Own Id: OTP-18102 Aux Id: #5904\n\n- The type specifications for `inet:getopts/2` and `inet:setopts/2` have been\n  corrected regarding SCTP options.\n\n  Own Id: OTP-18115 Aux Id: PR-5939\n\n- The type specifications for `inet:parse_*` have been tightened.\n\n  Own Id: OTP-18121 Aux Id: PR-5972\n\n- Fix gen_tcp:connect/3 spec to include the inet_backend option.\n\n  Own Id: OTP-18171 Aux Id: PR-6131\n\n- Fix bug where using a binary as the format when calling\n  `logger:log(Level, Format, Args)` (or any other logging function) would cause\n  a crash or incorrect logging.\n\n  Own Id: OTP-18229 Aux Id: PR-6212","ref":"notes.html#fixed-bugs-and-malfunctions-40"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Add rudimentary debug feature (option) for the inet-driver based sockets, such\n  as gen_tcp and gen_udp.\n\n  Own Id: OTP-18032\n\n- Introduced the `hidden` and `dist_listen` options to `net_kernel:start/2`.\n\n  Also documented the [`-dist_listen`](`e:erts:erl_cmd.md#dist_listen`) command\n  line argument which was erroneously documented as a `kernel` parameter and not\n  as a command line argument.\n\n  Own Id: OTP-18107 Aux Id: PR-6009\n\n- Scope and group monitoring have been introduced in `m:pg`. For more\n  information see the documentation of\n  [`pg:monitor_scope()`](`pg:monitor_scope/0`),\n  [`pg:monitor()`](`pg:monitor/1`), and [`pg:demonitor()`](`pg:demonitor/1`).\n\n  Own Id: OTP-18163 Aux Id: PR-6058, PR-6275\n\n- A new function `global:disconnect/0` has been introduced with which one can\n  cleanly disconnect a node from all other nodes in a cluster of `global` nodes.\n\n  Own Id: OTP-18232 Aux Id: OTP-17843, PR-6264","ref":"notes.html#improvements-and-new-features-9"},{"type":"extras","title":"Kernel 8.4.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- A call to [`net_kernel:setopts(new, Opts)`](`net_kernel:setopts/2`) at the\n  same time as a connection was being set up could cause a deadlock between the\n  `net_kernel` process and the process setting up the connection.\n\n  Own Id: OTP-18198 Aux Id: GH-6129, PR-6216","ref":"notes.html#fixed-bugs-and-malfunctions-41"},{"type":"extras","title":"Kernel 8.4.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The DNS resolver `inet_res` has been fixed to ignore trailing dot difference\n  in the request domain between the sent request and the received response, when\n  validating a response.\n\n  Own Id: OTP-18112 Aux Id: ERIERL-811\n\n- A bug in `inet_res` has been fixed where a missing internal `{ok,_}` wrapper\n  caused `inet_res:resolve/*` to return a calculated host name instead of an\n  `{ok,Msg}` tuple, when resolving an IP address or a host name that is an IP\n  address string.\n\n  Own Id: OTP-18122 Aux Id: GH-6015, PR-6020\n\n- The `erlang:is_alive()` BIF could return `true` before configured distribution\n  service was available. This bug was introduced in OTP 25.0 ERTS version 13.0.\n\n  The `erlang:monitor_node()` and `erlang:monitor()` BIFs could erroneously fail\n  even though configured distribution service was available. This occurred if\n  these BIFs were called after the distribution had been started using dynamic\n  node name assignment but before the name had been assigned.\n\n  Own Id: OTP-18124 Aux Id: OTP-17558, PR-6032\n\n- Added the missing mandatory `address/0` callback in the `gen_tcp_dist`\n  example.\n\n  Own Id: OTP-18136","ref":"notes.html#fixed-bugs-and-malfunctions-42"},{"type":"extras","title":"Kernel 8.4 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The DNS resolver implementation has been rewritten to validate replies more\n  thoroughly, and a bit optimized to create less garbage.\n\n  Own Id: OTP-17323\n\n- The socket option 'reuseaddr' is _no longer_ ignored on Windows.\n\n  Own Id: OTP-17447 Aux Id: GH-4819\n\n- Fix bug where using the atoms `string` or `report` as the format when calling\n  `logger:log(Level, Format, Args)` (or any other logging function) would cause\n  a crash or incorrect logging.\n\n  Own Id: OTP-17551 Aux Id: GH-5071 PR-5075\n\n- As of OTP 25, `global` will by default prevent overlapping partitions due to\n  network issues by actively disconnecting from nodes that reports that they\n  have lost connections to other nodes. This will cause fully connected\n  partitions to form instead of leaving the network in a state with overlapping\n  partitions.\n\n  Prevention of overlapping partitions can be disabled using the\n  [`prevent_overlapping_partitions`](kernel_app.md#prevent_overlapping_partitions)\n  `kernel(6)` parameter, making `global` behave like it used to do. This is,\n  however, problematic for all applications expecting a fully connected network\n  to be provided, such as for example `mnesia`, but also for `global` itself. A\n  network of overlapping partitions might cause the internal state of `global`\n  to become inconsistent. Such an inconsistency can remain even after such\n  partitions have been brought together to form a fully connected network again.\n  The effect on other applications that expects that a fully connected network\n  is maintained may vary, but they might misbehave in very subtle hard to detect\n  ways during such a partitioning. Since you might get hard to detect issues\n  without this fix, you are _strongly_ advised _not_ to disable this fix. Also\n  note that this fix _has_ to be enabled on _all_ nodes in the network in order\n  to work properly.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17911 Aux Id: PR-5687, PR-5611, OTP-17843\n\n- Starting the helper program for name resolving; `inet_gethost`, has been\n  improved to use an absolute file system path to ensure that the right program\n  is started.\n\n  If the helper program can not be started - the system now halts, to avoid\n  running with a silently broken name resolver.\n\n  Own Id: OTP-17958 Aux Id: OTP-17978\n\n- The type specification for `inet_res:getbyname/2,3` has been corrected to\n  reflect that it can return peculiar `#hostent{}` records.\n\n  Own Id: OTP-17986 Aux Id: PR-5412, PR-5803\n\n- `code:module_status/1` would always report BEAM files loaded from an archive\n  as `modified`, and `code:modified_modules/0` would always return the name of\n  all modules loaded from archives.\n\n  Own Id: OTP-17990 Aux Id: GH-5801\n\n- In logger fix file handler shutdown delay by using erlang timers instead of\n  the timer module's timers.\n\n  Own Id: OTP-18001 Aux Id: GH-5780 PR-5829\n\n- Fix the meta data in log events generated by logger on failure to not contain\n  the original log event's meta data.\n\n  Own Id: OTP-18003 Aux Id: PR-5771\n\n- Fix logger file backend to re-create the log folder if it has been deleted.\n\n  Own Id: OTP-18015 Aux Id: GH-5828 PR-5845\n\n- \\[socket] Encode of sockaddr has been improved.\n\n  Own Id: OTP-18020\n\n- Fix `put_chars` requests to the io server with incomplete unicode data to exit\n  with `no_translation` error.\n\n  Own Id: OTP-18070 Aux Id: PR-5885","ref":"notes.html#fixed-bugs-and-malfunctions-43"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- The net module now works on Windows.\n\n  Own Id: OTP-16464\n\n- An Erlang installation directory is now relocatable on the file system given\n  that the paths in the installation's `RELEASES` file are paths that are\n  relative to the installations root directory. The\n  `` `release_handler:create_RELEASES/4 `` function can generate a `RELEASES`\n  file with relative paths if its `RootDir` parameter is set to the empty\n  string.\n\n  Own Id: OTP-17304\n\n- The following distribution flags are now mandatory: `DFLAG_BIT_BINARIES`,\n  `DFLAG_EXPORT_PTR_TAG`, `DFLAG_MAP_TAGS`, `DFLAG_NEW_FLOATS`, and\n  `DFLAG_FUN_TAGS`. This mainly concerns libraries or application that implement\n  the distribution protocol themselves.\n\n  Own Id: OTP-17318 Aux Id: PR-4972\n\n- Fix `os:cmd` to work on Android OS.\n\n  Own Id: OTP-17479 Aux Id: PR-4917\n\n- The configuration files [`.erlang`](`e:erts:erl_cmd.md`),\n  [`.erlang.cookie`](`e:system:distributed.md`) and\n  [`.erlang.crypt`](`m:beam_lib#module-erlang-crypt`) can now be located in the XDG\n  Config Home directory.\n\n  See the documentation for each file and `filename:basedir/2` for more details.\n\n  Own Id: OTP-17554 Aux Id: GH-5016 PR-5408 OTP-17821\n\n- Dynamic node name improvements: `erlang:is_alive/0` changed to return true for\n  pending dynamic node name and new function `net_kernel:get_state/0`.\n\n  Own Id: OTP-17558 Aux Id: OTP-17538, PR-5111, GH-5402\n\n- The types for callback result types in `gen_statem` has bee augmented with\n  arity 2 types where it is possible for a callback module to specify the type\n  of the callback data, so the callback module can get type validation of it.\n\n  Own Id: OTP-17589 Aux Id: PR-4926\n\n- The tagged tuple tests and fun-calls have been optimized and are now a little\n  bit cheaper than previously.\n\n  These optimizations become possible after making sure that all boxed terms\n  have at least one word allocated after the arity word. This has been\n  accomplished by letting all empty tuples refer to the same empty tuple literal\n  which also reduces memory usage for empty tuples.\n\n  Own Id: OTP-17608\n\n- A [`net_ticker_spawn_options`](kernel_app.md#net_ticker_spawn_options)\n  `kernel` configuration parameter with which one can set spawn options for the\n  distribution channel ticker processes has been introduced.\n\n  Own Id: OTP-17617 Aux Id: PR-5069\n\n- The most, or at least the most used, `m:rpc` operations now require `m:erpc`\n  support in order to communicate with other Erlang nodes. `erpc` was introduced\n  in OTP 23. That is, `rpc` operations against Erlang nodes of releases prior to\n  OTP 23 will fail.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17681 Aux Id: PR-5307\n\n- The new module `peer` supersedes the `slave` module. The `slave` module is now\n  deprecated and will be removed in OTP 27.\n\n  `peer` contains an extended and more robust API for starting erlang nodes.\n\n  Own Id: OTP-17720 Aux Id: PR-5162\n\n- In order to make it easier for the user to manage multiple outstanding\n  asynchronous `call` requests, new functionality utilizing request identifier\n  collections have been introduced in\n  [`erpc`](`t:erpc:request_id_collection/0`),\n  [`gen_server`](`t:gen_server:request_id_collection/0`),\n  [`gen_statem`](`t:gen_statem:request_id_collection/0`), and\n  [`gen_event`](`t:gen_event:request_id_collection/0`).\n\n  Own Id: OTP-17784 Aux Id: PR-5792\n\n- Type specifications have been added to the `gen_server`, and the documentation\n  has been updated to utilize this.\n\n  This surfaced a few type violations that has been corrected in `global`,\n  `logger_olp` and `rpc`.\n\n  Own Id: OTP-17915 Aux Id: PR-5751, GH-2375, GH-2690\n\n- IP address validation functions `is_ipv4_address/1`, `is_ipv6_address/1` and\n  `is_ip_address/1` have been added to the module `inet` in Kernel.\n\n  Own Id: OTP-17923 Aux Id: PR-5646\n\n- An API for multihomed SCTP connect has been added in the guise of\n  `gen_sctp:connectx_init/*`\n\n  Own Id: OTP-17951 Aux Id: PR-5656\n\n- \\[socket] Add encoding of the field hatype of the type sockaddr_ll (family\n  'packet').\n\n  Own Id: OTP-17968 Aux Id: OTP-16464\n\n- Added support for configurable features as described in EEP-60. Features can\n  be enabled/disabled during compilation with options\n  (`-enable-feature Feature`, `-disable-feature Feature` and\n  `+{feature, Feature, enable|disable}`) to `erlc` as well as with directives\n  (`-feature(Feature, enable|disable).`) in the file. Similar options can be\n  used to `erl` for enabling/disabling features allowed at runtime. The new\n  `maybe` expression (EEP-49) is fully supported as the feature `maybe_expr`.\n  The features support is documented in the reference manual.\n\n  Own Id: OTP-17988","ref":"notes.html#improvements-and-new-features-10"},{"type":"extras","title":"Kernel 8.3.2.4 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-3-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- gen_tcp:connect with socket address and socket (inet-) backend fails because\n  of missing callback function.\n\n  Own Id: OTP-18707 Aux Id: #7530","ref":"notes.html#fixed-bugs-and-malfunctions-44"},{"type":"extras","title":"Kernel 8.3.2.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-3-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Spec for function net:if_names/0 incorrect\n\n  Own Id: OTP-18296 Aux Id: OTP-16464\n\n- Missing ctrl option name transation for TOS and TTL (on FreeBSD) when using\n  gen_udp with the 'socket' inet_backend.\n\n  Own Id: OTP-18315\n\n- The tcp connect option 'bind_to_device' could not be used with inet_backend =\n  'socket'. 'inet' requires value type binarry() and 'socket' requires value\n  type 'string()'.\n\n  Own Id: OTP-18357 Aux Id: #6509\n\n- Minor issue processing options when calling gen_tcp:connect with a sockaddr()\n  and inet_backend = socket.\n\n  Own Id: OTP-18358 Aux Id: #6528","ref":"notes.html#fixed-bugs-and-malfunctions-45"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Improve warning message format for gen_tcp_socket.\n\n  Own Id: OTP-18317","ref":"notes.html#improvements-and-new-features-11"},{"type":"extras","title":"Kernel 8.3.2.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-3-2-2"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- A new function `global:disconnect/0` has been introduced with which one can\n  cleanly disconnect a node from all other nodes in a cluster of `global` nodes.\n\n  Own Id: OTP-18232 Aux Id: OTP-17843, PR-6264","ref":"notes.html#improvements-and-new-features-12"},{"type":"extras","title":"Kernel 8.3.2.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-3-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- A call to [`net_kernel:setopts(new, Opts)`](`net_kernel:setopts/2`) at the\n  same time as a connection was being set up could cause a deadlock between the\n  `net_kernel` process and the process setting up the connection.\n\n  Own Id: OTP-18198 Aux Id: GH-6129, PR-6216","ref":"notes.html#fixed-bugs-and-malfunctions-46"},{"type":"extras","title":"Kernel 8.3.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- inet:getopts/2 for the 'raw' option for a socket created with inet-backend\n  'socket' failed.\n\n  Own Id: OTP-18078 Aux Id: GH-5930\n\n- Corrected the behaviour of the shutdown function when using with the\n  inet_backend = socket. It was not sufficiently compatible with the \"old\"\n  gen_tcp.\n\n  Own Id: OTP-18080 Aux Id: GH-5930","ref":"notes.html#fixed-bugs-and-malfunctions-47"},{"type":"extras","title":"Kernel 8.3.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix failed accepted connection setup after previous established connection\n  from same node closed down silently.\n\n  Own Id: OTP-17979 Aux Id: ERIERL-780\n\n- Fixed a problem where typing Ctrl-R in the shell could hang if there were some\n  problem with the history log file.\n\n  Own Id: OTP-17981 Aux Id: PR-5791","ref":"notes.html#fixed-bugs-and-malfunctions-48"},{"type":"extras","title":"Kernel 8.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Handling of `send_timeout` for `gen_tcp` has been corrected so that the\n  timeout is honored also when sending 0 bytes.\n\n  Own Id: OTP-17840\n\n- By default `global` does _not_ take any actions to restore a fully connected\n  network when connections are lost due to network issues. This is problematic\n  for all applications expecting a fully connected network to be provided, such\n  as for example `mnesia`, but also for `global` itself. A network of\n  overlapping partitions might cause the internal state of `global` to become\n  inconsistent. Such an inconsistency can remain even after such partitions have\n  been brought together to form a fully connected network again. The effect on\n  other applications that expects that a fully connected network is maintained\n  may vary, but they might misbehave in very subtle hard to detect ways during\n  such a partitioning.\n\n  In order to prevent such issues, we have introduced a _prevent overlapping\n  partitions_ fix which can be enabled using the\n  [`prevent_overlapping_partitions`](kernel_app.md#prevent_overlapping_partitions)\n  `kernel(6)` parameter. When this fix has been enabled, `global` will actively\n  disconnect from nodes that reports that they have lost connections to other\n  nodes. This will cause fully connected partitions to form instead of leaving\n  the network in a state with overlapping partitions. Note that this fix _has_\n  to be enabled on _all_ nodes in the network in order to work properly. Since\n  this quite substantially changes the behavior, this fix is currently disabled\n  by default. Since you might get hard to detect issues without this fix you\n  are, however, _strongly_ advised to enable this fix in order to avoid issues\n  such as the ones described above. As of OTP 25 this fix will become enabled by\n  default.\n\n  Own Id: OTP-17843 Aux Id: ERIERL-732, PR-5611\n\n- Fix bug where `logger` would crash when logging a report including improper\n  lists.\n\n  Own Id: OTP-17851\n\n- Make `erlang:set_cookie` work for dynamic node names.\n\n  Own Id: OTP-17902 Aux Id: GH-5402, PR-5670","ref":"notes.html#fixed-bugs-and-malfunctions-49"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Add support for using socket:sockaddr_in() and socket:sockaddr_in6() when\n  using gen_sctp, gen_tcp and gen_udp. This will make it possible to use Link\n  Local IPv6 addresses.\n\n  Own Id: OTP-17455 Aux Id: GH-4852\n\n- A [`net_tickintensity`](kernel_app.md#net_tickintensity) `kernel` parameter\n  has been introduced. It can be used to control the amount of ticks during a\n  [`net_ticktime`](kernel_app.md#net_ticktime) period.\n\n  A new `net_kernel:start/2` function has also been introduced in order to make\n  it easier to add new options. The use of `net_kernel:start/1` has been\n  deprecated.\n\n  Own Id: OTP-17905 Aux Id: ERIERL-732, PR-5740\n\n- Improve documentation for the dynamic node name feature.\n\n  Own Id: OTP-17918","ref":"notes.html#improvements-and-new-features-13"},{"type":"extras","title":"Kernel 8.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- socket:which_sockets( pid() ) uses wrong keyword when looking up socket owner\n  ('ctrl' instead of 'owner').\n\n  Own Id: OTP-17716\n\n- In epmd_ntop, the #if defined(EPMD6) conditional was inverted and it was only\n  including the IPv6-specific code when EPMD6 was undefined. This was causing\n  IPv6 addrs to be interpreted as IPv4 addrs and generating nonsense IPv4\n  addresses as output.\n\n  Several places were incorrectly using 'num_sockets' instead of 'i' to index\n  into the iserv_addr array during error logging. This would result in a read\n  into uninitialized data in the iserv_addr array.\n\n  Thanks to John Eckersberg for providing this fix.\n\n  Own Id: OTP-17730\n\n- Minor fix of the `erl_uds_dist` distribution module example.\n\n  Own Id: OTP-17765 Aux Id: PR-5289\n\n- A bug has been fixed for the legacy TCP socket adaption module\n  `gen_tcp_socket` where it did bind to a socket address when given a file\n  descriptor, but should not.\n\n  Own Id: OTP-17793 Aux Id: PR-5348, OTP-17451, PR-4787, GH-4680, PR-2989,\n  OTP-17216\n\n- Improve the error printout when [`open_port/2`](`open_port/2`) fails because\n  of invalid arguments.\n\n  Own Id: OTP-17805 Aux Id: PR-5406\n\n- Calling socket:monitor/1 on an already closed socket should succeed and result\n  in an immediate DOWN message. This has now been fixed.\n\n  Own Id: OTP-17806\n\n- Fix the configuration option `logger_metadata` to work.\n\n  Own Id: OTP-17807 Aux Id: PR-5418\n\n- Fix tls and non-tls distribution to use erl_epmd:address_please to figure out\n  if IPv4 or IPv6 addresses should be used when connecting to the remote node.\n\n  Before this fix, a dns lookup of the remote node hostname determined which IP\n  version was to be used which meant that the hostname had to resolve to a valid\n  ip address.\n\n  Own Id: OTP-17809 Aux Id: PR-5337 GH-5334","ref":"notes.html#fixed-bugs-and-malfunctions-50"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Add `logger:reconfigure/0`.\n\n  Own Id: OTP-17375 Aux Id: PR-4663 PR-5186\n\n- Add socket function ioctl/2,3,4 for socket device control.\n\n  Own Id: OTP-17528\n\n- Add simple support for socknames/1 for gen_tcp_socket and gen_udp_socket.\n\n  Own Id: OTP-17531\n\n- The types for callback result types in `gen_statem` has bee augmented with\n  arity 2 types where it is possible for a callback module to specify the type\n  of the callback data, so the callback module can get type validation of it.\n\n  Own Id: OTP-17738 Aux Id: PR-4926, OTP-17589","ref":"notes.html#improvements-and-new-features-14"},{"type":"extras","title":"Kernel 8.1.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The internal, undocumented, but used, module `inet_dns` has been fixed to\n  handle mDNS high bit usage of the Class field.\n\n  Code that uses the previously obsolete, undocumented and unused record field\n  `#dns_rr.func` will need to be updated since that field is now used as a\n  boolean flag for the mDNS high Class bit. Code that uses the also undocumented\n  record `#dns_query` will need to be recompiled since a boolean field\n  `#dns_query.unicast_response` has been added for the mDNS high Class bit.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17734 Aux Id: GH-5327, OTP-17659\n\n- The fix for Linux's behaviour when reconnecting an UDP socket in PR-5120\n  released in OTP-24.1.2 has been refined to only dissolve the socket's\n  connection before a connect if the socket is already connected, that is: only\n  for a reconnect.\n\n  This allows code to open a socket with an ephemeral port, get the port number\n  and connect; without the port number changing (on Linux). This turned out to\n  have at least one valid use case (besides test cases).\n\n  Should one reconnect the socket then the port number may change, on Linux; it\n  is a known quirk, which can be worked around by binding to a specific port\n  number when opening the socket. If you can do without an ephemeral port, that\n  is...\n\n  Own Id: OTP-17736 Aux Id: GH-5279, PR-5120, OTP-17559","ref":"notes.html#fixed-bugs-and-malfunctions-51"},{"type":"extras","title":"Kernel 8.1.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The undocumented DNS encode/decode module `inet_dns` has been cleaned up to\n  handle the difference between \"symbolic\" and \"raw\" records in a more\n  consistent manner.\n\n  PR-5145/OTP-17584 introduced a change that contributed to an already existing\n  confusion, which this correction should remedy.\n\n  Own Id: OTP-17659 Aux Id: ERIERL-702","ref":"notes.html#fixed-bugs-and-malfunctions-52"},{"type":"extras","title":"Kernel 8.1.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Add more info about the socket 'type' ('socket' or 'port') for the DOWN\n  message when monitoring sockets.\n\n  Own Id: OTP-17640","ref":"notes.html#fixed-bugs-and-malfunctions-53"},{"type":"extras","title":"Kernel 8.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The extended error information has been corrected and improved for the\n  following BIFs: [`binary_to_existing_atom/2`](`binary_to_existing_atom/2`),\n  [`list_to_existing_atom/1`](`list_to_existing_atom/1`),\n  `erlang:send_after/{3,4}`, and `erlang:start_timer/{3,4}`.\n\n  Own Id: OTP-17449 Aux Id: GH-4900\n\n- Fixed rare bug that could cause net_kernel process to hang for ever. Have seen\n  to happen with massive number of TLS connections while remote nodes are\n  restarting. Bug exists since OTP-22.0.\n\n  Own Id: OTP-17476 Aux Id: GH-4931, PR-4934\n\n- Improve handling of closed sockets for inet:info/1.\n\n  Own Id: OTP-17492\n\n- This change fixes a performance problem introduced in pull-request #2675.\n  Pull-request #2675 made so the system tried to start children of already\n  started applications which is unnecessary. This change fixes this performance\n  problem.\n\n  Own Id: OTP-17519\n\n- Fix code:get_doc/1 to not crash when module is located in an escript.\n\n  Own Id: OTP-17570 Aux Id: PR-5139 GH-4256 ERL-1261\n\n- Parsing of the result value in the native DNS resolver has been made more\n  defensive against incorrect results.\n\n  Own Id: OTP-17578 Aux Id: ERIERL-683\n\n- A bug in the option handling for the legacy socket adaptor, that is; when\n  using `inet_backend = socket`, has been fixed. Now socket options are set\n  before the bind() call so options regarding, for example address reuse have\n  the desired effect.\n\n  Own Id: OTP-17580 Aux Id: GH-5122\n\n- `inet:ntoa/1` has been fixed to not accept invalid numerical addresses.\n\n  Own Id: OTP-17583 Aux Id: GH-5136\n\n- Parsing of DNS records has been improved for records of known types to not\n  accept and present malformed ones in raw format.\n\n  Own Id: OTP-17584 Aux Id: PR-5145\n\n- The `ip_mreq()` type for the `{ip,add_membership}` and `{ip,drop_membership}`\n  socket options has been corrected to have an `interface` field instead of,\n  incorrectly, an `address` field.\n\n  Own Id: OTP-17590 Aux Id: PR-5170","ref":"notes.html#fixed-bugs-and-malfunctions-54"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Add simple utility function to display existing sockets i the erlang shell\n  (socket:i/0).\n\n  Own Id: OTP-17376 Aux Id: OTP-17157\n\n- gen_udp can now be configured to use the socket inet-backend (in the same way\n  as gen_tcp).\n\n  Own Id: OTP-17410\n\n- Functions `erlang:set_cookie(Cookie)` and `erlang:get_cookie(Node)` have been\n  added for completeness and to facilitate configuring distributed nodes with\n  different cookies.\n\n  The documentation regarding distribution cookies has been improved to be less\n  vague.\n\n  Own Id: OTP-17538 Aux Id: GH-5063, PR-5111\n\n- A workaround has been implemented for Linux's quirky behaviour to not adjust\n  the source IP address when connecting a connected (reconnecing) UDP socket.\n\n  The workaround is to, on Linux, always dissolve any connection before\n  connecting an UDP socket.\n\n  Own Id: OTP-17559 Aux Id: GH-5092, PR-5120\n\n- Documented our recommendation against opening NFS-mounted files, FIFOs,\n  devices, and similar using `file:open/2`.\n\n  Own Id: OTP-17576 Aux Id: ERIERL-685","ref":"notes.html#improvements-and-new-features-15"},{"type":"extras","title":"Kernel 8.0.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- For `gen_tcp:connect/3,4` it is possible to specify a specific source port,\n  which should be enough to bind the socket to an address with that port before\n  connecting.\n\n  Unfortunately that feature was lost in OTP-17216 that made it mandatory to\n  specify the source address to get an address binding, and ignored a specified\n  source port if no source address was specified.\n\n  That bug has now been corrected.\n\n  Own Id: OTP-17536 Aux Id: OTP-17216, ERIERL-677","ref":"notes.html#fixed-bugs-and-malfunctions-55"},{"type":"extras","title":"Kernel 8.0.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix a race condition in Global.\n\n  Own Id: OTP-16033 Aux Id: ERIERL-329, ERL-1414, GH-4448, ERL-885, GH-3923\n\n- After a node restart with `init:restart/0,1`, the module `socket` was not\n  usable because supporting tables had been cleared and not re-initialized. This\n  has now been fixed.\n\n  Handling of the \".\" domain as a search domain was incorrect and caused a crash\n  in the DNS resolver `inet_res`, which has now been fixed.\n\n  Own Id: OTP-17439 Aux Id: GH-4827, PR-4888, GH-4838\n\n- Handling of combinations of the `fd` option and binding to an address has been\n  corrected, especially for the `local` address family.\n\n  Own Id: OTP-17451 Aux Id: OTP-17374\n\n- Bug fixes and code cleanup for the new `socket` implementation, such as:\n\n  Assertions on the result of demonitoring has been added in the NIF code, where\n  appropriate.\n\n  Internal state handling for socket close in the NIF code has been reviewed.\n\n  Looping over `close()` for `EINTR` in the NIF code has been removed, since it\n  is strongly discouraged on Linux and Posix is not clear about if it is\n  allowed.\n\n  The `inet_backend` temporary socket option for legacy `gen_tcp` sockets has\n  been documented.\n\n  The return value from `net:getaddrinfo/2` has been corrected: the `protocol`\n  field is now an `t:atom/0`, instead of, incorrectly,\n  [`list(atom())`](`t:list/1`). The documentation has also been corrected about\n  this return type.\n\n  Deferred close of a `socket:sendfile/*` file was broken and has been\n  corrected.\n\n  Some debug code, not enabled by default, in the socket NIF has been corrected\n  to not accidentally core dump for debug printouts of more or less innocent\n  events.\n\n  Own Id: OTP-17452","ref":"notes.html#fixed-bugs-and-malfunctions-56"},{"type":"extras","title":"Kernel 8.0 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-8-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- A bug has been fixed for the internal `inet_res` resolver cache that handled a\n  resolver configuration file status timer incorrectly and caused performance\n  problems due to many unnecessary file system accesses.\n\n  Own Id: OTP-14700 Aux Id: PR-2848\n\n- Change the value of the tag `head` returned by `disk_log:info/1` from\n  `{ok, Head}` to just `Head`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16809 Aux Id: ERL-1313\n\n- Two options have been added to `erl_call`. The `-fetch_stdout` option fetches\n  stdout data resulting from the code invoked by `erl_call`. The `-fetch_stdout`\n  option disables printing of the result term. In order to implement the first\n  of these two options a new function called `ei_xrpc_from` has been added to\n  erl_interface. For details see the `erl_call` documentation and\n  `erl_interface` documentation.\n\n  Own Id: OTP-17132\n\n- Missing runtime dependencies has been added to this application.\n\n  Own Id: OTP-17243 Aux Id: PR-4557\n\n- `inet:get_rc/0` has been corrected to return host entries as separate entries\n  instead of (incorrectly) in a list within the list. This bug was introduced by\n  OTP-16487 in OTP-23.0-rc1.\n\n  Own Id: OTP-17262 Aux Id: GH-4588, PR-4604, OTP-16487\n\n- The type gen_tcp:option_name() had a duplicate pktoptions value.\n\n  Own Id: OTP-17277\n\n- Fixed removal of empty groups from internal state in `pg`.\n\n  Own Id: OTP-17286 Aux Id: PR-4619\n\n- `erl -remsh` now prints an error message when it fails to connect to the\n  remote node.\n\n  Own Id: OTP-17287 Aux Id: PR-4581\n\n- Fix bugs related to corrupt shell history files.\n\n  Error messages printed by shell history are now logged as logger error reports\n  instead of written to standard error.\n\n  Own Id: OTP-17288 Aux Id: PR-4581\n\n- A logger warning is now issues when too many arguments are given to `-name` or\n  `-sname`. Example: `erl -name a b`.\n\n  Own Id: OTP-17315 Aux Id: GH-4626\n\n- The cache used by `inet_res` now, again, can handle multiple IP addresses per\n  domain name, and thus fixes a bug introduced in PR-3041 (OTP-13126) and\n  PR-2891 (OTP-14485).\n\n  Own Id: OTP-17344 Aux Id: PR-4633, GH-4631, OTP-14485, OTP-12136\n\n- Sockets created with socket:accept not counted (socket:info/0).\n\n  Own Id: OTP-17372\n\n- The `{fd, Fd}` option to `gen_tcp:listen/2` did not work for `inet_backend`\n  `socket`, which has been fixed.\n\n  Own Id: OTP-17374 Aux Id: PR-4787, GH-4680, PR-2989, OTP-17216","ref":"notes.html#fixed-bugs-and-malfunctions-57"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- The cache used by the DNS resolver `inet_res` has been improved to use ETS\n  lookups instead of server calls. This is a considerable speed improvement for\n  cache hits.\n\n  Own Id: OTP-13126 Aux Id: PR-3041\n\n- The cache ETS table type for the internal DNS resolver `inet_res` has changed\n  type (internally) to get better speed and atomicity.\n\n  Own Id: OTP-14485 Aux Id: PR-2891\n\n- The experimental `socket` module can now use any protocol (by name) the OS\n  supports. Suggested in PR-2641, implemented in PR-2670.\n\n  Own Id: OTP-14601 Aux Id: PR-2641, PR-2670, OTP-16749\n\n- The DNS resolver `inet_res` has been updated to support CAA (RFC 6844) and URI\n  (RFC 7553) records.\n\n  Own Id: OTP-16517 Aux Id: PR-2827\n\n- A compatibility adaptor for `gen_tcp` to use the new `socket` API has been\n  implemented (`gen_tcp_socket`). Used when setting the kernel application\n  variable `inet_backend = socket`.\n\n  Own Id: OTP-16611 Aux Id: OTP-16749\n\n- Extended error information for failing BIF calls as proposed in\n  [EEP 54](https://github.com/erlang/eep/blob/master/eeps/eep-0054.md) has been\n  implemented.\n\n  When a BIF call from the Erlang shell fails, more information about which\n  argument or arguments that were in error will be printed. The same extended\n  error information will by `proc_lib`, `common_test`, and `qlc` when BIF calls\n  fail.\n\n  For applications that wish to provide the same extended error information,\n  there are new functions `erl_error:format_exception/3` and\n  `erl_error:format_exception/4`.\n\n  There is a new [`error/3`](`error/3`) BIF that allows applications or\n  libraries to provide extended error information in the same way for their own\n  exceptions.\n\n  Own Id: OTP-16686\n\n- The file server can now be bypassed in `file:delete/1,2` with the `raw`\n  option.\n\n  Own Id: OTP-16698 Aux Id: PR-2634\n\n- An example implementation of Erlang distribution over UDS using distribution\n  processes has been introduced.\n\n  Thanks to Jérôme de Bretagne\n\n  Own Id: OTP-16703 Aux Id: PR-2620\n\n- The [_process alias_](`e:system:ref_man_processes.md#process-aliases`) feature\n  as outlined by\n  [EEP 53](https://github.com/erlang/eep/blob/master/eeps/eep-0053.md) has been\n  introduced. It is introduced in order to provide a lightweight mechanism that\n  can prevent late replies after timeout or connection loss. For more\n  information, see EEP 53 and the documentation of the new\n  [`alias/1`](`erlang:alias/1`) BIF and the new options to the\n  [`monitor/3`](`erlang:monitor/3`) BIF.\n\n  The `call` operation in the framework used by `gen_server`, `gen_statem`, and\n  `gen_event` has been updated to utilize alias in order to prevent late\n  responses. The `gen_statem` behavior still use a proxy process in the\n  distributed case, since it has always prevented late replies and aliases won't\n  work against pre OTP 24 nodes. The proxy process can be removed in OTP 26.\n\n  The alias feature also made it possible to introduce new functions similar to\n  the [`erpc:receive_response()`](`erpc:receive_response/2`) function in the gen\n  behaviors, so the new functions\n  [`gen_server:receive_response()`](`gen_server:receive_response/2`),\n  [`gen_statem:receive_response()`](`gen_statem:receive_response/2`),\n  [`gen_event:receive_response()`](`gen_event:receive_response/2`) have also\n  been introduced.\n\n  Own Id: OTP-16718 Aux Id: PR-2735\n\n- The experimental new socket API has been further developed. Some backwards\n  incompatible changes with respect to OTP 23 have been made.\n\n  The control message format has been changed so a decoded value is now in the\n  'value' field instead of in the 'data' field. The 'data' field now always\n  contains binary data.\n\n  Some type names have been changed regarding message headers and control\n  message headers.\n\n  `socket:bind/2` now returns plain `ok` instead of `{ok, Port}` which was only\n  relevant for the `inet` and `inet6` address families and often not\n  interesting. To find out which port was chosen use `socket:sockname/1`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16749 Aux Id: OTP-14601\n\n- New function `os:env/0` returns all OS environment variables as a list of\n  2-tuples.\n\n  Own Id: OTP-16793 Aux Id: ERL-1332, PR-2740\n\n- Remove the support for distributed disk logs. The new function\n  `disk_log:all/0` is to be used instead of `disk_log:accessible_logs/0`. The\n  function `disk_log:close/1` is to be used instead of `disk_log:lclose/1,2`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16811\n\n- Expand the spec for `erl_epmd:listen_port_please/2` to mirror\n  `erl_epmd:port_please/2`.\n\n  Own Id: OTP-16947 Aux Id: PR-2781\n\n- A new erl parameter for specifying a file descriptor with configuration data\n  has been added. This makes it possible to pass the parameter \"-configfd FD\"\n  when executing the erl command. When this option is given, the system will try\n  to read and parse configuration parameters from the file descriptor.\n\n  Own Id: OTP-16952\n\n- The experimental HiPE application has been removed, together with all related\n  functionality in other applications.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16963\n\n- The `pg2` module has been removed.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16968\n\n- Accept references up to a size of 160-bits from remote nodes. This is the\n  first step in an upgrade path toward using references up to 160-bits in a\n  future OTP release.\n\n  Own Id: OTP-17005 Aux Id: OTP-16718\n\n- Allow utf-8 binaries as parts of logger_formatter template.\n\n  Own Id: OTP-17015\n\n- Let `disk_log:open/1` change the size if a wrap log is opened for the first\n  time, that is, the disk log process does not exist, and the value of option\n  `size` does not match the current size of the disk log.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17062 Aux Id: ERL-1418, GH-4469, ERIERL-537\n\n- Allow the shell history of an erlang node to be fetched and stores using a\n  custom callback module. See `shell_history` configuration parameter in the\n  [kernel documentation](kernel_app.md) for more details.\n\n  Own Id: OTP-17103 Aux Id: PR-2949\n\n- The simple logger (used to log events that happen before kernel has been\n  started) has been improved to print prettier error messages.\n\n  Own Id: OTP-17106 Aux Id: PR-2885\n\n- `socket:sendfile/2,3,4,5` has been implemented, for platforms that support the\n  underlying socket library call.\n\n  Own Id: OTP-17154 Aux Id: OTP-16749\n\n- Add socket monitor(s) for all types sockets.\n\n  Own Id: OTP-17155\n\n- Fix various issues with the gen_tcp_socket. Including documenting some\n  incompatibilities.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17156\n\n- inet:i/0 now also shows existing gen_tcp compatibility sockets (based on\n  'socket').\n\n  Own Id: OTP-17157\n\n- Added support in logger for setting primary metadata. The primary metadata is\n  passed as a base metadata to all log events in the system. See\n  [Metadata](logger_chapter.md#metadata) in the Logger chapter of the Kernel\n  User's Guide for more details.\n\n  Own Id: OTP-17181 Aux Id: PR-2457\n\n- Recognize new key 'optional_applications' in application resource files.\n\n  Own Id: OTP-17189 Aux Id: PR-2675\n\n- The `Fun`'s passed to logger:log/2,3,4 can now return metadata that will only\n  be fetched when needed. See [`logger:log/2,3,4`](`logger:log/2`) for more\n  details.\n\n  Own Id: OTP-17198 Aux Id: PR-2721\n\n- `erpc:multicall()` has been rewritten to be able to utilize the newly\n  introduced and improved selective receive optimization.\n\n  Own Id: OTP-17201 Aux Id: PR-4534\n\n- Add utility fiunction inet:info/1 to provide miscellaneous info about a\n  socket.\n\n  Own Id: OTP-17203 Aux Id: OTP-17156\n\n- The behaviour for `gen_tcp:connect/3,4` has been changed to not per default\n  bind to an address, which allows the network stack to delay the address and\n  port selection to when the remote address is known. This allows better port\n  re-use, and thus enables far more outgoing connections, since the ephemeral\n  port range no longer has to be a hard limit.\n\n  There is a theoretical possibility that this behaviour change can affect the\n  set of possible error values, or have other small implications on some\n  platforms.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17216 Aux Id: PR-2989\n\n- An option `{nxdomain_reply, boolean()}` has been implemented in the DNS\n  resolver `inet_res`. It is useful since an `nxdomain` error from a name server\n  does contain the SOA record if the domain exists at all. This record is useful\n  to determine a TTL for negative caching of the failed entry.\n\n  Own Id: OTP-17266 Aux Id: PR-4564\n\n- Optimized lookup of local processes part of groups in `pg`.\n\n  Own Id: OTP-17284 Aux Id: PR-4615\n\n- The return values from module `socket` functions `send()`, `sendto()`,\n  `sendmsg()`, `sendfile()` and `recv()` has been changed to return a tuple\n  tagged with `select` when a `SelectInfo` was returned, and not sometimes\n  tagged with `ok`.\n\n  This is a backwards incompatible change that improves usability for code using\n  asynchronous operations.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17355 Aux Id: OTP-17154\n\n- Fixed warnings in code matching on underscore prefixed variables.\n\n  Own Id: OTP-17385 Aux Id: OTP-17123","ref":"notes.html#improvements-and-new-features-16"},{"type":"extras","title":"Kernel 7.3.1.7 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-7-3-1-7"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- A new function `global:disconnect/0` has been introduced with which one can\n  cleanly disconnect a node from all other nodes in a cluster of `global` nodes.\n\n  Own Id: OTP-18232 Aux Id: OTP-17843, PR-6264","ref":"notes.html#improvements-and-new-features-17"},{"type":"extras","title":"Kernel 7.3.1.6 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-7-3-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- A call to [`net_kernel:setopts(new, Opts)`](`net_kernel:setopts/2`) at the\n  same time as a connection was being set up could cause a deadlock between the\n  `net_kernel` process and the process setting up the connection.\n\n  Own Id: OTP-18198 Aux Id: GH-6129, PR-6216","ref":"notes.html#fixed-bugs-and-malfunctions-58"},{"type":"extras","title":"Kernel 7.3.1.5 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-7-3-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- By default `global` does _not_ take any actions to restore a fully connected\n  network when connections are lost due to network issues. This is problematic\n  for all applications expecting a fully connected network to be provided, such\n  as for example `mnesia`, but also for `global` itself. A network of\n  overlapping partitions might cause the internal state of `global` to become\n  inconsistent. Such an inconsistency can remain even after such partitions have\n  been brought together to form a fully connected network again. The effect on\n  other applications that expects that a fully connected network is maintained\n  may vary, but they might misbehave in very subtle hard to detect ways during\n  such a partitioning.\n\n  In order to prevent such issues, we have introduced a _prevent overlapping\n  partitions_ fix which can be enabled using the\n  [`prevent_overlapping_partitions`](kernel_app.md#prevent_overlapping_partitions)\n  `kernel(6)` parameter. When this fix has been enabled, `global` will actively\n  disconnect from nodes that reports that they have lost connections to other\n  nodes. This will cause fully connected partitions to form instead of leaving\n  the network in a state with overlapping partitions. Note that this fix _has_\n  to be enabled on _all_ nodes in the network in order to work properly. Since\n  this quite substantially changes the behavior, this fix is currently disabled\n  by default. Since you might get hard to detect issues without this fix you\n  are, however, _strongly_ advised to enable this fix in order to avoid issues\n  such as the ones described above. As of OTP 25 this fix will become enabled by\n  default.\n\n  Own Id: OTP-17843 Aux Id: ERIERL-732, PR-5611\n\n- Fix failed accepted connection setup after previous established connection\n  from same node closed down silently.\n\n  Own Id: OTP-17979 Aux Id: ERIERL-780","ref":"notes.html#fixed-bugs-and-malfunctions-59"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- A [`net_tickintensity`](kernel_app.md#net_tickintensity) `kernel` parameter\n  has been introduced. It can be used to control the amount of ticks during a\n  [`net_ticktime`](kernel_app.md#net_ticktime) period.\n\n  A new `net_kernel:start/2` function has also been introduced in order to make\n  it easier to add new options. The use of `net_kernel:start/1` has been\n  deprecated.\n\n  Own Id: OTP-17905 Aux Id: ERIERL-732, PR-5740","ref":"notes.html#improvements-and-new-features-18"},{"type":"extras","title":"Kernel 7.3.1.4 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-7-3-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Parsing of the result value in the native DNS resolver has been made more\n  defensive against incorrect results.\n\n  Own Id: OTP-17578 Aux Id: ERIERL-683","ref":"notes.html#fixed-bugs-and-malfunctions-60"},{"type":"extras","title":"Kernel 7.3.1.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-7-3-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix code:get_doc/1 to not crash when module is located in an escript.\n\n  Own Id: OTP-17570 Aux Id: PR-5139 GH-4256 ERL-1261","ref":"notes.html#fixed-bugs-and-malfunctions-61"},{"type":"extras","title":"Kernel 7.3.1.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-7-3-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Handling of the \".\" domain as a search domain was incorrect and caused a crash\n  in the DNS resolver `inet_res`, which has now been fixed.\n\n  Own Id: OTP-17473 Aux Id: GH-4838, OTP-17439\n\n- Fixed rare bug that could cause net_kernel process to hang for ever. Have seen\n  to happen with massive number of TLS connections while remote nodes are\n  restarting. Bug exists since OTP-22.0.\n\n  Own Id: OTP-17476 Aux Id: GH-4931, PR-4934","ref":"notes.html#fixed-bugs-and-malfunctions-62"},{"type":"extras","title":"Kernel 7.3.1.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-7-3-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix a race condition in Global.\n\n  Own Id: OTP-16033 Aux Id: ERIERL-329, ERL-1414, GH-4448, ERL-885, GH-3923","ref":"notes.html#fixed-bugs-and-malfunctions-63"},{"type":"extras","title":"Kernel 7.3.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-7-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- A bug in the Erlang DNS resolver has been fixed, where it could be made to\n  bring down the kernel supervisor and thereby the whole node, when getting an\n  incorrect (IN A reply to an IN CNAME query) reply from the DNS server and used\n  the reply record's value without verifying its type.\n\n  Own Id: OTP-17361","ref":"notes.html#fixed-bugs-and-malfunctions-64"},{"type":"extras","title":"Kernel 7.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-7-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The range check for compression pointers in DNS encoding was faulty, which\n  caused incorrect label compression encoding for very large DNS messages;\n  larger than about 16 kBytes, such as AXFR responses. This more than 11 year\n  old bug has now been corrected.\n\n  Own Id: OTP-13641 Aux Id: PR-2959\n\n- Fix of internal links in the `erpc` documentation.\n\n  Own Id: OTP-17202 Aux Id: PR-4516\n\n- Fix bug where complex seq_trace tokens (that is lists, tuples, maps etc) could\n  becomes corrupted by the GC. The bug was introduced in OTP-21.\n\n  Own Id: OTP-17209 Aux Id: PR-3039\n\n- When running Xref in the `modules` mode, the Debugger application would show\n  up as a dependency for the Kernel applications.\n\n  Own Id: OTP-17223 Aux Id: GH-4546, PR-4554","ref":"notes.html#fixed-bugs-and-malfunctions-65"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- `m:erl_epmd` (the epmd client) will now try to reconnect to the local EPMD if\n  the connection is broken.\n\n  Own Id: OTP-17178 Aux Id: PR-3003","ref":"notes.html#improvements-and-new-features-19"},{"type":"extras","title":"Kernel 7.2.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-7-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- When using the DNS resolver option `servfail_retry_timeout` it did not honour\n  the overall call time-out in e.g `inet_res:getbyname/3`. This misbehaviour has\n  now been fixed. Also, the `servfail_retry_timeout` behaviour has been improved\n  to only be enforced for servers that gives a servfail answer.\n\n  Own Id: OTP-12960 Aux Id: ERIERL-598, PR-4509","ref":"notes.html#fixed-bugs-and-malfunctions-66"},{"type":"extras","title":"Kernel 7.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-7-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The `apply` call's in `logger.hrl` are now called with `erlang` prefix to\n  avoid clashed with local [`apply/3`](`apply/3`) functions.\n\n  Own Id: OTP-16976 Aux Id: PR-2807\n\n- Fix memory leak in `pg`.\n\n  Own Id: OTP-17034 Aux Id: PR-2866\n\n- Fix crash in `logger_proxy` due to stray `gen_server:call` replies not being\n  handled. The stray replies come when logger is under heavy load and the flow\n  control mechanism is reaching its limit.\n\n  Own Id: OTP-17038\n\n- Fixed a bug in `erl_epmd:names()` that caused it to return the illegal return\n  value `noport` instead of `{error, Reason}` where `Reason` is the actual error\n  reason. This bug also propagated to `net_adm:names()`.\n\n  This bug was introduced in `kernel` version 7.1 (OTP 23.1).\n\n  Own Id: OTP-17054 Aux Id: ERL-1424","ref":"notes.html#fixed-bugs-and-malfunctions-67"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Add export of some resolver documented types.\n\n  Own Id: OTP-16954 Aux Id: ERIERL-544\n\n- Add configurable retry timeout for resolver lookups.\n\n  Own Id: OTP-16956 Aux Id: ERIERL-547\n\n- `gen_server:multi_call()` has been optimized in the special case of only\n  calling the local node with timeout set to `infinity`.\n\n  Own Id: OTP-17058 Aux Id: PR-2887","ref":"notes.html#improvements-and-new-features-20"},{"type":"extras","title":"Kernel 7.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- A fallback has been implemented for file:sendfile when using inet_backend\n  socket\n\n  Own Id: OTP-15187 Aux Id: ERL-1293\n\n- Make default TCP distribution honour option `backlog` in\n  `inet_dist_listen_options`.\n\n  Own Id: OTP-16694 Aux Id: PR-2625\n\n- Raw option handling for the experimental `gen_tcp_socket` backend was broken\n  so that all raw options were ignored by for example `gen_tcp:listen/2`, a bug\n  that now has been fixed. Reported by Jan Uhlig.\n\n  Own Id: OTP-16743 Aux Id: ERL-1287\n\n- Accept fails with inet-backend socket.\n\n  Own Id: OTP-16748 Aux Id: ERL-1284\n\n- Fixed various minor errors in the socket backend of gen_tcp.\n\n  Own Id: OTP-16754\n\n- Correct `disk_log:truncate/1` to count the header. Also correct the\n  documentation to state that `disk_log:truncate/1` can be used with external\n  disk logs.\n\n  Own Id: OTP-16768 Aux Id: ERL-1312\n\n- Fix erl_epmd:port_please/2,3 type specs to include all possible error values.\n\n  Own Id: OTP-16783\n\n- Fix `erl -erl_epmd_port` to work properly. Before this fix it did not work at\n  all.\n\n  Own Id: OTP-16785\n\n- Fix typespec for internal function `erlang:seq_trace_info/1` to allow\n  `t:term/0` as returned label. This in turn fixes so that calls to\n  `seq_trace:get_token/1` can be correctly analyzer by dialyzer.\n\n  Own Id: OTP-16823 Aux Id: PR-2722\n\n- Fix erroneous double registration of processes in `pg` when distribution is\n  dynamically started.\n\n  Own Id: OTP-16832 Aux Id: PR-2738","ref":"notes.html#fixed-bugs-and-malfunctions-68"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Make (use of) the socket registry optional (still enabled by default). Its now\n  possible to build OTP with the socket registry turned off, turn it off by\n  setting an environment variable and controlling in runtime (via function calls\n  and arguments when creating sockets).\n\n  Own Id: OTP-16763\n\n- `erl -remsh nodename` no longer requires the hostname to be given when used\n  together with dynamic nodenames.\n\n  Own Id: OTP-16784","ref":"notes.html#improvements-and-new-features-21"},{"type":"extras","title":"Kernel 7.0 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-7-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix race condition during shutdown when `shell_history` is enabled. The race\n  condition would trigger crashes in `disk_log`.\n\n  Own Id: OTP-16008 Aux Id: PR-2302\n\n- Fix the Erlang distribution to handle the scenario when a node connects that\n  can handle message fragmentation but can not handle the atom cache. This bug\n  only affects users that have implemented a custom distribution carrier. It has\n  been present since OTP-21.\n\n  The `DFLAG_FRAGMENT` distribution flag was added to the set of flags that can\n  be rejected by a distribution implementation.\n\n  Own Id: OTP-16284\n\n- Fix bug where a binary was not allowed to be the format string in calls to\n  `logger:log`.\n\n  Own Id: OTP-16395 Aux Id: PR-2444\n\n- Fix bug where `logger` would end up in an infinite loop when trying to log the\n  crash of a handler or formatter.\n\n  Own Id: OTP-16489 Aux Id: ERL-1134\n\n- `code:lib_dir/1` has been fixed to also return the lib dir for `erts`.\n\n  This is been marked as an incompatibility for any application that depended on\n  `{error,bad_name}` to be returned for `erts`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16502\n\n- The application `stop/1` callback was not called if the application master of\n  the application terminated.\n\n  Own Id: OTP-16504 Aux Id: PR-2328\n\n- Fix bug in `application:loaded_applications/0` that could cause it to fail\n  with `badarg` if for example a concurrent upgrade/downgrade is running.\n\n  Own Id: OTP-16627 Aux Id: PR-2601","ref":"notes.html#fixed-bugs-and-malfunctions-69"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- A new module `m:erpc` has been introduced in the `kernel` application. The\n  `erpc` module implements an enhanced subset of the operations provided by the\n  `m:rpc` module. Enhanced in the sense that it makes it possible to distinguish\n  between returned value, raised exceptions, and other errors. `erpc` also has\n  better performance and scalability than the original `rpc` implementation.\n  This by utilizing the newly introduced\n  [`spawn_request()`](`erlang:spawn_request/5`) BIF. Also the `rpc` module\n  benefits from these improvements by utilizing `erpc` when it is possible.\n\n  This change has been marked as a potential incompatibility since\n  [`rpc:block_call()`](`rpc:block_call/5`) now only is guaranteed to block other\n  `block_call()` operations. The documentation previously claimed that it would\n  block all `rpc` operations. This has however never been the case. It\n  previously did not block node-local `block_call()` operations.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13450 Aux Id: OTP-15251\n\n- A client node can receive its node name dynamically from the node that it\n  first connects to. This featured can by used by\n\n  - starting with `erl -sname undefined`\n  - erl_interface functions `ei_connect_init` and friends\n  - `erl_call -R`\n\n  Own Id: OTP-13812\n\n- Improved the printout of single line logger events for most of the OTP\n  behaviours in STDLIB and Kernel. This includes `proc_lib`, `gen_server`,\n  `gen_event`, `gen_statem`, `gen_fsm`, `supervisor`, `supervisor_bridge` and\n  `application`.\n\n  Improved the [`chars_limit`](`m:logger_formatter#chars_limit`) and\n  [`depth`](`m:logger_formatter#depth`) handling in `proc_lib` and when\n  formatting of exceptions.\n\n  Own Id: OTP-15299\n\n- Remove usage and documentation of old requests of the I/O-protocol.\n\n  Own Id: OTP-15695\n\n- Directories can now be opened by `file:open/2` when passing the `directory`\n  option.\n\n  Own Id: OTP-15835 Aux Id: PR-2212\n\n- The check of whether to log or not based on the log level in `logger` has been\n  optimized by using `persistent_term` to store the log level.\n\n  Own Id: OTP-15948 Aux Id: PR-2356\n\n- `file:read_file_info/2` can now be used on opened files and directories.\n\n  Own Id: OTP-15956 Aux Id: PR-2231\n\n- The `-config` option to `erl` now can take multiple config files without\n  repeating the `-config` option. Example:\n\n  erl -config sys local\n\n  Own Id: OTP-16148 Aux Id: PR-2373\n\n- Improved node connection setup handshake protocol. Made possible to agree on\n  protocol version without dependence on `epmd` or other prior knowledge of peer\n  node version. Also added exchange of node incarnation (\"creation\") values and\n  expanded the distribution capability flag field from 32 to 64 bits.\n\n  Own Id: OTP-16229\n\n- The possibility to run Erlang distribution without relying on EPMD has been\n  extended. To achieve this a couple of new options to the inet distribution has\n  been added.\n\n  - **\\-dist_listen false** - Setup the distribution channel, but do not listen\n    for incoming connection. This is useful when you want to use the current\n    node to interact with another node on the same machine without it joining\n    the entire cluster.\n\n  - **\\-erl_epmd_port Port** - Configure a default port that the built-in EPMD\n    client should return. This allows the local node to know the port to connect\n    to for any other node in the cluster.\n\n  The `erl_epmd` callback API has also been extended to allow returning `-1` as\n  the creation which means that a random creation will be created by the node.\n\n  In addition a new callback function called `listen_port_please` has been added\n  that allows the callback to return which listen port the distribution should\n  use. This can be used instead of `inet_dist_listen_min/max` if the listen port\n  is to be fetched from an external service.\n\n  Own Id: OTP-16250\n\n- A first EXPERIMENTAL module that is a `socket` backend to `gen_tcp` and `inet`\n  has been implemented. Others will follow. Feedback will be appreciated.\n\n  Own Id: OTP-16260 Aux Id: OTP-15403\n\n- The new experimental `socket` module has been moved to the Kernel application.\n\n  Own Id: OTP-16312\n\n- Replace usage of deprecated function in the `group` module.\n\n  Own Id: OTP-16345\n\n- Minor updates due to the new spawn improvements made.\n\n  Own Id: OTP-16368 Aux Id: OTP-15251\n\n- Update of [sequential tracing](`m:seq_trace#whatis`) to also support other\n  information transfers than message passing.\n\n  Own Id: OTP-16370 Aux Id: OTP-15251, OTP-15232\n\n- `code:module_status/1` now accepts a list of modules. `code:module_status/0`,\n  which returns the statuses for all loaded modules, has been added.\n\n  Own Id: OTP-16402\n\n- `filelib:wildcard/1,2` is now twice as fast when a double star (`**`) is part\n  of the pattern.\n\n  Own Id: OTP-16419\n\n- A new implementation of distributed named process groups has been introduced.\n  It is available in the `m:pg` module.\n\n  Note that this `pg` module only has the name in common with the experimental\n  `pg` module that was present in `stdlib` up until OTP 17.\n\n  Thanks to Maxim Fedorov for the implementation.\n\n  Own Id: OTP-16453 Aux Id: PR-2524\n\n- The `pg2` module has been deprecated. It has also been scheduled for removal\n  in OTP 24.\n\n  You are advised to replace the usage of `pg2` with the newly introduced `m:pg`\n  module. `pg` has a similar API, but with a more scalable implementation.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16455\n\n- Refactored the internal handling of deprecated and removed functions.\n\n  Own Id: OTP-16469\n\n- The internal hosts file resolver cache `inet_hosts` has been rewritten to\n  behave better when the hosts file changes. For example the cache is updated\n  per entry instead of cleared and reloaded so lookups do not temporarily fail\n  during reloading, and; when multiple processes simultaneously request reload\n  these are now folded into one instead of all done in sequence. Reported and\n  first solution suggestion by Maxim Fedorov.\n\n  Own Id: OTP-16487 Aux Id: PR-2516\n\n- Add `code:all_available/0` that can be used to get all available modules.\n\n  Own Id: OTP-16494\n\n- As of OTP 23, the distributed `m:disk_log` feature has been deprecated. It has\n  also been scheduled for removal in OTP 24.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16495\n\n- Add the function `code:fetch_docs/1` for fetching embedded documentation for\n  aa Erlang module.\n\n  Own Id: OTP-16499\n\n- Improve configure for the net nif, which should increase portability.\n\n  Own Id: OTP-16530 Aux Id: OTP-16464\n\n- socket: Socket counters and socket global counters are now represented as maps\n  (instead of property lists).\n\n  Own Id: OTP-16535\n\n- The experimental socket module has gotten restrictions removed so now the\n  'seqpacket' socket type should work for any communication domain (protocol\n  family) where the OS supports it, typically the Unix Domain.\n\n  Own Id: OTP-16550 Aux Id: ERIERL-476\n\n- Allow using custom IO devices in `logger_std_h`.\n\n  Own Id: OTP-16563 Aux Id: PR-2523\n\n- Added `file:del_dir_r/1` which deletes a directory together with all of its\n  contents, similar to `rm -rf` on Unix systems.\n\n  Own Id: OTP-16570 Aux Id: PR-2565\n\n- socket: By default the socket options rcvtimeo and sndtimeo are now disabled.\n  To enable these, OTP now has to be built with the configure option\n  --enable-esock-rcvsndtimeo\n\n  Own Id: OTP-16620\n\n- The experimental gen_tcp compatibility code utilizing the socket module could\n  loose buffered data when receiving a specified number of bytes. This bug has\n  been fixed. Reported by Maksim Lapshin on bugs.erlang.org ERL-1234\n\n  Own Id: OTP-16632 Aux Id: ERL-1234","ref":"notes.html#improvements-and-new-features-22"},{"type":"extras","title":"Kernel 6.5.2.5 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-5-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- By default `global` does _not_ take any actions to restore a fully connected\n  network when connections are lost due to network issues. This is problematic\n  for all applications expecting a fully connected network to be provided, such\n  as for example `mnesia`, but also for `global` itself. A network of\n  overlapping partitions might cause the internal state of `global` to become\n  inconsistent. Such an inconsistency can remain even after such partitions have\n  been brought together to form a fully connected network again. The effect on\n  other applications that expects that a fully connected network is maintained\n  may vary, but they might misbehave in very subtle hard to detect ways during\n  such a partitioning.\n\n  In order to prevent such issues, we have introduced a _prevent overlapping\n  partitions_ fix which can be enabled using the\n  `prevent_overlapping_partitions` `kernel(6)` parameter. When this fix has been\n  enabled, `global` will actively disconnect from nodes that reports that they\n  have lost connections to other nodes. This will cause fully connected\n  partitions to form instead of leaving the network in a state with overlapping\n  partitions. Note that this fix _has_ to be enabled on _all_ nodes in the\n  network in order to work properly. Since this quite substantially changes the\n  behavior, this fix is currently disabled by default. Since you might get hard\n  to detect issues without this fix you are, however, _strongly_ advised to\n  enable this fix in order to avoid issues such as the ones described above. As\n  of OTP 25 this fix will become enabled by default.\n\n  Own Id: OTP-17843 Aux Id: ERIERL-732, PR-5611","ref":"notes.html#fixed-bugs-and-malfunctions-70"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- A `net_tickintensity` `kernel` parameter has been introduced. It can be used\n  to control the amount of ticks during a `net_ticktime` period.\n\n  A new `net_kernel:start/2` function has also been introduced in order to make\n  it easier to add new options. The use of `net_kernel:start/1` has been\n  deprecated.\n\n  Own Id: OTP-17905 Aux Id: ERIERL-732, PR-5740","ref":"notes.html#improvements-and-new-features-23"},{"type":"extras","title":"Kernel 6.5.2.4 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-5-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fixed rare bug that could cause net_kernel process to hang for ever. Have seen\n  to happen with massive number of TLS connections while remote nodes are\n  restarting. Bug exists since OTP-22.0.\n\n  Own Id: OTP-17476 Aux Id: GH-4931, PR-4934","ref":"notes.html#fixed-bugs-and-malfunctions-71"},{"type":"extras","title":"Kernel 6.5.2.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-5-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix a race condition in Global.\n\n  Own Id: OTP-16033 Aux Id: ERIERL-329, ERL-1414, GH-4448, ERL-885, GH-3923","ref":"notes.html#fixed-bugs-and-malfunctions-72"},{"type":"extras","title":"Kernel 6.5.2.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-5-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- When running Xref in the `modules` mode, the Debugger application would show\n  up as a dependency for the Kernel applications.\n\n  Own Id: OTP-17223 Aux Id: GH-4546, PR-4554","ref":"notes.html#fixed-bugs-and-malfunctions-73"},{"type":"extras","title":"Kernel 6.5.2.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-5-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix bug in `application:loaded_applications/0` that could cause it to fail\n  with `badarg` if for example a concurrent upgrade/downgrade is running.\n\n  Own Id: OTP-16627 Aux Id: PR-2601","ref":"notes.html#fixed-bugs-and-malfunctions-74"},{"type":"extras","title":"Kernel 6.5.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The DNS resolver \\`inet_res\\` has been fixed to return the last intermediate\n  error when subsequent requests times out.\n\n  Own Id: OTP-16414 Aux Id: ERIERL-452\n\n- The prim_net nif (net/kernel) made use of an undefined atom, notsup. This has\n  now been corrected.\n\n  Own Id: OTP-16440\n\n- Fix a crash when attempting to log faults when loading files during early\n  boot.\n\n  Own Id: OTP-16491\n\n- Fix crash in logger when logging to a remote node during boot.\n\n  Own Id: OTP-16493 Aux Id: ERIERL-459","ref":"notes.html#fixed-bugs-and-malfunctions-75"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Improved `net_kernel` debug functionality.\n\n  Own Id: OTP-16458 Aux Id: PR-2525","ref":"notes.html#improvements-and-new-features-24"},{"type":"extras","title":"Kernel 6.5.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The 'socket state' info provided by the inet info function has been improved\n\n  Own Id: OTP-16043 Aux Id: ERL-1036\n\n- Fix bug where `logger` would crash when starting when a very large log file\n  needed to be rotated and compressed.\n\n  Own Id: OTP-16145 Aux Id: ERL-1034\n\n- Fixed a bug causing actual nodedown reason reported by\n  [`net_kernel:monitor_nodes(true, [nodedown_reason])`](`net_kernel:monitor_nodes/2`)\n  to be lost and replaced by the reason `killed`.\n\n  Own Id: OTP-16216\n\n- The documentation for `rpc:call/4,5/` has been updated to describe what\n  happens when the called function throws or return an `'EXIT'` tuple.\n\n  Own Id: OTP-16279 Aux Id: ERL-1066","ref":"notes.html#fixed-bugs-and-malfunctions-76"},{"type":"extras","title":"Kernel 6.5 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The type specification for `gen_sctp:connect/4,5` has been corrected.\n\n  Own Id: OTP-15344 Aux Id: ERL-947\n\n- Extra `-mode` flags given to `erl` are ignored with a warning.\n\n  Own Id: OTP-15852\n\n- Fix type spec for `seq_trace:set_token/2`.\n\n  Own Id: OTP-15858 Aux Id: ERL-700\n\n- `logger:compare_levels/2` would fail with a `badarg` exception if given the\n  values `all` or `none` as any of the parameters. This is now corrected.\n\n  Own Id: OTP-15942 Aux Id: PR-2301\n\n- Fix bug where the log file in `logger_std_h` would not be closed when the\n  inode of the file changed. This would in turn cause a file descriptor leak\n  when tools like logrotate are used.\n\n  Own Id: OTP-15997 Aux Id: PR-2331\n\n- Fix a race condition in the debugging function `net_kernel:nodes_info/0`.\n\n  Own Id: OTP-16022\n\n- Fix race condition when closing a file opened in `compressed` or\n  `delayed_write` mode.\n\n  Own Id: OTP-16023","ref":"notes.html#fixed-bugs-and-malfunctions-77"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- The possibility to send ancillary data, in particular the TOS field, has been\n  added to `gen_udp:send/4,5`.\n\n  Own Id: OTP-15747 Aux Id: ERIERL-294\n\n- If the log file was given with relative path, the standard logger handler\n  (`logger_std_h`) would store the file name with relative path. If the current\n  directory of the node was later changed, a new file would be created relative\n  the new current directory, potentially failing with an `enoent` if the new\n  directory did not exist. This is now corrected and `logger_std_h` always\n  stores the log file name as an absolute path, calculated from the current\n  directory at the time of the handler startup.\n\n  Own Id: OTP-15850\n\n- Support local sockets with inet:i/0.\n\n  Own Id: OTP-15935 Aux Id: PR-2299","ref":"notes.html#improvements-and-new-features-25"},{"type":"extras","title":"Kernel 6.4.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- `user`/`user_drv` could respond to io requests before they had been processed,\n  which could cause data to be dropped if the emulator was halted soon after a\n  call to `io:format/2`, such as in an escript.\n\n  Own Id: OTP-15805","ref":"notes.html#fixed-bugs-and-malfunctions-78"},{"type":"extras","title":"Kernel 6.4 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix so that when multiple `-sname` or `-name` are given to `erl` the first one\n  is chosen. Before this fix distribution was not started at all when multiple\n  name options were given.\n\n  Own Id: OTP-15786 Aux Id: ERL-918\n\n- Fix `inet_res` configuration pointing to non-existing files to work again.\n  This was broken in KERNEL-6.3 (OTP-21.3).\n\n  Own Id: OTP-15806","ref":"notes.html#fixed-bugs-and-malfunctions-79"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- A simple socket API is provided through the socket module. This is a low level\n  API that does _not_ replace gen\\_\\[tcp|udp|sctp]. It is intended to\n  _eventually_ replace the inet driver, but not the high level gen-modules\n  (gen_tcp, gen_udp and gen_sctp). It also provides a basic API that facilitates\n  the implementation of other protocols, that is TCP, UDP and SCTP.\n\n  Known issues are; No support for the Windows OS (currently).\n\n  Own Id: OTP-14831\n\n- Improved the documentation for the linger option.\n\n  Own Id: OTP-15491 Aux Id: PR-2019\n\n- Global no longer tries more than once when connecting to other nodes.\n\n  Own Id: OTP-15607 Aux Id: ERIERL-280\n\n- The dist messages EXIT, EXIT2 and MONITOR_DOWN have been updated with new\n  versions that send the reason term as part of the payload of the message\n  instead of as part of the control message.\n\n  The old versions are still present and can be used when communicating with\n  nodes that don't support the new versions.\n\n  Own Id: OTP-15611\n\n- Kernel configuration parameter `start_distribution = boolean()` is added. If\n  set to `false`, the system is started with all distribution functionality\n  disabled. Defaults to `true`.\n\n  Own Id: OTP-15668 Aux Id: PR-2088\n\n- In OTP-21.3, a warning was introduced for duplicated applications/keys in\n  configuration. This warning would be displayed both when the configuration was\n  given as a file on system start, and during runtime via\n  `application:set_env/1,2`.\n\n  The warning is now changed to a `badarg` exception in\n  `application:set_env/1,2`. If the faulty configuration is given in a\n  configuration file on system start, the startup will fail.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15692 Aux Id: PR-2170","ref":"notes.html#improvements-and-new-features-26"},{"type":"extras","title":"Kernel 6.3.1.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-3-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix bug where the log file in `logger_std_h` would not be closed when the\n  inode of the file changed. This would in turn cause a file descriptor leak\n  when tools like logrotate are used.\n\n  Own Id: OTP-15997 Aux Id: PR-2331","ref":"notes.html#fixed-bugs-and-malfunctions-80"},{"type":"extras","title":"Kernel 6.3.1.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-3-1-2"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- The possibility to send ancillary data, in particular the TOS field, has been\n  added to `gen_udp:send/4,5`.\n\n  Own Id: OTP-15747 Aux Id: ERIERL-294","ref":"notes.html#improvements-and-new-features-27"},{"type":"extras","title":"Kernel 6.3.1.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-3-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix type spec for `seq_trace:set_token/2`.\n\n  Own Id: OTP-15858 Aux Id: ERL-700","ref":"notes.html#fixed-bugs-and-malfunctions-81"},{"type":"extras","title":"Kernel 6.3.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fixed a performance regression when reading files opened with the `compressed`\n  flag.\n\n  Own Id: OTP-15706 Aux Id: ERIERL-336","ref":"notes.html#fixed-bugs-and-malfunctions-82"},{"type":"extras","title":"Kernel 6.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- If for example the `/etc/hosts` did not come into existence until after the\n  kernel application had started, its content was never read. This bug has now\n  been corrected.\n\n  Own Id: OTP-14702 Aux Id: PR-2066\n\n- Fix bug where doing `seq_trace:reset_trace()` while another process was doing\n  a garbage collection could cause the run-time system to segfault.\n\n  Own Id: OTP-15490\n\n- Fix `erl_epmd:port_please` spec to include `t:atom/0` and `t:string/0`.\n\n  Own Id: OTP-15557 Aux Id: PR-2117\n\n- The Logger handler logger_std_h now keeps track of the inode of its log file\n  in order to re-open the file if the inode changes. This may happen, for\n  instance, if the log file is opened and saved by an editor.\n\n  Own Id: OTP-15578 Aux Id: ERL-850\n\n- When user specific file modes are given to the logger handler `logger_std_h`,\n  they were earlier accepted without any control. This is now changes, so Logger\n  will adjust the file modes as follows:\n\n  \\- If `raw` is not found in the list, it is added.  \n  \\- If none of `write`, `append` or `exclusive` are found in the list, `append`\n  is added.  \n  \\- If none of `delayed_write` or `{delayed_write,Size,Delay}` are found in the\n  list, `delayed_write` is added.\n\n  Own Id: OTP-15602","ref":"notes.html#fixed-bugs-and-malfunctions-83"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- The standard logger handler, `logger_std_h`, now has a new internal feature\n  for log rotation. The rotation scheme is as follows:\n\n  The log file to which the handler currently writes always has the same name,\n  i.e. the name which is configured for the handler. The archived files have the\n  same name, but with extension \".N\", where N is an integer. The newest archive\n  has extension \".0\", and the oldest archive has the highest number.\n\n  The size at which the log file is rotated, and the number of archive files\n  that are kept, is specified with the handler specific configuration parameters\n  `max_no_bytes` and `max_no_files` respectively.\n\n  Archives can be compressed, in which case they get a \".gz\" file extension\n  after the integer. Compression is specified with the handler specific\n  configuration parameter `compress_on_rotate`.\n\n  Own Id: OTP-15479\n\n- The new functions `logger:i/0` and `logger:i/1` are added. These provide the\n  same information as `logger:get_config/0` and other `logger:get_*_config`\n  functions, but the information is more logically sorted and more readable.\n\n  Own Id: OTP-15600\n\n- Logger is now protected against overload due to massive amounts of log events\n  from the emulator or from remote nodes.\n\n  Own Id: OTP-15601\n\n- Logger now uses os:system_time/1 instead of erlang:system_time/1 to generate\n  log event timestamps.\n\n  Own Id: OTP-15625\n\n- Add functions `application:set_env/1,2` and `application:set_env/2`. These\n  take a list of application configuration parameters, and the behaviour is\n  equivalent to calling `application:set_env/4` individually for each\n  application/key combination, except it is more efficient.\n\n  `set_env/1,2` warns about duplicated applications or keys. The warning is also\n  emitted during boot, if applications or keys are duplicated within one\n  configuration file, e.g. sys.config.\n\n  Own Id: OTP-15642 Aux Id: PR-2164\n\n- Handler specific configuration parameters for the standard handler\n  `logger_std_h` are changed to be more intuitive and more similar to the\n  disk_log handler.\n\n  Earlier there was only one parameter, `type`, which could have the values\n  `standard_io`, `standard_error`, `{file,FileName}` or `{file,FileName,Modes}`.\n\n  This is now changed, so the following parameters are allowed:\n\n  `type = standard_io | standard_error | file`  \n  `file = file:filename()`  \n  `modes = [file:mode()]`\n\n  All parameters are optional. `type` defaults to `standard_io`, unless a file\n  name is given, in which case it defaults to `file`. If `type` is set to\n  `file`, the file name defaults to the same as the handler id.\n\n  The potential incompatibility is that `logger:get_config/0` and\n  `logger:get_handler_config/1` now returns the new parameters, even if the\n  configuration was set with the old variant, e.g. `#{type=>{file,FileName}}`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15662\n\n- The new configuration parameter `file_check` is added to the Logger handler\n  `logger_std_h`. This parameter specifies how long (in milliseconds) the\n  handler may wait before checking if the log file still exists and the inode is\n  the same as when it was opened.\n\n  The default value is 0, which means that this check is done prior to each\n  write operation. Setting a higher number may improve performance, but adds the\n  risk of losing log events.\n\n  Own Id: OTP-15663","ref":"notes.html#improvements-and-new-features-28"},{"type":"extras","title":"Kernel 6.2.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Setting the `recbuf` size of an inet socket the `buffer` is also automatically\n  increased. Fix a bug where the auto adjustment of inet buffer size would be\n  triggered even if an explicit inet buffer size had already been set.\n\n  Own Id: OTP-15651 Aux Id: ERIERL-304","ref":"notes.html#fixed-bugs-and-malfunctions-84"},{"type":"extras","title":"Kernel 6.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- A new function, `logger:update_handler_config/3` is added, and the handler\n  callback `changing_config` now has a new argument, `SetOrUpdate`, which\n  indicates if the configuration change comes from `set_handler_config/2,3` or\n  `update_handler_config/2,3`.\n\n  This allows the handler to consistently merge the new configuration with the\n  old (if the change comes from `update_handler_config/2,3`) or with the default\n  (if the change comes from `set_handler_config/2,3`).\n\n  The built-in handlers `logger_std_h` and `logger_disk_log_h` are updated\n  accordingly. A bug which could cause inconsistency between the handlers'\n  internal state and the stored configuration is also corrected.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15364\n\n- Fix fallback when custom erl_epmd client does not implement address_please.\n\n  Own Id: OTP-15388 Aux Id: PR-1983\n\n- The logger ets table did not have the `read_concurrency` option. This is now\n  added.\n\n  Own Id: OTP-15453 Aux Id: ERL-782\n\n- During system start, logger has a simple handler which prints to stdout. After\n  the kernel supervision is started, this handler is removed and replaced by the\n  default handler. Due to a bug, logger earlier issued a debug printout saying\n  it received an unexpected message, which was the EXIT message from the simple\n  handler's process. This is now corrected. The simple handler's process now\n  unlinks from the logger process before terminating.\n\n  Own Id: OTP-15466 Aux Id: ERL-788\n\n- The logger handler `logger_std_h` would not re-create it's log file if it was\n  removed. Due to this it could not be used with tools like 'logrotate'. This is\n  now corrected.\n\n  Own Id: OTP-15469","ref":"notes.html#fixed-bugs-and-malfunctions-85"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- A function `inet:getifaddrs/1` that takes a list with a namespace option has\n  been added, for platforms that support that feature, for example Linux\n  (only?).\n\n  Own Id: OTP-15121 Aux Id: ERIERL-189, PR-1974\n\n- Added the `nopush` option for TCP sockets, which corresponds to `TCP_NOPUSH`\n  on \\*BSD and `TCP_CORK` on Linux.\n\n  This is also used internally in `file:sendfile` to reduce latency on\n  subsequent send operations.\n\n  Own Id: OTP-15357 Aux Id: ERL-698\n\n- Optimize handling of send_delay for tcp sockes to better work with the new\n  pollthread implementation introduced in OTP-21.\n\n  Own Id: OTP-15471 Aux Id: ERIERL-229","ref":"notes.html#improvements-and-new-features-29"},{"type":"extras","title":"Kernel 6.1.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix bug causing net_kernel process crash on connection attempt from node with\n  name identical to local node.\n\n  Own Id: OTP-15438 Aux Id: ERL-781","ref":"notes.html#fixed-bugs-and-malfunctions-86"},{"type":"extras","title":"Kernel 6.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The values `all` and `none` are documented as valid value for the Kernel\n  configuration parameter `logger_level`, but would cause a crash during node\n  start. This is now corrected.\n\n  Own Id: OTP-15143\n\n- Fix some potential buggy behavior in how ticks are sent on inter node\n  distribution connections. Tick is now sent to c-node even if there are unsent\n  buffered data, as c-nodes need ticks in order to send reply ticks. The amount\n  of sent data was also calculated wrongly when ticks were suppressed due to\n  unsent buffered data.\n\n  Own Id: OTP-15162 Aux Id: ERIERL-191\n\n- Non semantic change in dist_util.erl to silence dialyzer warning.\n\n  Own Id: OTP-15170\n\n- Fixed `net_kernel:connect_node(node())` to return `true` (and do nothing) as\n  it always has before OTP-21.0. Also documented this successful \"self connect\"\n  as the expected behavior.\n\n  Own Id: OTP-15182 Aux Id: ERL-643\n\n- The single_line option on logger_formatter would in some cases add an unwanted\n  comma after the association arrows in a map. This is now corrected.\n\n  Own Id: OTP-15228\n\n- Improved robustness of distribution connection setup. In OTP-21.0 a truly\n  asynchronous connection setup was introduced. This is further improvement on\n  that work to make the emulator more robust and also be able to recover in\n  cases when involved Erlang processes misbehave.\n\n  Own Id: OTP-15297 Aux Id: OTP-15279, OTP-15280","ref":"notes.html#fixed-bugs-and-malfunctions-87"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- A new macro, `?LOG(Level,...)`, is added. This is equivalent to the existing\n  `?LOG_ (...)` macros.\n\n  A new variant of Logger report callback is added, which takes an extra\n  argument containing options for size limiting and line breaks. Module\n  `proc_lib` in `STDLIB` uses this for crash reports.\n\n  Logger configuration is now checked a bit more for errors.\n\n  Own Id: OTP-15132\n\n- The socket options `recvtos`, `recvttl`, `recvtclass` and `pktoptions` have\n  been implemented in the socket modules. See the documentation for the\n  `gen_tcp`, `gen_udp` and `inet` modules. Note that support for these in the\n  runtime system is platform dependent. Especially for `pktoptions` which is\n  very Linux specific and obsoleted by the RFCs that defined it.\n\n  Own Id: OTP-15145 Aux Id: ERIERL-187\n\n- Add `logger:set_application_level/2` for setting the logger level of all\n  modules in one application.\n\n  Own Id: OTP-15146","ref":"notes.html#improvements-and-new-features-30"},{"type":"extras","title":"Kernel 6.0.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fixed bug in `net_kernel` that could cause an emulator crash if certain\n  connection attempts failed. Bug exists since kernel-6.0 (OTP-21.0).\n\n  Own Id: OTP-15280 Aux Id: ERIERL-226, OTP-15279","ref":"notes.html#fixed-bugs-and-malfunctions-88"},{"type":"extras","title":"Kernel 6.0 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-6-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Clarify the documentation of `rpc:multicall/5`.\n\n  Own Id: OTP-10551\n\n- The DNS resolver when getting econnrefused from a server retained an invalid\n  socket so look up towards the next server(s) also failed.\n\n  Own Id: OTP-13133 Aux Id: PR-1557\n\n- No resolver backend returns V4Mapped IPv6 addresses any more. This was\n  inconsistent before, some did, some did not. To facilitate working with such\n  addresses a new function `inet:ipv4_mapped_ipv6_address/1` has been added.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13761 Aux Id: ERL-503\n\n- The type specifications for [`file:posix/0`](`t:file:posix/0`) and\n  [`inet:posix/0`](`t:inet:posix/0`) have been updated according to which errors\n  file and socket operations should be able to return.\n\n  Own Id: OTP-14019 Aux Id: ERL-550\n\n- Fix name resolving in IPv6 only environments when doing the initial\n  distributed connection.\n\n  Own Id: OTP-14501\n\n- File operations used to accept [filenames](`t:file:name_all/0`) containing\n  null characters (integer value zero). This caused the name to be truncated and\n  in some cases arguments to primitive operations to be mixed up. Filenames\n  containing null characters inside the filename are now _rejected_ and will\n  cause primitive file operations to fail.\n\n  Also environment variable operations used to accept\n  [names](`t:os:env_var_name/0`) and [values](`t:os:env_var_value/0`) of\n  environment variables containing null characters (integer value zero). This\n  caused operations to silently produce erroneous results. Environment variable\n  names and values containing null characters inside the name or value are now\n  _rejected_ and will cause environment variable operations to fail.\n\n  Primitive environment variable operations also used to accept the `$=`\n  character in environment variable names causing various problems. `$=`\n  characters in environment variable names are now also _rejected_.\n\n  Also `os:cmd/1` now reject null characters inside its\n  [command](`t:os:os_command/0`).\n\n  `erlang:open_port/2` will also reject null characters inside the port name\n  from now on.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14543 Aux Id: ERL-370\n\n- `os:putenv` and `os:getenv` no longer access the process environment directly\n  and instead work on a thread-safe emulation. The only observable difference is\n  that it's _not_ kept in sync with libc `getenv(3)` / `putenv(3)`, so those who\n  relied on that behavior in drivers or NIFs will need to add manual\n  synchronization.\n\n  On Windows this means that you can no longer resolve DLL dependencies by\n  modifying the `PATH` just before loading the driver/NIF. To make this less of\n  a problem, the emulator now adds the target DLL's folder to the DLL search\n  path.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14666\n\n- Fixed connection tick toward primitive hidden nodes (erl_interface) that could\n  cause faulty tick timeout in rare cases when payload data is sent to hidden\n  node but not received.\n\n  Own Id: OTP-14681\n\n- Make group react immediately on an EXIT-signal from shell in e.g ssh.\n\n  Own Id: OTP-14991 Aux Id: PR1705\n\n- Calls to `gen_tcp:send/2` on closed sockets now returns `{error, closed}`\n  instead of `{error,enotconn}`.\n\n  Own Id: OTP-15001\n\n- The `included_applications` key are no longer duplicated as application\n  environment variable. Earlier, the included applications could be read both\n  with `application:get[_all]_env(...)` and `application:get[_all]_key(...)`\n  functions. Now, it can only be read with `application:get[_all]_key(...)`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15071\n\n- Owner and group changes through `file:write_file_info`, `file:change_owner`,\n  and `file:change_group` will no longer report success on permission errors.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15118","ref":"notes.html#fixed-bugs-and-malfunctions-89"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- A new logging API is added to Erlang/OTP, see the `m:logger` manual page, and\n  section [Logging](logger_chapter.md) in the Kernel User's Guide.\n\n  Calls to `error_logger` are automatically redirected to the new API, and\n  legacy error logger event handlers can still be used. It is, however,\n  recommended to use the Logger API directly when writing new code.\n\n  Notice the following potential incompatibilities:\n\n  - Kernel configuration parameters `error_logger` still works, but is overruled\n    if the default handler's output destination is configured with Kernel\n    configuration parameter `logger`.\n\n    In general, parameters for configuring error logger are overwritten by new\n    parameters for configuring Logger.\n\n  - The concept of SASL error logging is deprecated, meaning that by default the\n    SASL application does not affect which log events are logged.\n\n    By default, supervisor reports and crash reports are logged by the default\n    Logger handler started by Kernel, and end up at the same destination\n    (terminal or file) as other standard log event from Erlang/OTP.\n\n    Progress reports are not logged by default, but can be enabled by setting\n    the primary log level to info, for example with the Kernel configuration\n    parameter `logger_level`.\n\n    To obtain backwards compatibility with the SASL error logging functionality\n    from earlier releases, set Kernel configuration parameter\n    `logger_sasl_compatible` to `true`. This prevents the default Logger handler\n    from logging any supervisor-, crash-, or progress reports. Instead, SASL\n    adds a separate Logger handler during application start, which takes care of\n    these log events. The SASL configuration parameters `sasl_error_logger` and\n    `sasl_errlog_type` specify the destination (terminal or file) and severity\n    level to log for these events.\n\n  Since Logger is new in Erlang/OTP 21.0, we do reserve the right to introduce\n  changes to the Logger API and functionality in patches following this release.\n  These changes might or might not be backwards compatible with the initial\n  version.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13295\n\n- The function `inet:i/0` has been documented.\n\n  Own Id: OTP-13713 Aux Id: PR-1645\n\n- Typespecs for `netns` and `bind_to_device` options have been added to\n  `gen_tcp`, `gen_udp` and `gen_sctp` functions.\n\n  Own Id: OTP-14359 Aux Id: PR-1816\n\n- New functionality for implementation of alternative carriers for the Erlang\n  distribution has been introduced. This mainly consists of support for usage of\n  distribution controller processes (previously only ports could be used as\n  distribution controllers). For more information see\n  [ERTS User's Guide ➜ How to implement an Alternative Carrier for the Erlang Distribution ➜ Distribution Module](`e:erts:alt_dist.md#distribution-module`).\n\n  Own Id: OTP-14459\n\n- `seq_trace` labels may now be any erlang term.\n\n  Own Id: OTP-14899\n\n- The SSL distribution protocol `-proto inet_tls` has stopped setting the SSL\n  option `server_name_indication`. New verify funs for client and server in\n  `inet_tls_dist` has been added, not documented yet, that checks node name if\n  present in peer certificate. Usage is still also yet to be documented.\n\n  Own Id: OTP-14969 Aux Id: OTP-14465, ERL-598\n\n- Changed timeout of `gen_server` calls to `auth` server from default 5 seconds\n  to `infinity`.\n\n  Own Id: OTP-15009 Aux Id: ERL-601\n\n- The callback module passed as `-epmd_module` to erl has been expanded to be\n  able to do name and port resolving.\n\n  Documentation has also been added in the `m:erl_epmd` reference manual and\n  ERTS User's Guide\n  [How to Implement an Alternative Node Discovery for Erlang Distribution](`e:erts:alt_disco.md`).\n\n  Own Id: OTP-15086 Aux Id: PR-1694\n\n- Included config file specified with relative path in sys.config are now first\n  searched for relative to the directory of sys.config itself. If not found, it\n  is also searched for relative to the current working directory. The latter is\n  for backwards compatibility.\n\n  Own Id: OTP-15137 Aux Id: PR-1838","ref":"notes.html#improvements-and-new-features-31"},{"type":"extras","title":"Kernel 5.4.3.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-5-4-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Non semantic change in dist_util.erl to silence dialyzer warning.\n\n  Own Id: OTP-15170","ref":"notes.html#fixed-bugs-and-malfunctions-90"},{"type":"extras","title":"Kernel 5.4.3.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-5-4-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix some potential buggy behavior in how ticks are sent on inter node\n  distribution connections. Tick is now sent to c-node even if there are unsent\n  buffered data, as c-nodes need ticks in order to send reply ticks. The amount\n  of sent data was calculated wrongly when ticks where suppressed due to unsent\n  buffered data.\n\n  Own Id: OTP-15162 Aux Id: ERIERL-191","ref":"notes.html#fixed-bugs-and-malfunctions-91"},{"type":"extras","title":"Kernel 5.4.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-5-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Correct a few contracts.\n\n  Own Id: OTP-14889\n\n- Reject loading modules with names containing directory separators ('/' or '\\\\'\n  on Windows).\n\n  Own Id: OTP-14933 Aux Id: ERL-564, PR-1716\n\n- Fix bug in handling of os:cmd/2 option max_size on windows.\n\n  Own Id: OTP-14940","ref":"notes.html#fixed-bugs-and-malfunctions-92"},{"type":"extras","title":"Kernel 5.4.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-5-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Add `os:cmd/2` that takes an options map as the second argument.\n\n  Add `max_size` as an option to `os:cmd/2` that control the maximum size of the\n  result that `os:cmd/2` will return.\n\n  Own Id: OTP-14823","ref":"notes.html#fixed-bugs-and-malfunctions-93"},{"type":"extras","title":"Kernel 5.4.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-5-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Refactored an internal API.\n\n  Own Id: OTP-14784","ref":"notes.html#fixed-bugs-and-malfunctions-94"},{"type":"extras","title":"Kernel 5.4 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-5-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Processes which did output after switching jobs (Ctrl+G) could be left forever\n  stuck in the io request.\n\n  Own Id: OTP-14571 Aux Id: ERL-472","ref":"notes.html#fixed-bugs-and-malfunctions-95"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Lock counting can now be fully toggled at runtime in the lock counting\n  emulator (`-emu_type lcnt`). Everything is enabled by default to match the old\n  behavior, but specific categories can be toggled at will with minimal runtime\n  overhead when disabled. Refer to the documentation on `lcnt:rt_mask/1` for\n  details.\n\n  Own Id: OTP-13170\n\n- `lcnt:collect` and `lcnt:clear` will no longer block all other threads in the\n  runtime system.\n\n  Own Id: OTP-14412\n\n- General Unicode improvements.\n\n  Own Id: OTP-14462","ref":"notes.html#improvements-and-new-features-32"},{"type":"extras","title":"Kernel 5.3.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-5-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The documentation for the 'quiet' option in disk_log:open/1 had an incorrect\n  default value.\n\n  Own Id: OTP-14498","ref":"notes.html#fixed-bugs-and-malfunctions-96"},{"type":"extras","title":"Kernel 5.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Function `inet:ntoa/1` has been fixed to return lowercase letters according to\n  RFC 5935 that has been approved after this function was written. Previously\n  uppercase letters were returned so this may be a backwards incompatible change\n  depending on how the returned address string is used.\n\n  Function `inet:parse_address/1` has been fixed to accept %-suffixes on scoped\n  addresses. The addresses does not work yet, but gives no parse errors.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13006 Aux Id: ERIERL-20, ERL-429\n\n- Fix bug where gethostname would incorrectly fail with enametoolong on Linux.\n\n  Own Id: OTP-14310\n\n- Fix bug causing `code:is_module_native` to falsely return true when `local`\n  call trace is enabled for the module.\n\n  Own Id: OTP-14390\n\n- Add early reject of invalid node names from distributed nodes.\n\n  Own Id: OTP-14426","ref":"notes.html#fixed-bugs-and-malfunctions-97"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Since Unicode is now allowed in atoms an extra check is needed for node names,\n  which are restricted to Latin-1.\n\n  Own Id: OTP-13805\n\n- Replaced usage of deprecated symbolic [`time unit`](`t:erlang:time_unit/0`)\n  representations.\n\n  Own Id: OTP-13831 Aux Id: OTP-13735\n\n- `file:write_file(Name, Data, [raw])` would turn `Data` into a single binary\n  before writing. This meant it could not take advantage of the `writev()`\n  system call if it was given a list of binaries and told to write with `raw`\n  mode.\n\n  Own Id: OTP-13909\n\n- The performance of the `disk_log` has been somewhat improved in some corner\n  cases (big items), and the documentation has been clarified.\n\n  Own Id: OTP-14057 Aux Id: PR-1245\n\n- Functions for detecting changed code has been added. `code:modified_modules/0`\n  returns all currently loaded modules that have changed on disk.\n  `code:module_status/1` returns the status for a module. In the shell and in\n  `c` module, `mm/0` is short for `code:modified_modules/0`, and `lm/0` reloads\n  all currently loaded modules that have changed on disk.\n\n  Own Id: OTP-14059\n\n- Introduce an event manager in Erlang to handle OS signals. A subset of OS\n  signals may be subscribed to and those are described in the Kernel\n  application.\n\n  Own Id: OTP-14186\n\n- Sockets can now be bound to device (SO_BINDTODEVICE) on platforms where it is\n  supported.\n\n  This has been implemented e.g to support VRF-Lite under Linux; see\n  [VRF ](https://www.kernel.org/doc/Documentation/networking/vrf.txt), and\n  GitHub pull request [\\#1326](https://github.com/erlang/otp/pull/1326).\n\n  Own Id: OTP-14357 Aux Id: PR-1326\n\n- Added option to store shell_history on disk so that the history can be reused\n  between sessions.\n\n  Own Id: OTP-14409 Aux Id: PR-1420\n\n- The size of crash reports created by `gen_server`, `gen_statem` and `proc_lib`\n  is limited with aid of the Kernel application variable\n  `error_logger_format_depth`. The purpose is to limit the size of the messages\n  sent to the `error_logger` process when processes with huge message queues or\n  states crash.\n\n  The crash report generated by `proc_lib` includes the new tag\n  `message_queue_len`. The neighbour report also includes the new tag\n  `current_stacktrace`. Finally, the neighbour report no longer includes the\n  tags `messages` and `dictionary`.\n\n  The new function `error_logger:get_format_depth/0` can be used to retrieve the\n  value of the Kernel application variable `error_logger_format_depth`.\n\n  Own Id: OTP-14417\n\n- One of the ETS tables used by the `global` module is created with\n  `{read_concurrency, true}` in order to reduce contention.\n\n  Own Id: OTP-14419\n\n- Warnings have been added to the relevant documentation about not using\n  un-secure distributed nodes in exposed environments.\n\n  Own Id: OTP-14425","ref":"notes.html#improvements-and-new-features-33"},{"type":"extras","title":"Kernel 5.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix a race during cleanup of os:cmd that would cause os:cmd to hang\n  indefinitely.\n\n  Own Id: OTP-14232 Aux Id: seq13275","ref":"notes.html#fixed-bugs-and-malfunctions-98"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- The functions in the '`file`' module that take a list of paths (e.g.\n  `file:path_consult/2`) will now continue to search in the path if the path\n  contains something that is not a directory.\n\n  Own Id: OTP-14191\n\n- Two OTP processes that are known to receive many messages are 'rex' (used by\n  'rpc') and 'error_logger'. Those processes will now store unprocessed messages\n  outside the process heap, which will potentially decrease the cost of garbage\n  collections.\n\n  Own Id: OTP-14192","ref":"notes.html#improvements-and-new-features-34"},{"type":"extras","title":"Kernel 5.1.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-5-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- `code:add_pathsa/1` and command line option `-pa` both revert the given list\n  of directories when adding it at the beginning of the code path. This is now\n  documented.\n\n  Own Id: OTP-13920 Aux Id: ERL-267\n\n- Add lost runtime dependency to erts-8.1. This should have been done in\n  kernel-5.1 (OTP-19.1) as it cannot run without at least erts-8.1 (OTP-19.1).\n\n  Own Id: OTP-14003\n\n- Type and doc for gen\\_\\{tcp,udp,sctp\\}:controlling_process/2 has been\n  improved.\n\n  Own Id: OTP-14022 Aux Id: PR-1208","ref":"notes.html#fixed-bugs-and-malfunctions-99"},{"type":"extras","title":"Kernel 5.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix a memory leak when calling seq_trace:get_system_tracer().\n\n  Own Id: OTP-13742\n\n- Fix for the problem that when adding the ebin directory of an application to\n  the code path, the `code:priv_dir/1` function returns an incorrect path to the\n  priv directory of the same application.\n\n  Own Id: OTP-13758 Aux Id: ERL-195\n\n- Fix code_server crash when adding code paths of two levels.\n\n  Own Id: OTP-13765 Aux Id: ERL-194\n\n- Respect -proto_dist switch while connection to EPMD\n\n  Own Id: OTP-13770 Aux Id: PR-1129\n\n- Fixed a bug where init:stop could deadlock if a process with infinite shutdown\n  timeout (e.g. a supervisor) attempted to load code while terminating.\n\n  Own Id: OTP-13802\n\n- Close stdin of commands run in os:cmd. This is a backwards compatibility fix\n  that restores the behaviour of pre 19.0 os:cmd.\n\n  Own Id: OTP-13867 Aux Id: seq13178","ref":"notes.html#fixed-bugs-and-malfunctions-100"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Add `net_kernel:setopts/2` and `net_kernel:getopts/2` to control options for\n  distribution sockets in runtime.\n\n  Own Id: OTP-13564\n\n- Rudimentary support for DSCP has been implemented in the guise of a `tclass`\n  socket option for IPv6 sockets.\n\n  Own Id: OTP-13582","ref":"notes.html#improvements-and-new-features-35"},{"type":"extras","title":"Kernel 5.0.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-5-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- When calling os:cmd from a process that has set trap_exit to true an 'EXIT'\n  message would be left in the message queue. This bug was introduced in kernel\n  vsn 5.0.1.\n\n  Own Id: OTP-13813","ref":"notes.html#fixed-bugs-and-malfunctions-101"},{"type":"extras","title":"Kernel 5.0.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-5-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix a os:cmd bug where creating a background job using & would cause os:cmd to\n  hang until the background job terminated or closed its stdout and stderr file\n  descriptors. This bug has existed from kernel 5.0.\n\n  Own Id: OTP-13741","ref":"notes.html#fixed-bugs-and-malfunctions-102"},{"type":"extras","title":"Kernel 5.0 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-5-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The handling of `on_load` functions has been improved. The major improvement\n  is that if a code upgrade fails because the `on_load` function fails, the\n  previous version of the module will now be retained.\n\n  Own Id: OTP-12593\n\n- `rpc:call()` and `rpc:block_call()` would sometimes cause an exception (which\n  was not mentioned in the documentation). This has been corrected so that\n  `{badrpc,Reason}` will be returned instead.\n\n  Own Id: OTP-13409\n\n- On Windows, for modules that were loaded early (such as the `lists` module),\n  `code:which/1` would return the path with mixed slashes and backslashes, for\n  example: `\"C:\\\\Program Files\\\\erl8.0/lib/stdlib-2.7/ebin/lists.beam\"`. This\n  has been corrected.\n\n  Own Id: OTP-13410\n\n- Make file:datasync use fsync instead of fdatasync on Mac OSX.\n\n  Own Id: OTP-13411\n\n- The default chunk size for the fallback sendfile implementation, used on\n  platforms that do not have a native sendfile, has been decreased in order to\n  reduce connectivity issues.\n\n  Own Id: OTP-13444\n\n- Large file writes (2Gb or more) could fail on some Unix platforms (for\n  example, OS X and FreeBSD).\n\n  Own Id: OTP-13461\n\n- A bug has been fixed where the DNS resolver inet_res did not refresh its view\n  of the contents of for example resolv.conf immediately after start and hence\n  then failed name resolution. Reported and fix suggested by Michal Ptaszek in\n  GitHUB pull req #949.\n\n  Own Id: OTP-13470 Aux Id: Pull #969\n\n- Fix process leak from global_group.\n\n  Own Id: OTP-13516 Aux Id: PR-1008\n\n- The function `inet:gethostbyname/1` now honors the resolver option `inet6`\n  instead of always looking up IPv4 addresses.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13622 Aux Id: PR-1065\n\n- The `Status` argument to `init:stop/1` is now sanity checked to make sure\n  `erlang:halt` does not fail.\n\n  Own Id: OTP-13631 Aux Id: PR-911","ref":"notes.html#fixed-bugs-and-malfunctions-103"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Add \\{line_delim, byte()\\} option to inet:setopts/2 and decode_packet/3\n\n  Own Id: OTP-12837\n\n- Added `os:perf_counter/1`.\n\n  The perf_counter is a very very cheap and high resolution timer that can be\n  used to timestamp system events. It does not have monoticity guarantees, but\n  should on most OS's expose a monotonous time.\n\n  Own Id: OTP-12908\n\n- The os:cmd call has been optimized on unix platforms to be scale better with\n  the number of schedulers.\n\n  Own Id: OTP-13089\n\n- New functions that can load multiple modules at once have been added to the\n  '`code`' module. The functions are `code:atomic_load/1`,\n  `code:prepare_loading/1`, `code:finish_loading/1`, and\n  `code:ensure_modules_loaded/1`.\n\n  Own Id: OTP-13111\n\n- The code path cache feature turned out not to be very useful in practice and\n  has been removed. If an attempt is made to enable the code path cache, there\n  will be a warning report informing the user that the feature has been removed.\n\n  Own Id: OTP-13191\n\n- When an attempt is made to start a distributed Erlang node with the same name\n  as an existing node, the error message will be much shorter and easier to read\n  than before. Example:\n\n  `Protocol 'inet_tcp': the name somename@somehost seems to be in use by another Erlang node`\n\n  Own Id: OTP-13294\n\n- The output of the default error logger is somewhat prettier and easier to\n  read. The default error logger is used during start-up of the OTP system. If\n  the start-up fails, the output will be easier to read.\n\n  Own Id: OTP-13325\n\n- The functions `rpc:safe_multi_server_call/2,3` that were deprecated in R12B\n  have been removed.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13449\n\n- Update the error reasons in dist_util, and show them in the logs if\n  net_kernel:verbose(1) has been called.\n\n  Own Id: OTP-13458\n\n- Experimental support for Unix Domain Sockets has been implemented. Read the\n  sources if you want to try it out. Example:\n  `gen_udp:open(0, [{ifaddr,{local,\"/tmp/socket\"}}])`. Documentation will be\n  written after user feedback on the experimental API.\n\n  Own Id: OTP-13572 Aux Id: PR-612\n\n- Allow heart to be configured to not kill the previous emulator before calling\n  the HEART_COMMAND. This is done by setting the environment variable\n  HEART_NO_KILL to TRUE.\n\n  Own Id: OTP-13650","ref":"notes.html#improvements-and-new-features-36"},{"type":"extras","title":"Kernel 4.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- `code:load_abs([10100])` would bring down the entire runtime system and create\n  a crash dump. Corrected to generate an error exception in the calling process.\n\n  Also corrected specs for code loading functions and added more information in\n  the documentation about the error reasons returned by code-loading functions.\n\n  Own Id: OTP-9375\n\n- `gen_tcp:accept/2` was not\n  [time warp safe](`e:erts:time_correction.md#time-warp-safe-code`). This since\n  it used the same time as returned by `erlang:now/0` when calculating timeout.\n  This has now been fixed.\n\n  Own Id: OTP-13254 Aux Id: OTP-11997, OTP-13222\n\n- Correct the contract for `inet:getifaddrs/1`.\n\n  Own Id: OTP-13335 Aux Id: ERL-95","ref":"notes.html#fixed-bugs-and-malfunctions-104"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Time warp safety improvements.\n\n  Introduced the options `monotonic_timestamp`, and `strict_monotonic_timestamp`\n  to the trace, sequential trace, and system profile functionality. This since\n  the already existing `timestamp` option is not time warp safe.\n\n  Introduced the option `safe_fixed_monotonic_time` to `ets:info/2` and\n  `dets:info/2`. This since the already existing `safe_fixed` option is not time\n  warp safe.\n\n  Own Id: OTP-13222 Aux Id: OTP-11997\n\n- Add validation callback for heart\n\n  The erlang heart process may now have a validation callback installed. The\n  validation callback will be executed, if present, before any heartbeat to\n  heart port program. If the validation fails, or stalls, no heartbeat will be\n  sent and the node will go down.\n\n  With the option `'check_schedulers'` heart executes a responsiveness check of\n  the schedulers before a heartbeat is sent to the port program. If the\n  responsiveness check fails, the heartbeat will not be performed (as intended).\n\n  Own Id: OTP-13250\n\n- Clarify documentation of `net_kernel:allow/1`\n\n  Own Id: OTP-13299\n\n- EPMD supports both IPv4 and IPv6\n\n  Also affects oldest supported windows version.\n\n  Own Id: OTP-13364","ref":"notes.html#improvements-and-new-features-37"},{"type":"extras","title":"Kernel 4.1.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-4-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Host name lookups though inet_res, the Erlang DNS resolver, are now done case\n  insensitively according to RFC 4343. Patch by Holger Weiß.\n\n  Own Id: OTP-12836\n\n- IPv6 distribution handler has been updated to share code with IPv4 so that all\n  features are supported in IPv6 as well. A bug when using an IPv4 address as\n  hostname has been fixed.\n\n  Own Id: OTP-13040\n\n- Caching of host names in the internal DNS resolver inet_res has been made\n  character case insensitive for host names according to RFC 4343.\n\n  Own Id: OTP-13083\n\n- Cooked file mode buffering has been fixed so file:position/2 now works\n  according to Posix on Posix systems i.e. when file:position/2 returns an error\n  the file pointer is unaffected.\n\n  The Windows system documentation, however, is unclear on this point so the\n  documentation of file:position/2 still does not promise anything.\n\n  Cooked file mode file:pread/2,3 and file:pwrite/2,3 have been corrected to\n  honor character encoding like the combination of file:position/2 and\n  file:read/2 or file:write/2 already does. This is probably not very useful\n  since the character representation on the caller's side is latin1, period.\n\n  Own Id: OTP-13155 Aux Id: PR#646","ref":"notes.html#fixed-bugs-and-malfunctions-105"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Add \\{line_delim, byte()\\} option to inet:setopts/2 and decode_packet/3\n\n  Own Id: OTP-12837","ref":"notes.html#improvements-and-new-features-38"},{"type":"extras","title":"Kernel 4.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-4-1"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- A mechanism for limiting the amount of text that the built-in error logger\n  events will produce has been introduced. It is useful for limiting both the\n  size of log files and the CPU time used to produce them.\n\n  This mechanism is experimental in the sense that it may be changed if it turns\n  out that it does not solve the problem it is supposed to solve. In that case,\n  there may be backward incompatible improvements to this mechanism.\n\n  See the documentation for the config parameter `error_logger_format_depth` in\n  the Kernel application for information about how to turn on this feature.\n\n  Own Id: OTP-12864","ref":"notes.html#improvements-and-new-features-39"},{"type":"extras","title":"Kernel 4.0 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-4-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Fix error handling in `file:read_line/1` for Unicode contents.\n\n  Own Id: OTP-12144\n\n- Introduce `os:getenv/2` which is similar to `os:getenv/1` but returns the\n  passed default value if the required environment variable is undefined.\n\n  Own Id: OTP-12342\n\n- It is now possible to paste text in JCL mode (using Ctrl-Y) that has been\n  copied in the previous shell session. Also a bug that caused the JCL mode to\n  crash when pasting text has been fixed.\n\n  Own Id: OTP-12673\n\n- Ensure that each segment of an IPv6 address when parsed from a string has a\n  maximum of 4 hex digits\n\n  Own Id: OTP-12773","ref":"notes.html#fixed-bugs-and-malfunctions-106"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- New BIF: `erlang:get_keys/0`, lists all keys associated with the process\n  dictionary. Note: `erlang:get_keys/0` is auto-imported.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12151 Aux Id: seq12521\n\n- The internal group to user_drv protocol has been changed to be synchronous in\n  order to guarantee that output sent to a process implementing the user_drv\n  protocol is printed before replying. This protocol is used by the\n  standard_output device and the ssh application when acting as a client.\n\n  This change changes the previous unlimited buffer when printing to standard_io\n  and other devices that end up in user_drv to 1KB.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12240\n\n- The `inflateInit/2` and `deflateInit/6` functions now accepts a WindowBits\n  argument equal to 8 and -8.\n\n  Own Id: OTP-12564\n\n- Map error logger warnings to warning messages by default.\n\n  Own Id: OTP-12755\n\n- Map beam error logger warnings to warning messages by default. Previously\n  these messages were mapped to the error channel by default.\n\n  Own Id: OTP-12781\n\n- gen_tcp:shutdown/2 is now asynchronous\n\n  This solves the following problems with the old implementation:\n\n  It doesn't block when the TCP peer is idle or slow. This is the expected\n  behaviour when shutdown() is called: the caller needs to be able to continue\n  reading from the socket, not be prevented from doing so.\n\n  It doesn't truncate the output. The current version of gen_tcp:shutdown/2 will\n  truncate any outbound data in the driver queue after about 10 seconds if the\n  TCP peer is idle of slow. Worse yet, it doesn't even inform anyone that the\n  data has been truncated: 'ok' is returned to the caller; and a FIN rather than\n  an RST is sent to the TCP peer.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12797\n\n- There are many cases where user code needs to be able to distinguish between a\n  socket that was closed normally and one that was aborted. Setting the option\n  \\{show_econnreset, true\\} enables the user to receive ECONNRESET errors on\n  both active and passive sockets.\n\n  Own Id: OTP-12843","ref":"notes.html#improvements-and-new-features-40"},{"type":"extras","title":"Kernel 3.2.0.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-3-2-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- The 'raw' socket option could not be used multiple times in one call to any\n  e.g gen_tcp function because only one of the occurrences were used. This bug\n  has been fixed, and also a small bug concerning propagating error codes from\n  within inet:setopts/2.\n\n  Own Id: OTP-11482 Aux Id: seq12872","ref":"notes.html#fixed-bugs-and-malfunctions-107"},{"type":"extras","title":"Kernel 3.2 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- A bug causing an infinite loop in hostname resolving has been corrected. To\n  trigger this bug you would have to enter an bogus search method from a\n  configuration file e.g .inetrc.\n\n  Bug pinpointed by Emil Holmström\n\n  Own Id: OTP-12133\n\n- The standard_error process now handles the getopts I/O protocol request\n  correctly and stores its encoding in the same way as standard_io.\n\n  Also, io:put_chars(standard_error, \\[oops]) could previously crash the\n  standard_error process. This is now corrected.\n\n  Own Id: OTP-12424","ref":"notes.html#fixed-bugs-and-malfunctions-108"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Configuration parameters for the Kernel application that allows setting socket\n  options for the distribution sockets have been added. See the application\n  Kernel documentation; parameters 'inet_dist_listen_options' and\n  'inet_dist_connect_options'.\n\n  Own Id: OTP-12476 Aux Id: OTP-12476","ref":"notes.html#improvements-and-new-features-41"},{"type":"extras","title":"Kernel 3.1 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Make sure to install .hrl files when needed\n\n  Own Id: OTP-12197\n\n- Removed the undocumented application environment variable 'raw_files' from the\n  kernel application. This variable was checked (by call to\n  application:get_env/2) each time a raw file was to be opened in the file\n  module.\n\n  Own Id: OTP-12276\n\n- A bug has been fixed when using the netns option to gen_udp, which\n  accidentally only worked if it was the last option.\n\n  Own Id: OTP-12314","ref":"notes.html#fixed-bugs-and-malfunctions-109"},{"type":"extras","title":"Improvements and New Features - Kernel Release Notes","doc":"- Updated documentation for inet buffer size options.\n\n  Own Id: OTP-12296\n\n- Introduce new option 'raw' in file_info and link_info functions. This option\n  allows the caller not to go through the file server for information about\n  files guaranteed to be local.\n\n  Own Id: OTP-12325","ref":"notes.html#improvements-and-new-features-42"},{"type":"extras","title":"Kernel 3.0.3 - Kernel Release Notes","doc":"","ref":"notes.html#kernel-3-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Kernel Release Notes","doc":"- Accept inet:ip_address() in net_adm:names/1\n\n  Own Id: OTP-12154","ref":"notes.html#fixed-bugs-and-malfunctions-110"},{"type":"extras","title":"Kernel 3.0.2 - Kernel Release Notes","doc":"","ref":"notes.html#k