// Copyright 2023-2024 Gentoo Authors
// Distributed under the terms of the GNU General Public License v2

namespace Gdmt.Sync.Runners

module Pkgcheck =
    open SimpleLog.SimpleLog

    open Gdmt.Shared

    let RunPkgcheckScan () : unit =
        let pkgcheckArgs = [ "pkgcheck"; "scan"; "--commits"; "--exit=error" ]

        LogMessage Debug $"Scanning with pkgcheck"
        ExecProcess(pkgcheckArgs).Run().Check()
        LogMessage Success "Scan succeeded"
