# Changelog 0.5.x

## 0.5.0

Since the launch of Python version, project, and tool management capabilities back in August, we've
seen extraordinary adoption of uv. We've been iterating rapidly: adding new features, fixing bugs,
and improving the user experience. Despite moving quickly, stability and compatibility have been a
major focus — we've made thirty releases since our last breaking change. Consequently, we've
accumulated various changes that improve correctness and user experience, but could break some
workflows. This release contains those changes; many have been marked as breaking out of an
abundance of caution. We expect most users to be able to upgrade without making changes.

### Breaking

- **Use base executable to set virtualenv Python path**
  ([#8481](https://github.com/astral-sh/uv/pull/8481))

  Previously, uv canonicalized the path to the Python executable when setting the Python path in
  created virtual environments. This behavior had several undesirable effects: it would bypass
  stabilized version directories (as constructed by Homebrew) and it was not consistent with the
  Python standard library's behavior. Now, uv uses the `sys._base_executable` path.

- **Use XDG (i.e. `~/.local/bin`) instead of the Cargo home directory in the installer**
  ([#8420](https://github.com/astral-sh/uv/pull/8420))

  Previously, uv's installer used `$CARGO_HOME` or `~/.cargo/bin` for its target install directory.
  It's been a longstanding complaint that uv uses this directory, as there's no relationship to
  Cargo. Now, uv will be installed into `$XDG_BIN_HOME`, `$XDG_DATA_HOME/../bin`, or `~/.local/bin`
  (in that order). Note that `$UV_INSTALL_DIR` can always be used to override the target directory.

- **Discover and respect `.python-version` files in parent directories**
  ([#6370](https://github.com/astral-sh/uv/pull/6370))

  Previously, uv only read `.python-version` files from the working directory. Now, uv will check
  parent directories for `.python-version` files; however uv will not search for `.python-version`
  files beyond project boundaries. The new behavior is better aligned with that of `pyenv` and Rye.

- **Error when disallowed settings are defined in `uv.toml`**
  ([#8550](https://github.com/astral-sh/uv/pull/8550))

  Some settings can only be defined in the `pyproject.toml`. Previously, uv would ignore these
  settings when present in the `uv.toml`. Now, uv will error to avoid confusion about why the
  settings are not respected.

- **Implement PEP 440-compliant local version semantics**
  ([#8797](https://github.com/astral-sh/uv/pull/8797))

  Previously, uv's implementation of local versions (e.g., `2.0+cpu`) was not compliant with the
  specification due to the technical complexity of implementing the local version semantics in the
  PubGrub algorithm. Thanks to the work of @ericmarkmartin, uv now has a spec-compliant
  implementation. Namely, uv will now allow a request for `torch==2.1.0` to install
  `torch@2.1.0+cpu` regardless of whether `torch@2.1.0` (without a local tag) actually exists.

- **Treat the base Conda environment as a system environment**
  ([#7691](https://github.com/astral-sh/uv/pull/7691))

  Previously, uv would not distinguish between the base and other Conda environments. Now, uv uses
  `CONDA_DEFAULT_ENV` and the names `base` and `default` to determine if an environment active via
  `CONDA_PREFIX` is the base environment. If the base environment is active, the `--system` flag
  must be used to mutate it.

- **Do not allow pre-releases when the `!=` operator is used**
  ([#7974](https://github.com/astral-sh/uv/pull/7974))

  Previously, uv would use the presence of a pre-release specifier in a version specifier as an
  opt-in to allow pre-release versions during resolution. The new behavior does not allow
  pre-releases when an inequals operator is used, e.g., `!= 2.0a1`.

- **Prefer `USERPROFILE` over `FOLDERID_Profile` when selecting a home directory on Windows**
  ([#8048](https://github.com/astral-sh/uv/pull/8048))

  This change is a side-effect of switching from the `directories` crate to `etcetera` for
  determining canonical system paths. If `USERPROFILE` is not set, the behavior will be unchanged.

- **Improve interactions between color environment variables and CLI options**
  ([#8215](https://github.com/astral-sh/uv/pull/8215))

  Previously, uv would respect the `FORCE_COLOR` and `NO_COLOR` environment variables over the
  `--color` flag. Now, when the `--color` flag is explicitly provided, uv will respect it over the
  environment variables.

- **Make `allow-insecure-host` a global option**
  ([#8476](https://github.com/astral-sh/uv/pull/8476))

  Previously, this option was only available in some parts of uv. Now, `--allow-insecure-host` can
  be provided to any command. For consistency, the `allow-insecure-host` setting has been removed
  from the `[tool.uv.pip]` configuration in favor of `[tool.uv]`.

- **Only write `.python-version` files during `uv init` for workspace members if the version
  differs** ([#8897](https://github.com/astral-sh/uv/pull/8897))

  Previously, uv would create a `.python-version` file for workspace members during `uv init`. Now,
  uv will only do so if the version differs from the `.python-version` file in the workspace root
  since uv will respect `.python-version` files in parent directories.

### Enhancements

- Add `uv tree --outdated` ([#8893](https://github.com/astral-sh/uv/pull/8893))
- Add armv8l alias for armv7l to support arm 32-bit compatibility mode
  ([#8881](https://github.com/astral-sh/uv/pull/8881))
- Add support for `pip list --outdated` ([#8872](https://github.com/astral-sh/uv/pull/8872))
- Allow semicolons directly after direct URLs ([#8836](https://github.com/astral-sh/uv/pull/8836))
- Enable support for arbitrary git transports ([#8769](https://github.com/astral-sh/uv/pull/8769))
- Improve Python discovery source messages ([#8890](https://github.com/astral-sh/uv/pull/8890))
- Show dedicated error for trailing `;` on URL and path requirements
  ([#8835](https://github.com/astral-sh/uv/pull/8835))
- Add progress bar for `uv cache clean` ([#8857](https://github.com/astral-sh/uv/pull/8857))
- Warn on failure to query system configuration file
  ([#8829](https://github.com/astral-sh/uv/pull/8829))

### Preview features

- Add support for building basic source distributions with the experimental uv build backend
  ([#8886](https://github.com/astral-sh/uv/pull/8886))

### Bug fixes

- Respect dynamic version updates in `uv lock` ([#8867](https://github.com/astral-sh/uv/pull/8867))
- Respect fork markers in `--resolution-mode=lowest-direct`
  ([#8839](https://github.com/astral-sh/uv/pull/8839))

### Documentation

- Add further examples of git+https support ([#8841](https://github.com/astral-sh/uv/pull/8841))
- Add installer variables to environment reference
  ([#8874](https://github.com/astral-sh/uv/pull/8874))
- Add note on private classifier ([#8783](https://github.com/astral-sh/uv/pull/8783))
- Update pip-and-uv strictness example ([#8822](https://github.com/astral-sh/uv/pull/8822))
- Fix `uv python install` docs to use an existing PyPy version
  ([#8845](https://github.com/astral-sh/uv/pull/8845))
- Document how to mimic `--verbose` with `RUST_LOG`
  ([#8858](https://github.com/astral-sh/uv/pull/8858))

## 0.5.1

### Enhancements

- Allow installation of manylinux wheels on `riscv64`
  ([#8934](https://github.com/astral-sh/uv/pull/8934))

### Bug fixes

- Build source distributions at top-level of cache
  ([#8905](https://github.com/astral-sh/uv/pull/8905))
- Allow non-registry dependencies in `uv pip list --outdated`
  ([#8939](https://github.com/astral-sh/uv/pull/8939))
- Compute superset of existing and required hashes when healing cache
  ([#8955](https://github.com/astral-sh/uv/pull/8955))
- Enable uv to replace and delete itself on Windows
  ([#8914](https://github.com/astral-sh/uv/pull/8914))
- Remove source distribution filename from cache
  ([#8907](https://github.com/astral-sh/uv/pull/8907))
- Respect `--index-url` in `uv pip list` ([#8942](https://github.com/astral-sh/uv/pull/8942))
- Respect comma-separated extras in `--with` ([#8946](https://github.com/astral-sh/uv/pull/8946))

### Documentation

- Add uninstall note for previous versions ([#8937](https://github.com/astral-sh/uv/pull/8937))
- Remove some missed references to `~/.cargo/bin`
  ([#8936](https://github.com/astral-sh/uv/pull/8936))
- Split README's install code block into 3 ([#8853](https://github.com/astral-sh/uv/pull/8853))

## 0.5.2

### Enhancements

- Hide `--no-system` from `uv pip tree` CLI ([#9040](https://github.com/astral-sh/uv/pull/9040))
- Allow configuration of Python and PyPy install mirrors in `uv.toml`
  ([#8695](https://github.com/astral-sh/uv/pull/8695))
- Allow passing Python download mirrors to `uv python install`
  ([#8695](https://github.com/astral-sh/uv/pull/8695))
- Add support for specifying conflicting extras and dependency groups
  ([#8976](https://github.com/astral-sh/uv/pull/8976),
  [#9096](https://github.com/astral-sh/uv/pull/9096))
- Consistent colon usage in build failure errors
  ([#8994](https://github.com/astral-sh/uv/pull/8994))
- Show full derivation chain when encountering build failures
  ([#9108](https://github.com/astral-sh/uv/pull/9108))
- Show link we failed on parsing index pages ([#9118](https://github.com/astral-sh/uv/pull/9118))
- Remove duplicate log when searching for interpreters
  ([#9092](https://github.com/astral-sh/uv/pull/9092))
- Update uv development status classifier to "Stable" on PyPI
  ([#8943](https://github.com/astral-sh/uv/pull/8943))
- Use rich diagnostic formatting for early build failures
  ([#9041](https://github.com/astral-sh/uv/pull/9041))
- Use rich diagnostic formatting for install failures
  ([#9043](https://github.com/astral-sh/uv/pull/9043))

### Performance

- Avoid retraversing filesystem when testing exact glob matches
  ([#9022](https://github.com/astral-sh/uv/pull/9022))

### Bug fixes

- Allow `--no-build` to validate lock ([#9024](https://github.com/astral-sh/uv/pull/9024))
- Allow default indexes to be marked as explicit
  ([#8990](https://github.com/astral-sh/uv/pull/8990))
- Avoid creating `.venv` in `uv add --frozen` and `uv add --no-sync`
  ([#8980](https://github.com/astral-sh/uv/pull/8980))
- Avoid duplicating first-entry comments in `uv add`
  ([#9109](https://github.com/astral-sh/uv/pull/9109))
- Defer reporting of build failures in resolver ([#9098](https://github.com/astral-sh/uv/pull/9098))
- Fix references to `--resolution-strategy` in error message output
  ([#8971](https://github.com/astral-sh/uv/pull/8971))
- Ignore virtual environments in parent directories when choosing Python version for new projects
  ([#9075](https://github.com/astral-sh/uv/pull/9075))
- Forward SIGTERM to child processes in `uv run`
  ([#8933](https://github.com/astral-sh/uv/pull/8933))
- Prefer Python executable names that match the request over default names
  ([#9066](https://github.com/astral-sh/uv/pull/9066))
- Prefer compatible to incompatible distributions when packages exist on multiple indexes
  ([#8961](https://github.com/astral-sh/uv/pull/8961))
- Publish: Ignore non-matching files ([#8986](https://github.com/astral-sh/uv/pull/8986))
- Revert `uv.lock` changes when `uv add` fails ([#9030](https://github.com/astral-sh/uv/pull/9030))
- Show file extensions on available commands when not `.exe`
  ([#9099](https://github.com/astral-sh/uv/pull/9099))
- Sort by name, then specifiers in `uv add` ([#9097](https://github.com/astral-sh/uv/pull/9097))
- Split after specifiers in `--with` requirements
  ([#9089](https://github.com/astral-sh/uv/pull/9089))
- Support multiple extras in universal pip compile output
  ([#8960](https://github.com/astral-sh/uv/pull/8960))

### Preview features

- Build backend: Add tests for source tree -> source dist -> wheel conversions
  ([#9091](https://github.com/astral-sh/uv/pull/9091))
- Build backend: Switch to custom `glob-walkdir` implementation
  ([#9013](https://github.com/astral-sh/uv/pull/9013))
- Build backend: Add minimal wheel settings ([#9085](https://github.com/astral-sh/uv/pull/9085))

### Documentation

- Add wget instructions for systems without curl
  ([#8630](https://github.com/astral-sh/uv/pull/8630))
- Fix `.env` file example in docs ([#9064](https://github.com/astral-sh/uv/pull/9064))
- Fix reference to `--resolution` in docs ([#8968](https://github.com/astral-sh/uv/pull/8968))
- Fix typo in GitLab integration docs ([#9047](https://github.com/astral-sh/uv/pull/9047))
- Update format of environment variable reference
  ([#9018](https://github.com/astral-sh/uv/pull/9018))
- Use Python syntax for `value_type` consistently
  ([#9017](https://github.com/astral-sh/uv/pull/9017))
- Use `[[index]]` API in configuration example ([#9065](https://github.com/astral-sh/uv/pull/9065))
- Mention how to use extras ([#8972](https://github.com/astral-sh/uv/pull/8972))
- Add some words about specifying conflicting extras/groups
  ([#9120](https://github.com/astral-sh/uv/pull/9120))

## 0.5.3

This release includes support for conflicting optional dependencies and dependency groups in the uv
resolver, including the ability to specify dependency sources (like index assignment) on a per-extra
or per-group basis.

For example, you can now select CPU-only vs. GPU-enabled PyTorch builds at runtime by defining
conflicting extras in a `pyproject.toml`, and assigning different extras to different PyTorch
indexes:

```toml
[project]
name = "project"
version = "0.1.0"
requires-python = ">=3.12.0"

[project.optional-dependencies]
# Include `torch` whenever `--extra cpu` or `--extra gpu` is provided.
cpu = ["torch>=2.5.1"]
gpu = ["torch>=2.5.1"]

[tool.uv]
# But allow `cpu` and `gpu` to choose conflicting versions of `torch`.
conflicts = [[{ extra = "cpu" }, { extra = "gpu" }]]

[tool.uv.sources]
torch = [
  # With `--extra cpu`, pull PyTorch from the CPU-only index.
  { index = "pytorch-cpu", extra = "cpu", marker = "platform_system != 'Darwin'" },
  # With `--extra gpu`, pull PyTorch from the GPU-enabled index.
  { index = "pytorch-gpu", extra = "gpu" },
]

[[tool.uv.index]]
name = "pytorch-cpu"
url = "https://download.pytorch.org/whl/cpu"
explicit = true

[[tool.uv.index]]
name = "pytorch-gpu"
url = "https://download.pytorch.org/whl/cu124"
explicit = true
```

See the [PyTorch](https://docs.astral.sh/uv/guides/integration/pytorch/) documentation for more.

### Enhancements

- Allow conflicting extras in explicit index assignments
  ([#9160](https://github.com/astral-sh/uv/pull/9160))
- Support overrides and constraints in PEP 723 scripts
  ([#9162](https://github.com/astral-sh/uv/pull/9162))
- Update `uv tool install --force` to imply `--reinstall-package <name>`
  ([#9074](https://github.com/astral-sh/uv/pull/9074))
- Turn `--verify-hashes` on by default ([#9170](https://github.com/astral-sh/uv/pull/9170))

### Performance

- Enable `zlib-rs` on all platforms ([#9202](https://github.com/astral-sh/uv/pull/9202))

### Bug fixes

- Allow apostrophe in virtual environment name ([#8984](https://github.com/astral-sh/uv/pull/8984))
- Automatically retry body errors when processing response
  ([#9213](https://github.com/astral-sh/uv/pull/9213))
- Detect nested workspace inside the current workspace and members with identical names
  ([#9094](https://github.com/astral-sh/uv/pull/9094))
- Only install the specified project with `--frozen --package` in legacy non-`[project]` workspaces
  ([#9215](https://github.com/astral-sh/uv/pull/9215))
- Respect `[[tool.uv.index]]` in PEP 723 scripts
  ([#9208](https://github.com/astral-sh/uv/pull/9208))
- Show derivation markers for resolutions with project name
  ([#9136](https://github.com/astral-sh/uv/pull/9136))
- Sort distributions when computing hash ([#9185](https://github.com/astral-sh/uv/pull/9185))
- Include trampolines in source distributions on Windows
  ([#9172](https://github.com/astral-sh/uv/pull/9172))

### Documentation

- Add `--index <name>=<url>` syntax to index documentation
  ([#9139](https://github.com/astral-sh/uv/pull/9139))
- Add documentation for using uv with PyTorch ([#9210](https://github.com/astral-sh/uv/pull/9210))

### Error messages

- Add a dedicated error for `include = "dev"` with `tool.uv.dev-dependencies`
  ([#9173](https://github.com/astral-sh/uv/pull/9173))
- Avoid showing disjoint marker error with `true`
  ([#9169](https://github.com/astral-sh/uv/pull/9169))
- Improve error message when `git` is not found ([#9206](https://github.com/astral-sh/uv/pull/9206))
- Include extras and dependency groups in derivation chains
  ([#9113](https://github.com/astral-sh/uv/pull/9113))
- Include version constraints in derivation chains
  ([#9112](https://github.com/astral-sh/uv/pull/9112))

## 0.5.4

### Enhancements

- Accept either singular or plural values for CLI requirements
  ([#9196](https://github.com/astral-sh/uv/pull/9196))
- Add `--all-groups` to `uv sync`, `uv run`, `uv export`, and `uv tree`
  ([#8892](https://github.com/astral-sh/uv/pull/8892))
- Add a progress bar to `uv tree --outdated` and `uv pip list --outdated`
  ([#9284](https://github.com/astral-sh/uv/pull/9284))
- Add retries for Python downloads ([#9274](https://github.com/astral-sh/uv/pull/9274))
- Use exponential backoff for publish retries ([#9276](https://github.com/astral-sh/uv/pull/9276))
- Add manylinux target triples up to glibc 2.40 ([#9234](https://github.com/astral-sh/uv/pull/9234))

### Performance

- Parallelize network requests in `uv tree --outdated`
  ([#9280](https://github.com/astral-sh/uv/pull/9280))
- Use `zlib-rs` on all platforms ([#9264](https://github.com/astral-sh/uv/pull/9264))

### Bug fixes

- Avoid validating extra and group sources in `build-system.requires`
  ([#9273](https://github.com/astral-sh/uv/pull/9273))
- Catch retries with wrapped `reqwest` errors ([#9253](https://github.com/astral-sh/uv/pull/9253))
- Sort hashes in `uv export` output ([#9237](https://github.com/astral-sh/uv/pull/9237))
- Strip `--index` and `--default-index` from command header
  ([#9288](https://github.com/astral-sh/uv/pull/9288))

### Documentation

- Add breadcrumbs to the documentation ([#9242](https://github.com/astral-sh/uv/pull/9242))
- Add minimum version to PyTorch guide ([#9247](https://github.com/astral-sh/uv/pull/9247))
- Add support for anchor redirects with client-side js
  ([#9212](https://github.com/astral-sh/uv/pull/9212))
- Improve content on project configuration ([#9235](https://github.com/astral-sh/uv/pull/9235))
- Improve the project creation documentation ([#9236](https://github.com/astral-sh/uv/pull/9236))
- Move the integration guides into the "Guides" section as a collapsed group
  ([#9245](https://github.com/astral-sh/uv/pull/9245))
- Reorganize the project concept documentation ([#9121](https://github.com/astral-sh/uv/pull/9121))
- Use the full screen height for the main content to stabilize the nav
  ([#9153](https://github.com/astral-sh/uv/pull/9153))

### Error messages

- Add dedicated warning for empty stdin ([#9256](https://github.com/astral-sh/uv/pull/9256))

## 0.5.5

### Enhancements

- Add aliases for build backend requests ([#9294](https://github.com/astral-sh/uv/pull/9294))
- Avoid displaying empty paths ([#9312](https://github.com/astral-sh/uv/pull/9312))
- Allow constraints in `uv tool upgrade` ([#9375](https://github.com/astral-sh/uv/pull/9375))
- Remove conflict between `--no-sync` and `--frozen` in `uv run`
  ([#9400](https://github.com/astral-sh/uv/pull/9400))
- Respect dependency sources in overrides and constraints
  ([#9455](https://github.com/astral-sh/uv/pull/9455))
- Show an interpreter-focused message for `--target` and `--prefix`
  ([#9373](https://github.com/astral-sh/uv/pull/9373))
- Add `--no-extra` flag and setting ([#9387](https://github.com/astral-sh/uv/pull/9387))
- Add `uv export --prune` ([#9389](https://github.com/astral-sh/uv/pull/9389))
- Add dedicated error message for musl install attempts
  ([#9430](https://github.com/astral-sh/uv/pull/9430))
- Add various grammar changes to conflict error messages
  ([#9369](https://github.com/astral-sh/uv/pull/9369))
- Annotate default groups in conflict error messages
  ([#9368](https://github.com/astral-sh/uv/pull/9368))
- Report marker diagnostics during parsing, rather than evaluation
  ([#9338](https://github.com/astral-sh/uv/pull/9338))
- Use consistent formatting for build system errors
  ([#9340](https://github.com/astral-sh/uv/pull/9340))
- Use rich diagnostics for build failures ([#9335](https://github.com/astral-sh/uv/pull/9335))

### Preview features

- Improve build backend excludes ([#9281](https://github.com/astral-sh/uv/pull/9281))
- Include PEP 639 `license-files` metadata during `uv publish`
  ([#9442](https://github.com/astral-sh/uv/pull/9442))

### Performance

- Initialize rayon lazily ([#9435](https://github.com/astral-sh/uv/pull/9435))
- Migrate to PubGrub's arena for package names ([#9448](https://github.com/astral-sh/uv/pull/9448))

### Bug fixes

- Allow dependency groups to include the containing package
  ([#9385](https://github.com/astral-sh/uv/pull/9385))
- Allow syncing to empty virtual environment directories
  ([#9427](https://github.com/astral-sh/uv/pull/9427))
- Allow system Python discovery with `--target` and `--prefix`
  ([#9371](https://github.com/astral-sh/uv/pull/9371))
- Don't warn when `--output-file` is empty ([#9417](https://github.com/astral-sh/uv/pull/9417))
- Fix Python interpreter discovery on non-glibc hosts
  ([#9005](https://github.com/astral-sh/uv/pull/9005))
- Fix `tool.uv.dependency-metadata.[].version` schema
  ([#9468](https://github.com/astral-sh/uv/pull/9468))
- Only respect preferences across the same indexes
  ([#9302](https://github.com/astral-sh/uv/pull/9302))
- Re-compile when `--compile` is passed to an install operation
  ([#9378](https://github.com/astral-sh/uv/pull/9378))
- Remove `--upgrade`, `--no-upgrade`, and `--upgrade-package` from `uv tool upgrade`
  ([#9318](https://github.com/astral-sh/uv/pull/9318))
- Remove dev dependencies in `--all-groups --no-dev`
  ([#9300](https://github.com/astral-sh/uv/pull/9300))
- Surface extras and group conflicts in `uv export`
  ([#9365](https://github.com/astral-sh/uv/pull/9365))
- Treat deprecated aliases as equivalent in marker algebra
  ([#9342](https://github.com/astral-sh/uv/pull/9342))
- Treat less compatible tags as lower priority in resolver
  ([#9339](https://github.com/astral-sh/uv/pull/9339))

### Documentation

- Avoid referencing `scikit-build` (instead of `scikit-build-core`)
  ([#9320](https://github.com/astral-sh/uv/pull/9320))
- Expand entry points documentation ([#9329](https://github.com/astral-sh/uv/pull/9329))
- Fix example `pyproject.toml` in project concept documentation
  ([#9298](https://github.com/astral-sh/uv/pull/9298))
- Fix header level of "Conflicting dependencies" page
  ([#9330](https://github.com/astral-sh/uv/pull/9330))
- Touch-up the extension module guide ([#9293](https://github.com/astral-sh/uv/pull/9293))
- Update the dependencies documentation ([#9359](https://github.com/astral-sh/uv/pull/9359))
- Reference `--no-progress` option in related environment variable
  ([#9357](https://github.com/astral-sh/uv/pull/9357))

## 0.5.6

### Enhancements

- Add `--dry-run` to `uv pip uninstall` ([#9557](https://github.com/astral-sh/uv/pull/9557))
- Allow `--constraints` and `--overrides` in `uv tool install`
  ([#9547](https://github.com/astral-sh/uv/pull/9547))
- Display removed Python executables on uninstall
  ([#9459](https://github.com/astral-sh/uv/pull/9459))
- Warn when keyring has no password for `uv publish`
  ([#8827](https://github.com/astral-sh/uv/pull/8827))
- Add suggested action when `.python-version` pin is incompatible with the project
  ([#9590](https://github.com/astral-sh/uv/pull/9590))
- Improve error messages for mismatches in `tool.uv.sources`
  ([#9482](https://github.com/astral-sh/uv/pull/9482))
- Use constraints in trace rather than irrelevant `requires-python`
  ([#9529](https://github.com/astral-sh/uv/pull/9529))

### Preview features

- Add `uv python install --default` ([#8650](https://github.com/astral-sh/uv/pull/8650))
- Fix Python executable installation when multiple patch versions are requested
  ([#9607](https://github.com/astral-sh/uv/pull/9607))
- Build backend: Revamp `include` / `exclude` ([#9525](https://github.com/astral-sh/uv/pull/9525))
- Build backend: Add fast path ([#9556](https://github.com/astral-sh/uv/pull/9556))
- Build backend: Add functions to collect file list
  ([#9602](https://github.com/astral-sh/uv/pull/9602))
- Build backend: Default excludes ([#9552](https://github.com/astral-sh/uv/pull/9552))
- Build backend: Refactoring before list ([#9558](https://github.com/astral-sh/uv/pull/9558))
- Build backend: Warn when visiting over 10k files
  ([#9523](https://github.com/astral-sh/uv/pull/9523))

### Configuration

- Make `check-url` available in configuration files
  ([#9032](https://github.com/astral-sh/uv/pull/9032))

### Performance

- Avoid adding non-extra package with extra dependencies
  ([#9540](https://github.com/astral-sh/uv/pull/9540))
- Avoid cloning `String` in marker evaluation ([#9598](https://github.com/astral-sh/uv/pull/9598))

### Rust API

- `uv-pep508`: Add more methods for simplifying `extra`-related expressions
  ([#9469](https://github.com/astral-sh/uv/pull/9469))

### Bug fixes

- Allow `file:` URLs to include package names ([#9493](https://github.com/astral-sh/uv/pull/9493))
- Avoid using IDs across PubGrub states ([#9538](https://github.com/astral-sh/uv/pull/9538))
- Consistently enforce requested-vs.-built metadata when retrieving wheels
  ([#9484](https://github.com/astral-sh/uv/pull/9484))
- Do not show empty version specifier in `uv tool list`
  ([#9605](https://github.com/astral-sh/uv/pull/9605))
- Include Git member information when getting metadata from cache
  ([#9388](https://github.com/astral-sh/uv/pull/9388))
- Include base installation directory in uv run PATH
  ([#9585](https://github.com/astral-sh/uv/pull/9585))
- Insert backslash when appending to system drive
  ([#9488](https://github.com/astral-sh/uv/pull/9488))
- Normalize paths when lowering Git dependencies
  ([#9595](https://github.com/astral-sh/uv/pull/9595))
- Omit origin when comparing requirements ([#9570](https://github.com/astral-sh/uv/pull/9570))
- Override `manylinux_compatible` with `--python-platform`
  ([#9526](https://github.com/astral-sh/uv/pull/9526))
- Pass extra when evaluating lockfile markers ([#9539](https://github.com/astral-sh/uv/pull/9539))
- Propagate markers for recursive extras in resolver
  ([#9509](https://github.com/astral-sh/uv/pull/9509))
- Respect path dependencies within Git dependencies
  ([#9594](https://github.com/astral-sh/uv/pull/9594))
- Support recursive extras with marker in `pip compile -r pyproject.toml`
  ([#9535](https://github.com/astral-sh/uv/pull/9535))
- Don't emit unpinned warning for proxy packages
  ([#9497](https://github.com/astral-sh/uv/pull/9497))
- Fix `--refresh-package` flag mentioned as `--refresh-dependency`
  ([#9486](https://github.com/astral-sh/uv/pull/9486))
- Handle Windows AV/EDR file locks during script installations
  ([#9543](https://github.com/astral-sh/uv/pull/9543))
- Re-enable conflicting extra/group tests and fix regression from #9540
  ([#9582](https://github.com/astral-sh/uv/pull/9582))

### Documentation

- Add missing word to docs for `run.md` ([#9527](https://github.com/astral-sh/uv/pull/9527))
- Add policies reference section and license document
  ([#9367](https://github.com/astral-sh/uv/pull/9367))
- Fix typo in entry point docs ([#9491](https://github.com/astral-sh/uv/pull/9491))
- Fix up version in prior uninstall instructions
  ([#9485](https://github.com/astral-sh/uv/pull/9485))
- Mention `uv pip` behavior in build system note
  ([#9586](https://github.com/astral-sh/uv/pull/9586))
- Update build failures document ([#9584](https://github.com/astral-sh/uv/pull/9584))
- Correct wording for multiple sources section ([#9504](https://github.com/astral-sh/uv/pull/9504))

## 0.5.7

### Enhancements

- Ignore dynamic version in source dist ([#9549](https://github.com/astral-sh/uv/pull/9549))
- Improve build frontend error handling ([#9611](https://github.com/astral-sh/uv/pull/9611))
- Un-hide `uv build --no-build-logs` option ([#9642](https://github.com/astral-sh/uv/pull/9642))
- Flag version mismatch between sdist and wheel during `uv build`
  ([#9633](https://github.com/astral-sh/uv/pull/9633))
- Improve message when updater receipt is for a different uv executable
  ([#9487](https://github.com/astral-sh/uv/pull/9487))
- Add environment variable to disable writing installer metadata files
  ([#8877](https://github.com/astral-sh/uv/pull/8877))
- Add managed downloads for the latest CPython releases: `3.9.21`, `3.10.16`, `3.11.11`, `3.12.8`,
  and `3.13.1` ([#9696](https://github.com/astral-sh/uv/pull/9696))

### Preview features

- Build backend: Add hint on import with preview disabled
  ([#9691](https://github.com/astral-sh/uv/pull/9691))
- Build backend: Add direct builds to the resolver and installer
  ([#9621](https://github.com/astral-sh/uv/pull/9621))
- Build backend: Add integration test for scripts
  ([#9635](https://github.com/astral-sh/uv/pull/9635))
- Build backend: Add template to `uv init` ([#9661](https://github.com/astral-sh/uv/pull/9661))
- Build backend: Add `--list` option ([#9610](https://github.com/astral-sh/uv/pull/9610))

### Bug fixes

- Create missing parent directories for output file of `uv export` / `uv pip compile`
  ([#9648](https://github.com/astral-sh/uv/pull/9648))
- Fix missing display of non-freethreaded Python 3.13 in `python list`
  ([#9669](https://github.com/astral-sh/uv/pull/9669))
- Implement `Ord` and `PartialOrd` without origin for `Requirement`
  ([#9624](https://github.com/astral-sh/uv/pull/9624))
- Include more sources to avoid lowest bound warning
  ([#9644](https://github.com/astral-sh/uv/pull/9644))
- Respect build tag priority in `uv.lock` ([#9677](https://github.com/astral-sh/uv/pull/9677))

### Documentation

- Add `build-essentials` note to build failures doc
  ([#9641](https://github.com/astral-sh/uv/pull/9641))
- Add entry-point for distroless image in GitLab documentation
  ([#9093](https://github.com/astral-sh/uv/pull/9093))
- Add documentation for `uv python pin` without a `REQUEST` argument
  ([#9631](https://github.com/astral-sh/uv/pull/9631))
- Add a link to `uv python pin` reference docs ([#9630](https://github.com/astral-sh/uv/pull/9630))

## 0.5.8

**This release does not include the `powerpc64le-unknown-linux-musl` target due to a build issue.
See [#9793](https://github.com/astral-sh/uv/issues/9793) for details. If this change affects you,
please file an issue with your use-case.**

### Enhancements

- Omit empty resolution markers in lockfile ([#9738](https://github.com/astral-sh/uv/pull/9738))
- Add `--install-dir` to to `uv python install` and `uninstall` commands
  ([#7920](https://github.com/astral-sh/uv/pull/7920))
- Add `--show-urls` and `--only-downloads` to `uv python list`
  ([#8062](https://github.com/astral-sh/uv/pull/8062))
- Add `uv python list --all-arches` ([#9782](https://github.com/astral-sh/uv/pull/9782))
- Add `uv run --gui-script` flag for running Python scripts with `pythonw.exe`
  ([#9152](https://github.com/astral-sh/uv/pull/9152))
- Allow `--gui-script` on Unix ([#9787](https://github.com/astral-sh/uv/pull/9787))
- Allow download of Python distribution variants optimized for newer x86_64 microarchitectures
  ([#9781](https://github.com/astral-sh/uv/pull/9781))
- Allow execution of `pyw` files on Unix ([#9759](https://github.com/astral-sh/uv/pull/9759))
- Allow users to specify URLs in `project.dependencies` and `tool.uv.sources`
  ([#9718](https://github.com/astral-sh/uv/pull/9718))
- Encode mutually-incompatible pairs of markers ([#9444](https://github.com/astral-sh/uv/pull/9444))
- Improve the error message when a Python install request is not valid
  ([#9783](https://github.com/astral-sh/uv/pull/9783))
- Preserve directory-level standalone build symlinks
  ([#9723](https://github.com/astral-sh/uv/pull/9723))
- Add support for `uv publish --index <name>` ([#9694](https://github.com/astral-sh/uv/pull/9694))
- Reframe `--locked` and `--frozen` as `--check` operations for `uv lock`
  ([#9662](https://github.com/astral-sh/uv/pull/9662))
- Rename Python install scratch directory from `.cache` -> `.temp`
  ([#9756](https://github.com/astral-sh/uv/pull/9756))
- Enable `uv tool uninstall uv` on Windows ([#8963](https://github.com/astral-sh/uv/pull/8963))
- Improve self-dependency hint to make shadowing clear
  ([#9716](https://github.com/astral-sh/uv/pull/9716))
- Refactor unavailable metadata to shrink the resolver
  ([#9769](https://github.com/astral-sh/uv/pull/9769))
- Show 'depends on itself' for proxy packages ([#9717](https://github.com/astral-sh/uv/pull/9717))
- Show a dedicated error for missing subdirectories
  ([#9761](https://github.com/astral-sh/uv/pull/9761))
- Show a dedicated hint for missing `git+` prefixes
  ([#9789](https://github.com/astral-sh/uv/pull/9789))

### Performance

- Eagerly error when parsing `pyproject.toml` requirements
  ([#9704](https://github.com/astral-sh/uv/pull/9704))
- Use copy-on-write when normalizing paths ([#9710](https://github.com/astral-sh/uv/pull/9710))

### Bug fixes

- Avoid enforcing non-conflicts in `uv export` ([#9751](https://github.com/astral-sh/uv/pull/9751))
- Don't drop comments between items in TOML tables
  ([#9784](https://github.com/astral-sh/uv/pull/9784))
- Don't fail with `--no-build` when static metadata is available
  ([#9785](https://github.com/astral-sh/uv/pull/9785))
- Don't filter non-patch registry version ([#9736](https://github.com/astral-sh/uv/pull/9736))
- Don't read metadata from stale `.egg-info` files
  ([#9760](https://github.com/astral-sh/uv/pull/9760))
- Enforce correctness of self-dependencies ([#9705](https://github.com/astral-sh/uv/pull/9705))
- Fix projects's typo in resolver error messages
  ([#9708](https://github.com/astral-sh/uv/pull/9708))
- Ignore `.` prefixed directories during managed Python installation discovery
  ([#9786](https://github.com/astral-sh/uv/pull/9786))
- Improve handling of invalid virtual environments during interpreter discovery
  ([#8086](https://github.com/astral-sh/uv/pull/8086))
- Normalize relative paths when `--project` is specified
  ([#9709](https://github.com/astral-sh/uv/pull/9709))
- Respect self-constraints on recursive extras ([#9714](https://github.com/astral-sh/uv/pull/9714))
- Respect user settings for tracing coloring ([#9733](https://github.com/astral-sh/uv/pull/9733))
- Retry on tar extraction errors ([#9753](https://github.com/astral-sh/uv/pull/9753))
- Add conflict markers to the lock file ([#9370](https://github.com/astral-sh/uv/pull/9370))
- De-duplicate resolution markers ([#9780](https://github.com/astral-sh/uv/pull/9780))
- Avoid 403 error hint for PyTorch URLs ([#9750](https://github.com/astral-sh/uv/pull/9750))
- Avoid treating non-existent `--find-links` as relative URLs
  ([#9720](https://github.com/astral-sh/uv/pull/9720))
- Omit Windows Store `python3.13.exe` et al ([#9679](https://github.com/astral-sh/uv/pull/9679))
- Replace executables with broken symlinks during `uv python install`
  ([#9706](https://github.com/astral-sh/uv/pull/9706))

### Documentation

- Fix build failure links ([#9740](https://github.com/astral-sh/uv/pull/9740))

## 0.5.9

### Enhancements

- Fork version selection based on `requires-python` requirements
  ([#9827](https://github.com/astral-sh/uv/pull/9827))
- Patch `sysconfig` data at install time ([#9857](https://github.com/astral-sh/uv/pull/9857))
- Remove `-isysroot` when patching sysconfig ([#9860](https://github.com/astral-sh/uv/pull/9860))

### Configuration

- Introduce a `--fork-strategy` preference mode ([#9868](https://github.com/astral-sh/uv/pull/9868))
- Add support for `UV_OFFLINE` ([#9795](https://github.com/astral-sh/uv/pull/9795))

### Bug fixes

- Avoid `panic!()` when current directory does not exist
  ([#9876](https://github.com/astral-sh/uv/pull/9876))
- Avoid reusing interpreter metadata when running under Rosetta
  ([#9846](https://github.com/astral-sh/uv/pull/9846))
- Avoid trailing slash when deserializing from lockfile
  ([#9848](https://github.com/astral-sh/uv/pull/9848))
- Fix bug in terms when collapsing unavailable versions in resolver errors
  ([#9877](https://github.com/astral-sh/uv/pull/9877))
- Fix suggestion to use `uv help python` on invalid install requests
  ([#9820](https://github.com/astral-sh/uv/pull/9820))
- Skip root when assessing prefix viability ([#9823](https://github.com/astral-sh/uv/pull/9823))
- Avoid spurious 'Upgraded tool environment' in `uv tool upgrade`
  ([#9870](https://github.com/astral-sh/uv/pull/9870))

### Rust API

- Upgrade minimum Rust version to 1.83 ([#9815](https://github.com/astral-sh/uv/pull/9815))

### Documentation

- Document the `--fork-strategy` setting ([#9887](https://github.com/astral-sh/uv/pull/9887))

### Preview features

- Build backend: Allow underscores in entrypoints
  ([#9825](https://github.com/astral-sh/uv/pull/9825))

## 0.5.10

### Enhancements

- Improve backtracking behavior when packages conflict repeatedly
  ([#9843](https://github.com/astral-sh/uv/pull/9843))
- Patch Python `sysconfig` values such as `AR` at `ar` install time
  ([#9905](https://github.com/astral-sh/uv/pull/9905))
- Patch Python `sysconfig` values such as `clang` to `cc` at install time
  ([#9916](https://github.com/astral-sh/uv/pull/9916))
- Skip `--native-tls` in `pip compile` header ([#9913](https://github.com/astral-sh/uv/pull/9913))
- Add resolver error hint for no-binary and no-build failures
  ([#9948](https://github.com/astral-sh/uv/pull/9948))
- Improve build error messages ([#9660](https://github.com/astral-sh/uv/pull/9660))
- Reduce redundant Python version incompatibilities in resolver error message
  ([#9957](https://github.com/astral-sh/uv/pull/9957))
- Reduce redundant enumeration of all package versions in some resolver errors
  ([#9885](https://github.com/astral-sh/uv/pull/9885))
- Improve display of ranges when pre-releases are not allowed
  ([#9944](https://github.com/astral-sh/uv/pull/9944))
- Improve error messages for `uv remove` ([#9959](https://github.com/astral-sh/uv/pull/9959))
- Improve phrasing for single term incompatibilities
  ([#9953](https://github.com/astral-sh/uv/pull/9953))
- Improve styling of `uv remove` dependency hints
  ([#9960](https://github.com/astral-sh/uv/pull/9960))
- Omit trailing zeros on Python requirements inferred from versions
  ([#9952](https://github.com/astral-sh/uv/pull/9952))
- Show a concise error message for missing `version` field
  ([#9912](https://github.com/astral-sh/uv/pull/9912))
- Use the build options value to improve hints for no wheel / source distribution errors
  ([#9950](https://github.com/astral-sh/uv/pull/9950))

### Bug fixes

- Allow multiple disjoint URLs in overrides ([#9893](https://github.com/astral-sh/uv/pull/9893))
- Include explicit indexes in publish index choice
  ([#9932](https://github.com/astral-sh/uv/pull/9932))
- Fix Python interpreter detection for 32-bit operating systems on 64-bit hosts
  ([#9970](https://github.com/astral-sh/uv/pull/9970))

### Documentation

- Fix typo "operation system" ([#9971](https://github.com/astral-sh/uv/pull/9971))
- Clarify uninstallation docs ([#9938](https://github.com/astral-sh/uv/pull/9938))
- Add a note to say that dependencies between workspace members are editable
  ([#9363](https://github.com/astral-sh/uv/pull/9363))
- Correctly document default value of `fork-strategy` setting
  ([#9931](https://github.com/astral-sh/uv/pull/9931))
- Use double quotes for Windows support in examples
  ([#9946](https://github.com/astral-sh/uv/pull/9946))
- Remove `pypy` from top-level pin example ([#9896](https://github.com/astral-sh/uv/pull/9896))
- Update references to `python-build-standalone` to reflect the transferred project
  ([#9977](https://github.com/astral-sh/uv/pull/9977))
- Use a different Ruff version in documentation ([#9943](https://github.com/astral-sh/uv/pull/9943))
- Change example so it works as-is on `powershell` and `cmd.exe`
  ([#9903](https://github.com/astral-sh/uv/pull/9903))
- Clarify best practice for Python matrix strategy in GitHub Actions
  ([#9454](https://github.com/astral-sh/uv/pull/9454))
- Add documentation for `uv-lock` and `uv-export` pre-commit hooks
  ([#9872](https://github.com/astral-sh/uv/pull/9872))

### Preview features

- Build backend: Fix pre-PEP 639 license files ([#9965](https://github.com/astral-sh/uv/pull/9965))

## 0.5.11

### Enhancements

- Normalize `platform_system` to `sys_platform` ([#9949](https://github.com/astral-sh/uv/pull/9949))
- Improve retry mechanisms on Windows for `copy_atomic` and `write_atomic`
  ([#10026](https://github.com/astral-sh/uv/pull/10026))
- Add nuance to prefetch logging ([#9984](https://github.com/astral-sh/uv/pull/9984))
- Update to
  [`python-build-standalone 20241219`](https://github.com/astral-sh/python-build-standalone/releases/tag/20241219)

### Preview features

- Build backend: Preserve executable bits for scripts in distributions
  ([#10027](https://github.com/astral-sh/uv/pull/10027))
- Build backend: Handle case where `metadata_directory` already contains `dist-info` directory
  ([#10005](https://github.com/astral-sh/uv/pull/10005))

### Performance

- Batch resolver pre-fetches per fork ([#10029](https://github.com/astral-sh/uv/pull/10029))

### Bug fixes

- Allow `--script` to be provided with `uv run -`
  ([#10035](https://github.com/astral-sh/uv/pull/10035))
- Allow `uv run` arguments when reading from `stdin`
  ([#10034](https://github.com/astral-sh/uv/pull/10034))
- Prefer higher Python lower-bounds when forking
  ([#10007](https://github.com/astral-sh/uv/pull/10007))
- Remove references to deprecated `first-match`
  ([#10036](https://github.com/astral-sh/uv/pull/10036))

### Documentation

- Add `uv python install --preview` to the documentation
  ([#10010](https://github.com/astral-sh/uv/pull/10010))
- Fix `uv python install --default` note about multiple requests
  ([#10011](https://github.com/astral-sh/uv/pull/10011))
- Fix typo in Caching docs ([#10032](https://github.com/astral-sh/uv/pull/10032))
- Remove remaining references to deprecated `first-match`
  ([#10038](https://github.com/astral-sh/uv/pull/10038))
- Supplement missing separators for `UV_INSTALL_DIR` directions on Windows
  ([#9507](https://github.com/astral-sh/uv/pull/9507))

## 0.5.12

### Enhancements

- Support `uv export` for non-project workspaces
  ([#10144](https://github.com/astral-sh/uv/pull/10144))
- Set glibc versions for standalone installers
  ([#10142](https://github.com/astral-sh/uv/pull/10142))
- Allow environment variables to be included in cache keys
  ([#10170](https://github.com/astral-sh/uv/pull/10170))

### Preview features

- Include extras in `uv-build` `Requires-Dist` metadata
  ([#10110](https://github.com/astral-sh/uv/pull/10110))
- Use `shutil.which` for the build backend ([#10028](https://github.com/astral-sh/uv/pull/10028))

### Bug fixes

- Always write slash paths to RECORD file ([#10164](https://github.com/astral-sh/uv/pull/10164))
- Add support for subdirectories in direct URLs in `uv.lock`
  ([#10068](https://github.com/astral-sh/uv/pull/10068))
- Avoid duplicating backslashes in sysconfig parser
  ([#10063](https://github.com/astral-sh/uv/pull/10063))
- Avoid erroring when subdirectories are provided in `uv add`
  ([#10095](https://github.com/astral-sh/uv/pull/10095))
- Backtrack to non-local versions when wheels are missing platform support
  ([#10046](https://github.com/astral-sh/uv/pull/10046))
- Fix mirror script to handle newer metadata format
  ([#10050](https://github.com/astral-sh/uv/pull/10050))
- Preserve sort when deciding on requirement placement
  ([#10078](https://github.com/astral-sh/uv/pull/10078))
- Remove redundant alias in `uv init` CLI ([#10124](https://github.com/astral-sh/uv/pull/10124))
- Respect sources credentials in non-project workspaces
  ([#10125](https://github.com/astral-sh/uv/pull/10125))
- Show non-project dependencies in `uv tree` ([#10149](https://github.com/astral-sh/uv/pull/10149))
- Strip fragment when storing direct URL ([#10093](https://github.com/astral-sh/uv/pull/10093))
- Include hashes for local source archives ([#10080](https://github.com/astral-sh/uv/pull/10080))

### Documentation

- Fix invalid syntax in some sources examples ([#10127](https://github.com/astral-sh/uv/pull/10127))

## 0.5.13

### Bug fixes

- Avoid enforcing URL check on initial publish
  ([#10182](https://github.com/astral-sh/uv/pull/10182))
- Fix incorrect mismatched constraints reference
  ([#10184](https://github.com/astral-sh/uv/pull/10184))
- Revert "Update `reqwest` (#10178)" ([#10187](https://github.com/astral-sh/uv/pull/10187))

## 0.5.14

### Enhancements

- Add `--exact` flag to `uv run` ([#10198](https://github.com/astral-sh/uv/pull/10198))
- Add `--outdated` support to `uv pip tree` ([#10199](https://github.com/astral-sh/uv/pull/10199))
- Add a required version setting to uv ([#10248](https://github.com/astral-sh/uv/pull/10248))
- Add loongarch64 to supported Python platform tags
  ([#10223](https://github.com/astral-sh/uv/pull/10223))
- Add manylinux2014 aliases for `--python-platform`
  ([#10217](https://github.com/astral-sh/uv/pull/10217))
- Add support for Python interpreters on ARMv5TE platforms
  ([#10234](https://github.com/astral-sh/uv/pull/10234))
- Add support for optional `--description` in `uv init`
  ([#10209](https://github.com/astral-sh/uv/pull/10209))
- Ignore empty or missing hrefs in Simple HTML
  ([#10276](https://github.com/astral-sh/uv/pull/10276))
- Patch pkgconfig files after Python install ([#10189](https://github.com/astral-sh/uv/pull/10189))

### Performance

- Actually use jemalloc as alternative allocator
  ([#10269](https://github.com/astral-sh/uv/pull/10269))
- Parse URLs lazily in resolver ([#10259](https://github.com/astral-sh/uv/pull/10259))
- Use `BTreeMap::range` to avoid iterating over unnecessary versions
  ([#10266](https://github.com/astral-sh/uv/pull/10266))

### Bug fixes

- Accept directories with space names in `uv init`
  ([#10246](https://github.com/astral-sh/uv/pull/10246))
- Avoid forking on version in non-universal resolutions
  ([#10274](https://github.com/astral-sh/uv/pull/10274))
- Avoid stripping query parameters from URLs ([#10253](https://github.com/astral-sh/uv/pull/10253))
- Consider workspace dependencies to be 'direct'
  ([#10197](https://github.com/astral-sh/uv/pull/10197))
- Detect cyclic dependencies during builds ([#10258](https://github.com/astral-sh/uv/pull/10258))
- Guard against self-deletion in `uv venv` and `uv tool`
  ([#10206](https://github.com/astral-sh/uv/pull/10206))
- Respect static metadata for already-installed distributions
  ([#10242](https://github.com/astral-sh/uv/pull/10242))

## 0.5.15

### Python

The managed Python distributions have been updated, including:

- Python 3.14.0a3 support on macOS and Linux
- Performance improvements
- Fixes to SQLite feature detection

See the
[`python-build-standalone` release notes](https://github.com/astral-sh/python-build-standalone/releases/tag/20250106)
for more details.

### Enhancements

- Respect `FORCE_COLOR` environment variable ([#10315](https://github.com/astral-sh/uv/pull/10315))

### Performance

- Avoid generating unused hashes during `uv lock`
  ([#10307](https://github.com/astral-sh/uv/pull/10307))
- Visit source distributions before wheels ([#10291](https://github.com/astral-sh/uv/pull/10291))

### Bug fixes

- Avoid downgrading packages when `--upgrade` is provided
  ([#10097](https://github.com/astral-sh/uv/pull/10097))
- Extract supported architectures from wheel tags
  ([#10179](https://github.com/astral-sh/uv/pull/10179))
- Redact new index credentials in `uv add` ([#10329](https://github.com/astral-sh/uv/pull/10329))

### Documentation

- Clarify `exclude-newer` only allows full timestamps in settings documentation
  ([#9135](https://github.com/astral-sh/uv/pull/9135))
- Tweak script `--no-project` comment ([#10331](https://github.com/astral-sh/uv/pull/10331))
- Update copyright year ([#10297](https://github.com/astral-sh/uv/pull/10297))
- Add instructions for installing with Scoop ([#10332](https://github.com/astral-sh/uv/pull/10332))

## 0.5.16

### Enhancements

- Accept full requirements in `uv remove` ([#10338](https://github.com/astral-sh/uv/pull/10338))

### Performance

- Avoid over-counting versions in batch prefetcher
  ([#10350](https://github.com/astral-sh/uv/pull/10350))
- Deactivate tracing for version-choosing ([#10351](https://github.com/astral-sh/uv/pull/10351))
- Force a niche into `VersionSmall` ([#10385](https://github.com/astral-sh/uv/pull/10385))
- Optimize `requirements_for_extra` ([#10348](https://github.com/astral-sh/uv/pull/10348))
- Re-enable `zlib-ng` on x86 platforms ([#10365](https://github.com/astral-sh/uv/pull/10365))
- Re-enable zlib-ng on all platforms (except s390x, PowerPC, and FreeBSD)
  ([#10370](https://github.com/astral-sh/uv/pull/10370))
- Remove `[u64; 4]` from small version to move `Arc` to full version
  ([#10345](https://github.com/astral-sh/uv/pull/10345))
- Shrink `Dist` from 352 to 288 bytes ([#10389](https://github.com/astral-sh/uv/pull/10389))
- Speed up file pins by removing nested hash map
  ([#10346](https://github.com/astral-sh/uv/pull/10346))
- Buffer file reads in `serde_json::from_reader`
  ([#10341](https://github.com/astral-sh/uv/pull/10341))

### Bug fixes

- Avoid enforcing project-level required version for `uv self`
  ([#10374](https://github.com/astral-sh/uv/pull/10374))
- Fix Ruff linting warnings from generated template files for extension modules
  ([#10371](https://github.com/astral-sh/uv/pull/10371))

### Documentation

- Add AWS Lambda integration guide ([#10278](https://github.com/astral-sh/uv/pull/10278))

## 0.5.17

This release includes support for generating lockfiles from scripts based on inline metadata, as
defined in PEP 723.

By default, scripts remain unlocked, and must be locked explicitly with
`uv lock --script /path/to/script.py`, which will generate a lockfile adjacent to the script (e.g.,
`script.py.lock`). Once generated, the lockfile will be respected (and updated, if necessary) across
`uv run --script`, `uv add --script`, and `uv remove --script` invocations.

This release also includes support for `uv export --script` and `uv tree --script`. Both commands
support PEP 723 scripts with and without accompanying lockfiles.

### Enhancements

- Add support for locking PEP 723 scripts ([#10135](https://github.com/astral-sh/uv/pull/10135))
- Respect PEP 723 script lockfiles in `uv run`
  ([#10136](https://github.com/astral-sh/uv/pull/10136))
- Update PEP 723 lockfile in `uv add --script`
  ([#10145](https://github.com/astral-sh/uv/pull/10145))
- Update PEP 723 lockfile in `uv remove --script`
  ([#10162](https://github.com/astral-sh/uv/pull/10162))
- Add `--script` support to `uv export` for PEP 723 scripts
  ([#10160](https://github.com/astral-sh/uv/pull/10160))
- Add `--script` support to `uv tree` for PEP 723 scripts
  ([#10159](https://github.com/astral-sh/uv/pull/10159))
- Add `ls` alias to `uv {tool, python, pip} list`
  ([#10240](https://github.com/astral-sh/uv/pull/10240))
- Allow reading `--with-requirements` from stdin in `uv add` and `uv run`
  ([#10447](https://github.com/astral-sh/uv/pull/10447))
- Warn-and-ignore for unsupported `requirements.txt` options
  ([#10420](https://github.com/astral-sh/uv/pull/10420))

### Preview features

- Add remaining Python type annotations to build backend
  ([#10434](https://github.com/astral-sh/uv/pull/10434))

### Performance

- Avoid allocating for names in the PEP 508 parser
  ([#10476](https://github.com/astral-sh/uv/pull/10476))
- Fetch concurrently for non-first-match index strategies
  ([#10432](https://github.com/astral-sh/uv/pull/10432))
- Remove unnecessary `.to_string()` call ([#10419](https://github.com/astral-sh/uv/pull/10419))
- Respect sentinels in package prioritization ([#10443](https://github.com/astral-sh/uv/pull/10443))
- Use `ArcStr` for marker values ([#10453](https://github.com/astral-sh/uv/pull/10453))
- Use `ArcStr` for package, extra, and group names
  ([#10475](https://github.com/astral-sh/uv/pull/10475))
- Use `matches!` rather than `contains` in `requirements.txt` parsing
  ([#10423](https://github.com/astral-sh/uv/pull/10423))
- Use faster disjointness check for markers ([#10439](https://github.com/astral-sh/uv/pull/10439))
- Pre-compute PEP 508 markers from universal markers
  ([#10472](https://github.com/astral-sh/uv/pull/10472))

### Bug fixes

- Fix `UV_FIND_LINKS` delimiter to split on commas
  ([#10477](https://github.com/astral-sh/uv/pull/10477))
- Improve `uv tool list` output when tool environment is broken
  ([#10409](https://github.com/astral-sh/uv/pull/10409))
- Only track markers for compatible versions ([#10457](https://github.com/astral-sh/uv/pull/10457))
- Respect `requires-python` when installing tools
  ([#10401](https://github.com/astral-sh/uv/pull/10401))
- Visit proxy packages eagerly ([#10441](https://github.com/astral-sh/uv/pull/10441))
- Improve shell compatibility of `venv` activate scripts
  ([#10397](https://github.com/astral-sh/uv/pull/10397))
- Read publish username from URL ([#10469](https://github.com/astral-sh/uv/pull/10469))

### Documentation

- Add Lambda layer instructions to AWS Lambda guide
  ([#10411](https://github.com/astral-sh/uv/pull/10411))
- Add `uv lock --script` to the docs ([#10414](https://github.com/astral-sh/uv/pull/10414))
- Use Windows-specific instructions in Jupyter guide
  ([#10446](https://github.com/astral-sh/uv/pull/10446))

## 0.5.18

### Bug fixes

- Avoid forking for identical markers ([#10490](https://github.com/astral-sh/uv/pull/10490))
- Avoid panic in `uv remove` when only comments exist
  ([#10484](https://github.com/astral-sh/uv/pull/10484))
- Revert "improve shell compatibility of venv activate scripts (#10397)"
  ([#10497](https://github.com/astral-sh/uv/pull/10497))

## 0.5.19

### Enhancements

- Filter wheels from lockfile based on architecture
  ([#10584](https://github.com/astral-sh/uv/pull/10584))
- Omit dynamic versions from the lockfile ([#10622](https://github.com/astral-sh/uv/pull/10622))
- Add support for `pip freeze --path` ([#10488](https://github.com/astral-sh/uv/pull/10488))
- Reduce verbosity of inline-metadata message when using `uv run <script.py>`
  ([#10588](https://github.com/astral-sh/uv/pull/10588))
- Add opt-in Git LFS support ([#10335](https://github.com/astral-sh/uv/pull/10335))
- Recommend `--native-tls` on SSL errors ([#10605](https://github.com/astral-sh/uv/pull/10605))
- Show expected and available ABI tags in resolver errors
  ([#10527](https://github.com/astral-sh/uv/pull/10527))
- Show target Python version in error messages
  ([#10582](https://github.com/astral-sh/uv/pull/10582))
- Add `--output-format=json` support to `uv python list`
  ([#10596](https://github.com/astral-sh/uv/pull/10596))

### Python

The managed Python distributions have been updated, including:

- Python 3.14 support on Windows
- Python 3.14.0a4 support
- 64-bit RISC-V Linux support
- Bundled `libedit` updated from 20210910-3.1 -> 20240808-3.1
- Bundled `tcl/tk` updated from 8.6.12 -> 8.6.14 (for all Python versions on Unix, only for Python
  3.14 on Windows)

See the
[`python-build-standalone` release notes](https://github.com/astral-sh/python-build-standalone/releases/tag/20250115)
for more details.

### Performance

- Avoid allocating when stripping source distribution extension
  ([#10625](https://github.com/astral-sh/uv/pull/10625))
- Reduce `WheelFilename` to 48 bytes ([#10583](https://github.com/astral-sh/uv/pull/10583))
- Reduce distribution size to 200 bytes ([#10601](https://github.com/astral-sh/uv/pull/10601))
- Remove `import re` from entrypoint wrapper scripts
  ([#10627](https://github.com/astral-sh/uv/pull/10627))
- Shrink size of platform tag enum ([#10546](https://github.com/astral-sh/uv/pull/10546))
- Use `ArcStr` in verbatim URL ([#10600](https://github.com/astral-sh/uv/pull/10600))
- Use `memchr` for wheel parsing ([#10620](https://github.com/astral-sh/uv/pull/10620))

### Bug fixes

- Avoid reading symlinks during `uv python install` on Windows
  ([#10639](https://github.com/astral-sh/uv/pull/10639))
- Correct Pyston tag format ([#10580](https://github.com/astral-sh/uv/pull/10580))
- Provide `pyproject.toml` path for parse errors in `uv venv`
  ([#10553](https://github.com/astral-sh/uv/pull/10553))
- Don't treat `setuptools` and `wheel` as seed packages in uv sync on Python 3.12
  ([#10572](https://github.com/astral-sh/uv/pull/10572))
- Fix git-tag cache-key reader in case of slashes (#10467)
  ([#10500](https://github.com/astral-sh/uv/pull/10500))
- Include build tag in rendered wheel filenames
  ([#10599](https://github.com/astral-sh/uv/pull/10599))
- Patch embedded install path for Python dylib on macOS during `python install`
  ([#10629](https://github.com/astral-sh/uv/pull/10629))
- Read cached registry distributions when `--config-settings` are present
  ([#10578](https://github.com/astral-sh/uv/pull/10578))
- Show resolver hints for packages with markers
  ([#10607](https://github.com/astral-sh/uv/pull/10607))

### Documentation

- Add meta titles to documents in guides, excluding integration documents
  ([#10539](https://github.com/astral-sh/uv/pull/10539))
- Remove `build-system` from example workspace rot
  ([#10636](https://github.com/astral-sh/uv/pull/10636))

### Preview features

- Make build backend type annotations more generic
  ([#10549](https://github.com/astral-sh/uv/pull/10549))

## 0.5.20

### Bug fixes

- Avoid failing when deserializing unknown tags
  ([#10655](https://github.com/astral-sh/uv/pull/10655))

## 0.5.21

### Enhancements

- Avoid building dynamic versions when validating lockfile
  ([#10703](https://github.com/astral-sh/uv/pull/10703))

### Configuration

- Add `UV_VENV_SEED` environment variable ([#10715](https://github.com/astral-sh/uv/pull/10715))

### Performance

- Store unsupported tags in wheel filename ([#10665](https://github.com/astral-sh/uv/pull/10665))

### Bug fixes

- Avoid attempting to patch macOS dylib for non-macOS installs
  ([#10721](https://github.com/astral-sh/uv/pull/10721))
- Avoid narrowing `requires-python` marker with disjunctions
  ([#10704](https://github.com/astral-sh/uv/pull/10704))
- Respect environment variable credentials for indexes outside root
  ([#10688](https://github.com/astral-sh/uv/pull/10688))
- Respect preferences for explicit index dependencies from `requirements.txt`
  ([#10690](https://github.com/astral-sh/uv/pull/10690))
- Sort preferences by environment, then index ([#10700](https://github.com/astral-sh/uv/pull/10700))
- Ignore permission errors when looking for user-level configuration file
  ([#10697](https://github.com/astral-sh/uv/pull/10697))

### Documentation

- Add `SyntaxWarning` compatibility note to bytecode compilation docs
  ([#10701](https://github.com/astral-sh/uv/pull/10701))
- Add `MACOSX_DEPLOYMENT_TARGET` to the `--python-platform` documentation
  ([#10698](https://github.com/astral-sh/uv/pull/10698))

## 0.5.22

### Enhancements

- Include version and contact information in GitHub User Agent
  ([#10785](https://github.com/astral-sh/uv/pull/10785))

### Performance

- Add fast-path for recursive extras in dynamic validation
  ([#10823](https://github.com/astral-sh/uv/pull/10823))
- Fetch `pyproject.toml` from GitHub API ([#10765](https://github.com/astral-sh/uv/pull/10765))
- Remove allocation in Git SHA truncation ([#10801](https://github.com/astral-sh/uv/pull/10801))
- Skip GitHub fast path when full commit is already known
  ([#10800](https://github.com/astral-sh/uv/pull/10800))

### Bug fixes

- Add fallback to build backend when `Requires-Dist` mismatches
  ([#10797](https://github.com/astral-sh/uv/pull/10797))
- Avoid deserialization error for paths above the root
  ([#10789](https://github.com/astral-sh/uv/pull/10789))
- Avoid respecting preferences from other indexes
  ([#10782](https://github.com/astral-sh/uv/pull/10782))
- Disable the distutils setuptools shim during interpreter query
  ([#10819](https://github.com/astral-sh/uv/pull/10819))
- Omit variant when detecting compatible Python installs
  ([#10722](https://github.com/astral-sh/uv/pull/10722))
- Remove TOCTOU errors in Git clone ([#10758](https://github.com/astral-sh/uv/pull/10758))
- Validate metadata under GitHub fast path ([#10796](https://github.com/astral-sh/uv/pull/10796))
- Include conflict markers in fork markers ([#10818](https://github.com/astral-sh/uv/pull/10818))

### Error messages

- Add tag incompatibility hints to sync failures
  ([#10739](https://github.com/astral-sh/uv/pull/10739))
- Improve log when distutils is missing ([#10713](https://github.com/astral-sh/uv/pull/10713))
- Show non-critical Python discovery errors if no other interpreter is found
  ([#10716](https://github.com/astral-sh/uv/pull/10716))
- Use colors for lock errors ([#10736](https://github.com/astral-sh/uv/pull/10736))

### Documentation

- Add testing instructions to the AWS Lambda guide
  ([#10805](https://github.com/astral-sh/uv/pull/10805))

## 0.5.23

### Enhancements

- Add `--refresh` to `uv venv` ([#10834](https://github.com/astral-sh/uv/pull/10834))
- Add `--no-default-groups` command-line flag ([#10618](https://github.com/astral-sh/uv/pull/10618))

### Bug fixes

- Sort extras and groups when comparing lockfile requirements
  ([#10856](https://github.com/astral-sh/uv/pull/10856))
- Include `commit_id` and `requested_revision` in `direct_url.json`
  ([#10862](https://github.com/astral-sh/uv/pull/10862))
- Invalidate lockfile when static versions change
  ([#10858](https://github.com/astral-sh/uv/pull/10858))
- Make GitHub fast path errors non-fatal ([#10859](https://github.com/astral-sh/uv/pull/10859))
- Remove warnings for `--frozen` and `--locked` in `uv run --script`
  ([#10840](https://github.com/astral-sh/uv/pull/10840))
- Resolve `find-links` paths relative to the configuration file
  ([#10827](https://github.com/astral-sh/uv/pull/10827))
- Respect visitation order for proxy packages ([#10833](https://github.com/astral-sh/uv/pull/10833))
- Treat version mismatch errors as non-fatal in fast paths
  ([#10860](https://github.com/astral-sh/uv/pull/10860))
- Mark `--locked` and `--upgrade` are conflicting
  ([#10836](https://github.com/astral-sh/uv/pull/10836))
- Relax error checking around unconditional enabling of conflicting extras
  ([#10875](https://github.com/astral-sh/uv/pull/10875))

### Documentation

- Reduce ambiguity in conflicting extras example
  ([#10877](https://github.com/astral-sh/uv/pull/10877))
- Update pre-commit documentation ([#10756](https://github.com/astral-sh/uv/pull/10756))

### Error messages

- Error when workspace contains conflicting Python requirements
  ([#10841](https://github.com/astral-sh/uv/pull/10841))
- Improve uvx error message when uv is missing ([#9745](https://github.com/astral-sh/uv/pull/9745))

## 0.5.24

### Enhancements

- Improve determinism of resolution by always setting package priorities
  ([#10853](https://github.com/astral-sh/uv/pull/10853))
- Upgrade to `cargo-dist` 0.28.0; improves several installer behaviors
  ([#10884](https://github.com/astral-sh/uv/pull/10884))

### Performance

- Remove dependencies clone in resolver ([#10880](https://github.com/astral-sh/uv/pull/10880))
- Use Hashbrown's raw entry API to reduce hashes and clone in resolver priority determination
  ([#10881](https://github.com/astral-sh/uv/pull/10881))

### Bug fixes

- Allow fallback to Python download on non-critical discovery errors
  ([#10908](https://github.com/astral-sh/uv/pull/10908))

### Preview features

- Register managed Python version with the Windows Registry (PEP 514)
  ([#10634](https://github.com/astral-sh/uv/pull/10634))

### Documentation

- Improve documentation for some environment variables
  ([#10887](https://github.com/astral-sh/uv/pull/10887))
- Add git subdirectory example ([#10894](https://github.com/astral-sh/uv/pull/10894))

## 0.5.25

### Enhancements

- Allow installation of manylinux wheels on loongarch64
  ([#10927](https://github.com/astral-sh/uv/pull/10927))
- Allow optional `=` for editables in `requirements.txt`
  ([#10954](https://github.com/astral-sh/uv/pull/10954))
- Add Windows aarch64 to the release binaries ([#10885](https://github.com/astral-sh/uv/pull/10885))

### Bug fixes

- Use spec-compliant (`128+n`) exit codes for `uv run` and `uv tool run` on Unix
  ([#10781](https://github.com/astral-sh/uv/pull/10781))
- Fix best-interpreter lookups when there is an invalid interpreter in the `PATH`
  ([#11030](https://github.com/astral-sh/uv/pull/11030))
- Guard against concurrent cache writes on Windows
  ([#11007](https://github.com/astral-sh/uv/pull/11007))
- Prioritize package preferences with greater package versions
  ([#10963](https://github.com/astral-sh/uv/pull/10963))
- Reject `--editable` flag on non-directory requirements
  ([#10994](https://github.com/astral-sh/uv/pull/10994))
- Respect `--no-sources` for `uv pip install` workspace discovery
  ([#11003](https://github.com/astral-sh/uv/pull/11003))
- Set `JEMALLOC_SYS_WITH_LG_PAGE=16` in ARM Docker builds
  ([#10943](https://github.com/astral-sh/uv/pull/10943))
- Update `riscv64` Python downloads to allow install on `riscv64gc`
  ([#10937](https://github.com/astral-sh/uv/pull/10937))
- Fix file persist retries on Windows ([#11008](https://github.com/astral-sh/uv/pull/11008))
- Fix incorrect error message when specifying `tool.uv.sources.(package).workspace` with other
  options ([#11013](https://github.com/astral-sh/uv/pull/11013))
- Improve SIGINT handling in `uv run` ([#11009](https://github.com/astral-sh/uv/pull/11009))

### Documentation

- Add `SECURITY` policy ([#11035](https://github.com/astral-sh/uv/pull/11035))
- Add `Requires-Python` upper bound behavior to the docs
  ([#10964](https://github.com/astral-sh/uv/pull/10964))
- Add a troubleshooting section and reproducible example guide
  ([#10947](https://github.com/astral-sh/uv/pull/10947))
- Add documentation for `uv add -r` ([#10926](https://github.com/astral-sh/uv/pull/10926))
- Amend `requires-python` rules in resolver documentation
  ([#10993](https://github.com/astral-sh/uv/pull/10993))
- Reference workspaces in `--no-sources` documentation
  ([#10995](https://github.com/astral-sh/uv/pull/10995))
- Update documentation for activating virtual environments in different shell
  ([#11000](https://github.com/astral-sh/uv/pull/11000))
- Add Docker SHA pinning tip ([#10955](https://github.com/astral-sh/uv/pull/10955))

## 0.5.26

### Enhancements

- Add support for `uvx python` ([#11076](https://github.com/astral-sh/uv/pull/11076))
- Allow `--no-dev --invert` in `uv tree` ([#11068](https://github.com/astral-sh/uv/pull/11068))
- Update `uv python install --reinstall` to reinstall all previous versions
  ([#11072](https://github.com/astral-sh/uv/pull/11072))
- Consistently write log messages with capitalized first word
  ([#11111](https://github.com/astral-sh/uv/pull/11111))
- Suggest `--build-backend` when `--backend` is passed to `uv init`
  ([#10958](https://github.com/astral-sh/uv/pull/10958))
- Improve retry trace message ([#11108](https://github.com/astral-sh/uv/pull/11108))

### Performance

- Remove unnecessary UTF-8 conversion in hash parsing
  ([#11110](https://github.com/astral-sh/uv/pull/11110))

### Bug fixes

- Ignore non-hash fragments in HTML API responses
  ([#11107](https://github.com/astral-sh/uv/pull/11107))
- Avoid resolving symbolic links when querying Python interpreters
  ([#11083](https://github.com/astral-sh/uv/pull/11083))
- Avoid sharing state between universal and non-universal resolves
  ([#11051](https://github.com/astral-sh/uv/pull/11051))
- Error when `--script` is passing a non-PEP 723 script
  ([#11118](https://github.com/astral-sh/uv/pull/11118))
- Make metadata deserialization failures non-fatal in the cache
  ([#11105](https://github.com/astral-sh/uv/pull/11105))
- Mark metadata as dynamic when reading from built wheel cache
  ([#11046](https://github.com/astral-sh/uv/pull/11046))
- Propagate credentials for `<index>/simple` to `<index>/...` endpoints
  ([#11074](https://github.com/astral-sh/uv/pull/11074))
- Fix conflicting extra bug during `uv sync` ([#11075](https://github.com/astral-sh/uv/pull/11075))

### Documentation

- Add PyTorch XPU instructions to the PyTorch guide
  ([#11109](https://github.com/astral-sh/uv/pull/11109))
- Add docs for signal handling ([#11041](https://github.com/astral-sh/uv/pull/11041))
- Explain build frontend vs. build backend ([#11094](https://github.com/astral-sh/uv/pull/11094))
- Fix formatting of `RUST_LOG` documentation ([#10053](https://github.com/astral-sh/uv/pull/10053))
- Fix typo in `--no-deps` description ([#11073](https://github.com/astral-sh/uv/pull/11073))
- Reflow CLI documentation comments ([#11040](https://github.com/astral-sh/uv/pull/11040))
- Shorten "Using existing Python versions" nav item so it fits on one line
  ([#11077](https://github.com/astral-sh/uv/pull/11077))
- Some minor touch-ups to the Python install guide
  ([#11116](https://github.com/astral-sh/uv/pull/11116))
- Update Dependabot tracking issue link ([#11054](https://github.com/astral-sh/uv/pull/11054))
- Update documentation for running in a container
  ([#11052](https://github.com/astral-sh/uv/pull/11052))
- Upgrade PyTorch version in documentation ([#11114](https://github.com/astral-sh/uv/pull/11114))
- Use `sys_platform` in lieu of `platform_system` in PyTorch docs
  ([#11113](https://github.com/astral-sh/uv/pull/11113))
- Use positive (rather than negative) markers in PyTorch examples
  ([#11112](https://github.com/astral-sh/uv/pull/11112))
- Fix unnecessary backslashes in brackets ([#11059](https://github.com/astral-sh/uv/pull/11059))
- Suggest setting copy link mode in GitLab integration guide
  ([#11067](https://github.com/astral-sh/uv/pull/11067))

## 0.5.27

### Enhancements

- Avoid setting permissions during tar extraction
  ([#11191](https://github.com/astral-sh/uv/pull/11191))
- Remove warnings for missing lower bounds ([#11195](https://github.com/astral-sh/uv/pull/11195))
- Update PubGrub to set-based outdated priority tracking
  ([#11169](https://github.com/astral-sh/uv/pull/11169))
- Improve error messages for `uv pip install` with `--extra` or `--all-extras` and invalid sources
  ([#11193](https://github.com/astral-sh/uv/pull/11193))
- Sign Docker images using GitHub attestations ([#8685](https://github.com/astral-sh/uv/pull/8685))

### Preview features

- Don't expand self-referential extras in the build backend
  ([#11142](https://github.com/astral-sh/uv/pull/11142))

### Performance

- Filter discovered Python executables by source before querying
  ([#11143](https://github.com/astral-sh/uv/pull/11143))
- Optimize exclusion computation for markers ([#11158](https://github.com/astral-sh/uv/pull/11158))
- Use Astral-maintained `tokio-tar` fork ([#11174](https://github.com/astral-sh/uv/pull/11174))
- Remove unneeded `.clone()` ([#11127](https://github.com/astral-sh/uv/pull/11127))

### Bug fixes

- Fix relative paths in bytecode compilation ([#11177](https://github.com/astral-sh/uv/pull/11177))
- Percent-decode URLs in canonical comparisons
  ([#11088](https://github.com/astral-sh/uv/pull/11088))
- Respect concurrency limits in parallel index fetch
  ([#11182](https://github.com/astral-sh/uv/pull/11182))
- Use wire JSON schema for conflict items ([#11196](https://github.com/astral-sh/uv/pull/11196))
- Use explicit `_GLibCVersion` tuple in uv-python crate
  ([#11122](https://github.com/astral-sh/uv/pull/11122))

### Documentation

- Add Git SHA locking behavior to docs ([#11125](https://github.com/astral-sh/uv/pull/11125))
- Add best-practice flags to `pip install` example in troubleshooting guide
  ([#11194](https://github.com/astral-sh/uv/pull/11194))
- Set `VIRTUAL_ENV` in Jupyter kernels ([#11155](https://github.com/astral-sh/uv/pull/11155))
- Add instructions for deactivating an environment
  ([#11200](https://github.com/astral-sh/uv/pull/11200))

## 0.5.28

### Bug fixes

- Allow discovering virtual environments from the first interpreter found on the `PATH`
  ([#11218](https://github.com/astral-sh/uv/pull/11218))
- Clear ephemeral overlays when running tools ([#11141](https://github.com/astral-sh/uv/pull/11141))
- Disable SSL in Git commands for `--allow-insecure-host`
  ([#11210](https://github.com/astral-sh/uv/pull/11210))
- Fix hardlinks in tar unpacking ([#11221](https://github.com/astral-sh/uv/pull/11221))
- Set base executable when returning virtual environment
  ([#11209](https://github.com/astral-sh/uv/pull/11209))
- Use base Python for cached environments ([#11208](https://github.com/astral-sh/uv/pull/11208))

### Documentation

- Add documentation on verifying Docker image attestations
  ([#11140](https://github.com/astral-sh/uv/pull/11140))
- Add `last updated` to documentation ([#11164](https://github.com/astral-sh/uv/pull/11164))

## 0.5.29

### Enhancements

- Add `--bare` option to `uv init` ([#11192](https://github.com/astral-sh/uv/pull/11192))
- Add support for respecting `VIRTUAL_ENV` in project commands via `--active`
  ([#11189](https://github.com/astral-sh/uv/pull/11189))
- Allow the project `VIRTUAL_ENV` warning to be silenced with `--no-active`
  ([#11251](https://github.com/astral-sh/uv/pull/11251))

### Python

The managed Python distributions have been updated, including:

- CPython 3.12.9
- CPython 3.13.2
- pkg-config files are now relocatable

See the
[`python-build-standalone` release notes](https://github.com/astral-sh/python-build-standalone/releases/tag/20250205)
for more details.

### Bug fixes

- Always use base Python discovery logic for cached environments
  ([#11254](https://github.com/astral-sh/uv/pull/11254))
- Use a flock to avoid concurrent initialization of project environments
  ([#11259](https://github.com/astral-sh/uv/pull/11259))
- Fix handling of `--all-groups` and `--no-default-groups` flags
  ([#11224](https://github.com/astral-sh/uv/pull/11224))

### Documentation

- Minor touchups to the Docker provenance docs
  ([#11252](https://github.com/astral-sh/uv/pull/11252))
- Move content from the `mkdocs.public.yml` into the template
  ([#11246](https://github.com/astral-sh/uv/pull/11246))

## 0.5.30

### Python

The managed PyPy distributions have been updated for PyPy v7.3.18, which includes:

- PyPy3.10, which updates the standard library from Python 3.10.14 to 3.10.19
- PyPy3.11, which adds beta support for Python 3.11.11

See the [PyPy release](https://pypy.org/posts/2025/02/pypy-v7318-release.html) for more details.

### Enhancements

- Add `uv sync --dry-run` ([#11299](https://github.com/astral-sh/uv/pull/11299))
- Ignore `#egg` fragment in HTML Simple API response
  ([#11340](https://github.com/astral-sh/uv/pull/11340))

### Configuration

- Add `NO_BINARY` and `NO_BINARY_PACKAGE` environment variables
  ([#11399](https://github.com/astral-sh/uv/pull/11399))

### Performance

- Avoid re-cloning name when populating ambiguous set
  ([#11401](https://github.com/astral-sh/uv/pull/11401))
- Optimize flattening in large workspaces ([#11313](https://github.com/astral-sh/uv/pull/11313))

### Bug fixes

- Allow dynamic packages to be overloaded ([#11400](https://github.com/astral-sh/uv/pull/11400))
- Fix credential caching for index roots when URL ends in `simple/`
  ([#11336](https://github.com/astral-sh/uv/pull/11336))
- Fix marker merging for requirements.txt for psycopg
  ([#11298](https://github.com/astral-sh/uv/pull/11298))
- Set 777 permissions on locked files ([#11328](https://github.com/astral-sh/uv/pull/11328))
- Support extras in `@` requests for tools ([#11335](https://github.com/astral-sh/uv/pull/11335))
- Upgrade `astral-tokio-tar` to v0.5.1 ([#11359](https://github.com/astral-sh/uv/pull/11359))
- Avoid missing logging for no-op upgrade events
  ([#11301](https://github.com/astral-sh/uv/pull/11301))
- Use refined specifiers when logging narrowed Python range
  ([#11334](https://github.com/astral-sh/uv/pull/11334))
- Don't use popup-generating `eprintln` in trampoline warnings
  ([#11295](https://github.com/astral-sh/uv/pull/11295))
- Patch pkg-config files to be relocatable ([#11291](https://github.com/astral-sh/uv/pull/11291))
- Fix a case of duplicate `torch` packages when using conflicting extras
  ([#11323](https://github.com/astral-sh/uv/pull/11323))

### Documentation

- Add docs for `uv tool install --editable` ([#11280](https://github.com/astral-sh/uv/pull/11280))
- Fix broken anchors in README and docs index ([#11338](https://github.com/astral-sh/uv/pull/11338))

## 0.5.31

### Enhancements

- Add `uv sync --script` ([#11361](https://github.com/astral-sh/uv/pull/11361))
- Allow PEP 508 requirements in tool requests ([#11337](https://github.com/astral-sh/uv/pull/11337))
- Allow source distributions to produce wheels with `+local` suffixes
  ([#11429](https://github.com/astral-sh/uv/pull/11429))
- Bring parity to `uvx` and `uv tool install` requests
  ([#11345](https://github.com/astral-sh/uv/pull/11345))
- Use a stable directory for local, remote, and stdin script virtual environments
  ([#11347](https://github.com/astral-sh/uv/pull/11347),
  [#11364](https://github.com/astral-sh/uv/pull/11364))
- Detect infinite recursion in `uv run` ([#11386](https://github.com/astral-sh/uv/pull/11386))

### Python

The managed Python distributions have been updated, including:

- CPython 3.14.0a5, which includes a new
  [tail calling interpreter](https://docs.python.org/3.14/whatsnew/3.14.html#whatsnew314-tail-call)
  for a significant performance improvement
- The bundled OpenSSL version was updated from 3.0.15 to 3.0.16 which fixes a
  [security advisory](https://openssl-library.org/news/secadv/20241016.txt)

See the
[`python-build-standalone` release notes](https://github.com/astral-sh/python-build-standalone/releases/tag/20250212)
for more details.

### Bug fixes

- Fix cross-drive script installation ([#11167](https://github.com/astral-sh/uv/pull/11167))
- Add indexes in priority order ([#11451](https://github.com/astral-sh/uv/pull/11451))
- Allow `--python <dir>` requests to match existing environments if `sys.executable` is the same
  file ([#11290](https://github.com/astral-sh/uv/pull/11290))
- Avoid comparing to system site packages in `--dry-run` mode
  ([#11427](https://github.com/astral-sh/uv/pull/11427))
- Prefer running executables in the environment with `<name>` over `<name>/__main__.py`
  ([#11431](https://github.com/astral-sh/uv/pull/11431))
- Retry local clones without hardlinks if they fail
  ([#11421](https://github.com/astral-sh/uv/pull/11421))

### Documentation

- Update alternative-indexes.md to use `UV_INDEX` instead of `UV_EXTRA_INDEX_URL`
  ([#11381](https://github.com/astral-sh/uv/pull/11381))
- Update scripts guide to include using package indexes
  ([#11443](https://github.com/astral-sh/uv/pull/11443))
