// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package acl_runtime

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// AddPayloadRuntimeACLCreatedCode is the HTTP code returned for type AddPayloadRuntimeACLCreated
const AddPayloadRuntimeACLCreatedCode int = 201

/*
AddPayloadRuntimeACLCreated ACL payload added

swagger:response addPayloadRuntimeAclCreated
*/
type AddPayloadRuntimeACLCreated struct {

	/*
	  In: Body
	*/
	Payload models.ACLFilesEntries `json:"body,omitempty"`
}

// NewAddPayloadRuntimeACLCreated creates AddPayloadRuntimeACLCreated with default headers values
func NewAddPayloadRuntimeACLCreated() *AddPayloadRuntimeACLCreated {

	return &AddPayloadRuntimeACLCreated{}
}

// WithPayload adds the payload to the add payload runtime Acl created response
func (o *AddPayloadRuntimeACLCreated) WithPayload(payload models.ACLFilesEntries) *AddPayloadRuntimeACLCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add payload runtime Acl created response
func (o *AddPayloadRuntimeACLCreated) SetPayload(payload models.ACLFilesEntries) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddPayloadRuntimeACLCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.ACLFilesEntries{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// AddPayloadRuntimeACLBadRequestCode is the HTTP code returned for type AddPayloadRuntimeACLBadRequest
const AddPayloadRuntimeACLBadRequestCode int = 400

/*
AddPayloadRuntimeACLBadRequest Bad request

swagger:response addPayloadRuntimeAclBadRequest
*/
type AddPayloadRuntimeACLBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewAddPayloadRuntimeACLBadRequest creates AddPayloadRuntimeACLBadRequest with default headers values
func NewAddPayloadRuntimeACLBadRequest() *AddPayloadRuntimeACLBadRequest {

	return &AddPayloadRuntimeACLBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the add payload runtime Acl bad request response
func (o *AddPayloadRuntimeACLBadRequest) WithConfigurationVersion(configurationVersion string) *AddPayloadRuntimeACLBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the add payload runtime Acl bad request response
func (o *AddPayloadRuntimeACLBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the add payload runtime Acl bad request response
func (o *AddPayloadRuntimeACLBadRequest) WithPayload(payload *models.Error) *AddPayloadRuntimeACLBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add payload runtime Acl bad request response
func (o *AddPayloadRuntimeACLBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddPayloadRuntimeACLBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
AddPayloadRuntimeACLDefault General Error

swagger:response addPayloadRuntimeAclDefault
*/
type AddPayloadRuntimeACLDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewAddPayloadRuntimeACLDefault creates AddPayloadRuntimeACLDefault with default headers values
func NewAddPayloadRuntimeACLDefault(code int) *AddPayloadRuntimeACLDefault {
	if code <= 0 {
		code = 500
	}

	return &AddPayloadRuntimeACLDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the add payload runtime ACL default response
func (o *AddPayloadRuntimeACLDefault) WithStatusCode(code int) *AddPayloadRuntimeACLDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the add payload runtime ACL default response
func (o *AddPayloadRuntimeACLDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the add payload runtime ACL default response
func (o *AddPayloadRuntimeACLDefault) WithConfigurationVersion(configurationVersion string) *AddPayloadRuntimeACLDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the add payload runtime ACL default response
func (o *AddPayloadRuntimeACLDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the add payload runtime ACL default response
func (o *AddPayloadRuntimeACLDefault) WithPayload(payload *models.Error) *AddPayloadRuntimeACLDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add payload runtime ACL default response
func (o *AddPayloadRuntimeACLDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddPayloadRuntimeACLDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
