// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_after_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetHTTPAfterResponseRuleFrontendOKCode is the HTTP code returned for type GetHTTPAfterResponseRuleFrontendOK
const GetHTTPAfterResponseRuleFrontendOKCode int = 200

/*
GetHTTPAfterResponseRuleFrontendOK Successful operation

swagger:response getHttpAfterResponseRuleFrontendOK
*/
type GetHTTPAfterResponseRuleFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.HTTPAfterResponseRule `json:"body,omitempty"`
}

// NewGetHTTPAfterResponseRuleFrontendOK creates GetHTTPAfterResponseRuleFrontendOK with default headers values
func NewGetHTTPAfterResponseRuleFrontendOK() *GetHTTPAfterResponseRuleFrontendOK {

	return &GetHTTPAfterResponseRuleFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http after response rule frontend o k response
func (o *GetHTTPAfterResponseRuleFrontendOK) WithConfigurationVersion(configurationVersion string) *GetHTTPAfterResponseRuleFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http after response rule frontend o k response
func (o *GetHTTPAfterResponseRuleFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http after response rule frontend o k response
func (o *GetHTTPAfterResponseRuleFrontendOK) WithPayload(payload *models.HTTPAfterResponseRule) *GetHTTPAfterResponseRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http after response rule frontend o k response
func (o *GetHTTPAfterResponseRuleFrontendOK) SetPayload(payload *models.HTTPAfterResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPAfterResponseRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetHTTPAfterResponseRuleFrontendNotFoundCode is the HTTP code returned for type GetHTTPAfterResponseRuleFrontendNotFound
const GetHTTPAfterResponseRuleFrontendNotFoundCode int = 404

/*
GetHTTPAfterResponseRuleFrontendNotFound The specified resource was not found

swagger:response getHttpAfterResponseRuleFrontendNotFound
*/
type GetHTTPAfterResponseRuleFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPAfterResponseRuleFrontendNotFound creates GetHTTPAfterResponseRuleFrontendNotFound with default headers values
func NewGetHTTPAfterResponseRuleFrontendNotFound() *GetHTTPAfterResponseRuleFrontendNotFound {

	return &GetHTTPAfterResponseRuleFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http after response rule frontend not found response
func (o *GetHTTPAfterResponseRuleFrontendNotFound) WithConfigurationVersion(configurationVersion string) *GetHTTPAfterResponseRuleFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http after response rule frontend not found response
func (o *GetHTTPAfterResponseRuleFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http after response rule frontend not found response
func (o *GetHTTPAfterResponseRuleFrontendNotFound) WithPayload(payload *models.Error) *GetHTTPAfterResponseRuleFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http after response rule frontend not found response
func (o *GetHTTPAfterResponseRuleFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPAfterResponseRuleFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetHTTPAfterResponseRuleFrontendDefault General Error

swagger:response getHttpAfterResponseRuleFrontendDefault
*/
type GetHTTPAfterResponseRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPAfterResponseRuleFrontendDefault creates GetHTTPAfterResponseRuleFrontendDefault with default headers values
func NewGetHTTPAfterResponseRuleFrontendDefault(code int) *GetHTTPAfterResponseRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetHTTPAfterResponseRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get HTTP after response rule frontend default response
func (o *GetHTTPAfterResponseRuleFrontendDefault) WithStatusCode(code int) *GetHTTPAfterResponseRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get HTTP after response rule frontend default response
func (o *GetHTTPAfterResponseRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get HTTP after response rule frontend default response
func (o *GetHTTPAfterResponseRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetHTTPAfterResponseRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get HTTP after response rule frontend default response
func (o *GetHTTPAfterResponseRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get HTTP after response rule frontend default response
func (o *GetHTTPAfterResponseRuleFrontendDefault) WithPayload(payload *models.Error) *GetHTTPAfterResponseRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get HTTP after response rule frontend default response
func (o *GetHTTPAfterResponseRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPAfterResponseRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
