// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package spoe

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateSpoeMessageCreatedCode is the HTTP code returned for type CreateSpoeMessageCreated
const CreateSpoeMessageCreatedCode int = 201

/*
CreateSpoeMessageCreated Spoe message created

swagger:response createSpoeMessageCreated
*/
type CreateSpoeMessageCreated struct {

	/*
	  In: Body
	*/
	Payload *models.SpoeMessage `json:"body,omitempty"`
}

// NewCreateSpoeMessageCreated creates CreateSpoeMessageCreated with default headers values
func NewCreateSpoeMessageCreated() *CreateSpoeMessageCreated {

	return &CreateSpoeMessageCreated{}
}

// WithPayload adds the payload to the create spoe message created response
func (o *CreateSpoeMessageCreated) WithPayload(payload *models.SpoeMessage) *CreateSpoeMessageCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create spoe message created response
func (o *CreateSpoeMessageCreated) SetPayload(payload *models.SpoeMessage) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateSpoeMessageCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateSpoeMessageBadRequestCode is the HTTP code returned for type CreateSpoeMessageBadRequest
const CreateSpoeMessageBadRequestCode int = 400

/*
CreateSpoeMessageBadRequest Bad request

swagger:response createSpoeMessageBadRequest
*/
type CreateSpoeMessageBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateSpoeMessageBadRequest creates CreateSpoeMessageBadRequest with default headers values
func NewCreateSpoeMessageBadRequest() *CreateSpoeMessageBadRequest {

	return &CreateSpoeMessageBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create spoe message bad request response
func (o *CreateSpoeMessageBadRequest) WithConfigurationVersion(configurationVersion string) *CreateSpoeMessageBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create spoe message bad request response
func (o *CreateSpoeMessageBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create spoe message bad request response
func (o *CreateSpoeMessageBadRequest) WithPayload(payload *models.Error) *CreateSpoeMessageBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create spoe message bad request response
func (o *CreateSpoeMessageBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateSpoeMessageBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateSpoeMessageConflictCode is the HTTP code returned for type CreateSpoeMessageConflict
const CreateSpoeMessageConflictCode int = 409

/*
CreateSpoeMessageConflict The specified resource already exists

swagger:response createSpoeMessageConflict
*/
type CreateSpoeMessageConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateSpoeMessageConflict creates CreateSpoeMessageConflict with default headers values
func NewCreateSpoeMessageConflict() *CreateSpoeMessageConflict {

	return &CreateSpoeMessageConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create spoe message conflict response
func (o *CreateSpoeMessageConflict) WithConfigurationVersion(configurationVersion string) *CreateSpoeMessageConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create spoe message conflict response
func (o *CreateSpoeMessageConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create spoe message conflict response
func (o *CreateSpoeMessageConflict) WithPayload(payload *models.Error) *CreateSpoeMessageConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create spoe message conflict response
func (o *CreateSpoeMessageConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateSpoeMessageConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateSpoeMessageDefault General Error

swagger:response createSpoeMessageDefault
*/
type CreateSpoeMessageDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateSpoeMessageDefault creates CreateSpoeMessageDefault with default headers values
func NewCreateSpoeMessageDefault(code int) *CreateSpoeMessageDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateSpoeMessageDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create spoe message default response
func (o *CreateSpoeMessageDefault) WithStatusCode(code int) *CreateSpoeMessageDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create spoe message default response
func (o *CreateSpoeMessageDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create spoe message default response
func (o *CreateSpoeMessageDefault) WithConfigurationVersion(configurationVersion string) *CreateSpoeMessageDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create spoe message default response
func (o *CreateSpoeMessageDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create spoe message default response
func (o *CreateSpoeMessageDefault) WithPayload(payload *models.Error) *CreateSpoeMessageDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create spoe message default response
func (o *CreateSpoeMessageDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateSpoeMessageDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
