// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllTCPResponseRuleBackendOKCode is the HTTP code returned for type ReplaceAllTCPResponseRuleBackendOK
const ReplaceAllTCPResponseRuleBackendOKCode int = 200

/*
ReplaceAllTCPResponseRuleBackendOK All TCP Response Rule lines replaced

swagger:response replaceAllTcpResponseRuleBackendOK
*/
type ReplaceAllTCPResponseRuleBackendOK struct {

	/*
	  In: Body
	*/
	Payload models.TCPResponseRules `json:"body,omitempty"`
}

// NewReplaceAllTCPResponseRuleBackendOK creates ReplaceAllTCPResponseRuleBackendOK with default headers values
func NewReplaceAllTCPResponseRuleBackendOK() *ReplaceAllTCPResponseRuleBackendOK {

	return &ReplaceAllTCPResponseRuleBackendOK{}
}

// WithPayload adds the payload to the replace all Tcp response rule backend o k response
func (o *ReplaceAllTCPResponseRuleBackendOK) WithPayload(payload models.TCPResponseRules) *ReplaceAllTCPResponseRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Tcp response rule backend o k response
func (o *ReplaceAllTCPResponseRuleBackendOK) SetPayload(payload models.TCPResponseRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPResponseRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.TCPResponseRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllTCPResponseRuleBackendAcceptedCode is the HTTP code returned for type ReplaceAllTCPResponseRuleBackendAccepted
const ReplaceAllTCPResponseRuleBackendAcceptedCode int = 202

/*
ReplaceAllTCPResponseRuleBackendAccepted Configuration change accepted and reload requested

swagger:response replaceAllTcpResponseRuleBackendAccepted
*/
type ReplaceAllTCPResponseRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.TCPResponseRules `json:"body,omitempty"`
}

// NewReplaceAllTCPResponseRuleBackendAccepted creates ReplaceAllTCPResponseRuleBackendAccepted with default headers values
func NewReplaceAllTCPResponseRuleBackendAccepted() *ReplaceAllTCPResponseRuleBackendAccepted {

	return &ReplaceAllTCPResponseRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace all Tcp response rule backend accepted response
func (o *ReplaceAllTCPResponseRuleBackendAccepted) WithReloadID(reloadID string) *ReplaceAllTCPResponseRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all Tcp response rule backend accepted response
func (o *ReplaceAllTCPResponseRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all Tcp response rule backend accepted response
func (o *ReplaceAllTCPResponseRuleBackendAccepted) WithPayload(payload models.TCPResponseRules) *ReplaceAllTCPResponseRuleBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Tcp response rule backend accepted response
func (o *ReplaceAllTCPResponseRuleBackendAccepted) SetPayload(payload models.TCPResponseRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPResponseRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.TCPResponseRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllTCPResponseRuleBackendBadRequestCode is the HTTP code returned for type ReplaceAllTCPResponseRuleBackendBadRequest
const ReplaceAllTCPResponseRuleBackendBadRequestCode int = 400

/*
ReplaceAllTCPResponseRuleBackendBadRequest Bad request

swagger:response replaceAllTcpResponseRuleBackendBadRequest
*/
type ReplaceAllTCPResponseRuleBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllTCPResponseRuleBackendBadRequest creates ReplaceAllTCPResponseRuleBackendBadRequest with default headers values
func NewReplaceAllTCPResponseRuleBackendBadRequest() *ReplaceAllTCPResponseRuleBackendBadRequest {

	return &ReplaceAllTCPResponseRuleBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all Tcp response rule backend bad request response
func (o *ReplaceAllTCPResponseRuleBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllTCPResponseRuleBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all Tcp response rule backend bad request response
func (o *ReplaceAllTCPResponseRuleBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all Tcp response rule backend bad request response
func (o *ReplaceAllTCPResponseRuleBackendBadRequest) WithPayload(payload *models.Error) *ReplaceAllTCPResponseRuleBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Tcp response rule backend bad request response
func (o *ReplaceAllTCPResponseRuleBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPResponseRuleBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllTCPResponseRuleBackendDefault General Error

swagger:response replaceAllTcpResponseRuleBackendDefault
*/
type ReplaceAllTCPResponseRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllTCPResponseRuleBackendDefault creates ReplaceAllTCPResponseRuleBackendDefault with default headers values
func NewReplaceAllTCPResponseRuleBackendDefault(code int) *ReplaceAllTCPResponseRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllTCPResponseRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all TCP response rule backend default response
func (o *ReplaceAllTCPResponseRuleBackendDefault) WithStatusCode(code int) *ReplaceAllTCPResponseRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all TCP response rule backend default response
func (o *ReplaceAllTCPResponseRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all TCP response rule backend default response
func (o *ReplaceAllTCPResponseRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllTCPResponseRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all TCP response rule backend default response
func (o *ReplaceAllTCPResponseRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all TCP response rule backend default response
func (o *ReplaceAllTCPResponseRuleBackendDefault) WithPayload(payload *models.Error) *ReplaceAllTCPResponseRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all TCP response rule backend default response
func (o *ReplaceAllTCPResponseRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllTCPResponseRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
