/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import java.util.regex.Pattern;

public enum TLineType {
    PLAIN,
    AFFECTATION_DEFINE,
    AFFECTATION,
    ASSERT,
    IF,
    IFDEF,
    UNDEF,
    IFNDEF,
    ELSE,
    ELSEIF,
    ENDIF,
    WHILE,
    ENDWHILE,
    FOREACH,
    ENDFOREACH,
    DECLARE_RETURN_FUNCTION,
    DECLARE_PROCEDURE,
    END_FUNCTION,
    RETURN,
    LEGACY_DEFINE,
    LEGACY_DEFINELONG,
    THEME,
    INCLUDE,
    INCLUDE_SPRITES,
    INCLUDE_DEF,
    IMPORT,
    STARTSUB,
    ENDSUB,
    INCLUDESUB,
    LOG,
    DUMP_MEMORY,
    COMMENT_SIMPLE,
    COMMENT_LONG_START,
    OPTION;

    private static final Pattern PATTERN_LEGACY_DEFINE;
    private static final Pattern PATTERN_LEGACY_DEFINELONG;
    private static final Pattern PATTERN_AFFECTATION_DEFINE;
    private static final Pattern PATTERN_AFFECTATION;
    private static final Pattern PATTERN_COMMENT_SIMPLE1;
    private static final Pattern PATTERN_COMMENT_SIMPLE2;
    private static final Pattern PATTERN_COMMENT_LONG_START;
    private static final Pattern PATTERN_IFDEF;
    private static final Pattern PATTERN_UNDEF;
    private static final Pattern PATTERN_IFNDEF;
    private static final Pattern PATTERN_ASSERT;
    private static final Pattern PATTERN_IF;
    private static final Pattern PATTERN_DECLARE_RETURN_FUNCTION;
    private static final Pattern PATTERN_DECLARE_PROCEDURE;
    private static final Pattern PATTERN_ELSE;
    private static final Pattern PATTERN_ELSEIF;
    private static final Pattern PATTERN_ENDIF;
    private static final Pattern PATTERN_WHILE;
    private static final Pattern PATTERN_ENDWHILE;
    private static final Pattern PATTERN_FOREACH;
    private static final Pattern PATTERN_ENDFOREACH;
    private static final Pattern PATTERN_END_FUNCTION;
    private static final Pattern PATTERN_RETURN;
    private static final Pattern PATTERN_THEME;
    private static final Pattern PATTERN_INCLUDE;
    private static final Pattern PATTERN_INCLUDE_SPRITES;
    private static final Pattern PATTERN_INCLUDE_DEF;
    private static final Pattern PATTERN_IMPORT;
    private static final Pattern PATTERN_STARTSUB;
    private static final Pattern PATTERN_ENDSUB;
    private static final Pattern PATTERN_INCLUDESUB;
    private static final Pattern PATTERN_LOG;
    private static final Pattern PATTERN_DUMP_MEMORY;
    private static final Pattern PATTERN_OPTION;

    public static TLineType getFromLineInternal(String s) {
        if (PATTERN_LEGACY_DEFINE.matcher(s).matches()) {
            return LEGACY_DEFINE;
        }
        if (PATTERN_LEGACY_DEFINELONG.matcher(s).matches()) {
            return LEGACY_DEFINELONG;
        }
        if (PATTERN_AFFECTATION_DEFINE.matcher(s).matches()) {
            return AFFECTATION_DEFINE;
        }
        if (PATTERN_AFFECTATION.matcher(s).matches()) {
            return AFFECTATION;
        }
        if (PATTERN_COMMENT_SIMPLE1.matcher(s).matches()) {
            return COMMENT_SIMPLE;
        }
        if (PATTERN_COMMENT_SIMPLE2.matcher(s).matches()) {
            return COMMENT_SIMPLE;
        }
        if (PATTERN_COMMENT_LONG_START.matcher(s).matches() && !s.contains("'/")) {
            return COMMENT_LONG_START;
        }
        if (PATTERN_IFDEF.matcher(s).matches()) {
            return IFDEF;
        }
        if (PATTERN_UNDEF.matcher(s).matches()) {
            return UNDEF;
        }
        if (PATTERN_IFNDEF.matcher(s).matches()) {
            return IFNDEF;
        }
        if (PATTERN_ASSERT.matcher(s).matches()) {
            return ASSERT;
        }
        if (PATTERN_IF.matcher(s).matches()) {
            return IF;
        }
        if (PATTERN_DECLARE_RETURN_FUNCTION.matcher(s).matches()) {
            return DECLARE_RETURN_FUNCTION;
        }
        if (PATTERN_DECLARE_PROCEDURE.matcher(s).matches()) {
            return DECLARE_PROCEDURE;
        }
        if (PATTERN_ELSE.matcher(s).matches()) {
            return ELSE;
        }
        if (PATTERN_ELSEIF.matcher(s).matches()) {
            return ELSEIF;
        }
        if (PATTERN_ENDIF.matcher(s).matches()) {
            return ENDIF;
        }
        if (PATTERN_WHILE.matcher(s).matches()) {
            return WHILE;
        }
        if (PATTERN_ENDWHILE.matcher(s).matches()) {
            return ENDWHILE;
        }
        if (PATTERN_FOREACH.matcher(s).matches()) {
            return FOREACH;
        }
        if (PATTERN_ENDFOREACH.matcher(s).matches()) {
            return ENDFOREACH;
        }
        if (PATTERN_END_FUNCTION.matcher(s).matches()) {
            return END_FUNCTION;
        }
        if (PATTERN_RETURN.matcher(s).matches()) {
            return RETURN;
        }
        if (PATTERN_THEME.matcher(s).matches()) {
            return THEME;
        }
        if (PATTERN_INCLUDE.matcher(s).matches()) {
            return INCLUDE;
        }
        if (PATTERN_INCLUDE_SPRITES.matcher(s).matches()) {
            return INCLUDE_SPRITES;
        }
        if (PATTERN_INCLUDE_DEF.matcher(s).matches()) {
            return INCLUDE_DEF;
        }
        if (PATTERN_IMPORT.matcher(s).matches()) {
            return IMPORT;
        }
        if (PATTERN_STARTSUB.matcher(s).matches()) {
            return STARTSUB;
        }
        if (PATTERN_ENDSUB.matcher(s).matches()) {
            return ENDSUB;
        }
        if (PATTERN_INCLUDESUB.matcher(s).matches()) {
            return INCLUDESUB;
        }
        if (PATTERN_LOG.matcher(s).matches()) {
            return LOG;
        }
        if (PATTERN_DUMP_MEMORY.matcher(s).matches()) {
            return DUMP_MEMORY;
        }
        if (PATTERN_OPTION.matcher(s).matches()) {
            return OPTION;
        }
        return PLAIN;
    }

    public static boolean isQuote(char ch) {
        return ch == '\"' || ch == '\'';
    }

    public static boolean isLetterOrUnderscoreOrDigit(char ch) {
        return TLineType.isLetterOrUnderscore(ch) || TLineType.isLatinDigit(ch);
    }

    public static boolean isLetterOrUnderscore(char ch) {
        return TLineType.isLetter(ch) || ch == '_';
    }

    public static boolean isLetterOrUnderscoreOrDollar(char ch) {
        return TLineType.isLetterOrUnderscore(ch) || ch == '$';
    }

    public static boolean isLetterOrDigit(char ch) {
        return TLineType.isLetter(ch) || TLineType.isLatinDigit(ch);
    }

    public static boolean isLetter(char ch) {
        return Character.isLetter(ch);
    }

    public static boolean isSpaceChar(char ch) {
        return Character.isSpaceChar(ch);
    }

    public static boolean isLatinDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    static {
        PATTERN_LEGACY_DEFINE = Pattern.compile("^\\s*!define\\s+[\\p{L}_][\\p{L}_0-9]*\\(.*");
        PATTERN_LEGACY_DEFINELONG = Pattern.compile("^\\s*!definelong\\s+[\\p{L}_][\\p{L}_0-9]*\\b.*");
        PATTERN_AFFECTATION_DEFINE = Pattern.compile("^\\s*!define\\s+[\\p{L}_][\\p{L}_0-9]*\\b.*");
        PATTERN_AFFECTATION = Pattern.compile("^\\s*!\\s*(local|global)?\\s*\\$?[\\p{L}_][\\p{L}_0-9]*\\s*\\??=.*");
        PATTERN_COMMENT_SIMPLE1 = Pattern.compile("^\\s*'.*");
        PATTERN_COMMENT_SIMPLE2 = Pattern.compile("^\\s*/'.*'/\\s*$");
        PATTERN_COMMENT_LONG_START = Pattern.compile("^\\s*/'.*");
        PATTERN_IFDEF = Pattern.compile("^\\s*!ifdef\\s+.*");
        PATTERN_UNDEF = Pattern.compile("^\\s*!undef\\s+.*");
        PATTERN_IFNDEF = Pattern.compile("^\\s*!ifndef\\s+.*");
        PATTERN_ASSERT = Pattern.compile("^\\s*!assert\\s+.*");
        PATTERN_IF = Pattern.compile("^\\s*!if\\s+.*");
        PATTERN_DECLARE_RETURN_FUNCTION = Pattern.compile("^\\s*!(unquoted\\s|final\\s)*(function)\\s+\\$?[\\p{L}_][\\p{L}_0-9]*.*");
        PATTERN_DECLARE_PROCEDURE = Pattern.compile("^\\s*!(unquoted\\s|final\\s)*(procedure)\\s+\\$?[\\p{L}_][\\p{L}_0-9]*.*");
        PATTERN_ELSE = Pattern.compile("^\\s*!else\\b.*");
        PATTERN_ELSEIF = Pattern.compile("^\\s*!elseif\\b.*");
        PATTERN_ENDIF = Pattern.compile("^\\s*!endif\\b.*");
        PATTERN_WHILE = Pattern.compile("^\\s*!while\\s+.*");
        PATTERN_ENDWHILE = Pattern.compile("^\\s*!endwhile\\b.*");
        PATTERN_FOREACH = Pattern.compile("^\\s*!foreach\\s+.*");
        PATTERN_ENDFOREACH = Pattern.compile("^\\s*!endfor\\b.*");
        PATTERN_END_FUNCTION = Pattern.compile("^\\s*!(end\\s*function|end\\s*definelong|end\\s*procedure)\\b.*");
        PATTERN_RETURN = Pattern.compile("^\\s*!return\\b.*");
        PATTERN_THEME = Pattern.compile("^\\s*!theme\\b.*");
        PATTERN_INCLUDE = Pattern.compile("^\\s*!(include|includeurl|include_many|include_once)\\b.*");
        PATTERN_INCLUDE_SPRITES = Pattern.compile("^\\s*!(include_sprites)\\b.*");
        PATTERN_INCLUDE_DEF = Pattern.compile("^\\s*!(includedef)\\b.*");
        PATTERN_IMPORT = Pattern.compile("^\\s*!(import)\\b.*");
        PATTERN_STARTSUB = Pattern.compile("^\\s*!startsub\\s+.*");
        PATTERN_ENDSUB = Pattern.compile("^\\s*!endsub\\b.*");
        PATTERN_INCLUDESUB = Pattern.compile("^\\s*!includesub\\b.*");
        PATTERN_LOG = Pattern.compile("^\\s*!(log)\\b.*");
        PATTERN_DUMP_MEMORY = Pattern.compile("^\\s*!(dump_memory)\\b.*");
        PATTERN_OPTION = Pattern.compile("^\\s*!option\\b.*");
    }
}

