/*
 * Decompiled with CFR 0.152.
 */
package pl.com.salsoft.sqlitestudioremote.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import pl.com.salsoft.sqlitestudioremote.internal.AuthService;
import pl.com.salsoft.sqlitestudioremote.internal.Utils;

public class AuthServiceImpl
implements AuthService {
    private String password;
    private List<Pattern> ipBlackList;
    private List<Pattern> ipWhiteList;

    public AuthServiceImpl(String password, List<String> ipBlackList, List<String> ipWhiteList) {
        this.password = password;
        if (ipBlackList != null) {
            this.ipBlackList = new ArrayList<Pattern>();
            for (String ipBlack : ipBlackList) {
                this.ipBlackList.add(Pattern.compile(Utils.createRegexFromGlob(ipBlack)));
            }
        }
        if (ipWhiteList != null) {
            this.ipWhiteList = new ArrayList<Pattern>();
            for (String ipWhite : ipWhiteList) {
                this.ipWhiteList.add(Pattern.compile(Utils.createRegexFromGlob(ipWhite)));
            }
        }
    }

    @Override
    public boolean isAuthRequired() {
        return this.password != null && !this.password.isEmpty();
    }

    @Override
    public boolean authorize(String password) {
        return password != null && password.equals(this.password);
    }

    @Override
    public boolean isIpAllowed(String ip) {
        if (this.ipBlackList == null) {
            return true;
        }
        boolean allowed = true;
        for (Pattern blackIp : this.ipBlackList) {
            if (!blackIp.matcher(ip).matches()) continue;
            allowed = false;
            break;
        }
        if (this.ipWhiteList == null) {
            return allowed;
        }
        for (Pattern whiteIp : this.ipWhiteList) {
            if (!whiteIp.matcher(ip).matches()) continue;
            allowed = true;
            break;
        }
        return allowed;
    }
}

