/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionOwner;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.jiter.MonoIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public final class Operand
implements Iterable<Operand>,
ExpressionOwner {
    private Expression parentExpression;
    private Expression childExpression;
    private OperandRole role;
    private static boolean DEBUG = false;

    public Operand(Expression parentExpression, Expression childExpression, OperandRole role) {
        this.parentExpression = parentExpression;
        this.role = role;
        this.setChildExpression(childExpression);
    }

    public Expression getParentExpression() {
        return this.parentExpression;
    }

    public Expression getChildExpression() {
        return this.childExpression;
    }

    @Override
    public void setChildExpression(Expression childExpression) {
        if (childExpression != this.childExpression) {
            if (this.role.isConstrainedClass() && this.childExpression != null && childExpression.getClass() != this.childExpression.getClass()) {
                throw new AssertionError();
            }
            this.childExpression = childExpression;
            this.parentExpression.adoptChildExpression(childExpression);
            this.parentExpression.resetLocalStaticProperties();
        }
    }

    public void detachChild() {
        if (DEBUG) {
            this.childExpression.setParentExpression(null);
            StringWriter sw = new StringWriter();
            new XPathException("dummy").printStackTrace(new PrintWriter(sw));
            this.childExpression = new ErrorExpression("child expression has been detached: " + sw.toString(), "ZZZ", false);
            ExpressionTool.copyLocationInfo(this.parentExpression, this.childExpression);
        }
    }

    public OperandRole getOperandRole() {
        return this.role;
    }

    public void setOperandRole(OperandRole role) {
        this.role = role;
    }

    public boolean setsNewFocus() {
        return this.role.setsNewFocus();
    }

    public boolean hasSpecialFocusRules() {
        return this.role.hasSpecialFocusRules();
    }

    public boolean hasSameFocus() {
        return this.role.hasSameFocus();
    }

    public boolean isEvaluatedRepeatedly() {
        return this.role.isEvaluatedRepeatedly();
    }

    public OperandUsage getUsage() {
        return this.role.getUsage();
    }

    public void setUsage(OperandUsage usage) {
        this.role = new OperandRole(this.role.properties, usage, this.role.getRequiredType());
    }

    public SequenceType getRequiredType() {
        return this.role.getRequiredType();
    }

    public boolean isInChoiceGroup() {
        return this.role.isInChoiceGroup();
    }

    @Override
    public Iterator<Operand> iterator() {
        return new MonoIterator<Operand>(this);
    }

    public void typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        try {
            this.setChildExpression(this.getChildExpression().typeCheck(visitor, contextInfo));
        }
        catch (XPathException e) {
            e.maybeSetLocation(this.getChildExpression().getLocation());
            if (!e.isReportableStatically()) {
                visitor.getStaticContext().issueWarning("Evaluation will always throw a dynamic error: " + e.getMessage(), this.getChildExpression().getLocation());
                this.setChildExpression(new ErrorExpression(e));
            }
            throw e;
        }
    }

    public void optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        try {
            this.setChildExpression(this.getChildExpression().optimize(visitor, contextInfo));
        }
        catch (XPathException e) {
            e.maybeSetLocation(this.getChildExpression().getLocation());
            if (!e.isReportableStatically()) {
                visitor.getStaticContext().issueWarning("Evaluation will always throw a dynamic error: " + e.getMessage(), this.getChildExpression().getLocation());
                this.setChildExpression(new ErrorExpression(e));
            }
            throw e;
        }
    }

    public static OperandUsage typeDeterminedUsage(ItemType type) {
        if (type.isPlainType()) {
            return OperandUsage.ABSORPTION;
        }
        if (type instanceof NodeTest || type == AnyItemType.getInstance()) {
            return OperandUsage.NAVIGATION;
        }
        return OperandUsage.INSPECTION;
    }
}

