/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.sse;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseEventSink;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.events.Event;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.SseBroadcaster;
import org.openhab.core.io.rest.sse.internal.SseItemStatesEventBuilder;
import org.openhab.core.io.rest.sse.internal.SsePublisher;
import org.openhab.core.io.rest.sse.internal.SseSinkItemInfo;
import org.openhab.core.io.rest.sse.internal.SseSinkTopicInfo;
import org.openhab.core.io.rest.sse.internal.dto.EventDTO;
import org.openhab.core.io.rest.sse.internal.util.SseUtil;
import org.openhab.core.items.events.ItemStateChangedEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="events")
@RolesAllowed(value={"user", "administrator"})
@Tag(name="events")
@Component(service={RESTResource.class, SsePublisher.class})
@JaxrsResource
@JaxrsName(value="events")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class SseResource
implements RESTResource,
SsePublisher {
    public static final String PATH_EVENTS = "events";
    private static final String X_ACCEL_BUFFERING_HEADER = "X-Accel-Buffering";
    public static final int ALIVE_INTERVAL_SECONDS = 10;
    private final Logger logger = LoggerFactory.getLogger(SseResource.class);
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"common");
    private final ScheduledFuture<?> aliveEventJob;
    @Context
    @NonNullByDefault(value={})
    private Sse sse;
    private final SseBroadcaster<SseSinkItemInfo> itemStatesBroadcaster = new SseBroadcaster();
    private final SseItemStatesEventBuilder itemStatesEventBuilder;
    private final SseBroadcaster<SseSinkTopicInfo> topicBroadcaster = new SseBroadcaster();
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Activate
    public SseResource(@Reference SseItemStatesEventBuilder itemStatesEventBuilder) {
        this.itemStatesEventBuilder = itemStatesEventBuilder;
        this.aliveEventJob = this.scheduler.scheduleWithFixedDelay(() -> {
            if (this.sse != null) {
                this.logger.debug("Sending alive event to SSE connections");
                OutboundSseEvent aliveEvent = this.sse.newEventBuilder().name("alive").mediaType(MediaType.APPLICATION_JSON_TYPE).data((Object)new AliveEvent()).build();
                this.itemStatesBroadcaster.send(aliveEvent);
                this.topicBroadcaster.send(aliveEvent);
            }
        }, 1L, 10L, TimeUnit.SECONDS);
    }

    @Deactivate
    public void deactivate() {
        this.itemStatesBroadcaster.close();
        this.topicBroadcaster.close();
        this.executorService.shutdown();
        this.aliveEventJob.cancel(true);
    }

    @Override
    public void broadcast(Event event) {
        if (this.sse == null) {
            this.logger.trace("broadcast skipped (no one listened since activation)");
            return;
        }
        this.executorService.execute(() -> {
            this.handleEventBroadcastTopic(event);
            if (event instanceof ItemStateChangedEvent) {
                ItemStateChangedEvent changedEvent = (ItemStateChangedEvent)event;
                this.handleEventBroadcastItemState(changedEvent);
            }
        });
    }

    private void addCommonResponseHeaders(HttpServletResponse response) {
        response.addHeader(X_ACCEL_BUFFERING_HEADER, "no");
        response.addHeader("Content-Encoding", "identity");
        try {
            response.flushBuffer();
        }
        catch (IOException ex) {
            this.logger.trace("flush buffer failed", (Throwable)ex);
        }
    }

    @GET
    @Produces(value={"text/event-stream"})
    @Operation(operationId="getEvents", summary="Get all events.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Topic is empty or contains invalid characters")})
    public void listen(@Context SseEventSink sseEventSink, @Context HttpServletResponse response, @QueryParam(value="topics") @Parameter(description="topics") String eventFilter) {
        if (!SseUtil.isValidTopicFilter(eventFilter)) {
            response.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
            return;
        }
        this.topicBroadcaster.add(sseEventSink, (Object)new SseSinkTopicInfo(eventFilter));
        this.addCommonResponseHeaders(response);
    }

    private void handleEventBroadcastTopic(Event event) {
        EventDTO eventDTO = SseUtil.buildDTO(event);
        OutboundSseEvent sseEvent = SseUtil.buildEvent(this.sse.newEventBuilder(), eventDTO);
        this.topicBroadcaster.sendIf(sseEvent, SseSinkTopicInfo.matchesTopic(eventDTO.topic));
    }

    @GET
    @Path(value="/states")
    @Produces(value={"text/event-stream"})
    @Operation(operationId="initNewStateTacker", summary="Initiates a new item state tracker connection", responses={@ApiResponse(responseCode="200", description="OK")})
    public void getStateEvents(@Context SseEventSink sseEventSink, @Context HttpServletResponse response) {
        SseSinkItemInfo sinkItemInfo = new SseSinkItemInfo();
        this.itemStatesBroadcaster.add(sseEventSink, (Object)sinkItemInfo);
        this.addCommonResponseHeaders(response);
        String connectionId = sinkItemInfo.getConnectionId();
        OutboundSseEvent readyEvent = this.sse.newEventBuilder().id("0").name("ready").data((Object)connectionId).build();
        this.itemStatesBroadcaster.sendIf(readyEvent, SseSinkItemInfo.hasConnectionId(connectionId));
    }

    @POST
    @Path(value="/states/{connectionId}")
    @Operation(operationId="updateItemListForStateUpdates", summary="Changes the list of items a SSE connection will receive state updates to.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Unknown connectionId")})
    public Object updateTrackedItems(@PathParam(value="connectionId") @Nullable String connectionId, @Parameter(description="items") @Nullable Set<String> itemNames) {
        if (connectionId == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Optional itemStateInfo = this.itemStatesBroadcaster.getInfoIf(SseSinkItemInfo.hasConnectionId(connectionId)).findFirst();
        if (itemStateInfo.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Set<String> trackedItemNames = itemNames == null ? Set.of() : itemNames;
        ((SseSinkItemInfo)itemStateInfo.get()).updateTrackedItems(trackedItemNames);
        OutboundSseEvent itemStateEvent = this.itemStatesEventBuilder.buildEvent(this.sse.newEventBuilder(), trackedItemNames);
        if (itemStateEvent != null) {
            this.itemStatesBroadcaster.sendIf(itemStateEvent, SseSinkItemInfo.hasConnectionId(connectionId));
        }
        return Response.ok().build();
    }

    public void handleEventBroadcastItemState(ItemStateChangedEvent stateChangeEvent) {
        OutboundSseEvent event;
        String itemName = stateChangeEvent.getItemName();
        boolean isTracked = this.itemStatesBroadcaster.getInfoIf(info -> true).anyMatch(SseSinkItemInfo.tracksItem(itemName));
        if (isTracked && (event = this.itemStatesEventBuilder.buildEvent(this.sse.newEventBuilder(), Set.of(itemName))) != null) {
            this.itemStatesBroadcaster.sendIf(event, SseSinkItemInfo.tracksItem(itemName));
        }
    }

    private static class AliveEvent {
        public final String type = "ALIVE";
        public final int interval = 10;

        private AliveEvent() {
        }
    }
}

