/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.perftests;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import ognl.Ognl;
import ognl.OgnlException;
import org.mvel.MVEL;
import org.mvel.TemplateInterpreter;
import org.mvel.tests.main.res.Bar;
import org.mvel.tests.main.res.Base;
import org.mvel.tests.main.res.Foo;

public class ParserPerformanceTests
extends TestCase {
    private static final int COUNT = 10000;
    Foo foo = new Foo();
    Map<String, Object> map = new HashMap<String, Object>(100);
    Base base = new Base();

    public ParserPerformanceTests() {
        this.foo.setBar(new Bar());
        this.map.put("foo", this.foo);
        this.map.put("a", null);
        this.map.put("b", null);
        this.map.put("c", "cat");
        this.map.put("BWAH", "");
        this.map.put("bar2", new Base());
        this.map.put("pi", "3.14");
        this.map.put("hour", "60");
    }

    public void testSimplePropertyAccessPerf() {
        for (int i = 0; i < 10000; ++i) {
            this.parseDirect("((hour + 10 - 1) == 69) && c == 'cat'");
        }
    }

    public void testSimplePropertyAccessPerf2() {
        this.testSimplePropertyAccessPerf();
    }

    public void testDeepPropertyAccessPerf() {
        for (int i = 0; i < 10000; ++i) {
            this.parseDirect("foo.bar.name");
        }
    }

    public void testDeepPropertyAccessPerf2() {
        this.testDeepPropertyAccessPerf();
    }

    public void testSimplePropertyAccessPerfDirect() {
        for (int i = 0; i < 10000; ++i) {
            this.parseDirect("hour != null");
        }
    }

    public void testPreCompiledB() {
        Serializable ex = MVEL.compileExpression("((hour + 10 - 1) == 69) && c == 'cat'");
        for (int i = 0; i < 10000; ++i) {
            MVEL.executeExpression((Object)ex, null, this.map);
        }
        MVEL.executeExpression((Object)ex, null, this.map);
    }

    public void testPreCompiledB2() {
        this.testPreCompiledB();
    }

    public void testPreCompiledB3() {
        this.testPreCompiledB();
    }

    public void testPreCompiledC() {
        Serializable ex = MVEL.compileExpression("hour");
        for (int i = 0; i < 10000; ++i) {
            assert ("60".equals(MVEL.executeExpression((Object)ex, null, this.map)));
        }
        MVEL.executeExpression((Object)ex, null, this.map);
    }

    public void testSimplePropertyAccessPerfDirect2() {
        this.testSimplePropertyAccessPerfDirect();
    }

    public void testLogicPerformance() {
        for (int i = 0; i < 10000; ++i) {
            this.parseDirect("a != null && pi == 3.14");
        }
    }

    public void testRegularExpression() {
        for (int i = 0; i < 10000; ++i) {
            this.parse("@{c ~= '[a-z].+'}");
        }
    }

    public void testOgnl() throws OgnlException {
        Object o = Ognl.parseExpression((String)"hour");
        for (int i = 0; i < 10000; ++i) {
            assert ("60".equals(Ognl.getValue((Object)o, this.map)));
        }
    }

    public void testOgnl2() throws OgnlException {
        this.testOgnl();
    }

    public void testOgnl3() throws OgnlException {
        this.testOgnl();
    }

    public void testObjectCreation() {
        for (int i = 0; i < 10000; ++i) {
            this.parse("@{new String('hello')}");
        }
    }

    public Object parse(String ex) {
        return new TemplateInterpreter(ex).execute(this.base, this.map);
    }

    public Object parseDirect(String ex) {
        return MVEL.eval(ex, (Object)this.base, this.map);
    }
}

