/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.util;

import org.mvel.util.Stack;
import org.mvel.util.StackElement;

public class ExecutionStack
implements Stack {
    private StackElement element;
    private int size = 0;

    @Override
    public boolean isEmpty() {
        return this.element == null;
    }

    @Override
    public void add(Object o) {
        ++this.size;
        StackElement el = this.element;
        if (el != null) {
            while (el.next != null) {
                el = el.next;
            }
            el.next = new StackElement(null, o);
        } else {
            this.element = new StackElement(null, o);
        }
    }

    @Override
    public void push(Object o) {
        ++this.size;
        this.element = new StackElement(this.element, o);
    }

    @Override
    public Object pushAndPeek(Object o) {
        ++this.size;
        this.element = new StackElement(this.element, o);
        return o;
    }

    @Override
    public void push(Object obj1, Object obj2) {
        this.size += 2;
        this.element = new StackElement(new StackElement(this.element, obj1), obj2);
    }

    @Override
    public void push(Object obj1, Object obj2, Object obj3) {
        this.size += 3;
        this.element = new StackElement(new StackElement(new StackElement(this.element, obj1), obj2), obj3);
    }

    @Override
    public Object peek() {
        if (this.size == 0) {
            return null;
        }
        return this.element.value;
    }

    @Override
    public Object pop() {
        if (this.size-- == 0) {
            return null;
        }
        Object el = this.element.value;
        this.element = this.element.next;
        return el;
    }

    @Override
    public void discard() {
        if (this.size != 0) {
            --this.size;
            this.element = this.element.next;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.element = null;
    }

    @Override
    public void showStack() {
        StackElement el = this.element;
        do {
            System.out.println("->" + el.value);
        } while ((el = el.next) != null);
    }
}

