﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/config/model/GetCustomRulePolicyRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::ConfigService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String GetCustomRulePolicyRequest::SerializePayload() const {
  JsonValue payload;

  if (m_configRuleNameHasBeenSet) {
    payload.WithString("ConfigRuleName", m_configRuleName);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection GetCustomRulePolicyRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "StarlingDoveService.GetCustomRulePolicy"));
  return headers;
}
