﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/datasync/model/HdfsNameNode.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace DataSync {
namespace Model {

HdfsNameNode::HdfsNameNode(JsonView jsonValue) { *this = jsonValue; }

HdfsNameNode& HdfsNameNode::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Hostname")) {
    m_hostname = jsonValue.GetString("Hostname");
    m_hostnameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Port")) {
    m_port = jsonValue.GetInteger("Port");
    m_portHasBeenSet = true;
  }
  return *this;
}

JsonValue HdfsNameNode::Jsonize() const {
  JsonValue payload;

  if (m_hostnameHasBeenSet) {
    payload.WithString("Hostname", m_hostname);
  }

  if (m_portHasBeenSet) {
    payload.WithInteger("Port", m_port);
  }

  return payload;
}

}  // namespace Model
}  // namespace DataSync
}  // namespace Aws
