/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.control;

import java.awt.Font;
import java.awt.Paint;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.AWTUtils;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardChartComposite;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardRendererAbstract;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardViewItem;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewSettings;

public abstract class DashboardRendererDatabaseChart
extends DashboardRendererAbstract {
    protected static final Font DEFAULT_LEGEND_FONT = new Font("SansSerif", 0, 9);
    protected static final Font DEFAULT_TICK_LABEL_FONT = new Font("SansSerif", 0, 8);

    protected void generateSampleSeries(DashboardItemContainer container, TimeSeriesCollection dataset) {
        TimeSeries seriesSin = new TimeSeries((Comparable)((Object)"Sin"));
        long startTime = System.currentTimeMillis() - 0x6DDD00L;
        int i = 0;
        while (i < 100) {
            seriesSin.add(new TimeSeriesDataItem((RegularTimePeriod)new FixedMillisecond(startTime + (long)(i * 60 * 1000)), Math.sin(0.1 * (double)i) * 100.0));
            ++i;
        }
        dataset.addSeries(seriesSin);
        TimeSeries seriesCos = new TimeSeries((Comparable)((Object)"Cos"));
        int i2 = 0;
        while (i2 < 100) {
            seriesCos.add(new TimeSeriesDataItem((RegularTimePeriod)new FixedMillisecond(startTime + (long)(i2 * 60 * 1000)), Math.cos(0.1 * (double)i2) * 100.0));
            ++i2;
        }
        dataset.addSeries(seriesCos);
    }

    @Override
    public void moveDashboardView(@NotNull DashboardViewItem toItem, @NotNull DashboardViewItem fromItem, boolean clearOriginal) {
        DashboardChartComposite toComp = this.getChartComposite(toItem);
        DashboardChartComposite fromComp = this.getChartComposite(fromItem);
        toComp.setChart(fromComp.getChart());
        if (clearOriginal) {
            fromComp.setChart(null);
        }
    }

    @Override
    public void disposeDashboard(@NotNull DashboardItemContainer container) {
        DashboardChartComposite chartComposite = this.getChartComposite(container);
        if (chartComposite != null) {
            chartComposite.setChart(null);
        }
    }

    protected DashboardChartComposite getChartComposite(DashboardItemContainer container) {
        return (DashboardChartComposite)container.getDashboardControl();
    }

    protected DashboardChartComposite createChartComposite(Composite composite, DashboardItemContainer container, DashboardContainer viewContainer, Point preferredSize) {
        return new DashboardChartComposite(container, viewContainer, composite, 0x20000000, preferredSize);
    }

    protected void createDefaultLegend(DashboardItemViewSettings viewConfig, JFreeChart chart) {
        java.awt.Color gridColor = AWTUtils.makeAWTColor((Color)UIStyles.getDefaultTextForeground());
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.BOTTOM);
        legend.setBorder(0.0, 0.0, 0.0, 0.0);
        legend.setBackgroundPaint(chart.getBackgroundPaint());
        legend.setItemPaint((Paint)gridColor);
        legend.setItemFont(DEFAULT_LEGEND_FONT);
        if (viewConfig != null && !viewConfig.isLegendVisible()) {
            legend.setVisible(false);
        }
    }
}

