#!/bin/env python

import numpy as np
import scipy
import pylab
import pymorph
import mahotas
from scipy import ndimage

dna = mahotas.imread('dna.jpeg')

dnaf = ndimage.gaussian_filter(dna, 16)
rmax = pymorph.regmax(dnaf)
pylab.imshow(pymorph.overlay(dna, rmax))
seeds,nr_nuclei = ndimage.label(rmax)
print nr_nuclei
pylab.show()
