(* AFM data for standard 14 fonts *)

(* This file constitutes a modification of Adobe's AFM data files. This file
   also constitutes a modification of Adobe's license file.

   This file and the 14 PostScript(R) AFM files it accompanies may be used,
   copied, and distributed for any purpose and without charge, with or without
   modification, provided that all copyright notices are retained; that the AFM
   files are not distributed without this file; that all modifications to this
   file or any of the AFM files are prominently noted in the modified file(s);
   and that this paragraph is not modified. Adobe Systems has no responsibility
   or obligation to support the use of the AFM files. *)

let courier_afm () = "x\001\189[Iw\220\198\017\190\243W\224\152\188\151\241\003\026K\003\246\137\162(\155\137\022G\020%[7p\1669D\132\001h,\146\168_\159\234\189P@\139\202%\207\2074MVwW\215W\203W\213\195\235\169\030\166\023}7\189\018\211\208\236\199(\251)9\187\232O'\209M\209E\255\24084\199\251)\250\219\254\239QR\149\213?\224k\021\171\175\137\250\202\212\215T}\229\209\249\161\191\021\209\245\2278\137\211\024]u\251~x\232\135z\018\135\159\162\232\188m\163\183r\1831z+F1|\134\159\250\163\006QOM\223E\207A\250\231\232\221\253\028\189\170\031\163(\137\018\2543\227?\199\149:\193\201\223t\205_\179\184z\030ei\156\199\238\199\239_\205c}\020QZ\241<\139\242\152\243\234L\222\238u}\018p\157yh\196p\246bn\219\229\015\234S\211>.~\244A\168{\191\018\135f>\157]Mu\219\236\207\187c+\162\248\236j|\209|\021\135\223\155i\127\031M\195,\206.\238\235\161\222Ob\184\022St\249u\018\221A\028\222\246\167\186S\167?{\214\127\141v,\133\127\2438\226I\030\149q\030\157\221\128\212\2086\157\248\189\031\027u\249]\018\199\254\199\239\238\155\253\167N\140#\\\228\236\189\024F)\018\199\233O1H\189\238\167f/\254\031\016]\130\204\161\233\142\215\251{\001\022R\027\\Ouw\168\135\131\253\221\217E\253\240\1556Y^\176\179?\204\247\025+\206\206\199\1894\199\016\021\172:{.\236\255\237\146\156\159]O\135\223>Dy\"\191yo\190\001\127\148\230\180\254\152&\249\217E\148\178\232\151\232\195\031Q\017\199\240\205\235h|\168\225\242\191D\207\162\216\252\243\139\148J\151R\226\235\190\173OJ\140\165\133<2J\011p\011\206\180x\182\020\255k\238\193\012\183\173Z\144\148\028N-\163,I\229\149\244\130|\185\160\155O\183\018\150c\167\150T\0000(\n^\023\021i\165W\020\203\021\135\190m\235A\031\000.\176KX\017eU\017\021\246\004\190\148\127\016\195^\250\181\\P&\234\006yR\130)\141x\185\020\175O\176`\004h\212\130\"\213\011@*\207R\189\160\218\184\178\246\031e%\184\172\188t\202\011w\233,&*\213\131\232ZqgV\020\149\244Z\176\019\200Y\181\178dc\137?%)b\189&M\019\191\134 \\\143R\177\241\147^\145\020\017\203y\148\149\025\bp\189\128\128\253\208\206\163\182S\012\202D9\131\255p\237\023\025\001z\015\217\1626(K\163&\012|!\139\018\171\n\129\249\254\241\225^t\006\180\020\\)\001\204x\196\202\\\139\023+\204\154^#\192X\165\189\142C\030\139\181Kd\004\226\177\173\199{\1899\003\143\144\218\243\\\006\139\150&\b\127\019Co4\209\014\157U\153\183!A\183\239t\140\128\131\197\224\150\185\019\204\t\166\211\023\189)\151\145\148q\143JN\144\156\238\007\161\247\228\185>\190(\1880\129\240\014r\169\150-\213\249\222Ar\130\221]\243\217h\202\204\165\184\1959'\224\141\205W\227\019\137\151\181\251\018\228F\241\217\000W2y\1792\245\219\018\212\132w\207\216*\225\003-'\160u\1417\173\146-+/[Rok\251n\229\014\169\241\158\188\162*\159\026\191\194\251'ZR\016\244ZY\"\1644\196\029\132Q\158T\128\161\214\165 \248\137\191\230\186\181Q\146\200\196\000a\"\163]\t\019\252\142\178&\011\r!\192,\183\134(q[\1674\149\136Q\0211\237\202\149\177!s\233\182 @\214\218\220\156\155,\149:\011\022\004\198s%\152J'\002\176mb*\b\130\207\180\r\148\024X\213\137\017\232.\172\169v\137\204\139 \\\234,Q\016\220\158\163\253x\230\247#\128]*\177\\\031\027;1N@z\129\196 \19381\002\208\175\250\170F;\b2\171\029'\224\252\166\005\165[\231\160\185\219\143\160r\133\019\128\191\004'X\252S\239\150\233c\011\159\2539\129\226_ZP\0054\196\148\019#X\188\212\182\227\202(\232X\130\197+-\166\128Eg\018 ^k?\001\221\160\020W\190\028s\130\196\027\011\152\186\004\132\172\181]I\176\248]oX)\237\188\237J\130\197\191\253~)\217\144\128\241\022[\005mH\192\184\214\231Bz\129\168\203!D\220~\004\142wh\191\194_\184$`\220\232X\227\250\194%\018$p\188W\130\187L\153\176@~P\018@>h\193\212\b\162\029\t&\127\232\132\166\131\195\199dI \249S\139)\132\017\167\168\b \031uJR^\154x\237*\002\200-\144\236Ob\218\"\031\204%\143\138`s\011kP\141\005K\169\026[2Wc\171t\243\024DX\192IV\132\165\162\233l\2207\205\190\025\246\179f\156\240\251T\245 \190@V\004\191Y2\225\017\024\184\165\178;I\001\228ow\\\167\250\170\136\214|\205\223\031\012\171\232Z\233\017\168\b\162\181\205;*\201B^\204$;\147\130\004\209[}\213L\011\"\nR\017L\247\182 (A\230wLb\002\171&A\153f\ny\149\184-\147\152\214\165\197\158Y\137\246\164\164\194\192\168\\*5[B\190i\128D\168o\218\232\1745K\t\174G\164\014WY\206\159B\1924\206b\211\156\215\155 \216h\168s\203\175rn\228\bn\255\137\012\tQGgI\140D\t`\159P\217)ct4\193\171%G;9\002\151\246\198\157\148+@\206]9!`\025\138\162b\144c9\002\149f\138\005s\189\133\151$P=h\r\141\185s\188'\229\014Kd\192S\188(A\198\208\145\216Ty/G\169_dX\142\238\153R$I\1761\221\149\165!2\229ZI\002\205\172Md\25000\001\244\183F\146\128\243Y\251\143\234s\224>1\146$\240|\241\1699V\169\217I2\002\144\166\189,6\142\225\229\b@\143\145-\151\202\150HKF\000\250\166\001Ru0\198r\027\t\209g\157D\185\177\204\186\169g\222\t\203h\218\213H1\217(\200\177G\n\187\243<6\210\249\198\t\184CL\205\017\168\217\149\189\242:\227NM{0\217#\133\t\007W\148.e\230\156\021\255U\019\129C\255\197x\187\158\np5\022\128I\146YD\204\228:pI\246\161\199R\157\140\244K%Ll%\219V\024\222\232\\\003u}\007\240\228\240o\145\024\167\1624\248NN\142,o\150\253\143D\r\130\184(r\179\128\216\234Q,B\213\151\203\1322\226\187\182\031\026-,\253\011rJ\158\250>%\161\204x\020^\017\025\162; b\153\1643\1655\012\237l\230\001\026\251\189q\184Tv>9\227\170\228i\249\173i\195\216\1681\154\186\001\004\176\170_\016\154\238\018\1488\219\169\140\247\191L\015)d\159\234W\017\160\143s\003+N\189'\011\224\172\\\211\169,3\250QN-\023)\245\208Y\149\\\149\229\tZ\149\006V!\255\221ZFq\215\181\195v5.\127S\198}\215\006\228\bz0V\179$\007\182\144C\138\028\162\204\014)\018J\170\015\245\241hz\187D6C\018\235\2203\210\132\146k-\239\166c[K(\205\214\131\016\025=b\016v \194@\014P\135\181)3\021\144\178i\024\023\213\199\161~\208\151\201cuR\158 \180)\177\190\133\137\1740\166\007P\147T\166G\201\139R#\159\133\028\241\182\030\141/&\138\244f\170\027VLF-\204\183\157\209-K2\179,\131\176\245\203\138\237e\216C\140\019\231\028]\139\007\156\216\175\219\240bJ\205E\2196\015c3Zy]\172R]\201\213\130j\133\211t\223\207nn\168\185b\129\2305\te\226\182\217w\153T&k\205m \018]&\165\204\026P5\131\158$\215C4\233\b\005\183\167PJ\189\159'\131\014\016|)\158AJ\241\226\004\028M\190\239Za\006DL\014+\164F\192\192s\147\174)\161\246\229Cr;9\198\201c\217\249\024\219R6}\170\247\131\027q\196*\194\178R\226a\162lE\170\007\225.\012\2491\150\249@\142\182L\012Sj}\232\167z\239\202\r\147\181\006\000La\176Vd\218\164l\197\177\225\181BX\180\019`\206rE\006\135\249\021$\188\006[\157\024\020\215\012\028#U\012\151\027\233\148\022\191\0038a\029\217~c'\145K\193c\019\187=\157\150\206\221\177\030\230S[\207\198\213a\178\147\153\194l\177c\148 \247G\024V~2jI\130\005\130\025P\227\204\136\019\028\246\181\135!SS&\133rQ\025q\026\018'\151\027c\149\026\229/ljd\148\140\156_\250\140\139&:\140\017%\250\225p\007\211:7\011L`\166(1\147\221\168M\138\140\190\\\188\244\189\232j<\194\232\003\198\027$\156\170\190UN!l\t`\244\001\227\141V\\m[p\180m\190R\252\004\228in\189\230\220h\158z\205\233\020\1916\178\149\233\016cG\169\025\157\152\031d\221\029G\210\029Y~\2012\218\202\248k\174\250\025\182\026j{a\217\132H\155\200\233\140\137XFG\219\253Rk\21220:\220\134\250\006/v\144\166\2054\181\212K\202\210)\179#+\174\022\209\231\166l<O7\197\133Oh\168\213\1811A\165k\159<P\251ns\007\149\158Wqg\251\1482\014\030!|\028a\133\138\237#\254\\\220\214\ruB\183=4\159\027\147[K\249t\163\187\176\130o\239\141s\189\217X>\146n\201\158\147Do\169\017/\183\247\174\253\222\216\144\001\155\220\2082\226\199k\161\003\030\253\001\168\237\n\0290\170\231'\148\231e\147*\253\022w\169k\164\150Za\184Lm[]\196%z|\133\"\222\022^\214\017\180 \128n\1412\182\178*\151I\143\007/p\227m\132v\015A</\234\129\217\029\181\209T\254r\161\190\027\198\135\148\127\014U\220<?\1641\233\162\168,EK\214x\221\208BZ\221\201\199\158\205E\246Y\222\014\246J\245;\155\\W\250#b\225\180/\170\192\230\235\168eU0jk\231\006\216\249\217\182'\191\166\183\229\1985\209\216\157\174i=\178.{\135p\173=\003\252\129P|G\181I\141\233\241P\156.\186\240\234\160G\158\160B\158\000.\146l\200\205\022\004\237I?\027=Rh\018\021Bj\196\\K\203'\223M\n\205\134\229C\182l\251o\162;\154\000\148sMY\235y\224\158o\189\222\238Q\163\140\1837\254u\005Rb@B\175W\171\248&\233\012\205\212B\233\172&K0\\\129%\231(\170\\\255\028\b\170\001\005\149\029.\134\128\218c\160t\b&\139I8]\240q\2337\238\161#\2287\239\238\251A\235\162\031\169\2102\232\238o\208\029\209\211W\232\154o\189\203 d\183c\227\026\1495\255f\021\146>x\003\154\137\191\252\160S\1369\221\224N\202\215\131\144\2183jZ\188\167\004\146\152\250\144\1948\171\241\131\153p\192\240\153A\022\200\208c\204\202\144>5!;\0069\136\151\182\158\021\020\245<\2061\149t[\135\211\220N\205C\171\007j\178\152B\154\147\175\232<\016E\1364!\179\004\179)\t\234\"\r\0065\140`\166\166n\015\205\221\157\131(\213\227\030\158l+\243\184(\193\152\007\177\237\005\175\151\172I\191\237\134\140\216\144\232\1752\247\228\178\029\251\151\235taru\136%R\n\225k\229\182\254b\177\000\019\178\192\130\253\154\254\179p\241\235\016\184\246Q&$;\163hB\158`\199\018\235*\239<\001[~{\239+Tdl\131\019BI~\006\011\026b\251A,\174>\136%\247\015\208\164\219\161\255$\186\197S\129\156\127\202\167\130\130o\0311\136c3\250\129\226\211\212\234W\020~\254c\021\161\b\188Zf\234'[\186q\134\226\231\167\230\242\002R\149<XZ/\023\012H\187d\200\156\003r\024W\147\002.\208#\023@\143s!\023\248\232\183v\213(\164\198G\196b\188\236\182\026\2303C\254sFUi^\151By\227r\210\205\252\147D\252\002W]E\237d\213\205\194\200\183\148\153T\230)\n\207\023V\197\003]\214?\t\242d;i\b\212\167\168\152\150}JV\134\187 $\175\202\158\234\154\194d\246\028\149\235\167\202\204\"\029\185J\019\026Ex7\252\129Q\1967\148\003\236kaH\182AW\172rsE\2446\190\170\187\136\175?]w{\020\018\222\203\131#\148e[e3z((F\020\020\136\174\135.\186\028\254\248\193\213\1827\190!\005\t]6T\146n\208\188\252\233\158\249\185h'CI\021\248`\150\178\012\016$K/w\230\253S\190\206\007#\226K\191$S\220\012\011Y\022&S\011\219\224\171\006\252\241\132\223\214\249\226q}ewo\149'\187\158~5\021\179^\243\157\169\216\229\214h\163H\130Az\240\211\132\141\207\186l\178SH\143\003\164IS'a\140P\168\026\\\020\219W\190\198\169\1433\223p\132S\159\203b\218F\234\211\149\219\n\253+\216e\163\015\248\209E/Q\212\2181v\2001\167\161>\136S=h\139\202\191\131`\133T'\156\246\196\178\n\255\000\183\186BN\241\020K\185BY\193\t\135:\143\151\168\173\161\243\250\149\183u\226\190n5c\142\213C\190|\245/\002\217FN\200\255\135:\217\211\t J\127\001\014\220\249\225\134\167\144\001^r\179~\1831)\167\n\019\148\203\197d\245\251dF`\130\226\001\r\229\226\163\167m\248\019[\161\2417\152\222\196\020\182>\2522d\253k\196\129qs\203\002\210t.\198L\140|'\b\223\172Lj\019a\0256\211\001*\179\249\136}\162\"\165R\143\152\161D\219\163:\254t=\188@\206\140gc\129\174\194\239\253\003\237%\004y\179\175\237\135\021t\022\132|_\177\192\004\182FS\011M\252Bz\012\212\248\133\029\152\231\225\145\203k\239\251\190\199\225\129\020\216\163O\017!+\006\167c\193\132\025\158\211\188\164\1392;Z\253NB9\247z9B\023\184\1949*Z\166f\021qX\157s7P\241L1\224\197^\007\\\199\003j|#\253\147c\139\129\188}\233\253\000e\144@o\134\153\165%\219q\216z\159V&O-Nq\176\026\162\2465V\175\183\242/$X\185\205Z\174\232T\194\181\139\001F\215\249\235\250\140\\\132:\017\250Nd=\006}Fq=\230=\202(\236z\183D~2C\210\2164pL\191\028c \247\015@6/\159\001\241<n{\001(\227\235\156j\145\011\221\183\005 8\174pC\005\128\199\219uZL\247\235\011\004|\020\145#\231\159\001\235tT\023\128\205M\183C\185\007\188\1480ff\024s\025L\228\r&%\150\214\134\138\227\229l\254\n\204\255\245\227ew@\1276)\255\023\253U\239\127\001\200+J\214"

let courier_oblique_afm () = "x\001\189[Ks\2206\018\190\235W\240\184[\181J\145 \001\144\201I\150\229D\027?\178\146e'\190Q3\208\136k\206P\225\195\182\252\235\183\241\"\154\205\129\148\\\182\\R\201R\227\213_?\190n`\174\199\186\031_u\135\241\141\026\251f3$\197\015\217\201y\183\223\171\195\152\156w\015\143}\179\187\031\147\127l\254\153dUY\253\011\190W\169\249\158\153\239\204|\207\205w\153\156m\187[\149\\?\014\163\218\015\201\229a\211\245\015]_\143j\251C\146\156\181mr\165g\027\146+5\168\254\011\2526,\213\171zl\186C\242\018\164\127L\222\223O\201\155\2501I\178$\147?\230\242G\206\204\n\179\252\205\161\249sR\151/\147\"Oy\216\241\1357\211P\239T\146\tV\148\137\228%\171N\244\233\222\214{\005\199\153\250F\245\167\239n[=\248\228\213\212\182\248\015\201\252\135z\223\180\143\248O'\031\149\209\195\027\181m\166\253\201\229X\183\205\230\236\176kUr\154\177\147\203\225U\243Mm\127k\198\205}2\2460\197\249}\221\215\155Q\245\215jL.\190\141\234\176U\219\171n_\031\204~^\188\232\190%\167L\194\023O\147\178\168\1462\229\201\201\rH\245msP\191uCc\212q\154\165i\248\245\251\251f\243\249\160\134!\225\233\201\007\213\015Z$M\243\031R\144z\219\141\205F\253?@\187\000\153ms\216]o\238\021\232\200Lp=\214\135m\221o\253\223N\206\235\135_\172\210\184`'\191\187\159\011&N\206\134\141VG\159\b@\231\165\242\255;\205\184<\185\030\183\191|L\000Q\248\225\131\251\001,T\171\211[h\158\241\147\243$g\201O\201\199\223\019\145\166\240\195\219dx\168\225\240?%/\146\212\253\251IK\229K)\245m\211\214{#\198\138\\/\153\020\162H\184dV\188X\138\2559u\160\134\219\214\014\1449\172Z&\028\150\134#\217\001|9\2240\237o5,\187\131\025\146\193\250\167Z\188\018\137\200+;D,\135l\187\182\173{+\158\150\218\156\132\149\247K\200\165\252\131\2347\218\212\237\252\1339\003\175*P\166\147/\151\242\245\030F\012\000\142\025QJ;\160L\019\014\n0\003\170#\135\182\022d\142]\218c\023\021\159\143]\164dOu\175\014\173\186\179#\242Lk\022\206\162\213\234\183UdG\134\132U\178\\\2181\185>\186\031C0\174\007\189\177\225\179\221W\198\018\198\1659\138H\165\029@\224~h\167\193N\207\170\164(\140l!\173i\020\004\235\r\132\144\218\ns\189\023\152>\007\209\204\239\133 }\255\248p\175\028\202\016\156X\158%\156\151\160-n\197\197\n\181\166\179\016\176\1884\024\228%\196\180\212\026EA@\030\218z\184\183\147\195>N\205\017\011\237/V\154@\252]\245\157\219\137\179\007\201\131\018\t\188\221\193\186IU\130\143\240,\br\002\234\248\213N*\1813qQ\006A\002\229x\223+;'\156\200,\159#a\130\225\029\004\212\217\216\181\017fA\148\160w\215|q[\173\156\209V3\210\156\16074\223\156\006\184\145\213\170\154\231%\208\r\234\139G\0146\012\170\005\021\207\243\018\220\020\178Pw\184\018\029\142\192vh\188rs\135C\017dKjomwX\024D\001\186\200\157\253\240\138\238y\223\132\017\179\133\226!\130\224\215\234<a6#\180'\137L\219\190\221\139 \b\170?\167\186u\168Tp\210\210\252%\151\194J\019\bw:W+\139\"\172]0\019\127\230\185s\026N\212`R\1539*\243J\204\231\160+\b\148\181\2117\243\161*\004\017A\144<\179\241&\177\017\192G'A0|a\164\n#\150\137 F\192;\015\200\193\249\185\r\146F\144 \247\018\205W\132\160(\bd\023F\140\0271\145\206b\146\192\244*\"F \250\217\170\219\237\174\b\187\147\004\157_\172N\140a\151A)\146\192r\233M\003\196X\030\196\b\024\255\182\187cv\2172\156V\018(~\181\203j\159\022\176\247Y\140`\241\218\234N\018\200$\193\226\141\021\003)\153\1615\t\016om|\130\189\229 \023\178\178$H\188\179g-\236!X\208]I\176\248\205NX\025d\139y\190\146`\241\031;\159\14249\153\144\128q\021\180\194!\224\206\019\0180\174\237\186\002\232 \172\012\129x\158\143\192\241\030\133N!\130fJ\130\198\141s!n\142,\211\160\155\146\000\242\193\205\200\173\022\145)\148\004\147\143NR8I4'\193\229w\023\214\140-\160M\018X\254H<G\0029\196.*\130\202'k\250\198T\179\224!\021A\229\022\b\247g5\2064\132\021\194\211\144\016\133+\002\208-\140\t\201\150A\178\212\201\1820\217\206&\219*?\186\012\166.\220\174S@\232\155\215\161Am\2164\205\166\2337\147e\159\025\232%\231\154\145\2000\134\1288iZ<\000\029\1839\197\148\011\15316\176di\131~%\1465y\011L\172p\220\141\007W\171\b\172\245l{\198\211*\147S\140 A\245\214\170\168r\249\149\007\r\017\\7\200P@Jk\198M\153\165\004\218\173O\"F\178H\2319\179\148\166\168\197\164\218\153\194\164\148bX\209\1720N\194\236\156\016y\026`\020\230\1356\185k\221P\002\238\206\012\133\244\168\139\017\240D\137V!\136Z\1391\198\203+\1346NPl|\176pl\139K'G\144\251o\136\180\026-\158\"Q\002\153%\192\220\004\129<GK\019\196Z\178\244,G\000\179&y\202\141\131\241p\228\140\160\229r\184vD^b9\130\149#\163i LA\148`\245\224L\187p\026O\241\180\148I c\001\209\146!Q\002\142%'\"5\026\018H\142RAk\252\165\219h\129$\t<\206\215\133#%\"3_V\148\1923\185\227g\142\0032]\245:Q\130\208\023\139P\170\003\b\156(C\146\004\163\175\193Mm\180\156%\025A\201\018af\206\206\177\028A\233\209\170\222k\030rR\016%(}O\028\r\215\182\142\229\142\196\198\016}X\238\235@\017\200x\198\n\026\129-X\134\026\234nH\001\bK\158:i~d\005\020{\139\212\197^)\209\018\226H\240\029\155v\235\130\b`\155U\210r\\\230\022ZQb\211)\216v_=qufW\000\245\130\158\147\027D\244\020\ns\168\145N!\153\152bA\027\167\145&\218\210\213,tul\204\209z9e\186\024\130\175\204Y\022\165\198w\186\167\228\185\180\206\002\026\184B\024*`\007\016u=\250B\199\154C\021\178{FY\242]\219\245\205\193\185\16363\200\029\154\201\205Z\165|yPa/::\158\130\027\241*p\151\140\242\230\205\212C\205\191\177vW\233\220\007\147\195\152\212Y\1478\214\136\024\026\211e\179\217\140\219l\134hrF\233\180o\217\004+\004I\211\182)24\138\160\189\155\026\024\177\239\002{\128\144.\181\003\233 \227\246G\153\182\030d\182\023\214\0025H]\212\166hT\030\025\133\172\024\198\232a\169@\195(\2446\143\216\"\166\n\177\156\242\240\1876\"G\208\131\158\219\220b\000\2113\253\011\160X\190\127\145Q\174\189\173w;W\2431\bx\006l\216\235\0126\229\220V\222\247\206\180\237\175\134P\246m{$\218\135T\175\\\175\004\142\151\001o,\160\209\1493\151\014)\201\134VR\189\235\235\007w\026\248\173^J\228\200J(\225\190\133\214\175r\152\193\233\179\220\134\157\188\204\157|\0173\197\219zpQ\196$\"\189/\b%\134\216\152\129\252\1849\134a\153\027V\192\030\1950q|\024j\195e\174\251(\005:\150\140\152q\024\199Kc\199Y\025L\139\210u\213\182\205\195\208\216\\X\136\185\131\148\2490D\137;\0005\222w\211\220T\228\158\019\162\024L\217\185o\003\204\017\213\150\028:\162B$\154#*e\219\128\171k\0021\136\024\005\168\186\000l\132\244\171P\154\189\153F\031,J#n\154;\1798A\199\018\242\187V\185\156\169\187\132R\183\020!\236q\023\181)\195\014yDw \139\210\250\152\240A\140\210\235}\189\233\231>\015\148L\1547\167\2182\157\159\173Xv\175\252\129\193\1658\144\b\141\184p}\194\140r\237m7\214\1559\237\228\016l8tR\181mi6\173\135\176\021\231\134\251\012\229\225f\160\026=\130\195ba\004q\176\222'\169\028N\160\171\028\158\166\006m+\157\211$\184\005+t\173\212\202\240%hRA9\157\249\233i+u:\236\234~\218\183\245\228\137Ce\177+\243\025;F\249r\183\131N\230g\231\138\218\000\165n\216\194\217\1578\193aS\2070\128\247\020\154\177C^\022\162r\226\212'\246sx\1324\174\163\163\000\134\224\163#\163\180\228\236\"D]\030*Y\198\200.\186~{\007\157\188\185O\200\000W]tr\221\189pq\145\209\171\141\215\161@]5N\024\189\225x\023\132u\195Cw\142Q\169\198\232\r\199\187\011\239\193\169Qu\152\151\175v\190\007\0305\181\243\214\001N\179\245<\180?\024\237\242\215V\182\200\\\128\bT\156\209\134\250V'\223a \229\146\167\154\250:oY\219\160s\026aSH\187S\174z\222\168\159\158\218~\186ff\158y0\218\250\238\236\182]7\029\215D\1406\191!\201\193\165\030\132j\023>K7$\236\230\148\140\184\\8\224\220\129\147<?*\174BL\155Kj\020\211\168x\029\002\136\175\233Q\252\160\210\211\202\247|\217\162;A\1775Tp\166\176\165\224LT\252\143\197\129C\191'v\226m\243\165\241T]\023o:\233A\209!\228\241\217\145~\230\169\245m\2341\2253\018\241}\235X\150\199'\175\195\228\242y\221\223\144\217q\255-\182\194cX\001\151b\177%\006sM\133B\190\174]\153\233\024\134\226u\141\023\217\023\234\162\248<\183:K\031*\019t\n\145\030\151^B\140GD@\174Q\2526\1705\193\167\138\158\225\006\193\140\166\143\001=\225\244`LZ\207\143Jq:\224bq\130\185\029\031\219\254K\200\234\238\162bu\017@e)d\025\200\026\204r\240\177S}/tt\144\191\198w\2511\189k!\231X\187:\000b\026\243\246E\021\153\253\239yp=\027\003\234\019z\002@\133\223\174L\212\158\022w\232\233\1526\160k\162\185\166\"1h\235\192\t\241n\"\014\243~\165\253\212y\012\238\159\211Q\231h?\225B(\186\163\192\t}\148@\148pmi\011\206\246\172\169\r\001+Y>\011\213\128\233\151\149\207\158\012\014\rU\253\019\001\174\237\190\171\195\206\t\023&EW\224\134\199\207y\021\246m\175\133\n\237\174\199'\254\153\162\164/\186\012H\232\166k\229\227\171\176\022:n\177\176V\1471\222\130\016\227_\229\012\228X>_\196\252\170\015g\158\155\1431\1646\011\162l\18903\216\198\160\250\180\180\156\249F$f9\239\239\187\222\025\142\225w\169\136\026\252;t\200\249\162\172\140\158\243\n\021Z\246\202/\238\175\215\203\028\234n\184b\210\219\160Aw-\160_G\197\184\212\r\2186N\011\177}O!\171ac\137D2\243\176a\152L_\194\183>r`\151\169\169\203|\169\187Re\136O\232\2021\202H\130\1807\174\168h\160v3o\201\143\239a?\181c\243\208>\186\163\230:Iiy\255\248e\165\023L2\029YO\217\019A\021\165\015\127\023\025\243mh\207\140M\221n\155;{1\163\179_n[A2;\190\157\199E2^\240\"v|\196[dd\137\191\015\142)\178!A\192\022\016<\030\002.\200\128\016\179c\188qq\000\025z*\177\253\171%\129\194\004-2b\243\247\234\130C\0167\0238O\193;a\175\154\205!4-\214\025?d(\164\252\227\147_\162|#\158I\245\250\253\022T\203Sx\199\002]c\2219\142\144\166\219\190\251\172\014\243\141\130yW#\245\019\191\202\\D\031\141\216j\215\012\161\225\248\023\136\214\207\193\r\209s\140\152'^.c\246\179\229\2220A\"\012}us\181l\194k,\205^\132\0002\155eL\159}\208}HO\017#\232\022F\192\1585\130Oan\155\152\158H\t\159P\144\023\207P\003\247\218(<Q\178\015\215\192\nb\209\227bt\205\146\231\136\2499\206\192\246\201\150\142\001e\020\250\150\210\148\2021y|\189\186\202\"(X\250\235C\b\0272;\030:\212\162r\241\149\017\186\239^\229@<\192\\\164J\182x\242\177\202#(y?c0g\139\1764g\157X\171\"\152\226\"\130E,\236;\138\004\2133\204\179A\1354\015o\180R\208u\250*\t\163\185]\018~\"\206t8\150\178gci\141\\\195\019\254'<c@\185\169|v\242f\217\0302\169\169\136'\142w4\151\005\202\017KN7\b\166\191PJ\191T\237h]D\184gL\162,#|\201\243\205\197\133~\2121\190vKr\149\135\142b\148\\-\181\131\014\027\177\201\189\189\141\151\254]\197\019-\128\006\017\183\249\205D,:\030i\156Y\195y\170qv\129\172\216d\026M>\209m\230\154\012\207]\006G\134%z\006|\148\174B\152\236!\\:\226\161\251\011\016\226\161\189+\196\241C_/\234E_\132\160'h\235\0248\1353[/\138x\171\243W\026/s_{\163'\130t\208\235\224.s\187;f\155c_o\213\190\238]\031\137\003\183\129\212Z\196c\159Z\166\227\191B\180.\145Y\248\236\029\219\207%.\163\172p\188\136z\0294i\015\154\199\247\rfs_\183\150@C\1521\023\255\154\213DB\142\238\164\147\140iHJ$cv\171J\026\189u\142p\226\003\186\b\179'\141\183<n\214\222\226\003\015\220\170\196\148y\017\012\1932\155'\024\133Z\176\149\231c\242.\1448\252\218+\214'\007\245;\199Z \160\031\022F\022\184F\156\216U\1892Nr\174W=3\225\028\229\tO|\183\210\170\139\135\146\199\149\186\133$\173\252\r\014\220\251\131\017\153\011\130H\188\237pJGF!c\140*\004\007\199\141\1598\245\132'G\229xdr\240\245f\227L\218\135C\208\190\172X\164E\027\220\2033\193\216Nz\170\127\b\202V\255\232\245\216\170\236Am\191\185\236\145\145P\216\161\247G\158b<\2251W\177\200\137\159\017\175\003\n\025T\184\214+\1901\\Q\188\1761\127}\025;\195\025J_>{=5s\1847\158\137c\196\146\195\030|J\127b\027\223II\229\159\165\197\002\248E0\004T!E\2025\2043\029\249\198\239\227\169\252g\170r\2383\028z\152\185\226$sI\171?\151d\158\005\128\139\179\2428\131\185\164\012o.!#\252\238\128\239\186\r\175\142\183\139\199U{\\\248\146\006=q\\\247\129w\218\019\015\157\127\237\198M\031\136Wp\209\031Y\168#\r\014\252a\154HO\138\140\240\001\"\206\133a?!\233\153\143\247\t\243\158\142Gp\216\173\188\030\165\002\153\030\207\218j\188_zq\030oO~G\225\208T8,\142\196\129n\134\t\127\179\199\163!\bl\149P\232\204P\232\162\138\247'\027\204Qly\145G\243\228\197\228>Z\022>Uyq\216\162\143c\234\255\162\207\015\255\015C\020b\214"

let courier_bold_afm () = "x\001\181[Ks\2206\018\190\235W\224\184[\181\147\"H\016$\227\147,\203\137\018?\178\150\031\137o\244\0125\226\1383TH\142m\249\215o\227\221l\018\150\247\176\149*E\0305\192F\127\253\248\186\193\185\158\234az\222\031\167\151\2054\180\219\145\137\159\248\217E\12784\199\137]\244\247\015C\187\191\157\216?\182\255d\188*\171\127\193\207*\209?\185\254\153\233\159\005;\223\245\159\026v\2530N\205adW\199m?\220\247C=5\187\159\024;\239:\246F\2373\1787\205\216\012\159\225\211\240\144\161\169\167\182?\178g \2533{\t\191\253v:\1784c\\\254\156\150?'\137~\130\151\127wl\255>5W\207\152\200\018Q\250\143\223\191<\141\245\190a\130\243\172by\202\1658S\231zU\031\0268\200ih\155a\243\180\239vg\207O]\135?e\230\211\250\208v\015\248\243\179\015\141>\187\254\243\213Tw\237\246\252\184\239\026\150\156]\141\207\219\175\205\238\143v\218\222\178i85g\023\183\245Po\167f\184n&v\249uj\142\187f\247\166?\212G\173\197\211\167\253W\182\001\213\216&\205\019V\136\138\149\tgg\239@l\232\218c\243G?\182\218\n\027\158$\225\227\183\183\237\246\238\216\140#\203\147\179\247\2050*\145$\201~J@\234U?\181\219\230\255\139\210%\200\236\218\227\254z{\219\128i\244\006\215S}\220\213\195\206\253\237\236\162\190\255\213\216*\151\233\217\159\246w\145Ug\231\227VYb`2\173\206\1585\238_\027\158\023g\215\211\238\215\015\172\020\234\151\247\031\024O$\252\006\222\168L\233\1881\227\249\217\005\203R\246\132}\248\147I\240\133'\236\021\027\239k8\247\019\246\148%\246\191'J*\155K5_\183]}\208bi\146\170g\178\172*Y^\164F\\\204\197\255>\245`\135O\157^\192\179\156\165E\193\132\204\213\153\204\130|\190\224x:|R\136\236\143zI.\217F\128\180\016L\230\220\172\144\243\021\187\190\235\234AK\151J\161T\178\156WLJi\196\139\185\248}3l\149k\235\221\181\254y\1493\201\173t9\151\174\015 ?\0022Z\030\030\173\023\bx\132\200\204\130j\229\192\198q\244\145\011n\142\012\145\231\142,\018\162Q=4\199\174\1851+R\208\029\2205\005+q\175\150\224+K\208S2\187&+\209\026\130o=*\197\198;\189\162\226\250Ay\002\134J\140]\005A\250\190;\141Z\022\142\160\131\191b\162(\141(Ay\011\233\1626\154\1929!\"\213\nH5\1330\226\004\227\219\135\251\219\198\224\011q\t~\004\182\129\255g\220\152T\200\005bmo\000\224\149q9\145\148\218\180Z\156\000<v\245xk\014Y\178\r\216>\007\195\200\212\026\133\224\251\173\025z\227:\133\129\022t\240\006$\208\246G\019\030`\227\132\229`\018'\152\019@\167/fO\169\004E\133\004\t\140\211\237\208\152=ef\030\159\004\252r\130\223\r$P\227\181\153z~R\004I\130\220M\251\217\236Z$f\215\148{\148s\002\221\216~5\182B\162n[\002\219\216|\182\168\193_\212\193D\216\149@\214x\215,\237\1938R\151\000vl\173a\139\202\202&A\182\164\158\214\245\214s\192\133\141+\168\232\202\141tE5>\180h\133\243M\229=n\137$\216u\170,hD$\211\246\2004(Z\148\160\215\252}\170;\023!\156\151:DT2\212\194\004\189\189*\200\141\001\016|Rm\r\185\210o\157\209,\210\140\186p97\230F6/MV\150\004\197\218\230\001\155\159J\225\r(\t\136\231ZpS\001\128\018\130\223\229$I\000|j\242\157\170\002y\017R\151$\208]\152\148\165\130\018\142\015\182\244\n\018\220\158\161\253\192o\252~\004\176K\179\159r/\189\155\021+\bH\207\205n\149\214\014\137\017\128~\153i\167\030k\181+\b8\191\218z\198\204\001\252~\004\149+\135^b\252\194\137\0170~3\218\021\250\177*B\188 \193\226w\155\240\181Q\002\022\005\193\226\005>m\025\196\b\022/\r\178\169F6\rb\004\137W&,U\161\004'A\135%P\188\158\025O=\215\026\175$`\252\161\005!\177\194^y8EI\192\248\1839\133\218/#\027\0184\222\152'\011b\150\146\160qm\158\011f\006%s\200\129yi\005\t\030o\145\153\011\180\031A\227\157\217\207:\139\012r\004\142\247\198\206\\ea\201\131\027\148\004\143\015V\174\212r\001\183\146\000\242\167MN\218\249\144\024\193\227/,\022NQ\0174>\154\228\149\218\018\229\197\b\026\159\128W\2235S`\029\"\183\172\163\bd\168\"\192|\1305\168\186V\182\186f\190\186V\217\234S\016QI\237c\178\028=\134&\179q\219\182\219v\216\158\012\207\228\144\174\021\191\023U\026\214\016\240N\138\001\143\192\188\029\131\221\168G\169\191n\n\147\232+\201\150D\205\159\159\131?\026\158\022\016\168\b\160\134\225d\1504B\222\017\185\2257\021A\244\147\215\193\230bg\030\002\233\214x\156\021\004\004\132*` \200\019\130\234\206%(\195W\185\223\146'\180(\205\246\132\186\226\148TV\159\179\004f\2353x\nD\145\222\017rM\011\244A\255\210\177\155\206\174$\176\238]2\135\178$u\024\135\135\016,\141\171\232|^\165Hk\002_;\207\1722/\173\028\001\237?\204\147%x\178\128c\006Q\130\214\029\206\2339z4\001\171#\143\246r\004\172\131M\175:\191\130\144?2'XY\178Q\2183\0079\130T\031\1728w'\206\tR\2476\147\168S\167D\148\018\135\224(J\020<%\136\018h\006\151?\1479\132\156\210>csU1 \2183\228\165\156\1603\249\140\172\233M\168A\156\019pN\225D\202K+\213\214ZI\002\207g'\153\232R\026\228\b<_H\182\245\130)\129\199\208]i\137H\016#\232<\152\253\1321\228\236\209)\129\231\027\011]\001<-\200\173dC\148qd\226\250\188\192\214x*h\20250\165\144/\245\144#\1314Q\228\137\149\206W\158\128\219Bi\031!\018\244\b\185\146n\167\182\219Y\018\014\\V\021Sp\204,\183K\022\204W\015\001v\253\151#\011\131\000\bHE~\133\176\199\167\012\216w\221R\245\244P\154\020;\226\214\233(\001V\189*\140jL\166\001\186\182Qy9W\011\184]@\012u\163\006E\1421\171*\163\232#0))\221\002b\171\007\223\129jW\bD\136S.|\211\245Ck\1327:\\3\174\231\029\222\162\148\021\143MPE\245?\138\162\170\216\177|\135Sr\188=\r\208\206o\141\203A\024*\227\168\196\170\162F\203\175\205\024\198V\143\205\012I+t\241\202\016S\231\1483\187I\140w@;\153P\017\029\022\017\160\247\167\022\022\028\250@\020JE\198\021\219\018\194\158\158\146i\181F+\023\\\029\198\023:iUhU\022Y\133\220wm\025\133\221T\014C\139*\148\190)\215\190\233b\130\004<\152\1659\134\003.\163g\019`!7\155\224\148N\239\234\253\222\182u\170Z)\172\005\23448\165\213F\222O\196\214\150P\130m\230\031*|\154\161qs\016\169=Z@\189\205\236\\\140S\030\rC\162z?\212\247\2460\198\015\011\137\030D\019\020\204p\027g{\024\016g*9\169\132\230\228E\204\015?\213\163qEew\1571\005\248$\18332N\169\182\243E\191L\218U\170\131\014\171\228\250\170\224!\210\186p\138\\\152\210p\239\194a\025T\168\194\022g\231W\148\1487]\215\222\143\173\169}\169m\171\193\249\184\139yJ\207\001\164\233\182?\249Q\161\025K\195\170\002M\1488\165\225\174\207\247\169T\145jM\170t\214\182\153\148\210j\000\213\014x\020D90\154L\1410]\166[\240\233\237i\178\137\"\201\181\184\128\012\020\196\t8\134y\223t\205W\235\162\016\235\224)\002\232\176\204mF\162d:\148\015\176\139\000}s\213]f\238\212\004\146C\189\029\\z\132\180\174\148\002q\197\210\1408\165\211Cc\143\171\212\000\213\2450)s\234\211\000\235\167z\235kM\154\169\224\002\003\001\22423T1]\176k\184\151h\028\216\028*\141Z!T\134\247+Hh\r\1744)eE\169FJ ]8\233\140V\190\029\248`\237!\216\164\016\246YY\216\017{J\217\240\237\233\184\175\135\211\161\171O\214\207\213CJ\221\030:\216RJ\141\251=\204'\239,\181P^\004\134\017I\226\159A0\216\214\014\002\rpe\001\150\133\021\167\241p\240Y\017\024\133>\162\026\030\184\180\152R&rn&9\155\180\"\227\bU\171\230z\015\187\027\024\211\249! \135\232T\254%tGo\181\167w\021/B\027\186\152\139\164\244\202\226u\016V\227\0125-\208\211\007a\197I\184\188v\170\155\174%G\027\231\011\213\015\192\158N\221wu\167\179\251\218\200jj\153\027fi\169wJ\007\229;Ux\199\145tG\142`\166\130\1822\225\160\139~&]L\179\145\t\129\212\000\241\212\141\133\180\128\210\153vo\181\230\165Q\155#\181\233X\027\n\028\\\209A\166\030\189\209u\219*\1896\027\178\226j\022\130^\249\194:;\021oBJC\157\174\140H\215!\129\160\230=&}ZD\159mSdZF\0235!\156f\n\021\171\210\127\145\132cG:\177\211\238\218\207-\"\231RWIua\178\186w0M\216\216\186:\149='\169\222O\133\139r}\243:l\254\003\150|G\182\015\163\181\216\254\015a\127\220y\197\0300\234{'\148\237U\147\170<\023w\169K\168\136V\b\175|\029\175w>\221\135#\148I\228\2083l\209\145c\206\137\242\182\182\169\154x\150a\188\176\216\031\185>\178\231\186\240\tm\174\189Xo\158\251\012B\229/g\202\2511|L\247gP\198\237\205\195b\178Oe)T\166\014\170\134\022\202\206&b\248\173\191\132w\003\181R\255-\143\248\207%b\022A\251\164\\\223|\025\179\"\143\198l\237}\000{~\177\190\245+zZ\235\151x\222N\215t\001X\159\255bNV\007\006\248\003q\248va{n\195\004M\195\233\162\011\196\026\195\245N\204\209\234@\000\177B\153\140\184\217\156\163=\230gc@\n\141\161bH\141\152n\233\140\000T\233{\025\161]\177|\204\150]\255\1739\238m\211\162\135H@\031\n\177\238\142o\130\222\2546\163\168\214e\127Y\128\148Z\144Pk\184\136o\154\192\195@-\150\203j\178\004\195\021Yr\142\162*\148\136HT\r(\170\220h1\134\212\022#\165bP#%\226H}\156;\142\191\229\1369\206\219\219~\176\186\152\235\169\"\234\239\175q\234\b\151^\177c\190A\225\225\161\141\004\1995J\217\225\182*&\189CNc\210R\145\022Q\226\244\014\169\141\234AD\235\147Ob\216S\"IL\191\1560\158\244\244\193\0148\160\029JA}\145\133\150va\199\144\154\176\025c\012$H#\242\017\145\r4\238Q\217\195\169\155\218\251\206L\212J\251\254J\226\223_Y\216\005\241\014d\152h>\r\b\185K\197XX\195\012fj\235n\215\222\152\235\022uu\161\174?\225v\184H\215\149y\152\021\225\025\015\202\"\229&\168\031\238uc\166iI\002(2\127\233\178\030\165\151dAH\2151\1508;\192\172\030\172\235\223\2049\019\"d\145\005\219%\255\023y\020\175#\162\196\238V&\202\254q\174\011\174\224f\019\203B\239]\001Y>\226\011W+u&\134\146z\249\n\154\226\240\006\150\234\207\020\237\231\235\138|\026\250\187\2308\187-P\1638u[ \139\245%C\179o\1990R|\156]\253\018\002\016\189S\017;\193\213<W?\218\211\141'\168\127~l\206\245=\177f\194E\018a\017(\211\004\151\\Wf\152\165`W\149\214\021\233\145\011\160\219\185\152\011|\012[\135z\020Q\227#\"2^6\226-\246\133\161\240\146Q*]\160V\017\131L\190\157\255>\023\191\152\r\164R[we\028\249\142\146\147\162\176\228\004M\024\022\245c\198\004\220\149`\145d\2359\000\181*:\166\245\155\031Y\188\015\194\242V\028\189\180\177(\030(\195?Zh\230\t\216\139\199z\255\224\135?0\140\248\134r\181\1871\140\201\182\232\140\202\226\250\144\232z|Q{\151\156\253;\181\183G\205|\242h\019Q\227\168\200\031\141\138\017E\005\166\236\145\131\174\143\127\212=\238\2349iE\194\135]\247\224w\b$\246X\219\252\172\233&\219>\216H\146e\140#9\130\169\222\208\243\215\243\209\144\248\210\207\t\021\\u\232\t54JQB5\239\201\209Q#\198<\160\203u\165\015\186]_\216=X\229\209\206\167_\204\197\172\215H\025\159\139]\"\015N\221t\163\136\135\233.L\020V^vYe\168\144\031\007\200\147\142-\021\250\230W\138\184N\215\179\174\163\176\217\015\189?\182\204~>\145\025+Uq>\254{\180\215\174\226\189\246\011\020\137n\154\029\243\205i\168w\205\161\030\238\\rR\254\163\190\249\016\219\188\153\215\225\031`WW+^\017\173\242(-\004\225H\251\241\"\024R\159Sf\241~\012\220\230\182\238n~\024U5'\255\031jeO\219\224\228\2096\248\024f\028\129FF&\028\239\022\193b\178\1422y\204\148\151({?\198g\026\220\246\005Dc\217x\143&\224\232\173\173h\168\031]T\025\243\171/a(\243\231\242;A5+\246\174\199\141p\155k\026%\194\241\137\239\132\225\235\133Mm2T\131\249h7\r\213\217\190b\015T2\133|+\n\017\205\181=\154\171=^\018/P\031\136Fd\1453\159P\171\251x\143\tQ\222n\1733o\2047B\004\168\014&\141\180\176\207Pl9\254\023Se\136\154\031\189\007\182hu\208\029ohu\"\131\154\030\205\003\145!#\209\242f\1454\197\015$M\186H}\007\198L5\2038\r\012z\005^\0239\1959\030\158\219\011U\137\2224X\200\135\225\138\219:6\191}\029\212\192\005=\162\200\183y\006\015\1801\146\191/\145_\250D\018\235I#\0203v\200\187\229\028\223\185N\030-\138\243FV\189Q\163\190(\193\215\027\129+:\159\b%h\253\bGt\149\029\218\251\"\210\147\196<\031\189\173\184\156\249\238U,\030{\255\222\020\183g\016\1453\244\243\t\b\142\128\200\000j\222r\160\252\016Y\000\202\132j\007\193\168Jd\174\203\233\186F\251E\180\160:P\240H\149\177\re\174\134\232\133\254\202[\012\226oh\016\018\218\154H!\165\186pwm\135^\151]\169Is\234\156[\234,\138h:o\215\200I\172F^\158\2367\193\194\183\031/\143;\244\181I\245O\244\157\222\255\002\158\141J\161"

let courier_bold_oblique_afm () = "x\001\181[\201r\220F\018\189\243+p\156\137\152v\160\128Z\000\251DQ\148M[\139G\212b\235\006v\131M\140\208\r\026\139$\234\235'\179\022T!\209Ez\014\019\014S-1k\203\151\203\203\172\234\235\177\234\199\023\221q|U\143}\179\029\018\254\003;\187\232\014\135\2508&\023\221\253C\223\236\239\198\228\031\219\127&\172,\202\127\193\2072\213?\153\254\153\235\159*9\223u7ur\2530\140\245aH\174\142\219\174\191\239\250j\172w?$\201y\219&oq\158!y[\015u\255\005\254\213/\210\215\213\216t\199\2289H\255\152\188\130O\191N\199$\203\019&\127\204\138\031\185\212+\204\242\239\143\205_S}\245<\225y\202\203\249\159?\188\154\134j_'L\137\172LT\153q~\134\231z]\029j8\200\2127u\191y\214\181\18777-Np\246bj\219\240\151\t\2542\153\127[\029\154\246!\252\253\217\199Z\171\002\197\206\174\198\170m\182\231\199}['\027\150\157]\r/\154o\245\238\247f\220\222%c\015\019\\\220U}\181\029\235\254\186\030\147\203oc}\220\213\187\183\221\161:\234m={\214}K6B%\155L\164I!\203\164HYr\246\030\164\250\1829\214\191wC\163\181\178ai\234\255\249\221]\179\253|\172\135!\017\233\217\135\186\031P$M\243\031R\144z\221\141\205\182\254\255\162v\t2\187\230\184\191\222\222\213\160\027=\193\245X\029wU\191s\191;\187\168\238\1271\202\0182;\251\195~\230yyv>lQ\017}\"\179\242\236y\237\254\182aB\157]\143\187_>&\005\199\015\031>&,\149\240\t\172\0195\233\1723g\226\236\"\201\179\228\167\228\227\031\137LS\248\240:\025\238+8\247O\201\179$\181\255\253\132R\249R\170\254\182m\171\131\022\203\152\1925\019^\138D\168\204\136\243\165\248_S\007z\184i\237\000\150dJ%\162\016x&3@,\007\028\167\195\r\"\178?\234!E\145l\184H$g\137\020\204\140\144\203\017\187\174m\171\222H+\180#\153\200<M\164\148F\\-\197\239\235~\139\166\142\242\012\172\005O 3\248\159Y\249b)_\029`\196\000\216\232\017\210\012\016xd\158\155\001\229\137#\027\211\209\135\006G\210\135\006qwh\158\146=U}}l\235[;B\162^\211\012V\201\230m\129\002\214C\252*\140)3\134s\238\199\016\132\171\00176|6#\020\236\139\149\176H\001\002F\181\156\128}\223N\131\157\158\2279E)\019\174\n#K\144\222B\b\169\180pY\194V\000j\b-\176\n7\210\004\230\187\135\251\187\218@\204`\213,E\229(\176L\163S.W\1605\157A K\165\177\186L\193\236v\223\004\227\161\173\134;\179\1514\217\128\242%\026Ef\181B\000\254^\247\157\217H.,\184\185W!\001\183;\026\023\001\145T\195\233\004\005\129t\252\2189\131\001\193\210\131\"\b\144\227]_\1559\149\181-\248s\022&\b\222B\0205\150\174\167\021\165\151$\208\2216_\236\172\202\1548\155a\022\004\186\161\249\182P\128\020\193\185\bpC\253e\198M\193\030d\150\249y\tju`\158v\2304P\004\001\237\216X\221*\007C\176\139\130\026[\219\029\1739\216 T\164`\018\194H\151t\207\135\198\143\152\205\019t\232FH\130^\139\201Ao<\003\027\198\224\000\246iO)\t\128\245_Se\226\027x\007c\224M\218Y\140\151H\002\224\030\243tm0\132\212\129\199,J?uNCI=\232\252\165\183R\228\176q\174\245\"\n\019\157%A\1782\234\150V\219\220kP\018\028\207\181\224\166D\b!\019\184\200$\t\132\207\180X\158j\177\212\139\017\236.\012p\028\150\133\243+\2257H\128{\030\204\007\155\159\231#\136]\026l\005\138)\191\172\"0\1890\179\233C\020~6E\016\2509\182;E\208\249\197\154\020\204\167\210`Y\002\203\149s,X6\136\234\138\128\241\171\022\003\211\197e\021\248\223,H\176\248\205fG\156\175\244X(\130\197\203\224\180\144\004g1\130\197+\131l\134\135\200\130\217\b\018\175M\028\193\132\t\007\012\014K\160x\179P\030\247\202+\b\024\191kA\136\174K\173\020\004\140\127\155u\209\150!\213\234\131\184\t\t\026o\141Z8N\b\233m\158\144\160qm\212\012\027\196P\004X\137\194\n\018<\222\153\149\1656\170\210\207G\208x\159xj\000\1841\175\233\130\000\242\193L\136\027Typb\002\200G\163\193R\139\021^\140\000\242\135\r8\218\n<\030\005\193\227O\187==]\234\143Q\0188>\153H\160\167\203\189\246J\002\199\r\240\235\207\245\232\201G\150\027\"!!\207\186\224Q\018dn`\140\207\177\025\232\029\147,/}\146-\243\147\203\004\132%\181\235\240\"X\135\134\179a\2194\219\166\223N\134qb\190G\166/D0\134\1927!\023\030\128\131\215\214\0154'\020\154tn\148\t\247\165L\214\148\205\171\000\002326^\004j#\152\026\1663\179\193\028\b\142!:%A\245\198l<7\0019\0154Dp\221&6\175\027A\200M\152\198@\144\165\004Y\203DS\027\227\197<%\218\23625-\230\132L\233v\137\138_\210\005\231\149\232\027\134/\253\004\001\167\001\030\161?\180\201mkG\018d\247\198\237q7\192\218$\004\n\191\b\129\243\206\2301\237\208\225\182\t\132\141\143\175\002\231\020\133\149#\176\253\199\004Di\150\1980\226E\t^\134\243\230\185\rN~i\002WK\150\158\229\bZ\007k\\\218\189\128$\206gf\004\172\227\242\204^\142@e\216\162r\245H\022H\018\168\238\205\210\144\180\225\216\025\145\165\004\194\155\n\138\022\225\006\b8\134\147\024N'B9J\000\205\148\168t\176\019\208\223l\167\140\192\227\168_a\156Dzo\194je\233\180\230\244\233L\252x\238&%\000}q\146\024%E G\000\250j\178\002\002\174X0_F\2401\204\215\228\004\022\136\017x\030,\222\204j2\\:#\000}Of\134\142T\208\203\157\136\137A\212q\001\017kK\023\220X\198i\228\237\17343M\015\001\206\163Dj\165\197\137\021\194\"\145\219%\130\216\2062y\"\232\142M\187\171\019\207\128!\187A\130\201\133\029\179\226\192\186+\176\235\190Zs/\173Or\012\163\220\158\159ra_\134\163ZA\n#\020j\204H\019ma\237\n\205\155\189\205\030\176@V\128\165\162\142\153\029Atu\139\173#\199\1581GI\204\1520H\186\001D]\015\182\178)\011m5>\0073J\139o\219\174o\140\176n?1\136\215*\245l\155Q\130<\212~+\200\165\020VN\233L}\024\229\201\219\169\135\250~\251\224\194\017j\007*n\129\142\163\229O5\029\134F\183\210\012\195\206M\014+=/a\148>\187\230\204l\131\0120\214\189\138\146\007\163\b\214\251\169\129\017\135\206s\006\144\196\243\128\157sn\207O\1535\014\210\219\011\214\0188J@\254\242\163\242\200\168\192\134\165\025\134\1425\015\163\1927\137\167R\216\015qQ\156\018\239\2196&H\224\131\006\155c;\1522\208W%\192\237\218\021\140\146\235]\181\223\219*\015\023E\184E\225\153.\163$\219\200\187>\153\246\007=D\249!\148n\155\150\b\250P\221\215\1825\002\228\027\245\195\193\192s\219-c\148UC\227\168\218\247\213\1899\1414+\233jg^\137\198)\232\241\214\227\236\216\012\203E\136e\216\2221\242<f\1397\213`\131\b\231&prH\208\2046\206\024e\222\206\030\231a\185\029%\192s\253(yzT\024\231L\203MW+\206\140)+\159\205\216\143SL\2191W\222\180(I\175\219\182\185\031\026\147\004]\191\b\166f\206\241)]\007\152\198\187n\154\027\136\216\205\196A\138\251&\019\163\164\220\213\253>\160\166\150_\137\180\244\001\149\146l\128\2136}2\133A\030j\r4T\023\238V\236z;\141V\207\204\136K\152\221\139\019t\012\015\191mk\14723\204\170\005\250\001(Z\216\176D\137u\144F\128\239b0\210\236+w\231&\152\028\170m\239\186\029\216a\197|\144\155~\177\145\167\228\186\175\221\129!0rY\152\214U\238N@\189\172\027\171\237\156ur\240\022^\022fW\185\225\141\217\138k\195\157E\237\240\2060\163\193\b\157\161\231\017\196\191z\151\163r\176B\2361\t\204S\202I\2314\007\238\192\012+\027\218\128)a{3\151\133\237\190g\148\026\223M\199}\213O\135\182\154\172\173#k)\176\191\224\161\203(Q\238\246\208\183\180m_\1424\0034\147K5/B`\216V\014\133,w\250A;RV\156\250\196a\014\142\185i\229b\t\225bcFI\201\185i\238l2S\193\250\1308\203\200>\186~w\011\173\187\1851\136\222\136&&2\031J3z\141\241\210\023\166\171VIFo3\222xa^\004\r\004n\197\137\199\188\177})\169w\206\130y\197j\231\007\224QS\187\218:vF\220\214iO\191r\182<wa\029\011\207h\255|\135\233w\024H\165\228\168&&\130eY\227\207i\132\0115'\187l\213\227\246\194\186\171\194\181\177si\241\164\157\238\206\157\208\236Z\006\187\166\189n\200qpu\007\177\218\250Sf\171\157r\222\204\134\140\184Z8\224\220rS\214\210\169x\237c\218\\\245z\191\160\210\149\143\031\210\233\188\136JO+\223\179\245\138\146\241%j\239Ksi\239]\137J\255\1858\173\239\241\196\142\187k\1904.\190\002!\194V\021\218X\154\158\158\221+'\152\218\218:\021>'\225~\238\020\171\226\244\236\149\159]>\173\250\247d\250\176\221\022[\225\193\175\176(\196bk\012\250J*\136\248X\180\162\249\134U\235\026\176\229\198f3\242Ynu\150\222\151%\254\020E\02699\19388w\204L\131\240\173U[\150\139\150\211j\133\016\231P\173\167\197\167`zm\209zz_2S\249\203eNt=\250\216\238\159CJ\183\215\018\171\182?\149\165\1281a\171\220\028\155w\017\245o\231\155z[\241\235F\181\244\212yu\128\128f\248\237\167\197\233\217\255'\007\174fS\bZ\131.\249S\225\215\244\184\1339l\216\141\167cZ\143\173\t\134y\025\181\180\202\243\193p7\017\156\222\173v\227\188%\232\149\211A\023\193v\252\245J\204\210*O\007]\136\b\216\224\218\206\022t\237IC\027<R\174;\245\bRC\200\188t`\192\158\200#\129\161\161\154\127$\186\181\221\247\250\184w\165\143\176\141 \197O\219\227\219\128o\233\203\014\129OoN\203\254LQB\181\027\148D\212\224'\018\211\230>[<\166Ud\136|:\012\158\007ne\179E\030u\171\222\159yn9\198\160\218\134P\161\019j\168\130\0149\029\240ii9\243\029H\204r\222\221u\189\221\139\238\211fq\255{\019\028\210Y\188\140\031\243\1737\026\003\173\140{\199\181\151\r.\179b\210\187\192\218\r\156\005\156.F\163\222\135\149U\152\019\"\251\158\2308\022\244dcqL\191`\024&\221\144\176=\015\1363x+\132D\221\021\185+M\250\232\020\\.F\233\136\151\014\152HD\214\211\186\141\187\026\142\201\030\166vl\238\219\007\171\025\253\202\005o\190x\228\172S\016\005\156f\202Gb\170O\030\238\2181\230\217\208\151\025\155\170\2215\183\230.\006z\002\027\188 \133\162He\1677\243\176\200\196KN\148GrN@\144\231\171\223\152r\026\0267t\233\160\226!\224\146\246\b\230\152\029#\141\139\019\004\143\171b\251\175\023\003\130\155\173\216\128\237\186\"\224q\192\142\001u*lz\141\214\003a(\176\151qA\179b\157\237\189-x\205G\140\225\138&\027\030\143\004\248H\011\138d\251RKI\1404\152n\004;\189\145\155\190\251\\\031\231\139\004\253pL\225\003\154R'\145\147\209\186\2227\131\2393\254\r\142\245\179\247A\231\221\143x\225\2132`?Y\230\r\019$A\2550F?\151\131\205c\027:\194%\130\214\152\183\201\211\155\233\189\238\131\212tz#]h\003\236I\027\248\020\212H\217\019\233\224S\016\224\179'X\129}U\228_\"\233\014\005\134\014YF\0202\218\022\201S\148\252\"L\190\154l`\242}\132l\180+\134b\159\231\134\247\169\171\020\226\015\235\238\011u\224K\243\211Q (Y\n[\017\133\215\219\171\244\0236\192R; |\217\177J!A\169YZ\027\136\166\155e\020\158\179S\172#\224M1\012_\017\233\239\139\240exdL\182\t\0119e\011\185\224\254|\149\129\215\228\253\145\012\220\005\210O\007\210*p\012\249\180c\012\129c\184\155\229\248\228\205\186)$\144\252\176\2009i\026\011\015{\218\136\223{\144\254N\t\253\188nG[I\184\215\158E\140+9\170\185\184\192\143\250\197\215\142\016+\006\205F\244\165,N\172\150\218\t\014\027Q\231\193\220\190\243\210\236\231\177\218\191\tH\219\252F\"\022\027\215\2532c\b\197#\208^\0066\156\t\235\217*\206\199w\190\187`i0\222\246G\213\137L\021\130d\015\193rp\169X\226K\130\248\142\174\195\000(\230\000\232\159\153\173\003\224\028\203\180\142T\030\231\229\191\209`\153\217\134G\248\014\144\014z\025\\\220\184\014w\2042\199\190\218\213\135\170\183\177Rj\235\193/J\196&\175\151\169\248o0\172+b\019\143q\149\1710_j\225G\138\167\151^\145\250\156J\168\232\182\193h\238\170\2140gw\213\207\226\182\137\189s\154-\241\217u$[v4\130\248g:1*|\012\174\190\220\147\200X\167\227\253\250V\199\006\157\"\141\007\228\203\160\182|\138\211\212\129\222\139\167\195\241\222\179\183\240aW\212\211\143\206\169\204\230s\251\212B=\226T3\180\174\214-\226\244\230\154z\137\152\155\030q7|\179\014?&\020\1702\174\211\029dg\251\026\031\031#dx[\131W\194\145P\219\005\166\031\152D\228\208\023A`p\1568~\232)\152;\168\193#s\131\1557[k\206R\127\021\004om\224\160\145:\246y\224[\142\002\198v\210S\245s\203\232\194wb\171r\199\219\127P\238D\0266\157\023VO7\006\223\174\130\1663\007\022\015\016/\233 \b)fP\254\b\r\244\2512\188\014\002g\236\012\231A\230\218\1486s\229\241(~>\183Xf\202\024k\228\190\t\212\227zN\241\141|_EpK\027#\241\2512h?\206q$V\151\158\160\152\225co*\255y\165\245\220j=x\132\185\226#s1\139\151Z\250\171A\016\151\221}\242jK\167\154\020&\007\157>\1951\1685\n\219\166\140\181\030\199\213\141\004\179M\250\2409\227\186\253\187Gg<vv\012\248!>\155E\243\228\145StK\210\022\004\147\bj\211r\128\139\016\2414\r\187\241\025\015|q\195\205\021\176\144\167w\180_y}\144\t\020\139\228\025[V\150\185~x-\031iI~_\\\172X\139\136\192p\\\193P8\143\143G 0\212\005w\198\007+\154;3\030\r\232\r\229'B\137h\150\188\156\236\023\199\252\247%/\143\187\224\139\150\248\215\224[\193\255\005\206\204\\\205"

let times_roman_afm () = "x\001\189}Kw\027G\178\230^\191\002\203\153s\134=@\225\221\189\146mY\237+\183(\201*R\184;\136,R\024A\132\026 \005\194\191~\178*\227\249e\020\220\171{|\142\012|\145U\149\241\142\140L\020\255x\\\239\031\127\221=<\254\171y\220on\014\131\201\223F/~\222}\251\214<<\014~\222}?\2377\247_\030\007\255\235\230\127\015F\203\197\244\255\180\255\206\187\127\151\237\191\203a\247\239\184\251w>xy\187\251\220\012\2548\029\030\155o\135\193o\0157\187\253\247\221~\253\216\220\254m0x\185\221\014>\180w;\012>4\135f\255#\161\250\168}\179~\220\236\030\006\191\164\209\127\031|\252\2424\248\215\2504\024\140\006\163\234\239\147\229\223G\243\238\t2\190~\216\252\251\169\249\237\151\193d<\156-\004\190\250\215\211a}\223$t9\\\014\166\147\229x\242\162\229\238\237\250[3\248\184\249\214\028.>\236\190\173\031^\252\250\180\221*8 p\253m\179=)\252\226\186\233\184\207\212\223\030\215\219\205\205\203\135\251m3\024\190\248\237\240\235\230\185\185}\183y\188\2492\184[o\015\205\139\159\191\172\247\235\155\199f\255G\2438x\245\252\216<\2206\183t\2314\135\159~\218=\015.F\179\197\224\162\026-\006\163\225p8X,\023\131\023u\026\183\223n\030\154w\187\195\166\019\194E\"*\252\241\203\230\230\235Cs8\012\166\195\023W\205\254\208\014\025\014\171\191\165;\188x\187{\220\2204\255\003\170\202\130\218\028\006\235\193\227~}\219|[\239\191\014vw\131\2237\015\187\199\211\247\230\226\159M\186\234\229\235\193\250\225\246\255\238\246\131M\186\248\240\244\249\176\185\221\172\247\155\230\240\183\023\175\210Cn7\015\247\127\220|i\146\136\187\025\252\241\152\134\175\247\183L{\241\243\250\251?\179\212g\179\234\197'\250<I\156\191<\220\180\018\221\015f\139\241\139_\026\254\150\1329\127\241\199\227\237?\175\007\213\162\253pu=XL\210\135d\216\173F\216\176\199\163\233\139\159\007\227j\240\143\193\245\167A5\029\166\015o\007\135\239\235$\189\127\012~\026\012\233\191\127\180\163\198y\212\184\251\240v\208<\223l\215\223\186a\163\241pp\177\028T\227\197`6\159\229\209\147<z2\\t\163\255\253\180Kb\252\188\237\198\207\231\201\024G\233N#\029?\205\227\167\195<\135\135\167o\159[\173\222?tWL\211$&\203Y\203\127\030>\243\195ow\219\237z\223\r\157L\006\023\139\244\128\233|0\175\230y\244<\143^\208\212\1917\251\155\2143\218\225\179Q\178\172q\154R\165sY\228\225\243y\158\251\250[\186\224\144t\146\239_\229\011\146\176\228\130\165\023M\199l\182\188\142\221ebw<h\r\156\175\152\012\253\021\223\215\251\230a\219\220\229\011&\201\029FIH\227\225D\175\024\005W\2323\170e\190\164ZL\245\146\202\011i}hgu\248\154\249N\250\154M\211\196\148\239\tix:\155\228Gl\159\014\221\216qk\003\211\164\210\233\144FN\188\197\220\164P\179\206\138\154\165y\164\185\142\150\211\228\205YY\147\169\159\250\151\211\247/M\214k\146\220h9\233f]M\179\178&3\127\239$\251\205.\139~\158\204l\148\238\189\024\181\145\"\143&\213V\164\171\195v}\248\210\r\190h%\210\222z\174\012.\188@\254l\246\187,\189I7v\146\198\201\216\165\031\187{\200.1J\019\024\166y\171f\166C?\242\241\184S\169M\230\170\143\233\b\006~\2177\249\166I\242\221\243\141CLAyw\187\167l\223\163\170\187\173\170m:\134\145\155\031\249\174\227\138\238\154\236n\177\200c'~\236a\243\156\135\146\000f\237\208I\030\n\030yh~\144\210\170\164\134E\178\129\165\184\227\020\220\177\017\187\204\246\144\006\0271\204\193\2137$\2186\138TU2\151\165\142]x\245\222\236\182\187<\137\197(\219\1942_\208\r^\130-4\2236\230\130a\182\204j\180\148+fCo\241\2196\161t,.Z\022\167)\204LGY\028\179\145\031\218\252\251i\189\229i\143\170\236\031\227E\158\246\172\242\131\239\219L\222\236\251nM\n\156L&\020>\154C\151\242:?\237\134OFjo3\210\225\178\026e\183~$\195\204\162^\012U|3\210\225\188\170\186\161/\243\2006\154\206\135\173\173\211\004H}\179\217\188\027\246S\0306o\189~9\022-\207\230~\216\207\194O;\187\228\220\242\216\133\127\236/\249~\179t\191Y\027\159\248~\164\175\217(3\242J\237{\154\1781\015\155\179\146:+{;\248\213\012\155hJ\152\143\252C_[\031\152\027\161\204+?\240\159\249~\203N(\149\222\015\242\221oy\216\162\245\254\14521'm\140\023\203n\216\127\229a\157\177\165\1963\212\129\160\1397\236x\233\177\149\ny>\243B\249\221\ne\161\1958\165\209c\255\165\195\0223s7\208\196[\030\214\250\206|h\132\188\244\003/mXh\163\007Ko\001\218x\167\186\157NTz\011\208\198{\189_\154\211|\168\129nQy\171\250\160\1987\155j\136Y\140\253s\255\024H2N\225ei\2387\241\002\252\024\027\243\002\212Q\231a\0192\023U\240b\230\007^1\195\173\bg\198N\023\164\146%\185\241u\014\128\221\184\229\216\136\006t\242\137-\166\181\191\137\014\003\141\172\178\183U\2210\229c9\244\236\254w7l\t>\180\132\234\225s*\202\1916\143Rq,Z'N\146\173\150*\241e\229\195\233\231t\201\217\244\186\028\135\015\209\"\165S\127\251\148\137\138w\201\133\226,\027\242\250p\179\217\220l\2467O\185\182L\169\185J\140L\140\167/!3=\1815\239!\021\235\\\180^\140\170iG\189h\157\174\189b6(\0114a~4\154\230\002m\170Av9\24719W7\169\144L\203\144\004\166\1643\203\005\200\018j\138\207y`\030\215\165\211q\030\183\2447\188\201\220M\243\192\145\222\176\171l\\m\155G\210\163[K\167[\142\134#\127\207\198\221\179\154\152{V^\000w\003J\228)\152\165\187uwL\161f\147\138\135\238\195vp\183\165+\161\186\184\151\160\223\214\179\147\249\208<\004\138\139/b\138\147\214Jd\214SoW\027\141 \213tl\198\205\252\184\255\151\237\174-\002\187\181b[\130\201X\168)r\141\219\249|\235\2022\012\202\137\173\134\254\182\252\212q\236{4\238\155Nq\158LJ8\030\129\170\030t\220da\199A\229GU\2312+\202\202p\004e\223w\014\"iE\007#A1\255fw\201C\147G\235\208\137\215\254~\192k\170\241\216\206r\234SY.\133\166\163n\150\227\137\189!\168\134\252([}\149r\201t\190\164\145\160\152'\178\137\204x[\137\241-\193\143~\176jra>7#!0\0303\227\163\156\170\146U\200\200\n\212\243\172\169\192=\187\002\245\156$\023d\027\159\154\161\149w\185?\2179['^\152q\\\211-\134\018\011M\196icS\187\140\025\183\171\200\005_\195\171*\014%\180\162M\1371[|R\223|Q\209\224i\240\000\r\181\221\146\188{\194\194>\129\235\244\201H\131\237\227f{K\203\144T\201&\023\152\166h1\174\200\021f\1449\242\178\255vw\204\182\190\164\185U\195\214\144\230t\r\024\177,\182\167\173\133\140\219\181\195BMd\006\134\220\174RS\139'\007\154\182TI\227\151\186\216\030q\253;\162\130\225\174m0q\185\156{Im\233e\214R\163\025d\140\019\173d.\210\132R\136\024ir\030\205`)s\183\221\2377\015\020N\146D\1510\025\176\239C\163s\233\150\171\173\219T3s\001\216\249\205\211>-\228o\178\201\181\203\159\180\228\153\166\255\205\134<!2\247\017)\186\203]\135M\215r\163fA\187n\028\153\250{\196%\179\174(r\247E;\012\227.\227\217e\197h\014^p\255\180I\023|\219i\149\144\210^{Q\202\224\147\017_\004\137\165\189\168\155\156\\\148\212\219\230\2146\028\202E\227\158\139\212~\019W\237Um\192\147\1718\189P\005x\151\019\199\184]\143O+\147\022\185\210\150\129\180N\171\138\129\160\188\212<\227\242&\133\177\148][B\197.=\007\205\221\174\239\239iM7\237\194\212\178+\012T\158\203h<\247\192\166]\1975\246\151pq\237{\031\173\2514\251Fz \169W\217\245@\198#\154\025\151\208\147\169\244\134\214\247\251\245\247/bT\233Q9.\138\157s==\166G}N\205\223\230Q\194@\170\152\198]\005\1953\131\020\162V\248y}\200\1348_\242\002{!\173\159\017\151\217h\137r\213d\154\175j\213\172W\205\226\171L)9\204\006l\022\018\163\197\188\199\128\141YM\178\005/\212\172\184\028\239z\207\157\021l\183\155\239\135M\206~m\234n\011\248\197b!=\167\017\151\230rI\210\211\227\151\221\147\244\b\219H\177L%\223\164[fw\215,G\131p\145/\145tLu\2058\177#b\199\146:i\149\154;\233\254\211T\245T\157\249,h4(i}\243\244\152G/\199\221\232\241hnFC[.\023\221w\219\134\210\228(_\210\198\"\234\019\140\176\142\214\212\145\006\143\171\028t\199|\255\185\031\252m}\179\167\200\216\222{B\247n\139\216n\248b\000\171\135\134XM\225\179\155I\183\\\229\153@\203\245v\247\184\190\145<\211V\019\211Ek\138)\242.\242\003\170!\244\\o7\201\169D\207\249\130ne/\023@l\219sRJA\191\205\025U\210\210|\196\131AS7\205m\178>j\138V\173jS\139s6\162fz5\196\158\232\211\195\253z\255\244m\187~\202,\\\144\198\230\170\177j\b\226\223\221\167\174$\181s[\031Oi\174\154\140\229\017 \255\155\181\021?\168\182\026\022n\240\r\130aG\225hXq\253\193\r\136\151\175h\168o@T\1494hs0\222\237o\239R_N\154~\147\174\151\218\006z\246\227\138\247#\164\005\162\171\206\162\015R\241\182\1324.tp\187\220\236\170\159\212p\024\019\155\188/\193\211\190|%\2067K`\187.%a\243\142D\023e\243\196\191\165z\233i\2033\159u3\183=\250\138\155\244\220\203XScs\209\213\187\179\177\174\242\170\t\172\130n\219<{8\192bH\135\227\202\197\200$/_\150\146\215\170\162w\173\131\1875G\187\218L\002\159N\201v\185\131\2052\220i?\182\157\246RW\029\021\246\176SFK{y)4\031X?\1691`\215\189\023P?\254\134n\151\219i\139\241\212\r\151%\173\1980\179\174e\143\192\209k\r\026f\169\206A\227\002\230\254T8]^\151L\187\164\018?\161Q/r\243\241O\144\158\141cVz7\200,\183\137o7?6\183N\246\221\166\011e\170\226\230F4r\231\2290\028\251\018\131;\183\128\023\139Y,I\189\185\149$HE\154gx{m\163\225\003\164\004\215\007\216\133\022>A\214\162\221\022\147\t\241\237\178\180K\151f]Z*\203O\235?\208X-A\222\242\176\236a\219\219\178\185\160\199\154\215&bwbmw\224f\203\130\001y\128\023\146Lg\024\219\179\185{k\201i\007g\178\208\1333\015\151v\187\159=\183\221q\238\210\196O\217\155\183\026\176\147\207c\221~\160U\214\146V\176\169\140\188\128\233\204g|\r\239\214K\200\156t\015\231\232Z\204\223\022\0202\251\2098\148\252M\233\183\163\170\176\002\209\147X\1291~N\245(\152\183\200m\215^_.\\\127]$\196\241\219h\182\139\223\203a\161W\153\141V}g|Q\250\221\197th\137n\187\223\023\144\168~6\177D\247sz'\164u\159\157\208x\209cg\1906\23534uuQ\2138\007\228\174K\002\170\210\209\182\208\026\229B+\n\n\210n4\146\159\145\228\139h?\207S\223\238\254l\030\238ip[X\181\027\135\243j\018\202\240\131)\176x\247\002\163\159lN\161\146\198UV\146\221\168*\252\027\194\153v\209z\237\024\174p\230\019\007\192\151\214\171$K\140\226d\190W\150\185\155\2167\149\027\171\167j\154\245d\251\222h6\255\237\205f\217c5\188\200\255\248e\1837\237W\187\023\133,^\026\022\205\014\0232)z5\006#z\197\016\204\187R:\214lM\021\163\023T\243\153\160\14853MV=[\198\001\184\182\1541\217\000\166-\214\"1L\237\004C\216\216\158D8<u\237\134=\171\190J\226\171\204\198Z!F\019\150\140\020\251*\016\179t\021\179\234\027\171e\156\142E\167\160\154\233\219\211\246q\243}{\226\172\209v\207R\206[\206c\161\152%\177\241\158\190H\234\029\186\r\160E\189D\203\154\212ry\220\172\183\183\155\187;\t\186m\163\179\141\023\1638]\159\138\234A\138\160j\028g\026c\137\186\133\139R\148@\007\206\127A\225\174\244Q\137\212X\198I\168\238\171\018\029\0116\186Tq\026n|Al\234\177\158\011n\202\250\1274.4&\251/\016\219'\139i\239\216'\227N\198\022\134}I~mj\r\017=\200E\0229f\030y\133S\170\201\158\178J\235\225\190\163V\162U\222\020\216\239\1906\015vk`\148\150\252\221\214\192p\030\022V\251\230~s\208\006\226\153\202J\178\147YF\233\249\t\244@]\209\249\252\222\183\164\155q\139\252)\165>i\146\143\166\020\248\166\210++\204\210\132\014\177H\144\166d$\149\188f\164\216\000v\198\000\204V\028Z\128\228#\027:\226I\200P5\150e\143\007M'\185|\161\147Az\154\168\234\178Ww $V\206\171\199/\131\179E\184\212t.\227.r\198\181\199t\138\154\180\168\028\169l\183{\163\"\240*\007\190G\227\024y\255o\220\1501U\021\251\191Y\162t\254\220.\128\204Fu\145\243\204\248.\231\205\166\238pF\1459\140\227\253e\150\241\241W\134\247u\"\212\n\255\131N\196\159&n\241\230 \142\149@m\153\156e&\219\179\153(rI\188fm\222\159x\197\204\205L\140\149\247uPlmd\22698\133T\223\198\221t\159\184\151Q'\241\139n\221\211\030-\234Iw\151X\189\026f{\234\234\218\132\138\254\005\243lDK\218f\251\152\221\163\243\165\161\158\147D!>Jui\182\226\011\151\208\003\160\190\150\234\218\155\213r\214_J\249<j\248\196j\151\030\241-\239\163\143g\180\180k\235\232iO\025\160\"\185X\240\025\139\190\144Xt\196\216d\150\163\2222\233\1495_jC\219\179G\248\144[m$p\213;,\1339\159\154\2104E\199}\138\146\007\205\024I\177\2308uQ\134\219\2087\161\238\251$\168e\199d\246[\019\197Z\179\028\167\221\137\190:\252M\177v\155\208z\191\n\022\216\220\195v\165[\238a\163Y.i\135W\127J@\021A\149\216ZNK\137jU\2292\240\153\178Jr\182\241\019\201\215=)\2457\191q3\236\246\r\138\197\018\243\233\234$\234\213\163\213\147j\147\213|Yos\189<\206\1997\230\147\210I8U\182\237\241\255 O\138-c\243\207\006\191\184!\252`\246\179\164|\028\247\244\254\nW9\027p\200U\n+\152\2476Y\026[\158\024\141B$\150F\188\217/3\135\179\176\247mdON\165\161\254\175|J4k\151\182\139\190\209\224$\019jpL\206\173(\011\153\158\201o\019\014')1\2111\250\228\"\227e\235\188\227\222\030\202\206d\241\254l\168%\148.\208M[\172\167\165\253\164\247\238_\\\242\030}\242\241\205\r\219r\218|j{K\169\1998[\2444_\213\173\184\238\235[|\236\139\238+u\202\205Y\175byc,\223,o\166=%\133\142\182B\028/z\250bAC\178\141\151\246xo\025G\130\166j\238b.\250\171?\195\133\148s\211\158\234\207f-\170D\231\221\015\152z\250b\1861\160\133e\172\172K\211\0305\246;\141\253\252O\b\222R-V\227\158E\250\186\236z\247\173C-\147\139\204\164=\188\142\138\253\138R\231\214\241\176\172F\165\001c\215\174\021\253\016\162\234\155Py\200\128\242I\143O=\128\225\231\021\253$\172t\030\011\155\025\211\250\197\156H\196\233ow\247\173\031>\236\228\\I{J\212\254\152\163\176~\223\1950\014P\245t\226\220\005&4\224xJti.\154\231Z\187\031\183\167+\230\221\145\1370\244#\2236\001\204'\203\240\162\230\241\139\159\127{.*\238\242\252\233\218\148\188\150\233I\161\133\014\168D\181\231a\177`N6\234\n\230\020\199\187\138y\178\232]\171nLv\236\218Z\237\252{R\227\171'\250\153\151\254\156\241\213\195\173\249\029d\254a\228\155f\255\240\203\250q\173\223\222\1737\169\230\172\134\243\241\1397\239>\r^\014\210\189'C\254\156s\185\001\178\152,@U\168B\175\237\231\156\177\r`e\167\240e\2182\155\242gz\168\002\198\161\012*\022g\176\156\157\012\224\178\173\193I\180\006\201\231\007\012\144#\156\002\239\205\231\143m\254\024\241\023\018\138E,\151\138\215\230\0225\178Y\135l\214\001\1555\178Y\247\176Y\023lr\179\193 ]\208\215\239Wi\194c\254r\157V\176\172\163U\235DL\160\141y\139\232D\0214\191\0185b\2481\184\152O\232\2431=\161\162\207'\251\153\030\160\128\222\159\177<\196\024,\001`\181\132\130\2332\138\246\155\241\215\005\000\150Lhh\206\153fl\154\000\2088\161\145\218\137T\234\158\b`\000\132\198V@D4\005\130\193\236\t\005\219\207\232{\004\172\023\016\130\174\192p\232\015\153X\227m\235PNu\191\156\234>9\213\161\156\234sr\170c9\021~C\176w\158\012Z\015\202\136q\163\012X_\"\004\029\138\224\192\1712%t\173L2\254\149\129#\250\204\169\000\192\221\b-}.\187\129\2419\002\192\231\b\005\159c\020}.\227\175\011\000|\142\208\208\2312\205\248\028\001`K\132F\182D\164\210\150\136\000\182DhlKDD[\"\024|\142P\240\185\140\190G\192\250\028!\232s\012\135>\151\1375\222\182\014\229T\247\203\169\238\147S\029\202\169>'\167:\150S\225s\004{\159\203\160\245\185\140\024\159\203\128\2459B\208\231\b\014|.SB\159\203$\227s\0258\162\207\156\n\000|\142\208\210\231\140\022\140\227Y\020\188\207\146\192\005\029\t\253\208\016_\199(x\164%\133ni\006\024\223\180(\024\158%E\214g\233\165\tZ*\216\161%\197\198hG\160EZ\026\184\175%\129\015\027\210\251\016\181\222latiG\011\253\218\140\168\195G\213\253\130\174\255B\208\245YA\215\253\130\174\255R\208\245\025A\023\254oi>\b\024\138\141\004\0066\225\192\1606&X\024\003\131\165\005\209\193\144\195\016a\232&N\024\244\024:\251)F!lXR\025;\0041\145C1\136\027J\128\168a\b\0243\132\244:\194 ^(!\140\022B6\177B10`%D\230\171\212\210x\149\006\166\171\132\216p\149\142f\171\020\136\014J\128\216 \132\247\001f\227\130\130\024\021\012%\140\tB\175\131G\212}\226\172\207\138\179>#\206\186O\156\245_\136\179\238\021g\017\003\148\226#\128\224\214\255\0054\222/\152\245}\005\209\243\149\018\248\189@\161\215\011\213\248\188`\199\192EO\017\006\222\174\132\210\215\179\248\141\163\019\000^N(\1848\163\232\223\025\127]\000\224\217\132\134n\157i\198\167\t\000\011$42?\"\149\182G\0040<Bc\171#\"\154\028\193\224\190\132\130\239f\244=\002\214k\tA\151e8\244\215L\172\241\182u(\167\186_Nu\159\156\234PN\24599\213\177\156\n\191$\216;e\006\173Gf\196\184c\006\172/\018\130\142Hp\224\133\153\018\186`&\025\255\203\192\017}\230T\000\224v\132\150>G\2261N\199\bx\029\195\224v\002\163\223\017\225u\137\128\2311\028\186\030\017\141\2391\002F\197pdUL+\205\138)`W\012\199\134\197T\180,\198\193\005\025\006\031$\248}\129X/d\b\221P\240\208\015\137Z\023\183\174c\161\213g\132V\247\n\173\142\133V\159\021Z\221#\180\194\031\025\247\014I\168\245H\130\140K\018b}\146!tJ\198\003\175$R\232\150D3~I\200\177p\172S\137\128k2\\\250&\201\196\248&#\224\155\012\131o\n\140\190I\132\215%\002\190\201p\232\155D4\190\201\b\152\025\195\145\1531\17343\166\128\1531\028\155\025S\209\204\024\007\223d\024|\147\224\247\005b}\147!\244M\193C\223$j]\220\186\142\133V\159\017Z\221+\180:\022Z}Vhu\143\208\n\223d\220\251&\161\2147\t2\190I\136\245M\134\2087\025\015|\147H\161o\018\205\248&!\2017\167\222\177N%\194J\000\216\b\154(\029\239\1983\243w\240\203\012\130W\018\136>\217\193\175\241;\248c\006Co\236H\198\023\243w0\170\012F&\149)\165Ae\028\204)\131\1771e\026\154RF\193\2512\b\190\215\129\239\225\187\245\187\012\160\215\017\026\250\\G\171\225\150u$\154\186W4u\143h\234H4\245\025\209\212\161h\n\031\203\168\247\176\238\155\245\175\0140\222\213}\183\190\149\001\244\172\140\006~\213\017B\175\234(\198\167\186\239&\219u\223O\248\0292]\006\203<\151-\1928\019\001\224M\132\130;1\138\254\148\241\215\005\000\030Eh\232R\153f|\138\000\176\028B#\211!Ri;D\000\227!4\182\030\"\162\249\016\012\174E(\248V\254\250\030\001\235]\132\160{1\028\250W&\214x\219:\148S\221/\167\186ONu(\167\250\156\156\234XN\133\159\017\236\029-\131\214\2112b\\-\003\214\215\bAg#8\240\182L\t\221-\147\140\191e\224\136>s*\000p9B\011\159\251i\240rpA\204\253\196\219\165\006 /Q\192jMQ\189\175b\164+\005X\019\138\176\018\020\201\242\215\239d\184\002\212\173\220\248\179\136\152\001;9E\173\200\025\163\201)\224mHq\158\180\"<iE\242\164\233\251/\173D'\242\217\199\174_D\162\n\216I+\170\147V\140&\173\000ON\017\158\156\"yr\250\157$*\192\149\249\156\236z\204\159W\226\006\191\1361+Px(\157z5\188\019\000\002 \020\164@h$\n\"\149\242 \002\b\133P\148\012\193(\030\130\189\140\b\004Ae\244\n\001#\178\012\172P$(<B\003\tv\191\181\176\018\204\000J0\163(\193\140\134\018\204\164@\130\153\128\018\204h!\193\012\023\018\2040H0\131(\193\014\189B\192J\176\003V(\146B\130\025-$\248k+<\138\148\191\138\220\020 \145)`\165\165\168\222W1\146\145\002,\030EX2\138d\161\232w\146\135\000\169J\025\241\204\215\028\204\004\160\217*\224\162\155\160&\186\t\198\209M\000\137b\130H\020\019\132\162\152|\167\217\n\144\255p\192\197bH\223w\134\182\195\217\239\194\201\238\130\201\238p\178;\b\197\130\023L\208\187\146\012\128s\166?H\192\147\254\175\214@f\242\153&\173\000\137\\\001\203\133\162\202\133b\196\133\002<[EX\228\138d\145\235w\154>\001o\218\146s,\15997\011\224R\177\160&\021\011\198\169X\000/b\197%E\011B\"V\12832\003\233s5\229\2074G\005\168~4\128\153\180\162:i\131\201Y{\003\018'\n\240\140\021a1\011\178\147\250\225\141\024\170\002AA\243\198\026\170b\190\160y\131\134\1708\020:o\196P\021\240u\205\155\193\147\024\237\027~\241\129\001\002gzc\142\170\027\204;\211\027xo\150\193\193\153\222\200\027\137\012\226\"\194\155\182\200\020\153\158P\211\167R\133v\145`,\217\193`\212\142\022\217\183\027P\154\186#\131\213;Z\236\000n\b\250\130#\130[8\026x\136\1655\177t\208o\028\r\\\200\211\002or\003\206k%\2421G\007ws4\244<GD'\180D\227\143\014\006\215t\180\200K\221\128\210a\029\025|\215\209b7vC\208\163\029\017\156\219\209\192\207-\205\184\188\131\193\251\029-\n\004n@\025\019\028\025\194\131\163\197\145\194\r\193\160\225\136\024?\028\209\135\018K:\197Fr:\227\018e\172\249\189\237]\208\146\246w\233Z\024\192\246+\004n\023\246\195!}\185\150\194\236\247\188\156g\130\174\228\005\177+J\006\237\250]\158p\146\218\244w\237)\011P\020\176\191\203yt\190\131?\142\142h\196\149\158\221\230\169\201\217m\230\207\156\221vC\nN\131\179\219\142\018\241,\007\179=O\200}q0\155\t\153\213\232\206\153r\194\161xgB\131;\027q\025\017;\024\004\237i\145\184-h\133nq#z\011\175z\134\023jp\196@\025\150\030\n\206\187[$\143B\136\177\18719\135<#D\002@|\140F\130\2034+\178\140\024ae`U\012)\004Dp \154L\137\132\146)'\228\t\005Ah!\130\183\166q\246\022\027go\177q\2466l\156\189\r\026go\177q\246\182h\156\189-\026go\161q\246\022\027g\2446\170\151\005\000\243&\020&Oh\196\001\145J6\136\000\188\016\138\012\017\140\\\017\236Y#\016\248\147\238\019\000\192\159\239>\001\026\241Wt\159\128\000\252A\247\t`\228\207u\159\000D\254\140\011\189\236\129\145WKC\142--\228\219\014\b\184\183d\148\129\165\021\146\176\196B\030\150\bR\177$\144M\254\250\178\000@\030\132\130$\b\141d@\164\146{\"\000\223\132\"\199\004#\175\004{.\t\244\252]\026\214.\145\171Kd\2322\228\2292`\227\0189\184,&\127Y\204\251\018\166|Y\206\246\1634\248.%!\024 \216`\187l\211\192\148?_\155{}2cVf\140t\004\0050\001\1540\012y\151a\200\187\012C\222e\127\200\187\236\011y\151a\200\187\140C\222e\028\242.\163\144w\025\134\188K\169\021'\142a\020yT+z\218\021\202\236\026\031\242\t/Y\225%\168\144\162rd\130\145\168Q\141EA?\150\004J\178\164HS\150^\170\203RAg\150\132\138\1794\212\158\165y\021Z\n\232\209\255\140fR\202\t5\218\251#\154`\192U(\249\235\240\233\159\194;\172\194;\160\190\227\031\1500U\016\163r\197@\225J\000u+!R\182RKU+\r\020\173\004T\179RP\201J\241*V\028\020l\127\r1A\137\160r{~\011Q\144\175\002\233^\007\207\252\020\\\187\n\174E\133F\191\023`Z\022\162\209%\001\160HBA\139\132F*$R\169?\"\128\242\bE\205\017\140j#\216\235\140@P\152\156\130\1598\134QU\209\025xO\187B\153]\227C>\225%+\188\004\021S\156\031g\130\235\223\024\229x\028t\228\137\160*O\1404\230G\148\138\243t\208\159'\162\026=\021\181\233\169^\169\158\006\186uD\163b\143\131\166\129\024)\220\r\185\234\209\202u\207<>\245\220g\213s\031\180\tO,M\131dk\140\130\0170\007\134\193\016\024\142L\128i\165\242\153\002jg\024\021\2068\170\154q\175dFA\189zv~\226yG\149\134'\231\129xUH\240\186x\210\167\226\170Uq\021\170\171<m\206\148\220m0z\"\000\212D(h\137\208HID*uD\004P\017\161\168!\130QA\004{\253\016\b\234\145\190\209\1961\140\202\137\250F\158v\1332\187\198\135|\194KVx\t\170\165\232\"1\001\023\152\151\225\002\2432\\`^\246/0/\251\022\152\151\225\002\2432^`^\198\011\204\203h\129y\025/0\229\244\223\1961\140Z\137\206\254y\218\021\202\236\026\031\242\t/Y\225%\168\149\226\220\028\017\222\181\n\161f\222;\209\133\002\164\006\005\172\006\020-N\196\189\019\185+\192\"W\132\165\173H\022\180~'\025\011\160\135=\222\225a\143wx\216\227]x\216\227]p\216\227\029\030\246xW\028\246xW\028\246x\007\135=\222\225a\143w|\216\131\015\"\190\147\147\020\140\1887G\241\222\227Q\188\247\225Q\188\247\193Q\188\247x\020\239}\207Q\188\247\197Q\188\247\197Q\188\247p\020\239C\187\237<\145\207\254\028\213\007\191\193\172hqN\234\131l%+\224\231\1688\156\154\250 ;\197\n\248SQ\031Z\191\155\201gr9\003Xo\019\1846\215\215\200W\029\242U\007|\213\200W\221\195W]\240U\195A\176\015,{\249~%\199n>\180q\128\250\230\031Z\143\159\201g>\130#\1289[CX\030b4I\000\176Mh\196;\145J\001\016\001\164@h,\n\"\162<\b\006e\019\n\026\151\198\205\204\003\160\251\168q\227i5\222\179\014eR\247\203\164\238\147I\029\202\164>'\147:\150Ia(\004{k\145N\212\194\001\198n\164\241\228\237\002-\168h<1!K\215\152\017\001 2B#\145\017\169\020\025\017@d\132\198\"#\"\138\140`0#B\193\1402j\204\136\0000#F#3\202\180\026\239Y\1352\169\251eR\247\201\164\014eR\159\147I\029\203\1640#\130\189\025\201!\221\133\003\140\025\201!]o\023hF\197!]!\248CM\242\224\224PSH\011\133\024\031j\n\201(\208\254CM\225\144B\184\193\161\166\144\134\198\231\247\210g\017\140\134\216\187\151\030\141\168\227g\213gd[\255\149l\235\243\178\173\207\200\182\254k\217\214\231d[\154\175%\130\017\251#\005\139\000\182\006\237O\020DvZ\024w|\158\128\200\031\187\194z\204\159\185\176\022\128\011k\001\\a-\168)\172\005\227\194Z\000)\172\005\145\194Z\016*\172\229;\023\214\012$/\028-\2483\215\161\002\184:TPS\135\n\198u\168\000P\135\n.u\168 |\014Y\000.\167\025\208s\211\031\165\248W\128$\170\128\157\180\162\133\245~\148\226_\0010\194\143Z\252\235\141\178D\245\187\247\237\143\169\248\223\182\183\152\234\247n1@\1992>\182\167\024\231L\227\163\139\n\144\219\027\192\158\178\023\1808\188\249\209\029G\212\129|\244^\0008\152\249QO\027\202\152/\167\239_\026]\176}\028ld!\250\145\255\170\160\001`\237\252\177=\162(\226\217\161\190v\161z\204\tD\197h\238\nx\155R\156yR\132lJ\001\210\146\000\188\"\019\181\236\r\003{\228\145\254\252\159\005l\b\022\248\208|\219\176\254\025{J\182!\1599\000\011\224\162\174\160\198X\005cc\021\000\130\170\224b\196\130H\248\020\132b&\127?\026\201\156\236g\212\222\169\212\147\028\030\225\152\226\015\143\000\n\241/8<\002\1642\018\250\195#\128bL\132\195#\000\251\232\232\015\143x\212\196I_\250\002\026E\204\162\244\005\002\196\206\176\244\005\"FQ_\250\002\n\2414\163k\212 FVB!\188\018\02691\145\202@K\004\136\182\132b\200%\024\227.\193>\248\018\b\0178\163\016\134\025t\1778\131&<\018\000Q\153P\b\205\140\150\231\236\153T\006i&\148\145\154(\016\174\t\197\152M0\006\238\012c\244\206\168\t\225\004@\140#\020\131y\134w(\243]h,\187~\179\216\245\005\014\140\242\132\198\161\158\136\024\239\t\134\160O(D\254\140b\248\207\232\030\249\222\135B\194l\192h\148\0182-\200\011\153`\146\003\001\144!\b\141\210\004\145\202\\A\004H\024\132\198Y\131\136\152:\b\198\252A\176O\"\025<\162\164O\005\016\154N\148X\252\169=\137\199\193\169\189\144\134\169\166\239\212^8 H;\193\169\189\144V\164\160\232\212^H\132t\020\156\218\139h65\005\011\233\144\022\166\169x!\029\1461e\245/\164\195!E\250\n\022\210!\rS\153\161\173c\203)\210\154\165ar\179\1800\150\217\001A\162\179dLw\150V$=K,R\159%B\002\180$L\131\134\134\201\208\145|J\180\191C2\169\197\194\152\030-\r\147\164\163E\169\210\014\b\018\166#\007i\211\210\253O\214<M~q\028\017\139Dj\136E:54\155T-\140Y\195\210\138\004k\136\187X\179\1873&\188\251+3\221\157\015\172E\250\181\180\158$l\135\020\169\216\0181![\026\166eC+\146\179\161\237c\201\237\207\136\188H\215\142\022&m\003F\169\219\144m\002\1830\166qK\011\147\185\029\016\164tK\198\196ni=\233\221\014)\146\188%\022\169\222\018!\225\027\2101\214\228\169\007>c\208e!P\155\183:\212\248B\135\026\223\229P\015\162\2158\212\193\027\028j|yC]\188\183\161.^\217P\195\219\026j|QC-'\167\001\128y\251\147\211\128F\028\020'\167\129\000\188\192\201i\128\145+wr\026@\224\207\159A\142P\22448\131\028\145\"\158\2273\200\017\021\184\143\206 G4\148Cy\0069\162\128D\236\001\221\018\003i\020\007tKB$\137\232\128nI\003)\148\007tK\nJ\000\015\232\1508p/\231Y\001\000\190\253yV@#\142\139\243\172@\000^\225<+\192\200\165;\207\n \240\135'Cc\028\184\rO\134\198\196\136\247\190\147\1611\029$\017\159\012\141\169(\151\232dhL\003)\233!ID@2pH\018\225H\026\229!I\164\128\004\240\144$\226\200\181?$\137(pJ\023\191,\017\224\148a\224\148\225\136S\166\149\1562\0058e\0249e\0289e\220s\202(p\218\rz\137\223\129\203\012\002\143\025\1408\204\148\146\191\140\003w\025D\2222\138\156e\212\243\1491\207\213U\203\017\191\145\238J\2161\b\159&S\196\173\150\0216kd\005ye\172\136,v\021\146\163W\n\209\217+\005x\169+\200k9av%/`T\192\021\178\002_\026\190ag\253*\220N\191\n\246\208\175p\227\252\170g\183\252\170\216\"\191\194}\241+\220\012\191\026\152\147rWz\184O\017fU\017\183'&\168y\243\148`\220O\021@\214\129\130\136.\244\254\164\011\005\248\221S\012\208\130\128\022(Wr\224\175Z\018\224\230\219\020<\2012Y\129\136\165&`\201\174\130\205\r\145\209\166`\180)\025\229\181-\255\224\251\170]\209\206\2283o|\011\224^\152\"\168y\159\132`\252\234\019\001\228}'\130\192\011\157\174\186Wb\137\000\229\157X\1388/T\216\172\023\004\227E\173\000\208\147\210\171e\253*\b\183\159t\012/U\025\144\211\1562\196,\018\197&\210\202p\206n\200\203A\005\156\190\0055\250\022\1405+\128\231Eq\209\184 \210\215\016\132^\170\150\191_w\161\1444r\173\161P\017v=E\188\018\0046\161PA\014\133\138H(TH\172R!r?\0058\020\nr)\167T\175\181\207)@pz\246\218u4\005\243\167g\175\139\222\165\224pz\246Z\187\148\002\240$\025\208~\22856!\175\177\243x\029\182\027\175mLS\204wl\1745\166)\002-\196k\232\027^KD\019\128\172w<\151\239]D\163\174\215\245\192\142m\144\027\014g\006\136\184i\138\204r\237\194\153\014\244\233\230Z\163\153\"\005\139\028\204fl\220\0273|\227s\223\181\134\031Av\230^;\228p\0232\180\011\212\179C\245\196]\180\235\162uv\141\253\178kl\146]K\228\017\181\152\192#\170{\146F\239\181\004\030\005\220\139\131\005-~ p-\129G\001xS\176\224\242\146`A\228\253\192\130\208\171\129\249{j\012\209\223\154\190\150n\144\002&\012fle#\213\170\136T\171\"R\173\226H\181\138\"\213\170\136T\1712R\173\202H\181\194H\181*\"\213\202\188\186m\133\239k[\133/i[\005of[\225\235\216V=\239`[\021/^[\225\219\214V\248\138\181UW\128\r\229\139\132SAX\182\138\248\b+\1769\r'\152\127\181\227J\163\149\"\250C\004\129\248\151\b\002\248\151;\1748^\145#\172\176\002[\r\220\132\155\130)\014Y\022\t\153j\002\166\\\r\166#\145\213\166`\181)Y\149\026\140\170\178U\027\183\168\211\188\146\184\165\000\188z{\213\149M#\190\155\148M\1388\182\0206>&\152?}\176*\202&\189\026\182SVZ6\233\024.\154\025\192\178ie\163\151(\242\201\138\226\t*\231\021\188\196M\225\162R^i\229$\000\178#\004(\150W\230}l:\200\175\nV\210\231\021g\247\141^\1321B\005\173^\164\005\177\2027{\017.\162\022\180{\017\135\248\229\027\190\000\155H\230\127C\002h\020\211\138\223\144\000\001\162[\248\027\018 b\156\243\191!\001\020\"^Fm\216#\004\195\004\193\024\000\t\014\003\006\209\202\168A\004\b\018\132b\164 \184\b\023\132Cx$\020bdF\193\191\024\244\2092\163%\139M,\144\"x2\220/\144\166O a,%R(\171&\150U\211#\171\"\190f\216\004Y\002 \210\018\138\2256\1956\230\018\130\129\151\2240\250\018\173\012\193D\1288LhO0&*Fd\1301,\019\012\1779\163E\128\206p\016\1653\225\169\144j\017\175\t\014\1316\209\202\200M\004\b\223\132\246\196p\162b '\184\136\230\132CH\183\0279\018\253\138\157\156\128\130\177=\222\203\t\200A\132/vs\002J\017\231\203\253\156\128\004\209\190\216\209))&\230+\006a_\tQ\228Wj\025\252\149\006\241_\tq\nP:f\001\165@\"P\002\228\002!\216t\160 \006@\165`RPJ\024\006\149\\FB\165A\196S\002\006=\165\020qOI\144&\148 \189\n\164\128\159\027\220'\012!\132wiz\165Vd\014C9+\181\230\140\212\194\020\162\212>\1536\1892m\250eZ\164\019\161\152\140\162\024$\021%`^\017\138M-\nbvQJ\152`\148\\\230\024\165A\154QBO\166\209\001\152l\148\130\249F)\144r\132Pd\029\161\004\137GhO\145\n\138\244\163\1480\003)\185LBJ\131<\164\132\158T\164\0030\027)\165HHJ\2429i\221\254\253\"\138\203\235\246\152\rm\237P`2\196\012\152\0179@\153\017\0250#\140P\2040\131\154\1772A3R03.K\203\012\202\128\025AR1C\b1c\244\239\015\242\024\253\251\131<\134\255\154\026\143\224\191\166\198t\249\243O<@\254\252\019\141\248,\182GM\192\207\173YU\242\153\172I\129`\255\227\179\181\029\197\252\254\199g\180\021\197a_\228\179\154\134\"\217\"\228\251\015a\224\166\237\163\233g\182~\001LuAX\030r*\000\184\148\208\242z9\211\r\000\\_\156\233\022\002\253\129\185S\000\225=\024/\239\210%\163\238\181\196\183\159\183\244fb\138+\134\230\t\205@_\217\145>\251\253\211\004D\251\167\217z\248\243\209|~6cN\246\179g\"\146!%\199\251\002\128)\017\026\206K\157\223\001G\004\158\241\146S\001\192\132\2514O\137\251\190\000`\214\132\134\179\20643k\249\201\128\007\158\241\146S\001\192\172\251\236\205\022\021\2471\138\2437\164\152\t\0313K\244\024\162\207\225\029N1\138\220\025R\201\162 \247\017\006\236)!d\206\005y\196\142\001\246\028\\{\1380`I\t\001CR\205\221\135 \178\164\148\152'\161[\166\004<F\224st\249)\004\1451\165\148\156\229\172p_\000\192\017\161!7\154^\029pD\224\025/9\021\000\204\156\208r\214\148\162\238K\004\230\205p8q\147\245=r,\144\231\226\170S\137\192\236\025.\167O\249\244\190D`\250\012\135\2117\005\137G\142\005\242\\\\u*\017\152~\249'\146\137r\151\215\165\252Y\022V\012\200*\148\129`\243\251\206\189\250J0\191\249}g^}%\b\188\"\234N\151\148\252\221\239z\223\r\146\253o\155\195a#{}w\233?\150\208]\187H\170\024\223\248\250\234\206fmZ\022\221\183\220\203G^L\241w\226]\190\187\173M\006\205\206&C\188\177\201\223e\255\146\001Y\1561@\187\151\252\149\152\166\239y\026k\252\238gK\160\1592\129\193\188\137RL\158p\207\001\129\192\006\161\192\011\161\142!\194<W\240\211\170\b\245\028F?\172\138H\001\183=?\171\138\168\158\243\240GU\017\r\164\016\252\164*\1628\137\228?w\193\031\029\239\254O\\t\208\198\132\138\r\150k\155\176\136\216\004\217w\131\241~S\196\209M\017\154\190\014\212#\191\154f\012\003\210\131\017\160\140\025_m\199\197`\182\211\194\160\015$_\181\177\162\b\004\146\175]\155C>\227\012w\225\132v\193\132v\248\236]x\130\231\171\249\251\135\130\248\019<_\245\239\0312\160a\187\b\216Q\168\254\n\191\157\227\251D\191\157\011i\160\151\222\223\206\133\003J\225\244\253v.\164\131\028\195\223\206\133D\212,\252\158-\132\207\ba\247W\140\238\2063\186;\195H\143m\132\191g\011\137`1\209\239\217\"\218)6\0174\169\158_A\017y\2195.\242\221\183\218\235!\000~\139\197p\158\176\002]\220\152\240g\157WQOE\149\212\131\1321\190\003\174)\031\1945\229C\223\154\242A\022\132|C\\\238=\132\203\189\135\190\229\222\131\021\131\189m\168\140\1353\202x8\175\140\007\233-\241#\228/\137\251\017x\219\226/\137\019ag\186:;SS\238\186[\014\249\179w\156\157\187\017a\162$\190\027\182\006v\1705w\t\222\188\212\026\017|\242\226\199\132+\224\029\172u\203;\224S{\214\186D\181\025\146\031\028\172Own-\138\215\226#\195\181(\209$\253\242\211p\185\181\211\213\149\187\004\031R\174\174\136\224b\146y\144\195\205\243\028~\234\185\015>\221\019\203IhQ\193\143/\022g;\179\020\243W\225\195\130\165\024Qr82O\145\248T9\224\132\151\224#\138\191+\198\004\241K~\130\244|+\007\156\240\018|B\233\168\153\240\221\\\250\029\175\250\030]\144[\204q\183\210\018=\133\199o\155\187\238Wg\139\b\166\167\1354\127\192\216\211\130\195\172~\128r\017\146\253\017WO\131S\173\158\b\135v=\209\029Q\246$\127\014\182\163E\130\233\149J\175H\206\203\227\1560z%\209/\134~\025\244\t\224<\247\250\137\127u`\012\233VV\224\022\188\233\254\248{@\217\138\193Z\208\155\183\165\248&II\247\165\146\1618[/f\189\143\230\198?\238\015(T2G\020;\193\146~\144\173W\011\250\237ZK\225\007\005\020\218\167\bin\018%\253\251\250\166\137\196\160\239M\177\160\151yA\255!|\238y\191~\194\223\239\229\130\189\246\189\004\136n\188\151\173\238\138o\194\187e\196\200\222\157%\227G\233\238\198\194\001\240\208pw\195\209\240\241\254\140\018\207\193\189\215\139\231\160{\021\011\007\192\028\194\189\nG\1959\248\151G\201\028\202\215\169\200L\012\201\206\199\1948+K\139\231\022\188\158\164\n\030\b\243\204\214\246\018\191{\155'\144\2517\014t\157\027G1\221\015\135s\183\198\129\210\167q(\028\136 \148z3\014\227\174\140\005?\138t\232;\175\165=\024H3\147\174\196w\242\247k9 \148\191\175\006\023K\247\157\164\230A\021\003\225?\218\214\025U\030?\164a\166\000\137Y\001\183\195,\168\217a\022\140w\152\005\144\157dA\224\207\136\255\224V\151~'Q\n@\214;\227\239\186r\249\161\173\011\001X\198\n\148\127v\225\135\235L(f\218\017\002\250\191\197\240\1954\030\004\129\191\197\240\163m1T,\235\157o(\255\240\205\004E\139\r\251\031\2106P \220\176\255\161\r\002E(\213)\192Re\128\253\144\196z4-\253#\182\244\143\216\210?\134-\253c\208\210?bK\255X\180\244\143EK\255\b-\253#\182\244\143`\020G\211\2139b+\231\024\246o\142A\211\230\136\157\154cO{\230X\244d\142\216\1369b\247\229\136\"\1276\150\252\140\150\252\140\150\252\028Z\242s`\201\207\145%?\163%?\023\150\252\\X\242\t\196|B\022N.\219z\016\135\226\177\189\0027\023\188z\184}\211\236\031\222\1737\251\003\127\249e\253\184n?\255\186{x\252W\243\184\223\220\028\254?\208=S\236"

let times_bold_afm () = "x\001\189}Kw\219H\210\229\222\191\002\203\153sF=$\b\190\190^\185^\238\178\170mK%\145\230\183\163%H\230\232\001\023)\200\197\254\245\147@\198+o\006\232Y\205\233n7y#\001f\222\136\188\145/@\127\190l\247/\1915\207/\255\174_\246\187\155CQ\253c\252\230\231\230\233\169~~)~n\190\029\247\187\251\175/\197\255\184\249\159\197x\185\152\254\175\238\223y\255\239\178\251w9\234\255\157\244\255\206\139\183\183\205\151\186\248\243xx\169\159\014\197\239\2077\205\254[\179\223\190\212\183\255(\138\183\143\143\197ew\183CqY\031\234\253k@\245\167\246\245\246e\215<\023\191\132\210\255U\\}m\139\127o\143E1.\198\229\127M\195\127g\253/H\249\235\231\221_m\253\251/E5\025\205\166\002\175\254\221\030\182\247uQ\141g\147Y1-g\179\241\155\174u\031\182Ouq\181{\170\015g?5\143\183o~k\031\031\021+\"\182}\218=\030\021}\179\174\251\182\247\198\223_\182\143\187\155\183\207\247\143u1z\243\251\225\183\221\223\245\237\167\221\203\205\215\226n\251x\168\223\252\252u\187\223\222\188\212\251?\235\151\226\215\191_\234\231\219\250\246\178y\218>\247\021\248\233\167\230\239\226l<[\020g\229xQ\140G\163Q\177\156L\1397\215\161\220\254q\247\\\127j\014\187\158\129\179`T\248\234\235\238\230\225\185>\028\138\233\232\205\170\222\031\186\"\163Q\249\143p\1357\031\154\151\221M\253\255\193O\145\166\221\161\216\022/\251\237m\253\180\221?\020\205]\241\199\238\185y9~\171\207\254U\135\171\222\190+\182\207\183\255\187\217\023\187p\241\161\253r\216\221\238\182\251]}\248\199\155_\195\143\220\238\158\239\255\188\249Z\007\134\251\026\252\249\018\138o\247\183l{\243\243\246\219\191\"\233\179\249\236\205g\250\\\005'\190=\220t\140\238\139\217b\242\230\151\154\191\0052\231o\254|\185\253\215\186\168\170\238\195j]\140'\203\240)\132u\231\018\014\235\2018\004I1)\139\127\022\235\207E9\029\133\015\031\138\195\183m\160\239\159\197O\197\136\254\243\207\174\212$\150\154\244\031>\020\245\2237\143\219\167\190\216b\028\2203\t\215\143\139\217r\028KW\177\244t:\237K\255\2136\129\199/\143\177\252\164\168FUQ\205K-?\165\242\163X\135\231\246\233K\231\214\251\231\254\138*T\162Z\206\138\249\136*3K\139\2236\143\143\219}_\180\\\022g\203e\127\243\249\148J\207c\233>\190\186\226\223\234\253M\2151\186\242\227\178\n\181\175\138\197|\030jS\198\011\022\241\130\005\181u\251\020\1748\004\183\244W\204\202.f\139\249b\174\213_\166\228\244\205\141\193\215]1_\134\006\206\138r6\145+\170Qz\197\183\237\190~~\172\239\226\005\213,v\139\208\141\195\021U\188b\236\\\161\191Q\206\227%e_-\186\164Li\218\030\186Z\029\030\250\011\186\n\005\239T\1496\163\"\031O\231\196\211c{\232\203\134\159\028\021\211\192\2274T\168/Y\1651s\019\164f\027\139\006\254\199\139QQ\150\147b\220y\191+=M\171\254\245\248\237kM\158\173\138\241|\220\215\186\251__z\150\222;p\191k\"\245\021E\218x\020\238M5!\231\150\243E\140\222\199\237\225k_\248\172\247l\160~\164qV-RF\254S\239\155H_\213\223\185\154\007\194\023\139Xv\153\150m\158c\175\152M\187h\012\220r\193\233(-\248\242=\222s<\239\n\134zI\1931\020\252\186\175\227=\199\179>\b\171\153)\012\206\187k\218\024\225\161I\221m\167Zr\002%w\175\241\174e\136\212E(:\234\148#\022\173\210\162\135\221\223\177\228\130\154o\238\n]\242P\191\146\207\168]s\189+t\199Z\163\146\239k\216\154CW\223\017\175\229\140\202N\180\236\"\r\156\155\230\177\137uX\148\1629\221\205\251\194\208\t\015\245\211\014.\232\226r6\147+f\1634\222\031\187\140\210\007\241\184#n\026by:\142]i6N\139\214\127\181\219G\238\027\227\209\188\239\029\147 <}\2252-|\223\229\241z?tkp_H\225\135>\231\245\189t\030I\169:\199\208\221\201\135\203\t\245j\018\178\209\162\015\247E\169\225>#\031\206\203\178/\250\182/\217\197Ow\179\2172\234\227\140\2207\155\205\251R?qH\134b\225\134\236\229\217<\189\217\207\177K.\251_\157\0255\156-\210\130\191\196\251u\"\222\253\164\220o\153\254\236\175\230gCG\231bsr\210l<\238\139\253\166\197\166!\147H1r\208\156t\224]d{\222\215n\030\130\153k7/\211\130\255\138\1937\014\247\155O\181\181s\206w\029\235\161\216\239\177X\151\014'\166C\205\161C\189\143?\027rP\023f\230v\211\244W\207c\185\238v\243\153)\006\174\248C{\252,d%)F\174X\246:\252\161\248\1832\188,\ru\224\136\015\1705\139\192\171)\184Lk\2471\214n\026\201\1714m-\192\025\159\140\207F\202\202\002\156q\161\247\011%\146\027\150i\021/Y\n\002/\227\169\222\144\251H/5\031\138?m\005\167\227\137\164\238E\149\018x\197\157\174#p\166\247\131\142q\173\204,\019f\022\179\180\224j\136\194\005\0142\214\236\186\179\208\142\229\194\148\004\175|6\028.5\020\022\203\180\216&\022\155B\177\229(m\240\127\179\238v\r\174\180\024\140\030\190\132q\249C\253\"#\142Y\215Q\170.Yv\021\141\234\187\228\129!y\241K\184\196\166\215)\165W\245\230r\226\254\138\142R&e\252\153N\133\229g\184\011-bLm\0157\187\221\205n\127\211\198\225e\232\137\147\016n\211\145i4\228\166\182\027\247\030\194\128\157\199\173g\227P\187\206z6\143C\144\229\172\200Gh\210\250\208\161\251\001ZH\143\210\020HSqt\211\1839\228\233\197\162\207S}\193E\026\154_\n\202\145]\193\169\233\141KrhE\157\246&\185\227d$w\028\143F\233-om\201\169\241\234x4N\239Y'\247,g\230\158eJ\192\157J\198\164\207\005\221\157\254(va\244\208\127x,\238\030\233J\200O\247\028age\024\rV\139\137\249\145*\173\248W\163\213I\181\167id\237\180\\i\164z<\002\175\253\159\024y]R,C\181\236\128\186\203\193\201o\199Qn\232<\225\183\171\137\249\237E\250\219\143\240\219R\142\220\197\147\128'-\183\232\200\2296\143\193Y\207\154O\186,\175\229`\240\215$\174\154\027W\141\203\244\142\223DI\202@\220\180\180?\014\186\248W\236e\021\021\157\216\187Vi\168\200t)\004\222\196\222r\154&\190\131\173\231d66%\193;4\228\235{_\000\1950d2\162\146\224\155\1820\131\222n\228T\205\200\139c\024\160\1912\155\177\219MMI\208\199\239\177\228\164/9\031\153{\1500>\143C\222q\023\025\213\1622\229\192CG\169eGf\021r\159\022-S2\255\163N\175J[\142\005qY\137 \170\236t\227\243q\016\168I\213i\250\130.\225\169U9\"\213\141\158\154\205h\149$\136\212|QR\225\169s\127\149\219iE?\208O\181\249\007x\180^\142To_v\143\1835G\1968x\184\n\253\170wlw\201\012\178G\156\252\2236\223ul\221\247\1990g\153\142\168\2333\152\191\200\140{\218\187(\144\020F\247S\026\232\143q\016\220\205T\195J\207}\226\254n\202\177\168\232\002\162iLy\239\174[h\226Qs\\S\234\162\176\\\202db<\131\172q\164\249\204\217\172\234EB'4\227\025\204h\238\030\155\253\238Y\146K7o^v\249\159\139C\1788\21270\130/C\168\024\177\154A\152\223\180\2510\155\1919Rf\157u\243\141i\255\127\236\129e\170Z}\254:\236\250\165\183>\131M\2515\149r\164\025l<\135\184\231E\024\137\191P\171.\237U\139\153\185\b:\193}\187\011\023<5:T\b1M\186R\141\167t\017$\151\238\162\190rrQ\152\167\133\139&]?\146\139&\003\023\237\237\2441\\U\134\248\210\171 \197\220\2374\145uz\167\r\153B\193\199\161\130\224\188\176\136\198c\156\176\204\176\024\247\134r\206\165\193s\183\219\251{\154\218U\189\167C\156N\141\167\231K\175</\133US\n\142\169\169\016\015\178\211\005\144\174\255\212\251Z\022B\202\176\150\209-\132T\2279]\198\029\174\162\203\194\218\235\253~\251\237\171\132m\240\243\212L\232\198<\170\158\208\015}\t\011\1925\133\198\180[&\237V\b\251\021\140X\188*\2421T\239\177/\219\003\133!\175\254\204t\245g\188\152\250q(W\141\171xU\183\252\161W\205\252\1714:\186|\212\133o\183h\"\220\205\007\1947Y)\235\227w\174A\197Cr\025\188\135\133\219\221\183\195\238P\152\181\134e \154W\157\198<:\183k\138/_\155VV\t\187!\2022\140\249\166\170\018\203q\225N\244EGC\211\131\142\142{\169\016\029\1971up)-\239\004\249\012\029\164\012\235es\150\137%\184h{\211\190P\225Y_z\018\210\139\150\134u\1858\232\190{\172\255&\029\138\151L\1866\144\236\2268Z\243F\183&\218i\232\164\234\"\140\139\207\211\226O\219\155=\233b\232WA\144'aj6\155P\004/a\185\231\203\190\166\166\142\167\177*c\227\234%\172\247\2206/\219\027]\215\r\249\168\235\230\229T/)G\176\234z\187\011=\138\221\2205\183[\196\t\205\237'S\253\005 l{NIa\233h\026\002\169\012\"6\175FT\024<uS\223\134\224\139\019\007\222\227(\151U\193\197qU\180}\190\223\238\219\167\199m\251B\140N\250VW!\203\179\207J\028\0187\247a]2\142u\151]\031_v\179\165e\183\158\025\139\131\003n\182\204\191\227\221r\148\245\131'\208\194\222\194bX\242\240C\202\191\141\1398\253B\196T\167>e\201\213\224\193\239\254\246.,\207\201\218\223YH\015!V\250\217'\165\235\146\247%d-D\231\158\217\130H\201\219\019\178\130\161\133\187U\130\016\143\221\170\195\156\"\173\228\253\t\169\248\199X\241nDF\179u\026h\148\019q\147T\253)\012\153\218G\174{\240j_\247\177\174q\150\188X\207\131\211m,:\137\163\211\217R\231Le\005s\161\219.\213\030\0140%\226\017e\167\250\233\244\197\206\200\187!m?\031gZ\1785l-\221\141\232\195\012\191\155yL\171\184\178X\242J6W\187\209u\228\190\218:\157(e-\155\210kHja[/\232\243\129=\212\141\191\166c]\022<\227A$\175\168%\189OV\214\186\141\024[\\\166\182\170ef~\203\253\226\012\180u\171\218a\230\236X\021\153\143d}\143\231&a\244\134?!\021\210\190d+D}\233\012\"`\147\180V\150q\176\181\188d|\187{\221\221j\208\004\149\236\183_&s\255\230\202\141\220yYN\220\178oA\229y5x9\174|&s\222\003\147H\138,\164\193\221\205\146\218\208\015\028M\229\205\\\011\127A\230\163\253^\147Q\250\174V\157\180\218\185i\238\171\180Z\255\015\014\187\022\173\183m\152L\253\194\169w\245\130\204\191\204\170\209\237\184\144\214\165\252*k\128\252@J\018W\007|,\241l\238\030\139O\226b\196,\141\127Yz\199\234\199%x\172\188,\232\135$N\187\0143X\212\231\162\201\198\160qV7F\238\243`P\1693\218\159\149\219Ws\186\134w\238i-\184on9\206\186\175T\223\014+\164\242\149\175#7y\183\r\202\142Q ~\146(\176\193_\141\\^>`k\227:q\186P,\012\177\128'\158\rj\031rI\230W\174\141\014\254N\244EY\251\198\234t{O\029\249v%\028\219\240\179V\199l\237\012V\200\172\027\024\153\157W\003a\150\014\209\216U\203\209x\160\171\163\171&a^\129\174\210\210f\188uJ\020d\213\017\153\0157\202\196\158\022V\030\155\255\212\207\247TxD+G\243\202W\131KSo\222\201@\245\147}\170\204I\212C\236\158U\214\191=\149\141+i\131\129<\160\128}t\250\n\248\214t+\206\018C\189jo\154\204K\138x_\237\129\142\163\236\0028\198\205\127\167q#\155\027\0247\188+u\245\181\217[5\024\229\250$\227D\211F\179\223\133\205\020\207\154d(\158\029\016\225?\181\172\217\168\194\210\179y\188\243m\022\235\179~\020Z\250\233 U<\2016Pm\137\1514\151Q\164\128\138M\236\169\132C\219\175:\208\158uh\236\162\023&\030\224f4\1700\025\022\007\135 ZZF\031CEu\028'E\193\235<dzj\031_v\223\030\227\026Z\024&w\243\209p\151j9\2429\129\140J\164\012j\169\184G6\019\177K\179V\132\133\151\151\221\246\241vwG\155,\189\236\246\2309\164<\025\003e\227\007\030\006\241T4\2035P\253\133; \016\169\195\169\253d\222O\021\242\196'Z\157K\012\137\245\20881\029\206\155l0\027\024\208\187\023t\139\158\003\023\220\228#\209I>N\148}\024S\1547c\134\202\182\216\157b0\204\006\134\219\0314\024,\247c?/\253n*\194\147\156L3\204\137\1710-\030:v%n\229\189\129}\243P?\219\029\130q5\137;\004\163\185;\182\218\215\247\187\131\174#\158\024\\I\130\210\030hNS\012\165\236\223A\170\165\193(\213\188R\222\134\236'k\229\253B`w\174CW\205\178\184T\237\208\144,\253Q\255\2220/Ii`\194\216\152\0160\155r\024\002\146\146\204\173%\029\149\003\233\203H\187\148\197^TE\254\232\168\144\030/\234\211\204\180\156\012f\233__\226|~h$.\003;\155u\187\161]?\018\\\228\243s\025\152z\163\217~\236n\182I\133\242q\236I/\166\173q#\176[\189Z\140\167\190\0048\179 \187k\157\165=g^\227\141\173%{\168\151~\152h\0185\146\225\206\208bD>\016w\022#dw\016\164\168\219\"\196\178\162\212N\019\203y5\216=?f\163\012/\243J\148\231\018:?\177\136\226\244\137N\208\161O\200\000<\187y7\250\030lh\186\248*\t)Kx\220PHH\182\181\227\129)|\162\021C\147\230\217\152f\181\245\227\203V\187\210h\145\141v8]\188\232\248\210l\202c\016N\2448h2\154\234\214O\167\177\169C\163\169\132\026;,\157\251\227\187\167\150\243E\127&\163\223\247\159\249\189z\167\156\156\149sZ]\028\020\197l]\140\015\161\148\203\193\161\210\175N\004\207\170\156\0319\221\162\171\t\206\017\023\225fjF\167A\029\247A%i\2280\233uf>\153\012:\236O\171}\019\154q\216cc\2263\158\238%\025\190\219d+\243\1778\031\229\203fp#\154\193\153\131}H\210\031f\248\198\139\217\024\152\1788\173O\023\244\237\173\250\005\248\1659\128\155\015\173\210,l\198VC\139\177F\208\134\006)R\214\202\130,\219V~\162\252\1950\2177t\23409\149\019\214_\183\143q\208|6\143^5'\1461Wv\203\228&Q.\251D9\027\156\0017\0033\224\185s\t\143!\205\242\006\143!qqC\196\198_C\030\208\028\238+\176\004qj4S;j\\\230#\020\217\2494+\224\230\172V\150G\148{\234UrIG\127u\170Sma\230\220\207o\199\213@i\236%'\186\161\ba\198\233\137\028W\241\014{H\206t\172>\172\222Wa\011o\226\181\130\163\"\207\228NF\212A\148\180\217\174\142\r\180\185\133\252\227O19\156C'\223\221P0\135A\240Y\213\237\214\151\197b:\026X\132\213\142\197G\171\179\025\169\172\206\224\154\249\146W]\134\151\156?h\240\155Y\206b1\208\187\242\149\192n\248<\208Y.\179\n\209\216\210\030\250\205\165\004\007\164<\1385;\129\217\184N\235%\131\186\197\192z\151\221K\165\188\181\212c\242YqYT\145\177%\238\014p\024k\029l2_\248\206\250\015\1367\143\024\007W\191!Wy\147t\145n;\224\230\237\226\249h07?d~*\169\215\154#\149\217B\140\157\192\150\163e\031\245\221\234\145[#Te\201>\003\157\234\217\2040d^\143K\194|:!\171>\165f{:\017\171\255\216\220w\253\240\185y\2256tgF\237\243\029Y\236\187+\025\243|%C\132!\223.\162\021\007\188\128\180!TF3]\232\"g\001\239\206\249\244u\246\196?k\184I\001\139\210oF\253\2425k\000\196\156\196(8\161\159\209\012%\209\172.\180\ra\143\199\226\1609Di2h\238\014\186\132\161@9\207\149\\F\182&?\158-\250av9\152\029\127m\233\193/}\198\241\215\231[\243pd|Z\242\188\222?\255\178}\217\234\183O\219]\024w\150eU\1909\255\244\185x[\132{O\167\2529\166s\003D\158,@#Q\133\222\217\2071i\027\192\146\167\240\199\016\001\242\153~T\001\211\165\012*1g\176\152\160\012\144$\\\131\019\183\006\137'\t\012\016EN\129\011\243\249\1708[\202g\226\196\000\182\141\002_w\027\132\252\153\137\021\192\182QQm\163b\212F\005\2106*\206mT\132\212\210 \189\230\235\247U\215S\184\194\235\240e\194\150M\209?\178L_\168\250\006\209\154*\248\173{\168\130>\155GH\207\230\021\129\173\249\233\022)i]JZ\135\146\022)i\007(i3J\218\140\146\022(y\181-\250\030\252\201\159\143\166!\180\231o\000\173&c\177\136\233^\004@\031#\020:\026\163\216\219\"\254.\003\160\223\017\234v\190h3=\144\000\232\134\132z}\145Ly\135$\003\244JB\253\174IF\236\159\004C'%\020zjD/\0160}\150\000\232\184\140z\1897\218L\023&\000\130\150P/r\201\148\135/\025 \134\t\245\003\153\140\024\205\004cH\019\156\198u\004m\127\143\136\237\244\017\177=\159\016\236\254\004;\026\016-F\b\"\224\169A\180\180X\197\214\165\184\029\166\184\029\162\184u)nOQ\220\250\020\183>\197\173G\241k\198\134\017\145\b\028\145\004\148\019BsM\137\221\220h\n\001\160)\132\130\1660\138\154\018\241w\025\000\154B\168\171)\209f4\133\000\208\020B=M!S\174)d\000M!\212\215\0202\162\166\016\012\154B(hJD/\0160\154B\000h\n\163\158\166D\155\209\020\002 \224\t\245\002\158Ly\192\147\001\002\158P?\224\201\136\001O0\006<\193i\192G\208jJD\172\166D\196j\n!\168)\004;\154\018-FS\"\224iJ\180\180X\197\214\165\184\029\166\184\029\162\184u)nOQ\220\250\020\183>\197\173G\241k\198\134\209\148\b\028\145\004\212\020BsM1,\024a\177(\168\1395\129\196$&\212\025c|\231\163\1608\214\228\202\142)`\180\199\162 @\214\228\169\144\181\231Rd\173\160G\214\228\139\146-\129\202dm O\214\004\026eL\023.j\212\202\162 Y\137\201\211-S\192\136\151E\161{Y\147\215\199\172=\239h\214\n\189\205\154\252.gK`\191\1796\236|\214\150\246@c\177Jg`+w\006\182\154ga\020>ks\212\207\152\141\004\026\212\211Acn\221\166\180\195.k\127\224\178\246\164\203\218a\151\181?tY{\194e\237\t\151\181\131.{\245\1534\242i\208\163K \n\1695\229j*\136\209R\197@I\213\000:j\012\168\162bz\231a\160\160jp\245S\204F=\021\003\237T\131\167\156j\205uSm\160\154j\2405S\237\168\152j\001\189T\003\168\165\024.\028\204(\165b\160\147\198\224\169\164\152\141F*\006\221M\r^gSk\222\213\212\006\029M\r~7S;v2\181`\023SK\218\193\004\183\138(\160\213C\001\173\026*\136Z\168\022G\t\0052:(\152\167\130bl\157\170\183C.iO\186\164=\225\146v\200%\237\015\\\210\014\186\164\029tI;\224\146W\1431\163w\130\029\029\162P\235\212\144+]l\172\1459\002@\227\b\005\129c\020\213-\226\2392\000t\141PW\212\162\205(\026\001 g\132zZF\166\\\200\200\000*F\168/adD\253\"\024\196\139PP\174\136^ `4\139\000\016,F=\181\1386#U\004@\167 \212\235\017d\202\187\003\025\160/\016\234w\0042b/ \024\187\000\193i\252G\208\234QD\172\024E\196*\017!(C\004;\026\020-F\128\"\224\169O\180\180X\197\214\165\184\029\166\184\029\162\184u)nOQ\220\250\020\183>\197\173G\241k\198\134\017\151\b\028\145\004\148\021BsM\161\234\025Qa\004T\133a\144\021\129QW\200\240.G@Y\024v\165\133\140F[\024\001qa\216S\023\182\229\242\194\022\208\023\134}\129a+*\012\227 1\012\131\198\016|\145!Fe\024\001\153\017\216\211\0252\026\161a\004\186\001\195^?`[\222\017\216\002=\129a\191+\176\021\251\002\227\216\025\024O{\003\161Vq\b\178\146C\144\213\028\134Pt\024wT\135LFv\b\241t\135LmV\213\214\167\188=Ay;Hy\235S\222\158\164\188\029\160\188\029\160\188u)\127\205\1531\018D\2001#\004E\136\225\\\133\1686F\133\024\001\021b\024TH`T!2\188\203\017P!\134]\021\"\163Q!F@\133\024\246T\136m\185\n\177\005T\136a_\133\216\138*\1968\168\016\195\160B\004_d\136Q!F@\133\004\246T\136\140F\133\024\129.\193\176\215%\216\150w\t\182@\151`\216\239\018l\197.\1938v\t\198\211.A\168U!\130\172\n\017dU\136!T!\198\029\021\"\147Q!B<\021\"S\155U\181\245)oOP\222\014R\222\250\148\183')o\007(o\007(o]\202_sf\140\n\017\018Th\146\018\194*\132\1766\145-\253\175\026\r\138\223A\129\"\b\250C \170O\015\191\195\239\160<\017tu\1677\025\213\137\223As\"\232)N\180\228z\019qP\155\b\250Z\019m\1684\017\005\157\137 \168L\015^\192w\1630\241;\232\011\129\158\186\244&\163-\241;\132y\004\189 \143\150<\196#\014\001\030A?\188\163\r\131;\162\024\218\017M\003\187\255f\149\164\007\172\142\244\128U\145\b\160\134D\212Q\144\222`\244\163\255\238\169Goh\161j\173Gi;Hi;@i\235Q\218\158\160\180u)m]J[\135\210Wd\192\232D\255\253\b\r\199\145J\004\243qJ\140k#\017\004\128F\016\n\"\193(\170D\196\223e\000\232\004\161\174PD\155Q\n\002@*\b\245\180\130L\185X\144\001\212\130P_.\200\136zA0\b\006\161\160\024\241\235\005\002F3\b\000\209`\212S\141h3\178A\000\0049\161^\148\147)\015s2@\156\019\234\007:\0251\210\t\198P'8\141\245\bZ\253\136\136\021\144\136X\005!\004%\132`GC\162\197\136H\004<\021\137\150\022\171\216\186\020\183\195\020\183C\020\183.\197\237)\138[\159\226\214\167\184\245(~\205\2160\130\018\129#\146\128\146Bh\166)?\021o\195\bd\196\159y\176\"\000\169\128\002\1505E\205hF0\226J\001fB\017&A\145\216~\253N\029S\128\235\142\011\254,A\196\128\173\156\1626\168\024\163\202)\144\250Pq\174\180\"\\iEb\165\233\251/=\163S\254\204\140\n\192\140\n\1440*\168aT0fT\000aT\016aT\016bT\1903\163\012\132\014\\q\205\215\230\243\198~f%\023\192(5c\244wO\206J\002\1626\0262\b\000F\b\005Z\b\245\184!SN\016\025\128%B\145*\130\145/\130S\210\b\004\230\"j\232\139\192\026\129M\006\000\155\132\230\148FC\198k\255\248\169\2295\002\200kD\145\215\136\186\188F\147\195k4 \175\017\205x\141p\198k\132\129\215\b\"\175=jy\237\1295\002\155\012@^#\234\240\218\027\128\215\223:J\151\242\153\238\165\000\017\169\128\229PQ\2535\197\1369\005\1524E\152/E\"U\250\157X\018`+\025\2417~\231\157\001\168\182\n\216\218*\170\181U\140j\171\000\215V\017\174\173\"\177\182\250\157j+@\252\131Kg\203\146\190[[\141\181\1677\021Z\192\171}\237\212\222<Il@lR\1575\169\206\154\212\216\207X\195\198\173P\227T\168\193\223N\159Q7xV'z\249\165\001\144U\014\2251\229\158\247&\155\191\199l\254\030\179\249{7\155\191w\178\249{\204\230\239\179l\254>\203\230\239!\155\191\199l\254\190\139\225\241\148?s6\023\128j\171@\146\222\0055\233]0N\239\002H\026\023D\210\184 \148\198\229;\213V\128\2283\214\150c\214\000^mk\167\1826f\021\196&\212Y\019\234\172\t\141\253\1405l\220\n5N\133\026\252m\136Y\197\179:q\204*\128,\130\236\190\239\198\235bl\177\210\173[\233\214\169t\139\149n\007*\221f\149n3\"\219$\022\206\187\185-\005\237\185Lk\021pz\209\185\157\204*\150\246\162s\156\194*\014\189\235\\&\174\n\164\157\233\220H\2349J\2349J\234\185+\169\231\142\164\158{\146z\142\146z\158I\234y&\169\231FR\207QR\207]I=w$\245\028%\245|@R\2073I=GI=GI=7\209x\142\209x\238F\227\185\019\141\231\024\141\231\003\209x\158E\227y\022\141\231Y4\030ea\226\\&z\nd\139(\201\011?L$'0\004ub\243\226;)\144\135zb\134\168Ol~\007H\138`_H\140\208-\018\027\244\016k3.O`\136\202\196\006](\1819\193\155\020\200\22785\231},\177C\200'6\140\242\196\136\157\208\026\155\001\248\004\t\205\143\026\218\156nhs\162!\003\2218)r\170\173\216\185\019\027\244sk3]>\129\161\247'6O\b\146\002\185&$f\144\135\196\230+ER\004E#1\162~$\198TJ\172\233\232\011\006\nLb\203\180\230\143~\145\180\228\207\188>\170@\1784\202\240\202|^\155\207\027\251\153gd\002\152\169\022c\233\031\221\2241\198\031\201j!\015\150\255\232Z<\229j\031\211E\244?l\219\024\211\231L\203\004\128V\186\207\153&\182\021\002k\0046\025\000\205\207\030\201L\r\003D\228Og\n\027\242\168b\218Z\228%{T\145\r\182\185\134\162\004\006\162R\155G\151\005W>\188\246\225\205\000\0124&\182\156Lk\030\1604+\130\196B\031\243\248B\146\007\250\024\155\163\206\025\146\t\000z\025\245\136\141\182\021\002k\0046\025\000\004\018\154S\023\r\003\164\025#\210\021MGl-RDhFN\247Gc\249g\228\133\138\006\224\133\017\001\146\132&\168\201b\130q\234\018@\146\145 \146m\005\161\133\017\249\206y\136\128X\191\183\025\000\245&\020*O\168\215\0022\229\205 \003\180\133Pl\016\193\216*\130\211\166\017\b\237\147E`\000\160}\233\"0\160^\251\178E`0@\251`\017\024`l_\178\b\012 \182\207t\174\183\0030\182\213\218\176\197\214\230\182\219\022pZo\205\200\129\181eLXc\198\1355\002+\214\004\220\196\175o3\000\248 \020\152 \212\227\128Ly\235\201\000\237&\020[L0\182\149\224\180\149\004\166\237\251\2165\173\146\207\233\226\243Gi\144\002\201\198\183\160\217\242\244Gi\129\002\178\153-\b\215[\145Xe\253\206{\218\012\\\217\207\148*\012`\179\132\192+\217\139\252\216\229\006\249\252\217\148\217\024|\147n\181~\180\137\1291\145\188*\005\128\192T\242\000\245\168\204$\015\012@*H\030\192Ho\"y\000\002\2092J\004\000(\247F\137\169m\133\156\173\017\248\140\151l\176\004:$\0276\178\1930j\\cQ\240\1435\129\147\172\201\243\148\181\231\238\178V\240\1535\161\227\172\r\189gm\169\011\173\005\252\152>X\237\161\224\209\193\007\171\157\002+\151\249\181\139~v\239\176q\203\162\191\253\135\141\217*\136q\185b\224p5\128\187\213\2249[\173\185\171\213\006\142V\003\186Y-\232d\181\164.V\028\028l\159\006\2051p\238\192\211\160\153y\229\176\187v\176\207\206\181\027\167\028:\212{b\146m\145D\227K\002\192\145\132\130\023\t\245\\H\166\220\127d\000\231\017\138\158#\024\221Fp\2343\002\193a\242\028\028\000\224*\2399\184\212\182B\206\214\b|\198K6X\002\029\147=C\198\134d9\1998'\197\193G\169\017\\\149\026=\143\165%r\199\165v\240_jD7\166V\244fjM\157\154\218\192\183\137\241j\b\007O\131\209sxRd5\224\149\245\000\254y\224>\155\129\242\024\019\1691\015\r\226\214\004\005#\016\014\012C 0\236\133\000\219r\231\179\005\220\2060:\156qt5\227\169\147\025\005\247\234\211e\136\128K\221\167\203\192\184\202\024\\g\200\231\236\170MV\006\221\149?\145\197\150\184\218`\252D\000\184\137P\240\018\161\158\147\200\148\251\136\012\224\"B\209C\004\163\131\bN\253C \184GV\148\000\000\231x+J\169m\133\156\173\017\248\140\151l\176\004\186%[bb\131L0\171\020\000\175\164\019L@=\175d\019L0\128W`\130\t0z%\153`\002\b^\145S\199\000\128W\188S\199\169m\133\156\173\017\248\140\151l\176\004z%;\177K\134O\157C\232t\233'\241\133\002\228\006\005\172\007\020\205N\170~\018\222\021`\202\021a\182\021\137D\235w\226X\128\173\156\220\252\164gP\004\2243(\0028GL?%gP\004K\143\152~2gP\004\129\163\164\159\228\012\138|\231\211\019\012\164\231\168>\245\251\152l\171\211\133\149O\186c\169@\190\156\242)\217\155T\204lH\n\152\174\172|2[\143\130\192z\202\167~\147Q>c\r\027\183B\141S\161\006\127\027w\011\005\207\234$\251\130\002\164\0119\159\178sT\023\230\156\241\005\1583\190p\207\025_8\231\140/\240\156\241\197\1929\227\139\236\156\241Ev\206\248\002\206\025_\224I\154K\179\183\127\137\027\250\151\238.\254\165\179u\127\137\251\245\151\003\155\244\151\217\206\252%n\199_\226\030\252\165Q\179K\020\178K_\195.;g\200\245\215\216\174k\183]\215N\187\174\177]\215\003\237\186\206\218u\rg\219.\217\025\242}%;\016\151\157\186N\248\243\198~N\143\232^Z\245d,\0221\158$\000\154M\168\215v2\229\004\144\001X \212\167\130\140\200\007\193\224lB\193\227\184\028v\233.\135]\158X\014#\2195\222\243\218\229\228z\152\147\235!N\174]N\174Oqr\237s\146\005\n\193i\180\232\250^\226\2455\134\193&\003 \130\178\229<6DvM\024\017\000\148\017\234QF\166\15622\000e\132\250\148\145\017)#\024\194\136P\b\163\136\1540\"\000\194\136Q/\140\162\237\026\239y\237rr=\204\201\245\016'\215.'\215\1678\185\2469\201\194\136\2244\140\228\t\132i\226\2455\134\193&\003 \140\178'\016\196\224\158\028\187<qr\236\242G'\199.O\159\028\187<qr\236\242\199'\199.O\157\028\187<qr\236\242\196\201\177K8\219Py0\006\226\224\217\006\175\196\181\255[\215'\184\189\254\017\183\215\167\185\189>\193\237\245\143\185\189>\197m\030\190\214\bA\156\030\241\152:\145\183\246\003r3\000cp\251G<\200|e\030\251\184\194\199>\174\240\177\143\171\194{\236\227\202y\236\227\n\031\251\184\202\030\251\184\202\030\251\184\130\199>\174\240\177\143\171\174\023\142\023\252\153\007\166\002$\003SA\205\192T0\030\152\n\000\003S\193e`*\b\031\241\022\128')\012\232\004\229J\166T\n\240\131\197\002$\015b\nj&\150\130\241\227\151\002\200\195\149\130\b\163\130\016\163\242\157j+\151\2204\143f\014y\197S,\249n+_ck\234\244\204\205U:\197R\212i\141\157biAlb\1575\177\206\154\248\245\248\237km+\1773\206\216a\144\236db\193Hc.m\176\133\141\219\160&;\240s%S4\005\210\152R\\:\130 \020S\np\2203\192\147\029\233\b{\227\162}\186\202p\197\127\222\221\002V\130\005>\212O;\244\127k~\181E6Z\151\141\214a\163E6\218\0016\218\140\1416\243p\011A\252\221\212W\2239r\133o\027\185r\2223r%Gr\152\202\244H\014\160\160\127\206\145\0280\229J\152\030\201\001\0205\017\142\228\000\156\170cz$'E\141N\166C_@=\197\204\134\190`\000\237t\135\190`D\021M\135\190\128\130\158F\212\136*\001\016\155\132\130\188\018\234i,\153ri\"\003H\017\161\168G\004c\200\018\156\198-\129\160\192\017\133n\200`\162\197\017\204\218\\\187L\16043\234t`2\r1\225)5Y\\\142j\159\163\218\231\b\213;\162;\244\255\206\141\223L\204#\220\224\237\026\151\162f\152\012G\224\201\000\186F\168/ndD\133#\024D\159PP\254\244!\232\180\147\239140\017\016\n\217\128Q/%D\155\147\023\162\161\197\138\181.\177\2370\177\237\016\177\173Kl{\138\216\214'\182\245\003\173\245:\227wl\225\0173\005\230\020B\157\196\146\158\133\020W9g!]\027\166\154\161\179\144n\001'\2378g!][\150\130\188\179\144\174\017\210\145s\022\210\179\217\212\228L\164]\155\155\166\252\137\180k\198\1485<\145v\139d\233\203\153H\1876Le\198f\019\154\133\177CY\027&7ksS\156-\224\200\1875\163\148[[&\232\214\152\2456k\132>gM\152\006\141\r\181'1\165)\209>\236\229\255P}\130\209,I&6O\196l\129\211\140\186i\211\218O0^\159b\188>\197x\150N\141m\231G\226\238D\207\203\019\17216\254\2074'\bo~D\170\151x\173\025\179\132\181\r\228\n[$\203\024\214\136\t\217\2180-\027[\150\156\141m\239\135j\150\168\173\r\211ubs\147\182\001\189\212m\204\173\223\132\246\132\203\218\031\185\172=\237\178\246\132\203\218\031\187\172=\229\178\246TWh\135\197\231\187\207\206\209\207\230\217\016\192\218\178\129\192u\151\253g#\254L\215*@\"\174\128\229WQ\189\175b\196\164\002\204\141\"L\136\"\145\005\253N\145,\000)\234\148\191s83 \007\214g)\000\rK\015\172\003\23451;\176\014\006h,\028X\007\024\155\157\028X\007\016\b\136(\176\016A\164\"=%>sP \1979%\238\153<z\252S\226\158\021\136\242N\137{6\164,?%\238Y\128<c\002\006\141\005i\180\231\174g\025\006\020f\231\174s\131G\159w\238:\183\001u\249\185\235\220\130\180\225\185\235\028\007\202\196\000\132\t\142t\201\185\230Y\n\000Q\233\185f@=\138\178s\205`\000r\224\\3\192HKr\174\025@ $\162\192F\004\145\n<L<sq \198=L\236\027=\154\134\014\019\251v \205?L\236[\145B\2390\177o\003B\019#\240\154\216\144^=\144;\003\004(\133\003\185\b{4\230\007r\209\002\212\225\129\\\196\145\174\244@.\162@\017\193@\014\161H\011\253\146\161\133\017\160\133a\160\133a\143\022\182\229\180\176\005ha\024ia\028ia<\165\133Q\160\133`\160\133\223\132\014\180\244w4\164\196\239@I\004\129\144\bztDKNF\196\129\138\b\"\017\017E\026\"\154\146\0161\160\160\007\129\128\248\"\231\180\249\171\174\233c\218F]I\187\r\194\135'\021I\1501\0206\139\023\n\242\146\133\"\178\n\161\144\204\206\020\162Sr\n\240\026\132 \239d\247y%\2399V \153a\b\172o7^\225\139\141W\238;\141W\206\235\140W\248&\227\213\192K\140W\217\251\139W\248\234\226\021\190\181xeVTV\184\140\178\146\181\019\005\156i\205\202\174\146(\150N`V\186\030\162\b\204CV\176\242\177\146\229\014\001h\146f\190\247!7.\151\004t>\0271\255\242\1945Eh\154h\145\228\\\166\192\246`\166\130\230\165k\138\202yMA\244`\166@z2\147!^t\1609\213\170[i\152\204\2493\207\158\004H\142n\bj&R\130\241!\r\001\228\216\133 r\214\130\145\198\214\172\201xk|\150\026\143\165&\227\003_\005\167\134\156(y\025\156\"r\158\153\0179z+Ql&\240\018\027\173\253\140\145\221\186\129\220:\129\220b \251\211\239U6\231^e\019\237\021\204\174\215\189\026\210Q\220\181\170\161\"\172\134\138$\142P\2168BAv\132\"\194\183B\018\152\n\145\026*\192\030\016\228\163\028)^\235\026\180\000\206Q\231u\178\218,Xz\212y\157\173+\011\014G\157\215\186\130,@z\236}\221)\219l\202\1599\193\n\192\201U\128$\177\nj\146\170`\156P\005\144d*\136$RA(\137\202wN\160\012P\244N\245\187=\180\191.l\217\026[\195\178f\000\1755\181\211\026\171i\nb\019\235\172\137u\214D\2143\210\148\181Y9]\227r\233:[#]w\0184\231{\177\002)\144<\241!\168y\226C0~\226C\1284\166\020\151'A\004\161\152R\128\031\252`@V-\217-Fx\196u\2502\2495\190G~\237\190B~\237\188=~\141/\142_\015\1883~\157\189.~\157\189)~\r/\137_w\139v3\249\156\142>\215vy\142\176M\175Tc\249\194\222T\132\149J\145D\005\02062\160 \235\128\"\210\225\021\146\136Q\136\148J\001\022\001A>\202\169\189\141\030;\021\192y\167\245&9`*X\250&\235Mv\148Tpx\185\245F\015\141\n\144\190\188z\211)\213B>S\029\021 f\021\176\149VT+\173\024UZ\001\174\156\"L\170\"\145S\253N\181\021 \205\179\027P\170M?\004\027\143\249\139D\138 <\0043H\018)\002\155\206\173\152\025\129iI\238\242\002H\215\022D\131\135!\216\244\217\152\241\215\006\199_\155l\200\180\233\135Lr\179&kg\227\183\202\014\153\020\148\248\023\004\018\161\026\180c\b\196\169P\017\233\006\140\128pm\156\017\211\198\140\15268b\218\184#\166\1413b\218\224\136i30b\218d#\166M6b\218\192\136i#\235\234\210\195\211\133u\132Q\150\156\165u\1809\002\149.\174#\156I\021,\175#\014\162\149.\176\003l\228\011\030\234IQO\200\242\135zR\003H\154\255POjDq\131\135zR\020d.\162F\235\b\000\193#\020T\143PO\250\200\148\235\031\025@\004\tE%$\024\229\144\224T\019\t\004a\228-\145\164O%\251$)h\251'!(\"\004\163b2\236\t\012\217r\237d\131#\160d\002\021%\020\165\148\224LO#\142\162\026Q\163\172\004\128\188\018\138\026\027\225&\251\149\198'\1709\193\136\167\187dA\241%x@\129\201\154\2010\225\168\197\004\163 \167[e)[\1424GC\155\001 \210\132zJM\166\\\174\201\000\154M\168/\220dD\245&\024%\156\224T\199\237n\150H^\182\157\229XP\208\253\r-\199\236\200z\182\165\229X2q\2077\181\028\019H|\182\173\149[\140\208+\006Z\175\006O\238\213\154+\190\218@\244\213\224\235\190\218Q\250\213\002\234\175\006H\000b09@1H\003j\128L\160\006/\025\1685\207\007j\131\148\160\006\204\nj\193\196\160\15047(\014\233\193\236`&]\027w63\220\202\134\130\168\128j\193la,\158<\1709\207\025\198\230\164\r\181B\230P\003&\015\181d\249CL\152B\196`\178\136b\144H\212\128\185D,\141\247\163\205 \159\205i\214\188\188\162FL-j\025\200.Z K0j\194\028\163\022L3\217\246xF\170\147l\196\214z\024\164\0285xYG\173y\226Q\027\228\0305\248\233G\237\152\129\212\130IH-I\030\218v\127(\143\222\239N\nd\128\168<\0060M4\168\220\219`\177I\006\160\170\026D\255F0#\252\151@\249\187\252)?\002\190\132\255\240\250\230\023qi\197@+\175u\248\"nR\192yk\198\023\235\022\197\210\183f|A7(\014o\205\248\162\180+\146\188\020\245K\255w\tcc\162\220\193\187\158\171\204F\006Z\\\187\237\014\161\209\rno\250?\201\165@m\238^\1393\025\136\178h\129\196\153\140Zg\n&\226g@\2410\003\234aF\204_\129\142\200\157lX\241\247p\235\199\250p\216I\150\188\235d\174\228\207\141\253\204.\021\192\249\187\nw\206\031S\184\195\191\160p7\240g\019\238\178\191\149p\135\127 \225\014\255*\194\157\238\1980\144\250\148\150\028\239\172;\201\155\247x\237}\236q\136z\231F\201\214\191\245[?\179\138\011`\2129b\187\248\1671\227g\r\018\002 &\bMb\1300u?\001\198\253\132\216?\002\222#\015q{\146?\167\251&\015fsR\128|#\229!\221\154\020\204\238L2\152\238\174<\216}IF\224\1331\015\230\207A=\224\159\131zp\255\028\212\131\243\231\160\030\240\207A=\012\2529\168\135\236\207A=\224\159\131z\192?\007\245`\\\254\128.\127p\\\254\000\231\221\185\173\222yw\215\006~\025<\239\238\022\200\1895t\222\221\181\131\015\221\243\238\174\017=\011g\208=n\208\223\131g\208\221\002\167y\199\1288q\006\221-\130a\226\157Awm\016<pr\217\133O\208\144GW\223\229)\007?\139\1600 YG\000s3\003K\170'\1601\178\209\2449\142>\163d\017`J\184\026fQS\214Q6\197L9T;\002L\137\196\133\175\003\184)\159\201%#\166Lt\235+\002\166\132\249c\199\022\208\018\148.`\152A\249\199\026S\011\151\127\172\239\250#\147t\183\020N%#\181\165\239\128Km\142d\164\0052\201H\205\169$\1646\144\132\212\b\146\144\026\147\023\133\165\166tg\189\183y\196\012\1782H\201i>N\1451\200\1960\r\195\028\012\017p\186\245\250\233l6Q[\012$}\197\154\005\227\136\213\177\216\016\204o\182\247.\217\167#|kI_\225\151X\2369\181\220\174\199\136,\152N\177\173\133~\200\179\132\188\247\248\184\245m\201a\185\220\254m{S\203\177(cx\149*\239\139\155\130\015\014\132\207\233\217\130\000p\194V\128\171\163P\178\218\178/\236\2455\222\176\198\027\214\206\179\149\251$\215+f\018\188\128\233\163\149{\147\202\005\129\243\017\251B\131s\207\003e\003$\164\n\012g2\246\133f\208=g+\003p3\021H\238*p\154S\247\253x\130\171\217 y\141\203U\227p\213 -\141\251\152\233\222\140\006\004I\031(\221k\222g\224\155\161E&\017#F\2542%5\157P\0313\193F\000\180\145P\136\018F1\246\188=\161\189\238\t%\165j\247\151j\247\151\220\160\204\246\131\208\144\135g\186\029\004(2\143\219A\t|\143Lb\220\018\234\006o\186\161\196\017\028Q\019\164\004@,\019\n\001\205\168\023\213d\131\208\214\029\168\164a\141\235\150f\216\001\205\144\003\026\151\230\129\192\199\189\167\020\134.\000;O\t\250\ri\206zD\132\255\194\011M\223\160\183mh\t\002\128\026B!b\025\197\190\145\188\194\131\251\134\188\194#-U\187\191T\187\191\228\246\141\236\021\030h\200\251F\250\n\015@\209/\240\n\143\020\190G&\177o\016\234\246\141\244- \2207\"j\226\157\000\232\027\132B\223`\212\235\027d\131\190!\175\rI\027\214\184ni\134\029\208\0129\160qi\030\232\027\240\218\016\128\161o\164\175\rI\209oHs\2147\"\252\023^h\251\134}\248\222\148\1790\210dm\024\195\137-\2353\249\147\254\210s`\229\195\185\162>Q\143\250D=\252\0305\176\242\225\154\157\222\229\173|x\182\204\203\238\202\135c\188\247}\148\245=k\243{\160\243\250\000\233\135\198f{\152\133\177OZ\027\246\204\196\230\246O[\002{)\172\2518\1644'B\160\249\145\155\155\211nnN\184q\168'\187\235>\158\017{\181\183\238\227\216\190\249n\204\251\1851\254\229\223J\251|\156\182\188\149%\004\250N\212\166 \191\146$\001\147\131\193\137\197\028\014Np> \156\128r\0248A\229@p\130\210\161\224\004\2277\140X\240J\030j\162\239<\241KA\231!\168hZ\201\206N\252\190\006\251\006~o\227\177\182\201hx5/\226\127\197\023\241\191\226\139\248_\221\023\241\191:/\226\127\197\023\241\191f/\226\127\205^\196\255\n/\226\127\197\023\241\191\202\003r\\{k\171\177\246\176\234\252\234.5\191:\235\203\175\222\162\242+\174$\191f\203\199\175\217\154\241k|,\136?c\r\027\183B\141S\161\006\127\187q\159\243x\181\015\0041\146>\231\241j\030\007\"\128\187\237<\002\223\129\230\239\166\017\223\177\017\223\221F|w\026\241\029\027\241}\160\017\223\179F|\199F|\199F|\199F\028\161\017G\019+G\140\149#\198\202\209\141\149\163\019+G/V\142\024+\199,V\142Y\172\028\205^\229\017\247*\143\238^\229\209\217\171<\226^\229q`\175\242\152\237U\030q\175\242\136{\149\199\140\230d*\206\\\235T<)\133\172\195T\028P\135\255|*\014\134\220\0190\021OQ\244\tN\197\019\216x'\157\194\002\234\249)\155\194\130\001<\230Na\193\136\190K\167\176\128\130\023\211\025+\187\018\207Q\1777\147sTX\022}\154\159\162\202\r\142g\1893T\142-\247ov\132*7\160\151\157#Th1\190\206\0148\229\006\207\227\222\241\166\220\006~\031:\220\148\219\209\251\217\209\166\220\0001\144\029l\na\240\235\243\237y\189\127\254\180\221\237\015\252\229\151\237\203\182\251\252[\243\252\242\239\250e\191\1879\252_PW\249A"

let times_italic_afm () = "x\001\189}[w\219F\214\229\187\127\005\030g\214\026\247\144\224\189\251\201\029'\221\177\1478v$\209\252\222(\t\1509\186\192!E)\234_?\005\212\185\238:\160\191\167oe-\007\220\187\000\2129ujW\213A\001\250\227q\187\127\252\169}x\252\181y\220\239\174\014\213\244o\227W?\180\247\247\205\195c\245C\251\237e\191\187\249\250X\253\175\171\255]\141W\203\217\255\233\254]\244\255\174\186\127W\163\254\223I\255\239\162zs\221^6\213\031/\135\199\230\254P\253\252p\213\238\191\181\251\237cs\253\183\170zswW}\234\174v\168>5\135f\255\148P\189\213\190\217>\238\218\135\234m*\253\247\234\236\235\177\250u\251RU\227j\\\255}6\255\251l\214\223A\202\159?\236\254<6?\191\173\166\147\209\\\225\139_\143\135\237MSM\023\139zQ\205\150\139Y\253\170\179\238\183\237}S\157\237\238\155\195\235\159\031\183w\187\171W?\029\239\238\020\173\024\221\222\239\238^\020\127\181nz\251\127m\174w\199\251W\185\212\155\135\155\187\166z=\158\253m\246\234\231\195O\187\191\154\235\223w\143W_\171/\219\187C\243\234\135\175\219\253\246\234\177\217\255\209<V?\254\245\216<\\7\215\159\218\251\237C_\149\127\254\179\253+\157<_U\175\235\241\162\026\143\198\163j\185\156T\175\206S\185\253\221\238\161\249\189=\236z_\188\030\143F\n\159}\221]\221>4\135C5\027\189\186h\246\135\174\200hT\255m\148J\253\214>\238\174\154\255\129\022\203\238\218\029\170m\245\184\223^7\247\219\253m\213~\169~\217=\180\143/\223\154\215\255n\210Yo\254Um\031\174\255o\187\175v\233\228\195\241\242\176\187\222m\247\187\230\240\183W?\166\155\\\239\030n\254\184\250\218$?\2475\248\2271\021\223\238\175\153{\245\195\246\219\191\179\235\231\179\201\171\207t<\157\142_\1899\\u\030\221W\243\229\228\213\219\134\127u\206|\245\199\227\245\191\215\213\164\238\014.\214\213b\158\014R|w-\194\241=\025\207^\253\144\138T\255\168\214\159\171z6J\007\191U\135o\219\228\189\127T\255\172F\244\223?\186R\147\\j\210\031\252V5\127]\221m\239\251b\147\212|\227q5\025\213\213|\190\200\165\167\185\244\180\206\215\252\243\216&7^\222\245\229\199\211i\"\198)\\\187\019\230\249\132Y>a6\202'<\028\239/\187f\189y\232O\169S-f\211Q5_P\241\185/~\221\222\221m\247\1856\227\234\245rUMS\131.\210q_z\145K/\169\238\223\154\253U\215C\186\226\139\174\242\147\244?s\241e.\190X,\251\226\219\251t\194!5J>a\158NXV\139z\162\149_y\223\244\214\230\208\235\237\157u\182\206\171\186\187\007\1572\029\249S\190m\247\205\195]\243%\1591\173\187{\140\187\006Jg\172\242\025\227\224\012s\147\190Z\163\170N\182\203)\181\247\210\246\208U\235p\155O\168\151\169\201g\201Q\218\nSj\228\249b\150\239qw<\244\133\151\243\174\001R\253g#*9\245As\149Dg\219\023}=M\021\169W\21385i\234\208\185\244\204\215\253\235\203\183\175Mn\217i*\153jP/\235\1906}\233\185\191v\242\254\174\205\206OB\214\133\21885\209x\148\003sJ\141[Sk\029\238\182\135\175\185&\243Y\223T\147T{\177p\233]\242\159f\223\230\176I._\244Q\195a0]\249\162\237C\1955\030\165\246[I\193\217\200\023||n\201\195]\193Y\173\005\199P\240\235\190i(D\250\187\167\nKYh\187/\2371\199\247\184\187\232\194\220}\002\005wO\238\154\171\177\024?\155\250\162\135\221_\217\246QWr\150\186\228|I%\161;\030\154'j\175\020\025\175\151\233\166\011\189*\244\197Fb2_w\186\154he\023\208\205w\228\212\212\155^\143\0239\024\185\236\210\007\205U{\215\230:$\135wQP\207\199\157\n\230\194\208\005\015\205\253NO\232\195&\197\164=c>\242\177~\215\141&}\172O{\011SMf\227i.:\246E\155?\143\219;\238\023\227:\247\140\t\185n^\251\1947\221h\222\236\135.\r\173\151\006\242C?\222\245-\216\005e\138\162\233\162\235\162t\002\181\225\138\148uK\221?\197y\023\235\203\145\198\250\156\026q>\030\247E\223\228^1\235\"h\150\1743\159/s\185\185/\247\207\\n\217\021[.\187A'\023\163\182\2355>\021\251\161/6\207r8\239e\135\238\203\250Y\215}\193\183z\189E2S\174\183\242\183\2531\023\235j7O\227\007\023[\140|\177\159\178'\187RIV\164\212\216\223\243_9Pj\210j\149\184E\237\011\254\219T.\025&\215\131\225\238g-6Y\154\202\2418\215\235\225o\213;\018\158\254\182}\215\227\1303\239\188\247\1853uw\237*\199\165\184+\245}\234\183\234\023\211\018)\194\165\024\140g\191\146\231\186r\203Ts)\183\2447\253-\151\171\187\2383\171\186Y\161\148\\y\175|\200m;\202m\187\210\182]Bk\252^\241Da>\210\214XBk|\204\173\209\r\181I\231\221\245j\127\189Od\202\004\130o\t\253\228\143\028\245\139\190\130\179\209Rf\030\203\169w\225\025\223\186\139*u\205r\230kx\158\1757\162\128\153\027[\160w\\Tf\0220\183U\132VY\231\130\227\190\224\170\235\151\\p\233\175\248\153\154\165\175\227\204\220y\229M\217\228\011.\193\148\213\200\023\251/\142\193\174M\244\174+\158?\244\151\253\173\186L\019\243\219\230Q\230\028uW\209Tv\210\015\024t\014O\ril\189L\167\152\241u\154m\155\140\181=W\147\240.f\158R\211m\186@\224\219\200l17\198\246p\181\219]\237\246W\199{\n\175I\154HLM/^\193\248t\236\230\189\1354a\231\137k\146\205Y\207\190^\228I\197j^\149s41~\188\200S\180\201X\167h+\024\171\182\026r\169p\n\000\030IV0\167\184\212\017\173+8\233f\231\185\224\202\171\197U\197\163dW0U\152\175\216\207m\220\252\182\226\017=\245\140Y\215q\233\146\253\012\203^3;\160\155\004w\215\236\006\015\185&4\230\023\234ji\002\149$!\141\189u\210\181\158\251\165\218\165iD\127pW}\185\163\211\161\007\222\144\014\167s\231\253\b\1657\130iF\142\150\020$\175\211\180|\1774u\159\249\026\237*\154_\229\209\189\147\217)\149\156\251\146\255\143\234\158\170\220\215\189^\204M\225\133w\t\205w\167\217%\243\177\169\192\210_6\015\234\211\236\188\186\155dII\016\200{\t\230U\026\161\166j\252\024Z\238An\222\025o\011\194d0\207\025i\130;Mc\168\150\132\169\224\183l|7\019\171\147\011\167i \213\1788\159\200W\237\139\166b\201\028-:\245]5OQ\210\152:\242q3\158\249ry\150\212\1757R7\158w\253\160\166\146\208J4\011\204&\213\169\007\206\166s*\t}\235X\201\178\167\2352\166'\140\151\1901\159T\172\146\139\234\185)\185\242\163\221\179\2143\197\220\2128\180\030\249k\254E\002L\190O\029B\139B\247z\161\162S\138{[\129\186\246\142\250\015\149M\003xZ\202\165\145sZ/\169$\181\210\148\021#\169\164\138\209\1723.\141\241\211Q\215\207\023t\n/\184hZyI\203\221\174\019\229\228I\146\176\005\135k=\011n\160\"\252z\145\2390\153\174\204\029x\2421\029\171\n?\238\238\174i\2173\170\198\233\242\179$#\147\154n3\1351%'\005\174\219g\154\167\175r\132N\234\186\215\193|\014D\179\174\196\187J\165\021h\167%\179\249\136JC<w+\216\148\000\186!\219\187an6\238\214l\\\158\2204\166 \248\210\165\159x>\1573M\233\172\201D\151y\2279\140%/\141,\026\186\017T\007\218\241\028V:_\238\218\253\238AzX7\183\153\245mF\253a\014Q~h\180.\179nxH\190\232\245h\206U\129\145\228\234\184O\139\252+\014\186\186;k\214\253oEm\198s\232z<\213Q\237\176\235\147r\188\130\232R-\245\212\220e\001\019\006N\206\232h\216u\234\201\188_\164\232Y\160W7\199]:\227\190\213\025D7\170w]'\245\222\017y\140g\219<\234v'\245\213\179\193\158N\170S\015\209\147&\003'i\000\167\137}\127Vm\206\130Q\231\203\142\199\1831\141o\203N\249\169\175.f\216\148\174\2444\213k\169\r\185\128\134Li6M2\164\145--\158S\152\215S\174\n4\227\245\246\230\166\225\238\218O\179:)^\026\223\174\162\0198_V\215\2121\204R~\204\019q\159$\233:S\179o(S5\234\242\154UN$Q\255\224\249\246\172\150,\210\246f\191\253\150\141\153uQ\220%\182\198:o\028\243\212{Bw\186L\217\226\230Q4a\149\175\222\197q.>\173\202\137V\223|\151\219\003I\t\167\136\210\1659E4\230\0259F\165\1565\163E\252t43g\205\227\179\202\236\219\212\172:\198\203\197@0\155\016\155\229h^h\136\241\196}\201rww\183\251v\216\029\180zI\130S\159\230\212\212\152g\240\t\144Vz\252\218\030%\153\216\203\198*'\190\023\148Z\027\175\160\167qN@t\181^\146\174v\179\132\005yb\133\189f\191\229DP\151kMS\249\201x,i\132\241\n\154i{u|\164\226\221H\149\232\206l-\014\025\188<;\255r\215\228\177sEwXv\249J\174\016\204\184u(\233\252\211\169\246\180\155\200\214|\135\133/~\191\189\218\147V\166\150\155uB\150\234?\227\017n\005\217\161\203}\195\230R\030i\218\245\224\025\181\196\n\242C\215\237\227\246J\134\158N\030fi\1340\233\214\1764G\169G\144\162\189\222\165\158\197\173=\1663\166\238\012P\187\189\012T\148g\157t\171\187\213\152JC\131]\165\231*)\139\157U\165[\020\244\163\250\178\166\004|=\194$\234\241\225f\187?\222\223m\143\217\138\213$\183[\159\238\156\210I\208\b\237MJc\222\146\209y@\236*2\229{@#\\m\185\r8\136\186\025\0157q=\194\014q\143\186\184L\021b]\172yV\194\197\223P\202\167\031iWc\205\150\212\181$us\183n\247\215_RFO\210\133\211N\248\211r\205$Wk~\142!\201\019\179R\197\012J\205\1433$\225\161\133\251\172G\215\172)fz\186/\207i7\154\007~\200U\239\214*iq?\215q\178\230'\025\189\228\230\170\223\167\169\212\241\142\235>_\228\186\207M\2219\185\207s\215\173\201\138&\183\164\230\225Yf=\133E\211u7\002\031\014~\2374\153\153\019p\145\163\166\210Jg\146\166\251\188\210\169\139\180\183\022\239t\167K\235w+\142\025\173\182j\206~s\213\219F\163\171\238\251\134\212\004\243\223i\140KO\002\147Z\031h\240\157/i\168\238S\198\249!\198kx\238\241\179\235\135}\203NS\157\150\227\165+.\235a\0216^\020wq@\253\2275\212hkd$\235y7\223e\021\193\210\199\162\011\210\nf\182\028\021\183\144\ni\159\226\n\245\169\144\177\191\005\231|\156\181\146\251Ak9\217|\189{\218\145\200.\231\185*\171\172\181\225\197\2137ze\nI\1852'\143A\2415\141\188\164\153}\225K3\164\208\202j\185(\220\"\t8\184\190M\197\225\029d1\166w\208\021Y\208\186\178r\237\159R\025\221\239\022\135\157\202\218Ul\217^\190b\220h\253\140z\028\219\162\194o\173XN\226\2100\176\1523\160\149\197\179F\197{\215v\025\000\147\144*\238`Z\194\185u\030\135\181\185|\031\208\253\229\023\197\229%q\239{$'\240\177\246\2428 \141\235\244\212\162x&\192e\221cE\211`K\026\021S\160\190\134N\185\152\243)\252\216_\020.\153kR\148E\245\205LC*\191X\205\194h\1842\189w4\220{\185\1614\0164m\200\019\128\215\160\249\191\161\1779Q\159\250\140\205\212\139\135X\205\181mY\205W\195M\1875\179BS#TC\206\157c\141f\180Q\195\166\159\209\140\031\180B\252lh5\026\174\144\153\021\146\224v\003^=\029\13647m\027\0125\237\240:\127\201\249\170\233lZ\180\150\15063\176S\210 \249J\227{\218\003\209M\240P\248\023\185\242w\237\127\154\135\027^\151\247\143\134\187\tFl\233'\173\185>\012A\029\148\135]E;\213\185\242\246\193W\209\203A\215L\242m0\156Q\163m\b\197\218\240\198v.\0252\176wI\nR\173\206y\200I\217Z\218\019Mk\241t\217&\2091\154\255\011\130\135\031\144\020c)U\253\236k\187\207u\025\245\213^\021!/\147Gc\164yf\134VJ\219\154a\203\180m\220L\127\192(\186\236\159v\021\165\201)\215&\224\243\195\130\249L\019\238\197\184`\234m\007\006\172\184\132\140\200\153\r\022\144\179\137\221\220p8\246y\tJ-ORR?-\178&\186y\161\240\164\234\147q\228\224\156DK\219\233\200@a\157\218\153\194\243:\156G\221\031\239\030w\223\238r\226-MF\147\215\187\\\211j\017\251\197\232\000;fqBU\165\141\228\177d1\195\161uOJ\207<\238\182w\215\187/_$\004&\203\172\028\227Q<)\242\163\177\204\139\186\249\202h\030\143<v\030\165\015\135\209\147\"{8#\202\171\148I7J\r\200\192\1438{\020\229\030\154<\250I\017\207\031W\133\r2Ms'\200T\127<x\194\149Y\024\140\190\1870x0\221\144\158\229,\006\011\031M\191\226\128H\153\145\217r20\240\171\214;\247O\226\005\144i\173\188\250\tf\237f\003WZ6\015\237\226\210\150\165\135\n\251\246\182yp\143\022\198\201\128\254\209\194h\025N\183\246\205\205\238\1609\199\019\243-\025\173\180#\154\253\025\216\019u\185\231U\155w`\020\170\2059\246c\026\nu\007MgA'\1763I\175\021\161iDD\163r\030\143O\166\163\231\241i<\024\004\173\t\002~\178\180*\131@F'\211\17022\161\202sY\0190Z\022\174;\205U\166\237G\186e\169\238\131\160\206#C\212>?>\154\164I49\151\153\158\029\129\2314_\178\027\129\138\185*\206Sj\154\167\216G\173\1978bf\220\228\198\254\025K<+h\204\218\165\023\129n\237b\158f\022C\160]J\229!p\234\182\127\020\195\136i\167\239\1439^\139\181\252P\178Bc\209<\193\031Z\206\254\199\202v\255\1441\138GQm\187\170[e\207\216g\236\197Pl\230\241\195C\177D\187\150\174\135\023\251\162\238v\2261\2207dbn\196\151\166\241\167\012uN\151\137y]\140\004b)\012N\206\220\129\153\147YG\157XQ\207\199\180\228m\238\030\169\155\244\2215o\028\138<\243(\147N\247|\127\176s<\183n\138\149D\179^tC\241tx\138\229\220cm\029\2006\220\231\135\2439%=\202;\171\249Iv\225{\245\011\167\"\187\221rC\018Y\228\207(vf\1712\127&zm\226\2485\245p\187_\016or\173\233\006\222?\179\168\203)\241\204\204Z\147V\238\147ff\015\2459\216$\132\233\017\210|h\142\238\022\142\139\172ivS\0266\219\157Y\231\140\141\166\197:\251\030esaVw\179x8\249\005&\t]\242\027\163s\181$\155\229\221\005\154\012\213\233\161\215jV\230\028t\174\229\198d+U\208\197d\0207\131\172\140\224\139\129\178v\201\216Op\146\143\134\214R\191\152\1610oX\157\151\203\180\153l\224\254\186\189\203\019\233\2014\183\234\180\\\139\240\200\217e\213\255\027\195\166\0043\168\136\217\2013\180\158~0\201\015\154T\206\139\220\135HN\209YN+\015\245\022\187\214\028\152\221H\179\026\199\203\004zQ\206X8{\175\2438\222\005\214I>\166\229\212\249\212\173*Y3|\175Wm\221\024\145\214`\245hp\193\240G\145\219=\209\015E\011\011\159\158\024\234x/\205u\026\165y\219\254\168K\183u\225\188\0244\163\213\208w!1\029\152S\137\209fg\245\144\209G#\1836}\003\t\168\025=\142L\139\170+\014\2314s\204/',\230CiZ\223\179\186\153`\177$\145\188\r\166.'\148\143\t\166^\178\236\209\232w\203\158\201\128\031\181\184L\167\231\131\153\194OE\141\198]\196-\023nWq\161\154\197Y\148p\182\207\014\139I\158\177\131fx\243\194\n)lG\175\025\r_\221\t\243y\156\133z#9\0233}\028\200\231|\208\154\2168\158\196\139\153\255\192\202J\247\169\205\135\150J6)9\176\128\023\021\183\134.\179\157v\231<\138\207m\209\127\167\185\189\236\134\205\"Mc\151\1825\189\136Q/\007\198\021\204A\244cK=\027\236]\015F\128zy\158\245\187\131\199\225\204\231\177X\219\208\210\198l{\196\234\223\1817]\135|h\031\217\134nG\170}\153\164\232\004n\242V\015\167ED!\252d\152E\"8\129F\189T\025\029\244\186\253\173\245\170\127\219g6\141\199\176\155\232\017\r\237\b^\012T\170\161\021\166\212\191\156\143I\144\218\220\b\173q\166\195\003\234`\016\153\157\1838\025KaZ\164)\0234q\029\202\128\217\004O~\206:1\155S\176Z?\030\233%3}\161\242\199\135k\243&f~5\243}\179\127x\187}\220\234\175\223\183\1874\011\173'\245\248\213\251\223?Wo\170\031\186i8\031\231\161\221\000\217W\022\160y\169B\255J\1993>\206\003\184\001\172\251\020\254P\189\158\242\249\180*4\128\233U\006\149\1763X\030\172\012\224F_\131\147w\r\146\247 \024 +\157\002\031\205\241Y\170\251\130\143\217'\n8\027\025>\239\158'\2421\217\168\128\181QQ\181Q1\178Q\001o\163\226l\163\"$\152\006\233\165_\127_tS&n\148u\018$>\222\164Br\204\149\023\192T\1471\243\130\170\186\224\216u\\>\166\171(`]\160\168^[1r\129\002\222\005\138\179\011\020a\023(\146] \191\159\140\017\207\230\248\197\030\163\007^J\015\228\"\1667\017\000]\138P\232W\140b\231\202\184\233a\004@7#4\236k\1533\029\142\000\232u\132F]\143\168\178\255\017\001\157\144\208\184'\018\137\221\145`\232\147\132B\199\204\232G\004L\023%\000\250)\163Qg\205\156\233\177\004@\183%4\234\187D\149\029\152\b\232\197\132\198]\153H\236\207\004c\167&\216\247\236\012\218\238\157\017\211\1993\176\193\b\198\222N\232P\192G\253>3\166\243\019\000\n@h$\003D\149Z@\004\b\002\161\177*\016\137\210@0\234\003\193^$2\248\132\182?#\240R\000\1613\003\245\200\029\218\168\007\001\160\030\132\130z0\138\234\145q\163\030\004\128z\016\026\170G\230\140z\016\000\234Ah\164\030D\149\234A\004\168\007\161\177z\016\137\234A0\168\007\161\160\030\025\253\136\128Q\015\002@=\024\141\212#sF=\b\000\245 4R\015\162J\245 \002\212\131\208X=\136D\245 \024\213\131`\175\030\025\180\234\145\017\163\030\025\216`\004\163z\016:\020\240\145zd\198\168\007\001\160\030\132F\234AT\169\030D\128z\016\026\171\007\145\168\030\004\163z\016\236\213#\131Oh\2513\002/\005\016:3P\015\227\004#!\022\005\029\177\020\136\137\163PQ\012id\197\162\160-\150\n\005\198\0200*cQ\144\026KEzc\249Rt,\011\202c\169X~l\t\212 \203\129\016Y\n\212\200P\031C\212\232\146EA\156\028\021)\148)`d\202\162\160U\150\138\004\203\242\165jY\022\164\203R\177~\217\018(b\150C%\179\156\1513\195XM3\176\0176\131n\194\030\134\018g\169\147]3\018;C\027\197\179(\200\158\165\"\237\179|)\128\150\005\021\180T,\133\182\004\234\161\229P\020-\231\149\2090O\161\203\158C\244%F\135\219%\144LA\140`*\006r\169\004\136\165!P*\1332B\169\024\200\164\018\161H\nm$R1\016H%\"yT\182\020G\229@\026\149\136\133Qy\148Ee@\020\149\000I\020\226c\128\0259T\012\196\208\016\145\020\nm\132P1\144A%\"\017T\182\148@\229@\000\149\136\229Oy\020?eP\250\148\241\194'\184\149=\001\141\232\t\182\tz\b\n\158\018'\186U$vB\026\169S\012\132N\137H\230\148-EN9\1448%b\129S\030\229M\025\0207e\188\180\t\254\0208\2319\192^\"l\200\243\129\160e[\141\154\017\000RF(\232\024\163(b\0257\nF\000\200\023\161\161ve\206\b\023\001\160Z\132F\146ET\169WD\128X\017\026+\021\145(S\004\131F\017\n\002\149\209\143\b\024i\"\000t\137\209H\1482g\020\137\000\144#B#-\"\170\020\"\"@\133\b\141%\136H\212\031\130Q|\b\246\202\147A+;\0251\154\147\129\rF0\170\r\161C\001\031\233Lf\140\200\016\000\nCh$/D\149\218B\004\b\011\161\177\170\016\137\146B0\234\t\193^L2\248\132\182?#\240R\000\1613\003\245\160\218\025\249`\004\244\131a\016\016\129QA\1360\018\194\bh\b\195\161\136\016iT\132\017\144\017\134#\029a\174\020\018f@I\024\142\165\132Y\212\018\198AL\024\0065!\248c\129\024=a\004\004E\224HQ\1364\146\194\bh\n\195\145\1680W\170\n3 +\012\199\186\194,\n\011\227\168,\140{i!\212j\011AF\\\b\217\020\017\142\242\194\240`\151\136\004\134(\1630\140\128\1960\028i\012s\165\2000\003*\195p,3\204\162\2060\142B\195\184W\026B\159\n7<\023\200K\137\196\190\r\228\134*c\228\134\017\144\027\134An\004F\185!\194\200\r# 7\012\135rC\164\145\027F@n\024\142\228\134\185Rn\152\001\185a8\150\027fQn\024\007\185a\024\228\134\224\143\005b\228\134\017\144\027\129#\185!\210\200\r# 7\012Gr\195\\)7\204\128\2200\028\203\r\179(7\140\163\2200\238\229\134P+7\004\025\185!dSD8\202\r\195\131]\"\146\027\162\140\2200\002r\195p$7\204\149r\195\012\200\r\195\177\2200\139r\1958\202\r\227^n\b}*\220\240\\ /%\018\2516\144\155\254\166Fl\242o\144\154\012\130\208\016\1362\211\195Fd\242o\144\152\012\134\002\211SF^\242o\016\151\012F\210\146\153RX2\014\178\146\193XT2\135\146\146Q\016\148\012\130\156\244\224G\248m\164$\255\006!!0\146\145\1582\"\146\127\131\132d0\018\144\204\148\242\145q\016\143\012\198\210\1459\020\142\140\162ld\212\139F\255\203JF\015\024\193\232\127o BQ,28\016\206\145P\244\132\145\137\252\027D\"\131\145Dd\166\020\136\140\131<d0\022\135\204\1614d\020\133!\163^\022\250_O`\2403\252~\193\223\145\247\0021\200!l\212\128\000\144\003BA\015\024EA\200\184Q\004\002@\018\b\r5!sF\020\b\000U 4\146\005\162J] \002\132\129\208X\025\136Di \024\180\129P\016\135\252\243#\002F\030\b\000}`4\018\136\204\025\133 \000$\130\208H#\136*E\130\bP\tBc\153 \018u\130`\020\n\130\189Rd\208JEF\140Vd`\131\017\140jA\232P\192Gz\145\025#\024\004\128b\016\026I\006Q\165f\016\001\162Ah\172\026D\162l\016\140\186A\176\023\142\012>\161\237\207\b\188\020@\232\204R=\254Y\189Iw\147cv\148\000\212\223\021pN\019\212\248K0v\149\000\226\bA\196\007\130\144\249\242\155\186\160\000\231]`\2411\213V\001[9E\181r\138Q\229\020\240M\1688WZ\017\174\180\"\185\210\244\251m\231Q\210\192\183\226Q\005\188\130\190\245\030UT+\173\024UZ\001\174\156\"\\9Er\229\2447yT\128\011\209\179\183]'\149\227\141=\246\154\253\214\246J\198\178\232\025\219\t\000\007\016\n^ 4r\005Q\165?\136\000\167\016\138\158!\024\221C\176\247\017\129\224\168\140^\160\193k\0046\005\000\206#4\240`\255\022\166\245`\006\208\131\025E\015f4\244`\166\002\015f\002=\152\209\194\131\025.<\152a\240`\006\209\131=z\129\006\175\017\216\020\000z0\163\133\007\127\234\1567\030\207\248\007\235\131\"\2284\1318\201P\216h\134\130,\026\138\136:($\242\160\016\233\131\002\228\024E\182\221\187\204|L\213V\128j\173\128\173\180\162Zg\197\168\202\np\141\021\225\n+\146\235\171\191\169\186\002\228\191d\212}\231\144\000K6X}\250\154\159\005\162\2347A\245\205[\180\006D\155\154\194\166\166\176i\151\130D\1429\156\004p\147OAM|\t\198SN\001dB)\b\223[\144V'C?\241W\000,\226G-\129\237\176%\160\140[\130\224\192%\132\142\\\002\2094\215 \028\137\130\208_\1462\141\187\151\201\194O\252u\015\003P\227\026\192Ns\t~\215uL\234\164\239\164_*@\001\174@\176\026xg;\165b~\r\240N\187\164\"\210 \130\228\000\215\223~\162\255\174\235\142\019\174\249\214\203\239;\233\142\n\004\162\251\206vG\197\188\212\190\211\238\168\b\b\236;\238\142\250\219\203\234;\238\1425\255n\236\177\159\209\189\147\222h\128rF\247\206\246F\131ioT\208O\243\222ioT\004\166y\239\186\030\161\199X\1956\172P\027T\168\197{CgP\188\168\019w\005\005\252L\243\157t\004\001\142\198\229G\012\138c\024\003\199 \006\142\024\003\176zP\188\136\141c\017\027G\023\027\239\187\2136-\196\222\203B[\129`\249\248\222.\175\021\243\139\198\247\184\168V\028\150\138\239e)\173\0009V\128\198\212\183\241~|/\225i\128\210\177\239mx\026L\195SA\239\237\247\026\158\138\128W\223w\2259\229\218\182^\172\222\251\240T\180\208\166\247\018\158\n\132\169\137\247\026\158\138\248\132\196{\tO\001\142\246\024\235x\012\235x\012\234x\196:\030\007\234x,\234x\004]}\207\209(\191_\2361\214\241\165\172\141\029:L$;\024\130\218qQ|\187\002e\168;\026\162\222qq\007pE\176/8\018\186\133\227\160\135X\206\132\174\131\161\2238\014\186\144\231\130\222\228\n\148\029\203\211e\031s<t7\199a\207s$vBK\182q\136`\215t\\\212\003\\\129\211\225\135}\215qq\023qE\176\1838\018:\183\227\160\159[\2388\000\159p\195\241{n8\158v\195\241\132\027\142\223w\195\241\148\027\n\253p\164\151\018K\189\012\192'\220Pj\205/]\218\182\150c\158\020)`g\177\002_\200\140\246\151n\217*\199\027Sf\227\147\141\191\216u\170`A\242\242\151\206\176\t\023x\241\217\251_\172\t\140\201{\162\181\007\192\152\232=Q\207\025\179\228\173J\015l\240\020\180\178x\171\210\019\145\189\242\138\161\183\007-/^1d\194\026d\156\224`p\133\231\"\135X\208\184\197\194\235\024\222\196\023AG9\174t\151\165#\167AG\136|\129\014\028\232\bLg12\014$\000\\\199h\228\180\204\025we`\141\192\006OA\231\016Z\186%\019\145C2\243\130\246\160\019\b-\204\255\173\207\127/\248\152\235#\000\231\191\005p\139\019AM\141\005\227\197\137\000\178\b\017D\022F\130P\254[~\243\170\132\128\\\1917\005\000\245&\020*Ohd\001Q\165\025D\128-\132\162A\004\163U\004{\211\b\004\251$\137\012\000\216\231\147\200\128F\246\021Id \192>H\"\003\140\246\185$2\128h\159\233>o\006`\180\213rh\177\229B\187m\129\192zK\163\015,Wx\194\146\133?,\t^\177\020\248&\255|S\000\224\015B\193\019\132F> \170\180\158\b\176\155P\180\152`\180\149`o%\129\222\190\015\157i\164\135\031\196*\005\200 \005\220jF\208\226\t\222\007\177@\001Y\137\b\"\207n\005\161\199\182\242\155\023!\012\156\201\\\233\131\012\006\006\176\227\128\192\023\178\136\249\208\171?\031\1276e6\006\223\248\213\220\007\247\180\1510\145<\174\153\151<@\193\139\129\228\001U\250\211K\030\160\232Y\144<\128\189\143\189\228y\212x\219\207\226\016\141\252\174\1798\007\172\017\248\140\167l\176\0046H1\173c\194x\2124\141E\161},\005\141d\169\168\165,_6\151e\161\205,\133\rg9l=\203\249&\180\012\180\163\127\201yZ\250\t[t\240%\231\160\192E\232\249u\136~\014\175\176\t\203b{\015\188\251K\172 \166\201\021\131\006W\002\154[\137\168\177\149-\155Z9hh%\176\153\149\193FV\1987\177\226\208\192\246\165\205)z\004\027w\224\165\205\130\190\b\188\187\014\176\207\193\185\155\160\0286h\248n#q\217\137\166-\t\128\134$\020Z\145\208\168\t\137*\219\143\bh<B\177\229\b\198f#\216\183\025\129\208`\242\030\219\212\025\140M\021\189\199\230\185\011\244\217\026\129\207x\202\006K`\195\148\175\129\017\225\178*\166q<\014m\228Ih*OF-\230K\148\r\231yh?Ob3z\022[\211\179\190Q=\007m\235H\211\196\030\135\150\0062jpW\228b\160U\214\003\248\231\129\235l\006\202cLx\178\012\r\242\173\t\nF \028\024\134@`8\n\001\230\202\198g\006\154\157alp\198\177\169\025\247\141\204(4\175\19036\245\182c\147\134\239\140\001yQxp] \159\139\1796E\025l\174\224U+br\182\193\180\019\001\208L\132B+\017\0265\018Qe\027\017\001MD(\182\016\193\216@\004\251\246!\016\154GrFSg06N\1483\242\220\005\250l\141\192g<e\131%\176Y\138$\018\019\178\192d3\252\002\019Ph\149`\129\tT\217*~\129\t(\182\n,0\001\246\173\226\023\152\0305\173\226\183##\026\181\138\236\222\245>[#\240\025O\217`\tl\149r7o&~\239\026d%\199t\150\002\212\012\n\216\022PT\175\171\024\249]\001v\185\"\236mE\178\163\2457\249X\128m\245z)\199T[\005\168\182\n\216\218*\170\181U\140j\171\000\215V\017\174\173\"\185\182\250\155j+\000\236\212\250\189\178d\131\213\231'\135\006\136\170\223\004\213\183\015\006\021D\155\154\194\166\166\176\169\181\199X\1956\172P\027T\168\197{\195S;\197\139:\241\2439\005\208\173\184I\234\163\217\151\252\017\247%\127\012\247%\127\012\246%\127\196}\201\031\007\246%\127,\246%\127,\246%\127\132}\201\159\204\171\024\159\240-\140O\225\011\024\159\130w/>\225k\023\159\006\222\184\248T\188l\241\t\223\179\248\132\175X|\234\252\168\199X\199\243\176\142\231A\029\207\177\142\231\003u</\234x\014\143%?\177\031\229w\247r\195\146\142\215\230xc\1439\006\0040\173MX.bZ\133\0000\155\208\200v\162J\007\016\001^ 4v\005\145\232\015\130\161\225\b\133\214\203\232y\001\132\006\157\015\027t>d\208yh\208\249)\131\206c\131\138V&\2167\181$\214|\147\173\017\216\020\0004\127\145Gc\"+\174\137\001\002\192e\132F.#\170t\025\017\2242Bc\151\017\137.#\024b\128P\136\129\140\158\023@h\208\249\176A\231C\006\157\135\006\157\1592\232<6\168\136\001\130}\012\200\190\127\223dk\0046\005\0001P\236\251\023\194o{\146\027\007\219\158B.tb\188\237)\164\209\161\195\219\158\194\"\133s\131mO!\135\145c\184\243\001\248\132\027\206\191\231\134\243\211n8?\225\134\243\239\187\225\252\148\027\202H\179$\196\155\223\129\016\005\201:\1347\0030\198a\188\003\129\232\179~\1294\226c?\139?\211e\145\000\193\166\1873\183\024\018\204o\175;3K A\224\021\1953Y\248\200o\191W\238\172\2350R\243\015\222\2103\2235\020\r\140\230N\160\000L\188\004\151\137\151 \188\171^\000\222T\207@\154\129\175j>\230\021\142\000\188\194\017\192\173p\0045+\028\193x\133#\128\172p\004\145\021\142 \180\194\145\223\188\194a\224\170\1893\235\2103^C,\166\244\219\150m\208\026^B\024\192\198\135\160&>\020\211%\132\158\206A#\128\004\141 \133\137__\190}m\030L\149w\198\156\157_\238\159\233\011\027\130\180\230Z-Z\216\134\205\211\006\205\211b\243\192\018D\241\162\217x\t\162\000\182\018/A\196\198\1891`\1436\194k\026g\241k\026g\213\161\185\223Q\251\207\025;\026\254\136\023>\006\t\1453\187\171P1\159\0069\195\253\131\138Cf\228Lw\n*\226\242!g\221\011\177\226\136\023{L\245U\192\236\000\"L\246\156\176\166\248='\128\130\254\005{N\128*\149\208\2399\001\0205\017\246\156\000\236\213\209\2399\241\168\209I?\197\0044R\204b\138\t\004hg8\197\004\018U\212O1\001\005=\205\168\017U\002\160\167\018\n\242Jh\212\137\137*{2\017\208\157\t\197\190K0\138\018\193^|\t\132\190\157Q\144a\006\157\022g\1768\181\t=\129\210\204h\160\207D\149\"\205D\169\212\196\128\\\019\138\154Mp\236#T\239\140\238\208\021\168\227\132\162Td\184\197\155\180\161\139\218\225\176h\135\194\162\r\195b@\234\137\140c\006E\159\2080:P\2543\186G\187\247\161\147p4`4\026\0182\023\140\011\1538b\201cx\199p\152 \170\028+\136\128\001\131\208x\212 \018\135\014\130\227\160\128A$\131\207\232\211\151\002\1281\133\208``\241\155\253D\143\131\205~!\135C\205\208f\191\176@0\236\004\155\253B\174\024\130\162\205~!\t\195Q\176\217/\226\236\208\020\172yC.\028\166\2265oH\227\1445\188\230\r\139\020\195W\176\230\r9\028\202\012g\0074\011\163RY\014\0077\203\133Zf\011\004\138fi\2125\203\021\002f\201B\214-\t\003\160\165P\232\012\135\131\161\163\252\144h_*\138/\214\156\240h1H:.\026*\227\151\167b:\0246\131\151\167\194s\139!4zy*\186j1\156\026n\023\187\180\024Z-Wh\169}{)\174B{\194\225\237\247\194\180=\029\166\237\1370\029\026\132m\145S\145\\\012\200\150;\017\173\197\224l\184}\236\185\253\t\151\023\195\181\227\194A\219\128\209\208m\232c|\214\241D}\226\193\220\022\b\134tK\227\192n\185\129\225\221\022)\006yK\158\nO\028\240\r\245\028\183\214\203\000\140S\128\129Wl2}n\190~p\142_?8\199\175\031\156W\209\215\015\206\131\175\031\156\227\215\015\206\139\175\031\156\023_?8\135\175\031\156\227\215\015\206\225{\002\231\248&\252\185\236\200\2303\252\142l@\193\186`G6P\165\157~G6\160h1\236\200\006\216\219\238wd{\020\188\144At\133\223\006\205\023\b\182AG\020xfh\027t\196\151>\n\182AG\020z+\218\006\029q\222o\1936\232\128\002\015\026\006\221h7\022\243\133\138\141\197%\001\014\1407\022\151l\233\188bcqI\160\227\202\141\197%\227\157Vl,.\bp\152\224\232.\217\184\203W\240\027w\001\005/\005\027w\129*\253\2277\238\002\138\158\129\141\187\000{\159\248\141\187\030\005od\016]\129\187e\249\018\225n\217\152\004\255\012\239\150\141K\148\222\nw\203\198$\250.\222-\027\179\222\147\225n\217\144\004\191:\014\221\171;N\249R\176\227\020apf\180\227\020\185\210\129\176\227\020at\026\2388E\220;\nv\156\002\012\206!\020\221Bw2na\004\220\1940\184\133\225\200-\204\149na\006\220\1940\186\133qt\011\227\222-\140\130[\b\006\183\016\138n\233\175h\156\146\127\131K2\b\014\201`\228\142\204\148\206\2008\184\"\131\232\136\140\162\0272\234\157\1441pA\015\130\003z\012\204\191\232L\159\143\248\152\204V\128LV\192\154\171\168\154\170\024\153\169\000\155\168\b\155\167H6M\127\147Y\002|\144\151\160/$\215\162\128\251P\136\160\197\251\211\023\146JQ\000\190g$\184|\255C\016Z_)\192\159\182b\160\219\1878\030\243\015N\b)\"\223\243\019\196\127\207O`\147\014RP\190\231'\136~\207O \253\158\159@\252=?\001\228{~\140\248\005\215\133\236\195\172W\004\184\210Ma\024\167!,\018\026f\191\154\167\152\230\025LI\254l\158\000\242\217<AJ[9{0cKv\178\234\185\144<\129\002.j\004-VD\023\242!=\005$:\004\145\143\2481\210\218\154\181\133\211\218\216Em\212\246m\209\246\248!=%\202\160\144\015\233)R\132\128\236\017\14967+q1\233h\143\209\157n\161\173\168ir\193\184q\005\240\214(.\141.H\225fZ&\211\239\181\145\1815\202\218\026em\029\202\218:\144\1815\202\218\186\144\181u!kk\144\1815\202\218\186\1475\018\228\181\200\154\002\193\183\229\214V\214\020\243\223\150[\163\172)\014\223\150[\139\172)\224\191-\1836\169\2225\230w\215\152\212]\135\153\220u\144\190]c\206v]$j\215Evv\r)\2175\230a\215 fk\0223\225m\217\006\173\129\132\234\218\011\153\162E\234t\029\229K\215\152$]\023\153\209u\145\014]\139\138\209GC\214&\241\185\198l\231\186Hq\174M^s\141\201\204u\152\193\\\007i\2035\230*\215\003\t\202u\145\149\\c*r\141\249\199\181\232\141\000e\226om\178}kL\241\173\195\188\222:H\230\1731\131\183\030H\219\173\139\\\221\186H\208\173!+\183\238sn\220\153%\209&\128\017\191\140m\204\179\181\r>P\219\224S\180M\248\232l\019</\219\224C\178M\241dlS<\014\219\1923\176\r>\248\218\244O\187f|\204c\152\000n\b\019\212\140`\130\241\000&\000\140_\130\203\240%\b\143^\002\240\224\197\128\246\238\r\234\211\006\245i\019\234\211&\208\167\r\234\211\166\208\167M\161O\027\208\167\r\234\211\006\244i\003\250\180\169l\217\006\173\001}\218\132\250\180\t\244i\019\233\211\006\245iS\232\211\166\208\167\r>\163\217\152Y\214\006gY\155p\150\181\tfY\027\156em\138Y\214\166\152em\140\216mP\2366\161\216m\002\177\219\160\216m\006\196nS\136\221\006\197n\131b\183A\177\219\004b\183\233\196N\248#\026r\012\r9\006\134\028\209\144\227\128!\199\194\144c\209\210G\031\204\146Jgy\240\169t@A\202\130T:P\165\168\249T:\160(o\144J\007\216\011\157O\165{\212H\158\127\197\005\208H\252\138W\\\128\000\025\012_q\001\018\005\209\191\226\002(HcF\183\216\130(\146\132\130R\018\026E\030Qe\248\017\0011H(\006\028\193\024u\004G\161\135b\202\207>\\Or\015D|\201\226\212&\244\004\170,\163\131\158\b\244\150\137Rt\137\001\229%\020\229\151\224\216G(\196\025\221\021\000H2\161\145.\019U\1383\017\160\208\132\162L\019\140Z\157\225\022\173h\1956h\135\189\221\014\197]\027\198\221\128\146\019\025\007%j:\161a\248\161\186g4\144\248L\028\177\2281\180\2558l\255q\200\254ch\255\241\148\253\199\216\254c\028p0\030\184/\236\140\016\131Q\161\252\194NADcC\248\133\157\130\131\017\"\248\194N\193\2248Q|a\167\192a\180\016\194\012\024\138\193\152\161D4l([\142\028\202\193\224\161D<~(\143C\13620\138(\001\003\137\016\219\160\245q8Q\002F\020%\162\224V\182\140o\229 \196\149\192@V\006cY\153\129p\198a\198<\242t\029\026\031\133\022\229\163k4C\222\194Q\199\016\167\188\021\140=\134+\135\031%a\004R\002\007!e\006]\137C\145\016\187\b\131\001I\137hLR\182\028\150\148\131\145I\t\028\156\148\193\241I\15260\176\029j\182\246d\235\180'b\185\029\138\229\129\017K\249\193X\199qK\137\161\144\198\209K\136`\000\019\238\024\148?\0149\232x\210A\199\019\014:\0149\232\248\029\007\029\007\029t\028\140`?\182m+\253\022A:\230'7\002\184\141l\012g\015\220\020\000\156Mhx\137\\\244\166\000\224\018\132\134\1510\238\190\137Q\184\152\165\194+\138\143n\"\012\174\166Dx\173\220\1647\005\000W!4\188\0045\238M\137\192E\024\014\175B\129pS\"p\021\134\195\171\244As\131\191\225\n\025\012\207\207\221\242\166\000\224\n\132F\151\184\148.<e@\255\164\228%\2545\201\203\240\015I^\006\127C\242\018\255|\228\229\192_\142\188,\254h\228e\241\247\"/\225OE^U:\235\184\170n\r~\235ld\152\214;zN\006n\177D|6\189\169\163gg\224\022K\012\156M\127m\214\158O\208mY*\190F??\232?\b~}yG\223\004\031O\011\018\024Y\197\142\249\183>\253\215\024Q\192\221Z`y\1807#\224\201\028?\155c\141\007\251\161\251\226\027\247\209\231\237\027\183\232\030;\208\212\217\235!\160a\237\253\018\139\171\154\209'\004\158\0170\022e\224\005k\140\182\017Z\026\232\222h\027;\208\024H\000\024Hhh\160\127A\138\171\159\209'\004\158\0170\006\202\251?\190\198h`\249\254\015\019\197V\200q\201XS\203\001%\162b\163\203\205\149b\151RO!\250\028\162\214\017\138\190\132\230\021.1T\233\023\156\228\143\0177>)\006\197\146\b\253Q\204\198\216B!\158\002\2369\192\140\031\004{\t\140A\031(\017x@\022\017\232\002!\172\015\020D'(\019{A\248\194\r\194<E\224s\004ZO\b\248\018YU\248B\153\210\025n\183\231\216\129\198\t~R\003hh\188\2230\202\230d\244\t\129g\004\140\177\025x\193\026\163\145\132\150\006\250\173\133c\143\026\019a\206\133ph$lPd\027\b~*\144\231\0021\134\018\242RT\029Me\184\180\213\239\023\028{\212\216\n3C\132C[a\215!\219A\240S\129<\023\136\177\149\144\151\162\234h+\195\133\173_\192\202/U\n\243\187\230p\216\201n\148/\233?~\215\239K\183p\175\025\223\193t\238\011\154\245\197\206_h\tu\003w\188\169\026{\204\t2\001x\019\153\002\229w\232nl\186\195`f\011\153\128\254\227t7\154\214P\004>Bgg\242\197,~`\006\127\131\174\160\211\192\246\0126\005\000^ \020\\\193h\224\015\162J\1670Qz\134\024p\015\161\232#\130\209Q\184L\189\t\151\1697'\150\169\196\161\243\130w%\249\004xW2\132\193\157\209\187\1461\023\184v\224]\201\152.\221\028\189+\025r\232\242\240]\201\136\188\025\128\161\017\028\0236E\2446 5\200\173q\245-\250\247\022\157z\027z\2426p\223m\228\179[t\212m\225\157\219\194%\183\249/\022\2431\214\176\r+\212\006\021j\241\222m\2485\203[\251\183\138\025\145?U\204\128\252\165b\002^\2361\214\241\165\172M\028\236\183'\130\253\246D\176\223~/\216oO\007\251\237w\130\253\246D\176\223\158\n\246\219S\193~\011/\235\134\240\t'\180\2233\180=mh{\194\144\129\216\b_\214\rI\136\152\232e\221\136{\025\128O\184\161\140\174~\170E\243\148\007YK3 kO\001\204\197\012\156k\169@k\004\169E\021jc\233i\251\137\016\029c\250\180\r\211\167\237\137\244i\171\137\001\002\194dh;\156\012m\191\151\012ma\129Jh\144\"m\135R\164\237\233\020i\235\022}\132a\218\180\r\211\166\237\137\180i\171k\t\002\\\b\223\012\225p\007O\1347rE\204\253\138\188m\027\231m\219Sy\219\214,\022\b\201]\233\166\000\224\170\132\134\023\205\156\185&\230e\2190/\219\158\200\203\182\210?\b\160\145u \011hY\160z\236\174\249\242h\142d\235\1909A_\238\177`\242\214\2461b\220\173\202\171\237\163s\248\197\255\128\161\017'b\\F\180\224\2455)\011\210\141\002\230\202} \2221\148\131\r\185`\141f\249o\219\171&\244\131\190\020dAw\185\146\215V\223\247o\005\205\248\216o\011\216\235;A\002\004\251\003\246\238\141 \193\252~\128\189y\031H\016\025Q\005\161\183\129\228\183\127\208\191O\025x\222w\190\231\164\186\001\200\247\006`\151+D\179v\242\228\190\011K!9\026\005\176Wo\240v\r\222\206\255AhA\205bW1\243\167\159\005\228\135\196\002\200\195aA\228/;3rc\143\169\181\020\240q\1920?\r\1759\006\186\191\t\205\030\150?\004-\128{\147PP\181J1~\131P\000\248\212\171\224\242V\161 \252m[\001\248\197A\006d\230/-\247\1671\233`\"\250\224g\027{\233\147\006\224\1840P \146{\217\161\200\001\232w(\002\n\157%\216\161\bT\217m\252\014E@\177\003\193\014E\128}W\242;\020=j:\021\001\016\234\132B\1883\138}\204?l\225\230\202\2325\022\195.';!\001\bk\212\1325\n\187a\177\019\018\137\178C\250\157\144\128b\215\132\157\144\030\190)\000\232\169\209\164\209s\216ge\183\226\2125%\246\222`\183\"Pe?\246\187\021\001\141{4\236V\004\024\250\182\223\173\232\209\162\151g\248Ot\199\001\251(vzB\161\2313\138\221\159\241H\003\228\011\153\220i\252\0232\001\005\r\b\190\144\tT\169\001\254\011\153\128\162\006\192\0232\001\246\026\224\191\144\233Q\163\001\004@\143#\020z\028\163\168\001\254y$7fF\175\177\024j\128|\137\019\128\176FMX\163P\003\138/q\"Qj\128\255\018'\160\168\001\240%N\015\223\020\000h@\244\024\214s\168\001\2429\206\169kJ\212\128\224s\156@\149\026\224?\199\th\172\001\2409N\128A\003\252\2318=Zh@\134\255Dw\028\176\143\162\006\016\n\026\192(j\000\227\161\006\024\208*\129\133Q\015,\135\170`\185P\027l\129@!,\141:a\185B-,Yh\134%A9,\133\250as\226\166\141,\140=\215r\216\127\029W\232J\144\128\15101\220u|J\1614>\143\025\194'\234\222\156\168{\172@q\0303\166\0035\n\242\152!W(S\148\199\140\200\155\001\024\181j0i\031\149(t\203'N\167A \021\0266\1488\r\011\004z\022$NCn@\219\162\196iH\162\206\005\137\211\136+5\207\144\127\198n=\196\250T\168\160\229P\011\029W(\162c\003]\204i\1377\021?\150\165\223\\\001\007\178\004:0\248\242,1F\244\028\238\1915K |A\150P\2097\135\146\1769\204\127H6\131g\248\155]\231A\231\021K]\164F\155\153\223k\201\235\228\223\155\234\245\194\242\252\151E<\168n \252\t\190\209\250\132\031\200|\134\002\207X\224\133\011\208K\226/R\128\001\183\128\243 \022\197\237G\005nN\248\241\225\250}\179\127\248}\187\219\031\248\199\219\237\227\182;\254\169}x\252\181y\220\239\174\014\255\031\004\212\156\151"

let times_bold_italic_afm () = "x\001\189}[w\2198\018\230{~\005\031w\207\217\204\234Ni\230)\221\233\204t2\221q\167M)\2187\217\150\019\173e+\163\139m\205\175_\128\168\027>\020\213o{\250L\134\250\n$\129\186|U\000A\250\207\227j\127\252\176{:\254\182>\2387\183\135j\244\183\254\155\159w\143\143\235\167c\245\243\238\199y\191\249\246\253X\253\143\219\255Y\245g\211\241\255\138\255\214\237\191\179\248\239\172\215\254;l\255\173\171ww\187\155u\245\231\249p\\?\030\170_\159nw\251\031\187\253\234\184\190\251[U\189\219n\171/\241j\135\234\203\250\176\222?\007To\181_\175\142\155\221S\245>\180\254{u\253\253T\253\182:WU\191\234\015\255\222\027\253\1897i\239 \237\155\167\205\127N\235_\223W\163ao2\017x\254\219\233\176\250\182\174F\227i=\170\198\147\233l\246&\142\238\247\213\227\186\186\222<\174\015o\127\218m\239~=\174\182\155\2197\031N\219\173J\170(\169X\180z\220l\207*|\179X\183\138\136m\222\1646\239\158\190m\215\213\219\254\248\205\175\135\015\155\215\245\221\213\230x\251\189\186_m\015\2357?\127_\237W\183\199\245\254\207\245\177\250\229\245\184~\186[\223}\217=\174\158\218\254\252\244\211\238\181z;\232\245\194?\253i5\155M\170\217\160_\189iB\179\253v\243\180\190\218\0296\173>\222\246{=\133\175\191on\031\158\214\135C5\238\189\153\175\247\135\216\164\215\027\252\173\023Z\253\190;nn\215\255\031\172\150\212\1819T\171\234\184_\221\173\031W\251\135jw_\253{\243\180;\158\127\172\223\254k\029\206z\247\207j\245t\247\191w\251j\019N>\156n\014\155\187\205j\191Y\031\254\246\230\151p\147\187\205\211\183?o\191\175\131\138\219\030\252y\012\205W\251;\150\189\249y\245\227_I\235\147\201\236\205W:\030M\006o\222\029n\163B\247\213d:|\243~\205\191\130.\2357\127\030\239\254\181\168F\131x0_T\253A?\028\005'\143\022a'\031\006\163\253\\\r\007\213?\170\197\215j0\238\133\131\223\171\195\143UP\223?\170\159\170\030\253\247\143\216j\152Z\r\167\179\182\213\250\245v\187zl\155M\234`\158a5\172{\161#\163\212z\148Z\143\199\227\182\245\127N\187\160\199\155m\219\190?\156T\195\217\180\026\135\255\159L\199\233\1321\157\208K\157x:=\222D\187~{jOy\027n\223\011'\012\171\186G\253\153\228'\220\237\182\219\213>5\030\244Z\127\169F\193\170u\236xl_\167\246\211v \191W?\214\251\219\024*\241\132\225,\182\175\234\217\176\154\204\006\169\24945\175\235i\219|\245\024N8\004\203\180'\140C\251Yh\027\2547\165\2463R\015]\190\029pr\191xB\024\237p2\171\134\189\129\140x\212\203\207\248\177\218\175\159\182\235\251t\194`\026nQ\1353F#=\163\239\156\161\247x\027\154\182\231\012\234\190\1583\200\213\180:\196n\029\030\146\225\198\213`4\011,\161v\024\145\153\199uj\255c{:$\029%\003\212\225J\147\212r\148\187\205m\224\158U\234\200$\234?(\166\031\218\244\135\201#F\227\188\243\223\207?\190\175\147qC\195\201\164\237\245\128\1809\154\228\215\014\186\223\236\146\234\223\206Zg\235\007\133\247\135\212g2\237\128lu\216\174\014\223\169'Q%A\247#\163\247i\174\145\255\174\247\187\228\150\209\141G\225ju\140\167\212v\150\183\221=\173\201\254\193\185\162\007P\187q/ow|\217\145'\214\177\229h\162-\251\208\242\251~\157\174\025\024\180\029\217h\220\211\214`\189\251\221i/\141\1319zCm:\132\166\155g\190n?]wZG\002I\141Gy\227\195\2305Yb\216^y\220\011C\171\169)\004\230a\253Lf\011\157\011]\024\140\245\170\016\146kq\205a\234Am\244PC\188o\158\184\187\1316\024G\245X\027Os\223\185\221mwO\218\225a5\bv\030\141\169\023\016\137\135\245\227FOx;\136Z\158\230\167Lz\185\211ocfi\251\029T\023yj\022\236\150\220x\210\207\155\174\255sZm9@\250\189\186\r\145\225\140\174;\200\027\127\139\217}\189\239\1864X0$\246C\155\251b\243zF*T\142\157\140\152\209\006)\180\147\174'\195\214\229\235\182er\249\t\217p2\169\219\150\239(8\162s\142g\234C\147I\222\238'R\217(\180\155\132\127\217\208\147:o\247s\026\209\160\189\241\164\141\031\1861\179\232 u\241=\017\213\164J\157\147\011\206\242\011\254b\162g\018<\155\219\213\189\188\221\007r\153\200M\147IO\219\245\243\251\25439K?i\166\167tW\015r\154\255\151\025q\029\233\157/\b\217\239W\202J1\004F\241z\220\014\002\235\163\012\248m\184\218\216\232\176\006\155|\162;\247\227\157c\154\224vl\147~\191m\247oj\215\006\223\204\012\153\243\027\245\2407j7k#j\214\215\224\175\193(\191\139\178c\236\215\129\031\165\229,o\2499\169\177Nv\158i\150\153\246\242N^Y\251\245\213~S\176\203\031r\193A\015\1748\200\213\243E\134\019]\209\\\145\131\166%\159\223\171?)\163\196\030\142\007j\232\233(\239\225u\162\176^\235`\170\197\2338\239`SI\129\019\028g\164\230\155B\168\204+J\168m\195\190\186\246\020\236\178\176\rg#s\235i~\197\1756\248f\230\206\179|$\203\196\015m\b\140\213cg`\146\255#\201 \247\155\025\020\0217\161^\127X\031\165\016y;l\253\"T\"\129\205&u\162\158\025\151\140\02067\225\028\147uS\156\r\234\153\168\1276t\239b\138\151`\191p\155\192\157\161\002\145\219\140r\254\\\029n7\155\219\205\254\246$\133\231\1767Ji\144\135\003\233\234\020+\226C(\229\185\162\r\2090n\165ok\234\218\164*+7\025~\127@\149\219P+\136\025\228\174\149\132n[?\132\1409\154\164:f\006\181\198\r\233g\148\200<\250\019\165\138\025Yu\212\150U!\197\145VRe\029\244\205\151\236\247\160\214\1843w\031\134dR\2035\251\189~~Q.^\2105\167\230\154\131\\\007\247\212\2070\240\016\153\227T\193\180\131\249w\181\t\165E{\176\173\238\183t:d\174o\212\249A<;&-{\171Q\030\176\223\133\194Ce7\154MM\239\199\185\147m8\180C\133;\025J\026\236\247&y\187\255KW\156\182\157\175\201\015\1851\216\238\129\1807\140\217x4\029\154\219O\243\203n\205\237c\252H\187Y\158B\030\213\198\179\150Gd\232\253^>t\170H&i\228C\211\016\138D*&\169\138\n\211\000m\t\005\226\015\186y\156\001\177\225\1801\022\024\201\195\169em/;\202\211\221\222$\167\136i\195q\222\240@\247O\213Jt'm\nf:\n!E\141\134\2040\158\145\141\250u\174\167S\234\2318\233\201*t\154\251\247sj8Iz\234\217\001A\129\241b[Nb\212r\203\001\132W*\140\219\012\030/:1\131\031@x\157S\2110\140V\163Y\212\014\006\185\162\254K\151\r6\173#\195\004\231\027\145C\r\152+GS\225J%\1646q\212a\158\022s\219\132\206\224\169\216\128h\134&\194\161\158k\215U\250\161\222\175\167\220\147\177syC\196\253\182d\152\2144Y\229[L\028*>n\182w\196)a\162WG\246\153$\014\137\167p\169\156\175\024\220\237^\146\223\247\137[\1341Dh\214\221\159\128?\203\020}\020Sz\208\214(\022\2045u\n+\2308\183\r\203CD?m=:\b}\210\249T\159k\230>\249\193}\\\157\226\026;\241]p\134a\172\211\228\020\200(g\154\254\180\019\226\201@\171\165\254\004\230?\247\219\221~C\151\158\182Yt\210N\015\234HB\237\t@F\135\181vf8\161\001\1435\139\246'\144OnO\251\176\004pK\142\023l\020&\219\177\234\025\179\217\184\176\230\160k\147\219a\211.\217Iz\011\164;\bW\150\187\212\016\002\188x\163>8ls\2268\198\142\156\004\156\245\237\180\t'<\238\142&\149\198)\194(\186z\159O\130\188\019Oj{''\r\219\147\1341\139\200I\195\142\147\212\137\131\201\195Y\145T\244,\200;\247\027N\019\211\228\135q\026V\247\200\232\\\157K\235-\183\158P\235q\\\138\"\194\170\193\142a\025Nj\161P\225\245c\254\011m\006\236(5\152\241n\245\237\027M\011gm\017\017\232x62\186\157y\237e9-\0225\195\148B\228\020\174\200\243\021\148\024N\235\253\154\022\177\194zK(\184\194\218g\224J>\r\243IX\190\253\182_\253\160\193\140\163\023\135\219\140':A\233s\t>\164[\221\132\229\228u\178C\175\213d\020\196u\130\212zT\149\229Vk\190\155\213\129\150\000\198\180|4\155\201\242Q\127:\246\157\210\156U\167\211F\189\1619m\226\159\166\190\2269\243\180\238pf\227b\1657s\005\031J4\242\131\237v\243\227\176IIq\212\154)\2040\006\178p\213\231Z^\206\bf:~\223\157d\161\177n\167<q]\188\166e\183\254\172_\185\203\004B\172C\206\253!?\t\177b\001\030\140J\235C\211qK\219\131Y,\028\137\152f`\164\213\237\233H\132\209.X\004\162\137E\1494\135\181\189T\162\223o\215\175<\242\246\148I\188C\143N\129\170[S\201(-\012\143\002IN\198\164'\174\184\185\245\227\234vO<\025\1888\198\2260:\255\128\162w\006\235E7\2515\r6\176T\219\149\184\022\022\163\176m\r\011Fw\187\227\234V\018OL2\227\224\192\131X\154R\0219\232\193\218\237\221&D\021\027z<nO\024\181\233\147O\000\162\219s\150\234\135\201o\219\163\160\164z0\163\214`\172\219\245]\240?\154fL{\156\212\003\207S{\\[==}[\237O\143\219\213\137\214\132\146\209Ry]\211I`\129\221\183\176\186\153\202\225>\175\145\133\194f\200#\000\019\220\174\246\1864\213^<Trl\222A\175\b\133\199\130\018g\134\018\007\\\149\204\168\150zGK@\1478\253\157\2455\203\014\006\188\218;I\212\188\219\223\221\135%>Y@\140\202\156\197\t\155\174\127\r\248\017\135,\162\152\201j\177\1462\224G\029\178\236\161\173\219\181\143\184\228\025\162\176\158\144j\248a\007\247\253s\234{\154S\204\226\212\169&\157\243S\142!\023\246\251\187\199PI\157\182\220\249qt\252\144\188F\186\1346\024\193\162\201\202\176d\156+k\141=\024\193\148\233.\166\223\195\193\206\156\134S\211\028\1678F-ul=\236\233lrP,\134\155\214qj\018\n\18687\025O\200\007xQ\156\251\189K\253\166\154\187\214\154{\128\139\226!\185\133'\132\129\165i:\145\030\016\198\007:u\204\186I/o\161\188\2525\011BZ\154\011}\152\210]\222\226dXI\141\022\222\135c\137\142\183\208\163\149R\136\204\243\227S\022\226\016i\2063\150\"\002\211\236e\018kQ\184\133\244G#\138\250c\248\146\027\203\162O6XY\252\193\177r\181~\183y\222\016\189\006\231\142)\165}\1463\028\251\023W\205\200\149gT\235H[^J\006\174\215E\229i\151*\245\234\162\2028\157\135\230\178\002\00770kq\211\014M\158\205\029x2\230\025W&\173\237\163+\195\249\237\2525r\172\157\192\150\246\202;FF\139k\147`4\025\138\176\190\025D|\222\2376\206,lG\1416f\189\026\002O\138\157\014\179\197\168\226\014\170&\219\0310\180\184\180\147\031\236d\028\029\227\151<\028e)\127\218\209\155\247!\163\175x\2011-\130+%s\227\236Y\1635\216\144g\186\241\177\202\024\212?\170\233$\222\016\192UR\187T\171\019\159b\b\166\2040\003\024\246\\\127\184\213\248}\219\029\192b-\241\005\187n\200\021\000*\231\247b\192\237\154yk\178i\169%\166s5p\203\253qA\1620/\247G\011B\219!\012\025Y>\199\014\141\169*\177\139\233\168\207\159\181?\230YQg\143\180$\148\030\197\007\004\227\014c\229e[\183\195i\212\171\189h\189j\020\231\253`0mn\139\176K\004!\235\149\168\254P\249\023\228?K\206\179\221\253w\253\244\141\n\152\248Pb\020*\199z\228\015\245\139\233\185<\016\153v\240\231?\209RQ\151\003x\012V\004;p\155\174\189u\2503\230\129\204\137z~\238\176\241\165yc\232\027`oG\029\t\194\179\150\006\163\181\214\152\140\229\209\021?\030\001\247\145\231$\211\142\019\174\191\239\246\150\026\198\245\176p|) \205@\205\2113\028\169\216\215fH\182o\023/\255\153yY|\234\021(\176\200\214=\170\007s\029\166B,\208No\234g\b\211o\155\129\160\223\2265:\171\017\127AF\027\218}\015\135S\187,\145V>\250q6\016\151\003\251\178\246V\232QI\202\168\177\17941\148&\222\213\217\216\020x\234\138\024\030TN=\158\182\199\205\143mZv\011\004\028\166\028\227v\021\179C/f\250l\002\169\139Y\181\012\228\167\147\211\014\214\b\1713\199\205j{\183\185O\015l\250mh\183\226z\236\007\1989O\203R\030\197\167n\192\172\146|\172;\234Cb\212\164\208\0302A\251dg\232\004\171Pw\193\029\194\221]5$\020\023\\\145O\138AH\181\150O\209\019\221\199\220\217\209\254\214\012\250\194\244\128\159\228\152\214\2428\167\171\241\201D\149\241\135\193\176#\245\175l\r\194\218\159v\212\178\191\154\158\164)\208\208I\250fsW\1529w\237\240\018\203\242c\133\253\238a\253d\031.\196\005\234\246\225B\175vK\174\253\250\219\230\160+\142\023j.IW\026\135f\187\006\006\162\206\249r\214\150\253\024\005k\243\n\251)$CYco\159\195\1341O\199\178\188V\248\166\173\139\216-Q\159\146\162\242\169M/-bu\248\240\206f?z\1807)\253@\018\148\185\182$\167\130\205\184\177\173m$\147aGF\169\215\180+Iw2\r&\237\198.]\224F#\253r\228i\127W\161.%\159\205\195\177\232\027\192\014\161\162f-*\221\017\157e\031\186\138\226i\r\232\152\1437\134\2120r\224\200\231\0023\149\161\153\140}\026^dA\211<e\193a\182\021\164H%\150\012\2542\239\228L\166\169\167k\214\169\254\168\207\241\187&\182\2555=\161'\141\158G\nsg3\200^E\251\228\244Q{\145\143M\237\209\157\143\197\225-5\145\191\015\187W\\\178\201\023\175\019\212E|H}n\227\131\202\249Kc\205\244\158\234\243\176\158\215\149\003?C\138\178U\\\215\194\133Z\234\194\244z\210\167\233\239z{LQ\210\238\141\139\187\161\166SW1G-<\179\199\252El\232^\212\172\206\n\207\197\194\218\219\176?\236.\179r\221\152\161\022\203K)\252\030O\228\189\189\180\227\162]\014\030\249\147\210\141\169\225\218\005\201\241\172\155\"\139e4r\156\241\212)\160\152\1773/\166x\181\155\b\241.wf\229\129w\209\180S5(\230\199\166r\r\\\185\015\156I\203o\173s\214\131I\161Q)\210-\r\018\159\217\221i\234\204\003bA\225\179VI\177R\193\"]6\014\150k\0032\195\027\148$\197+\2246U\r:\210\137\172\222\235\235\r\196\227\145\021f\147r\233A\203\173,1\027\170\026wdr\147g%\139w\229\217_\179\212\217\182\1588\211)\030\170\173\160b\227IX\185\1415\136g\221\224:\223W[\218\2554#\195\150\161\194\1853\174\174\155\1969k\019\231\164H\156\226\208Nm\220n\249\238\151\019k.-\2052H[Z\142{\2214\213\148O~.P\015\007L^\223\251%\142\024\214>z\163\186xV\144\178,\228\155Y\149\221\r\134\235\230F\251\020YY`\245/\004\150\r\148\024U\222\172A\026\227RHw$\n\023\022\026%>\172\1579\249\136\025%di\218\213\223\214\022u\251\132\185\024\003;\133u\253\138\183xu\209\219\207:b\179\136\2145\228\147^\187{\234\201\206\028\130|s\187\210M\005!\169\140Cz\154\142{\029+\182\026W\178\163\187k^\178/XjB+\152v?Y1\249\177k\128f\242\211\177\004\1903\205I\147\023V\012\191\148\196I\171zv\131q\201&\197Y\236F\179\238:\248\157\141\226\174\026O\026\219\012\198\021\231\1647*<HN\208\197d-8;\158+|\214\158\\\200\236RA\194\004\203\236W\235\\\136\205'\172\254D^\152\220\0145\249\2430\219P\143&~(\213?L\234\183\1557u\218G\005\138Lr\227\166\151\222\172}/m\208\213\167\130\164\229Qb\215\244\223\0129q\180\243\020H\246=\150\145\1923\028\179\t\018G\176\221}\139\177\249\180;\2420\226\006\2138\140\225\204\215\212\014\158\135\166x\168\203x\016\174\200N`\186\152\149\237\137.B_4\245\197\230\001\031\199\189\030\181\191D\252\173\024\184M\t\245\196\175\001\215\199\239y\170\028\149\149.;\171%$\154\2388\203Nj\181\194\016\228I\179rQ\127\168o\128e\213t\1689\218r\186W\230(\169x\237\234o\218><\234\204\152\191\156\232m4}\247\242\151\167;\243\210fz\139\243\211z\255\244~u\\\233\175\171\213&\148\163A\155\2117\159\174\190V\239\170p\237\201\152\143S\1387@R\149\005\168BU\232\159\177\160\231\227\148\200\r`\149\167\240\231\248\244\141\143\233\166\n\152\1922\168\184\157\193R\2182@\150\134\rN\1865H\218\149`\128Dx\n\252\017\142y\140\215\246\152tb\000;F\129\027s\173\006\199\216\184cl\156168\198\166c\140M1F^\1450H\155\001\244\247<\248\025\247wQ\181/O\167\031\203\016\022rL\157W@\187)\152y\145\245m=\"\240\020\194\145\027\208\234\182\001\172\n\020\213k+F*P W\129\226\172\002EX\005\138$\021\200\239g\211\223\023s|\182\199\172\001\001\140\006\bKML4\017\000!E(\196\021\163\024\\\t7\017F\000\132\025\161n\172%\153\t8\002\192#\t\245\220\146D\165o\146\000\028\148P\223KI\136\174J0\196$\161\016\152\t5\209\153\128\235\002\1288e\212\011\214$k\240&\141\171\164\166[IM\151\146\026WI\205%%5\190\146\138\160&8\143\236\004\154\240N\128\141\241\132\152@'\000\162\157\2082\228\147\192\139\251$1\193O\0000\000\161\030\r\144\168\228\002\018\000!\016\234\179\002\t\145\026\bF~ 8'\137\004>\227\b_\0168\023\000\016\007\161%{\164\1286\236A\000\176\007\161\192\030\140\"{$\220\176\007\001\192\030\132\186\236\145d\134=\b\128\192 \212\011\012\018\149\129A\002\b\012B\253\192 !\006\006\193\192\030\132\002{$\212\176G\002\174\011\000\216\131Q\143=\146\172\193\1554\174\146\154n%5]Jj\\%5\151\148\212\248J*\216\131\224\156=\018h\216#\001\150=\018b\216\131\000`\015BK\246H\002\143=\146\196\176\007\001\192\030\132z\236A\162\146=H\000\236A\168\207\030$D\246 \024\217\131\224\156=\018\248\140#|A\224\\\000\192\030\132\150\236a\148`(\196\162\192#V\004d\146\137\144Q\140\208\208\138E\129[\172\200%\024\211\192\176\140E!\138\172\200\011%+/\227\201J!\168\172\200\143,\219\002\195\203\202\128\136\172\b\216\200\136\012%\025\244\218G\129\1562\145\199P\166A\227\222\189\233\214r\243\023Zn.j\185\233\214r\243\151Zn.h\185`2+\203\233\204H\012\167\025\212\018\155\129\r\187Y\020(\206\138J\1583R\143\236\140\2160\158E\129\246\172\200\227>+/\t\208J\129\005\173\200\167B\219\002\249\208\202\144\020\173,gF#yvu\242\226\162g\031\005\182\180\162\1462\0051\132\169\024\208\165\n\128,\141\000\169RD\134(\021\003\154T\129K\146\"6\020\169\024\132\174\n\188\192Ui\025\182*\131\160U\129\031\178*\199\128U\t\144\162\n\128\018E`\bQ\176k\015\00324\002\143\nE\2208\247l\186t\217\\\212esA\151M\151.\155\191\208e\211\169\203\130\250T\146\019\159\224\134\246\004\179\164'\160\161<\197\128\240TP\210\157 \030\217\137\208P\157b@t*\240hN\165%\201\169\012(N\005>\193\169\028\233M%Hn*\201\169M\240gg\252/\014v\2460\1604\021\148\132\150\198j\216\140\000\1602B\129\199\024E\018K\184a0\002\128\190\bu\185+\201\012q\017\000\145F\168\023f$*c\140\004\016`\132\250\209EB\012-\130\129\163\b\005\130J\168a\167\004\\\023\000\240\018\163\030)%Y\1317i\\%5\221Jj\186\148\212\184Jj.)\169\241\149T\144\015\1939\243$\208\208N\002,\231$\196\016\014\001\1926\132\150T\147\004\030\207$\137!\025\002\128a\b\245\232\133D%\183\144\000\136\133P\159UH\136\148B0\242\t\1939\153$\240\025G\248\130\192\185\000\128@\b-\217\131zg\232\131\017\224\015\134\129@\004F\006!\129\161\016F\128C\024vI\132\132\134E\024\129\ba\216\011\017\150\1491\194\018\b\018\134\253(a)\134\t\227@&\012\003\155\016l\232\132\144\235\018\001B\017\216c\020\0186\197\157\026_c\205\005\1415\157\026k|\1415\0235\214th\172`\022\198sj!\212p\011!\150\\\b2\236\194\b\208\011\195%\191\144\196#\024\018\025\134a\004(\134a\143cXV\146\012K\128e\024\246i\134\165\2003\140#\2090\1583\r\161\207\197X_\n\228\\\"\1926\012\151tC\1571t\195\b\208\r\195@7\002#\221\144\192\208\r#@7\012\187tCBC7\140@\2400\236\005\015\203\202\224a\t\004\015\195~\240\176\020\131\135q\160\027\134\129n\b6tC\200u\137\000\221\b\236\209\r\t\155\226N\141\175\177\230\130\198\154N\1415\190\198\154\139\026k:4V\208\r\2279\221\016j\232\134\016K7\004\025\186a\004\232\134\225\146nH\226\209\r\137\012\2210\002t\195\176G7,+\233\134%@7\012\251t\195R\164\027\198\145n\024\207\233\134\208\231b\172/\005\018\232f\b\b\143\030`3B\146\18075d\147~\003\213$\016\136\134@\164\153\0226$\147~\003\197$\208%\152Vd\232%\253\134PI\160\023(IR\134I\194!H\018\232\135H\146a\128$\020\b%\129@'-h\200\164\253}\141\191\129H\b\244h\164\0215p\253\198\211K\211\169\151\166C/\141\167\151\230\130^\026W/\005m$4'\141\246\151\161\140\246\183%\140\0220t\145~\003Y$\176\164\138\022\247\136\162\021\024\154H\191\129$\018\232QD\146\148\004\145p\160\135\004\250\228\144dH\r\tEbHhN\011\237\175g\024\215\011\252>\227o\168>\018X\214\030\201\133\r\027\016\000t@(\240\001\163H\b\t7\140@\000P\002\161.'$\153!\005\002\192\251\t\245\220\159D\165\255\147\000\002\128P?\002H\136!@0p\003\161@\014\233\167a\135\004\\\023\000\240\003\163\030A$Y\1317i\\%5\221Jj\186\148\212\184Jj.)\169\241\149T\016\005\1939S$\208PE\002,W$\196\144\005\001\192\022\132\150t\145\004\030_$\137!\012\002\1281\b\245(\131D%g\144\000H\131P\1595H\136\180A0\242\006\1939q$\240\025G\248\130\192\185\000\128<\b-\216\227\167\234]\252\219\000|Lg)@\241\174\128U\154\162z]\197HU\n\176\"\020a\029(\146\134\175\191)\004\005h\162\031\2411\245V\001\2199E\181s\138Q\231\020\200M\1688wZ\017\238\180\"\169\211\244\251\189\209\232{\212\232{\212\232{W\163\239\029\141\190G\141\190/4\250\190\208\232{\208\232{\212\232\251\024\170c\238\249\"~\164\142\142\151\006_\230t\244\222F%c\137\244\204\216\t\000\005\016\nZ \212S\005\137J}\144\000\148B(j\134`T\015\193\185\142\b\004E%t\142\0036*K\192\018[\160\242\bu4\216\190\143i5\152\000\212`BQ\131\tu5\152D\142\006\147\0005\152\208B\131\t.4\152`\208`\002Q\131-:\199\001[\r\182\192\018[\020\026Lh\161\193\015Qy\156f>\136\226\012BJ3HN\025\002[\206\016PHC\016e\007\129\148\030\004b~\016\128\020\163\200J\242\229\007\254P\156\001\168\215\n\216N+\170}V\140\186\172\000\247X\017\238\176\"\169\191\250\155\186+@\250\147G\241\139\217\004dcY\023j\167O\252e\136\171\246\181\167v\243N\173E\011c\172Kc\172Kcl\196\219>\240\151\170\012`\187\165\168\246J1\186\189\002|wE\248\230\130\236\164\134\249\192_\0050\128\189\183\162E\249\243\129_\1564@\158\188\020\231>)B\133\174\002d[\001\232ON\025\227\238M|\237\243H\252\192_\167\178@V\230&\248\163a\181\143Hh\031\145\203>\1864\246\209a\176\143H^\031\011\222\250XP\214G`\171\143HT\031c8\142\184\231\171\220I>J8*\224x\205G\027\142\138\229^\243Q\195Q\017\240\154\143\028\142\250\155z+\000\135#\255\182\1785\246\158c\209\000^\239\215N\239m *\136CZ\023CZ\023C\218\217c\236\225\206\237\208\206\233\208\014\239\r\129\160x\209'\014\004\005P\171\018\b\012\156\140\240\132\157>\185\157>9\157>a\167O\029\157>\021\157>\021\138<e\190\241)\206\182\135r\156\207z>\229slE\139\185\206'\153Y+\224\206p>\233|Z\017R\172\002\164X\0014\208>\137{*@\238i\128\146\n>Y\2474\152\186\167\1309?|R\247T\004\248\225StO=\198\030\238\220\014\237\156\014\237\240\222\224\158\138\023}b\247T \167\168O\209\027\007\172Q\246F\005\178>\nj\250(\024\247Q\000\232\163\224\210GADo\130\016\175\242\239\179=\198>\158\203\222\216\212a<9\131\193\1693\153\231\223Y\131\210\21331x}&\243\003 k\130\177\144\t!,2\025D\136\149\025\147g0xe&\131\016\202e\142\243f\rJ?\206\197e\140erp\249L\134^\158\t1\b\173p\215\001_P\194\238\175\006\186\187<\208\221\133\129t\132q\214\228\210X1\1843\025\196\185\149\157\252H\193\232\207d\030\017d\r.G!\210C&\243\153\"k\130\164\145\t\145?2aN%Vt\238\128/\168\161\228\154\127\199e\219\254\148\143y\130\162\128\173b\005\014s\215aM\199\011s\188\180\199\204P\002\024\214a\204.^\210R\240\191\219'\130\220\224\140W9\151W\145\247D\185\127\249{\162\136z#\146\215*\243k.\016X\022\000\244\175x\1712\023x\227\149W\012\243\166g\247\202\206\240\237\128\140\0182\024T\145\203<\133Xp\238\223k\225\195\203\014\024\134\147\201.\015\202S\026\004\130w\218\249\194\029\0295&22\n$\000T\199\168\167\180$\155\2275\023\b,\011\000\186JhW'=\133$\201\025\155\158\221+\151\195\143\127\020\150\019\175|\194\208\0004\215S\192\1691\236\215\012\r\150W\019\250\217g\131\1923\000\254\162\141\249\157\151\006\244I\218w\005\000\253&\020:O\1687\002\018\149\195 \001\140\133P\028\016\1938*\130\243\161\017\b\227\147Ed\000`|\249\"2\160\222\248\138Ed\016\192\248`\017\025`\028_\182\136\012 \142\207\132\207\187\014\024\199je8b+s\199m\0278\163\183b\212\129\149\021\154\176\194B\031V\bZ\177\"\208M\250\249\174\000@\031\132\130&\b\245t@\162r\244$\128q\019\138#&\024\199Jp>J\002\243\241}\142C\027\201q\190\128\240Y\006\164\128\179\162\240\217\014C\177|E\225\179v^\017X9\248\204]\214\223\249\250\199\231\152\017\2448_4\250\012y@`]\219\255\028\217_\142\191\1546K\131\195\194\254ggM\255\179P\222(\007@\1299\229\001\234\169\178\160<\016\128R\129\242\000F\245f\148\007 (Z\1708\000@\229^\021\151\203\230\168\179\005\002_\241\148%\182@\131\020e\029\011\140F\141i,\n\246\177\"0\146\021y\150\178\242\210\\V\n6\179\"4\156\149\161\245\172,7\161\149\128\029\243\151\156=\020,\218\249\146\179\211`\238j~\225\162_\221+,\221\182ho\255\221_\150\nbL\174\024\024\\\005`n\021x\198Viij\149\129\161U\128fV\t\026Y%\185\137\021\007\003\219\1516K\012\140\219\241\210f!\158;\218]8\216W\231\220\165\211\014\r\234\189\219\200\178\164DcK\002\192\144\132\130\021\t\245LH\162\210~$\000\227\017\138\150#\024\205Fpn3\002\193`\242\030\027\000`*\239=\182\\6G\157-\016\248\138\167,\177\005\026\166x\r\140\005\217\170\1381N\142\131\141r!\152*\023z\022\203[\148\134\203\229`\191\\\136f\204\165h\205\\\154\0275\151\129m3\225u\023\014\150\006\161g\240\172\201\188\195*\139\014\252k\199u\150\029\237\209'ra\233\026\164[\227\020\140\128;0\012\142\192\176\231\002,+\141\207\0180;\195hp\198\209\212\140\231Ff\020\204\171\239\140!\002&u\223\025\003\225\188\208\224\162@\190\022g-\1396h\174\242U+\150\164\213\006c'\002\192L\132\130\149\b\245\140D\162\210F$\000\019\017\138\022\"\024\rDpn\031\002\193<\178f\004\000\024\199[3\202es\212\217\002\129\175x\202\018[\160Y\138E$\022\200\004s\148\003`\149|\130\t\168g\149b\130\t\002\176\nL0\001F\171d\019L\000\193*\178\029\025\000\176\138\183\0299\151\205Qg\011\004\190\226)Kl\129V)v\243\146\224*\026d:\230c:K\0012\131\002\214\002\138\234u\021#\189+\192*W\132\181\173HR\180\254&\029\011\160[C\174pk\200\021n\r\185r\183\134\\9[C\174pk\200U\1775\228\170\216\026r\005[C\174pk\200\021\238\212\186\170\214F\241\235\220DW\242\228\208\000\229\134\243+\251\140\208`\250`P\193|\239\249\149>\002T\0046\149_\197\135}cV6?\225S \235\144\160\166C\130\241\189\005\128-\239\130K\159\004\225\183\001\004\224\023\001\024\192MR\127\152}\201\127\224\190\228?\220}\201\1278\251\146\255\192}\201\127t\236K\254\163\216\151\252G\177/\249\015\216\151\252%>R\031\201q\238\186_\242\135\231\138\022\158\250E\030\147+\224n`\249\162\015\196\021\201w\221|\145G\223\002\\\203z\217\023!.\003X\206\018\1841\23178\174\198\029W\227\140\171\193q5\029\227j\138q5\016\153_X\247\242{.OK\190\180\239B\240\241\210\030\179\223\b`<\132\176\212\196X\146\000\0246\161\222\216IT*\128\004\160\005B}U\144\016\245A0\024\155P\176\184,\127\rs\000l\239-\127\229\178\006\175\217\184:i\186u\210t\233\164qu\210\\\210I\227\235\164p\020\130so\145\245\188\220\234\011\004\150\005\000\030T,\223\177 i\215\184\017\001\1602B=\149\145\168T\025\t@e\132\250*#!\170\140`p#B\193\141\018j\220\136\000p#F=7J\178\006\175\217\184:i\186u\210t\233\164qu\210\\\210I\227\235\164p#\130s7\1467\022r\171/\016X\022\000\184Q\241\198\130\b\242\r[rcg\195\150+s\149\232o\216r\197\168\208\238\r[n\147B\185\206\134-W\134\206\151\239D\024z0:b\231N\004\175E\227\223\171\185\160\219\230\175t\219\\\214msA\183\205_\235\182\185\164\219\210}\173\016\1568\223\144\225y\222\194\135\151\0290:\183\191!\131\196\215qzBu\223\181LO\020\160\130_\001\167@\189\182\211\019\197\242\002\245Z\167'\138Hq,\b\189l)\191\243\202\244:F\161\244\252s>\210\235<\222\020u\006\205\145\165\000\212\161\130K\029*\b\005\142\002\252\182\011\003\241e\151\001\031S\031\021\224\151]\004\200^v\017\212\188\236\"\024\191\236\"\128\188\236\"\136\188\236\"\b\189\236\"\191\249e\023\006nw\219\246\021\138\145\252n\167T\"\183m\2158\026\158Q\025\192\027\141\157Q)\1663*m\200N#\1288\141 \197\016\191\159\127|_\219Nld\251\203\181\188\003\163\128<\226fd'\175\254\\\203\140L\001\231]\164k;#S,\127\023\233\026gd\138\195;J\2152#S \127%\233Zfd2\198\189\025\192\030\199\200o\173\024 \163`\134\015\235\199\r\218\255d\228'\188p\254N\177\160\197\182\163k}\147X\000\216a,\184\236D\016\164\176\016\1915\204\191_\204\241\217\030c\127\203\rQ\215\178\005\1359%\223\130\003(\240\159\179\005\007D%\019\230[p\000EN\132-8\000\231\236\152o\193\201Q\195\147y\233\011\168\199\152E\233\011\002\224N\183\244\005!\178h^\250\002\n|\154PCI\004\000\023\017\n\244J\168\199J$*\137\150\004\192\182\132\"\229\018\140\164DpN\190\004\002\003'\020\194\144\193\140\139\019X\156\186v5\129\212\204h\167&\028\146fA\201\212$\001\186&\0209\155`_G\200\222\t\221`\192\"\143\019\138T\145`\195\232\004\000\173\019\234q;\137J\130'\001\176<\161>\213\147\016\249\158` }B\129\249\019\138\244\159\208=\142{\239*\t\179\001\163^JH2'/$\193\t[\158\220;\186i\130D]\140\140\t\131P?k\144\016S\007\193\190S@\018I\224\011\002\231\002pG\232%\150|\239\163\240\177\179\247\209\149a\170\233\218\251\2326p\210\142\179\247\209\149\021)\200\219\251\232\n!\0299{\031=\153MM\206D\218\149\185i\202\159H\187bLY\221\019i\183I\145\190\156\137\180+\195Tfd\150\215-\140dne\152\220\172\204%v\219\192ItV\140\233\206\202\138\164g\133\005\173[!$@+\1944hd\200=\153(O\137\246\029\171\014\248\130F\139$\153\201\254B\163^\194\204\196N\218\180rL\158VV\164P+\188\164\241\"\157\026\217\198'\171\"\181ZY\193\165Fh\211\172\1331\217Z\153\155rm\003'\241Z1\166_+\235H\194\182I\145\138\173\016\019\178\149aZ6\178\"9\027\217\222\215\220\254\130\202\139t\157\201\220\164m@/u\027\241\201?\235t\161?~2\183\r.\231\194\"\177[YGz\183M\138$o\133\151\220\019\019\190\017\189\248\240\185\003\190\160\157\178\016h\218-\024c>\2305L\001\248\025\186\000\217J\166\160f\249R0^\179\020@V!\005\145\165GAh\189Q~\243\226.\001\186\255<\007\160\223\176\255<G\189\017\148\251\207s\001\140\005\247\159\2310\142*\223\127\158\1310>\216\201\237\1600Ro'\183#\242\198\220\177\147\219\145\194\232\221\157\220\142\012\245\224\236\228v$\160\145l\155s\129\1296\202m\206\133\192\211\132\187\205\185\144\129\022\156m\206\133\0045Pls.p\024\189\238\n\206\001\0247\236\n\206Qo\196\229\174\224\\\000c\197]\1939\140\163\204w\005\231 \140\175\216_\235\2260Z\127\127\173+\244\198\222\185\191\214\149\131&:\246\215\186R\212\139\187\191\214\149\129\150\204VS@@3\184\213\020`O\027\206VS\144\128\006\138\173\166\128\227\168a\171)\1600R:\249]\137\192H\025\134\1452\236\141\148e\229HY\002#e\024G\2028\142\148\241|\164\140\194H\219F\239\2407\1402\1290\198\004z#L\146r|\t\135\209%\016\199\150P\028YB\243q%,\031\213\220\236\031\156\227\254\1939\238\031\156W\222\254\193\185\179\127p\142\251\007\231\197\254\193y\177\127p\014\251\007\231\184\127p\030?\169K\027\178\230\2425]\005\178\242U`\253\022\202\028?\1282w\191z2w>u2\199\239\155\204;>j2/\190d2\199\207\151\204\241\155%\2438]\239\247\251\252\131\215*\020\225\161*\146\173Y(lV*\020\228\245\tEd\201A!\217\000\167\016\237\128S\128\023\028\004\201\231\002s\22019\175\178\214\235b`\242m;\131\184\0033\179\225Z1\243i;m\201\223w\019@\190\227&H9V\158\216\214l\145\141,/\205e\n\171\000,\\\205\227dU/\182+\198\185\243G\181\243\204\181+\204\005SO#(\237\200\211L\131\020V\195\r\152sg^7\143\1479\025\222\t5pr\214\012\231v\174\166X\190:8\199Y\153\226\176T8\215\249\151\"\217\162\224\"\178\023\245w!\236\165\000E\141\002\217G\002\0055\174%\024;\145\000\226D\130p\231\020I\157\211\223\252u@\006\226\218$\247\\\022$\005\200\\DP\227!\130\177\131\b\000\254!\184\184\135 \236\029\002\176s0\176\018\182]\b\017)\144\231\131ENC\138\022\249`!$\164\000\228\131\133R\144\"Y>X\b\001\t@>;\214\223-\255\136\198\227\154J\143\143y\225H\000^\158S\192.\031\tZl\216^\228\171o\002\230\027\182\023\197\134\237\133Y\\c\132\137G\154\2322\218\002\215\206\022\197\130\217\"\018\207\148Oe\222Q 3\143\160\198<\130\177y\004\200}Jq1\155 \228S\n\176\149\024`\190\017\179\024\186\017\211\157\236qN7\011\151n\022\014\221,\144n\022\029t\179(\232fQ\208\205\162\160\155\179=\198>\158\139\222,\r?-\145\159\150\200OK\151\159\150\014?-\145\159\150\005?-\011~Z\002?-\145\159\150\145\159\006\220s\230'\005\156o\130--?)\150\127\253k\137\252\1648|\231k)\252\164@\254E\175\165y\176\177\196\167\025K|\132\177t\159[,\157\135\021K|B\177,\030K,\139g\017Kx\000\177\196\167\014K\230'\243\219>_X\218\242hY\148G\203\162<Z\230\020U\011ZTGK\183:Zbu\180,\170\163eY\029-q\217\127i\170\163%VG\203\162:Z\218\234hYTGK\191:Zz\213\209\178\168\142\150]\213\209\178\172\142\150Eu\180,\170\163%\178\213\210\178\149(\224d\143\209\rO\174\215\157\028\175;\161\215\001[)^x\227\169\240\198S\238\141\178\244\202\003\201\151^\001\005.r\150^AT\178R\190\244\n(\242\019,\189\002\1563U\190\244\154\163\134\179\242\1519\000\245\216\171x\153\003\004\192c\238\203\028 DF\203_\230\000\020\184-\161+\180 \178\028\161@u\132z\158G\162\210\253H\000>H(:\028\193\232u\004{\174\135l\152P\136$\0063^L\160\141JB\144:\bF\154d\216\225J\018\149\132\201\002\1355I\004\212I(\242'\193\005\137&\028\1534\161\134N\t\000N%\020\1375\193\187\226.;_O>\207\146\204![\146 \227\018\220A\187$-\184\151p$`\130\145\133\019\140T\156P\135\143\147\224T\000n\232\156\186\131\228\212\021$'7H:\216\154\132~\004\157\252\b\002\242\182OQx\244\197S\148R\000,\238?E)\165%\151\023OQJ\0012z\249\020\165\148\228\188^<E)\004\134\221\021\003\130W\129\199\241*-i^e\192\244*\240\201^\229\200\247*\001\202W\001\176\190\bV\142\245\145\251U\000\244\175\002\207\185UZ\250\183\202\192\197U\128\142\172\018\244e\149t\1843\230\004\017@@\027<\203\012\130[\178P\016yO%\152\"\140\196\201\018*-\019\133\1459\185B\165\144.T\128\025C%E\210\016\017\230\r\017\152\212\161\024d\015\021`\002\017\201\206\187\233\174S\157~&Q\177\147LT\136\249D%\029)E\027\020YEE\152XT\130\185E$\152^D\224d\024\145\157<\172+LO\023\163\241t!\026O]\209\216\145sT\222\025\173\167\206h\205\147\207M\248\143\031\159\220\136\146F\012\232\135\180o\240\235\2177\238'\179o\156\239d\223\224\199\177o:\190\136}S|\006\251\166\248\246\245\r|\240\250\182\250.\003\184\173\030\236\177\247\136\232\150J3\004\030\n\192=\1556\154#\240P\000\254\217\244\183#\191\151\208\131\003\185\215h)\178\253\188\239\221\205\150\190\240K[\201\140,\023\172\141\145\1376\r\144zl\0015\171A\197\172\022\019R4`\178\181\001\200\166\006!\155*r\015\127\154\229\190\n\151\222\174\015\135\141<8\187O\127;\137\143\153\174\004\200\254\246\017\131\240\165\135\251\240\031o\161\189oy\144\241\029^o\231|\137\226^\249L\000\247\171\019\247JQ\002\200_\178\"\000\254j\202\1895\028Q\246C\165\207\r\031d\200\n\228o\202>\228\233M\209\226\001\231C\166-\005\243\167\158\015\154\189\020\129\175\186>\024%>\160\018\031\\%>d\025C\176\\\177\015\029\138}0iA\144\\\213\015\168\234\007\216\217;\244`\208\173\183\179\215\1519\026\239\216\217\235\139K;x;{]\025Z\199\221\217\235\tw\190n\208|\157\187m\221\006\165Q\189\221\182\174\2047\181\187\219\214\021\130\003x\187mI\246\020\255B(e\183\1674\\\003$C[\192\\\201\192\242\183F\t\216\197cz\170\182\139;B\007|\172\202\218\197\007\nz\156\171zg\031(0&\221\227+'\192\\>\001\175x\202\185\000\224n\132\150\1834F6\2475\168\185\185A_\221+\156}\020\250bEe\135\0041\221\017\204tF\176W\231\220\179\135A7TPv\"\185\174\233A\002\204\237\019\240\138\167\156\011\000\238Jhy\203,\"\204\1573\220t \195_;\174s\238\194\161W\185\176\236\028\197\162\233\022!\166C\132\188\022g\157K\004n\207py\227\020\231\230\190\t0\183M\192+\158r.\000\184g\241G\015X \161\206\183\148?+<\200\128W<\229\\\000p\203\226\239\012\147\128\234\002\191\196\179\194\\\210B\219\245\253\209\028\241d\1994\191\147\145X\240\182\2533\161\142\196\249\211\209\006\218{\167\236\243\205\014V\194\243rG\146\149\186\133\252\224\221\253\144\175\140Y\t\221\200\147\240\159o\247d\182\019\142\252\199\234\214\189\157\190n`A\239\253\n#W\151\218s\237;\225\223\\\0262\144\173\155\231 6\205\222\246\205\193\162i\249.\148'\130\211\146\022\222\201\144\232w\190y\129@\254\203\003\025\232\188\003B\018S*ex\254\214\007\129\240.\007\161\176e\130\208\236\237\r\194xW\158\005\231\178',\253^\192\239%\254f\015\204@\179\138\148\240gV/\221\236\185\210\240x\214\153\140\000y\152<\19569A\139\221B\207\249$H\192|\011\209\179\249\243\175\130\200<\137\145\157=\198\030\238\220\014\237\156\014\237\240\222;w\251\210\179)\240\004\201\183/=k)\199\000{&\169\245\165\210\249\227\139n\172\020 \223B\250\002\219*\005-\b\249E7U\n\000\229\232\139\217R)H\246M\193\023\221P\201@\238\020/\149\149\173\177\247\250\135\129\005\240z\191vz\239\204\140_\204\031\005f\160\024\210\186\024\146:\197\011:\197\139\235\020/\142S\188\160S\188t8\197K\225\020/\232\020/\232\020/\232\020\175F\173\175\168\214WT\235\171\171\214WG\173\175\158Z_Q\173\175\133Z_\011\181\158\193\017\2068\132sF\2559\136Mq)\189\192\205\t\191<\221}Z\239\159\174V\155\253\129\127\188_\029W\241\248\195\238\233\248\219\250\184\223\220\030\254\031l\0014)"

let helvetica_afm () = "x\001\181}\219v\027I\174\229\187\191\130\1433k\141zx\191t?\185\171\202\238jU\149l\151$\150\231\141\146R6\143)\166\155TH\162\191~23\016\001`\003\145:/g\213j7s\003\153\137\000\016;\238\169?\0317\135\199w\245\254\241\247\234\241\176\189=\014\166\127\027\189\249\169~x\168\246\143\131\159\234\239\167\195\246\203\215\199\193\255\186\253\223\131\209j9\251?\237\191\139\238\223U\251\239j\216\253\187\024\188\189\171o\170\193\159\167\227c\245p\028\252\186\191\173\015\223\235\195\230\177\186\251\219`\240v\183\027|j\159s\028|\170\142\213\225\169A\249%\135j\243\184\173\247\131\159\027\237\191\015.\191\134\193\239\155\211`0\026\140\198\127\159,\255>\158to\200\250W\251\237\127B\245\235\207\131\233d8\155f\248\250\247p\220|\169\006\147\197p\190\026L\151\195\213\244M[\174?6\015\213\224_\213\238\169z\220\222n\222\188\011\187\029B\155\135\237\238\004\224\186\234\202\253{u\183\r\015o~}\220\236\182\183o\247_v\213`\248\230\215\227\187\237Ku\247a\251x\251up\191\217\029\1717?}\221\0286\183\143\213\225\207\234q\240\203\203c\181\191\171\238>\213\015\155}g\196?\255Y\191\012\206F\243\249\224l<\158\rF\195\225p\176\154\140\006o\174\026\189\195n\187\175>\212\199m\231\133\179F\200\240\229\215\237\237\183}u<\014f\1957\215\213\225\216\170\012\135\227\1915Ox\243G\221\152Z\253\143F);d\176=\0146\131\199\195\230\174z\216\028\190\r\234\251\193o\219}\253x\250^\1575J\187\193\219\247\131\205\254\238\255\214\135\193\182y\1921\220\028\183w\219\205a[\029\255\246\230\151\230Ew\219\253\151?o\191V\141\151;+\254|l\2127\135\187${\243\211\230\251\191\162\211\023\163\229\155\191\232\247l<y\243\246x\219\250\243\208\t~\174\210\213\217x\184x\243\231\227\221\191\214\131\197\188\253q\189\030,\151\205\143&\163\219x\164\140\158\140fo~\026L\198\131\127\012\214\127\r\198\139e\243\227\143\193\241\251\166\241\221?\006\255\028\012\233\191\127\180Z\019\173U\189\220\2386\015\157\218\170\213\025-\023\173\021Qw\026u'\179Y\167\251\159P7\142\188\217u\218\139\225`:\159\012\198\203\025\235\207\162\254l6\239\244\247\225\225\166\141\232\151}w\199x\217<\1276^\r\230K\210\159k\253\187z\183\219\028:\221\1660g\163\209\172Q\031\014\022\139YT_D\245\229r\213\169\127\175\014\183m\197\232\244W\141\254j\176\1565\234\195IT_F\245\249|\209\169o\030\154\027\142ML\186\027\166\211\230\134\217`>\021\230\175\2005\2271\0237\230]{\199l\210\021x4c\007M\135\228\160\206\171\141E\155C\181\223U\247\241\134\249\178\139\224`\188Z\r\022\147h\212t\228\220\193\239h<\030o\153\207\248\022\138\235\132\138\1899\182V\029\191\165rO\155j6\153\174\216(\138\240l9\141\175\216\133c\210m\252\223\020x6\140\014\157Nu.\2206L\179\233T\155$8\027M\023M\157jHj8\143\2183m\250\215\211\247\175\213>9s\220Dl\220X8i\157\215j\207\245\179\027\223o\235\187\244\240\161~\242\0022w\1839~\237T\207F\139.\174\227U\235\143E\212^\234\172\249Q\029\234X\190\168;k\254\151r`\186\210\186\245>\214\136\209p\212\2160\153\177\230l\1685\031\159\227C\199\243\214iMH\178\226\b\020\191\030\170*\007\175}\127\227\129\172<\214\202\247u\136\249\221pd[\023&\1729\001\205\237S\1975\161-\2134\215\155\217T\235\030\183/QuI\170K~,T\201c\245D1\155,\200\130\252T\168\141\021gez\174\240\194\002\170\250\150<;es\179\238\018\211lW\239u&\204F1\019f+\200\132\234a\171\212sV\166;\230C\157\237\187\182)\233\012Y\014F\141Z\1951\211UL\247\249H\171V\255\t\155]\170\025\029\2174)>YE\158\156\143\181\242\151\182\017\175\014\165GC\244\154\246\251\2165v\029q\180)4]5Y1\142\025<\167\2485Y\024\137u\019\253\220\150\173c\177\1349R\182\207g\154\197\222\146f\243\200y\147\007\169\210\207\231Z\237\159\145\163;\1811\019\214\156\194\182 \138\251\137\185\176\165\229\017\191v\169\021\127\142\001hk\205|!^\187\210\175\253%\170\181\005\1587\001Jj\011\n\210|4\234\212\222\177\218l9a5\n\208\130\162\255>y\251\172\171\210\211l\221b\172\173\251W,m\155M\243\169x-\180u\191\198fn\2125sKVK\213i8\236\212\254\029]\028c1\029\011E\136\197y|mW\218\185(\006T\164\223Xm6\225X,RsF|\250{T\1554j\139&U\179\026D\226\015\241RY\214\149\246\221\133l\022\023\147U\246\221r\168\011\241A\132\172e.z\222\018b\2411?\175)\149z\030\196\226S|^\219\214\207\151\156)\203\137~\237\1591\182\209\190y\219\202\167\231Mu\174\\r\194\207V\236\189\229L\191\246*\186\133\1587\021/\134\154q\029\249w\216\249O<\143\162\177\154\198\250\190\142\175m\221\178\018)\176\132N\197_Qm\213=M\168A\189\248,k-g\202\n\234\197\255\139\182M\186z\193O[\141t\030\2234=\241o\213#w4&m\169\231M\1632\140\254h\239\129\222\224MsK\127\187\186\154\184o\225\206\201xI\175iX+\191\134\1625\157\167\206\201\237v{\187=\220\134\007zQ\2115h\248n\186\228\134f\005mRh;\187\199\166\167\158z\171g\163\166yl\165g\212\243[\165\206\132\236\153q\241gM\015\162\169\210\141\t\1391\221\000\205S\236\2134\132\221\246\249f\147\182\"\146-\208\153\184\137\140\189\140\138#\206\143\213J\147\196m|\226\176S\1566u9=q4\132\158D\236\2444}\227Ns\197\029\181\182\019\162[\220X'\134\244\242\185x&D\243\158\243i<o\027\150\022\254m\176m\186\r\221\143\221\224~GwB\203\244%\191c<\030v\230\240K\160[\2415y\183\213\027\t\179g:\026\219\168\215\181\229\179\153\208\131\168\253\023eD;F\028\161\238B\187\247\027?s6\148\239^\234g\238J\239^ir}\224\178,\230\162\204#\b\214^\151\153\245 T5\007u\218\244\162\164&t\249\190\231\140j;\246mJ\177*\246\026\242C[\213iS\183X5\r\197\168<\007n\241&M\015\145\245f\218\143\212\243\031\199\228\155\203'B\007=uA\154J\215\016\201\162\161\174\021)B]\n\1314\184i\031\185\\u\157\200\168\185\212/\127\138M\001\245~Xm\165\169\251\153\147y1\020\143\027\015\245\227^\162\222\168{\222P\232\141\180\222)\2335i6\213\022\142\199Z\245GtO\247\200\185\212\155$wO3\0232\225\196>nC\132]\159nL\183\164\193\212|H\132\027c\180\154\210\148H\147\164i$\219\242\155}>3\173\255\130\212\173\160\030iG\181\143\219\221]\164\141\166\2030ZF\175L\198\177o<\154\195h3\014\246\239\234\231=\185\168c\244Y\199\232\185\236sH\224<\198nF>qL\222\228\237<kC\014\183\131\211f^'\210\204d\210U\247\217D\144^\238\252R\211x\223N+\165\174r\156Aj\018\164\1818\141\031Fsh0Ni\b\211\178\195\140\027\150\209\028z^\247\187\250\176MO\030Q\r\028r/w4\135\220>Vl\203\180kU\219\145\198X\220\000\237\197m84\003\248\219Sj [>m\254o\158M\167\\\031\173F\220r\029\183\221<[\231\211U\156T\152p\207k\180\128Y\1334\237\146\243\175\169\194m\1317iG\165\212\224\141\022@P_\194\182\185\225\161\230^B\211&\182\2449m_9\165\004I\029\233\244\170\246\174\206\186|W\227\218\246\174q34\226\187&\133\1878\131\221\219\160\159}\191\229\138?m*B\215\138u\138@b\247;\1698\022\138\016\190f\218,\245p\154\134q:\236\004\147\017\197b\001\177\187\219|\249\146Ftm\172g4l\205qXy\250i\254\203\189%u\174\245\172G[\131\170Cu\1518{\212\176\215\184i\210'#\n^\234C\207&\177N4\179B\155/\135\205\247X\148\174\1506>\159\138\238\239(\245\167'3\162\155f\218\183zL\250\221\211\155\232\180\205MT\159\014l\015\170\139\217\205\230H\169\216\022\168\233\144\183\019\\iff\180\156\249\185\152\239\026\207\227]mO\146\239\154\251w\137\190\228<\206\030\174D\155\189\\\020R\152o\243r8u\201\1879\231.\011v\187\237\247\227\246H\028\215\182\229\203\165\180n\00574Qz\252Z\135<7\024\251\198\171\021Oa\140R\023<\245\212\211\000?s\233\170\163\151\134-\154\209\246,U\202\021V\148\195\134fu\218^C#\029\143Z2\154\1466\180\241\155\219\240H\218M\212Z\245I7\150K\234\016\154\216\235\190\223U\177\157l\251$\221-cq\011\196\133[\143\179fv\169\241\207\164\029\159\166\006'u\162\147\246\195\230\246@\2208\138\211\n\147n\250(=|\169\213o\014U*l\147\136\141\181\147q[\216\017i\175\180\246]\253\184\185\205MM\219\166\207\155\254\232\184\181\158\2266\030\002/\222m\155J\149\226\220T\246\238\134\213D\220\000\236vH\237RC0\179\134\250\198\237\252\223,)C\172n\155\133\145f::>|\022\219\240\246\134!\169\227lh\216\127\217\028\194\195n\019\030S\167\162\245\255t\200!\027\015\193\255\245\151fB2vu\155\250\029_\209\205\137Em\240\255\237&\185\223\137\237xh\170\193\003\144a'Il8N]\144\172\255\150&o\218\017\239\140\187\220\227q2c\017\245\234\195\221}3-\151g\252\154\142\207\180\241\198\164\157\140\160fr<\129>\196ob\232\217\r\189\229D\2008\173I\228\185\011\214N\019\024\211\161x\248\020,\191\136\150Ob\215a5\159\t\221\020\166\249,\025\255\208t\156\194.[?#\235\185W0N\147\244i\161aS\r\196\240q9\229.\2528M\138'\194\191k\027\220\2271\182l\171Y7\2114\201}\171\241\020\135/\232\151\241\148;\002\2274{\157H\167f\237v,\222\146Bcr;k\217\169\167)\2364\133Q\147\217q\228\185\026\2420a<\003:k\218\181f%\175a\232X\153\230\1398\004m:\021\169\173=\1319\136_U\237\027M\186\145\232\188y\203H\169\231\150\153\201L\140oS\242\162\246\134\185C\140\217\019w\160v0u\143\006'\179\241\168\248\138\138kS\143Ay\254F\1516\205\227\152\210R\215\252n\251\180%b\165\004\238\150]\198\133\135\011\162\207O\030\175\\\221\183\192\242y\"\024o\200\174\228\135+WjS\242,\026<^\204\167\153\023\164\209\150\176^\012\185\140\223\211\128\180[d\018T\223\142M[2\146\131S\027,mVO\196rI\152\236E\025 \131\178\178\n\175\188\161\144\206\027\193\220\147y\156K\153\t^0/`'\245\1854%\180xz\183\136\216N\135\141xx\138I\241\1392?\207\190\163\241y.\191i\198i\197a\b\243\249\185\150S\175\018\131\213\174\192t\131\217fz\248l:\212\143\167\206\235m^\173O\019\128\029\131\207x\020e\236\023=\139l\253r\225\231\219-W\\1\251Vd\146\156\0062\251\169\205G\199\252\129\197]\208v\0069\209\158]\148(\156C\219MC\181\179\157\197\202\200\029\192\158\202\152g\190\209\156\017M%\200yp,\195O\130hyY\167h\016\247\000\165A\212\003\180y\166:i\197D\227\186\206\161\226\025\16823\136\030W\031+\164&h\203E\237Z\218n\182\004\030>]D_\238\234\031\213\254KZ\252\237\166{\198\166m\203K\024lw^\199@\015\2305*\012\210\148*\172\\\1752\021\028\248LL\166\021\019\025n\233\203\159\212V\200\014{j'\176Z\229\1901\151y\030\215\198\199\197H\221\170H\r)R\011K\127y]C'N^\224\192\196I\150_~\173\015\146\014\196\186\020\250\255B\020R\172va1sh9g\138\161\205KT\162*\241:\149\209\158\210hD${\236q\205\197\132\180i\016\132\217\162E0\164\151\018&\211\152L\021\160\177<\170kw$\028C7\247\016\1677\154aE;_\212e\229\196w\163`&\246b\177\023\162\006\178~\007$\235\138q \235\206\221~\211C\216=n\191\239N\201\142\180]e\238;E0o\185\0021\155nTehI\020m\158.h\206~sx\220nvw\219{Zhi\006g\237\164[\183\200\235\215\137\147\238!\202\158\208\176\208\218\136>AZ\205E\1312\213A\237?ko\232\182^\021\234\254/p\003su\169%P\246Kv)x\191\194\225w\238\145\225\r\1375DO\244\245\134{/\130\155W\160\n\186AT&\145\tif\1946\2439\019^u\252\175\162\141\025Q\027c\\(6Z5\227b\187\219J\251#/\016\028\234o\213^.\019\140f\195\184L0\244{V\135\234\203\246\2003\137}]\171\220<q\237\155\242>\n\172\127<\168S<\157wJ\024\158NMvh\218\190<a>ji\175%v\155\0039-\1538\138\025\153[$Q?\210:W)\003j\217\n\240\162\028f@n\143\248\209\220\022!\127%]1\237R\210\157M\227D\001m\018\226\141Eq\247X;K\182\240s\241\151\1994C\227w\196s\183NMGQ?Pn\2161\221R\236\151\204\023b\029\n\2222\025\197\240<*\142<k'\248\154\166tX\024\148\137Q\202t\152F)\243\242\024H\206v\173R\199\218\02297\028fX\220\211\200x\227\243\242\240\173\2264\236\155\141H\139\132\130\184\210J!\234\230\181pQ\200\179\201(\141\150&\229\254\139xx\185\225\205y.\1809\205\139}FY+\152\209\177V\228\014\184xx\185\187\158\155$\127\002\200\180v\169\156\216\127-\0236'\012G\169g\208<\031\209\168\182\218=\198\234\209\017K\147\180iY\016\221\242\152{\151rU\222\212\137\212\155z\174U_\170\153cn\170\221Dl\2214E\213M\169(h!\029\031xI\189[\248_\218\161~\246:\251\228\172\243y\187\178SdE;)]N\154L\209\"\131\1514\1811\159\216\004\206\171b<\155@\253\222Y\187\r\t\180\151\180\208\221\245M\027z<44I=\135Y\231\159\229hh\028\154;\226\138\252\018u\136=c\217K\171\021\145\031\015f\186\166c4*\210\204yq\208?/\023\2507\232\187\181\243\176\152\152yz\154\207\020t\2467\171,\195v\204\\~z\165\155\225\158\190Un\184mZ,\203}\026A\011\237F\176\182W3/\014=~\131\222\146\156\185\199\2326\137\243u\179\139}\230\184|\222T\n[QRs\217\206\148\2557\218\202\156\206H!\1753\224^\236\143\200\189H\152\221\200tcjK\031\235\164\218\"\198\147\175u\177+\225w\017SC\199i\249St\221\196v-\156\005\023\190\167z\021m'\247\183\1875\139\213\138\167\192{\198\183Y\027':z*b\166B\203@e\222\159R}\185k\154g\218R\223\180\225\211\209(\174-a\018\165\172\016#\215rBp?\138\203\252\250\244X\224g\247\1400\167\179\212a\189\219\222R27\235\169g\203&`M\011\179\152\143\011\211\176<\203\148\246U\023\251\194\134\164\1687'7\127\153q\014'?\143sF\254\140T-&\002\133\023\011U\229\147\153\023^\166\030\233\180\204\153%\162\245\024%w\236\216.\238\213\141\252i\228\183\162\229JS\165r\143\188\209\207\147*\252h\\ Hy,\220#\018\024\157\153:\140\154\191\185\211X\026\021\137L(\145H&o\213\193\1645c\167y\203\027)K\227\000\185\173\210\204\195\200Q\236\184\237\211Og\221\233\030\215\162\210\220D\169V\237E\235\\\026\218\231]\137\1659p\185E\017\205\223\213_\218\138\184\1753\229\180\155F\228\233\014\147\254\186\203&j@i\238I\221 \201\001o\160\182\1741\134\155\186\166\203z6\137\137?\155\249}\194/\134nE\027\176\132z\153[\024\026M\166\142\216\216N\012\228\028\021\211\149\165A\r\007\012s\136\246C\200-\178HYM\150\234~\243\164\2358\143\197\233(\211\185\021\rd7\161\191\024\023[\199_\002\157\250\226\195\141\191\236\239\196\169\200xL\242\188:\236\127\222<n\248\234\195f\219\244<\155\249\208\217\155\243\015\127\r\222\014\154gO\134\233wl\206\005\016\221$\001\234\1392\244^\254\142\141\182\000\164\239\024\190\144\191\241\165r\172$\208\156r\002\139\r\148\000T\131+pr\173@\226f\002\001D\142c\224\163\248}\217\004`\156/\200)\018\145\165d\252jp6\203\191\169\152\012\200b2\202\197d\140\138\201\128.&\227\169\152\140\016_\n\164\163}\190\190n&:\210\239\181\192?\015\186\147\202tA\198\011\132\237d0\b\151\005\012kp\195\026\156\176\006\012k(\1325\152\176\166\181c\129\196\242\230\235\167v\229\150~?\139\223'\249\155lg\128\173LXT\017\181\135\000(6\161P\143\018\138\149)\226\239\r\000\213\138P\183nE\217\133\001\\\187\220\170F\"\027\024\018@t\b\245CDB\140\019\193P\007\t\133\138\024\209\143\b\200*I\b\214\203\004\187\1493\nE\r%\000\170)\161^]%\145\173\176$\128ZK\168_uI\136\245\151`\172\196\004\235\154\028AQ\157#\176F\rY\177\t\193\218M\176S\197\163$`0\130\155]\161\156]\161\148]\193\205\174\208\151]\193\207.C\005\004k>\136\224\019\214\235g\004N\006\000\142 \212\018E\172\187\130(\b\000\151\017\nD\145P$\138\136\1917\000\016\005\161.QD\217\133\001\\\187\\\162 \145\r%\t \148\132\250\161$!\134\146` \nB\129(\"\250\017\001I\020\132 Q$\216%\138(\020DA\000\016\005\161\030Q\144\200\018\005\t\128(\b\245\137\130\132H\020\004#Q\016\172\137\"\130\130(\"\176F\rI\020\132 Q\016\236\016E\148\004\012Fp\179+\148\179+\148\178+\184\217\021\250\178+\248\217e\136\130`M\020\017|\194z\253\140\192\201\000@\020\132Z\162\016N\016l!Qp\158\020\001o(\017\146\135\016\190\247Q\160\017)r\185D(\\\248h\217t\151Z\164\220f\128\148B\026H\145\159\011R\003\019B\202\128s\164\b\136G\136>\186\168\164 \t#\015)\153KFBC0\146D\129\150\164\200\227&)\183\004%\165\192RR\228S\149\212@\190\1462$-)\211\204%$\130\190\004\186vu%\145I\024\217L\202\028J\019\226\224\1349\148\147<\188\146\228\1617\201C9\201\195\171I\030z\146\220P\159\148i\254\019\146'\151\179\158]\244\228\163\192\137Rd\1371#\130\022\025\003\167\179\000(Q\b\144\016\179\232\189\135\001\025\178\192\165\194,\190\240\176\146\177.\t\178\212f\007\203 7X\224g\006\2031/X\002\212\199\002 \190,\248\232`\146\244\024D\202\019\018\151\240\178\\\208\029c@v,\240\168\142\165\150\232X\0064\199\002\159\228X\142\020\199\018$8\150hz\203\184 \183\140\173\029=Il\012\"\173\177\196!\181\012\005'\132\161\148\174\1617]CO\186\134R\186\134W\2105\020\211\213\144\024K4\133e\252\201\225\150g\007;y\024P\023\011,q\197\178\n\214\"\000\220J(\240UB\145\172\"\254\222\000@S\132\186\028\021e\023\006p\237r\169\137D6\208$\128(\019\234\135\152\132\024_\130\129\139\b\005\"\138\232G\004$\005\017\130\252\147`\151|\162P0\015\001@;\132z\156C\"K8$\000\182!\212\167\026\018\"\207\016\140$C\176f\152\b\nz\137\192\0265$\177\016\130\172B\176C)Q\0180\024\193\205\174P\206\174P\202\174\224fW\232\203\174\224g\151\161\014\1305oD\240\t\235\2453\002'\003\000W\016j\137\130\172\019L\145\016pZ\130\129+2\140dA\130\247\022\001\186H\176\203\023$\188\176\136o\158K\025If\163\154$\016\214\004\251qMR\012l\194\1297\018\012\196A\240G\131H\234H\016rG\198]\242 \169`\143\132\000}$\216\227\143$\179\004\146$\192 \t\246)$I\145C\018\142$\146p\205\"\132\n\026!dmt$\145$\b\153$\225\014\149\144(\152\240\004?\241BO\226\133b\226\005?\241Bo\226\133B\226\025JI\184\230\020B\159\012\007<\027\228d\017\224\149\004[b!c\004\177$\004\028\152` \150\012#\177\144\224\189E\128X\018\236\018\011\t/,\226\155\231\018K\146\217\248&\t\1967\193~|\147\020\227\155p \150\004\003\177\016\252\209 \146X\018\132\196\146q\151XH*\136%!@,\t\246\136%\201,\177$\t\016K\130}bIR$\150\132#\177$\\\019\011\161\130X\bY\027\029I,\tBbI\184C,$\n&<\193O\188\208\147x\161\152x\193O\188\208\155x\161\144x\134X\018\174\137\133\208'\195\001\207\0069Y\004\136%\193\150X\186\151\nZ\137\215\224\188\b\002\165\016\136\132\210\193\239\241\026\200$\130.\149t\162\011\188\246\012rI$Jl$#\014q\140\160\031\197(\195\024F\020\168#\130@\028\029\248\017\174%iD\000)\131P\1510:\153\160\139x\rd\017A\143*\162\196\018E\196\129&\"\232\147D\148!ED\020\t\"\162\154\030\186+A\014\221\245\026\228\146\024\"\128\180\016Q\135\020:A\000\215\007/\133B1\133B!\133\130\151B\161'\133\130\155B\134\004\"\170)\160\187z\130\186\250\012\215'\188\134\170\031A[\241c\186\138\154O\000\184\137P\168\251\t\197\202\031\241\247\006\128\234O\168[\255\163\236\194\000\174].\005\144\200\006\144\004\016AB\253\016\146\016cH0\240\000\161@\004\241\242#\002\146\n\bA.H\176K\006Q(\216\128\000\160\003B=> \145%\004\018\000#\016\234S\002\t\145\019\bFR X\179B\004\005-D`\141\026\146\024\bAf \216\161\134(\t\024\140\224fW(gW(eWp\179+\244eW\240\179\203P\004\193\154#\"\248\132\245\250\025\129\147\001\128'\b5D\241\2076\199F\249wvu\002\164\143\024\149\174O\024y\134\001\237\020\198\147?\024I\174`$z!_\199\191\249p6N\215\244w\026\018\240SR\152\164\235\164\144\128X.\208\138 \170\198j\n\170\0174\170D\144\168L0\168\255<x\155\221\254s\218\137$\000bQ\006\164\239\0255!\2529\205X\t \249\152\145\228cF\162\143\249\154\136-\003\\W\127n\171i\198\155\026\186\202\191\169\020\012\176y\025#\247\228\135%\191$ :W8\135\000\240\016\161\224&B=_\145\200:\140\004\2245B\209u\004\163\255\b\214N$\016<\025\209k,\240\0265\132c\t\000\239\018j]\172rV\191\1978\187;\b)\157\029\001tvD\209\217\017u\157\029E\142\179\163\000\157\029Q\227\236\b\027gG\024\156\029Atv\135^c\129\215\168!\157\029\001tvD\029gw\002tv\007\130\179\223\181~^\230\223\244\002\006\200\187\012H\1992\202&0F\238d y\146\145\228DF\162\255\248\154\\\151\129Mn\140\223\165O\178\t\128\172e\192\233u\188\019\159\232\016\152\238k\188\203g\190\005\002\157\136w\244Q,qM\214f\128\"0\202\000\183\203\239\210\167\252\004\160\251\184\239\212\231\218\004jZ\254w\242\164\171\000uO\224]>8)\016h\226\223\rj\249\027-\172]\131j\199\160\026\223]\187\029\144w\249\139\019\002\209\157\218w\233L\029\003)\135\217\175\135\166\238\204\210\239\196\019\025 \191\n@vh\t\254w[\019\168\181\254w\174\t\012Pn1 }\193(\251\1301\242\005\003\169\204\140\16480\018s\139\175\201\t\025\216\200\223h\237\006\173\221\184\214n\028k7h\237\198X\1871\214n\192\218\rZ\171\251\031\255\198\142\199\191\219\030qV\014X\156\224Z\031\028\235\003Z\015\029_\198M\169\130)UP\165:o\199\132\179\252[\147\207\185\030\t2j\184\230<\143\255\024p\1354\231<\234c\132\234\006\003\154r\206\007\220\206\156g\134a \213\004\006l;y.\025F`\2040\012\234&\243\156\025\134\017h(\207[\134\225\223ha\237\026T;\006\213\248n`\024\198\141M\137a\024\208-\244\185\024\159\157\227\208\236\220\029\149\157;\003\178s\028\139\157\023\134a\231f\004vn\006_\2310\238:o\007T9\234'\204\198\147\205;Iz\023\005\024\030\163d^~+\133W^\tY\175d~\005P*X\023\148\016\170\133\146A\r\1452\017r\005CV*\025T!-s\146W)\216<\214b[\199\148\028R^\2010\203\149\016+\161\020\214\005\184\199\t\245k\005\173\251\011Z\247\020\164P\141\149J_Y\177r+\025\212s)\019U^\193P\251\149\204#\002\165`9A\137\129\030\148\204g\n\165\130\164\161\132\200\031J\168\169D\138N~M9\2450\131\229\154\223\186\201\197Q\190H\243\138\002QS\138\025\191\150\023\235<J\249\173\155s\155\230\1394\007\196\136\152\238\201\160\254k\t(H\232<\161\167\236\144\223rq\0250\145\252\141O\015\1424\130\165uO\015j\225\181AD\225\249\180\221T#\232\006{\218NKJ\014\017R\244J>\179\166K\141\2541g\214\146 \250B:\137\016tR\130]'\229\233\t@\132\147\242\252D.\149\158\160@\216qR\148\148\156$\164\232\164(:a\169\209I\132:N\018\133V\174\146\184q\152\018\250n\019\232u\001\151.\020\176r\164\196\141;\165\208s\170\144\023]\139:\198\193\154\160<\191\025g\251\004\149\196\177\145\144\206&\004\221\156`\215\193Qxm\016\225\212\bHw\018\130\142$\216qa\148\148\156'\164\232\182(:a\169\209U\132\026']\136\017\241\005\142\136/pD|\225\142\136/\156\017\241\005\142\136/\204\136\248\194\140\136/`D|\129#\226\1396\154\211\252[w\211. \130\025\190\206m\214E\027\181\\\242\191\006g\243\244\251s\142\230E\014\027\003\\\188\140\209`7\191$\rv\019\016\159!\156K\000x\152Pp3\161\158\175Id\029N\002\240:\161\232z\130\209\255\004\235 l\"\b\145\200-\163.0\198\196k\023\181LD'\183\138\019\005\1368\229fr\161\001\136\152i$\181\000b\167\023`\018*\156/\162(Q\b\165\020A<\165\200\011\170\148\219\200J)\132W\1380\198R\134\129\1502\029m)\129\144\2353\138\142\1590\248\197\019\138\142\130H\003}DobQ\145\016\250\224\222\194A!5\252c{\142\020\146DH0S\242cD\1580\006Y\194\002\200\017\022x\025\194R\155\031,\131\236`\001\230\006K03X\162\243\130q\200\ny\132\203x\0043\162p\128\203\136E6\2003M\019\196D&\200sN\011\131A\022x\167\156\140\0122 \227\024\255\232u\017|\002 \242\132B\216\t\245bN\"\027p\018@\180\t\197P\019\140q&X\007\153@\136p>\030\163\011\140\177\245\014\199h\153\136j>J2Q\128\136g>[\178\208\000D\210\156,\209\002\136a\0041\128j\024.\226\168q\b\167\022BT\181\208\011\174\214\1761\214r\b\181\022b\196\181\020\003\175\165:\254Z\006i\160\132\151\005\239aR\128\208\203\r\165\"RD\225\"S\020.\018F\225\"o4\014\233\163\1336\139\148\028\146I\2010\167((\"\155\018\002y\148`\200\160\004{\185\147d6k\146\004\242%\193\152)\t\199\028I\184\206\142\132B^\240\025\024(;\230\130{\002\006\132\"\254|Ld\162\017\017s>8\178\000\004\226l\143\141\128\004bK(F5\014\163DP\t\128\152\018\n!%\212\139(\137l@I\000\241$\020\195I0F\147`\029L\002!\150y\200\172\011\140\145\244\006\204Z&\226\152\135\203\019\005\136(\230\241\243B\003\016C3z\214\002\136`\0041\128\177\188\"\128\004@\000\t\133\000\018\234\005\144D6\128$\128\000\018\138\001$\024\003H\176\014 \129\016\192\188\237S\023\024\003\232m\250\2122\017\192\188Er\162\000\017\192\188gr\161\001\b\160\2171\169\005\016\192\bB\000?\180\177K\219S?\228\184\t\132b&\016\181y\144a1\011\195`\218>\200H\222'\200P\222(\200\016\237\020d\128\226\194\200F\148a\163\215]>\228\181|\006\156\213\151\015r-\1591\189\206\242\129\215\242\025\129\165\161\015i-\159\175\245\162\201\135\188\171e\153\000^\023\248\144\215\206\024\160\244\018\128]H\252 \151\198\004\198\235a\012\234u\196\015\188\242\197\b\236\212\249\208\174q\241o\180\176v\r\170\029\131j|w\237.\\~\224\021*F\244\018\229\135\188\022\149\129\188\171\133\252\250Q\236{\253\136\251^?\186\251^?:\251^?\226\190\215\143\133}\175\031\205\190\215\143f\223\235G\216\247\250\169]I\030\231\223\154)?\2335cF\r\019~\202\171\195\012\184\2516>\241:0#\228Y\0064\239}j)o\146\127\235MV\159\128\2322|\149\019\254S\246=\003N\r\252$}\207\152\174\129\159\208\247\140C\205\252\196\190gD\213\204O\130\135?\t\n\254\212\146m\198?\235l\255$)6aQED\146\000\b'\161^LId\003K\002\136.\161~\136I\136q&\024\130M(D<O@N4\000\177\247& \181Ld\001\001\144\n\132z\249@\"\155\020$\128\204 \212O\015\018b\142\016\140\137B\176\206\022\156Q\253\1323\170\159\242\004\170\214\192\0122\019\168I\016\189+\210\136\000H#B\1894\"\145M#\018@\026\017\234\167\017\t1\141\b\1344\"\020\210(/^N4\000i\228-]j\153H#\002 \141\b\245\210\136D6\141H\000iD\168\159F$\1964\"\024\211\136`\157Fy)VG}\141E\254\140\026\152Ff\0296\011\244>\165\177\007cJ\149\246)\185\nNz9\251\148\\Y!\213\188}J\174\016\211\206\217\167\228\201d\n:k\194\190\204MG\001\202\164\1480\166\166\148\185\t*\021\1564\149bLV)+\164\172T1\137+\133&}\165\016\146X/\140{\153\183\246\157\246\217\2156\201\237\175\138\147\248O8-\244'\158\022\250S\173Ei\016U\213\193\n\r\026U}\024\ba\163.\n\129\183\b\017\220v)Ga\151f\020viFa\151\254(\236\210\027\133]\154Q\216\165\029\133]\218Q\216%\142\194.\205(\236\178%\155i\254\173k\193\165\166\021FM\190_f\002a\192\205\236K\166\nF\244\222\181\203L\n\025\216H\1317\198\183i\1728\207\128\239\218\141\231\218\141qm\030.\242\243\172g7\232\2174`\2047\221\214;\193\136\151y\000\153\001\245\210\202\148\170\130s\169\151z\012)`\175Xr\020)P*l6\1782e\173lY\191\158\190\127\173\246\188\251\226\178\029Y\178\1846\166\215\190\161\181ghm\252\015\195K!0\198\166\241\165\208\1930\228\001fV9\168\011c\252\193\248\253\224\030\005\190\028\028\171\135-F9H\133`\030\030|\207\004\2073\193x&\148<\019\140g\130\rc\192\148}\150\023'ua\012\023\027e\210;\242\241\192\172\165\207\007\"\140\012\232\156\016D\153\227\022}F\016a\195\138pJ\016qp\137>'\b\176`J\221\199\007\212\227L\211\199\007\001\176\167\219\199\007!\242\168\238\227\003\n\140\026\209\141)\226\198\015\029\018,\161=\145\219\020#\183\241#gH\151\224B\2246n\224\144\131S/AUQ\213u\128\007X\187*\223#\134\156\019\\vIUt\137\203\213$\002\194&\212wVUp\150\225\239\b\215F\177\246\011[\247\148\170.\150\170\246\003]bw\146\250%3<O\176\027o\195\248\017>X\196/\238\193\143m\161\021\136B\167)\136\130`T\131\255\214\208\227\228Ptr\240\157\028z\157\028|'\135B\250\004\183\174=\027\228d\017\191\168^[\"|\171Z\020\137\155\167I\161i]\164\208\247\173\212\240<,\229\198\207Rh[\029)\181n\149Rt\174\148\153vHO\018L=\024\219\164\210$\129\171\224\180O\206$\129++\180U\222$\129+\196v\203\153$\240d\155\130{6}\201b\2183){5W6\175\228\202\166/Wl;'\133\189\169\178\233I\021\211\242\169Q\172\230%;\192u\031Y*A\213\231Y\219.*\225k\174\173^q\173\223RJ\005l/\165\172\207\245U\175\235m\011*\132u\225\166\186\207Q\245\171\190\168_\241E\221\151f\197VV\234\244\249\195\182\184R\216\147m\182\245\021\194C\t\239s\213\161/\167J\173\178@\189\182Y\136C\225\182\208gSx5|\225\149\240\133\190\240\133\255F\248B_\248Bo:\135\030&y.\224\167\018\222\231&\219\210_\137O\156\\\225\215M\174\240\195&W\003\239\155&W\206\231L\174\240K&W\230#&W\230\251%W\240\233\146+\252j\201\021l\193\184\194\221\023W\249T\003\000P0}\170\001P\175\136\230T\003\b\160\176p\170\001`,\246F\158j\000\016\028\224\157\015\184r\207\007\\\233\243\001\030\nNq\206\007x\"\207=\254\249\000O\n\142\242\206\007x2t\153=\031\224I\192y\197\205\243W\229\205\243Wr\243\188\197\192\133f\243\188\021x\238\2436\207[\025\184\206n\158\183\018t\027n\158\1838\184\172\176\215\252\170\180\215\252*\2395\007\000\028\165\247\154\003\234\185\200\2365\007\0018\007\246\154\003\140nQ{\205\001\004\135x\187\182\175\220]\219W\184k\219\199\1931\238\174m_\232\185\169\180k\219\151\131\211\252]\219\190\020]\232\237\218\246e\224\208\158\r\204W}\027\152\175x\0033\"\224R\216\192\140\176\231F\187\129\025%\224:\220\192\1408\186Ko`F\020\\\228\238\000\190\242w\000\167\021\200\183\022\001\183$\024\220\146`\207-If\221\146$\224\150\004\163[\018\142nI\184vKB\193-\004\131[\bE\183tO|\139\215\224\146\b\130C\"\232\185#J\1723\"\014\174\136 :\"\162\232\134\136j'D\012\\\208\129\224\128\014\131\226_\139/\172]\227\023\214\174\241\011k\215\003\239\011k\215\206\023\214\174\241\011k\215\230\011k\215\230\011k\215\240\133\181k\252\194\218u\251\237\220l\249{\029\143k\248bn\134/\228o\029\216kw\174\229\218\153`\185\198Y\149\235\194T\202\181\153?\185\198I\147k\156)\185\030\240\151\240\174\243\148\b\003TP\006\164\209\140\154\237\201\215y\142\131\129d\028#)\n\140\196(\2405Y\155\001\026\165M\249\154\166'f\004\200\144U\152Ti\238A\000^RUNR\201y\005\0061\211*\147i\149\201\1804S\144\129Z\254F\147k\215\194\218\177\176Fc`\132\207\18412\r\229\025\192\236\2311{r\180\0243\231h\004\017\169\128\185\020\220\212\tN\234\004L\029\024\2362nR*\152\148\n*\165\214-\235\204\242o\189=e\157Y\135\001g\015\244Z\178\014cz\015\244\154Y\135\017\216\127\189N\172\195\215z\243\243Zl\244Z\227\238\174\181\187\165k\237\236\227Z\227\230\173ua\199\214\218l\211Z\227\222\1725n\200Z\139]\250k\220\165\191\198]\250kw\151\254\218\217\165\191\198]\250k\179K\127mv\233\175a\151\254\026w\233\175\019c,\211u\14974\173\241\211\147k\252\244\228\218\253\244\228\218\249\244\228\218\251\244\228\026?=\1856\159\158\\\155OO\1743a\228\"\212BX\163\201\181ka\237XX\1631\254\183(\215\230[\148k\252\022\229\026\191E\185\206\132\145\253\028\1320\160\209\1935:8F\0074:\020\140\014\198\232`<\171\191\247\180ng\176rV\159\176\182\157L\189\250\220-D\141\242E\154\231b$-91\162f\005\025\022S\129\012\166\249?F\2422\018Cy\026\143!\154\187c \173\018e\164\161\149\229,\253NMN\006T\147\147Q\209\228d,59\025\128&'\227\185\201\201Hjr2\144\154\156\004lx2\2533/\2140\162\187&\159aY\134\245\236\151c>\243\002\012#\208\148|\022K-\172D\158e y6#\212$\206\249:vP\178\130\210\174L\177\242\242\136@\220rU^\185\212\234\007\163\166\180\149)meK\139K\026\159\007[\145\250[]?\026\000\142\224}\238\150=\242\189\181)j\237\023\172\246\nV\155\"\224\250\005\011r%a(-U0b\002\151{8\025\017=\156\028\206 kQ0\021>\248\213;x\213;\152\234\141s\250,\176\245>\216z\031\160\222\231\137gD\208l=\245\140\176[$3\249\140\018,\028L?#nJ\163&\160\017E>\203\007u\018y\232\131:\128z\244f\014\234\128\000\136\206=\168\003B\164<}P\007P \191\136J\222 \004+\017\193\192\133\132\186\245\139dN%#\t\2144\130\1451\b6\180A80%\161z8\2479-\029\168:\166\214\019\224\001\214\174\202\247\136\161\209\004\151]R\021]\226\178*\137|oU\190\183\170\130\183\012\211FX\208-\001\192\185\132\"\241F\1846\207\171}_\213=N\169\139N\169\253\146\151h\153\164\190_\012?\019\140$\173W\149\000v\232:\n\130a\138\2243`\232\161\186P\164\186\224S]\137\204IZ \194P B\228v\185\004\228\128X>\179\b\228H\220\194{\203@\142\016]`\023\130\028\145)*.\0059\002d\254,\017\228\207\024\240?\011\188&\128\165\182\021`\0254\004,\240\219\002\150cs\192\018h\017X\000\141B\022H^d\016+7K\160u`\129[\241Y\236\212}\022b\245g\t\214q\150\024\250c\017\180\023,\128&C\172\254\169\170\142\171\130\246I\174\177U\209k\166\005\017\146^\183U}ns\155\018\150\022\157Z\021\157Z\149\157j\154\149,\017-\011c\208\184\176\000\219\151,\169\189g\215E\151\214\253\142\171\251\028W\023]SjqX\193\012\bX\132\r\015K\176\2371\203\203V\226\180@Y\022<\210\nE\158\014\253l\028\250\2168\020\217\184\212&\177B\153\174C\153\174\161q\218\180\127\245l\156~?\139\223\252\201\213\r~mu\227|h\149(M<-\002\207\b\156\240\022|8\161\246\r\145\026\197\027\"\240\140\192\to\1937\016j\223 \002)^#\208g\023=\185O\192\183J\145}uF\196\1393\246\236`'\231^|%\011\236\011c\226\137\183E\224\025\129\019\222\130/!\212\190\129\242S\188\130\144g\131\156\204]\248\150\004\219\215\240\223\248\029k\228\217 's\023\190\198\254\141\223$I\127Gt,\175\159\225\250\004\250\248x\252;\162\t\207\127\128p\172\128g\004Nx\011\190\192\252\001B\018\2204\255\165\015\158\220\192\146\239\205`\151\223\211\252\214MK\003\168\245R\134\245Z\195\r\174\025\223\136?\135s\131\127\014\231\198\253s87\206\159\195\185\193?\135sS\248s87\230\207\225\220\152?\135s\003\127\014\231F\184\252F\204(\223\224\140\242\1413\163|\203\127\026\139\174\191\t\2177\207k\183z\188<\147\2247\212\242\159\160\207;\205$\248\r\181\nO\208'\168\2433\b\254f5\253\231t\141\231\241\251\230\150\215\192\226#\241+\223C#\004\tzD\012\027\019\240\1483Y\214\138j\240\"\240\147\192!~\149\019\191\202\011F\005\195V\133\n#\176q#\224\0055N\168\129\134\153\214.\t\188@Wp$J\161\194\186|\166G?\236\0055N\168\129\214\153\019>Y`\246Bfc\236^HG$\141\245\154W\137\190\184\186'W\215\020\192mt\147\212\012Df\128c\td+=\193\135<;\015~q\244N\142\030\218\237\181\220Y\150\135%hv\022\024\187\179D\026\158\193g\239\225/\158\230\201\2114\198\179\196Z\175v@&\251\244\014H\141\n\139\177\139B\192\011j\156P\003-4}\150$\208{\229\146!\176W\014`a\160\233\224$\228\197\232\156\140\014\026i\187<I\162\183\174%s`\235\026\192\194J\211?J\200\139\2099\025\029\180\210\246\152Hr?\224?\150w\159\167<\024\208\127\206\252^\207p0j\1862\247y>\131\001X?\190\231\233\011F\212\250\241}\158\172\200\000y3_7Y\188\171\142\199v\248\189$H\170WX \216\127p\239\238?\184w\246\031\220{\251\015\238q\255\193\189\217\127po\246\031\220\139\237\006\247\184\221\224\222\221np\239l7\184\199\237\006\247\133\237\006\247f\187\193=n7\184\199\237\006\247\248w\019\239\161\1950Wp\196\168\127\241\165;r\148\127\167\017y\006\2104\016\003\2348\017\1931\241\014\006\128\199\017\n\207L\168\247`<\027\229\193\240\018\247d\148+s^(\255.\138\249\147(\222_C\2496\224\138\251-g0\003d\128\000l'\253\155\204`\129q\0063\168{\238\2238\131\025\129\030\250\1836\131\2497ZX\187\006\213\142A5\190\187vG\r\2238\131\025\209#\155o9\131\019\000\231*]\024,\247NU\2502\167\128\1333\149\190\216\198\193;Q\233\202\208\019\238\137JOX\023\224\030'\212\175\021\180\238/h\221S\144B\168\221\211\146\174\016\018\192;,I\178\135n\1780\255\214\181\251\001\166\0063*f\0043\166?p\250`\230\2552\014\0318}\016\179}\025Q\0318}\232N\251\205\210\239dc\006\1325\017\219\139B\237\177P{\183P{\167P{,\212\190P\168\189)\212\222\020j\015\133\146\243J{Q\192=\022p\239\021\144\023\027\135\n\128\162zK\141Zd\011\r\011\141\026\245\139\143\203\140\026FG\232EF\005\n\151\228\225\167.2:\199\012?\147\128\191w1T\000x\200\251\218\133\022Y\015\193\183.4\234{\b\190t\0010zH\127\232B\129\194C\252\153\011Ud\244\144\025\002g\001\156:\030:0z\171x\230\216Sp<\231\1578\246d\005/z\231\141]\161\241\168s\220\216\017I\239\194ac\199i\198\211\254Q\227$\142\196+<M\000\248\152P\207\187$\178~%\001x\148P\223\151$D/\018\140\254#X{\014'}\247y\142W\023\025\253d\230xIP\195\188n\141S\178u\251\178\172\252,~\243x\160\022}\202\026\251\148\181\211\167\172\2134\218T\129\248\254\204R\233\197y\026M\003/\248\244\147\001\192\176\210\162Q]<\180[\151\015\237\214z\162*\217\166'\170\028\244\197}\237\201G\161\000\189\171C5NTM\017\199\018\200\137\170d\169\156\1682\216\139\243\178\147\135\129\221=KL\181w\216\181v\015\187\214y\170'\025\150\167z4\240\130O?\025\000\012,-O\213='G\235\190\147\163Z(LV\248s\001\127)\024p*\225P\028-\180\165r\015{\214\254a\207\154'\176\146\173<\129\005\200\139y\197\201\"`kq\205\142:\216\141\129\179\153\002\232\001\128\166\131>\026U\167}\180\136_\b\130t\238G\163\249\240\143\134\243\t \r\2111 \r\166\179@\n\189A\224\214\000n\129i\249\198\160\180\028\131x\012\245J\129w\168u\215\020q\243\136\168yu\229\026T\185\006U\229\bT\165\b\168?\135\161%nl*?6\149\031\155{\004L\160\190\184\185\164\166Z@\246\021\129\173\001\\\159m\203\222\217\150\188\179u}\176\245}\176\245}\240_\b\024\141o=\165\221\025\192-\220\174\239\017\233\175\132(\244\001\001S\158\189\251\166\189\155z\251\158\247\239\221\186X\027\192}]]\142Z]\138Z\237F\r\255\172\138\022\250!\173]\215\213n\129\190\027\128\200]\019\193\127P\237`\000\215\017\007\215\239\135\030\191\027\191\028\221\007\031\221\007\031\011\228v\236y\161\005z\148\131\001\\\235B9\254\161\020\255\224\198?\244\197?\248\241\015~\149\014^\147\243\148\247\023\018\240\140\000\239\151%\224\132\026\169\193\006\148\011\170\005?\208\134\031\174\015\127\184\017\254\2250\191\247w\177j\247\239b\213y\1764R\247># \250)\184e\166v\183\204\212\165-3\223\243\138\208\140\174\243\194E\002NB\025\030\251\221{b\188\191\176?BJ}\017m\182\160\005\018\253\024\146M\133lW\221?\138_g\179\005\203\226Mwy\231\134\004SO\193H\164i\246a\007\239\150L.V\146\178\196\145\168jl\228G\023,\190\232X|\145 \029G\246\138\017\209\223TA\014\221>\239\252[OI\028r\015\150\001gz\226\1606qgLOJ\028\184\183\202\b\2046\028\242\014\237|\1576\200& n\222\153\240e\151\232\179t\189\029P\165:\164\206\r_\011\203\025\204\1343\020\237\230k2\155\001\178:\003\242\167t~Fw\226'X\181\243o\136\204\147\175\031\006\227\244s/~\198g\241u\204\023q-\158\205hti\190\254\206\222L4\145\221\201{\141\179\206\227`\154\127\202\231g4\176\217\001\n\027\188\016\004\027\130\000!\208-\018\195\024\153\128\145\137\237O\190|\226b\156\196\207h%_g\131\018\020\021DE!\000j\011\161Pe\b\245\234\r\137l\229!\001\212 B\177\026\017\140u\137`]\161\b\132Z\149&\194d\160\213\228\216L\129\\\201\232Z\135\153@'\214$1\001'\\G\157@\1361\161\016\232\180\017\017\174\189\186\021E;\188\246\138\176\235\185_W\208\br-\141\215{\188\214\245\149@]i\019\232\212\\\018\233\234K\211\149\0166\172\200\017\181\1819\226\\y\233\218\171\215i\225I\0239x~\011\197\208\135B\232\131\023z\191\214\235%'@\221\180\208$\144fr\181\011Nx\1739\001'i\019\206\127\191@\003@\012\250\175\023\000\234\017\131\253\227\005Z\000\196\000\127\186\000`$\006\253\151\0114\b\196 \255p\193\0040E\012\017db\160k\157\029\004:\217A\018\147\029\132\235\236 \0162\128P\200\128\180\191\024\174\189\138\029E;\188\246\138\176\235\185_\019C\004\153\024\226\245\030\17551\016\168\137!\129\0141\144H\019\003m\184\133\176!1\224_\r\208\218\\\251\233\218#\134\180\222\170\139\028<\191\133b\232C!\244\193\011\189O\012z\165\021P7-41\164eV\237\130\019^kb\1925\214\140\011GIz\1440\146\132\148!UH\153K\024R\193\161\r)F\242\1442C!Rh\136D\n\129N\164\bIE\200 \235\148D\019\140\016\t\154\145(d\156\020yy'\2296\251\164\020rP\1380\219\164\012sN\200\n\168K+\002\219\249h\185\224\187W\159\bt%D\130\180\004\186\247Q 0)\002\026S\"\143\204\164\002P\154\016}w\147\198\208\155\1449$'\164\130\207$\234\018\158\218>\225\185.\148#\018^I\197\208\155\138\161\156\138\005Rt6N\184\178\158d\005\154T\187&<W\158|\020\136\211\2212AR<\214`\1423t+\193IY\141T\146\130\238\007kT\220\235\157U9\186gU\142\249hJ\190\215=\142t\196?\232\136\184|\130\229\187\172\237d\181'\019O\203\249\173\1436\197\171K\188\214sK\tt\166\142\162\232\026\174\215y\198.^\127n\166\239\2135\181n\026\228\150I\225iB0\206\246M\140(\2264{\248\2126\168D\tO\185\021e\128\154N\006\212~\205\140\138M\154\025K;33\144\247Zf$o&\205\b\157\203\203\215i\155e\002(\176\203d\189\148Uh}\222a\203\128g}\229X\1756\208f\016\139T\153\"U\166H\181\252\141\022\214\174A\181cP\141\239\198\221\173\02576\229}\172\025@\175\194\151\255\158\007\\w\158\185k\149\129\212\159\202\128\234De\212\236Lz\230\238R\006r\031)#\185c\148\017\234\r\229\235\212\005J\000%\197<Y\207\221\163g\254ZD\006\244\246\250g\2486DFM\191\239Y\127\t\"\131\186\007\248\204I\193\b\244\245\158\187\1750\228\223ha\237\026T;\006\213\248\238\218\221\165\246,\190\167\144\145\244\025\133\012\232\142\229sN\nr\235\1398\246\242\130\199^^\240\216\203\139{\236\229\1979\246\242\226\029{y\193c//\230\216\203\1399\246r\234\184,\255Nu-\003\137\2032\224\236=?).\203\152\222e~\018\\\150\017\216\024\127\202\\\150\175\245\150\241Sn\164\134\t\144\194\n\205\135\227\002'\247\140\192\2019\024p\242N\003\156\240\b\192\201\236\251?\153\205\254'\177\195\255\132\219\250O\238^\254\147\179\129\255\132\187\246O\133\173\250'\179?\255\132\155\242O\184\019\255\196\r|\242k\158p\030k\000\236\215\019\206\128zE3\019\206 \128B\194\1323\192\232j5\225\012 \148Xw\217t\169\141Z\229\150\026\147+\161\197RW\165R{\185F\018\215\031\149\239\143\202\247Gm\000\1838u\217\240\186dx\237\154WHL\018\250\182c\138\018\234F\205$k6O\228+cPZ\022@\214\178\192\243\004K\1733X\006\254`\001\150\154%\0244\150\232<f\028\156bNb\027\183x\202U\201-\152\214B\208\231\150\170\199-^~\179\176\228\179\170\232\179\170\232\179\218\195J%\173{\011T\247\020\168.\217\\H}\150\023\203\132\021\128\005\165pc5\2481\224\254\221\015\238\195e \245\225\024\176=\208\031\170\015\199\152\232\195ePwK\127\136>\\F\160[\250\163\235\195\229\223ha\237\026T;\006\213\248n\236\195e\220\216\148\251p\025\208=\227\031\185\r\000\000\172\213m\000\162NAL\027\128\002\235c\221\006\000\138%\1316@\195\181\001\220\226\212e\195\235\146\225\181k^! \208\006\000\012\161\209m@B\163\199-\000\005\"\020\226\147P\167\152$\178\197L\002\027\031\146\128\003\b\1972\018\140\241\137pm\000\1838u\217\240\186dx\237\154W\136\015\t}\2191>\132B|\216O>\b\005\019\018\136\149\1488\197\022b[t)\180q\019Rp\142\144\160\015\132\bc\200\162\218\005\139E\174\251\011V\247\021\172.\154^\136\173P(\151\rc,$\028\231_\246w\231\213a\255a\179=\028\211\197\207\155\199M\251\251]\189\127\252\189z<lo\143\255\031\188CKx"

let helvetica_bold_afm () = "x\001\181}]w\219F\178\237\187\127\005\031\239]\235j.\t~\207<%\1773\147\216\019\217\142@Y\243FK\148\204cJtHA\018\252\235\015\128\174\207\221\005\250\188\156\149\021/p\239&\208]]\189\187\187\186@\253\249\184><\254\186\127x\252\247\230\241\176\189>\014&\127\027\189\250e\127\127\191yx\028\252\178\255V\031\182w_\030\007\255\231\250\255\014F\203\197\244\255\181\255\206\187\127\151\237\191\203a\247\239|\240\211\205\254\243f\240g}|\220\220\031\007\191=\\\239\015\223\246\135\245\227\230\230o\131\193O\187\221\224c{\159\227\224\227\230\1849<5\168>\228\176Y?n\247\015\131\215M\233\191\015.\190T\131\127\175\235\193`4\024\021\127\159\140\255>-\186'H\249\242a\251W\181\249\237\245`2\030N\011\129W\255\174\142\235\187\205`<\031\205\150\131\201b\180\156\188j\219\245\199\250~3\248\215f\247\180y\220^\175\207~\222\239n^\253Z\237v\030\031$|}\191\221\213\158yu\185\233,\208\021\248\237q\189\219^\255\244p\183\219\012\134\175~;\254\186}\217\220\188\223>^\127\025\220\174w\199\205\171_\190\172\015\235\235\199\205\225\207\205\227\224\205\203\227\230\225fs\243q\127\191~\232*\243\243\207\251\151\193\217h>\028\156\021\197b0\026\014\199\131\229\172\024\188*\155r\135\221\246a\243~\127\220v\2148kH\133/\190l\175\191>l\142\199\193t\248j\1819\028\219\"\195a\241\183aS\234\143}S\209\205\255jo\169\161\182\199\193z\240xX\223l\238\215\135\175\131\253\237\224\221\246a\255X\127\219\1565\133v\131\159\2549X?\220\252\255\253a\176mnp\172>\031\1837\219\245a\1879\254\237\213\155\230A7\219\135\187?\175\191l\026\027w\181\248\243\177)\190>\2200\247\234\151\245\183\127%\147\207G\139W\159\232z:.^\253t\188n\237y\232\136\215\027\254tV\012\231\175\254|\188\249\215\229`\212\016\205\213\170\185\154\012\155\171\198\183\219\030a\223\030\143\166\175~\025\140\139\193?\006\151\159\006\197|\209\\\25218~[7\214\251\199\224\231\193\144\254\251G[j\156J\141\187\139?\006\155\151\235\221\250\190+\182l\203\020\147I[\143Tv\146\202N\230\147\174\236_\213\1901\229\231]*\189\024L&\243\198/gZ~\154\202O\167\179\174\252Cu\255\185\237\211\187\135\238\027M\169a\211\224\197`\182\164\2423_\254f\191\219\173\015]\217q\227J\163\209t0-\198\131\249|\154\138\207S\241\197b\217\021\255\1829\\\183C\164-\223x\221\217h9X\204FMm\168\165\139T|^\020]\241\245}\243\133c\211+\221\023\166\147\238\011\243\225H\171\191\244\006\236\154\155<\175\253F;\252&\211A1\\\2027&Co\204o\235\195\230a\183\185M_h\204\209\244\225\162\233\158\198\164\173-\219o\140\130o\2323\154\026u_)\026\011\201W\168_\199\212\236\245\177\173\213\241kjw\211\003\139\230\255f\176I\165\168\135\167\139\212k\223v\213\177+;i\251w\218\244\239t8K%'\190\193\215\141\230\172S[[\235\204\154z4U\031M\168\244\212W\253K\253\237\203\230\129kQ4\1575n\238;\158\164\206\154\204\252\189\027\219o\2477|\243\161\191\243\028<w\183>~\233\138\1585\207j\187i<j\186\169\237\255\182\244\194{\205\247\205a\159\236]te\167\197D|`\178\244e\247\015\027\238\203a\227O\011)8\029\250\130\143\207\233\158\197\172\181\217H\189j:\130\130_\014\155\r\027\161{\252h\166\133\011_\248v_\029\184ls\219\194\148\028C\201\237SvW\0306\211\137/{\220\190\164\246\143\168\253C\189-\140\200\227\230\137\187l\218\213@\007\227\020\006\227F\1562\176\235t\014#}K\134\237\198m[\182\208\178\011\2397\215\251\221>\213aYt\130S4\173+R\209\165/z\220\220o]\241\228\148\230\027\179\161w\246];\151t\021i\004a\209\152j\214\020M\227h6\242E7\127U\235\029\015\140f\012\181#c\210\212\189+[\248\178w\237d\1909\244\221\153:o6\026\145pl\142\221d\215\185Z7\234\026;\205\139\228\1913\234\190e+k\237x\166\161?\"\tk\139\146\171\207\166^\194~J]\215\222q>\212\017?\155\249b?w\197\230\173\235\206f\170V\179\185/\246Kj|\018\194\217b\162\143\005\229|m\238\183\152\234\253\168\183f\221\141\255\024\1881\197\n\149\213\249\208[\231W-6m\204.\197\168{\230$\002\255\180\181\155\143\198R\187y\225k\247\175t\191Q\251\216\169y\236\216\139\202o^{\164\024\012\166\223\147\137[Wk&\184\133)\b}\241\182+\184h\007\242\188\208\190\152\207|k\223\217\214\142\181\024\207e\228\233\255VY\154\207\212\196s\232\137?\180\216lj\234\182\244\182;w\182\027k\207.\134\190\203\222\219.\211\190X@_|\144\2515\138\214\222K\238\007}\241\209\220on\2387\246\143\2533\r\164e\242\188b\169\247\155x\235]\164\161\209v\218\180\157\018\249~\208\023ezl\210)\235\004\139\153\127\240j@\179lS\191\137\185\031\245\198r\146\134\251e*\2146cY\232\000Z,\252\221>i\237fS\237\219\005\140\139\171Tl\n\197\1500.\254cty\161\139\170%\172\024>7\011\241\175\155GYe\204\186\025\178\153x\219uI\145Tq\tK\193\207\205WNO\170\203q\248\020]\153\020\147\244\152b>\212\199L\188J\174\143\215\219\237\245\246p]\165\005e\163\162\227f\253\214N\006<\203,aB\170\218\165\238\177Y\167\243J\245l\212X\160e\207h\213\183\132\133D\183*\211\2147\139\178f t\1392\210\215%\204MiES\180\206\214,}\138y'\221]\193\133\239\128\207\233\142\163Tp\174\238\177\132U\196ur\223\t\221q\"wl\2466\254\1507\174\164q\204\209\016\214\0174\219\143\233\158\011s\207\194w\205mr\167v\018\0247w\235\154\221\200\204\182Y3t\023\187\193\237\142\190\t\243\210\221\128f\187\179b\212\152\161\241E}\b\012\188\228)\179\206\025'3S\237\169\239\141\173\nR\234\131)\149\131^\251\175d\136\246\201\019(\t\221\245U\23985\171\218\209p\225\239\184\131'K9\234,\222%\220\171\238/\154\005\151\180x\004]\245\224[\172\229F\190\220\222u\233\220t\212\168\240%\191\241 hwrP\020W\012r\211\174h\163\178Z\148z\134\151\255\007m\207xnzp\132K\189\129\172\199\154z\182k2)9\243\014\245\200\014u\150Td6\231\130s_\203*=z\150n\217,\244\167\227\130J\194\154\252)\221r\220\025sl\202\193D\245\172\190<o\186R\202\021\176\028\127Q\t\1576[(-\007\163\168\150\166\180~6\029\219[\242\146\174\027\163\205\182a k\169\201bh\202\141\189\189[%T\189\153,Hm\219I\186\224\175\240>j1$\185M\157\180h\251\179\241\243\246\011\188\137m\229-\191\127\174\179\227\166\153\250\128Y \180\143\219\221\205\134%k4\027w{\229q\187\251k\1912\131i#\237\243o\246\207\180\150n\253\162\153e\218\237\1904}\006\219\021\217]w\222\222\244q\171u\179\130\006\218\012\182,\237\182\180\137\233$\145\233\246\227\179\174\179dd\242\194wD\243\226m\027R\226er\138\030\181\179\210XwE\163\0258uM\187\151\179$\015S\153WF3\216\190\220\238\246\135-\223\186\243\135a\218\154\209\1327\154\129\238\0287Z\153\174\189\139I\218\198\020\252\005\240\241\235\234\208\236\221\175k\154S\219U\207\180\217\192\204\1984zxy\\\140\205\196u\220vA\182n\1852\236\002(\237}\197D\188Vf'\229\136\139\206w\147n\190\155\140u?1\154\195 \184\171\182\205\023\238\247\186Fh\022.M\237&\179\180\162M_\130Y\165\253RW9\253R\215\164b:4_\026\247|I\2537\250\022\204-\183[\029\245\211\137\1770/\177\165\224\174\175 \244]\0190\227\197M3\027\180S|Ct\149\236JC\199\221\172\239\238x/\215jYc\191\180g\230NXF\2299\238\021~\133\215\213>\218\209\142\159\205aC\001\167Eg\244\162\249\218\152\";\163\005\012\184&\026\180\190;\172\191\209:\173\211\154Q'c\243!\141\b^J\143\167\1645M\204w#\n\222D\135\027\231\029v\0035\021\135\016\143:\225\231\245Qb!gm$\166\157EGla^a\163#\234\183&\233[\173'\234\183f\241\183L\016m\210\005\209:\255\021\227\205{\252\215xU\238\192\188\024o\214\\\233aM\148v\251\237\184M\243^\023ZX6k\006\1421\141xU.\229\155>z\252\178\175$\"x\150V\197]\240Z\004h\t\179?o\237EH\155\bK\243\173i\183\184\019!\197\213t\211\167\020\2069k4z\214,\182\218ia>\229\135L|\241\245u\245\184\161.]t\197\199mP@\138C .\173\184ow\155\023\145\187\238;\205T\160\223\1939_&\143\198\153\155\214\r;\135\018q\22854\023\191__\031X\168g\233\238\227v\161@=\184\132\016\207\231\195F\218K\165ms!\202s\179\127\\_\203\\\211.Eg\237\"q\220n4R8\166\024B\160\245f\219\140+\238\235YW~\220\238_\165<\168\219\129\231\165F\160\167m\b\169\145\1549-s\138!\244\214\245\230\166q@\n\132\166\019\141b2\165\248y1\1960h\245p\183>T\247\187u\149\026\176\236Z<Yh\143\021C\176\254\254\174\tD\166\133n\163$\221\019\198\195\137<\001\140\127\189\022\219\007][\012\179\129p\015j\2161,\135\005/@\164\252O)p\211\182pi\130\nE\193\245\152\167r\251\195\205m\019\144\147X_39N\154m\204x\162\241\128b\012k\224wf\219\217\173\181l\016\164\224\195\b\137[h\233v\143\218\246h{\028A!\229\130\207#\164\230\231\169\230\227\020#]\206F\166\"\220M\179)W\254\190Y6U;\174\253,U~\166^_pp\158\183\014kjg\218:.\166\186\128/&\176\015\186ig\219\227\017\182C,\b\197\0047/\198,\221\177H\177TA,8j-[\014-\221\006\166\154\250L\023\173\031\147\003p\236\154\163\023{\n\197\166-\202r\164\155\137b\nr\214\204k\205\025^\163\208G3\0214[\1496\"3\234\190r6\2425\255\205\r\189fY\213\238C\154\238X\142\166\174\188L\205*ffs\203\206\139\165\215\170\028f\195\142\165e?\146\141=\218\155\204\140\186f\021\210\225t\162B\018\187q\205\149\024N\214ZZ\152\223l\159\182\164\171\2376\187\rT\183\011\236\201\"\190\185\017z\1853-\031\185\172\132~A\229%\b\140_\016S\026\195\247\155R\"hp{\019K\235{@m\167)\221p\245\217\253\216\157.\025\161\031\211i\177\221\155\230\157\005\173\238\2391i\137h\189m\195\172\136\011\187\238\181_\232q\231\181\145\238\214\172EA;\225I\220m\165\026\233\132I\197\161\205\221g4\245\216}6:\208\027_}\142\188c\229%\142\223L\226t\218p6\133`\190\140sZWbo\205&t\182\223\204\222gh\250\241\156\190\195'\245I\216\210y\212|\162\241\221\172\001fa!\213_\204&\161\237\175u\228\154\216[\175\148\136\031X\247\159\199\221\244G\214\220ej\174\141\178\163\020\238\180o\211yb\243\160\222\209\168K\192\255\129\176]`uFd}\027\004\1996\252\162\2131g:\189\021\210\021\160\173P_?\2495Z\175\167\233`\215\174\210\bT\1914\152\021\215)Y\144\168c`y\188\249dI'\130\251\239\155\135;\209\169\180/\229%\005\218\240\163\214[\01412E\230\003*\236\164\tu\146=\172\202F8\b\154\t\166\245:2j\224\143\213\252'3\172d\162\192a%\001Ems\183\020i\163\138}u\185v=\197Ni\"\224\216\222\255x\199\145\211\rt\028v\180\139/\251\131\147\131y\238\239\188X4\1414G]\216L\233Z\163\196}]+\231SZ\214\028Re\1420\161\205H\166K\173\249\250\134ii%O\167\004\172\1828\140\200\152u\021\1441\217\213\181\201\b\199\170\139>P\b\178\0253\205*\215d\026dfTe2V\236]\134\024\029\235[\129HY\179\152\235]\173\208\194\233\190\218=n\191\237R0\173Y:\141\210\1887\156\198F1\227\191\127\000\169\154\170\131\243I\"\214\131\213\162\137\192<n\215\187\155\237-\029\179\140\1865nK\247\141\137\218/\017\237R\136\182\163\217l\003\242\213N2X!\145:\220\221\143\231\221\193\207\172w\201\250\006\151r\"\214}S\129k\128\149\023\168\191\172\202\252\023\204\154\172\231\011\215f<\245\207\220r\018c\204#\007P}[\0003\154\140+pd\"\159\231\197\021~h\249\223L5&}\211\187\201\177jv\198}\137Vrk> 8\236\191n\030\2361\193h:L\199\004\195xiu\216\220m\143\026L\212\181\213\"\155jd~\210\225g\178(z[\235\133Z\242$2\161\166\173\247\177j&?\t\152\183\235\1476\192\222.(\135\177\166\190Q\229\232\245H\153\146\208\244\139~o\217\027\0150\167r\232\0012!\153m\145LF=\203\241\255\152\173b_\217\233$U\1532\1324\169(e\142\181\233\139\195xBz\243H\001\128\190\165\184,\236\236\164\203\139\012\155\175\147-L\251V\179\197h\156=\133m\254hT\178;\n\156\180Kq\176\162(\128\221\006\141y\025\176\232\223\006\217\136W\193K\235Qo\147\1272\189\244\195i\198\171\145\020\239\011H\152\025\236D@\130O\t\161\"\237Q!\150\021\1696\141\028\205\210\222\176\141\229\240Qw6\243f\011\246h\230\021?\2075t~\"\144bW\128\170\232\179\158\254<\154\155\247\175\215\165\161=1\160l\190\227\134\194\140\244?Xg\148F-N\237\155ic\187\217=r\188\182\141\144\182\195#\030\254\143\178\190L\231\242\011\151\232\145\173\167\158\247n5\181l\020\1889c5\137\144YS\157ilCG\241R\230^\015\213\187\163\255`\183/f7\199\b\211!\231=\244\201b\022\027#\175\137bc\162\209v\152\146\007\207\198\203\204>\146\222\162\001\005\190{\176\242]\140'\003Y\1576\250xht\242(\163\164\181\207r\153\025T\150\226n\199\193\187\242\"\015)Lh\196\238`\138\159\012\251\183\204oQ(\155\163\168\180\1333\025}\216\232w\176\145h#\218\232\152\018\161\2147\n\200\031\218\028\233\229t\150\221]\215V~\195\212\191\184\146\153;s\139\209\137E\141=\201\025\143\187\165d\209\187\249x\007\219a\027\188\199\222m\028\231\203zw\203s_\234\215|\160\240|\217F\203\205d\185\228|\232a\\\147=H\200\t\t\148e\164I\144\144e$\174\149Xn\178\209\194\170\179\024\245\238\018\223\224\142\242\196\026{c\245X\251\180o\149rg\214n&]\011\155jlO\227\202\153\1276;1\172t\207\218\191\195\213\210\024\187=1\016E\n3\155\158\208}\030\1897\205\244L\249\244\211y\179\004\153\165\179\174Q\017{\133\186\254\t\135\208u\212\026\226\005Q\128Lv\022z\239SA\154\t\175Xo\182\215k\201W8\235\178\195\155\129\213S\149\215\024gj\150\127\189\139\225\190P\172M\255\2026:\198\249e\163S\140c+jYk\197\158\161\242\017\1713\167@\181M\248\205\133\164\231K\145\162\200\194\206\132(eU\007m\144\178vA:L3\215|R\244\223[\163\195rk<#`?\214jX\007\134\138\200\130\017\244[\022\141\160\222\186[_g\001\240^\2416\141\236v\128\221\154>\152\170$\151\178o#`3+\179P\140\221\199\182\153\000\211n\218\234\153|z\195\019}\227\234\193\204\207}\187{Y\127eq\240!\159\150k\154\"\214\127\183\191k\135\226\195\254Q\026\209.\243\204\219\029\217\000p\1396;\006\138\248\011\149\207?0\242\128\001\016\146\135\1662:\2175+\193\179I\027\220n\026?\143\231\174\187,\182lf\129E\207\132\183\161\r\229\137A,^jv\182}\219\026\2370t\162)\159L\2052\253\145\012\135\007\031\135l\132\188]:\023\237\187\003\163\158]\133]\154tg\226\139i\239\134\229ME/}\233\187\141o\030n\204K\145\233-\201\183\155\195\195\235\245\227Z?\189_o\155\197gs ?z\245\246\253\167\193O\131\230\222\147!_\167\025\221\000\201N\022\160\229\168B\255l\151]|\157\230m\003X\227)|n\190\127\142\015\181\219%\131\138\207\025,\205Q\006ps\174\193\201\182\006I9\005\006H2\167\192\007s}18[\2025\217\196\000\182\141\002\151\166\189t\012j\000\219FE\181\141\138Q\027\021\240mT\156\219\168\b\233\165A:\217\215\207\171\198\211\248\250\178\tz\240\245U\171\175\242\129*o\016\173\167\130U#~rM_Q\192\182WQ\189\143b\212^\005|{\021\231\246*\194\237U$\181W>?\153>}6xm\175\177\238u^\203T\196\012\029\002\192\149\t\133A\196(\142\164\132\155\225D\000\140)B\195\129\149\184s\188\231yX\175p\156\017\149\0156\"`\196\017\026\015;\"q\236\017\012\003\144P\024\133\t\253\128\128\025\143\004\192\160d4\026\153\137+\209j8F\t\141\006*Q\249h%\002\134,\161\241\184%\018\007/\1938\130\t\246\1958\129f,'\192\012\232\004\216QM\b\014m\130\131\241\157\152\n\199\000\142tB\163\225NT\223h\194\129Oh<\250\137D\t \024u\128`/\006\t|B\215z\198\018u\006\132M\014T\"\r\\\163\018\004\192h$\020T\130QT\137\132\027\149 \000T\130\208P%\018w\142\247<\015\235\021\170\004Q\185J\016\001*Ah\172\018D\162J\016\012*A(\168DB? `T\130\000P\tF#\149H\\\137VC\149 4R\t\162r\149 \002T\130\208X%\136D\149 \024U\130`\175\018\t4*\145\000\163\018\t\176*A\b\170\004\193\129J$\166\1941\128*Ah\164\018D\245\141&T\tBc\149 \018U\130`T\t\130\189J$\240\t]\235\025K\212\025\01669P\tc\004#\021\022\133qi)\016\rG\161r\024\210\200\135EAC,\021\n\137)p\030>\231\188\191\234\161\174X>\023\023\203\130\194X*\150\025[\002\181\198r 8\150\002\2131\212\135\0165\250cQ\016!GEJd\n\148\161\237Q\147,\021\t\147\229su\178,H\148\165b\157\178%P\172,\135\138e9/[\1341\218eP#`\006\181*fa\1482\203\005zf\232*\028\178\168l\150\138\228\205\242'\181\000\133\206R\177\218\217\018(y\150C\221\179\156\023?\195<\133\030\254\028\150\173c\180\223R\129*\nb4Q1\144\021%@\015\r\129j(\148\209B\197@\t\149\buP\232\243\224\254\231}\149\r\021P\217\\\255\148\003\245S\"\214>\229Q\249\148\001\221S\002TO\136\015\001f\020O1\208;CDj't\025\216\023\149N\137H\231\148\205UN9\2088%b\133S\030\245M\025T7e\188\182\tn\148M0\163k\130YUS\0165M\153@\209\004\170\130\193\134j\166D\164e\202\158\024\191\168cJ\196*\166<j\1522\168`\202x\253\018\252)\240\213\231\160\\\029a}6\tT+\181\213H\022\001 \001\132\130X1\138J\149p#S\004\128F\017\026\nT\226\206\241\158\231a\189B]\"*\023%\"@\145\b\141\229\136H\212\"\130A\136\b\005\021J\232\007\004\140\254\016\000\226\195h\164<\137+\209j\1689\132F\130CT\1746D\128\212\016\026\235\012\145(2\004\163\194\016\236\229%\129F[\018`\132%\001VU\bAI!8\208\147\196T8\006PI\b\141d\132\168\190\209\132\002Bh\172\030D\162t\016\140\186A\176\023\141\004>\161k=c\137:\003\194&\007*A\18132\193\b\140G\134A(\004F\165 \194H\005#\160\021\012\135bA\228yv\223\243\184z\161^0\151\011\0063\160\024\012\199\146\193,j\006\227 \026\012\131j\016\252!C\140n0\002\194!p\164\028D\150\153\rQ;\024\142\196\131\185\\=\152\001\249`8\214\015fQ@\024G\005a\220K\b\161FC\b1\"B\136U\017\134PF\024\015t\132\168*\027&\168$\012GR\194\\\239\152C1a8V\019fQN\024G=a\220\011\n\161O\153\215=ge\234\028\137[\031\168\nU\198\168\n#0l\025\006U\017\024U\133\b\163*\140\128\1700\028\170\n\145\231\217}\207\227\234\133\170\194\\\174*\204\128\1700\028\171\n\179\168*\140\131\1700\012\170B\240\135\0121\170\194\b\168\138\192\145\170\016Yf6DUa8R\021\230rUa\006T\133\225XU\152EUa\028U\133q\175*\132\026U!\196\168\n!VU\024BUa<P\021\162\170l\152\160\1700\028\169\ns\189c\014U\133\225XU\152EUa\028U\133q\175*\132>e^\247\156\149\169s$n}\160*\221C\141\166\164\2070d\019\bzB \170I\007\027-I\159AI\018\024\234HG\157\195\253\206\163\n\133\n\146\152\\?\018\014\234\145\192X;\018\135\202\145P\208\141\004\130jt\224\007\248l\020#}\006\189 0R\139\142*\193N\168\020\t\140t\"1\185J$\0284\"\129\177B$\014\245!\161\168\014\t\245\218\208}2\202\208}6\186\208}\182\170\144\000\212\132\132\006\138\208\017\02188\170A\002#-HL\2078A\029H`\172\002\137C\rH(*@B\253\248\239>=\129\255<\003_\227\231\168\157\193\168O\190j\134=\0010\204\b\133\129\207(\142\252\132\155\161O\000\140}B\195\193\159\184s\188\231yX\175p\252\019\149\011\000\017\160\000\132\198\018@$j\000\193 \002\132\130\n\164\143\031\0160:@\000\b\001\163\145\018$\174D\171\161\022\016\026\137\001Q\185\026\016\001r@h\172\007D\162 \016\140\138@\176\151\132\004\026MH\128\017\133\004XU \004e\129\224@\023\018S\225\024@e 4\146\006\162\250F\019\138\003\161\177:\016\137\242@0\234\003\193^ \018\248\132\174\245\140%\234\012\b\155\156\171\196\207\131\159\236\181\255\214\207|\226m\128\192h?\155x\170\193\188\169~\150m\143A\192\006?\147\152\153\2074\212\004hF\196H\174\2171\004\176\149S\2128\138`T9\005|\023*\206\149V\132+\173H\1704}~\221Zt\"\215^\213^\139E\021\b\020\238\181\181\168b^\215^\171E\021\225\202)\146*\167\159\189x\189n\135\164\\_\154\235f \206\229\154Z\161\128VO\176\244\1517\184\171^\243_\203\016 \169\1591\014\001`!B\193L\132F\182\"*7\024\017`5B\209t\004\163\253\b\246F$\016,\153\208\021\002\151\b\024\195\018\000\214%47q\"\192\206\t\204\140\221\189\212h\141\157\0004vB\209\216\t\r\141\157\168\192\216\137@c'43v\1303c'\024\140\157@4v\135\174\016\184D\192\026;\001h\236\132\006\198\238\b4v\007\130\177\127m\237\188\144kz\128\002d]\005\172a\021\213*(F\230T\128-\169\b\027Q\145d?\253L\166\019`\221\190\166\203\215T[\005\168\182\n\216\218*\170\181U\140j\171\000\215V\017\174\173\"\169\182\250\153j+\000\245@\251'\183\018\192\214g\228\247\214\252\133\\\251\006\253.\230W h\208\239\214\252\138\249\006\253\174\230W\004\026\244;\155_?\251\006\253\206\r\146\207\220\030\001*{\141\205\169\194\218WA\237+\172=,S\020\207ZUe\173\170\\\171\222\182\203\247\177\\\251U\195[\191hW4[$\188\149\165\186\002\225R\234\173.\208\021\161\181\185\002~\173\240v\208\206\239S\190\230\181\130\000\180\0247\128]<\bj\022\015\138\201\235q\006\228\021\133\000\178r\016DV\014\140\236\155\218\2025[Q\000gEA\141\021\005c+\n\000V\020\\\172(\b[Q\000\182\"\003\149\177h\133=]\133=]\005=]aOW==]e=\141K\229\183\176J~\219.\127'r\237\167\184\183v\209\203\152\221r\025Ov04\213qQ\171]\129\220\000\142\006[8.6\139+\130\022r$\012\011\199\193\b\177\156q]\007\195\184q\028\012!\207\005\163\201\021\200\007\150\167\2431\230x\024n\142\195\145\231H\028\132\1504\227\209\19304\029\023\141RW \031\176\142\134\177\235\184x\024\187\"8\162\029\t\131\219q0\206-W\197.R\157\024\018\213\143\134DuzHT'\134D\245\227!Q\157\026\018\153~8\210K\137\165\234X0P`\028\151i\205;\019\007z\135!\160wq\244\231]\187\176\229\160\198\187vQ\187\224\2356<R\200\007\030\156\138\152Q%\160\255\005\251\179\209\196\017\025\170\177\132w\024Fx\023D\016\222\225\219\\\239\194\183\185\222\157x\155\235\157\188\252$\141\150\183\159\022\014\176\205\135\183\159\000\014\012\145\152>k\0246\166jl2\026\167\239\029\"\247\195\001\198N\014\006ky.\178\153\005\173\229,n\236gakE\135\163-\029\025X\212\242}v\205\202\156*P\199FCK\247\0129\166\147\236\025K\019\0006f4\178n\226\172]\019b,\154\000kKB\208\138\004\007\246KL\159\229\012\027S56\025\237Dhf\161\243v\2034\149k\031T>\151-\147\002A\128\249\220n\153\020\243a\229s\2212)\002\241\226s\2222\233g\154\155\004\184\0169=\151^4\128\237@\129W\230\251\151\230\250\147\185\214\232\1929\006\006\206\131\152\1929\239\221\228!\188wc \221\195\024\151\000\1760\161`fB#[\019\149\027\156\b\176:\161hz\130\209\254\004\251N \016zB\180\2227\024\251$\210z\207\173\240\158\151\b|B\192t\150\151~@\243nK\004\244]\002\177\003\141\241M/Z\020\186\210R\208\159\150\138:\213\242y\207Z\022\186\215R\216\199\150\195\142\182\156\239m\203@\151\251w\161\002;a\231\247\190\011\021\020X\133\207\185\012\209O!j\188\"xE(\162r\2550,8\137a\208S\2286\198O\020\003/Q\002|D\137\200C\148\205\253C9\240\014%\2087\148A\207P\198\251\133\226\224\021\246m\145\204\"\232\017=o\139d\244*\184\255e\128}\n0\227\007\217K\0219\145\251\128 \224\001\130c\255'\171\155\206'\000z\158P\232vB\163>'*\239p\"\160\183\t\197\174&\024\251\153`\223\201\004B\015K2\190o0\246m\148\140\239\185\021\222\243\018\129O\b\152\206\244\185\236\128\230\221\152\b\232\195\004b\007\186]\165\233G\143Cwz\018z\213\147Q\231\250\018y\031{\030\186\218\147\216\227\158\197\142\247\172\239\127\207\129\0278\242\162\199z\232\020@F\190\225\138\172z\158w\217\131\127\234\193\141\223x\028\220\199\147\185\0239\030\156\201q\232S\212)\198\155\024\001?b\024<\136\225\200w\152\203\189\134\025\240\023\134\209S\024G\031a\220{\007\163\224\023\154t\015mG_\b\147\238\129\\e\247\189\204\144O\025bz\027r\213\017\206{\152\024\232[B\177W\2116\202t*\001\208\167\132B\151\018\026\245(Qy\135\018\001\253I(v'\193\216\155\004\251\206$\016\250R\246\203\190\193\216\147\209~\217s+\188\231%\002\159\0160\157\232\183\207\128\230]\152\b\232\193\004b\007\166\246\154\014$\000:\144P\232@B\163\014$*\239@\"\160\003\t\197\014$\024;\144`\223\129\004B\007J\194\153o0v`\148p\230\185\021\222\243\018\129O\b\152\014\244\249Z\128\230\029\152\b\232\192\004B\007\190o\251\142\207{\223K\191\025\132\250\204 >\023H`\155\012$\160d\003\t\162i?\002i\222\143@\156\248#\000\245\139\"\154;\240^\206\218\021\240\217U\239\253Y\187\162Y\252\230\189\156\181+\000\017\240\247z\214\174\136\139u\191\151\179v\001\248\172\189`\192\146\027\172>\159\255\024 \170\254&\168\190=\222Q\016\219\180\201\218\180\201\218\1807N\178\247\145\249\247\254pF\209,H\255^\142a\020\b\211E\223\235\129\139\">I\244\189\028\173\b \025\011d\215\015&\141\237\003\166\177}\b\211\216>\004il\0310\141\237CO\026\219\135,\141\237C\150\198\246\001\210\216>\1443H\149\169\017\244\249c{n\170\215>K\225\163?!U4\203R\248(g\161\n\132Y\n\031\245\212S\0172\188\002>\213\226c\171\136zM\222j\000\171\131\002\151\246\026\219U\134\237*\131v\149\216\174\178\167]e\214\174\018\178/>r\215\200g\149\233\143&\229\233c\171\197\130_\249\201\237\163U`\198R\017\211\147\004@\179\t\141\218NTn\000\"\192\n\132\198\166 \018\237A0t6\161\208\227\018\159\004\000\250>\138Oz\174\204\128\208&e\191M\202>\155\148\161M\202S6)c\155d\142B\176\247\022\012\184~\148\128\235\196\001WX\002=(\139\1752\145\172k\220\136\0000\025\161\145\201\136\202MF\004\152\140\208\216dD\162\201\b\0067\"\020\220(\161\023\025\000n\196h\228F\137+3 \180I\217o\147\178\207&eh\147\242\148M\202\216&\153\027\017\236\221H\210[}\175\0277\146\244V_\002\221(Ko\021\194g\229\020\017\140\230\235\203\202\t\011\004\166\012\178rB\174\199\172QVNH\162\219\005Y9\017w\209\003\163#\246\158\022G%\202\030\248\132m\203\031\217\182<m\219\242\132m\203\031\219\182<e\219\220}-\tN\236\015\205#\207\179\014\237\207\204\163\210\153s\199'\230D_\180\251\152\165\\\211w\021\160\253\128\002\214\236\138\234}\021#\003+\192&S\132\237\164H2\142~&O\020@_\210\186\192\247\179.\194W\179.\130\183\178.\240\133\172\139\158w\177.\178\215\176.\240\r\172\011|\249\234\162\221a-\228\218\231^_\200\014K\129 \247\250\194\238\176\020\243\185\215\023\186\195R\004r\175/x\135\165\159}\238\245E\179\168\222\185\246\209\142K\248\141\188\015u!\027.\005h\216\027\192\180FQm\141\193t\195\165 5Q\001n\162\"\220DA\190\212\223\190l\030t3s\209n\193\164\254{\236\129}h\240}`\240=\026\028\182`\138g\029\193[0\005\208\238\188\005\019\224`\175\177\210\238\207\149(|\220\220o\177\003+3\\*\028\208U8~\171`\252V8~!\233M\241l\\W\217\184\174`\\?\155\238\171\2375:X\157{\142\188\181\179\244\0004\213\191\181\003hd\133\236\173\029 \192\030\240\214\014\192h\001\247\214\014\128\160q\178v\157x\000\212.X\187\002\149\235\158_\187\002\026+ \172]\001\006-\244kW\143\026M!\000|\156P\208GB\1631KT>p\137\128\209K(\014U\130Q8\t\246\234I \012e~\tj\151\027\b\1964\129\027\244e\148UBA[\025\r\004\150\168\190\177\018I-1\160\183\132\162\232\018\140\202\155\224L~\019\188\199f\239\195\254\222\247\247\236\190\175g\247a\207\246\1363\145q\183\163L\019\026v0\nvB\015\025\01663\214\239\196\005\"\158\136\nE\161\n5\174\234W\179\170O\205\170P\205z$\158\200X\234\170X\234\170H\234\158\209w\234\012\b\135B4\011\024{\218\185\192\194h-\203\225\188`\185\208\158\182@`UK\163m-\151\025\209\146\153)-\t\006\181\020\206 ~\219:\137`\156M\250\182\173a\129`f\t\182\173!\2153\203D\219\214\144\196\025'\216\182F\156\021a\011\227`\181\028\206D\150\011U\203\022\b\180\203\210\168`\150\203\164\202\146\217<eI\152\173,\133\146f8\212\030G\249\249\203\190\182\018\143\197l.\179\028\206h\142\139\2305[\224\180\006\132s\156\229q\166\179\\6\223Y2\155\245\012\153\207}\246\133\150\216p\251\019>\183\255\145_\237O\251\213\254\132_\245\205\143\182\200)\215\203\230J\203\157p\175l\2224\220\161\007>a\162\158\153\212\128\209|j\232*\022\202\234\196lQ\253hF\168N\207\b\213\137\025\161o\206\181ENM\026\213\169I\163\234\1594\158c\143\174{\224\019\195:\159\157K\147\217PbRC\137\249\012e\152\202P\006Y\012%&0\148Y\238B\153\165-\148\144\177Pb\178B\t\239\212\151\248:}\137I\244e\152D_\134I\244e\127\018}\217\151D_\134I\244e\156D_\198I\244e\148D_\134I\244\165KG\247\141FS\132\233\232e\127:z\217\159\142^\254 \029\189<\153\142^\246\167\163\151'\210\209\203\019\233\232eo:z\217\159\142^\230\185\218\129\173\208\140A\174v\217\151\171]\246\229j\151's\181\203\019\185\218e_\174v\217\155\171]\246\230j\151=\185\218e_\174v\137\169\205\153U\208\\\152\218\\\134\169\205e\152\218\\\246\1676\151}\169\205e\152\218\\\198\169\205e\156\218\\F\169\205e\152\218\\\186$a\223h4EO\146py*I\184<\149$\\\2540I\184\252A\146py*I\184<\153$\\\158L\018.O$\t\151\167\146\132\203(_6\180 \1547\203\151-\227|\2172\206\151-O\228\203\150\189\249\178e\156/[\246\228\203\150=\249\178e\152/[\198\249\178\165O8\133\246\163Y\232I\198,\140\128Y\024\006\1790\028\153\133\185\220,\204\128Y\024F\1790\142fa\220\155\133Q0\011\193`\022B\209,\221\029\141Q\210g0I\002\193 \t\140\204\145\152\220\024\t\007S$\016\r\145P4CB\189\017\018\006&\232@0@\135A\243W\230g\134V\2483C+\252\153\161\213 \250\153\161U\2403C+\252\153\161U\2463C\171\236g\134V\2403C+\252\153\161\149\249\145\200\021\254>\228*\254i\200U\027?\209k\223\177+\031)Q4\235\187\149\196D\020\b\127\215p\165\209\015Eh\223\165\128\239\174U\027\220\152\201\181_\168\175$\140\161@\176\211^\217\128\133b~\207\188\210\208\132\"\176;^q\016B?Sm\005\240[\179\021\166x\174\006\182i\02749\199\016\012\016\245\193&\232\003\027\"P\016;f\147u\192\006\006\210J\182\253\226Y{\217c\173d\127\175@\176{\\\217\157\188b~\159\184\194=\187\226\176#\\\201\238\\\001\031\020\\e9\159\171`\163\188jw\199\210S\021\250R\021\186N\021\184N\133\174\003\219\\\1973\151\1702\151\170\156K]\182\170\163\215\190\142\151\162:\n\004\149\190\180\170\163\152\175\244\165\170\142\"P\185KV\029\253\236\253\253\210$\014]b\182\208e\152\"t\025\228\005]b2\208eO\006\208e\150\246s\137\185>\151\152\224s9\208t\247KQ\016\005\252\143\241]z\005Q4\139\n_\138\130(\000\193\221KU\016E\220\207\237]\138\130\b@>;\210\2076Jy\217\229\136O\249\154s\196\005\224\028q\005\242\223\203\185t9\226\138\153\028q\001\253\207\229\\\154\028qA$G\156\017\022\016i\210\2228\204\030]z\031z\240>\240\224=z\240>\028v\151* \138\144\147(\128\142\012\129\188K\171\031\210\023\141~L\184\149\172\031\n8\199\017\2128\142`\2368\002\192\193\129\224\226P\130\136C\tB\014\197\159k\227\2495\142\200:\027{W\221\187\030#\249\192\217\241\138\240\187\030\138\184\132y\133M\198\188\130\1562\175\136\228\198+$\201\241\nQv\188\002\252\174\135 \231\242j\203\149H\143\002\182\142\138fo\197\\\137\244(\224;Cq\174\184\"\228U\nP%\005X\203\020u%\210\163\128?\166\187\242\210\163h6\151^\137\244(\000s\230\149J\143\".^z%\210#\000\185\251T?\223\219\223\130\188\026\232z\243J\180G\001\210\030\003\228+\226+\171=\006S\237Q\208/\147\175T{\020\129e\242U+5Z\221=\188\184t\229\197\198\192\249kJW\"7\006\193\215=\132\192\247\151\174Dq\012\002o+]e?\173yeEGz\161\178\005\170\172IU\220\164*jR\1495\169\234kR\1497\169\194W\178\174X|\004\144X\178\012S\031LF\024\181%\b'#\023\168\140\015(#\156\233\r\132\148\017\007\229\241Ae\128\141\006\249w9\000\141\212({\151\003\b\208\165\240]\014 Q\161\252\187\028\128\130V%\212\b\022\001\160Z\132\130t\017\026\233\023Q\185\136\017\001JF(\202\025\193\168i\004{a#\016\212\141\143\001\220\224rg\003\224\197Fz\b\000\197#\020d\143\209@\251\136\202\005\144\137\\\005\137\001)$\020\245\144`\020\197\004\239\179\006f\242Hp((\196\005\170B\012J\011\193=\250Bl&2\132\163x\018\140\n\234Oq\000\014\1804\017UV\180\138-Q\157\176D\213k\137*\182Du\210\018U\143%r\205%\028\132\215\030\185\136Feg.\001\131\n\028\159\186\004t\160\195\217\185K\192dj\156\159\188\004\020hrv\246\1463F\153\021\003qV\"\210ges\137V\014TZ\137X\168\149G\173V\006\228Z\tPl!\140h+\006\186\173\004H\183\018\145z+\155\011\184r\160\225J\160\140+\131J\174\140\023s\197A\207\2051\155\027\227x\252\150\015\017#\164\138\129\182+\001\242n\136@\225\149\205E\222p\185\206+\tR\175\004\170\1892(\248\194\236\163\230g\178\175L\168wJ\007\146\167$\170\1582=\194\167\0052\237S\n'\002ep.\200\142Ws&\152\017\132\171\162/T\189\166\170N\155\170:e\170\170\215T\213\143LU\245\155*\159)\148\242\147\197z\160\239\1577\215\242[\014\012\184\179\002\129\159\006\252\027\206\2356\189F\1745\222\176\198x\195:\1367\144.\153\026\016\000\213 4\172K\226L\133\018\240\140@\141O\197\250\017\154W2U\198T\146\000\168$\161a%\019g*\153\128g\004j|*V\146\208\188\146\198\005MM-\n\213\181TXgS\192T\220\160\207!Z\135u\194vX*o\140 \166)\138AC\148\b\155!\180i\132`\207\001V\007\245\192\234+\145W>\rhSs\002\160\218\132\134uN\156\169p\002\158\017\168\241\169XOB\243J\146t\152Z2\002\213d8\172'\145\166\162\132<gH\157=\027\235\202p^Y\0183SYF\160\178\012\135\149\213?\248\201U\211?\248\tH\157=\027+\155\255\193Of:y5UM\159\161\162\t\012\171\201\127\151\144\171\196\127\151\208}\174\225yX=\252\187\132\140\167y\210\212\142\000\168\030\161a\253\228\207\162q\133\228\207\162y\160\198\167b\029\179?\139F\196\231\193N\158\214\\\203\172\203@T\171\006\150\197\001\001\149\185!\252%\151\207\225_r\249\028\252%\151\207\248\151\\>\247\252%\151\207\217_r\249\156\253%\151\207\240\151\\>\183V\148\235\218^c}s+]\015\180\177\215\131\175\006\255\026\189\132~\221\026U\175\253\253\175\193\168\n\251\227\180\235\182\146\242\204\218\247\204\181\173$c\169\200\023\004Lu\t\b\159\159\184]\006@\237\t=u\011h\135\172\b|\181\176E\217\138\128\tz\029\012\001\211,\002\194:%n\151\001\208,BO\221\002\154%o\026\249ja\179\1787\141\132\160\1918\250%\135l\211\024\138kF\236.\128\176\129\140\159\190\0176\146\240:\175d\214P\198\243\166v\011\255\227\183\245\181\158\182\166-\"\254 |\145\145!\227ou3\184\145G5\215\215\221_.S@\197\243\198\232\230M\215$\185\230\182\b`\026AX\186\175y\020\001\240\188\244\241\t\191\247\140@\157\001P\007B\179\138p\208\148\030\184\129\223\171\178\179\133\157(6\131\023s]\219k\255\224M\244L\027\173\229\007\187\016`\225\192'\252\2303\002/\b\212\025\000\213\202\245\129\b\251J,\215\205\189ZY8\240\t\191\249\140\192\011\002u\006@\221\242A\206\004&qK\005\179\028\238\"g\158\194\027=\135\232K\136\2141\138\213\015\247\007\204BX\135[\128\187\254\002\241\167\224\022\207\001\246\018`u\132A\173\163m\129p\018\231\129J\011\142\181\022\226)\186\203s\004\190D`\029\130Xue\242\186\219\164m\174\183\203\217.\028\248\132\223|F\224\005\129:\003\160~\217N\134\t\151\220\203\149\243\185\189\133G\159\178/?g\200K\134\2129\002U\20470\204\184L[\174\163O\180-<\250\148}\2499C^2\164\206\017\168c\190o!\230VC\164\244yc\175\253\204z\171\127\127L\001\023\003c4\155yo\253\159\023\019P\194`\012hp\139\017\141i\017\178\151U\193\173\0042\021\b\150\248\1836l\169\152_\226\223b\144RqX\226\223JHR\001\159ovk\002\144\004\248\005\198\216\193\014\187kz`$\151\169y\2509\217\223|\214\214*(\1415\144\024_\177\212~\253L\205T\128,/\128n \179\173m\207\182\150J\233S\232\179o\022\129\190m\012\230\r$&k%\227YS\137\240\237%\016\026M(\180\028C\129wa(\240\238D(\240\206\191Y\028\162\222(\193{\1971\149\027(~\1718f3c\005\239\020\135\020\024.z\1638\226\238b\147\160)\029\023\025\244\139\2179\127\193\157\243\151`\231\252\181;\t\153\242\181\023\200\175p\238!h&\152_\245\148C\000\136\216\011.Z&\bG+\004\224\019\012\002\224\237\234\016\134\154\247\190]\029\022\200\219\019\189]\029rq+\195\183\171C\018\218\030\189]M\220\206\204z;3\187\237p^\219\0053\218\014\215\249;\\\214\239\194e\253\174oY\191\131\151\138#\184\238\129\225\017=/\0213\157,\244\140@\157\001p\219\236o\142\017qo\162a\247\024\r\187\015\163a\247A4\236\030\163a\247=\209\176\251,\026v\159E\195\238!\026vo\254\164\218=\2545\181\251\224\015\169=\164c:\190\246+\148\007<\148c4[\144<\152#8\006\194_r~\176\007n\140\192\154\228A\143\215\232\243\147\004\005l\012<\139~Gq\239\007\147\161\226\000hj\152\159\226\168\188\209\152\157\226\208\184\249Yn\138\131\209\016\144\153bAc\018<\154{\b\143\230\030\250\142\230\030\228\215\131F\030\000\011\005\191\030\004Tn!\255\235A\128\198\022\130_\015\002\024-\228~=\200\131\198B\178\221\247MF\011e\219}!\252\239A\140\"\024\173\213\247{\016a\129\192r\193\239A\132\\\143\021\163\223\131\b\201\204\162\249\239AD\148\181\174\151\238\200h\153\165c\233f:M`\198\210\004\128\141\t\141\172KTnW\"\192\162\132\198\182$\018\173H0\218\143`o99\239\1538\160\198&\163\157\250\142w\246\230\212co\230\184\253@\255p\193\222\220~\143w\222G7\021e\241\128\185\189\004\249\198\174D\141_\193\167\245i\207\222G\197\002\212<\220G\197\198y\217:\188\003\214\229\228\169\249\222\134\1852\204T\198\134\185\198X\174\014\190\139\2138q\250\189\151\b\144\007\204\227%\0024v%j\252\n>\181\239,\219\175G\159zpS\001\135\155z8\188\238\185\015\214\202\147y\2294\230\004\136\169\144\198\156\198\190L\157}\011\031\223{hN\171\236'\004\204c\019`\158*\171L\255\021|f\182\202dB\164\194\003\230\145\t0\143D1\217\135b\178\239\019\147ofM\252\r\151\195\223\130\1490\133czNy,\027S\254\156\199\223\134\184\133\225v\155\219Gsu6\153)\151\190t\227\191@ \157\224\228\140\030\171Y\208[\2032\209\209\154\229}\252\2020\214\006y\173\015\222\004\004R5\002\134\162\133\017c+\152\243\250\202\159\005\233A\001\227\127w\2051t\024\024r\182\018\001\159wl\"\212\213\015\205\249\183\185\246\029r\2243W\011pu\020J\241\215\025\127\1901\028;\132\000w\226\209\007\r\153\b\224\227$\012\243\171\152r\147\189\189\198*G\241\211C\016?=`\252\244\208\019?=d\241\211\003\198O\015\024?=H\252T\204\242\151!\143\166uG?\248\015\226\011\006`\155\027(\180\212\227@\030\241hK\b\250\196!\173C#@z\233\002w\007#?\012\209\161\1656\129\0000>\161\2244\140\162\231\216\147P\177S\002o\176\020:\018eVj\219\215>\001\211\163\161\181(\199\003\156+\161\251\012\b[\026\250\026Q\185\195\017\001^Gh\236zD\162\255\017\012NH(x\162;[\0063\255\133\197\142h\030\244NB\193E\025E?e\188\223\252\234\155\2449r[^${o\172\241\179\247b\\\2552Ng\220\218r\002\160\131\t\005Wf\020]\217\253\150\244\204\1297X\n]9\161\198\149\t\000W&4\180\165\255\153g\127\227}\006\132-\r]9\251\149g \192\149\195_y\006\018]\217\255\2023\160\224\202\254W\158\189\153\255\194bG4\015\1862\161\224\202\140\162+3\222o~\245W\250\028\1852\199I\1887\214\248\217\1872\006I\0047\015\176\014ma\236l\203\161s;.sq\203\130\163\027\234&\254F\230\244p\1622\r`\028\000\253'*A\137l0\248\131\137\016>a\171xx\196\007\019!\141C\165\255`\",\146\r\155\224`\"\228p\b\025.\027H\134\251+\254\20216v6\180,\135\003\204q\2170s\236\143:\217\140+\139\134\003\207\005\210\162\017T\199(\012\1970\138F\172\141V\0281\144s\196\020)i\188\133\194\147\026}\229\199o\227\210\167\139\129\188\020C\128\2288x\212\031BZn%\155\132\244\249\018>_\233~\146\000\238p\143\154m\171#x\191\1536\147\139\140J8\249\225\211@U\231I^\001T\128dA\129`h>\217W\253\020\243\131\240I_\237S\004N{\158\248U>\253\236G\212\019\252\182\205S\171.c\185\246\199AO^G\020\205\014\137\158D1\020\2402\1618\252\197\211'\017\004\005\252\031m}\194\031\138y\134\191\168\251l$\242\025u\2419\020\195\231@\001\159Q\246\158{\180\2389\019\184gT\181g\148\178g\252\131\191/&\243\231\0053\127^0\243\231%\204\252y\t2\127^\162\204\159\023\204\252y\2012\127^\178\204\159\218\252i\223\026\255\180o\141\127\218\183\014\255\180o\029\252i\223\026\255\180o\157\253i\223:\251\211\1905\252i\223\026\255\180o\r\158]\027\251\214h\223\026\237[\135\246\173\003\251\214\145}k\180o\157\217\183\014\236\219\186\237\148\175\217m\005pn+\168q[\193\216m\005\000\183\021\\\220V\016v[\001\216m\025\128\177G\019\140\241\012\002\192=\b\005\031!4r\020\162ro!\002\\\134P\244\027\130\209y\b\246\030D \184\145\219\230\251F\155\238%\000\188\138Pp-F\003\255\"*w2&rO#\006\220\141P\2449\130\209\2414j0u\000\184`\0205\240T\238\140\0165\240h\236\150\0245\24008(D\r\028\138\174*\1813\222\170\0248\172\018\224\179JDn\171l\238\185\202\129\243*\129\254\171\012\186\1762\222\139\021\007G\134\236\237\220*\198}\020\003\143V\002\156\218\016\129_+\155\187\182\225r\239V\018\028\\\t\244qe\208\205\1331\158\174\0248\187\018\145\191+\155\187\188r\224\245J\196\142\175<\250\1902\224\254J\192\b\192\164|\238\238\239\154\253\248\029R\030\191C\158\227\247(\185\241{\158\209\248=Hc\252\014\185\139\2231a\241;f)~gM\133\207\190\138NQ\017\204+\139z\138xVm\167\166\000B\003\188\1502J\127\201\012?\251V\016\232[\193`\222\nb\178V0\158\181\130\b\223\n\002\161\021\132B+\244\150\155\b\243\1731\132o\145%\242V\0256k\153\229\178\214\025\210\183\208\016\208J\195hK\223<\220\188\221\028\030\222\175\183\135#\127x\189~\\\183\215\191\238\031\030\255\189y<l\175\143\255\ro\174='"

let helvetica_oblique_afm () = "x\001\181}[s\219H\178\230\187\127\005\031w#\214\179\188_\206y\242t\183==\234\025\217nI\028\1597J\130l\030S\132\135\020,\209\191~\001TV^\190\204\162\247\229\132#\028\196\151\005 +3\235\171\172\027\244\231\211\230\240\244\182\222?\253\163z:l\239\142\131\233_F\175~\169\031\031\171\253\211\224\151\250\219\233\176\253\252\229i\240\191\238\254\247`\180Z\206\254O\247\255\162\255\127\213\253\191\026\246\255/\006o\238\235\219j\240\231\233\248T=\030\007\191\239\239\234\195\183\250\176y\170\238\2552\024\188\217\237\006\031\187\231\028\007\031\171cu\248\222\162\242\146C\181y\218\214\251\193\175m\233\255\024\\}i\006\255\216\156\006\131\209`4\254\143\233\244?&\163\254\r\\\254z\191\253wS\253\254\235`:\025\206f\012\223\252\1639n>W\131\209t5\031\014\230\171\201t\254\170\171\215?7\143\213\224o\213\238{\245\180\189\219\188\190\188\221u\183\191z\219\236vV4`\209\230q\187;Y\225\171u\213\219\225\031\213\253\182y|\245\251\211f\183\189{\179\255\188\171\006\175G\227W\191\031\223n_\170\251\247\219\167\187/\131\135\205\238X\189\250\229\203\230\176\185{\170\014\127VO\131\223^\158\170\253}u\255\177~\220\236{\181\254\250\215\250\165\189u1\028\188\030\143g\131\209h4\031\172\218\170\190\186n\203\029v\219}\245\190>n{\187\188\030\r\135\002_}\217\222}\221W\199\227`6|uS\029\142]\145\225p\252\151a[\234\159u\171l\245?\2347\177\215\2468\216\012\158\014\155\251\234qs\248:\168\031\006\127l\247\245\211\233[\245\186-\180\027\188y7\216\236\239\255o}\024l\219\007\028\155\219\227\246~\1879l\171\227_^\253\214\190\232~\187\255\252\231\221\151\170\181s\175\197\159Om\241\205\225>\203^\253\178\249\246\183d\246\197h\249\234_\244{6\158\188zs\188\235\236y\232\005\191V\249\234\245x\184x\245\231\211\253\223\214\131\197\188\251q\179\030,\151\237\1436\198;\127\228\024\159\140\218\184\025L\198\131\255\028\172\2555\024/\150\237\143\127\014\142\2236\173\237\254s\240\215\193\144\254\253gWjbKU/w\187\205c_l\213\149\153L\135\157\022\169\2364\149\157\204f}\217\1277uk\200\219]_z4_\014\166\243I\027\182K\185a\150n\152\205\230\253\r\251\230\241\182s\233\231}\127\203b\210\190`\222F\197|I\229\231\182\252}\189\219m\014}\217\249\170\r\148\209l0\031-\006\139\197,\021_\164\226\203\229\170/\254\173:\220um\165Wg\186hoX\245\178\197p\146\202/S\249\249|\209\151\223<\182w\028[\175$m\186\027\218\023\1807\178\254+2\206x,\021N\145\215\191c6\234\171<\025\137\141Zs%\027\245\134mu\218\028\170\253\174z\160;\134\203\222\139\131\233l\218V?\1695\029\005\183\200[^\175\210-\147\182\186|\011\249vB5\223\028;\189\142_\201\019\179\214\011\173j\173\153X-r\243l9M\239\2165\199\190\240r\214\249`8o\155[2\234tj\003\226\174%\160M_\180u\202\235\206\172\227\209\180\173\200<\149\158Y\221\191\156\190}\169\146wW\147\193\184\141\193\201\172U\189\179_Wzn\159\221\154\127['\235/\023\173\030\230\201\011\b\223\221\230\248%\025d<\234];\157\141[\131,R\233\165\141\156\031\213\161\206Zte\231\173\225s\024LW\182l\189O\205\1623\242\176\181\131\148\156\rm\201\167\231\244\208\241\1883Z\023\137\185\224\b\n~9T\233\161\173\015\250\247w!\146\011\143m\225\135\186\161\024\031u\239_\204\165\228\004Jn\191\167\167\182m\173\127\234X\218\206lj\203\030\183/\201\000#R`&\143\133fy\172\190\147\207F\147\206\004\243\182\177\241c\161IV\028\151\139)YV\153a\001\237}K\166]\142\169\1724\198\217\018\227lW\239%\020&\195Qk\213\020\n\179\021\132B\245\184\149\2269,\245\029\243\161\r\247]\215\161\244\214h\003\172\181Y\219\228\166\171\020\239\243\145-Z\253\187\217$Fk[v\2078\227eK\004\137-\231c[\248s\215\185W\201{m\176\180\143\158\181\157\014?\026\220\215\246\190\199\190\203K\173t\212\007Q\027\023\227\020\195s\242\224h8J\252\186I\134\030\143R\012\173\218v\157\227}>\179T\246\134H\175{dG-\212\236\231s[\236\175\217s\029a\141\165\024\249mA<\247\139\144U\251\222\197R\218\217|iK\254\154<\214Ue1W\239]\217\247\254\150\138\205\251b\242\222\005\185i>\026\245\197\222\170bm_\192\197\200E\011\242\255\187\164\222(E\246b\181b\245\022c\171\222\2232\179\015S\177\252@\232\244~\207-\165\235\239FR,7\169\225\176/\246\247\190\024u,\179\165*\b\222\184H\175\237\234\177\028Jw\184\128\182\244\135\020\155\205\132\171\023\185[#N\253\135t\150\171\145\216x\001\174\248\167<\205\212ue\141wI\190M1\181l\169,\027o9\180\181x\175\189!\157\226\018\188\241A\030\216\214\203<\016\188\2411=p\217=\176\173\014?pb\223\251\231\128\178\143\222\187\163\137<oj\195\229\138\130\190\127\224L\250\224\229\204\190\247:\149\027O(^T]\160}\220\164\146\189\173\151C\245Dr\201j\154\218\253\154\154\240\170-\2156\019\137\132%\164\024\255J\005W\189S\212\243\160}|\162\231-\250\247J\228\175\160\129\252W\"\132N\189\133\n\212\213\200\198\243m\155\154\127\173\1588\237H\029\230\188MN&\201(\221=\144\030\222\182\183H\031;\154&\243\143\219Gg\243\175&\225[T\1662\154\166\247LZ\154\224\247\144\211\166\243\156\170\220m\183w\219\195]\147\178\2046\149\025\183\2041\155H\159\179\130\254\169\233\178\223c\155\186\167\206\228\245\184k\129\237\168b\214)I\185\224*\167\022:U\147\188\171K\137Z\182\153\140;\003\208\029\208Y\165$g>\234\179\192Y\219\231\204&\164\014\228\022\183\137\238\151\169\224RZ\228je\249\226n\192\253d\247\196\t?q4\132\196\130r\160Tr>\019\134l\251\002[\178\210%g\173'\228\153\224\208\007i\190\211\182[\\\140;\248\143\193\182\205\"\250\031\187\193\195\142\238\132~\234svL;vK]\148\188\004\178\140\020-\243Y\159\184L\148\2183\235\142m*\151z\246\165*\007n\251\239\228\225y7n\028a\217\1335\239Wy\230\\\181\213\174\2192\207\220\149\222\189\178<\251(uY\182.\224:\143\192Y{[g)\007\174J\185\226r\210\183\139YKJR\0182\192o\212\230R\162\223\133\148\020\197\028\130\253\223\021\157\015\245S\243\240\140\234s\144\206o\218f\222Rnf\237\1522\163\249$\133\212x\165JB\190\158\0071md,\250F\222e\138\169$4\166f@\217V\031\208\237\139\218a-\149\\\218\183\127O\207\236)r\222F\162\020\\Y\022\127&\022\239\2533VO\028\015\237\019_\232\137\157\127Z\r\164\220\200\150;\165r\179.\212\166V\201\241\216\022\253\209\023\157\164\252|\164\202M\178\201\167L\137\194:\1711\209n;J\202t8\026\231\241\213|H\188\155\252\212z\168\159*\153\180c\166<\192\237*\235\159/\132;$\186\2372>~~N2(E\237\249\246i\187\187\175\0069k\026\181=\253l\217\177a\202\150Gs\024\129\166I\128\251\250y?\224\145qK\202]y\174\250\028b\152G\222\171Y\026\169w\n\204\1854\132q7^m\167{\136i\186\177\253\188\141@\161\210\017'\195\212C>t\179M9wN\019K\221\016\176KM\135\249\029\208m\156hP\211g\167\243\149\244/\1639$b\015\187\250\176\165G\207\198\212\180\250\017\250\130n\128\240>V\162\204\162\027\127\180\221d\223\019\240\r\208g\2205\135vP\127\151B\174\245|\167M\235\2419\235N\193>Z\141\164\251:n\251\025\184\020\165\139~\170a\188\148<q\180\128\185\134<\031#\221^\219\144\187no\218:8w{\163\005\208\212\231f\219\222\241XK\1860j5\235Xt\214\154\160c\142t\219\216\190\172\187\173WP\189m\209\223\214M\025\201m\147\194mj\026\165\011\201\238\190\145~\029\228\222\015[\233\206fm:\214wg}A`\179\135\157.8S\005\193\135\237\156Z\206v\218\225\251\184U\186\139\214\201\136<\178\000\015\222o>\127\166\145\222h\210\133\248\172\027\127\171\158z\177\138n\200\211c]X\165[T/\1533n;\031\210\181\164\234P\221\019\223\173\218\160h\167F\186i\148\017\1850'\214\179Ij\028\237\140\209\230\243a\243\141r\183q\023\145\173\225\231*'\030\229,{2#\222ig\136+j\177m\245[N\159\182U\159\141(\128s\174m\242\169\222q\183\155#\205\151t\169R\219v\187j\228Y\155\209r\022\199$\223\245z\158\238\154\180\138\201]\243\248.\021$-o\246\211\139S\213\131/\023\133P\214\247\rS,\183a\192\193\149\179\2446\015K\198h\231s\183\223\142\219#\197c\215\197\172\134Z\191\021\220\208z\234\233K\221\240\228\2252\r\149\219\174Qf8F9-\207\217{\030\2553\177.\187\190\167\155\182\152t\221\0209w\133-\230\176\161Y\159\174\193\207Zq\154\t\156Rq\232\2457w\205\019\249\1675UW\188\159\007\228\226\224\159\148\137?\236*\2345\219\209m\127O7\139\203\247\128wTo2\158\245\147\135\211nl\147{\160\156X\231\226\143\155\187C\158\244h\231!\231\227\142\202\218\220a\153\031\191\180\229o\015U\174\240\188\211\166K\221\187A\229\136\138\175l\241\251\250is\199\189\207x\218M3M\219\236\164\235\025\146\251\198C \202\251m\219\190\216\221\157.\195\142z&\234\014`\187C\238\171\186Ta\214r\225\180-\177\152\229\210\224\178\187v\025\165\157\185N7\164n\189\155\n\029Ri\1563m\246\1597\135\230q\183i\158\152\236;'\204\230\226\184\241\016\156P\127n\231-S\n\220*\158\2221]\241;\192\007w\027v\193\130<<_\170\135\187\006\241\136\228\216\182\133\005\179\2278'&|\195\027\154\226\233\007\196j\132=\030gM\022\169`}\184\127h\231\239xjp\212\133Ck\146\233T\166q\198\019H.\254\144\145\233t\004\211%\227\188\132\1933\028\170p\026\242/WC\245\236)\168~\153T_Q\019\238\178^)\156}5\159e\237\031\219\140\170\217\177\250\221Tb\167~oN\186+\207\232\231\133\137\r\205\218\166\177\229j()\2468O\160\231.\224\190\235\135\143\199\212\219\173:\"\026\171\028\182k\210vl\003\134\153\168\213\139q\158\232\206\252SK\225q\183\1680\238\023;f\211D<\227<\219\157'9j\026k\166\129\193j.\163\146\241\012\152\173\237\232\218\149\191\150\176i,AK)\179%w\191\175a\138\226w\211\006\251\169\183i[|5\028\153\226\220Y\011\173\229\177\239RH\016Ko\132B\242x~\177d\006\193\210\141k\128y\220\178(\191\162\146\022\197\n\r]i\158\223\001\198\201\243<\174\186\148\180\223o\191o\137b\151\180\128\208-\209\140\011O\023\227\168G\143Wa\2257\142\241i\206\024o`c\202\211\1791\003\211\243\\\027>^\205\186\1857\228\129\152\210_\141\198\156\233\243x\181_\146R\156?'\254\211cW\239/\171\151\154A)V\133I\223T\002\162\136K[\023\235;\n1\189Q\020\222Y\182\155l\209\243N\238\r\202L\231\172\154\195Z=\190\011\232\241\216\142\19610~3\021\224\185z\212\158g\254\219N\157\022(\250iP=\253\207\141\157rMt\216dE\219\002\218\142\244\245th\159O9\237\029/\242\247\157PZlZ\246\153\207\"\214_\229\025\172\253r\017\135\220\1574_5?W\228\019\142\0045=\152{\1274\204?\177\182\011\026\217\235Yy\182P\230q\213\200\250\t\155\246E\197\006)\025\161V\007\169'O\146\163:\221|y\210G\r\015\176\018\191\168XS\203@E\149$%\204*\181\147\0319#\244\145fR\182b\168I\131gg\229Y\170~\233\183D\015*\251:G\r\185+\218J]\251\014\183\031b\192\195\167\139d\205]\253\163\218\127&f\238\146\157n\014\026\2518^\239P}D^\244@\011\242\154\150s\211h\164\194\006b\158\2198\176\154\154p+\1982\220r.\132r\151a2\248\174\187h;FlY\156)\171\150\197\235\233\005W\221iW-\136\163\244D9\006\243\127A\178\159\023B0r\178\230W_\234\131f\004\181\230\137\014\184\212\149T\171cXOv\174\202HJ\206\229\021-\021a\178\172\229JOit\226R\011\189\136\232z\005\173\183\234\022\028\243\229\144a.\211\193\002\\\198#\189n\031\195\177\233\231%\014Y\255q7\1634\145]\n\206\146j\196\170\012YLHT\241R.\194e\213\216\176/\219fG\171\241<\204\161\030\155\221\211\246\219.M\185\205\186\189L\243vIc6\156\199fQ.*7\"!U\025OM\243\242#*=]\208\236\254\230\240\180\221\236\238\183\015iI\166\141\215\215\147nv\173\011\200\184a\156l2\161\147\162a\161\215\017\253y\t\024\021b\194C\214\232Yo4*\018\192o\152<1c\151\250\003\163\191\166\152\130\249+\155|\168\228\012o\200\212\161\234;-2\024/\217\168\238u\150g\016\011e\027\213\160T(\228\233\n\223\221\011\223\253\204\240\191\171 \235G<K_V\239\208j\135\201\180Mk\210/\143\180\020\128\241\203\203\b\135\250k\181\207\139\t\243~\182\177\029\014vc\217a\156`\029\170\207\219\163L4\158\201\176\184\143R\173Om\190\192\006(C<C\214i{\197\194\231\195\243\220q7m\015(\251c:\230\232\186\154\145\139\001\014Ka\142bDr\183\164\226\165O\176\212\164\024F@\1733IY\190\195\b\224NIM\185q\135\132\004\150\203J\180\020\203\206\166i\214\1286\023\201\134\164\180\237\172[\146]\196\177\248\219\019\173\199\150\018rN\239t\199\1556%v\153\134\218\232\227\018T\204O\1983Z\175\n\250\166\201(9\232I\209dZ4\156\181\190\239z\179\144\003\212\128e\153\147\001\181\194\237z>U\190\239\249R\182\180p\234p\239\161\146\218\212{\148\187\2367\150\129\185c*\205O\168P,\143,y9Q\020\2255E,\203+\231\170\150\175\231\163\178\209\185\251\213\169{\185\251\229`WyL\142\24533+\170i\240l\128'G\206\197\021\239N\138,\205\253\146\157\019\154\229\157\011\216\229\229\138\226T\195\153\218r\204\168d\227\204\024z>\162An\181{\162\129D\191<\189\2285D4\204\019g\154z\025\2235\140\156W=\215&\171j\155\234\184]\166\236\231@KY\149\rH]\215BL>\166E\2481\239\021\240c\127\182\188\152\1657{\191\163\185\196\142n\186\140\226&\154.c\170\214m{\158\230:\244N@|\201\189\204.\228]1K?z^\210\178x\159\166\1824yh\233\146\2363Iy\246\178[\249\028\198\019\030\127j\018\\\209I\005\189\223\140\173\180Z\017\007\20284\r\210\167E\174\185(\205\002D\185<OsC\018\215Msch\242\180\181\028M\232+\220Zu2\236\214mg\243\226\243+\024x\151\211,\238\195U`\244\253\247lT\206nt\226\148\210\155Iq\024\242\007\164M\179\197\176\232\2226r\190lv)y\030\141r\158\226\155J\2388\187\tt\2365\219%\127\23659\1601\187\149.\191\152O\170\249\142>\159\012f;\152r\252\250\0141\207r8*\246?\191)Z\254Y\182]\233|eZ&\229\188J*i\156\222\227\133\211\227\202\250\212\180\146\2423jY\195\241\153\150\197\206=7\222\229\210\208T\206\181E\166CoU\166D\159TO\169\205\220\183\253t\149g\202W\253\152\167_\184\193@\202\145\161z\245rPHR\165\178\157\159\207\1535\170i\149G\156\211Y\206_\239\183w\020\209m\147z\189\164\003\b\243qavV\230\016\242\230\236bj\236\166g\201\254z\215\152\027\246H\011\144a\207(\158\165\170\165l\238*\134\229\246\242\017\213Y\230\244Tm0\244tR\160[\189R\232r<\181\144=\165=BX\007.\171\147\205<\155>+\243\255\027Y<\224\220\017W\014r(+5t\183\142\214\204\201\163%qI K\163$\021\n%&a\n\215\201\230\132Rj\189%\030\149\249\234\214b\022\178\210\224n\20233<\172m[\211\184\219\249\213\170>^\022T\194\201\138\180TXnW{\213K\167\177\254\176\152q>\149\150\146\244\230FT\127W\127\238\154\226\190\206\188\147vK\233s\"\174\005\216\233\r\197%\165\233(\155\n+~\192\027\168\207k\181\145.\175\173\237\235\201\172\223k4\155\197\201\225g\172\185\238\n\150\2084\185\163\161\241\2292e\254=\001M\nQ*^(\014q\196c\232\133Y\030\253\249\169`\222\255\176\183\019\147\221\166\190.\135\158,|\198\199i\174\206P\210\240bQ\236&\127k\232\b\153\028\151\252m\127\175\206Y\166\131\151\023\213a\255\235\230i#W\2397\2196\011mgIg\175.\222\255k\240f\208>{2\204\191S\191\174\128d(\rPZ*\208;\253;\245\222\n\208\214\019\248R\255\198\151\234\161\147B9\232\020\150z)\005\152\142W\225d[\133\164\237\006\nHD'\192\007\245\251\170u\192\152/\200(\026\209\181\020\252z\240z\198\191\169\154\002\232j\n*\213\020\140\170)\128\173\166\224\185\154\130\016g*\164\231~\185\190ig>\242\239\181\194?\r\250\179\207tA\202+D\244\020\176Q&k\208\173M\232\214&pk\131nm\nnm\156[\243\186\178BR}\249\250{\183\168K\191\159\213\239\147\254M\186\011 Zf,\021Q\173\135\000\1686\161\208\1422\138\141)\225\239\028\000\205\138\208\176m%\217\165\003B\189\194\166F\"\239\024\018\128w\b\141]DB\244\019\193\208\006\t\133\134\152\208\015\b\232&I\b\182\203\012\135\1413\tU\011%\000\154)\161Q[%\145o\176$\128VKh\220tI\136\237\151`l\196\004\219\150\156@\213\156\019\176\198\018\186a\019\130\173\155\224\160\137'I\131\206h\194\232j\202\209\213\148\162\171\t\163\1719\023]M\028]\142\n\b\182|\144\192\239\216\174\159\01789\0008\130PO\020\169\237*\162 \000LF(\016EF\145(\018\254\206\001@\020\132\134D\145d\151\014\b\245\n\137\130D\222\149$\000W\018\026\187\146\132\232J\130\129(\b\005\162H\232\007\0044Q\016\130D\145\225\144(\146P\017\005\001@\020\132FDA\"O\020$\000\162 4&\n\018\"Q\016\140DA\176%\138\004*\162H\192\026Kh\162 \004\137\130\224\128(\146\164Ag4at5\229\232jJ\209\213\132\209\213\156\139\174&\142.G\020\004[\162H\224wl\215\207\b\156\028\000DA\168'\ne\004\197\022\026\005\227i\017\240\134\017!y(\225\187\024\005\026\209\162\144KT\129\203\024-\171\030R\139\150\251\b\208R\b\003-\138cA\151\192\128\2082\224\028-\002\226Q\162\015!\170)H\195\200CF\022\146\145*\161\024I\163@KZ\020q\147\150{\130\210R`)-\138\169J\151@\190\2102$--\179\204\165$\138\190\020\186\014\203j\"\2110\178\153\150\005\148\166\196M\232\230\166\028\228\205O\130\1889\027\228M9\200\155\159\006ys&\200\029\245i\153\229?%\249\030r\214s\136\158b\0208Q\139<12\162hQ00\186\b\128\018\149\000\t\145E\239\"\012\200P\004!\021\178\2482\194J\202\134$(R\031\029\"\131\216\016A\028\025\"\199\184\016\tP\159\b\128\248X\240!\1924\233\t\136\148\167$!\225\177\\\209\157`@v\"\136\168N\164\158\232D\0064'\130\152\228D\142\020'\018$8\145Xzc\\\145\027c\235\160\156&6\001\145\214D\018\144\026CM\224\194\166\020\174\205\217pm\206\132kS\n\215\230'\225\218\020\195\213\145\152H,\1331\254=\224\150\231\000;E\024P\151\b<q\165\186*\214\"\000\204J(\240UF\145\172\018\254\206\001@S\132\134\028\149d\151\014\b\245\n\169\137D\222\209$\000/\019\026\187\152\132\232_\130\129\139\b\005\"J\232\007\0044\005\017\130\252\147\225\144|\146P1\015\001@;\132F\156C\"O8$\000\182!4\166\026\018\"\207\016\140$C\176e\152\004*zI\192\026Khb!\004Y\133\224\128R\146\164Ag4at5\229\232jJ\209\213\132\209\213\156\139\174&\142.G\029\004[\222H\224wl\215\207\b\156\028\000\\A\168'\n\210N1EF\192h\025\006\174`\024\201\130\004\239<\002t\145\225\144/Hx\233\145X\189\1442\178\204{5K\192\173\025\142\253\154\165\232\216\140\003od\024\136\131\224\015\014\209\212\145!\228\014\198C\242 \169b\143\140\000}d8\226\143,\243\004\146%\192 \025\142)$K\145C2\142$\146q\203\"\132*\026!d\237\202h\"\201\0162I\198\003*!Q\227\220\211\196\129\215\156\t\188\166\024xM\028x\205\217\192k\n\129\231(%\227\150S\b\253\2388\224\217!'\143\000\175d\216\019\011)\163\136%#`\192\012\003\1770\140\196B\130w\030\001b\201pH,$\188\244H\172^H,Y\230\253\155%\224\223\012\199\254\205R\244o\198\129X2\012\196B\240\007\135hb\201\016\018\011\227!\177\144T\017KF\128X2\028\017K\150yb\201\018 \150\012\199\196\146\165H,\025Gb\201\184%\022B\021\177\016\178ve4\177d\b\137%\227\001\177\144\168q\238i\226\192k\206\004^S\012\188&\014\188\230l\2245\133\192s\196\146qK,\132~w\028\240\236\144\147G\128X2\236\137\165\127\169\162\149t\r\198K P\n\129H(=\252\014\175\129L\018\024RI/\186\196\235H\161\144D\146\196{2\225\224\199\004\198^L2\244aB\129:\018\b\196\209\131\031\224Z\147F\002\1442\b\r\t\163\151)\186H\215@\022\t\140\168\"I<Q$\028h\"\1291I$\025RDB\145 \018j\233\161\191R\228\208_\175A\174\137!\001H\011\t\rH\161\0234`\250&\n\161\166\024BM!\132\154(\132\1543!\212\132!\228H \161\150\002\250\171\239\208V\159\225\250\132\215\208\244\019\232\027~\nW\213\242\t\0003\017\nm?\163\216\248\019\254\206\001\208\252\t\r\219\127\146]: \212+\164\000\018y\007\146\000<Hh\236B\018\162\015\t\006\030 \020\136 ]~@@S\001!\200\005\025\014\201 \t\021\027\016\000t@h\196\007$\242\132@\002`\004BcJ !r\002\193H\n\004[VH\160\162\133\004\172\177\132&\006B\144\025\b\014\168!I\026tF\019FWS\142\174\166\020]M\024]\205\185\232j\226\232r\020A\176\229\136\004~\199v\253\140\192\201\001\192\019\132:\162\248k\023c#\254\205\166\206\128\182\145\160\218\244\025#\203\b`\141\"x\182\135 \217\020\130$+\240u\250\003\018\175\199\249\154\254\232C\006~\201\005&\249:\023\200@\170\023\148J \022M\205\020\138&\208\021%\130\196\194\004C\241_\007o\216\236\191\230\157H\n \022\021@\219^P\231\194_\243\140\149\002\178\141\005\2016\022$\217X\174\137\216\024\144\182\250k\215L\025o[\232\138\127S-\004\016\245\024#\243\240\195\178]2\144\140\171\140C\000X\136P0\019\161\145\173H\228\rF\002\176\026\161h:\130\209~\004[#\018\b\150L\232\rVx\141%\148a\t\000\235\018\234Mlb\214\190\197\025\187?\020\169\141\157\0004vB\209\216\t\r\141\157D\129\177\147\000\141\157Pg\236\004;c'\024\140\157@4v\143\222`\133\215XB\027;\001h\236\132\006\198\238\005h\236\030\004c\191\237\236\188\228\223\244\002\001\200\186\002h\195\n**\bF\230\020 [R\144lDA\146\253\228\154L\199\192\134;\227\183\249\147m\n m\005\b\178\142\183\234\179\029\n\179\185\198[>\002\174\016H\"\222\210\007\179\2125i\203\000y`\196\128\244\203o\243\199\254\020`s\220\183\230kn\nu=\255[}\228U\1296\019x\203'(\021\002]\252\219A\173\127\163\134u\168P\029(T\227\187\2350\001y\203_\161P\136Mj\223\230\131u\002\228\024\022\187\030\218\1823\203\1913O0@vU\128Nh\t\254{\215\018\168\183\254;\183\004\001(\182\004\208\182\016Tl!\024\217B\128\\gA\178\031\004I\177%\215d\004\0066\2507j\187Am7\161\182\155@\219\rj\187q\218n\156\182\027\208v\131\218\218\252\227\239\152x\252\189\203\136\185p\131\213iB\237\155@\251\006\181\135\196WpW\171\198\213\1701\181\186\232\198\1323\254m\201\231\194\142\004\005u\\s\193\227?\001\194!\205\133\140\250\004\161\182!\128\165\156\139\129\2443\023\2040\002\228\150 \128\239'/4\195(L\024F@\219e^\b\195\b\002\029\229E\1990\242\0275\172C\133\234@\161\026\223\r\012#\184\211)3\140\000\182\135\190P\227\179\011\028\154]\132\163\178\139`@v\129c\177\139\1940\236\194\141\192.\220\224\235\002\198]\023\221\128\138\189~\194h<\249\184\211\164wY\128\2251F\022\197\183)\240\147WB\212\027Y\220\000L\017l\011F\b\205\194\200\160\133h\153r\185\129!*\141\012\154\144\149\005\193k\n\2488\182b\223\198\140\028B\222\2000\202\141\016\027\161\022\214\005\248\140\017\234\159U\180>_\209\250LE\n\205\216\0209WWl\220F\006\237\\\203T\14770\180~#\139\136\192\020\240\156`\196@\015F\0223\133)\130\164a\132\200\031Fh\169D\139NqK9\157a\006\2075\127\244\147\139#\190\200\243\138\n1S\138\140\223\232\1395\143R\254\232\231\220\166|\145\231\128\004Q\211=\012\218?\175\128\130\140\2063zb\131\252\193\213\021\192y\242\0159=8\178\b\2146<=h\1337\014Q\149\151\211vS\139\160\025\252i;+)\025DI\209*|f\205\214\026\237\227\206\172eA\178\1336\018!h\164\012\135F\226\233\t@\148\145x~\130ke'(\016\014\140\148$%#))\026)\137NXk4\018\161\129\145T\165\141\1694\238\012f\132\177\217\020zS\192\181\t\021l\012\169qgN-\140\140\170\228E\211b\025g`KP\145\221\156\177c\130\202\226\212Ihc\019\130f\206ph\224$\188q\1362j\002\1809\tAC\018\028\1520IJ\198SR4[\018\157\176\214h*B\157\145.\213\136\248\018G\196\1518\"\190\012G\196\151\193\136\248\018G\196\151nD|\233F\196\1510\"\190\196\017\241e\231\205)\255\182i\218%x\144\225\027\238\179.;\175q\205\255\213\253u>\250\253\137\189y\201n\019@\170\199\024\rv\249%y\176\155\129\244\012e\\\002\192\194\132\130\153\t\141lM\"op\018\128\213\tE\211\019\140\246'\216:\129@\240\004\247\140\182\194\232\147\168_\1802\229\029\238\021'\006P~\226nra\001\240\152\235$\173\000|g\023`2\170\140\175\188\168Qp\165\022\129?\181(r\170\150{\207j)\184W\139\208\199Z\134\142\2142\235m-\001\151\2193\138\129\157\208\249\197\019\138A\001\021\006\246\136\222\196\163* \236\193\189E\128Bh\196\199\246\002)\004\137\146`\164\240cT\156\b\006Q\"\002\136\017\017D\017\"R\031\031\"\131\232\016\001\198\134H02Db\227Bp\136\n}\132\203Y\004#\162p\128\203\137U4\2323M\019\196T$\232sN\011\135A\020D\167\156\156\012\"\128q\244\127\178\186r>\001\224yB\193\237\132F>'\145w8\t\192\219\132\162\171\tF?\019l\157L x\152\143\199\216\n\163o\163\1951V\166\188\202GI&\006P\254\228\179%\011\011\128'\221\201\018+\000\031&\016\029h\134\225\202\143\022\007wZ!x\213\n#\231\218\018\222\199V\014\174\182B\244\184\149\162\227\173\212\250\223\202 \012\140\240\170`=\012\n\016F\177a\138\168\0161\184\138\020\131\171\1281\184\138\027\139C\248X\161\143\"#\135`22\140)r\138\138\166\140@\028e\024\"(\195Q\236d\153\143\154,\129x\2010FJ\1981F2n\163#\163\016\023r\006\006\234\142\177\016\158\128\001\161\242\191\028\019\153XD\249\\\014\142,\000\001?\251c# \001\223\018\138^M\195(\229T\002\192\167\132\130K\t\141<J\"\239P\018\128?\tEw\018\140\222$\216:\147@\240%\015\153m\133\209\147\209\128\217\202\148\031y\184<1\128\242\"\143\159\023\022\000\031\186\209\179\021\128\007\019\136\014L\245U\014$\000\028H(8\144\208\200\129$\242\014$\0018\144Pt \193\232@\130\173\003\t\004\007\242\182O[at`\180\233\211\202\148\003y\139\228\196\000\202\129\188gra\001p\160\2191i\005\224\192\004\130\003\223w\190\203\219S\223\179\223\020B>S\136\217<(\176\154\133\0170o\031\020\132\247\t\n\196\027\005\005\162\157\130\002\144_\004\217\168:l\236\186\203{^\203\023 X}y\175\215\242\005\179\235,\239e-_\016X\026z\159\215\242\229\218.\154\188\231]-\203\012\200\186\192{^;\019\128\194K\001~!\241\189^\026S\152\172\135\th\215\017\223\203\202\151 \176S\231}\183\198%\191Q\195:T\168\014\020\170\241\221u\184p\249^V\168\004\177K\148\239y-\138\001\222\213Bv\253\160\246\189~\192}\175\031\194}\175\031\130}\175\031p\223\235\135\194\190\215\015n\223\235\007\183\239\245\003\236{\253\216\173$\143\249\183e\202\143v\205XP\199\132\031yuX\128p\223\198GY\007\022\132,+\128\229\189\143\029\229M\248\183\221d\245\017\136\142\225k\014\248\143l{\001\130\022\248Q\219^0\219\002?\162\237\005\135\150\249Ql/\136i\153\031\021\015\127T\020\252\177#[\198?\217h\255\168)6c\169\136\242$\001\224NB#\159\146\200;\150\004\224]Bc\023\147\016\253L08\155P\2408O@N,\000\190\143& \173LE\001\001\016\n\132F\241@\"\031\020$\128\200 4\014\015\018b\140\016\140\129B\176\141\022\156Q\253\1363\170\031y\002\213\150\192\br\019\168Y\144\172\171\194\136\000\b#B\1630\"\145\015#\018@\024\017\026\135\017\t1\140\b\1340\"\020\194\136\023/'\022\1280\138\150.\173L\133\017\001\016F\132FaD\"\031F$\1280\"4\014#\018b\024\017\140aD\176\r#^\138\181^_c\149?a\t\012#\183\014\203\002\187Oi\028\193\024R\165}Ja\129 \188\130}J\161\172\016j\209>\165P\136a\023\236S\138d:\004\1315\225X\022\134\163\002uPj\024CS\203\194\000\213\005\1300\213b\012V-+\132\172.\226\002W\011]\248j!\004\177]\024\143\"o\029\027\237S\\\218\005w\188*N\226?\225\180\208\159xZ\232O\179\022eA,j\014VX\208\021\181\135\129\016v\197U%\240\022%\130\219\174\244(\236\202\141\194\174\220(\236*\030\133]E\163\176+7\n\187\242\163\176+?\n\187\194Q\216\149\027\133]ud3\229\223\182\021\\YZ\017\212\197\251\021\019\136\000ad_\tU\bb\247\174]1)0\176\209\no\156m\243Xq\206@l\218Md\218\1413-\015\023\229y\222\178\027\180l\0300\242Mw\245N1\226\021\015 \0250/\173\\\173*8\151ze\199\144\n\142\170\165G\145\n\165\202\178\146\149\171k\229\235\250\229\244\237K\181\151\221\023W\221\200R\196\181S\189\142\021\173#Ekg\127\024^*\129S6\143/U\025t\003\0150\185\200\193\\8\229\015\206\238\135\240(\240\213\224X=n\209\203\141.\208\184\1357\177e\154\2002\141\179LS\178L\227,\211x76\024\178\207\250\226d.\156\226j\163L~\007\031\015\228R\246| \194\200\128\193\tA\148\005f\177g\004\017v\172\b\167\004\017\007\147\216s\130\000+\166\1809>\160\017g\186\028\031\004\192\158a\142\015B\228Q\155\227\003\n\140\154\208\141\171\226&v\029\018,\161g<\183)zn\019{\206\145.\193\005\199mB\199!\007\231,\1934Q\147:\192\003\188^Ul\017G\206\025.\155\164*\154$\228j\018\001a\019\026\027\171*\024\203\241w\130kW\176\142+[\159\169U]\172U\029;\186\196\238$\141k\230x\158\224\208\223\142\241\019|\240H\\\221C\236\219B/\144\132AW\144\004\141+\218\196om\206\024\185)\026\185\137\141\220\1565r\019\027\185)\132O\019\182\181g\135\156<\018W5\234K\148mM\143\162q\2474-t\189\139\022\198\182\213%\"\011k\185\179\179\022\250^GK\189Y\181\020\141\171e\174\031\178\147\004\211\b\198>\1694I\016\022\b\250\167`\146 \148\021\250\170h\146 \020b\191\021L\018D\178M\193<\155s\193\226\2503-\251i\172l~\018+\155s\177\226\2519-<\027*\1553\161\226z>3\138\181\188\228\007\184\225#K5\168\206Y\214\247\139F\2483\211V?1m\220S\234\002\216_j\2179\211WgM\239{P%\172\0117\213\231\012U\255\212\022\245OlQ\159\011\179b/\171\203\156\179\135\239q\181\240L\180\249\222W\t\015%\252\156\169\014\231b\170\212++4\234\155\149\184)\220\214\156\211\169\249\169\251\154\159\184\1759\231\190\230\255\195}\2059\2475g\195\1859\195$\207\005\252T\194\207\153\201\247\244\215\234\019'\215\248u\147k\252\176\201\245 \250\166\201u\2409\147k\252\146\201\181\251\136\201\181\251~\2015|\186\228\026\191Zr\r[0\174q\247\1975\159j\000\000*fO5\000\026U\209\157j\000\001T\022N5\000\140\2136\167\026\000\004\003D\231\003\174\195\243\001\215\246|@\132\130Q\130\243\001\145(2O|> \146\130\161\162\243\001\145\012M\230\207\007D\0180^q\243\252uy\243\252\181\222<\23910\161\219<\239\005\145\249\162\205\243^\006\166\243\155\231\189\004\205\134\155\231=\014&+\2365\191.\2375\191\230\189\230\000\128\161\236^s@#\019\185\189\230 \000\227\192^s\128\209,f\1759\128`\144h\215\246u\184k\251\026wm\1998\024&\220\181\029\011#3\149vm\199r0Z\188k;\150\162\t\163]\219\177\012\012zf\003\243\245\185\r\204\215\178\129\025\0170)l`F82\163\223\192\140\0180\029n`F\028\205e70#\n&\nw\000_\199;\128\243\n\228\027\143\128Y2\012f\201pd\150,\243f\201\0180K\134\209,\025G\179d\220\154%\163`\022\130\193,\132\162Y\250'\190\193k0I\002\193 \t\140\204\145$\222\024\t\007S$\016\r\145P4CB\173\017\018\006&\232A0@\143A\245o\212\023\214n\240\011k7\248\133\181\155A\244\133\181\155\224\011k7\248\133\181\027\247\133\181\027\247\133\181\027\248\194\218\r~a\237\166\251v.k\254\206\250\227\006\190\152\203\240\165\254m\029{\019\206\181\220\004\019,78\171rS\152J\185q\243'78ir\1313%7\003\249\018\222\rO\137\b@\021\021@+-\168\219\158|\195s\028\002d\229\004\201^\016$yA\174I[\006h\1486\149k\154\158\152\017\160]VaP\229\185\007\005DAU\005A\165\231\021\004\196H\171\\\164U.\210\242L\001\003\181\254\141*\215\161\134u\160a\141\202\192\b_p\167d\030\202\011\128\209/c\246lh5ffo4\202S\r\198R\019\134N\019\132N\131\161\003\131]\193]H5.\164\026\019R\235\142uf\252\219nOY3\235\b\016\236\129^k\214\017\204\238\129^\011\235\b\002\251\175\215\153u\228\218n~^\171\141^k\220\221\181\014\183t\173\131}\\k\220\188\181.\236\216Z\187mZk\220\155\181\198\rYk\181K\127\141\187\244\215\184K\127\029\238\210_\007\187\244\215\184K\127\237v\233\175\221.\2535\236\210_\227.\253uf\140e\190\174xC\211\026?=\185\198OO\174\195OO\174\131OO\174\163OO\174\241\211\147k\247\233\201\181\251\244\228\154\t\131\171P+a\141*\215\161\134u\160a\141\202\196\223\162\\\187oQ\174\241[\148k\252\022\229\154\t\131\237\220(a\131J7\161\210M\160t\131J7\005\165\027\167t\227,k\191\247\180\238f\1768\170O\216\218N\174]}\234\023\162F|\145\231\185\004\201KN\130\152YA\129\213T\160\128y\254O\016^F\018\136\167\241\004\162\185;\001\242*\017#-\173,g\249w\238r\0240]\014\163\170\203a,w9\012@\151\1958w9\140\228.\135\129\220\229d`#\147\233\159d\177F\016\155\154|\130e\025)\231\191\028\243I\022`\004\129\174\228\147Zj\145BdY\001\178e\025\161.q.\215)A\225\002\166t\229\170\197\203#\n\t\235UE\2452\171\031\130\186\218V\174\182\149\175-.i|\026lU\232om\251h\0018\130\247\169_\246\224{kW\213:\174X\029U\172vU\192\245\011\017p#\017(/U\b\226\028\199\025\014#*\195aw6\186\0215\174\1937q\243n\162\230\221\184\230\141s\250\"\240\237\190\241\237\190\129v\207\019\207\136\160\218v\234\025\225\176Jn\242\025%X9\152~F\220\213\198L@#\138|\198\007u2y\216\131:\128F\244\230\014\234\128\000\136.<\168\003B\164<{P\007P \191\132j\222 \004\027\017\193\192\133\132\134\237\139dA##\t\1824\130\1451\bv\180A80%\161v8\247)/\029\1526f\214\019\224\001^\175*\182\136\163\209\012\151MR\021M\018\178*\137bkU\177\181\170\130\181\028\211&X\209-\001\192\185\132\"\241&\184v\207\171c[\213g\140R\023\141R\1995/\2092Ic\1878~&\024I\218\174*\001\028\208u\0184\142)\154\152\001\1553T\215\020\169\174\137\169\174D\230$-\016aS B\228v\189\004\020\128X?\183\b\020H\194\202G\203@\129\016M\224\023\130\002\145\171*.\005\005\002d~\150(\242\023\012\248_\004Q\023 R\223\011\136\012:\002\017\196}\129\200\177;\016\t\244\b\"\128N\129\005\154\023\005\196\198-\018\232\029D\0166|\017\007m_\132\216\252E\130m\\$\142\254D\004\253\133\b\160\203P\171\127\166\169\227\170\160\127R\168lU\180\154\235A\148\228\172\217\170sf\011\187\018\145\022\141Z\021\141Z\149\141\234\186\021\150\168\158E0\232\\D\128\253\011K\234\232\217u\209\164\245y\195\213\231\012W\023MS\234q\164\128\027\016\136\b;\030\145`\223\227\150\151\189$\232\129X\214D\164\213\020y\1869\207\198\20596n\138l\\\234\147\164@\153\174\1552]C\231\180\233\254\234\2178\255~V\191\229\147\171\027\252\218\234&\248\208*Q\154zZ\002\158\0178\225-\248pB\253\027\0185\1707$\224\025\129\019\222\130o \212\191A9R\189F\161\207!z\n\159\128o\213\"\255jF\212\139\025{\014\176Sp/\190R\004\254\133)\240\212\219\018\240\140\192\to\193\151\016\234\223@\241\169^A\200\179CN\238.|K\134\253k\228o\252\142-\242\236\144\147\187\011_\227\255\198o\150\228\191#:\214\215\207p}\130\242\248x\252;\162\025\231?@86\1923\002'\188\005_\224\254\000!\tn\219\127\249\131'\183\176\228{;\216\241{\218\223\182ki\001\179^*\176]k\184\1975\227[\245\231pn\241\207\225\220\134\127\014\2316\248s8\183\248\231pn\011\127\014\231\214\2539\156[\247\231pn\225\207\225\220*\147\223\170\025\229[\156Q\190\rf\148\239\228Oc\209\245W%\251\026Y\237\206\142\151g\026\252\138\165\226'\216\243N3\r~\197R\133'\216\019\212\252\012\130\191\250\146\241s\250\206\243\248ms'k`\233\145\248\149\239\161\019\130\004-\162\134\141\025\248\206\145\172[E5xQ\248I\225\224\191*\240_\0219\163\130a\171A\149\018\216\185\017\240\130%NX\002\021s\189]\022D\142\174\224H\148A\149v|\166\199>\236\005K\156\176\004j\231N\248\176\192\237\133de\252^\200@\164\149\141\186W\141\190\132eOaYW\129\176\211\205R7\016\153\001\1425\208\189\244\004\031\242\028<\248%(w\n\202\161\222Q\207\2052\030\150\160\218,pz\179D+\206\224s\244\240\151\168\228)*\233\148\023\137\215\222\236\128\204\250\217\029\144\022U\026c\138B\192\011\1508a\t\212\208\229,Y`\247\202eE`\175\028\192JA\151\224d\228\197\1499\1852\168\164Oy\178\196n]\203\234\192\2145\128\149\150.?\202\200\139+srePK\1591\145\228a \127,\239\129\167<\004\176\127\206\252\193\206p\b\234R\153\007\158\207\016\000\214\143\031d\250B\016\179~\252\192\147\021\012\1445\249\186\141\226]u<v\195\239%A\186x\133\021\130\253\007\015\225\254\131\135`\255\193C\180\255\224\001\247\031<\184\253\007\015n\255\193\131\218n\240\128\219\r\030\194\237\006\015\193v\131\007\220n\240P\216n\240\224\182\027<\224v\131\007\220n\240\128\1277\241\001\018\134\185\129\019F\249\197\231\254\200\017\255\206#r\006\2424\144\000\2308\017\193)\240\014\014\128\199\017\n\207\204h\244`<\027\021\193\240\146\240dT(\011^\168\255.\138\251\147(\209_C\249:\144\134\251\149#X\000R@\001>I\255\170#Xa\018\193\002\218\204\253\171D\176 \144\161\127\237\"X~\163\134u\168P\029(T\227\187\235p\212\240U\"X\016;\178\249\202\017\156\0018W\025\194\160yt\1702\150\005\021,\156\169\140\197\222\015\209\137\202P\134\150\bOTF\194\186\000\1591B\253\179\138\214\231+Z\159\169H\193\213\225i\201P\b\001\016\029\150$\217c?Y\200\191m\235~\132\169AF\213\140 c\246\003\167\143n\254\143q\248\192\233\163\154\237c\196|\224\244\177?\2377\203\191\179\142\012(m\018\182W\149\218c\165\246a\165\246A\165\246X\169}\161R{W\169\189\171\212\030*\165\231\149\246\170\130{\172\224>\170\160,6\014\r\000U\141\150\026\173\200W\026\022\026-\026W\031\151\025-\140\134\176\139\140\006T&\225\225\167\1732\026\199\r?\179@\190w14\000X(\250\218\133\021y\011\193\183.,\026[\b\190t\0010Z\200~\232\194\128\202B\242\153\011Se\180\144\027\002\179\000N\029\015\003\024\173U<s\028\021\b,\023\1578\142d\005+F\231\141C\161\179hp\2208\016i\235\194a\227\192h\206\210\241Q\227,N\196\171,M\000\216\152\208\200\186$\242v%\001X\148\208\216\150$D+\018\140\246#\216Z\014'}\247<\199k\171\140vrs\188$\168a^\183\198)\217\186{\025\023~V\191e<P\171\156\178\198\156\178\014r\202\218L\163M\r\136\239g\150\202/\230i4\011\188\224\211O\014\000\197J\139Fu\241\208n]>\180[\219\137\170\172\155\157\168\n\208\151\240\181\167\024\133\n\156]\029\170q\162j\1388\214@OTeM\245D\149\195^\130\151\157\"\012\244>\179\196TG\135]\235\240\176k\205S=Y1\158\234\177\192\011>\253\228\000P\176\180<U\15999Z\159;9j\133Je\131?\023\240\151\130\002\167\018\014\213\177B_\171\240\176g\029\031\246\172e\002+\235*\019X\128\188\184W\156<\002\186\022\215\236(\193n\021\156\205\012@\015\0004\031\244\177\1689\237cE\242B\016\228s?\022\229\195?\022\230\019@\022\166c@\022\204g\129\012z\139\192\157\003\194\n\211\242\141Ci9\006\241\228\234\149\001\239\177\212}[\197\205\019\162\238\213U\168P\021*T\149=P\149<`\254\028\134\149\132\190\169b\223T\177o\030\016p\142\250\028\198\146\153j\001\217\023\004\182\014\bm\182-[g[\178\2066\180\1936\182\1936\182\193\127#\224J|=S\219\157\003\194\202\237\206=\"\255\149\016\131>\"\224\234\179\015\223\180\015Co\127\230\253\251\176-\214\014\b_W\151\189V\151\188V\135^\195?\171b\133\177K\235\208tuX\161o\014 r\183D\240o,vp@h\136Ch\247\195\025\187;\187\028\195\007\031\195\007\031\011\228v<\243B\015\156)\2208 \212\174)\251\191)\249\191\t\253\223\156\243\127\019\251\191\137\155t\019u9\223y\127!\001\207\b\200~Y\002NX\"w\216\128JE\173\224\007\234\240#\180\225\143\208\195?\002\230\143\254.V\029\254]\172\154\007K#s\2393\002*O\193-3u\184e\166.m\153\249\198+B3\186\230\133\139\012\156Tax\236\183\232\137\233\254\194\254\b-\141E\180\217\130\022H\236cH6U\178]\245\240\164~\189\158-D\150n\186\231\157\027\026\204\153\130\147h\213\252\195\014\209-L.^\146\163$\144\152f\236\228\199\016,\190\232X|\145\"\157@\246\019%\146\189\169\129\028\250}\222\252\219NI\0288\131\021 \152\1588\152M\220\140\217I\137\131d\171\130\192l\195\129wh\243u\222 \155\129\180yg\"\151}\160\207\242\245v@\141\234\144\147\027\185V\154\011\200\138\011\148\244\150kR[\000\210\154\001\253S\027\159\209\157\250\tZ\237\226\027\018\243\240\245\227`\156\127\238\213\207\244,\185N\241\162\174\213\179\005M&\229\235ob\205L\019lN\217k\204e\158\006S\254\169\159\207h#j7P\217&rA\227]\208\128\011l\143$0z\166A\207\164\254\135/\191K5N\234g\210R\174Y\161\012\165\002\170\161\016\000\173\133Ph2\132F\237\134D\190\241\144\000Z\016\161\216\140\b\198\182D\176mP\004B\171\202\019a\218\209frlf@idtm\221L`\224k\1468\135\019n\189N \248\152Ppt\222\136\b\215Q\219J\162\029^GU\216\157\185\2236\208\004J+M\215{\188\182\237\149@\219h3\024\180\\\018\217\230K\211\149\2246l\200\t\245\1739\225\210x\233:j\215y\225\201V\185\137\236\214\020]\223\020\\\223D\174\143[\189]r\0024\012\011K\002y&\215\154\224\132\215\150\019p\1466\227\242\247\011,\000\196`\255z\001\160\0171\248?^`\005@\012\240\167\011\000Fb\176\127\185\192\130@\012\250\015\023L\0003\196\144@!\006\186\182\209A`\016\029$q\209A\184\141\014\002!\002\b\133\b\200\251\139\225:j\216I\180\195\235\168\n\1873\247[bH\160\016C\186\222\227\181%\006\002-1d0 \006\018Yb\160\r\183\2246$\006\252\171\001\182\180\180~\186\142\136!\175\183\218*7\145\221\154\162\235\155\130\235\155\200\24511\216\149V@\195\176\176\196\144\151Y\173\tNxm\137\001\215X\025W\134\210\244\160a$\t-C\170\208\178\1440t\129\1286\180\024\201C\203\028\133h\161#\018-\004:\209\"$\021%\131\1683\018K0J\164hF\163\016qZ\020\197\157\150\251\232\211R\136A-\194h\2112\1409%+\160!\173(l\023\163\229\138\239~\250D\160+%R\164\165\208}\140\002\129i\017\208\152\017Ed\166\011\000\165)\209\1830h\028\189)Y@rJ\170\248L\163!\225\153\237\019\145\233\154\178G\154\159\132bs6\020\155r(\022H1\2168\017\202\206\004+\208\164\2175\017\153\242\020\163@\156\225\150\t\146\226\177\006w\156\161_\t\206\133\205H%\023\176y\176E\213\189\209Y\149cxV\229\200GS\248\222\2408\210\017\255\160#\226\250\t\158\239\184t\016\213\145L=\141\227\219\030mJWWxm\231\1502\024L\029%\209\r\\\175y\198.]\127j\167\239\2055\245n\022\148\158\201\224yB0\205\246M\156(\2254{\248\189\235P\137\018\190s/*\000u\157\002\152\253\154\140\170M\154\140\229\157\153\012\240^KFx3)#t.\143\175\2436\203\012\144c\151Y{-\171P{\222a+@\164}\021ho6\2082\136U\170\\\149*W\165Z\255F\r\235P\161:P\168\198w\227\238V\198\157N\188\143\149\001\180*|\249\239y m\231YR+\006r>\197\128I\162\024u;\147\158%]b\128s$F81b\132\178!\190\206)P\006((\230Y{I\143\158\229k\017\012\216\237\245\207\240m\bF]\222\247l\191\004\193\160\205\000\159%(\004\129\\\239\185\255\n\003\255F\r\235P\161:P\168\198w\215\225.\181g\245=\005F\242g\020\024\176\137\2293\007\005\153\245E\029{y\193c//x\236\229%<\246\242\018\028{y\137\142\189\188\224\177\151\023w\236\229\197\029{9\245\\\198\191s[c s\025\003\193\222\243\147\2252\198\236.\243\147\2262F`c\252\137\185\140\175\237\150\241\019wR\195\012ha\133\234\195q\129SxF\224\020\028\0128E\167\001Nx\004\224\228\246\253\159\220f\255\147\218\225\127\194m\253\167p/\255)\216\192\127\194]\251\167\194V\253\147\219\159\127\194M\249'\220\137\127\146\014>\219\149'\156\199\022\000\253\237\1323\160Q\213\220\1323\b\160\1460\225\0120\154\218L8\003\b5\182)\155\173\181+V\133\181\198\224\202h\177\214U\169\214Q\172\145$\180G\021\219\163\138\237Q; \172N]V\188.)^\135\234\021\002\147\132\177\238\024\162\132\134^s\193\202\234\169x\021\012j+\002\136Z\017D\150\016\1697\134\200\192\030\"\192Z\139\004\157&\018\027\199\130\131Q\220Ilg\150\168pU2\011\134\181\018\1563Ku\198,Q|\139\176d\179\170h\179\170h\179:\194J5\173\207V\168>S\161\186\164s!\244E^\172\0196\000\017\148\220\141\205\224\199@\242\187\031\146\1951\144s8\001|\006\250\195\228p\130\169\028\142A\155\150\254P9\028#\144\150\254\232s8\254\141\026\214\161Bu\160P\141\239\198\028\142q\167\019\231p\012\216\204\248\007\247\001\000\128\182\182\015@4\168\136\235\003P\224ml\251\000@\177f\208\007X\184v@X\157\186\172x]R\188\014\213+8\004\250\000\128\1935\182\015\200h\178\184\007\160B\132\130\1272\026T\147D\190\154Y\224\253C\0180\000\161XG\130\209?\t\174\029\016V\167.+^\151\020\175C\245\n\254!a\172;\250\135P\240\143\216)\006\161bJ\002\190\210\146\160\218J\236\171\174\133\222oJ\n\198Q\018\180\129\018\161\015ET\135`\177\202\245\249\138\213\231*V\023U/\248V\021(\215\r}\172$\226\231\223\246\247\023\213a\255~\179=\028\243\197\175\155\167M\247\251m\189\127\250G\245t\216\222\029\255\031S\224c\026"

let helvetica_bold_oblique_afm () = "x\001\181}]w\0277\018\229\187\127\005\031w\207Y\205\146M\178I\206<%\1773\147\216\137lGMZ\243FK\180\1965%:\164ZT\251\215/\186Q\168\143\139jz_\246\228\196\135\188\023\221\r\020\n\023@\161\154\250\235i}x\250u\255\248\244\199\230\233\176\1899\014&\255\024\189\250e\255\240\176y|\026\252\178\255\214\028\182w\247O\131\255q\243?\007\163\197|\250\191\218\127g\221\191\139\246\223\197\176\251w6\248\233v\255y3\248\1719>m\030\142\131\223\030o\246\135o\251\195\250is\251\143\193\224\167\221n\240\177\189\207q\240qs\220\028\158\003*\0159l\214O\219\253\227\224u(\253\207\193\213}=\248c\221\012\006\163\193\168\248\231d\250\207Q\209=\129\203W\143\219\191\235\205o\175\007\147\241p:fx\249G}\\\223m\006\163\201d^\012\202\249t^\190j\219\245\231\250a3\248\207f\247\188y\218\222\172/~\222\239n/?\239\218[\188\250\181\222\237,=h\233\001\243\235\135\237\174\177%^\1736\157A\218\130\175~{Z\239\1827?=\222\2376\131\139Q\241\234\183\227\175\219\151\205\237\251\237\211\205\253\224\203zw\220\188\250\229~}X\223<m\014\127m\158\006o^\1586\143\183\155\219\143\251\135\245cW\187\159\127\222\191\132Kg\147\193EQ\204\007\163\209h2X\148\197\224U\021\202\029v\219\199\205\251\253q\219\153\231b4\028\n|u\191\189\249\250\1849\030\007\211\225\171\229\230pl\139\012\135\197?\134\161\212\159\251P\213\205\255\215\238\019\147m\143\131\245\224\233\176\190\221<\172\015_\007\251/\131w\219\199\253S\243ms\017\n\237\006?\253{\176~\188\253\223\251\195`\027np\172?\031\183\183\219\245a\1879\254\227\213\155\240\160\219\237\227\221_7\247\155`\229\174\022\127=\133\226\235\195m\226^\253\178\254\246\159h\244\217h\254\234\019}\158\142\139W?\029oZ{\030:\226\245&}\187(\134\179W\127=\221\254g\021\012:o?-\195\167\2010|\n\206\222\246Hr\246\241h\250\234\151\193\184\024\252k\176\2504(f\243\240\225\207\193\241\219:X\239_\131\159\007C\250\239_m\169q,5\238>\2529\216\188\220\236\214\015]\177\197$\148\025\0073\134z\196\178\147Xv2\155te\255\174\247\193\148\159w]\233\209b<\152Lf\131i\177\144\011\166\241\130\233\180\236.x\172\031>\183\157z\247\216]R\182\149('\147A\185\160\242\165-\127\187\223\237\214\135Xv\022\\e4\029\148E1\152\205\166\177\248,\022\159\207\023]\241o\155\195M;h\186\234\132{]\140\022\131\197p\020\170Cm\157\199\242\179\162\232\202\175\031\194\021\199\208/\221\021\225&\237\005\179`7\174\255\194\154\176kp\244\189\238\025\161R\147\2014T[.\153\012\173=\191\173\015\155\199\221\230K\188bV\182\2218\015\022\028\134\007M\226\021#\231\ny\200E1\141\215\140\203\133\\C};\166\150\175\143m\189\142_c\181&e B\213\230#\169\022u\243t\030\187\238\219\174>\198V\023m\031\004\003M\135e,9\177m\190\tJ\180\238\138\134\145|1*\231\131\"4\185}FWzj+\127\223|\187\223\196\222\157\141\007E\232\176\241l\017\028'v\216\164\180\247\014\230\223\238\163\245\203\214\217\204\157g\224\190\187\245\241>Zd<\235zj\018\2342k}\160-=\183\158\243}s\216\199\246E7(G3v\131\201\194\150\221?\198a1\n5\030\146\255\198\146\211\161-\249t\1387-\202\206h\170\224\b\n\222\0316\241\166\2294>?t \023.l\225/\251\250 \227a\186P%\199Pr\251\188I\214\234\238\026\156<\141\157\233\196\150=n_\162\001\168\002\186\1820,\143\155g\234\179Qp\182\208\178\153\186-\012\201\r;f\185\160\027\151r\227\025\140\247-\153v6\167\178S);\183\158s\179\223\237c%\022\173K\142\131I\167a\146\236\138.l\209\227\230a+\197\167etK}E9\180\238\190k\167\020r\247\139y\232\148i(\026\135R9\178E7\127\215\235\168h\161\134a\020\149\225\161\147P\247\174la\203\222\181\147\252&v^\1717\225\206\195\133\220\153z\175\028\141H=6\199n\206\139\218\017-\029\134h\017]\184\164\014\\\180\234\214\142i\018\025\242\224E\232\224\228\237\229\212\n\217O\209+[\247\153\rE\139\202\210\022\2519iP(\022\158\198\197f\182\216/\241\185\1958\202f\243\133<\023\004\244\181\186\225L\230\137\146\250\171\236\238\252\231\224\141*6\149b\179\161\181\207\175\170X\144Q.F\0294#!\2487U/\186\212\188\029\216T\189Ya\171\247\159x\195Q\184\225|(\237\157\141\173\178\252&\0024.U\245`@\253\158\198\232E(P\142UA\232\141\183\209\211f\237c\167s)V\218\230\190\147\230\182\016\023K\147\0269\251\031i\176\r\007\139\145\186\027t\197\159Rl>Tu[X\227]\154\190\157\023c6\222|h;\237\189\234\141\177<w\014\189\241An\024t\205\220\016z\227\163v\022u\195\177}\238_\209z\163\232|#\145\248\249\196\218\239\138&\187\206\235\167b\1929tG\021\203\141\2260\210\1420/\237\163\1514\r\020\157\017\213\029\169K\022\1478\236W4\130[c\007?\148\0017\159\219\027~\162*\1825\\\168\251\193\248\184\166\251\205\187\231\150\\n\001\003\228\191q\152O\187.\145>^\192\002\226sX\154\127\221<\241\162\163\232lY\134\249\178\136Fi\175\129\197\225\231p\137\204\176\163\"\206/\227\161\012\174\197\216}\138Z\168\140\230\244\156\214\t\210s&V1\215\199\155\237\246f{\184\169\227\026s4\030\133\133\2348H\252\136\167\156\005LOu\187\252=\134\181{\156K.\138\214y\131\021\166\161\235/h)\184\128\149E\183Rc\011\180b;\t\2509.En\0230W\1975\206\180\157-'\161\186\161J\180\016Y\204m/|\142#m\212\021,'S\233\007XW\220D\135_\196;\0066\2211ly\236-oyn\n%g\202CGCXX\208t:\164{\142\213=\011\219?_D\133&\237\202\177mv\208\156mXDt\031v\131/;\186\018\230\169\1878\159\133\222,\130\184\150a\022\145\135\192\024\140\238\018\1672\181\238\031\r\167\182;\182\162N\227\178\245\142)\149\131n\251?\177\135\195\2426<{\002e\161\195\190\202=\203\217P={n\239\185\211\207.T9\234\174\180{x\144i`1T\1575\130\206z\180m\150r#[n\175;\181\156\168\174\026\021\182\228\183\232\164\243n\139\215\185\148\020\1975D\188\233\144\138\150\186(\245M\218\019\028\164=\147\185\174'\174\254b\18519\254D\149,\173K\209`\n\222{\209\142\242\162[(\198\1463[\205\186+\185\152\199\182\135Ip:.\168$,\212\159Ip\186i0`R\016f\174\019\021l\215\232\243`U.X\192\"\253%\022\236\250g\162\158\\\192Pj\186r\201\213\202\169\190eZ\231u\0035\236&\006\188\190\234\148\129\203\141\173\201[M\020\213YL\162\030N\219I\172H\151\164\237\213|H\194+\203\199\162\152F\137\"QkE.\191\191\167\184\173N\243\019JGr\159\182\187[\218\229\004\203\140BoO\195Bc\220n\011\219kJ\152Bb\020\224v\127\162%v\183\232\t\187\202\169j|\t\219\024\222zw\138\023\170\214J^Y\208h+a+\211nXC\196\231N\238\031\246\028c\017\211QZ\014\143h\146\252\210\006\156\210\2349\198\150\218=\224\\\246u\163\018<\187\217\1688\195,\012\1654\195\140J\216\213|\217\237\015[\186u[\153\"\220\178,e\225;*A|\142\027\169L7\021\180\227\166\221\185\021\233\002\240\243\155\250\016\182\2457\209\233B\161v\139\021\\\160\221\193\197\242)\2120V\019\216q\219\005\225x\n\011{\226q!\235\136QZA'?M\001\0255\241\r\187\137o:WU\155\193@\184\171\183\225\138\135\189\172\024FmG\004\199\r%'\243\t]\005\243K{UW?uU\187\175\232\156D\174\026\247\\%^\028\188\164\189*\184\175\\\005\211\204\151\173Lfe\240wi\202\020\n\238t\193\169*\b\253\023Bji\177\0194\162\b\197\202\240\127W\203\1748\244\222\237\250\238\142\246y\163n\208\005\203\148E\169zb\225]\144bc\1472]\"\235\222QZp\219`H;\1386\135\205-=k\216\025\190h\rD\161\159\209\028\198]\136\023\173\239\014\235o\247\162\185\237b\170\237\241!\r\140\180\198\030OItB\136x\019\173\031\168Q\016\170I\209F>\210\019 \004$\190\248y}\140\2388\233\150?ep\2152(\014\0259\173\188\209\029\249\170.&7iW\162cuU\233_\165\227lE\023g\155\206\213\018c>\235\241bu]\187\146*\187u\"\187VZ\162\135Y,>.\004s\183\223\142\2198\011v\161\135E\b\251\165(\212(\173\213\185|\232\166\167\251}\205a\195Y\220W\132U\148\196mF\011X\011\164\173\191(j;\221\006\007\157\134\216\006+*.\177C\175R\188\167\141f\150\1615\237\216\154M\211C&\182\248\250\166~\138\197\011*>m\227-\\\028Buq\021\254e\183ya\191n\175\153\180!\t\190\006W\000j\026\025S\216P\182\b\163\180\166N\197\031\2147\135\020\239h\151\011\237\237\131\195\1493\234\195\005\196\128>\0316\169\193\211\216\130Ih\164\212\006\226@\183\251\167\245\rO;E\016\173\178]4\206\219q\031\0036\197\016\194\177\183\2190\184Ro\143B\189\219+\218\163\021\185\002t\238\144&\169\246^\211 \235\237P\153\209\194\167\024B\151\221ln\131\027\198\189D\023\167l\207?\138\"E\219\139!\198K\235\199\187\245\161~\216\173\235'\169\211\1446\022\211t\021t\195\254.\196,\191\242@\236\158\209-\244bi\232\133\1555w\194d\017\253\162\r\018\241\205\179\017\241\128\218\024\214\222#\022\199\"\173J\248\130\159b\128\167]q\141\218\213a\026\163E\145j2\139\005\247\135\219/!v\199a\193v\1293\t[\156I\152\220\146\019\021cX\029\191\147}\233x\002\193\146\"\029_p|C\021\158v[\197y\235A\020\127.\210\t\006W\253\242M\154\131\186A\220.\162\165\"\169\175\202i\170\253CXL\213;\169\2548V\127\174\170\159\194\249i[\177\142e\187(e8\005+d\031PL`\151t\219N\193\199\163\222,\021\178*-&\184\177\145\182vA\144\137\138\251\020)\200\205\187\017)\\\180K\222\160\164\161\230\211\146\156 E\186S\136c\031kM\187\151E\152>\185\214S\208\1820\207\133s\191 \216\199T\239\184\232oua\212]r1\178\021\255\205\140\194\184C\t\189\180\024MMq\158\171E\216h\227\219\206\213\201\127\177\244ZD\1326\243e\027R\129\210\188Q\201\006 mZf\243I\239#62\162R\133Fyi\142\238X\205\225(O\214\\Z\175\223n\159\183\183b\254\176A\233tv2\247\239.\198Q\183\166Ue*\204qb\208|\138\024\231\023\1761\229\238\201\152\142\2339\210\150M)\018s\235{B#O\208[\177>\211\031\187\227(\165\250\237\190\181\213?\189q\205\251\203\214K\133Oz\155\194\178o\026Q\022~i\219\197\250\138\030\159^+\to-[\0206\232\148=Au\243\025\171\178[\171\219\183\014\221ZHo\195\209\139\222\152\006p\164\030k\207q\2550\173\211\241DY@\240\159\007;\1735\177\195F%%\005\132\149\216\005Z\127<\163k\210\017?Kgh\239XT6\171\191Zip\237\231\229\196\181\253\141\026\190\139\222\225\203=\197\158\160b\131i\254G\195\252\153\185\231\"\182V\199\228Q\014w\210\183\157\232OC\249\222\001)kB]\157\030u\187\202\140\223\134L\219\250\232\12896\226\023\229k\234\016\168\183J\178(L\0261Z\244\247\148]\180\245\186\154\012x\238,\nQ\157\235\172\163^\127\157\147\006\014L\130\237'\237\182\tn>Y\208!\226\254\251\230\241.\022^t\177\160R\150\022h\196\143\202\201\210\145G&\203\233D+\235\166!\141Y}\186\149\141qP5\021m\235\245e\184\228\140\011\241\148\161FV\156.\130\215\224\200\226\144\163\234\172vV\159\182\017\129\158\186\220\232\174\154\2090\209Qrl\239\127a\185\159\142A\208s\146\167]\221\239\015\186\003Fe\238\241i\213\1687*\234l\012\219\201\157\171V$}\157\203\231YR6\029j\133\187d\1740\161\253\137X0\173\189\194\022\163o\164V\186\222jZ\192z\179\203\176\150ig\001-\227\189^\155\195p\172\187\176D\012}\132]m\209\134\132&\146R\147YR\237Y\149!{\023$R\156O\175{\203\202\194.\150-\028M\1625\212C\189{\218~\219\197h[P\151Q\023[\156\014\167\190Y\164\139\206\012\"\017U\181\159J\135\143X\145\164\025!8\243\180]\239n\183_\226y\204\164\213\164\176\238\158O{\007Fc\230b\179(\162=j6\235\128\136\181\147\rV\136\005\015$ \170\222\164\127\249\250\006\023O\172\216}\243\129\169\127\146\152v\023\006\213\231\229\153]|\012\127x\193\141\026~\139\222U)\159\215(\235t\135\002\211I\255v@\r(\229\n)`\145O\247\162w?2\252o\170\026\147\190Y^eg\133m2\165huNV\182\007\158C\184u:C8\236\191n\030\211I\194\180\213\141\208\1906\233*E\000q\129u\216\220m\143\018g\156Ni\1335\201f\027\158\163TlF\165^\244\182\214\138u\153R\t3\177\166}\248\177\0143\160$\199\180\193}:\214\027\250\178\250F\148\163\215#yZB\211O\250\151L{\229\001\234\236\014=\128'%\021t\227\t\169gQ\254_\241\150\222\178\211I\1722e\022I2R< \235\182\237\254\156\244\230\137\014c\251\022\228\188\188\211\019o'\210\221\130p\158\175\217x\129\138\235\1471\173\"\245y*\026\253I\201d<1ls\224\230`G\214\000\181a\153\r\211b\224\204~H\149\031\165-\133\206\237\200f\015\213QQ\180\135\2533\141\017$Z\245\148\253\241\t\229\138\253;K>K\132\138\180K\030,\203b\173Z\217\222\183\219&\234C\241l\250\205\151\238\222\244\203\206\174\214&\228\235\2113;!54X\214\167\217\208\224\181\184\026u\227^\149\230\166\218\152P7+M\167\249\148\151\026\138\161\134\255\135\197F\165\214&g\247\208\180\201\221\236\158h#\209\014\189\224\188\237\153\138g\198'^i\1983\252\185I\011\201\214U\167\189YU\133\182\022\2436wz\209\191\170\178\241\005\221\214\145\191\164y\136'\240]\168\175M\020p\246\254ly1\011\197\028\251\195e\251,\\\150\146V\230gV\016zl\151\209\137u\030 >\228V\162\011|\247EVz>\158\012x\153\026d\242\016\228\146\014q\0224\155\229\006\229E\185\214\1929\133\208u\178\025\175\227h\212\238`\166\159\150\253\251\231\183(\151s\210X\157\r\136\141~\007[\138\022G\207\228\168\181\188\151\208\249C\155a\029\166\201Q\155\210\130\247\151E\150\221w+\161\130!\198S\184\242\139\148\027\217;\221+i\160xn\217\187\011y\007[\227v~\237\235\221\2248\247\235]\\;\143\198E\236\216\233<\235\2164o\182\241s5i.(\155\025'M\246g\144\0175\227\247.'%\220\017\151\147a\134\202\022MIq\242\227\157$<\243a\239\142\241\r\238.\207,\1827:\2405\236\213d\142\213\203*N\231wa[\149\245id\217\014\024\150gF\150l`%\135\179ws\156\r\1493c\145\2130\183*)\226b\152?*\141\224\2190MoR\162\1278v*\218c\232V\132\n\2233\196\251\2078\133\172\169\214\024?\240Bf\188\205\144\155\159\139\218L\210\242\245v{C\030\221\230\142]L\218\220\145v\028\012{\162\179\024z:\1794\198\014(h-\165S\198\178m\143\026\002\188\237)\198\190\029\165,\219\177\127\192|\196\234\204\168::c8\215\147\158\139\244Ia\182\198\147z\197\005^\bj`\027\184\172\154\192\138!M`\195\162\255\222\234\2048\0055\240\228 \249\178:Q\215\211:\212\132\023\143\016\003K\025i\168\225\178y_ga\241^\r\215\139\205t\172\172\019\226Q{\190\246\005\187u:f\022\153\225m\237\188\232\018\006\218\195\173\241\176g\n\194`ELf\236?\247xT\211t\020\231Q6\172x\029\134\213\159R\208Ug6b\245w\251\187v,>\238\147\240L\187\237\176~I$\027\001f\241\166\197\164\240/\168\205\005Z 0\030B\002\017j#s^\171\209\2371\127\216\163Mg\254\020v\151\237\231\212\\0\239\153\2476\180\191L\r\152\r\179Q\204^\1706\186\209C\251W\148\143\153\019M\201\137\138\\\1288\255\225\209\006&G\147y\183\134\030\207\243\149\001/s\245\018\165\219^\132\007\244\237]\222\212\244\250\152\188*\249\230\241V\189c\025_\186|\1879<\190^?\173\229\219\251\2456\172B\195Q\253\232\213\219\247\159\006?\r\194\189'\195\2449N\236\n\136\134\210\000\173K\005\250w{J\150>\199\233[\001\218z\002_\170\235/\241\161z\235\164Pv:\133\197iJ\001f\230U8\217V!1\221@\001Q\232\004\248\160>_\r.\022\252\153l\162\000\221F\134+\213^:\029U\128n\163\160\210F\193\168\141\002\2166\n\158\218(\b\t\166B:\225\151\239\203\193\197<}^\133\016H\250|\029\028n\196_\168\242\n\145z\nX\015.\198\252\153.\017@\183WP\185\143`\212^\001l{\005O\237\021$\181W\144\216^\254\254\172\250\244\164\240F\127\198\1867y-c\0175t\b\000W&\020\006QBq$E\\\r'\002`L\017\234\014\172\200]\226=/\221z\185\227\140\168|\176\017\001#\142P\127\216\017\137c\143`\024\128\132\194(\140\232\007\004\212x$\000\006eB\189\145\025\185\n\173\134c\148Po\160\018\149\143V\"`\200\018\234\143[\"q\240\018\140#\152`;\140#\168\198r\004\212\128\142\128\030\213\132\224\208&\216\025\223\145\169q\012\224H'\212\027\238D\245\141&\028\248\132\250\163\159H\148\000\130Q\007\b\182b\016\193gt\173\019\150h2\192m\178\163\018q\224*\149 \000F#\161\160\018\tE\149\136\184R\t\002@%\buU\"r\151x\207K\183^\174J\016\149\171\004\017\160\018\132\250*A$\170\004\193\160\018\132\130JD\244\003\002J%\b\000\149H\168\167\018\145\171\208j\168\018\132z*AT\174\018D\128J\016\234\171\004\145\168\018\004\163J\016lU\"\130J%\"\160T\"\002Z%\bA\149 \216Q\137\200\2128\006P%\b\245T\130\168\190\209\132*A\168\175\018D\162J\016\140*A\176U\137\b>\163k\157\176D\147\001n\147\029\149PFPR\161Q\024\151\154\002\2090\020*\135\"\149|h\0204DS\174\144\168\002\151\238s.\251\171\238\234\138\230sq\209,(\140\166|\153\209%Pk4\007\130\163)P\029E}pQ\165?\026\005\0172\148\167D\170@\229\218\0305IS\1580i>W'\205\130Di\202\215)]\002\197Js\168X\154\179\178\165\024\165]\nU\002\166P\173b\026F)\211\156\163g\138\174\221!\139\202\166)O\2224\127V\011P\2324\229\171\157.\129\146\1679\212=\205Y\241S\204\179\235\225'\183l\227\163\253\150rT\145\017\165\137\130\129\172\b\001z\168\bTC\166\148\022\n\006J(\132\171\131L_:\247\191\236\171\172\171\128\194\230\250'\028\168\159\016\190\246\t\143\202'\012\232\158\016\160zL|p0\165x\130\129\222)\194S;\166+\199\190\168tBx:'l\174r\194\129\198\t\225+\156\240\168o\194\160\186\tc\181\141q\165l\140)]cL\171\154\128\168i\1948\138\198P\237\0126T3!<-\019\246\204\248E\029\019\194W1\225Q\195\132A\005\019\198\234\023\227\207\142\175\158\156r\141\135\245\217\196Q\173\216V%Y\004\128\004\016\nb\149PT\170\136+\153\"\0004\138PW\160\"w\137\247\188t\235\229\234\018Q\185(\017\001\138D\168/GD\162\022\017\012BD(\168PD? \160\244\135\000\016\159\132z\202\019\185\n\173\134\154C\168'8D\229jC\004H\r\161\190\206\016\137\"C0*\012\193V^\"\168\180%\002JX\"\160U\133\016\148\020\130\029=\137L\141c\000\149\132POF\136\234\027M( \132\250\234A$J\007\193\168\027\004[\209\136\2243\186\214\tK4\025\2246\217Q\t\170\157\146\137\132\192xL0\b\005\195\168\020D(\169H\bhE\130]\177 \2422\187\239\165_=W/\018\151\011Fb@1\018\236KFbQ3\018\014\162\145`P\r\130?d\136\210\141\132\128p0\236)\007\145UfC\212\142\004{\226\145\184\\=\018\003\242\145`_?\018\139\002\146pT\144\132[\t!Ti\b!JD\b\209*\146 \148\145\132;:BT\157\r\019T\146\004{R\146\184\2221\135b\146`_M\018\139r\146p\212\147\132[A!\2449\243\186SV\166\201\017\191\245\142\170Pe\148\170$\004\134m\130AU\024FU!B\169JB@U\018\236\170\n\145\151\217}/\253\234\185\170\146\184\\U\018\003\170\146`_U\018\139\170\146pP\149\004\131\170\016\252!C\148\170$\004T\133aOU\136\1722\027\162\170$\216S\149\196\229\170\146\024P\149\004\251\170\146XT\149\132\163\170$\220\170\n\161JU\bQ\170B\136V\149\004\161\170$\220Q\021\162\234l\152\160\170$\216S\149\196\245\1429T\149\004\251\170\146XT\149\132\163\170$\220\170\n\161\207\153\215\157\1782M\142\248\173wT\165{\168\210\148\248\029\134l\004AO\bD5\233`\165%\241;(I\004]\029\233\168K\184\223\165W!WA\"\147\235G\196A=\"\232kG\228P9\"\n\186\017AP\141\014\252\000\223\149b\196\239\160\023\004zj\209Q\021\216\t\149\"\130\158ND&W\137\136\131FD\208W\136\200\161>D\020\213!\162V\027\186oJ\025\186\239J\023\186\239Z\021\"\128\154\016QG\017:\162\006\007G5\136\160\167\005\145\233\025'\168\003\017\244U r\168\001\017E\005\136\168\029\255\221\183g\240\159\019\240\r~\247\218\233\140\250\232\171j\216\019\000\195\140P\024\248\t\197\145\031q5\244\t\128\177O\168;\248#w\137\247\188t\235\229\142\127\162r\001 \002\020\128P_\002\136D\r \024D\128PP\129\248\245\003\002J\007\b\000!H\168\167\004\145\171\208j\168\005\132zb@T\174\006D\128\028\016\234\235\001\145(\b\004\163\"\016l%!\130J\019\"\160D!\002Z\021\bAY \216\209\133\200\2128\006P\025\b\245\164\129\168\190\209\132\226@\168\175\014D\162<\016\140\250@\176\021\136\b>\163k\157\176D\147\001n\147s\149\248y\240\147\254l\175\2509\157x+\1921\218\207*\158\1700k\170\159y\219\163\016\176\193\207$f\234;\r5\006\194\136\024\241\231\228\024\012\232\202\t\170\028\1331\170\156\000\182\011\005O\149\022$UZ\144Xi\250\254\186\181\232\132?[U{\205\022\021\192Q\184\215\218\162\130Y]{-\022\021$UN\144X9\249n\197\235u;$\249\243J}\014\003q\198\159\169\021\002H\245\024\139\127\195#u\213\235\244w7\024\136\234\167\140C\000X\136P0\019\161\158\173\136\202\rF\004X\141P4\029\193h?\130\173\017\t\004KFt\137\192\n\001eX\002\192\186\132\230&\142\004\2169\130\153\177\187\183\027\181\177#\128\198\142(\026;\162\174\177#\229\024;\018h\236\136f\198\142pf\236\b\131\177#\136\198\238\208%\002+\004\180\177#\128\198\142\168c\236\142@cw \024\251\215\214\206s\254L\015\016\128\172+\1286\172\160R\005\193\200\156\002$K\n\146\140(H\180\159|'\2111\176n_\215M\159\169\182\002Pm\005\208\181\021Tj+\024\213V\128T[ARm\005\137\181\149\239T[\006\168\007\218\191\224\021\129d\253\132\252\222\154\191\224\207\182A\191\179\249\005p\026\244\1876\191`\182A\191\139\249\005\129\006\253\158\204/\223m\131~O\r\226\239\169=\012\212\25036\167vk_;\181\175\177\246\176L\017<kU\157\181\1706\173z\219.\223\199\252\217\174\026\222\218E\187\160\217\"\225-/\213\005p\151Roe\129.\b\173\205\005\176k\133\183\131v~\159\166\207i\173\192\000-\198\021\160\023\015\140\170\197\131`\252~\156\002\211\138\130\001^90\194+\135\132\236Cm\249s\178\"\003\198\138\140*+2\150\172\200\000X\145q\182\"#\201\138\012$+&\160V\022\173\177\167k\183\167k\167\167k\236\233\186\167\167\235\172\167q\169\252\022V\201o\219\229\239\132?\219)\238\173^\244&Lo\185\148'\027\024\154j8\175\213\166@n\000C\131-\012\231\155\197\020A\011\025\018\134\133\225`\132hN\185\174\129a\220\024\014\134\144\229\156\209d\n\228\003\203\210\249\0243<\0127\195\225\2003$\014BM\170\241h`\024\154\134\243F\169)\144\015XC\195\2165\156?\140M\017\028\209\134\132\193m8\024\231\154\171}\023\169\207\012\137\250GC\162>?$\2343C\162\254\241\144\168\207\r\137L?\012i\165DS\141/\024(0\134\203\180\230\157\138\003\189\195\016\208;?\250\243\174]\216\166\160\198\187vQ;O\159\219\240H\193_\210\224\020D\141*\006\237o\221_\140&\134\200P\137%\188\1950\194;'\130\240\014\223\230z\231\190\205\245\238\204\219\\\239\248\229'n4\191\25347\128n>\188\253\004\176c\136\200\244YC\177>\213`\147\2098}\239\016\153\159\014Pv20X\203r\158\2054\168-\167qe?\rk+\026\028miH\199\162\154\239\179kV\230\\\129\1987\026Z\186g\200%:\202\158\1784\001`\227\132z\214\141\156\182kD\148E#\160mI\bZ\145`\199~\145\233\179\156b}\170\193&\163\157\b\205,t\217n\153\166\252\217\006\149/y\203$\128\019`\190\212[&\193lX\249R\182L\130@\188\2482m\153\228;\205M\012\\\177\156^r/*@w \195Ku\253J}\254\164>Kt\224\018\003\003\151NL\2242\237\221\248!i\239\150\128x\015e\\\002\192\194\132\130\153\t\245lMTnp\"\192\234\132\162\233\tF\251\019l;\129@\232\t\214z\219`\236\019O\235-\183\196{\174\016\248\132\128\234,+\253\128\230\221\022\t\232\187\bb\007*\227\171^\212(t\165\166\160?5\229u\170\230\243\158\213,t\175\166\176\1435\135\029\1739\219\219\154\129.\183\239B9v\194\206\239}\023\202)\176t\159\179r\209O.\170\188\194yE\200\163r\255P,8\137b\208S\2486\202O\004\003/\017\002|D\b\207C\132\205\253C8\240\014!\2087\132A\207\016\198\250\133\224\224\021\250m\145\204\"\232\017=o\139d\244\210\185\255\202\193>9\152\242\131\236\165\138\156\200}\128\017\240\000\198\177\255\163\213U\231\019\000=O(t;\161^\159\019\149w8\017\208\219\132bW\019\140\253L\176\237d\002\161\1359\025\2236\024\251\214K\198\183\220\018\239\185B\224\019\002\1703m.;\160y7F\002\2500\130\216\129fW\169\250\209\226\208\157\150\132^\181\164\215\185\182D\222\199\150\135\174\182$\246\184e\177\227-k\251\223r\224\006\134\188\234\177\030:\005\144\158o\152\"\203\158\231\173z\240O=\184\242\027\139\131\251X2\247\"\195\1313\025\014}\138:EySB\192\143\018\012\030\148`\207w\018\151{Mb\192_\018\140\158\146p\244\145\132[\239H(\248\133$\221C\219\209\023\220\164{ \151\217}W\025\242)CToC\174:\194y\015\019\003}K(\246j\220F\169N%\000\250\148P\232RB\189\030%*\239P\"\160?\t\197\238$\024{\147`\219\153\004B_\242~\2176\024{\210\219/[n\137\247\\!\240\t\001\213\137v\251\012h\222\133\145\128\030\140 v`l\175\234@\002\160\003\t\133\014$\212\235@\162\242\014$\002:\144P\236@\130\177\003\t\182\029H t '\156\217\006c\007z\tg\150[\226=W\b|B@u\160\205\215\0024\239\192H@\007F\016:\240}\219w\233\188\247=\247\155B\168\207\020bs\129\024\214\201@\012r6\016#\146\246\195\144\228\2530\148\018\127\024\160~\017Dr\007\222\243Y\187\0006\187\234\189=k\0234\139\223\188\231\179v\001 \002\254^\206\218\0051\177\238\247|\214\206@:k/\018\160\201\rV?\157\255(\192\171\254\198\169\190>\222\017\016\219\180\201\218\180\201\218\180WN\178\183\145\249\247\246pF\208,H\255\158\143a\004p\211E\223\203\129\139 6I\244=\031\1730\192\025\011d\215\015*\141\237\003\166\177}p\211\216>8il\0310\141\237CO\026\219\135,\141\237C\150\198\246\001\210\216>\1443p\149\169\017\244\253c{n*\159m\150\194G{B*h\150\165\240\145\207B\005p\179\020>\202\169\167 dx\001l\170\197\199V\017\2293y\171\002\180\0142\\\233\207\216\174\202mW\229\180\171\194vU=\237\170\178vU\144}\2411u\r\127\023\153\254\168R\158>\182Z\204\248\181\157\220>j\005NX,\162z\146\000h6\161^\219\137\202\r@\004X\129P\223\020D\162=\b\134\206&\020z\156\227\147\000@\223{\241I\203U\025\224\218\164\234\183I\213g\147\202\181Iu\206&\149o\147\204Q\b\182\222\130\001\215\143\028p\157\024\224\026K\160\007e\241\213DD\235*7\"\000LF\168g2\162r\147\017\001&#\2127\025\145h2\130\193\141\b\0057\138\232U\006\128\027%\212s\163\200U\025\224\218\164\234\183I\213g\147\202\181Iu\206&\149o\147\204\141\b\182n\196\233\173\182\215\149\027qz\171-\129n\148\165\1832a\179r\n\015F\243\245e\229\184\005\028S:Y9.\215cV/+\199%\209\237\156\172\028\143\187\234\129\209\017{O\139\189\018U\015|\198\182\213\143l[\157\183mu\198\182\213\143m[\157\179m\238\190\154\004'\182\135\230\158\231i\135\182g\230^\233\204\185\253\019s\162\175\218}\204\130?\211\181\002\208~@\000mvA\229\190\130\145\129\005H&\019$\217I\144h\028\249N\158\200\128\188\164u\133\239g]\185\175f]9oe]\225\011YW=\239b]e\175a]\225\027XW\248\242\213U\187\195\154\243g\155{}\197;,\001\156\220\235+\189\195\018\204\230^_\201\014K\016\200\189\190J;,\249ns\175\175\194\162zg\218G;.\2307\252>\212\021o\184\004\160a\175\000\213\026A\1655\n\147\r\151\128\212D\001R\019\005IMd\228\190\249v\191y\148\205\204U\187\005\227\250\239\177\007\246\174\193\247\142\193\247hp\216\130\t\158uD\218\130\t\128vO[0\006\014\2503V\218\252\193\018\129\143\155\135-v`\173\134K\141\003\186v\199o\237\140\223\026\199/$\189\t\158\141\235:\027\2155\140\235\147\234\190F\127F\007kr\207\225\183v\022\022\128\166\218\183v\000\245\172\144\189\181\003\004\216\003\222\218\001\024-`\222\218\001\0164\142\215\174\019\011\128\2189kW\160r\221\179kW@}\005\132\181+\192\160\133v\237jQ\165)\004\128\143\019\n\250H\1687f\137\202\007.\0170z\t\197\161J0\n'\193V=\t\132\161\156^\130\218\229\006\0021\141\224\006}\025e\149P\208\214\132:\002KT\223X\241\164\150\024\208[BQt\tF\229\141p&\191\017\222c\179\247n\127\239\251{v\223\215\179{\183g{\196\153H\191\219Q\166\tu;\024\005;\162\135\012p\155\233\235w\228\028\017\143D\141\162P\187\026W\247\171Y\221\167f\181\171f=\018O\164/u\181/u\181'u'\244\157&\003\220\161\224\205\002\202\158z.\2080ZKs8/h\206\181\167.\224XU\211h[\205eF\212dfJM\130A5\1333\136\221\182N<\024g\147\190m\171[\192\153Y\156m\171\203\245\2042\222\182\213%q\198q\182\173\030\167EX\1958X5\1353\145\230\\\213\210\005\028\237\2104*\152\2302\169\210d6Oi\018f+M\161\164)\014\181\199Pv\254\210\175\173\248c1\155\2034\1353\154\225\188yM\0238\175\001\238\028\167y\156\2334\151\205w\154\204f=E\230s\159~\161\1977\220\254\140\207\237\127\228W\251\243~\181?\227W}\243\163.r\206\245\178\185Rsg\220+\1557\021w\232\129\207\152\168g&U\1607\159*\186\246\133\178>3[\212?\154\017\234\2433B}fF\232\155su\145s\147F}n\210\168\251'\141\147\239\209M\015|fX\231\179s\1652\027*Lj\1680\159\161rS\025*'\139\161\194\004\134*\203]\168\178\180\133\n2\022*LV\168\224\157\250\n_\167\1750\137\190r\147\232+7\137\190\234O\162\175\250\146\232+7\137\190\242\147\232+?\137\190\242\146\232+7\137\1902\233\232\182\209h\n7\029\189\234OG\175\250\211\209\171\031\164\163Wg\211\209\171\254t\244\234L:zu&\029\189\234MG\175\250\211\209\171<W\219\177\021\154\209\201\213\174\250r\181\171\190\\\237\234l\174vu&W\187\234\203\213\174zs\181\171\222\\\237\170'W\187\234\203\213\1740\1819\179\n\154\011S\155+7\181\185rS\155\171\254\212\230\170/\181\185rS\155+?\181\185\242S\155+/\181\185rS\155+\147$l\027\141\166\232I\018\174\206%\tW\231\146\132\171\031&\tW?H\018\174\206%\tWg\147\132\171\179I\194\213\153$\225\234\\\146p\229\229\203\186\022D\243f\249\178\149\159/[\249\249\178\213\153|\217\1707_\182\242\243e\171\158|\217\170'_\182r\243e+?_\182\178\t\167\208~4\011=I\153%!`\150\004\131Y\018\236\153%q\185Y\018\003fI0\154%\225h\150\132[\179$\020\204B0\152\133P4KwGe\148\248\029L\018A0H\004=sD&7F\196\193\020\017DCD\020\205\016Qk\132\136\129\t:\016\012\208a\208\252\165\250\153\161%\254\204\208\018\127fh9\240~fh\233\252\204\208\018\127fh\153\253\204\2082\251\153\161%\252\204\208\018\127fh\169~$r\137\191\015\185\244\127\026r\217\198O\228\179\237\216\165\141\148\b\154\245\221\146c\"\002\184\191k\184\148\232\135 \180\239\018\192v\215\178\rn\148\252\217.\212\151\028\198\016\192\217i/u\192B0\187g^JhB\016\216\029/S\016B\190Sm\025\176[\179%\166x.\007\186i\0274y\138!(\192\235\131\141\211\007:D  v\204&\235\128\r\012\164%o\251\217\179\246\188\199Z\242\254^\000g\247\184\212;y\193\236>q\137{v\193aG\184\228\221\185\0006(\184\204r>\151\206Fy\217\238\142\185\167j\244\165\218u\157\218q\157\026]\007\182\185\130g.Ug.U\027\151Z\181\170#\159m\029W\172:\0028\149^i\213\017\204Vz%\170#\bTn\149TG\190[\127_\169\196\161\021f\011\173\220\020\161\149\147\023\180\194d\160UO\006\208*K\251Ya\174\207\n\019|V\003Iw_\177\130\b`\127\140oe\021D\208,*\188b\005\017\000\130\187+Q\016A\204\207\237\173XA\024 \159\029\201w\029\165\\u9\226\211\2449\229\1363\144r\196\005\200\127/ger\196\005S9\226\012\218\159\203Y\169\028qF8G<!I@\184I{\2290{t\233\189\235\193{\199\131\247\232\193{w\216\173D@\004!'\017\000\029\025\002y+\173\031\220\023A?&\169\149I?\0040\142\195\168r\028\198\146\2270\000\007\007\140\179C1\194\014\197\b9T\250\222(\207opD6\217\216\187\238\222\245\024\241\151\148\029/Hz\215C\016\1470/\176\202\152\0230\165\204\011\194\185\241\002qr\188@\148\029/@z\215\131\145K~\181\229\154\165G\000]GA\179\183b\174Yz\004\176\157!x\170\184 \228U\002P%\025X\243\020u\205\210#\128=\166\187\182\210#h6\151^\179\244\b\000s\230\181H\143 &^z\205\210\195\000\185\251T\190?\232\223\130\188\030\200z\243\154\181G\000\210\030\005\228+\226k\173=\n\019\237\017\208.\147\175E{\004\129e\242u+5R\221=\188\184tm\197F\193\249kJ\215,7\n\193\215=\152\192\247\151\174Yq\020\002o+]g?\173y\173E\135{\161\214\005\234\172I\181\223\164\218kR\1575\169\238kR\1577\169\198W\178\174\147\2480\192\177d\030\1666\152\1400j\139\019NF\206Q\025\027PF8\211\027\b)#\014\202c\131\202\000+\r\178\239r\000\234\169Q\246.\007\016\160K\238\187\028@\162B\217w9\000\005\173\138\168\018,\002@\181\b\005\233\"\212\211/\162r\017#\002\148\140P\1483\130Q\211\b\182\194F \168[:\0060\131\203\156\r\128\023+\233!\000\020\143P\144\189\132:\218GT.\128\137\200U\144\024\144BBQ\015\tFQ\140\240>k`&\143\004\187\130B\156\163*\196\160\180\016\220\163/\196f\"C8\138'\193\168\160\246\020\007`GK#QgEk\223\018\245\025K\212\189\150\168}K\212g-Q\247X\"\215\\\194Ax\245\145\011kTv\230\2260\168\192\254\169\139C;:\156\157\1878L\166\198\249\201\139C\129&gg/9\163\148Y0\016g!<}\0226\151h\225@\165\133\240\133Zx\212ja@\174\133\000\197fB\137\182`\160\219B\128t\011\225\169\183\176\185\128\011\007\026.\004\202\1840\168\228\194X1\023\028\244\\\029\179\1531\142\199o\249\016QB*\024h\187\016 \239\138p\020^\216\\\228\021\151\235\188\144 \245B\160\218\011\131\130\207\204\222k~&\251\194\184z'\180#yB\162\234\t\211#|R \211>\161p\"\016\006\231\130\236x5g\156\025\129\185\218\187\160\2385U}\222T\2459S\213\189\166\170\127d\170\186\223T\249L!\148\157,\214\003y\239<|\230\223rH\1289+`\248y\144~\195y\221\166\215\240g\1377\1721\222\176v\226\r\164K\170\006\004@5\bu\235\0189U\161\b\156\016h\240\169X?B\243J\198\202\168J\018\000\149$\212\173d\228T%#pB\160\193\167b%\t\205+\169\\P\213T\163P]M\185uV\005T\197\021zr\209\198\173\019\182CSyc\024QM\017\012\026\"\132\219\012\166U#\024;9X\227\212\003\171/D^\2498\160U\205\t\128j\019\234\2149r\170\194\0178!\208\224S\177\158\132\230\149$\233P\181L\bT3\193n=\137T\021%\228\148!M\246l\172k\130\243\202\146\152\169\202&\004*\155`\183\178\242\007?S\213\228\015~\002\210d\207\198\202\230\127\24031\157\188\170\170\198\239P\209\b\186\213L\127\1510U)\253]B\243\189\129\231a\245\240\239\018&<\206\147\170v\004@\245\bu\235\199\127\022-U\136\255,\154\005\026|*\2141\251\179hD|\030\236\248i\2253\207\186\t\240j\021`^\028\016P\171\027\194_r\249\236\254%\151\207\206_r\249\140\127\201\229s\207_r\249\156\253%\151\207\217_r\249\012\127\201\229skE\254\220\232\207X\223\220J7\003i\236\205\224\171\194\191z/\161\223\180F\149\207\246\2547`T\129\237q\218M[I~fc{\230FW2a\177\200=\002\170\186\004\184\207\143\220.\003\160\246\132\158\187\005\180\131W\004\182Z\216\162lE\144\bz\029\012\001\213,\002\220:En\151\001\208,B\207\221\002\154\197o\026\217ja\179\1787\141\152\160\1918z\159C\186i\t\242kF\236\206\129\176\129\t?\127#l$\225M^\201\172\161\t\207\155\218-\252\143\223\2147r\218\026\183\136\248\131\240EF\186\140\189\213\237\224\150\031\021>\223t\127\185L\000\017\207[\165\155\183]\147\248sj\011\003\170\017\132\197\251\170G\017\000\207\139_\159\241\186\019\002M\006@\029\b\205*\146\130\166\244\192\r\252^\149\158-\244D\177\025\188\168\207\141\254l\031\188\241\158\169\163\181\233\193&\004X\024\240\025\175<!\240\130@\147\001P\173\\\031\136\208\175\196\166\186\153W+\011\003>\227\149'\004^\016h2\000\234\150\015\242D`\0187W0\203\225.r\230\217\189\209\201E_\\\180\241Q\172\190\187?H,\132uR\011p\215_ \254\236\220\226\228`/\014\214x\024\212\218\219\0220\199q\030\1684\227Xk&\158\189\187\156<\240\197\003\027\023\196\170\011\147\215]'m\167z\155\156\237\194\128\207x\229\t\129\023\004\154\012\128\250e;\153D\152\228\222T9\155\219[X\2449\187\248\148!/\025\210\228\bT1\223\192$\198d\218\166:\218D\219\194\162\207\217\197\167\012y\201\144&G\160\142\249\190\133\152/\018\"\165\239\027\253\217\206\172_\228\239\143\t`b`\t\205f\222/\246\207\1391\200a\176\004Hp+!\018\211\"d\207\171\130/\028\200\020\192Y\226\127\209aK\193\236\018\255\011\006)\005\135%\254\023\014I\n`\243\205\190\168\000$\001v\12916\176\193\238B\015\140\248cl\158|\143\246W\223\165\181\002rc\021\196\198\023,\182_\190S3\005 \2033 \027\200lk\219\179\173\165R\242\020\250n\155E\160m[\002\243\006\018\147\1812\225YS\137\176\237%\016\026M(\180\028C\129wn(\240\238L(\240\206\190Y\236\162\214(\206{\197>\149\027\200\127\171\216g3c9\239\020\187\020\024\206{\163\216\227\238|\147\160)\r\231\025\244^\237\156\239q\231|\239\236\156\191v'!\211\244\217\n\228W8\247`4\019\204\175r\202\193\000D\236\025g-c$E+\024H'\024\004\192\219\213.\0125\239}\187\218-\144\183\199{\187\218\229\252V\186oW\187$\180\221{\187\154\184\157\154\245vjv\219\225\188\182sf\180\029\174\243w\184\172\223\185\203\250]\223\178~\007/\021{p\211\003\195#z^*Nt\180\208\t\129&\003\224\182\217\223\028#\226AE\195\0300\026\246\224F\195\030\156h\216\003F\195\030z\162a\015Y4\236!\139\134=@4\236A\253I\181\007\252kj\015\206\031R{\140\199t\233\179]\161<\226\161\\B\179\005\201\163:\130K\128\251K\206\143\250\192-!\176&y\148\2275\250\254\204A\001\029\003\207\162\223^\220\251Qe\168\024\000\154\234\230\167\024*o4f\167\024\212o~\150\155b`4\004d\166hP\153\004\143\230\030\221\163\185\199\190\163\185G\254\245\160\145\005\192B\206\175\007\001\149[\200\254z\016\160\190\133\224\215\131\000F\011\153_\015\178\160\178\016o\247m\147\209B\217v\159\t\251{\016#\015Fk\245\253\030\132[\192\177\156\243{\016.\215cE\239\247 \\2\179h\254{\016\030\165\173k\165\2193Zfi_\186\019\029'0ei\002\192\198\132z\214%*\183+\017`QB}[\018\137V$\024\237G\176\181\028\159\247L\012\208`\147\209N}\199;{u\234\177Ws\220~ \127\184`\175n\191\199;\239\189\155\178\178X@\221\158\131|cS\162\193K\240i}\218\179\183Q1\007U\015\183Q\177q^\182q\239\128u9{j\190\215a\174\012S\149\209a\1741\150k\156k\177\026gN\191\247\028\001\178\128z<G\128\198\166D\131\151\224S\251\206\178\237z\244\185\007W\0210\184\170\135\193\155\158\251`\173,\153WNbN\128\168\nI\204il\2034\217U\248\248\222CsZe?#\160\030\027\001\245T^e\218K\240\153\217*3\017,\021\022P\143\140\128z$\138\201\222\021\147}\159\152|Sk\226o\184\028\254\230\172\132)\028\211s\202\163Y\159\178\231<\2466\196\205\021\183\219|yR\159.&\165p\241\162[{\001\129t\130\1473r\172\166Ak-\205xGk\154\183\241+\197h\027\228\181>X\019\016H\213p\024\138\022z\140\174`\206\203+\127\026\164\0079\140\253\2215\195\208a\160\203\233J8|\222\177\145\016W?\132\243o\245\217v\200!\157\185j UG\160\024\127-\211\247[\197%\135`\224\142=\250 !\019\006l\156$\193\233UL\190\201^\127\198*{\241\211\131\019?=`\252\244\208\019?=d\241\211\003\198O\015\024?=p\252\148\205\242\183\"\143\170uG;\248\015\236\011\nH6W\144k\169\167\001?\226I\151`\2449\133\180\014A\128\228\163\t\220\029\148\252$\136\014-\165\t\004\128\241\t\005\167I(z\142>\te;E\240\022K\161#Qf\165\180}m\0190-\234Z\139r<\192\185\"\186\207\000\183\165\174\175\017\149;\028\017\224u\132\250\174G$\250\031\193\224\132\132\130'\154\179e0\243\223X\236\136\230A\239$\020\\4\161\232\167\t\2397\191\248&}\247\2206-\146\17376\248\221z1\174\127\019Ng\220\210r\002\160\131\t\005WN(\186\178\249-\233\210\128\183X\n]9\162\202\149\t\000W&\212\181\165\253\153g{\227}\006\184-u]9\251\149g \192\149\221_y\006\018]\217\254\2023\160\224\202\246W\158\173\153\255\198bG4\015\1862\161\224\202\tEWNx\191\249\197_\233\187\231\202)Nb\189\177\193\239\214\1491H\194\184z\128vh\rcgk\014\157\219p\153\139k\022\028]Q\183\254\021\153\211\195\137\202\212\129q\000\244\159\1688%\178\193`\015&\\\248\140\173\252\225\225\031L\1844\014\149\254\131\t\183H6l\156\131\t\151\195!\164\184l )\238o\255\146\163o\236lhi\014\007\152\225\178af\216\031u\178\026W\026u\007\158\t\164y#\168\241Q\024\138n\020\141X\029\1738b \231\136)R\220x\r\185'5\242\202\143\221\198\197oW\003~)\134\000\206q\176\168=\132\212\220\1467\t\241\251\n\190_\203~\146\128\212\225\022U\219VC\164\253f\220L\2063*\226\228\135\207\003Q\157g~\005P\000\146\005\001\156\161\249\172_\245\019\204\014\194gy\181O\0168\237yN\175\242\201w;\162\158\225\183m\158[u\025\243g{\028\244luD\208\236\144\232\153\021C\000+\019\130\195_<}fA\016\192\254\209\214g\252\161\152\019\252E\221\147\146\200\019\234\226\201\021\195\147\163\128'\148\189S\143\214\1572\129;\161\170\157P\202N\248\007\127_T\230\207\011f\254\188`\230\207\139\155\249\243\226d\254\188x\153?/\152\249\243\146e\254\188d\153?\141\250\211\190\r\254i\223\006\255\180o\227\254i\223\198\249\211\190\r\254i\223&\251\211\190M\246\167}\027\248\211\190\r\254i\223\006<\187Q\246m\208\190\r\218\183q\237\2198\246m<\2516h\223&\179o\227\216\183u\219i\250\156\220\150\001\227\182\140*\183e,\185-\003\224\182\140\179\2192\146\220\150\129\228\182\t\128\177G\019\140\242\012\002\192=\b\005\031!\212s\020\162ro!\002\\\134P\244\027\130\209y\b\182\030D \184\145\217\230\219F\171\238%\000\188\138Pp\173\132:\254ET\238d\137\200=\141\024p7B\209\231\bF\199\147\168\193\212\000\224\130^\212\192R\1853B\212\192\162\190[b\212\192\194\224\160\01650(\186*\215Ny\171`\224\176B\128\207\n\225\185\173\176\185\231\n\007\206+\004\250\1750\232\194\194X/\022\028\028\025\178\183s\171(\247\017\012<Z\bpjE8~-l\238\218\138\203\189[Hpp!\208\199\133A7gFy\186`\224\236Bx\254.l\238\242\194\129\215\011\225;\190\240\232\251\194\128\251\011\001#\000\147\242Sw\127\151\236\199\239\144\242\248\029\242\028\191{\201\141\223\243\140\198\239N\026\227w\200]\252\142\t\139\2231K\241{\210T\248n\171h\020\021\193\188\178\168\167\136g\2136j\n 4\192jiB\233/\153\225w\219\n\002m+\018\152\183\130\152\172\021\t\207ZA\132m\005\129\208\nB\161\021r\203\141\135\217\214(\194\182H\019y\171\020\155\181LsY\235\020i[\168\bh\165b\164\165o\030o\223n\014\143\239\215\219\1951}y\189~Z\183\159\127\221?>\253\177y:lo\142\255\023\211\007VP"

let symbol_afm () = "x\001\181ZK\147\2196\018\190\207\175\224q\183j\149\"^\004\144\156l\199\217u\237\218q\197N\156\218\027G\194H,S\164LR~\253\250\237\006\186\t\146\163\201m\203U*\205\184\027\232\199\215O\204\187\169\030\166_\250nz\029\166\161\217\143\133\254A\220\189\232\207\231\208M\197\139\254\242mh\142\167\169\248\219\254\239\133\240\206\252\003?m\252\244\248\233\203\248i\139g\135\254>\020\239\190\141S8\143\197\171n\223\015\151~\168\167p\248\161x\214\182E<f,\1340\134\2253\2522\2231\132zj\250\174\248\025\136\127,\222\159\174\197\235\250[Q\136B\152\031\133\252Q\154x\193L\255{\215|\186\134W?\023Z\149\149\158\127\253\199\235\235X\031C\161J'\203BydA\181\222\212g\020\235|\223\183w\191\\\219v\245s}n\218o\203\223|\bQ\219\215\225\208\\\207w\175\166\186m\246\207\186c\027\138\242\238\213\248K\2435\028\2226\211\254T<\212\237\024\238^\156\234\161\222Oax\023\166\226\221%\236\155\186\141\183>\127\222\127-v\194\149\197NzU\136\210\151\240!\202\226\238\247\238\016\134\182\233\194\219~l\162\222;Q\150\249\215\239O\205\254c\023\198\1770\229\221\031a\024\145\164,\197\015e\233\238\222\244S\179\015\255W\183\188\004\146C\211\029\223\237O\001\236\130\202D\197\030\154\253\221\187\233\240\175\015\133\151\248\229\143\015\1333\240\005\208\131V`\244\b_\222\189(\148,~*>\252YHS\194\1517\197x\169A\236\159\138\231EI\255~B*\149\168T\252\242\166\b_\247m}\142dB:\176\139-\164.\139\202\202D\174\019\185\021\137\252\2185\159\193>u\0279\148\128S+'\n[\154Dn\018\185)\147\012\221\245|\143\230<v\145\030@\178\019U\161\129\163\178*qT\196\161=\201\211\128\217\186\169\161+\000\137e\161\173\131+lb\176\137\193\145\002\1510\236\017\139H\\\169b\007\007Z\011\231\027\146\200\145\002\214E\242\250|A\249\187Cd\208\002\001SX0YU\137\196\224\019\131VI\160\241\186?M\167:]\160\147\133\180\208IE\160\215\229\218\160\151z\b]\027\030\018\131\001\137\132\023\016!\229\1722\\\250\152#A+\026\181L,\210\218\204\"\215v\173\193FC3~<\215\211)i\014\001\011\190\210\210\022\198$E\180Z[\246\210^\199\228g\196\130\001\245\140\162\211\245\0269{\b\239:\137_\129,F\002\1944\176\233Dm\214\231\158\155\142\015\006\161\225H\003(\144\206%\226j}4\024\191\233\147\237+\031m)\000\012>\249J\147k%\249jl\235\241D\bF7I\163\139\nODZ\183\182\200\2470\244\t0\026h\193\018\182\002d\210\185~M\219w\129\228\181\005\166\173\236\026S\174)\167/\253\018\133f>\210\136\r\225i\b\233P\173\210\253jA\188\241\222C\127\029\146\000\241X0\196L\1696\148\016m\t\0202\157\n\198\175|\002\158\209k\218\177\249\154H\201\000\149\203\199n\194r\012\159C\151\173\005\017\t\230\156mP\173\137\195\140\204\136\006\018\130O\182\155\128o\200\182*\185L\155\133rn\237\222}\223\246I\n'\018\020 k\235\138\180\243\027,\132s\179`P\t\151R\138\153\163*\215\184l1\159G\029+\196\187\004`\202\148\212*\177\2019\159\174\148m\000\193\002\194\211@\146Qd\230J\174\137\143X:\195\240\196\201\228?\029C\234M\001Es\140\245\006\169mI\201C\130I\018\138+\189>|\223w\199\225\202\233L\136\024\1686\"/\146\147\031-^\007\228\207\218\203)\005\170\142\137X\207N\172\200\137Ue#\229\2430%B\233\241L/3\165]\159\249\226\212D\194\029\018\218rq$\185\175\018\137\240\231\208\210\153h\133\170D\184\165\160\175<S\138H\249\24226\2369\0002\016\139\156\218,\185\205V)\027\190\165\251\163m\173\206\149\194\146\215\1702\017\254\179\230,%\163\246\165\207\164r\173\211K\018TE\157\228\130pS\r_\245L\137b*\136\140\153\146<U)A\001\015\022\021\201M.B\189\002\028T\206'\234\141\163\254]_.t\176\137\"d\251[\246\020B\002H\255S\159\239\015\011\187\186r\182\171\229\210\231\018Z^_\147\250\014\232\156[\152\212\173o\127se\215\239\160\214\201\156\238\172_\019\254\n16\144\163t\138I+r\176\187\217U)&\223699ZL\nt\172#OY\157l\245\254\196\232\187u(\199\151I\250\255v\234\179V\006@1\159\202\185\209'a\2235G\174RH\233\178W\157^\227\239}\157\012\000NF\156dC9rSL\169@\248\251\002\168;\188\191\242\025\255\142\02857\006x\127B\128\198\150\019N\215\208|p_\224\236\218X\191\158\195\177\230\004\r\246R\213\236W\199\145\021K\235\155\226\207\134O\197P]\232\197\238\242\137\238\237\216\2282b\177\169r\169D\251rm\128\255\206\246\143\145\1622\172\253\166\023\185\135\214\250c\152\230\254\197\197\006\000\234y\020\131N'\1439\138X\b\133!<\244\003\021\213J\197\196\001\137\217\165\142\205\171\155w,:\030E\151\232*_\194>4\201|\2088\\Bwh\246\215\182^\020\207\202\200\204\178\169rWl\239\199=\011\182\195\018\nX5%|\161\132\2347\181n\168\225\134\186\r\169\146j\135q%\210$\225\005ic\215\137\160\2069XP\030\1443\b\188[\231\247{v\004\148\160\157\196\194\001Z\1960Ab\191)\006\148\t!\223\002\186D,2\218\167\004#Jr\177\246\169\210\028\230l\172c\255\024\155l\171K\162\022k\236\134\005\208\165L\244\216:\150\146\2329(eR\242\194I\217\161\216\208\002,\n\136(\185\232\017\218\142sb6Hm@\020\189\016\\\175\2118[\004C\b\1745(\134\208DK\030U2\137\221\244\153\024\220\161@-S\178\020\213\250\\\0169\005'\160=\202l\000\142Y\n\187\182\245\199\156\160\017\190\006PgJA\180\027'\1829C\199\246\t\004\134\246\201*>\154\221hSB;\207\201'y\188\1783<\132(\215v\238\174\\{cWf\017\173\150H7MK\191\200\213PT\208\133(\241\172\161\216\244-\023\002SB\135\129\254\140\227S\b\181\150b\202\249Z\165\150\197\229\182S\136M\2072P\19461\t\194\177\190\\Ha\214^\025\231\164\141\r\"\220g\156[\152c\147b'J\220$\180\022KZ\1876\243u\001i\027\003\017\231\144l>\174\1374\200\246\152\142\197\028_\024\183\022\165!4\t\191\174\202\253\156\189\181\140&\193T;\203\"\231`L\135\127\165h\177\020-\208\016\217\170\"Z\177>\2492.\162\\\186\1529\243\193r\029\229\223\231\252QRh\001\154\172\225\1639\016]9'\218\144G\209\216\166(h\130r\001\020\146G?J\128\247\148\\+CK\020\176!O\222\152<\031\159\159\211\184\245\233\002-\220\226\130\205|?6\176\254\225\012\014\187\134\018\155g\015h\160;\184\139\18340\190\188\242\\\135\024\144\224?=\183\014\130\027\249J\174\234\183\224|\143\157f\185 \231\r\137NM1N\174S`W\225\168\018\029\160\152|3@\227@\145G\133\212H\131z\021\007>7\243\130z\238\007\\Sq\243\159\246R\160\128\138\219\021\214\214\172Q\217t\015M\215L\223\n\234\128\209?\216%h\154\189E\181)X\015m?4\148\1991FT\132\n\143\023bn\238M:\127\223^\239\011\174\235({U\206[\000\193\r>\019\031\154\250\220\211\162D \236\177o(19\018:\185\207g\134S\128\197T\193\147\245\014\206\197\"i\020\021\149\185\211'rXP\029x\016O\139\155\n\140\138\1854\145\147s\161b\164\134\175\030\134\254\203}O\027\143\152z\r\150*\bDA\169\154\027\127\239lf\153# \014\209\006Z\011\185\224P\235\004\0219\174\151\020\234\177\177\0049\188 \141y\nX\157\159#@\251t\001 )_`n\\p\232\191t|\197\014\251\005\184\1969V\156\179 \249\248\016\142\188\\\000\203+@\1792\011T\219M)\195=\207b'\195\203\158\216\\Fz\183.\215c\216\179\151!\1400\n4\184\195*\130\168\221t%4\255\254U \184\205$~\190\182Ssi\191q\208\187\1369#\t\211\243\184@Ap\025zX\151b\228\240\r6\2306<\127\014\004\183\201\140\176D\195\157\225\161yx\224\224\217\161:\016\243\150VF\130'\136\1841\192\252\005\171\2330\177a\017\132Z\224\154\135\226\193m\n\221\161\249\2200`K\028G\r@Vs\242u\155\181X\215O\139\189\002\186\025\170\017\196~\252\255\200\176\221|~\1866\159\161\247\236hk\011\137\014\1484\176\192\212\154%\218\184\026\154\150\161\255\186\184F\199\132\141=\148\242l(\199a\196\251\156\182m O\242\202.Md8R\210\022N\240\152\177B,l}'j\139e\202d\000E\208?.\216#\027\015\029\243E\145\239\004\249\233;1\238\192\238R\226R\030\204--\025\142G\016\238\244\247\192\215\192\171\194\016\166\235\208\205\230\195Y\028\250CL\017\137\141\167\016IR\182\225r\"\132\153T\208+\145\014\141\228j]v_Av\2548\241\030\014\020\130\164dp\205\204-3\015 <l\253\182d\144q,\130L\006\133]\145\161y\252\224\220\240%40~LCMk(\001\196\208\241@\160[\204*\228R\158@xL\2207\195\190\r\171\136\161&\204\170<\011\011oo\177\205+\222\200b\136\133\220\202\179\b\027,\156/\211\183\145\240\175P6\029\135H+\216\194~}G\211A\220C\182\152kZ\028P\173\194q'\177\200r\179!\128\231\130L\155\148\144qxH\2127\002\031n\184\226\007\201%\241\n\212Z\219\146\152\228\154\tFO\152\215\182Lq\210[\243\1695\031\196\231x\189\159\245\007\135\21826\185F3\135\190-^f\178Eb\201\151\152\219\194-Y\146h+\174j\205\005=\219\153w\128\169\006\149&\238s\019\181}\164\200\134a\023\167\023\200\003\244\006\"y\130a\183\212\241u\141\128\140.\204\r\155\228\241\133\143?\226L\204\135\163\153\132OO>\130\228\225\025\198\210\018e\bG|\194\001o\012\205\003'\215\232{\1577O\146\199\025\230\218\243\243\218\130M$\016\199\029 i\194S\141#6\b\175C8\215\195\199\204\134\015\005\016\237\206\152\197mj\141}p\229\225\186'\180`\182\000(:@\136\165\183\019\249h\200I\139\1299[\128\197pt\231\165\128\2289\135\2239\014\253\148\223f|4\018\182K\138\146\165\020\027\151\183\253\017\207\007_\022y\183\001y\150\223Q$\143;\156\148\137\129\031\178d\156Z\177\2496\154\024\220M\134>%0\021\219\002\200w\218\178\006\190\184\209n\029\238\219\220q\217XR\161\227\194\189\005)\194\163\207\170#\002\174\220t\149\169'\194\247&A\238\144\226F\133\001&\234\187\128T\1989\217S\019%\165\188}\203\162\2452Q8op,#\155Iu\251\154\220}\2334\012C\219\232<+\164\215\141E\219\127\015\22110\180\176\165\168\226\1823Qo6\0201\178f\221#\180 \239\194\163\249\220\133H\158\136\030\197K\221\141s\184\200\146\194\133\165\178O\133\011sQ\239\137k\1369Z$\199=\021\189\028-\243]1V\172\\\196\138\220$\128\241\n\235\1569\231\0114\025\238\250=\150?J\228\138\223@\221\220\140\1657\208)9\020{u\188\007\247\163^\146\029\148x\130\137\219\012`r&\174_\188$\133\248\141\251\017\207\253\244\023\023\1695\211b\199I\242\129\193!\214\020\15203\233'\153H>`\130\222\024\194'Kg\158\228!\249n]T\173\2416\015\237l\187\210G;\224\171[\190\201>\193tn\230N\030\153$H\226\0213\185'\152\216xx\147\165\155f&\127\131\137=D\162\173n\153_\183\151\017\145\227T\n\014\137\220\152K~\222\150V\207\157\006\212\029\234\254\017p\176)\2408\1351\195\166\155c\006\178\153\002\204\236\156\139\129\224%\133\016\191royH\025\230Q\144\020=\007\016\191uoy\238\231\007\186\029d\164\200\")U\241\139\247\n\162Q\127\018\2060F\171\005F\249\233\2511\023\139\007\179@\132A\228b\241\220S\\$\224\237\187\252M\152.e\196\1570\002\021g_f3\229\211l\012\b\000\t\006E\226#!\141x\154\143\145w\235:y\003xK\025\181\203\224\155\239RO1\229\192\160p\130t7c\214\232\167\216\238\243\223}\2165\208w\155\006\006f1\234\169\240\153\\\197\222\219\197J\244\178;,\254Z\007\127\\\252\233\215\255\000\209\026\188\168"

let zapf_dingbats_afm () = "x\001\181\154Mo\0279\018\134\239\250\021<\238\002\155\128\223,&\167|L\1769$\024\1403\201bo\026\185m\011#K^I^\140\255\253\146\205*\022\187\025\030\023\t\012G~\194\174\174\183\170\200*\250\230\186=_?\157\142\215/\211\245\188\223]\132}\1736\031N\143\143\211\241*>\156\158^\206\251\251\135\171\248\219\238\239BEp\255\200_\195\252\021\230\1751\127\141A\188\187=\2531\137\155\151\203uz\188\136\207\199\221\233\252t:o\175\211\237k\241\238p\016\191\229e.\226\183\2332\157\255\155>\228g\156\167\237u\127:\138\143\t~#\190=<\139/\219\023!\148P\238\141\178o\148\153\031P\249\223\143\251\255<O\159?\nk$\232\250\241\247/\207\151\237\253$\172\011\193\t\231\156q\155\252Z_\183\143\147\248\247\246\233\238\227\254x\255\199\246z\217|z>\028\230O?\127\2510\255D\240\143\182\143\251\195K\255_~L\179\019\190L\183\251\231\199\205\231\235\246\176\223\189;\222\031&!7\159/\159\246\127M\183\191\238\175\187\007q\183=\\\166\205\135\135\237y\187\187N\231\155\233*n\158\166\221~{\152\141y\255\254\244\151x\165\210_kD\004%@K\177\249\253x;\157\015\251\227\244\235\233\178\159]\241JI\201\031\127{\216\239\254<N\151\139pr\243}:_2\"\165~-\019\245\245t\221\239\166\255\167R\157\155\196\254\"\182\226<\221\239\211\018\231\233V\\\207\219\219\233q{\254S\156\238\210\130\233\195\227,\233\246 \190\189<Mw\219\217\192\242\148\244\241\235\205/\233\161\183i\181\155\221\195\148|\157]3\187\233n\191\219\220\\o\255\249Ch\200\223|\255!\162L\223\164\016\205>\165\016\2132\233.\140\022o\197\143\127\t\029 }\243U\\\158\242s\222\138\247B\226\159\183\1532\133\138\193\206\212V\205\136q\"h\017M\020^\171\002Z\004\189*\160&0\233\020u\016^!\232V+&sFkzDA\022\212\016(E\180N\248\168\011\023\n\023T,\156-\156\021*\175\006)\160\189/$ \tH:Z1\197\148\b.\153 ]!#\146\017\159\173\230\197\127\202ZI\172\"\022\1525\"$\159TV\021\214\243\186\129\173\005\225]N?SXM>\173,-\171t\202\000\157_\012\nJ:\025|1U\157\170\210\202Q\218\180j,(*\229,\161\197\173:&c\149p\202\179\177\168\0218\135h\245lZ,g\1597E\002KR)rA\245\172\147\002\130\023\222\"\025\200R\131\164gK\211\1621&KK\240YX/*\135\171\162\\\209\146\165\161]5\202X\189\234\228:\164\171X*\185)&\017\028\132\130\162X\161\190\127\164\247\159u\213\172\171C\173`\246\196\028\214\005\245s\184\128jP\212*x\141\168\226\184\0149U0\174\157%\144rJ\015@\212\201\005\002\139\164\185V\166\000\201\031{_r\202\161P>\004D-\219if\127V;)\173<*\165]\251x\224\199SVQ\156j\223\130\158AJ*\135\161\167C\011rF{\202(GE\002ZP2\136\n\217\136`\243d\235\027\014\229q\014}\222<\216)\246\164Gm\156A\2474\207u\2100GIDn\172\197!\250\164\155N\175Z*\142w\148\239\154b\184-#>9\153\252\237=\021'\n\161U\197\225\016\242$\r\000VF\185DYE\015kT-Q\195\232\186\230\025\189D\1852\132Z\24206\140YT\188$pE)\137H\"c\135(%\145B\015\152e}\006~\173\128B\129&\003\252\018e\191\006\187*\250&,_\2032J\005\207b\"\025hQ\144\205\170~m\192R-h^\011\213\002*yv\169V\004Fa\229\001\171\022\206j=\016iU\180\213.\213\138\172\022P\201#[\173Y\188\022\176\001@jYT\203\218&\243\020g\020\160V\161\174\217T\007\015\\\029\128\202\029\2377\182\173\0149\007\b\180\171\240\179\129\171\2372\252\192\017\138Yea)i\243BT\240\"\214p\187\208\201\207{s\201U\160\172\n\232|\199:\165g')|,{(\212\138\135I\229X\166\020\"\1982\025W\150\186UNqDE\185\170\142\206\252\188:F\210Hb\241q\139\140\242!\007\137-(\169$\201\208EF\021\020\031\143:y K\023\025\229mc))%1\244\\X\250\148\149\138\148Q\154|\186T*rQ\139\148Q\n\149r\171\140\146\140\134UJ{9J\233\184>\242y5D\227\202\175^\183\001\232\003\151\202\212a\144\183\136E\177|\014\127\167\170XJ\214\019\031z\1927\025\149\195\207G\133\164\1665\201\2126\165\156k\2144\171\173\194\251e\170\168\198\210Z\254\200\2100\218+\202\249j>IcR{X\134\0114,mWt\234\245q\180[(Y\245Bi\195\226t\180\180\023V\235\0065\202\024%\169\006\006\1807,\178\011Lc\175\162\244\162\211TX\164\023\159R\148\162\252\162\003Zhk`s\238RJ\175H-\205\b5\171\236\014\238\231\217\173\148]\145Z\218\017J\217E\213%4\181\021\\\251\246~M.\162 \179\188\234\250t\017`\1482\165\211\153Y\220/\1942\nllXT\203\026\\\023\022\202Z\217\228\151F\181Te\155\179o\142\233j\173F\1814\029\197\160\145@\167M\145IT\203R\129\129\198\175\006dC\162X\134\188\021\171\183tJt\211\198\160\182k\022(\023{\150N\131\180o\196\216\174\235M\235\001\191bK\205\153\147\166\192\141\012\026\200\b\220;a!\131i\147Q\199\021\027\229\146\229\206V\025\148\193(:\231\182\206\005>\016+\163\214\164\029\145u\242\128\197+\170\129`4}`R\143H:\143\203\1543Mz\217\208\228\012\r *\nC\210S\188P_#\155\2442\0114\172P\024\146\168\1486\1520\176H\1964cj\188\031\215,\012Y\026B\024bc\243Z:\145\213\002\026A0\233\007$uW\193\212\230\165\205\216\172iH\135K\1434\245XttT8\217q\165\202\219\249\152I\176\233`\211naN6\197\139\186\173H\222U\\\017m\030\004\184y\203-lM\177@\236\242\028\211\230Xm\185\234\132E.7G\221\228Mm\186\024.r\200\185\b\229C\167\243\017Y*\139\020\185J\181\189\187m\246;\234\186\028\029P\021\141y\208\019\158\207=\138\250.O\205\148Z\247\147MHP\231\229\233\236U\246\203y\229\212\2066G/E\157W-\249J\015OT*\152\014Vc\216v\176\030\195\174\131\205\024\246\029l\199p\232`7\134\161\131\253\024\142\029<\236/\021ub\r<\222[k/\198p\028\195\157\130f\172 t\n\154\177\130\208)h\198\nB\167\160\025+\b\157\130f\172 t\n\154\177\130\208)h\198\nB\167\224xB\160b\167\160\025+\024;\005\205X\193\216)h\199\n\198NA;V0v\n\218\177\130\177S\208\142\021\140\157\130v\172`\236\020\180c\005c\167\160\029+\024;\005\237PA-;\005-\140\225NA\027\199p\167\160\147c\184S\208\1691\220)\232\244\024\238\020tf\012w\n:;\134;\005\157\027\195\157\130\206\143\225NA7VPu\n\186\177\130\170S\208\141\021\164\134\014\234\254\202\147\133\244\012\200#ec\145\165\017$\181(\138G\011Y\030H\n;+\017F\001\211\t\1386c_\015<\153\206\247\153L\163\130\214\213\165\027Q\210\254b\211&\154\239_\nM\018Z\162\249D\023s\167\148\014&1 K\215/\186\190`U0\215\027H\245m\030\146\2070t\011\235\225\194t\003\163\170\201|\177\147\190\133\180\1418]N\127Z\215\129$\029\210x(\1456\151\220\164z\143oG\253]\212ua\190\176\209\249\198(9\206\163\197\212\2265pd8\t\152\234\166\243\006\225* \249\"H\0220uA\249.\202\224\251Q\155WG\r\138\231\018i\209\028\004\014g~Z\215\161\023Y\193s\137|t\205\163\r\007\128\176_+\194\131\137\228`H\187\147\139\024r\186WO\015\217z{F>n\199\024\000\220=i\234\b\163\161\147-\015'\146l\144\194\201K4\151:\194Hcg\1973\135\142\165\219\025_}\198I\157\156e\211\131\003N\1914\181\133\000\021\174:'WC\138A\175Q9S\149\163d\226\177\131\205s\250\244r\150\140\176k\150{\216\142%\225j\243\000\028\017i+\000\163\231ss\129\253\026\230n\190\135Q\185:\005T<\252\176e\012\205V\192\138\213R\014\217:\001\171\183\153|\157\158\154\179\148\210^aXR\227\007|\245\206\215\249\006Y,\132\182N\182($`0\141\214\245\238\217\214W\179\156\249r\190\190u\006\149\163\219\231@W\149*\214)\191\201\163s?O:\011[\213\160\206\136[\245\188\021A\138E\011\232`\186\129n\022\182\195\133\233B\166n\t<\179y\149\188\005\249RL\209\235Q\030qLpa\211\249\194X\215kxM\247\208\205\202n\1842\221D\215\027\028\197\179\128</\204W8.\160xN\173\235\015\r\003\252<\133\155\011P@3\156^\215W\158\007\2293\201\\3-\153Q\127\199\131\164\230\129P\202\237\156\232^a\225vv]\229cmVS\244\207E>\167\215\230\151\227m\243;'\249\159\205oI\253\015\003u\140\r"
