/*

    This file is part of the Maude 3 interpreter.

    Copyright 1997-2023 SRI International, Menlo Park, CA 94025, USA.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

*/

//
//      Forward declarations for mixfix frontend classes.
//
#ifndef _mixfix_hh_
#define _mixfix_hh_

class Timer;
class AutoWrapBuffer;
class Token;
class FileTable;
class DirectoryManager;
class SyntacticPreModule;
class PreModule;
class MixfixModule;
class ImportModule;
class ImportTranslation;
class UserLevelRewritingContext;
class QuotedIdentifierSymbol;
class QuotedIdentifierTerm;
class QuotedIdentifierDagNode;
class QuotedIdentifierOpSymbol;
class LoopSymbol;
class SymbolType;
class XmlBuffer;
class MaudemlBuffer;
class Interpreter;
class Compiler;
class ProfileModule;
class MixfixParser;
class VisibleModule;
class CommonTokens;
class MetadataStore;
class ModuleExpression;
class Renaming;
class ModuleCache;
class View;
class SyntacticView;
class ModuleDatabase;
class ViewDatabase;
class Entity;
class SyntaxContainer;
class FreshVariableSource;
class PrintAttribute;
class CacheableRewritingContext;
class ViewExpression;
class ViewCache;
class EnclosingObject;
class Argument;
class Parameter;
class ParameterDatabase;
class ObjectConstructorSymbol;
class StatementTransformer;
class MaudeLatexBuffer;
class CommutativeDecomposeEqualitySymbol;
class PrintSettings;

//
//	Support for quantifying just active computations (rather than
//	including waits for input).
//
#ifdef QUANTIFY_REWRITING
#define QUANTIFY_START()	quantify_start_recording_data()
#define QANTIFY_STOP()		quantify_stop_recording_data()
#else
#define QUANTIFY_START()
#define QUANTIFY_STOP()
#endif

#endif
