# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class XMLParser(Object):
    r"""
    XMLParser - Parse XML to handle element tags and attributes.
    
    Superclass: Object
    
    XMLParser reads a stream and parses XML element tags and
    corresponding attributes.  Each element begin tag and its attributes
    are sent to the start_element method.  Each element end tag is sent to
    the end_element method.  Subclasses should replace these methods to
    actually use the tags.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXMLParser, obj, update, **traits)
    
    encoding = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set and get the encoding the parser should expect (nullptr
        defaults to Expat's own default encoder, i.e UTF-8). This should
        be set before parsing (i.e. a call to Parse()) or even
        initializing the parser (i.e. a call to initialize_parser())
        """
    )

    def _encoding_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEncoding,
                        self.encoding)

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Set and get file name.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    ignore_character_data = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        If this is off (the default), character_data_handler will be called
        to process text within XML Elements. If this is on, the text will
        be ignored.
        """
    )

    def _ignore_character_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIgnoreCharacterData,
                        self.ignore_character_data)

    def cleanup_parser(self):
        """
        cleanup_parser(self) -> int
        C++: virtual int cleanup_parser()"""
        ret = self._vtk_obj.CleanupParser()
        return ret
        

    def initialize_parser(self):
        """
        initialize_parser(self) -> int
        C++: virtual int initialize_parser()
        When parsing fragments of XML, or when streaming XML, use the
        following three methods:
        - initialize_parser() initializes the parser but does not perform
          any actual parsing.
        - parse_chunk() parses a fragment of XML; this has to match to
          what was already parsed.
        - cleanup_parser() finishes parsing; if there were errors, it will
        report them.
        """
        ret = self._vtk_obj.InitializeParser()
        return ret
        

    def parse(self, *args):
        """
        parse(self) -> int
        C++: virtual int parse()
        parse(self, inputString:str) -> int
        C++: virtual int parse(const char *inputString)
        parse(self, inputString:str, length:int) -> int
        C++: virtual int parse(const char *inputString,
            unsigned int length)
        Parse the XML input.
        """
        ret = self._wrap_call(self._vtk_obj.Parse, *args)
        return ret

    def parse_chunk(self, *args):
        """
        parse_chunk(self, inputString:str, length:int) -> int
        C++: virtual int parse_chunk(const char *inputString,
            unsigned int length)"""
        ret = self._wrap_call(self._vtk_obj.ParseChunk, *args)
        return ret

    def seek_g(self, *args):
        """
        seek_g(self, position:int) -> None
        C++: void seek_g(TypeInt64 position)"""
        ret = self._wrap_call(self._vtk_obj.SeekG, *args)
        return ret

    def tell_g(self):
        """
        tell_g(self) -> int
        C++: TypeInt64 tell_g()
        Used by subclasses and their supporting classes.  These methods
        wrap around the tellg and seekg methods of the input stream to
        work-around stream bugs on various platforms.
        """
        ret = self._vtk_obj.TellG()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('encoding', 'GetEncoding'), ('file_name',
    'GetFileName'), ('ignore_character_data', 'GetIgnoreCharacterData'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'encoding', 'file_name',
    'ignore_character_data'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(XMLParser, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit XMLParser properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['encoding', 'file_name', 'ignore_character_data']),
            title='Edit XMLParser properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit XMLParser properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

