/* oid_names.h
 *
 * Copyright (C) 2006-2025 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */

/* Generated using (from wolfssl):
 *   cd examples/asn1
 *   ruby ./gen_oid_names.rb dumpasn1.cfg > oid_names.h
 */

typedef struct asn1App_OidName {
    byte* oid;
    word32 len;
    const char* name;
} asn1App_OidName;


static asn1App_OidName asn1App_oid_name[2767] = {
    { (byte*)"\x02\x82\x06\x01\x0a", 5,
      "Telesec" },
    { (byte*)"\x02\x82\x06\x01\x0a\x00", 6,
      "extension" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01", 6,
      "mechanism" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x00", 7,
      "authentication" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x00\x01", 8,
      "passwordAuthentication" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x00\x02", 8,
      "protectedPasswordAuthentication" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x00\x03", 8,
      "oneWayX509Authentication" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x00\x04", 8,
      "twoWayX509Authentication" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x00\x05", 8,
      "threeWayX509Authentication" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x00\x06", 8,
      "oneWayISO9798Authentication" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x00\x07", 8,
      "twoWayISO9798Authentication" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x00\x08", 8,
      "telekomAuthentication" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x01", 7,
      "signature" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x01\x01", 8,
      "md4WithRSAAndISO9697" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x01\x02", 8,
      "md4WithRSAAndTelesecSignatureStandard" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x01\x03", 8,
      "md5WithRSAAndISO9697" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x01\x04", 8,
      "md5WithRSAAndTelesecSignatureStandard" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x01\x05", 8,
      "ripemd160WithRSAAndTelekomSignatureStandard" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x01\x09", 8,
      "hbciRsaSignature" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02", 7,
      "encryption" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x00", 8,
      "none" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x01", 8,
      "rsaTelesec" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x02", 8,
      "des" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x02\x01", 9,
      "desECB" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x02\x02", 9,
      "desCBC" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x02\x03", 9,
      "desOFB" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x02\x04", 9,
      "desCFB8" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x02\x05", 9,
      "desCFB64" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x03", 8,
      "des3" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x03\x01", 9,
      "des3ECB" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x03\x02", 9,
      "des3CBC" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x03\x03", 9,
      "des3OFB" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x03\x04", 9,
      "des3CFB8" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x03\x05", 9,
      "des3CFB64" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x04", 8,
      "magenta" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x05", 8,
      "idea" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x05\x01", 9,
      "ideaECB" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x05\x02", 9,
      "ideaCBC" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x05\x03", 9,
      "ideaOFB" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x05\x04", 9,
      "ideaCFB8" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x02\x05\x05", 9,
      "ideaCFB64" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x03", 7,
      "oneWayFunction" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x03\x01", 8,
      "md4" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x03\x02", 8,
      "md5" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x03\x03", 8,
      "sqModNX509" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x03\x04", 8,
      "sqModNISO" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x03\x05", 8,
      "ripemd128" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x03\x06", 8,
      "hashUsingBlockCipher" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x03\x07", 8,
      "mac" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x03\x08", 8,
      "ripemd160" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x04", 7,
      "fecFunction" },
    { (byte*)"\x02\x82\x06\x01\x0a\x01\x04\x01", 8,
      "reedSolomon" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02", 6,
      "module" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02\x00", 7,
      "algorithms" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02\x01", 7,
      "attributeTypes" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02\x02", 7,
      "certificateTypes" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02\x03", 7,
      "messageTypes" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02\x04", 7,
      "plProtocol" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02\x05", 7,
      "smeAndComponentsOfSme" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02\x06", 7,
      "fec" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02\x07", 7,
      "usefulDefinitions" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02\x08", 7,
      "stefiles" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02\x09", 7,
      "sadmib" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02\x0a", 7,
      "electronicOrder" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02\x0b", 7,
      "telesecTtpAsymmetricApplication" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02\x0c", 7,
      "telesecTtpBasisApplication" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02\x0d", 7,
      "telesecTtpMessages" },
    { (byte*)"\x02\x82\x06\x01\x0a\x02\x0e", 7,
      "telesecTtpTimeStampApplication" },
    { (byte*)"\x02\x82\x06\x01\x0a\x03", 6,
      "objectClass" },
    { (byte*)"\x02\x82\x06\x01\x0a\x03\x00", 7,
      "telesecOtherName" },
    { (byte*)"\x02\x82\x06\x01\x0a\x03\x01", 7,
      "directory" },
    { (byte*)"\x02\x82\x06\x01\x0a\x03\x02", 7,
      "directoryType" },
    { (byte*)"\x02\x82\x06\x01\x0a\x03\x03", 7,
      "directoryGroup" },
    { (byte*)"\x02\x82\x06\x01\x0a\x03\x04", 7,
      "directoryUser" },
    { (byte*)"\x02\x82\x06\x01\x0a\x03\x05", 7,
      "symmetricKeyEntry" },
    { (byte*)"\x02\x82\x06\x01\x0a\x04", 6,
      "package" },
    { (byte*)"\x02\x82\x06\x01\x0a\x05", 6,
      "parameter" },
    { (byte*)"\x02\x82\x06\x01\x0a\x06", 6,
      "nameBinding" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07", 6,
      "attribute" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x00", 7,
      "applicationGroupIdentifier" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x01", 7,
      "certificateType" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x02", 7,
      "telesecCertificate" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x03", 7,
      "certificateNumber" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x04", 7,
      "certificateRevocationList" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x05", 7,
      "creationDate" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x06", 7,
      "issuer" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x07", 7,
      "namingAuthority" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x08", 7,
      "publicKeyDirectory" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x09", 7,
      "securityDomain" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x0a", 7,
      "subject" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x0b", 7,
      "timeOfRevocation" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x0c", 7,
      "userGroupReference" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x0d", 7,
      "validity" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x0e", 7,
      "zert93" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x0f", 7,
      "securityMessEnv" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x10", 7,
      "anonymizedPublicKeyDirectory" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x11", 7,
      "telesecGivenName" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x12", 7,
      "nameAdditions" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x13", 7,
      "telesecPostalCode" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x14", 7,
      "nameDistinguisher" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x15", 7,
      "telesecCertificateList" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x16", 7,
      "teletrustCertificateList" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x17", 7,
      "x509CertificateList" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x18", 7,
      "timeOfIssue" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x19", 7,
      "physicalCardNumber" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x1a", 7,
      "fileType" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x1b", 7,
      "ctlFileIsArchive" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x1c", 7,
      "emailAddress" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x1d", 7,
      "certificateTemplateList" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x1e", 7,
      "directoryName" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x1f", 7,
      "directoryTypeName" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x20", 7,
      "directoryGroupName" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x21", 7,
      "directoryUserName" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x22", 7,
      "revocationFlag" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x23", 7,
      "symmetricKeyEntryName" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x24", 7,
      "glNumber" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x25", 7,
      "goNumber" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x26", 7,
      "gKeyData" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x27", 7,
      "zKeyData" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x28", 7,
      "ktKeyData" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x29", 7,
      "ktKeyNumber" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x33", 7,
      "timeOfRevocationGen" },
    { (byte*)"\x02\x82\x06\x01\x0a\x07\x34", 7,
      "liabilityText" },
    { (byte*)"\x02\x82\x06\x01\x0a\x08", 6,
      "attributeGroup" },
    { (byte*)"\x02\x82\x06\x01\x0a\x09", 6,
      "action" },
    { (byte*)"\x02\x82\x06\x01\x0a\x0a", 6,
      "notification" },
    { (byte*)"\x02\x82\x06\x01\x0a\x0b", 6,
      "snmp-mibs" },
    { (byte*)"\x02\x82\x06\x01\x0a\x0b\x01", 7,
      "securityApplication" },
    { (byte*)"\x02\x82\x06\x01\x0a\x0c", 6,
      "certAndCrlExtensionDefinitions" },
    { (byte*)"\x02\x82\x06\x01\x0a\x0c\x00", 7,
      "liabilityLimitationFlag" },
    { (byte*)"\x02\x82\x06\x01\x0a\x0c\x01", 7,
      "telesecCertIdExt" },
    { (byte*)"\x02\x82\x06\x01\x0a\x0c\x02", 7,
      "Telesec policyIdentifier" },
    { (byte*)"\x02\x82\x06\x01\x0a\x0c\x03", 7,
      "telesecPolicyQualifierID" },
    { (byte*)"\x02\x82\x06\x01\x0a\x0c\x04", 7,
      "telesecCRLFilteredExt" },
    { (byte*)"\x02\x82\x06\x01\x0a\x0c\x05", 7,
      "telesecCRLFilterExt" },
    { (byte*)"\x02\x82\x06\x01\x0a\x0c\x06", 7,
      "telesecNamingAuthorityExt" },
    { (byte*)"\x04\x00\x7f\x00\x07", 5,
      "bsi" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01", 6,
      "bsiEcc" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01", 7,
      "bsifieldType" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x01", 8,
      "bsiPrimeField" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x02", 8,
      "bsiCharacteristicTwoField" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x02\x02", 9,
      "bsiECTLVKeyFormat" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x02\x02\x01", 10,
      "bsiECTLVPublicKey" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x02\x03", 9,
      "bsiCharacteristicTwoBasis" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x02\x03\x01", 10,
      "bsiGnBasis" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x02\x03\x02", 10,
      "bsiTpBasis" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x02\x03\x03", 10,
      "bsiPpBasis" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x04\x01", 9,
      "bsiEcdsaSignatures" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x04\x01\x01", 10,
      "bsiEcdsaWithSHA1" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x04\x01\x02", 10,
      "bsiEcdsaWithSHA224" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x04\x01\x03", 10,
      "bsiEcdsaWithSHA256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x04\x01\x04", 10,
      "bsiEcdsaWithSHA384" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x04\x01\x05", 10,
      "bsiEcdsaWithSHA512" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x04\x01\x06", 10,
      "bsiEcdsaWithRIPEMD160" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x01\x01", 10,
      "bsiEckaEgX963KDF" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x01\x01\x01", 11,
      "bsiEckaEgX963KDFWithSHA1" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x01\x01\x02", 11,
      "bsiEckaEgX963KDFWithSHA224" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x01\x01\x03", 11,
      "bsiEckaEgX963KDFWithSHA256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x01\x01\x04", 11,
      "bsiEckaEgX963KDFWithSHA384" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x01\x01\x05", 11,
      "bsiEckaEgX963KDFWithSHA512" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x01\x01\x06", 11,
      "bsiEckaEgX963KDFWithRIPEMD160" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x01\x02", 10,
      "bsiEckaEgSessionKDF" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x01\x02\x01", 11,
      "bsiEckaEgSessionKDFWith3DES" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x01\x02\x02", 11,
      "bsiEckaEgSessionKDFWithAES128" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x01\x02\x03", 11,
      "bsiEckaEgSessionKDFWithAES192" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x01\x02\x04", 11,
      "bsiEckaEgSessionKDFWithAES256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x02", 9,
      "bsiEckaDH" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x02\x01", 10,
      "bsiEckaDHX963KDF" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x02\x01\x01", 11,
      "bsiEckaDHX963KDFWithSHA1" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x02\x01\x02", 11,
      "bsiEckaDHX963KDFWithSHA224" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x02\x01\x03", 11,
      "bsiEckaDHX963KDFWithSHA256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x02\x01\x04", 11,
      "bsiEckaDHX963KDFWithSHA384" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x02\x01\x05", 11,
      "bsiEckaDHX963KDFWithSHA512" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x02\x01\x06", 11,
      "bsiEckaDHX963KDFWithRIPEMD160" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x02\x02", 10,
      "bsiEckaDHSessionKDF" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x02\x02\x01", 11,
      "bsiEckaDHSessionKDFWith3DES" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x02\x02\x02", 11,
      "bsiEckaDHSessionKDFWithAES128" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x02\x02\x03", 11,
      "bsiEckaDHSessionKDFWithAES192" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x01\x05\x02\x02\x04", 11,
      "bsiEckaDHSessionKDFWithAES256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x02", 7,
      "bsiEcKeyType" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x02\x01", 8,
      "bsiEcPublicKey" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x05\x01", 8,
      "bsiKaeg" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x05\x01\x01", 9,
      "bsiKaegWithX963KDF" },
    { (byte*)"\x04\x00\x7f\x00\x07\x01\x05\x01\x02", 9,
      "bsiKaegWith3DESKDF" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x01", 8,
      "bsiPK" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x01\x01", 9,
      "bsiPK_DH" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x01\x02", 9,
      "bsiPK_ECDH" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x02", 8,
      "bsiTA" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x02\x01", 9,
      "bsiTA_RSA" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x02\x01\x01", 10,
      "bsiTA_RSAv1_5_SHA1" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x02\x01\x02", 10,
      "bsiTA_RSAv1_5_SHA256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x02\x01\x03", 10,
      "bsiTA_RSAPSS_SHA1" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x02\x01\x04", 10,
      "bsiTA_RSAPSS_SHA256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x02\x01\x05", 10,
      "bsiTA_RSAv1_5_SHA512" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x02\x01\x06", 10,
      "bsiTA_RSAPSS_SHA512" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x02\x02", 9,
      "bsiTA_ECDSA" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x02\x02\x01", 10,
      "bsiTA_ECDSA_SHA1" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x02\x02\x02", 10,
      "bsiTA_ECDSA_SHA224" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x02\x02\x03", 10,
      "bsiTA_ECDSA_SHA256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x02\x02\x04", 10,
      "bsiTA_ECDSA_SHA384" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x02\x02\x05", 10,
      "bsiTA_ECDSA_SHA512" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x03", 8,
      "bsiCA" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x03\x01", 9,
      "bsiCA_DH" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x03\x01\x01", 10,
      "bsiCA_DH_3DES_CBC_CBC" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x03\x01\x02", 10,
      "bsiCA_DH_AES_CBC_CMAC_128" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x03\x01\x03", 10,
      "bsiCA_DH_AES_CBC_CMAC_192" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x03\x01\x04", 10,
      "bsiCA_DH_AES_CBC_CMAC_256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x03\x02", 9,
      "bsiCA_ECDH" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x03\x02\x01", 10,
      "bsiCA_ECDH_3DES_CBC_CBC" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x03\x02\x02", 10,
      "bsiCA_ECDH_AES_CBC_CMAC_128" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x03\x02\x03", 10,
      "bsiCA_ECDH_AES_CBC_CMAC_192" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x03\x02\x04", 10,
      "bsiCA_ECDH_AES_CBC_CMAC_256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04", 8,
      "bsiPACE" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x01", 9,
      "bsiPACE_DH_GM" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x01\x01", 10,
      "bsiPACE_DH_GM_3DES_CBC_CBC" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x01\x02", 10,
      "bsiPACE_DH_GM_AES_CBC_CMAC_128" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x01\x03", 10,
      "bsiPACE_DH_GM_AES_CBC_CMAC_192" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x01\x04", 10,
      "bsiPACE_DH_GM_AES_CBC_CMAC_256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x02", 9,
      "bsiPACE_ECDH_GM" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x02\x01", 10,
      "bsiPACE_ECDH_GM_3DES_CBC_CBC" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x02\x02", 10,
      "bsiPACE_ECDH_GM_AES_CBC_CMAC_128" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x02\x03", 10,
      "bsiPACE_ECDH_GM_AES_CBC_CMAC_192" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x02\x04", 10,
      "bsiPACE_ECDH_GM_AES_CBC_CMAC_256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x03", 9,
      "bsiPACE_DH_IM" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x03\x01", 10,
      "bsiPACE_DH_IM_3DES_CBC_CBC" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x03\x02", 10,
      "bsiPACE_DH_IM_AES_CBC_CMAC_128" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x03\x03", 10,
      "bsiPACE_DH_IM_AES_CBC_CMAC_192" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x03\x04", 10,
      "bsiPACE_DH_IM_AES_CBC_CMAC_256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x04", 9,
      "bsiPACE_ECDH_IM" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x04\x01", 10,
      "bsiPACE_ECDH_IM_3DES_CBC_CBC" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x04\x02", 10,
      "bsiPACE_ECDH_IM_AES_CBC_CMAC_128" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x04\x03", 10,
      "bsiPACE_ECDH_IM_AES_CBC_CMAC_192" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x04\x04\x04", 10,
      "bsiPACE_ECDH_IM_AES_CBC_CMAC_256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x05", 8,
      "bsiRI" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x05\x01", 9,
      "bsiRI_DH" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x05\x01\x01", 10,
      "bsiRI_DH_SHA1" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x05\x01\x02", 10,
      "bsiRI_DH_SHA224" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x05\x01\x03", 10,
      "bsiRI_DH_SHA256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x05\x01\x04", 10,
      "bsiRI_DH_SHA384" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x05\x01\x05", 10,
      "bsiRI_DH_SHA512" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x05\x02", 9,
      "bsiRI_ECDH" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x05\x02\x01", 10,
      "bsiRI_ECDH_SHA1" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x05\x02\x02", 10,
      "bsiRI_ECDH_SHA224" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x05\x02\x03", 10,
      "bsiRI_ECDH_SHA256" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x05\x02\x04", 10,
      "bsiRI_ECDH_SHA384" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x05\x02\x05", 10,
      "bsiRI_ECDH_SHA512" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x06", 8,
      "bsiCardInfo" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x07", 8,
      "bsiEidSecurity" },
    { (byte*)"\x04\x00\x7f\x00\x07\x02\x02\x08", 8,
      "bsiPT" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x02", 8,
      "bsiEACRoles" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x02\x01", 9,
      "bsiEACRolesIS" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x02\x02", 9,
      "bsiEACRolesAT" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x02\x03", 9,
      "bsiEACRolesST" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x03", 8,
      "bsiTAv2ce" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x03\x01", 9,
      "bsiTAv2ceDescription" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x03\x01\x01", 10,
      "bsiTAv2ceDescriptionPlainText" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x03\x01\x02", 10,
      "bsiTAv2ceDescriptionIA5String" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x03\x01\x03", 10,
      "bsiTAv2ceDescriptionOctetString" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x03\x02", 9,
      "bsiTAv2ceTerminalSector" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x04", 8,
      "bsiAuxData" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x04\x01", 9,
      "bsiAuxDataBirthday" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x04\x02", 9,
      "bsiAuxDataExpireDate" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x04\x03", 9,
      "bsiAuxDataCommunityID" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05", 8,
      "bsiDefectList" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05\x01", 9,
      "bsiDefectAuthDefect" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05\x01\x01", 10,
      "bsiDefectCertRevoked" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05\x01\x02", 10,
      "bsiDefectCertReplaced" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05\x01\x03", 10,
      "bsiDefectChipAuthKeyRevoked" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05\x01\x04", 10,
      "bsiDefectActiveAuthKeyRevoked" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05\x02", 9,
      "bsiDefectEPassportDefect" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05\x02\x01", 10,
      "bsiDefectEPassportDGMalformed" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05\x02\x02", 10,
      "bsiDefectSODInvalid" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05\x03", 9,
      "bsiDefectEIDDefect" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05\x03\x01", 10,
      "bsiDefectEIDDGMalformed" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05\x03\x02", 10,
      "bsiDefectEIDIntegrity" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05\x04", 9,
      "bsiDefectDocumentDefect" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05\x04\x01", 10,
      "bsiDefectCardSecurityMalformed" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05\x04\x02", 10,
      "bsiDefectChipSecurityMalformed" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x05\x04\x03", 10,
      "bsiDefectPowerDownReq" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x01\x06", 8,
      "bsiListContentDescription" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x02\x01", 8,
      "bsiSecurityObject" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x02\x02", 8,
      "bsiBlackList" },
    { (byte*)"\x04\x00\x7f\x00\x07\x03\x04\x02\x02", 9,
      "bsiSignedUpdateDeviceAdmin" },
    { (byte*)"\x04\x00\x7f\x00\x07\x04\x01\x01\x01", 9,
      "bsiCertReqMsgs" },
    { (byte*)"\x04\x00\x7f\x00\x07\x04\x01\x01\x02", 9,
      "bsiCertReqMsgswithOuterSignature" },
    { (byte*)"\x04\x00\x7f\x00\x07\x04\x01\x01\x03", 9,
      "bsiAuthorizedCertReqMsgs" },
    { (byte*)"\x04\x00\x7f\x00\x07\x04\x01\x02\x02", 9,
      "bsiSignedRevReqs" },
    { (byte*)"\x04\x00\x8e\x46", 4,
      "etsiQcsProfile" },
    { (byte*)"\x04\x00\x8e\x46\x01", 5,
      "etsiQcs" },
    { (byte*)"\x04\x00\x8e\x46\x01\x01", 6,
      "etsiQcsCompliance" },
    { (byte*)"\x04\x00\x8e\x46\x01\x02", 6,
      "etsiQcsLimitValue" },
    { (byte*)"\x04\x00\x8e\x46\x01\x03", 6,
      "etsiQcsRetentionPeriod" },
    { (byte*)"\x04\x00\x8e\x46\x01\x04", 6,
      "etsiQcsQcSSCD" },
    { (byte*)"\x04\x00\x8e\x46\x01\x05", 6,
      "etsiQcsQcPDS" },
    { (byte*)"\x04\x00\x8e\x46\x01\x06", 6,
      "etsiQcsQcType" },
    { (byte*)"\x04\x00\x8e\x46\x01\x06\x01", 7,
      "etsiQcsQctEsign" },
    { (byte*)"\x04\x00\x8e\x46\x01\x06\x02", 7,
      "etsiQcsQctEseal" },
    { (byte*)"\x04\x00\x8e\x46\x01\x06\x03", 7,
      "etsiQcsQctWeb" },
    { (byte*)"\x04\x00\x8f\x7a\x01\x01", 6,
      "normalisedCertificatePolicy" },
    { (byte*)"\x04\x00\x8f\x7a\x01\x02", 6,
      "normalisedCertificatePolicyPlus" },
    { (byte*)"\x04\x00\x8f\x7a\x01\x03", 6,
      "lightweightCertificatePolicy" },
    { (byte*)"\x04\x00\x8f\x7a\x01\x04", 6,
      "evCertificatePolicy" },
    { (byte*)"\x04\x00\x8f\x7a\x01\x05", 6,
      "evCertificatePolicyPlus" },
    { (byte*)"\x04\x00\x8f\x7a\x01\x06", 6,
      "dvCertificatePolicy" },
    { (byte*)"\x04\x00\x8f\x7a\x01\x07", 6,
      "ovCertificatePolicy" },
    { (byte*)"\x04\x00\x8b\xec\x40\x01\x00", 7,
      "qcpNatural" },
    { (byte*)"\x04\x00\x8b\xec\x40\x01\x01", 7,
      "qcpLegal" },
    { (byte*)"\x04\x00\x8b\xec\x40\x01\x02", 7,
      "qcpNaturalQscd" },
    { (byte*)"\x04\x00\x8b\xec\x40\x01\x03", 7,
      "qcpLegalQscd" },
    { (byte*)"\x04\x00\x8b\xec\x40\x01\x04", 7,
      "qcpWeb" },
    { (byte*)"\x04\x00\x8b\xec\x49\x01\x01", 7,
      "qcsSemanticsIdNatural" },
    { (byte*)"\x04\x00\x8b\xec\x49\x01\x02", 7,
      "qcsSemanticsIdLegal" },
    { (byte*)"\x04\x00\x8b\xec\x49\x01\x03", 7,
      "qcsSemanticsIdeIDASNatural" },
    { (byte*)"\x04\x00\x8b\xec\x49\x01\x04", 7,
      "qcsSemanticsIdeIDASLegal" },
    { (byte*)"\x09\x92\x26\x89\x93\xf2\x2c\x64\x01\x01", 10,
      "userID" },
    { (byte*)"\x09\x92\x26\x89\x93\xf2\x2c\x64\x01\x03", 10,
      "rfc822Mailbox" },
    { (byte*)"\x09\x92\x26\x89\x93\xf2\x2c\x64\x01\x19", 10,
      "domainComponent" },
    { (byte*)"\x28\xcf\x06\x03\x00\x31", 6,
      "ripemd160" },
    { (byte*)"\x28\xcf\x06\x03\x00\x32", 6,
      "ripemd128" },
    { (byte*)"\x28\xcf\x06\x03\x00\x37", 6,
      "whirlpool" },
    { (byte*)"\x28\x81\x8c\x71\x02", 5,
      "iso18033-2" },
    { (byte*)"\x28\x81\x8c\x71\x02\x02", 6,
      "kem" },
    { (byte*)"\x28\x81\x8c\x71\x02\x02\x04", 7,
      "kemRSA" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01", 7,
      "qgpki" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01", 8,
      "qgpkiPolicies" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x01", 9,
      "qgpkiMedIntermedCA" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x01\x01", 10,
      "qgpkiMedIntermedIndividual" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x01\x02", 10,
      "qgpkiMedIntermedDeviceControl" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x01\x03", 10,
      "qgpkiMedIntermedDevice" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x01\x04", 10,
      "qgpkiMedIntermedAuthorisedParty" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x01\x05", 10,
      "qgpkiMedIntermedDeviceSystem" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x02", 9,
      "qgpkiMedIssuingCA" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x02\x01", 10,
      "qgpkiMedIssuingIndividual" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x02\x02", 10,
      "qgpkiMedIssuingDeviceControl" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x02\x03", 10,
      "qgpkiMedIssuingDevice" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x02\x04", 10,
      "qgpkiMedIssuingAuthorisedParty" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x02\x05", 10,
      "qgpkiMedIssuingClientAuth" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x02\x06", 10,
      "qgpkiMedIssuingServerAuth" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x02\x07", 10,
      "qgpkiMedIssuingDataProt" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x02\x08", 10,
      "qgpkiMedIssuingTokenAuth" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x03", 9,
      "qgpkiBasicIntermedCA" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x03\x01", 10,
      "qgpkiBasicIntermedDeviceSystem" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x04", 9,
      "qgpkiBasicIssuingCA" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x04\x01", 10,
      "qgpkiBasicIssuingClientAuth" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x04\x02", 10,
      "qgpkiBasicIssuingServerAuth" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x01\x04\x03", 10,
      "qgpkiBasicIssuingDataSigning" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x02", 8,
      "qgpkiAssuranceLevel" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x02\x01", 9,
      "qgpkiAssuranceRudimentary" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x02\x02", 9,
      "qgpkiAssuranceBasic" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x02\x03", 9,
      "qgpkiAssuranceMedium" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x02\x04", 9,
      "qgpkiAssuranceHigh" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x03", 8,
      "qgpkiCertFunction" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x03\x01", 9,
      "qgpkiFunctionIndividual" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x03\x02", 9,
      "qgpkiFunctionDevice" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x03\x03", 9,
      "qgpkiFunctionAuthorisedParty" },
    { (byte*)"\x2a\x24\x01\x03\x01\x01\x01\x03\x04", 9,
      "qgpkiFunctionDeviceControl" },
    { (byte*)"\x2a\x24\x01\x03\x01\x02", 6,
      "qpspki" },
    { (byte*)"\x2a\x24\x01\x03\x01\x02\x01", 7,
      "qpspkiPolicies" },
    { (byte*)"\x2a\x24\x01\x03\x01\x02\x01\x02", 8,
      "qpspkiPolicyBasic" },
    { (byte*)"\x2a\x24\x01\x03\x01\x02\x01\x03", 8,
      "qpspkiPolicyMedium" },
    { (byte*)"\x2a\x24\x01\x03\x01\x02\x01\x04", 8,
      "qpspkiPolicyHigh" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02", 7,
      "qtmrpki" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x01", 8,
      "qtmrpkiPolicies" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x02", 8,
      "qtmrpkiPurpose" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x02\x01", 9,
      "qtmrpkiIndividual" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x02\x02", 9,
      "qtmrpkiDeviceControl" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x02\x03", 9,
      "qtmrpkiDevice" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x02\x04", 9,
      "qtmrpkiAuthorisedParty" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x02\x05", 9,
      "qtmrpkiDeviceSystem" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x03", 8,
      "qtmrpkiDevice" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x03\x01", 9,
      "qtmrpkiDriverLicense" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x03\x02", 9,
      "qtmrpkiIndustryAuthority" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x03\x03", 9,
      "qtmrpkiMarineLicense" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x03\x04", 9,
      "qtmrpkiAdultProofOfAge" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x03\x05", 9,
      "qtmrpkiSam" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x04", 8,
      "qtmrpkiAuthorisedParty" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x04\x01", 9,
      "qtmrpkiTransportInspector" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x04\x02", 9,
      "qtmrpkiPoliceOfficer" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x04\x03", 9,
      "qtmrpkiSystem" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x04\x04", 9,
      "qtmrpkiLiquorLicensingInspector" },
    { (byte*)"\x2a\x24\x01\x03\x01\x03\x02\x04\x05", 9,
      "qtmrpkiMarineEnforcementOfficer" },
    { (byte*)"\x2a\x24\x01\x82\x4d\x01", 6,
      "australianBusinessNumber" },
    { (byte*)"\x2a\x24\xa0\xf2\xa0\x7d\x01\x01\x02", 9,
      "signetPersonal" },
    { (byte*)"\x2a\x24\xa0\xf2\xa0\x7d\x01\x01\x03", 9,
      "signetBusiness" },
    { (byte*)"\x2a\x24\xa0\xf2\xa0\x7d\x01\x01\x04", 9,
      "signetLegal" },
    { (byte*)"\x2a\x24\xa0\xf2\xa0\x7d\x01\x01\x0a", 9,
      "signetPilot" },
    { (byte*)"\x2a\x24\xa0\xf2\xa0\x7d\x01\x01\x0b", 9,
      "signetIntraNet" },
    { (byte*)"\x2a\x24\xa0\xf2\xa0\x7d\x01\x01\x14", 9,
      "signetPolicy" },
    { (byte*)"\x2a\x24\xa4\x97\xa3\x53\x01\x64\x01\x01", 10,
      "certificatesAustraliaPolicy" },
    { (byte*)"\x2a\x70\x00\x02\x00\x22\x65\x2d\x02\x01", 10,
      "bignPubkey" },
    { (byte*)"\x2a\x70\x00\x02\x00\x22\x65\x2d\x03\x01", 10,
      "bignParamB1" },
    { (byte*)"\x2a\x70\x00\x02\x00\x22\x65\x2d\x03\x02", 10,
      "bignParamB2" },
    { (byte*)"\x2a\x70\x00\x02\x00\x22\x65\x2d\x03\x03", 10,
      "bignParamB3" },
    { (byte*)"\x2a\x70\x00\x02\x00\x22\x65\x2d\x0b", 9,
      "bignWithHSpec" },
    { (byte*)"\x2a\x70\x00\x02\x00\x22\x65\x2d\x0c", 9,
      "bignWithHBelt" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01", 6,
      "gmtCryptographicAlgorithm" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x64", 7,
      "gmtBlockCipher" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x66", 7,
      "sm1Cipher" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x67", 7,
      "ssf33Cipher" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x68", 7,
      "sm4Cipher" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x81\x48", 8,
      "gmtStreamCipher" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x81\x49", 8,
      "zucCipher" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x82\x2c", 8,
      "gmtPublicKeyCryptography" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x82\x2d", 8,
      "sm2ECC" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x82\x2d\x01", 9,
      "sm2-1DigitalSignature" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x82\x2d\x02", 9,
      "sm2-2KeyExchange" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x82\x2d\x03", 9,
      "sm2-3PublicKeyEncryption" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x82\x2e", 8,
      "gmtSM9IBE" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x82\x2e\x01", 9,
      "sm9-1DigitalSignature" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x82\x2e\x02", 9,
      "sm9-2KeyExchange" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x82\x2e\x03", 9,
      "sm9-3PublicKeyEncryption" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x83\x10", 8,
      "gmtHashAlgorithm" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x83\x11", 8,
      "sm3Hash" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x83\x11\x01", 9,
      "sm3HashWithoutKey" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x83\x11\x02", 9,
      "sm3HashWithKey" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x83\x74", 8,
      "gmtDigestSigning" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x83\x75", 8,
      "sm2withSM3" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x01\x83\x78", 8,
      "rsaWithSM3" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x04\x03", 7,
      "gmtCertificateAuthority" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06", 6,
      "gmtStandardClass" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x01", 7,
      "gmtFoundationClass" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x01\x01", 8,
      "gmtAlgorithmClass" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x01\x01\x01", 9,
      "zucStandard" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x01\x01\x02", 9,
      "sm4Standard" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x01\x01\x03", 9,
      "sm2Standard" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x01\x01\x04", 9,
      "sm3Standard" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x01\x02", 8,
      "gmtIDClass" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x01\x02\x01", 9,
      "gmtCryptoID" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x01\x03", 8,
      "gmtOperationModes" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x01\x04", 8,
      "gmtSecurityMechanism" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x01\x04\x01", 9,
      "gmtSM2Specification" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x01\x04\x02", 9,
      "gmtSM2CryptographicMessageSyntax" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x02", 7,
      "gmtDeviceClass" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x03", 7,
      "gmtServiceClass" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x04", 7,
      "gmtInfrastructure" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x05", 7,
      "gmtTestingClass" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x05\x01", 8,
      "gmtRandomTestingClass" },
    { (byte*)"\x2a\x81\x1c\xcf\x55\x06\x06", 7,
      "gmtManagementClass" },
    { (byte*)"\x2a\x83\x08\x8c\x9a\x4b\x3d\x01\x01\x01", 10,
      "mitsubishiSecurityAlgorithm" },
    { (byte*)"\x2a\x83\x08\x8c\x9a\x4b\x3d\x01\x01\x01\x01", 11,
      "misty1-cbc" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01", 7,
      "kisaAlgorithm" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x01", 8,
      "kcdsa" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x02", 8,
      "has160" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x03", 8,
      "seedECB" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x04", 8,
      "seedCBC" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x05", 8,
      "seedOFB" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x06", 8,
      "seedCFB" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x07", 8,
      "seedMAC" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x08", 8,
      "kcdsaWithHAS160" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x09", 8,
      "kcdsaWithSHA1" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x0a", 8,
      "pbeWithHAS160AndSEED-ECB" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x0b", 8,
      "pbeWithHAS160AndSEED-CBC" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x0c", 8,
      "pbeWithHAS160AndSEED-CFB" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x0d", 8,
      "pbeWithHAS160AndSEED-OFB" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x0e", 8,
      "pbeWithSHA1AndSEED-ECB" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x0f", 8,
      "pbeWithSHA1AndSEED-CBC" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x10", 8,
      "pbeWithSHA1AndSEED-CFB" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x11", 8,
      "pbeWithSHA1AndSEED-OFB" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x14", 8,
      "rsaWithHAS160" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x01\x15", 8,
      "kcdsa1" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x02", 7,
      "npkiCP" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x02\x01", 8,
      "npkiSignaturePolicy" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x03", 7,
      "npkiKP" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x04", 7,
      "npkiAT" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x05", 7,
      "npkiLCA" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x05\x01", 8,
      "npkiSignKorea" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x05\x02", 8,
      "npkiSignGate" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x05\x03", 8,
      "npkiNcaSign" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x06", 7,
      "npkiON" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x07", 7,
      "npkiAPP" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x07\x01", 8,
      "npkiSMIME" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x07\x01\x01", 9,
      "npkiSMIMEAlgo" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x07\x01\x01\x01", 10,
      "npkiCmsSEEDWrap" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x0a", 7,
      "npki" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x0a\x01", 8,
      "npkiAttribute" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x0a\x01\x01", 9,
      "npkiIdentifyData" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x0a\x01\x01\x01", 10,
      "npkiVID" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x0a\x01\x01\x02", 10,
      "npkiEncryptedVID" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x0a\x01\x01\x03", 10,
      "npkiRandomNum" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x44\x0a\x01\x01\x04", 10,
      "npkiVID" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01", 8,
      "aria1AlgorithmModes" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x01", 9,
      "aria128-ecb" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x02", 9,
      "aria128-cbc" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x03", 9,
      "aria128-cfb" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x04", 9,
      "aria128-ofb" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x05", 9,
      "aria128-ctr" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x06", 9,
      "aria192-ecb" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x07", 9,
      "aria192-cbc" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x08", 9,
      "aria192-cfb" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x09", 9,
      "aria192-ofb" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x0a", 9,
      "aria192-ctr" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x0b", 9,
      "aria256-ecb" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x0c", 9,
      "aria256-cbc" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x0d", 9,
      "aria256-cfb" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x0e", 9,
      "aria256-ofb" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x0f", 9,
      "aria256-ctr" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x15", 9,
      "aria128-cmac" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x16", 9,
      "aria192-cmac" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x17", 9,
      "aria256-cmac" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x1f", 9,
      "aria128-ocb2" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x20", 9,
      "aria192-ocb2" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x21", 9,
      "aria256-ocb2" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x22", 9,
      "aria128-gcm" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x23", 9,
      "aria192-gcm" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x24", 9,
      "aria256-gcm" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x25", 9,
      "aria128-ccm" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x26", 9,
      "aria192-ccm" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x27", 9,
      "aria256-ccm" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x28", 9,
      "aria128-keywrap" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x29", 9,
      "aria192-keywrap" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x2a", 9,
      "aria256-keywrap" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x2b", 9,
      "aria128-keywrapWithPad" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x2c", 9,
      "aria192-keywrapWithPad" },
    { (byte*)"\x2a\x83\x1a\x8c\x9a\x6e\x01\x01\x2d", 9,
      "aria256-keywrapWithPad" },
    { (byte*)"\x2a\x85\x03\x02\x02\x03", 6,
      "gostSignature" },
    { (byte*)"\x2a\x85\x03\x02\x02\x04", 6,
      "gost94Signature" },
    { (byte*)"\x2a\x85\x03\x02\x02\x13", 6,
      "gostPublicKey" },
    { (byte*)"\x2a\x85\x03\x02\x02\x14", 6,
      "gost94PublicKey" },
    { (byte*)"\x2a\x85\x03\x02\x02\x15", 6,
      "gostCipher" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1f\x00", 7,
      "testCipherParams" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1f\x01", 7,
      "cryptoProCipherA" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1f\x02", 7,
      "cryptoProCipherB" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1f\x03", 7,
      "cryptoProCipherC" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1f\x04", 7,
      "cryptoProCipherD" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1f\x05", 7,
      "oscar11Cipher" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1f\x06", 7,
      "oscar10Cipher" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1f\x07", 7,
      "ric1Cipher" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1f\x0c", 7,
      "tc26CipherA" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1f\x0d", 7,
      "tc26CipherB" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1f\x0e", 7,
      "tc26CipherC" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1f\x0f", 7,
      "tc26CipherD" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1f\x10", 7,
      "tc26CipherE" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1f\x11", 7,
      "tc26CipherF" },
    { (byte*)"\x2a\x85\x03\x07\x01\x02\x05\x01\x01", 9,
      "tc26CipherZ" },
    { (byte*)"\x2a\x85\x03\x02\x02\x09", 6,
      "gostDigest" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1e\x00", 7,
      "testDigestParams" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1e\x01", 7,
      "cryptoProDigestA" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1e\x02", 7,
      "cryptoProDigestB" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1e\x03", 7,
      "cryptoProDigestC" },
    { (byte*)"\x2a\x85\x03\x02\x02\x1e\x04", 7,
      "cryptoProDigestD" },
    { (byte*)"\x2a\x85\x03\x02\x02\x20\x02", 7,
      "cryptoPro94SignA" },
    { (byte*)"\x2a\x85\x03\x02\x02\x20\x03", 7,
      "cryptoPro94SignB" },
    { (byte*)"\x2a\x85\x03\x02\x02\x20\x04", 7,
      "cryptoPro94SignC" },
    { (byte*)"\x2a\x85\x03\x02\x02\x20\x05", 7,
      "cryptoPro94SignD" },
    { (byte*)"\x2a\x85\x03\x02\x02\x21\x01", 7,
      "cryptoPro94SignXA" },
    { (byte*)"\x2a\x85\x03\x02\x02\x21\x02", 7,
      "cryptoPro94SignXB" },
    { (byte*)"\x2a\x85\x03\x02\x02\x21\x03", 7,
      "cryptoPro94SignXC" },
    { (byte*)"\x2a\x85\x03\x02\x02\x23\x00", 7,
      "testSignParams" },
    { (byte*)"\x2a\x85\x03\x02\x02\x23\x01", 7,
      "cryptoProSignA" },
    { (byte*)"\x2a\x85\x03\x02\x02\x23\x02", 7,
      "cryptoProSignB" },
    { (byte*)"\x2a\x85\x03\x02\x02\x23\x03", 7,
      "cryptoProSignC" },
    { (byte*)"\x2a\x85\x03\x02\x02\x24\x00", 7,
      "cryptoProSignXA" },
    { (byte*)"\x2a\x85\x03\x02\x02\x24\x01", 7,
      "cryptoProSignXB" },
    { (byte*)"\x2a\x85\x03\x07\x01\x02\x01\x01\x01", 9,
      "cryptoPro2012Sign256A" },
    { (byte*)"\x2a\x85\x03\x07\x01\x02\x01\x02\x01", 9,
      "cryptoPro2012Sign512A" },
    { (byte*)"\x2a\x85\x03\x07\x01\x02\x01\x02\x02", 9,
      "cryptoPro2012Sign512B" },
    { (byte*)"\x2a\x85\x03\x07\x01\x02\x01\x02\x03", 9,
      "cryptoPro2012Sign512C" },
    { (byte*)"\x2a\x85\x03\x02\x02\x0e\x00", 7,
      "nullMeshing" },
    { (byte*)"\x2a\x85\x03\x02\x02\x0e\x01", 7,
      "cryptoProMeshing" },
    { (byte*)"\x2a\x85\x03\x02\x02\x0a", 6,
      "hmacGost" },
    { (byte*)"\x2a\x85\x03\x02\x02\x0d\x00", 7,
      "gostWrap" },
    { (byte*)"\x2a\x85\x03\x02\x02\x0d\x01", 7,
      "cryptoProWrap" },
    { (byte*)"\x2a\x85\x03\x02\x02\x60", 6,
      "cryptoProECDHWrap" },
    { (byte*)"\x2a\x85\x03\x07\x01\x01\x01\x01", 8,
      "gost2012PublicKey256" },
    { (byte*)"\x2a\x85\x03\x07\x01\x01\x01\x02", 8,
      "gost2012PublicKey512" },
    { (byte*)"\x2a\x85\x03\x07\x01\x01\x02\x02", 8,
      "gost2012Digest256" },
    { (byte*)"\x2a\x85\x03\x07\x01\x01\x02\x03", 8,
      "gost2012Digest512" },
    { (byte*)"\x2a\x85\x03\x07\x01\x01\x03\x02", 8,
      "gost2012Signature256" },
    { (byte*)"\x2a\x85\x03\x07\x01\x01\x03\x03", 8,
      "gost2012Signature512" },
    { (byte*)"\x2a\x85\x03\x07\x01\x01\x06\x01", 8,
      "cryptoProECDH256" },
    { (byte*)"\x2a\x85\x03\x07\x01\x01\x06\x02", 8,
      "cryptoProECDH512" },
    { (byte*)"\x2a\x85\x03\x64\x71\x01", 6,
      "cryptoProClassSignToolKC1" },
    { (byte*)"\x2a\x85\x03\x64\x71\x02", 6,
      "cryptoProClassSignToolKC2" },
    { (byte*)"\x2a\x85\x03\x64\x71\x03", 6,
      "cryptoProClassSignToolKC3" },
    { (byte*)"\x2a\x85\x03\x64\x71\x04", 6,
      "cryptoProClassSignToolKB1" },
    { (byte*)"\x2a\x85\x03\x64\x71\x05", 6,
      "cryptoProClassSignToolKB2" },
    { (byte*)"\x2a\x85\x03\x64\x71\x06", 6,
      "cryptoProClassSignToolKA1" },
    { (byte*)"\x2a\x85\x70\x22\x01", 5,
      "seis-cp" },
    { (byte*)"\x2a\x85\x70\x22\x01\x01", 6,
      "SEIS high-assurance policyIdentifier" },
    { (byte*)"\x2a\x85\x70\x22\x01\x02", 6,
      "SEIS GAK policyIdentifier" },
    { (byte*)"\x2a\x85\x70\x22\x02", 5,
      "SEIS pe" },
    { (byte*)"\x2a\x85\x70\x22\x03", 5,
      "SEIS at" },
    { (byte*)"\x2a\x85\x70\x22\x03\x01", 6,
      "SEIS at-personalIdentifier" },
    { (byte*)"\x2a\x86\x48\xce\x38\x01", 6,
      "module" },
    { (byte*)"\x2a\x86\x48\xce\x38\x01\x01", 7,
      "x9f1-cert-mgmt" },
    { (byte*)"\x2a\x86\x48\xce\x38\x02", 6,
      "holdinstruction" },
    { (byte*)"\x2a\x86\x48\xce\x38\x02\x01", 7,
      "holdinstruction-none" },
    { (byte*)"\x2a\x86\x48\xce\x38\x02\x02", 7,
      "callissuer" },
    { (byte*)"\x2a\x86\x48\xce\x38\x02\x03", 7,
      "reject" },
    { (byte*)"\x2a\x86\x48\xce\x38\x02\x04", 7,
      "pickupToken" },
    { (byte*)"\x2a\x86\x48\xce\x38\x03", 6,
      "attribute" },
    { (byte*)"\x2a\x86\x48\xce\x38\x03\x01", 7,
      "countersignature" },
    { (byte*)"\x2a\x86\x48\xce\x38\x03\x02", 7,
      "attribute-cert" },
    { (byte*)"\x2a\x86\x48\xce\x38\x04", 6,
      "algorithm" },
    { (byte*)"\x2a\x86\x48\xce\x38\x04\x01", 7,
      "dsa" },
    { (byte*)"\x2a\x86\x48\xce\x38\x04\x02", 7,
      "dsa-match" },
    { (byte*)"\x2a\x86\x48\xce\x38\x04\x03", 7,
      "dsaWithSha1" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x01", 6,
      "fieldType" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x01\x01", 7,
      "prime-field" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x01\x02", 7,
      "characteristic-two-field" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x01\x02\x03", 8,
      "characteristic-two-basis" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x01\x02\x03\x01", 9,
      "onBasis" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x01\x02\x03\x02", 9,
      "tpBasis" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x01\x02\x03\x03", 9,
      "ppBasis" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x02", 6,
      "publicKeyType" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x02\x01", 7,
      "ecPublicKey" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x00\x01", 8,
      "c2pnb163v1" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x00\x02", 8,
      "c2pnb163v2" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x00\x03", 8,
      "c2pnb163v3" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x00\x05", 8,
      "c2tnb191v1" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x00\x06", 8,
      "c2tnb191v2" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x00\x07", 8,
      "c2tnb191v3" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x00\x0a", 8,
      "c2pnb208w1" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x00\x0b", 8,
      "c2tnb239v1" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x00\x0c", 8,
      "c2tnb239v2" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x00\x0d", 8,
      "c2tnb239v3" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x00\x10", 8,
      "c2pnb272w1" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x00\x12", 8,
      "c2tnb359v1" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x00\x13", 8,
      "c2pnb368w1" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x00\x14", 8,
      "c2tnb431r1" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x01\x01", 8,
      "prime192v1" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x01\x02", 8,
      "prime192v2" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x01\x03", 8,
      "prime192v3" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x01\x04", 8,
      "prime239v1" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x01\x05", 8,
      "prime239v2" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x01\x06", 8,
      "prime239v3" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x03\x01\x07", 8,
      "prime256v1" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x04\x01", 7,
      "ecdsaWithSHA1" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x04\x02", 7,
      "ecdsaWithRecommended" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x04\x03", 7,
      "ecdsaWithSpecified" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x04\x03\x01", 8,
      "ecdsaWithSHA224" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x04\x03\x02", 8,
      "ecdsaWithSHA256" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x04\x03\x03", 8,
      "ecdsaWithSHA384" },
    { (byte*)"\x2a\x86\x48\xce\x3d\x04\x03\x04", 8,
      "ecdsaWithSHA512" },
    { (byte*)"\x2a\x86\x48\xce\x3e\x01", 6,
      "fieldType" },
    { (byte*)"\x2a\x86\x48\xce\x3e\x01\x01", 7,
      "gf-prime" },
    { (byte*)"\x2a\x86\x48\xce\x3e\x02", 6,
      "numberType" },
    { (byte*)"\x2a\x86\x48\xce\x3e\x02\x01", 7,
      "dhPublicKey" },
    { (byte*)"\x2a\x86\x48\xce\x3e\x03", 6,
      "scheme" },
    { (byte*)"\x2a\x86\x48\xce\x3e\x03\x01", 7,
      "dhStatic" },
    { (byte*)"\x2a\x86\x48\xce\x3e\x03\x02", 7,
      "dhEphem" },
    { (byte*)"\x2a\x86\x48\xce\x3e\x03\x03", 7,
      "dhHybrid1" },
    { (byte*)"\x2a\x86\x48\xce\x3e\x03\x04", 7,
      "dhHybrid2" },
    { (byte*)"\x2a\x86\x48\xce\x3e\x03\x05", 7,
      "mqv2" },
    { (byte*)"\x2a\x86\x48\xce\x3e\x03\x06", 7,
      "mqv1" },
    { (byte*)"\x2a\x86\x48\xce\x51\x02\x02", 7,
      "?" },
    { (byte*)"\x2a\x86\x48\xce\x51\x02\x03", 7,
      "healthcareLicense" },
    { (byte*)"\x2a\x86\x48\xce\x51\x02\x03\x01\x01", 9,
      "license?" },
    { (byte*)"\x2a\x86\x48\xce\x56", 5,
      "iec62351" },
    { (byte*)"\x2a\x86\x48\xce\x56\x08", 6,
      "iec62351_8" },
    { (byte*)"\x2a\x86\x48\xce\x56\x08\x01", 7,
      "iecUserRoles" },
    { (byte*)"\x2a\x86\x48\x86\xf6\x7d\x07", 7,
      "nsn" },
    { (byte*)"\x2a\x86\x48\x86\xf6\x7d\x07\x41", 8,
      "nsn-ce" },
    { (byte*)"\x2a\x86\x48\x86\xf6\x7d\x07\x41\x00", 9,
      "entrustVersInfo" },
    { (byte*)"\x2a\x86\x48\x86\xf6\x7d\x07\x42", 8,
      "nsn-alg" },
    { (byte*)"\x2a\x86\x48\x86\xf6\x7d\x07\x42\x03", 9,
      "cast3CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf6\x7d\x07\x42\x0a", 9,
      "cast5CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf6\x7d\x07\x42\x0b", 9,
      "cast5MAC" },
    { (byte*)"\x2a\x86\x48\x86\xf6\x7d\x07\x42\x0c", 9,
      "pbeWithMD5AndCAST5-CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf6\x7d\x07\x42\x0d", 9,
      "passwordBasedMac" },
    { (byte*)"\x2a\x86\x48\x86\xf6\x7d\x07\x43", 8,
      "nsn-oc" },
    { (byte*)"\x2a\x86\x48\x86\xf6\x7d\x07\x43\x00", 9,
      "entrustUser" },
    { (byte*)"\x2a\x86\x48\x86\xf6\x7d\x07\x44", 8,
      "nsn-at" },
    { (byte*)"\x2a\x86\x48\x86\xf6\x7d\x07\x44\x00", 9,
      "entrustCAInfo" },
    { (byte*)"\x2a\x86\x48\x86\xf6\x7d\x07\x44\x0a", 9,
      "attributeCertificate" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x01", 8,
      "pkcs-1" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01", 9,
      "rsaEncryption" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x01\x02", 9,
      "md2WithRSAEncryption" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x01\x03", 9,
      "md4WithRSAEncryption" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x01\x04", 9,
      "md5WithRSAEncryption" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x01\x05", 9,
      "sha1WithRSAEncryption" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x01\x07", 9,
      "rsaOAEP" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x01\x08", 9,
      "pkcs1-MGF" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x01\x09", 9,
      "rsaOAEP-pSpecified" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x01\x0a", 9,
      "rsaPSS" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x01\x0b", 9,
      "sha256WithRSAEncryption" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x01\x0c", 9,
      "sha384WithRSAEncryption" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x01\x0d", 9,
      "sha512WithRSAEncryption" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x01\x0e", 9,
      "sha224WithRSAEncryption" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x01\x06", 9,
      "rsaOAEPEncryptionSET" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x02", 8,
      "bsafeRsaEncr" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x03", 8,
      "pkcs-3" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x03\x01", 9,
      "dhKeyAgreement" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x05", 8,
      "pkcs-5" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x05\x01", 9,
      "pbeWithMD2AndDES-CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x05\x03", 9,
      "pbeWithMD5AndDES-CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x05\x04", 9,
      "pbeWithMD2AndRC2-CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x05\x06", 9,
      "pbeWithMD5AndRC2-CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x05\x09", 9,
      "pbeWithMD5AndXOR" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x05\x0a", 9,
      "pbeWithSHAAndDES-CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x05\x0c", 9,
      "pkcs5PBKDF2" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x05\x0d", 9,
      "pkcs5PBES2" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x05\x0e", 9,
      "pkcs5PBMAC1" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x07", 8,
      "pkcs-7" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x07\x01", 9,
      "data" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x07\x02", 9,
      "signedData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x07\x03", 9,
      "envelopedData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x07\x04", 9,
      "signedAndEnvelopedData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x07\x05", 9,
      "digestedData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x07\x06", 9,
      "encryptedData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x07\x07", 9,
      "dataWithAttributes" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x07\x08", 9,
      "encryptedPrivateKeyInfo" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09", 8,
      "pkcs-9" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x01", 9,
      "emailAddress" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x02", 9,
      "unstructuredName" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x03", 9,
      "contentType" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x04", 9,
      "messageDigest" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x05", 9,
      "signingTime" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x06", 9,
      "countersignature" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x07", 9,
      "challengePassword" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x08", 9,
      "unstructuredAddress" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x09", 9,
      "extendedCertificateAttributes" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x0a", 9,
      "issuerAndSerialNumber" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x0b", 9,
      "passwordCheck" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x0c", 9,
      "publicKey" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x0d", 9,
      "signingDescription" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x0e", 9,
      "extensionRequest" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x0f", 9,
      "sMIMECapabilities" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x0f\x01", 10,
      "preferSignedData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x0f\x02", 10,
      "canNotDecryptAny" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x0f\x03", 10,
      "receiptRequest" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x0f\x04", 10,
      "receipt" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x0f\x05", 10,
      "contentHints" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x0f\x06", 10,
      "mlExpansionHistory" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10", 9,
      "id-sMIME" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x00", 10,
      "id-mod" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x00\x01", 11,
      "id-mod-cms" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x00\x02", 11,
      "id-mod-ess" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x00\x03", 11,
      "id-mod-oid" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x00\x04", 11,
      "id-mod-msg-v3" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x00\x05", 11,
      "id-mod-ets-eSignature-88" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x00\x06", 11,
      "id-mod-ets-eSignature-97" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x00\x07", 11,
      "id-mod-ets-eSigPolicy-88" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x00\x08", 11,
      "id-mod-ets-eSigPolicy-88" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01", 10,
      "contentType" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x00", 11,
      "anyContentType" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x01", 11,
      "receipt" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x02", 11,
      "authData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x03", 11,
      "publishCert" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x04", 11,
      "tSTInfo" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x05", 11,
      "tDTInfo" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x06", 11,
      "contentInfo" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x07", 11,
      "dVCSRequestData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x08", 11,
      "dVCSResponseData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x09", 11,
      "compressedData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x0a", 11,
      "scvpCertValRequest" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x0b", 11,
      "scvpCertValResponse" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x0c", 11,
      "scvpValPolRequest" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x0d", 11,
      "scvpValPolResponse" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x0e", 11,
      "attrCertEncAttrs" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x0f", 11,
      "tSReq" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x10", 11,
      "firmwarePackage" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x11", 11,
      "firmwareLoadReceipt" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x12", 11,
      "firmwareLoadError" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x13", 11,
      "contentCollection" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x14", 11,
      "contentWithAttrs" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x15", 11,
      "encKeyWithID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x16", 11,
      "encPEPSI" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x17", 11,
      "authEnvelopedData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x18", 11,
      "routeOriginAttest" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x19", 11,
      "symmetricKeyPackage" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x1a", 11,
      "rpkiManifest" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x1b", 11,
      "asciiTextWithCRLF" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x1c", 11,
      "xml" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x1d", 11,
      "pdf" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x1e", 11,
      "postscript" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x1f", 11,
      "timestampedData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x20", 11,
      "asAdjacencyAttest" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x21", 11,
      "rpkiTrustAnchor" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x22", 11,
      "trustAnchorList" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x23", 11,
      "rpkiGhostbusters" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x24", 11,
      "resourceTaggedAttest" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x25", 11,
      "utf8TextWithCRLF" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x26", 11,
      "htmlWithCRLF" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x27", 11,
      "epub" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x28", 11,
      "animaJSONVoucher" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x29", 11,
      "mudType" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x2a", 11,
      "sztpConveyedInfoXML" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x2b", 11,
      "sztpConveyedInfoJSON" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x2c", 11,
      "cbor" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x2d", 11,
      "cborSequence" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x2e", 11,
      "animaCBORVoucher" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x2f", 11,
      "geofeedCSVwithCRLF" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x30", 11,
      "rpkiSignedChecklist" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x01\x31", 11,
      "rpkiASPA" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02", 10,
      "authenticatedAttributes" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x01", 11,
      "receiptRequest" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x02", 11,
      "securityLabel" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x03", 11,
      "mlExpandHistory" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x04", 11,
      "contentHint" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x05", 11,
      "msgSigDigest" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x06", 11,
      "encapContentType" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x07", 11,
      "contentIdentifier" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x08", 11,
      "macValue" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x09", 11,
      "equivalentLabels" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x0a", 11,
      "contentReference" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x0b", 11,
      "encrypKeyPref" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x0c", 11,
      "signingCertificate" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x0d", 11,
      "smimeEncryptCerts" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x0e", 11,
      "timeStampToken" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x0f", 11,
      "sigPolicyId" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x10", 11,
      "commitmentType" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x11", 11,
      "signerLocation" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x12", 11,
      "signerAttr" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x13", 11,
      "otherSigCert" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x14", 11,
      "contentTimestamp" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x15", 11,
      "certificateRefs" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x16", 11,
      "revocationRefs" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x17", 11,
      "certValues" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x18", 11,
      "revocationValues" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x19", 11,
      "escTimeStamp" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x1a", 11,
      "certCRLTimestamp" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x1b", 11,
      "archiveTimeStamp" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x1c", 11,
      "signatureType" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x1d", 11,
      "dvcsDvc" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x1e", 11,
      "cekReference" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x1f", 11,
      "maxCEKDecrypts" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x20", 11,
      "kekDerivationAlg" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x21", 11,
      "intendedRecipients" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x22", 11,
      "cmcUnsignedData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x23", 11,
      "fwPackageID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x24", 11,
      "fwTargetHardwareIDs" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x25", 11,
      "fwDecryptKeyID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x26", 11,
      "fwImplCryptAlgs" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x27", 11,
      "fwWrappedFirmwareKey" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x28", 11,
      "fwCommunityIdentifiers" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x29", 11,
      "fwPkgMessageDigest" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x2a", 11,
      "fwPackageInfo" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x2b", 11,
      "fwImplCompressAlgs" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x2c", 11,
      "etsAttrCertificateRefs" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x2d", 11,
      "etsAttrRevocationRefs" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x2e", 11,
      "binarySigningTime" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x2f", 11,
      "signingCertificateV2" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x30", 11,
      "etsArchiveTimeStampV2" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x31", 11,
      "erInternal" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x32", 11,
      "erExternal" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x33", 11,
      "multipleSignatures" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x34", 11,
      "cmsAlgorithmProtect" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x35", 11,
      "setKeyInformation" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x36", 11,
      "asymmDecryptKeyID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x37", 11,
      "secureHeaderFieldsIdentifier" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x38", 11,
      "otpChallenge" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x39", 11,
      "revocationChallenge" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x02\x3a", 11,
      "estIdentityLinking" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x01", 11,
      "esDHwith3DES" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x02", 11,
      "esDHwithRC2" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x03", 11,
      "3desWrap" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x04", 11,
      "rc2Wrap" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x05", 11,
      "esDH" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x06", 11,
      "cms3DESwrap" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x07", 11,
      "cmsRC2wrap" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x08", 11,
      "zlib" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x09", 11,
      "pwriKEK" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x0a", 11,
      "ssDH" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x0b", 11,
      "hmacWith3DESwrap" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x0c", 11,
      "hmacWithAESwrap" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x0d", 11,
      "md5XorExperiment" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x0e", 11,
      "rsaKEM" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x0f", 11,
      "authEnc128" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x10", 11,
      "authEnc256" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x11", 11,
      "hssLmsHashSig" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x12", 11,
      "chaCha20Poly1305" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x13", 11,
      "ecdhHKDF-SHA256" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x14", 11,
      "ecdhHKDF-SHA384" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x15", 11,
      "ecdhHKDF-SHA512" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x16", 11,
      "aesSIV-CMAC-256" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x17", 11,
      "aesSIV-CMAC-384" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x18", 11,
      "aesSIV-CMAC-512" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x19", 11,
      "aesSIV-CMAC-wrap256" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x1a", 11,
      "aesSIV-CMAC-wrap384" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x1b", 11,
      "aesSIV-CMAC-wrap512" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x1c", 11,
      "hkdfWithSha256" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x1d", 11,
      "hkdfWithSha384" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x03\x1e", 11,
      "hkdfWithSha512" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x04\x01", 11,
      "certDist-ldap" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x05\x01", 11,
      "sigPolicyQualifier-spuri x" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x05\x02", 11,
      "sigPolicyQualifier-spUserNotice" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x06\x01", 11,
      "proofOfOrigin" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x06\x02", 11,
      "proofOfReceipt" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x06\x03", 11,
      "proofOfDelivery" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x06\x04", 11,
      "proofOfSender" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x06\x05", 11,
      "proofOfApproval" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x06\x06", 11,
      "proofOfCreation" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x07\x01", 11,
      "testAmoco" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x07\x02", 11,
      "testCaterpillar" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x07\x03", 11,
      "testWhirlpool" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x07\x04", 11,
      "testWhirlpoolCategories" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x08\x01", 11,
      "glUseKEK" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x08\x02", 11,
      "glDelete" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x08\x03", 11,
      "glAddMember" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x08\x04", 11,
      "glDeleteMember" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x08\x05", 11,
      "glRekey" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x08\x06", 11,
      "glAddOwner" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x08\x07", 11,
      "glRemoveOwner" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x08\x08", 11,
      "glkCompromise" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x08\x09", 11,
      "glkRefresh" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x08\x0a", 11,
      "glFailInfo" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x08\x0b", 11,
      "glaQueryRequest" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x08\x0c", 11,
      "glaQueryResponse" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x08\x0d", 11,
      "glProvideCert" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x08\x0e", 11,
      "glUpdateCert" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x08\x0f", 11,
      "glKey" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x09", 10,
      "signatureTypeIdentifier" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x09\x01", 11,
      "originatorSig" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x09\x02", 11,
      "domainSig" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x09\x03", 11,
      "additionalAttributesSig" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x09\x04", 11,
      "reviewSig" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0a\x01", 11,
      "envelopedData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0a\x02", 11,
      "signedData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0a\x03", 11,
      "certsOnly" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0a\x04", 11,
      "signedReceipt" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0a\x05", 11,
      "envelopedX400" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0a\x06", 11,
      "signedX400" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0a\x07", 11,
      "compressedData" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0b", 10,
      "capabilities" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0b\x01", 11,
      "preferBinaryInside" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c", 10,
      "pskcAttributes" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x01", 11,
      "pskcManufacturer" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x02", 11,
      "pskcSerialNo" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x03", 11,
      "pskcModel" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x04", 11,
      "pskcIssueno" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x05", 11,
      "pskcDevicebinding" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x06", 11,
      "pskcDevicestartdate" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x07", 11,
      "pskcDeviceexpirydate" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x08", 11,
      "pskcModuleid" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x09", 11,
      "pskcKeyid" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x0a", 11,
      "pskcAlgorithm" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x0b", 11,
      "pskcIssuer" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x0c", 11,
      "pskcKeyprofileid" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x0d", 11,
      "pskcKeyreference" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x0e", 11,
      "pskcFriendlyname" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x0f", 11,
      "pskcAlgorithmparams" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x10", 11,
      "pskcCounter" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x11", 11,
      "pskcTime" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x12", 11,
      "pskcTimeinterval" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x13", 11,
      "pskcTimedrift" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x14", 11,
      "pskcValuemac" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x15", 11,
      "pskcKeystartdate" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x16", 11,
      "pskcKeyexpirydate" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x17", 11,
      "pskcNooftransactions" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x18", 11,
      "pskcKeyusages" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x19", 11,
      "pskcPinpolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x1a", 11,
      "pskcDeviceuserid" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0c\x1b", 11,
      "pskcKeyuserid" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0d", 10,
      "otherRecipientInfoIds" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0d\x01", 11,
      "keyTransPSK" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x10\x0d\x02", 11,
      "keyAgreePSK" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x14", 9,
      "friendlyName (for PKCS #12)" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x15", 9,
      "localKeyID (for PKCS #12)" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x16", 9,
      "certTypes (for PKCS #12)" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x16\x01", 10,
      "x509Certificate (for PKCS #12)" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x16\x02", 10,
      "sdsiCertificate (for PKCS #12)" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x17", 9,
      "crlTypes (for PKCS #12)" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x17\x01", 10,
      "x509Crl (for PKCS #12)" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x18", 9,
      "pkcs9objectClass" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x19", 9,
      "pkcs9attributes" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x19\x01", 10,
      "pkcs15Token" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x19\x02", 10,
      "encryptedPrivateKeyInfo" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x19\x03", 10,
      "randomNonce" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x19\x04", 10,
      "sequenceNumber" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x19\x05", 10,
      "pkcs7PDU" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x1a", 9,
      "pkcs9syntax" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x1b", 9,
      "pkcs9matchingRules" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x09\x34", 9,
      "cmsAlgorithmProtection" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c", 8,
      "pkcs-12" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x01", 9,
      "pkcs-12-PbeIds" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x01\x01", 10,
      "pbeWithSHAAnd128BitRC4" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x01\x02", 10,
      "pbeWithSHAAnd40BitRC4" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x01\x03", 10,
      "pbeWithSHAAnd3-KeyTripleDES-CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x01\x04", 10,
      "pbeWithSHAAnd2-KeyTripleDES-CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x01\x05", 10,
      "pbeWithSHAAnd128BitRC2-CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x01\x06", 10,
      "pbeWithSHAAnd40BitRC2-CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x02", 9,
      "pkcs-12-ESPVKID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x02\x01", 10,
      "pkcs-12-PKCS8KeyShrouding" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x03", 9,
      "pkcs-12-BagIds" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x03\x01", 10,
      "pkcs-12-keyBagId" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x03\x02", 10,
      "pkcs-12-certAndCRLBagId" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x03\x03", 10,
      "pkcs-12-secretBagId" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x03\x04", 10,
      "pkcs-12-safeContentsId" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x03\x05", 10,
      "pkcs-12-pkcs-8ShroudedKeyBagId" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x04", 9,
      "pkcs-12-CertBagID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x04\x01", 10,
      "pkcs-12-X509CertCRLBagID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x04\x02", 10,
      "pkcs-12-SDSICertBagID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x05", 9,
      "pkcs-12-OID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x05\x01", 10,
      "pkcs-12-PBEID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x05\x01\x01", 11,
      "pkcs-12-PBEWithSha1And128BitRC4" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x05\x01\x02", 11,
      "pkcs-12-PBEWithSha1And40BitRC4" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x05\x01\x03", 11,
      "pkcs-12-PBEWithSha1AndTripleDESCBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x05\x01\x04", 11,
      "pkcs-12-PBEWithSha1And128BitRC2CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x05\x01\x05", 11,
      "pkcs-12-PBEWithSha1And40BitRC2CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x05\x01\x06", 11,
      "pkcs-12-PBEWithSha1AndRC4" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x05\x01\x07", 11,
      "pkcs-12-PBEWithSha1AndRC2CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x05\x02", 10,
      "pkcs-12-EnvelopingID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x05\x02\x01", 11,
      "pkcs-12-RSAEncryptionWith128BitRC4" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x05\x02\x02", 11,
      "pkcs-12-RSAEncryptionWith40BitRC4" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x05\x02\x03", 11,
      "pkcs-12-RSAEncryptionWithTripleDES" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x05\x03", 10,
      "pkcs-12-SignatureID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x05\x03\x01", 11,
      "pkcs-12-RSASignatureWithSHA1Digest" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x0a", 9,
      "pkcs-12Version1" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x0a\x01", 10,
      "pkcs-12BadIds" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x0a\x01\x01", 11,
      "pkcs-12-keyBag" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x0a\x01\x02", 11,
      "pkcs-12-pkcs-8ShroudedKeyBag" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x0a\x01\x03", 11,
      "pkcs-12-certBag" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x0a\x01\x04", 11,
      "pkcs-12-crlBag" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x0a\x01\x05", 11,
      "pkcs-12-secretBag" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0c\x0a\x01\x06", 11,
      "pkcs-12-safeContentsBag" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0f\x01", 9,
      "pkcs15modules" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0f\x02", 9,
      "pkcs15attributes" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0f\x03", 9,
      "pkcs15contentType" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x01\x0f\x03\x01", 10,
      "pkcs15content" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x02", 7,
      "digestAlgorithm" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x02\x02", 8,
      "md2" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x02\x04", 8,
      "md4" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x02\x05", 8,
      "md5" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x02\x07", 8,
      "hmacWithSHA1" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x02\x08", 8,
      "hmacWithSHA224" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x02\x09", 8,
      "hmacWithSHA256" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x02\x0a", 8,
      "hmacWithSHA384" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x02\x0b", 8,
      "hmacWithSHA512" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x03", 7,
      "encryptionAlgorithm" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x03\x02", 8,
      "rc2CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x03\x03", 8,
      "rc2ECB" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x03\x04", 8,
      "rc4" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x03\x05", 8,
      "rc4WithMAC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x03\x06", 8,
      "desx-CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x03\x07", 8,
      "des-EDE3-CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x03\x08", 8,
      "rc5CBC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x03\x09", 8,
      "rc5-CBCPad" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x0d\x03\x0a", 8,
      "desCDMF" },
    { (byte*)"\x2a\x86\x48\x86\xfa\x65\x01\x06\x01", 9,
      "Identrus unknown policyIdentifier" },
    { (byte*)"\x2a\x86\x48\x86\xfa\x65\x04\x01", 8,
      "identrusOCSP" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x02\x81\x71", 10,
      "deliveryMechanism" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x02\x82\x19", 10,
      "ntSecurityDescriptor" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x03\x00", 9,
      "site-Addressing" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x03\x0d", 9,
      "classSchema" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x03\x0e", 9,
      "attributeSchema" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x03\x11", 9,
      "mailbox-Agent" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x03\x16", 9,
      "mailbox" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x03\x17", 9,
      "container" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x03\x2e", 9,
      "mailRecipient" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x81\x11", 10,
      "revision" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8a\x2f", 10,
      "pKIDefaultKeySpec" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8a\x30", 10,
      "pKIKeyUsage" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8a\x31", 10,
      "pKIMaxIssuingDepth" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8a\x32", 10,
      "pKICriticalExtensions" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8a\x33", 10,
      "pKIExpirationPeriod" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8a\x34", 10,
      "pKIOverlapPeriod" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8a\x35", 10,
      "pKIExtendedKeyUsage" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8a\x36", 10,
      "pKIDefaultCSPs" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8a\x37", 10,
      "pKIEnrollmentAccess" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8b\x15", 10,
      "msPKI-RA-Signature" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8b\x16", 10,
      "msPKI-Enrollment-Flag" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8b\x17", 10,
      "msPKI-Private-Key-Flag" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8b\x18", 10,
      "msPKI-Certificate-Name-Flag" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8b\x19", 10,
      "msPKI-Minimal-Key-Size" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8b\x1a", 10,
      "msPKI-Template-Schema-Version" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8b\x1b", 10,
      "msPKI-Template-Minor-Revision" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8b\x1c", 10,
      "msPKI-Cert-Template-OID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8b\x1d", 10,
      "msPKI-Supersede-Templates" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8b\x1e", 10,
      "msPKI-RA-Policies" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8b\x1f", 10,
      "msPKI-Certificate-Policy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8d\x0a", 10,
      "msPKI-Certificate-Application-Policy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x01\x04\x8d\x0b", 10,
      "msPKI-RA-Application-Policies" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x04\x03", 8,
      "microsoftExcel" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x04\x04", 8,
      "titledWithOID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x14\x04\x05", 8,
      "microsoftPowerPoint" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01", 7,
      "adobeAcrobat" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x01", 8,
      "acrobatSecurity" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x01\x01", 9,
      "pdfPassword" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x01\x02", 9,
      "pdfDefaultSigningCredential" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x01\x03", 9,
      "pdfDefaultEncryptionCredential" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x01\x04", 9,
      "pdfPasswordTimeout" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x01\x05", 9,
      "pdfAuthenticDocumentsTrust" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x01\x06", 9,
      "pdfDynamicContentTrust" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x01\x07", 9,
      "pdfUbiquityTrust" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x01\x08", 9,
      "pdfRevocationInfoArchival" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x01\x09", 9,
      "pdfX509Extension" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x01\x09\x01", 10,
      "pdfTimeStamp" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x01\x09\x02", 10,
      "pdfArchiveRevInfo" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x01\x0a", 9,
      "pdfPPLKLiteCredential" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x02", 8,
      "acrobatCPS" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x02\x01", 9,
      "pdfAuthenticDocumentsCPS" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x02\x02", 9,
      "pdfTestCPS" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x02\x03", 9,
      "pdfUbiquityCPS" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x02\x04", 9,
      "pdfAdhocCPS" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x07", 8,
      "acrobatUbiquity" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x07\x01", 9,
      "pdfUbiquitySubRights" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x2f\x01\x09", 8,
      "acrobatExtension" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x5c\x72\x01\x07", 9,
      "adobePKCS7" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64", 7,
      "appleDataSecurity" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01", 8,
      "appleTrustPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x01", 9,
      "appleISignTP" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x02", 9,
      "appleX509Basic" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x03", 9,
      "appleSSLPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x04", 9,
      "appleLocalCertGenPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x05", 9,
      "appleCSRGenPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x06", 9,
      "appleCRLPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x07", 9,
      "appleOCSPPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x08", 9,
      "appleSMIMEPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x09", 9,
      "appleEAPPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x0a", 9,
      "appleSWUpdateSigningPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x0b", 9,
      "appleIPSecPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x0c", 9,
      "appleIChatPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x0d", 9,
      "appleResourceSignPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x0e", 9,
      "applePKINITClientPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x0f", 9,
      "applePKINITServerPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x10", 9,
      "appleCodeSigningPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x01\x11", 9,
      "applePackageSigningPolicy" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x02", 8,
      "appleSecurityAlgorithm" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x02\x01", 9,
      "appleFEE" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x02\x02", 9,
      "appleASC" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x02\x03", 9,
      "appleFEE_MD5" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x02\x04", 9,
      "appleFEE_SHA1" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x02\x05", 9,
      "appleFEED" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x02\x06", 9,
      "appleFEEDEXP" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x02\x07", 9,
      "appleECDSA" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x03", 8,
      "appleDotMacCertificate" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x03\x01", 9,
      "appleDotMacCertificateRequest" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x03\x02", 9,
      "appleDotMacCertificateExtension" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x03\x03", 9,
      "appleDotMacCertificateRequestValues" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04", 8,
      "appleExtendedKeyUsage" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x01", 9,
      "appleCodeSigning" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x01\x01", 10,
      "appleCodeSigningDevelopment" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x01\x02", 10,
      "appleSoftwareUpdateSigning" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x01\x03", 10,
      "appleCodeSigningThirdParty" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x01\x04", 10,
      "appleResourceSigning" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x02", 9,
      "appleIChatSigning" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x03", 9,
      "appleIChatEncryption" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x04", 9,
      "appleSystemIdentity" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x05", 9,
      "appleCryptoEnv" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x05\x01", 10,
      "appleCryptoProductionEnv" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x05\x02", 10,
      "appleCryptoMaintenanceEnv" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x05\x03", 10,
      "appleCryptoTestEnv" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x05\x04", 10,
      "appleCryptoDevelopmentEnv" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x06", 9,
      "appleCryptoQoS" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x06\x01", 10,
      "appleCryptoTier0QoS" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x06\x02", 10,
      "appleCryptoTier1QoS" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x06\x03", 10,
      "appleCryptoTier2QoS" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x04\x06\x04", 10,
      "appleCryptoTier3QoS" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x05", 8,
      "appleCertificatePolicies" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x05\x01", 9,
      "appleCertificatePolicyID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x05\x02", 9,
      "appleDotMacCertificatePolicyID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x05\x03", 9,
      "appleADCCertificatePolicyID" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x06", 8,
      "appleCertificateExtensions" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x06\x01", 9,
      "appleCertificateExtensionCodeSigning" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x06\x01\x01", 10,
      "appleCertificateExtensionAppleSigning" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x06\x01\x02", 10,
      "appleCertificateExtensionADCDeveloperSigning" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x06\x01\x03", 10,
      "appleCertificateExtensionADCAppleSigning" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x0f\x01", 9,
      "appleCustomCertificateExtension1" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x0f\x02", 9,
      "appleCustomCertificateExtension2" },
    { (byte*)"\x2a\x86\x48\x86\xf7\x63\x64\x0f\x03", 9,
      "appleCustomCertificateExtension3" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x04", 10,
      "spcIndirectDataContext" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x0a", 10,
      "spcAgencyInfo" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x0b", 10,
      "spcStatementType" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x0c", 10,
      "spcSpOpusInfo" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x0e", 10,
      "certReqExtensions" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x0f", 10,
      "spcPEImageData" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x12", 10,
      "spcRawFileData" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x13", 10,
      "spcStructuredStorageData" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x14", 10,
      "spcJavaClassData (type 1)" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x15", 10,
      "individualCodeSigning" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x16", 10,
      "commercialCodeSigning" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x19", 10,
      "spcLink (type 2)" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x1a", 10,
      "spcMinimalCriteriaInfo" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x1b", 10,
      "spcFinancialCriteriaInfo" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x1c", 10,
      "spcLink (type 3)" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x1d", 10,
      "spcHashInfoObjID" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x01\x1e", 10,
      "spcSipInfoObjID" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x02", 9,
      "ctl" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x02\x01", 10,
      "ctlTrustedCodesigningCAList" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x02\x02", 10,
      "ctlTrustedClientAuthCAList" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x02\x02\x03", 10,
      "ctlTrustedServerAuthCAList" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x03\x02\x01", 10,
      "timestampRequest" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x01", 9,
      "certTrustList" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x01\x01", 10,
      "sortedCtl" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x02", 9,
      "nextUpdateLocation" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x01", 10,
      "certTrustListSigning" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x02", 10,
      "timeStampSigning" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x03", 10,
      "serverGatedCrypto" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x03\x01", 11,
      "serialized" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x04", 10,
      "encryptedFileSystem" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x05", 10,
      "whqlCrypto" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x06", 10,
      "nt5Crypto" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x07", 10,
      "oemWHQLCrypto" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x08", 10,
      "embeddedNTCrypto" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x09", 10,
      "rootListSigner" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x0a", 10,
      "qualifiedSubordination" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x0b", 10,
      "keyRecovery" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x0c", 10,
      "documentSigning" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x0d", 10,
      "lifetimeSigning" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x0e", 10,
      "mobileDeviceSoftware" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x0f", 10,
      "smartDisplay" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x10", 10,
      "cspSignature" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x03\x04\x01", 11,
      "efsRecovery" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x04\x01", 10,
      "yesnoTrustAttr" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x05\x01", 10,
      "drm" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x05\x02", 10,
      "drmIndividualization" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x06\x01", 10,
      "licenses" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x06\x02", 10,
      "licenseServer" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x07\x01", 10,
      "keyidRdn" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x08\x01", 10,
      "removeCertificate" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x09\x01", 10,
      "crossCertDistPoints" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x0a\x01", 10,
      "cmcAddAttributes" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x0b", 9,
      "certPropIdPrefix" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x0b\x04", 10,
      "certMd5HashPropId" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x0b\x14", 10,
      "certKeyIdentifierPropId" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x0b\x1c", 10,
      "certIssuerSerialNumberMd5HashPropId" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x0b\x1d", 10,
      "certSubjectNameMd5HashPropId" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0a\x0c\x01", 10,
      "anyApplicationPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0c", 8,
      "catalog" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0c\x01\x01", 10,
      "catalogList" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0c\x01\x02", 10,
      "catalogListMember" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0c\x02\x01", 10,
      "catalogNameValueObjID" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0c\x02\x02", 10,
      "catalogMemberInfoObjID" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0d\x01", 9,
      "renewalCertificate" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0d\x02\x01", 10,
      "enrolmentNameValuePair" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0d\x02\x02", 10,
      "enrolmentCSP" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x0d\x02\x03", 10,
      "osVersion" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x10\x04", 9,
      "microsoftRecipientInfo" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x11\x01", 9,
      "pkcs12KeyProviderNameAttr" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x11\x02", 9,
      "localMachineKeyset" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x11\x03", 9,
      "pkcs12ExtendedAttributes" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x14\x01", 9,
      "autoEnrollCtlUsage" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x14\x02", 9,
      "enrollCerttypeExtension" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x14\x02\x01", 10,
      "enrollmentAgent" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x14\x02\x02", 10,
      "smartcardLogon" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x14\x02\x03", 10,
      "userPrincipalName" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x14\x03", 9,
      "certManifold" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x01", 9,
      "cAKeyCertIndexPair" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x02", 9,
      "certSrvPreviousCertHash" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x03", 9,
      "crlVirtualBase" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x04", 9,
      "crlNextPublish" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x05", 9,
      "caExchange" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x06", 9,
      "keyRecovery" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x07", 9,
      "certificateTemplate" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x09", 9,
      "rdnDummySigner" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x0a", 9,
      "applicationCertPolicies" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x0b", 9,
      "applicationPolicyMappings" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x0c", 9,
      "applicationPolicyConstraints" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x0d", 9,
      "archivedKey" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x0e", 9,
      "crlSelfCDP" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x0f", 9,
      "requireCertChainPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x10", 9,
      "archivedKeyCertHash" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x11", 9,
      "issuedCertHash" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x13", 9,
      "dsEmailReplication" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x14", 9,
      "requestClientInfo" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x15", 9,
      "encryptedKeyHash" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x15\x16", 9,
      "certsrvCrossCaVersion" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x19\x01", 9,
      "ntdsReplication" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x19\x02", 9,
      "ntdsCASecurityExt" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x19\x02\x01", 10,
      "ntdsObjectSID" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x1f\x01", 9,
      "productUpdate" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x2f\x01\x01", 10,
      "systemHealth" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x2f\x01\x03", 10,
      "systemHealthLoophole" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x3c\x01\x01", 10,
      "rootProgramFlags" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x3d\x01\x01", 10,
      "kernelModeCodeSigning" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x3c\x02\x01\x01", 11,
      "jurisdictionOfIncorporationL" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x3c\x02\x01\x02", 11,
      "jurisdictionOfIncorporationSP" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x3c\x02\x01\x03", 11,
      "jurisdictionOfIncorporationC" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x4c\x83\x7d\x01\x01", 12,
      "microsoftCPS" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x58", 8,
      "capiCom" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x58\x01", 9,
      "capiComVersion" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x58\x02", 9,
      "capiComAttribute" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x58\x02\x01", 10,
      "capiComDocumentName" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x58\x02\x02", 10,
      "capiComDocumentDescription" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x58\x03", 9,
      "capiComEncryptedData" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x37\x58\x03\x01", 10,
      "capiComEncryptedContent" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\x3c\x07\x01\x01", 10,
      "ascom" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\x3c\x07\x01\x01\x01", 11,
      "ideaECB" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\x3c\x07\x01\x01\x02", 11,
      "ideaCBC" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\x3c\x07\x01\x01\x03", 11,
      "ideaCFB" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\x3c\x07\x01\x01\x04", 11,
      "ideaOFB" },
    { (byte*)"\x2b\x06\x01\x04\x01\x92\x3b\x03\x02", 9,
      "euroControlUntrustedEA" },
    { (byte*)"\x2b\x06\x01\x04\x01\x92\x3b\x04\x03", 9,
      "euroControlEARootCA" },
    { (byte*)"\x2b\x06\x01\x04\x01\x92\x3b\x04\x03\x01", 10,
      "euroControlEABridgeCA" },
    { (byte*)"\x2b\x06\x01\x04\x01\x92\x3b\x04\x03\x01\x01", 11,
      "euroControlEAIssuingCA" },
    { (byte*)"\x2b\x06\x01\x04\x01\x92\x3b\x04\x03\x01\x01\x01", 12,
      "euroControlEAClientCertificate" },
    { (byte*)"\x2b\x06\x01\x04\x01\x92\x3b\x04\x03\x01\x01\x02", 12,
      "euroControlEAServerCertificate" },
    { (byte*)"\x2b\x06\x01\x04\x01\x92\x3b\x04\x03\x01\x01\x03", 12,
      "euroControlEASWIMSigningCertificate" },
    { (byte*)"\x2b\x06\x01\x04\x01\x92\x7c\x0a\x01\x01", 10,
      "UNINETT policyIdentifier" },
    { (byte*)"\x2b\x06\x01\x04\x01\x95\x18\x0a", 8,
      "ICE-TEL policyIdentifier" },
    { (byte*)"\x2b\x06\x01\x04\x01\x95\x62\x01\x01\x01", 10,
      "ICE-TEL Italian policyIdentifier" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x01\x01\x01", 10,
      "blowfishECB" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x01\x01\x02", 10,
      "blowfishCBC" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x01\x01\x03", 10,
      "blowfishCFB" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x01\x01\x04", 10,
      "blowfishOFB" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x01\x02\x01", 10,
      "elgamal" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x01\x02\x01\x01", 11,
      "elgamalWithSHA-1" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x01\x02\x01\x02", 11,
      "elgamalWithRIPEMD-160" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x03\x01\x01", 10,
      "cryptlibPresenceCheck" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x03\x01\x02", 10,
      "pkiBoot" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x03\x01\x04", 10,
      "crlExtReason" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x03\x01\x05", 10,
      "keyFeatures" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x04\x01", 9,
      "cryptlibContent" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x04\x01\x01", 10,
      "cryptlibConfigData" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x04\x01\x02", 10,
      "cryptlibUserIndex" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x04\x01\x03", 10,
      "cryptlibUserInfo" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x04\x01\x04", 10,
      "rtcsRequest" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x04\x01\x05", 10,
      "rtcsResponse" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x04\x01\x06", 10,
      "rtcsResponseExt" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x2a\xd7\x24\x01", 11,
      "mpeg-1" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x36\xdd\x24\x36", 11,
      "TSA policy \"Anything that arrives, we sign\"" },
    { (byte*)"\x2b\x06\x01\x04\x01\x97\x55\x58\x59\x5a\x5a\x59", 12,
      "xYZZY policyIdentifier" },
    { (byte*)"\x2b\x06\x01\x04\x01\x9a\x49\x08\x01\x01", 10,
      "pgpExtension" },
    { (byte*)"\x2b\x06\x01\x04\x01\x9b\x78\x07", 8,
      "eciaAscX12Edi" },
    { (byte*)"\x2b\x06\x01\x04\x01\x9b\x78\x07\x01", 9,
      "plainEDImessage" },
    { (byte*)"\x2b\x06\x01\x04\x01\x9b\x78\x07\x02", 9,
      "signedEDImessage" },
    { (byte*)"\x2b\x06\x01\x04\x01\x9b\x78\x07\x05", 9,
      "integrityEDImessage" },
    { (byte*)"\x2b\x06\x01\x04\x01\x9b\x78\x07\x41", 9,
      "iaReceiptMessage" },
    { (byte*)"\x2b\x06\x01\x04\x01\x9b\x78\x07\x61", 9,
      "iaStatusMessage" },
    { (byte*)"\x2b\x06\x01\x04\x01\x9b\x78\x08", 8,
      "eciaEdifact" },
    { (byte*)"\x2b\x06\x01\x04\x01\x9b\x78\x09", 8,
      "eciaNonEdi" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa0\x32", 7,
      "Globalsign" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa0\x32\x01", 8,
      "globalsignPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa0\x32\x01\x0a", 9,
      "globalsignDVPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa0\x32\x01\x14", 9,
      "globalsignOVPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa0\x32\x01\x1e", 9,
      "globalsignTSAPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa0\x32\x01\x28", 9,
      "globalsignClientCertPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa0\x32\x01\x32", 9,
      "globalsignCodeSignPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa0\x32\x01\x3c", 9,
      "globalsignRootSignPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa0\x32\x01\x46", 9,
      "globalsignTrustedRootPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa0\x32\x01\x50", 9,
      "globalsignEDIClientPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa0\x32\x01\x51", 9,
      "globalsignEDIServerPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa0\x32\x01\x5a", 9,
      "globalsignTPMRootPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa0\x32\x01\x5f", 9,
      "globalsignOCSPPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa9\x3d\x01", 8,
      "edelWebPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa9\x3d\x01\x02", 9,
      "edelWebCustomerPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa9\x3d\x01\x02\x01", 10,
      "edelWebClepsydrePolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa9\x3d\x01\x02\x02", 10,
      "edelWebExperimentalTSAPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa9\x3d\x01\x02\x03", 10,
      "edelWebOpenEvidenceTSAPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xaa\x60", 7,
      "timeproof" },
    { (byte*)"\x2b\x06\x01\x04\x01\xaa\x60\x01", 8,
      "tss" },
    { (byte*)"\x2b\x06\x01\x04\x01\xaa\x60\x01\x01", 9,
      "tss80" },
    { (byte*)"\x2b\x06\x01\x04\x01\xaa\x60\x01\x02", 9,
      "tss380" },
    { (byte*)"\x2b\x06\x01\x04\x01\xaa\x60\x01\x03", 9,
      "tss400" },
    { (byte*)"\x2b\x06\x01\x04\x01\xad\x0a\x00\x03", 9,
      "secondaryPractices" },
    { (byte*)"\x2b\x06\x01\x04\x01\xad\x0a\x00\x04", 9,
      "physicianIdentifiers" },
    { (byte*)"\x2b\x06\x01\x04\x01\xb2\x31\x01\x02\x01\x03\x01", 12,
      "comodoPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xb2\x31\x01\x02\x02\x0f", 11,
      "wotrustPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xb2\x31\x01\x03\x05\x02", 11,
      "comodoCertifiedDeliveryService" },
    { (byte*)"\x2b\x06\x01\x04\x01\xb2\x31\x02\x01\x01", 10,
      "comodoTimestampingPolicy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xc0\x6d\x03\x05\x01", 10,
      "validityModelChain" },
    { (byte*)"\x2b\x06\x01\x04\x01\xc0\x6d\x03\x05\x02", 10,
      "validityModelShell" },
    { (byte*)"\x2b\x06\x01\x04\x01\xc0\x27\x01", 8,
      "rolUnicoNacional" },
    { (byte*)"\x2b\x06\x01\x04\x01\xd6\x79\x02\x04\x02", 10,
      "googleSignedCertificateTimestamp" },
    { (byte*)"\x2b\x06\x01\x04\x01\xd6\x79\x02\x04\x03", 10,
      "googlePrecertificatePoison" },
    { (byte*)"\x2b\x06\x01\x04\x01\xd6\x79\x02\x04\x04", 10,
      "googlePrecertificateCA" },
    { (byte*)"\x2b\x06\x01\x04\x01\xd6\x79\x02\x04\x05", 10,
      "googleOcspSignedCertificateTimestamp" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47", 7,
      "gnu" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x01", 8,
      "gnuRadius" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x02\x02\x01", 10,
      "gpgX509StandaloneCert" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x02\x02\x02", 10,
      "gpgX509WellKnownPrivateKey" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x02\x02\x0a", 10,
      "gpgX509PgpKdfKekParm" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x02\x03\x01", 10,
      "gpgCtPgpKeyblock" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x02\x04\x01\x01", 11,
      "gpgFingerprint" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x02\x04\x01\x02", 11,
      "gpgSubFingerprint" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x02\x04\x01\x03", 11,
      "gpgMailbox" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x02\x04\x01\x04", 11,
      "gpgSubCertID" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x02\x05\x01", 10,
      "gpgNtds" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x02\x06\x01", 10,
      "gpgX509PgpUseCert" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x02\x06\x02", 10,
      "gpgX509PgpUseSign" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x02\x06\x03", 10,
      "gpgX509PgpUseEncr" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x02\x06\x04", 10,
      "gpgX509PgpUseAuth" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x02\x85\xeb\xa0\x1d", 12,
      "gpgInvalidOid" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x03", 8,
      "gnuRadar" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x04\x0b", 9,
      "scrypt" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0c", 8,
      "gnuDigestAlgorithm" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0c\x02", 9,
      "tiger" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0d", 8,
      "gnuEncryptionAlgorithm" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0d\x02", 9,
      "serpent" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0d\x02\x01", 10,
      "serpent128_ECB" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0d\x02\x02", 10,
      "serpent128_CBC" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0d\x02\x03", 10,
      "serpent128_OFB" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0d\x02\x04", 10,
      "serpent128_CFB" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0d\x02\x15", 10,
      "serpent192_ECB" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0d\x02\x16", 10,
      "serpent192_CBC" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0d\x02\x17", 10,
      "serpent192_OFB" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0d\x02\x18", 10,
      "serpent192_CFB" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0d\x02\x29", 10,
      "serpent256_ECB" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0d\x02\x2a", 10,
      "serpent256_CBC" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0d\x02\x2b", 10,
      "serpent256_OFB" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0d\x02\x2c", 10,
      "serpent256_CFB" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0f\x01", 9,
      "curve25519" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0f\x02", 9,
      "curve448" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0f\x03", 9,
      "curve25519ph" },
    { (byte*)"\x2b\x06\x01\x04\x01\xda\x47\x0f\x04", 9,
      "curve448ph" },
    { (byte*)"\x2b\x06\x01\x04\x01\xff\x4e\x83\x7d\x01\x01", 11,
      "Northrop Grumman extKeyUsage?" },
    { (byte*)"\x2b\x06\x01\x04\x01\xff\x4e\x83\x7d\x02\x01", 11,
      "ngcClass1" },
    { (byte*)"\x2b\x06\x01\x04\x01\xff\x4e\x83\x7d\x02\x02", 11,
      "ngcClass2" },
    { (byte*)"\x2b\x06\x01\x04\x01\xff\x4e\x83\x7d\x02\x03", 11,
      "ngcClass3" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xb8\x4d\x01\x04\x02\x01\x01", 13,
      "safenetUsageLimit" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xb8\x4d\x01\x04\x02\x01\x02", 13,
      "safenetEndDate" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xb8\x4d\x01\x04\x02\x01\x03", 13,
      "safenetStartDate" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xb8\x4d\x01\x04\x02\x01\x04", 13,
      "safenetAdminCert" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xb8\x4d\x01\x04\x02\x02\x01", 13,
      "safenetKeyDigest" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xc3\x5e\x03", 9,
      "carillonSecurity" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xc3\x5e\x03\x01", 10,
      "carillonCommercialPKI" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xc3\x5e\x03\x02", 10,
      "carillonCommercialTSA" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xc3\x5e\x03\x03", 10,
      "carillonCommercialSCVP" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xc3\x5e\x03\x03\x01", 11,
      "carillonSCVPExtendedStatusInfo" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xc3\x5e\x03\x04", 10,
      "carillonCommercialCMS" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xc3\x5e\x03\x04\x01", 11,
      "carillonExtKeyUsageCIVCardAuth" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xc3\x5e\x03\x04\x02", 11,
      "carillonExtKeyUsageCIVContentSigning" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xc3\x5e\x03\x05", 10,
      "carillonCommercialLSAP" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xc3\x5e\x03\x05\x01", 11,
      "carillonExtKeyUsageLSAPCodeSigning" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xc3\x5e\x03\x06", 10,
      "carillonCommercialCE" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xc3\x5e\x03\x07", 10,
      "carillonCommercialLicense" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xc3\x5e\x03\x07\x01", 11,
      "carillonExtKeyUsageLicenseSigning" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xc3\x5e\x03\x08", 10,
      "carillonCommercialSecret" },
    { (byte*)"\x2b\x06\x01\x04\x01\x83\x92\x1b\x02\x01", 10,
      "hashOfRootKey" },
    { (byte*)"\x2b\x06\x01\x05\x02\x03\x01", 7,
      "authData" },
    { (byte*)"\x2b\x06\x01\x05\x02\x03\x02", 7,
      "dHKeyData" },
    { (byte*)"\x2b\x06\x01\x05\x02\x03\x03", 7,
      "rkeyData" },
    { (byte*)"\x2b\x06\x01\x05\x02\x03\x04", 7,
      "keyPurposeClientAuth" },
    { (byte*)"\x2b\x06\x01\x05\x02\x03\x05", 7,
      "keyPurposeKdc" },
    { (byte*)"\x2b\x06\x01\x05\x02\x03\x06", 7,
      "kdf" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07", 6,
      "pkix" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x00\x0c", 8,
      "attributeCert" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01", 7,
      "privateExtension" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x01", 8,
      "authorityInfoAccess" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x02", 8,
      "biometricInfo" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x03", 8,
      "qcStatements" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x04", 8,
      "acAuditIdentity" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x05", 8,
      "acTargeting" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x06", 8,
      "acAaControls" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x07", 8,
      "ipAddrBlocks" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x08", 8,
      "autonomousSysIds" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x09", 8,
      "routerIdentifier" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x0a", 8,
      "acProxying" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x0b", 8,
      "subjectInfoAccess" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x0c", 8,
      "logoType" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x0d", 8,
      "wlanSSID" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x0e", 8,
      "proxyCertInfo" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x0f", 8,
      "acPolicies" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x10", 8,
      "certificateWarranty" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x12", 8,
      "cmsContentConstraints" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x13", 8,
      "otherCerts" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x14", 8,
      "wrappedApexContinKey" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x15", 8,
      "clearanceConstraints" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x16", 8,
      "skiSemantics" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x17", 8,
      "noSecrecyAfforded" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x18", 8,
      "tlsFeature" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x19", 8,
      "manufacturerUsageDescription" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x1a", 8,
      "tnAuthList" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x1b", 8,
      "jwtClaimConstraints" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x1c", 8,
      "ipAddrBlocksV2" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x1d", 8,
      "autonomousSysIdsV2" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x1e", 8,
      "manufacturerUsageDescriptionSigner" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x1f", 8,
      "acmeIdentifier" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x20", 8,
      "masaURL" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x21", 8,
      "enhancedJWTClaimConstraints" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x01\x22", 8,
      "nfTypes" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x02", 7,
      "policyQualifierIds" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x02\x01", 8,
      "cps" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x02\x02", 8,
      "unotice" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x02\x03", 8,
      "textNotice" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x02\x04", 8,
      "acps" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x02\x05", 8,
      "acunotice" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03", 7,
      "keyPurpose" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x01", 8,
      "serverAuth" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x02", 8,
      "clientAuth" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x03", 8,
      "codeSigning" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x04", 8,
      "emailProtection" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x05", 8,
      "ipsecEndSystem" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x06", 8,
      "ipsecTunnel" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x07", 8,
      "ipsecUser" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x08", 8,
      "timeStamping" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x09", 8,
      "ocspSigning" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x0a", 8,
      "dvcs" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x0b", 8,
      "sbgpCertAAServerAuth" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x0c", 8,
      "scvpResponder" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x0d", 8,
      "eapOverPPP" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x0e", 8,
      "eapOverLAN" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x0f", 8,
      "scvpServer" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x10", 8,
      "scvpClient" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x11", 8,
      "ipsecIKE" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x12", 8,
      "capwapAC" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x13", 8,
      "capwapWTP" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x14", 8,
      "sipDomain" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x15", 8,
      "secureShellClient" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x16", 8,
      "secureShellServer" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x17", 8,
      "sendRouter" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x18", 8,
      "sendProxiedRouter" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x19", 8,
      "sendOwner" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x1a", 8,
      "sendProxiedOwner" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x1b", 8,
      "cmcCA" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x1c", 8,
      "cmcRA" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x1d", 8,
      "cmcArchive" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x1e", 8,
      "bgpsecRouter" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x1f", 8,
      "bimi" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x20", 8,
      "cmKGA" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x21", 8,
      "rpcTLSClient" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x22", 8,
      "rpcTLSServer" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x23", 8,
      "bundleSecurity" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x03\x24", 8,
      "documentSigning" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x04", 7,
      "cmpInformationTypes" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x04\x01", 8,
      "caProtEncCert" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x04\x02", 8,
      "signKeyPairTypes" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x04\x03", 8,
      "encKeyPairTypes" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x04\x04", 8,
      "preferredSymmAlg" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x04\x05", 8,
      "caKeyUpdateInfo" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x04\x06", 8,
      "currentCRL" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x04\x07", 8,
      "unsupportedOIDs" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x04\x0a", 8,
      "keyPairParamReq" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x04\x0b", 8,
      "keyPairParamRep" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x04\x0c", 8,
      "revPassphrase" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x04\x0d", 8,
      "implicitConfirm" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x04\x0e", 8,
      "confirmWaitTime" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x04\x0f", 8,
      "origPKIMessage" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x04\x10", 8,
      "suppLangTags" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x05", 7,
      "crmfRegistration" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x05\x01", 8,
      "regCtrl" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x05\x01\x01", 9,
      "regToken" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x05\x01\x02", 9,
      "authenticator" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x05\x01\x03", 9,
      "pkiPublicationInfo" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x05\x01\x04", 9,
      "pkiArchiveOptions" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x05\x01\x05", 9,
      "oldCertID" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x05\x01\x06", 9,
      "protocolEncrKey" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x05\x01\x07", 9,
      "altCertTemplate" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x05\x01\x08", 9,
      "wtlsTemplate" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x05\x02", 8,
      "utf8Pairs" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x05\x02\x01", 9,
      "utf8Pairs" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x05\x02\x02", 9,
      "certReq" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06", 7,
      "algorithms" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x01", 8,
      "des40" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x02", 8,
      "noSignature" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x03", 8,
      "dhSigHmacSha1" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x04", 8,
      "dhPop" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x05", 8,
      "dhPopSha224" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x06", 8,
      "dhPopSha256" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x07", 8,
      "dhPopSha384" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x08", 8,
      "dhPopSha512" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x0f", 8,
      "dhPopStaticSha224HmacSha224" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x10", 8,
      "dhPopStaticSha256HmacSha256" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x11", 8,
      "dhPopStaticSha384HmacSha384" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x12", 8,
      "dhPopStaticSha512HmacSha512" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x19", 8,
      "ecdhPopStaticSha224HmacSha224" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x1a", 8,
      "ecdhPopStaticSha256HmacSha256" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x1b", 8,
      "ecdhPopStaticSha384HmacSha384" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x1c", 8,
      "ecdhPopStaticSha512HmacSha512" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x1e", 8,
      "rsaPssShake128" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x1f", 8,
      "rsaPssShake256" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x20", 8,
      "ecdsaShake128" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x06\x21", 8,
      "ecdsaShake256" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x07", 7,
      "cmcControls" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x08", 7,
      "otherNames" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x08\x01", 8,
      "personalData" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x08\x02", 8,
      "userGroup" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x08\x03", 8,
      "permanentIdentifier" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x08\x05", 8,
      "xmppAddr" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x08\x06", 8,
      "SIM" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x08\x07", 8,
      "dnsSRV" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x08\x08", 8,
      "naiRealm" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x08\x09", 8,
      "smtpUTF8Mailbox" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x08\x0a", 8,
      "acpNodeName" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x08\x0b", 8,
      "bundleEID" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x09", 7,
      "personalData" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x09\x01", 8,
      "dateOfBirth" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x09\x02", 8,
      "placeOfBirth" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x09\x03", 8,
      "gender" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x09\x04", 8,
      "countryOfCitizenship" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x09\x05", 8,
      "countryOfResidence" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x0a", 7,
      "attributeCertificate" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x0a\x01", 8,
      "authenticationInfo" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x0a\x02", 8,
      "accessIdentity" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x0a\x03", 8,
      "chargingIdentity" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x0a\x04", 8,
      "group" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x0a\x05", 8,
      "role" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x0a\x06", 8,
      "wlanSSID" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x0b", 7,
      "personalData" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x0b\x01", 8,
      "pkixQCSyntax-v1" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x0b\x02", 8,
      "pkixQCSyntax-v2" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x0c", 7,
      "pkixCCT" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x0c\x02", 8,
      "pkiData" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x0c\x03", 8,
      "pkiResponse" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x0e\x02", 8,
      "resourceCertificatePolicy" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x11", 7,
      "scvpCheck" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x11\x01", 8,
      "scvpCheckBuildPath" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x11\x02", 8,
      "scvpCheckBuildValidPath" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x11\x03", 8,
      "scvpCheckBuildStatusCheckedPath" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x11\x04", 8,
      "scvpCheckBuildAaPath" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x11\x05", 8,
      "scvpCheckBuildValidAaPath" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x11\x06", 8,
      "scvpCheckBuildStatusCheckedAaPath" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x11\x07", 8,
      "scvpCheckStatusCheckAcAndBuildStatusCheckedAaPath" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x12", 7,
      "scvpWantBack" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x12\x01", 8,
      "scvpWantbackBestCertPath" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x12\x02", 8,
      "scvpWantbackRevocationInfo" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x12\x04", 8,
      "scvpWantbackPublicKeyInfo" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x12\x05", 8,
      "scvpWantbackAaCertPath" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x12\x06", 8,
      "scvpWantbackAaRevocationInfo" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x12\x07", 8,
      "scvpWantbackAcRevocationInfo" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x12\x09", 8,
      "scvpWantbackRelayedResponses" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x12\x0a", 8,
      "scvpWantbackCert" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x12\x0b", 8,
      "scvpWantbackAcCert" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x12\x0c", 8,
      "scvpWantbackAllCertPaths" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x12\x0d", 8,
      "scvpWantbackEeRevocationInfo" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x12\x0e", 8,
      "scvpWantbackCAsRevocationInfo" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13", 7,
      "scvpValPolicy" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x01", 8,
      "scvpDefaultValPolicy" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x02", 8,
      "scvpNameValAlg" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x02\x01", 9,
      "scvpNameErrorNameMismatch" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x02\x02", 9,
      "scvpNameErrorNoName" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x02\x03", 9,
      "scvpNameErrorUnknownAlg" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x02\x04", 9,
      "scvpNameErrorBadName" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x02\x05", 9,
      "scvpNameErrorBadNameType" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x02\x06", 9,
      "scvpNameErrorMixedNames" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x03", 8,
      "scvpBasicValAlg" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x03\x01", 9,
      "scvpValErrorExpired" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x03\x02", 9,
      "scvpValErrorNotYetValid" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x03\x03", 9,
      "scvpValErrorWrongTrustAnchor" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x03\x04", 9,
      "scvpValErrorNoValidCertPath" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x03\x05", 9,
      "scvpValErrorRevoked" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x03\x09", 9,
      "scvpValErrorInvalidKeyPurpose" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x03\x0a", 9,
      "scvpValErrorInvalidKeyUsage" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x13\x03\x0b", 9,
      "scvpValErrorInvalidCertPolicy" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x14", 7,
      "logo" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x14\x01", 8,
      "logoLoyalty" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x14\x02", 8,
      "logoBackground" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x30\x01", 8,
      "ocsp" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x30\x01\x01", 9,
      "ocspBasic" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x30\x01\x02", 9,
      "ocspNonce" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x30\x01\x03", 9,
      "ocspCRL" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x30\x01\x04", 9,
      "ocspResponse" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x30\x01\x05", 9,
      "ocspNoCheck" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x30\x01\x06", 9,
      "ocspArchiveCutoff" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x30\x01\x07", 9,
      "ocspServiceLocator" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x30\x02", 8,
      "caIssuers" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x30\x03", 8,
      "timeStamping" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x30\x04", 8,
      "dvcs" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x30\x05", 8,
      "caRepository" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x30\x07", 8,
      "signedObjectRepository" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x30\x0a", 8,
      "rpkiManifest" },
    { (byte*)"\x2b\x06\x01\x05\x05\x07\x30\x0b", 8,
      "signedObject" },
    { (byte*)"\x2b\x06\x01\x05\x05\x08\x01\x01", 8,
      "hmacMD5" },
    { (byte*)"\x2b\x06\x01\x05\x05\x08\x01\x02", 8,
      "hmacSHA" },
    { (byte*)"\x2b\x06\x01\x05\x05\x08\x01\x03", 8,
      "hmacTiger" },
    { (byte*)"\x2b\x06\x01\x05\x05\x08\x02\x02", 8,
      "iKEIntermediate" },
    { (byte*)"\x2b\x0c\x02\x87\x73\x07\x01", 7,
      "decEncryptionAlgorithm" },
    { (byte*)"\x2b\x0c\x02\x87\x73\x07\x01\x02", 8,
      "decDEA" },
    { (byte*)"\x2b\x0c\x02\x87\x73\x07\x02", 7,
      "decHashAlgorithm" },
    { (byte*)"\x2b\x0c\x02\x87\x73\x07\x02\x01", 8,
      "decMD2" },
    { (byte*)"\x2b\x0c\x02\x87\x73\x07\x02\x02", 8,
      "decMD4" },
    { (byte*)"\x2b\x0c\x02\x87\x73\x07\x03", 7,
      "decSignatureAlgorithm" },
    { (byte*)"\x2b\x0c\x02\x87\x73\x07\x03\x01", 8,
      "decMD2withRSA" },
    { (byte*)"\x2b\x0c\x02\x87\x73\x07\x03\x02", 8,
      "decMD4withRSA" },
    { (byte*)"\x2b\x0c\x02\x87\x73\x07\x03\x03", 8,
      "decDEAMAC" },
    { (byte*)"\x2b\x0e\x02\x1a\x05", 5,
      "sha" },
    { (byte*)"\x2b\x0e\x03\x02\x01\x01", 6,
      "rsa" },
    { (byte*)"\x2b\x0e\x03\x02\x02", 5,
      "md4WitRSA" },
    { (byte*)"\x2b\x0e\x03\x02\x03", 5,
      "md5WithRSA" },
    { (byte*)"\x2b\x0e\x03\x02\x04", 5,
      "md4WithRSAEncryption" },
    { (byte*)"\x2b\x0e\x03\x02\x02\x01", 6,
      "sqmod-N" },
    { (byte*)"\x2b\x0e\x03\x02\x03\x01", 6,
      "sqmod-NwithRSA" },
    { (byte*)"\x2b\x0e\x03\x02\x06", 5,
      "desECB" },
    { (byte*)"\x2b\x0e\x03\x02\x07", 5,
      "desCBC" },
    { (byte*)"\x2b\x0e\x03\x02\x08", 5,
      "desOFB" },
    { (byte*)"\x2b\x0e\x03\x02\x09", 5,
      "desCFB" },
    { (byte*)"\x2b\x0e\x03\x02\x0a", 5,
      "desMAC" },
    { (byte*)"\x2b\x0e\x03\x02\x0b", 5,
      "rsaSignature" },
    { (byte*)"\x2b\x0e\x03\x02\x0c", 5,
      "dsa" },
    { (byte*)"\x2b\x0e\x03\x02\x0d", 5,
      "dsaWithSHA" },
    { (byte*)"\x2b\x0e\x03\x02\x0e", 5,
      "mdc2WithRSASignature" },
    { (byte*)"\x2b\x0e\x03\x02\x0f", 5,
      "shaWithRSASignature" },
    { (byte*)"\x2b\x0e\x03\x02\x10", 5,
      "dhWithCommonModulus" },
    { (byte*)"\x2b\x0e\x03\x02\x11", 5,
      "desEDE" },
    { (byte*)"\x2b\x0e\x03\x02\x12", 5,
      "sha" },
    { (byte*)"\x2b\x0e\x03\x02\x13", 5,
      "mdc-2" },
    { (byte*)"\x2b\x0e\x03\x02\x14", 5,
      "dsaCommon" },
    { (byte*)"\x2b\x0e\x03\x02\x15", 5,
      "dsaCommonWithSHA" },
    { (byte*)"\x2b\x0e\x03\x02\x16", 5,
      "rsaKeyTransport" },
    { (byte*)"\x2b\x0e\x03\x02\x17", 5,
      "keyed-hash-seal" },
    { (byte*)"\x2b\x0e\x03\x02\x18", 5,
      "md2WithRSASignature" },
    { (byte*)"\x2b\x0e\x03\x02\x19", 5,
      "md5WithRSASignature" },
    { (byte*)"\x2b\x0e\x03\x02\x1a", 5,
      "sha1" },
    { (byte*)"\x2b\x0e\x03\x02\x1b", 5,
      "dsaWithSHA1" },
    { (byte*)"\x2b\x0e\x03\x02\x1c", 5,
      "dsaWithCommonSHA1" },
    { (byte*)"\x2b\x0e\x03\x02\x1d", 5,
      "sha-1WithRSAEncryption" },
    { (byte*)"\x2b\x0e\x03\x03\x01", 5,
      "simple-strong-auth-mechanism" },
    { (byte*)"\x2b\x0e\x07\x02\x01\x01", 6,
      "ElGamal" },
    { (byte*)"\x2b\x0e\x07\x02\x03\x01", 6,
      "md2WithRSA" },
    { (byte*)"\x2b\x0e\x07\x02\x03\x02", 6,
      "md2WithElGamal" },
    { (byte*)"\x2b\x12\x00\x02\x12\x01", 6,
      "hostIDMapping" },
    { (byte*)"\x2b\x1b\x10", 3,
      "icaoSecurity" },
    { (byte*)"\x2b\x1b\x10\x00", 4,
      "icaoSecurity" },
    { (byte*)"\x2b\x1b\x10\x00\x01\x01\x01\x01\x01\x01\x00", 11,
      "icaoTestValidationPolicy" },
    { (byte*)"\x2b\x1b\x10\x01", 4,
      "icaoCertPolicy" },
    { (byte*)"\x2b\x1b\x10\x01\x02", 5,
      "icaoIATFRootCA" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x00\x01", 7,
      "icaoIdentityAssurance" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x00\x01\x01", 8,
      "icaoIdentityAssuranceLow" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x00\x01\x02", 8,
      "icaoIdentityAssuranceLowDevice" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x00\x01\x03", 8,
      "icaoIdentityAssuranceLowTSPMediated" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x00\x01\x04", 8,
      "icaoIdentityAssuranceMedium" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x00\x01\x05", 8,
      "icaoIdentityAssuranceMediumDevice" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x00\x01\x06", 8,
      "icaoIdentityAssuranceMediumTSPMediated" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x00\x01\x07", 8,
      "icaoIdentityAssuranceMediumHardware" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x00\x01\x08", 8,
      "icaoIdentityAssuranceMediumDeviceHardware" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x00\x01\x09", 8,
      "icaoIdentityAssuranceHigh" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x00\x01\x0a", 8,
      "icaoIdentityAssuranceHighCardAuth" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x00\x01\x0b", 8,
      "icaoIdentityAssuranceHighContentSigning" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x01", 6,
      "icaoIATFBridgeCA" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x01\x00", 7,
      "icaoCAODRootCA" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x01\x01", 7,
      "icaoCAODBridgeCA" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x01\x01\x01", 8,
      "icaoUSBridgeCA" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x01\x01\x01\x01", 9,
      "icaoFAARootCA" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x01\x01\x01\x01\x01", 10,
      "icaoFAAIssuingCA" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x01\x01\x01\x01\x01\x01", 11,
      "icaoFAAClientCertificate" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x01\x01\x01\x01\x01\x02", 11,
      "icaoFAAServerCertificate" },
    { (byte*)"\x2b\x1b\x10\x01\x02\x01\x01\x01\x01\x01\x03", 11,
      "icaoFAASWIMSigningCertificate" },
    { (byte*)"\x2b\x1b\x10\x01\x04\x01\x01", 7,
      "icaoSWIMSigning" },
    { (byte*)"\x2b\x24\x01", 3,
      "document" },
    { (byte*)"\x2b\x24\x01\x01", 4,
      "finalVersion" },
    { (byte*)"\x2b\x24\x01\x02", 4,
      "draft" },
    { (byte*)"\x2b\x24\x02", 3,
      "sio" },
    { (byte*)"\x2b\x24\x02\x01", 4,
      "sedu" },
    { (byte*)"\x2b\x24\x03", 3,
      "algorithm" },
    { (byte*)"\x2b\x24\x03\x01", 4,
      "encryptionAlgorithm" },
    { (byte*)"\x2b\x24\x03\x01\x01", 5,
      "des" },
    { (byte*)"\x2b\x24\x03\x01\x01\x01", 6,
      "desECB_pad" },
    { (byte*)"\x2b\x24\x03\x01\x01\x01\x01", 7,
      "desECB_ISOpad" },
    { (byte*)"\x2b\x24\x03\x01\x01\x02\x01", 7,
      "desCBC_pad" },
    { (byte*)"\x2b\x24\x03\x01\x01\x02\x01\x01", 8,
      "desCBC_ISOpad" },
    { (byte*)"\x2b\x24\x03\x01\x03", 5,
      "des_3" },
    { (byte*)"\x2b\x24\x03\x01\x03\x01\x01", 7,
      "des_3ECB_pad" },
    { (byte*)"\x2b\x24\x03\x01\x03\x01\x01\x01", 8,
      "des_3ECB_ISOpad" },
    { (byte*)"\x2b\x24\x03\x01\x03\x02\x01", 7,
      "des_3CBC_pad" },
    { (byte*)"\x2b\x24\x03\x01\x03\x02\x01\x01", 8,
      "des_3CBC_ISOpad" },
    { (byte*)"\x2b\x24\x03\x01\x02", 5,
      "idea" },
    { (byte*)"\x2b\x24\x03\x01\x02\x01", 6,
      "ideaECB" },
    { (byte*)"\x2b\x24\x03\x01\x02\x01\x01", 7,
      "ideaECB_pad" },
    { (byte*)"\x2b\x24\x03\x01\x02\x01\x01\x01", 8,
      "ideaECB_ISOpad" },
    { (byte*)"\x2b\x24\x03\x01\x02\x02", 6,
      "ideaCBC" },
    { (byte*)"\x2b\x24\x03\x01\x02\x02\x01", 7,
      "ideaCBC_pad" },
    { (byte*)"\x2b\x24\x03\x01\x02\x02\x01\x01", 8,
      "ideaCBC_ISOpad" },
    { (byte*)"\x2b\x24\x03\x01\x02\x03", 6,
      "ideaOFB" },
    { (byte*)"\x2b\x24\x03\x01\x02\x04", 6,
      "ideaCFB" },
    { (byte*)"\x2b\x24\x03\x01\x04", 5,
      "rsaEncryption" },
    { (byte*)"\x2b\x24\x03\x01\x04\x84\x00\x11", 8,
      "rsaEncryptionWithlmod512expe17" },
    { (byte*)"\x2b\x24\x03\x01\x05", 5,
      "bsi-1" },
    { (byte*)"\x2b\x24\x03\x01\x05\x01", 6,
      "bsi_1ECB_pad" },
    { (byte*)"\x2b\x24\x03\x01\x05\x02", 6,
      "bsi_1CBC_pad" },
    { (byte*)"\x2b\x24\x03\x01\x05\x02\x01", 7,
      "bsi_1CBC_PEMpad" },
    { (byte*)"\x2b\x24\x03\x02", 4,
      "hashAlgorithm" },
    { (byte*)"\x2b\x24\x03\x02\x01", 5,
      "ripemd160" },
    { (byte*)"\x2b\x24\x03\x02\x02", 5,
      "ripemd128" },
    { (byte*)"\x2b\x24\x03\x02\x03", 5,
      "ripemd256" },
    { (byte*)"\x2b\x24\x03\x02\x04", 5,
      "mdc2singleLength" },
    { (byte*)"\x2b\x24\x03\x02\x05", 5,
      "mdc2doubleLength" },
    { (byte*)"\x2b\x24\x03\x03", 4,
      "signatureAlgorithm" },
    { (byte*)"\x2b\x24\x03\x03\x01", 5,
      "rsaSignature" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01", 6,
      "rsaSignatureWithsha1" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x84\x00\x02", 9,
      "rsaSignatureWithsha1_l512_l2" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x85\x00\x02", 9,
      "rsaSignatureWithsha1_l640_l2" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x86\x00\x02", 9,
      "rsaSignatureWithsha1_l768_l2" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x87\x00\x02", 9,
      "rsaSignatureWithsha1_l896_l2" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x88\x00\x02", 9,
      "rsaSignatureWithsha1_l1024_l2" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x84\x00\x03", 9,
      "rsaSignatureWithsha1_l512_l3" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x85\x00\x03", 9,
      "rsaSignatureWithsha1_l640_l3" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x86\x00\x03", 9,
      "rsaSignatureWithsha1_l768_l3" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x87\x00\x03", 9,
      "rsaSignatureWithsha1_l896_l3" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x88\x00\x03", 9,
      "rsaSignatureWithsha1_l1024_l3" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x84\x00\x05", 9,
      "rsaSignatureWithsha1_l512_l5" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x85\x00\x05", 9,
      "rsaSignatureWithsha1_l640_l5" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x86\x00\x05", 9,
      "rsaSignatureWithsha1_l768_l5" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x87\x00\x05", 9,
      "rsaSignatureWithsha1_l896_l5" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x88\x00\x05", 9,
      "rsaSignatureWithsha1_l1024_l5" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x84\x00\x09", 9,
      "rsaSignatureWithsha1_l512_l9" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x85\x00\x09", 9,
      "rsaSignatureWithsha1_l640_l9" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x86\x00\x09", 9,
      "rsaSignatureWithsha1_l768_l9" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x87\x00\x09", 9,
      "rsaSignatureWithsha1_l896_l9" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x88\x00\x09", 9,
      "rsaSignatureWithsha1_l1024_l9" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x84\x00\x0b", 9,
      "rsaSignatureWithsha1_l512_l11" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x85\x00\x0b", 9,
      "rsaSignatureWithsha1_l640_l11" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x86\x00\x0b", 9,
      "rsaSignatureWithsha1_l768_l11" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x87\x00\x0b", 9,
      "rsaSignatureWithsha1_l896_l11" },
    { (byte*)"\x2b\x24\x03\x03\x01\x01\x88\x00\x0b", 9,
      "rsaSignatureWithsha1_l1024_l11" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02", 6,
      "rsaSignatureWithripemd160" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x84\x00\x02", 9,
      "rsaSignatureWithripemd160_l512_l2" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x85\x00\x02", 9,
      "rsaSignatureWithripemd160_l640_l2" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x86\x00\x02", 9,
      "rsaSignatureWithripemd160_l768_l2" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x87\x00\x02", 9,
      "rsaSignatureWithripemd160_l896_l2" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x88\x00\x02", 9,
      "rsaSignatureWithripemd160_l1024_l2" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x84\x00\x03", 9,
      "rsaSignatureWithripemd160_l512_l3" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x85\x00\x03", 9,
      "rsaSignatureWithripemd160_l640_l3" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x86\x00\x03", 9,
      "rsaSignatureWithripemd160_l768_l3" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x87\x00\x03", 9,
      "rsaSignatureWithripemd160_l896_l3" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x88\x00\x03", 9,
      "rsaSignatureWithripemd160_l1024_l3" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x84\x00\x05", 9,
      "rsaSignatureWithripemd160_l512_l5" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x85\x00\x05", 9,
      "rsaSignatureWithripemd160_l640_l5" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x86\x00\x05", 9,
      "rsaSignatureWithripemd160_l768_l5" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x87\x00\x05", 9,
      "rsaSignatureWithripemd160_l896_l5" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x88\x00\x05", 9,
      "rsaSignatureWithripemd160_l1024_l5" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x84\x00\x09", 9,
      "rsaSignatureWithripemd160_l512_l9" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x85\x00\x09", 9,
      "rsaSignatureWithripemd160_l640_l9" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x86\x00\x09", 9,
      "rsaSignatureWithripemd160_l768_l9" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x87\x00\x09", 9,
      "rsaSignatureWithripemd160_l896_l9" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x88\x00\x09", 9,
      "rsaSignatureWithripemd160_l1024_l9" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x84\x00\x0b", 9,
      "rsaSignatureWithripemd160_l512_l11" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x85\x00\x0b", 9,
      "rsaSignatureWithripemd160_l640_l11" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x86\x00\x0b", 9,
      "rsaSignatureWithripemd160_l768_l11" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x87\x00\x0b", 9,
      "rsaSignatureWithripemd160_l896_l11" },
    { (byte*)"\x2b\x24\x03\x03\x01\x02\x88\x00\x0b", 9,
      "rsaSignatureWithripemd160_l1024_l11" },
    { (byte*)"\x2b\x24\x03\x03\x01\x03", 6,
      "rsaSignatureWithrimpemd128" },
    { (byte*)"\x2b\x24\x03\x03\x01\x04", 6,
      "rsaSignatureWithrimpemd256" },
    { (byte*)"\x2b\x24\x03\x03\x02", 5,
      "ecsieSign" },
    { (byte*)"\x2b\x24\x03\x03\x02\x01", 6,
      "ecsieSignWithsha1" },
    { (byte*)"\x2b\x24\x03\x03\x02\x02", 6,
      "ecsieSignWithripemd160" },
    { (byte*)"\x2b\x24\x03\x03\x02\x03", 6,
      "ecsieSignWithmd2" },
    { (byte*)"\x2b\x24\x03\x03\x02\x04", 6,
      "ecsieSignWithmd5" },
    { (byte*)"\x2b\x24\x03\x03\x02\x08\x01\x01\x01", 9,
      "brainpoolP160r1" },
    { (byte*)"\x2b\x24\x03\x03\x02\x08\x01\x01\x02", 9,
      "brainpoolP160t1" },
    { (byte*)"\x2b\x24\x03\x03\x02\x08\x01\x01\x03", 9,
      "brainpoolP192r1" },
    { (byte*)"\x2b\x24\x03\x03\x02\x08\x01\x01\x04", 9,
      "brainpoolP192t1" },
    { (byte*)"\x2b\x24\x03\x03\x02\x08\x01\x01\x05", 9,
      "brainpoolP224r1" },
    { (byte*)"\x2b\x24\x03\x03\x02\x08\x01\x01\x06", 9,
      "brainpoolP224t1" },
    { (byte*)"\x2b\x24\x03\x03\x02\x08\x01\x01\x07", 9,
      "brainpoolP256r1" },
    { (byte*)"\x2b\x24\x03\x03\x02\x08\x01\x01\x08", 9,
      "brainpoolP256t1" },
    { (byte*)"\x2b\x24\x03\x03\x02\x08\x01\x01\x09", 9,
      "brainpoolP320r1" },
    { (byte*)"\x2b\x24\x03\x03\x02\x08\x01\x01\x0a", 9,
      "brainpoolP320t1" },
    { (byte*)"\x2b\x24\x03\x03\x02\x08\x01\x01\x0b", 9,
      "brainpoolP384r1" },
    { (byte*)"\x2b\x24\x03\x03\x02\x08\x01\x01\x0c", 9,
      "brainpoolP384t1" },
    { (byte*)"\x2b\x24\x03\x03\x02\x08\x01\x01\x0d", 9,
      "brainpoolP512r1" },
    { (byte*)"\x2b\x24\x03\x03\x02\x08\x01\x01\x0e", 9,
      "brainpoolP512t1" },
    { (byte*)"\x2b\x24\x03\x04", 4,
      "signatureScheme" },
    { (byte*)"\x2b\x24\x03\x04\x01", 5,
      "sigS_ISO9796-1" },
    { (byte*)"\x2b\x24\x03\x04\x02", 5,
      "sigS_ISO9796-2" },
    { (byte*)"\x2b\x24\x03\x04\x02\x01", 6,
      "sigS_ISO9796-2Withred" },
    { (byte*)"\x2b\x24\x03\x04\x02\x02", 6,
      "sigS_ISO9796-2Withrsa" },
    { (byte*)"\x2b\x24\x03\x04\x02\x03", 6,
      "sigS_ISO9796-2Withrnd" },
    { (byte*)"\x2b\x24\x04", 3,
      "attribute" },
    { (byte*)"\x2b\x24\x05", 3,
      "policy" },
    { (byte*)"\x2b\x24\x06", 3,
      "api" },
    { (byte*)"\x2b\x24\x06\x01", 4,
      "manufacturer-specific_api" },
    { (byte*)"\x2b\x24\x06\x01\x01", 5,
      "utimaco-api" },
    { (byte*)"\x2b\x24\x06\x02", 4,
      "functionality-specific_api" },
    { (byte*)"\x2b\x24\x07", 3,
      "keymgmnt" },
    { (byte*)"\x2b\x24\x07\x01", 4,
      "keyagree" },
    { (byte*)"\x2b\x24\x07\x01\x01", 5,
      "bsiPKE" },
    { (byte*)"\x2b\x24\x07\x02", 4,
      "keytrans" },
    { (byte*)"\x2b\x24\x07\x02\x01", 5,
      "encISO9796-2Withrsa" },
    { (byte*)"\x2b\x24\x08\x01\x01", 5,
      "Teletrust SigGConform policyIdentifier" },
    { (byte*)"\x2b\x24\x08\x02\x01", 5,
      "directoryService" },
    { (byte*)"\x2b\x24\x08\x03\x01", 5,
      "dateOfCertGen" },
    { (byte*)"\x2b\x24\x08\x03\x02", 5,
      "procuration" },
    { (byte*)"\x2b\x24\x08\x03\x03", 5,
      "admission" },
    { (byte*)"\x2b\x24\x08\x03\x04", 5,
      "monetaryLimit" },
    { (byte*)"\x2b\x24\x08\x03\x05", 5,
      "declarationOfMajority" },
    { (byte*)"\x2b\x24\x08\x03\x06", 5,
      "integratedCircuitCardSerialNumber" },
    { (byte*)"\x2b\x24\x08\x03\x07", 5,
      "pKReference" },
    { (byte*)"\x2b\x24\x08\x03\x08", 5,
      "restriction" },
    { (byte*)"\x2b\x24\x08\x03\x09", 5,
      "retrieveIfAllowed" },
    { (byte*)"\x2b\x24\x08\x03\x0a", 5,
      "requestedCertificate" },
    { (byte*)"\x2b\x24\x08\x03\x0b", 5,
      "namingAuthorities" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01", 6,
      "rechtWirtschaftSteuern" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x01", 7,
      "rechtsanwaeltin" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x02", 7,
      "rechtsanwalt" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x03", 7,
      "rechtsBeistand" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x04", 7,
      "steuerBeraterin" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x05", 7,
      "steuerBerater" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x06", 7,
      "steuerBevollmaechtigte" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x07", 7,
      "steuerBevollmaechtigter" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x08", 7,
      "notarin" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x09", 7,
      "notar" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x0a", 7,
      "notarVertreterin" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x0b", 7,
      "notarVertreter" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x0c", 7,
      "notariatsVerwalterin" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x0d", 7,
      "notariatsVerwalter" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x0e", 7,
      "wirtschaftsPrueferin" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x0f", 7,
      "wirtschaftsPruefer" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x10", 7,
      "vereidigteBuchprueferin" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x11", 7,
      "vereidigterBuchpruefer" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x12", 7,
      "patentAnwaeltin" },
    { (byte*)"\x2b\x24\x08\x03\x0b\x01\x13", 7,
      "patentAnwalt" },
    { (byte*)"\x2b\x24\x08\x03\x0c", 5,
      "certInDirSince" },
    { (byte*)"\x2b\x24\x08\x03\x0d", 5,
      "certHash" },
    { (byte*)"\x2b\x24\x08\x03\x0e", 5,
      "nameAtBirth" },
    { (byte*)"\x2b\x24\x08\x03\x0f", 5,
      "additionalInformation" },
    { (byte*)"\x2b\x24\x08\x04\x01", 5,
      "personalData" },
    { (byte*)"\x2b\x24\x08\x04\x08", 5,
      "restriction" },
    { (byte*)"\x2b\x24\x08\x05\x01\x01\x01", 7,
      "rsaIndicateSHA1" },
    { (byte*)"\x2b\x24\x08\x05\x01\x01\x02", 7,
      "rsaIndicateRIPEMD160" },
    { (byte*)"\x2b\x24\x08\x05\x01\x01\x03", 7,
      "rsaWithSHA1" },
    { (byte*)"\x2b\x24\x08\x05\x01\x01\x04", 7,
      "rsaWithRIPEMD160" },
    { (byte*)"\x2b\x24\x08\x05\x01\x02\x01", 7,
      "dsaExtended" },
    { (byte*)"\x2b\x24\x08\x05\x01\x02\x02", 7,
      "dsaWithRIPEMD160" },
    { (byte*)"\x2b\x24\x08\x06\x01", 5,
      "cert" },
    { (byte*)"\x2b\x24\x08\x06\x02", 5,
      "certRef" },
    { (byte*)"\x2b\x24\x08\x06\x03", 5,
      "attrCert" },
    { (byte*)"\x2b\x24\x08\x06\x04", 5,
      "attrRef" },
    { (byte*)"\x2b\x24\x08\x06\x05", 5,
      "fileName" },
    { (byte*)"\x2b\x24\x08\x06\x06", 5,
      "storageTime" },
    { (byte*)"\x2b\x24\x08\x06\x07", 5,
      "fileSize" },
    { (byte*)"\x2b\x24\x08\x06\x08", 5,
      "location" },
    { (byte*)"\x2b\x24\x08\x06\x09", 5,
      "sigNumber" },
    { (byte*)"\x2b\x24\x08\x06\x0a", 5,
      "autoGen" },
    { (byte*)"\x2b\x24\x08\x07\x01\x01", 6,
      "ptAdobeILL" },
    { (byte*)"\x2b\x24\x08\x07\x01\x02", 6,
      "ptAmiPro" },
    { (byte*)"\x2b\x24\x08\x07\x01\x03", 6,
      "ptAutoCAD" },
    { (byte*)"\x2b\x24\x08\x07\x01\x04", 6,
      "ptBinary" },
    { (byte*)"\x2b\x24\x08\x07\x01\x05", 6,
      "ptBMP" },
    { (byte*)"\x2b\x24\x08\x07\x01\x06", 6,
      "ptCGM" },
    { (byte*)"\x2b\x24\x08\x07\x01\x07", 6,
      "ptCorelCRT" },
    { (byte*)"\x2b\x24\x08\x07\x01\x08", 6,
      "ptCorelDRW" },
    { (byte*)"\x2b\x24\x08\x07\x01\x09", 6,
      "ptCorelEXC" },
    { (byte*)"\x2b\x24\x08\x07\x01\x0a", 6,
      "ptCorelPHT" },
    { (byte*)"\x2b\x24\x08\x07\x01\x0b", 6,
      "ptDraw" },
    { (byte*)"\x2b\x24\x08\x07\x01\x0c", 6,
      "ptDVI" },
    { (byte*)"\x2b\x24\x08\x07\x01\x0d", 6,
      "ptEPS" },
    { (byte*)"\x2b\x24\x08\x07\x01\x0e", 6,
      "ptExcel" },
    { (byte*)"\x2b\x24\x08\x07\x01\x0f", 6,
      "ptGEM" },
    { (byte*)"\x2b\x24\x08\x07\x01\x10", 6,
      "ptGIF" },
    { (byte*)"\x2b\x24\x08\x07\x01\x11", 6,
      "ptHPGL" },
    { (byte*)"\x2b\x24\x08\x07\x01\x12", 6,
      "ptJPEG" },
    { (byte*)"\x2b\x24\x08\x07\x01\x13", 6,
      "ptKodak" },
    { (byte*)"\x2b\x24\x08\x07\x01\x14", 6,
      "ptLaTeX" },
    { (byte*)"\x2b\x24\x08\x07\x01\x15", 6,
      "ptLotus" },
    { (byte*)"\x2b\x24\x08\x07\x01\x16", 6,
      "ptLotusPIC" },
    { (byte*)"\x2b\x24\x08\x07\x01\x17", 6,
      "ptMacPICT" },
    { (byte*)"\x2b\x24\x08\x07\x01\x18", 6,
      "ptMacWord" },
    { (byte*)"\x2b\x24\x08\x07\x01\x19", 6,
      "ptMSWfD" },
    { (byte*)"\x2b\x24\x08\x07\x01\x1a", 6,
      "ptMSWord" },
    { (byte*)"\x2b\x24\x08\x07\x01\x1b", 6,
      "ptMSWord2" },
    { (byte*)"\x2b\x24\x08\x07\x01\x1c", 6,
      "ptMSWord6" },
    { (byte*)"\x2b\x24\x08\x07\x01\x1d", 6,
      "ptMSWord8" },
    { (byte*)"\x2b\x24\x08\x07\x01\x1e", 6,
      "ptPDF" },
    { (byte*)"\x2b\x24\x08\x07\x01\x1f", 6,
      "ptPIF" },
    { (byte*)"\x2b\x24\x08\x07\x01\x20", 6,
      "ptPostscript" },
    { (byte*)"\x2b\x24\x08\x07\x01\x21", 6,
      "ptRTF" },
    { (byte*)"\x2b\x24\x08\x07\x01\x22", 6,
      "ptSCITEX" },
    { (byte*)"\x2b\x24\x08\x07\x01\x23", 6,
      "ptTAR" },
    { (byte*)"\x2b\x24\x08\x07\x01\x24", 6,
      "ptTarga" },
    { (byte*)"\x2b\x24\x08\x07\x01\x25", 6,
      "ptTeX" },
    { (byte*)"\x2b\x24\x08\x07\x01\x26", 6,
      "ptText" },
    { (byte*)"\x2b\x24\x08\x07\x01\x27", 6,
      "ptTIFF" },
    { (byte*)"\x2b\x24\x08\x07\x01\x28", 6,
      "ptTIFF-FC" },
    { (byte*)"\x2b\x24\x08\x07\x01\x29", 6,
      "ptUID" },
    { (byte*)"\x2b\x24\x08\x07\x01\x2a", 6,
      "ptUUEncode" },
    { (byte*)"\x2b\x24\x08\x07\x01\x2b", 6,
      "ptWMF" },
    { (byte*)"\x2b\x24\x08\x07\x01\x2c", 6,
      "ptWordPerfect" },
    { (byte*)"\x2b\x24\x08\x07\x01\x2d", 6,
      "ptWPGrph" },
    { (byte*)"\x2b\x65\x01\x04", 4,
      "thawte-ce" },
    { (byte*)"\x2b\x65\x01\x04\x01", 5,
      "strongExtranet" },
    { (byte*)"\x2b\x65\x6e", 3,
      "curveX25519" },
    { (byte*)"\x2b\x65\x6f", 3,
      "curveX448" },
    { (byte*)"\x2b\x65\x70", 3,
      "curveEd25519" },
    { (byte*)"\x2b\x65\x71", 3,
      "curveEd448" },
    { (byte*)"\x2b\x65\x72", 3,
      "curveEd25519ph" },
    { (byte*)"\x2b\x65\x73", 3,
      "curveEd448ph" },
    { (byte*)"\x2b\x81\x04\x00\x01", 5,
      "sect163k1" },
    { (byte*)"\x2b\x81\x04\x00\x02", 5,
      "sect163r1" },
    { (byte*)"\x2b\x81\x04\x00\x03", 5,
      "sect239k1" },
    { (byte*)"\x2b\x81\x04\x00\x04", 5,
      "sect113r1" },
    { (byte*)"\x2b\x81\x04\x00\x05", 5,
      "sect113r2" },
    { (byte*)"\x2b\x81\x04\x00\x06", 5,
      "secp112r1" },
    { (byte*)"\x2b\x81\x04\x00\x07", 5,
      "secp112r2" },
    { (byte*)"\x2b\x81\x04\x00\x08", 5,
      "secp160r1" },
    { (byte*)"\x2b\x81\x04\x00\x09", 5,
      "secp160k1" },
    { (byte*)"\x2b\x81\x04\x00\x0a", 5,
      "secp256k1" },
    { (byte*)"\x2b\x81\x04\x00\x0f", 5,
      "sect163r2" },
    { (byte*)"\x2b\x81\x04\x00\x10", 5,
      "sect283k1" },
    { (byte*)"\x2b\x81\x04\x00\x11", 5,
      "sect283r1" },
    { (byte*)"\x2b\x81\x04\x00\x16", 5,
      "sect131r1" },
    { (byte*)"\x2b\x81\x04\x00\x17", 5,
      "sect131r2" },
    { (byte*)"\x2b\x81\x04\x00\x18", 5,
      "sect193r1" },
    { (byte*)"\x2b\x81\x04\x00\x19", 5,
      "sect193r2" },
    { (byte*)"\x2b\x81\x04\x00\x1a", 5,
      "sect233k1" },
    { (byte*)"\x2b\x81\x04\x00\x1b", 5,
      "sect233r1" },
    { (byte*)"\x2b\x81\x04\x00\x1c", 5,
      "secp128r1" },
    { (byte*)"\x2b\x81\x04\x00\x1d", 5,
      "secp128r2" },
    { (byte*)"\x2b\x81\x04\x00\x1e", 5,
      "secp160r2" },
    { (byte*)"\x2b\x81\x04\x00\x1f", 5,
      "secp192k1" },
    { (byte*)"\x2b\x81\x04\x00\x20", 5,
      "secp224k1" },
    { (byte*)"\x2b\x81\x04\x00\x21", 5,
      "secp224r1" },
    { (byte*)"\x2b\x81\x04\x00\x22", 5,
      "secp384r1" },
    { (byte*)"\x2b\x81\x04\x00\x23", 5,
      "secp521r1" },
    { (byte*)"\x2b\x81\x04\x00\x24", 5,
      "sect409k1" },
    { (byte*)"\x2b\x81\x04\x00\x25", 5,
      "sect409r1" },
    { (byte*)"\x2b\x81\x04\x00\x26", 5,
      "sect571k1" },
    { (byte*)"\x2b\x81\x04\x00\x27", 5,
      "sect571r1" },
    { (byte*)"\x2b\x81\x04\x01\x0b\x00", 6,
      "ecdhX963KDF-SHA224" },
    { (byte*)"\x2b\x81\x04\x01\x0b\x01", 6,
      "ecdhX963KDF-SHA256" },
    { (byte*)"\x2b\x81\x04\x01\x0b\x02", 6,
      "ecdhX963KDF-SHA384" },
    { (byte*)"\x2b\x81\x04\x01\x0b\x03", 6,
      "ecdhX963KDF-SHA512" },
    { (byte*)"\x2b\x81\x04\x01\x0e\x00", 6,
      "eccofactordhX963KDF-SHA224" },
    { (byte*)"\x2b\x81\x04\x01\x0e\x01", 6,
      "eccofactordhX963KDF-SHA256" },
    { (byte*)"\x2b\x81\x04\x01\x0e\x02", 6,
      "eccofactordhX963KDF-SHA384" },
    { (byte*)"\x2b\x81\x04\x01\x0e\x03", 6,
      "eccofactordhX963KDF-SHA512" },
    { (byte*)"\x2b\x81\x04\x01\x0f\x00", 6,
      "ecmqv-X963KDF-SHA224" },
    { (byte*)"\x2b\x81\x04\x01\x0f\x01", 6,
      "ecmqv-X963KDF-SHA256" },
    { (byte*)"\x2b\x81\x04\x01\x0f\x02", 6,
      "ecmqv-X963KDF-SHA384" },
    { (byte*)"\x2b\x81\x04\x01\x0f\x03", 6,
      "ecmqv-X963KDF-SHA512" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x2c", 8,
      "x944" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x2c\x01", 9,
      "x944Components" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x2c\x01\x01", 10,
      "x944Kdf2" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x2c\x01\x02", 10,
      "x944Kdf3" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54", 8,
      "x984" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x00", 9,
      "x984Module" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x00\x01", 10,
      "x984Biometrics" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x00\x02", 10,
      "x984CMS" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x00\x03", 10,
      "x984Identifiers" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01", 9,
      "x984Biometric" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x00", 10,
      "biometricUnknownType" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x01", 10,
      "biometricBodyOdor" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x02", 10,
      "biometricDNA" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x03", 10,
      "biometricEarShape" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x04", 10,
      "biometricFacialFeatures" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x05", 10,
      "biometricFingerImage" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x06", 10,
      "biometricFingerGeometry" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x07", 10,
      "biometricHandGeometry" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x08", 10,
      "biometricIrisFeatures" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x09", 10,
      "biometricKeystrokeDynamics" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x0a", 10,
      "biometricPalm" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x0b", 10,
      "biometricRetina" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x0c", 10,
      "biometricSignature" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x0d", 10,
      "biometricSpeechPattern" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x0e", 10,
      "biometricThermalImage" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x0f", 10,
      "biometricVeinPattern" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x10", 10,
      "biometricThermalFaceImage" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x11", 10,
      "biometricThermalHandImage" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x12", 10,
      "biometricLipMovement" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x01\x13", 10,
      "biometricGait" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x03", 9,
      "x984MatchingMethod" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04", 9,
      "x984FormatOwner" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x00", 10,
      "x984CbeffOwner" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01", 10,
      "x984IbiaOwner" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x01", 11,
      "ibiaOwnerSAFLINK" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x02", 11,
      "ibiaOwnerBioscrypt" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x03", 11,
      "ibiaOwnerVisionics" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x04", 11,
      "ibiaOwnerInfineonTechnologiesAG" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x05", 11,
      "ibiaOwnerIridianTechnologies" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x06", 11,
      "ibiaOwnerVeridicom" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x07", 11,
      "ibiaOwnerCyberSIGN" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x08", 11,
      "ibiaOwnereCryp" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x09", 11,
      "ibiaOwnerFingerprintCardsAB" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x0a", 11,
      "ibiaOwnerSecuGen" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x0b", 11,
      "ibiaOwnerPreciseBiometric" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x0c", 11,
      "ibiaOwnerIdentix" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x0d", 11,
      "ibiaOwnerDERMALOG" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x0e", 11,
      "ibiaOwnerLOGICO" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x0f", 11,
      "ibiaOwnerNIST" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x10", 11,
      "ibiaOwnerA3Vision" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x11", 11,
      "ibiaOwnerNEC" },
    { (byte*)"\x2b\x81\x05\x10\x86\x48\x09\x54\x04\x01\x12", 11,
      "ibiaOwnerSTMicroelectronics" },
    { (byte*)"\x2b\x81\x1e\x91\x99\x84\x05\x00\x00\x00\x01\x02\x02", 13,
      "qcpSK" },
    { (byte*)"\x55\x04\x00", 3,
      "objectClass" },
    { (byte*)"\x55\x04\x01", 3,
      "aliasedEntryName" },
    { (byte*)"\x55\x04\x02", 3,
      "knowledgeInformation" },
    { (byte*)"\x55\x04\x03", 3,
      "commonName" },
    { (byte*)"\x55\x04\x04", 3,
      "surname" },
    { (byte*)"\x55\x04\x05", 3,
      "serialNumber" },
    { (byte*)"\x55\x04\x06", 3,
      "countryName" },
    { (byte*)"\x55\x04\x07", 3,
      "localityName" },
    { (byte*)"\x55\x04\x07\x01", 4,
      "collectiveLocalityName" },
    { (byte*)"\x55\x04\x08", 3,
      "stateOrProvinceName" },
    { (byte*)"\x55\x04\x08\x01", 4,
      "collectiveStateOrProvinceName" },
    { (byte*)"\x55\x04\x09", 3,
      "streetAddress" },
    { (byte*)"\x55\x04\x09\x01", 4,
      "collectiveStreetAddress" },
    { (byte*)"\x55\x04\x0a", 3,
      "organizationName" },
    { (byte*)"\x55\x04\x0a\x01", 4,
      "collectiveOrganizationName" },
    { (byte*)"\x55\x04\x0b", 3,
      "organizationalUnitName" },
    { (byte*)"\x55\x04\x0b\x01", 4,
      "collectiveOrganizationalUnitName" },
    { (byte*)"\x55\x04\x0c", 3,
      "title" },
    { (byte*)"\x55\x04\x0d", 3,
      "description" },
    { (byte*)"\x55\x04\x0e", 3,
      "searchGuide" },
    { (byte*)"\x55\x04\x0f", 3,
      "businessCategory" },
    { (byte*)"\x55\x04\x10", 3,
      "postalAddress" },
    { (byte*)"\x55\x04\x10\x01", 4,
      "collectivePostalAddress" },
    { (byte*)"\x55\x04\x11", 3,
      "postalCode" },
    { (byte*)"\x55\x04\x11\x01", 4,
      "collectivePostalCode" },
    { (byte*)"\x55\x04\x12", 3,
      "postOfficeBox" },
    { (byte*)"\x55\x04\x12\x01", 4,
      "collectivePostOfficeBox" },
    { (byte*)"\x55\x04\x13", 3,
      "physicalDeliveryOfficeName" },
    { (byte*)"\x55\x04\x13\x01", 4,
      "collectivePhysicalDeliveryOfficeName" },
    { (byte*)"\x55\x04\x14", 3,
      "telephoneNumber" },
    { (byte*)"\x55\x04\x14\x01", 4,
      "collectiveTelephoneNumber" },
    { (byte*)"\x55\x04\x15", 3,
      "telexNumber" },
    { (byte*)"\x55\x04\x15\x01", 4,
      "collectiveTelexNumber" },
    { (byte*)"\x55\x04\x16", 3,
      "teletexTerminalIdentifier" },
    { (byte*)"\x55\x04\x16\x01", 4,
      "collectiveTeletexTerminalIdentifier" },
    { (byte*)"\x55\x04\x17", 3,
      "facsimileTelephoneNumber" },
    { (byte*)"\x55\x04\x17\x01", 4,
      "collectiveFacsimileTelephoneNumber" },
    { (byte*)"\x55\x04\x18", 3,
      "x121Address" },
    { (byte*)"\x55\x04\x19", 3,
      "internationalISDNNumber" },
    { (byte*)"\x55\x04\x19\x01", 4,
      "collectiveInternationalISDNNumber" },
    { (byte*)"\x55\x04\x1a", 3,
      "registeredAddress" },
    { (byte*)"\x55\x04\x1b", 3,
      "destinationIndicator" },
    { (byte*)"\x55\x04\x1c", 3,
      "preferredDeliveryMehtod" },
    { (byte*)"\x55\x04\x1d", 3,
      "presentationAddress" },
    { (byte*)"\x55\x04\x1e", 3,
      "supportedApplicationContext" },
    { (byte*)"\x55\x04\x1f", 3,
      "member" },
    { (byte*)"\x55\x04\x20", 3,
      "owner" },
    { (byte*)"\x55\x04\x21", 3,
      "roleOccupant" },
    { (byte*)"\x55\x04\x22", 3,
      "seeAlso" },
    { (byte*)"\x55\x04\x23", 3,
      "userPassword" },
    { (byte*)"\x55\x04\x24", 3,
      "userCertificate" },
    { (byte*)"\x55\x04\x25", 3,
      "caCertificate" },
    { (byte*)"\x55\x04\x26", 3,
      "authorityRevocationList" },
    { (byte*)"\x55\x04\x27", 3,
      "certificateRevocationList" },
    { (byte*)"\x55\x04\x28", 3,
      "crossCertificatePair" },
    { (byte*)"\x55\x04\x29", 3,
      "name" },
    { (byte*)"\x55\x04\x2a", 3,
      "givenName" },
    { (byte*)"\x55\x04\x2b", 3,
      "initials" },
    { (byte*)"\x55\x04\x2c", 3,
      "generationQualifier" },
    { (byte*)"\x55\x04\x2d", 3,
      "uniqueIdentifier" },
    { (byte*)"\x55\x04\x2e", 3,
      "dnQualifier" },
    { (byte*)"\x55\x04\x2f", 3,
      "enhancedSearchGuide" },
    { (byte*)"\x55\x04\x30", 3,
      "protocolInformation" },
    { (byte*)"\x55\x04\x31", 3,
      "distinguishedName" },
    { (byte*)"\x55\x04\x32", 3,
      "uniqueMember" },
    { (byte*)"\x55\x04\x33", 3,
      "houseIdentifier" },
    { (byte*)"\x55\x04\x34", 3,
      "supportedAlgorithms" },
    { (byte*)"\x55\x04\x35", 3,
      "deltaRevocationList" },
    { (byte*)"\x55\x04\x36", 3,
      "dmdName" },
    { (byte*)"\x55\x04\x37", 3,
      "clearance" },
    { (byte*)"\x55\x04\x38", 3,
      "defaultDirQop" },
    { (byte*)"\x55\x04\x39", 3,
      "attributeIntegrityInfo" },
    { (byte*)"\x55\x04\x3a", 3,
      "attributeCertificate" },
    { (byte*)"\x55\x04\x3b", 3,
      "attributeCertificateRevocationList" },
    { (byte*)"\x55\x04\x3c", 3,
      "confKeyInfo" },
    { (byte*)"\x55\x04\x3d", 3,
      "aACertificate" },
    { (byte*)"\x55\x04\x3e", 3,
      "attributeDescriptorCertificate" },
    { (byte*)"\x55\x04\x3f", 3,
      "attributeAuthorityRevocationList" },
    { (byte*)"\x55\x04\x40", 3,
      "familyInformation" },
    { (byte*)"\x55\x04\x41", 3,
      "pseudonym" },
    { (byte*)"\x55\x04\x42", 3,
      "communicationsService" },
    { (byte*)"\x55\x04\x43", 3,
      "communicationsNetwork" },
    { (byte*)"\x55\x04\x44", 3,
      "certificationPracticeStmt" },
    { (byte*)"\x55\x04\x45", 3,
      "certificatePolicy" },
    { (byte*)"\x55\x04\x46", 3,
      "pkiPath" },
    { (byte*)"\x55\x04\x47", 3,
      "privPolicy" },
    { (byte*)"\x55\x04\x48", 3,
      "role" },
    { (byte*)"\x55\x04\x49", 3,
      "delegationPath" },
    { (byte*)"\x55\x04\x4a", 3,
      "protPrivPolicy" },
    { (byte*)"\x55\x04\x4b", 3,
      "xMLPrivilegeInfo" },
    { (byte*)"\x55\x04\x4c", 3,
      "xmlPrivPolicy" },
    { (byte*)"\x55\x04\x4d", 3,
      "uuidpair" },
    { (byte*)"\x55\x04\x4e", 3,
      "tagOid" },
    { (byte*)"\x55\x04\x4f", 3,
      "uiiFormat" },
    { (byte*)"\x55\x04\x50", 3,
      "uiiInUrh" },
    { (byte*)"\x55\x04\x51", 3,
      "contentUrl" },
    { (byte*)"\x55\x04\x52", 3,
      "permission" },
    { (byte*)"\x55\x04\x53", 3,
      "uri" },
    { (byte*)"\x55\x04\x54", 3,
      "pwdAttribute" },
    { (byte*)"\x55\x04\x55", 3,
      "userPwd" },
    { (byte*)"\x55\x04\x56", 3,
      "urn" },
    { (byte*)"\x55\x04\x57", 3,
      "url" },
    { (byte*)"\x55\x04\x58", 3,
      "utmCoordinates" },
    { (byte*)"\x55\x04\x59", 3,
      "urnC" },
    { (byte*)"\x55\x04\x5a", 3,
      "uii" },
    { (byte*)"\x55\x04\x5b", 3,
      "epc" },
    { (byte*)"\x55\x04\x5c", 3,
      "tagAfi" },
    { (byte*)"\x55\x04\x5d", 3,
      "epcFormat" },
    { (byte*)"\x55\x04\x5e", 3,
      "epcInUrn" },
    { (byte*)"\x55\x04\x5f", 3,
      "ldapUrl" },
    { (byte*)"\x55\x04\x60", 3,
      "tagLocation" },
    { (byte*)"\x55\x04\x61", 3,
      "organizationIdentifier" },
    { (byte*)"\x55\x04\x62", 3,
      "countryCode3c" },
    { (byte*)"\x55\x04\x63", 3,
      "countryCode3n" },
    { (byte*)"\x55\x04\x64", 3,
      "dnsName" },
    { (byte*)"\x55\x04\x65", 3,
      "eepkCertificateRevocationList" },
    { (byte*)"\x55\x04\x66", 3,
      "eeAttrCertificateRevocationList" },
    { (byte*)"\x55\x04\x67", 3,
      "supportedPublicKeyAlgorithms" },
    { (byte*)"\x55\x04\x68", 3,
      "intEmail" },
    { (byte*)"\x55\x04\x69", 3,
      "jid" },
    { (byte*)"\x55\x04\x6a", 3,
      "objectIdentifier" },
    { (byte*)"\x55\x06\x00", 3,
      "top" },
    { (byte*)"\x55\x06\x01", 3,
      "alias" },
    { (byte*)"\x55\x06\x02", 3,
      "country" },
    { (byte*)"\x55\x06\x03", 3,
      "locality" },
    { (byte*)"\x55\x06\x04", 3,
      "organization" },
    { (byte*)"\x55\x06\x05", 3,
      "organizationalUnit" },
    { (byte*)"\x55\x06\x06", 3,
      "person" },
    { (byte*)"\x55\x06\x07", 3,
      "organizationalPerson" },
    { (byte*)"\x55\x06\x08", 3,
      "organizationalRole" },
    { (byte*)"\x55\x06\x09", 3,
      "groupOfNames" },
    { (byte*)"\x55\x06\x0a", 3,
      "residentialPerson" },
    { (byte*)"\x55\x06\x0b", 3,
      "applicationProcess" },
    { (byte*)"\x55\x06\x0c", 3,
      "applicationEntity" },
    { (byte*)"\x55\x06\x0d", 3,
      "dSA" },
    { (byte*)"\x55\x06\x0e", 3,
      "device" },
    { (byte*)"\x55\x06\x0f", 3,
      "strongAuthenticationUser" },
    { (byte*)"\x55\x06\x10", 3,
      "certificateAuthority" },
    { (byte*)"\x55\x06\x11", 3,
      "groupOfUniqueNames" },
    { (byte*)"\x55\x06\x15", 3,
      "pkiUser" },
    { (byte*)"\x55\x06\x16", 3,
      "pkiCA" },
    { (byte*)"\x55\x08\x01\x01", 4,
      "rsa" },
    { (byte*)"\x55\x1d\x01", 3,
      "authorityKeyIdentifier" },
    { (byte*)"\x55\x1d\x02", 3,
      "keyAttributes" },
    { (byte*)"\x55\x1d\x03", 3,
      "certificatePolicies" },
    { (byte*)"\x55\x1d\x04", 3,
      "keyUsageRestriction" },
    { (byte*)"\x55\x1d\x05", 3,
      "policyMapping" },
    { (byte*)"\x55\x1d\x06", 3,
      "subtreesConstraint" },
    { (byte*)"\x55\x1d\x07", 3,
      "subjectAltName" },
    { (byte*)"\x55\x1d\x08", 3,
      "issuerAltName" },
    { (byte*)"\x55\x1d\x09", 3,
      "subjectDirectoryAttributes" },
    { (byte*)"\x55\x1d\x0a", 3,
      "basicConstraints" },
    { (byte*)"\x55\x1d\x0b", 3,
      "nameConstraints" },
    { (byte*)"\x55\x1d\x0c", 3,
      "policyConstraints" },
    { (byte*)"\x55\x1d\x0d", 3,
      "basicConstraints" },
    { (byte*)"\x55\x1d\x0e", 3,
      "subjectKeyIdentifier" },
    { (byte*)"\x55\x1d\x0f", 3,
      "keyUsage" },
    { (byte*)"\x55\x1d\x10", 3,
      "privateKeyUsagePeriod" },
    { (byte*)"\x55\x1d\x11", 3,
      "subjectAltName" },
    { (byte*)"\x55\x1d\x12", 3,
      "issuerAltName" },
    { (byte*)"\x55\x1d\x13", 3,
      "basicConstraints" },
    { (byte*)"\x55\x1d\x14", 3,
      "cRLNumber" },
    { (byte*)"\x55\x1d\x15", 3,
      "cRLReason" },
    { (byte*)"\x55\x1d\x16", 3,
      "expirationDate" },
    { (byte*)"\x55\x1d\x17", 3,
      "instructionCode" },
    { (byte*)"\x55\x1d\x18", 3,
      "invalidityDate" },
    { (byte*)"\x55\x1d\x19", 3,
      "cRLDistributionPoints" },
    { (byte*)"\x55\x1d\x1a", 3,
      "issuingDistributionPoint" },
    { (byte*)"\x55\x1d\x1b", 3,
      "deltaCRLIndicator" },
    { (byte*)"\x55\x1d\x1c", 3,
      "issuingDistributionPoint" },
    { (byte*)"\x55\x1d\x1d", 3,
      "certificateIssuer" },
    { (byte*)"\x55\x1d\x1e", 3,
      "nameConstraints" },
    { (byte*)"\x55\x1d\x1f", 3,
      "cRLDistributionPoints" },
    { (byte*)"\x55\x1d\x20", 3,
      "certificatePolicies" },
    { (byte*)"\x55\x1d\x20\x00", 4,
      "anyPolicy" },
    { (byte*)"\x55\x1d\x21", 3,
      "policyMappings" },
    { (byte*)"\x55\x1d\x22", 3,
      "policyConstraints" },
    { (byte*)"\x55\x1d\x23", 3,
      "authorityKeyIdentifier" },
    { (byte*)"\x55\x1d\x24", 3,
      "policyConstraints" },
    { (byte*)"\x55\x1d\x25", 3,
      "extKeyUsage" },
    { (byte*)"\x55\x1d\x25\x00", 4,
      "anyExtendedKeyUsage" },
    { (byte*)"\x55\x1d\x26", 3,
      "authorityAttributeIdentifier" },
    { (byte*)"\x55\x1d\x27", 3,
      "roleSpecCertIdentifier" },
    { (byte*)"\x55\x1d\x28", 3,
      "cRLStreamIdentifier" },
    { (byte*)"\x55\x1d\x29", 3,
      "basicAttConstraints" },
    { (byte*)"\x55\x1d\x2a", 3,
      "delegatedNameConstraints" },
    { (byte*)"\x55\x1d\x2b", 3,
      "timeSpecification" },
    { (byte*)"\x55\x1d\x2c", 3,
      "cRLScope" },
    { (byte*)"\x55\x1d\x2d", 3,
      "statusReferrals" },
    { (byte*)"\x55\x1d\x2e", 3,
      "freshestCRL" },
    { (byte*)"\x55\x1d\x2f", 3,
      "orderedList" },
    { (byte*)"\x55\x1d\x30", 3,
      "attributeDescriptor" },
    { (byte*)"\x55\x1d\x31", 3,
      "userNotice" },
    { (byte*)"\x55\x1d\x32", 3,
      "sOAIdentifier" },
    { (byte*)"\x55\x1d\x33", 3,
      "baseUpdateTime" },
    { (byte*)"\x55\x1d\x34", 3,
      "acceptableCertPolicies" },
    { (byte*)"\x55\x1d\x35", 3,
      "deltaInfo" },
    { (byte*)"\x55\x1d\x36", 3,
      "inhibitAnyPolicy" },
    { (byte*)"\x55\x1d\x37", 3,
      "targetInformation" },
    { (byte*)"\x55\x1d\x38", 3,
      "noRevAvail" },
    { (byte*)"\x55\x1d\x39", 3,
      "acceptablePrivilegePolicies" },
    { (byte*)"\x55\x1d\x3a", 3,
      "toBeRevoked" },
    { (byte*)"\x55\x1d\x3b", 3,
      "revokedGroups" },
    { (byte*)"\x55\x1d\x3c", 3,
      "expiredCertsOnCRL" },
    { (byte*)"\x55\x1d\x3d", 3,
      "indirectIssuer" },
    { (byte*)"\x55\x1d\x3e", 3,
      "noAssertion" },
    { (byte*)"\x55\x1d\x3f", 3,
      "aAissuingDistributionPoint" },
    { (byte*)"\x55\x1d\x40", 3,
      "issuedOnBehalfOf" },
    { (byte*)"\x55\x1d\x41", 3,
      "singleUse" },
    { (byte*)"\x55\x1d\x42", 3,
      "groupAC" },
    { (byte*)"\x55\x1d\x43", 3,
      "allowedAttAss" },
    { (byte*)"\x55\x1d\x44", 3,
      "attributeMappings" },
    { (byte*)"\x55\x1d\x45", 3,
      "holderNameConstraints" },
    { (byte*)"\x60\x84\x42\x01\x1a\x01\x03\x01", 8,
      "privateKeySmartCard" },
    { (byte*)"\x60\x84\x42\x01\x1a\x01\x03\x02", 8,
      "privateKeySoftToken" },
    { (byte*)"\x60\x84\x42\x01\x1a\x01\x03\x03", 8,
      "sslEvident.  Also assigned as BuyPass EV policy" },
    { (byte*)"\x60\x84\x42\x01\x1a\x01\x03\x04", 8,
      "sslBusinessPlus" },
    { (byte*)"\x60\x84\x42\x01\x1a\x01\x03\x05", 8,
      "privateKeyHardToken" },
    { (byte*)"\x60\x84\x42\x01\x1a\x01\x03\x06", 8,
      "privateKeyHSM" },
    { (byte*)"\x60\x85\x54\x01\x02\x02\x04\x01", 8,
      "personalDataInfo" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x01", 9,
      "sdnsSignatureAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x02", 9,
      "fortezzaSignatureAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x03", 9,
      "sdnsConfidentialityAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x04", 9,
      "fortezzaConfidentialityAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x05", 9,
      "sdnsIntegrityAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x06", 9,
      "fortezzaIntegrityAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x07", 9,
      "sdnsTokenProtectionAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x08", 9,
      "fortezzaTokenProtectionAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x09", 9,
      "sdnsKeyManagementAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x0a", 9,
      "fortezzaKeyManagementAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x0b", 9,
      "sdnsKMandSigAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x0c", 9,
      "fortezzaKMandSigAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x0d", 9,
      "suiteASignatureAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x0e", 9,
      "suiteAConfidentialityAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x0f", 9,
      "suiteAIntegrityAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x10", 9,
      "suiteATokenProtectionAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x11", 9,
      "suiteAKeyManagementAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x12", 9,
      "suiteAKMandSigAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x13", 9,
      "fortezzaUpdatedSigAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x14", 9,
      "fortezzaKMandUpdSigAlgorithms" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x15", 9,
      "fortezzaUpdatedIntegAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x16", 9,
      "keyExchangeAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x17", 9,
      "fortezzaWrap80Algorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x01\x18", 9,
      "kEAKeyEncryptionAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x01", 9,
      "rfc822MessageFormat" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x02", 9,
      "emptyContent" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x03", 9,
      "cspContentType" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x2a", 9,
      "mspRev3ContentType" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x30", 9,
      "mspContentType" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x31", 9,
      "mspRekeyAgentProtocol" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x32", 9,
      "mspMMP" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x42", 9,
      "mspRev3-1ContentType" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x48", 9,
      "forwardedMSPMessageBodyPart" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x49", 9,
      "mspForwardedMessageParameters" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x4a", 9,
      "forwardedCSPMsgBodyPart" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x4b", 9,
      "cspForwardedMessageParameters" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x4c", 9,
      "mspMMP2" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x4e\x02", 10,
      "encryptedKeyPackage" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x4e\x03", 10,
      "keyPackageReceipt" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x02\x4e\x06", 10,
      "keyPackageError" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x01", 9,
      "sdnsSecurityPolicy" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x02", 9,
      "sdnsPRBAC" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x03", 9,
      "mosaicPRBAC" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0a", 9,
      "siSecurityPolicy" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0a\x00", 10,
      "siNASP" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0a\x01", 10,
      "siELCO" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0a\x02", 10,
      "siTK" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0a\x03", 10,
      "siDSAP" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0a\x04", 10,
      "siSSSS" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0a\x05", 10,
      "siDNASP" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0a\x06", 10,
      "siBYEMAN" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0a\x07", 10,
      "siREL-US" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0a\x08", 10,
      "siREL-AUS" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0a\x09", 10,
      "siREL-CAN" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0a\x0a", 10,
      "siREL_UK" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0a\x0b", 10,
      "siREL-NZ" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0a\x0c", 10,
      "siGeneric" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0b", 9,
      "genser" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0b\x00", 10,
      "genserNations" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0b\x01", 10,
      "genserComsec" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0b\x02", 10,
      "genserAcquisition" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0b\x03", 10,
      "genserSecurityCategories" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0b\x03\x00", 11,
      "genserTagSetName" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0c", 9,
      "defaultSecurityPolicy" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0d", 9,
      "capcoMarkings" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0d\x00", 10,
      "capcoSecurityCategories" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0d\x00\x01", 11,
      "capcoTagSetName1" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0d\x00\x02", 11,
      "capcoTagSetName2" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0d\x00\x03", 11,
      "capcoTagSetName3" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x03\x0d\x00\x04", 11,
      "capcoTagSetName4" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x01", 9,
      "sdnsKeyManagementCertificate" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x02", 9,
      "sdnsUserSignatureCertificate" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x03", 9,
      "sdnsKMandSigCertificate" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x04", 9,
      "fortezzaKeyManagementCertificate" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x05", 9,
      "fortezzaKMandSigCertificate" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x06", 9,
      "fortezzaUserSignatureCertificate" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x07", 9,
      "fortezzaCASignatureCertificate" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x08", 9,
      "sdnsCASignatureCertificate" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x0a", 9,
      "auxiliaryVector" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x0b", 9,
      "mlReceiptPolicy" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x0c", 9,
      "mlMembership" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x0d", 9,
      "mlAdministrators" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x0e", 9,
      "alid" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x14", 9,
      "janUKMs" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x15", 9,
      "febUKMs" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x16", 9,
      "marUKMs" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x17", 9,
      "aprUKMs" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x18", 9,
      "mayUKMs" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x19", 9,
      "junUKMs" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x1a", 9,
      "julUKMs" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x1b", 9,
      "augUKMs" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x1c", 9,
      "sepUKMs" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x1d", 9,
      "octUKMs" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x1e", 9,
      "novUKMs" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x1f", 9,
      "decUKMs" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x28", 9,
      "metaSDNSckl" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x29", 9,
      "sdnsCKL" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x2a", 9,
      "metaSDNSsignatureCKL" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x2b", 9,
      "sdnsSignatureCKL" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x2c", 9,
      "sdnsCertificateRevocationList" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x2d", 9,
      "fortezzaCertificateRevocationList" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x2e", 9,
      "fortezzaCKL" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x2f", 9,
      "alExemptedAddressProcessor" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x30", 9,
      "guard" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x31", 9,
      "algorithmsSupported" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x32", 9,
      "suiteAKeyManagementCertificate" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x33", 9,
      "suiteAKMandSigCertificate" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x34", 9,
      "suiteAUserSignatureCertificate" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x35", 9,
      "prbacInfo" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x36", 9,
      "prbacCAConstraints" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x37", 9,
      "sigOrKMPrivileges" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x38", 9,
      "commPrivileges" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x39", 9,
      "labeledAttribute" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x3a", 9,
      "policyInformationFile" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x3b", 9,
      "secPolicyInformationFile" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x3c", 9,
      "cAClearanceConstraint" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x41", 9,
      "keyPkgIdAndReceiptReq" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x42", 9,
      "contentDecryptKeyID" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x46", 9,
      "kpCrlPointers" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x47", 9,
      "kpKeyProvinceV2" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x05\x48", 9,
      "kpManifest" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x07\x01", 9,
      "cspExtns" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x07\x01\x00", 10,
      "cspCsExtn" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x08\x01", 9,
      "mISSISecurityCategories" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x08\x02", 9,
      "standardSecurityLabelPrivileges" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x08\x03\x01", 10,
      "enumeratedPermissiveAttrs" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x08\x03\x03", 10,
      "informativeAttrs" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x08\x03\x04", 10,
      "enumeratedRestrictiveAttrs" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0a\x01", 9,
      "sigPrivileges" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0a\x02", 9,
      "kmPrivileges" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0a\x03", 9,
      "namedTagSetPrivilege" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0b\x01", 9,
      "ukDemo" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0b\x02", 9,
      "usDODClass2" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0b\x03", 9,
      "usMediumPilot" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0b\x04", 9,
      "usDODClass4" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0b\x05", 9,
      "usDODClass3" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0b\x06", 9,
      "usDODClass5" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00", 9,
      "testSecurityPolicy" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00\x01", 10,
      "tsp1" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00\x01\x00", 11,
      "tsp1SecurityCategories" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00\x01\x00\x00", 12,
      "tsp1TagSetZero" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00\x01\x00\x01", 12,
      "tsp1TagSetOne" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00\x01\x00\x02", 12,
      "tsp1TagSetTwo" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00\x02", 10,
      "tsp2" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00\x02\x00", 11,
      "tsp2SecurityCategories" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00\x02\x00\x00", 12,
      "tsp2TagSetZero" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00\x02\x00\x01", 12,
      "tsp2TagSetOne" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00\x02\x00\x02", 12,
      "tsp2TagSetTwo" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00\x03", 10,
      "kafka" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00\x03\x00", 11,
      "kafkaSecurityCategories" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00\x03\x00\x01", 12,
      "kafkaTagSetName1" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00\x03\x00\x02", 12,
      "kafkaTagSetName2" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x00\x03\x00\x03", 12,
      "kafkaTagSetName3" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0c\x01\x01", 10,
      "tcp1" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0d\x01", 9,
      "kmaKeyAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0d\x03", 9,
      "kmaTSECNomenclature" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0d\x05", 9,
      "kmaKeyDistPeriod" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0d\x06", 9,
      "kmaKeyValidityPeriod" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0d\x07", 9,
      "kmaKeyDuration" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0d\x0b", 9,
      "kmaSplitID" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0d\x0c", 9,
      "kmaKeyPkgType" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0d\x0d", 9,
      "kmaKeyPurpose" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0d\x0e", 9,
      "kmaKeyUse" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0d\x0f", 9,
      "kmaTransportKey" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0d\x10", 9,
      "kmaKeyPkgReceiversV2" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0d\x13", 9,
      "kmaOtherCertFormats" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0d\x14", 9,
      "kmaUsefulCerts" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0d\x15", 9,
      "kmaKeyWrapAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x0d\x16", 9,
      "kmaSigUsageV3" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x10\x00", 9,
      "dn" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x16", 8,
      "errorCodes" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x16\x01", 9,
      "missingKeyType" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x16\x02", 9,
      "privacyMarkTooLong" },
    { (byte*)"\x60\x86\x48\x01\x65\x02\x01\x16\x03", 9,
      "unrecognizedSecurityPolicy" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x01", 7,
      "slabel" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02", 7,
      "pki" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x01", 8,
      "NIST policyIdentifier" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x01\x03\x01", 10,
      "fbcaRudimentaryPolicy" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x01\x03\x02", 10,
      "fbcaBasicPolicy" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x01\x03\x03", 10,
      "fbcaMediumPolicy" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x01\x03\x04", 10,
      "fbcaHighPolicy" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x01\x30\x01", 10,
      "nistTestPolicy1" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x01\x30\x02", 10,
      "nistTestPolicy2" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x01\x30\x03", 10,
      "nistTestPolicy3" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x01\x30\x04", 10,
      "nistTestPolicy4" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x01\x30\x05", 10,
      "nistTestPolicy5" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x01\x30\x06", 10,
      "nistTestPolicy6" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x02", 8,
      "gak" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x02\x01", 9,
      "kRAKey" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x03", 8,
      "extensions" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x03\x01", 9,
      "kRTechnique" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x03\x02", 9,
      "kRecoveryCapable" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x03\x03", 9,
      "kR" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x04", 8,
      "keyRecoverySchemes" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x02\x05", 8,
      "krapola" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x03", 7,
      "arpa" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04", 7,
      "nistAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01", 8,
      "aes" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x01", 9,
      "aes128-ECB" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x02", 9,
      "aes128-CBC" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x03", 9,
      "aes128-OFB" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x04", 9,
      "aes128-CFB" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x05", 9,
      "aes128-wrap" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x06", 9,
      "aes128-GCM" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x07", 9,
      "aes128-CCM" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x08", 9,
      "aes128-wrap-pad" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x09", 9,
      "aes128-GMAC" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x15", 9,
      "aes192-ECB" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x16", 9,
      "aes192-CBC" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x17", 9,
      "aes192-OFB" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x18", 9,
      "aes192-CFB" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x19", 9,
      "aes192-wrap" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x1a", 9,
      "aes192-GCM" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x1b", 9,
      "aes192-CCM" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x1c", 9,
      "aes192-wrap-pad" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x1d", 9,
      "aes192-GMAC" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x29", 9,
      "aes256-ECB" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x2a", 9,
      "aes256-CBC" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x2b", 9,
      "aes256-OFB" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x2c", 9,
      "aes256-CFB" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x2d", 9,
      "aes256-wrap" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x2e", 9,
      "aes256-GCM" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x2f", 9,
      "aes256-CCM" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x30", 9,
      "aes256-wrap-pad" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x01\x31", 9,
      "aes256-GMAC" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x02", 8,
      "hashAlgos" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x02\x01", 9,
      "sha-256" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x02\x02", 9,
      "sha-384" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x02\x03", 9,
      "sha-512" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x02\x04", 9,
      "sha-224" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x02\x07", 9,
      "sha3-224" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x02\x08", 9,
      "sha3-256" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x02\x09", 9,
      "sha3-384" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x02\x0a", 9,
      "sha3-512" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x02\x0b", 9,
      "shake128" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x02\x0c", 9,
      "shake256" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x02\x11", 9,
      "shake128len" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x02\x12", 9,
      "shake256len" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x02\x13", 9,
      "kmacShake128" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x02\x14", 9,
      "kmacShake256" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x03\x01", 9,
      "dsaWithSha224" },
    { (byte*)"\x60\x86\x48\x01\x65\x03\x04\x03\x02", 9,
      "dsaWithSha256" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08", 10,
      "novellAlgorithm" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x16", 11,
      "desCbcIV8" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x17", 11,
      "desCbcPadIV8" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x18", 11,
      "desEDE2CbcIV8" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x19", 11,
      "desEDE2CbcPadIV8" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x1a", 11,
      "desEDE3CbcIV8" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x1b", 11,
      "desEDE3CbcPadIV8" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x1c", 11,
      "rc5CbcPad" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x1d", 11,
      "md2WithRSAEncryptionBSafe1" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x1e", 11,
      "md5WithRSAEncryptionBSafe1" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x1f", 11,
      "sha1WithRSAEncryptionBSafe1" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x20", 11,
      "lmDigest" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x28", 11,
      "md2" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x32", 11,
      "md5" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x33", 11,
      "ikeHmacWithSHA1-RSA" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x34", 11,
      "ikeHmacWithMD5-RSA" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x45", 11,
      "rc2CbcPad" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x52", 11,
      "sha-1" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x5c", 11,
      "rc2BSafe1Cbc" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x5f", 11,
      "md4" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x81\x02", 12,
      "md4Packet" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x81\x03", 12,
      "rsaEncryptionBsafe1" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x81\x04", 12,
      "nwPassword" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x02\x08\x81\x05", 12,
      "novellObfuscate-1" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x09", 9,
      "pki" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x09\x04", 10,
      "pkiAttributeType" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x09\x04\x01", 11,
      "securityAttributes" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x37\x01\x09\x04\x02", 11,
      "relianceLimit" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x01", 8,
      "cert-extension" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x01\x01", 9,
      "netscape-cert-type" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x01\x02", 9,
      "netscape-base-url" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x01\x03", 9,
      "netscape-revocation-url" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x01\x04", 9,
      "netscape-ca-revocation-url" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x01\x07", 9,
      "netscape-cert-renewal-url" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x01\x08", 9,
      "netscape-ca-policy-url" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x01\x09", 9,
      "HomePage-url" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x01\x0a", 9,
      "EntityLogo" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x01\x0b", 9,
      "UserPicture" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x01\x0c", 9,
      "netscape-ssl-server-name" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x01\x0d", 9,
      "netscape-comment" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x02", 8,
      "data-type" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x02\x01", 9,
      "dataGIF" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x02\x02", 9,
      "dataJPEG" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x02\x03", 9,
      "dataURL" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x02\x04", 9,
      "dataHTML" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x02\x05", 9,
      "certSequence" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x02\x06", 9,
      "certURL" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x03", 8,
      "directory" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x03\x01", 9,
      "ldapDefinitions" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x03\x01\x01", 10,
      "carLicense" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x03\x01\x02", 10,
      "departmentNumber" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x03\x01\x03", 10,
      "employeeNumber" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x03\x01\x04", 10,
      "employeeType" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x03\x01\x81\x58", 11,
      "userPKCS12" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x03\x02\x02", 10,
      "inetOrgPerson" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x42\x04\x01", 9,
      "serverGatedCrypto" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x06\x03", 10,
      "verisignCZAG" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x06\x06", 10,
      "verisignInBox" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x06\x0b", 10,
      "verisignOnsiteJurisdictionHash" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x06\x0d", 10,
      "Unknown Verisign VPN extension" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x06\x0f", 10,
      "verisignServerID" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x07\x01\x01", 11,
      "verisignCertPolicies95Qualifier1" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x07\x01\x01\x01", 12,
      "verisignCPSv1notice" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x07\x01\x01\x02", 12,
      "verisignCPSv1nsi" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x08\x01", 10,
      "verisignISSStrongCrypto" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01", 8,
      "pki" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x09", 9,
      "pkcs7Attribute" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x09\x02", 10,
      "messageType" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x09\x03", 10,
      "pkiStatus" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x09\x04", 10,
      "failInfo" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x09\x05", 10,
      "senderNonce" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x09\x06", 10,
      "recipientNonce" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x09\x07", 10,
      "transID" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x09\x08", 10,
      "extensionReq" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x4d\x02", 8,
      "intelCDSA" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x01", 8,
      "digiCertNonEVCerts" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x01\x01", 9,
      "digiCertOVCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x01\x02", 9,
      "digiCertDVCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x01\x0b", 9,
      "digiCertFederatedDeviceCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x01\x03\x00\x01", 11,
      "digiCertGlobalCAPolicy" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x01\x03\x00\x02", 11,
      "digiCertHighAssuranceEVCAPolicy" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x01\x03\x00\x03", 11,
      "digiCertGlobalRootCAPolicy" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x01\x03\x00\x04", 11,
      "digiCertAssuredIDRootCAPolicy" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x02", 9,
      "digiCertEVCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x03", 9,
      "digiCertObjectSigningCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x03\x01", 10,
      "digiCertCodeSigningCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x03\x02", 10,
      "digiCertEVCodeSigningCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x03\x0b", 10,
      "digiCertKernelCodeSigningCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x03\x15", 10,
      "digiCertDocumentSigningCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x04", 9,
      "digiCertClientCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x04\x01\x01", 11,
      "digiCertLevel1PersonalClientCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x04\x01\x02", 11,
      "digiCertLevel1EnterpriseClientCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x04\x02", 10,
      "digiCertLevel2ClientCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x04\x03\x01", 11,
      "digiCertLevel3USClientCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x04\x03\x02", 11,
      "digiCertLevel3CBPClientCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x04\x04\x01", 11,
      "digiCertLevel4USClientCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x04\x04\x02", 11,
      "digiCertLevel4CBPClientCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x04\x05\x01", 11,
      "digiCertPIVHardwareCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x04\x05\x02", 11,
      "digiCertPIVCardAuthCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x04\x05\x03", 11,
      "digiCertPIVContentSigningCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x04\x1f", 9,
      "digiCertGridClassicCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x04\x1f\x05", 10,
      "digiCertGridIntegratedCert" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x1f\x04\x1f\x01", 11,
      "digiCertGridHostCert" },
    { (byte*)"\x67\x2a\x00", 3,
      "contentType" },
    { (byte*)"\x67\x2a\x00\x00", 4,
      "panData" },
    { (byte*)"\x67\x2a\x00\x01", 4,
      "panToken" },
    { (byte*)"\x67\x2a\x00\x02", 4,
      "panOnly" },
    { (byte*)"\x67\x2a\x01", 3,
      "msgExt" },
    { (byte*)"\x67\x2a\x02", 3,
      "field" },
    { (byte*)"\x67\x2a\x02\x00", 4,
      "fullName" },
    { (byte*)"\x67\x2a\x02\x01", 4,
      "givenName" },
    { (byte*)"\x67\x2a\x02\x02", 4,
      "familyName" },
    { (byte*)"\x67\x2a\x02\x03", 4,
      "birthFamilyName" },
    { (byte*)"\x67\x2a\x02\x04", 4,
      "placeName" },
    { (byte*)"\x67\x2a\x02\x05", 4,
      "identificationNumber" },
    { (byte*)"\x67\x2a\x02\x06", 4,
      "month" },
    { (byte*)"\x67\x2a\x02\x07", 4,
      "date" },
    { (byte*)"\x67\x2a\x02\x08", 4,
      "address" },
    { (byte*)"\x67\x2a\x02\x09", 4,
      "telephone" },
    { (byte*)"\x67\x2a\x02\x0a", 4,
      "amount" },
    { (byte*)"\x67\x2a\x02\x0b", 4,
      "accountNumber" },
    { (byte*)"\x67\x2a\x02\x0c", 4,
      "passPhrase" },
    { (byte*)"\x67\x2a\x03", 3,
      "attribute" },
    { (byte*)"\x67\x2a\x03\x00", 4,
      "cert" },
    { (byte*)"\x67\x2a\x03\x00\x00", 5,
      "rootKeyThumb" },
    { (byte*)"\x67\x2a\x03\x00\x01", 5,
      "additionalPolicy" },
    { (byte*)"\x67\x2a\x04", 3,
      "algorithm" },
    { (byte*)"\x67\x2a\x05", 3,
      "policy" },
    { (byte*)"\x67\x2a\x05\x00", 4,
      "root" },
    { (byte*)"\x67\x2a\x06", 3,
      "module" },
    { (byte*)"\x67\x2a\x07", 3,
      "certExt" },
    { (byte*)"\x67\x2a\x07\x00", 4,
      "hashedRootKey" },
    { (byte*)"\x67\x2a\x07\x01", 4,
      "certificateType" },
    { (byte*)"\x67\x2a\x07\x02", 4,
      "merchantData" },
    { (byte*)"\x67\x2a\x07\x03", 4,
      "cardCertRequired" },
    { (byte*)"\x67\x2a\x07\x04", 4,
      "tunneling" },
    { (byte*)"\x67\x2a\x07\x05", 4,
      "setExtensions" },
    { (byte*)"\x67\x2a\x07\x06", 4,
      "setQualifier" },
    { (byte*)"\x67\x2a\x08", 3,
      "brand" },
    { (byte*)"\x67\x2a\x08\x01", 4,
      "IATA-ATA" },
    { (byte*)"\x67\x2a\x08\x04", 4,
      "VISA" },
    { (byte*)"\x67\x2a\x08\x05", 4,
      "MasterCard" },
    { (byte*)"\x67\x2a\x08\x1e", 4,
      "Diners" },
    { (byte*)"\x67\x2a\x08\x22", 4,
      "AmericanExpress" },
    { (byte*)"\x67\x2a\x08\xae\x7b", 5,
      "Novus" },
    { (byte*)"\x67\x2a\x09", 3,
      "vendor" },
    { (byte*)"\x67\x2a\x09\x00", 4,
      "GlobeSet" },
    { (byte*)"\x67\x2a\x09\x01", 4,
      "IBM" },
    { (byte*)"\x67\x2a\x09\x02", 4,
      "CyberCash" },
    { (byte*)"\x67\x2a\x09\x03", 4,
      "Terisa" },
    { (byte*)"\x67\x2a\x09\x04", 4,
      "RSADSI" },
    { (byte*)"\x67\x2a\x09\x05", 4,
      "VeriFone" },
    { (byte*)"\x67\x2a\x09\x06", 4,
      "TrinTech" },
    { (byte*)"\x67\x2a\x09\x07", 4,
      "BankGate" },
    { (byte*)"\x67\x2a\x09\x08", 4,
      "GTE" },
    { (byte*)"\x67\x2a\x09\x09", 4,
      "CompuSource" },
    { (byte*)"\x67\x2a\x09\x0a", 4,
      "Griffin" },
    { (byte*)"\x67\x2a\x09\x0b", 4,
      "Certicom" },
    { (byte*)"\x67\x2a\x09\x0c", 4,
      "OSS" },
    { (byte*)"\x67\x2a\x09\x0d", 4,
      "TenthMountain" },
    { (byte*)"\x67\x2a\x09\x0e", 4,
      "Antares" },
    { (byte*)"\x67\x2a\x09\x0f", 4,
      "ECC" },
    { (byte*)"\x67\x2a\x09\x10", 4,
      "Maithean" },
    { (byte*)"\x67\x2a\x09\x11", 4,
      "Netscape" },
    { (byte*)"\x67\x2a\x09\x12", 4,
      "Verisign" },
    { (byte*)"\x67\x2a\x09\x13", 4,
      "BlueMoney" },
    { (byte*)"\x67\x2a\x09\x14", 4,
      "Lacerte" },
    { (byte*)"\x67\x2a\x09\x15", 4,
      "Fujitsu" },
    { (byte*)"\x67\x2a\x09\x16", 4,
      "eLab" },
    { (byte*)"\x67\x2a\x09\x17", 4,
      "Entrust" },
    { (byte*)"\x67\x2a\x09\x18", 4,
      "VIAnet" },
    { (byte*)"\x67\x2a\x09\x19", 4,
      "III" },
    { (byte*)"\x67\x2a\x09\x1a", 4,
      "OpenMarket" },
    { (byte*)"\x67\x2a\x09\x1b", 4,
      "Lexem" },
    { (byte*)"\x67\x2a\x09\x1c", 4,
      "Intertrader" },
    { (byte*)"\x67\x2a\x09\x1d", 4,
      "Persimmon" },
    { (byte*)"\x67\x2a\x09\x1e", 4,
      "NABLE" },
    { (byte*)"\x67\x2a\x09\x1f", 4,
      "espace-net" },
    { (byte*)"\x67\x2a\x09\x20", 4,
      "Hitachi" },
    { (byte*)"\x67\x2a\x09\x21", 4,
      "Microsoft" },
    { (byte*)"\x67\x2a\x09\x22", 4,
      "NEC" },
    { (byte*)"\x67\x2a\x09\x23", 4,
      "Mitsubishi" },
    { (byte*)"\x67\x2a\x09\x24", 4,
      "NCR" },
    { (byte*)"\x67\x2a\x09\x25", 4,
      "e-COMM" },
    { (byte*)"\x67\x2a\x09\x26", 4,
      "Gemplus" },
    { (byte*)"\x67\x2a\x0a", 3,
      "national" },
    { (byte*)"\x67\x2a\x0a\x83\x08", 5,
      "Japan" },
    { (byte*)"\x67\x2b\x01\x04", 4,
      "wTLS-ECC" },
    { (byte*)"\x67\x2b\x01\x04\x01", 5,
      "wTLS-ECC-curve1" },
    { (byte*)"\x67\x2b\x01\x04\x06", 5,
      "wTLS-ECC-curve6" },
    { (byte*)"\x67\x2b\x01\x04\x08", 5,
      "wTLS-ECC-curve8" },
    { (byte*)"\x67\x2b\x01\x04\x09", 5,
      "wTLS-ECC-curve9" },
    { (byte*)"\x67\x81\x05", 3,
      "tCPA" },
    { (byte*)"\x67\x81\x05\x01", 4,
      "tcgSpecVersion" },
    { (byte*)"\x67\x81\x05\x02", 4,
      "tcgAttribute" },
    { (byte*)"\x67\x81\x05\x02\x01", 5,
      "tcgTpmManufacturer" },
    { (byte*)"\x67\x81\x05\x02\x02", 5,
      "tcgTpmModel" },
    { (byte*)"\x67\x81\x05\x02\x03", 5,
      "tcgTpmVersion" },
    { (byte*)"\x67\x81\x05\x02\x04", 5,
      "tcgPlatformManufacturer" },
    { (byte*)"\x67\x81\x05\x02\x05", 5,
      "tcgPlatformModel" },
    { (byte*)"\x67\x81\x05\x02\x06", 5,
      "tcgPlatformVersion" },
    { (byte*)"\x67\x81\x05\x02\x07", 5,
      "tcgComponentManufacturer" },
    { (byte*)"\x67\x81\x05\x02\x08", 5,
      "tcgComponentModel" },
    { (byte*)"\x67\x81\x05\x02\x09", 5,
      "tcgComponentVersion" },
    { (byte*)"\x67\x81\x05\x02\x0a", 5,
      "tcgSecurityQualities" },
    { (byte*)"\x67\x81\x05\x02\x0b", 5,
      "tcgTpmProtectionProfile" },
    { (byte*)"\x67\x81\x05\x02\x0c", 5,
      "tcgTpmSecurityTarget" },
    { (byte*)"\x67\x81\x05\x02\x0d", 5,
      "tcgFoundationProtectionProfile" },
    { (byte*)"\x67\x81\x05\x02\x0e", 5,
      "tcgFoundationSecurityTarget" },
    { (byte*)"\x67\x81\x05\x02\x0f", 5,
      "tcgTpmIdLabel" },
    { (byte*)"\x67\x81\x05\x02\x10", 5,
      "tcgTpmSpecification" },
    { (byte*)"\x67\x81\x05\x02\x12", 5,
      "tcgTpmSecurityAssertions" },
    { (byte*)"\x67\x81\x05\x03", 4,
      "tcgProtocol" },
    { (byte*)"\x67\x81\x05\x03\x01", 5,
      "tcgPrttTpmIdProtocol" },
    { (byte*)"\x67\x81\x05\x08\x01", 5,
      "tcgEKCertificate" },
    { (byte*)"\x67\x81\x05\x0a\x01\x01\x01", 7,
      "tcgObject" },
    { (byte*)"\x67\x81\x06\x01\x04\x02\x01", 7,
      "postSignumRootQCA" },
    { (byte*)"\x67\x81\x06\x01\x02\x02\x03", 7,
      "postSignumPublicCA" },
    { (byte*)"\x67\x81\x06\x01\x02\x01\x08\x81\x52", 9,
      "postSignumCommercialServerPolicy" },
    { (byte*)"\x67\x81\x08\x01\x01\x01", 6,
      "mRTDSignatureData" },
    { (byte*)"\x67\x81\x0c\x01\x01", 5,
      "evGuidelines" },
    { (byte*)"\x67\x81\x0c\x01\x02\x01", 6,
      "domainValidated" },
    { (byte*)"\x67\x81\x0c\x01\x02\x02", 6,
      "subjectIdentityValidated" },
    { (byte*)"\x67\x81\x0c\x01\x04\x01", 6,
      "codeSigningRequirements" },
    { (byte*)"\x81\x06\x8d\x6f\x02", 5,
      "hashedRootKey" },
    { (byte*)"\x81\x06\x8d\x6f\x03", 5,
      "certificateType" },
    { (byte*)"\x81\x06\x8d\x6f\x04", 5,
      "merchantData" },
    { (byte*)"\x81\x06\x8d\x6f\x05", 5,
      "cardCertRequired" },
    { (byte*)"\x81\x06\x8d\x6f\x06", 5,
      "tunneling" },
    { (byte*)"\x81\x06\x8d\x6f\x07", 5,
      "setQualifier" },
    { (byte*)"\x81\x06\x8d\x6f\x63", 5,
      "setData" },
    { (byte*)"\x2a\x28\x00\x11\x01\x16", 6,
      "A-Trust EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x8f\x09\x02\x01", 10,
      "AffirmTrust EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x8f\x09\x02\x02", 10,
      "AffirmTrust EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x8f\x09\x02\x03", 10,
      "AffirmTrust EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\x8f\x09\x02\x04", 10,
      "AffirmTrust EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\x87\x2e\x0a\x0e\x02\x01\x02", 13,
      "Camerfirma EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\x87\x2e\x0a\x08\x0c\x01\x02", 13,
      "Camerfirma EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xad\x5a\x02\x05\x02\x03\x01", 13,
      "CertPlus EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xb2\x31\x01\x02\x01\x05\x01", 12,
      "Comodo EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xb1\x3e\x01\x64\x01", 10,
      "Cybertrust EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa5\x34\x02\x81\x4a\x01", 11,
      "D-TRUST EV policy" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6c\x02\x01", 9,
      "DigiCert EV policy" },
    { (byte*)"\x60\x84\x10\x01\x87\x69\x01\x01\x01\x0c\x06\x01\x01\x01", 14,
      "DigiNotar EV policy" },
    { (byte*)"\x60\x86\x48\x01\x86\xfa\x6c\x0a\x01\x02", 10,
      "Entrust EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xf0\x22\x01\x06", 9,
      "GeoTrust EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xa0\x32\x01\x01", 9,
      "GlobalSign EV policy" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6d\x01\x07\x17\x03", 11,
      "GoDaddy EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xf3\x39\x06\x01\x01", 10,
      "Izenpe EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xf3\x39\x06\x01\x02", 10,
      "Izenpe EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\x86\x0e\x01\x02\x01\x08\x01", 12,
      "Network Solutions EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xbe\x58\x00\x02\x64\x01\x02", 12,
      "QuoVadis EV policy" },
    { (byte*)"\x2a\x83\x08\x8c\x9b\x1b\x64\x85\x51\x01", 10,
      "Security Communication (SECOM) EV policy" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x6e\x01\x07\x17\x03", 11,
      "Starfield EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\x81\xb5\x37\x01\x01\x01", 11,
      "StartCom EV policy" },
    { (byte*)"\x60\x85\x74\x01\x59\x01\x02\x01\x01", 9,
      "SwissSign EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\xbd\x47\x0d\x18\x01", 10,
      "T-TeleSec EV policy" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x07\x30\x01", 11,
      "Thawte EV policy" },
    { (byte*)"\x60\x86\x48\x01\x86\xfd\x64\x01\x01\x02\x04\x01", 12,
      "TrustWave EV policy" },
    { (byte*)"\x2b\x06\x01\x04\x01\x82\xbf\x25\x01\x01\x16\x03", 12,
      "TWCA EV policy" },
    { (byte*)"\x60\x86\x48\x01\x86\xf8\x45\x01\x07\x17\x06", 11,
      "VeriSign EV policy" },
    { (byte*)"\x60\x86\x48\x01\x86\xfb\x7b\x83\x74\x09", 10,
      "Wells Fargo EV policy" },
};

int asn1App_oid_names_len = 2767;

