/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.adaptator.impl;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.IXMLParser;
import com.izforge.izpack.adaptator.impl.LineNumberFilter;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLParser
implements IXMLParser {
    private LineNumberFilter filter;

    public XMLParser() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setXIncludeAware(true);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            this.filter = new LineNumberFilter(xMLReader);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    private IXMLElement searchFirstElement(DOMResult dOMResult) {
        for (Node node = dOMResult.getNode().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return new XMLElementImpl(node);
        }
        return null;
    }

    private DOMResult parseLineNrFromInputSource(InputSource inputSource) {
        DOMResult dOMResult = null;
        try {
            dOMResult = new DOMResult();
            SAXSource sAXSource = new SAXSource(inputSource);
            sAXSource.setXMLReader(this.filter);
            StreamSource streamSource = new StreamSource(IXMLParser.class.getResource("styleSheet.xsl").openStream());
            Transformer transformer = TransformerFactory.newInstance().newTransformer(streamSource);
            transformer.transform(sAXSource, dOMResult);
            this.filter.applyLN(dOMResult);
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return dOMResult;
    }

    public IXMLElement parse(InputStream inputStream) {
        InputSource inputSource = new InputSource(inputStream);
        DOMResult dOMResult = this.parseLineNrFromInputSource(inputSource);
        return this.searchFirstElement(dOMResult);
    }

    public IXMLElement parse(InputStream inputStream, String string) {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        DOMResult dOMResult = this.parseLineNrFromInputSource(inputSource);
        return this.searchFirstElement(dOMResult);
    }

    public IXMLElement parse(String string) {
        return this.parse(new ByteArrayInputStream(string.getBytes()));
    }

    public IXMLElement parse(URL uRL) {
        InputSource inputSource = new InputSource(uRL.toExternalForm());
        DOMResult dOMResult = this.parseLineNrFromInputSource(inputSource);
        return this.searchFirstElement(dOMResult);
    }
}

