import os

def parse_x2y_args(args, xextns, yextns):
    """
    Helper function for working out input and output filenames for YODA
    converter scripts, where the output name is generated by replacing the input
    file extension (xextn) with the output one (yextn), if there are exactly two
    arguments and the second arg is consistent with an output name. The x/yextn
    arguments should include the leading dot.
    """
    def endswithoneof(s, ends):
        #return any(s.endswith(e) for e in ends)
        for e in ends:
            if s.endswith(e):
                return e
        return False
    infiles = []
    outfiles = []
    if type(xextns) is str:
        xextns = [xextns]
    if type(yextns) is str:
        yextns = [yextns]
    ## If there are two args and the second has the right output extension, treat as in-, out-names
    if len(args) == 2 and (endswithoneof(args[1], yextns) or args[1] == "-"):
        infiles = [args[0]]
        outfiles = [args[1]]
    ## Otherwise treat as a list of in-names and generate default out-names
    else:
        for infile in args:
            xextn = endswithoneof(infile, xextns)
            if xextn:
                outfile = infile.replace(xextn, yextns[0])
            else:
                outfile = infile + yextns[0]
            outfile = os.path.basename(outfile)
            infiles.append(infile)
            outfiles.append(outfile)
    return zip(infiles, outfiles)


def filter_aos(aos, match_re=None, unmatch_re=None):
    "Remove unwanted analysis objects from a dict (modifies arg, also returned)"
    import re
    if match_re:
        re_match = re.compile(match_re)
        keylist = list(aos.keys())
        for k in keylist:
            if not re_match.search(k):
                del aos[k]
    if unmatch_re:
        re_unmatch = re.compile(unmatch_re)
        keylist = list(aos.keys())
        for k in keylist:
            if re_unmatch.search(k):
                del aos[k]
    return aos
