// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/UnstableParticles.hh"
#include "Rivet/Projections/DecayedParticles.hh"

namespace Rivet {


  /// @brief Add a short analysis description here
  class BESIII_2025_I2866232 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BESIII_2025_I2866232);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      UnstableParticles ufs = UnstableParticles(Cuts::abspid==PID::JPSI);
      declare(ufs, "UFS");
      DecayedParticles psi(ufs);
      psi.addStable(PID::PI0);
      declare(psi, "PSI");
      book(_h[0],1,1,2);
      book(_h[1],1,1,4);
      book(_c[0],"TMP/den1");
      book(_c[1],"TMP/den2");
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      // define the decay mode
      static const map<PdgId,unsigned int> & mode0   = { {PID::PI0,1},{ PID::PHOTON,1} };
      static const map<PdgId,unsigned int> & mode1   = { {PID::PI0     ,1},{ 11,1}, { -11,1}};
      DecayedParticles psi = apply<DecayedParticles>(event, "PSI");
      // loop over particles
      for(unsigned int ix=0;ix<psi.decaying().size();++ix) {
        _c[0]->fill();
	if(psi.modeMatches(ix,2,mode0)) {
	  _c[1]->fill();
	  continue;
	}
	else if(psi.modeMatches(ix,3,mode1)) {
          // e+ e-
          const Particle & em = psi.decayProducts()[ix].at( 11)[0];
          const Particle & ep = psi.decayProducts()[ix].at(-11)[0];
          double q = (ep.momentum()+em.momentum()).mass();
	  _h[0]->fill(q);
	  double me = em.mass();
	  double beta = sqrt(1.-4.*sqr(me/q));
	  double mJpsi = psi.decaying()[ix].mass();
	  double mPi0  = psi.decayProducts()[ix].at(111)[0].mass();
	  double p = sqrt(sqr(1.+sqr(q)/(sqr(mJpsi)-sqr(mPi0)))-4.*sqr(mJpsi*q/(sqr(mJpsi)-sqr(mPi0))));
	  double fact = beta*GeV/q*(1.+2.*sqr(me/q))*pow(p,3);
	  _h[1]->fill(q,1./fact);
	}
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_h[0],1e8/ *_c[0]);
      static double alpha= 7.2973525664e-3;
      scale(_h[1], 1.5 *M_PI/alpha/ *_c[1]);
    }

    /// @}


    /// @name Histograms
    /// @{
    Histo1DPtr _h[2];
    CounterPtr _c[3];
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BESIII_2025_I2866232);

}
