---
title: pixi add
---
<!--- This file is autogenerated. Do not edit manually! -->
# [pixi](../pixi.md) add

Adds dependencies to the workspace

--8<-- "docs/reference/cli/pixi/add_extender:description"

## Usage
```
pixi add [OPTIONS] <SPEC>...
```

## Arguments
- <a id="arg-<SPEC>" href="#arg-<SPEC>">`<SPEC>`</a>
:  The dependency as names, conda MatchSpecs or PyPi requirements
<br>May be provided more than once.
<br>**required**: `true`

## Options
- <a id="arg---pypi" href="#arg---pypi">`--pypi`</a>
:  The specified dependencies are pypi dependencies. Conflicts with `host` and `build`
- <a id="arg---platform" href="#arg---platform">`--platform (-p) <PLATFORM>`</a>
:  The platform for which the dependency should be modified
<br>May be provided more than once.
- <a id="arg---feature" href="#arg---feature">`--feature (-f) <FEATURE>`</a>
:  The feature for which the dependency should be modified
<br>**default**: `default`
- <a id="arg---editable" href="#arg---editable">`--editable`</a>
:  Whether the pypi requirement should be editable

## Config Options
- <a id="arg---auth-file" href="#arg---auth-file">`--auth-file <AUTH_FILE>`</a>
:  Path to the file containing the authentication token
- <a id="arg---concurrent-downloads" href="#arg---concurrent-downloads">`--concurrent-downloads <CONCURRENT_DOWNLOADS>`</a>
:  Max concurrent network requests, default is `50`
- <a id="arg---concurrent-solves" href="#arg---concurrent-solves">`--concurrent-solves <CONCURRENT_SOLVES>`</a>
:  Max concurrent solves, default is the number of CPUs
- <a id="arg---pinning-strategy" href="#arg---pinning-strategy">`--pinning-strategy <PINNING_STRATEGY>`</a>
:  Set pinning strategy
<br>**options**: `semver`, `minor`, `major`, `latest-up`, `exact-version`, `no-pin`
- <a id="arg---pypi-keyring-provider" href="#arg---pypi-keyring-provider">`--pypi-keyring-provider <PYPI_KEYRING_PROVIDER>`</a>
:  Specifies whether to use the keyring to look up credentials for PyPI
<br>**options**: `disabled`, `subprocess`
- <a id="arg---run-post-link-scripts" href="#arg---run-post-link-scripts">`--run-post-link-scripts`</a>
:  Run post-link scripts (insecure)
- <a id="arg---tls-no-verify" href="#arg---tls-no-verify">`--tls-no-verify`</a>
:  Do not verify the TLS certificate of the server
- <a id="arg---tls-root-certs" href="#arg---tls-root-certs">`--tls-root-certs <TLS_ROOT_CERTS>`</a>
:  Which TLS root certificates to use: 'webpki' (bundled Mozilla roots), 'native' (system store), or 'all' (both)
<br>**env**: `PIXI_TLS_ROOT_CERTS`
- <a id="arg---use-environment-activation-cache" href="#arg---use-environment-activation-cache">`--use-environment-activation-cache`</a>
:  Use environment activation cache (experimental)

## Git Options
- <a id="arg---git" href="#arg---git">`--git (-g) <GIT>`</a>
:  The git url to use when adding a git dependency
- <a id="arg---branch" href="#arg---branch">`--branch <BRANCH>`</a>
:  The git branch
- <a id="arg---tag" href="#arg---tag">`--tag <TAG>`</a>
:  The git tag
- <a id="arg---rev" href="#arg---rev">`--rev <REV>`</a>
:  The git revision
- <a id="arg---subdir" href="#arg---subdir">`--subdir (-s) <SUBDIR>`</a>
:  The subdirectory of the git repository to use

## Update Options
- <a id="arg---no-install" href="#arg---no-install">`--no-install`</a>
:  Don't modify the environment, only modify the lock-file
- <a id="arg---frozen" href="#arg---frozen">`--frozen`</a>
:  Install the environment as defined in the lockfile, doesn't update lockfile if it isn't up-to-date with the manifest file
<br>**env**: `PIXI_FROZEN`
- <a id="arg---locked" href="#arg---locked">`--locked`</a>
:  Check if lockfile is up-to-date before installing the environment, aborts when lockfile isn't up-to-date with the manifest file
<br>**env**: `PIXI_LOCKED`

## Global Options
- <a id="arg---manifest-path" href="#arg---manifest-path">`--manifest-path (-m) <MANIFEST_PATH>`</a>
:  The path to `pixi.toml`, `pyproject.toml`, or the workspace directory

## Description
Adds dependencies to the workspace

The dependencies should be defined as MatchSpec for conda package, or a PyPI
requirement for the `--pypi` dependencies. If no specific version is
provided, the latest version compatible with your workspace will be chosen
automatically or a * will be used.

Example usage:

- `pixi add python=3.9`: This will select the latest minor version that
  complies with 3.9.*, i.e., python version 3.9.0, 3.9.1, 3.9.2, etc.
- `pixi add python`: In absence of a specified version, the latest version
  will be chosen. For instance, this could resolve to python version
  3.11.3.* at the time of writing.

Adding multiple dependencies at once is also supported:

- `pixi add python pytest`: This will add both `python` and `pytest` to the
  workspace's dependencies.

The `--platform` and `--build/--host` flags make the dependency target
specific.

- `pixi add python --platform linux-64 --platform osx-arm64`: Will add the
  latest version of python for linux-64 and osx-arm64 platforms.
- `pixi add python --build`: Will add the latest version of python for as a
  build dependency.

Mixing `--platform` and `--build`/`--host` flags is supported

The `--pypi` option will add the package as a pypi dependency. This cannot
be mixed with the conda dependencies

- `pixi add --pypi boto3`
- `pixi add --pypi "boto3==version"`

If the workspace manifest is a `pyproject.toml`, adding a pypi dependency will
add it to the native pyproject `project.dependencies` array or to the native
`dependency-groups` table if a feature is specified:

- `pixi add --pypi boto3` will add `boto3` to the `project.dependencies`
  array
- `pixi add --pypi boto3 --feature aws` will add `boto3` to the
  `dependency-groups.aws` array
- `pixi add --pypi --editable 'boto3 @ file://absolute/path/to/boto3'` will add
  the local editable `boto3` to the `pypi-dependencies` array

Note that if `--platform` or `--editable` are specified, the pypi dependency
will be added to the `tool.pixi.pypi-dependencies` table instead as native
arrays have no support for platform-specific or editable dependencies.

These dependencies will then be read by pixi as if they had been added to
the pixi `pypi-dependencies` tables of the default or of a named feature.

The versions will be automatically added with a pinning strategy based on
semver or the pinning strategy set in the config. There is a list of
packages that are not following the semver versioning scheme but will use
the minor version by default:
Python, Rust, Julia, GCC, GXX, GFortran, NodeJS, Deno, R, R-Base, Perl


--8<-- "docs/reference/cli/pixi/add_extender:example"
